# ImageVault

The `imagevault` crate supplies a convenient way to consume
the ImageVault API using a `Client` with the choice of
multiple `Authentication` methods.

This crate consumes the ImageVault REST API using the `reqwest`
crate. All requests are asynchronous. No attempts will be made
to document the ImageVault API, this information is available
in the original <a target="_blank" href="https://imagevault.se/doc">ImageVault documentation</a>.

The aim of this crate is to support as much of the `apiv2` version
as possible. At this time a limited set is covered:

## Supported authentication methods
* Client Credentials
* Pin code

## Supported services
* assets/info
* assets/search
* categoryservice/getcategories
* info/version
* mediacontentservice/storecontentinvault
* mediaservice/deletemediaitem
* mediaservice/deletemediaitems
* mediaservice/save
* uploadservice/upload
* vaultservice/delete

## Remarks
This is still a pre-release, major API changes and rewrites can occur
until a stable version 1.0.

Although the creator of this crate is an ImageVault employee,
**this is not an official ImageVault product**. The ImageVault product
and company names are trademarks of their respective holders.

## Example usage
```
let authentication = ClientCredentialsAuthentication::default();

let client = Client::new(
    "identity",
    "secret",
    "https://myimagevault.se",
    )?
    .with_authentication(authentication);

let info = assets::info(&client).await?;

let query = assets::SearchBuilder::new("cat")
    .filter("isOrganized")
    .top(20)
    .build();

let search_result = assets::search(&client, &query).await?;
```

## License

Licensed under either of

 * Apache License, Version 2.0
   ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license
   ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

## Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.