//! # ImageVault
//!
//! The `imagevault` crate supplies a convenient way to consume
//! the ImageVault API using a `Client` with the choice of
//! multiple `Authentication` methods.
//!
//! This crate consumes the ImageVault REST API using the `reqwest`
//! crate. All requests are asynchronous. No attempts will be made
//! to document the ImageVault API, this information is available
//! in the original <a target="_blank" href="https://imagevault.se/doc">ImageVault documentation</a>.
//!
//! The aim of this crate is to support as much of the `apiv2` version
//! as possible. At this time a limited set is covered:
//!
//! ## Supported authentication methods
//! * Client Credentials
//! * Pin code
//!
//! ## Supported services/endpoints
//! * assets/info
//! * assets/search
//! * categoryservice/getcategories
//! * info/version
//! * mediacontentservice/storecontentinvault
//! * mediaservice/save
//! * uploadservice/upload
//! * vaultservice/delete
//!
//! ## Remarks
//! This is still a pre-release, major API changes and rewrites can occur
//! until a stable version 1.0.
//!
//! Although the creator of this crate is an ImageVault employee,
//! **this is not an official ImageVault product**. The ImageVault product
//! and company names are trademarks of their respective holders.
//!

pub use client::Client;
pub mod authentication;
mod client;
mod data;
pub mod error;
pub mod service;
#[cfg(test)]
mod testutil;
