//! # Error
//! Contains various specific errors for the `imagevault` crate

use thiserror::Error;
#[derive(Error, Debug)]
/// ImageVault errors
pub enum Error {
    /// Required authentication is missing
    #[error("required authentication is missing")]
    AuthenticationMissing,
    /// Pin authentication request expired
    #[error("pin code request has expired")]
    PinCodeExpired,
    /// Invalid Pin authentication request
    #[error("pin code is invalid")]
    PinCodeInvalid,
    /// Wrap Reqwest errors
    #[error(transparent)]
    ReqwestError(#[from] reqwest::Error),
    /// Wrap URL parse errors
    #[error(transparent)]
    UrlParseError(#[from] url::ParseError),
    /// Wrap IO errors
    #[error(transparent)]
    IOError(#[from] std::io::Error)
}