//! # Error
//! Contains various specific errors for the `imagevault` crate

use std::{error::Error as StdError, fmt};
#[derive(Debug)]
/// ImageVault errors
pub enum Error {
    /// Required authentication is missing
    AuthenticationMissing,
    /// Pin authentication request expired
    PinCodeExpired,
    /// Invalid Pin authentication request
    PinCodeInvalid,
}

impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        match self {
            Error::AuthenticationMissing => write!(f, "Required authentication is missing"),
            Error::PinCodeExpired => write!(f, "Pin code request has expired"),
            Error::PinCodeInvalid => write!(f, "Pin code is invalid"),
        }
    }
}

impl StdError for Error {}
