#[cfg(test)]
use imagesize::blob_size;

#[test]
fn blob_test() {
    //  PNG Header with size 123x321
    let data = vec![0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 
                    0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 
                    0x00, 0x00, 0x00, 0x7B, 0x00, 0x00, 0x01, 0x41,
                    0x08, 0x06, 0x00, 0x00, 0x00, 0x9A, 0x38, 0xC4];

    let dim = blob_size(&data).unwrap();
    assert_eq!(dim.width, 123);
    assert_eq!(dim.height, 321);
}

#[test]
fn blob_too_small_test() {
    let data = vec![0x89, 0x00, 0x01, 0x02];
    assert_eq!(blob_size(&data).is_err(), true);
}

#[test]
fn blob_test_fail() {
    //  Invalid PNG header (0x51 instead of 0x50)
    let data = vec![0x89, 0x51, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 
                    0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 
                    0x00, 0x00, 0x00, 0x7B, 0x00, 0x00, 0x01, 0x41,
                    0x08, 0x06, 0x00, 0x00, 0x00, 0x9A, 0x38, 0xC4];

    assert_eq!(blob_size(&data).is_err(), true);
}

#[test]
fn gif_blob_too_small_test() {
    let data = vec![0x47, 0x49, 0x46, 0x38];
    assert_eq!(blob_size(&data).is_err(), true);
}
