fn read(p: &str) -> lodepng::Bitmap<lodepng::RGBA> { return lodepng::decode32_file(p).unwrap(); }
fn write(p: &str, width: usize, height: usize, buffer: &[lodepng::RGBA]) { lodepng::encode32_file(p, buffer, width, height).unwrap(); }

#[test]
fn rotate() {
  let milk = read("tests/images/milk.png");
  let mut fb = imagescript::framebuffer::new(milk.width, milk.height);
  unsafe { fb.ptr_mut::<u8>().copy_from_nonoverlapping(milk.buffer.as_ptr() as _, fb.len()); }

  {
    let mut c = fb.clone();
    imagescript::ops::rotate::rotate90(&mut c);
    write("tests/images/milk_rotate90.png", c.width, c.height, c.slice());
  }

  {
    let mut c = fb.clone();
    imagescript::ops::rotate::rotate180(&mut c);
    write("tests/images/milk_rotate180.png", c.width, c.height, c.slice());
  }

  {
    let mut c = fb.clone();
    imagescript::ops::rotate::rotate270(&mut c);
    write("tests/images/milk_rotate270.png", c.width, c.height, c.slice());
  }
}