use approx::assert_abs_diff_eq;
use image_moments::{Moments, Spatial};

fn main() {
    let points = [
        (53, 19),
        (52, 20),
        (49, 20),
        (48, 21),
        (47, 21),
        (46, 22),
        (45, 22),
        (44, 23),
        (43, 23),
        (42, 24),
        (41, 24),
        (39, 26),
        (38, 26),
        (34, 30),
        (76, 30),
        (77, 31),
        (79, 31),
        (80, 32),
        (81, 32),
        (83, 34),
        (84, 34),
        (86, 36),
        (86, 37),
        (87, 38),
        (87, 39),
        (88, 40),
        (88, 47),
        (86, 49),
        (86, 50),
        (83, 53),
        (82, 53),
        (81, 54),
        (81, 55),
        (82, 55),
        (84, 57),
        (84, 58),
        (85, 59),
        (85, 60),
        (86, 61),
        (86, 63),
        (87, 64),
        (87, 65),
        (88, 66),
        (93, 66),
        (94, 65),
        (94, 64),
        (95, 63),
        (95, 60),
        (96, 59),
        (99, 59),
        (99, 53),
        (98, 52),
        (97, 52),
        (96, 51),
        (95, 51),
        (94, 50),
        (93, 50),
        (90, 47),
        (90, 46),
        (91, 45),
        (91, 44),
        (92, 43),
        (92, 42),
        (93, 41),
        (93, 39),
        (94, 38),
        (94, 36),
        (91, 33),
        (91, 32),
        (85, 26),
        (84, 26),
        (82, 24),
        (81, 24),
        (80, 23),
        (79, 23),
        (78, 22),
        (77, 22),
        (76, 21),
        (75, 21),
        (74, 20),
        (71, 20),
        (70, 19),
        (69, 19),
        (67, 21),
        (66, 21),
        (62, 25),
        (60, 25),
        (54, 19),
    ];

    // Calculate the moments up to third order
    let moments: Spatial<f64, 3> = points.iter().collect();

    // Compare with those values generated by OpenCV
    assert_abs_diff_eq!(moments.get::<0, 0>(), 703.0);
    assert_abs_diff_eq!(moments.get::<1, 0>(), 52175.166666666664);
    assert_abs_diff_eq!(moments.get::<0, 1>(), 25661.5);
    assert_abs_diff_eq!(moments.get::<2, 0>(), 4084450.6666666665);
    assert_abs_diff_eq!(moments.get::<1, 1>(), 2024477.75);
    assert_abs_diff_eq!(moments.get::<0, 2>(), 1071256.0);
    assert_abs_diff_eq!(moments.get::<3, 0>(), 332589780.65000004);
    assert_abs_diff_eq!(moments.get::<2, 1>(), 166738807.83333334);
    assert_abs_diff_eq!(moments.get::<1, 2>(), 89124447.63333333);
    assert_abs_diff_eq!(moments.get::<0, 3>(), 50269189.75);
}
