# image-moments
This crate provides efficient and compile-time checked calculations of contour moments. It strives to be as compatible to the corresponding OpenCV functions as possible while maintaining a "rusty" workflow. The computed order of moments is adjustable: You pay only for those moments that you require. 

## Usage
```rust
use image_moments::{Moments, Spatial};
use approx::assert_abs_diff_eq;

fn main() {
    // Points defining the contour
    let points = [
        (53, 19),
        (52, 20),
        (49, 20),
        // [...]
        (60, 25),
        (54, 19),
    ];

    // Calculate all spatial (aka "raw") contour moments up to the third order
    let moments: Spatial<f64, 3> = points.iter().collect();

    // Compare with those values generated by OpenCV
    assert_abs_diff_eq!(moments.get::<0, 0>(), 703.0);
    assert_abs_diff_eq!(moments.get::<1, 0>(), 52175.166666666664);
    assert_abs_diff_eq!(moments.get::<0, 1>(), 25661.5);
    assert_abs_diff_eq!(moments.get::<2, 0>(), 4084450.6666666665);
    assert_abs_diff_eq!(moments.get::<1, 1>(), 2024477.75);
    assert_abs_diff_eq!(moments.get::<0, 2>(), 1071256.0);
    assert_abs_diff_eq!(moments.get::<3, 0>(), 332589780.65000004);
    assert_abs_diff_eq!(moments.get::<2, 1>(), 166738807.83333334);
    assert_abs_diff_eq!(moments.get::<1, 2>(), 89124447.63333333);
    assert_abs_diff_eq!(moments.get::<0, 3>(), 50269189.75);

    // This will fail at compile time because it is not covered by the third order:
    // assert_abs_diff_eq!(moments.get::<0, 4>(), 50269189.75);
}
```

## License
Licensed under either of

 * Apache License, Version 2.0
   ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license
   ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

## Contribution
Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.