use std::env::current_dir;
use git2::Repository;
use colorful::{Color, Colorful};
use walkdir::WalkDir;

fn main() {

    let directory = current_dir().unwrap();
    let repository = Repository::open(directory.clone()).unwrap();

    println!("{:?}", directory);
    let mut iterator = WalkDir::new(directory.to_str().unwrap()).into_iter();
    
    while let Some(file) = iterator.next() {
        let file = match file {
            Ok(file) => file,
            Err(_) => continue,
        };

        let path = file.path();
        let status = repository.is_path_ignored(&path).unwrap_or(false);
        let file_name = path.to_str().unwrap();

        if !status {
            let string = String::from(file_name).color(Color::Grey53).bold().to_string();
            println!("|{}{}","-".repeat(file.depth() * 2), string);
        } else {
            let string = String::from(file_name).color(Color::Violet).bold().to_string();
            println!("|{}{} ", "-".repeat(file.depth()),string);
        };
    }
}
