use std::collections::HashMap;

lazy_static! {
    pub static ref LANGUAGES_MAP: HashMap<&'static str, &'static str> = {
        let mut m = HashMap::new();

        m.insert("actionscript", "Actionscript");
        m.insert("ada", "Ada");
        m.insert("agda", "Agda");
        m.insert("android", "Android");
        m.insert("appengine", "AppEngine");
        m.insert("appceleratortitanium", "AppceleratorTitanium");
        m.insert("archlinuxpackages", "ArchLinuxPackages");
        m.insert("autotools", "Autotools");
        m.insert("c++", "C++");
        m.insert("c", "C");
        m.insert("cfwheels", "CFWheels");
        m.insert("cmake", "CMake");
        m.insert("cuda", "CUDA");
        m.insert("cakephp", "CakePHP");
        m.insert("chefcookbook", "ChefCookbook");
        m.insert("clojure", "Clojure");
        m.insert("codeigniter", "CodeIgniter");
        m.insert("commonlisp", "CommonLisp");
        m.insert("composer", "Composer");
        m.insert("concrete5", "Concrete5");
        m.insert("coq", "Coq");
        m.insert("craftcms", "CraftCMS");
        m.insert("d", "D");
        m.insert("dm", "DM");
        m.insert("dart", "Dart");
        m.insert("delphi", "Delphi");
        m.insert("drupal", "Drupal");
        m.insert("episerver", "EPiServer");
        m.insert("eagle", "Eagle");
        m.insert("elisp", "Elisp");
        m.insert("elixir", "Elixir");
        m.insert("elm", "Elm");
        m.insert("erlang", "Erlang");
        m.insert("expressionengine", "ExpressionEngine");
        m.insert("extjs", "ExtJs");
        m.insert("fancy", "Fancy");
        m.insert("finale", "Finale");
        m.insert("forcedotcom", "ForceDotCom");
        m.insert("fortran", "Fortran");
        m.insert("fuelphp", "FuelPHP");
        m.insert("gwt", "GWT");
        m.insert("gcov", "Gcov");
        m.insert("gitbook", "GitBook");
        m.insert("go", "Go");
        m.insert("godot", "Godot");
        m.insert("gradle", "Gradle");
        m.insert("grails", "Grails");
        m.insert("haskell", "Haskell");
        m.insert("igorpro", "IGORPro");
        m.insert("idris", "Idris");
        m.insert("jboss", "JBoss");
        m.insert("jenkins_home", "JENKINS_HOME");
        m.insert("java", "Java");
        m.insert("jekyll", "Jekyll");
        m.insert("joomla", "Joomla");
        m.insert("julia", "Julia");
        m.insert("kicad", "KiCad");
        m.insert("kohana", "Kohana");
        m.insert("kotlin", "Kotlin");
        m.insert("labview", "LabVIEW");
        m.insert("laravel", "Laravel");
        m.insert("leiningen", "Leiningen");
        m.insert("lemonstand", "LemonStand");
        m.insert("lilypond", "Lilypond");
        m.insert("lithium", "Lithium");
        m.insert("lua", "Lua");
        m.insert("magento", "Magento");
        m.insert("maven", "Maven");
        m.insert("mercury", "Mercury");
        m.insert("metaprogrammingsystem", "MetaProgrammingSystem");
        m.insert("nanoc", "Nanoc");
        m.insert("nim", "Nim");
        m.insert("node", "Node");
        m.insert("ocaml", "OCaml");
        m.insert("objective-c", "Objective-C");
        m.insert("opa", "Opa");
        m.insert("opencart", "OpenCart");
        m.insert("oracleforms", "OracleForms");
        m.insert("packer", "Packer");
        m.insert("perl", "Perl");
        m.insert("phalcon", "Phalcon");
        m.insert("playframework", "PlayFramework");
        m.insert("plone", "Plone");
        m.insert("prestashop", "Prestashop");
        m.insert("processing", "Processing");
        m.insert("purescript", "PureScript");
        m.insert("python", "Python");
        m.insert("qooxdoo", "Qooxdoo");
        m.insert("qt", "Qt");
        m.insert("r", "R");
        m.insert("ros", "ROS");
        m.insert("rails", "Rails");
        m.insert("raku", "Raku");
        m.insert("rhodesrhomobile", "RhodesRhomobile");
        m.insert("ruby", "Ruby");
        m.insert("rust", "Rust");
        m.insert("scons", "SCons");
        m.insert("sass", "Sass");
        m.insert("scala", "Scala");
        m.insert("scheme", "Scheme");
        m.insert("scrivener", "Scrivener");
        m.insert("sdcc", "Sdcc");
        m.insert("seamgen", "SeamGen");
        m.insert("sketchup", "SketchUp");
        m.insert("smalltalk", "Smalltalk");
        m.insert("stella", "Stella");
        m.insert("sugarcrm", "SugarCRM");
        m.insert("swift", "Swift");
        m.insert("symfony", "Symfony");
        m.insert("symphonycms", "SymphonyCMS");
        m.insert("tex", "TeX");
        m.insert("terraform", "Terraform");
        m.insert("textpattern", "Textpattern");
        m.insert("turbogears2", "TurboGears2");
        m.insert("twincat3", "TwinCAT3");
        m.insert("typo3", "Typo3");
        m.insert("umbraco", "Umbraco");
        m.insert("unity", "Unity");
        m.insert("unrealengine", "UnrealEngine");
        m.insert("vvvv", "VVVV");
        m.insert("visualstudio", "VisualStudio");
        m.insert("waf", "Waf");
        m.insert("wordpress", "WordPress");
        m.insert("xojo", "Xojo");
        m.insert("yeoman", "Yeoman");
        m.insert("yii", "Yii");
        m.insert("zendframework", "ZendFramework");
        m.insert("zephir", "Zephir");

        m
    };
}
