ignor
======

`ignor` is a command line utility to fetch .gitignore tempaltes from [gitignore.io](https://gitignore.io).


## Installation

```
$ cargo install ignor
```


## Usage

**List**

```
$ ignor
```

Print all available .gitignore tempaltes on gitignore.io.


**Search**

```
$ ignor rust intellij
```

Print .gitignore content generated by gitignore.io.

You can make a .gitignore using Unix redirect.

```
$ ignor rust intellij > .gitignore
```


## Use as a library

`ignor` is written by Rust and also is able to used as a Rust library.

(`ignor` uses [reqwest](https://crates.io/crates/reqwest) of http client)


```rust
extern crate ignor;
extern crate reqwest;

#[macro_use]
extern crate error_chain;

error_chain!{
    foreign_links {
        ReqError(reqwest::Error);
        IoError(std::io::Error);
    }
}

quick_main!(run);


fn run() -> Result<()> {
  let res = ignor::list();
  let _ = std::io::copy(&mut res?, &mut std::io::stdout())?;
  Ok(())
}
```

