pub mod threads {
    use std::thread;
    use std::time::Duration;
    use std::sync::mpsc;
    use std::sync::{Mutex, Arc};

    pub fn start() {
        let handle = thread::spawn(|| {
            for i in 1..10 {
                println!("hi number {} from spawned thread!", i);
                thread::sleep(Duration::from_millis(1));
            }
        });

        for i in 1..5 {
            println!("hi number {} from main thread!", i);
            thread::sleep(Duration::from_millis(1));
        }

        handle.join().unwrap();

        bar();

        // bar1();

        // bar2();

        bar3();

        bar4();
    }

    fn bar() {
        let v = vec![1, 2, 3];
        let handle = thread::spawn(move || {
            println!("Here is a vector: {:?}", v);
        });

        //drop(v); // cannot be used, it moves to the closure

        handle.join().unwrap();
    }

    fn bar1() {
        let (tx, rx) = mpsc::channel();

        thread::spawn(move || {
            let msg = String::from("Hi from thread");
            tx.send(msg).unwrap();
        });

        let received = rx.recv().unwrap();
        println!("Got: {}", received);
    }

    fn bar2() {
        let (tx, rx) = mpsc::channel();

        let tx2 = tx.clone();

        thread::spawn(move || {
            let messages = vec![
                String::from("Hi"),
                String::from("from"),
                String::from("the"),
                String::from("thread"),
            ];
            for msg in messages {
                tx.send(msg).unwrap();
                thread::sleep(Duration::from_secs(1));
            }
        });

        thread::spawn(move || {
            let messages = vec![
                String::from("Hi2"),
                String::from("from2"),
                String::from("the2"),
                String::from("thread2"),
            ];
            for msg in messages {
                tx2.send(msg).unwrap();
                thread::sleep(Duration::from_secs(1));
            }
        });

        for received in rx {
            println!("Got: {}", received);
        }
    }

    // using shared state
    fn bar3() {
        let m = Mutex::new(5);

        {
            let mut num = m.lock().unwrap();
            *num = 6;
        }

        println!("m = {:?}", m);
    }

    fn bar4() {
        let counter = Arc::new(Mutex::new(0));
        let mut handles = vec![];
        for _ in 0..10 {
            let counter = Arc::clone(&counter);
            let handle = thread::spawn(move || {
                let mut num = counter.lock().unwrap();

                *num += 1;
            });

            handles.push(handle);
        }

        for handle in handles {
            handle.join().unwrap();
        }

        println!("Got counter {:?}", *counter.lock().unwrap());
    }
}
