use core::fmt;
use std::fmt::{Display, Formatter};

pub struct Student<T: Display> {
    pub name: String,
    pub age: i16,
    pub cargo: T,
}

impl<T: Display> Summary for Student<T> {
    fn summarize(&self) -> String {
        format!("{}, at age {}, with cargo [{}]", self.name, self.age, self.cargo)
    }
}

impl<T: Display> fmt::Display for Student<T> {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        f.write_str(&mut self.summarize())
    }
}

pub trait Summary {
    fn summarize(&self) -> String {
        String::from("(A generic summary...)")
    }
}


pub struct Car {
    pub name: String
}

impl Summary  for Car {}
