pub mod ownership_one {
  #[test]
  pub fn doit() {
    // each value has variable that's called its owner
    // there can be only one owner at a time
    // when the owner gets out of scope, the value will be droped

    // all good here
    let mut x = 32;
    let mut y = x;
    println!("The value of x = {} and the value of y = {}", x, y);

    let s1 = String::from("abc");
    let s2 = &s1; // & doesn't change the ownership
    println!("s1 = {}, s2 = {}", s1, s2);
    testS(&s1);
    testS(&s1);
  }

  pub fn doit_vec() {
    let num_vec1: Vec<i32> = vec![5, 6, 9];
    let num_vec2 = num_vec1.clone(); // to make a full copy
    println!("vec1 {:?} vec2 {:?}", num_vec1, num_vec2);

    {
      let my = String::from("Bill Gates");
    }

    // println!("{}", my); // my is out of scope
  }

  fn testS(s: &String) {
    println!("{}", s);
  }

  #[test]
  pub fn doit1() {
    let mut stack_num = 32;
    let mut heap_num = vec![4, 5, 6];

    stack_num = stack_function(stack_num);
    println!("print stack {}", stack_num);

    heap_function(&mut heap_num);
    println!("Vec after func {:?}", heap_num);

    let large_data1 = String::from("Large string 1");
    let large_data2 = String::from("Large string 2");
    // combine string without using more memory
    let huge_concat: Vec<&str> = vec![&large_data1, &large_data2];
  }

  fn stack_function(mut var: i32) -> i32 {
    var  = 56;
    println!("Th ecopy updated {}", var);
    var
  }

  fn heap_function(var: &mut Vec<i32>) {
    println!("Vector inside func: {:?}", var);
    var.push(56);
  }

  pub fn doit2() {

  }

  pub fn doit3() {
    let s1 = String::from("Hello");
    let s2: &str = "world";

    let s3 = s1 + s2;
    // s1 doesn;t exists anymore, was moved to 3
    // println!("test {}", s1); - error
    println!("test {}", s3); // good
  }

  pub fn doit4() {
    let s1 = String::from("Hello");
    let s2 = String::from(" world");
    let s3  = s1 + &s2; // +  only works with a String and string slice
  }

  fn doit5() {
    let s1 = String::from("Hello");
    let s2 = String::from(" world");
    let s3 = String::from(" from Rust");

    let s4 = s1 + &s2 + &s3;
  }
}