pub mod option_iterator {
    #[test]
    pub fn doit() {
        let grade = Some("A+");
        let mut grades = vec!["C-", "B+", "D"];

        if let Some(grade) = grade {
            grades.push(grade);
        }

        // OR

        grades.extend(grade); // because Option implements the iterator trait

        println!("{:?}", grades);

        // extend an iterator
        for grade in grades.iter().chain(grades.iter()) {
            println!("{grade:?}");
        }

        // filter out None variants
        let grades = vec![Some("A-"), None, Some("B-"), None];
        let grades: Vec<&str> = grades.into_iter().flatten().collect(); // all without None
        println!("{:?}", grades);

        let grades = ["3.8", "A+", "4.2", "B-"];
        let grades: Vec<f32> = grades
            .iter()
            .filter_map(|x| x.parse().ok())
            .collect();
        println!("{:?}", grades);
    }
}


