pub mod M {
    use std::fs::{File, self};
    use std::io;
    use std::io::{ErrorKind, Read};

    pub fn do_it() {
        let f = File::open("hello.txt");

        let f = match f {
            Ok(file) => file,
            Err(error) => match error.kind() {
                ErrorKind::NotFound => match File::create("hello.txt") {
                    Ok(fc) => fc,
                    Err(e) => panic!("Problem creating file: {:?}!", e)
                },
                _ => panic!("No idea what to do :)")
            }
        };


    }

    fn do_it_closures() {
        let f = File::open("foo.bar").unwrap_or_else(|err|{
            if err.kind() == ErrorKind::NotFound {
                File::create("foo.bar").unwrap_or_else(|err|{
                    panic!("Problem creating file: {:?}", err);
                })
            } else {
                panic!("Problem opening file: {:?}!", err);
            }
        });
    }

    fn read_user_from_file() -> Result<String, io::Error> {
        let f = File::open("ba.ba");

        let mut f = match f {
            Ok(f) => f,
            Err(e) => return Err(e),
        };

        let mut s = String::new();

        match f.read_to_string(&mut s) {
            Ok(_) => Ok(s),
            Err(e) => Err(e)
        }
    }

    fn read_user_from_file_1() -> Result<String, io::Error> {
        let mut f = File::open("ba.ba")?;

        // ? - if all good return the value into variable
        // otherwise exits with Err(e)
        // let mut f = match f {
        //     Ok(f) => f,
        //     Err(e) => return Err(e),
        // };

        let mut s = String::new();

        f.read_to_string(&mut s)?;
        Ok(s)
    }

    fn read_user_from_file_2() -> Result<String, io::Error> {
        let mut s = String::new();
        File::open("ba.ba")?.read_to_string(&mut s)?;
        Ok(s)
    }

    fn read_user_from_file_3() -> Result<String, io::Error> {
        fs::read_to_string("hello.txt")
    }
}