pub mod enums_pattern_matching {
    pub enum IpAddKind {
        V4(u8, u8, u8, u8),
        V6(String),
    }

    enum Message {
        Quit,
        Move { x: i32, y: i32 },
        Write(String),
        ChangeColor(i32, i32, i32),
    }

    impl Message {
        fn some_function() {

        }
    }

    struct IpAddress {
        kind: IpAddKind,
        address: String,
    }

    pub fn do_something() {
        let four = IpAddKind::V4;
        let six = IpAddKind::V6;

        // let ip = IpAddress { kind: IpAddKind::V4, address: "127.0.0.1".to_string() };

        // route(four);

        let localHost = IpAddKind::V4(127, 0, 0, 1);

        bar1();
        bar2();
    }

    fn route(ip_kind: IpAddKind) {}


    // Option enum
    // enum Option<T> {
    //     Some(T),
    //     None
    // }

    fn bar1() {
        let x: i8 = 5;
        let y: Option<i8> = Some(5);

        let mut sum = x + y.unwrap_or(0);
        println!("{}", sum);

        let z: Option<i8> = None;
        sum = x + z.unwrap_or(0);
        println!("{}", sum);
    }

    #[derive(Debug)]
    enum UsState {
        Alabama,
        Alaska,
        Arizona,
        Arkanzas,
        California,
    }

    // Matching
    enum Coin {
        Penny,
        Nickel,
        Dime,
        Quarter(UsState)
    }

    fn value_in_cents(coin: Coin) -> i8 {
        match coin {
            Coin::Penny => {
                println!("Lucky penny");
                1
            },
            Coin::Nickel => 5,
            Coin::Dime => 10,
            Coin::Quarter(state) => {
                println!("State quarter from {:?}!", state);
                25
            },
        }
    }

    fn bar2() {
        println!("Cents {}", value_in_cents(Coin::Penny));
        println!("Cents {}", value_in_cents(Coin::Quarter(UsState::Arizona)));
    }

    fn plus_one(x: Option<i32>) -> Option<i32> {
        match x {
            None => None,
            Some(i) => Some(i + 1)
        }
    }

    fn plus_one_1(x: Option<i32>) -> Option<i32> {
        match x {
            Some(i) => Some(i + 1),
            _ => None // will match all of the other enums value
        }
    }

    fn bar3() {
        let some_value = Some(3);

        match some_value {
            Some(3) => println!("Three!"),
            _ => ()
        }

        // is equivalent to

        if let Some(3) = some_value {
            println!("Three again")
        }
    }
}

