use std::collections::HashMap;
lazy_static! {
    pub static ref REGION_MAP: HashMap<&'static str, &'static str> = {
        let mut map = HashMap::new();
        map.insert("110000", "北京市");
        map.insert("110100", "北京市市辖区");
        map.insert("110101", "北京市东城区");
        map.insert("110102", "北京市西城区");
        map.insert("110103", "北京市崇文区");
        map.insert("110104", "北京市宣武区");
        map.insert("110105", "北京市朝阳区");
        map.insert("110106", "北京市丰台区");
        map.insert("110107", "北京市石景山区");
        map.insert("110108", "北京市海淀区");
        map.insert("110109", "北京市门头沟区");
        map.insert("110110", "北京市燕山区");
        map.insert("110111", "北京市房山区");
        map.insert("110112", "北京市通州区");
        map.insert("110113", "北京市顺义区");
        map.insert("110114", "北京市昌平区");
        map.insert("110115", "北京市大兴区");
        map.insert("110116", "北京市怀柔区");
        map.insert("110117", "北京市平谷区");
        map.insert("110221", "北京市昌平县");
        map.insert("110222", "北京市顺义县");
        map.insert("110223", "北京市通县");
        map.insert("110224", "北京市大兴县");
        map.insert("110225", "北京市房山县");
        map.insert("110226", "北京市平谷县");
        map.insert("110227", "北京市怀柔县");
        map.insert("110228", "北京市密云县");
        map.insert("110229", "北京市延庆县");
        map.insert("120000", "天津市");
        map.insert("120100", "天津市市辖区");
        map.insert("120101", "天津市和平区");
        map.insert("120102", "天津市河东区");
        map.insert("120103", "天津市河西区");
        map.insert("120104", "天津市南开区");
        map.insert("120105", "天津市河北区");
        map.insert("120106", "天津市红桥区");
        map.insert("120107", "天津市塘沽区");
        map.insert("120108", "天津市汉沽区");
        map.insert("120109", "天津市大港区");
        map.insert("120110", "天津市东丽区");
        map.insert("120111", "天津市西青区");
        map.insert("120112", "天津市津南区");
        map.insert("120113", "天津市北辰区");
        map.insert("120114", "天津市武清区");
        map.insert("120115", "天津市宝坻区");
        map.insert("120221", "天津市宁河县");
        map.insert("120222", "天津市武清县");
        map.insert("120223", "天津市静海县");
        map.insert("120224", "天津市宝坻县");
        map.insert("120225", "天津市蓟县");
        map.insert("130000", "河北省");
        map.insert("130100", "河北省石家庄市");
        map.insert("130101", "河北省石家庄市市辖区");
        map.insert("130102", "河北省石家庄市长安区");
        map.insert("130103", "河北省石家庄市桥东区");
        map.insert("130104", "河北省石家庄市桥西区");
        map.insert("130105", "河北省石家庄市新华区");
        map.insert("130106", "河北省石家庄市郊区");
        map.insert("130107", "河北省石家庄市井陉矿区");
        map.insert("130108", "河北省石家庄市裕华区");
        map.insert("130121", "河北省井陉县");
        map.insert("130122", "河北省获鹿县");
        map.insert("130123", "河北省正定县");
        map.insert("130124", "河北省栾城县");
        map.insert("130125", "河北省行唐县");
        map.insert("130126", "河北省灵寿县");
        map.insert("130127", "河北省高邑县");
        map.insert("130128", "河北省深泽县");
        map.insert("130129", "河北省赞皇县");
        map.insert("130130", "河北省无极县");
        map.insert("130131", "河北省平山县");
        map.insert("130132", "河北省元氏县");
        map.insert("130133", "河北省赵县");
        map.insert("130181", "河北省辛集市");
        map.insert("130182", "河北省藁城市");
        map.insert("130183", "河北省晋州市");
        map.insert("130184", "河北省新乐市");
        map.insert("130185", "河北省鹿泉市");
        map.insert("130200", "河北省唐山市");
        map.insert("130201", "河北省唐山市市辖区");
        map.insert("130202", "河北省唐山市路南区");
        map.insert("130203", "河北省唐山市路北区");
        map.insert("130204", "河北省唐山市古冶区");
        map.insert("130205", "河北省唐山市开平区");
        map.insert("130206", "河北省唐山市新区");
        map.insert("130207", "河北省唐山市丰南区");
        map.insert("130208", "河北省唐山市丰润区");
        map.insert("130221", "河北省丰润县");
        map.insert("130222", "河北省丰南县");
        map.insert("130223", "河北省滦县");
        map.insert("130224", "河北省滦南县");
        map.insert("130225", "河北省乐亭县");
        map.insert("130226", "河北省迁安县");
        map.insert("130227", "河北省迁西县");
        map.insert("130228", "河北省遵化县");
        map.insert("130229", "河北省玉田县");
        map.insert("130230", "河北省唐海县");
        map.insert("130281", "河北省遵化市");
        map.insert("130282", "河北省丰南市");
        map.insert("130283", "河北省迁安市");
        map.insert("130300", "河北省秦皇岛市");
        map.insert("130301", "河北省秦皇岛市市辖区");
        map.insert("130302", "河北省秦皇岛市海港区");
        map.insert("130303", "河北省秦皇岛市山海关区");
        map.insert("130304", "河北省秦皇岛市北戴河区");
        map.insert("130321", "河北省青龙满族自治县");
        map.insert("130322", "河北省昌黎县");
        map.insert("130323", "河北省抚宁县");
        map.insert("130324", "河北省卢龙县");
        map.insert("130400", "河北省邯郸市");
        map.insert("130401", "河北省邯郸市市辖区");
        map.insert("130402", "河北省邯郸市邯山区");
        map.insert("130403", "河北省邯郸市丛台区");
        map.insert("130404", "河北省邯郸市复兴区");
        map.insert("130406", "河北省邯郸市峰峰矿区");
        map.insert("130421", "河北省邯郸县");
        map.insert("130422", "河北省武安县");
        map.insert("130423", "河北省临漳县");
        map.insert("130424", "河北省成安县");
        map.insert("130425", "河北省大名县");
        map.insert("130426", "河北省涉县");
        map.insert("130427", "河北省磁县");
        map.insert("130428", "河北省肥乡县");
        map.insert("130429", "河北省永年县");
        map.insert("130430", "河北省邱县");
        map.insert("130431", "河北省鸡泽县");
        map.insert("130432", "河北省广平县");
        map.insert("130433", "河北省馆陶县");
        map.insert("130434", "河北省魏县");
        map.insert("130435", "河北省曲周县");
        map.insert("130481", "河北省武安市");
        map.insert("130500", "河北省邢台市");
        map.insert("130501", "河北省邢台市市辖区");
        map.insert("130502", "河北省邢台市桥东区");
        map.insert("130503", "河北省邢台市桥西区");
        map.insert("130504", "河北省邢台市郊区");
        map.insert("130521", "河北省邢台县");
        map.insert("130522", "河北省临城县");
        map.insert("130523", "河北省内丘县");
        map.insert("130524", "河北省柏乡县");
        map.insert("130525", "河北省隆尧县");
        map.insert("130526", "河北省任县");
        map.insert("130527", "河北省南和县");
        map.insert("130528", "河北省宁晋县");
        map.insert("130529", "河北省巨鹿县");
        map.insert("130530", "河北省新河县");
        map.insert("130531", "河北省广宗县");
        map.insert("130532", "河北省平乡县");
        map.insert("130533", "河北省威县");
        map.insert("130534", "河北省清河县");
        map.insert("130535", "河北省临西县");
        map.insert("130581", "河北省南宫市");
        map.insert("130582", "河北省沙河市");
        map.insert("130600", "河北省保定市");
        map.insert("130601", "河北省保定市市辖区");
        map.insert("130602", "河北省保定市新市区");
        map.insert("130603", "河北省保定市北市区");
        map.insert("130604", "河北省保定市南市区");
        map.insert("130605", "河北省保定市郊区");
        map.insert("130621", "河北省满城县");
        map.insert("130622", "河北省清苑县");
        map.insert("130623", "河北省涞水县");
        map.insert("130624", "河北省阜平县");
        map.insert("130625", "河北省徐水县");
        map.insert("130626", "河北省定兴县");
        map.insert("130627", "河北省唐县");
        map.insert("130628", "河北省高阳县");
        map.insert("130629", "河北省容城县");
        map.insert("130630", "河北省涞源县");
        map.insert("130631", "河北省望都县");
        map.insert("130632", "河北省安新县");
        map.insert("130633", "河北省易县");
        map.insert("130634", "河北省曲阳县");
        map.insert("130635", "河北省蠡县");
        map.insert("130636", "河北省顺平县");
        map.insert("130637", "河北省博野县");
        map.insert("130638", "河北省雄县");
        map.insert("130681", "河北省涿州市");
        map.insert("130682", "河北省定州市");
        map.insert("130683", "河北省安国市");
        map.insert("130684", "河北省高碑店市");
        map.insert("130700", "河北省张家口市");
        map.insert("130701", "河北省张家口市市辖区");
        map.insert("130702", "河北省张家口市桥东区");
        map.insert("130703", "河北省张家口市桥西区");
        map.insert("130704", "河北省张家口市茶坊区");
        map.insert("130705", "河北省张家口市宣化区");
        map.insert("130706", "河北省张家口市下花园区");
        map.insert("130707", "河北省张家口市庞家堡区");
        map.insert("130721", "河北省宣化县");
        map.insert("130722", "河北省张北县");
        map.insert("130723", "河北省康保县");
        map.insert("130724", "河北省沽源县");
        map.insert("130725", "河北省尚义县");
        map.insert("130726", "河北省蔚县");
        map.insert("130727", "河北省阳原县");
        map.insert("130728", "河北省怀安县");
        map.insert("130729", "河北省万全县");
        map.insert("130730", "河北省怀来县");
        map.insert("130731", "河北省涿鹿县");
        map.insert("130732", "河北省赤城县");
        map.insert("130733", "河北省崇礼县");
        map.insert("130800", "河北省承德市");
        map.insert("130801", "河北省承德市市辖区");
        map.insert("130802", "河北省承德市双桥区");
        map.insert("130803", "河北省承德市双滦区");
        map.insert("130804", "河北省承德市鹰手营子矿区");
        map.insert("130821", "河北省承德县");
        map.insert("130822", "河北省兴隆县");
        map.insert("130823", "河北省平泉县");
        map.insert("130824", "河北省滦平县");
        map.insert("130825", "河北省隆化县");
        map.insert("130826", "河北省丰宁满族自治县");
        map.insert("130827", "河北省宽城满族自治县");
        map.insert("130828", "河北省围场满族蒙古族自治县");
        map.insert("130900", "河北省沧州市");
        map.insert("130901", "河北省沧州市市辖区");
        map.insert("130902", "河北省沧州市新华区");
        map.insert("130903", "河北省沧州市运河区");
        map.insert("130904", "河北省沧州市郊区");
        map.insert("130921", "河北省沧县");
        map.insert("130922", "河北省青县");
        map.insert("130923", "河北省东光县");
        map.insert("130924", "河北省海兴县");
        map.insert("130925", "河北省盐山县");
        map.insert("130926", "河北省肃宁县");
        map.insert("130927", "河北省南皮县");
        map.insert("130928", "河北省吴桥县");
        map.insert("130929", "河北省献县");
        map.insert("130930", "河北省孟村回族自治县");
        map.insert("130981", "河北省泊头市");
        map.insert("130982", "河北省任丘市");
        map.insert("130983", "河北省黄骅市");
        map.insert("130984", "河北省河间市");
        map.insert("131000", "河北省廊坊市");
        map.insert("131001", "河北省廊坊市市辖区");
        map.insert("131002", "河北省廊坊市安次区");
        map.insert("131003", "河北省廊坊市广阳区");
        map.insert("131021", "河北省三河县");
        map.insert("131022", "河北省固安县");
        map.insert("131023", "河北省永清县");
        map.insert("131024", "河北省香河县");
        map.insert("131025", "河北省大城县");
        map.insert("131026", "河北省文安县");
        map.insert("131027", "河北省霸县");
        map.insert("131028", "河北省大厂回族自治县");
        map.insert("131081", "河北省霸州市");
        map.insert("131082", "河北省三河市");
        map.insert("131100", "河北省衡水市");
        map.insert("131101", "河北省衡水市市辖区");
        map.insert("131102", "河北省衡水市桃城区");
        map.insert("131121", "河北省枣强县");
        map.insert("131122", "河北省武邑县");
        map.insert("131123", "河北省武强县");
        map.insert("131124", "河北省饶阳县");
        map.insert("131125", "河北省安平县");
        map.insert("131126", "河北省故城县");
        map.insert("131127", "河北省景县");
        map.insert("131128", "河北省阜城县");
        map.insert("131181", "河北省冀州市");
        map.insert("131182", "河北省深州市");
        map.insert("132100", "河北省邯郸地区");
        map.insert("132101", "河北省邯郸市");
        map.insert("132121", "河北省大名县");
        map.insert("132122", "河北省魏县");
        map.insert("132123", "河北省曲周县");
        map.insert("132124", "河北省丘县");
        map.insert("132125", "河北省鸡泽县");
        map.insert("132126", "河北省肥乡县");
        map.insert("132127", "河北省广平县");
        map.insert("132128", "河北省成安县");
        map.insert("132129", "河北省临漳县");
        map.insert("132130", "河北省磁县");
        map.insert("132131", "河北省武安县");
        map.insert("132132", "河北省涉县");
        map.insert("132133", "河北省永年县");
        map.insert("132134", "河北省邯郸县");
        map.insert("132135", "河北省馆陶县");
        map.insert("132200", "河北省邢台地区");
        map.insert("132201", "河北省南宫市");
        map.insert("132202", "河北省沙河市");
        map.insert("132221", "河北省邢台县");
        map.insert("132222", "河北省沙河县");
        map.insert("132223", "河北省临城县");
        map.insert("132224", "河北省内丘县");
        map.insert("132225", "河北省柏乡县");
        map.insert("132226", "河北省隆尧县");
        map.insert("132227", "河北省任县");
        map.insert("132228", "河北省南和县");
        map.insert("132229", "河北省宁晋县");
        map.insert("132230", "河北省南宫县");
        map.insert("132231", "河北省巨鹿县");
        map.insert("132232", "河北省新河县");
        map.insert("132233", "河北省广宗县");
        map.insert("132234", "河北省平乡县");
        map.insert("132235", "河北省威县");
        map.insert("132236", "河北省清河县");
        map.insert("132237", "河北省临西县");
        map.insert("132300", "河北省石家庄地区");
        map.insert("132301", "河北省辛集市");
        map.insert("132302", "河北省藁城市");
        map.insert("132321", "河北省束鹿县");
        map.insert("132322", "河北省晋县");
        map.insert("132323", "河北省深泽县");
        map.insert("132324", "河北省无极县");
        map.insert("132325", "河北省藁城县");
        map.insert("132326", "河北省赵县");
        map.insert("132327", "河北省栾城县");
        map.insert("132328", "河北省正定县");
        map.insert("132329", "河北省新乐县");
        map.insert("132330", "河北省高邑县");
        map.insert("132331", "河北省元氏县");
        map.insert("132332", "河北省赞皇县");
        map.insert("132333", "河北省井陉县");
        map.insert("132334", "河北省获鹿县");
        map.insert("132335", "河北省平山县");
        map.insert("132336", "河北省灵寿县");
        map.insert("132337", "河北省行唐县");
        map.insert("132400", "河北省保定地区");
        map.insert("132401", "河北省定州市");
        map.insert("132402", "河北省涿州市");
        map.insert("132403", "河北省安国市");
        map.insert("132404", "河北省高碑店市");
        map.insert("132421", "河北省易县");
        map.insert("132422", "河北省满城县");
        map.insert("132423", "河北省徐水县");
        map.insert("132424", "河北省涞源县");
        map.insert("132425", "河北省定兴县");
        map.insert("132426", "河北省顺平县");
        map.insert("132427", "河北省唐县");
        map.insert("132428", "河北省望都县");
        map.insert("132429", "河北省涞水县");
        map.insert("132430", "河北省涿县");
        map.insert("132431", "河北省清苑县");
        map.insert("132432", "河北省高阳县");
        map.insert("132433", "河北省安新县");
        map.insert("132434", "河北省雄县");
        map.insert("132435", "河北省容城县");
        map.insert("132436", "河北省新城县");
        map.insert("132437", "河北省曲阳县");
        map.insert("132438", "河北省阜平县");
        map.insert("132439", "河北省定县");
        map.insert("132440", "河北省安国县");
        map.insert("132441", "河北省博野县");
        map.insert("132442", "河北省蠡县");
        map.insert("132500", "河北省张家口地区");
        map.insert("132501", "河北省张家口市");
        map.insert("132521", "河北省张北县");
        map.insert("132522", "河北省康保县");
        map.insert("132523", "河北省沽源县");
        map.insert("132524", "河北省尚义县");
        map.insert("132525", "河北省蔚县");
        map.insert("132526", "河北省阳原县");
        map.insert("132527", "河北省怀安县");
        map.insert("132528", "河北省万全县");
        map.insert("132529", "河北省怀来县");
        map.insert("132530", "河北省涿鹿县");
        map.insert("132531", "河北省宣化县");
        map.insert("132532", "河北省赤城县");
        map.insert("132533", "河北省崇礼县");
        map.insert("132600", "河北省承德地区");
        map.insert("132601", "河北省承德市");
        map.insert("132621", "河北省青龙县");
        map.insert("132622", "河北省宽城县");
        map.insert("132623", "河北省兴隆县");
        map.insert("132624", "河北省平泉县");
        map.insert("132625", "河北省承德县");
        map.insert("132626", "河北省滦平县");
        map.insert("132627", "河北省丰宁县");
        map.insert("132628", "河北省隆化县");
        map.insert("132629", "河北省围场县");
        map.insert("132701", "河北省秦皇岛市");
        map.insert("132721", "河北省丰润县");
        map.insert("132722", "河北省丰南县");
        map.insert("132723", "河北省滦县");
        map.insert("132724", "河北省滦南县");
        map.insert("132725", "河北省乐亭县");
        map.insert("132726", "河北省昌黎县");
        map.insert("132727", "河北省抚宁县");
        map.insert("132728", "河北省卢龙县");
        map.insert("132729", "河北省迁安县");
        map.insert("132730", "河北省迁西县");
        map.insert("132731", "河北省遵化县");
        map.insert("132732", "河北省玉田县");
        map.insert("132800", "河北省廊坊地区");
        map.insert("132801", "河北省廊坊市");
        map.insert("132821", "河北省三河县");
        map.insert("132822", "河北省大厂回族自治县");
        map.insert("132823", "河北省香河县");
        map.insert("132824", "河北省安次县");
        map.insert("132825", "河北省永清县");
        map.insert("132826", "河北省固安县");
        map.insert("132827", "河北省霸县");
        map.insert("132828", "河北省文安县");
        map.insert("132829", "河北省大城县");
        map.insert("132900", "河北省沧州地区");
        map.insert("132901", "河北省沧州市");
        map.insert("132902", "河北省泊头市");
        map.insert("132903", "河北省任丘市");
        map.insert("132904", "河北省黄骅市");
        map.insert("132905", "河北省河间市");
        map.insert("132921", "河北省沧县");
        map.insert("132922", "河北省河间县");
        map.insert("132923", "河北省肃宁县");
        map.insert("132924", "河北省献县");
        map.insert("132925", "河北省交河县");
        map.insert("132926", "河北省吴桥县");
        map.insert("132927", "河北省东光县");
        map.insert("132928", "河北省南皮县");
        map.insert("132929", "河北省盐山县");
        map.insert("132930", "河北省黄骅县");
        map.insert("132931", "河北省孟村回族自治县");
        map.insert("132932", "河北省青县");
        map.insert("132933", "河北省任丘县");
        map.insert("132934", "河北省海兴县");
        map.insert("133000", "河北省衡水地区");
        map.insert("133001", "河北省衡水市");
        map.insert("133002", "河北省冀州市");
        map.insert("133021", "河北省衡水县");
        map.insert("133022", "河北省冀县");
        map.insert("133023", "河北省枣强县");
        map.insert("133024", "河北省武邑县");
        map.insert("133025", "河北省深县");
        map.insert("133026", "河北省武强县");
        map.insert("133027", "河北省饶阳县");
        map.insert("133028", "河北省安平县");
        map.insert("133029", "河北省故城县");
        map.insert("133030", "河北省景县");
        map.insert("133031", "河北省阜城县");
        map.insert("139000", "河北省省直辖单位");
        map.insert("139001", "河北省武安市");
        map.insert("140000", "山西省");
        map.insert("140100", "山西省太原市");
        map.insert("140101", "山西省太原市市辖区");
        map.insert("140102", "山西省太原市南城区");
        map.insert("140103", "山西省太原市北城区");
        map.insert("140104", "山西省太原市河西区");
        map.insert("140105", "山西省太原市小店区");
        map.insert("140106", "山西省太原市迎泽区");
        map.insert("140107", "山西省太原市杏花岭区");
        map.insert("140108", "山西省太原市尖草坪区");
        map.insert("140109", "山西省太原市万柏林区");
        map.insert("140110", "山西省太原市晋源区");
        map.insert("140111", "山西省太原市古交工矿区");
        map.insert("140112", "山西省太原市南郊区");
        map.insert("140113", "山西省太原市北郊区");
        map.insert("140120", "山西省太原市区");
        map.insert("140121", "山西省清徐县");
        map.insert("140122", "山西省阳曲县");
        map.insert("140123", "山西省娄烦县");
        map.insert("140181", "山西省古交市");
        map.insert("140200", "山西省大同市");
        map.insert("140201", "山西省大同市市辖区");
        map.insert("140202", "山西省大同市城区");
        map.insert("140203", "山西省大同市矿区");
        map.insert("140211", "山西省大同市南郊区");
        map.insert("140212", "山西省大同市新荣区");
        map.insert("140221", "山西省阳高县");
        map.insert("140222", "山西省天镇县");
        map.insert("140223", "山西省广灵县");
        map.insert("140224", "山西省灵丘县");
        map.insert("140225", "山西省浑源县");
        map.insert("140226", "山西省左云县");
        map.insert("140227", "山西省大同县");
        map.insert("140300", "山西省阳泉市");
        map.insert("140301", "山西省阳泉市市辖区");
        map.insert("140302", "山西省阳泉市城区");
        map.insert("140303", "山西省阳泉市矿区");
        map.insert("140311", "山西省阳泉市郊区");
        map.insert("140321", "山西省平定县");
        map.insert("140322", "山西省盂县");
        map.insert("140400", "山西省长治市");
        map.insert("140401", "山西省长治市市辖区");
        map.insert("140402", "山西省长治市城区");
        map.insert("140411", "山西省长治市郊区");
        map.insert("140421", "山西省长治县");
        map.insert("140422", "山西省潞城县");
        map.insert("140423", "山西省襄垣县");
        map.insert("140424", "山西省屯留县");
        map.insert("140425", "山西省平顺县");
        map.insert("140426", "山西省黎城县");
        map.insert("140427", "山西省壶关县");
        map.insert("140428", "山西省长子县");
        map.insert("140429", "山西省武乡县");
        map.insert("140430", "山西省沁县");
        map.insert("140431", "山西省沁源县");
        map.insert("140481", "山西省潞城市");
        map.insert("140500", "山西省晋城市");
        map.insert("140501", "山西省晋城市市辖区");
        map.insert("140502", "山西省晋城市城区");
        map.insert("140511", "山西省晋城市郊区");
        map.insert("140521", "山西省沁水县");
        map.insert("140522", "山西省阳城县");
        map.insert("140523", "山西省高平县");
        map.insert("140524", "山西省陵川县");
        map.insert("140525", "山西省泽州县");
        map.insert("140581", "山西省高平市");
        map.insert("140600", "山西省朔州市");
        map.insert("140601", "山西省朔州市市辖区");
        map.insert("140602", "山西省朔州市朔城区");
        map.insert("140603", "山西省朔州市平鲁区");
        map.insert("140621", "山西省山阴县");
        map.insert("140622", "山西省应县");
        map.insert("140623", "山西省右玉县");
        map.insert("140624", "山西省怀仁县");
        map.insert("140700", "山西省晋中市");
        map.insert("140701", "山西省晋中市市辖区");
        map.insert("140702", "山西省晋中市榆次区");
        map.insert("140721", "山西省榆社县");
        map.insert("140722", "山西省左权县");
        map.insert("140723", "山西省和顺县");
        map.insert("140724", "山西省昔阳县");
        map.insert("140725", "山西省寿阳县");
        map.insert("140726", "山西省太谷县");
        map.insert("140727", "山西省祁县");
        map.insert("140728", "山西省平遥县");
        map.insert("140729", "山西省灵石县");
        map.insert("140781", "山西省介休市");
        map.insert("140800", "山西省运城市");
        map.insert("140801", "山西省运城市市辖区");
        map.insert("140802", "山西省运城市盐湖区");
        map.insert("140821", "山西省临猗县");
        map.insert("140822", "山西省万荣县");
        map.insert("140823", "山西省闻喜县");
        map.insert("140824", "山西省稷山县");
        map.insert("140825", "山西省新绛县");
        map.insert("140826", "山西省绛县");
        map.insert("140827", "山西省垣曲县");
        map.insert("140828", "山西省夏县");
        map.insert("140829", "山西省平陆县");
        map.insert("140830", "山西省芮城县");
        map.insert("140881", "山西省永济市");
        map.insert("140882", "山西省河津市");
        map.insert("140900", "山西省忻州市");
        map.insert("140901", "山西省忻州市市辖区");
        map.insert("140902", "山西省忻州市忻府区");
        map.insert("140921", "山西省定襄县");
        map.insert("140922", "山西省五台县");
        map.insert("140923", "山西省代县");
        map.insert("140924", "山西省繁峙县");
        map.insert("140925", "山西省宁武县");
        map.insert("140926", "山西省静乐县");
        map.insert("140927", "山西省神池县");
        map.insert("140928", "山西省五寨县");
        map.insert("140929", "山西省岢岚县");
        map.insert("140930", "山西省河曲县");
        map.insert("140931", "山西省保德县");
        map.insert("140932", "山西省偏关县");
        map.insert("140981", "山西省原平市");
        map.insert("141000", "山西省临汾市");
        map.insert("141001", "山西省临汾市市辖区");
        map.insert("141002", "山西省临汾市尧都区");
        map.insert("141021", "山西省曲沃县");
        map.insert("141022", "山西省翼城县");
        map.insert("141023", "山西省襄汾县");
        map.insert("141024", "山西省洪洞县");
        map.insert("141025", "山西省古县");
        map.insert("141026", "山西省安泽县");
        map.insert("141027", "山西省浮山县");
        map.insert("141028", "山西省吉县");
        map.insert("141029", "山西省乡宁县");
        map.insert("141030", "山西省大宁县");
        map.insert("141031", "山西省隰县");
        map.insert("141032", "山西省永和县");
        map.insert("141033", "山西省蒲县");
        map.insert("141034", "山西省汾西县");
        map.insert("141081", "山西省侯马市");
        map.insert("141082", "山西省霍州市");
        map.insert("141100", "山西省吕梁市");
        map.insert("141101", "山西省吕梁市市辖区");
        map.insert("141102", "山西省吕梁市离石区");
        map.insert("141121", "山西省文水县");
        map.insert("141122", "山西省交城县");
        map.insert("141123", "山西省兴县");
        map.insert("141124", "山西省临县");
        map.insert("141125", "山西省柳林县");
        map.insert("141126", "山西省石楼县");
        map.insert("141127", "山西省岚县");
        map.insert("141128", "山西省方山县");
        map.insert("141129", "山西省中阳县");
        map.insert("141130", "山西省交口县");
        map.insert("141181", "山西省孝义市");
        map.insert("141182", "山西省汾阳市");
        map.insert("142100", "山西省雁北地区");
        map.insert("142121", "山西省阳高县");
        map.insert("142122", "山西省天镇县");
        map.insert("142123", "山西省广灵县");
        map.insert("142124", "山西省灵丘县");
        map.insert("142125", "山西省浑源县");
        map.insert("142126", "山西省应县");
        map.insert("142127", "山西省山阴县");
        map.insert("142128", "山西省朔县");
        map.insert("142129", "山西省平鲁县");
        map.insert("142130", "山西省左云县");
        map.insert("142131", "山西省右玉县");
        map.insert("142132", "山西省大同县");
        map.insert("142133", "山西省怀仁县");
        map.insert("142200", "山西省忻州地区");
        map.insert("142201", "山西省忻州市");
        map.insert("142202", "山西省原平市");
        map.insert("142221", "山西省忻县");
        map.insert("142222", "山西省定襄县");
        map.insert("142223", "山西省五台县");
        map.insert("142224", "山西省原平县");
        map.insert("142225", "山西省代县");
        map.insert("142226", "山西省繁峙县");
        map.insert("142227", "山西省宁武县");
        map.insert("142228", "山西省静乐县");
        map.insert("142229", "山西省神池县");
        map.insert("142230", "山西省五寨县");
        map.insert("142231", "山西省岢岚县");
        map.insert("142232", "山西省河曲县");
        map.insert("142233", "山西省保德县");
        map.insert("142234", "山西省偏关县");
        map.insert("142300", "山西省吕梁地区");
        map.insert("142301", "山西省孝义市");
        map.insert("142302", "山西省离石市");
        map.insert("142303", "山西省汾阳市");
        map.insert("142321", "山西省汾阳县");
        map.insert("142322", "山西省文水县");
        map.insert("142323", "山西省交城县");
        map.insert("142324", "山西省孝义县");
        map.insert("142325", "山西省兴县");
        map.insert("142326", "山西省临县");
        map.insert("142327", "山西省柳林县");
        map.insert("142328", "山西省石楼县");
        map.insert("142329", "山西省岚县");
        map.insert("142330", "山西省方山县");
        map.insert("142331", "山西省离石县");
        map.insert("142332", "山西省中阳县");
        map.insert("142333", "山西省交口县");
        map.insert("142400", "山西省晋中地区");
        map.insert("142401", "山西省榆次市");
        map.insert("142402", "山西省介休市");
        map.insert("142421", "山西省榆社县");
        map.insert("142422", "山西省左权县");
        map.insert("142423", "山西省和顺县");
        map.insert("142424", "山西省昔阳县");
        map.insert("142425", "山西省平定县");
        map.insert("142426", "山西省盂县");
        map.insert("142427", "山西省寿阳县");
        map.insert("142428", "山西省榆次县");
        map.insert("142429", "山西省太谷县");
        map.insert("142430", "山西省祁县");
        map.insert("142431", "山西省平遥县");
        map.insert("142432", "山西省介休县");
        map.insert("142433", "山西省灵石县");
        map.insert("142500", "山西省晋东南地区");
        map.insert("142501", "山西省晋城市");
        map.insert("142521", "山西省长治县");
        map.insert("142522", "山西省潞城县");
        map.insert("142523", "山西省屯留县");
        map.insert("142524", "山西省长子县");
        map.insert("142525", "山西省沁水县");
        map.insert("142526", "山西省阳城县");
        map.insert("142527", "山西省晋城县");
        map.insert("142528", "山西省高平县");
        map.insert("142529", "山西省陵川县");
        map.insert("142530", "山西省壶关县");
        map.insert("142531", "山西省平顺县");
        map.insert("142532", "山西省黎城县");
        map.insert("142533", "山西省武乡县");
        map.insert("142534", "山西省襄垣县");
        map.insert("142535", "山西省沁县");
        map.insert("142536", "山西省沁源县");
        map.insert("142600", "山西省临汾地区");
        map.insert("142601", "山西省临汾市");
        map.insert("142602", "山西省侯马市");
        map.insert("142603", "山西省霍州市");
        map.insert("142621", "山西省曲沃县");
        map.insert("142622", "山西省翼城县");
        map.insert("142623", "山西省襄汾县");
        map.insert("142624", "山西省临汾县");
        map.insert("142625", "山西省洪洞县");
        map.insert("142626", "山西省霍县");
        map.insert("142627", "山西省古县");
        map.insert("142628", "山西省安泽县");
        map.insert("142629", "山西省浮山县");
        map.insert("142630", "山西省吉县");
        map.insert("142631", "山西省乡宁县");
        map.insert("142632", "山西省蒲县");
        map.insert("142633", "山西省大宁县");
        map.insert("142634", "山西省永和县");
        map.insert("142635", "山西省隰县");
        map.insert("142636", "山西省汾西县");
        map.insert("142700", "山西省运城地区");
        map.insert("142701", "山西省运城市");
        map.insert("142702", "山西省永济市");
        map.insert("142703", "山西省河津市");
        map.insert("142721", "山西省运城县");
        map.insert("142722", "山西省永济县");
        map.insert("142723", "山西省芮城县");
        map.insert("142724", "山西省临猗县");
        map.insert("142725", "山西省万荣县");
        map.insert("142726", "山西省新绛县");
        map.insert("142727", "山西省稷山县");
        map.insert("142728", "山西省河津县");
        map.insert("142729", "山西省闻喜县");
        map.insert("142730", "山西省夏县");
        map.insert("142731", "山西省绛县");
        map.insert("142732", "山西省平陆县");
        map.insert("142733", "山西省垣曲县");
        map.insert("149000", "山西省省直辖单位");
        map.insert("149001", "山西省古交市");
        map.insert("150000", "内蒙古自治区");
        map.insert("150100", "内蒙古自治区呼和浩特市");
        map.insert("150101", "内蒙古自治区呼和浩特市市辖区");
        map.insert("150102", "内蒙古自治区呼和浩特市新城区");
        map.insert("150103", "内蒙古自治区呼和浩特市回民区");
        map.insert("150104", "内蒙古自治区呼和浩特市玉泉区");
        map.insert("150105", "内蒙古自治区呼和浩特市赛罕区");
        map.insert("150120", "内蒙古自治区呼和浩特市区");
        map.insert("150121", "内蒙古自治区土默特左旗");
        map.insert("150122", "内蒙古自治区托克托县");
        map.insert("150123", "内蒙古自治区和林格尔县");
        map.insert("150124", "内蒙古自治区清水河县");
        map.insert("150125", "内蒙古自治区武川县");
        map.insert("150200", "内蒙古自治区包头市");
        map.insert("150201", "内蒙古自治区包头市市辖区");
        map.insert("150202", "内蒙古自治区包头市东河区");
        map.insert("150203", "内蒙古自治区包头市昆都仑区");
        map.insert("150204", "内蒙古自治区包头市青山区");
        map.insert("150205", "内蒙古自治区包头市石拐区");
        map.insert("150206", "内蒙古自治区包头市白云矿区");
        map.insert("150207", "内蒙古自治区包头市九原区");
        map.insert("150220", "内蒙古自治区包头市区");
        map.insert("150221", "内蒙古自治区土默特右旗");
        map.insert("150222", "内蒙古自治区固阳县");
        map.insert("150223", "内蒙古自治区达尔罕茂明安联合旗");
        map.insert("150300", "内蒙古自治区乌海市");
        map.insert("150301", "内蒙古自治区乌海市市辖区");
        map.insert("150302", "内蒙古自治区乌海市海勃湾区");
        map.insert("150303", "内蒙古自治区乌海市海南区");
        map.insert("150304", "内蒙古自治区乌海市乌达区");
        map.insert("150400", "内蒙古自治区赤峰市");
        map.insert("150401", "内蒙古自治区赤峰市市辖区");
        map.insert("150402", "内蒙古自治区赤峰市红山区");
        map.insert("150403", "内蒙古自治区赤峰市元宝山区");
        map.insert("150404", "内蒙古自治区赤峰市松山区");
        map.insert("150421", "内蒙古自治区阿鲁科尔沁旗");
        map.insert("150422", "内蒙古自治区巴林左旗");
        map.insert("150423", "内蒙古自治区巴林右旗");
        map.insert("150424", "内蒙古自治区林西县");
        map.insert("150425", "内蒙古自治区克什克腾旗");
        map.insert("150426", "内蒙古自治区翁牛特旗");
        map.insert("150428", "内蒙古自治区喀喇沁旗");
        map.insert("150429", "内蒙古自治区宁城县");
        map.insert("150430", "内蒙古自治区敖汉旗");
        map.insert("150500", "内蒙古自治区通辽市");
        map.insert("150501", "内蒙古自治区通辽市市辖区");
        map.insert("150502", "内蒙古自治区通辽市科尔沁区");
        map.insert("150521", "内蒙古自治区科尔沁左翼中旗");
        map.insert("150522", "内蒙古自治区科尔沁左翼后旗");
        map.insert("150523", "内蒙古自治区开鲁县");
        map.insert("150524", "内蒙古自治区库伦旗");
        map.insert("150525", "内蒙古自治区奈曼旗");
        map.insert("150526", "内蒙古自治区扎鲁特旗");
        map.insert("150581", "内蒙古自治区霍林郭勒市");
        map.insert("150600", "内蒙古自治区鄂尔多斯市");
        map.insert("150602", "内蒙古自治区鄂尔多斯市东胜区");
        map.insert("150621", "内蒙古自治区达拉特旗");
        map.insert("150622", "内蒙古自治区准格尔旗");
        map.insert("150623", "内蒙古自治区鄂托克前旗");
        map.insert("150624", "内蒙古自治区鄂托克旗");
        map.insert("150625", "内蒙古自治区杭锦旗");
        map.insert("150626", "内蒙古自治区乌审旗");
        map.insert("150627", "内蒙古自治区伊金霍洛旗");
        map.insert("150700", "内蒙古自治区呼伦贝尔市");
        map.insert("150701", "内蒙古自治区呼伦贝尔市市辖区");
        map.insert("150702", "内蒙古自治区呼伦贝尔市海拉尔区");
        map.insert("150721", "内蒙古自治区阿荣旗");
        map.insert("150722", "内蒙古自治区莫力达瓦达斡尔族自治旗");
        map.insert("150723", "内蒙古自治区鄂伦春自治旗");
        map.insert("150724", "内蒙古自治区鄂温克族自治旗");
        map.insert("150725", "内蒙古自治区陈巴尔虎旗");
        map.insert("150726", "内蒙古自治区新巴尔虎左旗");
        map.insert("150727", "内蒙古自治区新巴尔虎右旗");
        map.insert("150781", "内蒙古自治区满洲里市");
        map.insert("150782", "内蒙古自治区牙克石市");
        map.insert("150783", "内蒙古自治区扎兰屯市");
        map.insert("150784", "内蒙古自治区额尔古纳市");
        map.insert("150785", "内蒙古自治区根河市");
        map.insert("150800", "内蒙古自治区巴彦淖尔市");
        map.insert("150801", "内蒙古自治区巴彦淖尔市市辖区");
        map.insert("150802", "内蒙古自治区巴彦淖尔市临河区");
        map.insert("150821", "内蒙古自治区五原县");
        map.insert("150822", "内蒙古自治区磴口县");
        map.insert("150823", "内蒙古自治区乌拉特前旗");
        map.insert("150824", "内蒙古自治区乌拉特中旗");
        map.insert("150825", "内蒙古自治区乌拉特后旗");
        map.insert("150826", "内蒙古自治区杭锦后旗");
        map.insert("150900", "内蒙古自治区乌兰察布市");
        map.insert("150901", "内蒙古自治区乌兰察布市市辖区");
        map.insert("150902", "内蒙古自治区乌兰察布市集宁区");
        map.insert("150921", "内蒙古自治区卓资县");
        map.insert("150922", "内蒙古自治区化德县");
        map.insert("150923", "内蒙古自治区商都县");
        map.insert("150924", "内蒙古自治区兴和县");
        map.insert("150925", "内蒙古自治区凉城县");
        map.insert("150926", "内蒙古自治区察哈尔右翼前旗");
        map.insert("150927", "内蒙古自治区察哈尔右翼中旗");
        map.insert("150928", "内蒙古自治区察哈尔右翼后旗");
        map.insert("150929", "内蒙古自治区四子王旗");
        map.insert("150981", "内蒙古自治区丰镇市");
        map.insert("152100", "内蒙古自治区呼伦贝尔盟");
        map.insert("152101", "内蒙古自治区海拉尔市");
        map.insert("152102", "内蒙古自治区满洲里市");
        map.insert("152103", "内蒙古自治区扎兰屯市");
        map.insert("152104", "内蒙古自治区牙克石市");
        map.insert("152105", "内蒙古自治区根河市");
        map.insert("152106", "内蒙古自治区额尔古纳市");
        map.insert("152121", "内蒙古自治区布特哈旗");
        map.insert("152122", "内蒙古自治区阿荣旗");
        map.insert("152123", "内蒙古自治区莫力达瓦达斡尔族自治旗");
        map.insert("152124", "内蒙古自治区喜桂图旗");
        map.insert("152125", "内蒙古自治区额尔古纳右旗");
        map.insert("152126", "内蒙古自治区额尔古纳左旗");
        map.insert("152127", "内蒙古自治区鄂伦春自治旗");
        map.insert("152128", "内蒙古自治区鄂温克族自治旗");
        map.insert("152129", "内蒙古自治区新巴尔虎右旗");
        map.insert("152130", "内蒙古自治区新巴尔虎左旗");
        map.insert("152131", "内蒙古自治区陈巴尔虎旗");
        map.insert("152200", "内蒙古自治区兴安盟");
        map.insert("152201", "内蒙古自治区乌兰浩特市");
        map.insert("152202", "内蒙古自治区阿尔山市");
        map.insert("152221", "内蒙古自治区科尔沁右翼前旗");
        map.insert("152222", "内蒙古自治区科尔沁右翼中旗");
        map.insert("152223", "内蒙古自治区扎赉特旗");
        map.insert("152224", "内蒙古自治区突泉县");
        map.insert("152300", "内蒙古自治区哲里木盟");
        map.insert("152301", "内蒙古自治区通辽市");
        map.insert("152302", "内蒙古自治区霍林郭勒市");
        map.insert("152321", "内蒙古自治区通辽县");
        map.insert("152322", "内蒙古自治区科尔沁左翼中旗");
        map.insert("152323", "内蒙古自治区科尔沁左翼后旗");
        map.insert("152324", "内蒙古自治区开鲁县");
        map.insert("152325", "内蒙古自治区库伦旗");
        map.insert("152326", "内蒙古自治区奈曼旗");
        map.insert("152327", "内蒙古自治区扎鲁特旗");
        map.insert("152400", "内蒙古自治区昭乌达盟");
        map.insert("152401", "内蒙古自治区赤峰市");
        map.insert("152421", "内蒙古自治区阿鲁科尔沁旗");
        map.insert("152422", "内蒙古自治区巴林左旗");
        map.insert("152423", "内蒙古自治区巴林右旗");
        map.insert("152424", "内蒙古自治区林西县");
        map.insert("152425", "内蒙古自治区克什克腾旗");
        map.insert("152426", "内蒙古自治区翁牛特旗");
        map.insert("152427", "内蒙古自治区赤峰县");
        map.insert("152428", "内蒙古自治区喀喇沁旗");
        map.insert("152429", "内蒙古自治区宁城县");
        map.insert("152430", "内蒙古自治区敖汉旗");
        map.insert("152500", "内蒙古自治区锡林郭勒盟");
        map.insert("152501", "内蒙古自治区二连浩特市");
        map.insert("152502", "内蒙古自治区锡林浩特市");
        map.insert("152521", "内蒙古自治区阿巴哈纳尔旗");
        map.insert("152522", "内蒙古自治区阿巴嘎旗");
        map.insert("152523", "内蒙古自治区苏尼特左旗");
        map.insert("152524", "内蒙古自治区苏尼特右旗");
        map.insert("152525", "内蒙古自治区东乌珠穆沁旗");
        map.insert("152526", "内蒙古自治区西乌珠穆沁旗");
        map.insert("152527", "内蒙古自治区太仆寺旗");
        map.insert("152528", "内蒙古自治区镶黄旗");
        map.insert("152529", "内蒙古自治区正镶白旗");
        map.insert("152530", "内蒙古自治区正蓝旗");
        map.insert("152531", "内蒙古自治区多伦县");
        map.insert("152600", "内蒙古自治区乌兰察布盟");
        map.insert("152601", "内蒙古自治区集宁市");
        map.insert("152602", "内蒙古自治区丰镇市");
        map.insert("152621", "内蒙古自治区武川县");
        map.insert("152622", "内蒙古自治区和林格尔县");
        map.insert("152623", "内蒙古自治区清水河县");
        map.insert("152624", "内蒙古自治区卓资县");
        map.insert("152625", "内蒙古自治区化德县");
        map.insert("152626", "内蒙古自治区商都县");
        map.insert("152627", "内蒙古自治区兴和县");
        map.insert("152628", "内蒙古自治区丰镇县");
        map.insert("152629", "内蒙古自治区凉城县");
        map.insert("152630", "内蒙古自治区察哈尔右翼前旗");
        map.insert("152631", "内蒙古自治区察哈尔右翼中旗");
        map.insert("152632", "内蒙古自治区察哈尔右翼后旗");
        map.insert("152634", "内蒙古自治区四子王旗");
        map.insert("152700", "内蒙古自治区伊克昭盟");
        map.insert("152701", "内蒙古自治区东胜市");
        map.insert("152721", "内蒙古自治区东胜县");
        map.insert("152722", "内蒙古自治区达拉特旗");
        map.insert("152723", "内蒙古自治区准格尔旗");
        map.insert("152724", "内蒙古自治区鄂托克前旗");
        map.insert("152725", "内蒙古自治区鄂托克旗");
        map.insert("152726", "内蒙古自治区杭锦旗");
        map.insert("152727", "内蒙古自治区乌审旗");
        map.insert("152728", "内蒙古自治区伊金霍洛旗");
        map.insert("152800", "内蒙古自治区巴彦淖尔盟");
        map.insert("152801", "内蒙古自治区临河市");
        map.insert("152821", "内蒙古自治区临河县");
        map.insert("152822", "内蒙古自治区五原县");
        map.insert("152823", "内蒙古自治区磴口县");
        map.insert("152824", "内蒙古自治区乌拉特前旗");
        map.insert("152825", "内蒙古自治区乌拉特中旗");
        map.insert("152826", "内蒙古自治区乌拉特后旗");
        map.insert("152827", "内蒙古自治区杭锦后旗");
        map.insert("152900", "内蒙古自治区阿拉善盟");
        map.insert("152921", "内蒙古自治区阿拉善左旗");
        map.insert("152922", "内蒙古自治区阿拉善右旗");
        map.insert("152923", "内蒙古自治区额济纳旗");
        map.insert("210000", "辽宁省");
        map.insert("210100", "辽宁省沈阳市");
        map.insert("210101", "辽宁省沈阳市市辖区");
        map.insert("210102", "辽宁省沈阳市和平区");
        map.insert("210103", "辽宁省沈阳市沈河区");
        map.insert("210104", "辽宁省沈阳市大东区");
        map.insert("210105", "辽宁省沈阳市皇姑区");
        map.insert("210106", "辽宁省沈阳市铁西区");
        map.insert("210111", "辽宁省沈阳市苏家屯区");
        map.insert("210112", "辽宁省沈阳市东陵区");
        map.insert("210113", "辽宁省沈阳市新城子区");
        map.insert("210114", "辽宁省沈阳市于洪区");
        map.insert("210120", "辽宁省沈阳市区");
        map.insert("210121", "辽宁省新民县");
        map.insert("210122", "辽宁省辽中县");
        map.insert("210123", "辽宁省康平县");
        map.insert("210124", "辽宁省法库县");
        map.insert("210181", "辽宁省新民市");
        map.insert("210200", "辽宁省大连市");
        map.insert("210201", "辽宁省大连市市辖区");
        map.insert("210202", "辽宁省大连市中山区");
        map.insert("210203", "辽宁省大连市西岗区");
        map.insert("210204", "辽宁省大连市沙河口区");
        map.insert("210211", "辽宁省大连市甘井子区");
        map.insert("210212", "辽宁省大连市旅顺口区");
        map.insert("210213", "辽宁省大连市金州区");
        map.insert("210219", "辽宁省瓦房店市");
        map.insert("210220", "辽宁省大连市区");
        map.insert("210221", "辽宁省金县");
        map.insert("210222", "辽宁省新金县");
        map.insert("210223", "辽宁省复县");
        map.insert("210224", "辽宁省长海县");
        map.insert("210225", "辽宁省庄河县");
        map.insert("210281", "辽宁省瓦房店市");
        map.insert("210282", "辽宁省普兰店市");
        map.insert("210283", "辽宁省庄河市");
        map.insert("210300", "辽宁省鞍山市");
        map.insert("210301", "辽宁省鞍山市市辖区");
        map.insert("210302", "辽宁省鞍山市铁东区");
        map.insert("210303", "辽宁省鞍山市铁西区");
        map.insert("210304", "辽宁省鞍山市立山区");
        map.insert("210311", "辽宁省鞍山市千山区");
        map.insert("210319", "辽宁省海城市");
        map.insert("210320", "辽宁省鞍山市区");
        map.insert("210321", "辽宁省台安县");
        map.insert("210322", "辽宁省海城县");
        map.insert("210323", "辽宁省岫岩满族自治县");
        map.insert("210381", "辽宁省海城市");
        map.insert("210400", "辽宁省抚顺市");
        map.insert("210401", "辽宁省抚顺市市辖区");
        map.insert("210402", "辽宁省抚顺市新抚区");
        map.insert("210403", "辽宁省抚顺市东洲区");
        map.insert("210404", "辽宁省抚顺市望花区");
        map.insert("210411", "辽宁省抚顺市顺城区");
        map.insert("210420", "辽宁省抚顺市区");
        map.insert("210421", "辽宁省抚顺县");
        map.insert("210422", "辽宁省新宾满族自治县");
        map.insert("210423", "辽宁省清原满族自治县");
        map.insert("210500", "辽宁省本溪市");
        map.insert("210501", "辽宁省本溪市市辖区");
        map.insert("210502", "辽宁省本溪市平山区");
        map.insert("210503", "辽宁省本溪市溪湖区");
        map.insert("210504", "辽宁省本溪市明山区");
        map.insert("210505", "辽宁省本溪市南芬区");
        map.insert("210511", "辽宁省本溪市南芬区");
        map.insert("210520", "辽宁省本溪市区");
        map.insert("210521", "辽宁省本溪满族自治县");
        map.insert("210522", "辽宁省桓仁满族自治县");
        map.insert("210600", "辽宁省丹东市");
        map.insert("210601", "辽宁省丹东市市辖区");
        map.insert("210602", "辽宁省丹东市元宝区");
        map.insert("210603", "辽宁省丹东市振兴区");
        map.insert("210604", "辽宁省丹东市振安区");
        map.insert("210620", "辽宁省丹东市区");
        map.insert("210621", "辽宁省凤城满族自治县");
        map.insert("210622", "辽宁省岫岩满族自治县");
        map.insert("210623", "辽宁省东沟县");
        map.insert("210624", "辽宁省宽甸满族自治县");
        map.insert("210681", "辽宁省东港市");
        map.insert("210682", "辽宁省凤城市");
        map.insert("210700", "辽宁省锦州市");
        map.insert("210701", "辽宁省锦州市市辖区");
        map.insert("210702", "辽宁省锦州市古塔区");
        map.insert("210703", "辽宁省锦州市凌河区");
        map.insert("210704", "辽宁省锦州市南票区");
        map.insert("210705", "辽宁省锦州市葫芦岛区");
        map.insert("210711", "辽宁省锦州市太和区");
        map.insert("210719", "辽宁省锦西市");
        map.insert("210720", "辽宁省锦州市区");
        map.insert("210721", "辽宁省锦西县");
        map.insert("210722", "辽宁省兴城县");
        map.insert("210723", "辽宁省绥中县");
        map.insert("210724", "辽宁省锦县");
        map.insert("210725", "辽宁省北镇满族自治县");
        map.insert("210726", "辽宁省黑山县");
        map.insert("210727", "辽宁省义县");
        map.insert("210781", "辽宁省凌海市");
        map.insert("210782", "辽宁省北宁市");
        map.insert("210800", "辽宁省营口市");
        map.insert("210801", "辽宁省营口市市辖区");
        map.insert("210802", "辽宁省营口市站前区");
        map.insert("210803", "辽宁省营口市西市区");
        map.insert("210804", "辽宁省营口市鲅鱼圈区");
        map.insert("210811", "辽宁省营口市老边区");
        map.insert("210812", "辽宁省营口市鲅鱼圈区");
        map.insert("210820", "辽宁省营口市区");
        map.insert("210821", "辽宁省营口县");
        map.insert("210822", "辽宁省盘山县");
        map.insert("210823", "辽宁省大洼县");
        map.insert("210824", "辽宁省盖县");
        map.insert("210881", "辽宁省盖州市");
        map.insert("210882", "辽宁省大石桥市");
        map.insert("210900", "辽宁省阜新市");
        map.insert("210901", "辽宁省阜新市市辖区");
        map.insert("210902", "辽宁省阜新市海州区");
        map.insert("210903", "辽宁省阜新市新邱区");
        map.insert("210904", "辽宁省阜新市太平区");
        map.insert("210905", "辽宁省阜新市清河门区");
        map.insert("210911", "辽宁省阜新市细河区");
        map.insert("210920", "辽宁省阜新市区");
        map.insert("210921", "辽宁省阜新蒙古族自治县");
        map.insert("210922", "辽宁省彰武县");
        map.insert("211000", "辽宁省辽阳市");
        map.insert("211001", "辽宁省辽阳市市辖区");
        map.insert("211002", "辽宁省辽阳市白塔区");
        map.insert("211003", "辽宁省辽阳市文圣区");
        map.insert("211004", "辽宁省辽阳市宏伟区");
        map.insert("211005", "辽宁省辽阳市弓长岭区");
        map.insert("211011", "辽宁省辽阳市太子河区");
        map.insert("211020", "辽宁省辽阳市区");
        map.insert("211021", "辽宁省辽阳县");
        map.insert("211022", "辽宁省灯塔县");
        map.insert("211081", "辽宁省灯塔市");
        map.insert("211100", "辽宁省盘锦市");
        map.insert("211101", "辽宁省盘锦市市辖区");
        map.insert("211102", "辽宁省盘锦市双台子区");
        map.insert("211103", "辽宁省盘锦市兴隆台区");
        map.insert("211111", "辽宁省盘锦市郊区");
        map.insert("211121", "辽宁省大洼县");
        map.insert("211122", "辽宁省盘山县");
        map.insert("211200", "辽宁省铁岭市");
        map.insert("211201", "辽宁省铁岭市市辖区");
        map.insert("211202", "辽宁省铁岭市银州区");
        map.insert("211203", "辽宁省铁岭市铁法区");
        map.insert("211204", "辽宁省铁岭市清河区");
        map.insert("211221", "辽宁省铁岭县");
        map.insert("211222", "辽宁省开原县");
        map.insert("211223", "辽宁省西丰县");
        map.insert("211224", "辽宁省昌图县");
        map.insert("211225", "辽宁省康平县");
        map.insert("211226", "辽宁省法库县");
        map.insert("211281", "辽宁省调兵山市");
        map.insert("211282", "辽宁省开原市");
        map.insert("211300", "辽宁省朝阳市");
        map.insert("211301", "辽宁省朝阳市市辖区");
        map.insert("211302", "辽宁省朝阳市双塔区");
        map.insert("211303", "辽宁省朝阳市龙城区");
        map.insert("211319", "辽宁省北票市");
        map.insert("211321", "辽宁省朝阳县");
        map.insert("211322", "辽宁省建平县");
        map.insert("211323", "辽宁省凌源县");
        map.insert("211324", "辽宁省喀喇沁左翼蒙古族自治县");
        map.insert("211325", "辽宁省建昌县");
        map.insert("211326", "辽宁省北票县");
        map.insert("211381", "辽宁省北票市");
        map.insert("211382", "辽宁省凌源市");
        map.insert("211400", "辽宁省葫芦岛市");
        map.insert("211401", "辽宁省葫芦岛市市辖区");
        map.insert("211402", "辽宁省葫芦岛市连山区");
        map.insert("211403", "辽宁省葫芦岛市龙港区");
        map.insert("211404", "辽宁省葫芦岛市南票区");
        map.insert("211421", "辽宁省绥中县");
        map.insert("211422", "辽宁省建昌县");
        map.insert("211481", "辽宁省兴城市");
        map.insert("212100", "辽宁省铁岭地区");
        map.insert("212101", "辽宁省铁岭市");
        map.insert("212102", "辽宁省铁法市");
        map.insert("212121", "辽宁省铁岭县");
        map.insert("212122", "辽宁省开原县");
        map.insert("212123", "辽宁省西丰县");
        map.insert("212124", "辽宁省昌图县");
        map.insert("212125", "辽宁省康平县");
        map.insert("212126", "辽宁省法库县");
        map.insert("212200", "辽宁省朝阳地区");
        map.insert("212201", "辽宁省朝阳市");
        map.insert("212221", "辽宁省朝阳县");
        map.insert("212222", "辽宁省建平县");
        map.insert("212223", "辽宁省凌源县");
        map.insert("212224", "辽宁省喀啦沁左翼蒙古族自治县");
        map.insert("212225", "辽宁省建昌县");
        map.insert("212226", "辽宁省北票县");
        map.insert("219001", "辽宁省瓦房店市");
        map.insert("219002", "辽宁省海城市");
        map.insert("219003", "辽宁省锦西市");
        map.insert("219004", "辽宁省兴城市");
        map.insert("219005", "辽宁省铁法市");
        map.insert("219006", "辽宁省北票市");
        map.insert("219007", "辽宁省开原市");
        map.insert("220000", "吉林省");
        map.insert("220100", "吉林省长春市");
        map.insert("220101", "吉林省长春市市辖区");
        map.insert("220102", "吉林省长春市南关区");
        map.insert("220103", "吉林省长春市宽城区");
        map.insert("220104", "吉林省长春市朝阳区");
        map.insert("220105", "吉林省长春市二道区");
        map.insert("220106", "吉林省长春市绿园区");
        map.insert("220111", "吉林省长春市郊区");
        map.insert("220112", "吉林省长春市双阳区");
        map.insert("220120", "吉林省长春市区");
        map.insert("220121", "吉林省榆树县");
        map.insert("220122", "吉林省农安县");
        map.insert("220123", "吉林省九台县");
        map.insert("220124", "吉林省德惠县");
        map.insert("220125", "吉林省双阳县");
        map.insert("220181", "吉林省九台市");
        map.insert("220182", "吉林省榆树市");
        map.insert("220183", "吉林省德惠市");
        map.insert("220200", "吉林省吉林市");
        map.insert("220201", "吉林省吉林市市辖区");
        map.insert("220202", "吉林省吉林市昌邑区");
        map.insert("220203", "吉林省吉林市龙潭区");
        map.insert("220204", "吉林省吉林市船营区");
        map.insert("220211", "吉林省吉林市丰满区");
        map.insert("220220", "吉林省吉林市区");
        map.insert("220221", "吉林省永吉县");
        map.insert("220222", "吉林省舒兰县");
        map.insert("220223", "吉林省磐石县");
        map.insert("220224", "吉林省蛟河县");
        map.insert("220225", "吉林省桦甸县");
        map.insert("220281", "吉林省蛟河市");
        map.insert("220282", "吉林省桦甸市");
        map.insert("220283", "吉林省舒兰市");
        map.insert("220284", "吉林省磐石市");
        map.insert("220300", "吉林省四平市");
        map.insert("220301", "吉林省四平市市辖区");
        map.insert("220302", "吉林省四平市铁西区");
        map.insert("220303", "吉林省四平市铁东区");
        map.insert("220319", "吉林省公主岭市");
        map.insert("220321", "吉林省怀德县");
        map.insert("220322", "吉林省梨树县");
        map.insert("220323", "吉林省伊通满族自治县");
        map.insert("220324", "吉林省双辽县");
        map.insert("220381", "吉林省公主岭市");
        map.insert("220382", "吉林省双辽市");
        map.insert("220400", "吉林省辽源市");
        map.insert("220401", "吉林省辽源市市辖区");
        map.insert("220402", "吉林省辽源市龙山区");
        map.insert("220403", "吉林省辽源市西安区");
        map.insert("220421", "吉林省东丰县");
        map.insert("220422", "吉林省东辽县");
        map.insert("220500", "吉林省通化市");
        map.insert("220501", "吉林省通化市市辖区");
        map.insert("220502", "吉林省通化市东昌区");
        map.insert("220503", "吉林省通化市二道江区");
        map.insert("220519", "吉林省梅河口市");
        map.insert("220521", "吉林省通化县");
        map.insert("220522", "吉林省集安县");
        map.insert("220523", "吉林省辉南县");
        map.insert("220524", "吉林省柳河县");
        map.insert("220581", "吉林省梅河口市");
        map.insert("220582", "吉林省集安市");
        map.insert("220600", "吉林省白山市");
        map.insert("220601", "吉林省白山市市辖区");
        map.insert("220602", "吉林省白山市八道江区");
        map.insert("220603", "吉林省浑江市三岔子区");
        map.insert("220604", "吉林省浑江市临江区");
        map.insert("220621", "吉林省抚松县");
        map.insert("220622", "吉林省靖宇县");
        map.insert("220623", "吉林省长白朝鲜族自治县");
        map.insert("220624", "吉林省临江县");
        map.insert("220625", "吉林省江源县");
        map.insert("220681", "吉林省临江市");
        map.insert("220700", "吉林省松原市");
        map.insert("220701", "吉林省松原市市辖区");
        map.insert("220702", "吉林省松原市宁江区");
        map.insert("220721", "吉林省前郭尔罗斯蒙古族自治县");
        map.insert("220722", "吉林省长岭县");
        map.insert("220723", "吉林省乾安县");
        map.insert("220724", "吉林省扶余县");
        map.insert("220800", "吉林省白城市");
        map.insert("220801", "吉林省白城市市辖区");
        map.insert("220802", "吉林省白城市洮北区");
        map.insert("220821", "吉林省镇赉县");
        map.insert("220822", "吉林省通榆县");
        map.insert("220881", "吉林省洮南市");
        map.insert("220882", "吉林省大安市");
        map.insert("222100", "吉林省四平地区");
        map.insert("222101", "吉林省四平市");
        map.insert("222102", "吉林省辽源市");
        map.insert("222121", "吉林省怀德县");
        map.insert("222122", "吉林省梨树县");
        map.insert("222123", "吉林省伊通县");
        map.insert("222124", "吉林省东丰县");
        map.insert("222125", "吉林省双辽县");
        map.insert("222200", "吉林省通化地区");
        map.insert("222201", "吉林省通化市");
        map.insert("222202", "吉林省浑江市");
        map.insert("222221", "吉林省海龙县");
        map.insert("222222", "吉林省通化县");
        map.insert("222223", "吉林省柳河县");
        map.insert("222224", "吉林省辉南县");
        map.insert("222225", "吉林省集安县");
        map.insert("222226", "吉林省抚松县");
        map.insert("222227", "吉林省靖宇县");
        map.insert("222228", "吉林省长白朝鲜族自治县");
        map.insert("222300", "吉林省白城地区");
        map.insert("222301", "吉林省白城市");
        map.insert("222302", "吉林省洮南市");
        map.insert("222303", "吉林省扶余市");
        map.insert("222304", "吉林省大安市");
        map.insert("222321", "吉林省扶余县");
        map.insert("222322", "吉林省洮安县");
        map.insert("222323", "吉林省长岭县");
        map.insert("222324", "吉林省前郭尔罗斯蒙古族自治县");
        map.insert("222325", "吉林省大安县");
        map.insert("222326", "吉林省镇赉县");
        map.insert("222327", "吉林省通榆县");
        map.insert("222328", "吉林省乾安县");
        map.insert("222400", "吉林省延边朝鲜族自治州");
        map.insert("222401", "吉林省延吉市");
        map.insert("222402", "吉林省图们市");
        map.insert("222403", "吉林省敦化市");
        map.insert("222404", "吉林省珲春市");
        map.insert("222405", "吉林省龙井市");
        map.insert("222406", "吉林省和龙市");
        map.insert("222421", "吉林省龙井县");
        map.insert("222422", "吉林省敦化县");
        map.insert("222423", "吉林省和龙县");
        map.insert("222424", "吉林省汪清县");
        map.insert("222425", "吉林省珲春县");
        map.insert("222426", "吉林省安图县");
        map.insert("229000", "吉林省省直辖行政单位");
        map.insert("229001", "吉林省公主岭市");
        map.insert("229002", "吉林省梅河口市");
        map.insert("229003", "吉林省集安市");
        map.insert("229004", "吉林省桦甸市");
        map.insert("229005", "吉林省九台市");
        map.insert("230000", "黑龙江省");
        map.insert("230100", "黑龙江省哈尔滨市");
        map.insert("230101", "黑龙江省哈尔滨市市辖区");
        map.insert("230102", "黑龙江省哈尔滨市道里区");
        map.insert("230103", "黑龙江省哈尔滨市南岗区");
        map.insert("230104", "黑龙江省哈尔滨市道外区");
        map.insert("230105", "黑龙江省哈尔滨市太平区");
        map.insert("230106", "黑龙江省哈尔滨市香坊区");
        map.insert("230107", "黑龙江省哈尔滨市动力区");
        map.insert("230108", "黑龙江省哈尔滨市平房区");
        map.insert("230109", "黑龙江省哈尔滨市松北区");
        map.insert("230111", "黑龙江省哈尔滨市呼兰区");
        map.insert("230121", "黑龙江省呼兰县");
        map.insert("230122", "黑龙江省阿城县");
        map.insert("230123", "黑龙江省依兰县");
        map.insert("230124", "黑龙江省方正县");
        map.insert("230125", "黑龙江省宾县");
        map.insert("230126", "黑龙江省巴彦县");
        map.insert("230127", "黑龙江省木兰县");
        map.insert("230128", "黑龙江省通河县");
        map.insert("230129", "黑龙江省延寿县");
        map.insert("230181", "黑龙江省阿城市");
        map.insert("230182", "黑龙江省双城市");
        map.insert("230183", "黑龙江省尚志市");
        map.insert("230184", "黑龙江省五常市");
        map.insert("230200", "黑龙江省齐齐哈尔市");
        map.insert("230201", "黑龙江省齐齐哈尔市市辖区");
        map.insert("230202", "黑龙江省齐齐哈尔市龙沙区");
        map.insert("230203", "黑龙江省齐齐哈尔市建华区");
        map.insert("230204", "黑龙江省齐齐哈尔市铁锋区");
        map.insert("230205", "黑龙江省齐齐哈尔市昂昂溪区");
        map.insert("230206", "黑龙江省齐齐哈尔市富拉尔基区");
        map.insert("230207", "黑龙江省齐齐哈尔市碾子山区");
        map.insert("230208", "黑龙江省齐齐哈尔市梅里斯达斡尔族区");
        map.insert("230221", "黑龙江省龙江县");
        map.insert("230222", "黑龙江省讷河县");
        map.insert("230223", "黑龙江省依安县");
        map.insert("230224", "黑龙江省泰来县");
        map.insert("230225", "黑龙江省甘南县");
        map.insert("230226", "黑龙江省杜尔伯特蒙古族自治县");
        map.insert("230227", "黑龙江省富裕县");
        map.insert("230228", "黑龙江省林甸县");
        map.insert("230229", "黑龙江省克山县");
        map.insert("230230", "黑龙江省克东县");
        map.insert("230231", "黑龙江省拜泉县");
        map.insert("230281", "黑龙江省讷河市");
        map.insert("230300", "黑龙江省鸡西市");
        map.insert("230301", "黑龙江省鸡西市市辖区");
        map.insert("230302", "黑龙江省鸡西市鸡冠区");
        map.insert("230303", "黑龙江省鸡西市恒山区");
        map.insert("230304", "黑龙江省鸡西市滴道区");
        map.insert("230305", "黑龙江省鸡西市梨树区");
        map.insert("230306", "黑龙江省鸡西市城子河区");
        map.insert("230307", "黑龙江省鸡西市麻山区");
        map.insert("230321", "黑龙江省鸡东县");
        map.insert("230322", "黑龙江省虎林县");
        map.insert("230381", "黑龙江省虎林市");
        map.insert("230382", "黑龙江省密山市");
        map.insert("230400", "黑龙江省鹤岗市");
        map.insert("230401", "黑龙江省鹤岗市市辖区");
        map.insert("230402", "黑龙江省鹤岗市向阳区");
        map.insert("230403", "黑龙江省鹤岗市工农区");
        map.insert("230404", "黑龙江省鹤岗市南山区");
        map.insert("230405", "黑龙江省鹤岗市兴安区");
        map.insert("230406", "黑龙江省鹤岗市东山区");
        map.insert("230407", "黑龙江省鹤岗市兴山区");
        map.insert("230421", "黑龙江省萝北县");
        map.insert("230422", "黑龙江省绥滨县");
        map.insert("230500", "黑龙江省双鸭山市");
        map.insert("230501", "黑龙江省双鸭山市市辖区");
        map.insert("230502", "黑龙江省双鸭山市尖山区");
        map.insert("230503", "黑龙江省双鸭山市岭东区");
        map.insert("230504", "黑龙江省双鸭山市岭西区");
        map.insert("230505", "黑龙江省双鸭山市四方台区");
        map.insert("230506", "黑龙江省双鸭山市宝山区");
        map.insert("230521", "黑龙江省集贤县");
        map.insert("230522", "黑龙江省友谊县");
        map.insert("230523", "黑龙江省宝清县");
        map.insert("230524", "黑龙江省饶河县");
        map.insert("230600", "黑龙江省大庆市");
        map.insert("230601", "黑龙江省大庆市市辖区");
        map.insert("230602", "黑龙江省大庆市萨尔图区");
        map.insert("230603", "黑龙江省大庆市龙凤区");
        map.insert("230604", "黑龙江省大庆市让胡路区");
        map.insert("230605", "黑龙江省大庆市红岗区");
        map.insert("230606", "黑龙江省大庆市大同区");
        map.insert("230621", "黑龙江省肇州县");
        map.insert("230622", "黑龙江省肇源县");
        map.insert("230623", "黑龙江省林甸县");
        map.insert("230624", "黑龙江省杜尔伯特蒙古族自治县");
        map.insert("230700", "黑龙江省伊春市");
        map.insert("230701", "黑龙江省伊春市市辖区");
        map.insert("230702", "黑龙江省伊春市伊春区");
        map.insert("230703", "黑龙江省伊春市南岔区");
        map.insert("230704", "黑龙江省伊春市友好区");
        map.insert("230705", "黑龙江省伊春市西林区");
        map.insert("230706", "黑龙江省伊春市翠峦区");
        map.insert("230707", "黑龙江省伊春市新青区");
        map.insert("230708", "黑龙江省伊春市美溪区");
        map.insert("230709", "黑龙江省伊春市金山屯区");
        map.insert("230710", "黑龙江省伊春市五营区");
        map.insert("230711", "黑龙江省伊春市乌马河区");
        map.insert("230712", "黑龙江省伊春市汤旺河区");
        map.insert("230713", "黑龙江省伊春市带岭区");
        map.insert("230714", "黑龙江省伊春市乌伊岭区");
        map.insert("230715", "黑龙江省伊春市红星区");
        map.insert("230716", "黑龙江省伊春市上甘岭区");
        map.insert("230720", "黑龙江省伊春地区");
        map.insert("230721", "黑龙江省铁力县");
        map.insert("230722", "黑龙江省嘉荫县");
        map.insert("230781", "黑龙江省铁力市");
        map.insert("230800", "黑龙江省佳木斯市");
        map.insert("230801", "黑龙江省佳木斯市市辖区");
        map.insert("230802", "黑龙江省佳木斯市永红区");
        map.insert("230803", "黑龙江省佳木斯市向阳区");
        map.insert("230804", "黑龙江省佳木斯市前进区");
        map.insert("230805", "黑龙江省佳木斯市东风区");
        map.insert("230811", "黑龙江省佳木斯市郊区");
        map.insert("230821", "黑龙江省富锦县");
        map.insert("230822", "黑龙江省桦南县");
        map.insert("230823", "黑龙江省依兰县");
        map.insert("230825", "黑龙江省集贤县");
        map.insert("230826", "黑龙江省桦川县");
        map.insert("230827", "黑龙江省宝清县");
        map.insert("230828", "黑龙江省汤原县");
        map.insert("230829", "黑龙江省绥滨县");
        map.insert("230830", "黑龙江省萝北县");
        map.insert("230831", "黑龙江省同江县");
        map.insert("230832", "黑龙江省饶河县");
        map.insert("230833", "黑龙江省抚远县");
        map.insert("230834", "黑龙江省友谊县");
        map.insert("230881", "黑龙江省同江市");
        map.insert("230882", "黑龙江省富锦市");
        map.insert("230900", "黑龙江省七台河市");
        map.insert("230901", "黑龙江省七台河市市辖区");
        map.insert("230902", "黑龙江省七台河市新兴区");
        map.insert("230903", "黑龙江省七台河市桃山区");
        map.insert("230904", "黑龙江省七台河市茄子河区");
        map.insert("230921", "黑龙江省勃利县");
        map.insert("231000", "黑龙江省牡丹江市");
        map.insert("231001", "黑龙江省牡丹江市市辖区");
        map.insert("231002", "黑龙江省牡丹江市东安区");
        map.insert("231003", "黑龙江省牡丹江市阳明区");
        map.insert("231004", "黑龙江省牡丹江市爱民区");
        map.insert("231005", "黑龙江省牡丹江市西安区");
        map.insert("231011", "黑龙江省牡丹江市郊区");
        map.insert("231020", "黑龙江省绥芬河市");
        map.insert("231021", "黑龙江省宁安县");
        map.insert("231022", "黑龙江省海林县");
        map.insert("231023", "黑龙江省穆棱县");
        map.insert("231024", "黑龙江省东宁县");
        map.insert("231025", "黑龙江省林口县");
        map.insert("231026", "黑龙江省密山县");
        map.insert("231027", "黑龙江省虎林县");
        map.insert("231081", "黑龙江省绥芬河市");
        map.insert("231082", "黑龙江省密山市");
        map.insert("231083", "黑龙江省海林市");
        map.insert("231084", "黑龙江省宁安市");
        map.insert("231085", "黑龙江省穆棱市");
        map.insert("231100", "黑龙江省黑河市");
        map.insert("231101", "黑龙江省黑河市市辖区");
        map.insert("231102", "黑龙江省黑河市爱辉区");
        map.insert("231121", "黑龙江省嫩江县");
        map.insert("231122", "黑龙江省德都县");
        map.insert("231123", "黑龙江省逊克县");
        map.insert("231124", "黑龙江省孙吴县");
        map.insert("231181", "黑龙江省北安市");
        map.insert("231182", "黑龙江省五大连池市");
        map.insert("231200", "黑龙江省绥化市");
        map.insert("231201", "黑龙江省绥化市市辖区");
        map.insert("231202", "黑龙江省绥化市北林区");
        map.insert("231221", "黑龙江省望奎县");
        map.insert("231222", "黑龙江省兰西县");
        map.insert("231223", "黑龙江省青冈县");
        map.insert("231224", "黑龙江省庆安县");
        map.insert("231225", "黑龙江省明水县");
        map.insert("231226", "黑龙江省绥棱县");
        map.insert("231281", "黑龙江省安达市");
        map.insert("231282", "黑龙江省肇东市");
        map.insert("231283", "黑龙江省海伦市");
        map.insert("232100", "黑龙江省松花江地区");
        map.insert("232101", "黑龙江省双城市");
        map.insert("232102", "黑龙江省尚志市");
        map.insert("232103", "黑龙江省五常市");
        map.insert("232121", "黑龙江省阿城县");
        map.insert("232122", "黑龙江省宾县");
        map.insert("232123", "黑龙江省呼兰县");
        map.insert("232124", "黑龙江省双城县");
        map.insert("232125", "黑龙江省五常县");
        map.insert("232126", "黑龙江省巴彦县");
        map.insert("232127", "黑龙江省木兰县");
        map.insert("232128", "黑龙江省通河县");
        map.insert("232129", "黑龙江省尚志县");
        map.insert("232130", "黑龙江省方正县");
        map.insert("232131", "黑龙江省延寿县");
        map.insert("232200", "黑龙江省嫩江地区");
        map.insert("232221", "黑龙江省龙江县");
        map.insert("232222", "黑龙江省讷河县");
        map.insert("232223", "黑龙江省依安县");
        map.insert("232224", "黑龙江省泰来县");
        map.insert("232225", "黑龙江省甘南县");
        map.insert("232226", "黑龙江省杜尔伯特蒙古族自治县");
        map.insert("232227", "黑龙江省富裕县");
        map.insert("232228", "黑龙江省林甸县");
        map.insert("232229", "黑龙江省克山县");
        map.insert("232230", "黑龙江省克东县");
        map.insert("232231", "黑龙江省拜泉县");
        map.insert("232300", "黑龙江省绥化地区");
        map.insert("232301", "黑龙江省绥化市");
        map.insert("232302", "黑龙江省安达市");
        map.insert("232303", "黑龙江省肇东市");
        map.insert("232304", "黑龙江省海伦市");
        map.insert("232321", "黑龙江省海伦县");
        map.insert("232322", "黑龙江省肇东县");
        map.insert("232323", "黑龙江省绥化县");
        map.insert("232324", "黑龙江省望奎县");
        map.insert("232325", "黑龙江省兰西县");
        map.insert("232326", "黑龙江省青冈县");
        map.insert("232327", "黑龙江省安达县");
        map.insert("232328", "黑龙江省肇源县");
        map.insert("232329", "黑龙江省肇州县");
        map.insert("232330", "黑龙江省庆安县");
        map.insert("232331", "黑龙江省明水县");
        map.insert("232332", "黑龙江省绥棱县");
        map.insert("232400", "黑龙江省合江地区");
        map.insert("232401", "黑龙江省佳木斯市");
        map.insert("232402", "黑龙江省七台河市");
        map.insert("232421", "黑龙江省富锦县");
        map.insert("232422", "黑龙江省桦南县");
        map.insert("232423", "黑龙江省依兰县");
        map.insert("232424", "黑龙江省勃利县");
        map.insert("232425", "黑龙江省集贤县");
        map.insert("232426", "黑龙江省桦川县");
        map.insert("232427", "黑龙江省宝清县");
        map.insert("232428", "黑龙江省汤源县");
        map.insert("232429", "黑龙江省绥滨县");
        map.insert("232430", "黑龙江省萝北县");
        map.insert("232431", "黑龙江省同江县");
        map.insert("232432", "黑龙江省饶河县");
        map.insert("232433", "黑龙江省抚远县");
        map.insert("232500", "黑龙江省牡丹江地区");
        map.insert("232501", "黑龙江省牡丹江市");
        map.insert("232502", "黑龙江省绥芬河市");
        map.insert("232521", "黑龙江省宁安县");
        map.insert("232522", "黑龙江省海林县");
        map.insert("232523", "黑龙江省穆棱县");
        map.insert("232524", "黑龙江省东宁县");
        map.insert("232525", "黑龙江省林口县");
        map.insert("232526", "黑龙江省鸡东县");
        map.insert("232527", "黑龙江省密山县");
        map.insert("232528", "黑龙江省虎林县");
        map.insert("232600", "黑龙江省黑河地区");
        map.insert("232601", "黑龙江省黑河市");
        map.insert("232602", "黑龙江省北安市");
        map.insert("232603", "黑龙江省五大连池市");
        map.insert("232621", "黑龙江省北安县");
        map.insert("232622", "黑龙江省嫩江县");
        map.insert("232623", "黑龙江省德都县");
        map.insert("232624", "黑龙江省爱辉县");
        map.insert("232625", "黑龙江省逊克县");
        map.insert("232626", "黑龙江省孙吴县");
        map.insert("232700", "黑龙江省大兴安岭地区");
        map.insert("232721", "黑龙江省呼玛县");
        map.insert("232722", "黑龙江省塔河县");
        map.insert("232723", "黑龙江省漠河县");
        map.insert("239000", "黑龙江省省直辖行政单位");
        map.insert("239001", "黑龙江省绥芬河市");
        map.insert("239002", "黑龙江省阿城市");
        map.insert("239003", "黑龙江省同江市");
        map.insert("239004", "黑龙江省富锦市");
        map.insert("239005", "黑龙江省铁力市");
        map.insert("239006", "黑龙江省密山市");
        map.insert("310000", "上海市");
        map.insert("310100", "上海市市辖区");
        map.insert("310101", "上海市黄浦区");
        map.insert("310102", "上海市南市区");
        map.insert("310103", "上海市卢湾区");
        map.insert("310104", "上海市徐汇区");
        map.insert("310105", "上海市长宁区");
        map.insert("310106", "上海市静安区");
        map.insert("310107", "上海市普陀区");
        map.insert("310108", "上海市闸北区");
        map.insert("310109", "上海市虹口区");
        map.insert("310110", "上海市杨浦区");
        map.insert("310111", "上海市吴淞区");
        map.insert("310112", "上海市闵行区");
        map.insert("310113", "上海市宝山区");
        map.insert("310114", "上海市嘉定区");
        map.insert("310115", "上海市浦东新区");
        map.insert("310116", "上海市金山区");
        map.insert("310117", "上海市松江区");
        map.insert("310118", "上海市青浦区");
        map.insert("310119", "上海市南汇区");
        map.insert("310120", "上海市奉贤区");
        map.insert("310221", "上海市上海县");
        map.insert("310222", "上海市嘉定县");
        map.insert("310223", "上海市宝山县");
        map.insert("310224", "上海市川沙县");
        map.insert("310225", "上海市南汇县");
        map.insert("310226", "上海市奉贤县");
        map.insert("310227", "上海市松江县");
        map.insert("310228", "上海市金山县");
        map.insert("310229", "上海市青浦县");
        map.insert("310230", "上海市崇明县");
        map.insert("320000", "江苏省");
        map.insert("320100", "江苏省南京市");
        map.insert("320101", "江苏省南京市市辖区");
        map.insert("320102", "江苏省南京市玄武区");
        map.insert("320103", "江苏省南京市白下区");
        map.insert("320104", "江苏省南京市秦淮区");
        map.insert("320105", "江苏省南京市建邺区");
        map.insert("320106", "江苏省南京市鼓楼区");
        map.insert("320107", "江苏省南京市下关区");
        map.insert("320111", "江苏省南京市浦口区");
        map.insert("320112", "江苏省南京市大厂区");
        map.insert("320113", "江苏省南京市栖霞区");
        map.insert("320114", "江苏省南京市雨花台区");
        map.insert("320115", "江苏省南京市江宁区");
        map.insert("320116", "江苏省南京市六合区");
        map.insert("320120", "江苏省南京市区");
        map.insert("320121", "江苏省江宁县");
        map.insert("320122", "江苏省江浦县");
        map.insert("320123", "江苏省六合县");
        map.insert("320124", "江苏省溧水县");
        map.insert("320125", "江苏省高淳县");
        map.insert("320200", "江苏省无锡市");
        map.insert("320201", "江苏省无锡市市辖区");
        map.insert("320202", "江苏省无锡市崇安区");
        map.insert("320203", "江苏省无锡市南长区");
        map.insert("320204", "江苏省无锡市北塘区");
        map.insert("320205", "江苏省无锡市锡山区");
        map.insert("320206", "江苏省无锡市惠山区");
        map.insert("320211", "江苏省无锡市滨湖区");
        map.insert("320212", "江苏省无锡市马山区");
        map.insert("320221", "江苏省江阴县");
        map.insert("320222", "江苏省无锡县");
        map.insert("320223", "江苏省宜兴县");
        map.insert("320281", "江苏省江阴市");
        map.insert("320282", "江苏省宜兴市");
        map.insert("320283", "江苏省锡山市");
        map.insert("320300", "江苏省徐州市");
        map.insert("320301", "江苏省徐州市市辖区");
        map.insert("320302", "江苏省徐州市鼓楼区");
        map.insert("320303", "江苏省徐州市云龙区");
        map.insert("320304", "江苏省徐州市九里区");
        map.insert("320305", "江苏省徐州市贾汪区");
        map.insert("320311", "江苏省徐州市泉山区");
        map.insert("320321", "江苏省丰县");
        map.insert("320322", "江苏省沛县");
        map.insert("320323", "江苏省铜山县");
        map.insert("320324", "江苏省睢宁县");
        map.insert("320325", "江苏省邳县");
        map.insert("320326", "江苏省新沂县");
        map.insert("320381", "江苏省新沂市");
        map.insert("320382", "江苏省邳州市");
        map.insert("320400", "江苏省常州市");
        map.insert("320401", "江苏省常州市市辖区");
        map.insert("320402", "江苏省常州市天宁区");
        map.insert("320403", "江苏省常州市广化区");
        map.insert("320404", "江苏省常州市钟楼区");
        map.insert("320405", "江苏省常州市戚墅堰区");
        map.insert("320411", "江苏省常州市新北区");
        map.insert("320412", "江苏省常州市武进区");
        map.insert("320421", "江苏省武进县");
        map.insert("320422", "江苏省金坛县");
        map.insert("320423", "江苏省溧阳县");
        map.insert("320481", "江苏省溧阳市");
        map.insert("320482", "江苏省金坛市");
        map.insert("320483", "江苏省武进市");
        map.insert("320500", "江苏省苏州市");
        map.insert("320501", "江苏省苏州市市辖区");
        map.insert("320502", "江苏省苏州市沧浪区");
        map.insert("320503", "江苏省苏州市平江区");
        map.insert("320504", "江苏省苏州市金阊区");
        map.insert("320505", "江苏省苏州市虎丘区");
        map.insert("320506", "江苏省苏州市吴中区");
        map.insert("320507", "江苏省苏州市相城区");
        map.insert("320511", "江苏省苏州市郊区");
        map.insert("320520", "江苏省常熟市");
        map.insert("320521", "江苏省沙洲县");
        map.insert("320522", "江苏省太仓县");
        map.insert("320523", "江苏省昆山县");
        map.insert("320524", "江苏省吴县");
        map.insert("320525", "江苏省吴江县");
        map.insert("320581", "江苏省常熟市");
        map.insert("320582", "江苏省张家港市");
        map.insert("320583", "江苏省昆山市");
        map.insert("320584", "江苏省吴江市");
        map.insert("320585", "江苏省太仓市");
        map.insert("320586", "江苏省吴县市");
        map.insert("320600", "江苏省南通市");
        map.insert("320601", "江苏省南通市市辖区");
        map.insert("320602", "江苏省南通市崇川区");
        map.insert("320611", "江苏省南通市港闸区");
        map.insert("320621", "江苏省海安县");
        map.insert("320622", "江苏省如皋县");
        map.insert("320623", "江苏省如东县");
        map.insert("320624", "江苏省南通县");
        map.insert("320625", "江苏省海门县");
        map.insert("320626", "江苏省启东县");
        map.insert("320681", "江苏省启东市");
        map.insert("320682", "江苏省如皋市");
        map.insert("320683", "江苏省通州市");
        map.insert("320684", "江苏省海门市");
        map.insert("320700", "江苏省连云港市");
        map.insert("320701", "江苏省连云港市市辖区");
        map.insert("320702", "江苏省连云港市新海区");
        map.insert("320703", "江苏省连云港市连云区");
        map.insert("320704", "江苏省连云港市云台区");
        map.insert("320705", "江苏省连云港市新浦区");
        map.insert("320706", "江苏省连云港市海州区");
        map.insert("320721", "江苏省赣榆县");
        map.insert("320722", "江苏省东海县");
        map.insert("320723", "江苏省灌云县");
        map.insert("320724", "江苏省灌南县");
        map.insert("320800", "江苏省淮安市");
        map.insert("320801", "江苏省淮安市市辖区");
        map.insert("320802", "江苏省淮安市清河区");
        map.insert("320803", "江苏省淮安市楚州区");
        map.insert("320804", "江苏省淮安市淮阴区");
        map.insert("320811", "江苏省淮安市清浦区");
        map.insert("320821", "江苏省淮阴县");
        map.insert("320822", "江苏省灌南县");
        map.insert("320823", "江苏省沭阳县");
        map.insert("320824", "江苏省宿迁县");
        map.insert("320825", "江苏省泗阳县");
        map.insert("320826", "江苏省涟水县");
        map.insert("320827", "江苏省泗洪县");
        map.insert("320828", "江苏省淮安县");
        map.insert("320829", "江苏省洪泽县");
        map.insert("320830", "江苏省盱眙县");
        map.insert("320831", "江苏省金湖县");
        map.insert("320881", "江苏省宿迁市");
        map.insert("320882", "江苏省淮安市");
        map.insert("320900", "江苏省盐城市");
        map.insert("320901", "江苏省盐城市市辖区");
        map.insert("320902", "江苏省盐城市亭湖区");
        map.insert("320903", "江苏省盐城市盐都区");
        map.insert("320911", "江苏省盐城市郊区");
        map.insert("320921", "江苏省响水县");
        map.insert("320922", "江苏省滨海县");
        map.insert("320923", "江苏省阜宁县");
        map.insert("320924", "江苏省射阳县");
        map.insert("320925", "江苏省建湖县");
        map.insert("320926", "江苏省大丰县");
        map.insert("320927", "江苏省东台县");
        map.insert("320928", "江苏省盐都县");
        map.insert("320981", "江苏省东台市");
        map.insert("320982", "江苏省大丰市");
        map.insert("321000", "江苏省扬州市");
        map.insert("321001", "江苏省扬州市市辖区");
        map.insert("321002", "江苏省扬州市广陵区");
        map.insert("321003", "江苏省扬州市邗江区");
        map.insert("321011", "江苏省扬州市郊区");
        map.insert("321019", "江苏省仪征市");
        map.insert("321020", "江苏省泰州市");
        map.insert("321021", "江苏省兴化县");
        map.insert("321022", "江苏省高邮县");
        map.insert("321023", "江苏省宝应县");
        map.insert("321024", "江苏省靖江县");
        map.insert("321025", "江苏省泰兴县");
        map.insert("321026", "江苏省江都县");
        map.insert("321027", "江苏省邗江县");
        map.insert("321028", "江苏省泰县");
        map.insert("321029", "江苏省仪征县");
        map.insert("321081", "江苏省仪征市");
        map.insert("321082", "江苏省泰州市");
        map.insert("321083", "江苏省兴化市");
        map.insert("321084", "江苏省高邮市");
        map.insert("321085", "江苏省泰兴市");
        map.insert("321086", "江苏省靖江市");
        map.insert("321088", "江苏省江都市");
        map.insert("321100", "江苏省镇江市");
        map.insert("321101", "江苏省镇江市市辖区");
        map.insert("321102", "江苏省镇江市京口区");
        map.insert("321111", "江苏省镇江市润州区");
        map.insert("321112", "江苏省镇江市丹徒区");
        map.insert("321121", "江苏省丹徒县");
        map.insert("321122", "江苏省丹阳县");
        map.insert("321123", "江苏省句容县");
        map.insert("321124", "江苏省扬中县");
        map.insert("321181", "江苏省丹阳市");
        map.insert("321182", "江苏省扬中市");
        map.insert("321183", "江苏省句容市");
        map.insert("321200", "江苏省泰州市");
        map.insert("321201", "江苏省泰州市市辖区");
        map.insert("321202", "江苏省泰州市海陵区");
        map.insert("321203", "江苏省泰州市高港区");
        map.insert("321281", "江苏省兴化市");
        map.insert("321282", "江苏省靖江市");
        map.insert("321283", "江苏省泰兴市");
        map.insert("321284", "江苏省姜堰市");
        map.insert("321300", "江苏省宿迁市");
        map.insert("321301", "江苏省宿迁市市辖区");
        map.insert("321302", "江苏省宿迁市宿城区");
        map.insert("321311", "江苏省宿迁市宿豫区");
        map.insert("321321", "江苏省宿豫县");
        map.insert("321322", "江苏省沭阳县");
        map.insert("321323", "江苏省泗阳县");
        map.insert("321324", "江苏省泗洪县");
        map.insert("322100", "江苏省徐州地区");
        map.insert("322121", "江苏省丰县");
        map.insert("322122", "江苏省沛县");
        map.insert("322123", "江苏省铜山县");
        map.insert("322124", "江苏省睢宁县");
        map.insert("322125", "江苏省邳县");
        map.insert("322126", "江苏省新沂县");
        map.insert("322127", "江苏省东海县");
        map.insert("322128", "江苏省赣榆县");
        map.insert("322200", "江苏省淮阴地区");
        map.insert("322201", "江苏省清江市");
        map.insert("322221", "江苏省淮阴县");
        map.insert("322222", "江苏省灌云县");
        map.insert("322223", "江苏省灌南县");
        map.insert("322224", "江苏省沭阳县");
        map.insert("322225", "江苏省宿迁县");
        map.insert("322226", "江苏省泗阳县");
        map.insert("322227", "江苏省涟水县");
        map.insert("322228", "江苏省泗洪县");
        map.insert("322229", "江苏省淮安县");
        map.insert("322230", "江苏省洪泽县");
        map.insert("322231", "江苏省盱眙县");
        map.insert("322232", "江苏省金湖县");
        map.insert("322300", "江苏省盐城地区");
        map.insert("322321", "江苏省响水县");
        map.insert("322322", "江苏省滨海县");
        map.insert("322323", "江苏省阜宁县");
        map.insert("322324", "江苏省射阳县");
        map.insert("322325", "江苏省建湖县");
        map.insert("322326", "江苏省盐城县");
        map.insert("322327", "江苏省大丰县");
        map.insert("322328", "江苏省东台县");
        map.insert("322400", "江苏省扬州地区");
        map.insert("322401", "江苏省扬州市");
        map.insert("322402", "江苏省泰州市");
        map.insert("322421", "江苏省兴化县");
        map.insert("322422", "江苏省高邮县");
        map.insert("322423", "江苏省宝应县");
        map.insert("322424", "江苏省靖江县");
        map.insert("322425", "江苏省泰兴县");
        map.insert("322426", "江苏省江都县");
        map.insert("322427", "江苏省邗江县");
        map.insert("322428", "江苏省泰县");
        map.insert("322429", "江苏省仪征县");
        map.insert("322500", "江苏省南通地区");
        map.insert("322521", "江苏省海安县");
        map.insert("322522", "江苏省如皋县");
        map.insert("322523", "江苏省如东县");
        map.insert("322524", "江苏省南通县");
        map.insert("322525", "江苏省海门县");
        map.insert("322526", "江苏省启东县");
        map.insert("322600", "江苏省镇江地区");
        map.insert("322601", "江苏省镇江市");
        map.insert("322621", "江苏省丹徒县");
        map.insert("322622", "江苏省武进县");
        map.insert("322623", "江苏省丹阳县");
        map.insert("322624", "江苏省句容县");
        map.insert("322625", "江苏省金坛县");
        map.insert("322626", "江苏省溧水县");
        map.insert("322627", "江苏省高淳县");
        map.insert("322628", "江苏省溧阳县");
        map.insert("322629", "江苏省宜兴县");
        map.insert("322630", "江苏省扬中县");
        map.insert("322700", "江苏省苏州地区");
        map.insert("322721", "江苏省江阴县");
        map.insert("322722", "江苏省无锡县");
        map.insert("322723", "江苏省沙洲县");
        map.insert("322724", "江苏省常熟县");
        map.insert("322725", "江苏省太仓县");
        map.insert("322726", "江苏省昆山县");
        map.insert("322727", "江苏省吴县");
        map.insert("322728", "江苏省吴江县");
        map.insert("329000", "江苏省省直辖行政单位");
        map.insert("329001", "江苏省泰州市");
        map.insert("329002", "江苏省仪征市");
        map.insert("329003", "江苏省常熟市");
        map.insert("329004", "江苏省张家港市");
        map.insert("329005", "江苏省江阴市");
        map.insert("329006", "江苏省宿迁市");
        map.insert("329007", "江苏省丹阳市");
        map.insert("329008", "江苏省东台市");
        map.insert("329009", "江苏省兴化市");
        map.insert("329010", "江苏省淮安市");
        map.insert("329011", "江苏省宜兴市");
        map.insert("330000", "浙江省");
        map.insert("330100", "浙江省杭州市");
        map.insert("330101", "浙江省杭州市市辖区");
        map.insert("330102", "浙江省杭州市上城区");
        map.insert("330103", "浙江省杭州市下城区");
        map.insert("330104", "浙江省杭州市江干区");
        map.insert("330105", "浙江省杭州市拱墅区");
        map.insert("330106", "浙江省杭州市西湖区");
        map.insert("330107", "浙江省杭州市半山区");
        map.insert("330108", "浙江省杭州市滨江区");
        map.insert("330109", "浙江省杭州市萧山区");
        map.insert("330110", "浙江省杭州市余杭区");
        map.insert("330120", "浙江省杭州市区");
        map.insert("330121", "浙江省萧山县");
        map.insert("330122", "浙江省桐庐县");
        map.insert("330123", "浙江省富阳县");
        map.insert("330124", "浙江省临安县");
        map.insert("330125", "浙江省余杭县");
        map.insert("330126", "浙江省建德县");
        map.insert("330127", "浙江省淳安县");
        map.insert("330181", "浙江省萧山市");
        map.insert("330182", "浙江省建德市");
        map.insert("330183", "浙江省富阳市");
        map.insert("330184", "浙江省余杭市");
        map.insert("330185", "浙江省临安市");
        map.insert("330200", "浙江省宁波市");
        map.insert("330201", "浙江省宁波市市辖区");
        map.insert("330202", "浙江省宁波市镇明区");
        map.insert("330203", "浙江省宁波市海曙区");
        map.insert("330204", "浙江省宁波市江东区");
        map.insert("330205", "浙江省宁波市江北区");
        map.insert("330206", "浙江省宁波市北仑区");
        map.insert("330211", "浙江省宁波市镇海区");
        map.insert("330212", "浙江省宁波市鄞州区");
        map.insert("330219", "浙江省余姚市");
        map.insert("330220", "浙江省宁波市区");
        map.insert("330221", "浙江省镇海县");
        map.insert("330222", "浙江省慈溪县");
        map.insert("330223", "浙江省余姚县");
        map.insert("330224", "浙江省奉化县");
        map.insert("330225", "浙江省象山县");
        map.insert("330226", "浙江省宁海县");
        map.insert("330227", "浙江省鄞县");
        map.insert("330281", "浙江省余姚市");
        map.insert("330282", "浙江省慈溪市");
        map.insert("330283", "浙江省奉化市");
        map.insert("330300", "浙江省温州市");
        map.insert("330301", "浙江省温州市市辖区");
        map.insert("330302", "浙江省温州市鹿城区");
        map.insert("330303", "浙江省温州市龙湾区");
        map.insert("330304", "浙江省温州市瓯海区");
        map.insert("330320", "浙江省温州市区");
        map.insert("330321", "浙江省瓯海县");
        map.insert("330322", "浙江省洞头县");
        map.insert("330323", "浙江省乐清县");
        map.insert("330324", "浙江省永嘉县");
        map.insert("330325", "浙江省瑞安县");
        map.insert("330326", "浙江省平阳县");
        map.insert("330327", "浙江省苍南县");
        map.insert("330328", "浙江省文成县");
        map.insert("330329", "浙江省泰顺县");
        map.insert("330381", "浙江省瑞安市");
        map.insert("330382", "浙江省乐清市");
        map.insert("330400", "浙江省嘉兴市");
        map.insert("330401", "浙江省嘉兴市市辖区");
        map.insert("330402", "浙江省嘉兴市秀城区");
        map.insert("330411", "浙江省嘉兴市秀洲区");
        map.insert("330421", "浙江省嘉善县");
        map.insert("330422", "浙江省平湖县");
        map.insert("330423", "浙江省海宁县");
        map.insert("330424", "浙江省海盐县");
        map.insert("330425", "浙江省桐乡县");
        map.insert("330481", "浙江省海宁市");
        map.insert("330482", "浙江省平湖市");
        map.insert("330483", "浙江省桐乡市");
        map.insert("330500", "浙江省湖州市");
        map.insert("330501", "浙江省湖州市市辖区");
        map.insert("330502", "浙江省湖州市城区");
        map.insert("330503", "浙江省湖州市南浔区");
        map.insert("330511", "浙江省湖州市郊区");
        map.insert("330521", "浙江省德清县");
        map.insert("330522", "浙江省长兴县");
        map.insert("330523", "浙江省安吉县");
        map.insert("330600", "浙江省绍兴市");
        map.insert("330601", "浙江省绍兴市市辖区");
        map.insert("330602", "浙江省绍兴市越城区");
        map.insert("330621", "浙江省绍兴县");
        map.insert("330622", "浙江省上虞县");
        map.insert("330623", "浙江省嵊县");
        map.insert("330624", "浙江省新昌县");
        map.insert("330625", "浙江省诸暨县");
        map.insert("330681", "浙江省诸暨市");
        map.insert("330682", "浙江省上虞市");
        map.insert("330683", "浙江省嵊州市");
        map.insert("330700", "浙江省金华市");
        map.insert("330701", "浙江省金华市市辖区");
        map.insert("330702", "浙江省金华市婺城区");
        map.insert("330703", "浙江省金华市金东区");
        map.insert("330719", "浙江省兰溪市");
        map.insert("330721", "浙江省金华县");
        map.insert("330722", "浙江省永康县");
        map.insert("330723", "浙江省武义县");
        map.insert("330724", "浙江省东阳县");
        map.insert("330725", "浙江省义乌县");
        map.insert("330726", "浙江省浦江县");
        map.insert("330727", "浙江省磐安县");
        map.insert("330781", "浙江省兰溪市");
        map.insert("330782", "浙江省义乌市");
        map.insert("330783", "浙江省东阳市");
        map.insert("330784", "浙江省永康市");
        map.insert("330800", "浙江省衢州市");
        map.insert("330801", "浙江省衢州市市辖区");
        map.insert("330802", "浙江省衢州市柯城区");
        map.insert("330803", "浙江省衢州市衢江区");
        map.insert("330821", "浙江省衢县");
        map.insert("330822", "浙江省常山县");
        map.insert("330823", "浙江省江山县");
        map.insert("330824", "浙江省开化县");
        map.insert("330825", "浙江省龙游县");
        map.insert("330881", "浙江省江山市");
        map.insert("330900", "浙江省舟山市");
        map.insert("330901", "浙江省舟山市市辖区");
        map.insert("330902", "浙江省舟山市定海区");
        map.insert("330903", "浙江省舟山市普陀区");
        map.insert("330921", "浙江省岱山县");
        map.insert("330922", "浙江省嵊泗县");
        map.insert("331000", "浙江省台州市");
        map.insert("331001", "浙江省台州市市辖区");
        map.insert("331002", "浙江省台州市椒江区");
        map.insert("331003", "浙江省台州市黄岩区");
        map.insert("331004", "浙江省台州市路桥区");
        map.insert("331021", "浙江省玉环县");
        map.insert("331022", "浙江省三门县");
        map.insert("331023", "浙江省天台县");
        map.insert("331024", "浙江省仙居县");
        map.insert("331081", "浙江省温岭市");
        map.insert("331082", "浙江省临海市");
        map.insert("331100", "浙江省丽水市");
        map.insert("331101", "浙江省丽水市市辖区");
        map.insert("331102", "浙江省丽水市莲都区");
        map.insert("331121", "浙江省青田县");
        map.insert("331122", "浙江省缙云县");
        map.insert("331123", "浙江省遂昌县");
        map.insert("331124", "浙江省松阳县");
        map.insert("331125", "浙江省云和县");
        map.insert("331126", "浙江省庆元县");
        map.insert("331127", "浙江省景宁畲族自治县");
        map.insert("331181", "浙江省龙泉市");
        map.insert("332100", "浙江省嘉兴地区");
        map.insert("332101", "浙江省湖州市");
        map.insert("332102", "浙江省嘉兴市");
        map.insert("332121", "浙江省嘉善县");
        map.insert("332122", "浙江省平湖县");
        map.insert("332123", "浙江省海宁县");
        map.insert("332124", "浙江省海盐县");
        map.insert("332125", "浙江省桐乡县");
        map.insert("332126", "浙江省德清县");
        map.insert("332127", "浙江省长兴县");
        map.insert("332128", "浙江省安吉县");
        map.insert("332200", "浙江省宁波地区");
        map.insert("332221", "浙江省慈溪县");
        map.insert("332222", "浙江省余姚县");
        map.insert("332223", "浙江省奉化县");
        map.insert("332224", "浙江省象山县");
        map.insert("332225", "浙江省宁海县");
        map.insert("332226", "浙江省鄞县");
        map.insert("332300", "浙江省绍兴地区");
        map.insert("332301", "浙江省绍兴市");
        map.insert("332321", "浙江省上虞县");
        map.insert("332322", "浙江省嵊县");
        map.insert("332323", "浙江省新昌县");
        map.insert("332324", "浙江省诸暨县");
        map.insert("332400", "浙江省金华地区");
        map.insert("332401", "浙江省金华市");
        map.insert("332402", "浙江省衢州市");
        map.insert("332421", "浙江省兰溪县");
        map.insert("332422", "浙江省永康县");
        map.insert("332423", "浙江省武义县");
        map.insert("332424", "浙江省东阳县");
        map.insert("332425", "浙江省义乌县");
        map.insert("332426", "浙江省浦江县");
        map.insert("332427", "浙江省常山县");
        map.insert("332428", "浙江省江山县");
        map.insert("332429", "浙江省开化县");
        map.insert("332430", "浙江省龙游县");
        map.insert("332431", "浙江省磐安县");
        map.insert("332500", "浙江省丽水地区");
        map.insert("332501", "浙江省丽水市");
        map.insert("332502", "浙江省龙泉市");
        map.insert("332521", "浙江省丽水县");
        map.insert("332522", "浙江省青田县");
        map.insert("332523", "浙江省云和县");
        map.insert("332524", "浙江省龙泉县");
        map.insert("332525", "浙江省庆元县");
        map.insert("332526", "浙江省缙云县");
        map.insert("332527", "浙江省遂昌县");
        map.insert("332528", "浙江省松阳县");
        map.insert("332529", "浙江省景宁畲族自治县");
        map.insert("332600", "浙江省台州地区");
        map.insert("332601", "浙江省椒江市");
        map.insert("332602", "浙江省临海市");
        map.insert("332603", "浙江省黄岩市");
        map.insert("332621", "浙江省临海县");
        map.insert("332622", "浙江省黄岩县");
        map.insert("332623", "浙江省温岭县");
        map.insert("332624", "浙江省仙居县");
        map.insert("332625", "浙江省天台县");
        map.insert("332626", "浙江省三门县");
        map.insert("332627", "浙江省玉环县");
        map.insert("332700", "浙江省舟山地区");
        map.insert("332721", "浙江省定海县");
        map.insert("332722", "浙江省普陀县");
        map.insert("332723", "浙江省岱山县");
        map.insert("332724", "浙江省嵊泗县");
        map.insert("339000", "浙江省省直辖行政单位");
        map.insert("339001", "浙江省余姚市");
        map.insert("339002", "浙江省海宁市");
        map.insert("339003", "浙江省兰溪市");
        map.insert("339004", "浙江省瑞安市");
        map.insert("339005", "浙江省萧山市");
        map.insert("339006", "浙江省江山市");
        map.insert("339007", "浙江省义乌市");
        map.insert("339008", "浙江省东阳市");
        map.insert("339009", "浙江省慈溪市");
        map.insert("339010", "浙江省奉化市");
        map.insert("340000", "安徽省");
        map.insert("340100", "安徽省合肥市");
        map.insert("340101", "安徽省合肥市市辖区");
        map.insert("340102", "安徽省合肥市瑶海区");
        map.insert("340103", "安徽省合肥市庐阳区");
        map.insert("340104", "安徽省合肥市蜀山区");
        map.insert("340111", "安徽省合肥市包河区");
        map.insert("340120", "安徽省合肥市区");
        map.insert("340121", "安徽省长丰县");
        map.insert("340122", "安徽省肥东县");
        map.insert("340123", "安徽省肥西县");
        map.insert("340200", "安徽省芜湖市");
        map.insert("340201", "安徽省芜湖市市辖区");
        map.insert("340202", "安徽省芜湖市镜湖区");
        map.insert("340203", "安徽省芜湖市马塘区");
        map.insert("340204", "安徽省芜湖市新芜区");
        map.insert("340207", "安徽省芜湖市鸠江区");
        map.insert("340211", "安徽省芜湖市郊区");
        map.insert("340220", "安徽省芜湖市区");
        map.insert("340221", "安徽省芜湖县");
        map.insert("340222", "安徽省繁昌县");
        map.insert("340223", "安徽省南陵县");
        map.insert("340224", "安徽省青阳县");
        map.insert("340300", "安徽省蚌埠市");
        map.insert("340301", "安徽省蚌埠市市辖区");
        map.insert("340302", "安徽省蚌埠市龙子湖区");
        map.insert("340303", "安徽省蚌埠市蚌山区");
        map.insert("340304", "安徽省蚌埠市禹会区");
        map.insert("340311", "安徽省蚌埠市淮上区");
        map.insert("340321", "安徽省怀远县");
        map.insert("340322", "安徽省五河县");
        map.insert("340323", "安徽省固镇县");
        map.insert("340400", "安徽省淮南市");
        map.insert("340401", "安徽省淮南市市辖区");
        map.insert("340402", "安徽省淮南市大通区");
        map.insert("340403", "安徽省淮南市田家庵区");
        map.insert("340404", "安徽省淮南市谢家集区");
        map.insert("340405", "安徽省淮南市八公山区");
        map.insert("340406", "安徽省淮南市潘集区");
        map.insert("340420", "安徽省淮南市区");
        map.insert("340421", "安徽省凤台县");
        map.insert("340500", "安徽省马鞍山市");
        map.insert("340501", "安徽省马鞍山市市辖区");
        map.insert("340502", "安徽省马鞍山市金家庄区");
        map.insert("340503", "安徽省马鞍山市花山区");
        map.insert("340504", "安徽省马鞍山市雨山区");
        map.insert("340505", "安徽省马鞍山市向山区");
        map.insert("340511", "安徽省马鞍山市郊区");
        map.insert("340521", "安徽省当涂县");
        map.insert("340600", "安徽省淮北市");
        map.insert("340601", "安徽省淮北市市辖区");
        map.insert("340602", "安徽省淮北市杜集区");
        map.insert("340603", "安徽省淮北市相山区");
        map.insert("340604", "安徽省淮北市烈山区");
        map.insert("340611", "安徽省淮北市郊区");
        map.insert("340620", "安徽省淮北市区");
        map.insert("340621", "安徽省濉溪县");
        map.insert("340700", "安徽省铜陵市");
        map.insert("340701", "安徽省铜陵市市辖区");
        map.insert("340702", "安徽省铜陵市铜官山区");
        map.insert("340703", "安徽省铜陵市狮子山区");
        map.insert("340704", "安徽省铜陵市铜山区");
        map.insert("340711", "安徽省铜陵市郊区");
        map.insert("340720", "安徽省铜陵市区");
        map.insert("340721", "安徽省铜陵县");
        map.insert("340800", "安徽省安庆市");
        map.insert("340801", "安徽省安庆市市辖区");
        map.insert("340802", "安徽省安庆市迎江区");
        map.insert("340803", "安徽省安庆市大观区");
        map.insert("340811", "安徽省安庆市郊区");
        map.insert("340821", "安徽省桐城县");
        map.insert("340822", "安徽省怀宁县");
        map.insert("340823", "安徽省枞阳县");
        map.insert("340824", "安徽省潜山县");
        map.insert("340825", "安徽省太湖县");
        map.insert("340826", "安徽省宿松县");
        map.insert("340827", "安徽省望江县");
        map.insert("340828", "安徽省岳西县");
        map.insert("340881", "安徽省桐城市");
        map.insert("340900", "安徽省省直辖行政单位");
        map.insert("340901", "安徽省黄山市");
        map.insert("341000", "安徽省黄山市");
        map.insert("341001", "安徽省黄山市市辖区");
        map.insert("341002", "安徽省黄山市屯溪区");
        map.insert("341003", "安徽省黄山市黄山区");
        map.insert("341004", "安徽省黄山市徽州区");
        map.insert("341021", "安徽省歙县");
        map.insert("341022", "安徽省休宁县");
        map.insert("341023", "安徽省黟县");
        map.insert("341024", "安徽省祁门县");
        map.insert("341100", "安徽省滁州市");
        map.insert("341101", "安徽省滁州市市辖区");
        map.insert("341102", "安徽省滁州市琅琊区");
        map.insert("341103", "安徽省滁州市南谯区");
        map.insert("341122", "安徽省来安县");
        map.insert("341124", "安徽省全椒县");
        map.insert("341125", "安徽省定远县");
        map.insert("341126", "安徽省凤阳县");
        map.insert("341127", "安徽省嘉山县");
        map.insert("341181", "安徽省天长市");
        map.insert("341182", "安徽省明光市");
        map.insert("341200", "安徽省阜阳市");
        map.insert("341201", "安徽省阜阳市市辖区");
        map.insert("341202", "安徽省阜阳市颍州区");
        map.insert("341203", "安徽省阜阳市颍东区");
        map.insert("341204", "安徽省阜阳市颍泉区");
        map.insert("341221", "安徽省临泉县");
        map.insert("341222", "安徽省太和县");
        map.insert("341223", "安徽省涡阳县");
        map.insert("341224", "安徽省蒙城县");
        map.insert("341225", "安徽省阜南县");
        map.insert("341226", "安徽省颍上县");
        map.insert("341227", "安徽省利辛县");
        map.insert("341281", "安徽省亳州市");
        map.insert("341282", "安徽省界首市");
        map.insert("341300", "安徽省宿州市");
        map.insert("341301", "安徽省宿州市市辖区");
        map.insert("341302", "安徽省宿州市墉桥区");
        map.insert("341321", "安徽省砀山县");
        map.insert("341322", "安徽省萧县");
        map.insert("341323", "安徽省灵璧县");
        map.insert("341324", "安徽省泗县");
        map.insert("341400", "安徽省巢湖市");
        map.insert("341401", "安徽省巢湖市市辖区");
        map.insert("341402", "安徽省巢湖市居巢区");
        map.insert("341421", "安徽省庐江县");
        map.insert("341422", "安徽省无为县");
        map.insert("341423", "安徽省含山县");
        map.insert("341424", "安徽省和县");
        map.insert("341500", "安徽省六安市");
        map.insert("341501", "安徽省六安市市辖区");
        map.insert("341502", "安徽省六安市金安区");
        map.insert("341503", "安徽省六安市裕安区");
        map.insert("341521", "安徽省寿县");
        map.insert("341522", "安徽省霍邱县");
        map.insert("341523", "安徽省舒城县");
        map.insert("341524", "安徽省金寨县");
        map.insert("341525", "安徽省霍山县");
        map.insert("341600", "安徽省亳州市");
        map.insert("341601", "安徽省亳州市市辖区");
        map.insert("341602", "安徽省亳州市谯城区");
        map.insert("341621", "安徽省涡阳县");
        map.insert("341622", "安徽省蒙城县");
        map.insert("341623", "安徽省利辛县");
        map.insert("341700", "安徽省池州市");
        map.insert("341701", "安徽省池州市市辖区");
        map.insert("341702", "安徽省池州市贵池区");
        map.insert("341721", "安徽省东至县");
        map.insert("341722", "安徽省石台县");
        map.insert("341723", "安徽省青阳县");
        map.insert("341800", "安徽省宣城市");
        map.insert("341801", "安徽省宣城市市辖区");
        map.insert("341802", "安徽省宣城市宣州区");
        map.insert("341821", "安徽省郎溪县");
        map.insert("341822", "安徽省广德县");
        map.insert("341823", "安徽省泾县");
        map.insert("341824", "安徽省绩溪县");
        map.insert("341825", "安徽省旌德县");
        map.insert("341881", "安徽省宁国市");
        map.insert("342100", "安徽省阜阳地区");
        map.insert("342101", "安徽省阜阳市");
        map.insert("342102", "安徽省亳州市");
        map.insert("342103", "安徽省界首市");
        map.insert("342121", "安徽省阜阳县");
        map.insert("342122", "安徽省临泉县");
        map.insert("342123", "安徽省太和县");
        map.insert("342124", "安徽省涡阳县");
        map.insert("342125", "安徽省蒙城县");
        map.insert("342126", "安徽省亳县");
        map.insert("342127", "安徽省阜南县");
        map.insert("342128", "安徽省颍上县");
        map.insert("342129", "安徽省界首县");
        map.insert("342130", "安徽省利辛县");
        map.insert("342200", "安徽省宿县地区");
        map.insert("342201", "安徽省宿州市");
        map.insert("342221", "安徽省砀山县");
        map.insert("342222", "安徽省萧县");
        map.insert("342223", "安徽省宿县");
        map.insert("342224", "安徽省灵壁县");
        map.insert("342225", "安徽省泗县");
        map.insert("342226", "安徽省怀远县");
        map.insert("342227", "安徽省五河县");
        map.insert("342228", "安徽省固镇县");
        map.insert("342300", "安徽省滁县地区");
        map.insert("342301", "安徽省滁州市");
        map.insert("342321", "安徽省天长县");
        map.insert("342322", "安徽省来安县");
        map.insert("342323", "安徽省滁县");
        map.insert("342324", "安徽省全椒县");
        map.insert("342325", "安徽省定远县");
        map.insert("342326", "安徽省凤阳县");
        map.insert("342327", "安徽省嘉山县");
        map.insert("342400", "安徽省六安地区");
        map.insert("342401", "安徽省六安市");
        map.insert("342421", "安徽省六安县");
        map.insert("342422", "安徽省寿县");
        map.insert("342423", "安徽省霍邱县");
        map.insert("342424", "安徽省肥西县");
        map.insert("342425", "安徽省舒城县");
        map.insert("342426", "安徽省金寨县");
        map.insert("342427", "安徽省霍山县");
        map.insert("342500", "安徽省宣城地区");
        map.insert("342501", "安徽省宣州市");
        map.insert("342502", "安徽省宁国市");
        map.insert("342521", "安徽省宣城县");
        map.insert("342522", "安徽省郎溪县");
        map.insert("342523", "安徽省广德县");
        map.insert("342524", "安徽省宁国县");
        map.insert("342525", "安徽省当涂县");
        map.insert("342526", "安徽省繁昌县");
        map.insert("342527", "安徽省南陵县");
        map.insert("342528", "安徽省青阳县");
        map.insert("342529", "安徽省泾县");
        map.insert("342530", "安徽省旌德县");
        map.insert("342531", "安徽省绩溪县");
        map.insert("342600", "安徽省巢湖地区");
        map.insert("342601", "安徽省巢湖市");
        map.insert("342621", "安徽省肥东县");
        map.insert("342622", "安徽省庐江县");
        map.insert("342623", "安徽省无为县");
        map.insert("342624", "安徽省巢县");
        map.insert("342625", "安徽省含山县");
        map.insert("342626", "安徽省和县");
        map.insert("342700", "安徽省徽州地区");
        map.insert("342701", "安徽省屯溪市");
        map.insert("342721", "安徽省绩溪县");
        map.insert("342722", "安徽省旌德县");
        map.insert("342723", "安徽省歙县");
        map.insert("342724", "安徽省休宁县");
        map.insert("342725", "安徽省黟县");
        map.insert("342726", "安徽省祁门县");
        map.insert("342727", "安徽省太平县");
        map.insert("342728", "安徽省石台县");
        map.insert("342800", "安徽省安庆地区");
        map.insert("342821", "安徽省怀宁县");
        map.insert("342822", "安徽省桐城县");
        map.insert("342823", "安徽省枞阳县");
        map.insert("342824", "安徽省潜山县");
        map.insert("342825", "安徽省太湖县");
        map.insert("342826", "安徽省宿松县");
        map.insert("342827", "安徽省望江县");
        map.insert("342828", "安徽省岳西县");
        map.insert("342829", "安徽省东至县");
        map.insert("342830", "安徽省贵池县");
        map.insert("342900", "安徽省池州地区");
        map.insert("342901", "安徽省贵池市");
        map.insert("342921", "安徽省东至县");
        map.insert("342922", "安徽省石台县");
        map.insert("342923", "安徽省青阳县");
        map.insert("350000", "福建省");
        map.insert("350100", "福建省福州市");
        map.insert("350101", "福建省福州市市辖区");
        map.insert("350102", "福建省福州市鼓楼区");
        map.insert("350103", "福建省福州市台江区");
        map.insert("350104", "福建省福州市仓山区");
        map.insert("350105", "福建省福州市马尾区");
        map.insert("350111", "福建省福州市晋安区");
        map.insert("350120", "福建省福州市区");
        map.insert("350121", "福建省闽侯县");
        map.insert("350122", "福建省连江县");
        map.insert("350123", "福建省罗源县");
        map.insert("350124", "福建省闽清县");
        map.insert("350125", "福建省永泰县");
        map.insert("350126", "福建省长乐县");
        map.insert("350127", "福建省福清县");
        map.insert("350128", "福建省平潭县");
        map.insert("350181", "福建省福清市");
        map.insert("350182", "福建省长乐市");
        map.insert("350200", "福建省厦门市");
        map.insert("350201", "福建省厦门市市辖区");
        map.insert("350202", "福建省厦门市鼓浪屿区");
        map.insert("350203", "福建省厦门市思明区");
        map.insert("350204", "福建省厦门市开元区");
        map.insert("350205", "福建省厦门市海沧区");
        map.insert("350206", "福建省厦门市湖里区");
        map.insert("350211", "福建省厦门市集美区");
        map.insert("350212", "福建省厦门市同安区");
        map.insert("350213", "福建省厦门市翔安区");
        map.insert("350220", "福建省厦门市区");
        map.insert("350221", "福建省同安县");
        map.insert("350300", "福建省莆田市");
        map.insert("350301", "福建省莆田市市辖区");
        map.insert("350302", "福建省莆田市城厢区");
        map.insert("350303", "福建省莆田市涵江区");
        map.insert("350304", "福建省莆田市荔城区");
        map.insert("350305", "福建省莆田市秀屿区");
        map.insert("350321", "福建省莆田县");
        map.insert("350322", "福建省仙游县");
        map.insert("350400", "福建省三明市");
        map.insert("350401", "福建省三明市市辖区");
        map.insert("350402", "福建省三明市梅列区");
        map.insert("350403", "福建省三明市三元区");
        map.insert("350420", "福建省永安市");
        map.insert("350421", "福建省明溪县");
        map.insert("350422", "福建省永安县");
        map.insert("350423", "福建省清流县");
        map.insert("350424", "福建省宁化县");
        map.insert("350425", "福建省大田县");
        map.insert("350426", "福建省尤溪县");
        map.insert("350427", "福建省沙县");
        map.insert("350428", "福建省将乐县");
        map.insert("350429", "福建省泰宁县");
        map.insert("350430", "福建省建宁县");
        map.insert("350481", "福建省永安市");
        map.insert("350500", "福建省泉州市");
        map.insert("350501", "福建省泉州市市辖区");
        map.insert("350502", "福建省泉州市鲤城区");
        map.insert("350503", "福建省泉州市丰泽区");
        map.insert("350504", "福建省泉州市洛江区");
        map.insert("350505", "福建省泉州市泉港区");
        map.insert("350521", "福建省惠安县");
        map.insert("350522", "福建省晋江县");
        map.insert("350523", "福建省南安县");
        map.insert("350524", "福建省安溪县");
        map.insert("350525", "福建省永春县");
        map.insert("350526", "福建省德化县");
        map.insert("350527", "福建省金门县");
        map.insert("350581", "福建省石狮市");
        map.insert("350582", "福建省晋江市");
        map.insert("350583", "福建省南安市");
        map.insert("350600", "福建省漳州市");
        map.insert("350601", "福建省漳州市市辖区");
        map.insert("350602", "福建省漳州市芗城区");
        map.insert("350603", "福建省漳州市龙文区");
        map.insert("350619", "福建省漳州市漳州开发区");
        map.insert("350621", "福建省龙海县");
        map.insert("350622", "福建省云霄县");
        map.insert("350623", "福建省漳浦县");
        map.insert("350624", "福建省诏安县");
        map.insert("350625", "福建省长泰县");
        map.insert("350626", "福建省东山县");
        map.insert("350627", "福建省南靖县");
        map.insert("350628", "福建省平和县");
        map.insert("350629", "福建省华安县");
        map.insert("350681", "福建省龙海市");
        map.insert("350700", "福建省南平市");
        map.insert("350701", "福建省南平市市辖区");
        map.insert("350702", "福建省南平市延平区");
        map.insert("350721", "福建省顺昌县");
        map.insert("350722", "福建省浦城县");
        map.insert("350723", "福建省光泽县");
        map.insert("350724", "福建省松溪县");
        map.insert("350725", "福建省政和县");
        map.insert("350781", "福建省邵武市");
        map.insert("350782", "福建省武夷山市");
        map.insert("350783", "福建省建瓯市");
        map.insert("350784", "福建省建阳市");
        map.insert("350800", "福建省龙岩市");
        map.insert("350801", "福建省龙岩市市辖区");
        map.insert("350802", "福建省龙岩市新罗区");
        map.insert("350821", "福建省长汀县");
        map.insert("350822", "福建省永定县");
        map.insert("350823", "福建省上杭县");
        map.insert("350824", "福建省武平县");
        map.insert("350825", "福建省连城县");
        map.insert("350881", "福建省漳平市");
        map.insert("350900", "福建省宁德市");
        map.insert("350901", "福建省宁德市市辖区");
        map.insert("350902", "福建省宁德市蕉城区");
        map.insert("350909", "福建省宁德市闽东华侨经济开发区");
        map.insert("350921", "福建省霞浦县");
        map.insert("350922", "福建省古田县");
        map.insert("350923", "福建省屏南县");
        map.insert("350924", "福建省寿宁县");
        map.insert("350925", "福建省周宁县");
        map.insert("350926", "福建省柘荣县");
        map.insert("350981", "福建省福安市");
        map.insert("350982", "福建省福鼎市");
        map.insert("352100", "福建省南平地区");
        map.insert("352101", "福建省南平市");
        map.insert("352102", "福建省邵武市");
        map.insert("352103", "福建省武夷山市");
        map.insert("352104", "福建省建瓯市");
        map.insert("352121", "福建省顺昌县");
        map.insert("352122", "福建省建阳县");
        map.insert("352123", "福建省建瓯县");
        map.insert("352124", "福建省浦城县");
        map.insert("352125", "福建省邵武县");
        map.insert("352126", "福建省崇安县");
        map.insert("352127", "福建省光泽县");
        map.insert("352128", "福建省松溪县");
        map.insert("352129", "福建省政和县");
        map.insert("352200", "福建省宁德地区");
        map.insert("352201", "福建省宁德市");
        map.insert("352202", "福建省福安市");
        map.insert("352203", "福建省福鼎市");
        map.insert("352221", "福建省宁德县");
        map.insert("352222", "福建省连江县");
        map.insert("352223", "福建省罗源县");
        map.insert("352224", "福建省福鼎县");
        map.insert("352225", "福建省霞浦县");
        map.insert("352226", "福建省福安县");
        map.insert("352227", "福建省古田县");
        map.insert("352228", "福建省屏南县");
        map.insert("352229", "福建省寿宁县");
        map.insert("352230", "福建省周宁县");
        map.insert("352231", "福建省柘荣县");
        map.insert("352300", "福建省莆田地区");
        map.insert("352321", "福建省闽清县");
        map.insert("352322", "福建省永泰县");
        map.insert("352323", "福建省长乐县");
        map.insert("352324", "福建省福清市");
        map.insert("352325", "福建省平潭县");
        map.insert("352326", "福建省莆田县");
        map.insert("352327", "福建省仙游县");
        map.insert("352400", "福建省晋江地区");
        map.insert("352401", "福建省泉州市");
        map.insert("352421", "福建省惠安县");
        map.insert("352422", "福建省晋江县");
        map.insert("352423", "福建省南安县");
        map.insert("352424", "福建省安溪县");
        map.insert("352425", "福建省永春县");
        map.insert("352426", "福建省德化县");
        map.insert("352427", "福建省金门县");
        map.insert("352500", "福建省龙溪地区");
        map.insert("352501", "福建省漳州市");
        map.insert("352521", "福建省龙海县");
        map.insert("352522", "福建省云霄县");
        map.insert("352523", "福建省漳浦县");
        map.insert("352524", "福建省诏安县");
        map.insert("352525", "福建省长泰县");
        map.insert("352526", "福建省东山县");
        map.insert("352527", "福建省南靖县");
        map.insert("352528", "福建省平和县");
        map.insert("352529", "福建省华安县");
        map.insert("352600", "福建省龙岩地区");
        map.insert("352601", "福建省龙岩市");
        map.insert("352602", "福建省漳平市");
        map.insert("352622", "福建省长汀县");
        map.insert("352623", "福建省永定县");
        map.insert("352624", "福建省上杭县");
        map.insert("352625", "福建省武平县");
        map.insert("352626", "福建省漳平县");
        map.insert("352627", "福建省连城县");
        map.insert("352700", "福建省三明地区");
        map.insert("352701", "福建省三明市");
        map.insert("352721", "福建省明溪县");
        map.insert("352722", "福建省永安县");
        map.insert("352723", "福建省清流县");
        map.insert("352724", "福建省宁化县");
        map.insert("352725", "福建省大田县");
        map.insert("352726", "福建省尤溪县");
        map.insert("352727", "福建省沙县");
        map.insert("352728", "福建省将乐县");
        map.insert("352729", "福建省泰宁县");
        map.insert("352730", "福建省建宁县");
        map.insert("359000", "福建省省直辖行政单位");
        map.insert("359001", "福建省永安市");
        map.insert("359002", "福建省石狮市");
        map.insert("360000", "江西省");
        map.insert("360100", "江西省南昌市");
        map.insert("360101", "江西省南昌市市辖区");
        map.insert("360102", "江西省南昌市东湖区");
        map.insert("360103", "江西省南昌市西湖区");
        map.insert("360104", "江西省南昌市青云谱区");
        map.insert("360105", "江西省南昌市湾里区");
        map.insert("360111", "江西省南昌市青山湖区");
        map.insert("360120", "江西省南昌市区");
        map.insert("360121", "江西省南昌县");
        map.insert("360122", "江西省新建县");
        map.insert("360123", "江西省安义县");
        map.insert("360124", "江西省进贤县");
        map.insert("360200", "江西省景德镇市");
        map.insert("360201", "江西省景德镇市市辖区");
        map.insert("360202", "江西省景德镇市昌江区");
        map.insert("360203", "江西省景德镇市珠山区");
        map.insert("360211", "江西省景德镇市鹅湖区");
        map.insert("360212", "江西省景德镇市蛟潭区");
        map.insert("360221", "江西省乐平县");
        map.insert("360222", "江西省浮梁县");
        map.insert("360281", "江西省乐平市");
        map.insert("360300", "江西省萍乡市");
        map.insert("360301", "江西省萍乡市市辖区");
        map.insert("360302", "江西省萍乡市安源区");
        map.insert("360311", "江西省萍乡市上栗区");
        map.insert("360312", "江西省萍乡市芦溪区");
        map.insert("360313", "江西省萍乡市湘东区");
        map.insert("360321", "江西省莲花县");
        map.insert("360322", "江西省上栗县");
        map.insert("360323", "江西省芦溪县");
        map.insert("360400", "江西省九江市");
        map.insert("360401", "江西省九江市市辖区");
        map.insert("360402", "江西省九江市庐山区");
        map.insert("360403", "江西省九江市浔阳区");
        map.insert("360411", "江西省九江市郊区");
        map.insert("360421", "江西省九江县");
        map.insert("360422", "江西省瑞昌县");
        map.insert("360423", "江西省武宁县");
        map.insert("360424", "江西省修水县");
        map.insert("360425", "江西省永修县");
        map.insert("360426", "江西省德安县");
        map.insert("360427", "江西省星子县");
        map.insert("360428", "江西省都昌县");
        map.insert("360429", "江西省湖口县");
        map.insert("360430", "江西省彭泽县");
        map.insert("360481", "江西省瑞昌市");
        map.insert("360500", "江西省新余市");
        map.insert("360501", "江西省新余市市辖区");
        map.insert("360502", "江西省新余市渝水区");
        map.insert("360521", "江西省分宜县");
        map.insert("360600", "江西省鹰潭市");
        map.insert("360601", "江西省鹰潭市市辖区");
        map.insert("360602", "江西省鹰潭市月湖区");
        map.insert("360621", "江西省贵溪县");
        map.insert("360622", "江西省余江县");
        map.insert("360681", "江西省贵溪市");
        map.insert("360700", "江西省赣州市");
        map.insert("360701", "江西省赣州市市辖区");
        map.insert("360702", "江西省赣州市章贡区");
        map.insert("360721", "江西省赣县");
        map.insert("360722", "江西省信丰县");
        map.insert("360723", "江西省大余县");
        map.insert("360724", "江西省上犹县");
        map.insert("360725", "江西省崇义县");
        map.insert("360726", "江西省安远县");
        map.insert("360727", "江西省龙南县");
        map.insert("360728", "江西省定南县");
        map.insert("360729", "江西省全南县");
        map.insert("360730", "江西省宁都县");
        map.insert("360731", "江西省于都县");
        map.insert("360732", "江西省兴国县");
        map.insert("360733", "江西省会昌县");
        map.insert("360734", "江西省寻乌县");
        map.insert("360735", "江西省石城县");
        map.insert("360781", "江西省瑞金市");
        map.insert("360782", "江西省南康市");
        map.insert("360800", "江西省吉安市");
        map.insert("360801", "江西省吉安市市辖区");
        map.insert("360802", "江西省吉安市吉州区");
        map.insert("360803", "江西省吉安市青原区");
        map.insert("360821", "江西省吉安县");
        map.insert("360822", "江西省吉水县");
        map.insert("360823", "江西省峡江县");
        map.insert("360824", "江西省新干县");
        map.insert("360825", "江西省永丰县");
        map.insert("360826", "江西省泰和县");
        map.insert("360827", "江西省遂川县");
        map.insert("360828", "江西省万安县");
        map.insert("360829", "江西省安福县");
        map.insert("360830", "江西省永新县");
        map.insert("360881", "江西省井冈山市");
        map.insert("360900", "江西省宜春市");
        map.insert("360901", "江西省宜春市市辖区");
        map.insert("360902", "江西省宜春市袁州区");
        map.insert("360921", "江西省奉新县");
        map.insert("360922", "江西省万载县");
        map.insert("360923", "江西省上高县");
        map.insert("360924", "江西省宜丰县");
        map.insert("360925", "江西省靖安县");
        map.insert("360926", "江西省铜鼓县");
        map.insert("360981", "江西省丰城市");
        map.insert("360982", "江西省樟树市");
        map.insert("360983", "江西省高安市");
        map.insert("361000", "江西省抚州市");
        map.insert("361001", "江西省抚州市市辖区");
        map.insert("361002", "江西省抚州市临川区");
        map.insert("361021", "江西省南城县");
        map.insert("361022", "江西省黎川县");
        map.insert("361023", "江西省南丰县");
        map.insert("361024", "江西省崇仁县");
        map.insert("361025", "江西省乐安县");
        map.insert("361026", "江西省宜黄县");
        map.insert("361027", "江西省金溪县");
        map.insert("361028", "江西省资溪县");
        map.insert("361029", "江西省东乡县");
        map.insert("361030", "江西省广昌县");
        map.insert("361100", "江西省上饶市");
        map.insert("361101", "江西省上饶市市辖区");
        map.insert("361102", "江西省上饶市信州区");
        map.insert("361121", "江西省上饶县");
        map.insert("361122", "江西省广丰县");
        map.insert("361123", "江西省玉山县");
        map.insert("361124", "江西省铅山县");
        map.insert("361125", "江西省横峰县");
        map.insert("361126", "江西省弋阳县");
        map.insert("361127", "江西省余干县");
        map.insert("361128", "江西省鄱阳县");
        map.insert("361129", "江西省万年县");
        map.insert("361130", "江西省婺源县");
        map.insert("361181", "江西省德兴市");
        map.insert("362100", "江西省赣州地区");
        map.insert("362101", "江西省赣州市");
        map.insert("362102", "江西省瑞金市");
        map.insert("362103", "江西省南康市");
        map.insert("362121", "江西省赣县");
        map.insert("362122", "江西省南康县");
        map.insert("362123", "江西省信丰县");
        map.insert("362124", "江西省大余县");
        map.insert("362125", "江西省上犹县");
        map.insert("362126", "江西省崇义县");
        map.insert("362127", "江西省安远县");
        map.insert("362128", "江西省龙南县");
        map.insert("362129", "江西省定南县");
        map.insert("362130", "江西省全南县");
        map.insert("362131", "江西省宁都县");
        map.insert("362132", "江西省于都县");
        map.insert("362133", "江西省兴国县");
        map.insert("362134", "江西省瑞金县");
        map.insert("362135", "江西省会昌县");
        map.insert("362136", "江西省寻乌县");
        map.insert("362137", "江西省石城县");
        map.insert("362138", "江西省广昌县");
        map.insert("362200", "江西省宜春地区");
        map.insert("362201", "江西省宜春市");
        map.insert("362202", "江西省丰城市");
        map.insert("362203", "江西省樟树市");
        map.insert("362204", "江西省高安市");
        map.insert("362221", "江西省丰城县");
        map.insert("362222", "江西省高安县");
        map.insert("362223", "江西省清江县");
        map.insert("362224", "江西省新余县");
        map.insert("362225", "江西省宜春县");
        map.insert("362226", "江西省奉新县");
        map.insert("362227", "江西省万载县");
        map.insert("362228", "江西省上高县");
        map.insert("362229", "江西省宜丰县");
        map.insert("362230", "江西省分宜县");
        map.insert("362231", "江西省安义县");
        map.insert("362232", "江西省靖安县");
        map.insert("362233", "江西省铜鼓县");
        map.insert("362300", "江西省上饶地区");
        map.insert("362301", "江西省上饶市");
        map.insert("362302", "江西省德兴市");
        map.insert("362321", "江西省上饶县");
        map.insert("362322", "江西省广丰县");
        map.insert("362323", "江西省玉山县");
        map.insert("362324", "江西省铅山县");
        map.insert("362325", "江西省横峰县");
        map.insert("362326", "江西省弋阳县");
        map.insert("362327", "江西省贵溪县");
        map.insert("362328", "江西省余江县");
        map.insert("362329", "江西省余干县");
        map.insert("362330", "江西省波阳县");
        map.insert("362331", "江西省万年县");
        map.insert("362332", "江西省乐平县");
        map.insert("362333", "江西省德兴县");
        map.insert("362334", "江西省婺源县");
        map.insert("362400", "江西省吉安地区");
        map.insert("362401", "江西省吉安市");
        map.insert("362402", "江西省井冈山市");
        map.insert("362421", "江西省吉安县");
        map.insert("362422", "江西省吉水县");
        map.insert("362423", "江西省峡江县");
        map.insert("362424", "江西省新干县");
        map.insert("362425", "江西省永丰县");
        map.insert("362426", "江西省泰和县");
        map.insert("362427", "江西省遂川县");
        map.insert("362428", "江西省万安县");
        map.insert("362429", "江西省安福县");
        map.insert("362430", "江西省永新县");
        map.insert("362431", "江西省莲花县");
        map.insert("362432", "江西省宁冈县");
        map.insert("362433", "江西省井冈山县");
        map.insert("362500", "江西省抚州地区");
        map.insert("362501", "江西省抚州市");
        map.insert("362502", "江西省临川市");
        map.insert("362521", "江西省临川县");
        map.insert("362522", "江西省南城县");
        map.insert("362523", "江西省黎川县");
        map.insert("362524", "江西省南丰县");
        map.insert("362525", "江西省崇仁县");
        map.insert("362526", "江西省乐安县");
        map.insert("362527", "江西省宜黄县");
        map.insert("362528", "江西省金溪县");
        map.insert("362529", "江西省资溪县");
        map.insert("362530", "江西省进贤县");
        map.insert("362531", "江西省东乡县");
        map.insert("362532", "江西省广昌县");
        map.insert("362600", "江西省九江地区");
        map.insert("362621", "江西省九江县");
        map.insert("362622", "江西省瑞昌县");
        map.insert("362623", "江西省武宁县");
        map.insert("362624", "江西省修水县");
        map.insert("362625", "江西省永修县");
        map.insert("362626", "江西省德安县");
        map.insert("362627", "江西省星子县");
        map.insert("362628", "江西省都昌县");
        map.insert("362629", "江西省湖口县");
        map.insert("362630", "江西省彭泽县");
        map.insert("370000", "山东省");
        map.insert("370100", "山东省济南市");
        map.insert("370101", "山东省济南市市辖区");
        map.insert("370102", "山东省济南市历下区");
        map.insert("370103", "山东省济南市市中区");
        map.insert("370104", "山东省济南市槐荫区");
        map.insert("370105", "山东省济南市天桥区");
        map.insert("370111", "山东省济南市郊区");
        map.insert("370112", "山东省济南市历城区");
        map.insert("370113", "山东省济南市长清区");
        map.insert("370120", "山东省济南市区");
        map.insert("370121", "山东省历城县");
        map.insert("370122", "山东省章丘县");
        map.insert("370123", "山东省长清县");
        map.insert("370124", "山东省平阴县");
        map.insert("370125", "山东省济阳县");
        map.insert("370126", "山东省商河县");
        map.insert("370181", "山东省章丘市");
        map.insert("370200", "山东省青岛市");
        map.insert("370201", "山东省青岛市市辖区");
        map.insert("370202", "山东省青岛市市南区");
        map.insert("370203", "山东省青岛市市北区");
        map.insert("370204", "山东省青岛市台东区");
        map.insert("370205", "山东省青岛市四方区");
        map.insert("370206", "山东省青岛市沧口区");
        map.insert("370211", "山东省青岛市黄岛区");
        map.insert("370212", "山东省青岛市崂山区");
        map.insert("370213", "山东省青岛市李沧区");
        map.insert("370214", "山东省青岛市城阳区");
        map.insert("370220", "山东省青岛市区");
        map.insert("370221", "山东省崂山县");
        map.insert("370222", "山东省即墨县");
        map.insert("370223", "山东省胶南县");
        map.insert("370224", "山东省胶县");
        map.insert("370225", "山东省莱西县");
        map.insert("370226", "山东省平度县");
        map.insert("370281", "山东省胶州市");
        map.insert("370282", "山东省即墨市");
        map.insert("370283", "山东省平度市");
        map.insert("370284", "山东省胶南市");
        map.insert("370285", "山东省莱西市");
        map.insert("370300", "山东省淄博市");
        map.insert("370301", "山东省淄博市市辖区");
        map.insert("370302", "山东省淄博市淄川区");
        map.insert("370303", "山东省淄博市张店区");
        map.insert("370304", "山东省淄博市博山区");
        map.insert("370305", "山东省淄博市临淄区");
        map.insert("370306", "山东省淄博市周村区");
        map.insert("370321", "山东省桓台县");
        map.insert("370322", "山东省高青县");
        map.insert("370323", "山东省沂源县");
        map.insert("370400", "山东省枣庄市");
        map.insert("370401", "山东省枣庄市市辖区");
        map.insert("370402", "山东省枣庄市市中区");
        map.insert("370403", "山东省枣庄市薛城区");
        map.insert("370404", "山东省枣庄市峄城区");
        map.insert("370405", "山东省枣庄市台儿庄区");
        map.insert("370406", "山东省枣庄市山亭区");
        map.insert("370420", "山东省枣庄市区");
        map.insert("370421", "山东省滕县");
        map.insert("370481", "山东省滕州市");
        map.insert("370500", "山东省东营市");
        map.insert("370501", "山东省东营市市辖区");
        map.insert("370502", "山东省东营市东营区");
        map.insert("370503", "山东省东营市河口区");
        map.insert("370504", "山东省东营市牛庄区");
        map.insert("370521", "山东省垦利县");
        map.insert("370522", "山东省利津县");
        map.insert("370523", "山东省广饶县");
        map.insert("370600", "山东省烟台市");
        map.insert("370601", "山东省烟台市市辖区");
        map.insert("370602", "山东省烟台市芝罘区");
        map.insert("370611", "山东省烟台市福山区");
        map.insert("370612", "山东省烟台市牟平区");
        map.insert("370613", "山东省烟台市莱山区");
        map.insert("370620", "山东省威海市");
        map.insert("370622", "山东省蓬莱县");
        map.insert("370623", "山东省黄县");
        map.insert("370624", "山东省招远县");
        map.insert("370625", "山东省掖县");
        map.insert("370627", "山东省莱阳县");
        map.insert("370628", "山东省栖霞县");
        map.insert("370629", "山东省海阳县");
        map.insert("370630", "山东省乳山县");
        map.insert("370631", "山东省牟平县");
        map.insert("370632", "山东省文登县");
        map.insert("370633", "山东省荣城县");
        map.insert("370634", "山东省长岛县");
        map.insert("370681", "山东省龙口市");
        map.insert("370682", "山东省莱阳市");
        map.insert("370683", "山东省莱州市");
        map.insert("370684", "山东省蓬莱市");
        map.insert("370685", "山东省招远市");
        map.insert("370686", "山东省栖霞市");
        map.insert("370687", "山东省海阳市");
        map.insert("370700", "山东省潍坊市");
        map.insert("370701", "山东省潍坊市市辖区");
        map.insert("370702", "山东省潍坊市潍城区");
        map.insert("370703", "山东省潍坊市寒亭区");
        map.insert("370704", "山东省潍坊市坊子区");
        map.insert("370705", "山东省潍坊市奎文区");
        map.insert("370719", "山东省青州市");
        map.insert("370721", "山东省益都县");
        map.insert("370722", "山东省安丘县");
        map.insert("370723", "山东省寿光县");
        map.insert("370724", "山东省临朐县");
        map.insert("370725", "山东省昌乐县");
        map.insert("370726", "山东省昌邑县");
        map.insert("370727", "山东省高密县");
        map.insert("370728", "山东省诸城县");
        map.insert("370729", "山东省五莲县");
        map.insert("370781", "山东省青州市");
        map.insert("370782", "山东省诸城市");
        map.insert("370783", "山东省寿光市");
        map.insert("370784", "山东省安丘市");
        map.insert("370785", "山东省高密市");
        map.insert("370786", "山东省昌邑市");
        map.insert("370800", "山东省济宁市");
        map.insert("370801", "山东省济宁市市辖区");
        map.insert("370802", "山东省济宁市市中区");
        map.insert("370811", "山东省济宁市任城区");
        map.insert("370819", "山东省济宁市曲阜市");
        map.insert("370822", "山东省兖州县");
        map.insert("370823", "山东省曲阜县");
        map.insert("370825", "山东省邹县");
        map.insert("370826", "山东省微山县");
        map.insert("370827", "山东省鱼台县");
        map.insert("370828", "山东省金乡县");
        map.insert("370829", "山东省嘉祥县");
        map.insert("370830", "山东省汶上县");
        map.insert("370831", "山东省泗水县");
        map.insert("370832", "山东省梁山县");
        map.insert("370881", "山东省曲阜市");
        map.insert("370882", "山东省兖州市");
        map.insert("370883", "山东省邹城市");
        map.insert("370900", "山东省泰安市");
        map.insert("370901", "山东省泰安市市辖区");
        map.insert("370902", "山东省泰安市泰山区");
        map.insert("370903", "山东省泰安市岱岳区");
        map.insert("370911", "山东省泰安市郊区");
        map.insert("370919", "山东省莱芜市");
        map.insert("370920", "山东省新泰市");
        map.insert("370921", "山东省宁阳县");
        map.insert("370922", "山东省肥城县");
        map.insert("370923", "山东省东平县");
        map.insert("370981", "山东省莱芜市");
        map.insert("370982", "山东省新泰市");
        map.insert("370983", "山东省肥城市");
        map.insert("371000", "山东省威海市");
        map.insert("371001", "山东省威海市市辖区");
        map.insert("371002", "山东省威海市环翠区");
        map.insert("371021", "山东省乳山县");
        map.insert("371081", "山东省文登市");
        map.insert("371082", "山东省荣成市");
        map.insert("371083", "山东省乳山市");
        map.insert("371100", "山东省日照市");
        map.insert("371101", "山东省日照市市辖区");
        map.insert("371102", "山东省日照市东港区");
        map.insert("371103", "山东省日照市岚山区");
        map.insert("371121", "山东省五莲县");
        map.insert("371122", "山东省莒县");
        map.insert("371200", "山东省莱芜市");
        map.insert("371201", "山东省莱芜市市辖区");
        map.insert("371202", "山东省莱芜市莱城区");
        map.insert("371203", "山东省莱芜市钢城区");
        map.insert("371300", "山东省临沂市");
        map.insert("371301", "山东省临沂市市辖区");
        map.insert("371302", "山东省临沂市兰山区");
        map.insert("371311", "山东省临沂市罗庄区");
        map.insert("371312", "山东省临沂市河东区");
        map.insert("371321", "山东省沂南县");
        map.insert("371322", "山东省郯城县");
        map.insert("371323", "山东省沂水县");
        map.insert("371324", "山东省苍山县");
        map.insert("371325", "山东省费县");
        map.insert("371326", "山东省平邑县");
        map.insert("371327", "山东省莒南县");
        map.insert("371328", "山东省蒙阴县");
        map.insert("371329", "山东省临沭县");
        map.insert("371400", "山东省德州市");
        map.insert("371401", "山东省德州市市辖区");
        map.insert("371402", "山东省德州市德城区");
        map.insert("371421", "山东省陵县");
        map.insert("371422", "山东省宁津县");
        map.insert("371423", "山东省庆云县");
        map.insert("371424", "山东省临邑县");
        map.insert("371425", "山东省齐河县");
        map.insert("371426", "山东省平原县");
        map.insert("371427", "山东省夏津县");
        map.insert("371428", "山东省武城县");
        map.insert("371481", "山东省乐陵市");
        map.insert("371482", "山东省禹城市");
        map.insert("371500", "山东省聊城市");
        map.insert("371501", "山东省聊城市市辖区");
        map.insert("371502", "山东省聊城市东昌府区");
        map.insert("371521", "山东省阳谷县");
        map.insert("371522", "山东省莘县");
        map.insert("371523", "山东省茌平县");
        map.insert("371524", "山东省东阿县");
        map.insert("371525", "山东省冠县");
        map.insert("371526", "山东省高唐县");
        map.insert("371581", "山东省临清市");
        map.insert("371600", "山东省滨州市");
        map.insert("371601", "山东省滨州市市辖区");
        map.insert("371602", "山东省滨州市滨城区");
        map.insert("371621", "山东省惠民县");
        map.insert("371622", "山东省阳信县");
        map.insert("371623", "山东省无棣县");
        map.insert("371624", "山东省沾化县");
        map.insert("371625", "山东省博兴县");
        map.insert("371626", "山东省邹平县");
        map.insert("371700", "山东省荷泽市");
        map.insert("371701", "山东省荷泽市市辖区");
        map.insert("371702", "山东省荷泽市牡丹区");
        map.insert("371721", "山东省曹县");
        map.insert("371722", "山东省单县");
        map.insert("371723", "山东省成武县");
        map.insert("371724", "山东省巨野县");
        map.insert("371725", "山东省郓城县");
        map.insert("371726", "山东省鄄城县");
        map.insert("371727", "山东省定陶县");
        map.insert("371728", "山东省东明县");
        map.insert("372100", "山东省烟台地区");
        map.insert("372101", "山东省烟台市");
        map.insert("372102", "山东省威海市");
        map.insert("372121", "山东省福山县");
        map.insert("372122", "山东省蓬莱县");
        map.insert("372123", "山东省黄县");
        map.insert("372124", "山东省招远县");
        map.insert("372125", "山东省掖县");
        map.insert("372126", "山东省莱西县");
        map.insert("372127", "山东省莱阳县");
        map.insert("372128", "山东省栖霞县");
        map.insert("372129", "山东省海阳县");
        map.insert("372130", "山东省乳山县");
        map.insert("372131", "山东省牟平县");
        map.insert("372132", "山东省文登县");
        map.insert("372133", "山东省荣城县");
        map.insert("372134", "山东省长岛县");
        map.insert("372200", "山东省潍坊地区");
        map.insert("372201", "山东省潍坊市");
        map.insert("372221", "山东省益都县");
        map.insert("372222", "山东省安丘县");
        map.insert("372223", "山东省寿光县");
        map.insert("372224", "山东省临朐县");
        map.insert("372225", "山东省昌乐县");
        map.insert("372226", "山东省昌邑县");
        map.insert("372227", "山东省高密县");
        map.insert("372228", "山东省诸城县");
        map.insert("372229", "山东省五莲县");
        map.insert("372230", "山东省平度县");
        map.insert("372231", "山东省潍县");
        map.insert("372300", "山东省滨州地区");
        map.insert("372301", "山东省滨州市");
        map.insert("372321", "山东省惠民县");
        map.insert("372322", "山东省滨县");
        map.insert("372323", "山东省阳信县");
        map.insert("372324", "山东省无棣县");
        map.insert("372325", "山东省沾化县");
        map.insert("372326", "山东省利津县");
        map.insert("372327", "山东省广饶县");
        map.insert("372328", "山东省博兴县");
        map.insert("372329", "山东省桓台县");
        map.insert("372330", "山东省邹平县");
        map.insert("372331", "山东省高青县");
        map.insert("372332", "山东省垦利县");
        map.insert("372400", "山东省德州地区");
        map.insert("372401", "山东省德州市");
        map.insert("372402", "山东省乐陵市");
        map.insert("372403", "山东省禹城市");
        map.insert("372421", "山东省陵县");
        map.insert("372422", "山东省平原县");
        map.insert("372423", "山东省夏津县");
        map.insert("372424", "山东省武城县");
        map.insert("372425", "山东省齐河县");
        map.insert("372426", "山东省禹城县");
        map.insert("372427", "山东省乐陵县");
        map.insert("372428", "山东省临邑县");
        map.insert("372429", "山东省商河县");
        map.insert("372430", "山东省济阳县");
        map.insert("372431", "山东省宁津县");
        map.insert("372432", "山东省庆云县");
        map.insert("372500", "山东省聊城地区");
        map.insert("372501", "山东省聊城市");
        map.insert("372502", "山东省临清市");
        map.insert("372521", "山东省聊城县");
        map.insert("372522", "山东省阳谷县");
        map.insert("372523", "山东省莘县");
        map.insert("372524", "山东省茌平县");
        map.insert("372525", "山东省东阿县");
        map.insert("372526", "山东省冠县");
        map.insert("372527", "山东省高唐县");
        map.insert("372528", "山东省临清县");
        map.insert("372600", "山东省泰安地区");
        map.insert("372601", "山东省泰安市");
        map.insert("372602", "山东省莱芜市");
        map.insert("372603", "山东省新泰市");
        map.insert("372622", "山东省莱芜县");
        map.insert("372623", "山东省新泰县");
        map.insert("372624", "山东省宁阳县");
        map.insert("372625", "山东省肥城县");
        map.insert("372626", "山东省东平县");
        map.insert("372627", "山东省平阴县");
        map.insert("372628", "山东省新汶县");
        map.insert("372629", "山东省汶上县");
        map.insert("372630", "山东省泗水县");
        map.insert("372700", "山东省济宁地区");
        map.insert("372701", "山东省济宁市");
        map.insert("372721", "山东省济宁县");
        map.insert("372722", "山东省兖州县");
        map.insert("372723", "山东省曲阜县");
        map.insert("372724", "山东省泗水县");
        map.insert("372725", "山东省邹县");
        map.insert("372726", "山东省微山县");
        map.insert("372727", "山东省鱼台县");
        map.insert("372728", "山东省金乡县");
        map.insert("372729", "山东省嘉祥县");
        map.insert("372730", "山东省汶上县");
        map.insert("372800", "山东省临沂地区");
        map.insert("372801", "山东省临沂市");
        map.insert("372802", "山东省日照市");
        map.insert("372821", "山东省临沂县");
        map.insert("372822", "山东省郯城县");
        map.insert("372823", "山东省苍山县");
        map.insert("372824", "山东省莒南县");
        map.insert("372825", "山东省日照县");
        map.insert("372826", "山东省莒县");
        map.insert("372827", "山东省沂水县");
        map.insert("372828", "山东省沂源县");
        map.insert("372829", "山东省蒙阴县");
        map.insert("372830", "山东省平邑县");
        map.insert("372831", "山东省费县");
        map.insert("372832", "山东省沂南县");
        map.insert("372833", "山东省临沭县");
        map.insert("372900", "山东省菏泽地区");
        map.insert("372901", "山东省菏泽市");
        map.insert("372921", "山东省荷泽县");
        map.insert("372922", "山东省曹县");
        map.insert("372923", "山东省定陶县");
        map.insert("372924", "山东省成武县");
        map.insert("372925", "山东省单县");
        map.insert("372926", "山东省巨野县");
        map.insert("372927", "山东省梁山县");
        map.insert("372928", "山东省郓城县");
        map.insert("372929", "山东省鄄城县");
        map.insert("372930", "山东省东明县");
        map.insert("379001", "山东省青州市");
        map.insert("379002", "山东省龙口市");
        map.insert("379003", "山东省曲阜市");
        map.insert("379004", "山东省莱芜市");
        map.insert("379005", "山东省新泰市");
        map.insert("379006", "山东省胶州市");
        map.insert("379007", "山东省诸城市");
        map.insert("379008", "山东省莱阳市");
        map.insert("379009", "山东省莱州市");
        map.insert("379010", "山东省滕州市");
        map.insert("379011", "山东省文登市");
        map.insert("379012", "山东省荣城市");
        map.insert("410000", "河南省");
        map.insert("410100", "河南省郑州市");
        map.insert("410101", "河南省郑州市市辖区");
        map.insert("410102", "河南省郑州市中原区");
        map.insert("410103", "河南省郑州市二七区");
        map.insert("410104", "河南省郑州市管城回族区");
        map.insert("410105", "河南省郑州市金水区");
        map.insert("410106", "河南省郑州市上街区");
        map.insert("410107", "河南省郑州市新密区");
        map.insert("410108", "河南省郑州市邙山区");
        map.insert("410111", "河南省郑州市金海区");
        map.insert("410112", "河南省郑州市郊区");
        map.insert("410120", "河南省郑州市区");
        map.insert("410121", "河南省荥阳县");
        map.insert("410122", "河南省中牟县");
        map.insert("410123", "河南省新郑县");
        map.insert("410124", "河南省巩县");
        map.insert("410125", "河南省登封县");
        map.insert("410126", "河南省密县");
        map.insert("410181", "河南省巩义市");
        map.insert("410182", "河南省荥阳市");
        map.insert("410183", "河南省新密市");
        map.insert("410184", "河南省新郑市");
        map.insert("410185", "河南省登封市");
        map.insert("410200", "河南省开封市");
        map.insert("410201", "河南省开封市市辖区");
        map.insert("410202", "河南省开封市龙亭区");
        map.insert("410203", "河南省开封市顺河回族区");
        map.insert("410204", "河南省开封市鼓楼区");
        map.insert("410205", "河南省开封市南关区");
        map.insert("410211", "河南省开封市郊区");
        map.insert("410221", "河南省杞县");
        map.insert("410222", "河南省通许县");
        map.insert("410223", "河南省尉氏县");
        map.insert("410224", "河南省开封县");
        map.insert("410225", "河南省兰考县");
        map.insert("410300", "河南省洛阳市");
        map.insert("410301", "河南省洛阳市市辖区");
        map.insert("410302", "河南省洛阳市老城区");
        map.insert("410303", "河南省洛阳市西工区");
        map.insert("410304", "河南省洛阳市廛河回族区");
        map.insert("410305", "河南省洛阳市涧西区");
        map.insert("410306", "河南省洛阳市吉利区");
        map.insert("410307", "河南省洛阳市洛龙区");
        map.insert("410311", "河南省洛阳市郊区");
        map.insert("410321", "河南省偃师县");
        map.insert("410322", "河南省孟津县");
        map.insert("410323", "河南省新安县");
        map.insert("410324", "河南省栾川县");
        map.insert("410325", "河南省嵩县");
        map.insert("410326", "河南省汝阳县");
        map.insert("410327", "河南省宜阳县");
        map.insert("410328", "河南省洛宁县");
        map.insert("410329", "河南省伊川县");
        map.insert("410381", "河南省偃师市");
        map.insert("410400", "河南省平顶山市");
        map.insert("410401", "河南省平顶山市市辖区");
        map.insert("410402", "河南省平顶山市新华区");
        map.insert("410403", "河南省平顶山市卫东区");
        map.insert("410404", "河南省平顶山市石龙区");
        map.insert("410411", "河南省平顶山市湛河区");
        map.insert("410412", "河南省平顶山市舞钢区");
        map.insert("410421", "河南省宝丰县");
        map.insert("410422", "河南省叶县");
        map.insert("410423", "河南省鲁山县");
        map.insert("410424", "河南省临汝县");
        map.insert("410425", "河南省郏县");
        map.insert("410426", "河南省襄城县");
        map.insert("410481", "河南省舞钢市");
        map.insert("410482", "河南省汝州市");
        map.insert("410500", "河南省安阳市");
        map.insert("410501", "河南省安阳市市辖区");
        map.insert("410502", "河南省安阳市文峰区");
        map.insert("410503", "河南省安阳市北关区");
        map.insert("410504", "河南省安阳市铁西区");
        map.insert("410505", "河南省安阳市殷都区");
        map.insert("410506", "河南省安阳市龙安区");
        map.insert("410511", "河南省安阳市郊区");
        map.insert("410521", "河南省林县");
        map.insert("410522", "河南省安阳县");
        map.insert("410523", "河南省汤阴县");
        map.insert("410524", "河南省淇县");
        map.insert("410525", "河南省浚县");
        map.insert("410526", "河南省滑县");
        map.insert("410527", "河南省内黄县");
        map.insert("410581", "河南省林州市");
        map.insert("410600", "河南省鹤壁市");
        map.insert("410601", "河南省鹤壁市市辖区");
        map.insert("410602", "河南省鹤壁市鹤山区");
        map.insert("410603", "河南省鹤壁市山城区");
        map.insert("410611", "河南省鹤壁市淇滨区");
        map.insert("410621", "河南省浚县");
        map.insert("410622", "河南省淇县");
        map.insert("410700", "河南省新乡市");
        map.insert("410701", "河南省新乡市市辖区");
        map.insert("410702", "河南省新乡市红旗区");
        map.insert("410703", "河南省新乡市卫滨区");
        map.insert("410704", "河南省新乡市凤泉区");
        map.insert("410711", "河南省新乡市牧野区");
        map.insert("410721", "河南省新乡县");
        map.insert("410722", "河南省汲县");
        map.insert("410723", "河南省辉县");
        map.insert("410724", "河南省获嘉县");
        map.insert("410725", "河南省原阳县");
        map.insert("410726", "河南省延津县");
        map.insert("410727", "河南省封丘县");
        map.insert("410728", "河南省长垣县");
        map.insert("410781", "河南省卫辉市");
        map.insert("410782", "河南省辉县市");
        map.insert("410800", "河南省焦作市");
        map.insert("410801", "河南省焦作市市辖区");
        map.insert("410802", "河南省焦作市解放区");
        map.insert("410803", "河南省焦作市中站区");
        map.insert("410804", "河南省焦作市马村区");
        map.insert("410811", "河南省焦作市山阳区");
        map.insert("410821", "河南省修武县");
        map.insert("410822", "河南省博爱县");
        map.insert("410823", "河南省武陟县");
        map.insert("410824", "河南省沁阳市");
        map.insert("410825", "河南省温县");
        map.insert("410826", "河南省孟县");
        map.insert("410827", "河南省济源县");
        map.insert("410881", "河南省济源市");
        map.insert("410882", "河南省沁阳市");
        map.insert("410883", "河南省孟州市");
        map.insert("410900", "河南省濮阳市");
        map.insert("410901", "河南省濮阳市市辖区");
        map.insert("410902", "河南省濮阳市华龙区");
        map.insert("410921", "河南省滑县");
        map.insert("410922", "河南省清丰县");
        map.insert("410923", "河南省南乐县");
        map.insert("410924", "河南省内黄县");
        map.insert("410925", "河南省长垣县");
        map.insert("410926", "河南省范县");
        map.insert("410927", "河南省台前县");
        map.insert("410928", "河南省濮阳县");
        map.insert("411000", "河南省许昌市");
        map.insert("411001", "河南省许昌市市辖区");
        map.insert("411002", "河南省许昌市魏都区");
        map.insert("411021", "河南省禹县");
        map.insert("411022", "河南省长葛县");
        map.insert("411023", "河南省许昌县");
        map.insert("411024", "河南省鄢陵县");
        map.insert("411025", "河南省襄城县");
        map.insert("411081", "河南省禹州市");
        map.insert("411082", "河南省长葛市");
        map.insert("411100", "河南省漯河市");
        map.insert("411101", "河南省漯河市市辖区");
        map.insert("411102", "河南省漯河市源汇区");
        map.insert("411103", "河南省漯河市郾城区");
        map.insert("411104", "河南省漯河市召陵区");
        map.insert("411121", "河南省舞阳县");
        map.insert("411122", "河南省临颍县");
        map.insert("411123", "河南省郾城县");
        map.insert("411200", "河南省三门峡市");
        map.insert("411201", "河南省三门峡市市辖区");
        map.insert("411202", "河南省三门峡市湖滨区");
        map.insert("411219", "河南省义马市");
        map.insert("411221", "河南省渑池县");
        map.insert("411222", "河南省陕县");
        map.insert("411223", "河南省灵宝县");
        map.insert("411224", "河南省卢氏县");
        map.insert("411281", "河南省义马市");
        map.insert("411282", "河南省灵宝市");
        map.insert("411300", "河南省南阳市");
        map.insert("411301", "河南省南阳市市辖区");
        map.insert("411302", "河南省南阳市宛城区");
        map.insert("411303", "河南省南阳市卧龙区");
        map.insert("411321", "河南省南召县");
        map.insert("411322", "河南省方城县");
        map.insert("411323", "河南省西峡县");
        map.insert("411324", "河南省镇平县");
        map.insert("411325", "河南省内乡县");
        map.insert("411326", "河南省淅川县");
        map.insert("411327", "河南省社旗县");
        map.insert("411328", "河南省唐河县");
        map.insert("411329", "河南省新野县");
        map.insert("411330", "河南省桐柏县");
        map.insert("411381", "河南省邓州市");
        map.insert("411400", "河南省商丘市");
        map.insert("411401", "河南省商丘市市辖区");
        map.insert("411402", "河南省商丘市梁园区");
        map.insert("411403", "河南省商丘市睢阳区");
        map.insert("411421", "河南省民权县");
        map.insert("411422", "河南省睢县");
        map.insert("411423", "河南省宁陵县");
        map.insert("411424", "河南省柘城县");
        map.insert("411425", "河南省虞城县");
        map.insert("411426", "河南省夏邑县");
        map.insert("411481", "河南省永城市");
        map.insert("411500", "河南省信阳市");
        map.insert("411501", "河南省信阳市市辖区");
        map.insert("411502", "河南省信阳市师河区");
        map.insert("411503", "河南省信阳市平桥区");
        map.insert("411521", "河南省罗山县");
        map.insert("411522", "河南省光山县");
        map.insert("411523", "河南省新县");
        map.insert("411524", "河南省商城县");
        map.insert("411525", "河南省固始县");
        map.insert("411526", "河南省潢川县");
        map.insert("411527", "河南省淮滨县");
        map.insert("411528", "河南省息县");
        map.insert("411600", "河南省周口市");
        map.insert("411601", "河南省周口市市辖区");
        map.insert("411602", "河南省周口市川汇区");
        map.insert("411621", "河南省扶沟县");
        map.insert("411622", "河南省西华县");
        map.insert("411623", "河南省商水县");
        map.insert("411624", "河南省沈丘县");
        map.insert("411625", "河南省郸城县");
        map.insert("411626", "河南省淮阳县");
        map.insert("411627", "河南省太康县");
        map.insert("411628", "河南省鹿邑县");
        map.insert("411681", "河南省项城市");
        map.insert("411700", "河南省驻马店市");
        map.insert("411701", "河南省驻马店市市辖区");
        map.insert("411702", "河南省驻马店市驿城区");
        map.insert("411721", "河南省西平县");
        map.insert("411722", "河南省上蔡县");
        map.insert("411723", "河南省平舆县");
        map.insert("411724", "河南省正阳县");
        map.insert("411725", "河南省确山县");
        map.insert("411726", "河南省泌阳县");
        map.insert("411727", "河南省汝南县");
        map.insert("411728", "河南省遂平县");
        map.insert("411729", "河南省新蔡县");
        map.insert("412100", "河南省安阳地区");
        map.insert("412121", "河南省林县");
        map.insert("412122", "河南省安阳县");
        map.insert("412123", "河南省汤阴县");
        map.insert("412124", "河南省淇县");
        map.insert("412125", "河南省浚县");
        map.insert("412126", "河南省濮阳县");
        map.insert("412127", "河南省滑县");
        map.insert("412128", "河南省清丰县");
        map.insert("412129", "河南省南乐县");
        map.insert("412130", "河南省内黄县");
        map.insert("412131", "河南省长垣县");
        map.insert("412132", "河南省范县");
        map.insert("412133", "河南省台前县");
        map.insert("412200", "河南省新乡地区");
        map.insert("412221", "河南省沁阳县");
        map.insert("412222", "河南省博爱县");
        map.insert("412223", "河南省济源县");
        map.insert("412224", "河南省孟县");
        map.insert("412225", "河南省温县");
        map.insert("412226", "河南省武陟县");
        map.insert("412227", "河南省修武县");
        map.insert("412228", "河南省获嘉县");
        map.insert("412229", "河南省新乡县");
        map.insert("412230", "河南省辉县");
        map.insert("412231", "河南省汲县");
        map.insert("412232", "河南省原阳县");
        map.insert("412233", "河南省延津县");
        map.insert("412234", "河南省封丘县");
        map.insert("412300", "河南省商丘地区");
        map.insert("412301", "河南省商丘市");
        map.insert("412302", "河南省永城市");
        map.insert("412321", "河南省虞城县");
        map.insert("412322", "河南省商丘县");
        map.insert("412323", "河南省民权县");
        map.insert("412324", "河南省宁陵县");
        map.insert("412325", "河南省睢县");
        map.insert("412326", "河南省夏邑县");
        map.insert("412327", "河南省柘城县");
        map.insert("412328", "河南省永城县");
        map.insert("412400", "河南省开封地区");
        map.insert("412421", "河南省杞县");
        map.insert("412422", "河南省通许县");
        map.insert("412423", "河南省尉氏县");
        map.insert("412424", "河南省开封县");
        map.insert("412425", "河南省中牟县");
        map.insert("412426", "河南省新郑县");
        map.insert("412427", "河南省巩县");
        map.insert("412428", "河南省登封县");
        map.insert("412429", "河南省密县");
        map.insert("412430", "河南省兰考县");
        map.insert("412500", "河南省洛阳地区");
        map.insert("412501", "河南省三门峡市");
        map.insert("412502", "河南省义马市");
        map.insert("412521", "河南省偃师县");
        map.insert("412522", "河南省孟津县");
        map.insert("412523", "河南省新安县");
        map.insert("412524", "河南省渑池县");
        map.insert("412525", "河南省陕县");
        map.insert("412526", "河南省灵宝县");
        map.insert("412527", "河南省伊川县");
        map.insert("412528", "河南省汝阳县");
        map.insert("412529", "河南省嵩县");
        map.insert("412530", "河南省洛宁县");
        map.insert("412531", "河南省卢氏县");
        map.insert("412532", "河南省栾川县");
        map.insert("412533", "河南省临汝县");
        map.insert("412534", "河南省宜阳县");
        map.insert("412600", "河南省许昌地区");
        map.insert("412601", "河南省许昌市");
        map.insert("412602", "河南省漯河市");
        map.insert("412621", "河南省长葛县");
        map.insert("412622", "河南省禹县");
        map.insert("412623", "河南省鄢陵县");
        map.insert("412624", "河南省许昌县");
        map.insert("412625", "河南省郏县");
        map.insert("412626", "河南省临颍县");
        map.insert("412627", "河南省襄城县");
        map.insert("412628", "河南省宝丰县");
        map.insert("412629", "河南省郾城县");
        map.insert("412630", "河南省叶县");
        map.insert("412631", "河南省鲁山县");
        map.insert("412632", "河南省舞阳县");
        map.insert("412700", "河南省周口地区");
        map.insert("412701", "河南省周口市");
        map.insert("412702", "河南省项城市");
        map.insert("412721", "河南省扶沟县");
        map.insert("412722", "河南省西华县");
        map.insert("412723", "河南省商水县");
        map.insert("412724", "河南省太康县");
        map.insert("412725", "河南省鹿邑县");
        map.insert("412726", "河南省郸城县");
        map.insert("412727", "河南省淮阳县");
        map.insert("412728", "河南省沈丘县");
        map.insert("412729", "河南省项城县");
        map.insert("412800", "河南省驻马店地区");
        map.insert("412801", "河南省驻马店市");
        map.insert("412821", "河南省确山县");
        map.insert("412822", "河南省泌阳县");
        map.insert("412823", "河南省遂平县");
        map.insert("412824", "河南省西平县");
        map.insert("412825", "河南省上蔡县");
        map.insert("412826", "河南省汝南县");
        map.insert("412827", "河南省平舆县");
        map.insert("412828", "河南省新蔡县");
        map.insert("412829", "河南省正阳县");
        map.insert("412900", "河南省南阳地区");
        map.insert("412901", "河南省南阳市");
        map.insert("412902", "河南省邓州市");
        map.insert("412921", "河南省南召县");
        map.insert("412922", "河南省方城县");
        map.insert("412923", "河南省西峡县");
        map.insert("412924", "河南省南阳县");
        map.insert("412925", "河南省镇平县");
        map.insert("412926", "河南省内乡县");
        map.insert("412927", "河南省淅川县");
        map.insert("412928", "河南省社旗县");
        map.insert("412929", "河南省唐河县");
        map.insert("412930", "河南省邓县");
        map.insert("412931", "河南省新野县");
        map.insert("412932", "河南省桐柏县");
        map.insert("413000", "河南省信阳地区");
        map.insert("413001", "河南省信阳市");
        map.insert("413021", "河南省息县");
        map.insert("413022", "河南省淮滨县");
        map.insert("413023", "河南省信阳县");
        map.insert("413024", "河南省潢川县");
        map.insert("413025", "河南省光山县");
        map.insert("413026", "河南省固始县");
        map.insert("413027", "河南省商城县");
        map.insert("413028", "河南省罗山县");
        map.insert("413029", "河南省新县");
        map.insert("419000", "河南省省直辖行政单位");
        map.insert("419001", "河南省义马市");
        map.insert("419002", "河南省汝州市");
        map.insert("419003", "河南省济源市");
        map.insert("419004", "河南省禹州市");
        map.insert("419005", "河南省卫辉市");
        map.insert("419006", "河南省辉县市");
        map.insert("420000", "湖北省");
        map.insert("420100", "武汉市");
        map.insert("420101", "武汉市市辖区");
        map.insert("420102", "武汉市江岸区");
        map.insert("420103", "武汉市江汉区");
        map.insert("420104", "武汉市硚口区");
        map.insert("420105", "武汉市汉阳区");
        map.insert("420106", "武汉市武昌区");
        map.insert("420107", "武汉市青山区");
        map.insert("420111", "武汉市洪山区");
        map.insert("420112", "武汉市东西湖区");
        map.insert("420113", "武汉市汉南区");
        map.insert("420114", "武汉市蔡甸区");
        map.insert("420115", "武汉市江夏区");
        map.insert("420116", "武汉市黄陂区");
        map.insert("420117", "武汉市新洲区");
        map.insert("420120", "武汉市区");
        map.insert("420121", "湖北省汉阳县");
        map.insert("420122", "湖北省武昌县");
        map.insert("420123", "湖北省黄陂县");
        map.insert("420124", "湖北省新洲县");
        map.insert("420200", "湖北省黄石市");
        map.insert("420201", "湖北省黄石市市辖区");
        map.insert("420202", "湖北省黄石市黄石港区");
        map.insert("420203", "湖北省黄石市西塞山区");
        map.insert("420204", "湖北省黄石市下陆区");
        map.insert("420205", "湖北省黄石市铁山区");
        map.insert("420220", "湖北省黄石市区");
        map.insert("420221", "湖北省大冶县");
        map.insert("420222", "湖北省阳新县");
        map.insert("420281", "湖北省大冶市");
        map.insert("420300", "湖北省十堰市");
        map.insert("420301", "湖北省十堰市市辖区");
        map.insert("420302", "湖北省十堰市茅箭区");
        map.insert("420303", "湖北省十堰市张湾区");
        map.insert("420321", "湖北省郧县");
        map.insert("420322", "湖北省郧西县");
        map.insert("420323", "湖北省竹山县");
        map.insert("420324", "湖北省竹溪县");
        map.insert("420325", "湖北省房县");
        map.insert("420381", "湖北省丹江口市");
        map.insert("420400", "湖北省沙市市");
        map.insert("420500", "湖北省宜昌市");
        map.insert("420501", "湖北省宜昌市市辖区");
        map.insert("420502", "湖北省宜昌市西陵区");
        map.insert("420503", "湖北省宜昌市伍家岗区");
        map.insert("420504", "湖北省宜昌市点军区");
        map.insert("420505", "湖北省宜昌市猇亭区");
        map.insert("420506", "湖北省宜昌市夷陵区");
        map.insert("420521", "湖北省宜昌县");
        map.insert("420523", "湖北省枝江县");
        map.insert("420525", "湖北省远安县");
        map.insert("420526", "湖北省兴山县");
        map.insert("420527", "湖北省秭归县");
        map.insert("420528", "湖北省长阳土家族自治县");
        map.insert("420529", "湖北省五峰土家族自治县");
        map.insert("420581", "湖北省宜都市");
        map.insert("420582", "湖北省当阳市");
        map.insert("420583", "湖北省枝江市");
        map.insert("420600", "湖北省襄樊市");
        map.insert("420601", "湖北省襄樊市市辖区");
        map.insert("420602", "湖北省襄樊市襄城区");
        map.insert("420603", "湖北省襄樊市樊东区");
        map.insert("420604", "湖北省襄樊市樊西区");
        map.insert("420605", "湖北省襄樊市郊区");
        map.insert("420606", "湖北省襄樊市樊城区");
        map.insert("420607", "湖北省襄樊市襄阳区");
        map.insert("420619", "湖北省随州市");
        map.insert("420620", "湖北省老河口市");
        map.insert("420621", "湖北省襄阳县");
        map.insert("420622", "湖北省枣阳县");
        map.insert("420623", "湖北省宜城县");
        map.insert("420624", "湖北省南漳县");
        map.insert("420625", "湖北省谷城县");
        map.insert("420626", "湖北省保康县");
        map.insert("420681", "湖北省随州市");
        map.insert("420682", "湖北省老河口市");
        map.insert("420683", "湖北省枣阳市");
        map.insert("420684", "湖北省宜城市");
        map.insert("420700", "湖北省鄂州市");
        map.insert("420701", "湖北省鄂州市市辖区");
        map.insert("420702", "湖北省鄂州市梁子湖区");
        map.insert("420703", "湖北省鄂州市华容区");
        map.insert("420704", "湖北省鄂州市鄂城区");
        map.insert("420800", "湖北省荆门市");
        map.insert("420801", "湖北省荆门市市辖区");
        map.insert("420802", "湖北省荆门市东宝区");
        map.insert("420803", "湖北省荆门市掇刀区");
        map.insert("420804", "湖北省荆门市掇刀区");
        map.insert("420821", "湖北省京山县");
        map.insert("420822", "湖北省沙洋县");
        map.insert("420881", "湖北省钟祥市");
        map.insert("420900", "湖北省孝感市");
        map.insert("420901", "湖北省孝感市市辖区");
        map.insert("420902", "湖北省孝感市孝南区");
        map.insert("420921", "湖北省孝昌县");
        map.insert("420922", "湖北省大悟县");
        map.insert("420923", "湖北省云梦县");
        map.insert("420924", "湖北省汉川县");
        map.insert("420981", "湖北省应城市");
        map.insert("420982", "湖北省安陆市");
        map.insert("420983", "湖北省广水市");
        map.insert("420984", "湖北省汉川市");
        map.insert("421000", "湖北省荆州市");
        map.insert("421001", "湖北省荆州市市辖区");
        map.insert("421002", "湖北省荆州市沙市区");
        map.insert("421003", "湖北省荆州市荆州区");
        map.insert("421004", "湖北省荆州市江陵区");
        map.insert("421022", "湖北省公安县");
        map.insert("421023", "湖北省监利县");
        map.insert("421024", "湖北省江陵县");
        map.insert("421081", "湖北省石首市");
        map.insert("421083", "湖北省洪湖市");
        map.insert("421087", "湖北省松滋市");
        map.insert("421100", "湖北省黄冈市");
        map.insert("421101", "湖北省黄冈市市辖区");
        map.insert("421102", "湖北省黄冈市黄州区");
        map.insert("421121", "湖北省团风县");
        map.insert("421122", "湖北省红安县");
        map.insert("421123", "湖北省罗田县");
        map.insert("421124", "湖北省英山县");
        map.insert("421125", "湖北省浠水县");
        map.insert("421126", "湖北省蕲春县");
        map.insert("421127", "湖北省黄梅县");
        map.insert("421181", "湖北省麻城市");
        map.insert("421182", "湖北省武穴市");
        map.insert("421200", "湖北省咸宁市");
        map.insert("421201", "湖北省咸宁市市辖区");
        map.insert("421202", "湖北省咸宁市咸安区");
        map.insert("421221", "湖北省嘉鱼县");
        map.insert("421222", "湖北省通城县");
        map.insert("421223", "湖北省崇阳县");
        map.insert("421224", "湖北省通山县");
        map.insert("421281", "湖北省赤壁市");
        map.insert("421300", "湖北省随州市");
        map.insert("421301", "湖北省随州市市辖区");
        map.insert("421302", "湖北省随州市曾都区");
        map.insert("421381", "湖北省广水市");
        map.insert("422100", "湖北省黄冈地区");
        map.insert("422101", "湖北省麻城市");
        map.insert("422102", "湖北省武穴市");
        map.insert("422103", "湖北省黄州市");
        map.insert("422121", "湖北省黄冈县");
        map.insert("422122", "湖北省新洲县");
        map.insert("422123", "湖北省红安县");
        map.insert("422124", "湖北省麻城县");
        map.insert("422125", "湖北省罗田县");
        map.insert("422126", "湖北省英山县");
        map.insert("422127", "湖北省浠水县");
        map.insert("422128", "湖北省蕲春县");
        map.insert("422129", "湖北省广济县");
        map.insert("422130", "湖北省黄梅县");
        map.insert("422131", "湖北省鄂城县");
        map.insert("422200", "湖北省孝感地区");
        map.insert("422201", "湖北省孝感市");
        map.insert("422202", "湖北省应城市");
        map.insert("422203", "湖北省安陆市");
        map.insert("422204", "湖北省广水市");
        map.insert("422221", "湖北省孝感县");
        map.insert("422222", "湖北省黄陂县");
        map.insert("422223", "湖北省大悟县");
        map.insert("422224", "湖北省应山县");
        map.insert("422225", "湖北省安陆县");
        map.insert("422226", "湖北省云梦县");
        map.insert("422227", "湖北省应城县");
        map.insert("422228", "湖北省汉川县");
        map.insert("422300", "湖北省咸宁地区");
        map.insert("422301", "湖北省咸宁市");
        map.insert("422302", "湖北省赤壁市");
        map.insert("422321", "湖北省咸宁县");
        map.insert("422322", "湖北省嘉鱼县");
        map.insert("422323", "湖北省蒲圻县");
        map.insert("422324", "湖北省通城县");
        map.insert("422325", "湖北省崇阳县");
        map.insert("422326", "湖北省通山县");
        map.insert("422327", "湖北省阳新县");
        map.insert("422400", "湖北省荆州地区");
        map.insert("422401", "湖北省仙桃市");
        map.insert("422402", "湖北省石首市");
        map.insert("422403", "湖北省洪湖市");
        map.insert("422404", "湖北省天门市");
        map.insert("422405", "湖北省潜江市");
        map.insert("422406", "湖北省钟祥市");
        map.insert("422421", "湖北省江陵县");
        map.insert("422422", "湖北省松滋县");
        map.insert("422423", "湖北省公安县");
        map.insert("422424", "湖北省石首县");
        map.insert("422425", "湖北省监利县");
        map.insert("422426", "湖北省洪湖县");
        map.insert("422427", "湖北省沔阳县");
        map.insert("422428", "湖北省天门县");
        map.insert("422429", "湖北省潜江县");
        map.insert("422430", "湖北省荆门县");
        map.insert("422431", "湖北省钟祥县");
        map.insert("422432", "湖北省京山县");
        map.insert("422500", "湖北省襄阳地区");
        map.insert("422501", "湖北省随州市");
        map.insert("422502", "湖北省老河口市");
        map.insert("422521", "湖北省襄阳县");
        map.insert("422522", "湖北省枣阳县");
        map.insert("422523", "湖北省随县");
        map.insert("422524", "湖北省宜城县");
        map.insert("422525", "湖北省南漳县");
        map.insert("422526", "湖北省光华县");
        map.insert("422527", "湖北省谷城县");
        map.insert("422528", "湖北省保康县");
        map.insert("422600", "湖北省郧阳地区");
        map.insert("422601", "湖北省丹江口市");
        map.insert("422621", "湖北省均县");
        map.insert("422622", "湖北省郧县");
        map.insert("422623", "湖北省郧西县");
        map.insert("422624", "湖北省竹山县");
        map.insert("422625", "湖北省竹溪县");
        map.insert("422626", "湖北省房县");
        map.insert("422627", "湖北省神农架林区");
        map.insert("422700", "湖北省宜昌地区");
        map.insert("422701", "湖北省枝城市");
        map.insert("422702", "湖北省当阳市");
        map.insert("422721", "湖北省宜昌县");
        map.insert("422722", "湖北省宜都县");
        map.insert("422723", "湖北省枝江县");
        map.insert("422724", "湖北省当阳县");
        map.insert("422725", "湖北省远安县");
        map.insert("422726", "湖北省兴山县");
        map.insert("422727", "湖北省秭归县");
        map.insert("422728", "湖北省长阳土家族自治县");
        map.insert("422729", "湖北省五峰土家族自治县");
        map.insert("422800", "湖北省恩施土家族苗族自治州");
        map.insert("422801", "湖北省恩施市");
        map.insert("422802", "湖北省利川市");
        map.insert("422821", "湖北省恩施县");
        map.insert("422822", "湖北省建始县");
        map.insert("422823", "湖北省巴东县");
        map.insert("422824", "湖北省利川县");
        map.insert("422825", "湖北省宣恩县");
        map.insert("422826", "湖北省咸丰县");
        map.insert("422827", "湖北省来凤县");
        map.insert("422828", "湖北省鹤峰县");
        map.insert("422900", "湖北省省直辖行政单位");
        map.insert("422921", "湖北省神农架林区");
        map.insert("429000", "湖北省直属行政单位");
        map.insert("429001", "湖北省随州市");
        map.insert("429002", "湖北省老河口市");
        map.insert("429003", "湖北省枣阳市");
        map.insert("429004", "湖北省仙桃市");
        map.insert("429005", "湖北省潜江市");
        map.insert("429006", "湖北省天门市");
        map.insert("429021", "湖北省神农架林区");
        map.insert("430000", "湖南省");
        map.insert("430100", "湖南省长沙市");
        map.insert("430101", "湖南省长沙市市辖区");
        map.insert("430102", "湖南省长沙市芙蓉区");
        map.insert("430103", "湖南省长沙市天心区");
        map.insert("430104", "湖南省长沙市岳麓区");
        map.insert("430105", "湖南省长沙市开福区");
        map.insert("430111", "湖南省长沙市雨花区");
        map.insert("430120", "湖南省长沙市区");
        map.insert("430121", "湖南省长沙县");
        map.insert("430122", "湖南省望城县");
        map.insert("430123", "湖南省浏阳县");
        map.insert("430124", "湖南省宁乡县");
        map.insert("430181", "湖南省浏阳市");
        map.insert("430200", "湖南省株洲市");
        map.insert("430201", "湖南省株洲市市辖区");
        map.insert("430202", "湖南省株洲市荷塘区");
        map.insert("430203", "湖南省株洲市芦淞区");
        map.insert("430204", "湖南省株洲市石峰区");
        map.insert("430211", "湖南省株洲市天元区");
        map.insert("430219", "湖南省醴陵市");
        map.insert("430220", "湖南省株州市区");
        map.insert("430221", "湖南省株洲县");
        map.insert("430222", "湖南省醴陵县");
        map.insert("430223", "湖南省攸县");
        map.insert("430224", "湖南省茶陵县");
        map.insert("430225", "湖南省炎陵县");
        map.insert("430281", "湖南省醴陵市");
        map.insert("430300", "湖南省湘潭市");
        map.insert("430301", "湖南省湘潭市市辖区");
        map.insert("430302", "湖南省湘潭市雨湖区");
        map.insert("430303", "湖南省湘潭市湘江区");
        map.insert("430304", "湖南省湘潭市岳塘区");
        map.insert("430305", "湖南省湘潭市板塘区");
        map.insert("430306", "湖南省湘潭市韶山区");
        map.insert("430311", "湖南省湘潭市郊区");
        map.insert("430312", "湖南省湘潭市韶山区");
        map.insert("430321", "湖南省湘潭县");
        map.insert("430322", "湖南省湘乡县");
        map.insert("430381", "湖南省湘乡市");
        map.insert("430382", "湖南省韶山市");
        map.insert("430400", "湖南省衡阳市");
        map.insert("430401", "湖南省衡阳市市辖区");
        map.insert("430402", "湖南省衡阳市江东区");
        map.insert("430403", "湖南省衡阳市城南区");
        map.insert("430404", "湖南省衡阳市城北区");
        map.insert("430405", "湖南省衡阳市珠晖区");
        map.insert("430406", "湖南省衡阳市雁峰区");
        map.insert("430407", "湖南省衡阳市石鼓区");
        map.insert("430408", "湖南省衡阳市蒸湘区");
        map.insert("430411", "湖南省衡阳市郊区");
        map.insert("430412", "湖南省衡阳市南岳区");
        map.insert("430419", "湖南省耒阳市");
        map.insert("430421", "湖南省衡阳县");
        map.insert("430422", "湖南省衡南县");
        map.insert("430423", "湖南省衡山县");
        map.insert("430424", "湖南省衡东县");
        map.insert("430425", "湖南省常宁县");
        map.insert("430426", "湖南省祁东县");
        map.insert("430427", "湖南省耒阳县");
        map.insert("430481", "湖南省耒阳市");
        map.insert("430482", "湖南省常宁市");
        map.insert("430500", "湖南省邵阳市");
        map.insert("430501", "湖南省邵阳市市辖区");
        map.insert("430502", "湖南省邵阳市双清区");
        map.insert("430503", "湖南省邵阳市大祥区");
        map.insert("430504", "湖南省邵阳市桥头区");
        map.insert("430511", "湖南省邵阳市北塔区");
        map.insert("430521", "湖南省邵东县");
        map.insert("430522", "湖南省新邵县");
        map.insert("430523", "湖南省邵阳县");
        map.insert("430524", "湖南省隆回县");
        map.insert("430525", "湖南省洞口县");
        map.insert("430526", "湖南省武冈县");
        map.insert("430527", "湖南省绥宁县");
        map.insert("430528", "湖南省新宁县");
        map.insert("430529", "湖南省城步苗族自治县");
        map.insert("430581", "湖南省武冈市");
        map.insert("430600", "湖南省岳阳市");
        map.insert("430601", "湖南省岳阳市市辖区");
        map.insert("430602", "湖南省岳阳市岳阳楼区");
        map.insert("430603", "湖南省岳阳市云溪区");
        map.insert("430611", "湖南省岳阳市君山区");
        map.insert("430621", "湖南省岳阳县");
        map.insert("430622", "湖南省临湘县");
        map.insert("430623", "湖南省华容县");
        map.insert("430624", "湖南省湘阴县");
        map.insert("430625", "湖南省汨罗县");
        map.insert("430626", "湖南省平江县");
        map.insert("430681", "湖南省汨罗市");
        map.insert("430682", "湖南省临湘市");
        map.insert("430700", "湖南省常德市");
        map.insert("430701", "湖南省常德市市辖区");
        map.insert("430702", "湖南省常德市武陵区");
        map.insert("430703", "湖南省常德市鼎城区");
        map.insert("430721", "湖南省安乡县");
        map.insert("430722", "湖南省汉寿县");
        map.insert("430723", "湖南省澧县");
        map.insert("430724", "湖南省临澧县");
        map.insert("430725", "湖南省桃源县");
        map.insert("430726", "湖南省石门县");
        map.insert("430781", "湖南省津市市");
        map.insert("430800", "湖南省张家界市");
        map.insert("430801", "湖南省张家界市市辖区");
        map.insert("430802", "湖南省张家界市永定区");
        map.insert("430811", "湖南省张家界市武陵源区");
        map.insert("430821", "湖南省慈利县");
        map.insert("430822", "湖南省桑植县");
        map.insert("430900", "湖南省益阳市");
        map.insert("430901", "湖南省益阳市市辖区");
        map.insert("430902", "湖南省益阳市资阳区");
        map.insert("430903", "湖南省益阳市赫山区");
        map.insert("430921", "湖南省南县");
        map.insert("430922", "湖南省桃江县");
        map.insert("430923", "湖南省安化县");
        map.insert("430981", "湖南省沅江市");
        map.insert("431000", "湖南省郴州市");
        map.insert("431001", "湖南省郴州市市辖区");
        map.insert("431002", "湖南省郴州市北湖区");
        map.insert("431003", "湖南省郴州市苏仙区");
        map.insert("431021", "湖南省桂阳县");
        map.insert("431022", "湖南省宜章县");
        map.insert("431023", "湖南省永兴县");
        map.insert("431024", "湖南省嘉禾县");
        map.insert("431025", "湖南省临武县");
        map.insert("431026", "湖南省汝城县");
        map.insert("431027", "湖南省桂东县");
        map.insert("431028", "湖南省安仁县");
        map.insert("431081", "湖南省资兴市");
        map.insert("431100", "湖南省永州市");
        map.insert("431101", "湖南省永州市市辖区");
        map.insert("431102", "湖南省永州市芝山区");
        map.insert("431103", "湖南省永州市冷水滩区");
        map.insert("431121", "湖南省祁阳县");
        map.insert("431122", "湖南省东安县");
        map.insert("431123", "湖南省双牌县");
        map.insert("431124", "湖南省道县");
        map.insert("431125", "湖南省江永县");
        map.insert("431126", "湖南省宁远县");
        map.insert("431127", "湖南省蓝山县");
        map.insert("431128", "湖南省新田县");
        map.insert("431129", "湖南省江华瑶族自治县");
        map.insert("431200", "湖南省怀化市");
        map.insert("431201", "湖南省怀化市市辖区");
        map.insert("431202", "湖南省怀化市鹤城区");
        map.insert("431221", "湖南省中方县");
        map.insert("431222", "湖南省沅陵县");
        map.insert("431223", "湖南省辰溪县");
        map.insert("431224", "湖南省溆浦县");
        map.insert("431225", "湖南省会同县");
        map.insert("431226", "湖南省麻阳苗族自治县");
        map.insert("431227", "湖南省新晃侗族自治县");
        map.insert("431228", "湖南省芷江侗族自治县");
        map.insert("431229", "湖南省靖州苗族侗族自治县");
        map.insert("431230", "湖南省通道侗族自治县");
        map.insert("431281", "湖南省洪江市");
        map.insert("431300", "湖南省娄底市");
        map.insert("431301", "湖南省娄底市市辖区");
        map.insert("431302", "湖南省娄底市娄星区");
        map.insert("431321", "湖南省双峰县");
        map.insert("431322", "湖南省新化县");
        map.insert("431381", "湖南省冷水江市");
        map.insert("431382", "湖南省涟源市");
        map.insert("432100", "湖南省湘潭地区");
        map.insert("432121", "湖南省湘潭县");
        map.insert("432122", "湖南省湘乡县");
        map.insert("432123", "湖南省醴陵县");
        map.insert("432124", "湖南省浏阳县");
        map.insert("432125", "湖南省攸县");
        map.insert("432126", "湖南省茶陵县");
        map.insert("432127", "湖南省酃县");
        map.insert("432200", "湖南省岳阳地区");
        map.insert("432201", "湖南省岳阳市");
        map.insert("432222", "湖南省平江县");
        map.insert("432223", "湖南省湘阴县");
        map.insert("432224", "湖南省汨罗县");
        map.insert("432225", "湖南省临湘县");
        map.insert("432226", "湖南省华容县");
        map.insert("432300", "湖南省益阳地区");
        map.insert("432301", "湖南省益阳市");
        map.insert("432302", "湖南省沅江市");
        map.insert("432321", "湖南省益阳县");
        map.insert("432322", "湖南省南县");
        map.insert("432323", "湖南省沅江县");
        map.insert("432324", "湖南省宁乡县");
        map.insert("432325", "湖南省桃江县");
        map.insert("432326", "湖南省安化县");
        map.insert("432400", "湖南省常德地区");
        map.insert("432401", "湖南省常德市");
        map.insert("432402", "湖南省津市市");
        map.insert("432421", "湖南省常德县");
        map.insert("432422", "湖南省安乡县");
        map.insert("432423", "湖南省汉寿县");
        map.insert("432424", "湖南省澧县");
        map.insert("432425", "湖南省临澧县");
        map.insert("432426", "湖南省桃源县");
        map.insert("432427", "湖南省石门县");
        map.insert("432428", "湖南省慈利县");
        map.insert("432500", "湖南省娄底地区");
        map.insert("432501", "湖南省娄底市");
        map.insert("432502", "湖南省冷水江市");
        map.insert("432503", "湖南省涟源市");
        map.insert("432521", "湖南省涟源县");
        map.insert("432522", "湖南省双峰县");
        map.insert("432523", "湖南省邵东县");
        map.insert("432524", "湖南省新化县");
        map.insert("432525", "湖南省新邵县");
        map.insert("432600", "湖南省邵阳地区");
        map.insert("432621", "湖南省邵阳县");
        map.insert("432622", "湖南省隆回县");
        map.insert("432623", "湖南省武冈县");
        map.insert("432624", "湖南省洞口县");
        map.insert("432625", "湖南省新宁县");
        map.insert("432626", "湖南省绥宁县");
        map.insert("432627", "湖南省城步苗族自治县");
        map.insert("432700", "湖南省衡阳地区");
        map.insert("432721", "湖南省衡阳县");
        map.insert("432722", "湖南省衡南县");
        map.insert("432723", "湖南省衡山县");
        map.insert("432724", "湖南省衡东县");
        map.insert("432725", "湖南省常宁县");
        map.insert("432726", "湖南省祁东县");
        map.insert("432727", "湖南省祁阳县");
        map.insert("432800", "湖南省郴州地区");
        map.insert("432801", "湖南省郴州市");
        map.insert("432802", "湖南省资兴市");
        map.insert("432821", "湖南省郴县");
        map.insert("432822", "湖南省桂阳县");
        map.insert("432823", "湖南省永兴县");
        map.insert("432824", "湖南省宜章县");
        map.insert("432825", "湖南省资兴县");
        map.insert("432826", "湖南省嘉禾县");
        map.insert("432827", "湖南省临武县");
        map.insert("432828", "湖南省汝城县");
        map.insert("432829", "湖南省桂东县");
        map.insert("432830", "湖南省耒阳县");
        map.insert("432831", "湖南省安仁县");
        map.insert("432900", "湖南省零陵地区");
        map.insert("432901", "湖南省永州市");
        map.insert("432902", "湖南省冷水滩市");
        map.insert("432921", "湖南省零陵县");
        map.insert("432922", "湖南省东安县");
        map.insert("432923", "湖南省道县");
        map.insert("432924", "湖南省宁远县");
        map.insert("432925", "湖南省江永县");
        map.insert("432926", "湖南省江华瑶族自治县");
        map.insert("432927", "湖南省蓝山县");
        map.insert("432928", "湖南省新田县");
        map.insert("432929", "湖南省双牌县");
        map.insert("432930", "湖南省祁阳县");
        map.insert("433000", "湖南省怀化地区");
        map.insert("433001", "湖南省怀化市");
        map.insert("433002", "湖南省洪江市");
        map.insert("433021", "湖南省黔阳县");
        map.insert("433022", "湖南省沅陵县");
        map.insert("433023", "湖南省辰溪县");
        map.insert("433024", "湖南省溆浦县");
        map.insert("433025", "湖南省麻阳苗族自治县");
        map.insert("433026", "湖南省新晃侗族自治县");
        map.insert("433027", "湖南省芷江侗族自治县");
        map.insert("433028", "湖南省怀化县");
        map.insert("433029", "湖南省会同县");
        map.insert("433030", "湖南省靖州苗族侗族自治县");
        map.insert("433031", "湖南省通道侗族自治县");
        map.insert("433100", "湖南省湘西土家族苗族自治州");
        map.insert("433101", "湖南省吉首市");
        map.insert("433102", "湖南省大庸市");
        map.insert("433121", "湖南省吉首县");
        map.insert("433122", "湖南省泸溪县");
        map.insert("433123", "湖南省凤凰县");
        map.insert("433124", "湖南省花垣县");
        map.insert("433125", "湖南省保靖县");
        map.insert("433126", "湖南省古丈县");
        map.insert("433127", "湖南省永顺县");
        map.insert("433128", "湖南省大庸县");
        map.insert("433129", "湖南省桑植县");
        map.insert("433130", "湖南省龙山县");
        map.insert("439000", "湖南省省直辖行政单位");
        map.insert("439001", "湖南省醴陵市");
        map.insert("439002", "湖南省湘乡市");
        map.insert("439003", "湖南省耒阳市");
        map.insert("439004", "湖南省汨罗市");
        map.insert("439005", "湖南省津市市");
        map.insert("440000", "广东省");
        map.insert("440100", "广东省广州市");
        map.insert("440101", "广东省广州市市辖区");
        map.insert("440102", "广东省广州市东山区");
        map.insert("440103", "广东省广州市荔湾区");
        map.insert("440104", "广东省广州市越秀区");
        map.insert("440105", "广东省广州市海珠区");
        map.insert("440106", "广东省广州市天河区");
        map.insert("440107", "广东省广州市芳村区");
        map.insert("440111", "广东省广州市白云区");
        map.insert("440112", "广东省广州市黄埔区");
        map.insert("440113", "广东省广州市番禺区");
        map.insert("440114", "广东省广州市花都区");
        map.insert("440120", "广东省广州市区");
        map.insert("440121", "广东省花县");
        map.insert("440122", "广东省从化县");
        map.insert("440123", "广东省新丰县");
        map.insert("440124", "广东省龙门县");
        map.insert("440125", "广东省增城县");
        map.insert("440126", "广东省番禺县");
        map.insert("440127", "广东省清远县");
        map.insert("440128", "广东省佛冈县");
        map.insert("440181", "广东省番禺市");
        map.insert("440182", "广东省花都市");
        map.insert("440183", "广东省增城市");
        map.insert("440184", "广东省从化市");
        map.insert("440200", "广东省韶关市");
        map.insert("440201", "广东省韶关市市辖区");
        map.insert("440202", "广东省韶关市北江区");
        map.insert("440203", "广东省韶关市武江区");
        map.insert("440204", "广东省韶关市浈江区");
        map.insert("440205", "广东省韶关市曲江区");
        map.insert("440220", "广东省韶关市区");
        map.insert("440221", "广东省曲江县");
        map.insert("440222", "广东省始兴县");
        map.insert("440223", "广东省南雄县");
        map.insert("440224", "广东省仁化县");
        map.insert("440225", "广东省乐昌县");
        map.insert("440226", "广东省连县");
        map.insert("440227", "广东省阳山县");
        map.insert("440228", "广东省英德县");
        map.insert("440229", "广东省翁源县");
        map.insert("440230", "广东省连山壮族瑶族自治县");
        map.insert("440231", "广东省连南瑶族自治县");
        map.insert("440232", "广东省乳源瑶族自治县");
        map.insert("440233", "广东省新丰县");
        map.insert("440281", "广东省乐昌市");
        map.insert("440282", "广东省南雄市");
        map.insert("440300", "广东省深圳市");
        map.insert("440301", "广东省深圳市市辖区");
        map.insert("440302", "广东省深圳市沙头角区");
        map.insert("440303", "广东省深圳市罗湖区");
        map.insert("440304", "广东省深圳市福田区");
        map.insert("440305", "广东省深圳市南山区");
        map.insert("440306", "广东省深圳市宝安区");
        map.insert("440307", "广东省深圳市龙岗区");
        map.insert("440308", "广东省深圳市盐田区");
        map.insert("440320", "广东省深圳市区");
        map.insert("440321", "广东省宝安县");
        map.insert("440400", "广东省珠海市");
        map.insert("440401", "广东省珠海市市辖区");
        map.insert("440402", "广东省珠海市香洲区");
        map.insert("440403", "广东省珠海市斗门区");
        map.insert("440404", "广东省珠海市金湾区");
        map.insert("440421", "广东省斗门县");
        map.insert("440500", "广东省汕头市");
        map.insert("440501", "广东省汕头市市辖区");
        map.insert("440502", "广东省汕头市同平区");
        map.insert("440503", "广东省汕头市安平区");
        map.insert("440504", "广东省汕头市公园区");
        map.insert("440505", "广东省汕头市金砂区");
        map.insert("440506", "广东省汕头市达濠区");
        map.insert("440507", "广东省汕头市龙湖区");
        map.insert("440508", "广东省汕头市金园区");
        map.insert("440509", "广东省汕头市升平区");
        map.insert("440510", "广东省汕头市河浦区");
        map.insert("440511", "广东省汕头市郊区");
        map.insert("440512", "广东省汕头市濠江区");
        map.insert("440513", "广东省汕头市潮阳区");
        map.insert("440514", "广东省汕头市潮南区");
        map.insert("440515", "广东省汕头市澄海区");
        map.insert("440520", "广东省潮州市");
        map.insert("440521", "广东省澄海县");
        map.insert("440522", "广东省饶平县");
        map.insert("440523", "广东省南澳县");
        map.insert("440524", "广东省潮阳县");
        map.insert("440525", "广东省揭阳县");
        map.insert("440526", "广东省揭西县");
        map.insert("440527", "广东省普宁县");
        map.insert("440528", "广东省惠来县");
        map.insert("440581", "广东省潮州市");
        map.insert("440582", "广东省潮阳市");
        map.insert("440583", "广东省澄海市");
        map.insert("440600", "广东省佛山市");
        map.insert("440601", "广东省佛山市市辖区");
        map.insert("440602", "广东省佛山市城区");
        map.insert("440603", "广东省佛山市石湾区");
        map.insert("440604", "广东省佛山市禅城区");
        map.insert("440605", "广东省佛山市南海区");
        map.insert("440606", "广东省佛山市顺德区");
        map.insert("440607", "广东省佛山市三水区");
        map.insert("440608", "广东省佛山市高明区");
        map.insert("440620", "广东省中山市");
        map.insert("440621", "广东省三水县");
        map.insert("440622", "广东省南海县");
        map.insert("440623", "广东省顺德县");
        map.insert("440624", "广东省高明县");
        map.insert("440681", "广东省顺德市");
        map.insert("440682", "广东省南海市");
        map.insert("440683", "广东省三水市");
        map.insert("440684", "广东省高明市");
        map.insert("440700", "广东省江门市");
        map.insert("440701", "广东省江门市市辖区");
        map.insert("440702", "广东省江门市城区");
        map.insert("440703", "广东省江门市蓬江区");
        map.insert("440704", "广东省江门市江海区");
        map.insert("440705", "广东省江门市新会区");
        map.insert("440711", "广东省江门市郊区");
        map.insert("440721", "广东省新会县");
        map.insert("440722", "广东省台山县");
        map.insert("440723", "广东省恩平县");
        map.insert("440724", "广东省开平县");
        map.insert("440725", "广东省鹤山县");
        map.insert("440726", "广东省阳江县");
        map.insert("440727", "广东省阳春县");
        map.insert("440781", "广东省台山市");
        map.insert("440782", "广东省新会市");
        map.insert("440783", "广东省开平市");
        map.insert("440784", "广东省鹤山市");
        map.insert("440785", "广东省恩平市");
        map.insert("440800", "广东省湛江市");
        map.insert("440801", "广东省湛江市市辖区");
        map.insert("440802", "广东省湛江市赤坎区");
        map.insert("440803", "广东省湛江市霞山区");
        map.insert("440804", "广东省湛江市坡头区");
        map.insert("440811", "广东省湛江市麻章区");
        map.insert("440821", "广东省吴川县");
        map.insert("440822", "广东省廉江县");
        map.insert("440823", "广东省遂溪县");
        map.insert("440824", "广东省海康县");
        map.insert("440825", "广东省徐闻县");
        map.insert("440881", "广东省廉江市");
        map.insert("440882", "广东省雷州市");
        map.insert("440883", "广东省吴川市");
        map.insert("440900", "广东省茂名市");
        map.insert("440901", "广东省茂名市市辖区");
        map.insert("440902", "广东省茂名市茂南区");
        map.insert("440903", "广东省茂名市茂港区");
        map.insert("440921", "广东省信宜县");
        map.insert("440922", "广东省高州县");
        map.insert("440923", "广东省电白县");
        map.insert("440924", "广东省化州县");
        map.insert("440981", "广东省高州市");
        map.insert("440982", "广东省化州市");
        map.insert("440983", "广东省信宜市");
        map.insert("441000", "广东省海口市");
        map.insert("441200", "广东省肇庆市");
        map.insert("441201", "广东省肇庆市市辖区");
        map.insert("441202", "广东省肇庆市端州区");
        map.insert("441203", "广东省肇庆市鼎湖区");
        map.insert("441221", "广东省高要县");
        map.insert("441222", "广东省四会县");
        map.insert("441223", "广东省广宁县");
        map.insert("441224", "广东省怀集县");
        map.insert("441225", "广东省封开县");
        map.insert("441226", "广东省德庆县");
        map.insert("441227", "广东省云浮县");
        map.insert("441228", "广东省新兴县");
        map.insert("441229", "广东省郁南县");
        map.insert("441230", "广东省罗定县");
        map.insert("441281", "广东省云浮市");
        map.insert("441282", "广东省罗定市");
        map.insert("441283", "广东省高要市");
        map.insert("441284", "广东省四会市");
        map.insert("441300", "广东省惠州市");
        map.insert("441301", "广东省惠州市市辖区");
        map.insert("441302", "广东省惠州市惠城区");
        map.insert("441303", "广东省惠州市惠阳区");
        map.insert("441321", "广东省惠阳县");
        map.insert("441322", "广东省博罗县");
        map.insert("441323", "广东省惠东县");
        map.insert("441324", "广东省龙门县");
        map.insert("441381", "广东省惠阳市");
        map.insert("441400", "广东省梅州市");
        map.insert("441401", "广东省梅州市市辖区");
        map.insert("441402", "广东省梅州市梅江区");
        map.insert("441421", "广东省梅县");
        map.insert("441422", "广东省大埔县");
        map.insert("441423", "广东省丰顺县");
        map.insert("441424", "广东省五华县");
        map.insert("441425", "广东省兴宁县");
        map.insert("441426", "广东省平远县");
        map.insert("441427", "广东省蕉岭县");
        map.insert("441481", "广东省兴宁市");
        map.insert("441500", "广东省汕尾市");
        map.insert("441501", "广东省汕尾市市辖区");
        map.insert("441502", "广东省汕尾市城区");
        map.insert("441521", "广东省海丰县");
        map.insert("441522", "广东省陆丰县");
        map.insert("441523", "广东省陆河县");
        map.insert("441581", "广东省陆丰市");
        map.insert("441600", "广东省河源市");
        map.insert("441601", "广东省河源市市辖区");
        map.insert("441602", "广东省河源市源城区");
        map.insert("441611", "广东省河源市郊区");
        map.insert("441621", "广东省紫金县");
        map.insert("441622", "广东省龙川县");
        map.insert("441623", "广东省连平县");
        map.insert("441624", "广东省和平县");
        map.insert("441625", "广东省东源县");
        map.insert("441700", "广东省阳江市");
        map.insert("441701", "广东省阳江市市辖区");
        map.insert("441702", "广东省阳江市江城区");
        map.insert("441703", "广东省阳江市阳东区");
        map.insert("441721", "广东省阳西县");
        map.insert("441722", "广东省阳春县");
        map.insert("441723", "广东省阳东县");
        map.insert("441781", "广东省阳春市");
        map.insert("441800", "广东省清远市");
        map.insert("441801", "广东省清远市市辖区");
        map.insert("441802", "广东省清远市清城区");
        map.insert("441811", "广东省清远市清郊区");
        map.insert("441821", "广东省佛冈县");
        map.insert("441822", "广东省英德县");
        map.insert("441823", "广东省阳山县");
        map.insert("441824", "广东省连县");
        map.insert("441825", "广东省连山壮族瑶族自治县");
        map.insert("441826", "广东省连南瑶族自治县");
        map.insert("441827", "广东省清新县");
        map.insert("441881", "广东省英德市");
        map.insert("441882", "广东省连州市");
        map.insert("441900", "广东省东莞市");
        map.insert("442000", "广东省中山市");
        map.insert("442100", "广东省海南行政区");
        map.insert("442101", "广东省海口市");
        map.insert("442121", "广东省琼山县");
        map.insert("442122", "广东省文昌县");
        map.insert("442123", "广东省琼海县");
        map.insert("442124", "广东省万宁县");
        map.insert("442125", "广东省定安县");
        map.insert("442126", "广东省屯昌县");
        map.insert("442127", "广东省澄迈县");
        map.insert("442128", "广东省临高县");
        map.insert("442129", "广东省儋县");
        map.insert("442200", "广东省海南行政区黎族苗族自治州");
        map.insert("442201", "广东省三亚市");
        map.insert("442202", "广东省通什市");
        map.insert("442221", "广东省崖县");
        map.insert("442222", "广东省东方县");
        map.insert("442223", "广东省乐东县");
        map.insert("442224", "广东省琼中县");
        map.insert("442225", "广东省保亭县");
        map.insert("442226", "广东省陵水县");
        map.insert("442227", "广东省白沙县");
        map.insert("442228", "广东省昌江县");
        map.insert("442229", "广东省西沙群岛、南沙群岛、中沙群岛");
        map.insert("442300", "广东省汕头地区");
        map.insert("442301", "广东省汕头市");
        map.insert("442302", "广东省潮州市");
        map.insert("442321", "广东省潮安县");
        map.insert("442322", "广东省澄海县");
        map.insert("442323", "广东省饶平县");
        map.insert("442324", "广东省南澳县");
        map.insert("442325", "广东省潮阳县");
        map.insert("442326", "广东省揭阳县");
        map.insert("442327", "广东省揭西县");
        map.insert("442328", "广东省普宁县");
        map.insert("442329", "广东省惠来县");
        map.insert("442330", "广东省陆丰县");
        map.insert("442331", "广东省海丰县");
        map.insert("442400", "广东省梅县地区");
        map.insert("442401", "广东省梅县市");
        map.insert("442421", "广东省梅县");
        map.insert("442422", "广东省大埔县");
        map.insert("442423", "广东省丰顺县");
        map.insert("442424", "广东省五华县");
        map.insert("442425", "广东省兴宁县");
        map.insert("442426", "广东省平远县");
        map.insert("442427", "广东省蕉岭县");
        map.insert("442500", "广东省惠阳地区");
        map.insert("442501", "广东省惠州市");
        map.insert("442502", "广东省东莞市");
        map.insert("442521", "广东省惠阳县");
        map.insert("442522", "广东省紫金县");
        map.insert("442523", "广东省和平县");
        map.insert("442524", "广东省连平县");
        map.insert("442525", "广东省河源县");
        map.insert("442526", "广东省博罗县");
        map.insert("442527", "广东省东莞县");
        map.insert("442528", "广东省惠东县");
        map.insert("442529", "广东省龙川县");
        map.insert("442530", "广东省陆丰县");
        map.insert("442531", "广东省海丰县");
        map.insert("442600", "广东省韶关地区");
        map.insert("442621", "广东省始兴县");
        map.insert("442622", "广东省南雄县");
        map.insert("442623", "广东省仁化县");
        map.insert("442624", "广东省乐昌县");
        map.insert("442625", "广东省连县");
        map.insert("442626", "广东省阳山县");
        map.insert("442627", "广东省英德县");
        map.insert("442628", "广东省清远县");
        map.insert("442629", "广东省佛冈县");
        map.insert("442630", "广东省翁源县");
        map.insert("442631", "广东省连山壮族瑶族自治县");
        map.insert("442632", "广东省连南瑶族自治县");
        map.insert("442633", "广东省乳源瑶族自治县");
        map.insert("442700", "广东省佛山地区");
        map.insert("442701", "广东省佛山市");
        map.insert("442702", "广东省江门市");
        map.insert("442721", "广东省三水县");
        map.insert("442722", "广东省南海县");
        map.insert("442723", "广东省顺德县");
        map.insert("442724", "广东省中山县");
        map.insert("442725", "广东省斗门县");
        map.insert("442726", "广东省新会县");
        map.insert("442727", "广东省台山县");
        map.insert("442728", "广东省恩平县");
        map.insert("442729", "广东省开平县");
        map.insert("442731", "广东省鹤山县");
        map.insert("442732", "广东省高明县");
        map.insert("442800", "广东省肇庆地区");
        map.insert("442801", "广东省肇庆市");
        map.insert("442821", "广东省高要县");
        map.insert("442822", "广东省四会县");
        map.insert("442823", "广东省广宁县");
        map.insert("442824", "广东省怀集县");
        map.insert("442825", "广东省封开县");
        map.insert("442826", "广东省德庆县");
        map.insert("442827", "广东省云浮县");
        map.insert("442828", "广东省新兴县");
        map.insert("442829", "广东省郁南县");
        map.insert("442830", "广东省罗定县");
        map.insert("442900", "广东省湛江地区");
        map.insert("442901", "广东省湛江市");
        map.insert("442902", "广东省茂名市");
        map.insert("442921", "广东省阳江县");
        map.insert("442922", "广东省阳春县");
        map.insert("442923", "广东省信宜县");
        map.insert("442924", "广东省高州县");
        map.insert("442925", "广东省电白县");
        map.insert("442926", "广东省吴川县");
        map.insert("442927", "广东省化州县");
        map.insert("442928", "广东省廉江县");
        map.insert("442929", "广东省遂溪县");
        map.insert("442930", "广东省海康县");
        map.insert("442931", "广东省徐闻县");
        map.insert("445100", "广东省潮州市");
        map.insert("445101", "广东省潮州市市辖区");
        map.insert("445102", "广东省潮州市湘桥区");
        map.insert("445121", "广东省潮安县");
        map.insert("445122", "广东省饶平县");
        map.insert("445200", "广东省揭阳市");
        map.insert("445201", "广东省揭阳市市辖区");
        map.insert("445202", "广东省揭阳市榕城区");
        map.insert("445221", "广东省揭东县");
        map.insert("445222", "广东省揭西县");
        map.insert("445224", "广东省惠来县");
        map.insert("445281", "广东省普宁市");
        map.insert("445300", "广东省云浮市");
        map.insert("445301", "广东省云浮市市辖区");
        map.insert("445302", "广东省云浮市云城区");
        map.insert("445321", "广东省新兴县");
        map.insert("445322", "广东省郁南县");
        map.insert("445323", "广东省云安县");
        map.insert("445381", "广东省罗定市");
        map.insert("449000", "广东省省直辖行政单位");
        map.insert("449001", "广东省潮州市");
        map.insert("450000", "广西壮族自治区");
        map.insert("450100", "广西壮族自治区南宁市");
        map.insert("450101", "广西壮族自治区南宁市市辖区");
        map.insert("450102", "广西壮族自治区南宁市兴宁区");
        map.insert("450103", "广西壮族自治区南宁市青秀区");
        map.insert("450104", "广西壮族自治区南宁市城北区");
        map.insert("450105", "广西壮族自治区南宁市江南区");
        map.insert("450106", "广西壮族自治区南宁市永新区");
        map.insert("450107", "广西壮族自治区南宁市西乡塘区");
        map.insert("450108", "广西壮族自治区南宁市良庆区");
        map.insert("450109", "广西壮族自治区南宁市邕宁区");
        map.insert("450111", "广西壮族自治区南宁市市郊区");
        map.insert("450121", "广西壮族自治区邕宁县");
        map.insert("450122", "广西壮族自治区武鸣县");
        map.insert("450123", "广西壮族自治区隆安县");
        map.insert("450124", "广西壮族自治区马山县");
        map.insert("450125", "广西壮族自治区上林县");
        map.insert("450126", "广西壮族自治区宾阳县");
        map.insert("450127", "广西壮族自治区横县");
        map.insert("450200", "广西壮族自治区柳州市");
        map.insert("450201", "广西壮族自治区柳州市市辖区");
        map.insert("450202", "广西壮族自治区柳州市城中区");
        map.insert("450203", "广西壮族自治区柳州市鱼峰区");
        map.insert("450204", "广西壮族自治区柳州市柳南区");
        map.insert("450205", "广西壮族自治区柳州市柳北区");
        map.insert("450211", "广西壮族自治区柳州市市郊区");
        map.insert("450221", "广西壮族自治区柳江县");
        map.insert("450222", "广西壮族自治区柳城县");
        map.insert("450223", "广西壮族自治区鹿寨县");
        map.insert("450224", "广西壮族自治区融安县");
        map.insert("450225", "广西壮族自治区融水苗族自治县");
        map.insert("450226", "广西壮族自治区三江侗族自治县");
        map.insert("450300", "广西壮族自治区桂林市");
        map.insert("450301", "广西壮族自治区桂林市市辖区");
        map.insert("450302", "广西壮族自治区桂林市秀峰区");
        map.insert("450303", "广西壮族自治区桂林市叠彩区");
        map.insert("450304", "广西壮族自治区桂林市象山区");
        map.insert("450305", "广西壮族自治区桂林市七星区");
        map.insert("450311", "广西壮族自治区桂林市雁山区");
        map.insert("450321", "广西壮族自治区阳朔县");
        map.insert("450322", "广西壮族自治区临桂县");
        map.insert("450323", "广西壮族自治区灵川县");
        map.insert("450324", "广西壮族自治区全州县");
        map.insert("450325", "广西壮族自治区兴安县");
        map.insert("450326", "广西壮族自治区永福县");
        map.insert("450327", "广西壮族自治区灌阳县");
        map.insert("450328", "广西壮族自治区龙胜各族自治县");
        map.insert("450329", "广西壮族自治区资源县");
        map.insert("450330", "广西壮族自治区平乐县");
        map.insert("450331", "广西壮族自治区荔蒲县");
        map.insert("450332", "广西壮族自治区恭城瑶族自治县");
        map.insert("450400", "广西壮族自治区梧州市");
        map.insert("450401", "广西壮族自治区梧州市市辖区");
        map.insert("450403", "广西壮族自治区梧州市万秀区");
        map.insert("450404", "广西壮族自治区梧州市蝶山区");
        map.insert("450405", "广西壮族自治区梧州市长洲区");
        map.insert("450411", "广西壮族自治区梧州市市郊区");
        map.insert("450421", "广西壮族自治区苍梧县");
        map.insert("450422", "广西壮族自治区藤县");
        map.insert("450423", "广西壮族自治区蒙山县");
        map.insert("450481", "广西壮族自治区岑溪市");
        map.insert("450500", "广西壮族自治区北海市");
        map.insert("450501", "广西壮族自治区北海市市辖区");
        map.insert("450502", "广西壮族自治区北海市海城区");
        map.insert("450503", "广西壮族自治区北海市银海区");
        map.insert("450512", "广西壮族自治区北海市铁山港区");
        map.insert("450521", "广西壮族自治区合浦县");
        map.insert("450600", "广西壮族自治区防城港市");
        map.insert("450601", "广西壮族自治区防城港市市辖区");
        map.insert("450602", "广西壮族自治区防城港市港口区");
        map.insert("450603", "广西壮族自治区防城港市防城区");
        map.insert("450621", "广西壮族自治区上思县");
        map.insert("450681", "广西壮族自治区东兴市");
        map.insert("450700", "广西壮族自治区钦州市");
        map.insert("450701", "广西壮族自治区钦州市市辖区");
        map.insert("450702", "广西壮族自治区钦州市钦南区");
        map.insert("450703", "广西壮族自治区钦州市钦北区");
        map.insert("450721", "广西壮族自治区灵山县");
        map.insert("450722", "广西壮族自治区浦北县");
        map.insert("450800", "广西壮族自治区贵港市");
        map.insert("450801", "广西壮族自治区贵港市市辖区");
        map.insert("450802", "广西壮族自治区贵港市港北区");
        map.insert("450803", "广西壮族自治区贵港市港南区");
        map.insert("450804", "广西壮族自治区贵港市覃塘区");
        map.insert("450821", "广西壮族自治区平南县");
        map.insert("450881", "广西壮族自治区桂平市");
        map.insert("450900", "广西壮族自治区玉林市");
        map.insert("450901", "广西壮族自治区玉林市市辖区");
        map.insert("450902", "广西壮族自治区玉林市玉州区");
        map.insert("450921", "广西壮族自治区容县");
        map.insert("450922", "广西壮族自治区陆川县");
        map.insert("450923", "广西壮族自治区博白县");
        map.insert("450924", "广西壮族自治区兴业县");
        map.insert("450981", "广西壮族自治区北流市");
        map.insert("451000", "广西壮族自治区百色市");
        map.insert("451001", "广西壮族自治区百色市市辖区");
        map.insert("451002", "广西壮族自治区百色市右江区");
        map.insert("451021", "广西壮族自治区田阳县");
        map.insert("451022", "广西壮族自治区田东县");
        map.insert("451023", "广西壮族自治区平果县");
        map.insert("451024", "广西壮族自治区德保县");
        map.insert("451025", "广西壮族自治区靖西县");
        map.insert("451026", "广西壮族自治区那坡县");
        map.insert("451027", "广西壮族自治区凌云县");
        map.insert("451028", "广西壮族自治区乐业县");
        map.insert("451029", "广西壮族自治区田林县");
        map.insert("451030", "广西壮族自治区西林县");
        map.insert("451031", "广西壮族自治区隆林各族自治县");
        map.insert("451100", "广西壮族自治区贺州市");
        map.insert("451101", "广西壮族自治区贺州市市辖区");
        map.insert("451102", "广西壮族自治区贺州市八步区");
        map.insert("451121", "广西壮族自治区昭平县");
        map.insert("451122", "广西壮族自治区钟山县");
        map.insert("451123", "广西壮族自治区富川瑶族自治县");
        map.insert("451200", "广西壮族自治区河池市");
        map.insert("451201", "广西壮族自治区河池市市辖区");
        map.insert("451202", "广西壮族自治区河池市金城江区");
        map.insert("451221", "广西壮族自治区南丹县");
        map.insert("451222", "广西壮族自治区天峨县");
        map.insert("451223", "广西壮族自治区凤山县");
        map.insert("451224", "广西壮族自治区东兰县");
        map.insert("451225", "广西壮族自治区罗城仫佬族自治县");
        map.insert("451226", "广西壮族自治区环江毛南族自治县");
        map.insert("451227", "广西壮族自治区巴马瑶族自治县");
        map.insert("451228", "广西壮族自治区都安瑶族自治县");
        map.insert("451229", "广西壮族自治区大化瑶族自治县");
        map.insert("451281", "广西壮族自治区宜州市");
        map.insert("451300", "广西壮族自治区来宾市");
        map.insert("451301", "广西壮族自治区来宾市市辖区");
        map.insert("451302", "广西壮族自治区来宾市兴宾区");
        map.insert("451321", "广西壮族自治区忻城县");
        map.insert("451322", "广西壮族自治区象州县");
        map.insert("451323", "广西壮族自治区武宣县");
        map.insert("451324", "广西壮族自治区金秀瑶族自治县");
        map.insert("451381", "广西壮族自治区合山市");
        map.insert("451400", "广西壮族自治区崇左市");
        map.insert("451401", "广西壮族自治区崇左市市辖区");
        map.insert("451402", "广西壮族自治区崇左市江洲区");
        map.insert("451421", "广西壮族自治区扶绥县");
        map.insert("451422", "广西壮族自治区宁明县");
        map.insert("451423", "广西壮族自治区龙州县");
        map.insert("451424", "广西壮族自治区大新县");
        map.insert("451425", "广西壮族自治区天等县");
        map.insert("451481", "广西壮族自治区凭祥市");
        map.insert("452100", "广西壮族自治区南宁地区");
        map.insert("452101", "广西壮族自治区凭祥市");
        map.insert("452122", "广西壮族自治区横县");
        map.insert("452123", "广西壮族自治区宾阳县");
        map.insert("452124", "广西壮族自治区上林县");
        map.insert("452126", "广西壮族自治区隆安县");
        map.insert("452127", "广西壮族自治区马山县");
        map.insert("452128", "广西壮族自治区扶绥县");
        map.insert("452129", "广西壮族自治区崇左县");
        map.insert("452130", "广西壮族自治区大新县");
        map.insert("452131", "广西壮族自治区天等县");
        map.insert("452132", "广西壮族自治区宁明县");
        map.insert("452133", "广西壮族自治区龙州县");
        map.insert("452200", "广西壮族自治区柳州地区");
        map.insert("452201", "广西壮族自治区合山市");
        map.insert("452223", "广西壮族自治区鹿寨县");
        map.insert("452224", "广西壮族自治区象州县");
        map.insert("452225", "广西壮族自治区武宣县");
        map.insert("452226", "广西壮族自治区来宾县");
        map.insert("452227", "广西壮族自治区融安县");
        map.insert("452228", "广西壮族自治区三江侗族自治县");
        map.insert("452229", "广西壮族自治区融水苗族自治县");
        map.insert("452230", "广西壮族自治区金秀瑶族自治县");
        map.insert("452231", "广西壮族自治区忻城县");
        map.insert("452400", "广西壮族自治区贺州地区");
        map.insert("452402", "广西壮族自治区贺州市");
        map.insert("452424", "广西壮族自治区昭平县");
        map.insert("452427", "广西壮族自治区钟山县");
        map.insert("452428", "广西壮族自治区富川瑶族自治县");
        map.insert("452600", "广西壮族自治区百色地区");
        map.insert("452601", "广西壮族自治区百色市");
        map.insert("452622", "广西壮族自治区田阳县");
        map.insert("452623", "广西壮族自治区田东县");
        map.insert("452624", "广西壮族自治区平果县");
        map.insert("452625", "广西壮族自治区德保县");
        map.insert("452626", "广西壮族自治区靖西县");
        map.insert("452627", "广西壮族自治区那坡县");
        map.insert("452628", "广西壮族自治区凌云县");
        map.insert("452629", "广西壮族自治区乐业县");
        map.insert("452630", "广西壮族自治区田林县");
        map.insert("452631", "广西壮族自治区隆林各族自治县");
        map.insert("452632", "广西壮族自治区西林县");
        map.insert("452700", "广西壮族自治区河池地区");
        map.insert("452701", "广西壮族自治区河池市");
        map.insert("452702", "广西壮族自治区宜州市");
        map.insert("452723", "广西壮族自治区罗城仫佬族自治县");
        map.insert("452724", "广西壮族自治区环江毛南族自治县");
        map.insert("452725", "广西壮族自治区南丹县");
        map.insert("452726", "广西壮族自治区天峨县");
        map.insert("452727", "广西壮族自治区凤山县");
        map.insert("452728", "广西壮族自治区东兰县");
        map.insert("452729", "广西壮族自治区巴马瑶族自治县");
        map.insert("452730", "广西壮族自治区都安瑶族自治县");
        map.insert("452731", "广西壮族自治区大化瑶族自治县");
        map.insert("460000", "海南省");
        map.insert("460001", "海南省通什市");
        map.insert("460002", "海南省琼海市");
        map.insert("460003", "海南省儋州市");
        map.insert("460004", "海南省琼山市");
        map.insert("460005", "海南省文昌市");
        map.insert("460006", "海南省万宁市");
        map.insert("460007", "海南省东方市");
        map.insert("460021", "海南省琼山县");
        map.insert("460022", "海南省文昌县");
        map.insert("460023", "海南省琼海县");
        map.insert("460024", "海南省万宁县");
        map.insert("460025", "海南省定安县");
        map.insert("460026", "海南省屯昌县");
        map.insert("460027", "海南省澄迈县");
        map.insert("460028", "海南省临高县");
        map.insert("460029", "海南省儋县");
        map.insert("460030", "海南省白沙黎族自治县");
        map.insert("460031", "海南省昌江黎族自治县");
        map.insert("460032", "海南省东方黎族自治县");
        map.insert("460033", "海南省乐东黎族自治县");
        map.insert("460034", "海南省陵水黎族自治县");
        map.insert("460035", "海南省保亭黎族苗族自治县");
        map.insert("460036", "海南省琼中黎族苗族自治县");
        map.insert("460037", "海南省西沙群岛");
        map.insert("460038", "海南省南沙群岛");
        map.insert("460039", "海南省中沙群岛的岛礁及其海域");
        map.insert("460100", "海南省海口市");
        map.insert("460101", "海南省海口市市辖区");
        map.insert("460102", "海南省海口市振东区");
        map.insert("460103", "海南省海口市新华区");
        map.insert("460104", "海南省海口市秀英区");
        map.insert("460105", "海南省海口市秀英区");
        map.insert("460106", "海南省海口市龙华区");
        map.insert("460107", "海南省海口市琼山区");
        map.insert("460108", "海南省海口市美兰区");
        map.insert("460200", "海南省三亚市");
        map.insert("460201", "海南省三亚市市辖区");
        map.insert("460300", "海南省洋浦经济开发区");
        map.insert("469001", "海南省五指山市");
        map.insert("469002", "海南省琼海市");
        map.insert("469003", "海南省儋州市");
        map.insert("469004", "海南省琼山市");
        map.insert("469005", "海南省文昌市");
        map.insert("469006", "海南省万宁市");
        map.insert("469007", "海南省东方市");
        map.insert("469021", "海南省定安县");
        map.insert("469022", "海南省屯昌县");
        map.insert("469023", "海南省澄迈县");
        map.insert("469024", "海南省临高县");
        map.insert("469025", "海南省白沙黎族自治县");
        map.insert("469026", "海南省昌江黎族自治县");
        map.insert("469027", "海南省乐东黎族自治县");
        map.insert("469028", "海南省陵水黎族自治县");
        map.insert("469029", "海南省保亭黎族苗族自治县");
        map.insert("469030", "海南省琼中黎族苗族自治县");
        map.insert("469031", "海南省西沙群岛");
        map.insert("469032", "海南省南沙群岛");
        map.insert("469033", "海南省中沙群岛的岛礁及其海域");
        map.insert("500000", "重庆市");
        map.insert("500100", "重庆市市辖区");
        map.insert("500101", "重庆市万州区");
        map.insert("500102", "重庆市涪陵区");
        map.insert("500103", "重庆市渝中区");
        map.insert("500104", "重庆市大渡口区");
        map.insert("500105", "重庆市江北区");
        map.insert("500106", "重庆市沙坪坝区");
        map.insert("500107", "重庆市九龙坡区");
        map.insert("500108", "重庆市南岸区");
        map.insert("500109", "重庆市北碚区");
        map.insert("500110", "重庆市万盛区");
        map.insert("500111", "重庆市双桥区");
        map.insert("500112", "重庆市渝北区");
        map.insert("500113", "重庆市巴南区");
        map.insert("500114", "重庆市黔江区");
        map.insert("500115", "重庆市长寿区");
        map.insert("500221", "重庆市长寿县");
        map.insert("500222", "重庆市綦江县");
        map.insert("500223", "重庆市潼南县");
        map.insert("500224", "重庆市铜梁县");
        map.insert("500225", "重庆市大足县");
        map.insert("500226", "重庆市荣昌县");
        map.insert("500227", "重庆市璧山县");
        map.insert("500228", "重庆市梁平县");
        map.insert("500229", "重庆市城口县");
        map.insert("500230", "重庆市丰都县");
        map.insert("500231", "重庆市垫江县");
        map.insert("500232", "重庆市武隆县");
        map.insert("500233", "重庆市忠县");
        map.insert("500234", "重庆市开县");
        map.insert("500235", "重庆市云阳县");
        map.insert("500236", "重庆市奉节县");
        map.insert("500237", "重庆市巫山县");
        map.insert("500238", "重庆市巫溪县");
        map.insert("500239", "重庆市黔江土家族苗族自治县");
        map.insert("500240", "重庆市石柱土家族自治县");
        map.insert("500241", "重庆市秀山土家族苗族自治县");
        map.insert("500242", "重庆市酉阳土家族苗族自治县");
        map.insert("500243", "重庆市彭水苗族土家族自治县");
        map.insert("500381", "重庆市江津市");
        map.insert("500382", "重庆市合川市");
        map.insert("500383", "重庆市永川市");
        map.insert("500384", "重庆市南川市");
        map.insert("510000", "四川省");
        map.insert("510100", "四川省成都市");
        map.insert("510101", "四川省成都市市辖区");
        map.insert("510102", "四川省成都市东城区");
        map.insert("510103", "四川省成都市西城区");
        map.insert("510104", "四川省成都市锦江区");
        map.insert("510105", "四川省成都市青羊区");
        map.insert("510106", "四川省成都市金牛区");
        map.insert("510107", "四川省成都市武侯区");
        map.insert("510108", "四川省成都市成华区");
        map.insert("510111", "四川省成都市金牛区");
        map.insert("510112", "四川省成都市龙泉驿区");
        map.insert("510113", "四川省成都市青白江区");
        map.insert("510114", "四川省成都市新都区");
        map.insert("510115", "四川省成都市温江区");
        map.insert("510120", "四川省成都市区");
        map.insert("510121", "四川省金堂县");
        map.insert("510122", "四川省双流县");
        map.insert("510123", "四川省温江县");
        map.insert("510124", "四川省郫县");
        map.insert("510125", "四川省新都县");
        map.insert("510126", "四川省彭县");
        map.insert("510127", "四川省灌县");
        map.insert("510128", "四川省崇庆县");
        map.insert("510129", "四川省大邑县");
        map.insert("510130", "四川省邛崃县");
        map.insert("510131", "四川省蒲江县");
        map.insert("510132", "四川省新津县");
        map.insert("510181", "四川省都江堰市");
        map.insert("510182", "四川省彭州市");
        map.insert("510183", "四川省邛崃市");
        map.insert("510184", "四川省崇州市");
        map.insert("510200", "四川省重庆市");
        map.insert("510201", "四川省重庆市市辖区");
        map.insert("510202", "四川省重庆市市中区");
        map.insert("510203", "四川省重庆市大渡口区");
        map.insert("510211", "四川省重庆市江北区");
        map.insert("510212", "四川省重庆市沙平坝区");
        map.insert("510213", "四川省重庆市九龙坡区");
        map.insert("510214", "四川省重庆市南岸区");
        map.insert("510215", "四川省重庆市北碚区");
        map.insert("510216", "四川省重庆市万盛区(南桐矿区)");
        map.insert("510217", "四川省重庆市双桥区");
        map.insert("510220", "四川省重庆市区");
        map.insert("510221", "四川省长寿县");
        map.insert("510222", "四川省巴县");
        map.insert("510223", "四川省綦江县");
        map.insert("510224", "四川省江北县");
        map.insert("510225", "四川省江津县");
        map.insert("510226", "四川省合川县");
        map.insert("510227", "四川省潼南县");
        map.insert("510228", "四川省铜梁县");
        map.insert("510229", "四川省永川县");
        map.insert("510230", "四川省大足县");
        map.insert("510231", "四川省荣昌县");
        map.insert("510232", "四川省璧山县");
        map.insert("510281", "四川省永川市");
        map.insert("510282", "四川省江津市");
        map.insert("510283", "四川省合川市");
        map.insert("510300", "四川省自贡市");
        map.insert("510301", "四川省自贡市市辖区");
        map.insert("510302", "四川省自贡市自流井区");
        map.insert("510303", "四川省自贡市贡井区");
        map.insert("510304", "四川省自贡市大安区");
        map.insert("510311", "四川省自贡市沿滩区");
        map.insert("510320", "四川省自贡市区");
        map.insert("510321", "四川省荣县");
        map.insert("510322", "四川省富顺县");
        map.insert("510400", "四川省攀枝花市");
        map.insert("510401", "四川省攀枝花市市辖区");
        map.insert("510402", "四川省攀枝花市东区");
        map.insert("510403", "四川省攀枝花市西区");
        map.insert("510411", "四川省攀枝花市仁和区");
        map.insert("510420", "四川省渡口市区");
        map.insert("510421", "四川省米易县");
        map.insert("510422", "四川省盐边县");
        map.insert("510500", "四川省泸州市");
        map.insert("510501", "四川省泸州市市辖区");
        map.insert("510502", "四川省泸州市江阳区");
        map.insert("510503", "四川省泸州市纳溪区");
        map.insert("510504", "四川省泸州市龙马潭区");
        map.insert("510521", "四川省泸县");
        map.insert("510522", "四川省合江县");
        map.insert("510523", "四川省纳溪县");
        map.insert("510524", "四川省叙永县");
        map.insert("510525", "四川省古蔺县");
        map.insert("510600", "四川省德阳市");
        map.insert("510601", "四川省德阳市市辖区");
        map.insert("510602", "四川省德阳市市中区");
        map.insert("510603", "四川省德阳市旌阳区");
        map.insert("510621", "四川省德阳县");
        map.insert("510622", "四川省绵竹县");
        map.insert("510623", "四川省中江县");
        map.insert("510624", "四川省广汉县");
        map.insert("510625", "四川省什邡县");
        map.insert("510626", "四川省罗江县");
        map.insert("510681", "四川省广汉市");
        map.insert("510682", "四川省什邡市");
        map.insert("510683", "四川省绵竹市");
        map.insert("510700", "四川省绵阳市");
        map.insert("510701", "四川省绵阳市市辖区");
        map.insert("510702", "四川省绵阳市市中区");
        map.insert("510703", "四川省绵阳市涪城区");
        map.insert("510704", "四川省绵阳市游仙区");
        map.insert("510721", "四川省江油县");
        map.insert("510722", "四川省三台县");
        map.insert("510723", "四川省盐亭县");
        map.insert("510724", "四川省安县");
        map.insert("510725", "四川省梓潼县");
        map.insert("510726", "四川省北川羌族自治县");
        map.insert("510727", "四川省平武县");
        map.insert("510781", "四川省江油市");
        map.insert("510800", "四川省广元市");
        map.insert("510801", "四川省广元市市辖区");
        map.insert("510802", "四川省广元市市中区");
        map.insert("510811", "四川省广元市元坝区");
        map.insert("510812", "四川省广元市朝天区");
        map.insert("510821", "四川省旺苍县");
        map.insert("510822", "四川省青川县");
        map.insert("510823", "四川省剑阁县");
        map.insert("510824", "四川省苍溪县");
        map.insert("510900", "四川省遂宁市");
        map.insert("510901", "四川省遂宁市市辖区");
        map.insert("510902", "四川省遂宁市市中区");
        map.insert("510903", "四川省遂宁市船山区");
        map.insert("510904", "四川省遂宁市安居区");
        map.insert("510921", "四川省蓬溪县");
        map.insert("510922", "四川省射洪县");
        map.insert("510923", "四川省大英县");
        map.insert("511000", "四川省内江市");
        map.insert("511001", "四川省内江市市辖区");
        map.insert("511002", "四川省内江市市中区");
        map.insert("511011", "四川省内江市东兴区");
        map.insert("511021", "四川省内江县");
        map.insert("511022", "四川省乐至县");
        map.insert("511023", "四川省安岳县");
        map.insert("511024", "四川省威远县");
        map.insert("511025", "四川省资中县");
        map.insert("511026", "四川省资阳县");
        map.insert("511027", "四川省简阳县");
        map.insert("511028", "四川省隆昌县");
        map.insert("511081", "四川省资阳市");
        map.insert("511082", "四川省简阳市");
        map.insert("511100", "四川省乐山市");
        map.insert("511101", "四川省乐山市市辖区");
        map.insert("511102", "四川省乐山市市中区");
        map.insert("511111", "四川省乐山市沙湾区");
        map.insert("511112", "四川省乐山市五通桥区");
        map.insert("511113", "四川省乐山市金口河区");
        map.insert("511121", "四川省仁寿县");
        map.insert("511122", "四川省眉山县");
        map.insert("511123", "四川省犍为县");
        map.insert("511124", "四川省井研县");
        map.insert("511125", "四川省峨眉县");
        map.insert("511126", "四川省夹江县");
        map.insert("511127", "四川省洪雅县");
        map.insert("511128", "四川省彭山县");
        map.insert("511129", "四川省沐川县");
        map.insert("511130", "四川省青神县");
        map.insert("511131", "四川省丹棱县");
        map.insert("511132", "四川省峨边彝族自治县");
        map.insert("511133", "四川省马边彝族自治县");
        map.insert("511181", "四川省峨眉山市");
        map.insert("511200", "四川省万县市");
        map.insert("511201", "四川省万县市市辖区");
        map.insert("511202", "四川省万县市龙宝区");
        map.insert("511203", "四川省万县市天城区");
        map.insert("511204", "四川省万县市五桥区");
        map.insert("511221", "四川省开县");
        map.insert("511222", "四川省忠县");
        map.insert("511223", "四川省梁平县");
        map.insert("511224", "四川省云阳县");
        map.insert("511225", "四川省奉节县");
        map.insert("511226", "四川省巫山县");
        map.insert("511227", "四川省巫溪县");
        map.insert("511228", "四川省城口县");
        map.insert("511300", "四川省南充市");
        map.insert("511301", "四川省南充市市辖区");
        map.insert("511302", "四川省南充市顺庆区");
        map.insert("511303", "四川省南充市高坪区");
        map.insert("511304", "四川省南充市嘉陵区");
        map.insert("511321", "四川省南部县");
        map.insert("511322", "四川省营山县");
        map.insert("511323", "四川省蓬安县");
        map.insert("511324", "四川省仪陇县");
        map.insert("511325", "四川省西充县");
        map.insert("511381", "四川省阆中市");
        map.insert("511400", "四川省眉山市");
        map.insert("511401", "四川省眉山市市辖区");
        map.insert("511402", "四川省眉山市东坡区");
        map.insert("511421", "四川省仁寿县");
        map.insert("511422", "四川省彭山县");
        map.insert("511423", "四川省洪雅县");
        map.insert("511424", "四川省丹棱县");
        map.insert("511425", "四川省青神县");
        map.insert("511500", "四川省宜宾市");
        map.insert("511501", "四川省宜宾市市辖区");
        map.insert("511502", "四川省宜宾市翠屏区");
        map.insert("511521", "四川省宜宾县");
        map.insert("511522", "四川省南溪县");
        map.insert("511523", "四川省江安县");
        map.insert("511524", "四川省长宁县");
        map.insert("511525", "四川省高县");
        map.insert("511526", "四川省珙县");
        map.insert("511527", "四川省筠连县");
        map.insert("511528", "四川省兴文县");
        map.insert("511529", "四川省屏山县");
        map.insert("511600", "四川省广安市");
        map.insert("511601", "四川省广安市市辖区");
        map.insert("511602", "四川省广安市广安区");
        map.insert("511621", "四川省岳池县");
        map.insert("511622", "四川省武胜县");
        map.insert("511623", "四川省邻水县");
        map.insert("511681", "四川省华莹市");
        map.insert("511700", "四川省达州市");
        map.insert("511701", "四川省达州市市辖区");
        map.insert("511702", "四川省达州市通川区");
        map.insert("511721", "四川省达县");
        map.insert("511722", "四川省宣汉县");
        map.insert("511723", "四川省开江县");
        map.insert("511724", "四川省大竹县");
        map.insert("511725", "四川省渠县");
        map.insert("511781", "四川省万源市");
        map.insert("511800", "四川省雅安市");
        map.insert("511801", "四川省雅安市市辖区");
        map.insert("511802", "四川省雅安市雨城区");
        map.insert("511821", "四川省名山县");
        map.insert("511822", "四川省荥经县");
        map.insert("511823", "四川省汉源县");
        map.insert("511824", "四川省石棉县");
        map.insert("511825", "四川省天全县");
        map.insert("511826", "四川省芦山县");
        map.insert("511827", "四川省宝兴县");
        map.insert("511900", "四川省巴中市");
        map.insert("511901", "四川省巴中市市辖区");
        map.insert("511902", "四川省巴中市巴州区");
        map.insert("511921", "四川省通江县");
        map.insert("511922", "四川省南江县");
        map.insert("511923", "四川省平昌县");
        map.insert("512000", "四川省资阳市");
        map.insert("512001", "四川省资阳市市辖区");
        map.insert("512002", "四川省资阳市雁江区");
        map.insert("512021", "四川省安岳县");
        map.insert("512022", "四川省乐至县");
        map.insert("512081", "四川省简阳市");
        map.insert("512100", "四川省永川地区");
        map.insert("512121", "四川省江津县");
        map.insert("512122", "四川省合川县");
        map.insert("512123", "四川省潼南县");
        map.insert("512124", "四川省铜梁县");
        map.insert("512125", "四川省永川县");
        map.insert("512126", "四川省大足县");
        map.insert("512127", "四川省荣昌县");
        map.insert("512128", "四川省璧山县");
        map.insert("512200", "四川省万县地区");
        map.insert("512201", "四川省万县市");
        map.insert("512221", "四川省万县");
        map.insert("512222", "四川省开县");
        map.insert("512223", "四川省忠县");
        map.insert("512224", "四川省梁平县");
        map.insert("512225", "四川省云阳县");
        map.insert("512226", "四川省奉节县");
        map.insert("512227", "四川省巫山县");
        map.insert("512228", "四川省巫溪县");
        map.insert("512229", "四川省城口县");
        map.insert("512300", "四川省涪陵地区");
        map.insert("512301", "四川省涪陵市");
        map.insert("512321", "四川省涪陵县");
        map.insert("512322", "四川省垫江县");
        map.insert("512323", "四川省南川县");
        map.insert("512324", "四川省丰都县");
        map.insert("512325", "四川省石柱土家族自治县");
        map.insert("512326", "四川省武隆县");
        map.insert("512327", "四川省彭水苗族土家族自治县");
        map.insert("512328", "四川省黔江土家族苗族自治县");
        map.insert("512329", "四川省酉阳土家族苗族自治县");
        map.insert("512330", "四川省秀山土家族苗族自治县");
        map.insert("512400", "四川省内江地区");
        map.insert("512401", "四川省内江市");
        map.insert("512421", "四川省内江县");
        map.insert("512422", "四川省资中县");
        map.insert("512423", "四川省资阳县");
        map.insert("512424", "四川省简阳县");
        map.insert("512425", "四川省威远县");
        map.insert("512426", "四川省隆昌县");
        map.insert("512427", "四川省安岳县");
        map.insert("512428", "四川省乐至县");
        map.insert("512500", "四川省宜宾地区");
        map.insert("512501", "四川省宜宾市");
        map.insert("512502", "四川省泸州市");
        map.insert("512521", "四川省泸县");
        map.insert("512522", "四川省富顺县");
        map.insert("512523", "四川省合江县");
        map.insert("512524", "四川省纳溪县");
        map.insert("512525", "四川省叙永县");
        map.insert("512526", "四川省古蔺县");
        map.insert("512527", "四川省宜宾县");
        map.insert("512528", "四川省南溪县");
        map.insert("512529", "四川省江安县");
        map.insert("512530", "四川省长宁县");
        map.insert("512531", "四川省高县");
        map.insert("512532", "四川省筠连县");
        map.insert("512533", "四川省珙县");
        map.insert("512534", "四川省兴文县");
        map.insert("512535", "四川省屏山县");
        map.insert("512600", "四川省乐山地区");
        map.insert("512601", "四川省乐山市");
        map.insert("512621", "四川省仁寿县");
        map.insert("512622", "四川省眉山县");
        map.insert("512623", "四川省犍为县");
        map.insert("512624", "四川省井研县");
        map.insert("512625", "四川省峨眉县");
        map.insert("512626", "四川省夹江县");
        map.insert("512627", "四川省洪雅县");
        map.insert("512628", "四川省彭山县");
        map.insert("512629", "四川省沐川县");
        map.insert("512630", "四川省青神县");
        map.insert("512631", "四川省丹棱县");
        map.insert("512632", "四川省峨边彝族自治县");
        map.insert("512633", "四川省马边彝族自治县");
        map.insert("512634", "四川省金口河工农区");
        map.insert("512700", "四川省温江地区");
        map.insert("512721", "四川省温江县");
        map.insert("512722", "四川省郫县");
        map.insert("512723", "四川省新都县");
        map.insert("512724", "四川省广汉县");
        map.insert("512725", "四川省什邡县");
        map.insert("512726", "四川省彭县");
        map.insert("512727", "四川省灌县");
        map.insert("512728", "四川省崇庆县");
        map.insert("512729", "四川省大邑县");
        map.insert("512730", "四川省邛崃县");
        map.insert("512731", "四川省蒲江县");
        map.insert("512732", "四川省新津县");
        map.insert("512800", "四川省绵阳地区");
        map.insert("512801", "四川省绵阳市");
        map.insert("512821", "四川省德阳县");
        map.insert("512822", "四川省绵竹县");
        map.insert("512823", "四川省安县");
        map.insert("512824", "四川省江油县");
        map.insert("512825", "四川省梓潼县");
        map.insert("512826", "四川省剑阁县");
        map.insert("512827", "四川省广元县");
        map.insert("512828", "四川省旺苍县");
        map.insert("512829", "四川省青川县");
        map.insert("512830", "四川省平武县");
        map.insert("512831", "四川省北川县");
        map.insert("512832", "四川省遂宁县");
        map.insert("512833", "四川省三台县");
        map.insert("512834", "四川省中江县");
        map.insert("512835", "四川省蓬溪县");
        map.insert("512836", "四川省射洪县");
        map.insert("512837", "四川省盐亭县");
        map.insert("512900", "四川省南充地区");
        map.insert("512901", "四川省南充市");
        map.insert("512902", "四川省华蓥市");
        map.insert("512903", "四川省阆中市");
        map.insert("512921", "四川省南充县");
        map.insert("512922", "四川省南部县");
        map.insert("512923", "四川省岳池县");
        map.insert("512924", "四川省营山县");
        map.insert("512925", "四川省广安县");
        map.insert("512926", "四川省蓬安县");
        map.insert("512927", "四川省仪陇县");
        map.insert("512928", "四川省武胜县");
        map.insert("512929", "四川省西充县");
        map.insert("512930", "四川省阆中县");
        map.insert("512931", "四川省苍溪县");
        map.insert("512932", "四川省华云工农区");
        map.insert("513000", "四川省达川地区");
        map.insert("513001", "四川省达川市");
        map.insert("513002", "四川省万源市");
        map.insert("513021", "四川省达县");
        map.insert("513022", "四川省宣汉县");
        map.insert("513023", "四川省开江县");
        map.insert("513024", "四川省万源县");
        map.insert("513025", "四川省通江县");
        map.insert("513026", "四川省南江县");
        map.insert("513027", "四川省巴中县");
        map.insert("513028", "四川省平昌县");
        map.insert("513029", "四川省大竹县");
        map.insert("513030", "四川省渠县");
        map.insert("513031", "四川省邻水县");
        map.insert("513032", "四川省白沙工农区");
        map.insert("513100", "四川省雅安地区");
        map.insert("513101", "四川省雅安市");
        map.insert("513121", "四川省雅安县");
        map.insert("513122", "四川省名山县");
        map.insert("513123", "四川省荥经县");
        map.insert("513124", "四川省汉源县");
        map.insert("513125", "四川省石棉县");
        map.insert("513126", "四川省天全县");
        map.insert("513127", "四川省芦山县");
        map.insert("513128", "四川省宝兴县");
        map.insert("513200", "四川省阿坝藏族羌族自治州");
        map.insert("513221", "四川省汶川县");
        map.insert("513222", "四川省理县");
        map.insert("513223", "四川省茂县");
        map.insert("513224", "四川省松潘县");
        map.insert("513225", "四川省九寨沟县");
        map.insert("513226", "四川省金川县");
        map.insert("513227", "四川省小金县");
        map.insert("513228", "四川省黑水县");
        map.insert("513229", "四川省马尔康县");
        map.insert("513230", "四川省壤塘县");
        map.insert("513231", "四川省阿坝县");
        map.insert("513232", "四川省若尔盖县");
        map.insert("513233", "四川省红原县");
        map.insert("513300", "四川省甘孜藏族自治州");
        map.insert("513321", "四川省康定县");
        map.insert("513322", "四川省泸定县");
        map.insert("513323", "四川省丹巴县");
        map.insert("513324", "四川省九龙县");
        map.insert("513325", "四川省雅江县");
        map.insert("513326", "四川省道孚县");
        map.insert("513327", "四川省炉霍县");
        map.insert("513328", "四川省甘孜县");
        map.insert("513329", "四川省新龙县");
        map.insert("513330", "四川省德格县");
        map.insert("513331", "四川省白玉县");
        map.insert("513332", "四川省石渠县");
        map.insert("513333", "四川省色达县");
        map.insert("513334", "四川省理塘县");
        map.insert("513335", "四川省巴塘县");
        map.insert("513336", "四川省乡城县");
        map.insert("513337", "四川省稻城县");
        map.insert("513338", "四川省得荣县");
        map.insert("513400", "四川省凉山彝族自治州");
        map.insert("513401", "四川省西昌市");
        map.insert("513421", "四川省西昌县");
        map.insert("513422", "四川省木里藏族自治县");
        map.insert("513423", "四川省盐源县");
        map.insert("513424", "四川省德昌县");
        map.insert("513425", "四川省会理县");
        map.insert("513426", "四川省会东县");
        map.insert("513427", "四川省宁南县");
        map.insert("513428", "四川省普格县");
        map.insert("513429", "四川省布拖县");
        map.insert("513430", "四川省金阳县");
        map.insert("513431", "四川省昭觉县");
        map.insert("513432", "四川省喜德县");
        map.insert("513433", "四川省冕宁县");
        map.insert("513434", "四川省越西县");
        map.insert("513435", "四川省甘洛县");
        map.insert("513436", "四川省美姑县");
        map.insert("513437", "四川省雷波县");
        map.insert("513500", "四川省黔江地区");
        map.insert("513521", "四川省石柱土家族自治县");
        map.insert("513522", "四川省秀山土家族苗族自治县");
        map.insert("513523", "四川省黔江土家族苗族自治县");
        map.insert("513524", "四川省酉阳土家族苗族自治县");
        map.insert("513525", "四川省彭水苗族土家族自治县");
        map.insert("513600", "四川省广安地区");
        map.insert("513601", "四川省华蓥市");
        map.insert("513621", "四川省岳池县");
        map.insert("513622", "四川省广安县");
        map.insert("513623", "四川省武胜县");
        map.insert("513624", "四川省邻水县");
        map.insert("513700", "四川省巴中地区");
        map.insert("513701", "四川省巴中市");
        map.insert("513721", "四川省通江县");
        map.insert("513722", "四川省南江县");
        map.insert("513723", "四川省平昌县");
        map.insert("513800", "四川省眉山地区");
        map.insert("513821", "四川省眉山县");
        map.insert("513822", "四川省仁寿县");
        map.insert("513823", "四川省彭山县");
        map.insert("513824", "四川省洪雅县");
        map.insert("513825", "四川省丹棱县");
        map.insert("513826", "四川省青神县");
        map.insert("513900", "四川省资阳地区");
        map.insert("513901", "四川省资阳市");
        map.insert("513902", "四川省简阳市");
        map.insert("513921", "四川省安岳县");
        map.insert("513922", "四川省乐至县");
        map.insert("519000", "四川省直辖行政单位");
        map.insert("519001", "四川省广汉市");
        map.insert("519002", "四川省江油市");
        map.insert("519003", "四川省都江堰市");
        map.insert("519004", "四川省峨眉山市");
        map.insert("520000", "贵州省");
        map.insert("520100", "贵州省贵阳市");
        map.insert("520101", "贵州省贵阳市市辖区");
        map.insert("520102", "贵州省贵阳市南明区");
        map.insert("520103", "贵州省贵阳市云岩区");
        map.insert("520111", "贵州省贵阳市花溪区");
        map.insert("520112", "贵州省贵阳市乌当区");
        map.insert("520113", "贵州省贵阳市白云区");
        map.insert("520114", "贵州省贵阳市小河区");
        map.insert("520121", "贵州省开阳县");
        map.insert("520122", "贵州省息烽县");
        map.insert("520123", "贵州省修文县");
        map.insert("520181", "贵州省清镇市");
        map.insert("520200", "贵州省六盘水市");
        map.insert("520201", "贵州省六盘水市钟山区");
        map.insert("520202", "贵州省六盘水市盘县特区");
        map.insert("520203", "贵州省六盘水市六枝特区");
        map.insert("520204", "贵州省六盘水市六枝特区");
        map.insert("520221", "贵州省水城县");
        map.insert("520222", "贵州省盘县");
        map.insert("520300", "贵州省遵义市");
        map.insert("520301", "贵州省遵义市市辖区");
        map.insert("520302", "贵州省遵义市红花岗区");
        map.insert("520303", "贵州省遵义市汇川区");
        map.insert("520321", "贵州省遵义县");
        map.insert("520322", "贵州省桐梓县");
        map.insert("520323", "贵州省绥阳县");
        map.insert("520324", "贵州省正安县");
        map.insert("520325", "贵州省道真仡佬族苗族自治县");
        map.insert("520326", "贵州省务川仡佬族苗族自治县");
        map.insert("520327", "贵州省凤冈县");
        map.insert("520328", "贵州省湄潭县");
        map.insert("520329", "贵州省余庆县");
        map.insert("520330", "贵州省习水县");
        map.insert("520381", "贵州省赤水市");
        map.insert("520382", "贵州省仁怀市");
        map.insert("520400", "贵州省安顺市");
        map.insert("520401", "贵州省安顺市市辖区");
        map.insert("520402", "贵州省安顺市西秀区");
        map.insert("520421", "贵州省平坝县");
        map.insert("520422", "贵州省普定县");
        map.insert("520423", "贵州省镇宁布依族苗族自治县");
        map.insert("520424", "贵州省关岭布依族苗族自治县");
        map.insert("520425", "贵州省紫云苗族布依族自治县");
        map.insert("522100", "贵州省遵义地区");
        map.insert("522101", "贵州省遵义市");
        map.insert("522102", "贵州省赤水市");
        map.insert("522103", "贵州省仁怀市");
        map.insert("522121", "贵州省遵义县");
        map.insert("522122", "贵州省桐梓县");
        map.insert("522123", "贵州省绥阳县");
        map.insert("522124", "贵州省正安县");
        map.insert("522125", "贵州省道真仡佬族苗族自治县");
        map.insert("522126", "贵州省务川仡佬族苗族自治县");
        map.insert("522127", "贵州省凤冈县");
        map.insert("522128", "贵州省湄潭县");
        map.insert("522129", "贵州省余庆县");
        map.insert("522130", "贵州省仁怀县");
        map.insert("522131", "贵州省赤水县");
        map.insert("522132", "贵州省习水县");
        map.insert("522200", "贵州省铜仁地区");
        map.insert("522201", "贵州省铜仁市");
        map.insert("522221", "贵州省铜仁县");
        map.insert("522222", "贵州省江口县");
        map.insert("522223", "贵州省玉屏侗族自治县");
        map.insert("522224", "贵州省石阡县");
        map.insert("522225", "贵州省思南县");
        map.insert("522226", "贵州省印江土家族苗族自治县");
        map.insert("522227", "贵州省德江县");
        map.insert("522228", "贵州省沿河土家族自治县");
        map.insert("522229", "贵州省松桃苗族自治县");
        map.insert("522230", "贵州省万山特区");
        map.insert("522300", "贵州省黔西南布依族苗族自治州");
        map.insert("522301", "贵州省兴义市");
        map.insert("522321", "贵州省兴义县");
        map.insert("522322", "贵州省兴仁县");
        map.insert("522323", "贵州省普安县");
        map.insert("522324", "贵州省晴隆县");
        map.insert("522325", "贵州省贞丰县");
        map.insert("522326", "贵州省望谟县");
        map.insert("522327", "贵州省册亨县");
        map.insert("522328", "贵州省安龙县");
        map.insert("522400", "贵州省毕节地区");
        map.insert("522401", "贵州省毕节市");
        map.insert("522421", "贵州省毕节县");
        map.insert("522422", "贵州省大方县");
        map.insert("522423", "贵州省黔西县");
        map.insert("522424", "贵州省金沙县");
        map.insert("522425", "贵州省织金县");
        map.insert("522426", "贵州省纳雍县");
        map.insert("522427", "贵州省威宁彝族回族苗族自治县");
        map.insert("522428", "贵州省赫章县");
        map.insert("522500", "贵州省安顺地区");
        map.insert("522501", "贵州省安顺市");
        map.insert("522502", "贵州省清镇市");
        map.insert("522521", "贵州省安顺县");
        map.insert("522522", "贵州省开阳县");
        map.insert("522523", "贵州省息烽县");
        map.insert("522524", "贵州省修文县");
        map.insert("522525", "贵州省清镇县");
        map.insert("522526", "贵州省平坝县");
        map.insert("522527", "贵州省普定县");
        map.insert("522528", "贵州省关岭布依族苗族自治县");
        map.insert("522529", "贵州省镇宁布依族苗族自治县");
        map.insert("522530", "贵州省紫云苗族布依族自治县");
        map.insert("522600", "贵州省黔东南苗族侗族自治州");
        map.insert("522601", "贵州省凯里市");
        map.insert("522621", "贵州省凯里县");
        map.insert("522622", "贵州省黄平县");
        map.insert("522623", "贵州省施秉县");
        map.insert("522624", "贵州省三穗县");
        map.insert("522625", "贵州省镇远县");
        map.insert("522626", "贵州省岑巩县");
        map.insert("522627", "贵州省天柱县");
        map.insert("522628", "贵州省锦屏县");
        map.insert("522629", "贵州省剑河县");
        map.insert("522630", "贵州省台江县");
        map.insert("522631", "贵州省黎平县");
        map.insert("522632", "贵州省榕江县");
        map.insert("522633", "贵州省从江县");
        map.insert("522634", "贵州省雷山县");
        map.insert("522635", "贵州省麻江县");
        map.insert("522636", "贵州省丹寨县");
        map.insert("522700", "贵州省黔南布依族苗族自治州");
        map.insert("522701", "贵州省都匀市");
        map.insert("522702", "贵州省福泉市");
        map.insert("522721", "贵州省都匀县");
        map.insert("522722", "贵州省荔波县");
        map.insert("522723", "贵州省贵定县");
        map.insert("522724", "贵州省福泉县");
        map.insert("522725", "贵州省瓮安县");
        map.insert("522726", "贵州省独山县");
        map.insert("522727", "贵州省平塘县");
        map.insert("522728", "贵州省罗甸县");
        map.insert("522729", "贵州省长顺县");
        map.insert("522730", "贵州省龙里县");
        map.insert("522731", "贵州省惠水县");
        map.insert("522732", "贵州省三都水族自治县");
        map.insert("530000", "云南省");
        map.insert("530100", "云南省昆明市");
        map.insert("530101", "云南省昆明市市辖区");
        map.insert("530102", "云南省昆明市五华区");
        map.insert("530103", "云南省昆明市盘龙区");
        map.insert("530111", "云南省昆明市官渡区");
        map.insert("530112", "云南省昆明市西山区");
        map.insert("530113", "云南省昆明市东川区");
        map.insert("530120", "云南省昆明市区");
        map.insert("530121", "云南省呈贡县");
        map.insert("530122", "云南省晋宁县");
        map.insert("530123", "云南省安宁县");
        map.insert("530124", "云南省富民县");
        map.insert("530125", "云南省宜良县");
        map.insert("530126", "云南省石林彝族自治县");
        map.insert("530127", "云南省嵩明县");
        map.insert("530128", "云南省禄劝彝族苗族自治县");
        map.insert("530129", "云南省寻甸回族彝族自治县");
        map.insert("530181", "云南省安宁市");
        map.insert("530200", "云南省东川市");
        map.insert("530201", "云南省东川市市辖区");
        map.insert("530300", "云南省曲靖市");
        map.insert("530301", "云南省曲靖市市辖区");
        map.insert("530302", "云南省曲靖市麒麟区");
        map.insert("530321", "云南省马龙县");
        map.insert("530322", "云南省陆良县");
        map.insert("530323", "云南省师宗县");
        map.insert("530324", "云南省罗平县");
        map.insert("530325", "云南省富源县");
        map.insert("530326", "云南省会泽县");
        map.insert("530328", "云南省沾益县");
        map.insert("530381", "云南省宣威市");
        map.insert("530400", "云南省玉溪市");
        map.insert("530401", "云南省玉溪市市辖区");
        map.insert("530402", "云南省玉溪市红塔区");
        map.insert("530421", "云南省江川县");
        map.insert("530422", "云南省澄江县");
        map.insert("530423", "云南省通海县");
        map.insert("530424", "云南省华宁县");
        map.insert("530425", "云南省易门县");
        map.insert("530426", "云南省峨山彝族自治县");
        map.insert("530427", "云南省新平彝族傣族自治县");
        map.insert("530428", "云南省元江哈尼族彝族傣族自治县");
        map.insert("530500", "云南省保山市");
        map.insert("530501", "云南省保山市市辖区");
        map.insert("530502", "云南省保山市隆阳区");
        map.insert("530521", "云南省施甸县");
        map.insert("530522", "云南省腾冲县");
        map.insert("530523", "云南省龙陵县");
        map.insert("530524", "云南省昌宁县");
        map.insert("530600", "云南省昭通市");
        map.insert("530601", "云南省昭通市市辖区");
        map.insert("530602", "云南省昭通市昭阳区");
        map.insert("530621", "云南省鲁甸县");
        map.insert("530622", "云南省巧家县");
        map.insert("530623", "云南省盐津县");
        map.insert("530624", "云南省大关县");
        map.insert("530625", "云南省永善县");
        map.insert("530626", "云南省绥江县");
        map.insert("530627", "云南省镇雄县");
        map.insert("530628", "云南省彝良县");
        map.insert("530629", "云南省威信县");
        map.insert("530630", "云南省水富县");
        map.insert("530700", "云南省丽江市");
        map.insert("530701", "云南省丽江市市辖区");
        map.insert("530702", "云南省丽江市古城区");
        map.insert("530721", "云南省玉龙纳西族自治县");
        map.insert("530722", "云南省永胜县");
        map.insert("530723", "云南省华坪县");
        map.insert("530724", "云南省宁蒗彝族自治县");
        map.insert("530800", "云南省思茅市");
        map.insert("530801", "云南省思茅市市辖区");
        map.insert("530802", "云南省思茅市翠云区");
        map.insert("530821", "云南省普洱哈尼族彝族自治县");
        map.insert("530822", "云南省墨江哈尼族自治县");
        map.insert("530823", "云南省景东彝族自治县");
        map.insert("530824", "云南省景谷傣族彝族自治县");
        map.insert("530825", "云南省镇沅彝族哈尼族拉祜族自治县");
        map.insert("530826", "云南省江城哈尼族彝族自治县");
        map.insert("530827", "云南省孟连傣族拉祜族佤族自治县");
        map.insert("530828", "云南省澜沧拉祜族自治县");
        map.insert("530829", "云南省西盟佤族自治县");
        map.insert("530900", "云南省临沧市");
        map.insert("530901", "云南省临沧市市辖区");
        map.insert("530902", "云南省临沧市临翔区");
        map.insert("530921", "云南省凤庆县");
        map.insert("530922", "云南省云县");
        map.insert("530923", "云南省永德县");
        map.insert("530924", "云南省镇康县");
        map.insert("530925", "云南省双江拉祜族佤族布朗族傣族自治县");
        map.insert("530926", "云南省耿马傣族佤族自治县");
        map.insert("530927", "云南省沧源佤族自治县");
        map.insert("532100", "云南省昭通地区");
        map.insert("532101", "云南省昭通市");
        map.insert("532121", "云南省昭通县");
        map.insert("532122", "云南省鲁甸县");
        map.insert("532123", "云南省巧家县");
        map.insert("532124", "云南省盐津县");
        map.insert("532125", "云南省大关县");
        map.insert("532126", "云南省永善县");
        map.insert("532127", "云南省绥江县");
        map.insert("532128", "云南省镇雄县");
        map.insert("532129", "云南省彝良县");
        map.insert("532130", "云南省威信县");
        map.insert("532131", "云南省水富县");
        map.insert("532200", "云南省曲靖地区");
        map.insert("532201", "云南省曲靖市");
        map.insert("532202", "云南省宣威市");
        map.insert("532221", "云南省曲靖县");
        map.insert("532222", "云南省沾益县");
        map.insert("532223", "云南省马龙县");
        map.insert("532224", "云南省宣威县");
        map.insert("532225", "云南省富源县");
        map.insert("532226", "云南省罗平县");
        map.insert("532227", "云南省师宗县");
        map.insert("532228", "云南省陆良县");
        map.insert("532229", "云南省宜良县");
        map.insert("532230", "云南省路南彝族自治县");
        map.insert("532231", "云南省寻甸回族彝族自治县");
        map.insert("532232", "云南省嵩明县");
        map.insert("532233", "云南省会泽县");
        map.insert("532300", "云南省楚雄彝族自治州");
        map.insert("532301", "云南省楚雄市");
        map.insert("532321", "云南省楚雄县");
        map.insert("532322", "云南省双柏县");
        map.insert("532323", "云南省牟定县");
        map.insert("532324", "云南省南华县");
        map.insert("532325", "云南省姚安县");
        map.insert("532326", "云南省大姚县");
        map.insert("532327", "云南省永仁县");
        map.insert("532328", "云南省元谋县");
        map.insert("532329", "云南省武定县");
        map.insert("532330", "云南省禄劝县");
        map.insert("532331", "云南省禄丰县");
        map.insert("532400", "云南省玉溪地区");
        map.insert("532401", "云南省玉溪市");
        map.insert("532421", "云南省玉溪县");
        map.insert("532422", "云南省江川县");
        map.insert("532423", "云南省澄江县");
        map.insert("532424", "云南省通海县");
        map.insert("532425", "云南省华宁县");
        map.insert("532426", "云南省易门县");
        map.insert("532427", "云南省峨山彝族自治县");
        map.insert("532428", "云南省新平彝族傣族自治县");
        map.insert("532429", "云南省元江哈尼族彝族傣族自治县");
        map.insert("532500", "云南省红河哈尼族彝族自治州");
        map.insert("532501", "云南省个旧市");
        map.insert("532502", "云南省开远市");
        map.insert("532522", "云南省蒙自县");
        map.insert("532523", "云南省屏边苗族自治县");
        map.insert("532524", "云南省建水县");
        map.insert("532525", "云南省石屏县");
        map.insert("532526", "云南省弥勒县");
        map.insert("532527", "云南省泸西县");
        map.insert("532528", "云南省元阳县");
        map.insert("532529", "云南省红河县");
        map.insert("532530", "云南省金平苗族瑶族傣族自治县");
        map.insert("532531", "云南省绿春县");
        map.insert("532532", "云南省河口瑶族自治县");
        map.insert("532600", "云南省文山壮族苗族自治州");
        map.insert("532621", "云南省文山县");
        map.insert("532622", "云南省砚山县");
        map.insert("532623", "云南省西畴县");
        map.insert("532624", "云南省麻栗坡县");
        map.insert("532625", "云南省马关县");
        map.insert("532626", "云南省丘北县");
        map.insert("532627", "云南省广南县");
        map.insert("532628", "云南省富宁县");
        map.insert("532700", "云南省思茅地区");
        map.insert("532701", "云南省思茅市");
        map.insert("532721", "云南省思茅县");
        map.insert("532722", "云南省普洱哈尼族彝族自治县");
        map.insert("532723", "云南省墨江哈尼族自治县");
        map.insert("532724", "云南省景东彝族自治县");
        map.insert("532725", "云南省景谷傣族彝族自治县");
        map.insert("532726", "云南省镇沅彝族哈尼族拉祜族自治县");
        map.insert("532727", "云南省江城哈尼族彝族自治县");
        map.insert("532728", "云南省孟连傣族拉祜族佤族自治县");
        map.insert("532729", "云南省澜沧拉祜族自治县");
        map.insert("532730", "云南省西盟佤族自治县");
        map.insert("532800", "云南省西双版纳傣族自治州");
        map.insert("532801", "云南省景洪市");
        map.insert("532821", "云南省景洪县");
        map.insert("532822", "云南省勐海县");
        map.insert("532823", "云南省勐腊县");
        map.insert("532900", "云南省大理白族自治州");
        map.insert("532901", "云南省大理市");
        map.insert("532921", "云南省大理县");
        map.insert("532922", "云南省漾濞彝族自治县");
        map.insert("532923", "云南省祥云县");
        map.insert("532924", "云南省宾川县");
        map.insert("532925", "云南省弥渡县");
        map.insert("532926", "云南省南涧彝族自治县");
        map.insert("532927", "云南省巍山彝族回族自治县");
        map.insert("532928", "云南省永平县");
        map.insert("532929", "云南省云龙县");
        map.insert("532930", "云南省洱源县");
        map.insert("532931", "云南省剑川县");
        map.insert("532932", "云南省鹤庆县");
        map.insert("533000", "云南省保山地区");
        map.insert("533001", "云南省保山市");
        map.insert("533021", "云南省保山县");
        map.insert("533022", "云南省施甸县");
        map.insert("533023", "云南省腾冲县");
        map.insert("533024", "云南省龙陵县");
        map.insert("533025", "云南省昌宁县");
        map.insert("533100", "云南省德宏傣族景颇族自治州");
        map.insert("533101", "云南省畹町市");
        map.insert("533102", "云南省瑞丽市");
        map.insert("533103", "云南省潞西市");
        map.insert("533121", "云南省潞西县");
        map.insert("533122", "云南省梁河县");
        map.insert("533123", "云南省盈江县");
        map.insert("533124", "云南省陇川县");
        map.insert("533125", "云南省瑞丽县");
        map.insert("533126", "云南省畹町镇");
        map.insert("533200", "云南省丽江地区");
        map.insert("533221", "云南省丽江纳西族自治县");
        map.insert("533222", "云南省永胜县");
        map.insert("533223", "云南省华坪县");
        map.insert("533224", "云南省宁蒗彝族自治县");
        map.insert("533300", "云南省怒江傈僳族自治州");
        map.insert("533321", "云南省泸水县");
        map.insert("533322", "云南省碧江县");
        map.insert("533323", "云南省福贡县");
        map.insert("533324", "云南省贡山独龙族怒族自治县");
        map.insert("533325", "云南省兰坪白族普米族自治县");
        map.insert("533400", "云南省迪庆藏族自治州");
        map.insert("533421", "云南省香格里拉县");
        map.insert("533422", "云南省德钦县");
        map.insert("533423", "云南省维西傈僳族自治县");
        map.insert("533500", "云南省临沧地区");
        map.insert("533521", "云南省临沧县");
        map.insert("533522", "云南省凤庆县");
        map.insert("533523", "云南省云县");
        map.insert("533524", "云南省永德县");
        map.insert("533525", "云南省镇康县");
        map.insert("533526", "云南省双江拉祜族佤族布朗族傣族自治县");
        map.insert("533527", "云南省耿马傣族佤族自治县");
        map.insert("533528", "云南省沧源佤族自治县");
        map.insert("540000", "西藏自治区");
        map.insert("540100", "西藏自治区拉萨市");
        map.insert("540101", "西藏自治区拉萨市市辖区");
        map.insert("540102", "西藏自治区拉萨市城关区");
        map.insert("540120", "西藏自治区拉萨市区");
        map.insert("540121", "西藏自治区林周县");
        map.insert("540122", "西藏自治区当雄县");
        map.insert("540123", "西藏自治区尼木县");
        map.insert("540124", "西藏自治区曲水县");
        map.insert("540125", "西藏自治区堆龙德庆县");
        map.insert("540126", "西藏自治区达孜县");
        map.insert("540127", "西藏自治区墨竹工卡县");
        map.insert("540128", "西藏自治区工布江达县");
        map.insert("540129", "西藏自治区林芝县");
        map.insert("540130", "西藏自治区米林县");
        map.insert("540131", "西藏自治区墨脱县");
        map.insert("542100", "西藏自治区昌都地区");
        map.insert("542121", "西藏自治区昌都县");
        map.insert("542122", "西藏自治区江达县");
        map.insert("542123", "西藏自治区贡觉县");
        map.insert("542124", "西藏自治区类乌齐县");
        map.insert("542125", "西藏自治区丁青县");
        map.insert("542126", "西藏自治区察雅县");
        map.insert("542127", "西藏自治区八宿县");
        map.insert("542128", "西藏自治区左贡县");
        map.insert("542129", "西藏自治区芒康县");
        map.insert("542130", "西藏自治区波密县");
        map.insert("542131", "西藏自治区察隅县");
        map.insert("542132", "西藏自治区洛隆县");
        map.insert("542133", "西藏自治区边坝县");
        map.insert("542134", "西藏自治区盐井县");
        map.insert("542135", "西藏自治区碧土县");
        map.insert("542136", "西藏自治区妥坝县");
        map.insert("542137", "西藏自治区生达县");
        map.insert("542200", "西藏自治区山南地区");
        map.insert("542221", "西藏自治区乃东县");
        map.insert("542222", "西藏自治区扎囊县");
        map.insert("542223", "西藏自治区贡嘎县");
        map.insert("542224", "西藏自治区桑日县");
        map.insert("542225", "西藏自治区琼结县");
        map.insert("542226", "西藏自治区曲松县");
        map.insert("542227", "西藏自治区措美县");
        map.insert("542228", "西藏自治区洛扎县");
        map.insert("542229", "西藏自治区加查县");
        map.insert("542230", "西藏自治区郎县");
        map.insert("542231", "西藏自治区隆子县");
        map.insert("542232", "西藏自治区错那县");
        map.insert("542233", "西藏自治区浪卡子县");
        map.insert("542300", "西藏自治区日喀则地区");
        map.insert("542301", "西藏自治区日喀则市");
        map.insert("542321", "西藏自治区日喀则县");
        map.insert("542322", "西藏自治区南木林县");
        map.insert("542323", "西藏自治区江孜县");
        map.insert("542324", "西藏自治区定日县");
        map.insert("542325", "西藏自治区萨迦县");
        map.insert("542326", "西藏自治区拉孜县");
        map.insert("542327", "西藏自治区昂仁县");
        map.insert("542328", "西藏自治区谢通门县");
        map.insert("542329", "西藏自治区白朗县");
        map.insert("542330", "西藏自治区仁布县");
        map.insert("542331", "西藏自治区康马县");
        map.insert("542332", "西藏自治区定结县");
        map.insert("542333", "西藏自治区仲巴县");
        map.insert("542334", "西藏自治区亚东县");
        map.insert("542335", "西藏自治区吉隆县");
        map.insert("542336", "西藏自治区聂拉木县");
        map.insert("542337", "西藏自治区萨嘎县");
        map.insert("542338", "西藏自治区岗巴县");
        map.insert("542400", "西藏自治区那曲地区");
        map.insert("542421", "西藏自治区那曲县");
        map.insert("542422", "西藏自治区嘉黎县");
        map.insert("542423", "西藏自治区比如县");
        map.insert("542424", "西藏自治区聂荣县");
        map.insert("542425", "西藏自治区安多县");
        map.insert("542426", "西藏自治区申扎县");
        map.insert("542427", "西藏自治区索县");
        map.insert("542428", "西藏自治区班戈县");
        map.insert("542429", "西藏自治区巴青县");
        map.insert("542430", "西藏自治区尼玛县");
        map.insert("542500", "西藏自治区阿里地区");
        map.insert("542521", "西藏自治区普兰县");
        map.insert("542522", "西藏自治区札达县");
        map.insert("542523", "西藏自治区噶尔县");
        map.insert("542524", "西藏自治区日土县");
        map.insert("542525", "西藏自治区革吉县");
        map.insert("542526", "西藏自治区改则县");
        map.insert("542527", "西藏自治区措勤县");
        map.insert("542528", "西藏自治区隆格尔县");
        map.insert("542600", "西藏自治区林芝地区");
        map.insert("542621", "西藏自治区林芝县");
        map.insert("542622", "西藏自治区工布江达县");
        map.insert("542623", "西藏自治区米林县");
        map.insert("542624", "西藏自治区墨脱县");
        map.insert("542625", "西藏自治区波密县");
        map.insert("542626", "西藏自治区察隅县");
        map.insert("542627", "西藏自治区朗县");
        map.insert("542700", "西藏自治区江孜地区");
        map.insert("542721", "西藏自治区江孜县");
        map.insert("542722", "西藏自治区浪卡子县");
        map.insert("542723", "西藏自治区白朗县");
        map.insert("542724", "西藏自治区仁布县");
        map.insert("542725", "西藏自治区康马县");
        map.insert("542726", "西藏自治区亚东县");
        map.insert("542727", "西藏自治区岗巴县");
        map.insert("610000", "陕西省");
        map.insert("610100", "陕西省西安市");
        map.insert("610101", "陕西省西安市市辖区");
        map.insert("610102", "陕西省西安市新城区");
        map.insert("610103", "陕西省西安市碑林区");
        map.insert("610104", "陕西省西安市莲湖区");
        map.insert("610111", "陕西省西安市灞桥区");
        map.insert("610112", "陕西省西安市未央区");
        map.insert("610113", "陕西省西安市雁塔区");
        map.insert("610114", "陕西省西安市阎良区");
        map.insert("610115", "陕西省西安市临潼区");
        map.insert("610116", "陕西省西安市长安区");
        map.insert("610120", "陕西省西安市区");
        map.insert("610121", "陕西省长安县");
        map.insert("610122", "陕西省蓝田县");
        map.insert("610123", "陕西省临潼县");
        map.insert("610124", "陕西省周至县");
        map.insert("610125", "陕西省户县");
        map.insert("610126", "陕西省高陵县");
        map.insert("610200", "陕西省铜川市");
        map.insert("610201", "陕西省铜川市市辖区");
        map.insert("610202", "陕西省铜川市王益区");
        map.insert("610203", "陕西省铜川市印台区");
        map.insert("610204", "陕西省铜川市耀州区");
        map.insert("610220", "陕西省铜川市区");
        map.insert("610221", "陕西省耀县");
        map.insert("610222", "陕西省宜君县");
        map.insert("610300", "陕西省宝鸡市");
        map.insert("610301", "陕西省宝鸡市市辖区");
        map.insert("610302", "陕西省宝鸡市渭滨区");
        map.insert("610303", "陕西省宝鸡市金台区");
        map.insert("610304", "陕西省宝鸡市陈仓区");
        map.insert("610320", "陕西省宝鸡市区");
        map.insert("610321", "陕西省宝鸡县");
        map.insert("610322", "陕西省凤翔县");
        map.insert("610323", "陕西省岐山县");
        map.insert("610324", "陕西省扶风县");
        map.insert("610325", "陕西省武功县");
        map.insert("610326", "陕西省眉县");
        map.insert("610327", "陕西省陇县");
        map.insert("610328", "陕西省千阳县");
        map.insert("610329", "陕西省麟游县");
        map.insert("610330", "陕西省凤县");
        map.insert("610331", "陕西省太白县");
        map.insert("610400", "陕西省咸阳市");
        map.insert("610401", "陕西省咸阳市市辖区");
        map.insert("610402", "陕西省咸阳市秦都区");
        map.insert("610403", "陕西省咸阳市杨凌区");
        map.insert("610404", "陕西省咸阳市渭城区");
        map.insert("610421", "陕西省兴平县");
        map.insert("610422", "陕西省三原县");
        map.insert("610423", "陕西省泾阳县");
        map.insert("610424", "陕西省乾县");
        map.insert("610425", "陕西省礼泉县");
        map.insert("610426", "陕西省永寿县");
        map.insert("610427", "陕西省彬县");
        map.insert("610428", "陕西省长武县");
        map.insert("610429", "陕西省旬邑县");
        map.insert("610430", "陕西省淳化县");
        map.insert("610431", "陕西省武功县");
        map.insert("610481", "陕西省兴平市");
        map.insert("610500", "陕西省渭南市");
        map.insert("610501", "陕西省渭南市市辖区");
        map.insert("610502", "陕西省渭南市临渭区");
        map.insert("610521", "陕西省华县");
        map.insert("610522", "陕西省潼关县");
        map.insert("610523", "陕西省大荔县");
        map.insert("610524", "陕西省合阳县");
        map.insert("610525", "陕西省澄城县");
        map.insert("610526", "陕西省蒲城县");
        map.insert("610527", "陕西省白水县");
        map.insert("610528", "陕西省富平县");
        map.insert("610581", "陕西省韩城市");
        map.insert("610582", "陕西省华阴市");
        map.insert("610600", "陕西省延安市");
        map.insert("610601", "陕西省延安市市辖区");
        map.insert("610602", "陕西省延安市宝塔区");
        map.insert("610621", "陕西省延长县");
        map.insert("610622", "陕西省延川县");
        map.insert("610623", "陕西省子长县");
        map.insert("610624", "陕西省安塞县");
        map.insert("610625", "陕西省志丹县");
        map.insert("610626", "陕西省吴旗县");
        map.insert("610627", "陕西省甘泉县");
        map.insert("610628", "陕西省富县");
        map.insert("610629", "陕西省洛川县");
        map.insert("610630", "陕西省宜川县");
        map.insert("610631", "陕西省黄龙县");
        map.insert("610632", "陕西省黄陵县");
        map.insert("610700", "陕西省汉中市");
        map.insert("610701", "陕西省汉中市市辖区");
        map.insert("610702", "陕西省汉中市汉台区");
        map.insert("610721", "陕西省南郑县");
        map.insert("610722", "陕西省城固县");
        map.insert("610723", "陕西省洋县");
        map.insert("610724", "陕西省西乡县");
        map.insert("610725", "陕西省勉县");
        map.insert("610726", "陕西省宁强县");
        map.insert("610727", "陕西省略阳县");
        map.insert("610728", "陕西省镇巴县");
        map.insert("610729", "陕西省留坝县");
        map.insert("610730", "陕西省佛坪县");
        map.insert("610800", "陕西省榆林市");
        map.insert("610801", "陕西省榆林市市辖区");
        map.insert("610802", "陕西省榆林市榆阳区");
        map.insert("610821", "陕西省神木县");
        map.insert("610822", "陕西省府谷县");
        map.insert("610823", "陕西省横山县");
        map.insert("610824", "陕西省靖边县");
        map.insert("610825", "陕西省定边县");
        map.insert("610826", "陕西省绥德县");
        map.insert("610827", "陕西省米脂县");
        map.insert("610828", "陕西省佳县");
        map.insert("610829", "陕西省吴堡县");
        map.insert("610830", "陕西省清涧县");
        map.insert("610831", "陕西省子洲县");
        map.insert("610900", "陕西省安康市");
        map.insert("610901", "陕西省安康市市辖区");
        map.insert("610902", "陕西省安康市汉滨区");
        map.insert("610921", "陕西省汉阴县");
        map.insert("610922", "陕西省石泉县");
        map.insert("610923", "陕西省宁陕县");
        map.insert("610924", "陕西省紫阳县");
        map.insert("610925", "陕西省岚皋县");
        map.insert("610926", "陕西省平利县");
        map.insert("610927", "陕西省镇坪县");
        map.insert("610928", "陕西省旬阳县");
        map.insert("610929", "陕西省白河县");
        map.insert("611000", "陕西省商洛市");
        map.insert("611001", "陕西省商洛市市辖区");
        map.insert("611002", "陕西省商洛市商州区");
        map.insert("611021", "陕西省洛南县");
        map.insert("611022", "陕西省丹凤县");
        map.insert("611023", "陕西省商南县");
        map.insert("611024", "陕西省山阳县");
        map.insert("611025", "陕西省镇安县");
        map.insert("611026", "陕西省柞水县");
        map.insert("612100", "陕西省渭南地区");
        map.insert("612101", "陕西省渭南市");
        map.insert("612102", "陕西省韩城市");
        map.insert("612103", "陕西省华阴市");
        map.insert("612121", "陕西省蓝田县");
        map.insert("612122", "陕西省临潼县");
        map.insert("612123", "陕西省渭南县");
        map.insert("612124", "陕西省华县");
        map.insert("612125", "陕西省华阴县");
        map.insert("612126", "陕西省潼关县");
        map.insert("612127", "陕西省大荔县");
        map.insert("612128", "陕西省蒲城县");
        map.insert("612129", "陕西省澄城县");
        map.insert("612130", "陕西省白水县");
        map.insert("612131", "陕西省韩城县");
        map.insert("612132", "陕西省合阳县");
        map.insert("612133", "陕西省富平县");
        map.insert("612200", "陕西省咸阳地区");
        map.insert("612201", "陕西省咸阳市");
        map.insert("612221", "陕西省兴平县");
        map.insert("612222", "陕西省周至县");
        map.insert("612223", "陕西省户县");
        map.insert("612224", "陕西省三原县");
        map.insert("612225", "陕西省泾阳县");
        map.insert("612226", "陕西省高陵县");
        map.insert("612227", "陕西省乾县");
        map.insert("612228", "陕西省礼泉县");
        map.insert("612229", "陕西省永寿县");
        map.insert("612230", "陕西省彬县");
        map.insert("612231", "陕西省长武县");
        map.insert("612232", "陕西省旬邑县");
        map.insert("612233", "陕西省淳化县");
        map.insert("612300", "陕西省汉中地区");
        map.insert("612301", "陕西省汉中市");
        map.insert("612321", "陕西省南郑县");
        map.insert("612322", "陕西省城固县");
        map.insert("612323", "陕西省洋县");
        map.insert("612324", "陕西省西乡县");
        map.insert("612325", "陕西省勉县");
        map.insert("612326", "陕西省宁强县");
        map.insert("612327", "陕西省略阳县");
        map.insert("612328", "陕西省镇巴县");
        map.insert("612329", "陕西省留坝县");
        map.insert("612330", "陕西省佛坪县");
        map.insert("612400", "陕西省安康地区");
        map.insert("612401", "陕西省安康市");
        map.insert("612421", "陕西省安康县");
        map.insert("612422", "陕西省汉阴县");
        map.insert("612423", "陕西省石泉县");
        map.insert("612424", "陕西省宁陕县");
        map.insert("612425", "陕西省紫阳县");
        map.insert("612426", "陕西省岚皋县");
        map.insert("612427", "陕西省平利县");
        map.insert("612428", "陕西省镇坪县");
        map.insert("612429", "陕西省旬阳县");
        map.insert("612430", "陕西省白河县");
        map.insert("612500", "陕西省商洛地区");
        map.insert("612501", "陕西省商州市");
        map.insert("612521", "陕西省商县");
        map.insert("612522", "陕西省洛南县");
        map.insert("612523", "陕西省丹凤县");
        map.insert("612524", "陕西省商南县");
        map.insert("612525", "陕西省山阳县");
        map.insert("612526", "陕西省镇安县");
        map.insert("612527", "陕西省柞水县");
        map.insert("612600", "陕西省延安地区");
        map.insert("612601", "陕西省延安市");
        map.insert("612621", "陕西省延长县");
        map.insert("612622", "陕西省延川县");
        map.insert("612623", "陕西省子长县");
        map.insert("612624", "陕西省安塞县");
        map.insert("612625", "陕西省志丹县");
        map.insert("612626", "陕西省吴旗县");
        map.insert("612627", "陕西省甘泉县");
        map.insert("612628", "陕西省富县");
        map.insert("612629", "陕西省洛川县");
        map.insert("612630", "陕西省宜川县");
        map.insert("612631", "陕西省黄龙县");
        map.insert("612632", "陕西省黄陵县");
        map.insert("612633", "陕西省宜君县");
        map.insert("612700", "陕西省榆林地区");
        map.insert("612701", "陕西省榆林市");
        map.insert("612721", "陕西省榆林县");
        map.insert("612722", "陕西省神木县");
        map.insert("612723", "陕西省府谷县");
        map.insert("612724", "陕西省横山县");
        map.insert("612725", "陕西省靖边县");
        map.insert("612726", "陕西省定边县");
        map.insert("612727", "陕西省绥德县");
        map.insert("612728", "陕西省米脂县");
        map.insert("612729", "陕西省佳县");
        map.insert("612730", "陕西省吴堡县");
        map.insert("612731", "陕西省清涧县");
        map.insert("612732", "陕西省子洲县");
        map.insert("620000", "甘肃省");
        map.insert("620100", "甘肃省兰州市");
        map.insert("620101", "甘肃省兰州市市辖区");
        map.insert("620102", "甘肃省兰州市城关区");
        map.insert("620103", "甘肃省兰州市七里河区");
        map.insert("620104", "甘肃省兰州市西固区");
        map.insert("620105", "甘肃省兰州市安宁区");
        map.insert("620111", "甘肃省兰州市红古区");
        map.insert("620112", "甘肃省兰州市白银区");
        map.insert("620120", "甘肃省兰州市区");
        map.insert("620121", "甘肃省永登县");
        map.insert("620122", "甘肃省皋兰县");
        map.insert("620123", "甘肃省榆中县");
        map.insert("620200", "甘肃省嘉峪关市");
        map.insert("620201", "甘肃省嘉峪关市市辖区");
        map.insert("620202", "甘肃省嘉峪关市嘉峪关区");
        map.insert("620300", "甘肃省金昌市");
        map.insert("620301", "甘肃省金昌市市辖区");
        map.insert("620302", "甘肃省金昌市金川区");
        map.insert("620320", "甘肃省金昌市区");
        map.insert("620321", "甘肃省永昌县");
        map.insert("620400", "甘肃省白银市");
        map.insert("620401", "甘肃省白银市市辖区");
        map.insert("620402", "甘肃省白银市白银区");
        map.insert("620403", "甘肃省白银市平川区");
        map.insert("620421", "甘肃省靖远县");
        map.insert("620422", "甘肃省会宁县");
        map.insert("620423", "甘肃省景泰县");
        map.insert("620500", "甘肃省天水市");
        map.insert("620501", "甘肃省天水市市辖区");
        map.insert("620502", "甘肃省天水市秦城区");
        map.insert("620503", "甘肃省天水市北道区");
        map.insert("620521", "甘肃省清水县");
        map.insert("620522", "甘肃省秦安县");
        map.insert("620523", "甘肃省甘谷县");
        map.insert("620524", "甘肃省武山县");
        map.insert("620525", "甘肃省张家川回族自治县");
        map.insert("620600", "甘肃省武威市");
        map.insert("620601", "甘肃省武威市市辖区");
        map.insert("620602", "甘肃省武威市凉州区");
        map.insert("620621", "甘肃省民勤县");
        map.insert("620622", "甘肃省古浪县");
        map.insert("620623", "甘肃省天祝藏族自治县");
        map.insert("620700", "甘肃省张掖市");
        map.insert("620701", "甘肃省张掖市市辖区");
        map.insert("620702", "甘肃省张掖市甘州区");
        map.insert("620721", "甘肃省肃南裕固族自治县");
        map.insert("620722", "甘肃省民乐县");
        map.insert("620723", "甘肃省临泽县");
        map.insert("620724", "甘肃省高台县");
        map.insert("620725", "甘肃省山丹县");
        map.insert("620800", "甘肃省平凉市");
        map.insert("620801", "甘肃省平凉市市辖区");
        map.insert("620802", "甘肃省平凉市崆峒区");
        map.insert("620821", "甘肃省泾川县");
        map.insert("620822", "甘肃省灵台县");
        map.insert("620823", "甘肃省崇信县");
        map.insert("620824", "甘肃省华亭县");
        map.insert("620825", "甘肃省庄浪县");
        map.insert("620826", "甘肃省静宁县");
        map.insert("620900", "甘肃省酒泉市");
        map.insert("620901", "甘肃省酒泉市市辖区");
        map.insert("620902", "甘肃省酒泉市肃州区");
        map.insert("620921", "甘肃省金塔县");
        map.insert("620922", "甘肃省安西县");
        map.insert("620923", "甘肃省肃北蒙古族自治县");
        map.insert("620924", "甘肃省阿克塞哈萨克族自治县");
        map.insert("620981", "甘肃省玉门市");
        map.insert("620982", "甘肃省敦煌市");
        map.insert("621000", "甘肃省庆阳市");
        map.insert("621001", "甘肃省庆阳市市辖区");
        map.insert("621002", "甘肃省庆阳市西峰区");
        map.insert("621021", "甘肃省庆城县");
        map.insert("621022", "甘肃省环县");
        map.insert("621023", "甘肃省华池县");
        map.insert("621024", "甘肃省合水县");
        map.insert("621025", "甘肃省正宁县");
        map.insert("621026", "甘肃省宁县");
        map.insert("621027", "甘肃省镇原县");
        map.insert("621100", "甘肃省定西市");
        map.insert("621101", "甘肃省定西市市辖区");
        map.insert("621102", "甘肃省定西市安定区");
        map.insert("621121", "甘肃省通渭县");
        map.insert("621122", "甘肃省陇西县");
        map.insert("621123", "甘肃省渭源县");
        map.insert("621124", "甘肃省临洮县");
        map.insert("621125", "甘肃省漳县");
        map.insert("621126", "甘肃省岷县");
        map.insert("621200", "甘肃省陇南市");
        map.insert("621201", "甘肃省陇南市市辖区");
        map.insert("621202", "甘肃省陇南市武都区");
        map.insert("621221", "甘肃省成县");
        map.insert("621222", "甘肃省文县");
        map.insert("621223", "甘肃省宕昌县");
        map.insert("621224", "甘肃省康县");
        map.insert("621225", "甘肃省西和县");
        map.insert("621226", "甘肃省礼县");
        map.insert("621227", "甘肃省徽县");
        map.insert("621228", "甘肃省两当县");
        map.insert("622100", "甘肃省酒泉地区");
        map.insert("622101", "甘肃省玉门市");
        map.insert("622102", "甘肃省酒泉市");
        map.insert("622103", "甘肃省敦煌市");
        map.insert("622121", "甘肃省酒泉县");
        map.insert("622122", "甘肃省敦煌县");
        map.insert("622123", "甘肃省金塔县");
        map.insert("622124", "甘肃省肃北蒙古族自治县");
        map.insert("622125", "甘肃省阿克塞哈萨克族自治县");
        map.insert("622126", "甘肃省安西县");
        map.insert("622200", "甘肃省张掖地区");
        map.insert("622201", "甘肃省张掖市");
        map.insert("622221", "甘肃省张掖县");
        map.insert("622222", "甘肃省肃南裕固族自治县");
        map.insert("622223", "甘肃省民乐县");
        map.insert("622224", "甘肃省临泽县");
        map.insert("622225", "甘肃省高台县");
        map.insert("622226", "甘肃省山丹县");
        map.insert("622300", "甘肃省武威地区");
        map.insert("622301", "甘肃省武威市");
        map.insert("622321", "甘肃省武威县");
        map.insert("622322", "甘肃省民勤县");
        map.insert("622323", "甘肃省古浪县");
        map.insert("622324", "甘肃省景泰县");
        map.insert("622326", "甘肃省天祝藏族自治县");
        map.insert("622400", "甘肃省定西地区");
        map.insert("622421", "甘肃省定西县");
        map.insert("622422", "甘肃省靖远县");
        map.insert("622423", "甘肃省会宁县");
        map.insert("622424", "甘肃省通渭县");
        map.insert("622425", "甘肃省陇西县");
        map.insert("622426", "甘肃省渭源县");
        map.insert("622427", "甘肃省临洮县");
        map.insert("622428", "甘肃省漳县");
        map.insert("622429", "甘肃省岷县");
        map.insert("622500", "甘肃省天水地区");
        map.insert("622501", "甘肃省天水市");
        map.insert("622521", "甘肃省张家川回族自治县");
        map.insert("622522", "甘肃省天水县");
        map.insert("622523", "甘肃省清水县");
        map.insert("622524", "甘肃省徽县");
        map.insert("622525", "甘肃省两当县");
        map.insert("622526", "甘肃省礼县");
        map.insert("622527", "甘肃省西和县");
        map.insert("622528", "甘肃省武山县");
        map.insert("622529", "甘肃省甘谷县");
        map.insert("622530", "甘肃省秦安县");
        map.insert("622531", "甘肃省漳县");
        map.insert("622600", "甘肃省陇南地区");
        map.insert("622621", "甘肃省武都县");
        map.insert("622622", "甘肃省岷县");
        map.insert("622623", "甘肃省宕昌县");
        map.insert("622624", "甘肃省成县");
        map.insert("622625", "甘肃省康县");
        map.insert("622626", "甘肃省文县");
        map.insert("622627", "甘肃省西和县");
        map.insert("622628", "甘肃省礼县");
        map.insert("622629", "甘肃省两当县");
        map.insert("622630", "甘肃省徽县");
        map.insert("622700", "甘肃省平凉地区");
        map.insert("622701", "甘肃省平凉市");
        map.insert("622721", "甘肃省平凉县");
        map.insert("622722", "甘肃省泾川县");
        map.insert("622723", "甘肃省灵台县");
        map.insert("622724", "甘肃省崇信县");
        map.insert("622725", "甘肃省华亭县");
        map.insert("622726", "甘肃省庄浪县");
        map.insert("622727", "甘肃省静宁县");
        map.insert("622800", "甘肃省庆阳地区");
        map.insert("622801", "甘肃省西峰市");
        map.insert("622821", "甘肃省庆阳县");
        map.insert("622822", "甘肃省环县");
        map.insert("622823", "甘肃省华池县");
        map.insert("622824", "甘肃省合水县");
        map.insert("622825", "甘肃省正宁县");
        map.insert("622826", "甘肃省宁县");
        map.insert("622827", "甘肃省镇原县");
        map.insert("622900", "甘肃省临夏回族自治州");
        map.insert("622901", "甘肃省临夏市");
        map.insert("622921", "甘肃省临夏县");
        map.insert("622922", "甘肃省康乐县");
        map.insert("622923", "甘肃省永靖县");
        map.insert("622924", "甘肃省广河县");
        map.insert("622925", "甘肃省和政县");
        map.insert("622926", "甘肃省东乡族自治县");
        map.insert("622927", "甘肃省积石山保安族东乡族撒拉族自治县");
        map.insert("623000", "甘肃省甘南藏族自治州");
        map.insert("623001", "甘肃省合作市");
        map.insert("623021", "甘肃省临潭县");
        map.insert("623022", "甘肃省卓尼县");
        map.insert("623023", "甘肃省舟曲县");
        map.insert("623024", "甘肃省迭部县");
        map.insert("623025", "甘肃省玛曲县");
        map.insert("623026", "甘肃省碌曲县");
        map.insert("623027", "甘肃省夏河县");
        map.insert("630000", "青海省");
        map.insert("630100", "青海省西宁市");
        map.insert("630101", "青海省西宁市市辖区");
        map.insert("630102", "青海省西宁市城东区");
        map.insert("630103", "青海省西宁市城中区");
        map.insert("630104", "青海省西宁市城西区");
        map.insert("630105", "青海省西宁市城北区");
        map.insert("630111", "青海省西宁市郊区");
        map.insert("630120", "青海省西宁市区");
        map.insert("630121", "青海省大通回族土族自治县");
        map.insert("630122", "青海省湟中县");
        map.insert("630123", "青海省湟源县");
        map.insert("632100", "青海省海东地区");
        map.insert("632121", "青海省平安县");
        map.insert("632122", "青海省民和回族土族自治县");
        map.insert("632123", "青海省乐都县");
        map.insert("632124", "青海省湟中县");
        map.insert("632125", "青海省湟源县");
        map.insert("632126", "青海省互助土族自治县");
        map.insert("632127", "青海省化隆回族自治县");
        map.insert("632128", "青海省循化撒拉族自治县");
        map.insert("632200", "青海省海北藏族自治州");
        map.insert("632221", "青海省门源回族自治县");
        map.insert("632222", "青海省祁连县");
        map.insert("632223", "青海省海晏县");
        map.insert("632224", "青海省刚察县");
        map.insert("632300", "青海省黄南藏族自治州");
        map.insert("632321", "青海省同仁县");
        map.insert("632322", "青海省尖扎县");
        map.insert("632323", "青海省泽库县");
        map.insert("632324", "青海省河南蒙古族自治县");
        map.insert("632400", "青海省省直辖行政单位");
        map.insert("632421", "青海省河南蒙古族自治县");
        map.insert("632500", "青海省海南藏族自治州");
        map.insert("632521", "青海省共和县");
        map.insert("632522", "青海省同德县");
        map.insert("632523", "青海省贵德县");
        map.insert("632524", "青海省兴海县");
        map.insert("632525", "青海省贵南县");
        map.insert("632600", "青海省果洛藏族自治州");
        map.insert("632621", "青海省玛沁县");
        map.insert("632622", "青海省班玛县");
        map.insert("632623", "青海省甘德县");
        map.insert("632624", "青海省达日县");
        map.insert("632625", "青海省久治县");
        map.insert("632626", "青海省玛多县");
        map.insert("632700", "青海省玉树藏族自治州");
        map.insert("632721", "青海省玉树县");
        map.insert("632722", "青海省杂多县");
        map.insert("632723", "青海省称多县");
        map.insert("632724", "青海省治多县");
        map.insert("632725", "青海省囊谦县");
        map.insert("632726", "青海省曲麻莱县");
        map.insert("632800", "青海省海西蒙古族藏族自治州");
        map.insert("632801", "青海省格尔木市");
        map.insert("632802", "青海省德令哈市");
        map.insert("632821", "青海省乌兰县");
        map.insert("632822", "青海省都兰县");
        map.insert("632823", "青海省天峻县");
        map.insert("632824", "青海省大柴旦镇");
        map.insert("632825", "青海省冷湖镇");
        map.insert("632826", "青海省茫崖镇");
        map.insert("640000", "宁夏回族自治区");
        map.insert("640100", "宁夏回族自治区银川市");
        map.insert("640101", "宁夏回族自治区银川市市辖区");
        map.insert("640102", "宁夏回族自治区银川市城区");
        map.insert("640103", "宁夏回族自治区银川市新城区");
        map.insert("640104", "宁夏回族自治区银川市兴庆区");
        map.insert("640105", "宁夏回族自治区银川市西夏区");
        map.insert("640106", "宁夏回族自治区银川市金凤区");
        map.insert("640111", "宁夏回族自治区银川市郊区");
        map.insert("640120", "宁夏回族自治区银川市区");
        map.insert("640121", "宁夏回族自治区永宁县");
        map.insert("640122", "宁夏回族自治区贺兰县");
        map.insert("640181", "宁夏回族自治区灵武市");
        map.insert("640200", "宁夏回族自治区石嘴山市");
        map.insert("640201", "宁夏回族自治区石嘴山市市辖区");
        map.insert("640202", "宁夏回族自治区石嘴山市大武口区");
        map.insert("640203", "宁夏回族自治区石嘴山市石嘴山区");
        map.insert("640204", "宁夏回族自治区石嘴山市石炭井区");
        map.insert("640205", "宁夏回族自治区石嘴山市惠农区");
        map.insert("640211", "宁夏回族自治区石嘴山市郊区");
        map.insert("640220", "宁夏回族自治区石嘴山市区");
        map.insert("640221", "宁夏回族自治区平罗县");
        map.insert("640222", "宁夏回族自治区陶乐县");
        map.insert("640223", "宁夏回族自治区惠农县");
        map.insert("640300", "宁夏回族自治区吴忠市");
        map.insert("640301", "宁夏回族自治区吴忠市市辖区");
        map.insert("640302", "宁夏回族自治区吴忠市利通区");
        map.insert("640321", "宁夏回族自治区中卫县");
        map.insert("640322", "宁夏回族自治区中宁县");
        map.insert("640323", "宁夏回族自治区盐池县");
        map.insert("640324", "宁夏回族自治区同心县");
        map.insert("640381", "宁夏回族自治区青铜峡市");
        map.insert("640382", "宁夏回族自治区灵武市");
        map.insert("640400", "宁夏回族自治区固原市");
        map.insert("640401", "宁夏回族自治区固原市市辖区");
        map.insert("640402", "宁夏回族自治区固原市原州区");
        map.insert("640421", "宁夏回族自治区海原县");
        map.insert("640422", "宁夏回族自治区西吉县");
        map.insert("640423", "宁夏回族自治区隆德县");
        map.insert("640424", "宁夏回族自治区泾源县");
        map.insert("640425", "宁夏回族自治区彭阳县");
        map.insert("640500", "宁夏回族自治区中卫市");
        map.insert("640501", "宁夏回族自治区中卫市市辖区");
        map.insert("640502", "宁夏回族自治区中卫市沙坡头区");
        map.insert("640521", "宁夏回族自治区中宁县");
        map.insert("640522", "宁夏回族自治区海原县");
        map.insert("642100", "宁夏回族自治区银南地区");
        map.insert("642101", "宁夏回族自治区吴忠市");
        map.insert("642102", "宁夏回族自治区青铜峡市");
        map.insert("642103", "宁夏回族自治区灵武市");
        map.insert("642121", "宁夏回族自治区吴忠县");
        map.insert("642122", "宁夏回族自治区青铜峡县");
        map.insert("642123", "宁夏回族自治区中卫县");
        map.insert("642124", "宁夏回族自治区中宁县");
        map.insert("642125", "宁夏回族自治区灵武县");
        map.insert("642126", "宁夏回族自治区盐池县");
        map.insert("642127", "宁夏回族自治区同心县");
        map.insert("642200", "宁夏回族自治区固原地区");
        map.insert("642221", "宁夏回族自治区固原县");
        map.insert("642222", "宁夏回族自治区海原县");
        map.insert("642223", "宁夏回族自治区西吉县");
        map.insert("642224", "宁夏回族自治区隆德县");
        map.insert("642225", "宁夏回族自治区泾源县");
        map.insert("642226", "宁夏回族自治区彭阳县");
        map.insert("650000", "新疆维吾尔自治区");
        map.insert("650100", "新疆维吾尔自治区乌鲁木齐市");
        map.insert("650101", "新疆维吾尔自治区乌鲁木齐市市辖区");
        map.insert("650102", "新疆维吾尔自治区乌鲁木齐市天山区");
        map.insert("650103", "新疆维吾尔自治区乌鲁木齐市沙依巴克区");
        map.insert("650104", "新疆维吾尔自治区乌鲁木齐市新市区");
        map.insert("650105", "新疆维吾尔自治区乌鲁木齐市水磨沟区");
        map.insert("650106", "新疆维吾尔自治区乌鲁木齐市头屯河区");
        map.insert("650107", "新疆维吾尔自治区乌鲁木齐市达坂城区");
        map.insert("650108", "新疆维吾尔自治区乌鲁木齐市东山区");
        map.insert("650120", "新疆维吾尔自治区乌鲁木齐市区");
        map.insert("650121", "新疆维吾尔自治区乌鲁木齐县");
        map.insert("650200", "新疆维吾尔自治区克拉玛依市");
        map.insert("650201", "新疆维吾尔自治区克拉玛依市市辖区");
        map.insert("650202", "新疆维吾尔自治区克拉玛依市独山子区");
        map.insert("650203", "新疆维吾尔自治区克拉玛依市克拉玛依区");
        map.insert("650204", "新疆维吾尔自治区克拉玛依市白碱滩区");
        map.insert("650205", "新疆维吾尔自治区克拉玛依市乌尔禾区");
        map.insert("650300", "新疆维吾尔自治区石河子市");
        map.insert("652100", "新疆维吾尔自治区吐鲁番地区");
        map.insert("652101", "新疆维吾尔自治区吐鲁番市");
        map.insert("652121", "新疆维吾尔自治区吐鲁番县");
        map.insert("652122", "新疆维吾尔自治区鄯善县");
        map.insert("652123", "新疆维吾尔自治区托克逊县");
        map.insert("652200", "新疆维吾尔自治区哈密地区");
        map.insert("652201", "新疆维吾尔自治区哈密市");
        map.insert("652221", "新疆维吾尔自治区哈密县");
        map.insert("652222", "新疆维吾尔自治区巴里坤哈萨克自治县");
        map.insert("652223", "新疆维吾尔自治区伊吾县");
        map.insert("652300", "新疆维吾尔自治区昌吉回族自治州");
        map.insert("652301", "新疆维吾尔自治区昌吉市");
        map.insert("652302", "新疆维吾尔自治区阜康市");
        map.insert("652303", "新疆维吾尔自治区米泉市");
        map.insert("652321", "新疆维吾尔自治区昌吉县");
        map.insert("652322", "新疆维吾尔自治区米泉县");
        map.insert("652323", "新疆维吾尔自治区呼图壁县");
        map.insert("652324", "新疆维吾尔自治区玛纳斯县");
        map.insert("652325", "新疆维吾尔自治区奇台县");
        map.insert("652326", "新疆维吾尔自治区阜康县");
        map.insert("652327", "新疆维吾尔自治区吉木萨尔县");
        map.insert("652328", "新疆维吾尔自治区木垒哈萨克自治县");
        map.insert("652401", "新疆维吾尔自治区伊宁市");
        map.insert("652402", "新疆维吾尔自治区奎屯市");
        map.insert("652421", "新疆维吾尔自治区伊宁县");
        map.insert("652422", "新疆维吾尔自治区察布查尔锡伯自治县");
        map.insert("652423", "新疆维吾尔自治区霍城县");
        map.insert("652424", "新疆维吾尔自治区巩留县");
        map.insert("652425", "新疆维吾尔自治区新源县");
        map.insert("652426", "新疆维吾尔自治区昭苏县");
        map.insert("652427", "新疆维吾尔自治区特克斯县");
        map.insert("652428", "新疆维吾尔自治区尼勒克县");
        map.insert("652500", "新疆维吾尔自治区塔城地区");
        map.insert("652521", "新疆维吾尔自治区塔城县");
        map.insert("652522", "新疆维吾尔自治区额敏县");
        map.insert("652523", "新疆维吾尔自治区乌苏县");
        map.insert("652524", "新疆维吾尔自治区沙湾县");
        map.insert("652525", "新疆维吾尔自治区托里县");
        map.insert("652526", "新疆维吾尔自治区裕民县");
        map.insert("652527", "新疆维吾尔自治区和布克赛尔蒙古族自治县");
        map.insert("652600", "新疆维吾尔自治区阿勒泰地区");
        map.insert("652621", "新疆维吾尔自治区阿勒泰县");
        map.insert("652622", "新疆维吾尔自治区布尔津县");
        map.insert("652623", "新疆维吾尔自治区富蕴县");
        map.insert("652624", "新疆维吾尔自治区福海县");
        map.insert("652625", "新疆维吾尔自治区哈巴河县");
        map.insert("652626", "新疆维吾尔自治区青河县");
        map.insert("652627", "新疆维吾尔自治区吉木乃县");
        map.insert("652700", "新疆维吾尔自治区博尔塔拉蒙古自治州");
        map.insert("652701", "新疆维吾尔自治区博乐市");
        map.insert("652721", "新疆维吾尔自治区博乐县");
        map.insert("652722", "新疆维吾尔自治区精河县");
        map.insert("652723", "新疆维吾尔自治区温泉县");
        map.insert("652800", "新疆维吾尔自治区巴音郭楞蒙古自治州");
        map.insert("652801", "新疆维吾尔自治区库尔勒市");
        map.insert("652821", "新疆维吾尔自治区库尔勒县");
        map.insert("652822", "新疆维吾尔自治区轮台县");
        map.insert("652823", "新疆维吾尔自治区尉犁县");
        map.insert("652824", "新疆维吾尔自治区若羌县");
        map.insert("652825", "新疆维吾尔自治区且末县");
        map.insert("652826", "新疆维吾尔自治区焉耆回族自治县");
        map.insert("652827", "新疆维吾尔自治区和静县");
        map.insert("652828", "新疆维吾尔自治区和硕县");
        map.insert("652829", "新疆维吾尔自治区博湖县");
        map.insert("652900", "新疆维吾尔自治区阿克苏地区");
        map.insert("652901", "新疆维吾尔自治区阿克苏市");
        map.insert("652921", "新疆维吾尔自治区阿克苏县");
        map.insert("652922", "新疆维吾尔自治区温宿县");
        map.insert("652923", "新疆维吾尔自治区库车县");
        map.insert("652924", "新疆维吾尔自治区沙雅县");
        map.insert("652925", "新疆维吾尔自治区新和县");
        map.insert("652926", "新疆维吾尔自治区拜城县");
        map.insert("652927", "新疆维吾尔自治区乌什县");
        map.insert("652928", "新疆维吾尔自治区阿瓦提县");
        map.insert("652929", "新疆维吾尔自治区柯坪县");
        map.insert("653000", "新疆维吾尔自治区克孜勒苏柯尔克孜自治州");
        map.insert("653001", "新疆维吾尔自治区阿图什市");
        map.insert("653021", "新疆维吾尔自治区阿图什县");
        map.insert("653022", "新疆维吾尔自治区阿克陶县");
        map.insert("653023", "新疆维吾尔自治区阿合奇县");
        map.insert("653024", "新疆维吾尔自治区乌恰县");
        map.insert("653100", "新疆维吾尔自治区喀什地区");
        map.insert("653101", "新疆维吾尔自治区喀什市");
        map.insert("653121", "新疆维吾尔自治区疏附县");
        map.insert("653122", "新疆维吾尔自治区疏勒县");
        map.insert("653123", "新疆维吾尔自治区英吉沙县");
        map.insert("653124", "新疆维吾尔自治区泽普县");
        map.insert("653125", "新疆维吾尔自治区莎车县");
        map.insert("653126", "新疆维吾尔自治区叶城县");
        map.insert("653127", "新疆维吾尔自治区麦盖提县");
        map.insert("653128", "新疆维吾尔自治区岳普湖县");
        map.insert("653129", "新疆维吾尔自治区伽师县");
        map.insert("653130", "新疆维吾尔自治区巴楚县");
        map.insert("653131", "新疆维吾尔自治区塔什库尔干塔吉克自治县");
        map.insert("653200", "新疆维吾尔自治区和田地区");
        map.insert("653201", "新疆维吾尔自治区和田市");
        map.insert("653221", "新疆维吾尔自治区和田县");
        map.insert("653222", "新疆维吾尔自治区墨玉县");
        map.insert("653223", "新疆维吾尔自治区皮山县");
        map.insert("653224", "新疆维吾尔自治区洛浦县");
        map.insert("653225", "新疆维吾尔自治区策勒县");
        map.insert("653226", "新疆维吾尔自治区于田县");
        map.insert("653227", "新疆维吾尔自治区民丰县");
        map.insert("654000", "新疆维吾尔自治区伊犁哈萨克自治州");
        map.insert("654001", "新疆维吾尔自治区奎屯市");
        map.insert("654002", "新疆维吾尔自治区伊宁市");
        map.insert("654003", "新疆维吾尔自治区奎屯市");
        map.insert("654021", "新疆维吾尔自治区伊宁县");
        map.insert("654022", "新疆维吾尔自治区察布查尔锡伯自治县");
        map.insert("654023", "新疆维吾尔自治区霍城县");
        map.insert("654024", "新疆维吾尔自治区巩留县");
        map.insert("654025", "新疆维吾尔自治区新源县");
        map.insert("654026", "新疆维吾尔自治区昭苏县");
        map.insert("654027", "新疆维吾尔自治区特克斯县");
        map.insert("654028", "新疆维吾尔自治区尼勒克县");
        map.insert("654100", "新疆维吾尔自治区伊犁地区");
        map.insert("654101", "新疆维吾尔自治区伊宁市");
        map.insert("654121", "新疆维吾尔自治区伊宁县");
        map.insert("654122", "新疆维吾尔自治区察布查尔锡伯自治县");
        map.insert("654123", "新疆维吾尔自治区霍城县");
        map.insert("654124", "新疆维吾尔自治区巩留县");
        map.insert("654125", "新疆维吾尔自治区新源县");
        map.insert("654126", "新疆维吾尔自治区昭苏县");
        map.insert("654127", "新疆维吾尔自治区特克斯县");
        map.insert("654128", "新疆维吾尔自治区尼勒克县");
        map.insert("654200", "新疆维吾尔自治区塔城地区");
        map.insert("654201", "新疆维吾尔自治区塔城市");
        map.insert("654202", "新疆维吾尔自治区乌苏市");
        map.insert("654221", "新疆维吾尔自治区额敏县");
        map.insert("654222", "新疆维吾尔自治区乌苏县");
        map.insert("654223", "新疆维吾尔自治区沙湾县");
        map.insert("654224", "新疆维吾尔自治区托里县");
        map.insert("654225", "新疆维吾尔自治区裕民县");
        map.insert("654226", "新疆维吾尔自治区和布克赛尔蒙古自治县");
        map.insert("654300", "新疆维吾尔自治区阿勒泰地区");
        map.insert("654301", "新疆维吾尔自治区阿勒泰市");
        map.insert("654321", "新疆维吾尔自治区布尔津县");
        map.insert("654322", "新疆维吾尔自治区富蕴县");
        map.insert("654323", "新疆维吾尔自治区福海县");
        map.insert("654324", "新疆维吾尔自治区哈巴河县");
        map.insert("654325", "新疆维吾尔自治区青河县");
        map.insert("654326", "新疆维吾尔自治区吉木乃县");
        map.insert("659001", "新疆维吾尔自治区石河子市");
        map.insert("659002", "新疆维吾尔自治区阿拉尔市");
        map.insert("659003", "新疆维吾尔自治区图木舒克市");
        map.insert("659004", "新疆维吾尔自治区五家渠市");
        map.insert("660000", "新疆生产建设兵团");
        map.insert("662800", "新疆生产建设兵团农八师（石河子市）");
        map.insert("710000", "台湾省");
        map.insert("810000", "香港特别行政区");
        map.insert("820000", "澳门特别行政区");
        map
    };
    pub static ref REGION_CODES: Vec<&'static str> = REGION_MAP.keys().cloned().collect();
}
