// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

#![allow(clippy::upper_case_acronyms)]

#[derive(Clone, PartialEq, Debug)]
pub enum EnumeratedProperty {
    BidiClass,
    BidiPairedBracketType,
    CanonicalCombiningClass,
    DecompositionType,
    EastAsianWidth,
    GeneralCategory,
    GraphemeClusterBreak,
    HangulSyllableType,
    IndicPositionalCategory,
    IndicSyllabicCategory,
    JoiningGroup,
    JoiningType,
    LineBreak,
    LeadCanonicalCombiningClass,
    NFCQuickCheck,
    NFDQuickCheck,
    NFKCQuickCheck,
    NFKDQuickCheck,
    NumericType,
    SentenceBreak,
    TrailCanonicalCombiningClass,
    VerticalOrientation,
    WordBreak,
}

#[derive(Clone, PartialEq, Debug)]
pub enum BidiClass {
    ArabicLetter,
    ArabicNumber,
    ParagraphSeparator,
    BoundaryNeutral,
    CommonSeparator,
    EuropeanNumber,
    EuropeanSeparator,
    EuropeanTerminator,
    FirstStrongIsolate,
    LeftToRight,
    LeftToRightEmbedding,
    LeftToRightIsolate,
    LeftToRightOverride,
    NonspacingMark,
    OtherNeutral,
    PopDirectionalFormat,
    PopDirectionalIsolate,
    RightToLeft,
    RightToLeftEmbedding,
    RightToLeftIsolate,
    RightToLeftOverride,
    SegmentSeparator,
    WhiteSpace,
}

#[derive(Clone, PartialEq, Debug)]
pub enum BidiPairedBracketType {
    Close,
    None,
    Open,
}

// The Rust enum determinant values are meaningful in ICU4C for collation
// implementation purposes, so those numerical values are preserved here, too.
#[derive(Clone, PartialEq, Debug)]
pub enum CanonicalCombiningClass {
    NotReordered = 0,
    Overlay = 1,
    CCC10 = 10,
    CCC103 = 103,
    CCC107 = 107,
    CCC11 = 11,
    CCC118 = 118,
    CCC12 = 12,
    CCC122 = 122,
    CCC129 = 129,
    CCC13 = 13,
    CCC130 = 130,
    CCC132 = 132,
    CCC133 = 133,
    CCC14 = 14,
    CCC15 = 15,
    CCC16 = 16,
    CCC17 = 17,
    CCC18 = 18,
    CCC19 = 19,
    CCC20 = 20,
    AttachedBelowLeft = 200,
    AttachedBelow = 202,
    CCC21 = 21,
    AttachedAbove = 214,
    AttachedAboveRight = 216,
    BelowLeft = 218,
    CCC22 = 22,
    Below = 220,
    BelowRight = 222,
    Left = 224,
    Right = 226,
    AboveLeft = 228,
    CCC23 = 23,
    Above = 230,
    AboveRight = 232,
    DoubleBelow = 233,
    DoubleAbove = 234,
    CCC24 = 24,
    IotaSubscript = 240,
    CCC25 = 25,
    CCC26 = 26,
    CCC27 = 27,
    CCC28 = 28,
    CCC29 = 29,
    CCC30 = 30,
    CCC31 = 31,
    CCC32 = 32,
    CCC33 = 33,
    CCC34 = 34,
    CCC35 = 35,
    CCC36 = 36,
    HanReading = 6,
    Nukta = 7,
    KanaVoicing = 8,
    CCC84 = 84,
    Virama = 9,
    CCC91 = 91,
}

#[derive(Clone, PartialEq, Debug)]
pub enum DecompositionType {
    Can,
    Com,
    Enc,
    Fin,
    Font,
    Fra,
    Init,
    Iso,
    Med,
    Nar,
    Nb,
    None,
    Sml,
    Sqr,
    Sub,
    Sup,
    Vert,
    Wide,
}

#[derive(Clone, PartialEq, Debug)]
pub enum EastAsianWidth {
    Ambiguous,
    Fullwidth,
    Halfwidth,
    Neutral,
    Narrow,
    Wide,
}

#[derive(Clone, PartialEq, Debug)]
pub enum GeneralCategory {
    Other,
    Cntrl,
    Format,
    Unassigned,
    PrivateUse,
    Surrogate,
    Letter,
    CasedLetter,
    LowercaseLetter,
    ModifierLetter,
    OtherLetter,
    TitlecaseLetter,
    UppercaseLetter,
    CombiningMark,
    SpacingMark,
    EnclosingMark,
    NonspacingMark,
    Number,
    Digit,
    LetterNumber,
    OtherNumber,
    Punct,
    ConnectorPunctuation,
    DashPunctuation,
    ClosePunctuation,
    FinalPunctuation,
    InitialPunctuation,
    OtherPunctuation,
    OpenPunctuation,
    Symbol,
    CurrencySymbol,
    ModifierSymbol,
    MathSymbol,
    OtherSymbol,
    Separator,
    LineSeparator,
    ParagraphSeparator,
    SpaceSeparator,
}

#[derive(Clone, PartialEq, Debug)]
pub enum GraphemeClusterBreak {
    Control,
    CR,
    EBase,
    EBaseGAZ,
    EModifier,
    Extend,
    GlueAfterZwj,
    L,
    LF,
    LV,
    LVT,
    Prepend,
    RegionalIndicator,
    SpacingMark,
    T,
    V,
    Other,
    ZWJ,
}

#[derive(Clone, PartialEq, Debug)]
pub enum HangulSyllableType {
    LeadingJamo,
    LVSyllable,
    LVTSyllable,
    NotApplicable,
    TrailingJamo,
    VowelJamo,
}

#[derive(Clone, PartialEq, Debug)]
pub enum IndicPositionalCategory {
    Bottom,
    BottomAndLeft,
    BottomAndRight,
    Left,
    LeftAndRight,
    NA,
    Overstruck,
    Right,
    Top,
    TopAndBottom,
    TopAndBottomAndLeft,
    TopAndBottomAndRight,
    TopAndLeft,
    TopAndLeftAndRight,
    TopAndRight,
    VisualOrderLeft,
}

#[derive(Clone, PartialEq, Debug)]
pub enum IndicSyllabicCategory {
    Avagraha,
    Bindu,
    BrahmiJoiningNumber,
    CantillationMark,
    Consonant,
    ConsonantDead,
    ConsonantFinal,
    ConsonantHeadLetter,
    ConsonantInitialPostfixed,
    ConsonantKiller,
    ConsonantMedial,
    ConsonantPlaceholder,
    ConsonantPrecedingRepha,
    ConsonantPrefixed,
    ConsonantSubjoined,
    ConsonantSucceedingRepha,
    ConsonantWithStacker,
    GeminationMark,
    InvisibleStacker,
    Joiner,
    ModifyingLetter,
    NonJoiner,
    Nukta,
    Number,
    NumberJoiner,
    Other,
    PureKiller,
    RegisterShifter,
    SyllableModifier,
    ToneLetter,
    ToneMark,
    Virama,
    Visarga,
    Vowel,
    VowelDependent,
    VowelIndependent,
}

#[derive(Clone, PartialEq, Debug)]
pub enum JoiningGroup {
    AfricanFeh,
    AfricanNoon,
    AfricanQaf,
    Ain,
    Alaph,
    Alef,
    Beh,
    Beth,
    BurushaskiYehBarree,
    Dal,
    DalathRish,
    E,
    FarsiYeh,
    Fe,
    Feh,
    FinalSemkath,
    Gaf,
    Gamal,
    Hah,
    HanifiRohingyaKinnaYa,
    HanifiRohingyaPa,
    He,
    Heh,
    HehGoal,
    Heth,
    Kaf,
    Kaph,
    Khaph,
    KnottedHeh,
    Lam,
    Lamadh,
    MalayalamBha,
    MalayalamJa,
    MalayalamLla,
    MalayalamLlla,
    MalayalamNga,
    MalayalamNna,
    MalayalamNnna,
    MalayalamNya,
    MalayalamRa,
    MalayalamSsa,
    MalayalamTta,
    ManichaeanAleph,
    ManichaeanAyin,
    ManichaeanBeth,
    ManichaeanDaleth,
    ManichaeanDhamedh,
    ManichaeanFive,
    ManichaeanGimel,
    ManichaeanHeth,
    ManichaeanHundred,
    ManichaeanKaph,
    ManichaeanLamedh,
    ManichaeanMem,
    ManichaeanNun,
    ManichaeanOne,
    ManichaeanPe,
    ManichaeanQoph,
    ManichaeanResh,
    ManichaeanSadhe,
    ManichaeanSamekh,
    ManichaeanTaw,
    ManichaeanTen,
    ManichaeanTeth,
    ManichaeanThamedh,
    ManichaeanTwenty,
    ManichaeanWaw,
    ManichaeanYodh,
    ManichaeanZayin,
    Meem,
    Mim,
    NoJoiningGroup,
    Noon,
    Nun,
    Nya,
    Pe,
    Qaf,
    Qaph,
    Reh,
    ReversedPe,
    RohingyaYeh,
    Sad,
    Sadhe,
    Seen,
    Semkath,
    Shin,
    StraightWaw,
    SwashKaf,
    SyriacWaw,
    Tah,
    Taw,
    TehMarbuta,
    TehMarbutaGoal,
    Teth,
    Waw,
    Yeh,
    YehBarree,
    YehWithTail,
    Yudh,
    YudhHe,
    Zain,
    Zhain,
}

#[derive(Clone, PartialEq, Debug)]
pub enum JoiningType {
    JoinCausing,
    DualJoining,
    LeftJoining,
    RightJoining,
    Transparent,
    NonJoining,
}

#[derive(Clone, PartialEq, Debug)]
pub enum LineBreak {
    Ambiguous,
    Alphabetic,
    BreakBoth,
    BreakAfter,
    BreakBefore,
    MandatoryBreak,
    ContingentBreak,
    ConditionalJapaneseStarter,
    ClosePunctuation,
    CombiningMark,
    CloseParenthesis,
    CarriageReturn,
    EBase,
    EModifier,
    Exclamation,
    Glue,
    H2,
    H3,
    HebrewLetter,
    Hyphen,
    Ideographic,
    Inseperable,
    InfixNumeric,
    JL,
    JT,
    JV,
    LineFeed,
    NextLine,
    Nonstarter,
    Numeric,
    OpenPunctuation,
    PostfixNumeric,
    PrefixNumeric,
    Quotation,
    RegionalIndicator,
    ComplexContext,
    Surrogate,
    Space,
    BreakSymbols,
    WordJoiner,
    Unknown,
    ZWSpace,
    ZWJ,
}

// The Rust enum determinant values are meaningful in ICU4C for collation
// implementation purposes, so those numerical values are preserved here, too.
#[derive(Clone, PartialEq, Debug)]
pub enum LeadCanonicalCombiningClass {
    NotReordered = 0,
    Overlay = 1,
    CCC10 = 10,
    CCC103 = 103,
    CCC107 = 107,
    CCC11 = 11,
    CCC118 = 118,
    CCC12 = 12,
    CCC122 = 122,
    CCC129 = 129,
    CCC13 = 13,
    CCC130 = 130,
    CCC132 = 132,
    CCC133 = 133,
    CCC14 = 14,
    CCC15 = 15,
    CCC16 = 16,
    CCC17 = 17,
    CCC18 = 18,
    CCC19 = 19,
    CCC20 = 20,
    AttachedBelowLeft = 200,
    AttachedBelow = 202,
    CCC21 = 21,
    AttachedAbove = 214,
    AttachedAboveRight = 216,
    BelowLeft = 218,
    CCC22 = 22,
    Below = 220,
    BelowRight = 222,
    Left = 224,
    Right = 226,
    AboveLeft = 228,
    CCC23 = 23,
    Above = 230,
    AboveRight = 232,
    DoubleBelow = 233,
    DoubleAbove = 234,
    CCC24 = 24,
    IotaSubscript = 240,
    CCC25 = 25,
    CCC26 = 26,
    CCC27 = 27,
    CCC28 = 28,
    CCC29 = 29,
    CCC30 = 30,
    CCC31 = 31,
    CCC32 = 32,
    CCC33 = 33,
    CCC34 = 34,
    CCC35 = 35,
    CCC36 = 36,
    HanReading = 6,
    Nukta = 7,
    KanaVoicing = 8,
    CCC84 = 84,
    Virama = 9,
    CCC91 = 91,
}

#[derive(Clone, PartialEq, Debug)]
pub enum NFCQuickCheck {
    Maybe,
    No,
    Yes,
}

#[derive(Clone, PartialEq, Debug)]
pub enum NFDQuickCheck {
    No,
    Yes,
}

#[derive(Clone, PartialEq, Debug)]
pub enum NFKCQuickCheck {
    Maybe,
    No,
    Yes,
}

#[derive(Clone, PartialEq, Debug)]
pub enum NFKDQuickCheck {
    No,
    Yes,
}

#[derive(Clone, PartialEq, Debug)]
pub enum NumericType {
    Decimal,
    Digit,
    None,
    Numeric,
}

#[derive(Clone, PartialEq, Debug)]
pub enum SentenceBreak {
    ATerm,
    Close,
    CR,
    Extend,
    Format,
    OLetter,
    LF,
    Lower,
    Numeric,
    SContinue,
    Sep,
    Sp,
    STerm,
    Upper,
    Other,
}

// The Rust enum determinant values are meaningful in ICU4C for collation
// implementation purposes, so those numerical values are preserved here, too.
#[derive(Clone, PartialEq, Debug)]
pub enum TrailCanonicalCombiningClass {
    NotReordered = 0,
    Overlay = 1,
    CCC10 = 10,
    CCC103 = 103,
    CCC107 = 107,
    CCC11 = 11,
    CCC118 = 118,
    CCC12 = 12,
    CCC122 = 122,
    CCC129 = 129,
    CCC13 = 13,
    CCC130 = 130,
    CCC132 = 132,
    CCC133 = 133,
    CCC14 = 14,
    CCC15 = 15,
    CCC16 = 16,
    CCC17 = 17,
    CCC18 = 18,
    CCC19 = 19,
    CCC20 = 20,
    AttachedBelowLeft = 200,
    AttachedBelow = 202,
    CCC21 = 21,
    AttachedAbove = 214,
    AttachedAboveRight = 216,
    BelowLeft = 218,
    CCC22 = 22,
    Below = 220,
    BelowRight = 222,
    Left = 224,
    Right = 226,
    AboveLeft = 228,
    CCC23 = 23,
    Above = 230,
    AboveRight = 232,
    DoubleBelow = 233,
    DoubleAbove = 234,
    CCC24 = 24,
    IotaSubscript = 240,
    CCC25 = 25,
    CCC26 = 26,
    CCC27 = 27,
    CCC28 = 28,
    CCC29 = 29,
    CCC30 = 30,
    CCC31 = 31,
    CCC32 = 32,
    CCC33 = 33,
    CCC34 = 34,
    CCC35 = 35,
    CCC36 = 36,
    HanReading = 6,
    Nukta = 7,
    KanaVoicing = 8,
    CCC84 = 84,
    Virama = 9,
    CCC91 = 91,
}

#[derive(Clone, PartialEq, Debug)]
pub enum VerticalOrientation {
    Rotated,
    TransformedRotated,
    TransformedUpright,
    Upright,
}

#[derive(Clone, PartialEq, Debug)]
pub enum WordBreak {
    CR,
    DoubleQuote,
    EBase,
    EBaseGAZ,
    EModifier,
    ExtendNumLet,
    Extend,
    Format,
    GlueAfterZwj,
    HebrewLetter,
    Katakana,
    ALetter,
    LF,
    MidNumLet,
    MidLetter,
    MidNum,
    Newline,
    Numeric,
    RegionalIndicator,
    SingleQuote,
    WSegSpace,
    Other,
    ZWJ,
}
