// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

// ⚠️This file was generated by GENERATOR!🦹‍♂️

#![allow(clippy::if_same_then_else)]
#![allow(clippy::missing_inline_in_public_items)]

use crate::code_asm::asm_traits::*;
use crate::code_asm::mem::*;
use crate::code_asm::op_state::MemoryOperandSize;
use crate::code_asm::reg::*;
use crate::code_asm::{CodeAssembler, CodeLabel};
use crate::{Code, IcedError, Instruction, Register, RepPrefixKind};

#[rustfmt::skip]
impl CodeAsmAaa for CodeAssembler {
	#[inline]
	fn aaa(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Aaa))
	}
}

#[rustfmt::skip]
impl CodeAsmAad<i32> for CodeAssembler {
	#[inline]
	fn aad(&mut self, op0: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aad_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAad<u32> for CodeAssembler {
	#[inline]
	fn aad(&mut self, op0: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aad_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAam<i32> for CodeAssembler {
	#[inline]
	fn aam(&mut self, op0: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aam_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAam<u32> for CodeAssembler {
	#[inline]
	fn aam(&mut self, op0: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aam_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAas for CodeAssembler {
	#[inline]
	fn aas(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Aas))
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adc_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Adc_AL_imm8 } else { Code::Adc_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister16, i32> for CodeAssembler {
	fn adc(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Adc_AX_imm16
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Adc_rm16_imm8
		} else {
			Code::Adc_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister32, i32> for CodeAssembler {
	fn adc(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Adc_EAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Adc_rm32_imm8
		} else {
			Code::Adc_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister64, i32> for CodeAssembler {
	fn adc(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX {
			Code::Adc_RAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Adc_rm64_imm8
		} else {
			Code::Adc_rm64_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmMemoryOperand, i32> for CodeAssembler {
	fn adc(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Adc_rm64_imm8 } else { Code::Adc_rm64_imm32 }
		} else if op0.size() == MemoryOperandSize::Dword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Adc_rm32_imm8 } else { Code::Adc_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Adc_rm16_imm8 } else { Code::Adc_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Adc_rm8_imm8
		} else {
			return Err(IcedError::new("adc: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn adc(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Adc_AL_imm8 } else { Code::Adc_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister16, u32> for CodeAssembler {
	fn adc(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Adc_AX_imm16
		} else if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) {
			Code::Adc_rm16_imm8
		} else {
			Code::Adc_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmRegister32, u32> for CodeAssembler {
	fn adc(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Adc_EAX_imm32
		} else if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 {
			Code::Adc_rm32_imm8
		} else {
			Code::Adc_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdc<AsmMemoryOperand, u32> for CodeAssembler {
	fn adc(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 { Code::Adc_rm32_imm8 } else { Code::Adc_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) { Code::Adc_rm16_imm8 } else { Code::Adc_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Adc_rm8_imm8
		} else {
			return Err(IcedError::new("adc: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdcx<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn adcx(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adcx_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdcx<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn adcx(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adcx_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdcx<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adcx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adcx_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdcx<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adcx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adcx_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Add_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Add_AL_imm8 } else { Code::Add_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister16, i32> for CodeAssembler {
	fn add(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Add_AX_imm16
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Add_rm16_imm8
		} else {
			Code::Add_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister32, i32> for CodeAssembler {
	fn add(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Add_EAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Add_rm32_imm8
		} else {
			Code::Add_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister64, i32> for CodeAssembler {
	fn add(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX {
			Code::Add_RAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Add_rm64_imm8
		} else {
			Code::Add_rm64_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmMemoryOperand, i32> for CodeAssembler {
	fn add(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Add_rm64_imm8 } else { Code::Add_rm64_imm32 }
		} else if op0.size() == MemoryOperandSize::Dword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Add_rm32_imm8 } else { Code::Add_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Add_rm16_imm8 } else { Code::Add_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Add_rm8_imm8
		} else {
			return Err(IcedError::new("add: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn add(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Add_AL_imm8 } else { Code::Add_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister16, u32> for CodeAssembler {
	fn add(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Add_AX_imm16
		} else if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) {
			Code::Add_rm16_imm8
		} else {
			Code::Add_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmRegister32, u32> for CodeAssembler {
	fn add(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Add_EAX_imm32
		} else if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 {
			Code::Add_rm32_imm8
		} else {
			Code::Add_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdd<AsmMemoryOperand, u32> for CodeAssembler {
	fn add(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 { Code::Add_rm32_imm8 } else { Code::Add_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) { Code::Add_rm16_imm8 } else { Code::Add_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Add_rm8_imm8
		} else {
			return Err(IcedError::new("add: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn addpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn addpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn addps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn addps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn addsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn addsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn addss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn addss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddsubpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn addsubpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addsubpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddsubpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn addsubpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addsubpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddsubps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn addsubps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addsubps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAddsubps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn addsubps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Addsubps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdox<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn adox(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adox_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdox<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn adox(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adox_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdox<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adox(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adox_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAdox<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn adox(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Adox_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdec<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn aesdec(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesdec_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdec<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesdec(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesdec_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdec128kl<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesdec128kl(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesdec128kl_xmm_m384, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdec256kl<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesdec256kl(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesdec256kl_xmm_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdeclast<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn aesdeclast(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesdeclast_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdeclast<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesdeclast(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesdeclast_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdecwide128kl<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesdecwide128kl(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aesdecwide128kl_m384, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesdecwide256kl<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesdecwide256kl(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aesdecwide256kl_m512, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesenc<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn aesenc(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesenc_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesenc<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesenc(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesenc_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesenc128kl<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesenc128kl(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesenc128kl_xmm_m384, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesenc256kl<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesenc256kl(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesenc256kl_xmm_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesenclast<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn aesenclast(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesenclast_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesenclast<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesenclast(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesenclast_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesencwide128kl<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesencwide128kl(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aesencwide128kl_m384, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesencwide256kl<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesencwide256kl(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Aesencwide256kl_m512, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesimc<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn aesimc(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesimc_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAesimc<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn aesimc(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Aesimc_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAeskeygenassist<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn aeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Aeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAeskeygenassist<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn aeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Aeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAeskeygenassist<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn aeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Aeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAeskeygenassist<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn aeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Aeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAltinst for CodeAssembler {
	#[inline]
	fn altinst(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Altinst))
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::And_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::And_AL_imm8 } else { Code::And_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister16, i32> for CodeAssembler {
	fn and(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::And_AX_imm16
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::And_rm16_imm8
		} else {
			Code::And_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister32, i32> for CodeAssembler {
	fn and(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::And_EAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::And_rm32_imm8
		} else {
			Code::And_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister64, i32> for CodeAssembler {
	fn and(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX {
			Code::And_RAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::And_rm64_imm8
		} else {
			Code::And_rm64_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmMemoryOperand, i32> for CodeAssembler {
	fn and(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::And_rm64_imm8 } else { Code::And_rm64_imm32 }
		} else if op0.size() == MemoryOperandSize::Dword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::And_rm32_imm8 } else { Code::And_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::And_rm16_imm8 } else { Code::And_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::And_rm8_imm8
		} else {
			return Err(IcedError::new("and: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn and(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::And_AL_imm8 } else { Code::And_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister16, u32> for CodeAssembler {
	fn and(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::And_AX_imm16
		} else if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) {
			Code::And_rm16_imm8
		} else {
			Code::And_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmRegister32, u32> for CodeAssembler {
	fn and(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::And_EAX_imm32
		} else if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 {
			Code::And_rm32_imm8
		} else {
			Code::And_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAnd<AsmMemoryOperand, u32> for CodeAssembler {
	fn and(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 { Code::And_rm32_imm8 } else { Code::And_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) { Code::And_rm16_imm8 } else { Code::And_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::And_rm8_imm8
		} else {
			return Err(IcedError::new("and: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndn<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn andn(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Andn_r32_r32_rm32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndn<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn andn(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Andn_r64_r64_rm64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndn<AsmRegister32, AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn andn(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Andn_r32_r32_rm32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndn<AsmRegister64, AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn andn(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Andn_r64_r64_rm64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndnpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn andnpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andnpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndnpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn andnpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andnpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndnps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn andnps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andnps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndnps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn andnps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andnps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn andpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn andpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn andps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmAndps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn andps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Andps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmArpl<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn arpl(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Arpl_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmArpl<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn arpl(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Arpl_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmArpl<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn arpl(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Arpl_r32m16_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmArpl<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn arpl(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Arpl_r32m16_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBb0_reset for CodeAssembler {
	#[inline]
	fn bb0_reset(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Bb0_reset))
	}
}

#[rustfmt::skip]
impl CodeAsmBb1_reset for CodeAssembler {
	#[inline]
	fn bb1_reset(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Bb1_reset))
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bextr_r32_rm32_r32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister32, AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bextr_r32_rm32_r32, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bextr_r64_rm64_r64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister64, AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bextr_r64_rm64_r64, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister32, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r32_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister64, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r64_rm64_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister32, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r32_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister64, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r64_rm64_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister32, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r32_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister64, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r64_rm64_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister32, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r32_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBextr<AsmRegister64, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn bextr(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Bextr_r64_rm64_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcfill<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blcfill(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcfill_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcfill<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blcfill(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcfill_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcfill<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcfill(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcfill_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcfill<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcfill(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcfill_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlci<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blci(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blci_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlci<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blci(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blci_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlci<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blci(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blci_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlci<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blci(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blci_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcic<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blcic(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcic_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcic<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blcic(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcic_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcic<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcic(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcic_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcic<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcic(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcic_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcmsk<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blcmsk(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcmsk_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcmsk<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blcmsk(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcmsk_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcmsk<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcmsk(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcmsk_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcmsk<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcmsk(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcmsk_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcs<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blcs(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcs_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcs<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blcs(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcs_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcs<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcs(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcs_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlcs<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blcs(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blcs_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendpd<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn blendpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendpd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendpd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn blendpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendpd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendpd<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn blendpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendpd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendpd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn blendpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendpd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendps<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn blendps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendps<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn blendps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendps<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn blendps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendps<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn blendps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Blendps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendvpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn blendvpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Blendvpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendvpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blendvpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Blendvpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendvps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn blendvps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Blendvps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlendvps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blendvps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Blendvps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsfill<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blsfill(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsfill_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsfill<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blsfill(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsfill_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsfill<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsfill(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsfill_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsfill<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsfill(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsfill_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsi<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blsi(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsi_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsi<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blsi(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsi_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsi<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsi(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsi_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsi<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsi(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsi_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsic<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blsic(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsic_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsic<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blsic(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsic_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsic<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsic(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsic_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsic<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsic(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Blsic_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsmsk<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blsmsk(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsmsk_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsmsk<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blsmsk(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsmsk_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsmsk<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsmsk(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsmsk_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsmsk<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsmsk(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsmsk_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsr<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn blsr(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsr_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsr<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn blsr(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsr_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsr<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsr(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsr_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBlsr<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn blsr(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Blsr_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcl<AsmRegisterBnd, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bndcl(&mut self, op0: AsmRegisterBnd, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndcl_bnd_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcl<AsmRegisterBnd, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bndcl(&mut self, op0: AsmRegisterBnd, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndcl_bnd_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcl<AsmRegisterBnd, AsmMemoryOperand> for CodeAssembler {
	fn bndcl(&mut self, op0: AsmRegisterBnd, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Qword {
			Code::Bndcl_bnd_rm64
		} else if op1.size() == MemoryOperandSize::Dword {
			Code::Bndcl_bnd_rm32
		} else {
			return Err(IcedError::new("bndcl: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcn<AsmRegisterBnd, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bndcn(&mut self, op0: AsmRegisterBnd, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndcn_bnd_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcn<AsmRegisterBnd, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bndcn(&mut self, op0: AsmRegisterBnd, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndcn_bnd_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcn<AsmRegisterBnd, AsmMemoryOperand> for CodeAssembler {
	fn bndcn(&mut self, op0: AsmRegisterBnd, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Qword {
			Code::Bndcn_bnd_rm64
		} else if op1.size() == MemoryOperandSize::Dword {
			Code::Bndcn_bnd_rm32
		} else {
			return Err(IcedError::new("bndcn: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcu<AsmRegisterBnd, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bndcu(&mut self, op0: AsmRegisterBnd, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndcu_bnd_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcu<AsmRegisterBnd, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bndcu(&mut self, op0: AsmRegisterBnd, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndcu_bnd_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndcu<AsmRegisterBnd, AsmMemoryOperand> for CodeAssembler {
	fn bndcu(&mut self, op0: AsmRegisterBnd, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Qword {
			Code::Bndcu_bnd_rm64
		} else if op1.size() == MemoryOperandSize::Dword {
			Code::Bndcu_bnd_rm32
		} else {
			return Err(IcedError::new("bndcu: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndldx<AsmRegisterBnd, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bndldx(&mut self, op0: AsmRegisterBnd, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndldx_bnd_mib, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndmk<AsmRegisterBnd, AsmMemoryOperand> for CodeAssembler {
	fn bndmk(&mut self, op0: AsmRegisterBnd, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Qword {
			Code::Bndmk_bnd_m64
		} else if op1.size() == MemoryOperandSize::Dword {
			Code::Bndmk_bnd_m32
		} else {
			return Err(IcedError::new("bndmk: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndmov<AsmRegisterBnd, AsmRegisterBnd> for CodeAssembler {
	#[inline]
	fn bndmov(&mut self, op0: AsmRegisterBnd, op1: AsmRegisterBnd) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 { Code::Bndmov_bnd_bndm128 } else { Code::Bndmov_bnd_bndm64 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndmov<AsmMemoryOperand, AsmRegisterBnd> for CodeAssembler {
	#[inline]
	fn bndmov(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterBnd) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 { Code::Bndmov_bndm128_bnd } else { Code::Bndmov_bndm64_bnd };
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndmov<AsmRegisterBnd, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bndmov(&mut self, op0: AsmRegisterBnd, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 { Code::Bndmov_bnd_bndm128 } else { Code::Bndmov_bnd_bndm64 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBndstx<AsmMemoryOperand, AsmRegisterBnd> for CodeAssembler {
	#[inline]
	fn bndstx(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterBnd) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bndstx_mib_bnd, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBound<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bound(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bound_r16_m1616, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBound<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bound(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bound_r32_m3232, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsf<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn bsf(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsf_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsf<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bsf(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsf_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsf<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bsf(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsf_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsf<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bsf(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsf_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsf<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bsf(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsf_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsf<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bsf(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsf_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsr<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn bsr(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsr_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsr<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bsr(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsr_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsr<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bsr(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsr_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsr<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bsr(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsr_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsr<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bsr(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsr_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBsr<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn bsr(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bsr_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmBswap<AsmRegister16> for CodeAssembler {
	#[inline]
	fn bswap(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Bswap_r16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBswap<AsmRegister32> for CodeAssembler {
	#[inline]
	fn bswap(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Bswap_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBswap<AsmRegister64> for CodeAssembler {
	#[inline]
	fn bswap(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Bswap_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmMemoryOperand, i32> for CodeAssembler {
	fn bt(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Bt_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Bt_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Bt_rm16_imm8
		} else {
			return Err(IcedError::new("bt: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn bt(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bt_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBt<AsmMemoryOperand, u32> for CodeAssembler {
	fn bt(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Bt_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Bt_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Bt_rm16_imm8
		} else {
			return Err(IcedError::new("bt: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmMemoryOperand, i32> for CodeAssembler {
	fn btc(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Btc_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Btc_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Btc_rm16_imm8
		} else {
			return Err(IcedError::new("btc: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn btc(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btc_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtc<AsmMemoryOperand, u32> for CodeAssembler {
	fn btc(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Btc_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Btc_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Btc_rm16_imm8
		} else {
			return Err(IcedError::new("btc: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmMemoryOperand, i32> for CodeAssembler {
	fn btr(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Btr_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Btr_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Btr_rm16_imm8
		} else {
			return Err(IcedError::new("btr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn btr(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Btr_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBtr<AsmMemoryOperand, u32> for CodeAssembler {
	fn btr(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Btr_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Btr_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Btr_rm16_imm8
		} else {
			return Err(IcedError::new("btr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmMemoryOperand, i32> for CodeAssembler {
	fn bts(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Bts_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Bts_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Bts_rm16_imm8
		} else {
			return Err(IcedError::new("bts: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm16_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm32_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn bts(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Bts_rm64_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBts<AsmMemoryOperand, u32> for CodeAssembler {
	fn bts(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Bts_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Bts_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Bts_rm16_imm8
		} else {
			return Err(IcedError::new("bts: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmBzhi<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bzhi(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bzhi_r32_rm32_r32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBzhi<AsmRegister32, AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn bzhi(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bzhi_r32_rm32_r32, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBzhi<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bzhi(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bzhi_r64_rm64_r64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmBzhi<AsmRegister64, AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn bzhi(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Bzhi_r64_rm64_r64, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCall<AsmRegister16> for CodeAssembler {
	#[inline]
	fn call(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Call_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCall<AsmRegister32> for CodeAssembler {
	#[inline]
	fn call(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Call_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCall<AsmRegister64> for CodeAssembler {
	#[inline]
	fn call(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Call_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCall<AsmMemoryOperand> for CodeAssembler {
	fn call(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Tbyte {
			Code::Call_m1664
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Call_rm64
		} else if op0.size() == MemoryOperandSize::Fword {
			Code::Call_m1632
		} else if op0.size() == MemoryOperandSize::Dword {
			if self.bitness() >= 32 { Code::Call_rm32 } else { Code::Call_m1616 }
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Call_rm16
		} else {
			return Err(IcedError::new("call: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCall<CodeLabel> for CodeAssembler {
	fn call(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Call_rel32_64
		} else if self.bitness() >= 32 {
			Code::Call_rel32_32
		} else {
			Code::Call_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCall<u64> for CodeAssembler {
	fn call(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Call_rel32_64
		} else if self.bitness() >= 32 {
			Code::Call_rel32_32
		} else {
			Code::Call_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCbw for CodeAssembler {
	#[inline]
	fn cbw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cbw))
	}
}

#[rustfmt::skip]
impl CodeAsmCcs_encrypt for CodeAssembler {
	fn ccs_encrypt(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Ccs_encrypt_64
		} else if self.bitness() >= 32 {
			Code::Ccs_encrypt_32
		} else {
			Code::Ccs_encrypt_16
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmCcs_hash for CodeAssembler {
	fn ccs_hash(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Ccs_hash_64
		} else if self.bitness() >= 32 {
			Code::Ccs_hash_32
		} else {
			Code::Ccs_hash_16
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmCdq for CodeAssembler {
	#[inline]
	fn cdq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cdq))
	}
}

#[rustfmt::skip]
impl CodeAsmCdqe for CodeAssembler {
	#[inline]
	fn cdqe(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cdqe))
	}
}

#[rustfmt::skip]
impl CodeAsmCl1invmb for CodeAssembler {
	#[inline]
	fn cl1invmb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cl1invmb))
	}
}

#[rustfmt::skip]
impl CodeAsmClac for CodeAssembler {
	#[inline]
	fn clac(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Clac))
	}
}

#[rustfmt::skip]
impl CodeAsmClc for CodeAssembler {
	#[inline]
	fn clc(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Clc))
	}
}

#[rustfmt::skip]
impl CodeAsmCld for CodeAssembler {
	#[inline]
	fn cld(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cld))
	}
}

#[rustfmt::skip]
impl CodeAsmCldemote<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cldemote(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Cldemote_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmClflush<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn clflush(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Clflush_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmClflushopt<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn clflushopt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Clflushopt_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmClgi for CodeAssembler {
	#[inline]
	fn clgi(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Clgi))
	}
}

#[rustfmt::skip]
impl CodeAsmCli for CodeAssembler {
	#[inline]
	fn cli(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cli))
	}
}

#[rustfmt::skip]
impl CodeAsmClrssbsy<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn clrssbsy(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Clrssbsy_m64, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmClts for CodeAssembler {
	#[inline]
	fn clts(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Clts))
	}
}

#[rustfmt::skip]
impl CodeAsmClui for CodeAssembler {
	#[inline]
	fn clui(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Clui))
	}
}

#[rustfmt::skip]
impl CodeAsmClwb<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn clwb(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Clwb_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmClzero for CodeAssembler {
	fn clzero(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Clzeroq
		} else if self.bitness() >= 32 {
			Code::Clzerod
		} else {
			Code::Clzerow
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmCmc for CodeAssembler {
	#[inline]
	fn cmc(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cmc))
	}
}

#[rustfmt::skip]
impl CodeAsmCmova<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmova(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmova<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmova(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmova<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmova(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmova<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmova(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmova<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmova(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmova<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmova(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovae<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovae(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovae<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovae(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovae<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovae(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovae<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovae(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovae<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovae(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovae<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovae(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovb<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovb(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovb<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovb(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovb<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovb(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovb<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovb(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovb<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovb(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovb<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovb(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovbe<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovbe(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovbe<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovbe(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovbe<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovbe(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovbe<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovbe(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovbe<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovbe(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovbe<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovbe(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovc<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovc(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovc<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovc(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovc<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovc(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovc<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovc(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovc<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovc(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovc<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovc(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmove<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmove(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmove<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmove(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmove<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmove(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmove<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmove(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmove<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmove(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmove<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmove(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovg<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovg(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovg<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovg(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovg<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovg(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovg<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovg(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovg<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovg(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovg<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovg(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovge<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovge(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovge<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovge(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovge<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovge(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovge<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovge(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovge<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovge(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovge<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovge(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovl<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovl(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovl<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovl(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovl<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovl(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovl<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovl(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovl<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovl(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovl<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovl(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovle<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovle(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovle<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovle(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovle<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovle(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovle<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovle(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovle<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovle(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovle<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovle(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovna<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovna(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovna<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovna(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovna<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovna(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovna<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovna(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovna<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovna(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovna<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovna(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovbe_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnae<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnae(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnae<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnae(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnae<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnae(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnae<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnae(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnae<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnae(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnae<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnae(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovb_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnb<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnb(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnb<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnb(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnb<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnb(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnb<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnb(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnb<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnb(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnb<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnb(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnbe<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnbe(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnbe<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnbe(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnbe<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnbe(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnbe<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnbe(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnbe<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnbe(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnbe<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnbe(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmova_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnc<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnc(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnc<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnc(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnc<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnc(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnc<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnc(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnc<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnc(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnc<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnc(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovae_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovne<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovne(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovne<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovne(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovne<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovne(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovne<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovne(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovne<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovne(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovne<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovne(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovng<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovng(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovng<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovng(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovng<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovng(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovng<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovng(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovng<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovng(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovng<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovng(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovle_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnge<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnge(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnge<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnge(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnge<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnge(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnge<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnge(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnge<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnge(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnge<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnge(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovl_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnl<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnl(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnl<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnl(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnl<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnl(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnl<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnl(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnl<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnl(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnl<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnl(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovge_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnle<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnle(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnle<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnle(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnle<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnle(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnle<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnle(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnle<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnle(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnle<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnle(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovg_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovno<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovno(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovno_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovno<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovno(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovno_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovno<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovno(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovno_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovno<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovno(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovno_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovno<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovno(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovno_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovno<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovno(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovno_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnp<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnp(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnp<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnp(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnp<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnp(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnp<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnp(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnp<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnp(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnp<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnp(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovns<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovns(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovns_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovns<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovns(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovns_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovns<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovns(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovns_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovns<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovns(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovns_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovns<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovns(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovns_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovns<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovns(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovns_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnz<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovnz(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnz<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovnz(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnz<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovnz(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnz<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnz(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnz<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnz(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovnz<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovnz(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovne_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovo<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovo(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovo_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovo<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovo(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovo_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovo<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovo(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovo_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovo<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovo(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovo_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovo<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovo(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovo_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovo<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovo(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovo_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovp<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovp(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovp<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovp(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovp<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovp(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovp<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovp(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovp<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovp(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovp<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovp(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpe<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovpe(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpe<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovpe(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpe<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovpe(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpe<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovpe(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpe<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovpe(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpe<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovpe(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovp_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpo<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovpo(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpo<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovpo(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpo<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovpo(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpo<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovpo(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpo<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovpo(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovpo<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovpo(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovnp_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovs<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovs(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovs_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovs<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovs(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovs_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovs<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovs(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovs_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovs<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovs(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovs_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovs<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovs(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovs_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovs<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovs(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmovs_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovz<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmovz(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovz<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmovz(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovz<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmovz(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovz<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovz(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovz<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovz(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmovz<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmovz(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmove_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmp_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Cmp_AL_imm8 } else { Code::Cmp_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister16, i32> for CodeAssembler {
	fn cmp(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Cmp_AX_imm16
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Cmp_rm16_imm8
		} else {
			Code::Cmp_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister32, i32> for CodeAssembler {
	fn cmp(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Cmp_EAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Cmp_rm32_imm8
		} else {
			Code::Cmp_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister64, i32> for CodeAssembler {
	fn cmp(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX {
			Code::Cmp_RAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Cmp_rm64_imm8
		} else {
			Code::Cmp_rm64_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmMemoryOperand, i32> for CodeAssembler {
	fn cmp(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Cmp_rm64_imm8 } else { Code::Cmp_rm64_imm32 }
		} else if op0.size() == MemoryOperandSize::Dword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Cmp_rm32_imm8 } else { Code::Cmp_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Cmp_rm16_imm8 } else { Code::Cmp_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Cmp_rm8_imm8
		} else {
			return Err(IcedError::new("cmp: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn cmp(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Cmp_AL_imm8 } else { Code::Cmp_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister16, u32> for CodeAssembler {
	fn cmp(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Cmp_AX_imm16
		} else if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) {
			Code::Cmp_rm16_imm8
		} else {
			Code::Cmp_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmRegister32, u32> for CodeAssembler {
	fn cmp(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Cmp_EAX_imm32
		} else if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 {
			Code::Cmp_rm32_imm8
		} else {
			Code::Cmp_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmp<AsmMemoryOperand, u32> for CodeAssembler {
	fn cmp(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 { Code::Cmp_rm32_imm8 } else { Code::Cmp_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) { Code::Cmp_rm16_imm8 } else { Code::Cmp_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Cmp_rm8_imm8
		} else {
			return Err(IcedError::new("cmp: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpeqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpeqpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpeqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpeqps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpeqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpeqsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpeqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpeqss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpeqss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmCmplepd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmplepd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmplepd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmplepd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpleps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpleps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpleps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpleps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmplesd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmplesd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmplesd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmplesd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpless<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpless(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpless<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpless(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 2)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpltpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpltpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpltps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpltps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpltsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpltsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpltss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpltss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpltss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpneqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpneqpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpneqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpneqps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpneqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpneqsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpneqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpneqss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpneqss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 4)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnlepd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnlepd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnlepd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnlepd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnleps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnleps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnleps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnleps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnlesd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnlesd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnlesd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnlesd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnless<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnless(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnless<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnless(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 6)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnltpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnltpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnltps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnltps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnltsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnltsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpnltss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpnltss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpnltss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 5)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpordpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpordpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpordps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpordps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpordsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpordsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpordss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpordss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpordss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 7)
	}
}

#[rustfmt::skip]
impl CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn cmppd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmppd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn cmppd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmppd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn cmppd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmppd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn cmppd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmppd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn cmpps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn cmpps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn cmpps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn cmpps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsb for CodeAssembler {
	#[inline]
	fn cmpsb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_cmpsb(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsd for CodeAssembler {
	#[inline]
	fn cmpsd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_cmpsd(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn cmpsd_3(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpsd_xmm_xmmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn cmpsd_3(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpsd_xmm_xmmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn cmpsd_3(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpsd_xmm_xmmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn cmpsd_3(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpsd_xmm_xmmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsq for CodeAssembler {
	#[inline]
	fn cmpsq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_cmpsq(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn cmpss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpss_xmm_xmmm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn cmpss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpss_xmm_xmmm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn cmpss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpss_xmm_xmmm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn cmpss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Cmpss_xmm_xmmm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpsw for CodeAssembler {
	#[inline]
	fn cmpsw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_cmpsw(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpunordpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmppd(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpunordpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmppd<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmppd(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpunordps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpps(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpunordps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpps<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpps(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpunordsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpsd_3(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpunordsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpsd3<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpsd_3(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cmpunordss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmRegisterXmm, i32>>::cmpss(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpunordss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpunordss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmCmpss<AsmRegisterXmm, AsmMemoryOperand, i32>>::cmpss(self, op0, op1, 3)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cmpxchg(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cmpxchg_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg16b<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpxchg16b(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Cmpxchg16b_m128, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCmpxchg8b<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cmpxchg8b(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Cmpxchg8b_m64, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmComisd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn comisd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Comisd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmComisd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn comisd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Comisd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmComiss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn comiss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Comiss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmComiss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn comiss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Comiss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCpu_read for CodeAssembler {
	#[inline]
	fn cpu_read(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cpu_read))
	}
}

#[rustfmt::skip]
impl CodeAsmCpu_write for CodeAssembler {
	#[inline]
	fn cpu_write(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cpu_write))
	}
}

#[rustfmt::skip]
impl CodeAsmCpuid for CodeAssembler {
	#[inline]
	fn cpuid(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cpuid))
	}
}

#[rustfmt::skip]
impl CodeAsmCqo for CodeAssembler {
	#[inline]
	fn cqo(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cqo))
	}
}

#[rustfmt::skip]
impl CodeAsmCrc32<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn crc32(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Crc32_r32_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCrc32<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn crc32(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Crc32_r64_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCrc32<AsmRegister32, AsmRegister16> for CodeAssembler {
	#[inline]
	fn crc32(&mut self, op0: AsmRegister32, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Crc32_r32_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCrc32<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn crc32(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Crc32_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCrc32<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn crc32(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Crc32_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCrc32<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	fn crc32(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Dword {
			Code::Crc32_r32_rm32
		} else if op1.size() == MemoryOperandSize::Word {
			Code::Crc32_r32_rm16
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Crc32_r32_rm8
		} else {
			return Err(IcedError::new("crc32: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCrc32<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	fn crc32(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Qword {
			Code::Crc32_r64_rm64
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Crc32_r64_rm8
		} else {
			return Err(IcedError::new("crc32: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtdq2pd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtdq2pd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtdq2pd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtdq2pd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtdq2pd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtdq2pd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtdq2ps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtdq2ps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtdq2ps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtdq2ps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtdq2ps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtdq2ps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpd2dq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtpd2dq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpd2dq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpd2dq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtpd2dq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpd2dq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpd2pi<AsmRegisterMm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtpd2pi(&mut self, op0: AsmRegisterMm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpd2pi_mm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpd2pi<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtpd2pi(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpd2pi_mm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpd2ps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtpd2ps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpd2ps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpd2ps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtpd2ps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpd2ps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpi2pd<AsmRegisterXmm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn cvtpi2pd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpi2pd_xmm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpi2pd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtpi2pd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpi2pd_xmm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpi2ps<AsmRegisterXmm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn cvtpi2ps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpi2ps_xmm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtpi2ps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtpi2ps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtpi2ps_xmm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtps2dq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtps2dq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtps2dq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtps2dq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtps2dq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtps2dq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtps2pd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtps2pd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtps2pd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtps2pd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtps2pd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtps2pd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtps2pi<AsmRegisterMm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtps2pi(&mut self, op0: AsmRegisterMm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtps2pi_mm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtps2pi<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtps2pi(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtps2pi_mm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsd2si<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtsd2si(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsd2si_r32_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsd2si<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtsd2si(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsd2si_r64_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsd2si<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtsd2si(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsd2si_r32_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsd2si<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtsd2si(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsd2si_r64_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsd2ss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtsd2ss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsd2ss_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsd2ss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtsd2ss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsd2ss_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsi2sd<AsmRegisterXmm, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cvtsi2sd(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsi2sd_xmm_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsi2sd<AsmRegisterXmm, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cvtsi2sd(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsi2sd_xmm_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsi2sd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn cvtsi2sd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Qword {
			Code::Cvtsi2sd_xmm_rm64
		} else if op1.size() == MemoryOperandSize::Dword {
			Code::Cvtsi2sd_xmm_rm32
		} else {
			return Err(IcedError::new("cvtsi2sd: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsi2ss<AsmRegisterXmm, AsmRegister32> for CodeAssembler {
	#[inline]
	fn cvtsi2ss(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsi2ss_xmm_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsi2ss<AsmRegisterXmm, AsmRegister64> for CodeAssembler {
	#[inline]
	fn cvtsi2ss(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtsi2ss_xmm_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtsi2ss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn cvtsi2ss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Qword {
			Code::Cvtsi2ss_xmm_rm64
		} else if op1.size() == MemoryOperandSize::Dword {
			Code::Cvtsi2ss_xmm_rm32
		} else {
			return Err(IcedError::new("cvtsi2ss: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtss2sd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtss2sd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtss2sd_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtss2sd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtss2sd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtss2sd_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtss2si<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtss2si(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtss2si_r32_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtss2si<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvtss2si(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtss2si_r64_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtss2si<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtss2si(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtss2si_r32_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvtss2si<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvtss2si(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvtss2si_r64_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttpd2dq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttpd2dq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttpd2dq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttpd2dq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttpd2dq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttpd2dq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttpd2pi<AsmRegisterMm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttpd2pi(&mut self, op0: AsmRegisterMm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttpd2pi_mm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttpd2pi<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttpd2pi(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttpd2pi_mm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttps2dq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttps2dq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttps2dq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttps2dq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttps2dq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttps2dq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttps2pi<AsmRegisterMm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttps2pi(&mut self, op0: AsmRegisterMm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttps2pi_mm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttps2pi<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttps2pi(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttps2pi_mm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttsd2si<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttsd2si(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttsd2si_r32_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttsd2si<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttsd2si(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttsd2si_r64_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttsd2si<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttsd2si(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttsd2si_r32_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttsd2si<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttsd2si(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttsd2si_r64_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttss2si<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttss2si(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttss2si_r32_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttss2si<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn cvttss2si(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttss2si_r64_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttss2si<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttss2si(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttss2si_r32_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCvttss2si<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn cvttss2si(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Cvttss2si_r64_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmCwd for CodeAssembler {
	#[inline]
	fn cwd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cwd))
	}
}

#[rustfmt::skip]
impl CodeAsmCwde for CodeAssembler {
	#[inline]
	fn cwde(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Cwde))
	}
}

#[rustfmt::skip]
impl CodeAsmDaa for CodeAssembler {
	#[inline]
	fn daa(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Daa))
	}
}

#[rustfmt::skip]
impl CodeAsmDas for CodeAssembler {
	#[inline]
	fn das(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Das))
	}
}

#[rustfmt::skip]
impl CodeAsmDec<AsmRegister8> for CodeAssembler {
	#[inline]
	fn dec(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Dec_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDec<AsmRegister16> for CodeAssembler {
	#[inline]
	fn dec(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 { Code::Dec_rm16 } else { Code::Dec_r16 };
		self.add_instr(Instruction::with1(code, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDec<AsmRegister32> for CodeAssembler {
	#[inline]
	fn dec(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 { Code::Dec_rm32 } else { Code::Dec_r32 };
		self.add_instr(Instruction::with1(code, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDec<AsmRegister64> for CodeAssembler {
	#[inline]
	fn dec(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Dec_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDec<AsmMemoryOperand> for CodeAssembler {
	fn dec(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Dec_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Dec_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Dec_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Dec_rm8
		} else {
			return Err(IcedError::new("dec: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmDiv<AsmRegister8> for CodeAssembler {
	#[inline]
	fn div(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Div_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDiv<AsmRegister16> for CodeAssembler {
	#[inline]
	fn div(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Div_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDiv<AsmRegister32> for CodeAssembler {
	#[inline]
	fn div(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Div_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDiv<AsmRegister64> for CodeAssembler {
	#[inline]
	fn div(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Div_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDiv<AsmMemoryOperand> for CodeAssembler {
	fn div(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Div_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Div_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Div_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Div_rm8
		} else {
			return Err(IcedError::new("div: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn divpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn divpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn divps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn divps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn divsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn divsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn divss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmDivss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn divss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Divss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmDmint for CodeAssembler {
	#[inline]
	fn dmint(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Dmint))
	}
}

#[rustfmt::skip]
impl CodeAsmDppd<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn dppd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dppd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmDppd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn dppd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dppd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmDppd<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn dppd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dppd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmDppd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn dppd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dppd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmDpps<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn dpps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dpps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmDpps<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn dpps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dpps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmDpps<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn dpps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dpps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmDpps<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn dpps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Dpps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmEmms for CodeAssembler {
	#[inline]
	fn emms(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Emms))
	}
}

#[rustfmt::skip]
impl CodeAsmEncls for CodeAssembler {
	#[inline]
	fn encls(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Encls))
	}
}

#[rustfmt::skip]
impl CodeAsmEnclu for CodeAssembler {
	#[inline]
	fn enclu(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Enclu))
	}
}

#[rustfmt::skip]
impl CodeAsmEnclv for CodeAssembler {
	#[inline]
	fn enclv(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Enclv))
	}
}

#[rustfmt::skip]
impl CodeAsmEncodekey128<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn encodekey128(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Encodekey128_r32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmEncodekey256<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn encodekey256(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Encodekey256_r32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmEndbr32 for CodeAssembler {
	#[inline]
	fn endbr32(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Endbr32))
	}
}

#[rustfmt::skip]
impl CodeAsmEndbr64 for CodeAssembler {
	#[inline]
	fn endbr64(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Endbr64))
	}
}

#[rustfmt::skip]
impl CodeAsmEnqcmd<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn enqcmd(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Enqcmd_r16_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmEnqcmd<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn enqcmd(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Enqcmd_r32_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmEnqcmd<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn enqcmd(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Enqcmd_r64_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmEnqcmds<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn enqcmds(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Enqcmds_r16_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmEnqcmds<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn enqcmds(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Enqcmds_r32_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmEnqcmds<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn enqcmds(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Enqcmds_r64_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmEnter<i32, i32> for CodeAssembler {
	fn enter(&mut self, op0: i32, op1: i32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Enterq_imm16_imm8
		} else if self.bitness() >= 32 {
			Code::Enterd_imm16_imm8
		} else {
			Code::Enterw_imm16_imm8
		};
		self.add_instr(Instruction::with2(code, op0, op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmEnter<u32, u32> for CodeAssembler {
	fn enter(&mut self, op0: u32, op1: u32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Enterq_imm16_imm8
		} else if self.bitness() >= 32 {
			Code::Enterd_imm16_imm8
		} else {
			Code::Enterw_imm16_imm8
		};
		self.add_instr(Instruction::with2(code, op0, op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmErets for CodeAssembler {
	#[inline]
	fn erets(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Erets))
	}
}

#[rustfmt::skip]
impl CodeAsmEretu for CodeAssembler {
	#[inline]
	fn eretu(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Eretu))
	}
}

#[rustfmt::skip]
impl CodeAsmExtractps<AsmRegister32, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn extractps(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extractps_rm32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtractps<AsmRegister64, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn extractps(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extractps_r64m32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtractps<AsmMemoryOperand, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn extractps(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extractps_rm32_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtractps<AsmRegister32, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn extractps(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extractps_rm32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtractps<AsmRegister64, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn extractps(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extractps_r64m32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtractps<AsmMemoryOperand, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn extractps(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extractps_rm32_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtrq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn extrq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Extrq_xmm_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtrq3<AsmRegisterXmm, i32, i32> for CodeAssembler {
	#[inline]
	fn extrq_3(&mut self, op0: AsmRegisterXmm, op1: i32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extrq_xmm_imm8_imm8, op0.register(), op1, op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmExtrq3<AsmRegisterXmm, u32, u32> for CodeAssembler {
	#[inline]
	fn extrq_3(&mut self, op0: AsmRegisterXmm, op1: u32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Extrq_xmm_imm8_imm8, op0.register(), op1, op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmF2xm1 for CodeAssembler {
	#[inline]
	fn f2xm1(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::F2xm1))
	}
}

#[rustfmt::skip]
impl CodeAsmFabs for CodeAssembler {
	#[inline]
	fn fabs(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fabs))
	}
}

#[rustfmt::skip]
impl CodeAsmFadd<AsmMemoryOperand> for CodeAssembler {
	fn fadd(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fadd_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fadd_m32fp
		} else {
			return Err(IcedError::new("fadd: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFadd2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fadd_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		let code = if op0.register() == Register::ST0 { Code::Fadd_st0_sti } else { Code::Fadd_sti_st0 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFaddp<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn faddp(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Faddp_sti_st0, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFbld<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fbld(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fbld_m80bcd, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFbstp<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fbstp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fbstp_m80bcd, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFchs for CodeAssembler {
	#[inline]
	fn fchs(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fchs))
	}
}

#[rustfmt::skip]
impl CodeAsmFclex for CodeAssembler {
	#[inline]
	fn fclex(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fclex))
	}
}

#[rustfmt::skip]
impl CodeAsmFcmovb<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmovb(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmovb_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcmovbe<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmovbe(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmovbe_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcmove<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmove(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmove_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcmovnb<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmovnb(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmovnb_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcmovnbe<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmovnbe(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmovnbe_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcmovne<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmovne(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmovne_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcmovnu<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmovnu(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmovnu_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcmovu<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcmovu(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcmovu_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcom<AsmMemoryOperand> for CodeAssembler {
	fn fcom(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fcom_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fcom_m32fp
		} else {
			return Err(IcedError::new("fcom: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcom2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcom_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcom_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcomi<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcomi(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcomi_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcomip<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcomip(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcomip_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcomp<AsmMemoryOperand> for CodeAssembler {
	fn fcomp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fcomp_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fcomp_m32fp
		} else {
			return Err(IcedError::new("fcomp: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcomp2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fcomp_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fcomp_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFcompp for CodeAssembler {
	#[inline]
	fn fcompp(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fcompp))
	}
}

#[rustfmt::skip]
impl CodeAsmFcos for CodeAssembler {
	#[inline]
	fn fcos(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fcos))
	}
}

#[rustfmt::skip]
impl CodeAsmFdecstp for CodeAssembler {
	#[inline]
	fn fdecstp(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fdecstp))
	}
}

#[rustfmt::skip]
impl CodeAsmFdisi for CodeAssembler {
	#[inline]
	fn fdisi(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fdisi))
	}
}

#[rustfmt::skip]
impl CodeAsmFdiv<AsmMemoryOperand> for CodeAssembler {
	fn fdiv(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fdiv_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fdiv_m32fp
		} else {
			return Err(IcedError::new("fdiv: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFdiv2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fdiv_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		let code = if op0.register() == Register::ST0 { Code::Fdiv_st0_sti } else { Code::Fdiv_sti_st0 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFdivp<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fdivp(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fdivp_sti_st0, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFdivr<AsmMemoryOperand> for CodeAssembler {
	fn fdivr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fdivr_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fdivr_m32fp
		} else {
			return Err(IcedError::new("fdivr: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFdivr2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fdivr_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		let code = if op0.register() == Register::ST0 { Code::Fdivr_st0_sti } else { Code::Fdivr_sti_st0 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFdivrp<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fdivrp(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fdivrp_sti_st0, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFemms for CodeAssembler {
	#[inline]
	fn femms(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Femms))
	}
}

#[rustfmt::skip]
impl CodeAsmFeni for CodeAssembler {
	#[inline]
	fn feni(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Feni))
	}
}

#[rustfmt::skip]
impl CodeAsmFfree<AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn ffree(&mut self, op0: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ffree_sti, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFfreep<AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn ffreep(&mut self, op0: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ffreep_sti, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFiadd<AsmMemoryOperand> for CodeAssembler {
	fn fiadd(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Fiadd_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fiadd_m16int
		} else {
			return Err(IcedError::new("fiadd: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFicom<AsmMemoryOperand> for CodeAssembler {
	fn ficom(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Ficom_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Ficom_m16int
		} else {
			return Err(IcedError::new("ficom: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFicomp<AsmMemoryOperand> for CodeAssembler {
	fn ficomp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Ficomp_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Ficomp_m16int
		} else {
			return Err(IcedError::new("ficomp: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFidiv<AsmMemoryOperand> for CodeAssembler {
	fn fidiv(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Fidiv_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fidiv_m16int
		} else {
			return Err(IcedError::new("fidiv: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFidivr<AsmMemoryOperand> for CodeAssembler {
	fn fidivr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Fidivr_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fidivr_m16int
		} else {
			return Err(IcedError::new("fidivr: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFild<AsmMemoryOperand> for CodeAssembler {
	fn fild(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fild_m64int
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fild_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fild_m16int
		} else {
			return Err(IcedError::new("fild: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFimul<AsmMemoryOperand> for CodeAssembler {
	fn fimul(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Fimul_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fimul_m16int
		} else {
			return Err(IcedError::new("fimul: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFincstp for CodeAssembler {
	#[inline]
	fn fincstp(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fincstp))
	}
}

#[rustfmt::skip]
impl CodeAsmFinit for CodeAssembler {
	#[inline]
	fn finit(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Finit))
	}
}

#[rustfmt::skip]
impl CodeAsmFist<AsmMemoryOperand> for CodeAssembler {
	fn fist(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Fist_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fist_m16int
		} else {
			return Err(IcedError::new("fist: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFistp<AsmMemoryOperand> for CodeAssembler {
	fn fistp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fistp_m64int
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fistp_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fistp_m16int
		} else {
			return Err(IcedError::new("fistp: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFisttp<AsmMemoryOperand> for CodeAssembler {
	fn fisttp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fisttp_m64int
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fisttp_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fisttp_m16int
		} else {
			return Err(IcedError::new("fisttp: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFisub<AsmMemoryOperand> for CodeAssembler {
	fn fisub(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Fisub_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fisub_m16int
		} else {
			return Err(IcedError::new("fisub: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFisubr<AsmMemoryOperand> for CodeAssembler {
	fn fisubr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Fisubr_m32int
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Fisubr_m16int
		} else {
			return Err(IcedError::new("fisubr: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFld<AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fld(&mut self, op0: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fld_sti, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFld<AsmMemoryOperand> for CodeAssembler {
	fn fld(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Tbyte {
			Code::Fld_m80fp
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Fld_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fld_m32fp
		} else {
			return Err(IcedError::new("fld: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFld1 for CodeAssembler {
	#[inline]
	fn fld1(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fld1))
	}
}

#[rustfmt::skip]
impl CodeAsmFldcw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fldcw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fldcw_m2byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFldenv<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fldenv(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Fldenv_m28byte } else { Code::Fldenv_m14byte };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFldl2e for CodeAssembler {
	#[inline]
	fn fldl2e(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fldl2e))
	}
}

#[rustfmt::skip]
impl CodeAsmFldl2t for CodeAssembler {
	#[inline]
	fn fldl2t(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fldl2t))
	}
}

#[rustfmt::skip]
impl CodeAsmFldlg2 for CodeAssembler {
	#[inline]
	fn fldlg2(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fldlg2))
	}
}

#[rustfmt::skip]
impl CodeAsmFldln2 for CodeAssembler {
	#[inline]
	fn fldln2(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fldln2))
	}
}

#[rustfmt::skip]
impl CodeAsmFldpi for CodeAssembler {
	#[inline]
	fn fldpi(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fldpi))
	}
}

#[rustfmt::skip]
impl CodeAsmFldz for CodeAssembler {
	#[inline]
	fn fldz(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fldz))
	}
}

#[rustfmt::skip]
impl CodeAsmFmul<AsmMemoryOperand> for CodeAssembler {
	fn fmul(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fmul_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fmul_m32fp
		} else {
			return Err(IcedError::new("fmul: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFmul2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fmul_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		let code = if op0.register() == Register::ST0 { Code::Fmul_st0_sti } else { Code::Fmul_sti_st0 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFmulp<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fmulp(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fmulp_sti_st0, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFnclex for CodeAssembler {
	#[inline]
	fn fnclex(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fnclex))
	}
}

#[rustfmt::skip]
impl CodeAsmFndisi for CodeAssembler {
	#[inline]
	fn fndisi(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fndisi))
	}
}

#[rustfmt::skip]
impl CodeAsmFneni for CodeAssembler {
	#[inline]
	fn fneni(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fneni))
	}
}

#[rustfmt::skip]
impl CodeAsmFninit for CodeAssembler {
	#[inline]
	fn fninit(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fninit))
	}
}

#[rustfmt::skip]
impl CodeAsmFnop for CodeAssembler {
	#[inline]
	fn fnop(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fnop))
	}
}

#[rustfmt::skip]
impl CodeAsmFnsave<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fnsave(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Fnsave_m108byte } else { Code::Fnsave_m94byte };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFnsetpm for CodeAssembler {
	#[inline]
	fn fnsetpm(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fnsetpm))
	}
}

#[rustfmt::skip]
impl CodeAsmFnstcw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fnstcw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fnstcw_m2byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFnstdw<AsmRegister16> for CodeAssembler {
	#[inline]
	fn fnstdw(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fnstdw_AX, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFnstenv<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fnstenv(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Fnstenv_m28byte } else { Code::Fnstenv_m14byte };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFnstsg<AsmRegister16> for CodeAssembler {
	#[inline]
	fn fnstsg(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fnstsg_AX, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFnstsw<AsmRegister16> for CodeAssembler {
	#[inline]
	fn fnstsw(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fnstsw_AX, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFnstsw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fnstsw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fnstsw_m2byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFpatan for CodeAssembler {
	#[inline]
	fn fpatan(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fpatan))
	}
}

#[rustfmt::skip]
impl CodeAsmFprem for CodeAssembler {
	#[inline]
	fn fprem(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fprem))
	}
}

#[rustfmt::skip]
impl CodeAsmFprem1 for CodeAssembler {
	#[inline]
	fn fprem1(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fprem1))
	}
}

#[rustfmt::skip]
impl CodeAsmFptan for CodeAssembler {
	#[inline]
	fn fptan(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fptan))
	}
}

#[rustfmt::skip]
impl CodeAsmFrndint for CodeAssembler {
	#[inline]
	fn frndint(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Frndint))
	}
}

#[rustfmt::skip]
impl CodeAsmFrstor<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn frstor(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Frstor_m108byte } else { Code::Frstor_m94byte };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFrstpm for CodeAssembler {
	#[inline]
	fn frstpm(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Frstpm))
	}
}

#[rustfmt::skip]
impl CodeAsmFsave<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fsave(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Fsave_m108byte } else { Code::Fsave_m94byte };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFscale for CodeAssembler {
	#[inline]
	fn fscale(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fscale))
	}
}

#[rustfmt::skip]
impl CodeAsmFsetpm for CodeAssembler {
	#[inline]
	fn fsetpm(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fsetpm))
	}
}

#[rustfmt::skip]
impl CodeAsmFsin for CodeAssembler {
	#[inline]
	fn fsin(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fsin))
	}
}

#[rustfmt::skip]
impl CodeAsmFsincos for CodeAssembler {
	#[inline]
	fn fsincos(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fsincos))
	}
}

#[rustfmt::skip]
impl CodeAsmFsqrt for CodeAssembler {
	#[inline]
	fn fsqrt(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fsqrt))
	}
}

#[rustfmt::skip]
impl CodeAsmFst<AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fst(&mut self, op0: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fst_sti, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFst<AsmMemoryOperand> for CodeAssembler {
	fn fst(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fst_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fst_m32fp
		} else {
			return Err(IcedError::new("fst: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstcw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fstcw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fstcw_m2byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstdw<AsmRegister16> for CodeAssembler {
	#[inline]
	fn fstdw(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fstdw_AX, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstenv<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fstenv(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Fstenv_m28byte } else { Code::Fstenv_m14byte };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstp<AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fstp(&mut self, op0: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fstp_sti, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstp<AsmMemoryOperand> for CodeAssembler {
	fn fstp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Tbyte {
			Code::Fstp_m80fp
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Fstp_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fstp_m32fp
		} else {
			return Err(IcedError::new("fstp: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstpnce<AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fstpnce(&mut self, op0: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fstpnce_sti, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstsg<AsmRegister16> for CodeAssembler {
	#[inline]
	fn fstsg(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fstsg_AX, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstsw<AsmRegister16> for CodeAssembler {
	#[inline]
	fn fstsw(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fstsw_AX, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFstsw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fstsw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fstsw_m2byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFsub<AsmMemoryOperand> for CodeAssembler {
	fn fsub(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fsub_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fsub_m32fp
		} else {
			return Err(IcedError::new("fsub: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFsub2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fsub_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		let code = if op0.register() == Register::ST0 { Code::Fsub_st0_sti } else { Code::Fsub_sti_st0 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFsubp<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fsubp(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fsubp_sti_st0, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFsubr<AsmMemoryOperand> for CodeAssembler {
	fn fsubr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Fsubr_m64fp
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Fsubr_m32fp
		} else {
			return Err(IcedError::new("fsubr: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFsubr2<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fsubr_2(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		let code = if op0.register() == Register::ST0 { Code::Fsubr_st0_sti } else { Code::Fsubr_sti_st0 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFsubrp<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fsubrp(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fsubrp_sti_st0, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFtst for CodeAssembler {
	#[inline]
	fn ftst(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Ftst))
	}
}

#[rustfmt::skip]
impl CodeAsmFucom<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fucom(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fucom_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFucomi<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fucomi(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fucomi_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFucomip<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fucomip(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fucomip_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFucomp<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fucomp(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fucomp_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFucompp for CodeAssembler {
	#[inline]
	fn fucompp(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fucompp))
	}
}

#[rustfmt::skip]
impl CodeAsmFxam for CodeAssembler {
	#[inline]
	fn fxam(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fxam))
	}
}

#[rustfmt::skip]
impl CodeAsmFxch<AsmRegisterSt, AsmRegisterSt> for CodeAssembler {
	#[inline]
	fn fxch(&mut self, op0: AsmRegisterSt, op1: AsmRegisterSt) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Fxch_st0_sti, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmFxrstor<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fxrstor(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fxrstor_m512byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFxrstor64<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fxrstor64(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fxrstor64_m512byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFxsave<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fxsave(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fxsave_m512byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFxsave64<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn fxsave64(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Fxsave64_m512byte, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmFxtract for CodeAssembler {
	#[inline]
	fn fxtract(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fxtract))
	}
}

#[rustfmt::skip]
impl CodeAsmFyl2x for CodeAssembler {
	#[inline]
	fn fyl2x(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fyl2x))
	}
}

#[rustfmt::skip]
impl CodeAsmFyl2xp1 for CodeAssembler {
	#[inline]
	fn fyl2xp1(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Fyl2xp1))
	}
}

#[rustfmt::skip]
impl CodeAsmGetsec for CodeAssembler {
	#[inline]
	fn getsec(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Getsecd))
	}
}

#[rustfmt::skip]
impl CodeAsmGetsecq for CodeAssembler {
	#[inline]
	fn getsecq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Getsecq))
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineinvqb<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn gf2p8affineinvqb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineinvqb_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineinvqb<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn gf2p8affineinvqb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineinvqb_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineinvqb<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn gf2p8affineinvqb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineinvqb_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineinvqb<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn gf2p8affineinvqb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineinvqb_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineqb<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn gf2p8affineqb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineqb_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineqb<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn gf2p8affineqb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineqb_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineqb<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn gf2p8affineqb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineqb_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8affineqb<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn gf2p8affineqb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Gf2p8affineqb_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8mulb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn gf2p8mulb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Gf2p8mulb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmGf2p8mulb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn gf2p8mulb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Gf2p8mulb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmHaddpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn haddpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Haddpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmHaddpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn haddpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Haddpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmHaddps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn haddps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Haddps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmHaddps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn haddps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Haddps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmHlt for CodeAssembler {
	#[inline]
	fn hlt(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Hlt))
	}
}

#[rustfmt::skip]
impl CodeAsmHreset<i32> for CodeAssembler {
	#[inline]
	fn hreset(&mut self, op0: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Hreset_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmHreset<u32> for CodeAssembler {
	#[inline]
	fn hreset(&mut self, op0: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Hreset_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmHsubpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn hsubpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Hsubpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmHsubpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn hsubpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Hsubpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmHsubps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn hsubps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Hsubps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmHsubps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn hsubps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Hsubps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmIbts<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn ibts(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ibts_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIbts<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn ibts(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ibts_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIbts<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn ibts(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ibts_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIbts<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn ibts(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ibts_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIdiv<AsmRegister8> for CodeAssembler {
	#[inline]
	fn idiv(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Idiv_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIdiv<AsmRegister16> for CodeAssembler {
	#[inline]
	fn idiv(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Idiv_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIdiv<AsmRegister32> for CodeAssembler {
	#[inline]
	fn idiv(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Idiv_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIdiv<AsmRegister64> for CodeAssembler {
	#[inline]
	fn idiv(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Idiv_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIdiv<AsmMemoryOperand> for CodeAssembler {
	fn idiv(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Idiv_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Idiv_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Idiv_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Idiv_rm8
		} else {
			return Err(IcedError::new("idiv: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul<AsmRegister8> for CodeAssembler {
	#[inline]
	fn imul(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Imul_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul<AsmRegister16> for CodeAssembler {
	#[inline]
	fn imul(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Imul_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul<AsmRegister32> for CodeAssembler {
	#[inline]
	fn imul(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Imul_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul<AsmRegister64> for CodeAssembler {
	#[inline]
	fn imul(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Imul_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul<AsmMemoryOperand> for CodeAssembler {
	fn imul(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Imul_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Imul_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Imul_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Imul_rm8
		} else {
			return Err(IcedError::new("imul: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul2<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn imul_2(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Imul_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul2<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn imul_2(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Imul_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul2<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn imul_2(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Imul_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul2<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn imul_2(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Imul_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul2<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn imul_2(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Imul_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul2<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn imul_2(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Imul_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister16, AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: i32) -> Result<(), IcedError> {
		let code = if op2 >= i8::MIN as i32 && op2 <= i8::MAX as i32 { Code::Imul_r16_rm16_imm8 } else { Code::Imul_r16_rm16_imm16 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister32, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		let code = if op2 >= i8::MIN as i32 && op2 <= i8::MAX as i32 { Code::Imul_r32_rm32_imm8 } else { Code::Imul_r32_rm32_imm32 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister64, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		let code = if op2 >= i8::MIN as i32 && op2 <= i8::MAX as i32 { Code::Imul_r64_rm64_imm8 } else { Code::Imul_r64_rm64_imm32 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister16, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		let code = if op2 >= i8::MIN as i32 && op2 <= i8::MAX as i32 { Code::Imul_r16_rm16_imm8 } else { Code::Imul_r16_rm16_imm16 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister32, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		let code = if op2 >= i8::MIN as i32 && op2 <= i8::MAX as i32 { Code::Imul_r32_rm32_imm8 } else { Code::Imul_r32_rm32_imm32 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister64, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		let code = if op2 >= i8::MIN as i32 && op2 <= i8::MAX as i32 { Code::Imul_r64_rm64_imm8 } else { Code::Imul_r64_rm64_imm32 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister16, AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: u32) -> Result<(), IcedError> {
		let code = if op2 <= i8::MAX as u32 || (0xFF80 <= op2 && op2 <= 0xFFFF) { Code::Imul_r16_rm16_imm8 } else { Code::Imul_r16_rm16_imm16 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister32, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		let code = if op2 <= i8::MAX as u32 || 0xFFFF_FF80 <= op2 { Code::Imul_r32_rm32_imm8 } else { Code::Imul_r32_rm32_imm32 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister16, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		let code = if op2 <= i8::MAX as u32 || (0xFF80 <= op2 && op2 <= 0xFFFF) { Code::Imul_r16_rm16_imm8 } else { Code::Imul_r16_rm16_imm16 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmImul3<AsmRegister32, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn imul_3(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		let code = if op2 <= i8::MAX as u32 || 0xFFFF_FF80 <= op2 { Code::Imul_r32_rm32_imm8 } else { Code::Imul_r32_rm32_imm32 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister8, AsmRegister16> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister8, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_AL_DX, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_AX_DX, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister32, AsmRegister16> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister32, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_EAX_DX, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_AL_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_AX_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_EAX_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_AL_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_AX_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmIn<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn in_(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::In_EAX_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInc<AsmRegister8> for CodeAssembler {
	#[inline]
	fn inc(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Inc_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmInc<AsmRegister16> for CodeAssembler {
	#[inline]
	fn inc(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 { Code::Inc_rm16 } else { Code::Inc_r16 };
		self.add_instr(Instruction::with1(code, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmInc<AsmRegister32> for CodeAssembler {
	#[inline]
	fn inc(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 { Code::Inc_rm32 } else { Code::Inc_r32 };
		self.add_instr(Instruction::with1(code, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmInc<AsmRegister64> for CodeAssembler {
	#[inline]
	fn inc(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Inc_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmInc<AsmMemoryOperand> for CodeAssembler {
	fn inc(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Inc_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Inc_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Inc_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Inc_rm8
		} else {
			return Err(IcedError::new("inc: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmIncsspd<AsmRegister32> for CodeAssembler {
	#[inline]
	fn incsspd(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Incsspd_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmIncsspq<AsmRegister64> for CodeAssembler {
	#[inline]
	fn incsspq(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Incsspq_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsb for CodeAssembler {
	#[inline]
	fn insb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_insb(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsd for CodeAssembler {
	#[inline]
	fn insd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_insd(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsertps<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn insertps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Insertps_xmm_xmmm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsertps<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn insertps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Insertps_xmm_xmmm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsertps<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn insertps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Insertps_xmm_xmmm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsertps<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn insertps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Insertps_xmm_xmmm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsertq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn insertq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Insertq_xmm_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsertq4<AsmRegisterXmm, AsmRegisterXmm, i32, i32> for CodeAssembler {
	#[inline]
	fn insertq_4(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::Insertq_xmm_xmm_imm8_imm8, op0.register(), op1.register(), op2, op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsertq4<AsmRegisterXmm, AsmRegisterXmm, u32, u32> for CodeAssembler {
	#[inline]
	fn insertq_4(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::Insertq_xmm_xmm_imm8_imm8, op0.register(), op1.register(), op2, op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInsw for CodeAssembler {
	#[inline]
	fn insw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_insw(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInt<i32> for CodeAssembler {
	#[inline]
	fn int(&mut self, op0: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Int_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInt<u32> for CodeAssembler {
	#[inline]
	fn int(&mut self, op0: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Int_imm8, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmInt1 for CodeAssembler {
	#[inline]
	fn int1(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Int1))
	}
}

#[rustfmt::skip]
impl CodeAsmInt3 for CodeAssembler {
	#[inline]
	fn int3(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Int3))
	}
}

#[rustfmt::skip]
impl CodeAsmInto for CodeAssembler {
	#[inline]
	fn into(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Into))
	}
}

#[rustfmt::skip]
impl CodeAsmInvd for CodeAssembler {
	#[inline]
	fn invd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Invd))
	}
}

#[rustfmt::skip]
impl CodeAsmInvept<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn invept(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Invept_r32_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmInvept<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn invept(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Invept_r64_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmInvlpg<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn invlpg(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Invlpg_m, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmInvlpga for CodeAssembler {
	fn invlpga(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Invlpgaq
		} else if self.bitness() >= 32 {
			Code::Invlpgad
		} else {
			Code::Invlpgaw
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmInvlpgb for CodeAssembler {
	fn invlpgb(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Invlpgbq
		} else if self.bitness() >= 32 {
			Code::Invlpgbd
		} else {
			Code::Invlpgbw
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmInvpcid<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn invpcid(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Invpcid_r32_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmInvpcid<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn invpcid(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Invpcid_r64_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmInvvpid<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn invvpid(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Invvpid_r32_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmInvvpid<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn invvpid(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Invvpid_r64_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmIret for CodeAssembler {
	#[inline]
	fn iret(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Iretw))
	}
}

#[rustfmt::skip]
impl CodeAsmIretd for CodeAssembler {
	#[inline]
	fn iretd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Iretd))
	}
}

#[rustfmt::skip]
impl CodeAsmIretq for CodeAssembler {
	#[inline]
	fn iretq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Iretq))
	}
}

#[rustfmt::skip]
impl CodeAsmJa<CodeLabel> for CodeAssembler {
	fn ja(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Ja_rel8_64
			} else if self.bitness() >= 32 {
				Code::Ja_rel8_32
			} else {
				Code::Ja_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Ja_rel32_64
		} else if self.bitness() >= 32 {
			Code::Ja_rel32_32
		} else {
			Code::Ja_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJa<u64> for CodeAssembler {
	fn ja(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Ja_rel8_64
			} else if self.bitness() >= 32 {
				Code::Ja_rel8_32
			} else {
				Code::Ja_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Ja_rel32_64
		} else if self.bitness() >= 32 {
			Code::Ja_rel32_32
		} else {
			Code::Ja_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJae<CodeLabel> for CodeAssembler {
	fn jae(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jae_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jae_rel8_32
			} else {
				Code::Jae_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jae_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jae_rel32_32
		} else {
			Code::Jae_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJae<u64> for CodeAssembler {
	fn jae(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jae_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jae_rel8_32
			} else {
				Code::Jae_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jae_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jae_rel32_32
		} else {
			Code::Jae_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJb<CodeLabel> for CodeAssembler {
	fn jb(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jb_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jb_rel8_32
			} else {
				Code::Jb_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jb_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jb_rel32_32
		} else {
			Code::Jb_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJb<u64> for CodeAssembler {
	fn jb(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jb_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jb_rel8_32
			} else {
				Code::Jb_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jb_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jb_rel32_32
		} else {
			Code::Jb_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJbe<CodeLabel> for CodeAssembler {
	fn jbe(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jbe_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jbe_rel8_32
			} else {
				Code::Jbe_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jbe_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jbe_rel32_32
		} else {
			Code::Jbe_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJbe<u64> for CodeAssembler {
	fn jbe(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jbe_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jbe_rel8_32
			} else {
				Code::Jbe_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jbe_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jbe_rel32_32
		} else {
			Code::Jbe_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJc<CodeLabel> for CodeAssembler {
	fn jc(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jb_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jb_rel8_32
			} else {
				Code::Jb_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jb_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jb_rel32_32
		} else {
			Code::Jb_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJc<u64> for CodeAssembler {
	fn jc(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jb_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jb_rel8_32
			} else {
				Code::Jb_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jb_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jb_rel32_32
		} else {
			Code::Jb_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJcxz<CodeLabel> for CodeAssembler {
	#[inline]
	fn jcxz(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_branch(Code::Jcxz_rel8_16, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJcxz<u64> for CodeAssembler {
	#[inline]
	fn jcxz(&mut self, op0: u64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_branch(Code::Jcxz_rel8_16, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJe<CodeLabel> for CodeAssembler {
	fn je(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Je_rel8_64
			} else if self.bitness() >= 32 {
				Code::Je_rel8_32
			} else {
				Code::Je_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Je_rel32_64
		} else if self.bitness() >= 32 {
			Code::Je_rel32_32
		} else {
			Code::Je_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJe<u64> for CodeAssembler {
	fn je(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Je_rel8_64
			} else if self.bitness() >= 32 {
				Code::Je_rel8_32
			} else {
				Code::Je_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Je_rel32_64
		} else if self.bitness() >= 32 {
			Code::Je_rel32_32
		} else {
			Code::Je_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJecxz<CodeLabel> for CodeAssembler {
	#[inline]
	fn jecxz(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_branch(Code::Jecxz_rel8_32, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJecxz<u64> for CodeAssembler {
	#[inline]
	fn jecxz(&mut self, op0: u64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_branch(Code::Jecxz_rel8_32, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJg<CodeLabel> for CodeAssembler {
	fn jg(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jg_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jg_rel8_32
			} else {
				Code::Jg_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jg_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jg_rel32_32
		} else {
			Code::Jg_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJg<u64> for CodeAssembler {
	fn jg(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jg_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jg_rel8_32
			} else {
				Code::Jg_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jg_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jg_rel32_32
		} else {
			Code::Jg_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJge<CodeLabel> for CodeAssembler {
	fn jge(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jge_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jge_rel8_32
			} else {
				Code::Jge_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jge_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jge_rel32_32
		} else {
			Code::Jge_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJge<u64> for CodeAssembler {
	fn jge(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jge_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jge_rel8_32
			} else {
				Code::Jge_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jge_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jge_rel32_32
		} else {
			Code::Jge_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJl<CodeLabel> for CodeAssembler {
	fn jl(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jl_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jl_rel8_32
			} else {
				Code::Jl_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jl_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jl_rel32_32
		} else {
			Code::Jl_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJl<u64> for CodeAssembler {
	fn jl(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jl_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jl_rel8_32
			} else {
				Code::Jl_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jl_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jl_rel32_32
		} else {
			Code::Jl_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJle<CodeLabel> for CodeAssembler {
	fn jle(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jle_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jle_rel8_32
			} else {
				Code::Jle_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jle_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jle_rel32_32
		} else {
			Code::Jle_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJle<u64> for CodeAssembler {
	fn jle(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jle_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jle_rel8_32
			} else {
				Code::Jle_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jle_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jle_rel32_32
		} else {
			Code::Jle_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmp<AsmRegister16> for CodeAssembler {
	#[inline]
	fn jmp(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Jmp_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmp<AsmRegister32> for CodeAssembler {
	#[inline]
	fn jmp(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Jmp_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmp<AsmRegister64> for CodeAssembler {
	#[inline]
	fn jmp(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Jmp_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmp<AsmMemoryOperand> for CodeAssembler {
	fn jmp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Tbyte {
			Code::Jmp_m1664
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Jmp_rm64
		} else if op0.size() == MemoryOperandSize::Fword {
			Code::Jmp_m1632
		} else if op0.size() == MemoryOperandSize::Dword {
			if self.bitness() >= 32 { Code::Jmp_rm32 } else { Code::Jmp_m1616 }
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Jmp_rm16
		} else {
			return Err(IcedError::new("jmp: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmp<CodeLabel> for CodeAssembler {
	fn jmp(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jmp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jmp_rel8_32
			} else {
				Code::Jmp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jmp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jmp_rel32_32
		} else {
			Code::Jmp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmp<u64> for CodeAssembler {
	fn jmp(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jmp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jmp_rel8_32
			} else {
				Code::Jmp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jmp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jmp_rel32_32
		} else {
			Code::Jmp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmpe<AsmRegister16> for CodeAssembler {
	#[inline]
	fn jmpe(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Jmpe_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmpe<AsmRegister32> for CodeAssembler {
	#[inline]
	fn jmpe(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Jmpe_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmpe<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn jmpe(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Jmpe_rm32 } else { Code::Jmpe_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmpe<CodeLabel> for CodeAssembler {
	#[inline]
	fn jmpe(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Jmpe_disp32 } else { Code::Jmpe_disp16 };
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJmpe<u64> for CodeAssembler {
	#[inline]
	fn jmpe(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Jmpe_disp32 } else { Code::Jmpe_disp16 };
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJna<CodeLabel> for CodeAssembler {
	fn jna(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jbe_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jbe_rel8_32
			} else {
				Code::Jbe_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jbe_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jbe_rel32_32
		} else {
			Code::Jbe_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJna<u64> for CodeAssembler {
	fn jna(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jbe_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jbe_rel8_32
			} else {
				Code::Jbe_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jbe_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jbe_rel32_32
		} else {
			Code::Jbe_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnae<CodeLabel> for CodeAssembler {
	fn jnae(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jb_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jb_rel8_32
			} else {
				Code::Jb_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jb_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jb_rel32_32
		} else {
			Code::Jb_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnae<u64> for CodeAssembler {
	fn jnae(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jb_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jb_rel8_32
			} else {
				Code::Jb_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jb_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jb_rel32_32
		} else {
			Code::Jb_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnb<CodeLabel> for CodeAssembler {
	fn jnb(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jae_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jae_rel8_32
			} else {
				Code::Jae_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jae_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jae_rel32_32
		} else {
			Code::Jae_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnb<u64> for CodeAssembler {
	fn jnb(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jae_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jae_rel8_32
			} else {
				Code::Jae_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jae_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jae_rel32_32
		} else {
			Code::Jae_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnbe<CodeLabel> for CodeAssembler {
	fn jnbe(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Ja_rel8_64
			} else if self.bitness() >= 32 {
				Code::Ja_rel8_32
			} else {
				Code::Ja_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Ja_rel32_64
		} else if self.bitness() >= 32 {
			Code::Ja_rel32_32
		} else {
			Code::Ja_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnbe<u64> for CodeAssembler {
	fn jnbe(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Ja_rel8_64
			} else if self.bitness() >= 32 {
				Code::Ja_rel8_32
			} else {
				Code::Ja_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Ja_rel32_64
		} else if self.bitness() >= 32 {
			Code::Ja_rel32_32
		} else {
			Code::Ja_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnc<CodeLabel> for CodeAssembler {
	fn jnc(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jae_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jae_rel8_32
			} else {
				Code::Jae_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jae_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jae_rel32_32
		} else {
			Code::Jae_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnc<u64> for CodeAssembler {
	fn jnc(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jae_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jae_rel8_32
			} else {
				Code::Jae_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jae_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jae_rel32_32
		} else {
			Code::Jae_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJne<CodeLabel> for CodeAssembler {
	fn jne(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jne_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jne_rel8_32
			} else {
				Code::Jne_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jne_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jne_rel32_32
		} else {
			Code::Jne_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJne<u64> for CodeAssembler {
	fn jne(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jne_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jne_rel8_32
			} else {
				Code::Jne_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jne_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jne_rel32_32
		} else {
			Code::Jne_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJng<CodeLabel> for CodeAssembler {
	fn jng(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jle_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jle_rel8_32
			} else {
				Code::Jle_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jle_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jle_rel32_32
		} else {
			Code::Jle_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJng<u64> for CodeAssembler {
	fn jng(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jle_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jle_rel8_32
			} else {
				Code::Jle_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jle_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jle_rel32_32
		} else {
			Code::Jle_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnge<CodeLabel> for CodeAssembler {
	fn jnge(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jl_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jl_rel8_32
			} else {
				Code::Jl_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jl_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jl_rel32_32
		} else {
			Code::Jl_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnge<u64> for CodeAssembler {
	fn jnge(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jl_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jl_rel8_32
			} else {
				Code::Jl_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jl_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jl_rel32_32
		} else {
			Code::Jl_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnl<CodeLabel> for CodeAssembler {
	fn jnl(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jge_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jge_rel8_32
			} else {
				Code::Jge_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jge_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jge_rel32_32
		} else {
			Code::Jge_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnl<u64> for CodeAssembler {
	fn jnl(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jge_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jge_rel8_32
			} else {
				Code::Jge_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jge_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jge_rel32_32
		} else {
			Code::Jge_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnle<CodeLabel> for CodeAssembler {
	fn jnle(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jg_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jg_rel8_32
			} else {
				Code::Jg_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jg_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jg_rel32_32
		} else {
			Code::Jg_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnle<u64> for CodeAssembler {
	fn jnle(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jg_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jg_rel8_32
			} else {
				Code::Jg_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jg_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jg_rel32_32
		} else {
			Code::Jg_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJno<CodeLabel> for CodeAssembler {
	fn jno(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jno_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jno_rel8_32
			} else {
				Code::Jno_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jno_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jno_rel32_32
		} else {
			Code::Jno_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJno<u64> for CodeAssembler {
	fn jno(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jno_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jno_rel8_32
			} else {
				Code::Jno_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jno_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jno_rel32_32
		} else {
			Code::Jno_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnp<CodeLabel> for CodeAssembler {
	fn jnp(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jnp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jnp_rel8_32
			} else {
				Code::Jnp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jnp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jnp_rel32_32
		} else {
			Code::Jnp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnp<u64> for CodeAssembler {
	fn jnp(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jnp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jnp_rel8_32
			} else {
				Code::Jnp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jnp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jnp_rel32_32
		} else {
			Code::Jnp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJns<CodeLabel> for CodeAssembler {
	fn jns(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jns_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jns_rel8_32
			} else {
				Code::Jns_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jns_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jns_rel32_32
		} else {
			Code::Jns_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJns<u64> for CodeAssembler {
	fn jns(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jns_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jns_rel8_32
			} else {
				Code::Jns_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jns_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jns_rel32_32
		} else {
			Code::Jns_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnz<CodeLabel> for CodeAssembler {
	fn jnz(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jne_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jne_rel8_32
			} else {
				Code::Jne_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jne_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jne_rel32_32
		} else {
			Code::Jne_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJnz<u64> for CodeAssembler {
	fn jnz(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jne_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jne_rel8_32
			} else {
				Code::Jne_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jne_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jne_rel32_32
		} else {
			Code::Jne_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJo<CodeLabel> for CodeAssembler {
	fn jo(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jo_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jo_rel8_32
			} else {
				Code::Jo_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jo_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jo_rel32_32
		} else {
			Code::Jo_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJo<u64> for CodeAssembler {
	fn jo(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jo_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jo_rel8_32
			} else {
				Code::Jo_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jo_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jo_rel32_32
		} else {
			Code::Jo_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJp<CodeLabel> for CodeAssembler {
	fn jp(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jp_rel8_32
			} else {
				Code::Jp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jp_rel32_32
		} else {
			Code::Jp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJp<u64> for CodeAssembler {
	fn jp(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jp_rel8_32
			} else {
				Code::Jp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jp_rel32_32
		} else {
			Code::Jp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJpe<CodeLabel> for CodeAssembler {
	fn jpe(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jp_rel8_32
			} else {
				Code::Jp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jp_rel32_32
		} else {
			Code::Jp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJpe<u64> for CodeAssembler {
	fn jpe(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jp_rel8_32
			} else {
				Code::Jp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jp_rel32_32
		} else {
			Code::Jp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJpo<CodeLabel> for CodeAssembler {
	fn jpo(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jnp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jnp_rel8_32
			} else {
				Code::Jnp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jnp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jnp_rel32_32
		} else {
			Code::Jnp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJpo<u64> for CodeAssembler {
	fn jpo(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Jnp_rel8_64
			} else if self.bitness() >= 32 {
				Code::Jnp_rel8_32
			} else {
				Code::Jnp_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Jnp_rel32_64
		} else if self.bitness() >= 32 {
			Code::Jnp_rel32_32
		} else {
			Code::Jnp_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJrcxz<CodeLabel> for CodeAssembler {
	#[inline]
	fn jrcxz(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_branch(Code::Jrcxz_rel8_64, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJrcxz<u64> for CodeAssembler {
	#[inline]
	fn jrcxz(&mut self, op0: u64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_branch(Code::Jrcxz_rel8_64, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJs<CodeLabel> for CodeAssembler {
	fn js(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Js_rel8_64
			} else if self.bitness() >= 32 {
				Code::Js_rel8_32
			} else {
				Code::Js_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Js_rel32_64
		} else if self.bitness() >= 32 {
			Code::Js_rel32_32
		} else {
			Code::Js_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJs<u64> for CodeAssembler {
	fn js(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Js_rel8_64
			} else if self.bitness() >= 32 {
				Code::Js_rel8_32
			} else {
				Code::Js_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Js_rel32_64
		} else if self.bitness() >= 32 {
			Code::Js_rel32_32
		} else {
			Code::Js_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmJz<CodeLabel> for CodeAssembler {
	fn jz(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Je_rel8_64
			} else if self.bitness() >= 32 {
				Code::Je_rel8_32
			} else {
				Code::Je_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Je_rel32_64
		} else if self.bitness() >= 32 {
			Code::Je_rel32_32
		} else {
			Code::Je_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmJz<u64> for CodeAssembler {
	fn jz(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.prefer_short_branch() {
			if self.bitness() == 64 {
				Code::Je_rel8_64
			} else if self.bitness() >= 32 {
				Code::Je_rel8_32
			} else {
				Code::Je_rel8_16
			}
		} else if self.bitness() == 64 {
			Code::Je_rel32_64
		} else if self.bitness() >= 32 {
			Code::Je_rel32_32
		} else {
			Code::Je_rel16
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKaddb<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kaddb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kaddb_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKaddd<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kaddd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kaddd_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKaddq<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kaddq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kaddq_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKaddw<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kaddw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kaddw_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandb<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandb_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandd<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandd_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandnb<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandnb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandnb_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandnd<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandnd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandnd_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandnq<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandnq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandnq_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandnw<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandnw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandnw_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandq<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandq_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKandw<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kandw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kandw_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovb<AsmRegisterK, AsmRegister32> for CodeAssembler {
	#[inline]
	fn kmovb(&mut self, op0: AsmRegisterK, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovb_kr_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovb<AsmRegister32, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovb(&mut self, op0: AsmRegister32, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovb_r32_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovb<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovb_kr_km8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovb<AsmMemoryOperand, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovb(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovb_m8_kr, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovb<AsmRegisterK, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn kmovb(&mut self, op0: AsmRegisterK, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovb_kr_km8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovd<AsmRegisterK, AsmRegister32> for CodeAssembler {
	#[inline]
	fn kmovd(&mut self, op0: AsmRegisterK, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovd_kr_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovd<AsmRegister32, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovd(&mut self, op0: AsmRegister32, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovd_r32_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovd<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovd_kr_km32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovd<AsmMemoryOperand, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovd_m32_kr, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovd<AsmRegisterK, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn kmovd(&mut self, op0: AsmRegisterK, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovd_kr_km32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovq<AsmRegisterK, AsmRegister64> for CodeAssembler {
	#[inline]
	fn kmovq(&mut self, op0: AsmRegisterK, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovq_kr_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovq<AsmRegister64, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovq(&mut self, op0: AsmRegister64, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovq_r64_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovq<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovq_kr_km64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovq<AsmMemoryOperand, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovq(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovq_m64_kr, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovq<AsmRegisterK, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn kmovq(&mut self, op0: AsmRegisterK, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovq_kr_km64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovw<AsmRegisterK, AsmRegister32> for CodeAssembler {
	#[inline]
	fn kmovw(&mut self, op0: AsmRegisterK, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovw_kr_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovw<AsmRegister32, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovw(&mut self, op0: AsmRegister32, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovw_r32_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovw<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovw_kr_km16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovw<AsmMemoryOperand, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kmovw(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovw_m16_kr, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKmovw<AsmRegisterK, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn kmovw(&mut self, op0: AsmRegisterK, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kmovw_kr_km16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmKnotb<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn knotb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Knotb_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKnotd<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn knotd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Knotd_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKnotq<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn knotq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Knotq_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKnotw<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn knotw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Knotw_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKorb<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn korb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Korb_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKord<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kord(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kord_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKorq<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn korq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Korq_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKortestb<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kortestb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kortestb_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKortestd<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kortestd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kortestd_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKortestq<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kortestq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kortestq_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKortestw<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kortestw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Kortestw_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKorw<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn korw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Korw_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftlb<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftlb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftlb_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftlb<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftlb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftlb_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftld<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftld(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftld_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftld<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftld(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftld_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftlq<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftlq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftlq_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftlq<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftlq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftlq_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftlw<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftlw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftlw_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftlw<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftlw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftlw_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrb<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftrb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrb_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrb<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftrb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrb_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrd<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftrd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrd_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrd<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftrd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrd_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrq<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftrq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrq_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrq<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftrq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrq_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrw<AsmRegisterK, AsmRegisterK, i32> for CodeAssembler {
	#[inline]
	fn kshiftrw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrw_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKshiftrw<AsmRegisterK, AsmRegisterK, u32> for CodeAssembler {
	#[inline]
	fn kshiftrw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kshiftrw_kr_kr_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmKtestb<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn ktestb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Ktestb_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKtestd<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn ktestd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Ktestd_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKtestq<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn ktestq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Ktestq_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKtestw<AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn ktestw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Ktestw_kr_kr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKunpckbw<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kunpckbw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kunpckbw_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKunpckdq<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kunpckdq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kunpckdq_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKunpckwd<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kunpckwd(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kunpckwd_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxnorb<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxnorb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxnorb_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxnord<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxnord(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxnord_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxnorq<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxnorq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxnorq_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxnorw<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxnorw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxnorw_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxorb<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxorb(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxorb_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxord<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxord(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxord_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxorq<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxorq(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxorq_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmKxorw<AsmRegisterK, AsmRegisterK, AsmRegisterK> for CodeAssembler {
	#[inline]
	fn kxorw(&mut self, op0: AsmRegisterK, op1: AsmRegisterK, op2: AsmRegisterK) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Kxorw_kr_kr_kr, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLahf for CodeAssembler {
	#[inline]
	fn lahf(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Lahf))
	}
}

#[rustfmt::skip]
impl CodeAsmLar<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn lar(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lar_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLar<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn lar(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lar_r32_r32m16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLar<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn lar(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lar_r64_r64m16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLar<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lar(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lar_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLar<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lar(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lar_r32_r32m16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLddqu<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lddqu(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lddqu_xmm_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLdmxcsr<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ldmxcsr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ldmxcsr_m32, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLds<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lds(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lds_r16_m1616, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLds<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lds(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lds_r32_m1632, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLdtilecfg<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ldtilecfg(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::VEX_Ldtilecfg_m512, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLea<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lea(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lea_r16_m, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLea<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lea(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lea_r32_m, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLea<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lea(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lea_r64_m, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLeave for CodeAssembler {
	fn leave(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Leaveq
		} else if self.bitness() >= 32 {
			Code::Leaved
		} else {
			Code::Leavew
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmLes<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn les(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Les_r16_m1616, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLes<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn les(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Les_r32_m1632, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLfence for CodeAssembler {
	#[inline]
	fn lfence(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Lfence))
	}
}

#[rustfmt::skip]
impl CodeAsmLfs<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lfs(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lfs_r16_m1616, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLfs<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lfs(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lfs_r32_m1632, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLfs<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lfs(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lfs_r64_m1664, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLgdt<AsmMemoryOperand> for CodeAssembler {
	fn lgdt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Lgdt_m1664
		} else if self.bitness() >= 32 {
			Code::Lgdt_m1632
		} else {
			Code::Lgdt_m1632_16
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLgs<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lgs(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lgs_r16_m1616, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLgs<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lgs(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lgs_r32_m1632, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLgs<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lgs(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lgs_r64_m1664, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLidt<AsmMemoryOperand> for CodeAssembler {
	fn lidt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Lidt_m1664
		} else if self.bitness() >= 32 {
			Code::Lidt_m1632
		} else {
			Code::Lidt_m1632_16
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLkgs<AsmRegister16> for CodeAssembler {
	#[inline]
	fn lkgs(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lkgs_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLkgs<AsmRegister32> for CodeAssembler {
	#[inline]
	fn lkgs(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lkgs_r32m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLkgs<AsmRegister64> for CodeAssembler {
	#[inline]
	fn lkgs(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lkgs_r64m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLkgs<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lkgs(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Lkgs_r32m16 } else { Code::Lkgs_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLldt<AsmRegister16> for CodeAssembler {
	#[inline]
	fn lldt(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lldt_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLldt<AsmRegister32> for CodeAssembler {
	#[inline]
	fn lldt(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lldt_r32m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLldt<AsmRegister64> for CodeAssembler {
	#[inline]
	fn lldt(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lldt_r64m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLldt<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lldt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Lldt_r32m16 } else { Code::Lldt_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLlwpcb<AsmRegister32> for CodeAssembler {
	#[inline]
	fn llwpcb(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::XOP_Llwpcb_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLlwpcb<AsmRegister64> for CodeAssembler {
	#[inline]
	fn llwpcb(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::XOP_Llwpcb_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLmsw<AsmRegister16> for CodeAssembler {
	#[inline]
	fn lmsw(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lmsw_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLmsw<AsmRegister32> for CodeAssembler {
	#[inline]
	fn lmsw(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lmsw_r32m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLmsw<AsmRegister64> for CodeAssembler {
	#[inline]
	fn lmsw(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Lmsw_r64m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLmsw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lmsw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Lmsw_r32m16 } else { Code::Lmsw_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoadall for CodeAssembler {
	#[inline]
	fn loadall(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Loadall386))
	}
}

#[rustfmt::skip]
impl CodeAsmLoadiwkey<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn loadiwkey(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Loadiwkey_xmm_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLodsb for CodeAssembler {
	#[inline]
	fn lodsb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_lodsb(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLodsd for CodeAssembler {
	#[inline]
	fn lodsd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_lodsd(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLodsq for CodeAssembler {
	#[inline]
	fn lodsq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_lodsq(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLodsw for CodeAssembler {
	#[inline]
	fn lodsw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_lodsw(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoop<CodeLabel> for CodeAssembler {
	fn loop_(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loop_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loop_rel8_32_ECX
		} else {
			Code::Loop_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoop<u64> for CodeAssembler {
	fn loop_(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loop_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loop_rel8_32_ECX
		} else {
			Code::Loop_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoope<CodeLabel> for CodeAssembler {
	fn loope(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loope_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loope_rel8_32_ECX
		} else {
			Code::Loope_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoope<u64> for CodeAssembler {
	fn loope(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loope_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loope_rel8_32_ECX
		} else {
			Code::Loope_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoopne<CodeLabel> for CodeAssembler {
	fn loopne(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loopne_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loopne_rel8_32_ECX
		} else {
			Code::Loopne_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoopne<u64> for CodeAssembler {
	fn loopne(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loopne_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loopne_rel8_32_ECX
		} else {
			Code::Loopne_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoopnz<CodeLabel> for CodeAssembler {
	fn loopnz(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loopne_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loopne_rel8_32_ECX
		} else {
			Code::Loopne_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoopnz<u64> for CodeAssembler {
	fn loopnz(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loopne_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loopne_rel8_32_ECX
		} else {
			Code::Loopne_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoopz<CodeLabel> for CodeAssembler {
	fn loopz(&mut self, op0: CodeLabel) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loope_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loope_rel8_32_ECX
		} else {
			Code::Loope_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0.id())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLoopz<u64> for CodeAssembler {
	fn loopz(&mut self, op0: u64) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Loope_rel8_64_RCX
		} else if self.bitness() >= 32 {
			Code::Loope_rel8_32_ECX
		} else {
			Code::Loope_rel8_16_CX
		};
		self.add_instr(Instruction::with_branch(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLsl<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn lsl(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lsl_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLsl<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn lsl(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lsl_r32_r32m16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLsl<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn lsl(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lsl_r64_r64m16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLsl<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lsl(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lsl_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLsl<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lsl(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lsl_r32_r32m16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLss<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lss(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lss_r16_m1616, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLss<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lss(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lss_r32_m1632, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLss<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lss(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lss_r64_m1664, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLtr<AsmRegister16> for CodeAssembler {
	#[inline]
	fn ltr(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ltr_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLtr<AsmRegister32> for CodeAssembler {
	#[inline]
	fn ltr(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ltr_r32m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLtr<AsmRegister64> for CodeAssembler {
	#[inline]
	fn ltr(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ltr_r64m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLtr<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ltr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Ltr_r32m16 } else { Code::Ltr_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister32, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r32_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister64, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister64, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r64_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister32, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r32_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister64, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r64_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister32, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r32_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister64, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister64, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r64_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister32, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r32_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpins<AsmRegister64, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn lwpins(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpins_r64_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister32, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r32_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister64, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister64, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r64_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister32, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r32_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister64, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r64_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister32, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r32_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister64, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister64, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r64_rm32_imm32, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister32, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r32_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLwpval<AsmRegister64, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn lwpval(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::XOP_Lwpval_r64_rm32_imm32, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmLzcnt<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn lzcnt(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lzcnt_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLzcnt<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn lzcnt(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lzcnt_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLzcnt<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn lzcnt(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lzcnt_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmLzcnt<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lzcnt(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lzcnt_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLzcnt<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lzcnt(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lzcnt_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmLzcnt<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn lzcnt(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Lzcnt_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaskmovdqu<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn maskmovdqu(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_maskmovdqu(self.bitness(), op0.register(), op1.register(), Register::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaskmovq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn maskmovq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_maskmovq(self.bitness(), op0.register(), op1.register(), Register::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn maxpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn maxpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn maxps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn maxps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn maxsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn maxsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn maxss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMaxss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn maxss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Maxss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMcommit for CodeAssembler {
	#[inline]
	fn mcommit(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Mcommit))
	}
}

#[rustfmt::skip]
impl CodeAsmMfence for CodeAssembler {
	#[inline]
	fn mfence(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Mfence))
	}
}

#[rustfmt::skip]
impl CodeAsmMinpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn minpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMinpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn minpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMinps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn minps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMinps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn minps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMinsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn minsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMinsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn minsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMinss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn minss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMinss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn minss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Minss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMonitor for CodeAssembler {
	fn monitor(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Monitorq
		} else if self.bitness() >= 32 {
			Code::Monitord
		} else {
			Code::Monitorw
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmMonitorx for CodeAssembler {
	fn monitorx(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Monitorxq
		} else if self.bitness() >= 32 {
			Code::Monitorxd
		} else {
			Code::Monitorxw
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmMontmul for CodeAssembler {
	fn montmul(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Montmul_64
		} else if self.bitness() >= 32 {
			Code::Montmul_32
		} else {
			Code::Montmul_16
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn mov(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op1.register() == Register::AL && self.bitness() == 64 && op0.is_displacement_only() {
			Code::Mov_moffs8_AL
		} else if op1.register() == Register::AL && self.bitness() < 64 && op0.is_displacement_only() {
			Code::Mov_moffs8_AL
		} else {
			Code::Mov_rm8_r8
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterSegment, AsmRegister16> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterSegment, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_Sreg_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	fn mov(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		let code = if op1.register() == Register::AX && self.bitness() == 64 && op0.is_displacement_only() {
			Code::Mov_moffs16_AX
		} else if op1.register() == Register::AX && self.bitness() < 64 && op0.is_displacement_only() {
			Code::Mov_moffs16_AX
		} else {
			Code::Mov_rm16_r16
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterSegment, AsmRegister32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterSegment, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_Sreg_r32m16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterCr, AsmRegister32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterCr, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_cr_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterDr, AsmRegister32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterDr, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_dr_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterTr, AsmRegister32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterTr, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_tr_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	fn mov(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		let code = if op1.register() == Register::EAX && self.bitness() == 64 && op0.is_displacement_only() {
			Code::Mov_moffs32_EAX
		} else if op1.register() == Register::EAX && self.bitness() < 64 && op0.is_displacement_only() {
			Code::Mov_moffs32_EAX
		} else {
			Code::Mov_rm32_r32
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterSegment, AsmRegister64> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterSegment, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_Sreg_r64m16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterCr, AsmRegister64> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterCr, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_cr_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterDr, AsmRegister64> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterDr, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_dr_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	fn mov(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		let code = if op1.register() == Register::RAX && self.bitness() == 64 && op0.is_displacement_only() {
			Code::Mov_moffs64_RAX
		} else if op1.register() == Register::RAX && self.bitness() < 64 && op0.is_displacement_only() {
			Code::Mov_moffs64_RAX
		} else {
			Code::Mov_rm64_r64
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister16, AsmRegisterSegment> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister16, op1: AsmRegisterSegment) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_rm16_Sreg, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, AsmRegisterSegment> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister32, op1: AsmRegisterSegment) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r32m16_Sreg, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister64, AsmRegisterSegment> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister64, op1: AsmRegisterSegment) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r64m16_Sreg, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmMemoryOperand, AsmRegisterSegment> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterSegment) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Mov_r32m16_Sreg } else { Code::Mov_rm16_Sreg };
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, AsmRegisterCr> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister32, op1: AsmRegisterCr) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r32_cr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister64, AsmRegisterCr> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister64, op1: AsmRegisterCr) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r64_cr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, AsmRegisterDr> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister32, op1: AsmRegisterDr) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r32_dr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister64, AsmRegisterDr> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister64, op1: AsmRegisterDr) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r64_dr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, AsmRegisterTr> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister32, op1: AsmRegisterTr) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r32_tr, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	fn mov(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL && self.bitness() == 64 && op1.is_displacement_only() {
			Code::Mov_AL_moffs8
		} else if op0.register() == Register::AL && self.bitness() < 64 && op1.is_displacement_only() {
			Code::Mov_AL_moffs8
		} else {
			Code::Mov_r8_rm8
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	fn mov(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX && self.bitness() == 64 && op1.is_displacement_only() {
			Code::Mov_AX_moffs16
		} else if op0.register() == Register::AX && self.bitness() < 64 && op1.is_displacement_only() {
			Code::Mov_AX_moffs16
		} else {
			Code::Mov_r16_rm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	fn mov(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX && self.bitness() == 64 && op1.is_displacement_only() {
			Code::Mov_EAX_moffs32
		} else if op0.register() == Register::EAX && self.bitness() < 64 && op1.is_displacement_only() {
			Code::Mov_EAX_moffs32
		} else {
			Code::Mov_r32_rm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	fn mov(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX && self.bitness() == 64 && op1.is_displacement_only() {
			Code::Mov_RAX_moffs64
		} else if op0.register() == Register::RAX && self.bitness() < 64 && op1.is_displacement_only() {
			Code::Mov_RAX_moffs64
		} else {
			Code::Mov_r64_rm64
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegisterSegment, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegisterSegment, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Mov_Sreg_r32m16 } else { Code::Mov_Sreg_rm16 };
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r8_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r16_imm16, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r32_imm32, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister64, i64> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister64, op1: i64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r64_imm64, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmMemoryOperand, i32> for CodeAssembler {
	fn mov(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Mov_rm64_imm32
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Mov_rm32_imm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Mov_rm16_imm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Mov_rm8_imm8
		} else {
			return Err(IcedError::new("mov: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r8_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r16_imm16, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r32_imm32, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmRegister64, u64> for CodeAssembler {
	#[inline]
	fn mov(&mut self, op0: AsmRegister64, op1: u64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mov_r64_imm64, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMov<AsmMemoryOperand, u32> for CodeAssembler {
	fn mov(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Mov_rm32_imm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Mov_rm16_imm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Mov_rm8_imm8
		} else {
			return Err(IcedError::new("mov: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovapd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movapd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movapd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovapd<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movapd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movapd_xmmm128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovapd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movapd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movapd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovaps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movaps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movaps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovaps<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movaps(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movaps_xmmm128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovaps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movaps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movaps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovbe<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movbe(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movbe_m16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovbe<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn movbe(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movbe_m32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovbe<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn movbe(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movbe_m64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovbe<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movbe(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movbe_r16_m16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovbe<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movbe(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movbe_r32_m32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovbe<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movbe(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movbe_r64_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmRegisterMm, AsmRegister32> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmRegisterMm, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_mm_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmRegisterXmm, AsmRegister32> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_xmm_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmRegister32, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmRegister32, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_rm32_mm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmMemoryOperand, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_rm32_mm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_rm32_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_rm32_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_mm_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movd_xmm_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovddup<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movddup(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movddup_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovddup<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movddup(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movddup_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdir64b<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movdir64b(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdir64b_r16_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdir64b<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movdir64b(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdir64b_r32_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdir64b<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movdir64b(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdir64b_r64_m512, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdiri<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn movdiri(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdiri_m32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdiri<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn movdiri(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdiri_m64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdq2q<AsmRegisterMm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movdq2q(&mut self, op0: AsmRegisterMm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdq2q_mm_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdqa<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movdqa(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdqa_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdqa<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movdqa(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdqa_xmmm128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdqa<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movdqa(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdqa_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdqu<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movdqu(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdqu_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdqu<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movdqu(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdqu_xmmm128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovdqu<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movdqu(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movdqu_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovhlps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movhlps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movhlps_xmm_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovhpd<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movhpd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movhpd_m64_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovhpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movhpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movhpd_xmm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovhps<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movhps(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movhps_m64_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovhps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movhps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movhps_xmm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovlhps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movlhps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movlhps_xmm_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovlpd<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movlpd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movlpd_m64_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovlpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movlpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movlpd_xmm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovlps<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movlps(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movlps_m64_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovlps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movlps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movlps_xmm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovmskpd<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movmskpd(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movmskpd_r32_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovmskpd<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movmskpd(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movmskpd_r64_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovmskps<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movmskps(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movmskps_r32_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovmskps<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movmskps(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movmskps_r64_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovntdq<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movntdq(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movntdq_m128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovntdqa<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movntdqa(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movntdqa_xmm_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovnti<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn movnti(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movnti_m32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovnti<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn movnti(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movnti_m64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovntpd<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movntpd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movntpd_m128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovntps<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movntps(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movntps_m128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovntq<AsmMemoryOperand, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn movntq(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movntq_m64_mm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovntsd<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movntsd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movntsd_m64_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovntss<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movntss(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movntss_m32_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegisterMm, AsmRegister64> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegisterMm, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_mm_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegisterXmm, AsmRegister64> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_xmm_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegister64, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegister64, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_rm64_mm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmMemoryOperand, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_mmm64_mm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_rm64_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_xmmm64_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovq2dq<AsmRegisterXmm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn movq2dq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movq2dq_xmm_mm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsb for CodeAssembler {
	#[inline]
	fn movsb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_movsb(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsd for CodeAssembler {
	#[inline]
	fn movsd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_movsd(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsd2<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movsd_2(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsd2<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movsd_2(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsd_xmmm64_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsd2<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movsd_2(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovshdup<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movshdup(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movshdup_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovshdup<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movshdup(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movshdup_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsldup<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movsldup(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsldup_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsldup<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movsldup(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsldup_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsq for CodeAssembler {
	#[inline]
	fn movsq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_movsq(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovss<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movss(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movss_xmmm32_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsw for CodeAssembler {
	#[inline]
	fn movsw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_movsw(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn movsx(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsx_r16_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn movsx(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsx_r32_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn movsx(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsx_r64_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movsx(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsx_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister32, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movsx(&mut self, op0: AsmRegister32, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsx_r32_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister64, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movsx(&mut self, op0: AsmRegister64, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsx_r64_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	fn movsx(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Word {
			Code::Movsx_r16_rm16
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Movsx_r16_rm8
		} else {
			return Err(IcedError::new("movsx: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	fn movsx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Word {
			Code::Movsx_r32_rm16
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Movsx_r32_rm8
		} else {
			return Err(IcedError::new("movsx: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsx<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	fn movsx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Word {
			Code::Movsx_r64_rm16
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Movsx_r64_rm8
		} else {
			return Err(IcedError::new("movsx: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsxd<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movsxd(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsxd_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsxd<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn movsxd(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsxd_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsxd<AsmRegister64, AsmRegister32> for CodeAssembler {
	#[inline]
	fn movsxd(&mut self, op0: AsmRegister64, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsxd_r64_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsxd<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movsxd(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsxd_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsxd<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movsxd(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsxd_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovsxd<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movsxd(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movsxd_r64_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovupd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movupd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movupd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovupd<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movupd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movupd_xmmm128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovupd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movupd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movupd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovups<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movups(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movups_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovups<AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn movups(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movups_xmmm128_xmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovups<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn movups(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movups_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn movzx(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movzx_r16_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn movzx(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movzx_r32_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn movzx(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movzx_r64_rm8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movzx(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movzx_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister32, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movzx(&mut self, op0: AsmRegister32, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movzx_r32_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister64, AsmRegister16> for CodeAssembler {
	#[inline]
	fn movzx(&mut self, op0: AsmRegister64, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Movzx_r64_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	fn movzx(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Word {
			Code::Movzx_r16_rm16
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Movzx_r16_rm8
		} else {
			return Err(IcedError::new("movzx: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	fn movzx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Word {
			Code::Movzx_r32_rm16
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Movzx_r32_rm8
		} else {
			return Err(IcedError::new("movzx: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMovzx<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	fn movzx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op1.size() == MemoryOperandSize::Word {
			Code::Movzx_r64_rm16
		} else if op1.size() == MemoryOperandSize::Byte {
			Code::Movzx_r64_rm8
		} else {
			return Err(IcedError::new("movzx: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMpsadbw<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn mpsadbw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Mpsadbw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMpsadbw<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn mpsadbw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Mpsadbw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMpsadbw<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn mpsadbw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Mpsadbw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMpsadbw<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn mpsadbw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Mpsadbw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmMul<AsmRegister8> for CodeAssembler {
	#[inline]
	fn mul(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Mul_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMul<AsmRegister16> for CodeAssembler {
	#[inline]
	fn mul(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Mul_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMul<AsmRegister32> for CodeAssembler {
	#[inline]
	fn mul(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Mul_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMul<AsmRegister64> for CodeAssembler {
	#[inline]
	fn mul(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Mul_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMul<AsmMemoryOperand> for CodeAssembler {
	fn mul(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Mul_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Mul_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Mul_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Mul_rm8
		} else {
			return Err(IcedError::new("mul: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn mulpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn mulpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn mulps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn mulps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn mulsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn mulsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn mulss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn mulss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Mulss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulx<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn mulx(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Mulx_r32_r32_rm32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulx<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn mulx(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Mulx_r64_r64_rm64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulx<AsmRegister32, AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn mulx(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Mulx_r32_r32_rm32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMulx<AsmRegister64, AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn mulx(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Mulx_r64_r64_rm64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmMwait for CodeAssembler {
	#[inline]
	fn mwait(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Mwait))
	}
}

#[rustfmt::skip]
impl CodeAsmMwaitx for CodeAssembler {
	#[inline]
	fn mwaitx(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Mwaitx))
	}
}

#[rustfmt::skip]
impl CodeAsmNeg<AsmRegister8> for CodeAssembler {
	#[inline]
	fn neg(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Neg_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNeg<AsmRegister16> for CodeAssembler {
	#[inline]
	fn neg(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Neg_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNeg<AsmRegister32> for CodeAssembler {
	#[inline]
	fn neg(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Neg_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNeg<AsmRegister64> for CodeAssembler {
	#[inline]
	fn neg(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Neg_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNeg<AsmMemoryOperand> for CodeAssembler {
	fn neg(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Neg_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Neg_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Neg_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Neg_rm8
		} else {
			return Err(IcedError::new("neg: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmNop for CodeAssembler {
	#[inline]
	fn nop(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Nopd } else { Code::Nopw };
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmNop1<AsmRegister16> for CodeAssembler {
	#[inline]
	fn nop_1(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Nop_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNop1<AsmRegister32> for CodeAssembler {
	#[inline]
	fn nop_1(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Nop_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNop1<AsmRegister64> for CodeAssembler {
	#[inline]
	fn nop_1(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Nop_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNop1<AsmMemoryOperand> for CodeAssembler {
	fn nop_1(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Nop_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Nop_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Nop_rm16
		} else {
			return Err(IcedError::new("nop: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmNot<AsmRegister8> for CodeAssembler {
	#[inline]
	fn not(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Not_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNot<AsmRegister16> for CodeAssembler {
	#[inline]
	fn not(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Not_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNot<AsmRegister32> for CodeAssembler {
	#[inline]
	fn not(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Not_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNot<AsmRegister64> for CodeAssembler {
	#[inline]
	fn not(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Not_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmNot<AsmMemoryOperand> for CodeAssembler {
	fn not(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Not_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Not_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Not_rm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Not_rm8
		} else {
			return Err(IcedError::new("not: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Or_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Or_AL_imm8 } else { Code::Or_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister16, i32> for CodeAssembler {
	fn or(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Or_AX_imm16
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Or_rm16_imm8
		} else {
			Code::Or_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister32, i32> for CodeAssembler {
	fn or(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Or_EAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Or_rm32_imm8
		} else {
			Code::Or_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister64, i32> for CodeAssembler {
	fn or(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX {
			Code::Or_RAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Or_rm64_imm8
		} else {
			Code::Or_rm64_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmMemoryOperand, i32> for CodeAssembler {
	fn or(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Or_rm64_imm8 } else { Code::Or_rm64_imm32 }
		} else if op0.size() == MemoryOperandSize::Dword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Or_rm32_imm8 } else { Code::Or_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Or_rm16_imm8 } else { Code::Or_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Or_rm8_imm8
		} else {
			return Err(IcedError::new("or: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn or(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Or_AL_imm8 } else { Code::Or_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister16, u32> for CodeAssembler {
	fn or(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Or_AX_imm16
		} else if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) {
			Code::Or_rm16_imm8
		} else {
			Code::Or_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmRegister32, u32> for CodeAssembler {
	fn or(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Or_EAX_imm32
		} else if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 {
			Code::Or_rm32_imm8
		} else {
			Code::Or_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOr<AsmMemoryOperand, u32> for CodeAssembler {
	fn or(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 { Code::Or_rm32_imm8 } else { Code::Or_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) { Code::Or_rm16_imm8 } else { Code::Or_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Or_rm8_imm8
		} else {
			return Err(IcedError::new("or: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOrpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn orpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Orpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOrpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn orpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Orpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmOrps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn orps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Orps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOrps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn orps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Orps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_DX_AL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<i32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: i32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_imm8_AL, op0, op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<u32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: u32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_imm8_AL, op0, op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_DX_AX, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<i32, AsmRegister16> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: i32, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_imm8_AX, op0, op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<u32, AsmRegister16> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: u32, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_imm8_AX, op0, op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<AsmRegister16, AsmRegister32> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: AsmRegister16, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_DX_EAX, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<i32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: i32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_imm8_EAX, op0, op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOut<u32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn out(&mut self, op0: u32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Out_imm8_EAX, op0, op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmOutsb for CodeAssembler {
	#[inline]
	fn outsb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_outsb(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOutsd for CodeAssembler {
	#[inline]
	fn outsd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_outsd(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmOutsw for CodeAssembler {
	#[inline]
	fn outsw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_outsw(self.bitness(), Register::None, RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pabsb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pabsb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pabsb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pabsb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pabsd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pabsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pabsd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pabsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pabsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pabsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pabsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPabsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pabsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pabsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackssdw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn packssdw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packssdw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackssdw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn packssdw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packssdw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackssdw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn packssdw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packssdw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackssdw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn packssdw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packssdw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPacksswb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn packsswb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packsswb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPacksswb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn packsswb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packsswb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPacksswb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn packsswb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packsswb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPacksswb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn packsswb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packsswb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackusdw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn packusdw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packusdw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackusdw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn packusdw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packusdw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackuswb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn packuswb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packuswb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackuswb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn packuswb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packuswb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackuswb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn packuswb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packuswb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPackuswb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn packuswb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Packuswb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddsb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddsb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddsb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddsb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsiw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddsiw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsiw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsiw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddsiw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsiw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddusb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddusb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddusb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddusb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddusw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddusw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddusw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddusw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddusw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddusw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paddw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn paddw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaddw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paddw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paddw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterMm, AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_mm_mmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterMm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_mm_mmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterMm, AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_mm_mmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterMm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_mm_mmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPalignr<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn palignr(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Palignr_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPand<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pand(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pand_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPand<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pand(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pand_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPand<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pand(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pand_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPand<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pand(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pand_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPandn<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pandn(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pandn_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPandn<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pandn(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pandn_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPandn<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pandn(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pandn_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPandn<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pandn(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pandn_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPause for CodeAssembler {
	#[inline]
	fn pause(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pause))
	}
}

#[rustfmt::skip]
impl CodeAsmPaveb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn paveb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paveb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPaveb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn paveb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Paveb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pavgb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pavgb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pavgb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pavgb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgusb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pavgusb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pavgusb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgusb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pavgusb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pavgusb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pavgw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pavgw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pavgw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPavgw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pavgw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pavgw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPblendvb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pblendvb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pblendvb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPblendvb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pblendvb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pblendvb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPblendw<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pblendw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pblendw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPblendw<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pblendw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pblendw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPblendw<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pblendw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pblendw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPblendw<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pblendw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pblendw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulhqhqdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pclmulhqhqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmRegisterXmm, i32>>::pclmulqdq(self, op0, op1, 17)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulhqhqdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pclmulhqhqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmMemoryOperand, i32>>::pclmulqdq(self, op0, op1, 17)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulhqlqdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pclmulhqlqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmRegisterXmm, i32>>::pclmulqdq(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulhqlqdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pclmulhqlqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmMemoryOperand, i32>>::pclmulqdq(self, op0, op1, 1)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmullqhqdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pclmullqhqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmRegisterXmm, i32>>::pclmulqdq(self, op0, op1, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmullqhqdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pclmullqhqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmMemoryOperand, i32>>::pclmulqdq(self, op0, op1, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmullqlqdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pclmullqlqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmRegisterXmm, i32>>::pclmulqdq(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmullqlqdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pclmullqlqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmPclmulqdq<AsmRegisterXmm, AsmMemoryOperand, i32>>::pclmulqdq(self, op0, op1, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulqdq<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pclmulqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pclmulqdq_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulqdq<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pclmulqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pclmulqdq_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulqdq<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pclmulqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pclmulqdq_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPclmulqdq<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pclmulqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pclmulqdq_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pcmpeqb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpeqb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpeqb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpeqb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pcmpeqd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpeqd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpeqd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpeqd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpeqq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpeqq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pcmpeqw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpeqw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpeqw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpeqw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpeqw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpeqw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pcmpestri(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pcmpestri(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pcmpestri(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pcmpestri(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri64<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pcmpestri64(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri64_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri64<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pcmpestri64(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri64_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri64<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pcmpestri64(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri64_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestri64<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pcmpestri64(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestri64_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pcmpestrm(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pcmpestrm(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pcmpestrm(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pcmpestrm(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm64<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pcmpestrm64(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm64_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm64<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pcmpestrm64(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm64_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm64<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pcmpestrm64(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm64_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpestrm64<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pcmpestrm64(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpestrm64_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pcmpgtb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpgtb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpgtb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpgtb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pcmpgtd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpgtd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpgtd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpgtd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpgtq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpgtq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pcmpgtw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pcmpgtw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpgtw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpgtw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pcmpgtw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pcmpgtw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistri<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pcmpistri(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistri_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistri<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pcmpistri(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistri_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistri<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pcmpistri(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistri_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistri<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pcmpistri(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistri_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistrm<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pcmpistrm(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistrm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistrm<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pcmpistrm(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistrm_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistrm<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pcmpistrm(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistrm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcmpistrm<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pcmpistrm(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pcmpistrm_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPcommit for CodeAssembler {
	#[inline]
	fn pcommit(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pcommit))
	}
}

#[rustfmt::skip]
impl CodeAsmPconfig for CodeAssembler {
	#[inline]
	fn pconfig(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pconfig))
	}
}

#[rustfmt::skip]
impl CodeAsmPdep<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn pdep(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pdep_r32_r32_rm32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPdep<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn pdep(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pdep_r64_r64_rm64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPdep<AsmRegister32, AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pdep(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pdep_r32_r32_rm32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPdep<AsmRegister64, AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pdep(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pdep_r64_r64_rm64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPdistib<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pdistib(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pdistib_mm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPext<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn pext(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pext_r32_r32_rm32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPext<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn pext(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pext_r64_r64_rm64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPext<AsmRegister32, AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pext(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pext_r32_r32_rm32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPext<AsmRegister64, AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pext(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Pext_r64_r64_rm64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrb<AsmRegister32, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrb(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrb_r32m8_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrb<AsmRegister64, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrb(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrb_r64m8_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrb<AsmMemoryOperand, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrb(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrb_r32m8_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrb<AsmRegister32, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrb(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrb_r32m8_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrb<AsmRegister64, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrb(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrb_r64m8_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrb<AsmMemoryOperand, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrb(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrb_r32m8_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrd<AsmRegister32, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrd(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrd_rm32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrd<AsmMemoryOperand, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrd_rm32_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrd<AsmRegister32, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrd(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrd_rm32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrd<AsmMemoryOperand, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrd_rm32_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrq<AsmRegister64, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrq(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrq_rm64_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrq<AsmMemoryOperand, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrq(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrq_rm64_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrq<AsmRegister64, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrq(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrq_rm64_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrq<AsmMemoryOperand, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrq(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrq_rm64_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister32, AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister32, op1: AsmRegisterMm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r32_mm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister64, AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister64, op1: AsmRegisterMm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r64_mm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister32, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister64, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r64_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmMemoryOperand, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r32m16_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister32, AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister32, op1: AsmRegisterMm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r32_mm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister64, AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister64, op1: AsmRegisterMm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r64_mm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister32, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r32_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmRegister64, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r64_xmm_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPextrw<AsmMemoryOperand, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pextrw(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pextrw_r32m16_xmm_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPf2id<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pf2id(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pf2id_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPf2id<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pf2id(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pf2id_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPf2iw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pf2iw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pf2iw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPf2iw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pf2iw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pf2iw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfacc<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfacc(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfacc_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfacc<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfacc(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfacc_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfadd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfadd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfadd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfadd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfadd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfadd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfcmpeq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfcmpeq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfcmpeq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfcmpeq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfcmpeq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfcmpeq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfcmpge<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfcmpge(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfcmpge_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfcmpge<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfcmpge(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfcmpge_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfcmpgt<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfcmpgt(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfcmpgt_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfcmpgt<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfcmpgt(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfcmpgt_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfmax<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfmax(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfmax_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfmax<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfmax(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfmax_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfmin<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfmin(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfmin_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfmin<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfmin(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfmin_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfmul<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfmul(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfmul_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfmul<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfmul(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfmul_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfnacc<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfnacc(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfnacc_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfnacc<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfnacc(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfnacc_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfpnacc<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfpnacc(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfpnacc_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfpnacc<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfpnacc(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfpnacc_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcp<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfrcp(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcp_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcp<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfrcp(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcp_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcpit1<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfrcpit1(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcpit1_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcpit1<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfrcpit1(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcpit1_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcpit2<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfrcpit2(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcpit2_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcpit2<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfrcpit2(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcpit2_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcpv<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfrcpv(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcpv_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrcpv<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfrcpv(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrcpv_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrsqit1<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfrsqit1(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrsqit1_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrsqit1<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfrsqit1(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrsqit1_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrsqrt<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfrsqrt(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrsqrt_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrsqrt<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfrsqrt(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrsqrt_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrsqrtv<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfrsqrtv(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrsqrtv_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfrsqrtv<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfrsqrtv(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfrsqrtv_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfsub<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfsub(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfsub_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfsub<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfsub(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfsub_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfsubr<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pfsubr(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfsubr_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPfsubr<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pfsubr(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pfsubr_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn phaddd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn phaddd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phaddd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phaddd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn phaddsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn phaddsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phaddsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phaddsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn phaddw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn phaddw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phaddw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhaddw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phaddw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phaddw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhminposuw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn phminposuw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phminposuw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhminposuw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phminposuw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phminposuw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn phsubd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn phsubd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phsubd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phsubd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn phsubsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn phsubsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phsubsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phsubsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn phsubw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn phsubw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phsubw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPhsubw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn phsubw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Phsubw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPi2fd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pi2fd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pi2fd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPi2fd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pi2fd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pi2fd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPi2fw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pi2fw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pi2fw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPi2fw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pi2fw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pi2fw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrb<AsmRegisterXmm, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn pinsrb(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrb_xmm_r32m8_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrb<AsmRegisterXmm, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn pinsrb(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrb_xmm_r64m8_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrb<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pinsrb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrb_xmm_r32m8_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrb<AsmRegisterXmm, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn pinsrb(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrb_xmm_r32m8_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrb<AsmRegisterXmm, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn pinsrb(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrb_xmm_r64m8_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrb<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pinsrb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrb_xmm_r32m8_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrd<AsmRegisterXmm, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn pinsrd(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrd_xmm_rm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pinsrd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrd_xmm_rm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrd<AsmRegisterXmm, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn pinsrd(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrd_xmm_rm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pinsrd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrd_xmm_rm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrq<AsmRegisterXmm, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn pinsrq(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrq_xmm_rm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrq<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pinsrq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrq_xmm_rm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrq<AsmRegisterXmm, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn pinsrq(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrq_xmm_rm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrq<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pinsrq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrq_xmm_rm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterMm, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterMm, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_mm_r32m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterXmm, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_xmm_r32m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterMm, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterMm, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_mm_r64m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterXmm, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_xmm_r64m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterMm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_mm_r32m16_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_xmm_r32m16_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterMm, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterMm, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_mm_r32m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterXmm, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterXmm, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_xmm_r32m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterMm, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterMm, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_mm_r64m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterXmm, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterXmm, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_xmm_r64m16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterMm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_mm_r32m16_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPinsrw<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pinsrw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pinsrw_xmm_r32m16_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmachriw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmachriw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmachriw_mm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddubsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmaddubsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddubsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddubsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaddubsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddubsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddubsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaddubsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddubsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddubsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaddubsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddubsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddwd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmaddwd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddwd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddwd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaddwd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddwd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddwd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaddwd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddwd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaddwd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaddwd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaddwd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmagw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmagw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmagw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmagw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmagw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmagw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaxsb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxsb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaxsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmaxsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaxsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxub<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmaxub(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxub_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxub<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaxub(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxub_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxub<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxub(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxub_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxub<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxub(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxub_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxud<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaxud(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxud_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxud<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxud(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxud_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxuw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmaxuw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxuw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmaxuw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmaxuw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmaxuw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pminsb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminsb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pminsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pminsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pminsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminub<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pminub(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminub_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminub<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pminub(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminub_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminub<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminub(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminub_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminub<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminub(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminub_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminud<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pminud(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminud_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminud<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminud(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminud_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminuw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pminuw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminuw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPminuw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pminuw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pminuw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovmskb<AsmRegister32, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmovmskb(&mut self, op0: AsmRegister32, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovmskb_r32_mm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovmskb<AsmRegister64, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmovmskb(&mut self, op0: AsmRegister64, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovmskb_r64_mm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovmskb<AsmRegister32, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovmskb(&mut self, op0: AsmRegister32, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovmskb_r32_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovmskb<AsmRegister64, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovmskb(&mut self, op0: AsmRegister64, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovmskb_r64_xmm, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxbd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovsxbd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxbd_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxbd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovsxbd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxbd_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxbq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovsxbq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxbq_xmm_xmmm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxbq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovsxbq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxbq_xmm_xmmm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxbw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovsxbw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxbw_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxbw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovsxbw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxbw_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovsxdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxdq_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovsxdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxdq_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxwd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovsxwd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxwd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxwd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovsxwd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxwd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxwq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovsxwq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxwq_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovsxwq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovsxwq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovsxwq_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxbd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovzxbd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxbd_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxbd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovzxbd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxbd_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxbq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovzxbq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxbq_xmm_xmmm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxbq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovzxbq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxbq_xmm_xmmm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxbw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovzxbw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxbw_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxbw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovzxbw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxbw_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovzxdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxdq_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovzxdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxdq_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxwd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovzxwd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxwd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxwd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovzxwd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxwd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxwq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmovzxwq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxwq_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmovzxwq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmovzxwq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmovzxwq_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmuldq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmuldq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmuldq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmuldq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmuldq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmuldq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhriw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmulhriw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhriw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhriw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhriw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhriw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmulhrsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhrsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmulhrsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhrsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhrsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhrsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhrsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhrsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmulhrw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pmulhrw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhrw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pmulhrw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrw_cyrix<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmulhrw_cyrix(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhrw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhrw_cyrix<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhrw_cyrix(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhrw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhuw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmulhuw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhuw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhuw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmulhuw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhuw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhuw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhuw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhuw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhuw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhuw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhuw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmulhw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmulhw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulhw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulhw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulhw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulld<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmulld(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulld_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmulld<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmulld(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmulld_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmullw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmullw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmullw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmullw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmullw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmullw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmullw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmullw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmullw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmullw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmullw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmullw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmuludq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pmuludq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmuludq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmuludq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pmuludq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmuludq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmuludq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmuludq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmuludq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmuludq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmuludq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmuludq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmvgezb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmvgezb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmvgezb_mm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmvlzb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmvlzb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmvlzb_mm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmvnzb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmvnzb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmvnzb_mm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPmvzb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pmvzb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pmvzb_mm_m64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPop<AsmRegister16> for CodeAssembler {
	#[inline]
	fn pop(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Pop_r16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPop<AsmRegister32> for CodeAssembler {
	#[inline]
	fn pop(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Pop_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPop<AsmRegister64> for CodeAssembler {
	#[inline]
	fn pop(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Pop_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPop<AsmRegisterSegment> for CodeAssembler {
	fn pop(&mut self, op0: AsmRegisterSegment) -> Result<(), IcedError> {
		let code = if op0.register() == Register::FS {
			if self.bitness() == 64 {
				Code::Popq_FS
			} else if self.bitness() >= 32 {
				Code::Popd_FS
			} else {
				Code::Popw_FS
			}
		} else if op0.register() == Register::GS {
			if self.bitness() == 64 {
				Code::Popq_GS
			} else if self.bitness() >= 32 {
				Code::Popd_GS
			} else {
				Code::Popw_GS
			}
		} else if op0.register() == Register::ES {
			if self.bitness() >= 32 { Code::Popd_ES } else { Code::Popw_ES }
		} else if op0.register() == Register::SS {
			if self.bitness() >= 32 { Code::Popd_SS } else { Code::Popw_SS }
		} else if op0.register() == Register::DS {
			if self.bitness() >= 32 { Code::Popd_DS } else { Code::Popw_DS }
		} else {
			return Err(IcedError::new("pop: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPop<AsmMemoryOperand> for CodeAssembler {
	fn pop(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Pop_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Pop_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Pop_rm16
		} else {
			return Err(IcedError::new("pop: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPopa for CodeAssembler {
	#[inline]
	fn popa(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Popaw))
	}
}

#[rustfmt::skip]
impl CodeAsmPopad for CodeAssembler {
	#[inline]
	fn popad(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Popad))
	}
}

#[rustfmt::skip]
impl CodeAsmPopcnt<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn popcnt(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Popcnt_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPopcnt<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn popcnt(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Popcnt_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPopcnt<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn popcnt(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Popcnt_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPopcnt<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn popcnt(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Popcnt_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPopcnt<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn popcnt(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Popcnt_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPopcnt<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn popcnt(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Popcnt_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPopf for CodeAssembler {
	#[inline]
	fn popf(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Popfw))
	}
}

#[rustfmt::skip]
impl CodeAsmPopfd for CodeAssembler {
	#[inline]
	fn popfd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Popfd))
	}
}

#[rustfmt::skip]
impl CodeAsmPopfq for CodeAssembler {
	#[inline]
	fn popfq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Popfq))
	}
}

#[rustfmt::skip]
impl CodeAsmPor<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn por(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Por_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPor<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn por(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Por_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPor<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn por(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Por_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPor<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn por(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Por_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPrefetch<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn prefetch(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Prefetch_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPrefetchnta<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn prefetchnta(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Prefetchnta_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPrefetcht0<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn prefetcht0(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Prefetcht0_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPrefetcht1<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn prefetcht1(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Prefetcht1_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPrefetcht2<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn prefetcht2(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Prefetcht2_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPrefetchw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn prefetchw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Prefetchw_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPrefetchwt1<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn prefetchwt1(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Prefetchwt1_m8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsadbw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psadbw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psadbw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsadbw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psadbw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psadbw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsadbw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psadbw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psadbw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsadbw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psadbw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psadbw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pshufb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pshufb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pshufb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pshufb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pshufb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pshufb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pshufb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pshufb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufd<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pshufd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pshufd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufd<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pshufd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pshufd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufhw<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pshufhw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufhw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufhw<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pshufhw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufhw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufhw<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pshufhw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufhw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufhw<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pshufhw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufhw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshuflw<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pshuflw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshuflw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshuflw<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pshuflw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshuflw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshuflw<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pshuflw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshuflw_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshuflw<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pshuflw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshuflw_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufw<AsmRegisterMm, AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn pshufw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufw_mm_mmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufw<AsmRegisterMm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn pshufw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufw_mm_mmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufw<AsmRegisterMm, AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn pshufw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufw_mm_mmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPshufw<AsmRegisterMm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn pshufw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Pshufw_mm_mmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psignb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psignb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psignb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psignb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psignd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psignd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psignd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psignd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psignw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psignw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psignw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsignw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psignw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psignw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslld<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pslld(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslld_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslldq<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn pslldq(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslldq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPslldq<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn pslldq(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pslldq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllq<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psllq(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsllw<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psllw(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psllw_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsmash for CodeAssembler {
	#[inline]
	fn psmash(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Psmash))
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrad<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psrad(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrad_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsraw<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psraw(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psraw_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrld<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psrld(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrld_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrldq<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psrldq(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrldq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrldq<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psrldq(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrldq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlq<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psrlq(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlq_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterMm, i32> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterMm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterXmm, op1: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterMm, u32> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterMm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_mm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsrlw<AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn psrlw(&mut self, op0: AsmRegisterXmm, op1: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psrlw_xmm_imm8, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubsb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubsb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubsb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubsb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsiw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubsiw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsiw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsiw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubsiw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsiw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubsw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubsw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubsw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubsw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubsw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubsw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusb<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubusb(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusb_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusb<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubusb(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusb_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusb<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubusb(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusb_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusb<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubusb(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusb_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubusw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubusw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubusw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubusw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubusw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubusw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn psubw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn psubw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPsubw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn psubw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Psubw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPswapd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pswapd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pswapd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPswapd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pswapd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::D3NOW_Pswapd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPtest<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn ptest(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ptest_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPtest<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ptest(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ptest_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPtwrite<AsmRegister32> for CodeAssembler {
	#[inline]
	fn ptwrite(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ptwrite_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPtwrite<AsmRegister64> for CodeAssembler {
	#[inline]
	fn ptwrite(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Ptwrite_rm64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPtwrite<AsmMemoryOperand> for CodeAssembler {
	fn ptwrite(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Ptwrite_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Ptwrite_rm32
		} else {
			return Err(IcedError::new("ptwrite: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhbw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn punpckhbw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhbw_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhbw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpckhbw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhbw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhbw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckhbw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhbw_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhbw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckhbw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhbw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhdq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn punpckhdq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhdq_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpckhdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhdq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhdq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckhdq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhdq_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckhdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhdq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhqdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpckhqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhqdq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhqdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckhqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhqdq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhwd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn punpckhwd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhwd_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhwd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpckhwd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhwd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhwd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckhwd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhwd_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckhwd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckhwd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckhwd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklbw<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn punpcklbw(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklbw_mm_mmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklbw<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpcklbw(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklbw_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklbw<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpcklbw(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklbw_mm_mmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklbw<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpcklbw(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklbw_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckldq<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn punpckldq(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckldq_mm_mmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckldq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpckldq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckldq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckldq<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckldq(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckldq_mm_mmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpckldq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpckldq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpckldq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklqdq<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpcklqdq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklqdq_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklqdq<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpcklqdq(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklqdq_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklwd<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn punpcklwd(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklwd_mm_mmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklwd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn punpcklwd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklwd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklwd<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpcklwd(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklwd_mm_mmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPunpcklwd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn punpcklwd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Punpcklwd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPush<AsmRegister16> for CodeAssembler {
	#[inline]
	fn push(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Push_r16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPush<AsmRegister32> for CodeAssembler {
	#[inline]
	fn push(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Push_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPush<AsmRegister64> for CodeAssembler {
	#[inline]
	fn push(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Push_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPush<AsmRegisterSegment> for CodeAssembler {
	fn push(&mut self, op0: AsmRegisterSegment) -> Result<(), IcedError> {
		let code = if op0.register() == Register::FS {
			if self.bitness() == 64 {
				Code::Pushq_FS
			} else if self.bitness() >= 32 {
				Code::Pushd_FS
			} else {
				Code::Pushw_FS
			}
		} else if op0.register() == Register::GS {
			if self.bitness() == 64 {
				Code::Pushq_GS
			} else if self.bitness() >= 32 {
				Code::Pushd_GS
			} else {
				Code::Pushw_GS
			}
		} else if op0.register() == Register::ES {
			if self.bitness() >= 32 { Code::Pushd_ES } else { Code::Pushw_ES }
		} else if op0.register() == Register::CS {
			if self.bitness() >= 32 { Code::Pushd_CS } else { Code::Pushw_CS }
		} else if op0.register() == Register::SS {
			if self.bitness() >= 32 { Code::Pushd_SS } else { Code::Pushw_SS }
		} else if op0.register() == Register::DS {
			if self.bitness() >= 32 { Code::Pushd_DS } else { Code::Pushw_DS }
		} else {
			return Err(IcedError::new("push: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPush<AsmMemoryOperand> for CodeAssembler {
	fn push(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Push_rm64
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Push_rm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Push_rm16
		} else {
			return Err(IcedError::new("push: invalid operands"));
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPush<i32> for CodeAssembler {
	fn push(&mut self, op0: i32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			if op0 >= i8::MIN as i32 && op0 <= i8::MAX as i32 { Code::Pushq_imm8 } else { Code::Pushq_imm32 }
		} else if self.bitness() >= 32 {
			if op0 >= i8::MIN as i32 && op0 <= i8::MAX as i32 { Code::Pushd_imm8 } else { Code::Pushd_imm32 }
		} else if op0 >= i8::MIN as i32 && op0 <= i8::MAX as i32 {
			Code::Pushw_imm8
		} else {
			Code::Push_imm16
		};
		self.add_instr(Instruction::with1(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPush<u32> for CodeAssembler {
	fn push(&mut self, op0: u32) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 {
			if op0 <= i8::MAX as u32 || 0xFFFF_FF80 <= op0 { Code::Pushd_imm8 } else { Code::Pushd_imm32 }
		} else if op0 <= i8::MAX as u32 || (0xFF80 <= op0 && op0 <= 0xFFFF) {
			Code::Pushw_imm8
		} else {
			Code::Push_imm16
		};
		self.add_instr(Instruction::with1(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmPusha for CodeAssembler {
	#[inline]
	fn pusha(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pushaw))
	}
}

#[rustfmt::skip]
impl CodeAsmPushad for CodeAssembler {
	#[inline]
	fn pushad(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pushad))
	}
}

#[rustfmt::skip]
impl CodeAsmPushf for CodeAssembler {
	#[inline]
	fn pushf(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pushfw))
	}
}

#[rustfmt::skip]
impl CodeAsmPushfd for CodeAssembler {
	#[inline]
	fn pushfd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pushfd))
	}
}

#[rustfmt::skip]
impl CodeAsmPushfq for CodeAssembler {
	#[inline]
	fn pushfq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Pushfq))
	}
}

#[rustfmt::skip]
impl CodeAsmPvalidate for CodeAssembler {
	fn pvalidate(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Pvalidateq
		} else if self.bitness() >= 32 {
			Code::Pvalidated
		} else {
			Code::Pvalidatew
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmPxor<AsmRegisterMm, AsmRegisterMm> for CodeAssembler {
	#[inline]
	fn pxor(&mut self, op0: AsmRegisterMm, op1: AsmRegisterMm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pxor_mm_mmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPxor<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn pxor(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pxor_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmPxor<AsmRegisterMm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pxor(&mut self, op0: AsmRegisterMm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pxor_mm_mmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmPxor<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn pxor(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Pxor_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcl_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcl_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcl_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcl_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn rcl(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Rcl_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rcl_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rcl_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rcl_rm8_CL
		} else {
			return Err(IcedError::new("rcl: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm8_1 } else { Code::Rcl_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm16_1 } else { Code::Rcl_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm32_1 } else { Code::Rcl_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm64_1 } else { Code::Rcl_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmMemoryOperand, i32> for CodeAssembler {
	fn rcl(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Rcl_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Rcl_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Rcl_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Rcl_rm8_1
			} else {
				return Err(IcedError::new("rcl: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Rcl_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rcl_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rcl_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rcl_rm8_imm8
		} else {
			return Err(IcedError::new("rcl: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm8_1 } else { Code::Rcl_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm16_1 } else { Code::Rcl_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm32_1 } else { Code::Rcl_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn rcl(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcl_rm64_1 } else { Code::Rcl_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcl<AsmMemoryOperand, u32> for CodeAssembler {
	fn rcl(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Rcl_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Rcl_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Rcl_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Rcl_rm8_1
			} else {
				return Err(IcedError::new("rcl: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Rcl_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rcl_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rcl_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rcl_rm8_imm8
		} else {
			return Err(IcedError::new("rcl: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcpps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn rcpps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcpps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcpps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rcpps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcpps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcpss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn rcpss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcpss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcpss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rcpss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcpss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcr_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcr_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcr_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rcr_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn rcr(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Rcr_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rcr_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rcr_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rcr_rm8_CL
		} else {
			return Err(IcedError::new("rcr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm8_1 } else { Code::Rcr_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm16_1 } else { Code::Rcr_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm32_1 } else { Code::Rcr_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm64_1 } else { Code::Rcr_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmMemoryOperand, i32> for CodeAssembler {
	fn rcr(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Rcr_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Rcr_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Rcr_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Rcr_rm8_1
			} else {
				return Err(IcedError::new("rcr: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Rcr_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rcr_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rcr_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rcr_rm8_imm8
		} else {
			return Err(IcedError::new("rcr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm8_1 } else { Code::Rcr_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm16_1 } else { Code::Rcr_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm32_1 } else { Code::Rcr_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn rcr(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rcr_rm64_1 } else { Code::Rcr_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRcr<AsmMemoryOperand, u32> for CodeAssembler {
	fn rcr(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Rcr_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Rcr_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Rcr_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Rcr_rm8_1
			} else {
				return Err(IcedError::new("rcr: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Rcr_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rcr_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rcr_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rcr_rm8_imm8
		} else {
			return Err(IcedError::new("rcr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdfsbase<AsmRegister32> for CodeAssembler {
	#[inline]
	fn rdfsbase(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdfsbase_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdfsbase<AsmRegister64> for CodeAssembler {
	#[inline]
	fn rdfsbase(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdfsbase_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdgsbase<AsmRegister32> for CodeAssembler {
	#[inline]
	fn rdgsbase(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdgsbase_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdgsbase<AsmRegister64> for CodeAssembler {
	#[inline]
	fn rdgsbase(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdgsbase_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdm for CodeAssembler {
	#[inline]
	fn rdm(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdm))
	}
}

#[rustfmt::skip]
impl CodeAsmRdmsr for CodeAssembler {
	#[inline]
	fn rdmsr(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdmsr))
	}
}

#[rustfmt::skip]
impl CodeAsmRdpid<AsmRegister32> for CodeAssembler {
	#[inline]
	fn rdpid(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdpid_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdpid<AsmRegister64> for CodeAssembler {
	#[inline]
	fn rdpid(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdpid_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdpkru for CodeAssembler {
	#[inline]
	fn rdpkru(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdpkru))
	}
}

#[rustfmt::skip]
impl CodeAsmRdpmc for CodeAssembler {
	#[inline]
	fn rdpmc(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdpmc))
	}
}

#[rustfmt::skip]
impl CodeAsmRdpru for CodeAssembler {
	#[inline]
	fn rdpru(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdpru))
	}
}

#[rustfmt::skip]
impl CodeAsmRdrand<AsmRegister16> for CodeAssembler {
	#[inline]
	fn rdrand(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdrand_r16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdrand<AsmRegister32> for CodeAssembler {
	#[inline]
	fn rdrand(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdrand_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdrand<AsmRegister64> for CodeAssembler {
	#[inline]
	fn rdrand(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdrand_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdseed<AsmRegister16> for CodeAssembler {
	#[inline]
	fn rdseed(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdseed_r16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdseed<AsmRegister32> for CodeAssembler {
	#[inline]
	fn rdseed(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdseed_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdseed<AsmRegister64> for CodeAssembler {
	#[inline]
	fn rdseed(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdseed_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdshr<AsmRegister32> for CodeAssembler {
	#[inline]
	fn rdshr(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdshr_rm32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdshr<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rdshr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdshr_rm32, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdsspd<AsmRegister32> for CodeAssembler {
	#[inline]
	fn rdsspd(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdsspd_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdsspq<AsmRegister64> for CodeAssembler {
	#[inline]
	fn rdsspq(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rdsspq_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRdtsc for CodeAssembler {
	#[inline]
	fn rdtsc(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdtsc))
	}
}

#[rustfmt::skip]
impl CodeAsmRdtscp for CodeAssembler {
	#[inline]
	fn rdtscp(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdtscp))
	}
}

#[rustfmt::skip]
impl CodeAsmRdudbg for CodeAssembler {
	#[inline]
	fn rdudbg(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rdudbg))
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f0d<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f0d(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F0D, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f0d<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f0d(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F0D, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f0d<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f0d(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F0D, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f0d<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f0d(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F0D, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f0d<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f0d(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F0D, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f0d<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f0d(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F0D, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f18<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f18(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F18, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f18<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f18(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F18, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f18<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f18(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F18, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f18<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f18(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F18, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f18<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f18(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F18, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f18<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f18(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F18, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f19<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f19(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F19, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f19<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f19(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F19, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f19<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f19(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F19, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f19<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f19(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F19, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f19<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f19(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F19, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f19<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f19(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F19, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1a<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1a(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1A, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1a<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1a(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1A, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1a<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1a(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1A, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1a<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1a(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1A, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1a<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1a(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1A, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1a<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1a(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1A, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1b<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1b(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1B, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1b<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1b(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1B, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1b<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1b(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1B, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1b<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1b(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1B, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1b<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1b(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1B, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1b<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1b(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1B, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1c<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1c(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1C, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1c<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1c(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1C, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1c<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1c(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1C, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1c<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1c(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1C, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1c<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1c(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1C, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1c<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1c(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1C, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1d<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1d(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1D, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1d<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1d(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1D, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1d<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1d(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1D, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1d<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1d(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1D, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1d<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1d(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1D, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1d<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1d(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1D, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1e<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1e(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1E, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1e<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1e(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1E, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1e<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1e(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1E, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1e<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1e(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1E, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1e<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1e(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1E, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1e<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1e(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1E, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1f<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1f(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1F, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1f<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn reservednop_0f1f(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm16_r16_0F1F, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1f<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1f(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1F, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1f<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn reservednop_0f1f(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm32_r32_0F1F, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1f<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1f(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1F, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmReservednop_0f1f<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn reservednop_0f1f(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Reservednop_rm64_r64_0F1F, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRet for CodeAssembler {
	fn ret(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Retnq
		} else if self.bitness() >= 32 {
			Code::Retnd
		} else {
			Code::Retnw
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmRet1<i32> for CodeAssembler {
	fn ret_1(&mut self, op0: i32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Retnq_imm16
		} else if self.bitness() >= 32 {
			Code::Retnd_imm16
		} else {
			Code::Retnw_imm16
		};
		self.add_instr(Instruction::with1(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRet1<u32> for CodeAssembler {
	fn ret_1(&mut self, op0: u32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Retnq_imm16
		} else if self.bitness() >= 32 {
			Code::Retnd_imm16
		} else {
			Code::Retnw_imm16
		};
		self.add_instr(Instruction::with1(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRetf for CodeAssembler {
	fn retf(&mut self) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Retfq
		} else if self.bitness() >= 32 {
			Code::Retfd
		} else {
			Code::Retfw
		};
		self.add_instr(Instruction::with(code))
	}
}

#[rustfmt::skip]
impl CodeAsmRetf1<i32> for CodeAssembler {
	fn retf_1(&mut self, op0: i32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Retfq_imm16
		} else if self.bitness() >= 32 {
			Code::Retfd_imm16
		} else {
			Code::Retfw_imm16
		};
		self.add_instr(Instruction::with1(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRetf1<u32> for CodeAssembler {
	fn retf_1(&mut self, op0: u32) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Retfq_imm16
		} else if self.bitness() >= 32 {
			Code::Retfd_imm16
		} else {
			Code::Retfw_imm16
		};
		self.add_instr(Instruction::with1(code, op0)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRmpadjust for CodeAssembler {
	#[inline]
	fn rmpadjust(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rmpadjust))
	}
}

#[rustfmt::skip]
impl CodeAsmRmpupdate for CodeAssembler {
	#[inline]
	fn rmpupdate(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rmpupdate))
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rol_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rol_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rol_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rol_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn rol(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Rol_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rol_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rol_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rol_rm8_CL
		} else {
			return Err(IcedError::new("rol: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm8_1 } else { Code::Rol_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm16_1 } else { Code::Rol_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm32_1 } else { Code::Rol_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm64_1 } else { Code::Rol_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmMemoryOperand, i32> for CodeAssembler {
	fn rol(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Rol_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Rol_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Rol_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Rol_rm8_1
			} else {
				return Err(IcedError::new("rol: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Rol_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rol_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rol_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rol_rm8_imm8
		} else {
			return Err(IcedError::new("rol: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm8_1 } else { Code::Rol_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm16_1 } else { Code::Rol_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm32_1 } else { Code::Rol_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn rol(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Rol_rm64_1 } else { Code::Rol_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRol<AsmMemoryOperand, u32> for CodeAssembler {
	fn rol(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Rol_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Rol_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Rol_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Rol_rm8_1
			} else {
				return Err(IcedError::new("rol: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Rol_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Rol_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Rol_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Rol_rm8_imm8
		} else {
			return Err(IcedError::new("rol: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ror_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ror_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ror_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ror_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn ror(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Ror_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Ror_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Ror_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Ror_rm8_CL
		} else {
			return Err(IcedError::new("ror: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm8_1 } else { Code::Ror_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm16_1 } else { Code::Ror_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm32_1 } else { Code::Ror_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm64_1 } else { Code::Ror_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmMemoryOperand, i32> for CodeAssembler {
	fn ror(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Ror_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Ror_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Ror_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Ror_rm8_1
			} else {
				return Err(IcedError::new("ror: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Ror_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Ror_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Ror_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Ror_rm8_imm8
		} else {
			return Err(IcedError::new("ror: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm8_1 } else { Code::Ror_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm16_1 } else { Code::Ror_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm32_1 } else { Code::Ror_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn ror(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Ror_rm64_1 } else { Code::Ror_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRor<AsmMemoryOperand, u32> for CodeAssembler {
	fn ror(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Ror_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Ror_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Ror_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Ror_rm8_1
			} else {
				return Err(IcedError::new("ror: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Ror_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Ror_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Ror_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Ror_rm8_imm8
		} else {
			return Err(IcedError::new("ror: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister32, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r32_rm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister64, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r64_rm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister32, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r32_rm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister64, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r64_rm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister32, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r32_rm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister64, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r64_rm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister32, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r32_rm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRorx<AsmRegister64, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn rorx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Rorx_r64_rm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundpd<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn roundpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundpd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundpd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn roundpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundpd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundpd<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn roundpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundpd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundpd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn roundpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundpd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundps<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn roundps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundps<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn roundps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundps<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn roundps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundps<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn roundps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundsd<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn roundsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundsd_xmm_xmmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundsd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn roundsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundsd_xmm_xmmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundsd<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn roundsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundsd_xmm_xmmm64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundsd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn roundsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundsd_xmm_xmmm64_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundss<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn roundss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundss_xmm_xmmm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundss<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn roundss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundss_xmm_xmmm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundss<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn roundss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundss_xmm_xmmm32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRoundss<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn roundss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Roundss_xmm_xmmm32_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmRsdc<AsmRegisterSegment, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rsdc(&mut self, op0: AsmRegisterSegment, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rsdc_Sreg_m80, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRsldt<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rsldt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rsldt_m80, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRsm for CodeAssembler {
	#[inline]
	fn rsm(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Rsm))
	}
}

#[rustfmt::skip]
impl CodeAsmRsqrtps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn rsqrtps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rsqrtps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRsqrtps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rsqrtps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rsqrtps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRsqrtss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn rsqrtss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rsqrtss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmRsqrtss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rsqrtss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Rsqrtss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRstorssp<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rstorssp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rstorssp_m64, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmRsts<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn rsts(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Rsts_m80, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSahf for CodeAssembler {
	#[inline]
	fn sahf(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sahf))
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sal_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sal_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sal_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sal_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn sal(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Sal_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Sal_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Sal_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sal_rm8_CL
		} else {
			return Err(IcedError::new("sal: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm8_1 } else { Code::Sal_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm16_1 } else { Code::Sal_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm32_1 } else { Code::Sal_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm64_1 } else { Code::Sal_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmMemoryOperand, i32> for CodeAssembler {
	fn sal(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Sal_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Sal_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Sal_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Sal_rm8_1
			} else {
				return Err(IcedError::new("sal: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Sal_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Sal_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Sal_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sal_rm8_imm8
		} else {
			return Err(IcedError::new("sal: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm8_1 } else { Code::Sal_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm16_1 } else { Code::Sal_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm32_1 } else { Code::Sal_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn sal(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sal_rm64_1 } else { Code::Sal_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSal<AsmMemoryOperand, u32> for CodeAssembler {
	fn sal(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Sal_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Sal_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Sal_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Sal_rm8_1
			} else {
				return Err(IcedError::new("sal: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Sal_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Sal_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Sal_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sal_rm8_imm8
		} else {
			return Err(IcedError::new("sal: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSalc for CodeAssembler {
	#[inline]
	fn salc(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Salc))
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sar_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sar_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sar_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sar_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn sar(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Sar_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Sar_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Sar_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sar_rm8_CL
		} else {
			return Err(IcedError::new("sar: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm8_1 } else { Code::Sar_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm16_1 } else { Code::Sar_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm32_1 } else { Code::Sar_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm64_1 } else { Code::Sar_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmMemoryOperand, i32> for CodeAssembler {
	fn sar(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Sar_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Sar_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Sar_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Sar_rm8_1
			} else {
				return Err(IcedError::new("sar: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Sar_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Sar_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Sar_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sar_rm8_imm8
		} else {
			return Err(IcedError::new("sar: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm8_1 } else { Code::Sar_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm16_1 } else { Code::Sar_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm32_1 } else { Code::Sar_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn sar(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Sar_rm64_1 } else { Code::Sar_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSar<AsmMemoryOperand, u32> for CodeAssembler {
	fn sar(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Sar_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Sar_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Sar_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Sar_rm8_1
			} else {
				return Err(IcedError::new("sar: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Sar_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Sar_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Sar_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sar_rm8_imm8
		} else {
			return Err(IcedError::new("sar: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSarx<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn sarx(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Sarx_r32_rm32_r32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSarx<AsmRegister32, AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn sarx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Sarx_r32_rm32_r32, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSarx<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn sarx(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Sarx_r64_rm64_r64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSarx<AsmRegister64, AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn sarx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Sarx_r64_rm64_r64, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSaveprevssp for CodeAssembler {
	#[inline]
	fn saveprevssp(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Saveprevssp))
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sbb_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Sbb_AL_imm8 } else { Code::Sbb_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister16, i32> for CodeAssembler {
	fn sbb(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Sbb_AX_imm16
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Sbb_rm16_imm8
		} else {
			Code::Sbb_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister32, i32> for CodeAssembler {
	fn sbb(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Sbb_EAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Sbb_rm32_imm8
		} else {
			Code::Sbb_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister64, i32> for CodeAssembler {
	fn sbb(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX {
			Code::Sbb_RAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Sbb_rm64_imm8
		} else {
			Code::Sbb_rm64_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmMemoryOperand, i32> for CodeAssembler {
	fn sbb(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Sbb_rm64_imm8 } else { Code::Sbb_rm64_imm32 }
		} else if op0.size() == MemoryOperandSize::Dword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Sbb_rm32_imm8 } else { Code::Sbb_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Sbb_rm16_imm8 } else { Code::Sbb_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sbb_rm8_imm8
		} else {
			return Err(IcedError::new("sbb: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn sbb(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Sbb_AL_imm8 } else { Code::Sbb_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister16, u32> for CodeAssembler {
	fn sbb(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Sbb_AX_imm16
		} else if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) {
			Code::Sbb_rm16_imm8
		} else {
			Code::Sbb_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmRegister32, u32> for CodeAssembler {
	fn sbb(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Sbb_EAX_imm32
		} else if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 {
			Code::Sbb_rm32_imm8
		} else {
			Code::Sbb_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSbb<AsmMemoryOperand, u32> for CodeAssembler {
	fn sbb(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 { Code::Sbb_rm32_imm8 } else { Code::Sbb_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) { Code::Sbb_rm16_imm8 } else { Code::Sbb_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sbb_rm8_imm8
		} else {
			return Err(IcedError::new("sbb: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmScasb for CodeAssembler {
	#[inline]
	fn scasb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_scasb(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmScasd for CodeAssembler {
	#[inline]
	fn scasd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_scasd(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmScasq for CodeAssembler {
	#[inline]
	fn scasq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_scasq(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmScasw for CodeAssembler {
	#[inline]
	fn scasw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_scasw(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSeamcall for CodeAssembler {
	#[inline]
	fn seamcall(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Seamcall))
	}
}

#[rustfmt::skip]
impl CodeAsmSeamops for CodeAssembler {
	#[inline]
	fn seamops(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Seamops))
	}
}

#[rustfmt::skip]
impl CodeAsmSeamret for CodeAssembler {
	#[inline]
	fn seamret(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Seamret))
	}
}

#[rustfmt::skip]
impl CodeAsmSenduipi<AsmRegister64> for CodeAssembler {
	#[inline]
	fn senduipi(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Senduipi_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSerialize for CodeAssembler {
	#[inline]
	fn serialize(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Serialize))
	}
}

#[rustfmt::skip]
impl CodeAsmSeta<AsmRegister8> for CodeAssembler {
	#[inline]
	fn seta(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Seta_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSeta<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn seta(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Seta_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetae<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setae(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setae_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetae<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setae(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setae_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetb<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setb(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setb_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetb<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setb(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setb_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetbe<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setbe(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setbe_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetbe<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setbe(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setbe_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetc<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setc(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setb_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetc<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setc(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setb_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSete<AsmRegister8> for CodeAssembler {
	#[inline]
	fn sete(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sete_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSete<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sete(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sete_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetg<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setg(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setg_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetg<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setg(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setg_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetge<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setge(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setge_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetge<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setge(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setge_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetl<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setl(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setl_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetl<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setl(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setl_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetle<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setle(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setle_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetle<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setle(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setle_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetna<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setna(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setbe_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetna<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setna(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setbe_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnae<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnae(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setb_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnae<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnae(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setb_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnb<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnb(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setae_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnb<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnb(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setae_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnbe<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnbe(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Seta_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnbe<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnbe(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Seta_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnc<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnc(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setae_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnc<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnc(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setae_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetne<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setne(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setne_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetne<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setne(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setne_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetng<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setng(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setle_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetng<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setng(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setle_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnge<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnge(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setl_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnge<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnge(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setl_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnl<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnl(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setge_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnl<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnl(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setge_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnle<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnle(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setg_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnle<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnle(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setg_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetno<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setno(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setno_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetno<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setno(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setno_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnp<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnp(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setnp_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnp<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setnp_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetns<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setns(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setns_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetns<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setns(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setns_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnz<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setnz(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setne_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetnz<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setnz(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setne_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSeto<AsmRegister8> for CodeAssembler {
	#[inline]
	fn seto(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Seto_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSeto<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn seto(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Seto_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetp<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setp(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setp_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetp<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setp(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setp_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetpe<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setpe(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setp_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetpe<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setpe(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setp_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetpo<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setpo(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setnp_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetpo<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setpo(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Setnp_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSets<AsmRegister8> for CodeAssembler {
	#[inline]
	fn sets(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sets_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSets<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sets(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sets_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetssbsy for CodeAssembler {
	#[inline]
	fn setssbsy(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Setssbsy))
	}
}

#[rustfmt::skip]
impl CodeAsmSetz<AsmRegister8> for CodeAssembler {
	#[inline]
	fn setz(&mut self, op0: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sete_rm8, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSetz<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn setz(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sete_rm8, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSfence for CodeAssembler {
	#[inline]
	fn sfence(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sfence))
	}
}

#[rustfmt::skip]
impl CodeAsmSgdt<AsmMemoryOperand> for CodeAssembler {
	fn sgdt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Sgdt_m1664
		} else if self.bitness() >= 32 {
			Code::Sgdt_m1632
		} else {
			Code::Sgdt_m1632_16
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1msg1<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sha1msg1(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha1msg1_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1msg1<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sha1msg1(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha1msg1_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1msg2<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sha1msg2(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha1msg2_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1msg2<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sha1msg2(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha1msg2_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1nexte<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sha1nexte(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha1nexte_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1nexte<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sha1nexte(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha1nexte_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1rnds4<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn sha1rnds4(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Sha1rnds4_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1rnds4<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn sha1rnds4(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Sha1rnds4_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1rnds4<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn sha1rnds4(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Sha1rnds4_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha1rnds4<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn sha1rnds4(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Sha1rnds4_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha256msg1<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sha256msg1(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha256msg1_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha256msg1<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sha256msg1(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha256msg1_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha256msg2<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sha256msg2(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha256msg2_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha256msg2<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sha256msg2(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha256msg2_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha256rnds2<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sha256rnds2(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha256rnds2_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSha256rnds2<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sha256rnds2(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sha256rnds2_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shl_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shl_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shl_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shl_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn shl(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Shl_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Shl_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Shl_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Shl_rm8_CL
		} else {
			return Err(IcedError::new("shl: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm8_1 } else { Code::Shl_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm16_1 } else { Code::Shl_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm32_1 } else { Code::Shl_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm64_1 } else { Code::Shl_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmMemoryOperand, i32> for CodeAssembler {
	fn shl(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Shl_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Shl_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Shl_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Shl_rm8_1
			} else {
				return Err(IcedError::new("shl: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Shl_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Shl_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Shl_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Shl_rm8_imm8
		} else {
			return Err(IcedError::new("shl: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm8_1 } else { Code::Shl_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm16_1 } else { Code::Shl_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm32_1 } else { Code::Shl_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn shl(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shl_rm64_1 } else { Code::Shl_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShl<AsmMemoryOperand, u32> for CodeAssembler {
	fn shl(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Shl_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Shl_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Shl_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Shl_rm8_1
			} else {
				return Err(IcedError::new("shl: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Shl_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Shl_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Shl_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Shl_rm8_imm8
		} else {
			return Err(IcedError::new("shl: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister16, AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm16_r16_CL, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm16_r16_CL, op0.to_memory_operand(self.bitness()), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister32, AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm32_r32_CL, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm32_r32_CL, op0.to_memory_operand(self.bitness()), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister64, AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm64_r64_CL, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm64_r64_CL, op0.to_memory_operand(self.bitness()), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister16, AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm16_r16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm16_r16_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister32, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm32_r32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm32_r32_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister64, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm64_r64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm64_r64_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister16, AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm16_r16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm16_r16_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister32, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm32_r32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm32_r32_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmRegister64, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm64_r64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShld<AsmMemoryOperand, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn shld(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shld_rm64_r64_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShlx<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn shlx(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shlx_r32_rm32_r32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShlx<AsmRegister32, AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn shlx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shlx_r32_rm32_r32, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShlx<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn shlx(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shlx_r64_rm64_r64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShlx<AsmRegister64, AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn shlx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shlx_r64_rm64_r64, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shr_rm8_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister16, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shr_rm16_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister32, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shr_rm32_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister64, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Shr_rm64_CL, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	fn shr(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Shr_rm64_CL
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Shr_rm32_CL
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Shr_rm16_CL
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Shr_rm8_CL
		} else {
			return Err(IcedError::new("shr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm8_1 } else { Code::Shr_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm16_1 } else { Code::Shr_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm32_1 } else { Code::Shr_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm64_1 } else { Code::Shr_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmMemoryOperand, i32> for CodeAssembler {
	fn shr(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Shr_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Shr_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Shr_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Shr_rm8_1
			} else {
				return Err(IcedError::new("shr: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Shr_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Shr_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Shr_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Shr_rm8_imm8
		} else {
			return Err(IcedError::new("shr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm8_1 } else { Code::Shr_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm16_1 } else { Code::Shr_rm16_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm32_1 } else { Code::Shr_rm32_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn shr(&mut self, op0: AsmRegister64, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 { Code::Shr_rm64_1 } else { Code::Shr_rm64_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShr<AsmMemoryOperand, u32> for CodeAssembler {
	fn shr(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op1 == 1 {
			if op0.size() == MemoryOperandSize::Qword {
				Code::Shr_rm64_1
			} else if op0.size() == MemoryOperandSize::Dword {
				Code::Shr_rm32_1
			} else if op0.size() == MemoryOperandSize::Word {
				Code::Shr_rm16_1
			} else if op0.size() == MemoryOperandSize::Byte {
				Code::Shr_rm8_1
			} else {
				return Err(IcedError::new("shr: invalid operands"));
			}
		} else if op0.size() == MemoryOperandSize::Qword {
			Code::Shr_rm64_imm8
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Shr_rm32_imm8
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Shr_rm16_imm8
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Shr_rm8_imm8
		} else {
			return Err(IcedError::new("shr: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister16, AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm16_r16_CL, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister16, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm16_r16_CL, op0.to_memory_operand(self.bitness()), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister32, AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm32_r32_CL, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister32, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm32_r32_CL, op0.to_memory_operand(self.bitness()), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister64, AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm64_r64_CL, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister64, AsmRegister8> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64, op2: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm64_r64_CL, op0.to_memory_operand(self.bitness()), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister16, AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm16_r16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm16_r16_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister32, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm32_r32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm32_r32_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister64, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm64_r64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm64_r64_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister16, AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister16, op1: AsmRegister16, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm16_r16_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm16_r16_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister32, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm32_r32_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm32_r32_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmRegister64, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm64_r64_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrd<AsmMemoryOperand, AsmRegister64, u32> for CodeAssembler {
	#[inline]
	fn shrd(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shrd_rm64_r64_imm8, op0.to_memory_operand(self.bitness()), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrx<AsmRegister32, AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn shrx(&mut self, op0: AsmRegister32, op1: AsmRegister32, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shrx_r32_rm32_r32, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrx<AsmRegister32, AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn shrx(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand, op2: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shrx_r32_rm32_r32, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrx<AsmRegister64, AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn shrx(&mut self, op0: AsmRegister64, op1: AsmRegister64, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shrx_r64_rm64_r64, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShrx<AsmRegister64, AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn shrx(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand, op2: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Shrx_r64_rm64_r64, op0.register(), op1.to_memory_operand(self.bitness()), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufpd<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn shufpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufpd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufpd<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn shufpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufpd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufpd<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn shufpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufpd_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufpd<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn shufpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufpd_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufps<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn shufps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufps<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn shufps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufps<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn shufps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufps_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmShufps<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn shufps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::Shufps_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSidt<AsmMemoryOperand> for CodeAssembler {
	fn sidt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() == 64 {
			Code::Sidt_m1664
		} else if self.bitness() >= 32 {
			Code::Sidt_m1632
		} else {
			Code::Sidt_m1632_16
		};
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSkinit for CodeAssembler {
	#[inline]
	fn skinit(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Skinit))
	}
}

#[rustfmt::skip]
impl CodeAsmSldt<AsmRegister16> for CodeAssembler {
	#[inline]
	fn sldt(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sldt_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSldt<AsmRegister32> for CodeAssembler {
	#[inline]
	fn sldt(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sldt_r32m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSldt<AsmRegister64> for CodeAssembler {
	#[inline]
	fn sldt(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Sldt_r64m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSldt<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sldt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Sldt_r32m16 } else { Code::Sldt_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSlwpcb<AsmRegister32> for CodeAssembler {
	#[inline]
	fn slwpcb(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::XOP_Slwpcb_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSlwpcb<AsmRegister64> for CodeAssembler {
	#[inline]
	fn slwpcb(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::XOP_Slwpcb_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSmint for CodeAssembler {
	#[inline]
	fn smint(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Smint))
	}
}

#[rustfmt::skip]
impl CodeAsmSmint_0f7e for CodeAssembler {
	#[inline]
	fn smint_0f7e(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Smint_0F7E))
	}
}

#[rustfmt::skip]
impl CodeAsmSmsw<AsmRegister16> for CodeAssembler {
	#[inline]
	fn smsw(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Smsw_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSmsw<AsmRegister32> for CodeAssembler {
	#[inline]
	fn smsw(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Smsw_r32m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSmsw<AsmRegister64> for CodeAssembler {
	#[inline]
	fn smsw(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Smsw_r64m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSmsw<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn smsw(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Smsw_r32m16 } else { Code::Smsw_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sqrtpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sqrtpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sqrtps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sqrtps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sqrtsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sqrtsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn sqrtss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSqrtss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sqrtss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sqrtss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmStac for CodeAssembler {
	#[inline]
	fn stac(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Stac))
	}
}

#[rustfmt::skip]
impl CodeAsmStc for CodeAssembler {
	#[inline]
	fn stc(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Stc))
	}
}

#[rustfmt::skip]
impl CodeAsmStd for CodeAssembler {
	#[inline]
	fn std(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Std))
	}
}

#[rustfmt::skip]
impl CodeAsmStgi for CodeAssembler {
	#[inline]
	fn stgi(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Stgi))
	}
}

#[rustfmt::skip]
impl CodeAsmSti for CodeAssembler {
	#[inline]
	fn sti(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sti))
	}
}

#[rustfmt::skip]
impl CodeAsmStmxcsr<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn stmxcsr(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Stmxcsr_m32, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmStosb for CodeAssembler {
	#[inline]
	fn stosb(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_stosb(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmStosd for CodeAssembler {
	#[inline]
	fn stosd(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_stosd(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmStosq for CodeAssembler {
	#[inline]
	fn stosq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_stosq(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmStosw for CodeAssembler {
	#[inline]
	fn stosw(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with_stosw(self.bitness(), RepPrefixKind::None)?)
	}
}

#[rustfmt::skip]
impl CodeAsmStr<AsmRegister16> for CodeAssembler {
	#[inline]
	fn str(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Str_rm16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmStr<AsmRegister32> for CodeAssembler {
	#[inline]
	fn str(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Str_r32m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmStr<AsmRegister64> for CodeAssembler {
	#[inline]
	fn str(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Str_r64m16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmStr<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn str(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.bitness() >= 32 { Code::Str_r32m16 } else { Code::Str_rm16 };
		self.add_instr(Instruction::with1(code, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSttilecfg<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sttilecfg(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::VEX_Sttilecfg_m512, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmStui for CodeAssembler {
	#[inline]
	fn stui(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Stui))
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Sub_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Sub_AL_imm8 } else { Code::Sub_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister16, i32> for CodeAssembler {
	fn sub(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Sub_AX_imm16
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Sub_rm16_imm8
		} else {
			Code::Sub_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister32, i32> for CodeAssembler {
	fn sub(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Sub_EAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Sub_rm32_imm8
		} else {
			Code::Sub_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister64, i32> for CodeAssembler {
	fn sub(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX {
			Code::Sub_RAX_imm32
		} else if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 {
			Code::Sub_rm64_imm8
		} else {
			Code::Sub_rm64_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmMemoryOperand, i32> for CodeAssembler {
	fn sub(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Sub_rm64_imm8 } else { Code::Sub_rm64_imm32 }
		} else if op0.size() == MemoryOperandSize::Dword {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Sub_rm32_imm8 } else { Code::Sub_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 >= i8::MIN as i32 && op1 <= i8::MAX as i32 { Code::Sub_rm16_imm8 } else { Code::Sub_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sub_rm8_imm8
		} else {
			return Err(IcedError::new("sub: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn sub(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Sub_AL_imm8 } else { Code::Sub_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister16, u32> for CodeAssembler {
	fn sub(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX {
			Code::Sub_AX_imm16
		} else if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) {
			Code::Sub_rm16_imm8
		} else {
			Code::Sub_rm16_imm16
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmRegister32, u32> for CodeAssembler {
	fn sub(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX {
			Code::Sub_EAX_imm32
		} else if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 {
			Code::Sub_rm32_imm8
		} else {
			Code::Sub_rm32_imm32
		};
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSub<AsmMemoryOperand, u32> for CodeAssembler {
	fn sub(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			if op1 <= i8::MAX as u32 || 0xFFFF_FF80 <= op1 { Code::Sub_rm32_imm8 } else { Code::Sub_rm32_imm32 }
		} else if op0.size() == MemoryOperandSize::Word {
			if op1 <= i8::MAX as u32 || (0xFF80 <= op1 && op1 <= 0xFFFF) { Code::Sub_rm16_imm8 } else { Code::Sub_rm16_imm16 }
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Sub_rm8_imm8
		} else {
			return Err(IcedError::new("sub: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn subpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn subpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn subps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn subps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubsd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn subsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subsd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubsd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn subsd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subsd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn subss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSubss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn subss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Subss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSvdc<AsmMemoryOperand, AsmRegisterSegment> for CodeAssembler {
	#[inline]
	fn svdc(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterSegment) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Svdc_m80_Sreg, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmSvldt<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn svldt(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Svldt_m80, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSvts<AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn svts(&mut self, op0: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Svts_m80, op0.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmSwapgs for CodeAssembler {
	#[inline]
	fn swapgs(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Swapgs))
	}
}

#[rustfmt::skip]
impl CodeAsmSyscall for CodeAssembler {
	#[inline]
	fn syscall(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Syscall))
	}
}

#[rustfmt::skip]
impl CodeAsmSysenter for CodeAssembler {
	#[inline]
	fn sysenter(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sysenter))
	}
}

#[rustfmt::skip]
impl CodeAsmSysexit for CodeAssembler {
	#[inline]
	fn sysexit(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sysexitd))
	}
}

#[rustfmt::skip]
impl CodeAsmSysexitq for CodeAssembler {
	#[inline]
	fn sysexitq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sysexitq))
	}
}

#[rustfmt::skip]
impl CodeAsmSysret for CodeAssembler {
	#[inline]
	fn sysret(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sysretd))
	}
}

#[rustfmt::skip]
impl CodeAsmSysretq for CodeAssembler {
	#[inline]
	fn sysretq(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Sysretq))
	}
}

#[rustfmt::skip]
impl CodeAsmT1mskc<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn t1mskc(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_T1mskc_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmT1mskc<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn t1mskc(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_T1mskc_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmT1mskc<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn t1mskc(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_T1mskc_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmT1mskc<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn t1mskc(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_T1mskc_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmTdcall for CodeAssembler {
	#[inline]
	fn tdcall(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Tdcall))
	}
}

#[rustfmt::skip]
impl CodeAsmTdpbf16ps<AsmRegisterTmm, AsmRegisterTmm, AsmRegisterTmm> for CodeAssembler {
	#[inline]
	fn tdpbf16ps(&mut self, op0: AsmRegisterTmm, op1: AsmRegisterTmm, op2: AsmRegisterTmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Tdpbf16ps_tmm_tmm_tmm, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTdpbssd<AsmRegisterTmm, AsmRegisterTmm, AsmRegisterTmm> for CodeAssembler {
	#[inline]
	fn tdpbssd(&mut self, op0: AsmRegisterTmm, op1: AsmRegisterTmm, op2: AsmRegisterTmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Tdpbssd_tmm_tmm_tmm, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTdpbsud<AsmRegisterTmm, AsmRegisterTmm, AsmRegisterTmm> for CodeAssembler {
	#[inline]
	fn tdpbsud(&mut self, op0: AsmRegisterTmm, op1: AsmRegisterTmm, op2: AsmRegisterTmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Tdpbsud_tmm_tmm_tmm, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTdpbusd<AsmRegisterTmm, AsmRegisterTmm, AsmRegisterTmm> for CodeAssembler {
	#[inline]
	fn tdpbusd(&mut self, op0: AsmRegisterTmm, op1: AsmRegisterTmm, op2: AsmRegisterTmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Tdpbusd_tmm_tmm_tmm, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTdpbuud<AsmRegisterTmm, AsmRegisterTmm, AsmRegisterTmm> for CodeAssembler {
	#[inline]
	fn tdpbuud(&mut self, op0: AsmRegisterTmm, op1: AsmRegisterTmm, op2: AsmRegisterTmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Tdpbuud_tmm_tmm_tmm, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm64_r64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmMemoryOperand, AsmRegister64> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmMemoryOperand, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Test_rm64_r64, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister8, i32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister8, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Test_AL_imm8 } else { Code::Test_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister16, i32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister16, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX { Code::Test_AX_imm16 } else { Code::Test_rm16_imm16 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister32, i32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister32, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX { Code::Test_EAX_imm32 } else { Code::Test_rm32_imm32 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister64, i32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister64, op1: i32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::RAX { Code::Test_RAX_imm32 } else { Code::Test_rm64_imm32 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmMemoryOperand, i32> for CodeAssembler {
	fn test(&mut self, op0: AsmMemoryOperand, op1: i32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Qword {
			Code::Test_rm64_imm32
		} else if op0.size() == MemoryOperandSize::Dword {
			Code::Test_rm32_imm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Test_rm16_imm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Test_rm8_imm8
		} else {
			return Err(IcedError::new("test: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister8, u32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister8, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AL { Code::Test_AL_imm8 } else { Code::Test_rm8_imm8 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister16, u32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister16, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::AX { Code::Test_AX_imm16 } else { Code::Test_rm16_imm16 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmRegister32, u32> for CodeAssembler {
	#[inline]
	fn test(&mut self, op0: AsmRegister32, op1: u32) -> Result<(), IcedError> {
		let code = if op0.register() == Register::EAX { Code::Test_EAX_imm32 } else { Code::Test_rm32_imm32 };
		self.add_instr(Instruction::with2(code, op0.register(), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTest<AsmMemoryOperand, u32> for CodeAssembler {
	fn test(&mut self, op0: AsmMemoryOperand, op1: u32) -> Result<(), IcedError> {
		let code = if op0.size() == MemoryOperandSize::Dword {
			Code::Test_rm32_imm32
		} else if op0.size() == MemoryOperandSize::Word {
			Code::Test_rm16_imm16
		} else if op0.size() == MemoryOperandSize::Byte {
			Code::Test_rm8_imm8
		} else {
			return Err(IcedError::new("test: invalid operands"));
		};
		self.add_instr(Instruction::with2(code, op0.to_memory_operand(self.bitness()), op1)?)
	}
}

#[rustfmt::skip]
impl CodeAsmTestui for CodeAssembler {
	#[inline]
	fn testui(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Testui))
	}
}

#[rustfmt::skip]
impl CodeAsmTileloadd<AsmRegisterTmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn tileloadd(&mut self, op0: AsmRegisterTmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Tileloadd_tmm_sibmem, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmTileloaddt1<AsmRegisterTmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn tileloaddt1(&mut self, op0: AsmRegisterTmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Tileloaddt1_tmm_sibmem, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmTilerelease for CodeAssembler {
	#[inline]
	fn tilerelease(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::VEX_Tilerelease))
	}
}

#[rustfmt::skip]
impl CodeAsmTilestored<AsmMemoryOperand, AsmRegisterTmm> for CodeAssembler {
	#[inline]
	fn tilestored(&mut self, op0: AsmMemoryOperand, op1: AsmRegisterTmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Tilestored_sibmem_tmm, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTilezero<AsmRegisterTmm> for CodeAssembler {
	#[inline]
	fn tilezero(&mut self, op0: AsmRegisterTmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::VEX_Tilezero_tmm, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTlbsync for CodeAssembler {
	#[inline]
	fn tlbsync(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Tlbsync))
	}
}

#[rustfmt::skip]
impl CodeAsmTpause<AsmRegister32> for CodeAssembler {
	#[inline]
	fn tpause(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Tpause_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTpause<AsmRegister64> for CodeAssembler {
	#[inline]
	fn tpause(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Tpause_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzcnt<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn tzcnt(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Tzcnt_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzcnt<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn tzcnt(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Tzcnt_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzcnt<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn tzcnt(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Tzcnt_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzcnt<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn tzcnt(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Tzcnt_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzcnt<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn tzcnt(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Tzcnt_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzcnt<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn tzcnt(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Tzcnt_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzmsk<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn tzmsk(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Tzmsk_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzmsk<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn tzmsk(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Tzmsk_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzmsk<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn tzmsk(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Tzmsk_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmTzmsk<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn tzmsk(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::XOP_Tzmsk_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUcomisd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn ucomisd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ucomisd_xmm_xmmm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUcomisd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ucomisd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ucomisd_xmm_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUcomiss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn ucomiss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ucomiss_xmm_xmmm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUcomiss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ucomiss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ucomiss_xmm_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd0 for CodeAssembler {
	#[inline]
	fn ud0(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Ud0))
	}
}

#[rustfmt::skip]
impl CodeAsmUd02<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn ud0_2(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud0_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd02<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn ud0_2(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud0_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd02<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn ud0_2(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud0_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd02<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ud0_2(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud0_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd02<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ud0_2(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud0_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd02<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ud0_2(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud0_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd1<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn ud1(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud1_r16_rm16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd1<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn ud1(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud1_r32_rm32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd1<AsmRegister64, AsmRegister64> for CodeAssembler {
	#[inline]
	fn ud1(&mut self, op0: AsmRegister64, op1: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud1_r64_rm64, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd1<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ud1(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud1_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd1<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ud1(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud1_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd1<AsmRegister64, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn ud1(&mut self, op0: AsmRegister64, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Ud1_r64_rm64, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUd2 for CodeAssembler {
	#[inline]
	fn ud2(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Ud2))
	}
}

#[rustfmt::skip]
impl CodeAsmUiret for CodeAssembler {
	#[inline]
	fn uiret(&mut self) -> Result<(), IcedError> {
		self.add_instr(Instruction::with(Code::Uiret))
	}
}

#[rustfmt::skip]
impl CodeAsmUmonitor<AsmRegister16> for CodeAssembler {
	#[inline]
	fn umonitor(&mut self, op0: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Umonitor_r16, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmonitor<AsmRegister32> for CodeAssembler {
	#[inline]
	fn umonitor(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Umonitor_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmonitor<AsmRegister64> for CodeAssembler {
	#[inline]
	fn umonitor(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Umonitor_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmRegister8, AsmRegister8> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmRegister8, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_rm8_r8, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmMemoryOperand, AsmRegister8> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmMemoryOperand, op1: AsmRegister8) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_rm8_r8, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmRegister16, AsmRegister16> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmRegister16, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_rm16_r16, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmMemoryOperand, AsmRegister16> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmMemoryOperand, op1: AsmRegister16) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_rm16_r16, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmRegister32, AsmRegister32> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmRegister32, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_rm32_r32, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmMemoryOperand, AsmRegister32> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmMemoryOperand, op1: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_rm32_r32, op0.to_memory_operand(self.bitness()), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmRegister8, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmRegister8, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_r8_rm8, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmRegister16, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmRegister16, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_r16_rm16, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmov<AsmRegister32, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn umov(&mut self, op0: AsmRegister32, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Umov_r32_rm32, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmwait<AsmRegister32> for CodeAssembler {
	#[inline]
	fn umwait(&mut self, op0: AsmRegister32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Umwait_r32, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUmwait<AsmRegister64> for CodeAssembler {
	#[inline]
	fn umwait(&mut self, op0: AsmRegister64) -> Result<(), IcedError> {
		self.add_instr(Instruction::with1(Code::Umwait_r64, op0.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpckhpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn unpckhpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpckhpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpckhpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn unpckhpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpckhpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpckhps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn unpckhps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpckhps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpckhps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn unpckhps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpckhps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpcklpd<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn unpcklpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpcklpd_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpcklpd<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn unpcklpd(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpcklpd_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpcklps<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn unpcklps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpcklps_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmUnpcklps<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn unpcklps(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::Unpcklps_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmV4fmaddps<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn v4fmaddps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_V4fmaddps_zmm_k1z_zmmp3_m128, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmV4fmaddss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn v4fmaddss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_V4fmaddss_xmm_k1z_xmmp3_m128, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmV4fnmaddps<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn v4fnmaddps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_V4fnmaddps_zmm_k1z_zmmp3_m128, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmV4fnmaddss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn v4fnmaddss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_V4fnmaddss_xmm_k1z_xmmp3_m128, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVaddpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddpd_xmm_xmm_xmmm128 } else { Code::EVEX_Vaddpd_xmm_k1z_xmm_xmmm128b64 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVaddpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaddpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddpd_ymm_ymm_ymmm256 } else { Code::EVEX_Vaddpd_ymm_k1z_ymm_ymmm256b64 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVaddpd<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vaddpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddpd_zmm_k1z_zmm_zmmm512b64_er, op0.register(), op1.register(), op2.register())?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn vaddpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vaddpd_xmm_k1z_xmm_xmmm128b64
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vaddpd_xmm_xmm_xmmm128
		} else {
			Code::EVEX_Vaddpd_xmm_k1z_xmm_xmmm128b64
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	fn vaddpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vaddpd_ymm_k1z_ymm_ymmm256b64
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vaddpd_ymm_ymm_ymmm256
		} else {
			Code::EVEX_Vaddpd_ymm_k1z_ymm_ymmm256b64
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddpd<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddpd_zmm_k1z_zmm_zmmm512b64_er, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddph<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddph(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddph_xmm_k1z_xmm_xmmm128b16, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVaddph<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaddph(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddph_ymm_k1z_ymm_ymmm256b16, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVaddph<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vaddph(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddph_zmm_k1z_zmm_zmmm512b16_er, op0.register(), op1.register(), op2.register())?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddph<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddph(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddph_xmm_k1z_xmm_xmmm128b16, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddph<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddph(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddph_ymm_k1z_ymm_ymmm256b16, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddph<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddph(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddph_zmm_k1z_zmm_zmmm512b16_er, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddps_xmm_xmm_xmmm128 } else { Code::EVEX_Vaddps_xmm_k1z_xmm_xmmm128b32 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVaddps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaddps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddps_ymm_ymm_ymmm256 } else { Code::EVEX_Vaddps_ymm_k1z_ymm_ymmm256b32 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVaddps<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vaddps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddps_zmm_k1z_zmm_zmmm512b32_er, op0.register(), op1.register(), op2.register())?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn vaddps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vaddps_xmm_k1z_xmm_xmmm128b32
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vaddps_xmm_xmm_xmmm128
		} else {
			Code::EVEX_Vaddps_xmm_k1z_xmm_xmmm128b32
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	fn vaddps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vaddps_ymm_k1z_ymm_ymmm256b32
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vaddps_ymm_ymm_ymmm256
		} else {
			Code::EVEX_Vaddps_ymm_k1z_ymm_ymmm256b32
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddps<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddps_zmm_k1z_zmm_zmmm512b32_er, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddsd_xmm_xmm_xmmm64 } else { Code::EVEX_Vaddsd_xmm_k1z_xmm_xmmm64_er };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddsd_xmm_xmm_xmmm64 } else { Code::EVEX_Vaddsd_xmm_k1z_xmm_xmmm64_er };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsh<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddsh(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddsh_xmm_k1z_xmm_xmmm16_er, op0.register(), op1.register(), op2.register())?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsh<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddsh(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vaddsh_xmm_k1z_xmm_xmmm16_er, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddss_xmm_xmm_xmmm32 } else { Code::EVEX_Vaddss_xmm_k1z_xmm_xmmm32_er };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaddss_xmm_xmm_xmmm32 } else { Code::EVEX_Vaddss_xmm_k1z_xmm_xmmm32_er };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddsubpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubpd_xmm_xmm_xmmm128, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaddsubpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubpd_ymm_ymm_ymmm256, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddsubpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubpd_xmm_xmm_xmmm128, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddsubpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubpd_ymm_ymm_ymmm256, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaddsubps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubps_xmm_xmm_xmmm128, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaddsubps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubps_ymm_ymm_ymmm256, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddsubps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubps_xmm_xmm_xmmm128, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaddsubps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaddsubps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaddsubps_ymm_ymm_ymmm256, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdec<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaesdec(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdec_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesdec_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdec<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaesdec(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdec_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesdec_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdec<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vaesdec(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesdec_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdec<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesdec(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdec_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesdec_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdec<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesdec(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdec_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesdec_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdec<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesdec(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesdec_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdeclast<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaesdeclast(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdeclast_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesdeclast_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdeclast<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaesdeclast(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdeclast_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesdeclast_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdeclast<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vaesdeclast(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesdeclast_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdeclast<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesdeclast(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdeclast_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesdeclast_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdeclast<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesdeclast(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesdeclast_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesdeclast_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesdeclast<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesdeclast(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesdeclast_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenc<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaesenc(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenc_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesenc_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenc<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaesenc(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenc_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesenc_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenc<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vaesenc(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesenc_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenc<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesenc(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenc_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesenc_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenc<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesenc(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenc_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesenc_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenc<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesenc(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesenc_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenclast<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaesenclast(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenclast_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesenclast_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenclast<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vaesenclast(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenclast_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesenclast_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenclast<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vaesenclast(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesenclast_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenclast<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesenclast(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenclast_xmm_xmm_xmmm128 } else { Code::EVEX_Vaesenclast_xmm_xmm_xmmm128 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenclast<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesenclast(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vaesenclast_ymm_ymm_ymmm256 } else { Code::EVEX_Vaesenclast_ymm_ymm_ymmm256 };
		self.add_instr(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesenclast<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesenclast(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::EVEX_Vaesenclast_zmm_zmm_zmmm512, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesimc<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vaesimc(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Vaesimc_xmm_xmmm128, op0.register(), op1.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaesimc<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vaesimc(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Vaesimc_xmm_xmmm128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaeskeygenassist<AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn vaeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaeskeygenassist<AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn vaeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaeskeygenassist<AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn vaeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.register(), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVaeskeygenassist<AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn vaeskeygenassist(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand, op2: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with3(Code::VEX_Vaeskeygenassist_xmm_xmmm128_imm8, op0.register(), op1.to_memory_operand(self.bitness()), op2)?)
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm, i32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, u32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm, u32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignd<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn valignd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm, i32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, u32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm, u32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8, op0.register(), op1.register(), op2.register(), op3)?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmValignq<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn valignq(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with4(Code::EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandnpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vandnpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandnpd_xmm_xmm_xmmm128 } else { Code::EVEX_Vandnpd_xmm_k1z_xmm_xmmm128b64 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandnpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vandnpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandnpd_ymm_ymm_ymmm256 } else { Code::EVEX_Vandnpd_ymm_k1z_ymm_ymmm256b64 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandnpd<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vandnpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandnpd_zmm_k1z_zmm_zmmm512b64, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandnpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn vandnpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandnpd_xmm_k1z_xmm_xmmm128b64
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandnpd_xmm_xmm_xmmm128
		} else {
			Code::EVEX_Vandnpd_xmm_k1z_xmm_xmmm128b64
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandnpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	fn vandnpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandnpd_ymm_k1z_ymm_ymmm256b64
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandnpd_ymm_ymm_ymmm256
		} else {
			Code::EVEX_Vandnpd_ymm_k1z_ymm_ymmm256b64
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandnpd<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vandnpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandnpd_zmm_k1z_zmm_zmmm512b64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandnps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vandnps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandnps_xmm_xmm_xmmm128 } else { Code::EVEX_Vandnps_xmm_k1z_xmm_xmmm128b32 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandnps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vandnps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandnps_ymm_ymm_ymmm256 } else { Code::EVEX_Vandnps_ymm_k1z_ymm_ymmm256b32 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandnps<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vandnps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandnps_zmm_k1z_zmm_zmmm512b32, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandnps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn vandnps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandnps_xmm_k1z_xmm_xmmm128b32
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandnps_xmm_xmm_xmmm128
		} else {
			Code::EVEX_Vandnps_xmm_k1z_xmm_xmmm128b32
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandnps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	fn vandnps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandnps_ymm_k1z_ymm_ymmm256b32
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandnps_ymm_ymm_ymmm256
		} else {
			Code::EVEX_Vandnps_ymm_k1z_ymm_ymmm256b32
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandnps<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vandnps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandnps_zmm_k1z_zmm_zmmm512b32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vandpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandpd_xmm_xmm_xmmm128 } else { Code::EVEX_Vandpd_xmm_k1z_xmm_xmmm128b64 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vandpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandpd_ymm_ymm_ymmm256 } else { Code::EVEX_Vandpd_ymm_k1z_ymm_ymmm256b64 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandpd<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vandpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandpd_zmm_k1z_zmm_zmmm512b64, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn vandpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandpd_xmm_k1z_xmm_xmmm128b64
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandpd_xmm_xmm_xmmm128
		} else {
			Code::EVEX_Vandpd_xmm_k1z_xmm_xmmm128b64
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	fn vandpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandpd_ymm_k1z_ymm_ymmm256b64
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandpd_ymm_ymm_ymmm256
		} else {
			Code::EVEX_Vandpd_ymm_k1z_ymm_ymmm256b64
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandpd<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vandpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandpd_zmm_k1z_zmm_zmmm512b64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vandps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandps_xmm_xmm_xmmm128 } else { Code::EVEX_Vandps_xmm_k1z_xmm_xmmm128b32 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vandps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vandps_ymm_ymm_ymmm256 } else { Code::EVEX_Vandps_ymm_k1z_ymm_ymmm256b32 };
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandps<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vandps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandps_zmm_k1z_zmm_zmmm512b32, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVandps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	fn vandps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandps_xmm_k1z_xmm_xmmm128b32
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandps_xmm_xmm_xmmm128
		} else {
			Code::EVEX_Vandps_xmm_k1z_xmm_xmmm128b32
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	fn vandps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if op2.is_broadcast() {
			Code::EVEX_Vandps_ymm_k1z_ymm_ymmm256b32
		} else if self.instruction_prefer_vex() {
			Code::VEX_Vandps_ymm_ymm_ymmm256
		} else {
			Code::EVEX_Vandps_ymm_k1z_ymm_ymmm256b32
		};
		self.add_instr_with_state(Instruction::with3(code, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVandps<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vandps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vandps_zmm_k1z_zmm_zmmm512b32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vblendmpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmpd_xmm_k1z_xmm_xmmm128b64, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vblendmpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmpd_ymm_k1z_ymm_ymmm256b64, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmpd<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vblendmpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmpd_zmm_k1z_zmm_zmmm512b64, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vblendmpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmpd_xmm_k1z_xmm_xmmm128b64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vblendmpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmpd_ymm_k1z_ymm_ymmm256b64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmpd<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vblendmpd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmpd_zmm_k1z_zmm_zmmm512b64, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vblendmps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmps_xmm_k1z_xmm_xmmm128b32, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vblendmps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmps_ymm_k1z_ymm_ymmm256b32, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmps<AsmRegisterZmm, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vblendmps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmps_zmm_k1z_zmm_zmmm512b32, op0.register(), op1.register(), op2.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vblendmps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmps_xmm_k1z_xmm_xmmm128b32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vblendmps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmps_ymm_k1z_ymm_ymmm256b32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVblendmps<AsmRegisterZmm, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vblendmps(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with3(Code::EVEX_Vblendmps_zmm_k1z_zmm_zmmm512b32, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()))?, op0.state().merge(op2.state()))
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, u32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn vblendpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendpd_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: i32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, u32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, u32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.register(), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_xmm_xmm_xmmm128_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, u32> for CodeAssembler {
	#[inline]
	fn vblendps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: u32) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendps_ymm_ymm_ymmm256_imm8, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3)?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vblendvpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvpd_xmm_xmm_xmmm128_xmm, op0.register(), op1.register(), op2.register(), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vblendvpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvpd_xmm_xmm_xmmm128_xmm, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vblendvpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvpd_ymm_ymm_ymmm256_ymm, op0.register(), op1.register(), op2.register(), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vblendvpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvpd_ymm_ymm_ymmm256_ymm, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vblendvps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm, op3: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvps_xmm_xmm_xmmm128_xmm, op0.register(), op1.register(), op2.register(), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vblendvps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand, op3: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvps_xmm_xmm_xmmm128_xmm, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vblendvps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm, op3: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvps_ymm_ymm_ymmm256_ymm, op0.register(), op1.register(), op2.register(), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVblendvps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vblendvps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand, op3: AsmRegisterYmm) -> Result<(), IcedError> {
		self.add_instr(Instruction::with4(Code::VEX_Vblendvps_ymm_ymm_ymmm256_ymm, op0.register(), op1.register(), op2.to_memory_operand(self.bitness()), op3.register())?)
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf128<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf128(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Vbroadcastf128_ymm_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf32x2<AsmRegisterYmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcastf32x2(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf32x2_ymm_k1z_xmmm64, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf32x2<AsmRegisterZmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcastf32x2(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf32x2_zmm_k1z_xmmm64, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf32x2<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf32x2(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf32x2_ymm_k1z_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf32x2<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf32x2(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf32x2_zmm_k1z_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf32x4<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf32x4(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf32x4_ymm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf32x4<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf32x4(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf32x4_zmm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf32x8<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf32x8(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf32x8_zmm_k1z_m256, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf64x2<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf64x2(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf64x2_ymm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf64x2<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf64x2(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf64x2_zmm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastf64x4<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastf64x4(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastf64x4_zmm_k1z_m256, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti128<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti128(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr(Instruction::with2(Code::VEX_Vbroadcasti128_ymm_m128, op0.register(), op1.to_memory_operand(self.bitness()))?)
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x2<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x2(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x2_xmm_k1z_xmmm64, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x2<AsmRegisterYmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x2(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x2_ymm_k1z_xmmm64, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x2<AsmRegisterZmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x2(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x2_zmm_k1z_xmmm64, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x2<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x2(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x2_xmm_k1z_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x2<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x2(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x2_ymm_k1z_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x2<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x2(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x2_zmm_k1z_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x4<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x4(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x4_ymm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x4<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x4(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x4_zmm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti32x8<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti32x8(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti32x8_zmm_k1z_m256, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti64x2<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti64x2(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti64x2_ymm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti64x2<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti64x2(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti64x2_zmm_k1z_m128, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcasti64x4<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcasti64x4(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcasti64x4_zmm_k1z_m256, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastsd<AsmRegisterYmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcastsd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vbroadcastsd_ymm_xmm } else { Code::EVEX_Vbroadcastsd_ymm_k1z_xmmm64 };
		self.add_instr_with_state(Instruction::with2(code, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastsd<AsmRegisterZmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcastsd(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastsd_zmm_k1z_xmmm64, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastsd<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastsd(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vbroadcastsd_ymm_m64 } else { Code::EVEX_Vbroadcastsd_ymm_k1z_xmmm64 };
		self.add_instr_with_state(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastsd<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastsd(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastsd_zmm_k1z_xmmm64, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastss<AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcastss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vbroadcastss_xmm_xmm } else { Code::EVEX_Vbroadcastss_xmm_k1z_xmmm32 };
		self.add_instr_with_state(Instruction::with2(code, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastss<AsmRegisterYmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcastss(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vbroadcastss_ymm_xmm } else { Code::EVEX_Vbroadcastss_ymm_k1z_xmmm32 };
		self.add_instr_with_state(Instruction::with2(code, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastss<AsmRegisterZmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vbroadcastss(&mut self, op0: AsmRegisterZmm, op1: AsmRegisterXmm) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastss_zmm_k1z_xmmm32, op0.register(), op1.register())?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastss<AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastss(&mut self, op0: AsmRegisterXmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vbroadcastss_xmm_m32 } else { Code::EVEX_Vbroadcastss_xmm_k1z_xmmm32 };
		self.add_instr_with_state(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastss<AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastss(&mut self, op0: AsmRegisterYmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		let code = if self.instruction_prefer_vex() { Code::VEX_Vbroadcastss_ymm_m32 } else { Code::EVEX_Vbroadcastss_ymm_k1z_xmmm32 };
		self.add_instr_with_state(Instruction::with2(code, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVbroadcastss<AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vbroadcastss(&mut self, op0: AsmRegisterZmm, op1: AsmMemoryOperand) -> Result<(), IcedError> {
		self.add_instr_with_state(Instruction::with2(Code::EVEX_Vbroadcastss_zmm_k1z_xmmm32, op0.register(), op1.to_memory_operand(self.bitness()))?, op0.state())
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ospd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ossd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ossd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ossd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ossd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ossd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ossd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ossd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ossd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ossh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ossh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsh(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ossh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ossh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsh(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_osss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_osss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_osss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 16)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqpd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqsd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqsd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqsh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsh(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqsh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsh(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uqss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 8)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_uspd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_uspd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ussd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ussd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ussd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ussd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ussd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ussd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ussd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ussd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ussh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_ussh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsh(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_ussh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_ussh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsh(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeq_usss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeq_usss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeq_usss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 24)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqpd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqsd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqsd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqsh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsh(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqsh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsh(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpeqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpeqss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpeqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 0)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ospd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ospd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ossd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ossd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ossd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ossd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ossd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ossd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ossd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ossd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ossh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ossh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsh(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_ossh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_ossh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsh(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalse_osss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalse_osss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 27)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsepd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalseps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalseps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsesd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsesd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsesd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsesd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsesd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsesd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsesd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsesd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsesh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsesh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsh(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsesh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsesh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsh(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsess<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsess(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsess<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpfalsess(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsess<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsess(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpfalsess<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpfalsess(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 11)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqpd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqpd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqps(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpps(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqsd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqsd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqsd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsd(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqsh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpsh(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqsh(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpsh<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpsh(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpge_oqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpss(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqss(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpge_oqss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpge_oqss(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpss<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpss(self, op0, op1, op2, 29)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterXmm, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterYmm, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgepd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgepd(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmppd<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmppd(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpgeph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpph(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpgeph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpph(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm> for CodeAssembler {
	#[inline]
	fn vcmpgeph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmRegisterZmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmRegisterZmm, i32>>::vcmpph(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgeph(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterXmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgeph(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterYmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand> for CodeAssembler {
	#[inline]
	fn vcmpgeph(&mut self, op0: AsmRegisterK, op1: AsmRegisterZmm, op2: AsmMemoryOperand) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpph<AsmRegisterK, AsmRegisterZmm, AsmMemoryOperand, i32>>::vcmpph(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpgeps(&mut self, op0: AsmRegisterK, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm> for CodeAssembler {
	#[inline]
	fn vcmpgeps(&mut self, op0: AsmRegisterXmm, op1: AsmRegisterXmm, op2: AsmRegisterXmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterXmm, AsmRegisterXmm, AsmRegisterXmm, i32>>::vcmpps(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpgeps(&mut self, op0: AsmRegisterK, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<(), IcedError> {
		<Self as CodeAsmVcmpps<AsmRegisterK, AsmRegisterYmm, AsmRegisterYmm, i32>>::vcmpps(self, op0, op1, op2, 13)
	}
}

#[rustfmt::skip]
impl CodeAsmVcmpgeps<AsmRegisterYmm, AsmRegisterYmm, AsmRegisterYmm> for CodeAssembler {
	#[inline]
	fn vcmpgeps(&mut self, op0: AsmRegisterYmm, op1: AsmRegisterYmm, op2: AsmRegisterYmm) -> Result<()