// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::iced_constants::IcedConstants;
use crate::iced_error::IcedError;
#[cfg(feature = "instr_info")]
use crate::info::enums::*;
use crate::mnemonics;
use crate::*;
use core::convert::TryFrom;
use core::iter::{ExactSizeIterator, FusedIterator, Iterator};
use core::{fmt, mem};
#[cfg(any(feature = "instr_info", feature = "encoder"))]
use static_assertions::const_assert_eq;

// GENERATOR-BEGIN: Code
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// x86 instruction code
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[cfg_attr(not(feature = "exhaustive_enums"), non_exhaustive)]
#[allow(non_camel_case_types)]
pub enum Code {
	/// It's an invalid instruction, eg. it's a new unknown instruction, garbage or there's not enough bytes to decode the instruction etc.
	INVALID = 0,
	/// A `db`/`.byte` asm directive that can store 1-16 bytes
	DeclareByte = 1,
	/// A `dw`/`.word` asm directive that can store 1-8 words
	DeclareWord = 2,
	/// A `dd`/`.int` asm directive that can store 1-4 dwords
	DeclareDword = 3,
	/// A `dq`/`.quad` asm directive that can store 1-2 qwords
	DeclareQword = 4,
	/// `ADD r/m8, r8`
	///
	/// `00 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_rm8_r8 = 5,
	/// `ADD r/m16, r16`
	///
	/// `o16 01 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_rm16_r16 = 6,
	/// `ADD r/m32, r32`
	///
	/// `o32 01 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Add_rm32_r32 = 7,
	/// `ADD r/m64, r64`
	///
	/// `o64 01 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Add_rm64_r64 = 8,
	/// `ADD r8, r/m8`
	///
	/// `02 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_r8_rm8 = 9,
	/// `ADD r16, r/m16`
	///
	/// `o16 03 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_r16_rm16 = 10,
	/// `ADD r32, r/m32`
	///
	/// `o32 03 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Add_r32_rm32 = 11,
	/// `ADD r64, r/m64`
	///
	/// `o64 03 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Add_r64_rm64 = 12,
	/// `ADD AL, imm8`
	///
	/// `04 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_AL_imm8 = 13,
	/// `ADD AX, imm16`
	///
	/// `o16 05 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_AX_imm16 = 14,
	/// `ADD EAX, imm32`
	///
	/// `o32 05 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Add_EAX_imm32 = 15,
	/// `ADD RAX, imm32`
	///
	/// `o64 05 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Add_RAX_imm32 = 16,
	/// `PUSH ES`
	///
	/// `o16 06`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Pushw_ES = 17,
	/// `PUSH ES`
	///
	/// `o32 06`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_ES = 18,
	/// `POP ES`
	///
	/// `o16 07`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Popw_ES = 19,
	/// `POP ES`
	///
	/// `o32 07`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Popd_ES = 20,
	/// `OR r/m8, r8`
	///
	/// `08 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_rm8_r8 = 21,
	/// `OR r/m16, r16`
	///
	/// `o16 09 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_rm16_r16 = 22,
	/// `OR r/m32, r32`
	///
	/// `o32 09 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Or_rm32_r32 = 23,
	/// `OR r/m64, r64`
	///
	/// `o64 09 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Or_rm64_r64 = 24,
	/// `OR r8, r/m8`
	///
	/// `0A /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_r8_rm8 = 25,
	/// `OR r16, r/m16`
	///
	/// `o16 0B /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_r16_rm16 = 26,
	/// `OR r32, r/m32`
	///
	/// `o32 0B /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Or_r32_rm32 = 27,
	/// `OR r64, r/m64`
	///
	/// `o64 0B /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Or_r64_rm64 = 28,
	/// `OR AL, imm8`
	///
	/// `0C ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_AL_imm8 = 29,
	/// `OR AX, imm16`
	///
	/// `o16 0D iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_AX_imm16 = 30,
	/// `OR EAX, imm32`
	///
	/// `o32 0D id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Or_EAX_imm32 = 31,
	/// `OR RAX, imm32`
	///
	/// `o64 0D id`
	///
	/// `X64`
	///
	/// `64-bit`
	Or_RAX_imm32 = 32,
	/// `PUSH CS`
	///
	/// `o16 0E`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Pushw_CS = 33,
	/// `PUSH CS`
	///
	/// `o32 0E`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_CS = 34,
	/// `POP CS`
	///
	/// `o16 0F`
	///
	/// `8086`
	///
	/// `16-bit`
	Popw_CS = 35,
	/// `ADC r/m8, r8`
	///
	/// `10 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_rm8_r8 = 36,
	/// `ADC r/m16, r16`
	///
	/// `o16 11 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_rm16_r16 = 37,
	/// `ADC r/m32, r32`
	///
	/// `o32 11 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Adc_rm32_r32 = 38,
	/// `ADC r/m64, r64`
	///
	/// `o64 11 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Adc_rm64_r64 = 39,
	/// `ADC r8, r/m8`
	///
	/// `12 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_r8_rm8 = 40,
	/// `ADC r16, r/m16`
	///
	/// `o16 13 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_r16_rm16 = 41,
	/// `ADC r32, r/m32`
	///
	/// `o32 13 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Adc_r32_rm32 = 42,
	/// `ADC r64, r/m64`
	///
	/// `o64 13 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Adc_r64_rm64 = 43,
	/// `ADC AL, imm8`
	///
	/// `14 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_AL_imm8 = 44,
	/// `ADC AX, imm16`
	///
	/// `o16 15 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_AX_imm16 = 45,
	/// `ADC EAX, imm32`
	///
	/// `o32 15 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Adc_EAX_imm32 = 46,
	/// `ADC RAX, imm32`
	///
	/// `o64 15 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Adc_RAX_imm32 = 47,
	/// `PUSH SS`
	///
	/// `o16 16`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Pushw_SS = 48,
	/// `PUSH SS`
	///
	/// `o32 16`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_SS = 49,
	/// `POP SS`
	///
	/// `o16 17`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Popw_SS = 50,
	/// `POP SS`
	///
	/// `o32 17`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Popd_SS = 51,
	/// `SBB r/m8, r8`
	///
	/// `18 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_rm8_r8 = 52,
	/// `SBB r/m16, r16`
	///
	/// `o16 19 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_rm16_r16 = 53,
	/// `SBB r/m32, r32`
	///
	/// `o32 19 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sbb_rm32_r32 = 54,
	/// `SBB r/m64, r64`
	///
	/// `o64 19 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Sbb_rm64_r64 = 55,
	/// `SBB r8, r/m8`
	///
	/// `1A /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_r8_rm8 = 56,
	/// `SBB r16, r/m16`
	///
	/// `o16 1B /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_r16_rm16 = 57,
	/// `SBB r32, r/m32`
	///
	/// `o32 1B /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sbb_r32_rm32 = 58,
	/// `SBB r64, r/m64`
	///
	/// `o64 1B /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Sbb_r64_rm64 = 59,
	/// `SBB AL, imm8`
	///
	/// `1C ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_AL_imm8 = 60,
	/// `SBB AX, imm16`
	///
	/// `o16 1D iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_AX_imm16 = 61,
	/// `SBB EAX, imm32`
	///
	/// `o32 1D id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sbb_EAX_imm32 = 62,
	/// `SBB RAX, imm32`
	///
	/// `o64 1D id`
	///
	/// `X64`
	///
	/// `64-bit`
	Sbb_RAX_imm32 = 63,
	/// `PUSH DS`
	///
	/// `o16 1E`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Pushw_DS = 64,
	/// `PUSH DS`
	///
	/// `o32 1E`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_DS = 65,
	/// `POP DS`
	///
	/// `o16 1F`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Popw_DS = 66,
	/// `POP DS`
	///
	/// `o32 1F`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Popd_DS = 67,
	/// `AND r/m8, r8`
	///
	/// `20 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_rm8_r8 = 68,
	/// `AND r/m16, r16`
	///
	/// `o16 21 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_rm16_r16 = 69,
	/// `AND r/m32, r32`
	///
	/// `o32 21 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	And_rm32_r32 = 70,
	/// `AND r/m64, r64`
	///
	/// `o64 21 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	And_rm64_r64 = 71,
	/// `AND r8, r/m8`
	///
	/// `22 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_r8_rm8 = 72,
	/// `AND r16, r/m16`
	///
	/// `o16 23 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_r16_rm16 = 73,
	/// `AND r32, r/m32`
	///
	/// `o32 23 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	And_r32_rm32 = 74,
	/// `AND r64, r/m64`
	///
	/// `o64 23 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	And_r64_rm64 = 75,
	/// `AND AL, imm8`
	///
	/// `24 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_AL_imm8 = 76,
	/// `AND AX, imm16`
	///
	/// `o16 25 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_AX_imm16 = 77,
	/// `AND EAX, imm32`
	///
	/// `o32 25 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	And_EAX_imm32 = 78,
	/// `AND RAX, imm32`
	///
	/// `o64 25 id`
	///
	/// `X64`
	///
	/// `64-bit`
	And_RAX_imm32 = 79,
	/// `DAA`
	///
	/// `27`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Daa = 80,
	/// `SUB r/m8, r8`
	///
	/// `28 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_rm8_r8 = 81,
	/// `SUB r/m16, r16`
	///
	/// `o16 29 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_rm16_r16 = 82,
	/// `SUB r/m32, r32`
	///
	/// `o32 29 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sub_rm32_r32 = 83,
	/// `SUB r/m64, r64`
	///
	/// `o64 29 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Sub_rm64_r64 = 84,
	/// `SUB r8, r/m8`
	///
	/// `2A /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_r8_rm8 = 85,
	/// `SUB r16, r/m16`
	///
	/// `o16 2B /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_r16_rm16 = 86,
	/// `SUB r32, r/m32`
	///
	/// `o32 2B /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sub_r32_rm32 = 87,
	/// `SUB r64, r/m64`
	///
	/// `o64 2B /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Sub_r64_rm64 = 88,
	/// `SUB AL, imm8`
	///
	/// `2C ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_AL_imm8 = 89,
	/// `SUB AX, imm16`
	///
	/// `o16 2D iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_AX_imm16 = 90,
	/// `SUB EAX, imm32`
	///
	/// `o32 2D id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sub_EAX_imm32 = 91,
	/// `SUB RAX, imm32`
	///
	/// `o64 2D id`
	///
	/// `X64`
	///
	/// `64-bit`
	Sub_RAX_imm32 = 92,
	/// `DAS`
	///
	/// `2F`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Das = 93,
	/// `XOR r/m8, r8`
	///
	/// `30 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_rm8_r8 = 94,
	/// `XOR r/m16, r16`
	///
	/// `o16 31 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_rm16_r16 = 95,
	/// `XOR r/m32, r32`
	///
	/// `o32 31 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Xor_rm32_r32 = 96,
	/// `XOR r/m64, r64`
	///
	/// `o64 31 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Xor_rm64_r64 = 97,
	/// `XOR r8, r/m8`
	///
	/// `32 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_r8_rm8 = 98,
	/// `XOR r16, r/m16`
	///
	/// `o16 33 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_r16_rm16 = 99,
	/// `XOR r32, r/m32`
	///
	/// `o32 33 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Xor_r32_rm32 = 100,
	/// `XOR r64, r/m64`
	///
	/// `o64 33 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Xor_r64_rm64 = 101,
	/// `XOR AL, imm8`
	///
	/// `34 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_AL_imm8 = 102,
	/// `XOR AX, imm16`
	///
	/// `o16 35 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_AX_imm16 = 103,
	/// `XOR EAX, imm32`
	///
	/// `o32 35 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Xor_EAX_imm32 = 104,
	/// `XOR RAX, imm32`
	///
	/// `o64 35 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Xor_RAX_imm32 = 105,
	/// `AAA`
	///
	/// `37`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Aaa = 106,
	/// `CMP r/m8, r8`
	///
	/// `38 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_rm8_r8 = 107,
	/// `CMP r/m16, r16`
	///
	/// `o16 39 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_rm16_r16 = 108,
	/// `CMP r/m32, r32`
	///
	/// `o32 39 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cmp_rm32_r32 = 109,
	/// `CMP r/m64, r64`
	///
	/// `o64 39 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Cmp_rm64_r64 = 110,
	/// `CMP r8, r/m8`
	///
	/// `3A /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_r8_rm8 = 111,
	/// `CMP r16, r/m16`
	///
	/// `o16 3B /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_r16_rm16 = 112,
	/// `CMP r32, r/m32`
	///
	/// `o32 3B /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cmp_r32_rm32 = 113,
	/// `CMP r64, r/m64`
	///
	/// `o64 3B /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Cmp_r64_rm64 = 114,
	/// `CMP AL, imm8`
	///
	/// `3C ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_AL_imm8 = 115,
	/// `CMP AX, imm16`
	///
	/// `o16 3D iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_AX_imm16 = 116,
	/// `CMP EAX, imm32`
	///
	/// `o32 3D id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cmp_EAX_imm32 = 117,
	/// `CMP RAX, imm32`
	///
	/// `o64 3D id`
	///
	/// `X64`
	///
	/// `64-bit`
	Cmp_RAX_imm32 = 118,
	/// `AAS`
	///
	/// `3F`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Aas = 119,
	/// `INC r16`
	///
	/// `o16 40+rw`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Inc_r16 = 120,
	/// `INC r32`
	///
	/// `o32 40+rd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Inc_r32 = 121,
	/// `DEC r16`
	///
	/// `o16 48+rw`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Dec_r16 = 122,
	/// `DEC r32`
	///
	/// `o32 48+rd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Dec_r32 = 123,
	/// `PUSH r16`
	///
	/// `o16 50+rw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Push_r16 = 124,
	/// `PUSH r32`
	///
	/// `o32 50+rd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Push_r32 = 125,
	/// `PUSH r64`
	///
	/// `o64 50+ro`
	///
	/// `X64`
	///
	/// `64-bit`
	Push_r64 = 126,
	/// `POP r16`
	///
	/// `o16 58+rw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Pop_r16 = 127,
	/// `POP r32`
	///
	/// `o32 58+rd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pop_r32 = 128,
	/// `POP r64`
	///
	/// `o64 58+ro`
	///
	/// `X64`
	///
	/// `64-bit`
	Pop_r64 = 129,
	/// `PUSHA`
	///
	/// `o16 60`
	///
	/// `186+`
	///
	/// `16/32-bit`
	Pushaw = 130,
	/// `PUSHAD`
	///
	/// `o32 60`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushad = 131,
	/// `POPA`
	///
	/// `o16 61`
	///
	/// `186+`
	///
	/// `16/32-bit`
	Popaw = 132,
	/// `POPAD`
	///
	/// `o32 61`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Popad = 133,
	/// `BOUND r16, m16&16`
	///
	/// `o16 62 /r`
	///
	/// `186+`
	///
	/// `16/32-bit`
	Bound_r16_m1616 = 134,
	/// `BOUND r32, m32&32`
	///
	/// `o32 62 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Bound_r32_m3232 = 135,
	/// `ARPL r/m16, r16`
	///
	/// `o16 63 /r`
	///
	/// `286+`
	///
	/// `16/32-bit`
	Arpl_rm16_r16 = 136,
	/// `ARPL r32/m16, r32`
	///
	/// `o32 63 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Arpl_r32m16_r32 = 137,
	/// `MOVSXD r16, r/m16`
	///
	/// `o16 63 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Movsxd_r16_rm16 = 138,
	/// `MOVSXD r32, r/m32`
	///
	/// `o32 63 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Movsxd_r32_rm32 = 139,
	/// `MOVSXD r64, r/m32`
	///
	/// `o64 63 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Movsxd_r64_rm32 = 140,
	/// `PUSH imm16`
	///
	/// `o16 68 iw`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Push_imm16 = 141,
	/// `PUSH imm32`
	///
	/// `o32 68 id`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_imm32 = 142,
	/// `PUSH imm32`
	///
	/// `o64 68 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Pushq_imm32 = 143,
	/// `IMUL r16, r/m16, imm16`
	///
	/// `o16 69 /r iw`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Imul_r16_rm16_imm16 = 144,
	/// `IMUL r32, r/m32, imm32`
	///
	/// `o32 69 /r id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Imul_r32_rm32_imm32 = 145,
	/// `IMUL r64, r/m64, imm32`
	///
	/// `o64 69 /r id`
	///
	/// `X64`
	///
	/// `64-bit`
	Imul_r64_rm64_imm32 = 146,
	/// `PUSH imm8`
	///
	/// `o16 6A ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Pushw_imm8 = 147,
	/// `PUSH imm8`
	///
	/// `o32 6A ib`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_imm8 = 148,
	/// `PUSH imm8`
	///
	/// `o64 6A ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Pushq_imm8 = 149,
	/// `IMUL r16, r/m16, imm8`
	///
	/// `o16 6B /r ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Imul_r16_rm16_imm8 = 150,
	/// `IMUL r32, r/m32, imm8`
	///
	/// `o32 6B /r ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Imul_r32_rm32_imm8 = 151,
	/// `IMUL r64, r/m64, imm8`
	///
	/// `o64 6B /r ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Imul_r64_rm64_imm8 = 152,
	/// `INSB`
	///
	/// `6C`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Insb_m8_DX = 153,
	/// `INSW`
	///
	/// `o16 6D`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Insw_m16_DX = 154,
	/// `INSD`
	///
	/// `o32 6D`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Insd_m32_DX = 155,
	/// `OUTSB`
	///
	/// `6E`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Outsb_DX_m8 = 156,
	/// `OUTSW`
	///
	/// `o16 6F`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Outsw_DX_m16 = 157,
	/// `OUTSD`
	///
	/// `o32 6F`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Outsd_DX_m32 = 158,
	/// `JO rel8`
	///
	/// `o16 70 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jo_rel8_16 = 159,
	/// `JO rel8`
	///
	/// `o32 70 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jo_rel8_32 = 160,
	/// `JO rel8`
	///
	/// `o64 70 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jo_rel8_64 = 161,
	/// `JNO rel8`
	///
	/// `o16 71 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jno_rel8_16 = 162,
	/// `JNO rel8`
	///
	/// `o32 71 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jno_rel8_32 = 163,
	/// `JNO rel8`
	///
	/// `o64 71 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jno_rel8_64 = 164,
	/// `JB rel8`
	///
	/// `o16 72 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jb_rel8_16 = 165,
	/// `JB rel8`
	///
	/// `o32 72 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jb_rel8_32 = 166,
	/// `JB rel8`
	///
	/// `o64 72 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jb_rel8_64 = 167,
	/// `JAE rel8`
	///
	/// `o16 73 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jae_rel8_16 = 168,
	/// `JAE rel8`
	///
	/// `o32 73 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jae_rel8_32 = 169,
	/// `JAE rel8`
	///
	/// `o64 73 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jae_rel8_64 = 170,
	/// `JE rel8`
	///
	/// `o16 74 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Je_rel8_16 = 171,
	/// `JE rel8`
	///
	/// `o32 74 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Je_rel8_32 = 172,
	/// `JE rel8`
	///
	/// `o64 74 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Je_rel8_64 = 173,
	/// `JNE rel8`
	///
	/// `o16 75 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jne_rel8_16 = 174,
	/// `JNE rel8`
	///
	/// `o32 75 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jne_rel8_32 = 175,
	/// `JNE rel8`
	///
	/// `o64 75 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jne_rel8_64 = 176,
	/// `JBE rel8`
	///
	/// `o16 76 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jbe_rel8_16 = 177,
	/// `JBE rel8`
	///
	/// `o32 76 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jbe_rel8_32 = 178,
	/// `JBE rel8`
	///
	/// `o64 76 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jbe_rel8_64 = 179,
	/// `JA rel8`
	///
	/// `o16 77 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Ja_rel8_16 = 180,
	/// `JA rel8`
	///
	/// `o32 77 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Ja_rel8_32 = 181,
	/// `JA rel8`
	///
	/// `o64 77 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Ja_rel8_64 = 182,
	/// `JS rel8`
	///
	/// `o16 78 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Js_rel8_16 = 183,
	/// `JS rel8`
	///
	/// `o32 78 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Js_rel8_32 = 184,
	/// `JS rel8`
	///
	/// `o64 78 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Js_rel8_64 = 185,
	/// `JNS rel8`
	///
	/// `o16 79 cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jns_rel8_16 = 186,
	/// `JNS rel8`
	///
	/// `o32 79 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jns_rel8_32 = 187,
	/// `JNS rel8`
	///
	/// `o64 79 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jns_rel8_64 = 188,
	/// `JP rel8`
	///
	/// `o16 7A cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jp_rel8_16 = 189,
	/// `JP rel8`
	///
	/// `o32 7A cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jp_rel8_32 = 190,
	/// `JP rel8`
	///
	/// `o64 7A cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jp_rel8_64 = 191,
	/// `JNP rel8`
	///
	/// `o16 7B cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jnp_rel8_16 = 192,
	/// `JNP rel8`
	///
	/// `o32 7B cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jnp_rel8_32 = 193,
	/// `JNP rel8`
	///
	/// `o64 7B cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jnp_rel8_64 = 194,
	/// `JL rel8`
	///
	/// `o16 7C cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jl_rel8_16 = 195,
	/// `JL rel8`
	///
	/// `o32 7C cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jl_rel8_32 = 196,
	/// `JL rel8`
	///
	/// `o64 7C cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jl_rel8_64 = 197,
	/// `JGE rel8`
	///
	/// `o16 7D cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jge_rel8_16 = 198,
	/// `JGE rel8`
	///
	/// `o32 7D cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jge_rel8_32 = 199,
	/// `JGE rel8`
	///
	/// `o64 7D cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jge_rel8_64 = 200,
	/// `JLE rel8`
	///
	/// `o16 7E cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jle_rel8_16 = 201,
	/// `JLE rel8`
	///
	/// `o32 7E cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jle_rel8_32 = 202,
	/// `JLE rel8`
	///
	/// `o64 7E cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jle_rel8_64 = 203,
	/// `JG rel8`
	///
	/// `o16 7F cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jg_rel8_16 = 204,
	/// `JG rel8`
	///
	/// `o32 7F cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jg_rel8_32 = 205,
	/// `JG rel8`
	///
	/// `o64 7F cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jg_rel8_64 = 206,
	/// `ADD r/m8, imm8`
	///
	/// `80 /0 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_rm8_imm8 = 207,
	/// `OR r/m8, imm8`
	///
	/// `80 /1 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_rm8_imm8 = 208,
	/// `ADC r/m8, imm8`
	///
	/// `80 /2 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_rm8_imm8 = 209,
	/// `SBB r/m8, imm8`
	///
	/// `80 /3 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_rm8_imm8 = 210,
	/// `AND r/m8, imm8`
	///
	/// `80 /4 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_rm8_imm8 = 211,
	/// `SUB r/m8, imm8`
	///
	/// `80 /5 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_rm8_imm8 = 212,
	/// `XOR r/m8, imm8`
	///
	/// `80 /6 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_rm8_imm8 = 213,
	/// `CMP r/m8, imm8`
	///
	/// `80 /7 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_rm8_imm8 = 214,
	/// `ADD r/m16, imm16`
	///
	/// `o16 81 /0 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_rm16_imm16 = 215,
	/// `ADD r/m32, imm32`
	///
	/// `o32 81 /0 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Add_rm32_imm32 = 216,
	/// `ADD r/m64, imm32`
	///
	/// `o64 81 /0 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Add_rm64_imm32 = 217,
	/// `OR r/m16, imm16`
	///
	/// `o16 81 /1 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_rm16_imm16 = 218,
	/// `OR r/m32, imm32`
	///
	/// `o32 81 /1 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Or_rm32_imm32 = 219,
	/// `OR r/m64, imm32`
	///
	/// `o64 81 /1 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Or_rm64_imm32 = 220,
	/// `ADC r/m16, imm16`
	///
	/// `o16 81 /2 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_rm16_imm16 = 221,
	/// `ADC r/m32, imm32`
	///
	/// `o32 81 /2 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Adc_rm32_imm32 = 222,
	/// `ADC r/m64, imm32`
	///
	/// `o64 81 /2 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Adc_rm64_imm32 = 223,
	/// `SBB r/m16, imm16`
	///
	/// `o16 81 /3 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_rm16_imm16 = 224,
	/// `SBB r/m32, imm32`
	///
	/// `o32 81 /3 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sbb_rm32_imm32 = 225,
	/// `SBB r/m64, imm32`
	///
	/// `o64 81 /3 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Sbb_rm64_imm32 = 226,
	/// `AND r/m16, imm16`
	///
	/// `o16 81 /4 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_rm16_imm16 = 227,
	/// `AND r/m32, imm32`
	///
	/// `o32 81 /4 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	And_rm32_imm32 = 228,
	/// `AND r/m64, imm32`
	///
	/// `o64 81 /4 id`
	///
	/// `X64`
	///
	/// `64-bit`
	And_rm64_imm32 = 229,
	/// `SUB r/m16, imm16`
	///
	/// `o16 81 /5 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_rm16_imm16 = 230,
	/// `SUB r/m32, imm32`
	///
	/// `o32 81 /5 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sub_rm32_imm32 = 231,
	/// `SUB r/m64, imm32`
	///
	/// `o64 81 /5 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Sub_rm64_imm32 = 232,
	/// `XOR r/m16, imm16`
	///
	/// `o16 81 /6 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_rm16_imm16 = 233,
	/// `XOR r/m32, imm32`
	///
	/// `o32 81 /6 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Xor_rm32_imm32 = 234,
	/// `XOR r/m64, imm32`
	///
	/// `o64 81 /6 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Xor_rm64_imm32 = 235,
	/// `CMP r/m16, imm16`
	///
	/// `o16 81 /7 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_rm16_imm16 = 236,
	/// `CMP r/m32, imm32`
	///
	/// `o32 81 /7 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cmp_rm32_imm32 = 237,
	/// `CMP r/m64, imm32`
	///
	/// `o64 81 /7 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Cmp_rm64_imm32 = 238,
	/// `ADD r/m8, imm8`
	///
	/// `82 /0 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Add_rm8_imm8_82 = 239,
	/// `OR r/m8, imm8`
	///
	/// `82 /1 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Or_rm8_imm8_82 = 240,
	/// `ADC r/m8, imm8`
	///
	/// `82 /2 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Adc_rm8_imm8_82 = 241,
	/// `SBB r/m8, imm8`
	///
	/// `82 /3 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Sbb_rm8_imm8_82 = 242,
	/// `AND r/m8, imm8`
	///
	/// `82 /4 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	And_rm8_imm8_82 = 243,
	/// `SUB r/m8, imm8`
	///
	/// `82 /5 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Sub_rm8_imm8_82 = 244,
	/// `XOR r/m8, imm8`
	///
	/// `82 /6 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Xor_rm8_imm8_82 = 245,
	/// `CMP r/m8, imm8`
	///
	/// `82 /7 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Cmp_rm8_imm8_82 = 246,
	/// `ADD r/m16, imm8`
	///
	/// `o16 83 /0 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Add_rm16_imm8 = 247,
	/// `ADD r/m32, imm8`
	///
	/// `o32 83 /0 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Add_rm32_imm8 = 248,
	/// `ADD r/m64, imm8`
	///
	/// `o64 83 /0 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Add_rm64_imm8 = 249,
	/// `OR r/m16, imm8`
	///
	/// `o16 83 /1 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Or_rm16_imm8 = 250,
	/// `OR r/m32, imm8`
	///
	/// `o32 83 /1 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Or_rm32_imm8 = 251,
	/// `OR r/m64, imm8`
	///
	/// `o64 83 /1 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Or_rm64_imm8 = 252,
	/// `ADC r/m16, imm8`
	///
	/// `o16 83 /2 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Adc_rm16_imm8 = 253,
	/// `ADC r/m32, imm8`
	///
	/// `o32 83 /2 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Adc_rm32_imm8 = 254,
	/// `ADC r/m64, imm8`
	///
	/// `o64 83 /2 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Adc_rm64_imm8 = 255,
	/// `SBB r/m16, imm8`
	///
	/// `o16 83 /3 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sbb_rm16_imm8 = 256,
	/// `SBB r/m32, imm8`
	///
	/// `o32 83 /3 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sbb_rm32_imm8 = 257,
	/// `SBB r/m64, imm8`
	///
	/// `o64 83 /3 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Sbb_rm64_imm8 = 258,
	/// `AND r/m16, imm8`
	///
	/// `o16 83 /4 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	And_rm16_imm8 = 259,
	/// `AND r/m32, imm8`
	///
	/// `o32 83 /4 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	And_rm32_imm8 = 260,
	/// `AND r/m64, imm8`
	///
	/// `o64 83 /4 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	And_rm64_imm8 = 261,
	/// `SUB r/m16, imm8`
	///
	/// `o16 83 /5 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sub_rm16_imm8 = 262,
	/// `SUB r/m32, imm8`
	///
	/// `o32 83 /5 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sub_rm32_imm8 = 263,
	/// `SUB r/m64, imm8`
	///
	/// `o64 83 /5 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Sub_rm64_imm8 = 264,
	/// `XOR r/m16, imm8`
	///
	/// `o16 83 /6 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xor_rm16_imm8 = 265,
	/// `XOR r/m32, imm8`
	///
	/// `o32 83 /6 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Xor_rm32_imm8 = 266,
	/// `XOR r/m64, imm8`
	///
	/// `o64 83 /6 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Xor_rm64_imm8 = 267,
	/// `CMP r/m16, imm8`
	///
	/// `o16 83 /7 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmp_rm16_imm8 = 268,
	/// `CMP r/m32, imm8`
	///
	/// `o32 83 /7 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cmp_rm32_imm8 = 269,
	/// `CMP r/m64, imm8`
	///
	/// `o64 83 /7 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Cmp_rm64_imm8 = 270,
	/// `TEST r/m8, r8`
	///
	/// `84 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_rm8_r8 = 271,
	/// `TEST r/m16, r16`
	///
	/// `o16 85 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_rm16_r16 = 272,
	/// `TEST r/m32, r32`
	///
	/// `o32 85 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Test_rm32_r32 = 273,
	/// `TEST r/m64, r64`
	///
	/// `o64 85 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Test_rm64_r64 = 274,
	/// `XCHG r/m8, r8`
	///
	/// `86 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xchg_rm8_r8 = 275,
	/// `XCHG r/m16, r16`
	///
	/// `o16 87 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xchg_rm16_r16 = 276,
	/// `XCHG r/m32, r32`
	///
	/// `o32 87 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Xchg_rm32_r32 = 277,
	/// `XCHG r/m64, r64`
	///
	/// `o64 87 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Xchg_rm64_r64 = 278,
	/// `MOV r/m8, r8`
	///
	/// `88 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_rm8_r8 = 279,
	/// `MOV r/m16, r16`
	///
	/// `o16 89 /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_rm16_r16 = 280,
	/// `MOV r/m32, r32`
	///
	/// `o32 89 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_rm32_r32 = 281,
	/// `MOV r/m64, r64`
	///
	/// `o64 89 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_rm64_r64 = 282,
	/// `MOV r8, r/m8`
	///
	/// `8A /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_r8_rm8 = 283,
	/// `MOV r16, r/m16`
	///
	/// `o16 8B /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_r16_rm16 = 284,
	/// `MOV r32, r/m32`
	///
	/// `o32 8B /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_r32_rm32 = 285,
	/// `MOV r64, r/m64`
	///
	/// `o64 8B /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_r64_rm64 = 286,
	/// `MOV r/m16, Sreg`
	///
	/// `o16 8C /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_rm16_Sreg = 287,
	/// `MOV r32/m16, Sreg`
	///
	/// `o32 8C /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_r32m16_Sreg = 288,
	/// `MOV r64/m16, Sreg`
	///
	/// `o64 8C /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_r64m16_Sreg = 289,
	/// `LEA r16, m`
	///
	/// `o16 8D /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Lea_r16_m = 290,
	/// `LEA r32, m`
	///
	/// `o32 8D /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lea_r32_m = 291,
	/// `LEA r64, m`
	///
	/// `o64 8D /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Lea_r64_m = 292,
	/// `MOV Sreg, r/m16`
	///
	/// `o16 8E /r`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_Sreg_rm16 = 293,
	/// `MOV Sreg, r32/m16`
	///
	/// `o32 8E /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_Sreg_r32m16 = 294,
	/// `MOV Sreg, r64/m16`
	///
	/// `o64 8E /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_Sreg_r64m16 = 295,
	/// `POP r/m16`
	///
	/// `o16 8F /0`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Pop_rm16 = 296,
	/// `POP r/m32`
	///
	/// `o32 8F /0`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pop_rm32 = 297,
	/// `POP r/m64`
	///
	/// `o64 8F /0`
	///
	/// `X64`
	///
	/// `64-bit`
	Pop_rm64 = 298,
	/// `NOP`
	///
	/// `o16 90`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Nopw = 299,
	/// `NOP`
	///
	/// `o32 90`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Nopd = 300,
	/// `NOP`
	///
	/// `o64 90`
	///
	/// `8086+`
	///
	/// `64-bit`
	Nopq = 301,
	/// `XCHG r16, AX`
	///
	/// `o16 90+rw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xchg_r16_AX = 302,
	/// `XCHG r32, EAX`
	///
	/// `o32 90+rd`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Xchg_r32_EAX = 303,
	/// `XCHG r64, RAX`
	///
	/// `o64 90+ro`
	///
	/// `X64`
	///
	/// `64-bit`
	Xchg_r64_RAX = 304,
	/// `PAUSE`
	///
	/// `F3 90`
	///
	/// `Pentium 4 or later`
	///
	/// `16/32/64-bit`
	Pause = 305,
	/// `CBW`
	///
	/// `o16 98`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cbw = 306,
	/// `CWDE`
	///
	/// `o32 98`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cwde = 307,
	/// `CDQE`
	///
	/// `o64 98`
	///
	/// `X64`
	///
	/// `64-bit`
	Cdqe = 308,
	/// `CWD`
	///
	/// `o16 99`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cwd = 309,
	/// `CDQ`
	///
	/// `o32 99`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cdq = 310,
	/// `CQO`
	///
	/// `o64 99`
	///
	/// `X64`
	///
	/// `64-bit`
	Cqo = 311,
	/// `CALL ptr16:16`
	///
	/// `o16 9A cd`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Call_ptr1616 = 312,
	/// `CALL ptr16:32`
	///
	/// `o32 9A cp`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Call_ptr1632 = 313,
	/// `WAIT`
	///
	/// `9B`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Wait = 314,
	/// `PUSHF`
	///
	/// `o16 9C`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Pushfw = 315,
	/// `PUSHFD`
	///
	/// `o32 9C`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushfd = 316,
	/// `PUSHFQ`
	///
	/// `o64 9C`
	///
	/// `X64`
	///
	/// `64-bit`
	Pushfq = 317,
	/// `POPF`
	///
	/// `o16 9D`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Popfw = 318,
	/// `POPFD`
	///
	/// `o32 9D`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Popfd = 319,
	/// `POPFQ`
	///
	/// `o64 9D`
	///
	/// `X64`
	///
	/// `64-bit`
	Popfq = 320,
	/// `SAHF`
	///
	/// `9E`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sahf = 321,
	/// `LAHF`
	///
	/// `9F`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Lahf = 322,
	/// `MOV AL, moffs8`
	///
	/// `A0 mo`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_AL_moffs8 = 323,
	/// `MOV AX, moffs16`
	///
	/// `o16 A1 mo`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_AX_moffs16 = 324,
	/// `MOV EAX, moffs32`
	///
	/// `o32 A1 mo`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_EAX_moffs32 = 325,
	/// `MOV RAX, moffs64`
	///
	/// `o64 A1 mo`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_RAX_moffs64 = 326,
	/// `MOV moffs8, AL`
	///
	/// `A2 mo`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_moffs8_AL = 327,
	/// `MOV moffs16, AX`
	///
	/// `o16 A3 mo`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_moffs16_AX = 328,
	/// `MOV moffs32, EAX`
	///
	/// `o32 A3 mo`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_moffs32_EAX = 329,
	/// `MOV moffs64, RAX`
	///
	/// `o64 A3 mo`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_moffs64_RAX = 330,
	/// `MOVSB`
	///
	/// `A4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Movsb_m8_m8 = 331,
	/// `MOVSW`
	///
	/// `o16 A5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Movsw_m16_m16 = 332,
	/// `MOVSD`
	///
	/// `o32 A5`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movsd_m32_m32 = 333,
	/// `MOVSQ`
	///
	/// `o64 A5`
	///
	/// `X64`
	///
	/// `64-bit`
	Movsq_m64_m64 = 334,
	/// `CMPSB`
	///
	/// `A6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmpsb_m8_m8 = 335,
	/// `CMPSW`
	///
	/// `o16 A7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmpsw_m16_m16 = 336,
	/// `CMPSD`
	///
	/// `o32 A7`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Cmpsd_m32_m32 = 337,
	/// `CMPSQ`
	///
	/// `o64 A7`
	///
	/// `X64`
	///
	/// `64-bit`
	Cmpsq_m64_m64 = 338,
	/// `TEST AL, imm8`
	///
	/// `A8 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_AL_imm8 = 339,
	/// `TEST AX, imm16`
	///
	/// `o16 A9 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_AX_imm16 = 340,
	/// `TEST EAX, imm32`
	///
	/// `o32 A9 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Test_EAX_imm32 = 341,
	/// `TEST RAX, imm32`
	///
	/// `o64 A9 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Test_RAX_imm32 = 342,
	/// `STOSB`
	///
	/// `AA`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Stosb_m8_AL = 343,
	/// `STOSW`
	///
	/// `o16 AB`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Stosw_m16_AX = 344,
	/// `STOSD`
	///
	/// `o32 AB`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Stosd_m32_EAX = 345,
	/// `STOSQ`
	///
	/// `o64 AB`
	///
	/// `X64`
	///
	/// `64-bit`
	Stosq_m64_RAX = 346,
	/// `LODSB`
	///
	/// `AC`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Lodsb_AL_m8 = 347,
	/// `LODSW`
	///
	/// `o16 AD`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Lodsw_AX_m16 = 348,
	/// `LODSD`
	///
	/// `o32 AD`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lodsd_EAX_m32 = 349,
	/// `LODSQ`
	///
	/// `o64 AD`
	///
	/// `X64`
	///
	/// `64-bit`
	Lodsq_RAX_m64 = 350,
	/// `SCASB`
	///
	/// `AE`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Scasb_AL_m8 = 351,
	/// `SCASW`
	///
	/// `o16 AF`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Scasw_AX_m16 = 352,
	/// `SCASD`
	///
	/// `o32 AF`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Scasd_EAX_m32 = 353,
	/// `SCASQ`
	///
	/// `o64 AF`
	///
	/// `X64`
	///
	/// `64-bit`
	Scasq_RAX_m64 = 354,
	/// `MOV r8, imm8`
	///
	/// `B0+rb ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_r8_imm8 = 355,
	/// `MOV r16, imm16`
	///
	/// `o16 B8+rw iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_r16_imm16 = 356,
	/// `MOV r32, imm32`
	///
	/// `o32 B8+rd id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_r32_imm32 = 357,
	/// `MOV r64, imm64`
	///
	/// `o64 B8+ro io`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_r64_imm64 = 358,
	/// `ROL r/m8, imm8`
	///
	/// `C0 /0 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Rol_rm8_imm8 = 359,
	/// `ROR r/m8, imm8`
	///
	/// `C0 /1 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Ror_rm8_imm8 = 360,
	/// `RCL r/m8, imm8`
	///
	/// `C0 /2 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Rcl_rm8_imm8 = 361,
	/// `RCR r/m8, imm8`
	///
	/// `C0 /3 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Rcr_rm8_imm8 = 362,
	/// `SHL r/m8, imm8`
	///
	/// `C0 /4 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Shl_rm8_imm8 = 363,
	/// `SHR r/m8, imm8`
	///
	/// `C0 /5 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Shr_rm8_imm8 = 364,
	/// `SAL r/m8, imm8`
	///
	/// `C0 /6 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Sal_rm8_imm8 = 365,
	/// `SAR r/m8, imm8`
	///
	/// `C0 /7 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Sar_rm8_imm8 = 366,
	/// `ROL r/m16, imm8`
	///
	/// `o16 C1 /0 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Rol_rm16_imm8 = 367,
	/// `ROL r/m32, imm8`
	///
	/// `o32 C1 /0 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rol_rm32_imm8 = 368,
	/// `ROL r/m64, imm8`
	///
	/// `o64 C1 /0 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Rol_rm64_imm8 = 369,
	/// `ROR r/m16, imm8`
	///
	/// `o16 C1 /1 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Ror_rm16_imm8 = 370,
	/// `ROR r/m32, imm8`
	///
	/// `o32 C1 /1 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Ror_rm32_imm8 = 371,
	/// `ROR r/m64, imm8`
	///
	/// `o64 C1 /1 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Ror_rm64_imm8 = 372,
	/// `RCL r/m16, imm8`
	///
	/// `o16 C1 /2 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Rcl_rm16_imm8 = 373,
	/// `RCL r/m32, imm8`
	///
	/// `o32 C1 /2 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rcl_rm32_imm8 = 374,
	/// `RCL r/m64, imm8`
	///
	/// `o64 C1 /2 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Rcl_rm64_imm8 = 375,
	/// `RCR r/m16, imm8`
	///
	/// `o16 C1 /3 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Rcr_rm16_imm8 = 376,
	/// `RCR r/m32, imm8`
	///
	/// `o32 C1 /3 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rcr_rm32_imm8 = 377,
	/// `RCR r/m64, imm8`
	///
	/// `o64 C1 /3 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Rcr_rm64_imm8 = 378,
	/// `SHL r/m16, imm8`
	///
	/// `o16 C1 /4 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Shl_rm16_imm8 = 379,
	/// `SHL r/m32, imm8`
	///
	/// `o32 C1 /4 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shl_rm32_imm8 = 380,
	/// `SHL r/m64, imm8`
	///
	/// `o64 C1 /4 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Shl_rm64_imm8 = 381,
	/// `SHR r/m16, imm8`
	///
	/// `o16 C1 /5 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Shr_rm16_imm8 = 382,
	/// `SHR r/m32, imm8`
	///
	/// `o32 C1 /5 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shr_rm32_imm8 = 383,
	/// `SHR r/m64, imm8`
	///
	/// `o64 C1 /5 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Shr_rm64_imm8 = 384,
	/// `SAL r/m16, imm8`
	///
	/// `o16 C1 /6 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Sal_rm16_imm8 = 385,
	/// `SAL r/m32, imm8`
	///
	/// `o32 C1 /6 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sal_rm32_imm8 = 386,
	/// `SAL r/m64, imm8`
	///
	/// `o64 C1 /6 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Sal_rm64_imm8 = 387,
	/// `SAR r/m16, imm8`
	///
	/// `o16 C1 /7 ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Sar_rm16_imm8 = 388,
	/// `SAR r/m32, imm8`
	///
	/// `o32 C1 /7 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sar_rm32_imm8 = 389,
	/// `SAR r/m64, imm8`
	///
	/// `o64 C1 /7 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Sar_rm64_imm8 = 390,
	/// `RET imm16`
	///
	/// `o16 C2 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Retnw_imm16 = 391,
	/// `RET imm16`
	///
	/// `o32 C2 iw`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Retnd_imm16 = 392,
	/// `RET imm16`
	///
	/// `o64 C2 iw`
	///
	/// `X64`
	///
	/// `64-bit`
	Retnq_imm16 = 393,
	/// `RET`
	///
	/// `o16 C3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Retnw = 394,
	/// `RET`
	///
	/// `o32 C3`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Retnd = 395,
	/// `RET`
	///
	/// `o64 C3`
	///
	/// `X64`
	///
	/// `64-bit`
	Retnq = 396,
	/// `LES r16, m16:16`
	///
	/// `o16 C4 /r`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Les_r16_m1616 = 397,
	/// `LES r32, m16:32`
	///
	/// `o32 C4 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Les_r32_m1632 = 398,
	/// `LDS r16, m16:16`
	///
	/// `o16 C5 /r`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Lds_r16_m1616 = 399,
	/// `LDS r32, m16:32`
	///
	/// `o32 C5 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Lds_r32_m1632 = 400,
	/// `MOV r/m8, imm8`
	///
	/// `C6 /0 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_rm8_imm8 = 401,
	/// `XABORT imm8`
	///
	/// `C6 F8 ib`
	///
	/// `RTM`
	///
	/// `16/32/64-bit`
	Xabort_imm8 = 402,
	/// `MOV r/m16, imm16`
	///
	/// `o16 C7 /0 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mov_rm16_imm16 = 403,
	/// `MOV r/m32, imm32`
	///
	/// `o32 C7 /0 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mov_rm32_imm32 = 404,
	/// `MOV r/m64, imm32`
	///
	/// `o64 C7 /0 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_rm64_imm32 = 405,
	/// `XBEGIN rel16`
	///
	/// `o16 C7 F8 cw`
	///
	/// `RTM`
	///
	/// `16/32/64-bit`
	Xbegin_rel16 = 406,
	/// `XBEGIN rel32`
	///
	/// `o32 C7 F8 cd`
	///
	/// `RTM`
	///
	/// `16/32/64-bit`
	Xbegin_rel32 = 407,
	/// `ENTER imm16, imm8`
	///
	/// `o16 C8 iw ib`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Enterw_imm16_imm8 = 408,
	/// `ENTER imm16, imm8`
	///
	/// `o32 C8 iw ib`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Enterd_imm16_imm8 = 409,
	/// `ENTER imm16, imm8`
	///
	/// `o64 C8 iw ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Enterq_imm16_imm8 = 410,
	/// `LEAVE`
	///
	/// `o16 C9`
	///
	/// `186+`
	///
	/// `16/32/64-bit`
	Leavew = 411,
	/// `LEAVE`
	///
	/// `o32 C9`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Leaved = 412,
	/// `LEAVE`
	///
	/// `o64 C9`
	///
	/// `X64`
	///
	/// `64-bit`
	Leaveq = 413,
	/// `RETF imm16`
	///
	/// `o16 CA iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Retfw_imm16 = 414,
	/// `RETF imm16`
	///
	/// `o32 CA iw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Retfd_imm16 = 415,
	/// `RETF imm16`
	///
	/// `o64 CA iw`
	///
	/// `X64`
	///
	/// `64-bit`
	Retfq_imm16 = 416,
	/// `RETF`
	///
	/// `o16 CB`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Retfw = 417,
	/// `RETF`
	///
	/// `o32 CB`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Retfd = 418,
	/// `RETF`
	///
	/// `o64 CB`
	///
	/// `X64`
	///
	/// `64-bit`
	Retfq = 419,
	/// `INT3`
	///
	/// `CC`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Int3 = 420,
	/// `INT imm8`
	///
	/// `CD ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Int_imm8 = 421,
	/// `INTO`
	///
	/// `CE`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Into = 422,
	/// `IRET`
	///
	/// `o16 CF`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Iretw = 423,
	/// `IRETD`
	///
	/// `o32 CF`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Iretd = 424,
	/// `IRETQ`
	///
	/// `o64 CF`
	///
	/// `X64`
	///
	/// `64-bit`
	Iretq = 425,
	/// `ROL r/m8, 1`
	///
	/// `D0 /0`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rol_rm8_1 = 426,
	/// `ROR r/m8, 1`
	///
	/// `D0 /1`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Ror_rm8_1 = 427,
	/// `RCL r/m8, 1`
	///
	/// `D0 /2`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcl_rm8_1 = 428,
	/// `RCR r/m8, 1`
	///
	/// `D0 /3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcr_rm8_1 = 429,
	/// `SHL r/m8, 1`
	///
	/// `D0 /4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shl_rm8_1 = 430,
	/// `SHR r/m8, 1`
	///
	/// `D0 /5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shr_rm8_1 = 431,
	/// `SAL r/m8, 1`
	///
	/// `D0 /6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sal_rm8_1 = 432,
	/// `SAR r/m8, 1`
	///
	/// `D0 /7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sar_rm8_1 = 433,
	/// `ROL r/m16, 1`
	///
	/// `o16 D1 /0`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rol_rm16_1 = 434,
	/// `ROL r/m32, 1`
	///
	/// `o32 D1 /0`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rol_rm32_1 = 435,
	/// `ROL r/m64, 1`
	///
	/// `o64 D1 /0`
	///
	/// `X64`
	///
	/// `64-bit`
	Rol_rm64_1 = 436,
	/// `ROR r/m16, 1`
	///
	/// `o16 D1 /1`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Ror_rm16_1 = 437,
	/// `ROR r/m32, 1`
	///
	/// `o32 D1 /1`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Ror_rm32_1 = 438,
	/// `ROR r/m64, 1`
	///
	/// `o64 D1 /1`
	///
	/// `X64`
	///
	/// `64-bit`
	Ror_rm64_1 = 439,
	/// `RCL r/m16, 1`
	///
	/// `o16 D1 /2`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcl_rm16_1 = 440,
	/// `RCL r/m32, 1`
	///
	/// `o32 D1 /2`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rcl_rm32_1 = 441,
	/// `RCL r/m64, 1`
	///
	/// `o64 D1 /2`
	///
	/// `X64`
	///
	/// `64-bit`
	Rcl_rm64_1 = 442,
	/// `RCR r/m16, 1`
	///
	/// `o16 D1 /3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcr_rm16_1 = 443,
	/// `RCR r/m32, 1`
	///
	/// `o32 D1 /3`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rcr_rm32_1 = 444,
	/// `RCR r/m64, 1`
	///
	/// `o64 D1 /3`
	///
	/// `X64`
	///
	/// `64-bit`
	Rcr_rm64_1 = 445,
	/// `SHL r/m16, 1`
	///
	/// `o16 D1 /4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shl_rm16_1 = 446,
	/// `SHL r/m32, 1`
	///
	/// `o32 D1 /4`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shl_rm32_1 = 447,
	/// `SHL r/m64, 1`
	///
	/// `o64 D1 /4`
	///
	/// `X64`
	///
	/// `64-bit`
	Shl_rm64_1 = 448,
	/// `SHR r/m16, 1`
	///
	/// `o16 D1 /5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shr_rm16_1 = 449,
	/// `SHR r/m32, 1`
	///
	/// `o32 D1 /5`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shr_rm32_1 = 450,
	/// `SHR r/m64, 1`
	///
	/// `o64 D1 /5`
	///
	/// `X64`
	///
	/// `64-bit`
	Shr_rm64_1 = 451,
	/// `SAL r/m16, 1`
	///
	/// `o16 D1 /6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sal_rm16_1 = 452,
	/// `SAL r/m32, 1`
	///
	/// `o32 D1 /6`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sal_rm32_1 = 453,
	/// `SAL r/m64, 1`
	///
	/// `o64 D1 /6`
	///
	/// `X64`
	///
	/// `64-bit`
	Sal_rm64_1 = 454,
	/// `SAR r/m16, 1`
	///
	/// `o16 D1 /7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sar_rm16_1 = 455,
	/// `SAR r/m32, 1`
	///
	/// `o32 D1 /7`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sar_rm32_1 = 456,
	/// `SAR r/m64, 1`
	///
	/// `o64 D1 /7`
	///
	/// `X64`
	///
	/// `64-bit`
	Sar_rm64_1 = 457,
	/// `ROL r/m8, CL`
	///
	/// `D2 /0`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rol_rm8_CL = 458,
	/// `ROR r/m8, CL`
	///
	/// `D2 /1`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Ror_rm8_CL = 459,
	/// `RCL r/m8, CL`
	///
	/// `D2 /2`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcl_rm8_CL = 460,
	/// `RCR r/m8, CL`
	///
	/// `D2 /3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcr_rm8_CL = 461,
	/// `SHL r/m8, CL`
	///
	/// `D2 /4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shl_rm8_CL = 462,
	/// `SHR r/m8, CL`
	///
	/// `D2 /5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shr_rm8_CL = 463,
	/// `SAL r/m8, CL`
	///
	/// `D2 /6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sal_rm8_CL = 464,
	/// `SAR r/m8, CL`
	///
	/// `D2 /7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sar_rm8_CL = 465,
	/// `ROL r/m16, CL`
	///
	/// `o16 D3 /0`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rol_rm16_CL = 466,
	/// `ROL r/m32, CL`
	///
	/// `o32 D3 /0`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rol_rm32_CL = 467,
	/// `ROL r/m64, CL`
	///
	/// `o64 D3 /0`
	///
	/// `X64`
	///
	/// `64-bit`
	Rol_rm64_CL = 468,
	/// `ROR r/m16, CL`
	///
	/// `o16 D3 /1`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Ror_rm16_CL = 469,
	/// `ROR r/m32, CL`
	///
	/// `o32 D3 /1`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Ror_rm32_CL = 470,
	/// `ROR r/m64, CL`
	///
	/// `o64 D3 /1`
	///
	/// `X64`
	///
	/// `64-bit`
	Ror_rm64_CL = 471,
	/// `RCL r/m16, CL`
	///
	/// `o16 D3 /2`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcl_rm16_CL = 472,
	/// `RCL r/m32, CL`
	///
	/// `o32 D3 /2`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rcl_rm32_CL = 473,
	/// `RCL r/m64, CL`
	///
	/// `o64 D3 /2`
	///
	/// `X64`
	///
	/// `64-bit`
	Rcl_rm64_CL = 474,
	/// `RCR r/m16, CL`
	///
	/// `o16 D3 /3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Rcr_rm16_CL = 475,
	/// `RCR r/m32, CL`
	///
	/// `o32 D3 /3`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rcr_rm32_CL = 476,
	/// `RCR r/m64, CL`
	///
	/// `o64 D3 /3`
	///
	/// `X64`
	///
	/// `64-bit`
	Rcr_rm64_CL = 477,
	/// `SHL r/m16, CL`
	///
	/// `o16 D3 /4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shl_rm16_CL = 478,
	/// `SHL r/m32, CL`
	///
	/// `o32 D3 /4`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shl_rm32_CL = 479,
	/// `SHL r/m64, CL`
	///
	/// `o64 D3 /4`
	///
	/// `X64`
	///
	/// `64-bit`
	Shl_rm64_CL = 480,
	/// `SHR r/m16, CL`
	///
	/// `o16 D3 /5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Shr_rm16_CL = 481,
	/// `SHR r/m32, CL`
	///
	/// `o32 D3 /5`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shr_rm32_CL = 482,
	/// `SHR r/m64, CL`
	///
	/// `o64 D3 /5`
	///
	/// `X64`
	///
	/// `64-bit`
	Shr_rm64_CL = 483,
	/// `SAL r/m16, CL`
	///
	/// `o16 D3 /6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sal_rm16_CL = 484,
	/// `SAL r/m32, CL`
	///
	/// `o32 D3 /6`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sal_rm32_CL = 485,
	/// `SAL r/m64, CL`
	///
	/// `o64 D3 /6`
	///
	/// `X64`
	///
	/// `64-bit`
	Sal_rm64_CL = 486,
	/// `SAR r/m16, CL`
	///
	/// `o16 D3 /7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sar_rm16_CL = 487,
	/// `SAR r/m32, CL`
	///
	/// `o32 D3 /7`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sar_rm32_CL = 488,
	/// `SAR r/m64, CL`
	///
	/// `o64 D3 /7`
	///
	/// `X64`
	///
	/// `64-bit`
	Sar_rm64_CL = 489,
	/// `AAM imm8`
	///
	/// `D4 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Aam_imm8 = 490,
	/// `AAD imm8`
	///
	/// `D5 ib`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Aad_imm8 = 491,
	/// `SALC`
	///
	/// `D6`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Salc = 492,
	/// `XLATB`
	///
	/// `D7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Xlat_m8 = 493,
	/// `FADD m32fp`
	///
	/// `D8 /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fadd_m32fp = 494,
	/// `FMUL m32fp`
	///
	/// `D8 /1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fmul_m32fp = 495,
	/// `FCOM m32fp`
	///
	/// `D8 /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcom_m32fp = 496,
	/// `FCOMP m32fp`
	///
	/// `D8 /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcomp_m32fp = 497,
	/// `FSUB m32fp`
	///
	/// `D8 /4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsub_m32fp = 498,
	/// `FSUBR m32fp`
	///
	/// `D8 /5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsubr_m32fp = 499,
	/// `FDIV m32fp`
	///
	/// `D8 /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdiv_m32fp = 500,
	/// `FDIVR m32fp`
	///
	/// `D8 /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdivr_m32fp = 501,
	/// `FADD ST(0), ST(i)`
	///
	/// `D8 C0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fadd_st0_sti = 502,
	/// `FMUL ST(0), ST(i)`
	///
	/// `D8 C8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fmul_st0_sti = 503,
	/// `FCOM ST(i)`
	///
	/// `D8 D0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcom_st0_sti = 504,
	/// `FCOMP ST(i)`
	///
	/// `D8 D8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcomp_st0_sti = 505,
	/// `FSUB ST(0), ST(i)`
	///
	/// `D8 E0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsub_st0_sti = 506,
	/// `FSUBR ST(0), ST(i)`
	///
	/// `D8 E8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsubr_st0_sti = 507,
	/// `FDIV ST(0), ST(i)`
	///
	/// `D8 F0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdiv_st0_sti = 508,
	/// `FDIVR ST(0), ST(i)`
	///
	/// `D8 F8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdivr_st0_sti = 509,
	/// `FLD m32fp`
	///
	/// `D9 /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fld_m32fp = 510,
	/// `FST m32fp`
	///
	/// `D9 /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fst_m32fp = 511,
	/// `FSTP m32fp`
	///
	/// `D9 /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstp_m32fp = 512,
	/// `FLDENV m14byte`
	///
	/// `o16 D9 /4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldenv_m14byte = 513,
	/// `FLDENV m28byte`
	///
	/// `o32 D9 /4`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fldenv_m28byte = 514,
	/// `FLDCW m2byte`
	///
	/// `D9 /5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldcw_m2byte = 515,
	/// `FNSTENV m14byte`
	///
	/// `o16 D9 /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fnstenv_m14byte = 516,
	/// `FSTENV m14byte`
	///
	/// `9B o16 D9 /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstenv_m14byte = 517,
	/// `FNSTENV m28byte`
	///
	/// `o32 D9 /6`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fnstenv_m28byte = 518,
	/// `FSTENV m28byte`
	///
	/// `9B o32 D9 /6`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fstenv_m28byte = 519,
	/// `FNSTCW m2byte`
	///
	/// `D9 /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fnstcw_m2byte = 520,
	/// `FSTCW m2byte`
	///
	/// `9B D9 /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstcw_m2byte = 521,
	/// `FLD ST(i)`
	///
	/// `D9 C0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fld_sti = 522,
	/// `FXCH ST(i)`
	///
	/// `D9 C8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fxch_st0_sti = 523,
	/// `FNOP`
	///
	/// `D9 D0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fnop = 524,
	/// `FSTPNCE ST(i)`
	///
	/// `D9 D8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstpnce_sti = 525,
	/// `FCHS`
	///
	/// `D9 E0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fchs = 526,
	/// `FABS`
	///
	/// `D9 E1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fabs = 527,
	/// `FTST`
	///
	/// `D9 E4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Ftst = 528,
	/// `FXAM`
	///
	/// `D9 E5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fxam = 529,
	/// `FLD1`
	///
	/// `D9 E8`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fld1 = 530,
	/// `FLDL2T`
	///
	/// `D9 E9`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldl2t = 531,
	/// `FLDL2E`
	///
	/// `D9 EA`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldl2e = 532,
	/// `FLDPI`
	///
	/// `D9 EB`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldpi = 533,
	/// `FLDLG2`
	///
	/// `D9 EC`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldlg2 = 534,
	/// `FLDLN2`
	///
	/// `D9 ED`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldln2 = 535,
	/// `FLDZ`
	///
	/// `D9 EE`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fldz = 536,
	/// `F2XM1`
	///
	/// `D9 F0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	F2xm1 = 537,
	/// `FYL2X`
	///
	/// `D9 F1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fyl2x = 538,
	/// `FPTAN`
	///
	/// `D9 F2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fptan = 539,
	/// `FPATAN`
	///
	/// `D9 F3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fpatan = 540,
	/// `FXTRACT`
	///
	/// `D9 F4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fxtract = 541,
	/// `FPREM1`
	///
	/// `D9 F5`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fprem1 = 542,
	/// `FDECSTP`
	///
	/// `D9 F6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdecstp = 543,
	/// `FINCSTP`
	///
	/// `D9 F7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fincstp = 544,
	/// `FPREM`
	///
	/// `D9 F8`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fprem = 545,
	/// `FYL2XP1`
	///
	/// `D9 F9`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fyl2xp1 = 546,
	/// `FSQRT`
	///
	/// `D9 FA`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsqrt = 547,
	/// `FSINCOS`
	///
	/// `D9 FB`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fsincos = 548,
	/// `FRNDINT`
	///
	/// `D9 FC`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Frndint = 549,
	/// `FSCALE`
	///
	/// `D9 FD`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fscale = 550,
	/// `FSIN`
	///
	/// `D9 FE`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fsin = 551,
	/// `FCOS`
	///
	/// `D9 FF`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fcos = 552,
	/// `FIADD m32int`
	///
	/// `DA /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fiadd_m32int = 553,
	/// `FIMUL m32int`
	///
	/// `DA /1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fimul_m32int = 554,
	/// `FICOM m32int`
	///
	/// `DA /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Ficom_m32int = 555,
	/// `FICOMP m32int`
	///
	/// `DA /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Ficomp_m32int = 556,
	/// `FISUB m32int`
	///
	/// `DA /4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fisub_m32int = 557,
	/// `FISUBR m32int`
	///
	/// `DA /5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fisubr_m32int = 558,
	/// `FIDIV m32int`
	///
	/// `DA /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fidiv_m32int = 559,
	/// `FIDIVR m32int`
	///
	/// `DA /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fidivr_m32int = 560,
	/// `FCMOVB ST(0), ST(i)`
	///
	/// `DA C0+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmovb_st0_sti = 561,
	/// `FCMOVE ST(0), ST(i)`
	///
	/// `DA C8+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmove_st0_sti = 562,
	/// `FCMOVBE ST(0), ST(i)`
	///
	/// `DA D0+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmovbe_st0_sti = 563,
	/// `FCMOVU ST(0), ST(i)`
	///
	/// `DA D8+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmovu_st0_sti = 564,
	/// `FUCOMPP`
	///
	/// `DA E9`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fucompp = 565,
	/// `FILD m32int`
	///
	/// `DB /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fild_m32int = 566,
	/// `FISTTP m32int`
	///
	/// `DB /1`
	///
	/// `8087+ and SSE3`
	///
	/// `16/32/64-bit`
	Fisttp_m32int = 567,
	/// `FIST m32int`
	///
	/// `DB /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fist_m32int = 568,
	/// `FISTP m32int`
	///
	/// `DB /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fistp_m32int = 569,
	/// `FLD m80fp`
	///
	/// `DB /5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fld_m80fp = 570,
	/// `FSTP m80fp`
	///
	/// `DB /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstp_m80fp = 571,
	/// `FCMOVNB ST(0), ST(i)`
	///
	/// `DB C0+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmovnb_st0_sti = 572,
	/// `FCMOVNE ST(0), ST(i)`
	///
	/// `DB C8+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmovne_st0_sti = 573,
	/// `FCMOVNBE ST(0), ST(i)`
	///
	/// `DB D0+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmovnbe_st0_sti = 574,
	/// `FCMOVNU ST(0), ST(i)`
	///
	/// `DB D8+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcmovnu_st0_sti = 575,
	/// `FNENI`
	///
	/// `DB E0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fneni = 576,
	/// `FENI`
	///
	/// `9B DB E0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Feni = 577,
	/// `FNDISI`
	///
	/// `DB E1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fndisi = 578,
	/// `FDISI`
	///
	/// `9B DB E1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdisi = 579,
	/// `FNCLEX`
	///
	/// `DB E2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fnclex = 580,
	/// `FCLEX`
	///
	/// `9B DB E2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fclex = 581,
	/// `FNINIT`
	///
	/// `DB E3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fninit = 582,
	/// `FINIT`
	///
	/// `9B DB E3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Finit = 583,
	/// `FNSETPM`
	///
	/// `DB E4`
	///
	/// `287+`
	///
	/// `16/32/64-bit`
	Fnsetpm = 584,
	/// `FSETPM`
	///
	/// `9B DB E4`
	///
	/// `287+`
	///
	/// `16/32/64-bit`
	Fsetpm = 585,
	/// `FRSTPM`
	///
	/// `DB E5`
	///
	/// `287 XL`
	///
	/// `16/32-bit`
	Frstpm = 586,
	/// `FUCOMI ST, ST(i)`
	///
	/// `DB E8+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fucomi_st0_sti = 587,
	/// `FCOMI ST, ST(i)`
	///
	/// `DB F0+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcomi_st0_sti = 588,
	/// `FADD m64fp`
	///
	/// `DC /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fadd_m64fp = 589,
	/// `FMUL m64fp`
	///
	/// `DC /1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fmul_m64fp = 590,
	/// `FCOM m64fp`
	///
	/// `DC /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcom_m64fp = 591,
	/// `FCOMP m64fp`
	///
	/// `DC /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcomp_m64fp = 592,
	/// `FSUB m64fp`
	///
	/// `DC /4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsub_m64fp = 593,
	/// `FSUBR m64fp`
	///
	/// `DC /5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsubr_m64fp = 594,
	/// `FDIV m64fp`
	///
	/// `DC /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdiv_m64fp = 595,
	/// `FDIVR m64fp`
	///
	/// `DC /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdivr_m64fp = 596,
	/// `FADD ST(i), ST(0)`
	///
	/// `DC C0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fadd_sti_st0 = 597,
	/// `FMUL ST(i), ST(0)`
	///
	/// `DC C8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fmul_sti_st0 = 598,
	/// `FCOM ST(i)`
	///
	/// `DC D0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcom_st0_sti_DCD0 = 599,
	/// `FCOMP ST(i)`
	///
	/// `DC D8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcomp_st0_sti_DCD8 = 600,
	/// `FSUBR ST(i), ST(0)`
	///
	/// `DC E0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsubr_sti_st0 = 601,
	/// `FSUB ST(i), ST(0)`
	///
	/// `DC E8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsub_sti_st0 = 602,
	/// `FDIVR ST(i), ST(0)`
	///
	/// `DC F0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdivr_sti_st0 = 603,
	/// `FDIV ST(i), ST(0)`
	///
	/// `DC F8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdiv_sti_st0 = 604,
	/// `FLD m64fp`
	///
	/// `DD /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fld_m64fp = 605,
	/// `FISTTP m64int`
	///
	/// `DD /1`
	///
	/// `8087+ and SSE3`
	///
	/// `16/32/64-bit`
	Fisttp_m64int = 606,
	/// `FST m64fp`
	///
	/// `DD /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fst_m64fp = 607,
	/// `FSTP m64fp`
	///
	/// `DD /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstp_m64fp = 608,
	/// `FRSTOR m94byte`
	///
	/// `o16 DD /4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Frstor_m94byte = 609,
	/// `FRSTOR m108byte`
	///
	/// `o32 DD /4`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Frstor_m108byte = 610,
	/// `FNSAVE m94byte`
	///
	/// `o16 DD /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fnsave_m94byte = 611,
	/// `FSAVE m94byte`
	///
	/// `9B o16 DD /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsave_m94byte = 612,
	/// `FNSAVE m108byte`
	///
	/// `o32 DD /6`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fnsave_m108byte = 613,
	/// `FSAVE m108byte`
	///
	/// `9B o32 DD /6`
	///
	/// `387+`
	///
	/// `16/32/64-bit`
	Fsave_m108byte = 614,
	/// `FNSTSW m2byte`
	///
	/// `DD /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fnstsw_m2byte = 615,
	/// `FSTSW m2byte`
	///
	/// `9B DD /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstsw_m2byte = 616,
	/// `FFREE ST(i)`
	///
	/// `DD C0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Ffree_sti = 617,
	/// `FXCH ST(i)`
	///
	/// `DD C8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fxch_st0_sti_DDC8 = 618,
	/// `FST ST(i)`
	///
	/// `DD D0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fst_sti = 619,
	/// `FSTP ST(i)`
	///
	/// `DD D8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstp_sti = 620,
	/// `FUCOM ST(i)`
	///
	/// `DD E0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fucom_st0_sti = 621,
	/// `FUCOMP ST(i)`
	///
	/// `DD E8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fucomp_st0_sti = 622,
	/// `FIADD m16int`
	///
	/// `DE /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fiadd_m16int = 623,
	/// `FIMUL m16int`
	///
	/// `DE /1`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fimul_m16int = 624,
	/// `FICOM m16int`
	///
	/// `DE /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Ficom_m16int = 625,
	/// `FICOMP m16int`
	///
	/// `DE /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Ficomp_m16int = 626,
	/// `FISUB m16int`
	///
	/// `DE /4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fisub_m16int = 627,
	/// `FISUBR m16int`
	///
	/// `DE /5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fisubr_m16int = 628,
	/// `FIDIV m16int`
	///
	/// `DE /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fidiv_m16int = 629,
	/// `FIDIVR m16int`
	///
	/// `DE /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fidivr_m16int = 630,
	/// `FADDP ST(i), ST(0)`
	///
	/// `DE C0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Faddp_sti_st0 = 631,
	/// `FMULP ST(i), ST(0)`
	///
	/// `DE C8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fmulp_sti_st0 = 632,
	/// `FCOMP ST(i)`
	///
	/// `DE D0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcomp_st0_sti_DED0 = 633,
	/// `FCOMPP`
	///
	/// `DE D9`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fcompp = 634,
	/// `FSUBRP ST(i), ST(0)`
	///
	/// `DE E0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsubrp_sti_st0 = 635,
	/// `FSUBP ST(i), ST(0)`
	///
	/// `DE E8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fsubp_sti_st0 = 636,
	/// `FDIVRP ST(i), ST(0)`
	///
	/// `DE F0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdivrp_sti_st0 = 637,
	/// `FDIVP ST(i), ST(0)`
	///
	/// `DE F8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fdivp_sti_st0 = 638,
	/// `FILD m16int`
	///
	/// `DF /0`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fild_m16int = 639,
	/// `FISTTP m16int`
	///
	/// `DF /1`
	///
	/// `8087+ and SSE3`
	///
	/// `16/32/64-bit`
	Fisttp_m16int = 640,
	/// `FIST m16int`
	///
	/// `DF /2`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fist_m16int = 641,
	/// `FISTP m16int`
	///
	/// `DF /3`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fistp_m16int = 642,
	/// `FBLD m80bcd`
	///
	/// `DF /4`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fbld_m80bcd = 643,
	/// `FILD m64int`
	///
	/// `DF /5`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fild_m64int = 644,
	/// `FBSTP m80bcd`
	///
	/// `DF /6`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fbstp_m80bcd = 645,
	/// `FISTP m64int`
	///
	/// `DF /7`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fistp_m64int = 646,
	/// `FFREEP ST(i)`
	///
	/// `DF C0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Ffreep_sti = 647,
	/// `FXCH ST(i)`
	///
	/// `DF C8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fxch_st0_sti_DFC8 = 648,
	/// `FSTP ST(i)`
	///
	/// `DF D0+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstp_sti_DFD0 = 649,
	/// `FSTP ST(i)`
	///
	/// `DF D8+i`
	///
	/// `8087+`
	///
	/// `16/32/64-bit`
	Fstp_sti_DFD8 = 650,
	/// `FNSTSW AX`
	///
	/// `DF E0`
	///
	/// `287+`
	///
	/// `16/32/64-bit`
	Fnstsw_AX = 651,
	/// `FSTSW AX`
	///
	/// `9B DF E0`
	///
	/// `287+`
	///
	/// `16/32/64-bit`
	Fstsw_AX = 652,
	/// `FSTDW AX`
	///
	/// `9B DF E1`
	///
	/// `387 SL`
	///
	/// `16/32-bit`
	Fstdw_AX = 653,
	/// `FSTSG AX`
	///
	/// `9B DF E2`
	///
	/// `387 SL`
	///
	/// `16/32-bit`
	Fstsg_AX = 654,
	/// `FUCOMIP ST, ST(i)`
	///
	/// `DF E8+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fucomip_st0_sti = 655,
	/// `FCOMIP ST, ST(i)`
	///
	/// `DF F0+i`
	///
	/// `8087+ and CMOV`
	///
	/// `16/32/64-bit`
	Fcomip_st0_sti = 656,
	/// `LOOPNE rel8`
	///
	/// `a16 o16 E0 cb`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Loopne_rel8_16_CX = 657,
	/// `LOOPNE rel8`
	///
	/// `a16 o32 E0 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Loopne_rel8_32_CX = 658,
	/// `LOOPNE rel8`
	///
	/// `a32 o16 E0 cb`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Loopne_rel8_16_ECX = 659,
	/// `LOOPNE rel8`
	///
	/// `a32 o32 E0 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Loopne_rel8_32_ECX = 660,
	/// `LOOPNE rel8`
	///
	/// `a32 o64 E0 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loopne_rel8_64_ECX = 661,
	/// `LOOPNE rel8`
	///
	/// `a64 o16 E0 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loopne_rel8_16_RCX = 662,
	/// `LOOPNE rel8`
	///
	/// `a64 o64 E0 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loopne_rel8_64_RCX = 663,
	/// `LOOPE rel8`
	///
	/// `a16 o16 E1 cb`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Loope_rel8_16_CX = 664,
	/// `LOOPE rel8`
	///
	/// `a16 o32 E1 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Loope_rel8_32_CX = 665,
	/// `LOOPE rel8`
	///
	/// `a32 o16 E1 cb`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Loope_rel8_16_ECX = 666,
	/// `LOOPE rel8`
	///
	/// `a32 o32 E1 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Loope_rel8_32_ECX = 667,
	/// `LOOPE rel8`
	///
	/// `a32 o64 E1 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loope_rel8_64_ECX = 668,
	/// `LOOPE rel8`
	///
	/// `a64 o16 E1 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loope_rel8_16_RCX = 669,
	/// `LOOPE rel8`
	///
	/// `a64 o64 E1 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loope_rel8_64_RCX = 670,
	/// `LOOP rel8`
	///
	/// `a16 o16 E2 cb`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Loop_rel8_16_CX = 671,
	/// `LOOP rel8`
	///
	/// `a16 o32 E2 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Loop_rel8_32_CX = 672,
	/// `LOOP rel8`
	///
	/// `a32 o16 E2 cb`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Loop_rel8_16_ECX = 673,
	/// `LOOP rel8`
	///
	/// `a32 o32 E2 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Loop_rel8_32_ECX = 674,
	/// `LOOP rel8`
	///
	/// `a32 o64 E2 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loop_rel8_64_ECX = 675,
	/// `LOOP rel8`
	///
	/// `a64 o16 E2 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loop_rel8_16_RCX = 676,
	/// `LOOP rel8`
	///
	/// `a64 o64 E2 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Loop_rel8_64_RCX = 677,
	/// `JCXZ rel8`
	///
	/// `a16 o16 E3 cb`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Jcxz_rel8_16 = 678,
	/// `JCXZ rel8`
	///
	/// `a16 o32 E3 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jcxz_rel8_32 = 679,
	/// `JECXZ rel8`
	///
	/// `a32 o16 E3 cb`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jecxz_rel8_16 = 680,
	/// `JECXZ rel8`
	///
	/// `a32 o32 E3 cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jecxz_rel8_32 = 681,
	/// `JECXZ rel8`
	///
	/// `a32 o64 E3 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jecxz_rel8_64 = 682,
	/// `JRCXZ rel8`
	///
	/// `a64 o16 E3 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jrcxz_rel8_16 = 683,
	/// `JRCXZ rel8`
	///
	/// `a64 o64 E3 cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jrcxz_rel8_64 = 684,
	/// `IN AL, imm8`
	///
	/// `E4 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	In_AL_imm8 = 685,
	/// `IN AX, imm8`
	///
	/// `o16 E5 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	In_AX_imm8 = 686,
	/// `IN EAX, imm8`
	///
	/// `o32 E5 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	In_EAX_imm8 = 687,
	/// `OUT imm8, AL`
	///
	/// `E6 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Out_imm8_AL = 688,
	/// `OUT imm8, AX`
	///
	/// `o16 E7 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Out_imm8_AX = 689,
	/// `OUT imm8, EAX`
	///
	/// `o32 E7 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Out_imm8_EAX = 690,
	/// `CALL rel16`
	///
	/// `o16 E8 cw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Call_rel16 = 691,
	/// `CALL rel32`
	///
	/// `o32 E8 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Call_rel32_32 = 692,
	/// `CALL rel32`
	///
	/// `o64 E8 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Call_rel32_64 = 693,
	/// `JMP rel16`
	///
	/// `o16 E9 cw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jmp_rel16 = 694,
	/// `JMP rel32`
	///
	/// `o32 E9 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jmp_rel32_32 = 695,
	/// `JMP rel32`
	///
	/// `o64 E9 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jmp_rel32_64 = 696,
	/// `JMP ptr16:16`
	///
	/// `o16 EA cd`
	///
	/// `8086+`
	///
	/// `16/32-bit`
	Jmp_ptr1616 = 697,
	/// `JMP ptr16:32`
	///
	/// `o32 EA cp`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jmp_ptr1632 = 698,
	/// `JMP rel8`
	///
	/// `o16 EB cb`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jmp_rel8_16 = 699,
	/// `JMP rel8`
	///
	/// `o32 EB cb`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jmp_rel8_32 = 700,
	/// `JMP rel8`
	///
	/// `o64 EB cb`
	///
	/// `X64`
	///
	/// `64-bit`
	Jmp_rel8_64 = 701,
	/// `IN AL, DX`
	///
	/// `EC`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	In_AL_DX = 702,
	/// `IN AX, DX`
	///
	/// `o16 ED`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	In_AX_DX = 703,
	/// `IN EAX, DX`
	///
	/// `o32 ED`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	In_EAX_DX = 704,
	/// `OUT DX, AL`
	///
	/// `EE`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Out_DX_AL = 705,
	/// `OUT DX, AX`
	///
	/// `o16 EF`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Out_DX_AX = 706,
	/// `OUT DX, EAX`
	///
	/// `o32 EF`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Out_DX_EAX = 707,
	/// `INT1`
	///
	/// `F1`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Int1 = 708,
	/// `HLT`
	///
	/// `F4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Hlt = 709,
	/// `CMC`
	///
	/// `F5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cmc = 710,
	/// `TEST r/m8, imm8`
	///
	/// `F6 /0 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_rm8_imm8 = 711,
	/// `TEST r/m8, imm8`
	///
	/// `F6 /1 ib`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_rm8_imm8_F6r1 = 712,
	/// `NOT r/m8`
	///
	/// `F6 /2`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Not_rm8 = 713,
	/// `NEG r/m8`
	///
	/// `F6 /3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Neg_rm8 = 714,
	/// `MUL r/m8`
	///
	/// `F6 /4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mul_rm8 = 715,
	/// `IMUL r/m8`
	///
	/// `F6 /5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Imul_rm8 = 716,
	/// `DIV r/m8`
	///
	/// `F6 /6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Div_rm8 = 717,
	/// `IDIV r/m8`
	///
	/// `F6 /7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Idiv_rm8 = 718,
	/// `TEST r/m16, imm16`
	///
	/// `o16 F7 /0 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_rm16_imm16 = 719,
	/// `TEST r/m32, imm32`
	///
	/// `o32 F7 /0 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Test_rm32_imm32 = 720,
	/// `TEST r/m64, imm32`
	///
	/// `o64 F7 /0 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Test_rm64_imm32 = 721,
	/// `TEST r/m16, imm16`
	///
	/// `o16 F7 /1 iw`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Test_rm16_imm16_F7r1 = 722,
	/// `TEST r/m32, imm32`
	///
	/// `o32 F7 /1 id`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Test_rm32_imm32_F7r1 = 723,
	/// `TEST r/m64, imm32`
	///
	/// `o64 F7 /1 id`
	///
	/// `X64`
	///
	/// `64-bit`
	Test_rm64_imm32_F7r1 = 724,
	/// `NOT r/m16`
	///
	/// `o16 F7 /2`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Not_rm16 = 725,
	/// `NOT r/m32`
	///
	/// `o32 F7 /2`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Not_rm32 = 726,
	/// `NOT r/m64`
	///
	/// `o64 F7 /2`
	///
	/// `X64`
	///
	/// `64-bit`
	Not_rm64 = 727,
	/// `NEG r/m16`
	///
	/// `o16 F7 /3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Neg_rm16 = 728,
	/// `NEG r/m32`
	///
	/// `o32 F7 /3`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Neg_rm32 = 729,
	/// `NEG r/m64`
	///
	/// `o64 F7 /3`
	///
	/// `X64`
	///
	/// `64-bit`
	Neg_rm64 = 730,
	/// `MUL r/m16`
	///
	/// `o16 F7 /4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Mul_rm16 = 731,
	/// `MUL r/m32`
	///
	/// `o32 F7 /4`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Mul_rm32 = 732,
	/// `MUL r/m64`
	///
	/// `o64 F7 /4`
	///
	/// `X64`
	///
	/// `64-bit`
	Mul_rm64 = 733,
	/// `IMUL r/m16`
	///
	/// `o16 F7 /5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Imul_rm16 = 734,
	/// `IMUL r/m32`
	///
	/// `o32 F7 /5`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Imul_rm32 = 735,
	/// `IMUL r/m64`
	///
	/// `o64 F7 /5`
	///
	/// `X64`
	///
	/// `64-bit`
	Imul_rm64 = 736,
	/// `DIV r/m16`
	///
	/// `o16 F7 /6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Div_rm16 = 737,
	/// `DIV r/m32`
	///
	/// `o32 F7 /6`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Div_rm32 = 738,
	/// `DIV r/m64`
	///
	/// `o64 F7 /6`
	///
	/// `X64`
	///
	/// `64-bit`
	Div_rm64 = 739,
	/// `IDIV r/m16`
	///
	/// `o16 F7 /7`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Idiv_rm16 = 740,
	/// `IDIV r/m32`
	///
	/// `o32 F7 /7`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Idiv_rm32 = 741,
	/// `IDIV r/m64`
	///
	/// `o64 F7 /7`
	///
	/// `X64`
	///
	/// `64-bit`
	Idiv_rm64 = 742,
	/// `CLC`
	///
	/// `F8`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Clc = 743,
	/// `STC`
	///
	/// `F9`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Stc = 744,
	/// `CLI`
	///
	/// `FA`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cli = 745,
	/// `STI`
	///
	/// `FB`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Sti = 746,
	/// `CLD`
	///
	/// `FC`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Cld = 747,
	/// `STD`
	///
	/// `FD`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Std = 748,
	/// `INC r/m8`
	///
	/// `FE /0`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Inc_rm8 = 749,
	/// `DEC r/m8`
	///
	/// `FE /1`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Dec_rm8 = 750,
	/// `INC r/m16`
	///
	/// `o16 FF /0`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Inc_rm16 = 751,
	/// `INC r/m32`
	///
	/// `o32 FF /0`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Inc_rm32 = 752,
	/// `INC r/m64`
	///
	/// `o64 FF /0`
	///
	/// `X64`
	///
	/// `64-bit`
	Inc_rm64 = 753,
	/// `DEC r/m16`
	///
	/// `o16 FF /1`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Dec_rm16 = 754,
	/// `DEC r/m32`
	///
	/// `o32 FF /1`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Dec_rm32 = 755,
	/// `DEC r/m64`
	///
	/// `o64 FF /1`
	///
	/// `X64`
	///
	/// `64-bit`
	Dec_rm64 = 756,
	/// `CALL r/m16`
	///
	/// `o16 FF /2`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Call_rm16 = 757,
	/// `CALL r/m32`
	///
	/// `o32 FF /2`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Call_rm32 = 758,
	/// `CALL r/m64`
	///
	/// `o64 FF /2`
	///
	/// `X64`
	///
	/// `64-bit`
	Call_rm64 = 759,
	/// `CALL m16:16`
	///
	/// `o16 FF /3`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Call_m1616 = 760,
	/// `CALL m16:32`
	///
	/// `o32 FF /3`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Call_m1632 = 761,
	/// `CALL m16:64`
	///
	/// `o64 FF /3`
	///
	/// `X64`
	///
	/// `64-bit`
	Call_m1664 = 762,
	/// `JMP r/m16`
	///
	/// `o16 FF /4`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jmp_rm16 = 763,
	/// `JMP r/m32`
	///
	/// `o32 FF /4`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jmp_rm32 = 764,
	/// `JMP r/m64`
	///
	/// `o64 FF /4`
	///
	/// `X64`
	///
	/// `64-bit`
	Jmp_rm64 = 765,
	/// `JMP m16:16`
	///
	/// `o16 FF /5`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Jmp_m1616 = 766,
	/// `JMP m16:32`
	///
	/// `o32 FF /5`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jmp_m1632 = 767,
	/// `JMP m16:64`
	///
	/// `o64 FF /5`
	///
	/// `X64`
	///
	/// `64-bit`
	Jmp_m1664 = 768,
	/// `PUSH r/m16`
	///
	/// `o16 FF /6`
	///
	/// `8086+`
	///
	/// `16/32/64-bit`
	Push_rm16 = 769,
	/// `PUSH r/m32`
	///
	/// `o32 FF /6`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Push_rm32 = 770,
	/// `PUSH r/m64`
	///
	/// `o64 FF /6`
	///
	/// `X64`
	///
	/// `64-bit`
	Push_rm64 = 771,
	/// `SLDT r/m16`
	///
	/// `o16 0F 00 /0`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Sldt_rm16 = 772,
	/// `SLDT r32/m16`
	///
	/// `o32 0F 00 /0`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sldt_r32m16 = 773,
	/// `SLDT r64/m16`
	///
	/// `o64 0F 00 /0`
	///
	/// `X64`
	///
	/// `64-bit`
	Sldt_r64m16 = 774,
	/// `STR r/m16`
	///
	/// `o16 0F 00 /1`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Str_rm16 = 775,
	/// `STR r32/m16`
	///
	/// `o32 0F 00 /1`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Str_r32m16 = 776,
	/// `STR r64/m16`
	///
	/// `o64 0F 00 /1`
	///
	/// `X64`
	///
	/// `64-bit`
	Str_r64m16 = 777,
	/// `LLDT r/m16`
	///
	/// `o16 0F 00 /2`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Lldt_rm16 = 778,
	/// `LLDT r32/m16`
	///
	/// `o32 0F 00 /2`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lldt_r32m16 = 779,
	/// `LLDT r64/m16`
	///
	/// `o64 0F 00 /2`
	///
	/// `X64`
	///
	/// `64-bit`
	Lldt_r64m16 = 780,
	/// `LTR r/m16`
	///
	/// `o16 0F 00 /3`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Ltr_rm16 = 781,
	/// `LTR r32/m16`
	///
	/// `o32 0F 00 /3`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Ltr_r32m16 = 782,
	/// `LTR r64/m16`
	///
	/// `o64 0F 00 /3`
	///
	/// `X64`
	///
	/// `64-bit`
	Ltr_r64m16 = 783,
	/// `VERR r/m16`
	///
	/// `o16 0F 00 /4`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Verr_rm16 = 784,
	/// `VERR r32/m16`
	///
	/// `o32 0F 00 /4`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Verr_r32m16 = 785,
	/// `VERR r64/m16`
	///
	/// `o64 0F 00 /4`
	///
	/// `X64`
	///
	/// `64-bit`
	Verr_r64m16 = 786,
	/// `VERW r/m16`
	///
	/// `o16 0F 00 /5`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Verw_rm16 = 787,
	/// `VERW r32/m16`
	///
	/// `o32 0F 00 /5`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Verw_r32m16 = 788,
	/// `VERW r64/m16`
	///
	/// `o64 0F 00 /5`
	///
	/// `X64`
	///
	/// `64-bit`
	Verw_r64m16 = 789,
	/// `JMPE r/m16`
	///
	/// `o16 0F 00 /6`
	///
	/// `IA-64`
	///
	/// `16/32-bit`
	Jmpe_rm16 = 790,
	/// `JMPE r/m32`
	///
	/// `o32 0F 00 /6`
	///
	/// `IA-64`
	///
	/// `16/32-bit`
	Jmpe_rm32 = 791,
	/// `SGDT m`
	///
	/// `o16 0F 01 /0`
	///
	/// `286+`
	///
	/// `16/32-bit`
	Sgdt_m1632_16 = 792,
	/// `SGDT m`
	///
	/// `o32 0F 01 /0`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Sgdt_m1632 = 793,
	/// `SGDT m`
	///
	/// `0F 01 /0`
	///
	/// `X64`
	///
	/// `64-bit`
	Sgdt_m1664 = 794,
	/// `SIDT m`
	///
	/// `o16 0F 01 /1`
	///
	/// `286+`
	///
	/// `16/32-bit`
	Sidt_m1632_16 = 795,
	/// `SIDT m`
	///
	/// `o32 0F 01 /1`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Sidt_m1632 = 796,
	/// `SIDT m`
	///
	/// `0F 01 /1`
	///
	/// `X64`
	///
	/// `64-bit`
	Sidt_m1664 = 797,
	/// `LGDT m16&32`
	///
	/// `o16 0F 01 /2`
	///
	/// `286+`
	///
	/// `16/32-bit`
	Lgdt_m1632_16 = 798,
	/// `LGDT m16&32`
	///
	/// `o32 0F 01 /2`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Lgdt_m1632 = 799,
	/// `LGDT m16&64`
	///
	/// `0F 01 /2`
	///
	/// `X64`
	///
	/// `64-bit`
	Lgdt_m1664 = 800,
	/// `LIDT m16&32`
	///
	/// `o16 0F 01 /3`
	///
	/// `286+`
	///
	/// `16/32-bit`
	Lidt_m1632_16 = 801,
	/// `LIDT m16&32`
	///
	/// `o32 0F 01 /3`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Lidt_m1632 = 802,
	/// `LIDT m16&64`
	///
	/// `0F 01 /3`
	///
	/// `X64`
	///
	/// `64-bit`
	Lidt_m1664 = 803,
	/// `SMSW r/m16`
	///
	/// `o16 0F 01 /4`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Smsw_rm16 = 804,
	/// `SMSW r32/m16`
	///
	/// `o32 0F 01 /4`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Smsw_r32m16 = 805,
	/// `SMSW r64/m16`
	///
	/// `o64 0F 01 /4`
	///
	/// `X64`
	///
	/// `64-bit`
	Smsw_r64m16 = 806,
	/// `RSTORSSP m64`
	///
	/// `F3 0F 01 /5`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Rstorssp_m64 = 807,
	/// `LMSW r/m16`
	///
	/// `o16 0F 01 /6`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Lmsw_rm16 = 808,
	/// `LMSW r32/m16`
	///
	/// `o32 0F 01 /6`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lmsw_r32m16 = 809,
	/// `LMSW r64/m16`
	///
	/// `o64 0F 01 /6`
	///
	/// `X64`
	///
	/// `64-bit`
	Lmsw_r64m16 = 810,
	/// `INVLPG m`
	///
	/// `0F 01 /7`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Invlpg_m = 811,
	/// `ENCLV`
	///
	/// `NP 0F 01 C0`
	///
	/// `OSS`
	///
	/// `16/32/64-bit`
	Enclv = 812,
	/// `VMCALL`
	///
	/// `NP 0F 01 C1`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmcall = 813,
	/// `VMLAUNCH`
	///
	/// `NP 0F 01 C2`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmlaunch = 814,
	/// `VMRESUME`
	///
	/// `NP 0F 01 C3`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmresume = 815,
	/// `VMXOFF`
	///
	/// `NP 0F 01 C4`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmxoff = 816,
	/// `PCONFIG`
	///
	/// `NP 0F 01 C5`
	///
	/// `PCONFIG`
	///
	/// `16/32/64-bit`
	Pconfig = 817,
	/// `MONITOR`
	///
	/// `a16 NP 0F 01 C8`
	///
	/// `MONITOR`
	///
	/// `16/32-bit`
	Monitorw = 818,
	/// `MONITOR`
	///
	/// `a32 NP 0F 01 C8`
	///
	/// `MONITOR`
	///
	/// `16/32/64-bit`
	Monitord = 819,
	/// `MONITOR`
	///
	/// `a64 NP 0F 01 C8`
	///
	/// `MONITOR`
	///
	/// `64-bit`
	Monitorq = 820,
	/// `MWAIT`
	///
	/// `NP 0F 01 C9`
	///
	/// `MONITOR`
	///
	/// `16/32/64-bit`
	Mwait = 821,
	/// `CLAC`
	///
	/// `NP 0F 01 CA`
	///
	/// `SMAP`
	///
	/// `16/32/64-bit`
	Clac = 822,
	/// `STAC`
	///
	/// `NP 0F 01 CB`
	///
	/// `SMAP`
	///
	/// `16/32/64-bit`
	Stac = 823,
	/// `ENCLS`
	///
	/// `NP 0F 01 CF`
	///
	/// `SGX1`
	///
	/// `16/32/64-bit`
	Encls = 824,
	/// `XGETBV`
	///
	/// `NP 0F 01 D0`
	///
	/// `XSAVE`
	///
	/// `16/32/64-bit`
	Xgetbv = 825,
	/// `XSETBV`
	///
	/// `NP 0F 01 D1`
	///
	/// `XSAVE`
	///
	/// `16/32/64-bit`
	Xsetbv = 826,
	/// `VMFUNC`
	///
	/// `NP 0F 01 D4`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmfunc = 827,
	/// `XEND`
	///
	/// `NP 0F 01 D5`
	///
	/// `RTM`
	///
	/// `16/32/64-bit`
	Xend = 828,
	/// `XTEST`
	///
	/// `NP 0F 01 D6`
	///
	/// `HLE or RTM`
	///
	/// `16/32/64-bit`
	Xtest = 829,
	/// `ENCLU`
	///
	/// `NP 0F 01 D7`
	///
	/// `SGX1`
	///
	/// `16/32/64-bit`
	Enclu = 830,
	/// `VMRUN`
	///
	/// `a16 0F 01 D8`
	///
	/// `SVM`
	///
	/// `16/32-bit`
	Vmrunw = 831,
	/// `VMRUN`
	///
	/// `a32 0F 01 D8`
	///
	/// `SVM`
	///
	/// `16/32/64-bit`
	Vmrund = 832,
	/// `VMRUN`
	///
	/// `a64 0F 01 D8`
	///
	/// `SVM`
	///
	/// `64-bit`
	Vmrunq = 833,
	/// `VMMCALL`
	///
	/// `0F 01 D9`
	///
	/// `SVM`
	///
	/// `16/32/64-bit`
	Vmmcall = 834,
	/// `VMLOAD`
	///
	/// `a16 0F 01 DA`
	///
	/// `SVM`
	///
	/// `16/32-bit`
	Vmloadw = 835,
	/// `VMLOAD`
	///
	/// `a32 0F 01 DA`
	///
	/// `SVM`
	///
	/// `16/32/64-bit`
	Vmloadd = 836,
	/// `VMLOAD`
	///
	/// `a64 0F 01 DA`
	///
	/// `SVM`
	///
	/// `64-bit`
	Vmloadq = 837,
	/// `VMSAVE`
	///
	/// `a16 0F 01 DB`
	///
	/// `SVM`
	///
	/// `16/32-bit`
	Vmsavew = 838,
	/// `VMSAVE`
	///
	/// `a32 0F 01 DB`
	///
	/// `SVM`
	///
	/// `16/32/64-bit`
	Vmsaved = 839,
	/// `VMSAVE`
	///
	/// `a64 0F 01 DB`
	///
	/// `SVM`
	///
	/// `64-bit`
	Vmsaveq = 840,
	/// `STGI`
	///
	/// `0F 01 DC`
	///
	/// `SKINIT or SVM`
	///
	/// `16/32/64-bit`
	Stgi = 841,
	/// `CLGI`
	///
	/// `0F 01 DD`
	///
	/// `SVM`
	///
	/// `16/32/64-bit`
	Clgi = 842,
	/// `SKINIT`
	///
	/// `0F 01 DE`
	///
	/// `SKINIT or SVM`
	///
	/// `16/32/64-bit`
	Skinit = 843,
	/// `INVLPGA`
	///
	/// `a16 0F 01 DF`
	///
	/// `SVM`
	///
	/// `16/32-bit`
	Invlpgaw = 844,
	/// `INVLPGA`
	///
	/// `a32 0F 01 DF`
	///
	/// `SVM`
	///
	/// `16/32/64-bit`
	Invlpgad = 845,
	/// `INVLPGA`
	///
	/// `a64 0F 01 DF`
	///
	/// `SVM`
	///
	/// `64-bit`
	Invlpgaq = 846,
	/// `SETSSBSY`
	///
	/// `F3 0F 01 E8`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Setssbsy = 847,
	/// `SAVEPREVSSP`
	///
	/// `F3 0F 01 EA`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Saveprevssp = 848,
	/// `RDPKRU`
	///
	/// `NP 0F 01 EE`
	///
	/// `PKU`
	///
	/// `16/32/64-bit`
	Rdpkru = 849,
	/// `WRPKRU`
	///
	/// `NP 0F 01 EF`
	///
	/// `PKU`
	///
	/// `16/32/64-bit`
	Wrpkru = 850,
	/// `SWAPGS`
	///
	/// `0F 01 F8`
	///
	/// `X64`
	///
	/// `64-bit`
	Swapgs = 851,
	/// `RDTSCP`
	///
	/// `0F 01 F9`
	///
	/// `RDTSCP`
	///
	/// `16/32/64-bit`
	Rdtscp = 852,
	/// `MONITORX`
	///
	/// `a16 NP 0F 01 FA`
	///
	/// `MONITORX`
	///
	/// `16/32-bit`
	Monitorxw = 853,
	/// `MONITORX`
	///
	/// `a32 NP 0F 01 FA`
	///
	/// `MONITORX`
	///
	/// `16/32/64-bit`
	Monitorxd = 854,
	/// `MONITORX`
	///
	/// `a64 NP 0F 01 FA`
	///
	/// `MONITORX`
	///
	/// `64-bit`
	Monitorxq = 855,
	/// `MCOMMIT`
	///
	/// `F3 0F 01 FA`
	///
	/// `MCOMMIT`
	///
	/// `16/32/64-bit`
	Mcommit = 856,
	/// `MWAITX`
	///
	/// `NP 0F 01 FB`
	///
	/// `MONITORX`
	///
	/// `16/32/64-bit`
	Mwaitx = 857,
	/// `CLZERO`
	///
	/// `a16 0F 01 FC`
	///
	/// `CLZERO`
	///
	/// `16/32-bit`
	Clzerow = 858,
	/// `CLZERO`
	///
	/// `a32 0F 01 FC`
	///
	/// `CLZERO`
	///
	/// `16/32/64-bit`
	Clzerod = 859,
	/// `CLZERO`
	///
	/// `a64 0F 01 FC`
	///
	/// `CLZERO`
	///
	/// `64-bit`
	Clzeroq = 860,
	/// `RDPRU`
	///
	/// `0F 01 FD`
	///
	/// `RDPRU`
	///
	/// `16/32/64-bit`
	Rdpru = 861,
	/// `LAR r16, r/m16`
	///
	/// `o16 0F 02 /r`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Lar_r16_rm16 = 862,
	/// `LAR r32, r32/m16`
	///
	/// `o32 0F 02 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lar_r32_r32m16 = 863,
	/// `LAR r64, r64/m16`
	///
	/// `o64 0F 02 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Lar_r64_r64m16 = 864,
	/// `LSL r16, r/m16`
	///
	/// `o16 0F 03 /r`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Lsl_r16_rm16 = 865,
	/// `LSL r32, r32/m16`
	///
	/// `o32 0F 03 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lsl_r32_r32m16 = 866,
	/// `LSL r64, r64/m16`
	///
	/// `o64 0F 03 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Lsl_r64_r64m16 = 867,
	/// `STOREALL`
	///
	/// `0F 04`
	///
	/// `286`
	///
	/// `16/32-bit`
	Storeall = 868,
	/// `LOADALL`
	///
	/// `0F 05`
	///
	/// `286`
	///
	/// `16/32-bit`
	Loadall286 = 869,
	/// `SYSCALL`
	///
	/// `0F 05`
	///
	/// `SYSCALL`
	///
	/// `16/32/64-bit`
	Syscall = 870,
	/// `CLTS`
	///
	/// `0F 06`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Clts = 871,
	/// `LOADALL`
	///
	/// `0F 07`
	///
	/// `386`
	///
	/// `16/32-bit`
	Loadall386 = 872,
	/// `SYSRET`
	///
	/// `0F 07`
	///
	/// `SYSCALL`
	///
	/// `16/32/64-bit`
	Sysretd = 873,
	/// `SYSRETQ`
	///
	/// `o64 0F 07`
	///
	/// `SYSCALL`
	///
	/// `64-bit`
	Sysretq = 874,
	/// `INVD`
	///
	/// `0F 08`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Invd = 875,
	/// `WBINVD`
	///
	/// `0F 09`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Wbinvd = 876,
	/// `WBNOINVD`
	///
	/// `F3 0F 09`
	///
	/// `WBNOINVD`
	///
	/// `16/32/64-bit`
	Wbnoinvd = 877,
	/// `CL1INVMB`
	///
	/// `0F 0A`
	///
	/// `CL1INVMB`
	///
	/// `16/32-bit`
	Cl1invmb = 878,
	/// `UD2`
	///
	/// `0F 0B`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Ud2 = 879,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 0D /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F0D = 880,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 0D /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F0D = 881,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 0D /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F0D = 882,
	/// `PREFETCH m8`
	///
	/// `0F 0D /0`
	///
	/// `PREFETCHW`
	///
	/// `16/32/64-bit`
	Prefetch_m8 = 883,
	/// `PREFETCHW m8`
	///
	/// `0F 0D /1`
	///
	/// `PREFETCHW`
	///
	/// `16/32/64-bit`
	Prefetchw_m8 = 884,
	/// `PREFETCHWT1 m8`
	///
	/// `0F 0D /2`
	///
	/// `PREFETCHWT1`
	///
	/// `16/32/64-bit`
	Prefetchwt1_m8 = 885,
	/// `FEMMS`
	///
	/// `0F 0E`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	Femms = 886,
	/// `UMOV r/m8, r8`
	///
	/// `0F 10 /r`
	///
	/// `386/486`
	///
	/// `16/32-bit`
	Umov_rm8_r8 = 887,
	/// `UMOV r/m16, r16`
	///
	/// `o16 0F 11 /r`
	///
	/// `386/486`
	///
	/// `16/32-bit`
	Umov_rm16_r16 = 888,
	/// `UMOV r/m32, r32`
	///
	/// `o32 0F 11 /r`
	///
	/// `386/486`
	///
	/// `16/32-bit`
	Umov_rm32_r32 = 889,
	/// `UMOV r8, r/m8`
	///
	/// `0F 12 /r`
	///
	/// `386/486`
	///
	/// `16/32-bit`
	Umov_r8_rm8 = 890,
	/// `UMOV r16, r/m16`
	///
	/// `o16 0F 13 /r`
	///
	/// `386/486`
	///
	/// `16/32-bit`
	Umov_r16_rm16 = 891,
	/// `UMOV r32, r/m32`
	///
	/// `o32 0F 13 /r`
	///
	/// `386/486`
	///
	/// `16/32-bit`
	Umov_r32_rm32 = 892,
	/// `MOVUPS xmm1, xmm2/m128`
	///
	/// `NP 0F 10 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movups_xmm_xmmm128 = 893,
	/// `VMOVUPS xmm1, xmm2/m128`
	///
	/// `VEX.128.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovups_xmm_xmmm128 = 894,
	/// `VMOVUPS ymm1, ymm2/m256`
	///
	/// `VEX.256.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovups_ymm_ymmm256 = 895,
	/// `VMOVUPS xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.0F.W0 10 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovups_xmm_k1z_xmmm128 = 896,
	/// `VMOVUPS ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.0F.W0 10 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovups_ymm_k1z_ymmm256 = 897,
	/// `VMOVUPS zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.0F.W0 10 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovups_zmm_k1z_zmmm512 = 898,
	/// `MOVUPD xmm1, xmm2/m128`
	///
	/// `66 0F 10 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movupd_xmm_xmmm128 = 899,
	/// `VMOVUPD xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovupd_xmm_xmmm128 = 900,
	/// `VMOVUPD ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovupd_ymm_ymmm256 = 901,
	/// `VMOVUPD xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F.W1 10 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovupd_xmm_k1z_xmmm128 = 902,
	/// `VMOVUPD ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F.W1 10 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovupd_ymm_k1z_ymmm256 = 903,
	/// `VMOVUPD zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F.W1 10 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovupd_zmm_k1z_zmmm512 = 904,
	/// `MOVSS xmm1, xmm2/m32`
	///
	/// `F3 0F 10 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movss_xmm_xmmm32 = 905,
	/// `VMOVSS xmm1, xmm2, xmm3`
	///
	/// `VEX.LIG.F3.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovss_xmm_xmm_xmm = 906,
	/// `VMOVSS xmm1, m32`
	///
	/// `VEX.LIG.F3.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovss_xmm_m32 = 907,
	/// `VMOVSS xmm1 {k1}{z}, xmm2, xmm3`
	///
	/// `EVEX.LIG.F3.0F.W0 10 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovss_xmm_k1z_xmm_xmm = 908,
	/// `VMOVSS xmm1 {k1}{z}, m32`
	///
	/// `EVEX.LIG.F3.0F.W0 10 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovss_xmm_k1z_m32 = 909,
	/// `MOVSD xmm1, xmm2/m64`
	///
	/// `F2 0F 10 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movsd_xmm_xmmm64 = 910,
	/// `VMOVSD xmm1, xmm2, xmm3`
	///
	/// `VEX.LIG.F2.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovsd_xmm_xmm_xmm = 911,
	/// `VMOVSD xmm1, m64`
	///
	/// `VEX.LIG.F2.0F.WIG 10 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovsd_xmm_m64 = 912,
	/// `VMOVSD xmm1 {k1}{z}, xmm2, xmm3`
	///
	/// `EVEX.LIG.F2.0F.W1 10 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsd_xmm_k1z_xmm_xmm = 913,
	/// `VMOVSD xmm1 {k1}{z}, m64`
	///
	/// `EVEX.LIG.F2.0F.W1 10 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsd_xmm_k1z_m64 = 914,
	/// `MOVUPS xmm2/m128, xmm1`
	///
	/// `NP 0F 11 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movups_xmmm128_xmm = 915,
	/// `VMOVUPS xmm2/m128, xmm1`
	///
	/// `VEX.128.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovups_xmmm128_xmm = 916,
	/// `VMOVUPS ymm2/m256, ymm1`
	///
	/// `VEX.256.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovups_ymmm256_ymm = 917,
	/// `VMOVUPS xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.0F.W0 11 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovups_xmmm128_k1z_xmm = 918,
	/// `VMOVUPS ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.0F.W0 11 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovups_ymmm256_k1z_ymm = 919,
	/// `VMOVUPS zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.0F.W0 11 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovups_zmmm512_k1z_zmm = 920,
	/// `MOVUPD xmm2/m128, xmm1`
	///
	/// `66 0F 11 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movupd_xmmm128_xmm = 921,
	/// `VMOVUPD xmm2/m128, xmm1`
	///
	/// `VEX.128.66.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovupd_xmmm128_xmm = 922,
	/// `VMOVUPD ymm2/m256, ymm1`
	///
	/// `VEX.256.66.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovupd_ymmm256_ymm = 923,
	/// `VMOVUPD xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.66.0F.W1 11 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovupd_xmmm128_k1z_xmm = 924,
	/// `VMOVUPD ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.66.0F.W1 11 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovupd_ymmm256_k1z_ymm = 925,
	/// `VMOVUPD zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.66.0F.W1 11 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovupd_zmmm512_k1z_zmm = 926,
	/// `MOVSS xmm2/m32, xmm1`
	///
	/// `F3 0F 11 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movss_xmmm32_xmm = 927,
	/// `VMOVSS xmm1, xmm2, xmm3`
	///
	/// `VEX.LIG.F3.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovss_xmm_xmm_xmm_0F11 = 928,
	/// `VMOVSS m32, xmm1`
	///
	/// `VEX.LIG.F3.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovss_m32_xmm = 929,
	/// `VMOVSS xmm1 {k1}{z}, xmm2, xmm3`
	///
	/// `EVEX.LIG.F3.0F.W0 11 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovss_xmm_k1z_xmm_xmm_0F11 = 930,
	/// `VMOVSS m32 {k1}, xmm1`
	///
	/// `EVEX.LIG.F3.0F.W0 11 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovss_m32_k1_xmm = 931,
	/// `MOVSD xmm1/m64, xmm2`
	///
	/// `F2 0F 11 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movsd_xmmm64_xmm = 932,
	/// `VMOVSD xmm1, xmm2, xmm3`
	///
	/// `VEX.LIG.F2.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovsd_xmm_xmm_xmm_0F11 = 933,
	/// `VMOVSD m64, xmm1`
	///
	/// `VEX.LIG.F2.0F.WIG 11 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovsd_m64_xmm = 934,
	/// `VMOVSD xmm1 {k1}{z}, xmm2, xmm3`
	///
	/// `EVEX.LIG.F2.0F.W1 11 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsd_xmm_k1z_xmm_xmm_0F11 = 935,
	/// `VMOVSD m64 {k1}, xmm1`
	///
	/// `EVEX.LIG.F2.0F.W1 11 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsd_m64_k1_xmm = 936,
	/// `MOVHLPS xmm1, xmm2`
	///
	/// `NP 0F 12 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movhlps_xmm_xmm = 937,
	/// `MOVLPS xmm1, m64`
	///
	/// `NP 0F 12 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movlps_xmm_m64 = 938,
	/// `VMOVHLPS xmm1, xmm2, xmm3`
	///
	/// `VEX.128.0F.WIG 12 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovhlps_xmm_xmm_xmm = 939,
	/// `VMOVLPS xmm2, xmm1, m64`
	///
	/// `VEX.128.0F.WIG 12 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovlps_xmm_xmm_m64 = 940,
	/// `VMOVHLPS xmm1, xmm2, xmm3`
	///
	/// `EVEX.128.0F.W0 12 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovhlps_xmm_xmm_xmm = 941,
	/// `VMOVLPS xmm2, xmm1, m64`
	///
	/// `EVEX.128.0F.W0 12 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovlps_xmm_xmm_m64 = 942,
	/// `MOVLPD xmm1, m64`
	///
	/// `66 0F 12 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movlpd_xmm_m64 = 943,
	/// `VMOVLPD xmm2, xmm1, m64`
	///
	/// `VEX.128.66.0F.WIG 12 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovlpd_xmm_xmm_m64 = 944,
	/// `VMOVLPD xmm2, xmm1, m64`
	///
	/// `EVEX.128.66.0F.W1 12 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovlpd_xmm_xmm_m64 = 945,
	/// `MOVSLDUP xmm1, xmm2/m128`
	///
	/// `F3 0F 12 /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Movsldup_xmm_xmmm128 = 946,
	/// `VMOVSLDUP xmm1, xmm2/m128`
	///
	/// `VEX.128.F3.0F.WIG 12 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovsldup_xmm_xmmm128 = 947,
	/// `VMOVSLDUP ymm1, ymm2/m256`
	///
	/// `VEX.256.F3.0F.WIG 12 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovsldup_ymm_ymmm256 = 948,
	/// `VMOVSLDUP xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.F3.0F.W0 12 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsldup_xmm_k1z_xmmm128 = 949,
	/// `VMOVSLDUP ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.F3.0F.W0 12 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsldup_ymm_k1z_ymmm256 = 950,
	/// `VMOVSLDUP zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.F3.0F.W0 12 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsldup_zmm_k1z_zmmm512 = 951,
	/// `MOVDDUP xmm1, xmm2/m64`
	///
	/// `F2 0F 12 /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Movddup_xmm_xmmm64 = 952,
	/// `VMOVDDUP xmm1, xmm2/m64`
	///
	/// `VEX.128.F2.0F.WIG 12 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovddup_xmm_xmmm64 = 953,
	/// `VMOVDDUP ymm1, ymm2/m256`
	///
	/// `VEX.256.F2.0F.WIG 12 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovddup_ymm_ymmm256 = 954,
	/// `VMOVDDUP xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.F2.0F.W1 12 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovddup_xmm_k1z_xmmm64 = 955,
	/// `VMOVDDUP ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.F2.0F.W1 12 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovddup_ymm_k1z_ymmm256 = 956,
	/// `VMOVDDUP zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.F2.0F.W1 12 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovddup_zmm_k1z_zmmm512 = 957,
	/// `MOVLPS m64, xmm1`
	///
	/// `NP 0F 13 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movlps_m64_xmm = 958,
	/// `VMOVLPS m64, xmm1`
	///
	/// `VEX.128.0F.WIG 13 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovlps_m64_xmm = 959,
	/// `VMOVLPS m64, xmm1`
	///
	/// `EVEX.128.0F.W0 13 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovlps_m64_xmm = 960,
	/// `MOVLPD m64, xmm1`
	///
	/// `66 0F 13 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movlpd_m64_xmm = 961,
	/// `VMOVLPD m64, xmm1`
	///
	/// `VEX.128.66.0F.WIG 13 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovlpd_m64_xmm = 962,
	/// `VMOVLPD m64, xmm1`
	///
	/// `EVEX.128.66.0F.W1 13 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovlpd_m64_xmm = 963,
	/// `UNPCKLPS xmm1, xmm2/m128`
	///
	/// `NP 0F 14 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Unpcklps_xmm_xmmm128 = 964,
	/// `VUNPCKLPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 14 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpcklps_xmm_xmm_xmmm128 = 965,
	/// `VUNPCKLPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 14 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpcklps_ymm_ymm_ymmm256 = 966,
	/// `VUNPCKLPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpcklps_xmm_k1z_xmm_xmmm128b32 = 967,
	/// `VUNPCKLPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpcklps_ymm_k1z_ymm_ymmm256b32 = 968,
	/// `VUNPCKLPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.0F.W0 14 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpcklps_zmm_k1z_zmm_zmmm512b32 = 969,
	/// `UNPCKLPD xmm1, xmm2/m128`
	///
	/// `66 0F 14 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Unpcklpd_xmm_xmmm128 = 970,
	/// `VUNPCKLPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 14 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpcklpd_xmm_xmm_xmmm128 = 971,
	/// `VUNPCKLPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 14 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpcklpd_ymm_ymm_ymmm256 = 972,
	/// `VUNPCKLPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpcklpd_xmm_k1z_xmm_xmmm128b64 = 973,
	/// `VUNPCKLPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpcklpd_ymm_k1z_ymm_ymmm256b64 = 974,
	/// `VUNPCKLPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 14 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpcklpd_zmm_k1z_zmm_zmmm512b64 = 975,
	/// `UNPCKHPS xmm1, xmm2/m128`
	///
	/// `NP 0F 15 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Unpckhps_xmm_xmmm128 = 976,
	/// `VUNPCKHPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 15 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpckhps_xmm_xmm_xmmm128 = 977,
	/// `VUNPCKHPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 15 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpckhps_ymm_ymm_ymmm256 = 978,
	/// `VUNPCKHPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpckhps_xmm_k1z_xmm_xmmm128b32 = 979,
	/// `VUNPCKHPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpckhps_ymm_k1z_ymm_ymmm256b32 = 980,
	/// `VUNPCKHPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.0F.W0 15 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpckhps_zmm_k1z_zmm_zmmm512b32 = 981,
	/// `UNPCKHPD xmm1, xmm2/m128`
	///
	/// `66 0F 15 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Unpckhpd_xmm_xmmm128 = 982,
	/// `VUNPCKHPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 15 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpckhpd_xmm_xmm_xmmm128 = 983,
	/// `VUNPCKHPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 15 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vunpckhpd_ymm_ymm_ymmm256 = 984,
	/// `VUNPCKHPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpckhpd_xmm_k1z_xmm_xmmm128b64 = 985,
	/// `VUNPCKHPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpckhpd_ymm_k1z_ymm_ymmm256b64 = 986,
	/// `VUNPCKHPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 15 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vunpckhpd_zmm_k1z_zmm_zmmm512b64 = 987,
	/// `MOVLHPS xmm1, xmm2`
	///
	/// `NP 0F 16 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movlhps_xmm_xmm = 988,
	/// `VMOVLHPS xmm1, xmm2, xmm3`
	///
	/// `VEX.128.0F.WIG 16 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovlhps_xmm_xmm_xmm = 989,
	/// `VMOVLHPS xmm1, xmm2, xmm3`
	///
	/// `EVEX.128.0F.W0 16 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovlhps_xmm_xmm_xmm = 990,
	/// `MOVHPS xmm1, m64`
	///
	/// `NP 0F 16 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movhps_xmm_m64 = 991,
	/// `VMOVHPS xmm2, xmm1, m64`
	///
	/// `VEX.128.0F.WIG 16 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovhps_xmm_xmm_m64 = 992,
	/// `VMOVHPS xmm2, xmm1, m64`
	///
	/// `EVEX.128.0F.W0 16 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovhps_xmm_xmm_m64 = 993,
	/// `MOVHPD xmm1, m64`
	///
	/// `66 0F 16 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movhpd_xmm_m64 = 994,
	/// `VMOVHPD xmm2, xmm1, m64`
	///
	/// `VEX.128.66.0F.WIG 16 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovhpd_xmm_xmm_m64 = 995,
	/// `VMOVHPD xmm2, xmm1, m64`
	///
	/// `EVEX.128.66.0F.W1 16 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovhpd_xmm_xmm_m64 = 996,
	/// `MOVSHDUP xmm1, xmm2/m128`
	///
	/// `F3 0F 16 /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Movshdup_xmm_xmmm128 = 997,
	/// `VMOVSHDUP xmm1, xmm2/m128`
	///
	/// `VEX.128.F3.0F.WIG 16 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovshdup_xmm_xmmm128 = 998,
	/// `VMOVSHDUP ymm1, ymm2/m256`
	///
	/// `VEX.256.F3.0F.WIG 16 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovshdup_ymm_ymmm256 = 999,
	/// `VMOVSHDUP xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.F3.0F.W0 16 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovshdup_xmm_k1z_xmmm128 = 1000,
	/// `VMOVSHDUP ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.F3.0F.W0 16 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovshdup_ymm_k1z_ymmm256 = 1001,
	/// `VMOVSHDUP zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.F3.0F.W0 16 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovshdup_zmm_k1z_zmmm512 = 1002,
	/// `MOVHPS m64, xmm1`
	///
	/// `NP 0F 17 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movhps_m64_xmm = 1003,
	/// `VMOVHPS m64, xmm1`
	///
	/// `VEX.128.0F.WIG 17 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovhps_m64_xmm = 1004,
	/// `VMOVHPS m64, xmm1`
	///
	/// `EVEX.128.0F.W0 17 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovhps_m64_xmm = 1005,
	/// `MOVHPD m64, xmm1`
	///
	/// `66 0F 17 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movhpd_m64_xmm = 1006,
	/// `VMOVHPD m64, xmm1`
	///
	/// `VEX.128.66.0F.WIG 17 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovhpd_m64_xmm = 1007,
	/// `VMOVHPD m64, xmm1`
	///
	/// `EVEX.128.66.0F.W1 17 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovhpd_m64_xmm = 1008,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 18 /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F18 = 1009,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 18 /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F18 = 1010,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 18 /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F18 = 1011,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 19 /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F19 = 1012,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 19 /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F19 = 1013,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 19 /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F19 = 1014,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 1A /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F1A = 1015,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 1A /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F1A = 1016,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 1A /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F1A = 1017,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 1B /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F1B = 1018,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 1B /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F1B = 1019,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 1B /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F1B = 1020,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 1C /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F1C = 1021,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 1C /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F1C = 1022,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 1C /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F1C = 1023,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 1D /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F1D = 1024,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 1D /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F1D = 1025,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 1D /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F1D = 1026,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 1E /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F1E = 1027,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 1E /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F1E = 1028,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 1E /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F1E = 1029,
	/// `RESERVEDNOP r/m16, r16`
	///
	/// `o16 0F 1F /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm16_r16_0F1F = 1030,
	/// `RESERVEDNOP r/m32, r32`
	///
	/// `o32 0F 1F /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Reservednop_rm32_r32_0F1F = 1031,
	/// `RESERVEDNOP r/m64, r64`
	///
	/// `o64 0F 1F /r`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Reservednop_rm64_r64_0F1F = 1032,
	/// `PREFETCHNTA m8`
	///
	/// `0F 18 /0`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Prefetchnta_m8 = 1033,
	/// `PREFETCHT0 m8`
	///
	/// `0F 18 /1`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Prefetcht0_m8 = 1034,
	/// `PREFETCHT1 m8`
	///
	/// `0F 18 /2`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Prefetcht1_m8 = 1035,
	/// `PREFETCHT2 m8`
	///
	/// `0F 18 /3`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Prefetcht2_m8 = 1036,
	/// `BNDLDX bnd, mib`
	///
	/// `NP 0F 1A /r`
	///
	/// `MPX`
	///
	/// `16/32/64-bit`
	Bndldx_bnd_mib = 1037,
	/// `BNDMOV bnd1, bnd2/m64`
	///
	/// `66 0F 1A /r`
	///
	/// `MPX`
	///
	/// `16/32-bit`
	Bndmov_bnd_bndm64 = 1038,
	/// `BNDMOV bnd1, bnd2/m128`
	///
	/// `66 0F 1A /r`
	///
	/// `MPX`
	///
	/// `64-bit`
	Bndmov_bnd_bndm128 = 1039,
	/// `BNDCL bnd, r/m32`
	///
	/// `F3 0F 1A /r`
	///
	/// `MPX`
	///
	/// `16/32-bit`
	Bndcl_bnd_rm32 = 1040,
	/// `BNDCL bnd, r/m64`
	///
	/// `F3 0F 1A /r`
	///
	/// `MPX`
	///
	/// `64-bit`
	Bndcl_bnd_rm64 = 1041,
	/// `BNDCU bnd, r/m32`
	///
	/// `F2 0F 1A /r`
	///
	/// `MPX`
	///
	/// `16/32-bit`
	Bndcu_bnd_rm32 = 1042,
	/// `BNDCU bnd, r/m64`
	///
	/// `F2 0F 1A /r`
	///
	/// `MPX`
	///
	/// `64-bit`
	Bndcu_bnd_rm64 = 1043,
	/// `BNDSTX mib, bnd`
	///
	/// `NP 0F 1B /r`
	///
	/// `MPX`
	///
	/// `16/32/64-bit`
	Bndstx_mib_bnd = 1044,
	/// `BNDMOV bnd1/m64, bnd2`
	///
	/// `66 0F 1B /r`
	///
	/// `MPX`
	///
	/// `16/32-bit`
	Bndmov_bndm64_bnd = 1045,
	/// `BNDMOV bnd1/m128, bnd2`
	///
	/// `66 0F 1B /r`
	///
	/// `MPX`
	///
	/// `64-bit`
	Bndmov_bndm128_bnd = 1046,
	/// `BNDMK bnd, m32`
	///
	/// `F3 0F 1B /r`
	///
	/// `MPX`
	///
	/// `16/32-bit`
	Bndmk_bnd_m32 = 1047,
	/// `BNDMK bnd, m64`
	///
	/// `F3 0F 1B /r`
	///
	/// `MPX`
	///
	/// `64-bit`
	Bndmk_bnd_m64 = 1048,
	/// `BNDCN bnd, r/m32`
	///
	/// `F2 0F 1B /r`
	///
	/// `MPX`
	///
	/// `16/32-bit`
	Bndcn_bnd_rm32 = 1049,
	/// `BNDCN bnd, r/m64`
	///
	/// `F2 0F 1B /r`
	///
	/// `MPX`
	///
	/// `64-bit`
	Bndcn_bnd_rm64 = 1050,
	/// `CLDEMOTE m8`
	///
	/// `NP 0F 1C /0`
	///
	/// `CLDEMOTE`
	///
	/// `16/32/64-bit`
	Cldemote_m8 = 1051,
	/// `RDSSPD r32`
	///
	/// `F3 0F 1E /1`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Rdsspd_r32 = 1052,
	/// `RDSSPQ r64`
	///
	/// `F3 o64 0F 1E /1`
	///
	/// `CET_SS`
	///
	/// `64-bit`
	Rdsspq_r64 = 1053,
	/// `ENDBR64`
	///
	/// `F3 0F 1E FA`
	///
	/// `CET_IBT`
	///
	/// `16/32/64-bit`
	Endbr64 = 1054,
	/// `ENDBR32`
	///
	/// `F3 0F 1E FB`
	///
	/// `CET_IBT`
	///
	/// `16/32/64-bit`
	Endbr32 = 1055,
	/// `NOP r/m16`
	///
	/// `o16 0F 1F /0`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Nop_rm16 = 1056,
	/// `NOP r/m32`
	///
	/// `o32 0F 1F /0`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `16/32/64-bit`
	Nop_rm32 = 1057,
	/// `NOP r/m64`
	///
	/// `o64 0F 1F /0`
	///
	/// `CPUID.01H.EAX[Bits 11:8] = 0110B or 1111B`
	///
	/// `64-bit`
	Nop_rm64 = 1058,
	/// `MOV r32, cr`
	///
	/// `0F 20 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Mov_r32_cr = 1059,
	/// `MOV r64, cr`
	///
	/// `0F 20 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_r64_cr = 1060,
	/// `MOV r32, dr`
	///
	/// `0F 21 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Mov_r32_dr = 1061,
	/// `MOV r64, dr`
	///
	/// `0F 21 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_r64_dr = 1062,
	/// `MOV cr, r32`
	///
	/// `0F 22 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Mov_cr_r32 = 1063,
	/// `MOV cr, r64`
	///
	/// `0F 22 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_cr_r64 = 1064,
	/// `MOV dr, r32`
	///
	/// `0F 23 /r`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Mov_dr_r32 = 1065,
	/// `MOV dr, r64`
	///
	/// `0F 23 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Mov_dr_r64 = 1066,
	/// `MOV r32, tr`
	///
	/// `0F 24 /r`
	///
	/// `386/486/Cyrix/Geode`
	///
	/// `16/32-bit`
	Mov_r32_tr = 1067,
	/// `MOV tr, r32`
	///
	/// `0F 26 /r`
	///
	/// `386/486/Cyrix/Geode`
	///
	/// `16/32-bit`
	Mov_tr_r32 = 1068,
	/// `MOVAPS xmm1, xmm2/m128`
	///
	/// `NP 0F 28 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movaps_xmm_xmmm128 = 1069,
	/// `VMOVAPS xmm1, xmm2/m128`
	///
	/// `VEX.128.0F.WIG 28 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovaps_xmm_xmmm128 = 1070,
	/// `VMOVAPS ymm1, ymm2/m256`
	///
	/// `VEX.256.0F.WIG 28 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovaps_ymm_ymmm256 = 1071,
	/// `VMOVAPS xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.0F.W0 28 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovaps_xmm_k1z_xmmm128 = 1072,
	/// `VMOVAPS ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.0F.W0 28 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovaps_ymm_k1z_ymmm256 = 1073,
	/// `VMOVAPS zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.0F.W0 28 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovaps_zmm_k1z_zmmm512 = 1074,
	/// `MOVAPD xmm1, xmm2/m128`
	///
	/// `66 0F 28 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movapd_xmm_xmmm128 = 1075,
	/// `VMOVAPD xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F.WIG 28 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovapd_xmm_xmmm128 = 1076,
	/// `VMOVAPD ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F.WIG 28 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovapd_ymm_ymmm256 = 1077,
	/// `VMOVAPD xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F.W1 28 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovapd_xmm_k1z_xmmm128 = 1078,
	/// `VMOVAPD ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F.W1 28 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovapd_ymm_k1z_ymmm256 = 1079,
	/// `VMOVAPD zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F.W1 28 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovapd_zmm_k1z_zmmm512 = 1080,
	/// `MOVAPS xmm2/m128, xmm1`
	///
	/// `NP 0F 29 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movaps_xmmm128_xmm = 1081,
	/// `VMOVAPS xmm2/m128, xmm1`
	///
	/// `VEX.128.0F.WIG 29 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovaps_xmmm128_xmm = 1082,
	/// `VMOVAPS ymm2/m256, ymm1`
	///
	/// `VEX.256.0F.WIG 29 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovaps_ymmm256_ymm = 1083,
	/// `VMOVAPS xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.0F.W0 29 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovaps_xmmm128_k1z_xmm = 1084,
	/// `VMOVAPS ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.0F.W0 29 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovaps_ymmm256_k1z_ymm = 1085,
	/// `VMOVAPS zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.0F.W0 29 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovaps_zmmm512_k1z_zmm = 1086,
	/// `MOVAPD xmm2/m128, xmm1`
	///
	/// `66 0F 29 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movapd_xmmm128_xmm = 1087,
	/// `VMOVAPD xmm2/m128, xmm1`
	///
	/// `VEX.128.66.0F.WIG 29 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovapd_xmmm128_xmm = 1088,
	/// `VMOVAPD ymm2/m256, ymm1`
	///
	/// `VEX.256.66.0F.WIG 29 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovapd_ymmm256_ymm = 1089,
	/// `VMOVAPD xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.66.0F.W1 29 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovapd_xmmm128_k1z_xmm = 1090,
	/// `VMOVAPD ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.66.0F.W1 29 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovapd_ymmm256_k1z_ymm = 1091,
	/// `VMOVAPD zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.66.0F.W1 29 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovapd_zmmm512_k1z_zmm = 1092,
	/// `CVTPI2PS xmm, mm/m64`
	///
	/// `NP 0F 2A /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cvtpi2ps_xmm_mmm64 = 1093,
	/// `CVTPI2PD xmm, mm/m64`
	///
	/// `66 0F 2A /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtpi2pd_xmm_mmm64 = 1094,
	/// `CVTSI2SS xmm1, r/m32`
	///
	/// `F3 0F 2A /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cvtsi2ss_xmm_rm32 = 1095,
	/// `CVTSI2SS xmm1, r/m64`
	///
	/// `F3 o64 0F 2A /r`
	///
	/// `SSE`
	///
	/// `64-bit`
	Cvtsi2ss_xmm_rm64 = 1096,
	/// `VCVTSI2SS xmm1, xmm2, r/m32`
	///
	/// `VEX.LIG.F3.0F.W0 2A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtsi2ss_xmm_xmm_rm32 = 1097,
	/// `VCVTSI2SS xmm1, xmm2, r/m64`
	///
	/// `VEX.LIG.F3.0F.W1 2A /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vcvtsi2ss_xmm_xmm_rm64 = 1098,
	/// `VCVTSI2SS xmm1, xmm2, r/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 2A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsi2ss_xmm_xmm_rm32_er = 1099,
	/// `VCVTSI2SS xmm1, xmm2, r/m64{er}`
	///
	/// `EVEX.LIG.F3.0F.W1 2A /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtsi2ss_xmm_xmm_rm64_er = 1100,
	/// `CVTSI2SD xmm1, r/m32`
	///
	/// `F2 0F 2A /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtsi2sd_xmm_rm32 = 1101,
	/// `CVTSI2SD xmm1, r/m64`
	///
	/// `F2 o64 0F 2A /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Cvtsi2sd_xmm_rm64 = 1102,
	/// `VCVTSI2SD xmm1, xmm2, r/m32`
	///
	/// `VEX.LIG.F2.0F.W0 2A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtsi2sd_xmm_xmm_rm32 = 1103,
	/// `VCVTSI2SD xmm1, xmm2, r/m64`
	///
	/// `VEX.LIG.F2.0F.W1 2A /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vcvtsi2sd_xmm_xmm_rm64 = 1104,
	/// `VCVTSI2SD xmm1, xmm2, r/m32{er}`
	///
	/// `EVEX.LIG.F2.0F.W0 2A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsi2sd_xmm_xmm_rm32_er = 1105,
	/// `VCVTSI2SD xmm1, xmm2, r/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 2A /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtsi2sd_xmm_xmm_rm64_er = 1106,
	/// `MOVNTPS m128, xmm1`
	///
	/// `NP 0F 2B /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movntps_m128_xmm = 1107,
	/// `VMOVNTPS m128, xmm1`
	///
	/// `VEX.128.0F.WIG 2B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovntps_m128_xmm = 1108,
	/// `VMOVNTPS m256, ymm1`
	///
	/// `VEX.256.0F.WIG 2B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovntps_m256_ymm = 1109,
	/// `VMOVNTPS m128, xmm1`
	///
	/// `EVEX.128.0F.W0 2B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntps_m128_xmm = 1110,
	/// `VMOVNTPS m256, ymm1`
	///
	/// `EVEX.256.0F.W0 2B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntps_m256_ymm = 1111,
	/// `VMOVNTPS m512, zmm1`
	///
	/// `EVEX.512.0F.W0 2B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntps_m512_zmm = 1112,
	/// `MOVNTPD m128, xmm1`
	///
	/// `66 0F 2B /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movntpd_m128_xmm = 1113,
	/// `VMOVNTPD m128, xmm1`
	///
	/// `VEX.128.66.0F.WIG 2B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovntpd_m128_xmm = 1114,
	/// `VMOVNTPD m256, ymm1`
	///
	/// `VEX.256.66.0F.WIG 2B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovntpd_m256_ymm = 1115,
	/// `VMOVNTPD m128, xmm1`
	///
	/// `EVEX.128.66.0F.W1 2B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntpd_m128_xmm = 1116,
	/// `VMOVNTPD m256, ymm1`
	///
	/// `EVEX.256.66.0F.W1 2B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntpd_m256_ymm = 1117,
	/// `VMOVNTPD m512, zmm1`
	///
	/// `EVEX.512.66.0F.W1 2B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntpd_m512_zmm = 1118,
	/// `MOVNTSS m32, xmm1`
	///
	/// `F3 0F 2B /r`
	///
	/// `SSE4A`
	///
	/// `16/32/64-bit`
	Movntss_m32_xmm = 1119,
	/// `MOVNTSD m64, xmm1`
	///
	/// `F2 0F 2B /r`
	///
	/// `SSE4A`
	///
	/// `16/32/64-bit`
	Movntsd_m64_xmm = 1120,
	/// `CVTTPS2PI mm, xmm/m64`
	///
	/// `NP 0F 2C /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cvttps2pi_mm_xmmm64 = 1121,
	/// `CVTTPD2PI mm, xmm/m128`
	///
	/// `66 0F 2C /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvttpd2pi_mm_xmmm128 = 1122,
	/// `CVTTSS2SI r32, xmm1/m32`
	///
	/// `F3 0F 2C /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cvttss2si_r32_xmmm32 = 1123,
	/// `CVTTSS2SI r64, xmm1/m32`
	///
	/// `F3 o64 0F 2C /r`
	///
	/// `SSE`
	///
	/// `64-bit`
	Cvttss2si_r64_xmmm32 = 1124,
	/// `VCVTTSS2SI r32, xmm1/m32`
	///
	/// `VEX.LIG.F3.0F.W0 2C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvttss2si_r32_xmmm32 = 1125,
	/// `VCVTTSS2SI r64, xmm1/m32`
	///
	/// `VEX.LIG.F3.0F.W1 2C /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vcvttss2si_r64_xmmm32 = 1126,
	/// `VCVTTSS2SI r32, xmm1/m32{sae}`
	///
	/// `EVEX.LIG.F3.0F.W0 2C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttss2si_r32_xmmm32_sae = 1127,
	/// `VCVTTSS2SI r64, xmm1/m32{sae}`
	///
	/// `EVEX.LIG.F3.0F.W1 2C /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvttss2si_r64_xmmm32_sae = 1128,
	/// `CVTTSD2SI r32, xmm1/m64`
	///
	/// `F2 0F 2C /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvttsd2si_r32_xmmm64 = 1129,
	/// `CVTTSD2SI r64, xmm1/m64`
	///
	/// `F2 o64 0F 2C /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Cvttsd2si_r64_xmmm64 = 1130,
	/// `VCVTTSD2SI r32, xmm1/m64`
	///
	/// `VEX.LIG.F2.0F.W0 2C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvttsd2si_r32_xmmm64 = 1131,
	/// `VCVTTSD2SI r64, xmm1/m64`
	///
	/// `VEX.LIG.F2.0F.W1 2C /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vcvttsd2si_r64_xmmm64 = 1132,
	/// `VCVTTSD2SI r32, xmm1/m64{sae}`
	///
	/// `EVEX.LIG.F2.0F.W0 2C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttsd2si_r32_xmmm64_sae = 1133,
	/// `VCVTTSD2SI r64, xmm1/m64{sae}`
	///
	/// `EVEX.LIG.F2.0F.W1 2C /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvttsd2si_r64_xmmm64_sae = 1134,
	/// `CVTPS2PI mm, xmm/m64`
	///
	/// `NP 0F 2D /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cvtps2pi_mm_xmmm64 = 1135,
	/// `CVTPD2PI mm, xmm/m128`
	///
	/// `66 0F 2D /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtpd2pi_mm_xmmm128 = 1136,
	/// `CVTSS2SI r32, xmm1/m32`
	///
	/// `F3 0F 2D /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cvtss2si_r32_xmmm32 = 1137,
	/// `CVTSS2SI r64, xmm1/m32`
	///
	/// `F3 o64 0F 2D /r`
	///
	/// `SSE`
	///
	/// `64-bit`
	Cvtss2si_r64_xmmm32 = 1138,
	/// `VCVTSS2SI r32, xmm1/m32`
	///
	/// `VEX.LIG.F3.0F.W0 2D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtss2si_r32_xmmm32 = 1139,
	/// `VCVTSS2SI r64, xmm1/m32`
	///
	/// `VEX.LIG.F3.0F.W1 2D /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vcvtss2si_r64_xmmm32 = 1140,
	/// `VCVTSS2SI r32, xmm1/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 2D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtss2si_r32_xmmm32_er = 1141,
	/// `VCVTSS2SI r64, xmm1/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W1 2D /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtss2si_r64_xmmm32_er = 1142,
	/// `CVTSD2SI r32, xmm1/m64`
	///
	/// `F2 0F 2D /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtsd2si_r32_xmmm64 = 1143,
	/// `CVTSD2SI r64, xmm1/m64`
	///
	/// `F2 o64 0F 2D /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Cvtsd2si_r64_xmmm64 = 1144,
	/// `VCVTSD2SI r32, xmm1/m64`
	///
	/// `VEX.LIG.F2.0F.W0 2D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtsd2si_r32_xmmm64 = 1145,
	/// `VCVTSD2SI r64, xmm1/m64`
	///
	/// `VEX.LIG.F2.0F.W1 2D /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vcvtsd2si_r64_xmmm64 = 1146,
	/// `VCVTSD2SI r32, xmm1/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W0 2D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsd2si_r32_xmmm64_er = 1147,
	/// `VCVTSD2SI r64, xmm1/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 2D /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtsd2si_r64_xmmm64_er = 1148,
	/// `UCOMISS xmm1, xmm2/m32`
	///
	/// `NP 0F 2E /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Ucomiss_xmm_xmmm32 = 1149,
	/// `VUCOMISS xmm1, xmm2/m32`
	///
	/// `VEX.LIG.0F.WIG 2E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vucomiss_xmm_xmmm32 = 1150,
	/// `VUCOMISS xmm1, xmm2/m32{sae}`
	///
	/// `EVEX.LIG.0F.W0 2E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vucomiss_xmm_xmmm32_sae = 1151,
	/// `UCOMISD xmm1, xmm2/m64`
	///
	/// `66 0F 2E /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Ucomisd_xmm_xmmm64 = 1152,
	/// `VUCOMISD xmm1, xmm2/m64`
	///
	/// `VEX.LIG.66.0F.WIG 2E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vucomisd_xmm_xmmm64 = 1153,
	/// `VUCOMISD xmm1, xmm2/m64{sae}`
	///
	/// `EVEX.LIG.66.0F.W1 2E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vucomisd_xmm_xmmm64_sae = 1154,
	/// `COMISS xmm1, xmm2/m32`
	///
	/// `NP 0F 2F /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Comiss_xmm_xmmm32 = 1155,
	/// `COMISD xmm1, xmm2/m64`
	///
	/// `66 0F 2F /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Comisd_xmm_xmmm64 = 1156,
	/// `VCOMISS xmm1, xmm2/m32`
	///
	/// `VEX.LIG.0F.WIG 2F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcomiss_xmm_xmmm32 = 1157,
	/// `VCOMISD xmm1, xmm2/m64`
	///
	/// `VEX.LIG.66.0F.WIG 2F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcomisd_xmm_xmmm64 = 1158,
	/// `VCOMISS xmm1, xmm2/m32{sae}`
	///
	/// `EVEX.LIG.0F.W0 2F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcomiss_xmm_xmmm32_sae = 1159,
	/// `VCOMISD xmm1, xmm2/m64{sae}`
	///
	/// `EVEX.LIG.66.0F.W1 2F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcomisd_xmm_xmmm64_sae = 1160,
	/// `WRMSR`
	///
	/// `0F 30`
	///
	/// `MSR`
	///
	/// `16/32/64-bit`
	Wrmsr = 1161,
	/// `RDTSC`
	///
	/// `0F 31`
	///
	/// `TSC`
	///
	/// `16/32/64-bit`
	Rdtsc = 1162,
	/// `RDMSR`
	///
	/// `0F 32`
	///
	/// `MSR`
	///
	/// `16/32/64-bit`
	Rdmsr = 1163,
	/// `RDPMC`
	///
	/// `0F 33`
	///
	/// `Pentium MMX or later, or Pentium Pro or later`
	///
	/// `16/32/64-bit`
	Rdpmc = 1164,
	/// `SYSENTER`
	///
	/// `0F 34`
	///
	/// `SEP`
	///
	/// `16/32/64-bit`
	Sysenter = 1165,
	/// `SYSEXIT`
	///
	/// `0F 35`
	///
	/// `SEP`
	///
	/// `16/32/64-bit`
	Sysexitd = 1166,
	/// `SYSEXITQ`
	///
	/// `o64 0F 35`
	///
	/// `SEP`
	///
	/// `64-bit`
	Sysexitq = 1167,
	/// `GETSEC`
	///
	/// `NP 0F 37`
	///
	/// `SMX`
	///
	/// `16/32/64-bit`
	Getsecd = 1168,
	/// `CMOVO r16, r/m16`
	///
	/// `o16 0F 40 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovo_r16_rm16 = 1169,
	/// `CMOVO r32, r/m32`
	///
	/// `o32 0F 40 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovo_r32_rm32 = 1170,
	/// `CMOVO r64, r/m64`
	///
	/// `o64 0F 40 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovo_r64_rm64 = 1171,
	/// `CMOVNO r16, r/m16`
	///
	/// `o16 0F 41 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovno_r16_rm16 = 1172,
	/// `CMOVNO r32, r/m32`
	///
	/// `o32 0F 41 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovno_r32_rm32 = 1173,
	/// `CMOVNO r64, r/m64`
	///
	/// `o64 0F 41 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovno_r64_rm64 = 1174,
	/// `CMOVB r16, r/m16`
	///
	/// `o16 0F 42 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovb_r16_rm16 = 1175,
	/// `CMOVB r32, r/m32`
	///
	/// `o32 0F 42 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovb_r32_rm32 = 1176,
	/// `CMOVB r64, r/m64`
	///
	/// `o64 0F 42 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovb_r64_rm64 = 1177,
	/// `CMOVAE r16, r/m16`
	///
	/// `o16 0F 43 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovae_r16_rm16 = 1178,
	/// `CMOVAE r32, r/m32`
	///
	/// `o32 0F 43 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovae_r32_rm32 = 1179,
	/// `CMOVAE r64, r/m64`
	///
	/// `o64 0F 43 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovae_r64_rm64 = 1180,
	/// `CMOVE r16, r/m16`
	///
	/// `o16 0F 44 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmove_r16_rm16 = 1181,
	/// `CMOVE r32, r/m32`
	///
	/// `o32 0F 44 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmove_r32_rm32 = 1182,
	/// `CMOVE r64, r/m64`
	///
	/// `o64 0F 44 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmove_r64_rm64 = 1183,
	/// `CMOVNE r16, r/m16`
	///
	/// `o16 0F 45 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovne_r16_rm16 = 1184,
	/// `CMOVNE r32, r/m32`
	///
	/// `o32 0F 45 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovne_r32_rm32 = 1185,
	/// `CMOVNE r64, r/m64`
	///
	/// `o64 0F 45 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovne_r64_rm64 = 1186,
	/// `CMOVBE r16, r/m16`
	///
	/// `o16 0F 46 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovbe_r16_rm16 = 1187,
	/// `CMOVBE r32, r/m32`
	///
	/// `o32 0F 46 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovbe_r32_rm32 = 1188,
	/// `CMOVBE r64, r/m64`
	///
	/// `o64 0F 46 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovbe_r64_rm64 = 1189,
	/// `CMOVA r16, r/m16`
	///
	/// `o16 0F 47 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmova_r16_rm16 = 1190,
	/// `CMOVA r32, r/m32`
	///
	/// `o32 0F 47 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmova_r32_rm32 = 1191,
	/// `CMOVA r64, r/m64`
	///
	/// `o64 0F 47 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmova_r64_rm64 = 1192,
	/// `CMOVS r16, r/m16`
	///
	/// `o16 0F 48 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovs_r16_rm16 = 1193,
	/// `CMOVS r32, r/m32`
	///
	/// `o32 0F 48 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovs_r32_rm32 = 1194,
	/// `CMOVS r64, r/m64`
	///
	/// `o64 0F 48 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovs_r64_rm64 = 1195,
	/// `CMOVNS r16, r/m16`
	///
	/// `o16 0F 49 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovns_r16_rm16 = 1196,
	/// `CMOVNS r32, r/m32`
	///
	/// `o32 0F 49 /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovns_r32_rm32 = 1197,
	/// `CMOVNS r64, r/m64`
	///
	/// `o64 0F 49 /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovns_r64_rm64 = 1198,
	/// `CMOVP r16, r/m16`
	///
	/// `o16 0F 4A /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovp_r16_rm16 = 1199,
	/// `CMOVP r32, r/m32`
	///
	/// `o32 0F 4A /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovp_r32_rm32 = 1200,
	/// `CMOVP r64, r/m64`
	///
	/// `o64 0F 4A /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovp_r64_rm64 = 1201,
	/// `CMOVNP r16, r/m16`
	///
	/// `o16 0F 4B /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovnp_r16_rm16 = 1202,
	/// `CMOVNP r32, r/m32`
	///
	/// `o32 0F 4B /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovnp_r32_rm32 = 1203,
	/// `CMOVNP r64, r/m64`
	///
	/// `o64 0F 4B /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovnp_r64_rm64 = 1204,
	/// `CMOVL r16, r/m16`
	///
	/// `o16 0F 4C /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovl_r16_rm16 = 1205,
	/// `CMOVL r32, r/m32`
	///
	/// `o32 0F 4C /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovl_r32_rm32 = 1206,
	/// `CMOVL r64, r/m64`
	///
	/// `o64 0F 4C /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovl_r64_rm64 = 1207,
	/// `CMOVGE r16, r/m16`
	///
	/// `o16 0F 4D /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovge_r16_rm16 = 1208,
	/// `CMOVGE r32, r/m32`
	///
	/// `o32 0F 4D /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovge_r32_rm32 = 1209,
	/// `CMOVGE r64, r/m64`
	///
	/// `o64 0F 4D /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovge_r64_rm64 = 1210,
	/// `CMOVLE r16, r/m16`
	///
	/// `o16 0F 4E /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovle_r16_rm16 = 1211,
	/// `CMOVLE r32, r/m32`
	///
	/// `o32 0F 4E /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovle_r32_rm32 = 1212,
	/// `CMOVLE r64, r/m64`
	///
	/// `o64 0F 4E /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovle_r64_rm64 = 1213,
	/// `CMOVG r16, r/m16`
	///
	/// `o16 0F 4F /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovg_r16_rm16 = 1214,
	/// `CMOVG r32, r/m32`
	///
	/// `o32 0F 4F /r`
	///
	/// `CMOV`
	///
	/// `16/32/64-bit`
	Cmovg_r32_rm32 = 1215,
	/// `CMOVG r64, r/m64`
	///
	/// `o64 0F 4F /r`
	///
	/// `CMOV`
	///
	/// `64-bit`
	Cmovg_r64_rm64 = 1216,
	/// `KANDW k1, k2, k3`
	///
	/// `VEX.L1.0F.W0 41 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kandw_kr_kr_kr = 1217,
	/// `KANDQ k1, k2, k3`
	///
	/// `VEX.L1.0F.W1 41 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kandq_kr_kr_kr = 1218,
	/// `KANDB k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W0 41 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kandb_kr_kr_kr = 1219,
	/// `KANDD k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W1 41 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kandd_kr_kr_kr = 1220,
	/// `KANDNW k1, k2, k3`
	///
	/// `VEX.L1.0F.W0 42 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kandnw_kr_kr_kr = 1221,
	/// `KANDNQ k1, k2, k3`
	///
	/// `VEX.L1.0F.W1 42 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kandnq_kr_kr_kr = 1222,
	/// `KANDNB k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W0 42 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kandnb_kr_kr_kr = 1223,
	/// `KANDND k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W1 42 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kandnd_kr_kr_kr = 1224,
	/// `KNOTW k1, k2`
	///
	/// `VEX.L0.0F.W0 44 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Knotw_kr_kr = 1225,
	/// `KNOTQ k1, k2`
	///
	/// `VEX.L0.0F.W1 44 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Knotq_kr_kr = 1226,
	/// `KNOTB k1, k2`
	///
	/// `VEX.L0.66.0F.W0 44 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Knotb_kr_kr = 1227,
	/// `KNOTD k1, k2`
	///
	/// `VEX.L0.66.0F.W1 44 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Knotd_kr_kr = 1228,
	/// `KORW k1, k2, k3`
	///
	/// `VEX.L1.0F.W0 45 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Korw_kr_kr_kr = 1229,
	/// `KORQ k1, k2, k3`
	///
	/// `VEX.L1.0F.W1 45 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Korq_kr_kr_kr = 1230,
	/// `KORB k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W0 45 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Korb_kr_kr_kr = 1231,
	/// `KORD k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W1 45 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kord_kr_kr_kr = 1232,
	/// `KXNORW k1, k2, k3`
	///
	/// `VEX.L1.0F.W0 46 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kxnorw_kr_kr_kr = 1233,
	/// `KXNORQ k1, k2, k3`
	///
	/// `VEX.L1.0F.W1 46 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kxnorq_kr_kr_kr = 1234,
	/// `KXNORB k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W0 46 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kxnorb_kr_kr_kr = 1235,
	/// `KXNORD k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W1 46 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kxnord_kr_kr_kr = 1236,
	/// `KXORW k1, k2, k3`
	///
	/// `VEX.L1.0F.W0 47 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kxorw_kr_kr_kr = 1237,
	/// `KXORQ k1, k2, k3`
	///
	/// `VEX.L1.0F.W1 47 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kxorq_kr_kr_kr = 1238,
	/// `KXORB k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W0 47 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kxorb_kr_kr_kr = 1239,
	/// `KXORD k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W1 47 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kxord_kr_kr_kr = 1240,
	/// `KADDW k1, k2, k3`
	///
	/// `VEX.L1.0F.W0 4A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kaddw_kr_kr_kr = 1241,
	/// `KADDQ k1, k2, k3`
	///
	/// `VEX.L1.0F.W1 4A /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kaddq_kr_kr_kr = 1242,
	/// `KADDB k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W0 4A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kaddb_kr_kr_kr = 1243,
	/// `KADDD k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W1 4A /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kaddd_kr_kr_kr = 1244,
	/// `KUNPCKWD k1, k2, k3`
	///
	/// `VEX.L1.0F.W0 4B /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kunpckwd_kr_kr_kr = 1245,
	/// `KUNPCKDQ k1, k2, k3`
	///
	/// `VEX.L1.0F.W1 4B /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kunpckdq_kr_kr_kr = 1246,
	/// `KUNPCKBW k1, k2, k3`
	///
	/// `VEX.L1.66.0F.W0 4B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kunpckbw_kr_kr_kr = 1247,
	/// `MOVMSKPS r32, xmm`
	///
	/// `NP 0F 50 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movmskps_r32_xmm = 1248,
	/// `MOVMSKPS r64, xmm`
	///
	/// `NP o64 0F 50 /r`
	///
	/// `SSE`
	///
	/// `64-bit`
	Movmskps_r64_xmm = 1249,
	/// `VMOVMSKPS r32, xmm2`
	///
	/// `VEX.128.0F.W0 50 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovmskps_r32_xmm = 1250,
	/// `VMOVMSKPS r64, xmm2`
	///
	/// `VEX.128.0F.W1 50 /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vmovmskps_r64_xmm = 1251,
	/// `VMOVMSKPS r32, ymm2`
	///
	/// `VEX.256.0F.W0 50 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovmskps_r32_ymm = 1252,
	/// `VMOVMSKPS r64, ymm2`
	///
	/// `VEX.256.0F.W1 50 /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vmovmskps_r64_ymm = 1253,
	/// `MOVMSKPD r32, xmm`
	///
	/// `66 0F 50 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movmskpd_r32_xmm = 1254,
	/// `MOVMSKPD r64, xmm`
	///
	/// `66 o64 0F 50 /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Movmskpd_r64_xmm = 1255,
	/// `VMOVMSKPD r32, xmm2`
	///
	/// `VEX.128.66.0F.W0 50 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovmskpd_r32_xmm = 1256,
	/// `VMOVMSKPD r64, xmm2`
	///
	/// `VEX.128.66.0F.W1 50 /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vmovmskpd_r64_xmm = 1257,
	/// `VMOVMSKPD r32, ymm2`
	///
	/// `VEX.256.66.0F.W0 50 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovmskpd_r32_ymm = 1258,
	/// `VMOVMSKPD r64, ymm2`
	///
	/// `VEX.256.66.0F.W1 50 /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vmovmskpd_r64_ymm = 1259,
	/// `SQRTPS xmm1, xmm2/m128`
	///
	/// `NP 0F 51 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sqrtps_xmm_xmmm128 = 1260,
	/// `VSQRTPS xmm1, xmm2/m128`
	///
	/// `VEX.128.0F.WIG 51 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsqrtps_xmm_xmmm128 = 1261,
	/// `VSQRTPS ymm1, ymm2/m256`
	///
	/// `VEX.256.0F.WIG 51 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsqrtps_ymm_ymmm256 = 1262,
	/// `VSQRTPS xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 51 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtps_xmm_k1z_xmmm128b32 = 1263,
	/// `VSQRTPS ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 51 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtps_ymm_k1z_ymmm256b32 = 1264,
	/// `VSQRTPS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.0F.W0 51 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtps_zmm_k1z_zmmm512b32_er = 1265,
	/// `SQRTPD xmm1, xmm2/m128`
	///
	/// `66 0F 51 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Sqrtpd_xmm_xmmm128 = 1266,
	/// `VSQRTPD xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F.WIG 51 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsqrtpd_xmm_xmmm128 = 1267,
	/// `VSQRTPD ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F.WIG 51 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsqrtpd_ymm_ymmm256 = 1268,
	/// `VSQRTPD xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 51 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtpd_xmm_k1z_xmmm128b64 = 1269,
	/// `VSQRTPD ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 51 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtpd_ymm_k1z_ymmm256b64 = 1270,
	/// `VSQRTPD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 51 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtpd_zmm_k1z_zmmm512b64_er = 1271,
	/// `SQRTSS xmm1, xmm2/m32`
	///
	/// `F3 0F 51 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sqrtss_xmm_xmmm32 = 1272,
	/// `VSQRTSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 51 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsqrtss_xmm_xmm_xmmm32 = 1273,
	/// `VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 51 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtss_xmm_k1z_xmm_xmmm32_er = 1274,
	/// `SQRTSD xmm1, xmm2/m64`
	///
	/// `F2 0F 51 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Sqrtsd_xmm_xmmm64 = 1275,
	/// `VSQRTSD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 51 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsqrtsd_xmm_xmm_xmmm64 = 1276,
	/// `VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 51 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtsd_xmm_k1z_xmm_xmmm64_er = 1277,
	/// `RSQRTPS xmm1, xmm2/m128`
	///
	/// `NP 0F 52 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Rsqrtps_xmm_xmmm128 = 1278,
	/// `VRSQRTPS xmm1, xmm2/m128`
	///
	/// `VEX.128.0F.WIG 52 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vrsqrtps_xmm_xmmm128 = 1279,
	/// `VRSQRTPS ymm1, ymm2/m256`
	///
	/// `VEX.256.0F.WIG 52 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vrsqrtps_ymm_ymmm256 = 1280,
	/// `RSQRTSS xmm1, xmm2/m32`
	///
	/// `F3 0F 52 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Rsqrtss_xmm_xmmm32 = 1281,
	/// `VRSQRTSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 52 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vrsqrtss_xmm_xmm_xmmm32 = 1282,
	/// `RCPPS xmm1, xmm2/m128`
	///
	/// `NP 0F 53 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Rcpps_xmm_xmmm128 = 1283,
	/// `VRCPPS xmm1, xmm2/m128`
	///
	/// `VEX.128.0F.WIG 53 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vrcpps_xmm_xmmm128 = 1284,
	/// `VRCPPS ymm1, ymm2/m256`
	///
	/// `VEX.256.0F.WIG 53 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vrcpps_ymm_ymmm256 = 1285,
	/// `RCPSS xmm1, xmm2/m32`
	///
	/// `F3 0F 53 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Rcpss_xmm_xmmm32 = 1286,
	/// `VRCPSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 53 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vrcpss_xmm_xmm_xmmm32 = 1287,
	/// `ANDPS xmm1, xmm2/m128`
	///
	/// `NP 0F 54 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Andps_xmm_xmmm128 = 1288,
	/// `VANDPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 54 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandps_xmm_xmm_xmmm128 = 1289,
	/// `VANDPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 54 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandps_ymm_ymm_ymmm256 = 1290,
	/// `VANDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 54 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandps_xmm_k1z_xmm_xmmm128b32 = 1291,
	/// `VANDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 54 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandps_ymm_k1z_ymm_ymmm256b32 = 1292,
	/// `VANDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.0F.W0 54 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandps_zmm_k1z_zmm_zmmm512b32 = 1293,
	/// `ANDPD xmm1, xmm2/m128`
	///
	/// `66 0F 54 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Andpd_xmm_xmmm128 = 1294,
	/// `VANDPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 54 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandpd_xmm_xmm_xmmm128 = 1295,
	/// `VANDPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 54 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandpd_ymm_ymm_ymmm256 = 1296,
	/// `VANDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 54 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandpd_xmm_k1z_xmm_xmmm128b64 = 1297,
	/// `VANDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 54 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandpd_ymm_k1z_ymm_ymmm256b64 = 1298,
	/// `VANDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 54 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandpd_zmm_k1z_zmm_zmmm512b64 = 1299,
	/// `ANDNPS xmm1, xmm2/m128`
	///
	/// `NP 0F 55 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Andnps_xmm_xmmm128 = 1300,
	/// `VANDNPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 55 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandnps_xmm_xmm_xmmm128 = 1301,
	/// `VANDNPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 55 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandnps_ymm_ymm_ymmm256 = 1302,
	/// `VANDNPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 55 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandnps_xmm_k1z_xmm_xmmm128b32 = 1303,
	/// `VANDNPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 55 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandnps_ymm_k1z_ymm_ymmm256b32 = 1304,
	/// `VANDNPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.0F.W0 55 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandnps_zmm_k1z_zmm_zmmm512b32 = 1305,
	/// `ANDNPD xmm1, xmm2/m128`
	///
	/// `66 0F 55 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Andnpd_xmm_xmmm128 = 1306,
	/// `VANDNPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 55 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandnpd_xmm_xmm_xmmm128 = 1307,
	/// `VANDNPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 55 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vandnpd_ymm_ymm_ymmm256 = 1308,
	/// `VANDNPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 55 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandnpd_xmm_k1z_xmm_xmmm128b64 = 1309,
	/// `VANDNPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 55 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandnpd_ymm_k1z_ymm_ymmm256b64 = 1310,
	/// `VANDNPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 55 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vandnpd_zmm_k1z_zmm_zmmm512b64 = 1311,
	/// `ORPS xmm1, xmm2/m128`
	///
	/// `NP 0F 56 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Orps_xmm_xmmm128 = 1312,
	/// `VORPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 56 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vorps_xmm_xmm_xmmm128 = 1313,
	/// `VORPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 56 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vorps_ymm_ymm_ymmm256 = 1314,
	/// `VORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 56 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vorps_xmm_k1z_xmm_xmmm128b32 = 1315,
	/// `VORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 56 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vorps_ymm_k1z_ymm_ymmm256b32 = 1316,
	/// `VORPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.0F.W0 56 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vorps_zmm_k1z_zmm_zmmm512b32 = 1317,
	/// `ORPD xmm1, xmm2/m128`
	///
	/// `66 0F 56 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Orpd_xmm_xmmm128 = 1318,
	/// `VORPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 56 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vorpd_xmm_xmm_xmmm128 = 1319,
	/// `VORPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 56 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vorpd_ymm_ymm_ymmm256 = 1320,
	/// `VORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 56 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vorpd_xmm_k1z_xmm_xmmm128b64 = 1321,
	/// `VORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 56 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vorpd_ymm_k1z_ymm_ymmm256b64 = 1322,
	/// `VORPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 56 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vorpd_zmm_k1z_zmm_zmmm512b64 = 1323,
	/// `XORPS xmm1, xmm2/m128`
	///
	/// `NP 0F 57 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Xorps_xmm_xmmm128 = 1324,
	/// `VXORPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 57 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vxorps_xmm_xmm_xmmm128 = 1325,
	/// `VXORPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 57 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vxorps_ymm_ymm_ymmm256 = 1326,
	/// `VXORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 57 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vxorps_xmm_k1z_xmm_xmmm128b32 = 1327,
	/// `VXORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 57 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vxorps_ymm_k1z_ymm_ymmm256b32 = 1328,
	/// `VXORPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.0F.W0 57 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vxorps_zmm_k1z_zmm_zmmm512b32 = 1329,
	/// `XORPD xmm1, xmm2/m128`
	///
	/// `66 0F 57 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Xorpd_xmm_xmmm128 = 1330,
	/// `VXORPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 57 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vxorpd_xmm_xmm_xmmm128 = 1331,
	/// `VXORPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 57 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vxorpd_ymm_ymm_ymmm256 = 1332,
	/// `VXORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 57 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vxorpd_xmm_k1z_xmm_xmmm128b64 = 1333,
	/// `VXORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 57 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vxorpd_ymm_k1z_ymm_ymmm256b64 = 1334,
	/// `VXORPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 57 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vxorpd_zmm_k1z_zmm_zmmm512b64 = 1335,
	/// `ADDPS xmm1, xmm2/m128`
	///
	/// `NP 0F 58 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Addps_xmm_xmmm128 = 1336,
	/// `VADDPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 58 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddps_xmm_xmm_xmmm128 = 1337,
	/// `VADDPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 58 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddps_ymm_ymm_ymmm256 = 1338,
	/// `VADDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 58 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddps_xmm_k1z_xmm_xmmm128b32 = 1339,
	/// `VADDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 58 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddps_ymm_k1z_ymm_ymmm256b32 = 1340,
	/// `VADDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.0F.W0 58 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddps_zmm_k1z_zmm_zmmm512b32_er = 1341,
	/// `ADDPD xmm1, xmm2/m128`
	///
	/// `66 0F 58 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Addpd_xmm_xmmm128 = 1342,
	/// `VADDPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 58 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddpd_xmm_xmm_xmmm128 = 1343,
	/// `VADDPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 58 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddpd_ymm_ymm_ymmm256 = 1344,
	/// `VADDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 58 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddpd_xmm_k1z_xmm_xmmm128b64 = 1345,
	/// `VADDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 58 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddpd_ymm_k1z_ymm_ymmm256b64 = 1346,
	/// `VADDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 58 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddpd_zmm_k1z_zmm_zmmm512b64_er = 1347,
	/// `ADDSS xmm1, xmm2/m32`
	///
	/// `F3 0F 58 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Addss_xmm_xmmm32 = 1348,
	/// `VADDSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 58 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddss_xmm_xmm_xmmm32 = 1349,
	/// `VADDSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 58 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddss_xmm_k1z_xmm_xmmm32_er = 1350,
	/// `ADDSD xmm1, xmm2/m64`
	///
	/// `F2 0F 58 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Addsd_xmm_xmmm64 = 1351,
	/// `VADDSD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 58 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddsd_xmm_xmm_xmmm64 = 1352,
	/// `VADDSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 58 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vaddsd_xmm_k1z_xmm_xmmm64_er = 1353,
	/// `MULPS xmm1, xmm2/m128`
	///
	/// `NP 0F 59 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Mulps_xmm_xmmm128 = 1354,
	/// `VMULPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 59 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmulps_xmm_xmm_xmmm128 = 1355,
	/// `VMULPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 59 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmulps_ymm_ymm_ymmm256 = 1356,
	/// `VMULPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 59 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulps_xmm_k1z_xmm_xmmm128b32 = 1357,
	/// `VMULPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 59 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulps_ymm_k1z_ymm_ymmm256b32 = 1358,
	/// `VMULPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.0F.W0 59 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulps_zmm_k1z_zmm_zmmm512b32_er = 1359,
	/// `MULPD xmm1, xmm2/m128`
	///
	/// `66 0F 59 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mulpd_xmm_xmmm128 = 1360,
	/// `VMULPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 59 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmulpd_xmm_xmm_xmmm128 = 1361,
	/// `VMULPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 59 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmulpd_ymm_ymm_ymmm256 = 1362,
	/// `VMULPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 59 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulpd_xmm_k1z_xmm_xmmm128b64 = 1363,
	/// `VMULPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 59 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulpd_ymm_k1z_ymm_ymmm256b64 = 1364,
	/// `VMULPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 59 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulpd_zmm_k1z_zmm_zmmm512b64_er = 1365,
	/// `MULSS xmm1, xmm2/m32`
	///
	/// `F3 0F 59 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Mulss_xmm_xmmm32 = 1366,
	/// `VMULSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 59 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmulss_xmm_xmm_xmmm32 = 1367,
	/// `VMULSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 59 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulss_xmm_k1z_xmm_xmmm32_er = 1368,
	/// `MULSD xmm1, xmm2/m64`
	///
	/// `F2 0F 59 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mulsd_xmm_xmmm64 = 1369,
	/// `VMULSD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 59 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmulsd_xmm_xmm_xmmm64 = 1370,
	/// `VMULSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 59 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmulsd_xmm_k1z_xmm_xmmm64_er = 1371,
	/// `CVTPS2PD xmm1, xmm2/m64`
	///
	/// `NP 0F 5A /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtps2pd_xmm_xmmm64 = 1372,
	/// `VCVTPS2PD xmm1, xmm2/m64`
	///
	/// `VEX.128.0F.WIG 5A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtps2pd_xmm_xmmm64 = 1373,
	/// `VCVTPS2PD ymm1, xmm2/m128`
	///
	/// `VEX.256.0F.WIG 5A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtps2pd_ymm_xmmm128 = 1374,
	/// `VCVTPS2PD xmm1 {k1}{z}, xmm2/m64/m32bcst`
	///
	/// `EVEX.128.0F.W0 5A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2pd_xmm_k1z_xmmm64b32 = 1375,
	/// `VCVTPS2PD ymm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.256.0F.W0 5A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2pd_ymm_k1z_xmmm128b32 = 1376,
	/// `VCVTPS2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}`
	///
	/// `EVEX.512.0F.W0 5A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2pd_zmm_k1z_ymmm256b32_sae = 1377,
	/// `CVTPD2PS xmm1, xmm2/m128`
	///
	/// `66 0F 5A /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtpd2ps_xmm_xmmm128 = 1378,
	/// `VCVTPD2PS xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F.WIG 5A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtpd2ps_xmm_xmmm128 = 1379,
	/// `VCVTPD2PS xmm1, ymm2/m256`
	///
	/// `VEX.256.66.0F.WIG 5A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtpd2ps_xmm_ymmm256 = 1380,
	/// `VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 5A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2ps_xmm_k1z_xmmm128b64 = 1381,
	/// `VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 5A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2ps_xmm_k1z_ymmm256b64 = 1382,
	/// `VCVTPD2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 5A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2ps_ymm_k1z_zmmm512b64_er = 1383,
	/// `CVTSS2SD xmm1, xmm2/m32`
	///
	/// `F3 0F 5A /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtss2sd_xmm_xmmm32 = 1384,
	/// `VCVTSS2SD xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 5A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtss2sd_xmm_xmm_xmmm32 = 1385,
	/// `VCVTSS2SD xmm1 {k1}{z}, xmm2, xmm3/m32{sae}`
	///
	/// `EVEX.LIG.F3.0F.W0 5A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtss2sd_xmm_k1z_xmm_xmmm32_sae = 1386,
	/// `CVTSD2SS xmm1, xmm2/m64`
	///
	/// `F2 0F 5A /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtsd2ss_xmm_xmmm64 = 1387,
	/// `VCVTSD2SS xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 5A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtsd2ss_xmm_xmm_xmmm64 = 1388,
	/// `VCVTSD2SS xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 5A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsd2ss_xmm_k1z_xmm_xmmm64_er = 1389,
	/// `CVTDQ2PS xmm1, xmm2/m128`
	///
	/// `NP 0F 5B /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtdq2ps_xmm_xmmm128 = 1390,
	/// `VCVTDQ2PS xmm1, xmm2/m128`
	///
	/// `VEX.128.0F.WIG 5B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtdq2ps_xmm_xmmm128 = 1391,
	/// `VCVTDQ2PS ymm1, ymm2/m256`
	///
	/// `VEX.256.0F.WIG 5B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtdq2ps_ymm_ymmm256 = 1392,
	/// `VCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 5B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2ps_xmm_k1z_xmmm128b32 = 1393,
	/// `VCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 5B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2ps_ymm_k1z_ymmm256b32 = 1394,
	/// `VCVTDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.0F.W0 5B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2ps_zmm_k1z_zmmm512b32_er = 1395,
	/// `VCVTQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.0F.W1 5B /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2ps_xmm_k1z_xmmm128b64 = 1396,
	/// `VCVTQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.0F.W1 5B /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2ps_xmm_k1z_ymmm256b64 = 1397,
	/// `VCVTQQ2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.0F.W1 5B /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2ps_ymm_k1z_zmmm512b64_er = 1398,
	/// `CVTPS2DQ xmm1, xmm2/m128`
	///
	/// `66 0F 5B /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtps2dq_xmm_xmmm128 = 1399,
	/// `VCVTPS2DQ xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F.WIG 5B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtps2dq_xmm_xmmm128 = 1400,
	/// `VCVTPS2DQ ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F.WIG 5B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtps2dq_ymm_ymmm256 = 1401,
	/// `VCVTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 5B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2dq_xmm_k1z_xmmm128b32 = 1402,
	/// `VCVTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 5B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2dq_ymm_k1z_ymmm256b32 = 1403,
	/// `VCVTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F.W0 5B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2dq_zmm_k1z_zmmm512b32_er = 1404,
	/// `CVTTPS2DQ xmm1, xmm2/m128`
	///
	/// `F3 0F 5B /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvttps2dq_xmm_xmmm128 = 1405,
	/// `VCVTTPS2DQ xmm1, xmm2/m128`
	///
	/// `VEX.128.F3.0F.WIG 5B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvttps2dq_xmm_xmmm128 = 1406,
	/// `VCVTTPS2DQ ymm1, ymm2/m256`
	///
	/// `VEX.256.F3.0F.WIG 5B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvttps2dq_ymm_ymmm256 = 1407,
	/// `VCVTTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.F3.0F.W0 5B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2dq_xmm_k1z_xmmm128b32 = 1408,
	/// `VCVTTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.F3.0F.W0 5B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2dq_ymm_k1z_ymmm256b32 = 1409,
	/// `VCVTTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}`
	///
	/// `EVEX.512.F3.0F.W0 5B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2dq_zmm_k1z_zmmm512b32_sae = 1410,
	/// `SUBPS xmm1, xmm2/m128`
	///
	/// `NP 0F 5C /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Subps_xmm_xmmm128 = 1411,
	/// `VSUBPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 5C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsubps_xmm_xmm_xmmm128 = 1412,
	/// `VSUBPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 5C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsubps_ymm_ymm_ymmm256 = 1413,
	/// `VSUBPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 5C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubps_xmm_k1z_xmm_xmmm128b32 = 1414,
	/// `VSUBPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 5C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubps_ymm_k1z_ymm_ymmm256b32 = 1415,
	/// `VSUBPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.0F.W0 5C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubps_zmm_k1z_zmm_zmmm512b32_er = 1416,
	/// `SUBPD xmm1, xmm2/m128`
	///
	/// `66 0F 5C /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Subpd_xmm_xmmm128 = 1417,
	/// `VSUBPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 5C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsubpd_xmm_xmm_xmmm128 = 1418,
	/// `VSUBPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 5C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsubpd_ymm_ymm_ymmm256 = 1419,
	/// `VSUBPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 5C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubpd_xmm_k1z_xmm_xmmm128b64 = 1420,
	/// `VSUBPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 5C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubpd_ymm_k1z_ymm_ymmm256b64 = 1421,
	/// `VSUBPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 5C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubpd_zmm_k1z_zmm_zmmm512b64_er = 1422,
	/// `SUBSS xmm1, xmm2/m32`
	///
	/// `F3 0F 5C /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Subss_xmm_xmmm32 = 1423,
	/// `VSUBSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 5C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsubss_xmm_xmm_xmmm32 = 1424,
	/// `VSUBSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 5C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubss_xmm_k1z_xmm_xmmm32_er = 1425,
	/// `SUBSD xmm1, xmm2/m64`
	///
	/// `F2 0F 5C /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Subsd_xmm_xmmm64 = 1426,
	/// `VSUBSD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 5C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vsubsd_xmm_xmm_xmmm64 = 1427,
	/// `VSUBSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 5C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vsubsd_xmm_k1z_xmm_xmmm64_er = 1428,
	/// `MINPS xmm1, xmm2/m128`
	///
	/// `NP 0F 5D /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Minps_xmm_xmmm128 = 1429,
	/// `VMINPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 5D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vminps_xmm_xmm_xmmm128 = 1430,
	/// `VMINPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 5D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vminps_ymm_ymm_ymmm256 = 1431,
	/// `VMINPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 5D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminps_xmm_k1z_xmm_xmmm128b32 = 1432,
	/// `VMINPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 5D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminps_ymm_k1z_ymm_ymmm256b32 = 1433,
	/// `VMINPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}`
	///
	/// `EVEX.512.0F.W0 5D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminps_zmm_k1z_zmm_zmmm512b32_sae = 1434,
	/// `MINPD xmm1, xmm2/m128`
	///
	/// `66 0F 5D /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Minpd_xmm_xmmm128 = 1435,
	/// `VMINPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 5D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vminpd_xmm_xmm_xmmm128 = 1436,
	/// `VMINPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 5D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vminpd_ymm_ymm_ymmm256 = 1437,
	/// `VMINPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 5D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminpd_xmm_k1z_xmm_xmmm128b64 = 1438,
	/// `VMINPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 5D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminpd_ymm_k1z_ymm_ymmm256b64 = 1439,
	/// `VMINPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F.W1 5D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminpd_zmm_k1z_zmm_zmmm512b64_sae = 1440,
	/// `MINSS xmm1, xmm2/m32`
	///
	/// `F3 0F 5D /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Minss_xmm_xmmm32 = 1441,
	/// `VMINSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 5D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vminss_xmm_xmm_xmmm32 = 1442,
	/// `VMINSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}`
	///
	/// `EVEX.LIG.F3.0F.W0 5D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminss_xmm_k1z_xmm_xmmm32_sae = 1443,
	/// `MINSD xmm1, xmm2/m64`
	///
	/// `F2 0F 5D /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Minsd_xmm_xmmm64 = 1444,
	/// `VMINSD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 5D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vminsd_xmm_xmm_xmmm64 = 1445,
	/// `VMINSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}`
	///
	/// `EVEX.LIG.F2.0F.W1 5D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vminsd_xmm_k1z_xmm_xmmm64_sae = 1446,
	/// `DIVPS xmm1, xmm2/m128`
	///
	/// `NP 0F 5E /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Divps_xmm_xmmm128 = 1447,
	/// `VDIVPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 5E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdivps_xmm_xmm_xmmm128 = 1448,
	/// `VDIVPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 5E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdivps_ymm_ymm_ymmm256 = 1449,
	/// `VDIVPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 5E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivps_xmm_k1z_xmm_xmmm128b32 = 1450,
	/// `VDIVPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 5E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivps_ymm_k1z_ymm_ymmm256b32 = 1451,
	/// `VDIVPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.0F.W0 5E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivps_zmm_k1z_zmm_zmmm512b32_er = 1452,
	/// `DIVPD xmm1, xmm2/m128`
	///
	/// `66 0F 5E /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Divpd_xmm_xmmm128 = 1453,
	/// `VDIVPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 5E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdivpd_xmm_xmm_xmmm128 = 1454,
	/// `VDIVPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 5E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdivpd_ymm_ymm_ymmm256 = 1455,
	/// `VDIVPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 5E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivpd_xmm_k1z_xmm_xmmm128b64 = 1456,
	/// `VDIVPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 5E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivpd_ymm_k1z_ymm_ymmm256b64 = 1457,
	/// `VDIVPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 5E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivpd_zmm_k1z_zmm_zmmm512b64_er = 1458,
	/// `DIVSS xmm1, xmm2/m32`
	///
	/// `F3 0F 5E /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Divss_xmm_xmmm32 = 1459,
	/// `VDIVSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 5E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdivss_xmm_xmm_xmmm32 = 1460,
	/// `VDIVSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 5E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivss_xmm_k1z_xmm_xmmm32_er = 1461,
	/// `DIVSD xmm1, xmm2/m64`
	///
	/// `F2 0F 5E /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Divsd_xmm_xmmm64 = 1462,
	/// `VDIVSD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 5E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdivsd_xmm_xmm_xmmm64 = 1463,
	/// `VDIVSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 5E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vdivsd_xmm_k1z_xmm_xmmm64_er = 1464,
	/// `MAXPS xmm1, xmm2/m128`
	///
	/// `NP 0F 5F /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Maxps_xmm_xmmm128 = 1465,
	/// `VMAXPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.0F.WIG 5F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaxps_xmm_xmm_xmmm128 = 1466,
	/// `VMAXPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.0F.WIG 5F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaxps_ymm_ymm_ymmm256 = 1467,
	/// `VMAXPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 5F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxps_xmm_k1z_xmm_xmmm128b32 = 1468,
	/// `VMAXPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 5F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxps_ymm_k1z_ymm_ymmm256b32 = 1469,
	/// `VMAXPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}`
	///
	/// `EVEX.512.0F.W0 5F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxps_zmm_k1z_zmm_zmmm512b32_sae = 1470,
	/// `MAXPD xmm1, xmm2/m128`
	///
	/// `66 0F 5F /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Maxpd_xmm_xmmm128 = 1471,
	/// `VMAXPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 5F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaxpd_xmm_xmm_xmmm128 = 1472,
	/// `VMAXPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 5F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaxpd_ymm_ymm_ymmm256 = 1473,
	/// `VMAXPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 5F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxpd_xmm_k1z_xmm_xmmm128b64 = 1474,
	/// `VMAXPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 5F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxpd_ymm_k1z_ymm_ymmm256b64 = 1475,
	/// `VMAXPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F.W1 5F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxpd_zmm_k1z_zmm_zmmm512b64_sae = 1476,
	/// `MAXSS xmm1, xmm2/m32`
	///
	/// `F3 0F 5F /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Maxss_xmm_xmmm32 = 1477,
	/// `VMAXSS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.F3.0F.WIG 5F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaxss_xmm_xmm_xmmm32 = 1478,
	/// `VMAXSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}`
	///
	/// `EVEX.LIG.F3.0F.W0 5F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxss_xmm_k1z_xmm_xmmm32_sae = 1479,
	/// `MAXSD xmm1, xmm2/m64`
	///
	/// `F2 0F 5F /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Maxsd_xmm_xmmm64 = 1480,
	/// `VMAXSD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.F2.0F.WIG 5F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaxsd_xmm_xmm_xmmm64 = 1481,
	/// `VMAXSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}`
	///
	/// `EVEX.LIG.F2.0F.W1 5F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxsd_xmm_k1z_xmm_xmmm64_sae = 1482,
	/// `PUNPCKLBW mm, mm/m32`
	///
	/// `NP 0F 60 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Punpcklbw_mm_mmm32 = 1483,
	/// `PUNPCKLBW xmm1, xmm2/m128`
	///
	/// `66 0F 60 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpcklbw_xmm_xmmm128 = 1484,
	/// `VPUNPCKLBW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 60 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpcklbw_xmm_xmm_xmmm128 = 1485,
	/// `VPUNPCKLBW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 60 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpcklbw_ymm_ymm_ymmm256 = 1486,
	/// `VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 60 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklbw_xmm_k1z_xmm_xmmm128 = 1487,
	/// `VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 60 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklbw_ymm_k1z_ymm_ymmm256 = 1488,
	/// `VPUNPCKLBW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 60 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklbw_zmm_k1z_zmm_zmmm512 = 1489,
	/// `PUNPCKLWD mm, mm/m32`
	///
	/// `NP 0F 61 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Punpcklwd_mm_mmm32 = 1490,
	/// `PUNPCKLWD xmm1, xmm2/m128`
	///
	/// `66 0F 61 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpcklwd_xmm_xmmm128 = 1491,
	/// `VPUNPCKLWD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 61 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpcklwd_xmm_xmm_xmmm128 = 1492,
	/// `VPUNPCKLWD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 61 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpcklwd_ymm_ymm_ymmm256 = 1493,
	/// `VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 61 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklwd_xmm_k1z_xmm_xmmm128 = 1494,
	/// `VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 61 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklwd_ymm_k1z_ymm_ymmm256 = 1495,
	/// `VPUNPCKLWD zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 61 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklwd_zmm_k1z_zmm_zmmm512 = 1496,
	/// `PUNPCKLDQ mm, mm/m32`
	///
	/// `NP 0F 62 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Punpckldq_mm_mmm32 = 1497,
	/// `PUNPCKLDQ xmm1, xmm2/m128`
	///
	/// `66 0F 62 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpckldq_xmm_xmmm128 = 1498,
	/// `VPUNPCKLDQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 62 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckldq_xmm_xmm_xmmm128 = 1499,
	/// `VPUNPCKLDQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 62 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckldq_ymm_ymm_ymmm256 = 1500,
	/// `VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 62 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckldq_xmm_k1z_xmm_xmmm128b32 = 1501,
	/// `VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 62 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckldq_ymm_k1z_ymm_ymmm256b32 = 1502,
	/// `VPUNPCKLDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 62 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckldq_zmm_k1z_zmm_zmmm512b32 = 1503,
	/// `PACKSSWB mm1, mm2/m64`
	///
	/// `NP 0F 63 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Packsswb_mm_mmm64 = 1504,
	/// `PACKSSWB xmm1, xmm2/m128`
	///
	/// `66 0F 63 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Packsswb_xmm_xmmm128 = 1505,
	/// `VPACKSSWB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 63 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpacksswb_xmm_xmm_xmmm128 = 1506,
	/// `VPACKSSWB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 63 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpacksswb_ymm_ymm_ymmm256 = 1507,
	/// `VPACKSSWB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 63 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpacksswb_xmm_k1z_xmm_xmmm128 = 1508,
	/// `VPACKSSWB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 63 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpacksswb_ymm_k1z_ymm_ymmm256 = 1509,
	/// `VPACKSSWB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 63 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpacksswb_zmm_k1z_zmm_zmmm512 = 1510,
	/// `PCMPGTB mm, mm/m64`
	///
	/// `NP 0F 64 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pcmpgtb_mm_mmm64 = 1511,
	/// `PCMPGTB xmm1, xmm2/m128`
	///
	/// `66 0F 64 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pcmpgtb_xmm_xmmm128 = 1512,
	/// `VPCMPGTB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 64 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtb_xmm_xmm_xmmm128 = 1513,
	/// `VPCMPGTB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 64 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtb_ymm_ymm_ymmm256 = 1514,
	/// `VPCMPGTB k1 {k2}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 64 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtb_kr_k1_xmm_xmmm128 = 1515,
	/// `VPCMPGTB k1 {k2}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 64 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtb_kr_k1_ymm_ymmm256 = 1516,
	/// `VPCMPGTB k1 {k2}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 64 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtb_kr_k1_zmm_zmmm512 = 1517,
	/// `PCMPGTW mm, mm/m64`
	///
	/// `NP 0F 65 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pcmpgtw_mm_mmm64 = 1518,
	/// `PCMPGTW xmm1, xmm2/m128`
	///
	/// `66 0F 65 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pcmpgtw_xmm_xmmm128 = 1519,
	/// `VPCMPGTW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 65 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtw_xmm_xmm_xmmm128 = 1520,
	/// `VPCMPGTW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 65 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtw_ymm_ymm_ymmm256 = 1521,
	/// `VPCMPGTW k1 {k2}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 65 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtw_kr_k1_xmm_xmmm128 = 1522,
	/// `VPCMPGTW k1 {k2}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 65 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtw_kr_k1_ymm_ymmm256 = 1523,
	/// `VPCMPGTW k1 {k2}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 65 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtw_kr_k1_zmm_zmmm512 = 1524,
	/// `PCMPGTD mm, mm/m64`
	///
	/// `NP 0F 66 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pcmpgtd_mm_mmm64 = 1525,
	/// `PCMPGTD xmm1, xmm2/m128`
	///
	/// `66 0F 66 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pcmpgtd_xmm_xmmm128 = 1526,
	/// `VPCMPGTD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 66 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtd_xmm_xmm_xmmm128 = 1527,
	/// `VPCMPGTD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 66 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtd_ymm_ymm_ymmm256 = 1528,
	/// `VPCMPGTD k1 {k2}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 66 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtd_kr_k1_xmm_xmmm128b32 = 1529,
	/// `VPCMPGTD k1 {k2}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 66 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtd_kr_k1_ymm_ymmm256b32 = 1530,
	/// `VPCMPGTD k1 {k2}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 66 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtd_kr_k1_zmm_zmmm512b32 = 1531,
	/// `PACKUSWB mm, mm/m64`
	///
	/// `NP 0F 67 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Packuswb_mm_mmm64 = 1532,
	/// `PACKUSWB xmm1, xmm2/m128`
	///
	/// `66 0F 67 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Packuswb_xmm_xmmm128 = 1533,
	/// `VPACKUSWB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 67 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpackuswb_xmm_xmm_xmmm128 = 1534,
	/// `VPACKUSWB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 67 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpackuswb_ymm_ymm_ymmm256 = 1535,
	/// `VPACKUSWB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 67 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackuswb_xmm_k1z_xmm_xmmm128 = 1536,
	/// `VPACKUSWB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 67 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackuswb_ymm_k1z_ymm_ymmm256 = 1537,
	/// `VPACKUSWB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 67 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackuswb_zmm_k1z_zmm_zmmm512 = 1538,
	/// `PUNPCKHBW mm, mm/m64`
	///
	/// `NP 0F 68 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Punpckhbw_mm_mmm64 = 1539,
	/// `PUNPCKHBW xmm1, xmm2/m128`
	///
	/// `66 0F 68 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpckhbw_xmm_xmmm128 = 1540,
	/// `VPUNPCKHBW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 68 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhbw_xmm_xmm_xmmm128 = 1541,
	/// `VPUNPCKHBW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 68 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhbw_ymm_ymm_ymmm256 = 1542,
	/// `VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 68 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhbw_xmm_k1z_xmm_xmmm128 = 1543,
	/// `VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 68 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhbw_ymm_k1z_ymm_ymmm256 = 1544,
	/// `VPUNPCKHBW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 68 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhbw_zmm_k1z_zmm_zmmm512 = 1545,
	/// `PUNPCKHWD mm, mm/m64`
	///
	/// `NP 0F 69 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Punpckhwd_mm_mmm64 = 1546,
	/// `PUNPCKHWD xmm1, xmm2/m128`
	///
	/// `66 0F 69 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpckhwd_xmm_xmmm128 = 1547,
	/// `VPUNPCKHWD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 69 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhwd_xmm_xmm_xmmm128 = 1548,
	/// `VPUNPCKHWD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 69 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhwd_ymm_ymm_ymmm256 = 1549,
	/// `VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 69 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhwd_xmm_k1z_xmm_xmmm128 = 1550,
	/// `VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 69 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhwd_ymm_k1z_ymm_ymmm256 = 1551,
	/// `VPUNPCKHWD zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 69 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhwd_zmm_k1z_zmm_zmmm512 = 1552,
	/// `PUNPCKHDQ mm, mm/m64`
	///
	/// `NP 0F 6A /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Punpckhdq_mm_mmm64 = 1553,
	/// `PUNPCKHDQ xmm1, xmm2/m128`
	///
	/// `66 0F 6A /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpckhdq_xmm_xmmm128 = 1554,
	/// `VPUNPCKHDQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 6A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhdq_xmm_xmm_xmmm128 = 1555,
	/// `VPUNPCKHDQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 6A /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhdq_ymm_ymm_ymmm256 = 1556,
	/// `VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 6A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhdq_xmm_k1z_xmm_xmmm128b32 = 1557,
	/// `VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 6A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhdq_ymm_k1z_ymm_ymmm256b32 = 1558,
	/// `VPUNPCKHDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 6A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhdq_zmm_k1z_zmm_zmmm512b32 = 1559,
	/// `PACKSSDW mm1, mm2/m64`
	///
	/// `NP 0F 6B /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Packssdw_mm_mmm64 = 1560,
	/// `PACKSSDW xmm1, xmm2/m128`
	///
	/// `66 0F 6B /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Packssdw_xmm_xmmm128 = 1561,
	/// `VPACKSSDW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 6B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpackssdw_xmm_xmm_xmmm128 = 1562,
	/// `VPACKSSDW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 6B /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpackssdw_ymm_ymm_ymmm256 = 1563,
	/// `VPACKSSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 6B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackssdw_xmm_k1z_xmm_xmmm128b32 = 1564,
	/// `VPACKSSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 6B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackssdw_ymm_k1z_ymm_ymmm256b32 = 1565,
	/// `VPACKSSDW zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 6B /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackssdw_zmm_k1z_zmm_zmmm512b32 = 1566,
	/// `PUNPCKLQDQ xmm1, xmm2/m128`
	///
	/// `66 0F 6C /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpcklqdq_xmm_xmmm128 = 1567,
	/// `VPUNPCKLQDQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 6C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpcklqdq_xmm_xmm_xmmm128 = 1568,
	/// `VPUNPCKLQDQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 6C /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpcklqdq_ymm_ymm_ymmm256 = 1569,
	/// `VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 6C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklqdq_xmm_k1z_xmm_xmmm128b64 = 1570,
	/// `VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 6C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklqdq_ymm_k1z_ymm_ymmm256b64 = 1571,
	/// `VPUNPCKLQDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 6C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpcklqdq_zmm_k1z_zmm_zmmm512b64 = 1572,
	/// `PUNPCKHQDQ xmm1, xmm2/m128`
	///
	/// `66 0F 6D /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Punpckhqdq_xmm_xmmm128 = 1573,
	/// `VPUNPCKHQDQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 6D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhqdq_xmm_xmm_xmmm128 = 1574,
	/// `VPUNPCKHQDQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 6D /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpunpckhqdq_ymm_ymm_ymmm256 = 1575,
	/// `VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 6D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhqdq_xmm_k1z_xmm_xmmm128b64 = 1576,
	/// `VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 6D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhqdq_ymm_k1z_ymm_ymmm256b64 = 1577,
	/// `VPUNPCKHQDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 6D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpunpckhqdq_zmm_k1z_zmm_zmmm512b64 = 1578,
	/// `MOVD mm, r/m32`
	///
	/// `NP 0F 6E /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Movd_mm_rm32 = 1579,
	/// `MOVQ mm, r/m64`
	///
	/// `NP o64 0F 6E /r`
	///
	/// `MMX`
	///
	/// `64-bit`
	Movq_mm_rm64 = 1580,
	/// `MOVD xmm, r/m32`
	///
	/// `66 0F 6E /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movd_xmm_rm32 = 1581,
	/// `MOVQ xmm, r/m64`
	///
	/// `66 o64 0F 6E /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Movq_xmm_rm64 = 1582,
	/// `VMOVD xmm1, r/m32`
	///
	/// `VEX.128.66.0F.W0 6E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovd_xmm_rm32 = 1583,
	/// `VMOVQ xmm1, r/m64`
	///
	/// `VEX.128.66.0F.W1 6E /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vmovq_xmm_rm64 = 1584,
	/// `VMOVD xmm1, r/m32`
	///
	/// `EVEX.128.66.0F.W0 6E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovd_xmm_rm32 = 1585,
	/// `VMOVQ xmm1, r/m64`
	///
	/// `EVEX.128.66.0F.W1 6E /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vmovq_xmm_rm64 = 1586,
	/// `MOVQ mm, mm/m64`
	///
	/// `NP 0F 6F /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Movq_mm_mmm64 = 1587,
	/// `MOVDQA xmm1, xmm2/m128`
	///
	/// `66 0F 6F /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movdqa_xmm_xmmm128 = 1588,
	/// `VMOVDQA xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F.WIG 6F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqa_xmm_xmmm128 = 1589,
	/// `VMOVDQA ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F.WIG 6F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqa_ymm_ymmm256 = 1590,
	/// `VMOVDQA32 xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F.W0 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa32_xmm_k1z_xmmm128 = 1591,
	/// `VMOVDQA32 ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F.W0 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa32_ymm_k1z_ymmm256 = 1592,
	/// `VMOVDQA32 zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F.W0 6F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa32_zmm_k1z_zmmm512 = 1593,
	/// `VMOVDQA64 xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F.W1 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa64_xmm_k1z_xmmm128 = 1594,
	/// `VMOVDQA64 ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F.W1 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa64_ymm_k1z_ymmm256 = 1595,
	/// `VMOVDQA64 zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F.W1 6F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa64_zmm_k1z_zmmm512 = 1596,
	/// `MOVDQU xmm1, xmm2/m128`
	///
	/// `F3 0F 6F /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movdqu_xmm_xmmm128 = 1597,
	/// `VMOVDQU xmm1, xmm2/m128`
	///
	/// `VEX.128.F3.0F.WIG 6F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqu_xmm_xmmm128 = 1598,
	/// `VMOVDQU ymm1, ymm2/m256`
	///
	/// `VEX.256.F3.0F.WIG 6F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqu_ymm_ymmm256 = 1599,
	/// `VMOVDQU32 xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.F3.0F.W0 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu32_xmm_k1z_xmmm128 = 1600,
	/// `VMOVDQU32 ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.F3.0F.W0 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu32_ymm_k1z_ymmm256 = 1601,
	/// `VMOVDQU32 zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.F3.0F.W0 6F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu32_zmm_k1z_zmmm512 = 1602,
	/// `VMOVDQU64 xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.F3.0F.W1 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu64_xmm_k1z_xmmm128 = 1603,
	/// `VMOVDQU64 ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.F3.0F.W1 6F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu64_ymm_k1z_ymmm256 = 1604,
	/// `VMOVDQU64 zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.F3.0F.W1 6F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu64_zmm_k1z_zmmm512 = 1605,
	/// `VMOVDQU8 xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.F2.0F.W0 6F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu8_xmm_k1z_xmmm128 = 1606,
	/// `VMOVDQU8 ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.F2.0F.W0 6F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu8_ymm_k1z_ymmm256 = 1607,
	/// `VMOVDQU8 zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.F2.0F.W0 6F /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu8_zmm_k1z_zmmm512 = 1608,
	/// `VMOVDQU16 xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.F2.0F.W1 6F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu16_xmm_k1z_xmmm128 = 1609,
	/// `VMOVDQU16 ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.F2.0F.W1 6F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu16_ymm_k1z_ymmm256 = 1610,
	/// `VMOVDQU16 zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.F2.0F.W1 6F /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu16_zmm_k1z_zmmm512 = 1611,
	/// `PSHUFW mm1, mm2/m64, imm8`
	///
	/// `NP 0F 70 /r ib`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pshufw_mm_mmm64_imm8 = 1612,
	/// `PSHUFD xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 70 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pshufd_xmm_xmmm128_imm8 = 1613,
	/// `VPSHUFD xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F.WIG 70 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpshufd_xmm_xmmm128_imm8 = 1614,
	/// `VPSHUFD ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.66.0F.WIG 70 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpshufd_ymm_ymmm256_imm8 = 1615,
	/// `VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F.W0 70 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufd_xmm_k1z_xmmm128b32_imm8 = 1616,
	/// `VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F.W0 70 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufd_ymm_k1z_ymmm256b32_imm8 = 1617,
	/// `VPSHUFD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F.W0 70 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufd_zmm_k1z_zmmm512b32_imm8 = 1618,
	/// `PSHUFHW xmm1, xmm2/m128, imm8`
	///
	/// `F3 0F 70 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pshufhw_xmm_xmmm128_imm8 = 1619,
	/// `VPSHUFHW xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.F3.0F.WIG 70 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpshufhw_xmm_xmmm128_imm8 = 1620,
	/// `VPSHUFHW ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.F3.0F.WIG 70 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpshufhw_ymm_ymmm256_imm8 = 1621,
	/// `VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8`
	///
	/// `EVEX.128.F3.0F.WIG 70 /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufhw_xmm_k1z_xmmm128_imm8 = 1622,
	/// `VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8`
	///
	/// `EVEX.256.F3.0F.WIG 70 /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufhw_ymm_k1z_ymmm256_imm8 = 1623,
	/// `VPSHUFHW zmm1 {k1}{z}, zmm2/m512, imm8`
	///
	/// `EVEX.512.F3.0F.WIG 70 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufhw_zmm_k1z_zmmm512_imm8 = 1624,
	/// `PSHUFLW xmm1, xmm2/m128, imm8`
	///
	/// `F2 0F 70 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pshuflw_xmm_xmmm128_imm8 = 1625,
	/// `VPSHUFLW xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.F2.0F.WIG 70 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpshuflw_xmm_xmmm128_imm8 = 1626,
	/// `VPSHUFLW ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.F2.0F.WIG 70 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpshuflw_ymm_ymmm256_imm8 = 1627,
	/// `VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8`
	///
	/// `EVEX.128.F2.0F.WIG 70 /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshuflw_xmm_k1z_xmmm128_imm8 = 1628,
	/// `VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8`
	///
	/// `EVEX.256.F2.0F.WIG 70 /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshuflw_ymm_k1z_ymmm256_imm8 = 1629,
	/// `VPSHUFLW zmm1 {k1}{z}, zmm2/m512, imm8`
	///
	/// `EVEX.512.F2.0F.WIG 70 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshuflw_zmm_k1z_zmmm512_imm8 = 1630,
	/// `PSRLW mm, imm8`
	///
	/// `NP 0F 71 /2 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrlw_mm_imm8 = 1631,
	/// `PSRLW xmm1, imm8`
	///
	/// `66 0F 71 /2 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrlw_xmm_imm8 = 1632,
	/// `VPSRLW xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 71 /2 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlw_xmm_xmm_imm8 = 1633,
	/// `VPSRLW ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 71 /2 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlw_ymm_ymm_imm8 = 1634,
	/// `VPSRLW xmm1 {k1}{z}, xmm2/m128, imm8`
	///
	/// `EVEX.128.66.0F.WIG 71 /2 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlw_xmm_k1z_xmmm128_imm8 = 1635,
	/// `VPSRLW ymm1 {k1}{z}, ymm2/m256, imm8`
	///
	/// `EVEX.256.66.0F.WIG 71 /2 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlw_ymm_k1z_ymmm256_imm8 = 1636,
	/// `VPSRLW zmm1 {k1}{z}, zmm2/m512, imm8`
	///
	/// `EVEX.512.66.0F.WIG 71 /2 ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlw_zmm_k1z_zmmm512_imm8 = 1637,
	/// `PSRAW mm, imm8`
	///
	/// `NP 0F 71 /4 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psraw_mm_imm8 = 1638,
	/// `PSRAW xmm1, imm8`
	///
	/// `66 0F 71 /4 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psraw_xmm_imm8 = 1639,
	/// `VPSRAW xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 71 /4 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsraw_xmm_xmm_imm8 = 1640,
	/// `VPSRAW ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 71 /4 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsraw_ymm_ymm_imm8 = 1641,
	/// `VPSRAW xmm1 {k1}{z}, xmm2/m128, imm8`
	///
	/// `EVEX.128.66.0F.WIG 71 /4 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraw_xmm_k1z_xmmm128_imm8 = 1642,
	/// `VPSRAW ymm1 {k1}{z}, ymm2/m256, imm8`
	///
	/// `EVEX.256.66.0F.WIG 71 /4 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraw_ymm_k1z_ymmm256_imm8 = 1643,
	/// `VPSRAW zmm1 {k1}{z}, zmm2/m512, imm8`
	///
	/// `EVEX.512.66.0F.WIG 71 /4 ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraw_zmm_k1z_zmmm512_imm8 = 1644,
	/// `PSLLW mm1, imm8`
	///
	/// `NP 0F 71 /6 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psllw_mm_imm8 = 1645,
	/// `PSLLW xmm1, imm8`
	///
	/// `66 0F 71 /6 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psllw_xmm_imm8 = 1646,
	/// `VPSLLW xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 71 /6 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsllw_xmm_xmm_imm8 = 1647,
	/// `VPSLLW ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 71 /6 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllw_ymm_ymm_imm8 = 1648,
	/// `VPSLLW xmm1 {k1}{z}, xmm2/m128, imm8`
	///
	/// `EVEX.128.66.0F.WIG 71 /6 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllw_xmm_k1z_xmmm128_imm8 = 1649,
	/// `VPSLLW ymm1 {k1}{z}, ymm2/m256, imm8`
	///
	/// `EVEX.256.66.0F.WIG 71 /6 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllw_ymm_k1z_ymmm256_imm8 = 1650,
	/// `VPSLLW zmm1 {k1}{z}, zmm2/m512, imm8`
	///
	/// `EVEX.512.66.0F.WIG 71 /6 ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllw_zmm_k1z_zmmm512_imm8 = 1651,
	/// `VPRORD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F.W0 72 /0 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprord_xmm_k1z_xmmm128b32_imm8 = 1652,
	/// `VPRORD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F.W0 72 /0 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprord_ymm_k1z_ymmm256b32_imm8 = 1653,
	/// `VPRORD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F.W0 72 /0 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprord_zmm_k1z_zmmm512b32_imm8 = 1654,
	/// `VPRORQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F.W1 72 /0 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorq_xmm_k1z_xmmm128b64_imm8 = 1655,
	/// `VPRORQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F.W1 72 /0 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorq_ymm_k1z_ymmm256b64_imm8 = 1656,
	/// `VPRORQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F.W1 72 /0 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorq_zmm_k1z_zmmm512b64_imm8 = 1657,
	/// `VPROLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F.W0 72 /1 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprold_xmm_k1z_xmmm128b32_imm8 = 1658,
	/// `VPROLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F.W0 72 /1 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprold_ymm_k1z_ymmm256b32_imm8 = 1659,
	/// `VPROLD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F.W0 72 /1 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprold_zmm_k1z_zmmm512b32_imm8 = 1660,
	/// `VPROLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F.W1 72 /1 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolq_xmm_k1z_xmmm128b64_imm8 = 1661,
	/// `VPROLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F.W1 72 /1 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolq_ymm_k1z_ymmm256b64_imm8 = 1662,
	/// `VPROLQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F.W1 72 /1 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolq_zmm_k1z_zmmm512b64_imm8 = 1663,
	/// `PSRLD mm, imm8`
	///
	/// `NP 0F 72 /2 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrld_mm_imm8 = 1664,
	/// `PSRLD xmm1, imm8`
	///
	/// `66 0F 72 /2 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrld_xmm_imm8 = 1665,
	/// `VPSRLD xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 72 /2 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrld_xmm_xmm_imm8 = 1666,
	/// `VPSRLD ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 72 /2 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrld_ymm_ymm_imm8 = 1667,
	/// `VPSRLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F.W0 72 /2 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrld_xmm_k1z_xmmm128b32_imm8 = 1668,
	/// `VPSRLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F.W0 72 /2 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrld_ymm_k1z_ymmm256b32_imm8 = 1669,
	/// `VPSRLD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F.W0 72 /2 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrld_zmm_k1z_zmmm512b32_imm8 = 1670,
	/// `PSRAD mm, imm8`
	///
	/// `NP 0F 72 /4 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrad_mm_imm8 = 1671,
	/// `PSRAD xmm1, imm8`
	///
	/// `66 0F 72 /4 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrad_xmm_imm8 = 1672,
	/// `VPSRAD xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 72 /4 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrad_xmm_xmm_imm8 = 1673,
	/// `VPSRAD ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 72 /4 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrad_ymm_ymm_imm8 = 1674,
	/// `VPSRAD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F.W0 72 /4 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrad_xmm_k1z_xmmm128b32_imm8 = 1675,
	/// `VPSRAD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F.W0 72 /4 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrad_ymm_k1z_ymmm256b32_imm8 = 1676,
	/// `VPSRAD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F.W0 72 /4 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrad_zmm_k1z_zmmm512b32_imm8 = 1677,
	/// `VPSRAQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F.W1 72 /4 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraq_xmm_k1z_xmmm128b64_imm8 = 1678,
	/// `VPSRAQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F.W1 72 /4 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraq_ymm_k1z_ymmm256b64_imm8 = 1679,
	/// `VPSRAQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F.W1 72 /4 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraq_zmm_k1z_zmmm512b64_imm8 = 1680,
	/// `PSLLD mm, imm8`
	///
	/// `NP 0F 72 /6 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pslld_mm_imm8 = 1681,
	/// `PSLLD xmm1, imm8`
	///
	/// `66 0F 72 /6 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pslld_xmm_imm8 = 1682,
	/// `VPSLLD xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 72 /6 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpslld_xmm_xmm_imm8 = 1683,
	/// `VPSLLD ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 72 /6 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpslld_ymm_ymm_imm8 = 1684,
	/// `VPSLLD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F.W0 72 /6 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpslld_xmm_k1z_xmmm128b32_imm8 = 1685,
	/// `VPSLLD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F.W0 72 /6 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpslld_ymm_k1z_ymmm256b32_imm8 = 1686,
	/// `VPSLLD zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F.W0 72 /6 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpslld_zmm_k1z_zmmm512b32_imm8 = 1687,
	/// `PSRLQ mm, imm8`
	///
	/// `NP 0F 73 /2 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrlq_mm_imm8 = 1688,
	/// `PSRLQ xmm1, imm8`
	///
	/// `66 0F 73 /2 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrlq_xmm_imm8 = 1689,
	/// `VPSRLQ xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 73 /2 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlq_xmm_xmm_imm8 = 1690,
	/// `VPSRLQ ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 73 /2 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlq_ymm_ymm_imm8 = 1691,
	/// `VPSRLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F.W1 73 /2 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlq_xmm_k1z_xmmm128b64_imm8 = 1692,
	/// `VPSRLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F.W1 73 /2 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlq_ymm_k1z_ymmm256b64_imm8 = 1693,
	/// `VPSRLQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F.W1 73 /2 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlq_zmm_k1z_zmmm512b64_imm8 = 1694,
	/// `PSRLDQ xmm1, imm8`
	///
	/// `66 0F 73 /3 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrldq_xmm_imm8 = 1695,
	/// `VPSRLDQ xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 73 /3 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrldq_xmm_xmm_imm8 = 1696,
	/// `VPSRLDQ ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 73 /3 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrldq_ymm_ymm_imm8 = 1697,
	/// `VPSRLDQ xmm1, xmm2/m128, imm8`
	///
	/// `EVEX.128.66.0F.WIG 73 /3 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrldq_xmm_xmmm128_imm8 = 1698,
	/// `VPSRLDQ ymm1, ymm2/m256, imm8`
	///
	/// `EVEX.256.66.0F.WIG 73 /3 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrldq_ymm_ymmm256_imm8 = 1699,
	/// `VPSRLDQ zmm1, zmm2/m512, imm8`
	///
	/// `EVEX.512.66.0F.WIG 73 /3 ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrldq_zmm_zmmm512_imm8 = 1700,
	/// `PSLLQ mm, imm8`
	///
	/// `NP 0F 73 /6 ib`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psllq_mm_imm8 = 1701,
	/// `PSLLQ xmm1, imm8`
	///
	/// `66 0F 73 /6 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psllq_xmm_imm8 = 1702,
	/// `VPSLLQ xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 73 /6 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsllq_xmm_xmm_imm8 = 1703,
	/// `VPSLLQ ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 73 /6 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllq_ymm_ymm_imm8 = 1704,
	/// `VPSLLQ xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F.W1 73 /6 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllq_xmm_k1z_xmmm128b64_imm8 = 1705,
	/// `VPSLLQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F.W1 73 /6 ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllq_ymm_k1z_ymmm256b64_imm8 = 1706,
	/// `VPSLLQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F.W1 73 /6 ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllq_zmm_k1z_zmmm512b64_imm8 = 1707,
	/// `PSLLDQ xmm1, imm8`
	///
	/// `66 0F 73 /7 ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pslldq_xmm_imm8 = 1708,
	/// `VPSLLDQ xmm1, xmm2, imm8`
	///
	/// `VEX.128.66.0F.WIG 73 /7 ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpslldq_xmm_xmm_imm8 = 1709,
	/// `VPSLLDQ ymm1, ymm2, imm8`
	///
	/// `VEX.256.66.0F.WIG 73 /7 ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpslldq_ymm_ymm_imm8 = 1710,
	/// `VPSLLDQ xmm1, xmm2/m128, imm8`
	///
	/// `EVEX.128.66.0F.WIG 73 /7 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpslldq_xmm_xmmm128_imm8 = 1711,
	/// `VPSLLDQ ymm1, ymm2/m256, imm8`
	///
	/// `EVEX.256.66.0F.WIG 73 /7 ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpslldq_ymm_ymmm256_imm8 = 1712,
	/// `VPSLLDQ zmm1, zmm2/m512, imm8`
	///
	/// `EVEX.512.66.0F.WIG 73 /7 ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpslldq_zmm_zmmm512_imm8 = 1713,
	/// `PCMPEQB mm, mm/m64`
	///
	/// `NP 0F 74 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pcmpeqb_mm_mmm64 = 1714,
	/// `PCMPEQB xmm1, xmm2/m128`
	///
	/// `66 0F 74 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pcmpeqb_xmm_xmmm128 = 1715,
	/// `VPCMPEQB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 74 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqb_xmm_xmm_xmmm128 = 1716,
	/// `VPCMPEQB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 74 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqb_ymm_ymm_ymmm256 = 1717,
	/// `VPCMPEQB k1 {k2}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 74 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqb_kr_k1_xmm_xmmm128 = 1718,
	/// `VPCMPEQB k1 {k2}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 74 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqb_kr_k1_ymm_ymmm256 = 1719,
	/// `VPCMPEQB k1 {k2}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 74 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqb_kr_k1_zmm_zmmm512 = 1720,
	/// `PCMPEQW mm, mm/m64`
	///
	/// `NP 0F 75 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pcmpeqw_mm_mmm64 = 1721,
	/// `PCMPEQW xmm1, xmm2/m128`
	///
	/// `66 0F 75 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pcmpeqw_xmm_xmmm128 = 1722,
	/// `VPCMPEQW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 75 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqw_xmm_xmm_xmmm128 = 1723,
	/// `VPCMPEQW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 75 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqw_ymm_ymm_ymmm256 = 1724,
	/// `VPCMPEQW k1 {k2}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG 75 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqw_kr_k1_xmm_xmmm128 = 1725,
	/// `VPCMPEQW k1 {k2}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG 75 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqw_kr_k1_ymm_ymmm256 = 1726,
	/// `VPCMPEQW k1 {k2}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG 75 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqw_kr_k1_zmm_zmmm512 = 1727,
	/// `PCMPEQD mm, mm/m64`
	///
	/// `NP 0F 76 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pcmpeqd_mm_mmm64 = 1728,
	/// `PCMPEQD xmm1, xmm2/m128`
	///
	/// `66 0F 76 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pcmpeqd_xmm_xmmm128 = 1729,
	/// `VPCMPEQD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 76 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqd_xmm_xmm_xmmm128 = 1730,
	/// `VPCMPEQD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 76 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqd_ymm_ymm_ymmm256 = 1731,
	/// `VPCMPEQD k1 {k2}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 76 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqd_kr_k1_xmm_xmmm128b32 = 1732,
	/// `VPCMPEQD k1 {k2}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 76 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqd_kr_k1_ymm_ymmm256b32 = 1733,
	/// `VPCMPEQD k1 {k2}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 76 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqd_kr_k1_zmm_zmmm512b32 = 1734,
	/// `EMMS`
	///
	/// `NP 0F 77`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Emms = 1735,
	/// `VZEROUPPER`
	///
	/// `VEX.128.0F.WIG 77`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vzeroupper = 1736,
	/// `VZEROALL`
	///
	/// `VEX.256.0F.WIG 77`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vzeroall = 1737,
	/// `VMREAD r/m32, r32`
	///
	/// `NP 0F 78 /r`
	///
	/// `VMX`
	///
	/// `16/32-bit`
	Vmread_rm32_r32 = 1738,
	/// `VMREAD r/m64, r64`
	///
	/// `NP 0F 78 /r`
	///
	/// `VMX`
	///
	/// `64-bit`
	Vmread_rm64_r64 = 1739,
	/// `VCVTTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 78 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2udq_xmm_k1z_xmmm128b32 = 1740,
	/// `VCVTTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 78 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2udq_ymm_k1z_ymmm256b32 = 1741,
	/// `VCVTTPS2UDQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}`
	///
	/// `EVEX.512.0F.W0 78 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2udq_zmm_k1z_zmmm512b32_sae = 1742,
	/// `VCVTTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.0F.W1 78 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2udq_xmm_k1z_xmmm128b64 = 1743,
	/// `VCVTTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.0F.W1 78 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2udq_xmm_k1z_ymmm256b64 = 1744,
	/// `VCVTTPD2UDQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.0F.W1 78 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2udq_ymm_k1z_zmmm512b64_sae = 1745,
	/// `EXTRQ xmm1, imm8, imm8`
	///
	/// `66 0F 78 /0 ib ib`
	///
	/// `SSE4A`
	///
	/// `16/32/64-bit`
	Extrq_xmm_imm8_imm8 = 1746,
	/// `VCVTTPS2UQQ xmm1 {k1}{z}, xmm2/m64/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 78 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2uqq_xmm_k1z_xmmm64b32 = 1747,
	/// `VCVTTPS2UQQ ymm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 78 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2uqq_ymm_k1z_xmmm128b32 = 1748,
	/// `VCVTTPS2UQQ zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}`
	///
	/// `EVEX.512.66.0F.W0 78 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2uqq_zmm_k1z_ymmm256b32_sae = 1749,
	/// `VCVTTPD2UQQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 78 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2uqq_xmm_k1z_xmmm128b64 = 1750,
	/// `VCVTTPD2UQQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 78 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2uqq_ymm_k1z_ymmm256b64 = 1751,
	/// `VCVTTPD2UQQ zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F.W1 78 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2uqq_zmm_k1z_zmmm512b64_sae = 1752,
	/// `VCVTTSS2USI r32, xmm1/m32{sae}`
	///
	/// `EVEX.LIG.F3.0F.W0 78 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttss2usi_r32_xmmm32_sae = 1753,
	/// `VCVTTSS2USI r64, xmm1/m32{sae}`
	///
	/// `EVEX.LIG.F3.0F.W1 78 /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvttss2usi_r64_xmmm32_sae = 1754,
	/// `INSERTQ xmm1, xmm2, imm8, imm8`
	///
	/// `F2 0F 78 /r ib ib`
	///
	/// `SSE4A`
	///
	/// `16/32/64-bit`
	Insertq_xmm_xmm_imm8_imm8 = 1755,
	/// `VCVTTSD2USI r32, xmm1/m64{sae}`
	///
	/// `EVEX.LIG.F2.0F.W0 78 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttsd2usi_r32_xmmm64_sae = 1756,
	/// `VCVTTSD2USI r64, xmm1/m64{sae}`
	///
	/// `EVEX.LIG.F2.0F.W1 78 /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvttsd2usi_r64_xmmm64_sae = 1757,
	/// `VMWRITE r32, r/m32`
	///
	/// `NP 0F 79 /r`
	///
	/// `VMX`
	///
	/// `16/32-bit`
	Vmwrite_r32_rm32 = 1758,
	/// `VMWRITE r64, r/m64`
	///
	/// `NP 0F 79 /r`
	///
	/// `VMX`
	///
	/// `64-bit`
	Vmwrite_r64_rm64 = 1759,
	/// `VCVTPS2UDQ xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.0F.W0 79 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2udq_xmm_k1z_xmmm128b32 = 1760,
	/// `VCVTPS2UDQ ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.0F.W0 79 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2udq_ymm_k1z_ymmm256b32 = 1761,
	/// `VCVTPS2UDQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.0F.W0 79 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2udq_zmm_k1z_zmmm512b32_er = 1762,
	/// `VCVTPD2UDQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.0F.W1 79 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2udq_xmm_k1z_xmmm128b64 = 1763,
	/// `VCVTPD2UDQ xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.0F.W1 79 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2udq_xmm_k1z_ymmm256b64 = 1764,
	/// `VCVTPD2UDQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.0F.W1 79 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2udq_ymm_k1z_zmmm512b64_er = 1765,
	/// `EXTRQ xmm1, xmm2`
	///
	/// `66 0F 79 /r`
	///
	/// `SSE4A`
	///
	/// `16/32/64-bit`
	Extrq_xmm_xmm = 1766,
	/// `VCVTPS2UQQ xmm1 {k1}{z}, xmm2/m64/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 79 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2uqq_xmm_k1z_xmmm64b32 = 1767,
	/// `VCVTPS2UQQ ymm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 79 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2uqq_ymm_k1z_xmmm128b32 = 1768,
	/// `VCVTPS2UQQ zmm1 {k1}{z}, ymm2/m256/m32bcst{er}`
	///
	/// `EVEX.512.66.0F.W0 79 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2uqq_zmm_k1z_ymmm256b32_er = 1769,
	/// `VCVTPD2UQQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 79 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2uqq_xmm_k1z_xmmm128b64 = 1770,
	/// `VCVTPD2UQQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 79 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2uqq_ymm_k1z_ymmm256b64 = 1771,
	/// `VCVTPD2UQQ zmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 79 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2uqq_zmm_k1z_zmmm512b64_er = 1772,
	/// `VCVTSS2USI r32, xmm1/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 79 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtss2usi_r32_xmmm32_er = 1773,
	/// `VCVTSS2USI r64, xmm1/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W1 79 /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtss2usi_r64_xmmm32_er = 1774,
	/// `INSERTQ xmm1, xmm2`
	///
	/// `F2 0F 79 /r`
	///
	/// `SSE4A`
	///
	/// `16/32/64-bit`
	Insertq_xmm_xmm = 1775,
	/// `VCVTSD2USI r32, xmm1/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W0 79 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsd2usi_r32_xmmm64_er = 1776,
	/// `VCVTSD2USI r64, xmm1/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 79 /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtsd2usi_r64_xmmm64_er = 1777,
	/// `VCVTTPS2QQ xmm1 {k1}{z}, xmm2/m64/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2qq_xmm_k1z_xmmm64b32 = 1778,
	/// `VCVTTPS2QQ ymm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2qq_ymm_k1z_xmmm128b32 = 1779,
	/// `VCVTTPS2QQ zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}`
	///
	/// `EVEX.512.66.0F.W0 7A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttps2qq_zmm_k1z_ymmm256b32_sae = 1780,
	/// `VCVTTPD2QQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2qq_xmm_k1z_xmmm128b64 = 1781,
	/// `VCVTTPD2QQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2qq_ymm_k1z_ymmm256b64 = 1782,
	/// `VCVTTPD2QQ zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F.W1 7A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2qq_zmm_k1z_zmmm512b64_sae = 1783,
	/// `VCVTUDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst`
	///
	/// `EVEX.128.F3.0F.W0 7A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2pd_xmm_k1z_xmmm64b32 = 1784,
	/// `VCVTUDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.256.F3.0F.W0 7A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2pd_ymm_k1z_xmmm128b32 = 1785,
	/// `VCVTUDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{er}`
	///
	/// `EVEX.512.F3.0F.W0 7A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2pd_zmm_k1z_ymmm256b32_er = 1786,
	/// `VCVTUQQ2PD xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.F3.0F.W1 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2pd_xmm_k1z_xmmm128b64 = 1787,
	/// `VCVTUQQ2PD ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.F3.0F.W1 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2pd_ymm_k1z_ymmm256b64 = 1788,
	/// `VCVTUQQ2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.F3.0F.W1 7A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2pd_zmm_k1z_zmmm512b64_er = 1789,
	/// `VCVTUDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.F2.0F.W0 7A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2ps_xmm_k1z_xmmm128b32 = 1790,
	/// `VCVTUDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.F2.0F.W0 7A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2ps_ymm_k1z_ymmm256b32 = 1791,
	/// `VCVTUDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.F2.0F.W0 7A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2ps_zmm_k1z_zmmm512b32_er = 1792,
	/// `VCVTUQQ2PS xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.F2.0F.W1 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2ps_xmm_k1z_xmmm128b64 = 1793,
	/// `VCVTUQQ2PS xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.F2.0F.W1 7A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2ps_xmm_k1z_ymmm256b64 = 1794,
	/// `VCVTUQQ2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.F2.0F.W1 7A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2ps_ymm_k1z_zmmm512b64_er = 1795,
	/// `VCVTPS2QQ xmm1 {k1}{z}, xmm2/m64/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 7B /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2qq_xmm_k1z_xmmm64b32 = 1796,
	/// `VCVTPS2QQ ymm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 7B /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2qq_ymm_k1z_xmmm128b32 = 1797,
	/// `VCVTPS2QQ zmm1 {k1}{z}, ymm2/m256/m32bcst{er}`
	///
	/// `EVEX.512.66.0F.W0 7B /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2qq_zmm_k1z_ymmm256b32_er = 1798,
	/// `VCVTPD2QQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 7B /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2qq_xmm_k1z_xmmm128b64 = 1799,
	/// `VCVTPD2QQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 7B /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2qq_ymm_k1z_ymmm256b64 = 1800,
	/// `VCVTPD2QQ zmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F.W1 7B /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2qq_zmm_k1z_zmmm512b64_er = 1801,
	/// `VCVTUSI2SS xmm1, xmm2, r/m32{er}`
	///
	/// `EVEX.LIG.F3.0F.W0 7B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtusi2ss_xmm_xmm_rm32_er = 1802,
	/// `VCVTUSI2SS xmm1, xmm2, r/m64{er}`
	///
	/// `EVEX.LIG.F3.0F.W1 7B /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtusi2ss_xmm_xmm_rm64_er = 1803,
	/// `VCVTUSI2SD xmm1, xmm2, r/m32{er}`
	///
	/// `EVEX.LIG.F2.0F.W0 7B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtusi2sd_xmm_xmm_rm32_er = 1804,
	/// `VCVTUSI2SD xmm1, xmm2, r/m64{er}`
	///
	/// `EVEX.LIG.F2.0F.W1 7B /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vcvtusi2sd_xmm_xmm_rm64_er = 1805,
	/// `HADDPD xmm1, xmm2/m128`
	///
	/// `66 0F 7C /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Haddpd_xmm_xmmm128 = 1806,
	/// `VHADDPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 7C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhaddpd_xmm_xmm_xmmm128 = 1807,
	/// `VHADDPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 7C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhaddpd_ymm_ymm_ymmm256 = 1808,
	/// `HADDPS xmm1, xmm2/m128`
	///
	/// `F2 0F 7C /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Haddps_xmm_xmmm128 = 1809,
	/// `VHADDPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.F2.0F.WIG 7C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhaddps_xmm_xmm_xmmm128 = 1810,
	/// `VHADDPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.F2.0F.WIG 7C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhaddps_ymm_ymm_ymmm256 = 1811,
	/// `HSUBPD xmm1, xmm2/m128`
	///
	/// `66 0F 7D /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Hsubpd_xmm_xmmm128 = 1812,
	/// `VHSUBPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG 7D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhsubpd_xmm_xmm_xmmm128 = 1813,
	/// `VHSUBPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG 7D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhsubpd_ymm_ymm_ymmm256 = 1814,
	/// `HSUBPS xmm1, xmm2/m128`
	///
	/// `F2 0F 7D /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Hsubps_xmm_xmmm128 = 1815,
	/// `VHSUBPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.F2.0F.WIG 7D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhsubps_xmm_xmm_xmmm128 = 1816,
	/// `VHSUBPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.F2.0F.WIG 7D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vhsubps_ymm_ymm_ymmm256 = 1817,
	/// `MOVD r/m32, mm`
	///
	/// `NP 0F 7E /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Movd_rm32_mm = 1818,
	/// `MOVQ r/m64, mm`
	///
	/// `NP o64 0F 7E /r`
	///
	/// `MMX`
	///
	/// `64-bit`
	Movq_rm64_mm = 1819,
	/// `MOVD r/m32, xmm`
	///
	/// `66 0F 7E /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movd_rm32_xmm = 1820,
	/// `MOVQ r/m64, xmm`
	///
	/// `66 o64 0F 7E /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Movq_rm64_xmm = 1821,
	/// `VMOVD r/m32, xmm1`
	///
	/// `VEX.128.66.0F.W0 7E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovd_rm32_xmm = 1822,
	/// `VMOVQ r/m64, xmm1`
	///
	/// `VEX.128.66.0F.W1 7E /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vmovq_rm64_xmm = 1823,
	/// `VMOVD r/m32, xmm1`
	///
	/// `EVEX.128.66.0F.W0 7E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovd_rm32_xmm = 1824,
	/// `VMOVQ r/m64, xmm1`
	///
	/// `EVEX.128.66.0F.W1 7E /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vmovq_rm64_xmm = 1825,
	/// `MOVQ xmm1, xmm2/m64`
	///
	/// `F3 0F 7E /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movq_xmm_xmmm64 = 1826,
	/// `VMOVQ xmm1, xmm2/m64`
	///
	/// `VEX.128.F3.0F.WIG 7E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovq_xmm_xmmm64 = 1827,
	/// `VMOVQ xmm1, xmm2/m64`
	///
	/// `EVEX.128.F3.0F.W1 7E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovq_xmm_xmmm64 = 1828,
	/// `MOVQ mm/m64, mm`
	///
	/// `NP 0F 7F /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Movq_mmm64_mm = 1829,
	/// `MOVDQA xmm2/m128, xmm1`
	///
	/// `66 0F 7F /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movdqa_xmmm128_xmm = 1830,
	/// `VMOVDQA xmm2/m128, xmm1`
	///
	/// `VEX.128.66.0F.WIG 7F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqa_xmmm128_xmm = 1831,
	/// `VMOVDQA ymm2/m256, ymm1`
	///
	/// `VEX.256.66.0F.WIG 7F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqa_ymmm256_ymm = 1832,
	/// `VMOVDQA32 xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.66.0F.W0 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa32_xmmm128_k1z_xmm = 1833,
	/// `VMOVDQA32 ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.66.0F.W0 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa32_ymmm256_k1z_ymm = 1834,
	/// `VMOVDQA32 zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.66.0F.W0 7F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa32_zmmm512_k1z_zmm = 1835,
	/// `VMOVDQA64 xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.66.0F.W1 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa64_xmmm128_k1z_xmm = 1836,
	/// `VMOVDQA64 ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.66.0F.W1 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa64_ymmm256_k1z_ymm = 1837,
	/// `VMOVDQA64 zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.66.0F.W1 7F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqa64_zmmm512_k1z_zmm = 1838,
	/// `MOVDQU xmm2/m128, xmm1`
	///
	/// `F3 0F 7F /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movdqu_xmmm128_xmm = 1839,
	/// `VMOVDQU xmm2/m128, xmm1`
	///
	/// `VEX.128.F3.0F.WIG 7F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqu_xmmm128_xmm = 1840,
	/// `VMOVDQU ymm2/m256, ymm1`
	///
	/// `VEX.256.F3.0F.WIG 7F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovdqu_ymmm256_ymm = 1841,
	/// `VMOVDQU32 xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.F3.0F.W0 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu32_xmmm128_k1z_xmm = 1842,
	/// `VMOVDQU32 ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.F3.0F.W0 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu32_ymmm256_k1z_ymm = 1843,
	/// `VMOVDQU32 zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.F3.0F.W0 7F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu32_zmmm512_k1z_zmm = 1844,
	/// `VMOVDQU64 xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.F3.0F.W1 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu64_xmmm128_k1z_xmm = 1845,
	/// `VMOVDQU64 ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.F3.0F.W1 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu64_ymmm256_k1z_ymm = 1846,
	/// `VMOVDQU64 zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.F3.0F.W1 7F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu64_zmmm512_k1z_zmm = 1847,
	/// `VMOVDQU8 xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.F2.0F.W0 7F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu8_xmmm128_k1z_xmm = 1848,
	/// `VMOVDQU8 ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.F2.0F.W0 7F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu8_ymmm256_k1z_ymm = 1849,
	/// `VMOVDQU8 zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.F2.0F.W0 7F /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu8_zmmm512_k1z_zmm = 1850,
	/// `VMOVDQU16 xmm2/m128 {k1}{z}, xmm1`
	///
	/// `EVEX.128.F2.0F.W1 7F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu16_xmmm128_k1z_xmm = 1851,
	/// `VMOVDQU16 ymm2/m256 {k1}{z}, ymm1`
	///
	/// `EVEX.256.F2.0F.W1 7F /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu16_ymmm256_k1z_ymm = 1852,
	/// `VMOVDQU16 zmm2/m512 {k1}{z}, zmm1`
	///
	/// `EVEX.512.F2.0F.W1 7F /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vmovdqu16_zmmm512_k1z_zmm = 1853,
	/// `JO rel16`
	///
	/// `o16 0F 80 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jo_rel16 = 1854,
	/// `JO rel32`
	///
	/// `o32 0F 80 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jo_rel32_32 = 1855,
	/// `JO rel32`
	///
	/// `o64 0F 80 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jo_rel32_64 = 1856,
	/// `JNO rel16`
	///
	/// `o16 0F 81 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jno_rel16 = 1857,
	/// `JNO rel32`
	///
	/// `o32 0F 81 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jno_rel32_32 = 1858,
	/// `JNO rel32`
	///
	/// `o64 0F 81 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jno_rel32_64 = 1859,
	/// `JB rel16`
	///
	/// `o16 0F 82 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jb_rel16 = 1860,
	/// `JB rel32`
	///
	/// `o32 0F 82 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jb_rel32_32 = 1861,
	/// `JB rel32`
	///
	/// `o64 0F 82 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jb_rel32_64 = 1862,
	/// `JAE rel16`
	///
	/// `o16 0F 83 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jae_rel16 = 1863,
	/// `JAE rel32`
	///
	/// `o32 0F 83 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jae_rel32_32 = 1864,
	/// `JAE rel32`
	///
	/// `o64 0F 83 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jae_rel32_64 = 1865,
	/// `JE rel16`
	///
	/// `o16 0F 84 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Je_rel16 = 1866,
	/// `JE rel32`
	///
	/// `o32 0F 84 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Je_rel32_32 = 1867,
	/// `JE rel32`
	///
	/// `o64 0F 84 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Je_rel32_64 = 1868,
	/// `JNE rel16`
	///
	/// `o16 0F 85 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jne_rel16 = 1869,
	/// `JNE rel32`
	///
	/// `o32 0F 85 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jne_rel32_32 = 1870,
	/// `JNE rel32`
	///
	/// `o64 0F 85 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jne_rel32_64 = 1871,
	/// `JBE rel16`
	///
	/// `o16 0F 86 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jbe_rel16 = 1872,
	/// `JBE rel32`
	///
	/// `o32 0F 86 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jbe_rel32_32 = 1873,
	/// `JBE rel32`
	///
	/// `o64 0F 86 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jbe_rel32_64 = 1874,
	/// `JA rel16`
	///
	/// `o16 0F 87 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Ja_rel16 = 1875,
	/// `JA rel32`
	///
	/// `o32 0F 87 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Ja_rel32_32 = 1876,
	/// `JA rel32`
	///
	/// `o64 0F 87 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Ja_rel32_64 = 1877,
	/// `JS rel16`
	///
	/// `o16 0F 88 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Js_rel16 = 1878,
	/// `JS rel32`
	///
	/// `o32 0F 88 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Js_rel32_32 = 1879,
	/// `JS rel32`
	///
	/// `o64 0F 88 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Js_rel32_64 = 1880,
	/// `JNS rel16`
	///
	/// `o16 0F 89 cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jns_rel16 = 1881,
	/// `JNS rel32`
	///
	/// `o32 0F 89 cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jns_rel32_32 = 1882,
	/// `JNS rel32`
	///
	/// `o64 0F 89 cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jns_rel32_64 = 1883,
	/// `JP rel16`
	///
	/// `o16 0F 8A cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jp_rel16 = 1884,
	/// `JP rel32`
	///
	/// `o32 0F 8A cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jp_rel32_32 = 1885,
	/// `JP rel32`
	///
	/// `o64 0F 8A cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jp_rel32_64 = 1886,
	/// `JNP rel16`
	///
	/// `o16 0F 8B cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jnp_rel16 = 1887,
	/// `JNP rel32`
	///
	/// `o32 0F 8B cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jnp_rel32_32 = 1888,
	/// `JNP rel32`
	///
	/// `o64 0F 8B cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jnp_rel32_64 = 1889,
	/// `JL rel16`
	///
	/// `o16 0F 8C cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jl_rel16 = 1890,
	/// `JL rel32`
	///
	/// `o32 0F 8C cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jl_rel32_32 = 1891,
	/// `JL rel32`
	///
	/// `o64 0F 8C cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jl_rel32_64 = 1892,
	/// `JGE rel16`
	///
	/// `o16 0F 8D cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jge_rel16 = 1893,
	/// `JGE rel32`
	///
	/// `o32 0F 8D cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jge_rel32_32 = 1894,
	/// `JGE rel32`
	///
	/// `o64 0F 8D cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jge_rel32_64 = 1895,
	/// `JLE rel16`
	///
	/// `o16 0F 8E cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jle_rel16 = 1896,
	/// `JLE rel32`
	///
	/// `o32 0F 8E cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jle_rel32_32 = 1897,
	/// `JLE rel32`
	///
	/// `o64 0F 8E cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jle_rel32_64 = 1898,
	/// `JG rel16`
	///
	/// `o16 0F 8F cw`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Jg_rel16 = 1899,
	/// `JG rel32`
	///
	/// `o32 0F 8F cd`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Jg_rel32_32 = 1900,
	/// `JG rel32`
	///
	/// `o64 0F 8F cd`
	///
	/// `X64`
	///
	/// `64-bit`
	Jg_rel32_64 = 1901,
	/// `SETO r/m8`
	///
	/// `0F 90 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Seto_rm8 = 1902,
	/// `SETNO r/m8`
	///
	/// `0F 91 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setno_rm8 = 1903,
	/// `SETB r/m8`
	///
	/// `0F 92 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setb_rm8 = 1904,
	/// `SETAE r/m8`
	///
	/// `0F 93 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setae_rm8 = 1905,
	/// `SETE r/m8`
	///
	/// `0F 94 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sete_rm8 = 1906,
	/// `SETNE r/m8`
	///
	/// `0F 95 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setne_rm8 = 1907,
	/// `SETBE r/m8`
	///
	/// `0F 96 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setbe_rm8 = 1908,
	/// `SETA r/m8`
	///
	/// `0F 97 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Seta_rm8 = 1909,
	/// `SETS r/m8`
	///
	/// `0F 98 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Sets_rm8 = 1910,
	/// `SETNS r/m8`
	///
	/// `0F 99 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setns_rm8 = 1911,
	/// `SETP r/m8`
	///
	/// `0F 9A /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setp_rm8 = 1912,
	/// `SETNP r/m8`
	///
	/// `0F 9B /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setnp_rm8 = 1913,
	/// `SETL r/m8`
	///
	/// `0F 9C /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setl_rm8 = 1914,
	/// `SETGE r/m8`
	///
	/// `0F 9D /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setge_rm8 = 1915,
	/// `SETLE r/m8`
	///
	/// `0F 9E /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setle_rm8 = 1916,
	/// `SETG r/m8`
	///
	/// `0F 9F /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Setg_rm8 = 1917,
	/// `KMOVW k1, k2/m16`
	///
	/// `VEX.L0.0F.W0 90 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kmovw_kr_km16 = 1918,
	/// `KMOVQ k1, k2/m64`
	///
	/// `VEX.L0.0F.W1 90 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kmovq_kr_km64 = 1919,
	/// `KMOVB k1, k2/m8`
	///
	/// `VEX.L0.66.0F.W0 90 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kmovb_kr_km8 = 1920,
	/// `KMOVD k1, k2/m32`
	///
	/// `VEX.L0.66.0F.W1 90 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kmovd_kr_km32 = 1921,
	/// `KMOVW m16, k1`
	///
	/// `VEX.L0.0F.W0 91 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kmovw_m16_kr = 1922,
	/// `KMOVQ m64, k1`
	///
	/// `VEX.L0.0F.W1 91 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kmovq_m64_kr = 1923,
	/// `KMOVB m8, k1`
	///
	/// `VEX.L0.66.0F.W0 91 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kmovb_m8_kr = 1924,
	/// `KMOVD m32, k1`
	///
	/// `VEX.L0.66.0F.W1 91 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kmovd_m32_kr = 1925,
	/// `KMOVW k1, r32`
	///
	/// `VEX.L0.0F.W0 92 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kmovw_kr_r32 = 1926,
	/// `KMOVB k1, r32`
	///
	/// `VEX.L0.66.0F.W0 92 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kmovb_kr_r32 = 1927,
	/// `KMOVD k1, r32`
	///
	/// `VEX.L0.F2.0F.W0 92 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kmovd_kr_r32 = 1928,
	/// `KMOVQ k1, r64`
	///
	/// `VEX.L0.F2.0F.W1 92 /r`
	///
	/// `AVX512BW`
	///
	/// `64-bit`
	VEX_Kmovq_kr_r64 = 1929,
	/// `KMOVW r32, k1`
	///
	/// `VEX.L0.0F.W0 93 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kmovw_r32_kr = 1930,
	/// `KMOVB r32, k1`
	///
	/// `VEX.L0.66.0F.W0 93 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kmovb_r32_kr = 1931,
	/// `KMOVD r32, k1`
	///
	/// `VEX.L0.F2.0F.W0 93 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kmovd_r32_kr = 1932,
	/// `KMOVQ r64, k1`
	///
	/// `VEX.L0.F2.0F.W1 93 /r`
	///
	/// `AVX512BW`
	///
	/// `64-bit`
	VEX_Kmovq_r64_kr = 1933,
	/// `KORTESTW k1, k2`
	///
	/// `VEX.L0.0F.W0 98 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kortestw_kr_kr = 1934,
	/// `KORTESTQ k1, k2`
	///
	/// `VEX.L0.0F.W1 98 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kortestq_kr_kr = 1935,
	/// `KORTESTB k1, k2`
	///
	/// `VEX.L0.66.0F.W0 98 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kortestb_kr_kr = 1936,
	/// `KORTESTD k1, k2`
	///
	/// `VEX.L0.66.0F.W1 98 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kortestd_kr_kr = 1937,
	/// `KTESTW k1, k2`
	///
	/// `VEX.L0.0F.W0 99 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Ktestw_kr_kr = 1938,
	/// `KTESTQ k1, k2`
	///
	/// `VEX.L0.0F.W1 99 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Ktestq_kr_kr = 1939,
	/// `KTESTB k1, k2`
	///
	/// `VEX.L0.66.0F.W0 99 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Ktestb_kr_kr = 1940,
	/// `KTESTD k1, k2`
	///
	/// `VEX.L0.66.0F.W1 99 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Ktestd_kr_kr = 1941,
	/// `PUSH FS`
	///
	/// `o16 0F A0`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Pushw_FS = 1942,
	/// `PUSH FS`
	///
	/// `o32 0F A0`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_FS = 1943,
	/// `PUSH FS`
	///
	/// `o64 0F A0`
	///
	/// `X64`
	///
	/// `64-bit`
	Pushq_FS = 1944,
	/// `POP FS`
	///
	/// `o16 0F A1`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Popw_FS = 1945,
	/// `POP FS`
	///
	/// `o32 0F A1`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Popd_FS = 1946,
	/// `POP FS`
	///
	/// `o64 0F A1`
	///
	/// `X64`
	///
	/// `64-bit`
	Popq_FS = 1947,
	/// `CPUID`
	///
	/// `0F A2`
	///
	/// `CPUID`
	///
	/// `16/32/64-bit`
	Cpuid = 1948,
	/// `BT r/m16, r16`
	///
	/// `o16 0F A3 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bt_rm16_r16 = 1949,
	/// `BT r/m32, r32`
	///
	/// `o32 0F A3 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bt_rm32_r32 = 1950,
	/// `BT r/m64, r64`
	///
	/// `o64 0F A3 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Bt_rm64_r64 = 1951,
	/// `SHLD r/m16, r16, imm8`
	///
	/// `o16 0F A4 /r ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shld_rm16_r16_imm8 = 1952,
	/// `SHLD r/m32, r32, imm8`
	///
	/// `o32 0F A4 /r ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shld_rm32_r32_imm8 = 1953,
	/// `SHLD r/m64, r64, imm8`
	///
	/// `o64 0F A4 /r ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Shld_rm64_r64_imm8 = 1954,
	/// `SHLD r/m16, r16, CL`
	///
	/// `o16 0F A5 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shld_rm16_r16_CL = 1955,
	/// `SHLD r/m32, r32, CL`
	///
	/// `o32 0F A5 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shld_rm32_r32_CL = 1956,
	/// `SHLD r/m64, r64, CL`
	///
	/// `o64 0F A5 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Shld_rm64_r64_CL = 1957,
	/// `MONTMUL`
	///
	/// `a16 F3 0F A6 C0`
	///
	/// `PADLOCK_PMM`
	///
	/// `16/32-bit`
	Montmul_16 = 1958,
	/// `MONTMUL`
	///
	/// `a32 F3 0F A6 C0`
	///
	/// `PADLOCK_PMM`
	///
	/// `16/32/64-bit`
	Montmul_32 = 1959,
	/// `MONTMUL`
	///
	/// `a64 F3 0F A6 C0`
	///
	/// `PADLOCK_PMM`
	///
	/// `64-bit`
	Montmul_64 = 1960,
	/// `XSHA1`
	///
	/// `a16 F3 0F A6 C8`
	///
	/// `PADLOCK_PHE`
	///
	/// `16/32-bit`
	Xsha1_16 = 1961,
	/// `XSHA1`
	///
	/// `a32 F3 0F A6 C8`
	///
	/// `PADLOCK_PHE`
	///
	/// `16/32/64-bit`
	Xsha1_32 = 1962,
	/// `XSHA1`
	///
	/// `a64 F3 0F A6 C8`
	///
	/// `PADLOCK_PHE`
	///
	/// `64-bit`
	Xsha1_64 = 1963,
	/// `XSHA256`
	///
	/// `a16 F3 0F A6 D0`
	///
	/// `PADLOCK_PHE`
	///
	/// `16/32-bit`
	Xsha256_16 = 1964,
	/// `XSHA256`
	///
	/// `a32 F3 0F A6 D0`
	///
	/// `PADLOCK_PHE`
	///
	/// `16/32/64-bit`
	Xsha256_32 = 1965,
	/// `XSHA256`
	///
	/// `a64 F3 0F A6 D0`
	///
	/// `PADLOCK_PHE`
	///
	/// `64-bit`
	Xsha256_64 = 1966,
	/// `XBTS r16, r/m16`
	///
	/// `o16 0F A6 /r`
	///
	/// `386 A0`
	///
	/// `16/32-bit`
	Xbts_r16_rm16 = 1967,
	/// `XBTS r32, r/m32`
	///
	/// `o32 0F A6 /r`
	///
	/// `386 A0`
	///
	/// `16/32-bit`
	Xbts_r32_rm32 = 1968,
	/// `XSTORE`
	///
	/// `a16 0F A7 C0`
	///
	/// `PADLOCK_RNG`
	///
	/// `16/32-bit`
	Xstore_16 = 1969,
	/// `XSTORE`
	///
	/// `a32 0F A7 C0`
	///
	/// `PADLOCK_RNG`
	///
	/// `16/32/64-bit`
	Xstore_32 = 1970,
	/// `XSTORE`
	///
	/// `a64 0F A7 C0`
	///
	/// `PADLOCK_RNG`
	///
	/// `64-bit`
	Xstore_64 = 1971,
	/// `XCRYPTECB`
	///
	/// `a16 F3 0F A7 C8`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32-bit`
	Xcryptecb_16 = 1972,
	/// `XCRYPTECB`
	///
	/// `a32 F3 0F A7 C8`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32/64-bit`
	Xcryptecb_32 = 1973,
	/// `XCRYPTECB`
	///
	/// `a64 F3 0F A7 C8`
	///
	/// `PADLOCK_ACE`
	///
	/// `64-bit`
	Xcryptecb_64 = 1974,
	/// `XCRYPTCBC`
	///
	/// `a16 F3 0F A7 D0`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32-bit`
	Xcryptcbc_16 = 1975,
	/// `XCRYPTCBC`
	///
	/// `a32 F3 0F A7 D0`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32/64-bit`
	Xcryptcbc_32 = 1976,
	/// `XCRYPTCBC`
	///
	/// `a64 F3 0F A7 D0`
	///
	/// `PADLOCK_ACE`
	///
	/// `64-bit`
	Xcryptcbc_64 = 1977,
	/// `XCRYPTCTR`
	///
	/// `a16 F3 0F A7 D8`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32-bit`
	Xcryptctr_16 = 1978,
	/// `XCRYPTCTR`
	///
	/// `a32 F3 0F A7 D8`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32/64-bit`
	Xcryptctr_32 = 1979,
	/// `XCRYPTCTR`
	///
	/// `a64 F3 0F A7 D8`
	///
	/// `PADLOCK_ACE`
	///
	/// `64-bit`
	Xcryptctr_64 = 1980,
	/// `XCRYPTCFB`
	///
	/// `a16 F3 0F A7 E0`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32-bit`
	Xcryptcfb_16 = 1981,
	/// `XCRYPTCFB`
	///
	/// `a32 F3 0F A7 E0`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32/64-bit`
	Xcryptcfb_32 = 1982,
	/// `XCRYPTCFB`
	///
	/// `a64 F3 0F A7 E0`
	///
	/// `PADLOCK_ACE`
	///
	/// `64-bit`
	Xcryptcfb_64 = 1983,
	/// `XCRYPTOFB`
	///
	/// `a16 F3 0F A7 E8`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32-bit`
	Xcryptofb_16 = 1984,
	/// `XCRYPTOFB`
	///
	/// `a32 F3 0F A7 E8`
	///
	/// `PADLOCK_ACE`
	///
	/// `16/32/64-bit`
	Xcryptofb_32 = 1985,
	/// `XCRYPTOFB`
	///
	/// `a64 F3 0F A7 E8`
	///
	/// `PADLOCK_ACE`
	///
	/// `64-bit`
	Xcryptofb_64 = 1986,
	/// `IBTS r/m16, r16`
	///
	/// `o16 0F A7 /r`
	///
	/// `386 A0`
	///
	/// `16/32-bit`
	Ibts_rm16_r16 = 1987,
	/// `IBTS r/m32, r32`
	///
	/// `o32 0F A7 /r`
	///
	/// `386 A0`
	///
	/// `16/32-bit`
	Ibts_rm32_r32 = 1988,
	/// `CMPXCHG r/m8, r8`
	///
	/// `0F A6 /r`
	///
	/// `486 A`
	///
	/// `16/32-bit`
	Cmpxchg486_rm8_r8 = 1989,
	/// `CMPXCHG r/m16, r16`
	///
	/// `o16 0F A7 /r`
	///
	/// `486 A`
	///
	/// `16/32-bit`
	Cmpxchg486_rm16_r16 = 1990,
	/// `CMPXCHG r/m32, r32`
	///
	/// `o32 0F A7 /r`
	///
	/// `486 A`
	///
	/// `16/32-bit`
	Cmpxchg486_rm32_r32 = 1991,
	/// `PUSH GS`
	///
	/// `o16 0F A8`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Pushw_GS = 1992,
	/// `PUSH GS`
	///
	/// `o32 0F A8`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Pushd_GS = 1993,
	/// `PUSH GS`
	///
	/// `o64 0F A8`
	///
	/// `X64`
	///
	/// `64-bit`
	Pushq_GS = 1994,
	/// `POP GS`
	///
	/// `o16 0F A9`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Popw_GS = 1995,
	/// `POP GS`
	///
	/// `o32 0F A9`
	///
	/// `386+`
	///
	/// `16/32-bit`
	Popd_GS = 1996,
	/// `POP GS`
	///
	/// `o64 0F A9`
	///
	/// `X64`
	///
	/// `64-bit`
	Popq_GS = 1997,
	/// `RSM`
	///
	/// `0F AA`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Rsm = 1998,
	/// `BTS r/m16, r16`
	///
	/// `o16 0F AB /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bts_rm16_r16 = 1999,
	/// `BTS r/m32, r32`
	///
	/// `o32 0F AB /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bts_rm32_r32 = 2000,
	/// `BTS r/m64, r64`
	///
	/// `o64 0F AB /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Bts_rm64_r64 = 2001,
	/// `SHRD r/m16, r16, imm8`
	///
	/// `o16 0F AC /r ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shrd_rm16_r16_imm8 = 2002,
	/// `SHRD r/m32, r32, imm8`
	///
	/// `o32 0F AC /r ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shrd_rm32_r32_imm8 = 2003,
	/// `SHRD r/m64, r64, imm8`
	///
	/// `o64 0F AC /r ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Shrd_rm64_r64_imm8 = 2004,
	/// `SHRD r/m16, r16, CL`
	///
	/// `o16 0F AD /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shrd_rm16_r16_CL = 2005,
	/// `SHRD r/m32, r32, CL`
	///
	/// `o32 0F AD /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Shrd_rm32_r32_CL = 2006,
	/// `SHRD r/m64, r64, CL`
	///
	/// `o64 0F AD /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Shrd_rm64_r64_CL = 2007,
	/// `FXSAVE m512byte`
	///
	/// `NP 0F AE /0`
	///
	/// `FXSR`
	///
	/// `16/32/64-bit`
	Fxsave_m512byte = 2008,
	/// `FXSAVE64 m512byte`
	///
	/// `NP o64 0F AE /0`
	///
	/// `FXSR`
	///
	/// `64-bit`
	Fxsave64_m512byte = 2009,
	/// `RDFSBASE r32`
	///
	/// `F3 0F AE /0`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Rdfsbase_r32 = 2010,
	/// `RDFSBASE r64`
	///
	/// `F3 o64 0F AE /0`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Rdfsbase_r64 = 2011,
	/// `FXRSTOR m512byte`
	///
	/// `NP 0F AE /1`
	///
	/// `FXSR`
	///
	/// `16/32/64-bit`
	Fxrstor_m512byte = 2012,
	/// `FXRSTOR64 m512byte`
	///
	/// `NP o64 0F AE /1`
	///
	/// `FXSR`
	///
	/// `64-bit`
	Fxrstor64_m512byte = 2013,
	/// `RDGSBASE r32`
	///
	/// `F3 0F AE /1`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Rdgsbase_r32 = 2014,
	/// `RDGSBASE r64`
	///
	/// `F3 o64 0F AE /1`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Rdgsbase_r64 = 2015,
	/// `LDMXCSR m32`
	///
	/// `NP 0F AE /2`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Ldmxcsr_m32 = 2016,
	/// `WRFSBASE r32`
	///
	/// `F3 0F AE /2`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Wrfsbase_r32 = 2017,
	/// `WRFSBASE r64`
	///
	/// `F3 o64 0F AE /2`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Wrfsbase_r64 = 2018,
	/// `VLDMXCSR m32`
	///
	/// `VEX.LZ.0F.WIG AE /2`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vldmxcsr_m32 = 2019,
	/// `STMXCSR m32`
	///
	/// `NP 0F AE /3`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Stmxcsr_m32 = 2020,
	/// `WRGSBASE r32`
	///
	/// `F3 0F AE /3`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Wrgsbase_r32 = 2021,
	/// `WRGSBASE r64`
	///
	/// `F3 o64 0F AE /3`
	///
	/// `FSGSBASE`
	///
	/// `64-bit`
	Wrgsbase_r64 = 2022,
	/// `VSTMXCSR m32`
	///
	/// `VEX.LZ.0F.WIG AE /3`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vstmxcsr_m32 = 2023,
	/// `XSAVE mem`
	///
	/// `NP 0F AE /4`
	///
	/// `XSAVE`
	///
	/// `16/32/64-bit`
	Xsave_mem = 2024,
	/// `XSAVE64 mem`
	///
	/// `NP o64 0F AE /4`
	///
	/// `XSAVE`
	///
	/// `64-bit`
	Xsave64_mem = 2025,
	/// `PTWRITE r/m32`
	///
	/// `F3 0F AE /4`
	///
	/// `PTWRITE`
	///
	/// `16/32/64-bit`
	Ptwrite_rm32 = 2026,
	/// `PTWRITE r/m64`
	///
	/// `F3 o64 0F AE /4`
	///
	/// `PTWRITE`
	///
	/// `64-bit`
	Ptwrite_rm64 = 2027,
	/// `XRSTOR mem`
	///
	/// `NP 0F AE /5`
	///
	/// `XSAVE`
	///
	/// `16/32/64-bit`
	Xrstor_mem = 2028,
	/// `XRSTOR64 mem`
	///
	/// `NP o64 0F AE /5`
	///
	/// `XSAVE`
	///
	/// `64-bit`
	Xrstor64_mem = 2029,
	/// `INCSSPD r32`
	///
	/// `F3 0F AE /5`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Incsspd_r32 = 2030,
	/// `INCSSPQ r64`
	///
	/// `F3 o64 0F AE /5`
	///
	/// `CET_SS`
	///
	/// `64-bit`
	Incsspq_r64 = 2031,
	/// `XSAVEOPT mem`
	///
	/// `NP 0F AE /6`
	///
	/// `XSAVEOPT`
	///
	/// `16/32/64-bit`
	Xsaveopt_mem = 2032,
	/// `XSAVEOPT64 mem`
	///
	/// `NP o64 0F AE /6`
	///
	/// `XSAVEOPT`
	///
	/// `64-bit`
	Xsaveopt64_mem = 2033,
	/// `CLWB m8`
	///
	/// `66 0F AE /6`
	///
	/// `CLWB`
	///
	/// `16/32/64-bit`
	Clwb_m8 = 2034,
	/// `TPAUSE r32, <edx>, <eax>`
	///
	/// `66 0F AE /6`
	///
	/// `WAITPKG`
	///
	/// `16/32/64-bit`
	Tpause_r32 = 2035,
	/// `TPAUSE r64, <edx>, <eax>`
	///
	/// `66 o64 0F AE /6`
	///
	/// `WAITPKG`
	///
	/// `64-bit`
	Tpause_r64 = 2036,
	/// `CLRSSBSY m64`
	///
	/// `F3 0F AE /6`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Clrssbsy_m64 = 2037,
	/// `UMONITOR r16`
	///
	/// `a16 F3 0F AE /6`
	///
	/// `WAITPKG`
	///
	/// `16/32-bit`
	Umonitor_r16 = 2038,
	/// `UMONITOR r32`
	///
	/// `a32 F3 0F AE /6`
	///
	/// `WAITPKG`
	///
	/// `16/32/64-bit`
	Umonitor_r32 = 2039,
	/// `UMONITOR r64`
	///
	/// `a64 F3 0F AE /6`
	///
	/// `WAITPKG`
	///
	/// `64-bit`
	Umonitor_r64 = 2040,
	/// `UMWAIT r32, <edx>, <eax>`
	///
	/// `F2 0F AE /6`
	///
	/// `WAITPKG`
	///
	/// `16/32/64-bit`
	Umwait_r32 = 2041,
	/// `UMWAIT r64, <edx>, <eax>`
	///
	/// `F2 o64 0F AE /6`
	///
	/// `WAITPKG`
	///
	/// `64-bit`
	Umwait_r64 = 2042,
	/// `CLFLUSH m8`
	///
	/// `NP 0F AE /7`
	///
	/// `CLFSH`
	///
	/// `16/32/64-bit`
	Clflush_m8 = 2043,
	/// `CLFLUSHOPT m8`
	///
	/// `66 0F AE /7`
	///
	/// `CLFLUSHOPT`
	///
	/// `16/32/64-bit`
	Clflushopt_m8 = 2044,
	/// `LFENCE`
	///
	/// `NP 0F AE E8`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence = 2045,
	/// `LFENCE`
	///
	/// `NP 0F AE E9`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence_E9 = 2046,
	/// `LFENCE`
	///
	/// `NP 0F AE EA`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence_EA = 2047,
	/// `LFENCE`
	///
	/// `NP 0F AE EB`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence_EB = 2048,
	/// `LFENCE`
	///
	/// `NP 0F AE EC`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence_EC = 2049,
	/// `LFENCE`
	///
	/// `NP 0F AE ED`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence_ED = 2050,
	/// `LFENCE`
	///
	/// `NP 0F AE EE`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence_EE = 2051,
	/// `LFENCE`
	///
	/// `NP 0F AE EF`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Lfence_EF = 2052,
	/// `MFENCE`
	///
	/// `NP 0F AE F0`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence = 2053,
	/// `MFENCE`
	///
	/// `NP 0F AE F1`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence_F1 = 2054,
	/// `MFENCE`
	///
	/// `NP 0F AE F2`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence_F2 = 2055,
	/// `MFENCE`
	///
	/// `NP 0F AE F3`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence_F3 = 2056,
	/// `MFENCE`
	///
	/// `NP 0F AE F4`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence_F4 = 2057,
	/// `MFENCE`
	///
	/// `NP 0F AE F5`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence_F5 = 2058,
	/// `MFENCE`
	///
	/// `NP 0F AE F6`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence_F6 = 2059,
	/// `MFENCE`
	///
	/// `NP 0F AE F7`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Mfence_F7 = 2060,
	/// `SFENCE`
	///
	/// `NP 0F AE F8`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence = 2061,
	/// `SFENCE`
	///
	/// `NP 0F AE F9`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence_F9 = 2062,
	/// `SFENCE`
	///
	/// `NP 0F AE FA`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence_FA = 2063,
	/// `SFENCE`
	///
	/// `NP 0F AE FB`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence_FB = 2064,
	/// `SFENCE`
	///
	/// `NP 0F AE FC`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence_FC = 2065,
	/// `SFENCE`
	///
	/// `NP 0F AE FD`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence_FD = 2066,
	/// `SFENCE`
	///
	/// `NP 0F AE FE`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence_FE = 2067,
	/// `SFENCE`
	///
	/// `NP 0F AE FF`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Sfence_FF = 2068,
	/// `PCOMMIT`
	///
	/// `66 0F AE F8`
	///
	/// `PCOMMIT`
	///
	/// `16/32/64-bit`
	Pcommit = 2069,
	/// `IMUL r16, r/m16`
	///
	/// `o16 0F AF /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Imul_r16_rm16 = 2070,
	/// `IMUL r32, r/m32`
	///
	/// `o32 0F AF /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Imul_r32_rm32 = 2071,
	/// `IMUL r64, r/m64`
	///
	/// `o64 0F AF /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Imul_r64_rm64 = 2072,
	/// `CMPXCHG r/m8, r8`
	///
	/// `0F B0 /r`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Cmpxchg_rm8_r8 = 2073,
	/// `CMPXCHG r/m16, r16`
	///
	/// `o16 0F B1 /r`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Cmpxchg_rm16_r16 = 2074,
	/// `CMPXCHG r/m32, r32`
	///
	/// `o32 0F B1 /r`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Cmpxchg_rm32_r32 = 2075,
	/// `CMPXCHG r/m64, r64`
	///
	/// `o64 0F B1 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Cmpxchg_rm64_r64 = 2076,
	/// `LSS r16, m16:16`
	///
	/// `o16 0F B2 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lss_r16_m1616 = 2077,
	/// `LSS r32, m16:32`
	///
	/// `o32 0F B2 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lss_r32_m1632 = 2078,
	/// `LSS r64, m16:64`
	///
	/// `o64 0F B2 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Lss_r64_m1664 = 2079,
	/// `BTR r/m16, r16`
	///
	/// `o16 0F B3 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btr_rm16_r16 = 2080,
	/// `BTR r/m32, r32`
	///
	/// `o32 0F B3 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btr_rm32_r32 = 2081,
	/// `BTR r/m64, r64`
	///
	/// `o64 0F B3 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Btr_rm64_r64 = 2082,
	/// `LFS r16, m16:16`
	///
	/// `o16 0F B4 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lfs_r16_m1616 = 2083,
	/// `LFS r32, m16:32`
	///
	/// `o32 0F B4 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lfs_r32_m1632 = 2084,
	/// `LFS r64, m16:64`
	///
	/// `o64 0F B4 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Lfs_r64_m1664 = 2085,
	/// `LGS r16, m16:16`
	///
	/// `o16 0F B5 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lgs_r16_m1616 = 2086,
	/// `LGS r32, m16:32`
	///
	/// `o32 0F B5 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Lgs_r32_m1632 = 2087,
	/// `LGS r64, m16:64`
	///
	/// `o64 0F B5 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Lgs_r64_m1664 = 2088,
	/// `MOVZX r16, r/m8`
	///
	/// `o16 0F B6 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movzx_r16_rm8 = 2089,
	/// `MOVZX r32, r/m8`
	///
	/// `o32 0F B6 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movzx_r32_rm8 = 2090,
	/// `MOVZX r64, r/m8`
	///
	/// `o64 0F B6 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Movzx_r64_rm8 = 2091,
	/// `MOVZX r16, r/m16`
	///
	/// `o16 0F B7 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movzx_r16_rm16 = 2092,
	/// `MOVZX r32, r/m16`
	///
	/// `o32 0F B7 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movzx_r32_rm16 = 2093,
	/// `MOVZX r64, r/m16`
	///
	/// `o64 0F B7 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Movzx_r64_rm16 = 2094,
	/// `JMPE disp16`
	///
	/// `o16 0F B8 cw`
	///
	/// `IA-64`
	///
	/// `16/32-bit`
	Jmpe_disp16 = 2095,
	/// `JMPE disp32`
	///
	/// `o32 0F B8 cd`
	///
	/// `IA-64`
	///
	/// `16/32-bit`
	Jmpe_disp32 = 2096,
	/// `POPCNT r16, r/m16`
	///
	/// `o16 F3 0F B8 /r`
	///
	/// `POPCNT`
	///
	/// `16/32/64-bit`
	Popcnt_r16_rm16 = 2097,
	/// `POPCNT r32, r/m32`
	///
	/// `o32 F3 0F B8 /r`
	///
	/// `POPCNT`
	///
	/// `16/32/64-bit`
	Popcnt_r32_rm32 = 2098,
	/// `POPCNT r64, r/m64`
	///
	/// `F3 o64 0F B8 /r`
	///
	/// `POPCNT`
	///
	/// `64-bit`
	Popcnt_r64_rm64 = 2099,
	/// `UD1 r16, r/m16`
	///
	/// `o16 0F B9 /r`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Ud1_r16_rm16 = 2100,
	/// `UD1 r32, r/m32`
	///
	/// `o32 0F B9 /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Ud1_r32_rm32 = 2101,
	/// `UD1 r64, r/m64`
	///
	/// `o64 0F B9 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Ud1_r64_rm64 = 2102,
	/// `BT r/m16, imm8`
	///
	/// `o16 0F BA /4 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bt_rm16_imm8 = 2103,
	/// `BT r/m32, imm8`
	///
	/// `o32 0F BA /4 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bt_rm32_imm8 = 2104,
	/// `BT r/m64, imm8`
	///
	/// `o64 0F BA /4 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Bt_rm64_imm8 = 2105,
	/// `BTS r/m16, imm8`
	///
	/// `o16 0F BA /5 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bts_rm16_imm8 = 2106,
	/// `BTS r/m32, imm8`
	///
	/// `o32 0F BA /5 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bts_rm32_imm8 = 2107,
	/// `BTS r/m64, imm8`
	///
	/// `o64 0F BA /5 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Bts_rm64_imm8 = 2108,
	/// `BTR r/m16, imm8`
	///
	/// `o16 0F BA /6 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btr_rm16_imm8 = 2109,
	/// `BTR r/m32, imm8`
	///
	/// `o32 0F BA /6 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btr_rm32_imm8 = 2110,
	/// `BTR r/m64, imm8`
	///
	/// `o64 0F BA /6 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Btr_rm64_imm8 = 2111,
	/// `BTC r/m16, imm8`
	///
	/// `o16 0F BA /7 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btc_rm16_imm8 = 2112,
	/// `BTC r/m32, imm8`
	///
	/// `o32 0F BA /7 ib`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btc_rm32_imm8 = 2113,
	/// `BTC r/m64, imm8`
	///
	/// `o64 0F BA /7 ib`
	///
	/// `X64`
	///
	/// `64-bit`
	Btc_rm64_imm8 = 2114,
	/// `BTC r/m16, r16`
	///
	/// `o16 0F BB /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btc_rm16_r16 = 2115,
	/// `BTC r/m32, r32`
	///
	/// `o32 0F BB /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Btc_rm32_r32 = 2116,
	/// `BTC r/m64, r64`
	///
	/// `o64 0F BB /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Btc_rm64_r64 = 2117,
	/// `BSF r16, r/m16`
	///
	/// `o16 0F BC /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bsf_r16_rm16 = 2118,
	/// `BSF r32, r/m32`
	///
	/// `o32 0F BC /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bsf_r32_rm32 = 2119,
	/// `BSF r64, r/m64`
	///
	/// `o64 0F BC /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Bsf_r64_rm64 = 2120,
	/// `TZCNT r16, r/m16`
	///
	/// `o16 F3 0F BC /r`
	///
	/// `BMI1`
	///
	/// `16/32/64-bit`
	Tzcnt_r16_rm16 = 2121,
	/// `TZCNT r32, r/m32`
	///
	/// `o32 F3 0F BC /r`
	///
	/// `BMI1`
	///
	/// `16/32/64-bit`
	Tzcnt_r32_rm32 = 2122,
	/// `TZCNT r64, r/m64`
	///
	/// `F3 o64 0F BC /r`
	///
	/// `BMI1`
	///
	/// `64-bit`
	Tzcnt_r64_rm64 = 2123,
	/// `BSR r16, r/m16`
	///
	/// `o16 0F BD /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bsr_r16_rm16 = 2124,
	/// `BSR r32, r/m32`
	///
	/// `o32 0F BD /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Bsr_r32_rm32 = 2125,
	/// `BSR r64, r/m64`
	///
	/// `o64 0F BD /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Bsr_r64_rm64 = 2126,
	/// `LZCNT r16, r/m16`
	///
	/// `o16 F3 0F BD /r`
	///
	/// `LZCNT`
	///
	/// `16/32/64-bit`
	Lzcnt_r16_rm16 = 2127,
	/// `LZCNT r32, r/m32`
	///
	/// `o32 F3 0F BD /r`
	///
	/// `LZCNT`
	///
	/// `16/32/64-bit`
	Lzcnt_r32_rm32 = 2128,
	/// `LZCNT r64, r/m64`
	///
	/// `F3 o64 0F BD /r`
	///
	/// `LZCNT`
	///
	/// `64-bit`
	Lzcnt_r64_rm64 = 2129,
	/// `MOVSX r16, r/m8`
	///
	/// `o16 0F BE /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movsx_r16_rm8 = 2130,
	/// `MOVSX r32, r/m8`
	///
	/// `o32 0F BE /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movsx_r32_rm8 = 2131,
	/// `MOVSX r64, r/m8`
	///
	/// `o64 0F BE /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Movsx_r64_rm8 = 2132,
	/// `MOVSX r16, r/m16`
	///
	/// `o16 0F BF /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movsx_r16_rm16 = 2133,
	/// `MOVSX r32, r/m16`
	///
	/// `o32 0F BF /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Movsx_r32_rm16 = 2134,
	/// `MOVSX r64, r/m16`
	///
	/// `o64 0F BF /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Movsx_r64_rm16 = 2135,
	/// `XADD r/m8, r8`
	///
	/// `0F C0 /r`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Xadd_rm8_r8 = 2136,
	/// `XADD r/m16, r16`
	///
	/// `o16 0F C1 /r`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Xadd_rm16_r16 = 2137,
	/// `XADD r/m32, r32`
	///
	/// `o32 0F C1 /r`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Xadd_rm32_r32 = 2138,
	/// `XADD r/m64, r64`
	///
	/// `o64 0F C1 /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Xadd_rm64_r64 = 2139,
	/// `CMPPS xmm1, xmm2/m128, imm8`
	///
	/// `NP 0F C2 /r ib`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cmpps_xmm_xmmm128_imm8 = 2140,
	/// `VCMPPS xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.0F.WIG C2 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcmpps_xmm_xmm_xmmm128_imm8 = 2141,
	/// `VCMPPS ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.0F.WIG C2 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcmpps_ymm_ymm_ymmm256_imm8 = 2142,
	/// `VCMPPS k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.0F.W0 C2 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpps_kr_k1_xmm_xmmm128b32_imm8 = 2143,
	/// `VCMPPS k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.0F.W0 C2 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpps_kr_k1_ymm_ymmm256b32_imm8 = 2144,
	/// `VCMPPS k1 {k2}, zmm2, zmm3/m512/m32bcst{sae}, imm8`
	///
	/// `EVEX.512.0F.W0 C2 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpps_kr_k1_zmm_zmmm512b32_imm8_sae = 2145,
	/// `CMPPD xmm1, xmm2/m128, imm8`
	///
	/// `66 0F C2 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cmppd_xmm_xmmm128_imm8 = 2146,
	/// `VCMPPD xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F.WIG C2 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcmppd_xmm_xmm_xmmm128_imm8 = 2147,
	/// `VCMPPD ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F.WIG C2 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcmppd_ymm_ymm_ymmm256_imm8 = 2148,
	/// `VCMPPD k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F.W1 C2 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmppd_kr_k1_xmm_xmmm128b64_imm8 = 2149,
	/// `VCMPPD k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F.W1 C2 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmppd_kr_k1_ymm_ymmm256b64_imm8 = 2150,
	/// `VCMPPD k1 {k2}, zmm2, zmm3/m512/m64bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F.W1 C2 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmppd_kr_k1_zmm_zmmm512b64_imm8_sae = 2151,
	/// `CMPSS xmm1, xmm2/m32, imm8`
	///
	/// `F3 0F C2 /r ib`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Cmpss_xmm_xmmm32_imm8 = 2152,
	/// `VCMPSS xmm1, xmm2, xmm3/m32, imm8`
	///
	/// `VEX.LIG.F3.0F.WIG C2 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcmpss_xmm_xmm_xmmm32_imm8 = 2153,
	/// `VCMPSS k1 {k2}, xmm2, xmm3/m32{sae}, imm8`
	///
	/// `EVEX.LIG.F3.0F.W0 C2 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpss_kr_k1_xmm_xmmm32_imm8_sae = 2154,
	/// `CMPSD xmm1, xmm2/m64, imm8`
	///
	/// `F2 0F C2 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cmpsd_xmm_xmmm64_imm8 = 2155,
	/// `VCMPSD xmm1, xmm2, xmm3/m64, imm8`
	///
	/// `VEX.LIG.F2.0F.WIG C2 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcmpsd_xmm_xmm_xmmm64_imm8 = 2156,
	/// `VCMPSD k1 {k2}, xmm2, xmm3/m64{sae}, imm8`
	///
	/// `EVEX.LIG.F2.0F.W1 C2 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpsd_kr_k1_xmm_xmmm64_imm8_sae = 2157,
	/// `MOVNTI m32, r32`
	///
	/// `NP 0F C3 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movnti_m32_r32 = 2158,
	/// `MOVNTI m64, r64`
	///
	/// `NP o64 0F C3 /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Movnti_m64_r64 = 2159,
	/// `PINSRW mm, r32/m16, imm8`
	///
	/// `NP 0F C4 /r ib`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pinsrw_mm_r32m16_imm8 = 2160,
	/// `PINSRW mm, r64/m16, imm8`
	///
	/// `NP o64 0F C4 /r ib`
	///
	/// `SSE`
	///
	/// `64-bit`
	Pinsrw_mm_r64m16_imm8 = 2161,
	/// `PINSRW xmm, r32/m16, imm8`
	///
	/// `66 0F C4 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pinsrw_xmm_r32m16_imm8 = 2162,
	/// `PINSRW xmm, r64/m16, imm8`
	///
	/// `66 o64 0F C4 /r ib`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Pinsrw_xmm_r64m16_imm8 = 2163,
	/// `VPINSRW xmm1, xmm2, r32/m16, imm8`
	///
	/// `VEX.128.66.0F.W0 C4 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpinsrw_xmm_xmm_r32m16_imm8 = 2164,
	/// `VPINSRW xmm1, xmm2, r64/m16, imm8`
	///
	/// `VEX.128.66.0F.W1 C4 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpinsrw_xmm_xmm_r64m16_imm8 = 2165,
	/// `VPINSRW xmm1, xmm2, r32/m16, imm8`
	///
	/// `EVEX.128.66.0F.W0 C4 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpinsrw_xmm_xmm_r32m16_imm8 = 2166,
	/// `VPINSRW xmm1, xmm2, r64/m16, imm8`
	///
	/// `EVEX.128.66.0F.W1 C4 /r ib`
	///
	/// `AVX512BW`
	///
	/// `64-bit`
	EVEX_Vpinsrw_xmm_xmm_r64m16_imm8 = 2167,
	/// `PEXTRW r32, mm, imm8`
	///
	/// `NP 0F C5 /r ib`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pextrw_r32_mm_imm8 = 2168,
	/// `PEXTRW r64, mm, imm8`
	///
	/// `NP o64 0F C5 /r ib`
	///
	/// `SSE`
	///
	/// `64-bit`
	Pextrw_r64_mm_imm8 = 2169,
	/// `PEXTRW r32, xmm, imm8`
	///
	/// `66 0F C5 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pextrw_r32_xmm_imm8 = 2170,
	/// `PEXTRW r64, xmm, imm8`
	///
	/// `66 o64 0F C5 /r ib`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Pextrw_r64_xmm_imm8 = 2171,
	/// `VPEXTRW r32, xmm1, imm8`
	///
	/// `VEX.128.66.0F.W0 C5 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpextrw_r32_xmm_imm8 = 2172,
	/// `VPEXTRW r64, xmm1, imm8`
	///
	/// `VEX.128.66.0F.W1 C5 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpextrw_r64_xmm_imm8 = 2173,
	/// `VPEXTRW r32, xmm1, imm8`
	///
	/// `EVEX.128.66.0F.W0 C5 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpextrw_r32_xmm_imm8 = 2174,
	/// `VPEXTRW r64, xmm1, imm8`
	///
	/// `EVEX.128.66.0F.W1 C5 /r ib`
	///
	/// `AVX512BW`
	///
	/// `64-bit`
	EVEX_Vpextrw_r64_xmm_imm8 = 2175,
	/// `SHUFPS xmm1, xmm2/m128, imm8`
	///
	/// `NP 0F C6 /r ib`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Shufps_xmm_xmmm128_imm8 = 2176,
	/// `VSHUFPS xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.0F.WIG C6 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vshufps_xmm_xmm_xmmm128_imm8 = 2177,
	/// `VSHUFPS ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.0F.WIG C6 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vshufps_ymm_ymm_ymmm256_imm8 = 2178,
	/// `VSHUFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.0F.W0 C6 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufps_xmm_k1z_xmm_xmmm128b32_imm8 = 2179,
	/// `VSHUFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.0F.W0 C6 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufps_ymm_k1z_ymm_ymmm256b32_imm8 = 2180,
	/// `VSHUFPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.0F.W0 C6 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufps_zmm_k1z_zmm_zmmm512b32_imm8 = 2181,
	/// `SHUFPD xmm1, xmm2/m128, imm8`
	///
	/// `66 0F C6 /r ib`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Shufpd_xmm_xmmm128_imm8 = 2182,
	/// `VSHUFPD xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F.WIG C6 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vshufpd_xmm_xmm_xmmm128_imm8 = 2183,
	/// `VSHUFPD ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F.WIG C6 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vshufpd_ymm_ymm_ymmm256_imm8 = 2184,
	/// `VSHUFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F.W1 C6 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufpd_xmm_k1z_xmm_xmmm128b64_imm8 = 2185,
	/// `VSHUFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F.W1 C6 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufpd_ymm_k1z_ymm_ymmm256b64_imm8 = 2186,
	/// `VSHUFPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F.W1 C6 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufpd_zmm_k1z_zmm_zmmm512b64_imm8 = 2187,
	/// `CMPXCHG8B m64`
	///
	/// `0F C7 /1`
	///
	/// `CX8`
	///
	/// `16/32/64-bit`
	Cmpxchg8b_m64 = 2188,
	/// `CMPXCHG16B m128`
	///
	/// `o64 0F C7 /1`
	///
	/// `CMPXCHG16B`
	///
	/// `64-bit`
	Cmpxchg16b_m128 = 2189,
	/// `XRSTORS mem`
	///
	/// `NP 0F C7 /3`
	///
	/// `XSAVES`
	///
	/// `16/32/64-bit`
	Xrstors_mem = 2190,
	/// `XRSTORS64 mem`
	///
	/// `NP o64 0F C7 /3`
	///
	/// `XSAVES`
	///
	/// `64-bit`
	Xrstors64_mem = 2191,
	/// `XSAVEC mem`
	///
	/// `NP 0F C7 /4`
	///
	/// `XSAVEC`
	///
	/// `16/32/64-bit`
	Xsavec_mem = 2192,
	/// `XSAVEC64 mem`
	///
	/// `NP o64 0F C7 /4`
	///
	/// `XSAVEC`
	///
	/// `64-bit`
	Xsavec64_mem = 2193,
	/// `XSAVES mem`
	///
	/// `NP 0F C7 /5`
	///
	/// `XSAVES`
	///
	/// `16/32/64-bit`
	Xsaves_mem = 2194,
	/// `XSAVES64 mem`
	///
	/// `NP o64 0F C7 /5`
	///
	/// `XSAVES`
	///
	/// `64-bit`
	Xsaves64_mem = 2195,
	/// `VMPTRLD m64`
	///
	/// `NP 0F C7 /6`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmptrld_m64 = 2196,
	/// `VMCLEAR m64`
	///
	/// `66 0F C7 /6`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmclear_m64 = 2197,
	/// `VMXON m64`
	///
	/// `F3 0F C7 /6`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmxon_m64 = 2198,
	/// `RDRAND r16`
	///
	/// `o16 0F C7 /6`
	///
	/// `RDRAND`
	///
	/// `16/32/64-bit`
	Rdrand_r16 = 2199,
	/// `RDRAND r32`
	///
	/// `o32 0F C7 /6`
	///
	/// `RDRAND`
	///
	/// `16/32/64-bit`
	Rdrand_r32 = 2200,
	/// `RDRAND r64`
	///
	/// `o64 0F C7 /6`
	///
	/// `RDRAND`
	///
	/// `64-bit`
	Rdrand_r64 = 2201,
	/// `VMPTRST m64`
	///
	/// `NP 0F C7 /7`
	///
	/// `VMX`
	///
	/// `16/32/64-bit`
	Vmptrst_m64 = 2202,
	/// `RDSEED r16`
	///
	/// `o16 0F C7 /7`
	///
	/// `RDSEED`
	///
	/// `16/32/64-bit`
	Rdseed_r16 = 2203,
	/// `RDSEED r32`
	///
	/// `o32 0F C7 /7`
	///
	/// `RDSEED`
	///
	/// `16/32/64-bit`
	Rdseed_r32 = 2204,
	/// `RDSEED r64`
	///
	/// `o64 0F C7 /7`
	///
	/// `RDSEED`
	///
	/// `64-bit`
	Rdseed_r64 = 2205,
	/// `RDPID r32`
	///
	/// `F3 0F C7 /7`
	///
	/// `RDPID`
	///
	/// `16/32-bit`
	Rdpid_r32 = 2206,
	/// `RDPID r64`
	///
	/// `F3 0F C7 /7`
	///
	/// `RDPID`
	///
	/// `64-bit`
	Rdpid_r64 = 2207,
	/// `BSWAP r16`
	///
	/// `o16 0F C8+rw`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Bswap_r16 = 2208,
	/// `BSWAP r32`
	///
	/// `o32 0F C8+rd`
	///
	/// `486+`
	///
	/// `16/32/64-bit`
	Bswap_r32 = 2209,
	/// `BSWAP r64`
	///
	/// `o64 0F C8+ro`
	///
	/// `X64`
	///
	/// `64-bit`
	Bswap_r64 = 2210,
	/// `ADDSUBPD xmm1, xmm2/m128`
	///
	/// `66 0F D0 /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Addsubpd_xmm_xmmm128 = 2211,
	/// `VADDSUBPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D0 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddsubpd_xmm_xmm_xmmm128 = 2212,
	/// `VADDSUBPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG D0 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddsubpd_ymm_ymm_ymmm256 = 2213,
	/// `ADDSUBPS xmm1, xmm2/m128`
	///
	/// `F2 0F D0 /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Addsubps_xmm_xmmm128 = 2214,
	/// `VADDSUBPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.F2.0F.WIG D0 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddsubps_xmm_xmm_xmmm128 = 2215,
	/// `VADDSUBPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.F2.0F.WIG D0 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaddsubps_ymm_ymm_ymmm256 = 2216,
	/// `PSRLW mm, mm/m64`
	///
	/// `NP 0F D1 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrlw_mm_mmm64 = 2217,
	/// `PSRLW xmm1, xmm2/m128`
	///
	/// `66 0F D1 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrlw_xmm_xmmm128 = 2218,
	/// `VPSRLW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D1 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlw_xmm_xmm_xmmm128 = 2219,
	/// `VPSRLW ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG D1 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlw_ymm_ymm_xmmm128 = 2220,
	/// `VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG D1 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlw_xmm_k1z_xmm_xmmm128 = 2221,
	/// `VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.WIG D1 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlw_ymm_k1z_ymm_xmmm128 = 2222,
	/// `VPSRLW zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.WIG D1 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlw_zmm_k1z_zmm_xmmm128 = 2223,
	/// `PSRLD mm, mm/m64`
	///
	/// `NP 0F D2 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrld_mm_mmm64 = 2224,
	/// `PSRLD xmm1, xmm2/m128`
	///
	/// `66 0F D2 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrld_xmm_xmmm128 = 2225,
	/// `VPSRLD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D2 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrld_xmm_xmm_xmmm128 = 2226,
	/// `VPSRLD ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG D2 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrld_ymm_ymm_xmmm128 = 2227,
	/// `VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.W0 D2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrld_xmm_k1z_xmm_xmmm128 = 2228,
	/// `VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.W0 D2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrld_ymm_k1z_ymm_xmmm128 = 2229,
	/// `VPSRLD zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.W0 D2 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrld_zmm_k1z_zmm_xmmm128 = 2230,
	/// `PSRLQ mm, mm/m64`
	///
	/// `NP 0F D3 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrlq_mm_mmm64 = 2231,
	/// `PSRLQ xmm1, xmm2/m128`
	///
	/// `66 0F D3 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrlq_xmm_xmmm128 = 2232,
	/// `VPSRLQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D3 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlq_xmm_xmm_xmmm128 = 2233,
	/// `VPSRLQ ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG D3 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlq_ymm_ymm_xmmm128 = 2234,
	/// `VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.W1 D3 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlq_xmm_k1z_xmm_xmmm128 = 2235,
	/// `VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.W1 D3 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlq_ymm_k1z_ymm_xmmm128 = 2236,
	/// `VPSRLQ zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.W1 D3 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlq_zmm_k1z_zmm_xmmm128 = 2237,
	/// `PADDQ mm, mm/m64`
	///
	/// `NP 0F D4 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddq_mm_mmm64 = 2238,
	/// `PADDQ xmm1, xmm2/m128`
	///
	/// `66 0F D4 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddq_xmm_xmmm128 = 2239,
	/// `VPADDQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D4 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddq_xmm_xmm_xmmm128 = 2240,
	/// `VPADDQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG D4 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddq_ymm_ymm_ymmm256 = 2241,
	/// `VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 D4 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddq_xmm_k1z_xmm_xmmm128b64 = 2242,
	/// `VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 D4 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddq_ymm_k1z_ymm_ymmm256b64 = 2243,
	/// `VPADDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 D4 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddq_zmm_k1z_zmm_zmmm512b64 = 2244,
	/// `PMULLW mm, mm/m64`
	///
	/// `NP 0F D5 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pmullw_mm_mmm64 = 2245,
	/// `PMULLW xmm1, xmm2/m128`
	///
	/// `66 0F D5 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmullw_xmm_xmmm128 = 2246,
	/// `VPMULLW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D5 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmullw_xmm_xmm_xmmm128 = 2247,
	/// `VPMULLW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG D5 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmullw_ymm_ymm_ymmm256 = 2248,
	/// `VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG D5 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmullw_xmm_k1z_xmm_xmmm128 = 2249,
	/// `VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG D5 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmullw_ymm_k1z_ymm_ymmm256 = 2250,
	/// `VPMULLW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG D5 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmullw_zmm_k1z_zmm_zmmm512 = 2251,
	/// `MOVQ xmm2/m64, xmm1`
	///
	/// `66 0F D6 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movq_xmmm64_xmm = 2252,
	/// `VMOVQ xmm1/m64, xmm2`
	///
	/// `VEX.128.66.0F.WIG D6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovq_xmmm64_xmm = 2253,
	/// `VMOVQ xmm1/m64, xmm2`
	///
	/// `EVEX.128.66.0F.W1 D6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovq_xmmm64_xmm = 2254,
	/// `MOVQ2DQ xmm, mm`
	///
	/// `F3 0F D6 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movq2dq_xmm_mm = 2255,
	/// `MOVDQ2Q mm, xmm`
	///
	/// `F2 0F D6 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movdq2q_mm_xmm = 2256,
	/// `PMOVMSKB r32, mm`
	///
	/// `NP 0F D7 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pmovmskb_r32_mm = 2257,
	/// `PMOVMSKB r64, mm`
	///
	/// `NP o64 0F D7 /r`
	///
	/// `SSE`
	///
	/// `64-bit`
	Pmovmskb_r64_mm = 2258,
	/// `PMOVMSKB r32, xmm`
	///
	/// `66 0F D7 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmovmskb_r32_xmm = 2259,
	/// `PMOVMSKB r64, xmm`
	///
	/// `66 o64 0F D7 /r`
	///
	/// `SSE2`
	///
	/// `64-bit`
	Pmovmskb_r64_xmm = 2260,
	/// `VPMOVMSKB r32, xmm1`
	///
	/// `VEX.128.66.0F.W0 D7 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovmskb_r32_xmm = 2261,
	/// `VPMOVMSKB r64, xmm1`
	///
	/// `VEX.128.66.0F.W1 D7 /r`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpmovmskb_r64_xmm = 2262,
	/// `VPMOVMSKB r32, ymm1`
	///
	/// `VEX.256.66.0F.W0 D7 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovmskb_r32_ymm = 2263,
	/// `VPMOVMSKB r64, ymm1`
	///
	/// `VEX.256.66.0F.W1 D7 /r`
	///
	/// `AVX2`
	///
	/// `64-bit`
	VEX_Vpmovmskb_r64_ymm = 2264,
	/// `PSUBUSB mm, mm/m64`
	///
	/// `NP 0F D8 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psubusb_mm_mmm64 = 2265,
	/// `PSUBUSB xmm1, xmm2/m128`
	///
	/// `66 0F D8 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubusb_xmm_xmmm128 = 2266,
	/// `VPSUBUSB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D8 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubusb_xmm_xmm_xmmm128 = 2267,
	/// `VPSUBUSB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG D8 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubusb_ymm_ymm_ymmm256 = 2268,
	/// `VPSUBUSB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG D8 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubusb_xmm_k1z_xmm_xmmm128 = 2269,
	/// `VPSUBUSB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG D8 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubusb_ymm_k1z_ymm_ymmm256 = 2270,
	/// `VPSUBUSB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG D8 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubusb_zmm_k1z_zmm_zmmm512 = 2271,
	/// `PSUBUSW mm, mm/m64`
	///
	/// `NP 0F D9 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psubusw_mm_mmm64 = 2272,
	/// `PSUBUSW xmm1, xmm2/m128`
	///
	/// `66 0F D9 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubusw_xmm_xmmm128 = 2273,
	/// `VPSUBUSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG D9 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubusw_xmm_xmm_xmmm128 = 2274,
	/// `VPSUBUSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG D9 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubusw_ymm_ymm_ymmm256 = 2275,
	/// `VPSUBUSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG D9 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubusw_xmm_k1z_xmm_xmmm128 = 2276,
	/// `VPSUBUSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG D9 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubusw_ymm_k1z_ymm_ymmm256 = 2277,
	/// `VPSUBUSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG D9 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubusw_zmm_k1z_zmm_zmmm512 = 2278,
	/// `PMINUB mm1, mm2/m64`
	///
	/// `NP 0F DA /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pminub_mm_mmm64 = 2279,
	/// `PMINUB xmm1, xmm2/m128`
	///
	/// `66 0F DA /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pminub_xmm_xmmm128 = 2280,
	/// `VPMINUB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG DA /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpminub_xmm_xmm_xmmm128 = 2281,
	/// `VPMINUB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG DA /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpminub_ymm_ymm_ymmm256 = 2282,
	/// `VPMINUB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG DA /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminub_xmm_k1z_xmm_xmmm128 = 2283,
	/// `VPMINUB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG DA /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminub_ymm_k1z_ymm_ymmm256 = 2284,
	/// `VPMINUB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG DA /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminub_zmm_k1z_zmm_zmmm512 = 2285,
	/// `PAND mm, mm/m64`
	///
	/// `NP 0F DB /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pand_mm_mmm64 = 2286,
	/// `PAND xmm1, xmm2/m128`
	///
	/// `66 0F DB /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pand_xmm_xmmm128 = 2287,
	/// `VPAND xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG DB /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpand_xmm_xmm_xmmm128 = 2288,
	/// `VPAND ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG DB /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpand_ymm_ymm_ymmm256 = 2289,
	/// `VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 DB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandd_xmm_k1z_xmm_xmmm128b32 = 2290,
	/// `VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 DB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandd_ymm_k1z_ymm_ymmm256b32 = 2291,
	/// `VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 DB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandd_zmm_k1z_zmm_zmmm512b32 = 2292,
	/// `VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 DB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandq_xmm_k1z_xmm_xmmm128b64 = 2293,
	/// `VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 DB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandq_ymm_k1z_ymm_ymmm256b64 = 2294,
	/// `VPANDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 DB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandq_zmm_k1z_zmm_zmmm512b64 = 2295,
	/// `PADDUSB mm, mm/m64`
	///
	/// `NP 0F DC /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddusb_mm_mmm64 = 2296,
	/// `PADDUSB xmm1, xmm2/m128`
	///
	/// `66 0F DC /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddusb_xmm_xmmm128 = 2297,
	/// `VPADDUSB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG DC /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddusb_xmm_xmm_xmmm128 = 2298,
	/// `VPADDUSB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG DC /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddusb_ymm_ymm_ymmm256 = 2299,
	/// `VPADDUSB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG DC /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddusb_xmm_k1z_xmm_xmmm128 = 2300,
	/// `VPADDUSB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG DC /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddusb_ymm_k1z_ymm_ymmm256 = 2301,
	/// `VPADDUSB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG DC /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddusb_zmm_k1z_zmm_zmmm512 = 2302,
	/// `PADDUSW mm, mm/m64`
	///
	/// `NP 0F DD /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddusw_mm_mmm64 = 2303,
	/// `PADDUSW xmm1, xmm2/m128`
	///
	/// `66 0F DD /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddusw_xmm_xmmm128 = 2304,
	/// `VPADDUSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG DD /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddusw_xmm_xmm_xmmm128 = 2305,
	/// `VPADDUSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG DD /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddusw_ymm_ymm_ymmm256 = 2306,
	/// `VPADDUSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG DD /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddusw_xmm_k1z_xmm_xmmm128 = 2307,
	/// `VPADDUSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG DD /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddusw_ymm_k1z_ymm_ymmm256 = 2308,
	/// `VPADDUSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG DD /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddusw_zmm_k1z_zmm_zmmm512 = 2309,
	/// `PMAXUB mm1, mm2/m64`
	///
	/// `NP 0F DE /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pmaxub_mm_mmm64 = 2310,
	/// `PMAXUB xmm1, xmm2/m128`
	///
	/// `66 0F DE /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmaxub_xmm_xmmm128 = 2311,
	/// `VPMAXUB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG DE /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxub_xmm_xmm_xmmm128 = 2312,
	/// `VPMAXUB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG DE /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxub_ymm_ymm_ymmm256 = 2313,
	/// `VPMAXUB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG DE /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxub_xmm_k1z_xmm_xmmm128 = 2314,
	/// `VPMAXUB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG DE /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxub_ymm_k1z_ymm_ymmm256 = 2315,
	/// `VPMAXUB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG DE /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxub_zmm_k1z_zmm_zmmm512 = 2316,
	/// `PANDN mm, mm/m64`
	///
	/// `NP 0F DF /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pandn_mm_mmm64 = 2317,
	/// `PANDN xmm1, xmm2/m128`
	///
	/// `66 0F DF /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pandn_xmm_xmmm128 = 2318,
	/// `VPANDN xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG DF /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpandn_xmm_xmm_xmmm128 = 2319,
	/// `VPANDN ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG DF /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpandn_ymm_ymm_ymmm256 = 2320,
	/// `VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 DF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandnd_xmm_k1z_xmm_xmmm128b32 = 2321,
	/// `VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 DF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandnd_ymm_k1z_ymm_ymmm256b32 = 2322,
	/// `VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 DF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandnd_zmm_k1z_zmm_zmmm512b32 = 2323,
	/// `VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 DF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandnq_xmm_k1z_xmm_xmmm128b64 = 2324,
	/// `VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 DF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandnq_ymm_k1z_ymm_ymmm256b64 = 2325,
	/// `VPANDNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 DF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpandnq_zmm_k1z_zmm_zmmm512b64 = 2326,
	/// `PAVGB mm1, mm2/m64`
	///
	/// `NP 0F E0 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pavgb_mm_mmm64 = 2327,
	/// `PAVGB xmm1, xmm2/m128`
	///
	/// `66 0F E0 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pavgb_xmm_xmmm128 = 2328,
	/// `VPAVGB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E0 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpavgb_xmm_xmm_xmmm128 = 2329,
	/// `VPAVGB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG E0 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpavgb_ymm_ymm_ymmm256 = 2330,
	/// `VPAVGB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG E0 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpavgb_xmm_k1z_xmm_xmmm128 = 2331,
	/// `VPAVGB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG E0 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpavgb_ymm_k1z_ymm_ymmm256 = 2332,
	/// `VPAVGB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG E0 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpavgb_zmm_k1z_zmm_zmmm512 = 2333,
	/// `PSRAW mm, mm/m64`
	///
	/// `NP 0F E1 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psraw_mm_mmm64 = 2334,
	/// `PSRAW xmm1, xmm2/m128`
	///
	/// `66 0F E1 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psraw_xmm_xmmm128 = 2335,
	/// `VPSRAW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E1 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsraw_xmm_xmm_xmmm128 = 2336,
	/// `VPSRAW ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG E1 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsraw_ymm_ymm_xmmm128 = 2337,
	/// `VPSRAW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG E1 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraw_xmm_k1z_xmm_xmmm128 = 2338,
	/// `VPSRAW ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.WIG E1 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraw_ymm_k1z_ymm_xmmm128 = 2339,
	/// `VPSRAW zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.WIG E1 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraw_zmm_k1z_zmm_xmmm128 = 2340,
	/// `PSRAD mm, mm/m64`
	///
	/// `NP 0F E2 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psrad_mm_mmm64 = 2341,
	/// `PSRAD xmm1, xmm2/m128`
	///
	/// `66 0F E2 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psrad_xmm_xmmm128 = 2342,
	/// `VPSRAD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E2 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsrad_xmm_xmm_xmmm128 = 2343,
	/// `VPSRAD ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG E2 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrad_ymm_ymm_xmmm128 = 2344,
	/// `VPSRAD xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.W0 E2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrad_xmm_k1z_xmm_xmmm128 = 2345,
	/// `VPSRAD ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.W0 E2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrad_ymm_k1z_ymm_xmmm128 = 2346,
	/// `VPSRAD zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.W0 E2 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrad_zmm_k1z_zmm_xmmm128 = 2347,
	/// `VPSRAQ xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.W1 E2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraq_xmm_k1z_xmm_xmmm128 = 2348,
	/// `VPSRAQ ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.W1 E2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraq_ymm_k1z_ymm_xmmm128 = 2349,
	/// `VPSRAQ zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.W1 E2 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsraq_zmm_k1z_zmm_xmmm128 = 2350,
	/// `PAVGW mm1, mm2/m64`
	///
	/// `NP 0F E3 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pavgw_mm_mmm64 = 2351,
	/// `PAVGW xmm1, xmm2/m128`
	///
	/// `66 0F E3 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pavgw_xmm_xmmm128 = 2352,
	/// `VPAVGW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E3 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpavgw_xmm_xmm_xmmm128 = 2353,
	/// `VPAVGW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG E3 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpavgw_ymm_ymm_ymmm256 = 2354,
	/// `VPAVGW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG E3 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpavgw_xmm_k1z_xmm_xmmm128 = 2355,
	/// `VPAVGW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG E3 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpavgw_ymm_k1z_ymm_ymmm256 = 2356,
	/// `VPAVGW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG E3 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpavgw_zmm_k1z_zmm_zmmm512 = 2357,
	/// `PMULHUW mm1, mm2/m64`
	///
	/// `NP 0F E4 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pmulhuw_mm_mmm64 = 2358,
	/// `PMULHUW xmm1, xmm2/m128`
	///
	/// `66 0F E4 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmulhuw_xmm_xmmm128 = 2359,
	/// `VPMULHUW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E4 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmulhuw_xmm_xmm_xmmm128 = 2360,
	/// `VPMULHUW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG E4 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmulhuw_ymm_ymm_ymmm256 = 2361,
	/// `VPMULHUW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG E4 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhuw_xmm_k1z_xmm_xmmm128 = 2362,
	/// `VPMULHUW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG E4 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhuw_ymm_k1z_ymm_ymmm256 = 2363,
	/// `VPMULHUW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG E4 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhuw_zmm_k1z_zmm_zmmm512 = 2364,
	/// `PMULHW mm, mm/m64`
	///
	/// `NP 0F E5 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pmulhw_mm_mmm64 = 2365,
	/// `PMULHW xmm1, xmm2/m128`
	///
	/// `66 0F E5 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmulhw_xmm_xmmm128 = 2366,
	/// `VPMULHW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E5 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmulhw_xmm_xmm_xmmm128 = 2367,
	/// `VPMULHW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG E5 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmulhw_ymm_ymm_ymmm256 = 2368,
	/// `VPMULHW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG E5 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhw_xmm_k1z_xmm_xmmm128 = 2369,
	/// `VPMULHW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG E5 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhw_ymm_k1z_ymm_ymmm256 = 2370,
	/// `VPMULHW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG E5 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhw_zmm_k1z_zmm_zmmm512 = 2371,
	/// `CVTTPD2DQ xmm1, xmm2/m128`
	///
	/// `66 0F E6 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvttpd2dq_xmm_xmmm128 = 2372,
	/// `VCVTTPD2DQ xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F.WIG E6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvttpd2dq_xmm_xmmm128 = 2373,
	/// `VCVTTPD2DQ xmm1, ymm2/m256`
	///
	/// `VEX.256.66.0F.WIG E6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvttpd2dq_xmm_ymmm256 = 2374,
	/// `VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 E6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2dq_xmm_k1z_xmmm128b64 = 2375,
	/// `VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 E6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2dq_xmm_k1z_ymmm256b64 = 2376,
	/// `VCVTTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F.W1 E6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttpd2dq_ymm_k1z_zmmm512b64_sae = 2377,
	/// `CVTDQ2PD xmm1, xmm2/m64`
	///
	/// `F3 0F E6 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtdq2pd_xmm_xmmm64 = 2378,
	/// `VCVTDQ2PD xmm1, xmm2/m64`
	///
	/// `VEX.128.F3.0F.WIG E6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtdq2pd_xmm_xmmm64 = 2379,
	/// `VCVTDQ2PD ymm1, xmm2/m128`
	///
	/// `VEX.256.F3.0F.WIG E6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtdq2pd_ymm_xmmm128 = 2380,
	/// `VCVTDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst`
	///
	/// `EVEX.128.F3.0F.W0 E6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2pd_xmm_k1z_xmmm64b32 = 2381,
	/// `VCVTDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.256.F3.0F.W0 E6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2pd_ymm_k1z_xmmm128b32 = 2382,
	/// `VCVTDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{er}`
	///
	/// `EVEX.512.F3.0F.W0 E6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2pd_zmm_k1z_ymmm256b32_er = 2383,
	/// `VCVTQQ2PD xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.F3.0F.W1 E6 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2pd_xmm_k1z_xmmm128b64 = 2384,
	/// `VCVTQQ2PD ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.F3.0F.W1 E6 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2pd_ymm_k1z_ymmm256b64 = 2385,
	/// `VCVTQQ2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.F3.0F.W1 E6 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2pd_zmm_k1z_zmmm512b64_er = 2386,
	/// `CVTPD2DQ xmm1, xmm2/m128`
	///
	/// `F2 0F E6 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Cvtpd2dq_xmm_xmmm128 = 2387,
	/// `VCVTPD2DQ xmm1, xmm2/m128`
	///
	/// `VEX.128.F2.0F.WIG E6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtpd2dq_xmm_xmmm128 = 2388,
	/// `VCVTPD2DQ xmm1, ymm2/m256`
	///
	/// `VEX.256.F2.0F.WIG E6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vcvtpd2dq_xmm_ymmm256 = 2389,
	/// `VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.F2.0F.W1 E6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2dq_xmm_k1z_xmmm128b64 = 2390,
	/// `VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.F2.0F.W1 E6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2dq_xmm_k1z_ymmm256b64 = 2391,
	/// `VCVTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.F2.0F.W1 E6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2dq_ymm_k1z_zmmm512b64_er = 2392,
	/// `MOVNTQ m64, mm`
	///
	/// `NP 0F E7 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Movntq_m64_mm = 2393,
	/// `MOVNTDQ m128, xmm1`
	///
	/// `66 0F E7 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Movntdq_m128_xmm = 2394,
	/// `VMOVNTDQ m128, xmm1`
	///
	/// `VEX.128.66.0F.WIG E7 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovntdq_m128_xmm = 2395,
	/// `VMOVNTDQ m256, ymm1`
	///
	/// `VEX.256.66.0F.WIG E7 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovntdq_m256_ymm = 2396,
	/// `VMOVNTDQ m128, xmm1`
	///
	/// `EVEX.128.66.0F.W0 E7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntdq_m128_xmm = 2397,
	/// `VMOVNTDQ m256, ymm1`
	///
	/// `EVEX.256.66.0F.W0 E7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntdq_m256_ymm = 2398,
	/// `VMOVNTDQ m512, zmm1`
	///
	/// `EVEX.512.66.0F.W0 E7 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntdq_m512_zmm = 2399,
	/// `PSUBSB mm, mm/m64`
	///
	/// `NP 0F E8 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psubsb_mm_mmm64 = 2400,
	/// `PSUBSB xmm1, xmm2/m128`
	///
	/// `66 0F E8 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubsb_xmm_xmmm128 = 2401,
	/// `VPSUBSB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E8 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubsb_xmm_xmm_xmmm128 = 2402,
	/// `VPSUBSB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG E8 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubsb_ymm_ymm_ymmm256 = 2403,
	/// `VPSUBSB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG E8 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubsb_xmm_k1z_xmm_xmmm128 = 2404,
	/// `VPSUBSB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG E8 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubsb_ymm_k1z_ymm_ymmm256 = 2405,
	/// `VPSUBSB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG E8 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubsb_zmm_k1z_zmm_zmmm512 = 2406,
	/// `PSUBSW mm, mm/m64`
	///
	/// `NP 0F E9 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psubsw_mm_mmm64 = 2407,
	/// `PSUBSW xmm1, xmm2/m128`
	///
	/// `66 0F E9 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubsw_xmm_xmmm128 = 2408,
	/// `VPSUBSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG E9 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubsw_xmm_xmm_xmmm128 = 2409,
	/// `VPSUBSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG E9 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubsw_ymm_ymm_ymmm256 = 2410,
	/// `VPSUBSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG E9 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubsw_xmm_k1z_xmm_xmmm128 = 2411,
	/// `VPSUBSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG E9 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubsw_ymm_k1z_ymm_ymmm256 = 2412,
	/// `VPSUBSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG E9 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubsw_zmm_k1z_zmm_zmmm512 = 2413,
	/// `PMINSW mm1, mm2/m64`
	///
	/// `NP 0F EA /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pminsw_mm_mmm64 = 2414,
	/// `PMINSW xmm1, xmm2/m128`
	///
	/// `66 0F EA /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pminsw_xmm_xmmm128 = 2415,
	/// `VPMINSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG EA /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpminsw_xmm_xmm_xmmm128 = 2416,
	/// `VPMINSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG EA /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpminsw_ymm_ymm_ymmm256 = 2417,
	/// `VPMINSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG EA /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsw_xmm_k1z_xmm_xmmm128 = 2418,
	/// `VPMINSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG EA /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsw_ymm_k1z_ymm_ymmm256 = 2419,
	/// `VPMINSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG EA /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsw_zmm_k1z_zmm_zmmm512 = 2420,
	/// `POR mm, mm/m64`
	///
	/// `NP 0F EB /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Por_mm_mmm64 = 2421,
	/// `POR xmm1, xmm2/m128`
	///
	/// `66 0F EB /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Por_xmm_xmmm128 = 2422,
	/// `VPOR xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG EB /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpor_xmm_xmm_xmmm128 = 2423,
	/// `VPOR ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG EB /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpor_ymm_ymm_ymmm256 = 2424,
	/// `VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 EB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpord_xmm_k1z_xmm_xmmm128b32 = 2425,
	/// `VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 EB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpord_ymm_k1z_ymm_ymmm256b32 = 2426,
	/// `VPORD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 EB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpord_zmm_k1z_zmm_zmmm512b32 = 2427,
	/// `VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 EB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vporq_xmm_k1z_xmm_xmmm128b64 = 2428,
	/// `VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 EB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vporq_ymm_k1z_ymm_ymmm256b64 = 2429,
	/// `VPORQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 EB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vporq_zmm_k1z_zmm_zmmm512b64 = 2430,
	/// `PADDSB mm, mm/m64`
	///
	/// `NP 0F EC /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddsb_mm_mmm64 = 2431,
	/// `PADDSB xmm1, xmm2/m128`
	///
	/// `66 0F EC /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddsb_xmm_xmmm128 = 2432,
	/// `VPADDSB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG EC /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddsb_xmm_xmm_xmmm128 = 2433,
	/// `VPADDSB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG EC /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddsb_ymm_ymm_ymmm256 = 2434,
	/// `VPADDSB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG EC /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddsb_xmm_k1z_xmm_xmmm128 = 2435,
	/// `VPADDSB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG EC /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddsb_ymm_k1z_ymm_ymmm256 = 2436,
	/// `VPADDSB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG EC /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddsb_zmm_k1z_zmm_zmmm512 = 2437,
	/// `PADDSW mm, mm/m64`
	///
	/// `NP 0F ED /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddsw_mm_mmm64 = 2438,
	/// `PADDSW xmm1, xmm2/m128`
	///
	/// `66 0F ED /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddsw_xmm_xmmm128 = 2439,
	/// `VPADDSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG ED /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddsw_xmm_xmm_xmmm128 = 2440,
	/// `VPADDSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG ED /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddsw_ymm_ymm_ymmm256 = 2441,
	/// `VPADDSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG ED /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddsw_xmm_k1z_xmm_xmmm128 = 2442,
	/// `VPADDSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG ED /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddsw_ymm_k1z_ymm_ymmm256 = 2443,
	/// `VPADDSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG ED /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddsw_zmm_k1z_zmm_zmmm512 = 2444,
	/// `PMAXSW mm1, mm2/m64`
	///
	/// `NP 0F EE /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Pmaxsw_mm_mmm64 = 2445,
	/// `PMAXSW xmm1, xmm2/m128`
	///
	/// `66 0F EE /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmaxsw_xmm_xmmm128 = 2446,
	/// `VPMAXSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG EE /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxsw_xmm_xmm_xmmm128 = 2447,
	/// `VPMAXSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG EE /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxsw_ymm_ymm_ymmm256 = 2448,
	/// `VPMAXSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG EE /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsw_xmm_k1z_xmm_xmmm128 = 2449,
	/// `VPMAXSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG EE /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsw_ymm_k1z_ymm_ymmm256 = 2450,
	/// `VPMAXSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG EE /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsw_zmm_k1z_zmm_zmmm512 = 2451,
	/// `PXOR mm, mm/m64`
	///
	/// `NP 0F EF /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pxor_mm_mmm64 = 2452,
	/// `PXOR xmm1, xmm2/m128`
	///
	/// `66 0F EF /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pxor_xmm_xmmm128 = 2453,
	/// `VPXOR xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG EF /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpxor_xmm_xmm_xmmm128 = 2454,
	/// `VPXOR ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG EF /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpxor_ymm_ymm_ymmm256 = 2455,
	/// `VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 EF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpxord_xmm_k1z_xmm_xmmm128b32 = 2456,
	/// `VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 EF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpxord_ymm_k1z_ymm_ymmm256b32 = 2457,
	/// `VPXORD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 EF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpxord_zmm_k1z_zmm_zmmm512b32 = 2458,
	/// `VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 EF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpxorq_xmm_k1z_xmm_xmmm128b64 = 2459,
	/// `VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 EF /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpxorq_ymm_k1z_ymm_ymmm256b64 = 2460,
	/// `VPXORQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 EF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpxorq_zmm_k1z_zmm_zmmm512b64 = 2461,
	/// `LDDQU xmm1, m128`
	///
	/// `F2 0F F0 /r`
	///
	/// `SSE3`
	///
	/// `16/32/64-bit`
	Lddqu_xmm_m128 = 2462,
	/// `VLDDQU xmm1, m128`
	///
	/// `VEX.128.F2.0F.WIG F0 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vlddqu_xmm_m128 = 2463,
	/// `VLDDQU ymm1, m256`
	///
	/// `VEX.256.F2.0F.WIG F0 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vlddqu_ymm_m256 = 2464,
	/// `PSLLW mm, mm/m64`
	///
	/// `NP 0F F1 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psllw_mm_mmm64 = 2465,
	/// `PSLLW xmm1, xmm2/m128`
	///
	/// `66 0F F1 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psllw_xmm_xmmm128 = 2466,
	/// `VPSLLW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F1 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsllw_xmm_xmm_xmmm128 = 2467,
	/// `VPSLLW ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG F1 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllw_ymm_ymm_xmmm128 = 2468,
	/// `VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG F1 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllw_xmm_k1z_xmm_xmmm128 = 2469,
	/// `VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.WIG F1 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllw_ymm_k1z_ymm_xmmm128 = 2470,
	/// `VPSLLW zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.WIG F1 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllw_zmm_k1z_zmm_xmmm128 = 2471,
	/// `PSLLD mm, mm/m64`
	///
	/// `NP 0F F2 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pslld_mm_mmm64 = 2472,
	/// `PSLLD xmm1, xmm2/m128`
	///
	/// `66 0F F2 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pslld_xmm_xmmm128 = 2473,
	/// `VPSLLD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F2 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpslld_xmm_xmm_xmmm128 = 2474,
	/// `VPSLLD ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG F2 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpslld_ymm_ymm_xmmm128 = 2475,
	/// `VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.W0 F2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpslld_xmm_k1z_xmm_xmmm128 = 2476,
	/// `VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.W0 F2 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpslld_ymm_k1z_ymm_xmmm128 = 2477,
	/// `VPSLLD zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.W0 F2 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpslld_zmm_k1z_zmm_xmmm128 = 2478,
	/// `PSLLQ mm, mm/m64`
	///
	/// `NP 0F F3 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psllq_mm_mmm64 = 2479,
	/// `PSLLQ xmm1, xmm2/m128`
	///
	/// `66 0F F3 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psllq_xmm_xmmm128 = 2480,
	/// `VPSLLQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F3 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsllq_xmm_xmm_xmmm128 = 2481,
	/// `VPSLLQ ymm1, ymm2, xmm3/m128`
	///
	/// `VEX.256.66.0F.WIG F3 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllq_ymm_ymm_xmmm128 = 2482,
	/// `VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.W1 F3 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllq_xmm_k1z_xmm_xmmm128 = 2483,
	/// `VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128`
	///
	/// `EVEX.256.66.0F.W1 F3 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllq_ymm_k1z_ymm_xmmm128 = 2484,
	/// `VPSLLQ zmm1 {k1}{z}, zmm2, xmm3/m128`
	///
	/// `EVEX.512.66.0F.W1 F3 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllq_zmm_k1z_zmm_xmmm128 = 2485,
	/// `PMULUDQ mm1, mm2/m64`
	///
	/// `NP 0F F4 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmuludq_mm_mmm64 = 2486,
	/// `PMULUDQ xmm1, xmm2/m128`
	///
	/// `66 0F F4 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmuludq_xmm_xmmm128 = 2487,
	/// `VPMULUDQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F4 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmuludq_xmm_xmm_xmmm128 = 2488,
	/// `VPMULUDQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG F4 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmuludq_ymm_ymm_ymmm256 = 2489,
	/// `VPMULUDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 F4 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmuludq_xmm_k1z_xmm_xmmm128b64 = 2490,
	/// `VPMULUDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 F4 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmuludq_ymm_k1z_ymm_ymmm256b64 = 2491,
	/// `VPMULUDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 F4 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmuludq_zmm_k1z_zmm_zmmm512b64 = 2492,
	/// `PMADDWD mm, mm/m64`
	///
	/// `NP 0F F5 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Pmaddwd_mm_mmm64 = 2493,
	/// `PMADDWD xmm1, xmm2/m128`
	///
	/// `66 0F F5 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Pmaddwd_xmm_xmmm128 = 2494,
	/// `VPMADDWD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F5 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaddwd_xmm_xmm_xmmm128 = 2495,
	/// `VPMADDWD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG F5 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaddwd_ymm_ymm_ymmm256 = 2496,
	/// `VPMADDWD xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG F5 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaddwd_xmm_k1z_xmm_xmmm128 = 2497,
	/// `VPMADDWD ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG F5 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaddwd_ymm_k1z_ymm_ymmm256 = 2498,
	/// `VPMADDWD zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG F5 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaddwd_zmm_k1z_zmm_zmmm512 = 2499,
	/// `PSADBW mm1, mm2/m64`
	///
	/// `NP 0F F6 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Psadbw_mm_mmm64 = 2500,
	/// `PSADBW xmm1, xmm2/m128`
	///
	/// `66 0F F6 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psadbw_xmm_xmmm128 = 2501,
	/// `VPSADBW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F6 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsadbw_xmm_xmm_xmmm128 = 2502,
	/// `VPSADBW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG F6 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsadbw_ymm_ymm_ymmm256 = 2503,
	/// `VPSADBW xmm1, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG F6 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsadbw_xmm_xmm_xmmm128 = 2504,
	/// `VPSADBW ymm1, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG F6 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsadbw_ymm_ymm_ymmm256 = 2505,
	/// `VPSADBW zmm1, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG F6 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsadbw_zmm_zmm_zmmm512 = 2506,
	/// `MASKMOVQ mm1, mm2`
	///
	/// `NP 0F F7 /r`
	///
	/// `SSE`
	///
	/// `16/32/64-bit`
	Maskmovq_rDI_mm_mm = 2507,
	/// `MASKMOVDQU xmm1, xmm2`
	///
	/// `66 0F F7 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Maskmovdqu_rDI_xmm_xmm = 2508,
	/// `VMASKMOVDQU xmm1, xmm2`
	///
	/// `VEX.128.66.0F.WIG F7 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovdqu_rDI_xmm_xmm = 2509,
	/// `PSUBB mm, mm/m64`
	///
	/// `NP 0F F8 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psubb_mm_mmm64 = 2510,
	/// `PSUBB xmm1, xmm2/m128`
	///
	/// `66 0F F8 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubb_xmm_xmmm128 = 2511,
	/// `VPSUBB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F8 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubb_xmm_xmm_xmmm128 = 2512,
	/// `VPSUBB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG F8 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubb_ymm_ymm_ymmm256 = 2513,
	/// `VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG F8 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubb_xmm_k1z_xmm_xmmm128 = 2514,
	/// `VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG F8 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubb_ymm_k1z_ymm_ymmm256 = 2515,
	/// `VPSUBB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG F8 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubb_zmm_k1z_zmm_zmmm512 = 2516,
	/// `PSUBW mm, mm/m64`
	///
	/// `NP 0F F9 /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psubw_mm_mmm64 = 2517,
	/// `PSUBW xmm1, xmm2/m128`
	///
	/// `66 0F F9 /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubw_xmm_xmmm128 = 2518,
	/// `VPSUBW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG F9 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubw_xmm_xmm_xmmm128 = 2519,
	/// `VPSUBW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG F9 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubw_ymm_ymm_ymmm256 = 2520,
	/// `VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG F9 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubw_xmm_k1z_xmm_xmmm128 = 2521,
	/// `VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG F9 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubw_ymm_k1z_ymm_ymmm256 = 2522,
	/// `VPSUBW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG F9 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubw_zmm_k1z_zmm_zmmm512 = 2523,
	/// `PSUBD mm, mm/m64`
	///
	/// `NP 0F FA /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Psubd_mm_mmm64 = 2524,
	/// `PSUBD xmm1, xmm2/m128`
	///
	/// `66 0F FA /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubd_xmm_xmmm128 = 2525,
	/// `VPSUBD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG FA /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubd_xmm_xmm_xmmm128 = 2526,
	/// `VPSUBD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG FA /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubd_ymm_ymm_ymmm256 = 2527,
	/// `VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 FA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubd_xmm_k1z_xmm_xmmm128b32 = 2528,
	/// `VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 FA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubd_ymm_k1z_ymm_ymmm256b32 = 2529,
	/// `VPSUBD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 FA /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubd_zmm_k1z_zmm_zmmm512b32 = 2530,
	/// `PSUBQ mm1, mm2/m64`
	///
	/// `NP 0F FB /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubq_mm_mmm64 = 2531,
	/// `PSUBQ xmm1, xmm2/m128`
	///
	/// `66 0F FB /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Psubq_xmm_xmmm128 = 2532,
	/// `VPSUBQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG FB /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsubq_xmm_xmm_xmmm128 = 2533,
	/// `VPSUBQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG FB /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsubq_ymm_ymm_ymmm256 = 2534,
	/// `VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F.W1 FB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubq_xmm_k1z_xmm_xmmm128b64 = 2535,
	/// `VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F.W1 FB /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubq_ymm_k1z_ymm_ymmm256b64 = 2536,
	/// `VPSUBQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F.W1 FB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsubq_zmm_k1z_zmm_zmmm512b64 = 2537,
	/// `PADDB mm, mm/m64`
	///
	/// `NP 0F FC /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddb_mm_mmm64 = 2538,
	/// `PADDB xmm1, xmm2/m128`
	///
	/// `66 0F FC /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddb_xmm_xmmm128 = 2539,
	/// `VPADDB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG FC /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddb_xmm_xmm_xmmm128 = 2540,
	/// `VPADDB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG FC /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddb_ymm_ymm_ymmm256 = 2541,
	/// `VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG FC /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddb_xmm_k1z_xmm_xmmm128 = 2542,
	/// `VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG FC /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddb_ymm_k1z_ymm_ymmm256 = 2543,
	/// `VPADDB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG FC /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddb_zmm_k1z_zmm_zmmm512 = 2544,
	/// `PADDW mm, mm/m64`
	///
	/// `NP 0F FD /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddw_mm_mmm64 = 2545,
	/// `PADDW xmm1, xmm2/m128`
	///
	/// `66 0F FD /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddw_xmm_xmmm128 = 2546,
	/// `VPADDW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG FD /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddw_xmm_xmm_xmmm128 = 2547,
	/// `VPADDW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG FD /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddw_ymm_ymm_ymmm256 = 2548,
	/// `VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F.WIG FD /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddw_xmm_k1z_xmm_xmmm128 = 2549,
	/// `VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F.WIG FD /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddw_ymm_k1z_ymm_ymmm256 = 2550,
	/// `VPADDW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F.WIG FD /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddw_zmm_k1z_zmm_zmmm512 = 2551,
	/// `PADDD mm, mm/m64`
	///
	/// `NP 0F FE /r`
	///
	/// `MMX`
	///
	/// `16/32/64-bit`
	Paddd_mm_mmm64 = 2552,
	/// `PADDD xmm1, xmm2/m128`
	///
	/// `66 0F FE /r`
	///
	/// `SSE2`
	///
	/// `16/32/64-bit`
	Paddd_xmm_xmmm128 = 2553,
	/// `VPADDD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F.WIG FE /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpaddd_xmm_xmm_xmmm128 = 2554,
	/// `VPADDD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F.WIG FE /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpaddd_ymm_ymm_ymmm256 = 2555,
	/// `VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F.W0 FE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddd_xmm_k1z_xmm_xmmm128b32 = 2556,
	/// `VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F.W0 FE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddd_ymm_k1z_ymm_ymmm256b32 = 2557,
	/// `VPADDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F.W0 FE /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpaddd_zmm_k1z_zmm_zmmm512b32 = 2558,
	/// `UD0 r16, r/m16`
	///
	/// `o16 0F FF /r`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Ud0_r16_rm16 = 2559,
	/// `UD0 r32, r/m32`
	///
	/// `o32 0F FF /r`
	///
	/// `386+`
	///
	/// `16/32/64-bit`
	Ud0_r32_rm32 = 2560,
	/// `UD0 r64, r/m64`
	///
	/// `o64 0F FF /r`
	///
	/// `X64`
	///
	/// `64-bit`
	Ud0_r64_rm64 = 2561,
	/// `PSHUFB mm1, mm2/m64`
	///
	/// `NP 0F 38 00 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pshufb_mm_mmm64 = 2562,
	/// `PSHUFB xmm1, xmm2/m128`
	///
	/// `66 0F 38 00 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pshufb_xmm_xmmm128 = 2563,
	/// `VPSHUFB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 00 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpshufb_xmm_xmm_xmmm128 = 2564,
	/// `VPSHUFB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 00 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpshufb_ymm_ymm_ymmm256 = 2565,
	/// `VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG 00 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufb_xmm_k1z_xmm_xmmm128 = 2566,
	/// `VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG 00 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufb_ymm_k1z_ymm_ymmm256 = 2567,
	/// `VPSHUFB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG 00 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufb_zmm_k1z_zmm_zmmm512 = 2568,
	/// `PHADDW mm1, mm2/m64`
	///
	/// `NP 0F 38 01 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phaddw_mm_mmm64 = 2569,
	/// `PHADDW xmm1, xmm2/m128`
	///
	/// `66 0F 38 01 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phaddw_xmm_xmmm128 = 2570,
	/// `VPHADDW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 01 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vphaddw_xmm_xmm_xmmm128 = 2571,
	/// `VPHADDW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 01 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vphaddw_ymm_ymm_ymmm256 = 2572,
	/// `PHADDD mm1, mm2/m64`
	///
	/// `NP 0F 38 02 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phaddd_mm_mmm64 = 2573,
	/// `PHADDD xmm1, xmm2/m128`
	///
	/// `66 0F 38 02 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phaddd_xmm_xmmm128 = 2574,
	/// `VPHADDD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 02 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vphaddd_xmm_xmm_xmmm128 = 2575,
	/// `VPHADDD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 02 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vphaddd_ymm_ymm_ymmm256 = 2576,
	/// `PHADDSW mm1, mm2/m64`
	///
	/// `NP 0F 38 03 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phaddsw_mm_mmm64 = 2577,
	/// `PHADDSW xmm1, xmm2/m128`
	///
	/// `66 0F 38 03 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phaddsw_xmm_xmmm128 = 2578,
	/// `VPHADDSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 03 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vphaddsw_xmm_xmm_xmmm128 = 2579,
	/// `VPHADDSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 03 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vphaddsw_ymm_ymm_ymmm256 = 2580,
	/// `PMADDUBSW mm1, mm2/m64`
	///
	/// `NP 0F 38 04 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pmaddubsw_mm_mmm64 = 2581,
	/// `PMADDUBSW xmm1, xmm2/m128`
	///
	/// `66 0F 38 04 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pmaddubsw_xmm_xmmm128 = 2582,
	/// `VPMADDUBSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 04 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaddubsw_xmm_xmm_xmmm128 = 2583,
	/// `VPMADDUBSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 04 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaddubsw_ymm_ymm_ymmm256 = 2584,
	/// `VPMADDUBSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG 04 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaddubsw_xmm_k1z_xmm_xmmm128 = 2585,
	/// `VPMADDUBSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG 04 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaddubsw_ymm_k1z_ymm_ymmm256 = 2586,
	/// `VPMADDUBSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG 04 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaddubsw_zmm_k1z_zmm_zmmm512 = 2587,
	/// `PHSUBW mm1, mm2/m64`
	///
	/// `NP 0F 38 05 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phsubw_mm_mmm64 = 2588,
	/// `PHSUBW xmm1, xmm2/m128`
	///
	/// `66 0F 38 05 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phsubw_xmm_xmmm128 = 2589,
	/// `VPHSUBW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 05 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vphsubw_xmm_xmm_xmmm128 = 2590,
	/// `VPHSUBW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 05 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vphsubw_ymm_ymm_ymmm256 = 2591,
	/// `PHSUBD mm1, mm2/m64`
	///
	/// `NP 0F 38 06 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phsubd_mm_mmm64 = 2592,
	/// `PHSUBD xmm1, xmm2/m128`
	///
	/// `66 0F 38 06 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phsubd_xmm_xmmm128 = 2593,
	/// `VPHSUBD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 06 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vphsubd_xmm_xmm_xmmm128 = 2594,
	/// `VPHSUBD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 06 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vphsubd_ymm_ymm_ymmm256 = 2595,
	/// `PHSUBSW mm1, mm2/m64`
	///
	/// `NP 0F 38 07 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phsubsw_mm_mmm64 = 2596,
	/// `PHSUBSW xmm1, xmm2/m128`
	///
	/// `66 0F 38 07 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Phsubsw_xmm_xmmm128 = 2597,
	/// `VPHSUBSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 07 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vphsubsw_xmm_xmm_xmmm128 = 2598,
	/// `VPHSUBSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 07 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vphsubsw_ymm_ymm_ymmm256 = 2599,
	/// `PSIGNB mm1, mm2/m64`
	///
	/// `NP 0F 38 08 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Psignb_mm_mmm64 = 2600,
	/// `PSIGNB xmm1, xmm2/m128`
	///
	/// `66 0F 38 08 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Psignb_xmm_xmmm128 = 2601,
	/// `VPSIGNB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 08 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsignb_xmm_xmm_xmmm128 = 2602,
	/// `VPSIGNB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 08 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsignb_ymm_ymm_ymmm256 = 2603,
	/// `PSIGNW mm1, mm2/m64`
	///
	/// `NP 0F 38 09 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Psignw_mm_mmm64 = 2604,
	/// `PSIGNW xmm1, xmm2/m128`
	///
	/// `66 0F 38 09 /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Psignw_xmm_xmmm128 = 2605,
	/// `VPSIGNW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 09 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsignw_xmm_xmm_xmmm128 = 2606,
	/// `VPSIGNW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 09 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsignw_ymm_ymm_ymmm256 = 2607,
	/// `PSIGND mm1, mm2/m64`
	///
	/// `NP 0F 38 0A /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Psignd_mm_mmm64 = 2608,
	/// `PSIGND xmm1, xmm2/m128`
	///
	/// `66 0F 38 0A /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Psignd_xmm_xmmm128 = 2609,
	/// `VPSIGND xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 0A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpsignd_xmm_xmm_xmmm128 = 2610,
	/// `VPSIGND ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 0A /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsignd_ymm_ymm_ymmm256 = 2611,
	/// `PMULHRSW mm1, mm2/m64`
	///
	/// `NP 0F 38 0B /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pmulhrsw_mm_mmm64 = 2612,
	/// `PMULHRSW xmm1, xmm2/m128`
	///
	/// `66 0F 38 0B /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pmulhrsw_xmm_xmmm128 = 2613,
	/// `VPMULHRSW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 0B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmulhrsw_xmm_xmm_xmmm128 = 2614,
	/// `VPMULHRSW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 0B /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmulhrsw_ymm_ymm_ymmm256 = 2615,
	/// `VPMULHRSW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG 0B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhrsw_xmm_k1z_xmm_xmmm128 = 2616,
	/// `VPMULHRSW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG 0B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhrsw_ymm_k1z_ymm_ymmm256 = 2617,
	/// `VPMULHRSW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG 0B /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulhrsw_zmm_k1z_zmm_zmmm512 = 2618,
	/// `VPERMILPS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 0C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilps_xmm_xmm_xmmm128 = 2619,
	/// `VPERMILPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 0C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilps_ymm_ymm_ymmm256 = 2620,
	/// `VPERMILPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 0C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilps_xmm_k1z_xmm_xmmm128b32 = 2621,
	/// `VPERMILPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 0C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilps_ymm_k1z_ymm_ymmm256b32 = 2622,
	/// `VPERMILPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 0C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilps_zmm_k1z_zmm_zmmm512b32 = 2623,
	/// `VPERMILPD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 0D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilpd_xmm_xmm_xmmm128 = 2624,
	/// `VPERMILPD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 0D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilpd_ymm_ymm_ymmm256 = 2625,
	/// `VPERMILPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 0D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilpd_xmm_k1z_xmm_xmmm128b64 = 2626,
	/// `VPERMILPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 0D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilpd_ymm_k1z_ymm_ymmm256b64 = 2627,
	/// `VPERMILPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 0D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilpd_zmm_k1z_zmm_zmmm512b64 = 2628,
	/// `VTESTPS xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.W0 0E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vtestps_xmm_xmmm128 = 2629,
	/// `VTESTPS ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F38.W0 0E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vtestps_ymm_ymmm256 = 2630,
	/// `VTESTPD xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.W0 0F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vtestpd_xmm_xmmm128 = 2631,
	/// `VTESTPD ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F38.W0 0F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vtestpd_ymm_ymmm256 = 2632,
	/// `PBLENDVB xmm1, xmm2/m128, <XMM0>`
	///
	/// `66 0F 38 10 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pblendvb_xmm_xmmm128 = 2633,
	/// `VPSRLVW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 10 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvw_xmm_k1z_xmm_xmmm128 = 2634,
	/// `VPSRLVW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 10 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvw_ymm_k1z_ymm_ymmm256 = 2635,
	/// `VPSRLVW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 10 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvw_zmm_k1z_zmm_zmmm512 = 2636,
	/// `VPMOVUSWB xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 10 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovuswb_xmmm64_k1z_xmm = 2637,
	/// `VPMOVUSWB xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 10 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovuswb_xmmm128_k1z_ymm = 2638,
	/// `VPMOVUSWB ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 10 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovuswb_ymmm256_k1z_zmm = 2639,
	/// `VPSRAVW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 11 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravw_xmm_k1z_xmm_xmmm128 = 2640,
	/// `VPSRAVW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 11 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravw_ymm_k1z_ymm_ymmm256 = 2641,
	/// `VPSRAVW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 11 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravw_zmm_k1z_zmm_zmmm512 = 2642,
	/// `VPMOVUSDB xmm1/m32 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 11 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusdb_xmmm32_k1z_xmm = 2643,
	/// `VPMOVUSDB xmm1/m64 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 11 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusdb_xmmm64_k1z_ymm = 2644,
	/// `VPMOVUSDB xmm1/m128 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 11 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusdb_xmmm128_k1z_zmm = 2645,
	/// `VPSLLVW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 12 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvw_xmm_k1z_xmm_xmmm128 = 2646,
	/// `VPSLLVW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 12 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvw_ymm_k1z_ymm_ymmm256 = 2647,
	/// `VPSLLVW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 12 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvw_zmm_k1z_zmm_zmmm512 = 2648,
	/// `VPMOVUSQB xmm1/m16 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 12 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqb_xmmm16_k1z_xmm = 2649,
	/// `VPMOVUSQB xmm1/m32 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 12 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqb_xmmm32_k1z_ymm = 2650,
	/// `VPMOVUSQB xmm1/m64 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 12 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqb_xmmm64_k1z_zmm = 2651,
	/// `VCVTPH2PS xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.W0 13 /r`
	///
	/// `F16C`
	///
	/// `16/32/64-bit`
	VEX_Vcvtph2ps_xmm_xmmm64 = 2652,
	/// `VCVTPH2PS ymm1, xmm2/m128`
	///
	/// `VEX.256.66.0F38.W0 13 /r`
	///
	/// `F16C`
	///
	/// `16/32/64-bit`
	VEX_Vcvtph2ps_ymm_xmmm128 = 2653,
	/// `VCVTPH2PS xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.W0 13 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2ps_xmm_k1z_xmmm64 = 2654,
	/// `VCVTPH2PS ymm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.256.66.0F38.W0 13 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2ps_ymm_k1z_xmmm128 = 2655,
	/// `VCVTPH2PS zmm1 {k1}{z}, ymm2/m256{sae}`
	///
	/// `EVEX.512.66.0F38.W0 13 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2ps_zmm_k1z_ymmm256_sae = 2656,
	/// `VPMOVUSDW xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 13 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusdw_xmmm64_k1z_xmm = 2657,
	/// `VPMOVUSDW xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 13 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusdw_xmmm128_k1z_ymm = 2658,
	/// `VPMOVUSDW ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 13 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusdw_ymmm256_k1z_zmm = 2659,
	/// `BLENDVPS xmm1, xmm2/m128, <XMM0>`
	///
	/// `66 0F 38 14 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Blendvps_xmm_xmmm128 = 2660,
	/// `VPRORVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorvd_xmm_k1z_xmm_xmmm128b32 = 2661,
	/// `VPRORVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorvd_ymm_k1z_ymm_ymmm256b32 = 2662,
	/// `VPRORVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 14 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorvd_zmm_k1z_zmm_zmmm512b32 = 2663,
	/// `VPRORVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorvq_xmm_k1z_xmm_xmmm128b64 = 2664,
	/// `VPRORVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorvq_ymm_k1z_ymm_ymmm256b64 = 2665,
	/// `VPRORVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 14 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprorvq_zmm_k1z_zmm_zmmm512b64 = 2666,
	/// `VPMOVUSQW xmm1/m32 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqw_xmmm32_k1z_xmm = 2667,
	/// `VPMOVUSQW xmm1/m64 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 14 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqw_xmmm64_k1z_ymm = 2668,
	/// `VPMOVUSQW xmm1/m128 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 14 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqw_xmmm128_k1z_zmm = 2669,
	/// `BLENDVPD xmm1, xmm2/m128, <XMM0>`
	///
	/// `66 0F 38 15 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Blendvpd_xmm_xmmm128 = 2670,
	/// `VPROLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolvd_xmm_k1z_xmm_xmmm128b32 = 2671,
	/// `VPROLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolvd_ymm_k1z_ymm_ymmm256b32 = 2672,
	/// `VPROLVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 15 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolvd_zmm_k1z_zmm_zmmm512b32 = 2673,
	/// `VPROLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolvq_xmm_k1z_xmm_xmmm128b64 = 2674,
	/// `VPROLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolvq_ymm_k1z_ymm_ymmm256b64 = 2675,
	/// `VPROLVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 15 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vprolvq_zmm_k1z_zmm_zmmm512b64 = 2676,
	/// `VPMOVUSQD xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqd_xmmm64_k1z_xmm = 2677,
	/// `VPMOVUSQD xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 15 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqd_xmmm128_k1z_ymm = 2678,
	/// `VPMOVUSQD ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 15 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovusqd_ymmm256_k1z_zmm = 2679,
	/// `VPERMPS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 16 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpermps_ymm_ymm_ymmm256 = 2680,
	/// `VPERMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 16 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermps_ymm_k1z_ymm_ymmm256b32 = 2681,
	/// `VPERMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 16 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermps_zmm_k1z_zmm_zmmm512b32 = 2682,
	/// `VPERMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 16 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermpd_ymm_k1z_ymm_ymmm256b64 = 2683,
	/// `VPERMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 16 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermpd_zmm_k1z_zmm_zmmm512b64 = 2684,
	/// `PTEST xmm1, xmm2/m128`
	///
	/// `66 0F 38 17 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Ptest_xmm_xmmm128 = 2685,
	/// `VPTEST xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.WIG 17 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vptest_xmm_xmmm128 = 2686,
	/// `VPTEST ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F38.WIG 17 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vptest_ymm_ymmm256 = 2687,
	/// `VBROADCASTSS xmm1, m32`
	///
	/// `VEX.128.66.0F38.W0 18 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcastss_xmm_m32 = 2688,
	/// `VBROADCASTSS ymm1, m32`
	///
	/// `VEX.256.66.0F38.W0 18 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcastss_ymm_m32 = 2689,
	/// `VBROADCASTSS xmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.128.66.0F38.W0 18 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastss_xmm_k1z_xmmm32 = 2690,
	/// `VBROADCASTSS ymm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.256.66.0F38.W0 18 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastss_ymm_k1z_xmmm32 = 2691,
	/// `VBROADCASTSS zmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.512.66.0F38.W0 18 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastss_zmm_k1z_xmmm32 = 2692,
	/// `VBROADCASTSD ymm1, m64`
	///
	/// `VEX.256.66.0F38.W0 19 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcastsd_ymm_m64 = 2693,
	/// `VBROADCASTF32X2 ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.W0 19 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf32x2_ymm_k1z_xmmm64 = 2694,
	/// `VBROADCASTF32X2 zmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.512.66.0F38.W0 19 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf32x2_zmm_k1z_xmmm64 = 2695,
	/// `VBROADCASTSD ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.W1 19 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastsd_ymm_k1z_xmmm64 = 2696,
	/// `VBROADCASTSD zmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.512.66.0F38.W1 19 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastsd_zmm_k1z_xmmm64 = 2697,
	/// `VBROADCASTF128 ymm1, m128`
	///
	/// `VEX.256.66.0F38.W0 1A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcastf128_ymm_m128 = 2698,
	/// `VBROADCASTF32X4 ymm1 {k1}{z}, m128`
	///
	/// `EVEX.256.66.0F38.W0 1A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf32x4_ymm_k1z_m128 = 2699,
	/// `VBROADCASTF32X4 zmm1 {k1}{z}, m128`
	///
	/// `EVEX.512.66.0F38.W0 1A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf32x4_zmm_k1z_m128 = 2700,
	/// `VBROADCASTF64X2 ymm1 {k1}{z}, m128`
	///
	/// `EVEX.256.66.0F38.W1 1A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf64x2_ymm_k1z_m128 = 2701,
	/// `VBROADCASTF64X2 zmm1 {k1}{z}, m128`
	///
	/// `EVEX.512.66.0F38.W1 1A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf64x2_zmm_k1z_m128 = 2702,
	/// `VBROADCASTF32X8 zmm1 {k1}{z}, m256`
	///
	/// `EVEX.512.66.0F38.W0 1B /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf32x8_zmm_k1z_m256 = 2703,
	/// `VBROADCASTF64X4 zmm1 {k1}{z}, m256`
	///
	/// `EVEX.512.66.0F38.W1 1B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcastf64x4_zmm_k1z_m256 = 2704,
	/// `PABSB mm1, mm2/m64`
	///
	/// `NP 0F 38 1C /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pabsb_mm_mmm64 = 2705,
	/// `PABSB xmm1, xmm2/m128`
	///
	/// `66 0F 38 1C /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pabsb_xmm_xmmm128 = 2706,
	/// `VPABSB xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.WIG 1C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpabsb_xmm_xmmm128 = 2707,
	/// `VPABSB ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F38.WIG 1C /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpabsb_ymm_ymmm256 = 2708,
	/// `VPABSB xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.WIG 1C /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsb_xmm_k1z_xmmm128 = 2709,
	/// `VPABSB ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.WIG 1C /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsb_ymm_k1z_ymmm256 = 2710,
	/// `VPABSB zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.WIG 1C /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsb_zmm_k1z_zmmm512 = 2711,
	/// `PABSW mm1, mm2/m64`
	///
	/// `NP 0F 38 1D /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pabsw_mm_mmm64 = 2712,
	/// `PABSW xmm1, xmm2/m128`
	///
	/// `66 0F 38 1D /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pabsw_xmm_xmmm128 = 2713,
	/// `VPABSW xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.WIG 1D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpabsw_xmm_xmmm128 = 2714,
	/// `VPABSW ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F38.WIG 1D /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpabsw_ymm_ymmm256 = 2715,
	/// `VPABSW xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.WIG 1D /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsw_xmm_k1z_xmmm128 = 2716,
	/// `VPABSW ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.WIG 1D /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsw_ymm_k1z_ymmm256 = 2717,
	/// `VPABSW zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.WIG 1D /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsw_zmm_k1z_zmmm512 = 2718,
	/// `PABSD mm1, mm2/m64`
	///
	/// `NP 0F 38 1E /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pabsd_mm_mmm64 = 2719,
	/// `PABSD xmm1, xmm2/m128`
	///
	/// `66 0F 38 1E /r`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Pabsd_xmm_xmmm128 = 2720,
	/// `VPABSD xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.WIG 1E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpabsd_xmm_xmmm128 = 2721,
	/// `VPABSD ymm1, ymm2/m256`
	///
	/// `VEX.256.66.0F38.WIG 1E /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpabsd_ymm_ymmm256 = 2722,
	/// `VPABSD xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 1E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsd_xmm_k1z_xmmm128b32 = 2723,
	/// `VPABSD ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 1E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsd_ymm_k1z_ymmm256b32 = 2724,
	/// `VPABSD zmm1 {k1}{z}, zmm2/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 1E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsd_zmm_k1z_zmmm512b32 = 2725,
	/// `VPABSQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 1F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsq_xmm_k1z_xmmm128b64 = 2726,
	/// `VPABSQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 1F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsq_ymm_k1z_ymmm256b64 = 2727,
	/// `VPABSQ zmm1 {k1}{z}, zmm2/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 1F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpabsq_zmm_k1z_zmmm512b64 = 2728,
	/// `PMOVSXBW xmm1, xmm2/m64`
	///
	/// `66 0F 38 20 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovsxbw_xmm_xmmm64 = 2729,
	/// `VPMOVSXBW xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.WIG 20 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxbw_xmm_xmmm64 = 2730,
	/// `VPMOVSXBW ymm1, xmm2/m128`
	///
	/// `VEX.256.66.0F38.WIG 20 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxbw_ymm_xmmm128 = 2731,
	/// `VPMOVSXBW xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.WIG 20 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbw_xmm_k1z_xmmm64 = 2732,
	/// `VPMOVSXBW ymm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.256.66.0F38.WIG 20 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbw_ymm_k1z_xmmm128 = 2733,
	/// `VPMOVSXBW zmm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.512.66.0F38.WIG 20 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbw_zmm_k1z_ymmm256 = 2734,
	/// `VPMOVSWB xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 20 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovswb_xmmm64_k1z_xmm = 2735,
	/// `VPMOVSWB xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 20 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovswb_xmmm128_k1z_ymm = 2736,
	/// `VPMOVSWB ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 20 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovswb_ymmm256_k1z_zmm = 2737,
	/// `PMOVSXBD xmm1, xmm2/m32`
	///
	/// `66 0F 38 21 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovsxbd_xmm_xmmm32 = 2738,
	/// `VPMOVSXBD xmm1, xmm2/m32`
	///
	/// `VEX.128.66.0F38.WIG 21 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxbd_xmm_xmmm32 = 2739,
	/// `VPMOVSXBD ymm1, xmm2/m64`
	///
	/// `VEX.256.66.0F38.WIG 21 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxbd_ymm_xmmm64 = 2740,
	/// `VPMOVSXBD xmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.128.66.0F38.WIG 21 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbd_xmm_k1z_xmmm32 = 2741,
	/// `VPMOVSXBD ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.WIG 21 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbd_ymm_k1z_xmmm64 = 2742,
	/// `VPMOVSXBD zmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.512.66.0F38.WIG 21 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbd_zmm_k1z_xmmm128 = 2743,
	/// `VPMOVSDB xmm1/m32 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 21 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsdb_xmmm32_k1z_xmm = 2744,
	/// `VPMOVSDB xmm1/m64 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 21 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsdb_xmmm64_k1z_ymm = 2745,
	/// `VPMOVSDB xmm1/m128 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 21 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsdb_xmmm128_k1z_zmm = 2746,
	/// `PMOVSXBQ xmm1, xmm2/m16`
	///
	/// `66 0F 38 22 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovsxbq_xmm_xmmm16 = 2747,
	/// `VPMOVSXBQ xmm1, xmm2/m16`
	///
	/// `VEX.128.66.0F38.WIG 22 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxbq_xmm_xmmm16 = 2748,
	/// `VPMOVSXBQ ymm1, xmm2/m32`
	///
	/// `VEX.256.66.0F38.WIG 22 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxbq_ymm_xmmm32 = 2749,
	/// `VPMOVSXBQ xmm1 {k1}{z}, xmm2/m16`
	///
	/// `EVEX.128.66.0F38.WIG 22 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbq_xmm_k1z_xmmm16 = 2750,
	/// `VPMOVSXBQ ymm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.256.66.0F38.WIG 22 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbq_ymm_k1z_xmmm32 = 2751,
	/// `VPMOVSXBQ zmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.512.66.0F38.WIG 22 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxbq_zmm_k1z_xmmm64 = 2752,
	/// `VPMOVSQB xmm1/m16 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 22 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqb_xmmm16_k1z_xmm = 2753,
	/// `VPMOVSQB xmm1/m32 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 22 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqb_xmmm32_k1z_ymm = 2754,
	/// `VPMOVSQB xmm1/m64 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 22 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqb_xmmm64_k1z_zmm = 2755,
	/// `PMOVSXWD xmm1, xmm2/m64`
	///
	/// `66 0F 38 23 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovsxwd_xmm_xmmm64 = 2756,
	/// `VPMOVSXWD xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.WIG 23 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxwd_xmm_xmmm64 = 2757,
	/// `VPMOVSXWD ymm1, xmm2/m128`
	///
	/// `VEX.256.66.0F38.WIG 23 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxwd_ymm_xmmm128 = 2758,
	/// `VPMOVSXWD xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.WIG 23 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxwd_xmm_k1z_xmmm64 = 2759,
	/// `VPMOVSXWD ymm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.256.66.0F38.WIG 23 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxwd_ymm_k1z_xmmm128 = 2760,
	/// `VPMOVSXWD zmm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.512.66.0F38.WIG 23 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxwd_zmm_k1z_ymmm256 = 2761,
	/// `VPMOVSDW xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 23 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsdw_xmmm64_k1z_xmm = 2762,
	/// `VPMOVSDW xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 23 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsdw_xmmm128_k1z_ymm = 2763,
	/// `VPMOVSDW ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 23 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsdw_ymmm256_k1z_zmm = 2764,
	/// `PMOVSXWQ xmm1, xmm2/m32`
	///
	/// `66 0F 38 24 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovsxwq_xmm_xmmm32 = 2765,
	/// `VPMOVSXWQ xmm1, xmm2/m32`
	///
	/// `VEX.128.66.0F38.WIG 24 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxwq_xmm_xmmm32 = 2766,
	/// `VPMOVSXWQ ymm1, xmm2/m64`
	///
	/// `VEX.256.66.0F38.WIG 24 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxwq_ymm_xmmm64 = 2767,
	/// `VPMOVSXWQ xmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.128.66.0F38.WIG 24 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxwq_xmm_k1z_xmmm32 = 2768,
	/// `VPMOVSXWQ ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.WIG 24 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxwq_ymm_k1z_xmmm64 = 2769,
	/// `VPMOVSXWQ zmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.512.66.0F38.WIG 24 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxwq_zmm_k1z_xmmm128 = 2770,
	/// `VPMOVSQW xmm1/m32 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 24 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqw_xmmm32_k1z_xmm = 2771,
	/// `VPMOVSQW xmm1/m64 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 24 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqw_xmmm64_k1z_ymm = 2772,
	/// `VPMOVSQW xmm1/m128 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 24 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqw_xmmm128_k1z_zmm = 2773,
	/// `PMOVSXDQ xmm1, xmm2/m64`
	///
	/// `66 0F 38 25 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovsxdq_xmm_xmmm64 = 2774,
	/// `VPMOVSXDQ xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.WIG 25 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxdq_xmm_xmmm64 = 2775,
	/// `VPMOVSXDQ ymm1, xmm2/m128`
	///
	/// `VEX.256.66.0F38.WIG 25 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovsxdq_ymm_xmmm128 = 2776,
	/// `VPMOVSXDQ xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.W0 25 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxdq_xmm_k1z_xmmm64 = 2777,
	/// `VPMOVSXDQ ymm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.256.66.0F38.W0 25 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxdq_ymm_k1z_xmmm128 = 2778,
	/// `VPMOVSXDQ zmm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.512.66.0F38.W0 25 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsxdq_zmm_k1z_ymmm256 = 2779,
	/// `VPMOVSQD xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 25 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqd_xmmm64_k1z_xmm = 2780,
	/// `VPMOVSQD xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 25 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqd_xmmm128_k1z_ymm = 2781,
	/// `VPMOVSQD ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 25 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovsqd_ymmm256_k1z_zmm = 2782,
	/// `VPTESTMB k2 {k1}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W0 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmb_kr_k1_xmm_xmmm128 = 2783,
	/// `VPTESTMB k2 {k1}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W0 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmb_kr_k1_ymm_ymmm256 = 2784,
	/// `VPTESTMB k2 {k1}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W0 26 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmb_kr_k1_zmm_zmmm512 = 2785,
	/// `VPTESTMW k2 {k1}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmw_kr_k1_xmm_xmmm128 = 2786,
	/// `VPTESTMW k2 {k1}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmw_kr_k1_ymm_ymmm256 = 2787,
	/// `VPTESTMW k2 {k1}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 26 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmw_kr_k1_zmm_zmmm512 = 2788,
	/// `VPTESTNMB k2 {k1}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.F3.0F38.W0 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmb_kr_k1_xmm_xmmm128 = 2789,
	/// `VPTESTNMB k2 {k1}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.F3.0F38.W0 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmb_kr_k1_ymm_ymmm256 = 2790,
	/// `VPTESTNMB k2 {k1}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.F3.0F38.W0 26 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmb_kr_k1_zmm_zmmm512 = 2791,
	/// `VPTESTNMW k2 {k1}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.F3.0F38.W1 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmw_kr_k1_xmm_xmmm128 = 2792,
	/// `VPTESTNMW k2 {k1}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.F3.0F38.W1 26 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmw_kr_k1_ymm_ymmm256 = 2793,
	/// `VPTESTNMW k2 {k1}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.F3.0F38.W1 26 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmw_kr_k1_zmm_zmmm512 = 2794,
	/// `VPTESTMD k2 {k1}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmd_kr_k1_xmm_xmmm128b32 = 2795,
	/// `VPTESTMD k2 {k1}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmd_kr_k1_ymm_ymmm256b32 = 2796,
	/// `VPTESTMD k2 {k1}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 27 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmd_kr_k1_zmm_zmmm512b32 = 2797,
	/// `VPTESTMQ k2 {k1}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmq_kr_k1_xmm_xmmm128b64 = 2798,
	/// `VPTESTMQ k2 {k1}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmq_kr_k1_ymm_ymmm256b64 = 2799,
	/// `VPTESTMQ k2 {k1}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 27 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestmq_kr_k1_zmm_zmmm512b64 = 2800,
	/// `VPTESTNMD k2 {k1}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F3.0F38.W0 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmd_kr_k1_xmm_xmmm128b32 = 2801,
	/// `VPTESTNMD k2 {k1}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F3.0F38.W0 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmd_kr_k1_ymm_ymmm256b32 = 2802,
	/// `VPTESTNMD k2 {k1}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.F3.0F38.W0 27 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmd_kr_k1_zmm_zmmm512b32 = 2803,
	/// `VPTESTNMQ k2 {k1}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.F3.0F38.W1 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmq_kr_k1_xmm_xmmm128b64 = 2804,
	/// `VPTESTNMQ k2 {k1}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.F3.0F38.W1 27 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmq_kr_k1_ymm_ymmm256b64 = 2805,
	/// `VPTESTNMQ k2 {k1}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.F3.0F38.W1 27 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vptestnmq_kr_k1_zmm_zmmm512b64 = 2806,
	/// `PMULDQ xmm1, xmm2/m128`
	///
	/// `66 0F 38 28 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmuldq_xmm_xmmm128 = 2807,
	/// `VPMULDQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 28 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmuldq_xmm_xmm_xmmm128 = 2808,
	/// `VPMULDQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 28 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmuldq_ymm_ymm_ymmm256 = 2809,
	/// `VPMULDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 28 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmuldq_xmm_k1z_xmm_xmmm128b64 = 2810,
	/// `VPMULDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 28 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmuldq_ymm_k1z_ymm_ymmm256b64 = 2811,
	/// `VPMULDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 28 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmuldq_zmm_k1z_zmm_zmmm512b64 = 2812,
	/// `VPMOVM2B xmm1, k1`
	///
	/// `EVEX.128.F3.0F38.W0 28 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2b_xmm_kr = 2813,
	/// `VPMOVM2B ymm1, k1`
	///
	/// `EVEX.256.F3.0F38.W0 28 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2b_ymm_kr = 2814,
	/// `VPMOVM2B zmm1, k1`
	///
	/// `EVEX.512.F3.0F38.W0 28 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2b_zmm_kr = 2815,
	/// `VPMOVM2W xmm1, k1`
	///
	/// `EVEX.128.F3.0F38.W1 28 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2w_xmm_kr = 2816,
	/// `VPMOVM2W ymm1, k1`
	///
	/// `EVEX.256.F3.0F38.W1 28 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2w_ymm_kr = 2817,
	/// `VPMOVM2W zmm1, k1`
	///
	/// `EVEX.512.F3.0F38.W1 28 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2w_zmm_kr = 2818,
	/// `PCMPEQQ xmm1, xmm2/m128`
	///
	/// `66 0F 38 29 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pcmpeqq_xmm_xmmm128 = 2819,
	/// `VPCMPEQQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 29 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqq_xmm_xmm_xmmm128 = 2820,
	/// `VPCMPEQQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 29 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpeqq_ymm_ymm_ymmm256 = 2821,
	/// `VPCMPEQQ k1 {k2}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 29 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqq_kr_k1_xmm_xmmm128b64 = 2822,
	/// `VPCMPEQQ k1 {k2}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 29 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqq_kr_k1_ymm_ymmm256b64 = 2823,
	/// `VPCMPEQQ k1 {k2}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 29 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpeqq_kr_k1_zmm_zmmm512b64 = 2824,
	/// `VPMOVB2M k1, xmm1`
	///
	/// `EVEX.128.F3.0F38.W0 29 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovb2m_kr_xmm = 2825,
	/// `VPMOVB2M k1, ymm1`
	///
	/// `EVEX.256.F3.0F38.W0 29 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovb2m_kr_ymm = 2826,
	/// `VPMOVB2M k1, zmm1`
	///
	/// `EVEX.512.F3.0F38.W0 29 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovb2m_kr_zmm = 2827,
	/// `VPMOVW2M k1, xmm1`
	///
	/// `EVEX.128.F3.0F38.W1 29 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovw2m_kr_xmm = 2828,
	/// `VPMOVW2M k1, ymm1`
	///
	/// `EVEX.256.F3.0F38.W1 29 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovw2m_kr_ymm = 2829,
	/// `VPMOVW2M k1, zmm1`
	///
	/// `EVEX.512.F3.0F38.W1 29 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovw2m_kr_zmm = 2830,
	/// `MOVNTDQA xmm1, m128`
	///
	/// `66 0F 38 2A /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Movntdqa_xmm_m128 = 2831,
	/// `VMOVNTDQA xmm1, m128`
	///
	/// `VEX.128.66.0F38.WIG 2A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmovntdqa_xmm_m128 = 2832,
	/// `VMOVNTDQA ymm1, m256`
	///
	/// `VEX.256.66.0F38.WIG 2A /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vmovntdqa_ymm_m256 = 2833,
	/// `VMOVNTDQA xmm1, m128`
	///
	/// `EVEX.128.66.0F38.W0 2A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntdqa_xmm_m128 = 2834,
	/// `VMOVNTDQA ymm1, m256`
	///
	/// `EVEX.256.66.0F38.W0 2A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntdqa_ymm_m256 = 2835,
	/// `VMOVNTDQA zmm1, m512`
	///
	/// `EVEX.512.66.0F38.W0 2A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vmovntdqa_zmm_m512 = 2836,
	/// `VPBROADCASTMB2Q xmm1, k1`
	///
	/// `EVEX.128.F3.0F38.W1 2A /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastmb2q_xmm_kr = 2837,
	/// `VPBROADCASTMB2Q ymm1, k1`
	///
	/// `EVEX.256.F3.0F38.W1 2A /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastmb2q_ymm_kr = 2838,
	/// `VPBROADCASTMB2Q zmm1, k1`
	///
	/// `EVEX.512.F3.0F38.W1 2A /r`
	///
	/// `AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastmb2q_zmm_kr = 2839,
	/// `PACKUSDW xmm1, xmm2/m128`
	///
	/// `66 0F 38 2B /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Packusdw_xmm_xmmm128 = 2840,
	/// `VPACKUSDW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 2B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpackusdw_xmm_xmm_xmmm128 = 2841,
	/// `VPACKUSDW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 2B /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpackusdw_ymm_ymm_ymmm256 = 2842,
	/// `VPACKUSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 2B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackusdw_xmm_k1z_xmm_xmmm128b32 = 2843,
	/// `VPACKUSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 2B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackusdw_ymm_k1z_ymm_ymmm256b32 = 2844,
	/// `VPACKUSDW zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 2B /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpackusdw_zmm_k1z_zmm_zmmm512b32 = 2845,
	/// `VMASKMOVPS xmm1, xmm2, m128`
	///
	/// `VEX.128.66.0F38.W0 2C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovps_xmm_xmm_m128 = 2846,
	/// `VMASKMOVPS ymm1, ymm2, m256`
	///
	/// `VEX.256.66.0F38.W0 2C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovps_ymm_ymm_m256 = 2847,
	/// `VSCALEFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 2C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefps_xmm_k1z_xmm_xmmm128b32 = 2848,
	/// `VSCALEFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 2C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefps_ymm_k1z_ymm_ymmm256b32 = 2849,
	/// `VSCALEFPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 2C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefps_zmm_k1z_zmm_zmmm512b32_er = 2850,
	/// `VSCALEFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 2C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefpd_xmm_k1z_xmm_xmmm128b64 = 2851,
	/// `VSCALEFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 2C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefpd_ymm_k1z_ymm_ymmm256b64 = 2852,
	/// `VSCALEFPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 2C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefpd_zmm_k1z_zmm_zmmm512b64_er = 2853,
	/// `VMASKMOVPD xmm1, xmm2, m128`
	///
	/// `VEX.128.66.0F38.W0 2D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovpd_xmm_xmm_m128 = 2854,
	/// `VMASKMOVPD ymm1, ymm2, m256`
	///
	/// `VEX.256.66.0F38.W0 2D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovpd_ymm_ymm_m256 = 2855,
	/// `VSCALEFSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 2D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefss_xmm_k1z_xmm_xmmm32_er = 2856,
	/// `VSCALEFSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 2D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefsd_xmm_k1z_xmm_xmmm64_er = 2857,
	/// `VMASKMOVPS m128, xmm1, xmm2`
	///
	/// `VEX.128.66.0F38.W0 2E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovps_m128_xmm_xmm = 2858,
	/// `VMASKMOVPS m256, ymm1, ymm2`
	///
	/// `VEX.256.66.0F38.W0 2E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovps_m256_ymm_ymm = 2859,
	/// `VMASKMOVPD m128, xmm1, xmm2`
	///
	/// `VEX.128.66.0F38.W0 2F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovpd_m128_xmm_xmm = 2860,
	/// `VMASKMOVPD m256, ymm1, ymm2`
	///
	/// `VEX.256.66.0F38.W0 2F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmaskmovpd_m256_ymm_ymm = 2861,
	/// `PMOVZXBW xmm1, xmm2/m64`
	///
	/// `66 0F 38 30 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovzxbw_xmm_xmmm64 = 2862,
	/// `VPMOVZXBW xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.WIG 30 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxbw_xmm_xmmm64 = 2863,
	/// `VPMOVZXBW ymm1, xmm2/m128`
	///
	/// `VEX.256.66.0F38.WIG 30 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxbw_ymm_xmmm128 = 2864,
	/// `VPMOVZXBW xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.WIG 30 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbw_xmm_k1z_xmmm64 = 2865,
	/// `VPMOVZXBW ymm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.256.66.0F38.WIG 30 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbw_ymm_k1z_xmmm128 = 2866,
	/// `VPMOVZXBW zmm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.512.66.0F38.WIG 30 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbw_zmm_k1z_ymmm256 = 2867,
	/// `VPMOVWB xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 30 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovwb_xmmm64_k1z_xmm = 2868,
	/// `VPMOVWB xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 30 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovwb_xmmm128_k1z_ymm = 2869,
	/// `VPMOVWB ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 30 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovwb_ymmm256_k1z_zmm = 2870,
	/// `PMOVZXBD xmm1, xmm2/m32`
	///
	/// `66 0F 38 31 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovzxbd_xmm_xmmm32 = 2871,
	/// `VPMOVZXBD xmm1, xmm2/m32`
	///
	/// `VEX.128.66.0F38.WIG 31 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxbd_xmm_xmmm32 = 2872,
	/// `VPMOVZXBD ymm1, xmm2/m64`
	///
	/// `VEX.256.66.0F38.WIG 31 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxbd_ymm_xmmm64 = 2873,
	/// `VPMOVZXBD xmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.128.66.0F38.WIG 31 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbd_xmm_k1z_xmmm32 = 2874,
	/// `VPMOVZXBD ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.WIG 31 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbd_ymm_k1z_xmmm64 = 2875,
	/// `VPMOVZXBD zmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.512.66.0F38.WIG 31 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbd_zmm_k1z_xmmm128 = 2876,
	/// `VPMOVDB xmm1/m32 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 31 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovdb_xmmm32_k1z_xmm = 2877,
	/// `VPMOVDB xmm1/m64 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 31 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovdb_xmmm64_k1z_ymm = 2878,
	/// `VPMOVDB xmm1/m128 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 31 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovdb_xmmm128_k1z_zmm = 2879,
	/// `PMOVZXBQ xmm1, xmm2/m16`
	///
	/// `66 0F 38 32 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovzxbq_xmm_xmmm16 = 2880,
	/// `VPMOVZXBQ xmm1, xmm2/m16`
	///
	/// `VEX.128.66.0F38.WIG 32 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxbq_xmm_xmmm16 = 2881,
	/// `VPMOVZXBQ ymm1, xmm2/m32`
	///
	/// `VEX.256.66.0F38.WIG 32 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxbq_ymm_xmmm32 = 2882,
	/// `VPMOVZXBQ xmm1 {k1}{z}, xmm2/m16`
	///
	/// `EVEX.128.66.0F38.WIG 32 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbq_xmm_k1z_xmmm16 = 2883,
	/// `VPMOVZXBQ ymm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.256.66.0F38.WIG 32 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbq_ymm_k1z_xmmm32 = 2884,
	/// `VPMOVZXBQ zmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.512.66.0F38.WIG 32 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxbq_zmm_k1z_xmmm64 = 2885,
	/// `VPMOVQB xmm1/m16 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 32 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqb_xmmm16_k1z_xmm = 2886,
	/// `VPMOVQB xmm1/m32 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 32 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqb_xmmm32_k1z_ymm = 2887,
	/// `VPMOVQB xmm1/m64 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 32 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqb_xmmm64_k1z_zmm = 2888,
	/// `PMOVZXWD xmm1, xmm2/m64`
	///
	/// `66 0F 38 33 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovzxwd_xmm_xmmm64 = 2889,
	/// `VPMOVZXWD xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.WIG 33 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxwd_xmm_xmmm64 = 2890,
	/// `VPMOVZXWD ymm1, xmm2/m128`
	///
	/// `VEX.256.66.0F38.WIG 33 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxwd_ymm_xmmm128 = 2891,
	/// `VPMOVZXWD xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.WIG 33 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxwd_xmm_k1z_xmmm64 = 2892,
	/// `VPMOVZXWD ymm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.256.66.0F38.WIG 33 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxwd_ymm_k1z_xmmm128 = 2893,
	/// `VPMOVZXWD zmm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.512.66.0F38.WIG 33 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxwd_zmm_k1z_ymmm256 = 2894,
	/// `VPMOVDW xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 33 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovdw_xmmm64_k1z_xmm = 2895,
	/// `VPMOVDW xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 33 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovdw_xmmm128_k1z_ymm = 2896,
	/// `VPMOVDW ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 33 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovdw_ymmm256_k1z_zmm = 2897,
	/// `PMOVZXWQ xmm1, xmm2/m32`
	///
	/// `66 0F 38 34 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovzxwq_xmm_xmmm32 = 2898,
	/// `VPMOVZXWQ xmm1, xmm2/m32`
	///
	/// `VEX.128.66.0F38.WIG 34 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxwq_xmm_xmmm32 = 2899,
	/// `VPMOVZXWQ ymm1, xmm2/m64`
	///
	/// `VEX.256.66.0F38.WIG 34 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxwq_ymm_xmmm64 = 2900,
	/// `VPMOVZXWQ xmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.128.66.0F38.WIG 34 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxwq_xmm_k1z_xmmm32 = 2901,
	/// `VPMOVZXWQ ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.WIG 34 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxwq_ymm_k1z_xmmm64 = 2902,
	/// `VPMOVZXWQ zmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.512.66.0F38.WIG 34 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxwq_zmm_k1z_xmmm128 = 2903,
	/// `VPMOVQW xmm1/m32 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 34 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqw_xmmm32_k1z_xmm = 2904,
	/// `VPMOVQW xmm1/m64 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 34 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqw_xmmm64_k1z_ymm = 2905,
	/// `VPMOVQW xmm1/m128 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 34 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqw_xmmm128_k1z_zmm = 2906,
	/// `PMOVZXDQ xmm1, xmm2/m64`
	///
	/// `66 0F 38 35 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmovzxdq_xmm_xmmm64 = 2907,
	/// `VPMOVZXDQ xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.WIG 35 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxdq_xmm_xmmm64 = 2908,
	/// `VPMOVZXDQ ymm1, xmm2/m128`
	///
	/// `VEX.256.66.0F38.WIG 35 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmovzxdq_ymm_xmmm128 = 2909,
	/// `VPMOVZXDQ xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.W0 35 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxdq_xmm_k1z_xmmm64 = 2910,
	/// `VPMOVZXDQ ymm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.256.66.0F38.W0 35 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxdq_ymm_k1z_xmmm128 = 2911,
	/// `VPMOVZXDQ zmm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.512.66.0F38.W0 35 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovzxdq_zmm_k1z_ymmm256 = 2912,
	/// `VPMOVQD xmm1/m64 {k1}{z}, xmm2`
	///
	/// `EVEX.128.F3.0F38.W0 35 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqd_xmmm64_k1z_xmm = 2913,
	/// `VPMOVQD xmm1/m128 {k1}{z}, ymm2`
	///
	/// `EVEX.256.F3.0F38.W0 35 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqd_xmmm128_k1z_ymm = 2914,
	/// `VPMOVQD ymm1/m256 {k1}{z}, zmm2`
	///
	/// `EVEX.512.F3.0F38.W0 35 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovqd_ymmm256_k1z_zmm = 2915,
	/// `VPERMD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 36 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpermd_ymm_ymm_ymmm256 = 2916,
	/// `VPERMD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 36 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermd_ymm_k1z_ymm_ymmm256b32 = 2917,
	/// `VPERMD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 36 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermd_zmm_k1z_zmm_zmmm512b32 = 2918,
	/// `VPERMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 36 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermq_ymm_k1z_ymm_ymmm256b64 = 2919,
	/// `VPERMQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 36 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermq_zmm_k1z_zmm_zmmm512b64 = 2920,
	/// `PCMPGTQ xmm1, xmm2/m128`
	///
	/// `66 0F 38 37 /r`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Pcmpgtq_xmm_xmmm128 = 2921,
	/// `VPCMPGTQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 37 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtq_xmm_xmm_xmmm128 = 2922,
	/// `VPCMPGTQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 37 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpgtq_ymm_ymm_ymmm256 = 2923,
	/// `VPCMPGTQ k1 {k2}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 37 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtq_kr_k1_xmm_xmmm128b64 = 2924,
	/// `VPCMPGTQ k1 {k2}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 37 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtq_kr_k1_ymm_ymmm256b64 = 2925,
	/// `VPCMPGTQ k1 {k2}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 37 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpgtq_kr_k1_zmm_zmmm512b64 = 2926,
	/// `PMINSB xmm1, xmm2/m128`
	///
	/// `66 0F 38 38 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pminsb_xmm_xmmm128 = 2927,
	/// `VPMINSB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 38 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpminsb_xmm_xmm_xmmm128 = 2928,
	/// `VPMINSB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 38 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpminsb_ymm_ymm_ymmm256 = 2929,
	/// `VPMINSB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG 38 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsb_xmm_k1z_xmm_xmmm128 = 2930,
	/// `VPMINSB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG 38 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsb_ymm_k1z_ymm_ymmm256 = 2931,
	/// `VPMINSB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG 38 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsb_zmm_k1z_zmm_zmmm512 = 2932,
	/// `VPMOVM2D xmm1, k1`
	///
	/// `EVEX.128.F3.0F38.W0 38 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2d_xmm_kr = 2933,
	/// `VPMOVM2D ymm1, k1`
	///
	/// `EVEX.256.F3.0F38.W0 38 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2d_ymm_kr = 2934,
	/// `VPMOVM2D zmm1, k1`
	///
	/// `EVEX.512.F3.0F38.W0 38 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2d_zmm_kr = 2935,
	/// `VPMOVM2Q xmm1, k1`
	///
	/// `EVEX.128.F3.0F38.W1 38 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2q_xmm_kr = 2936,
	/// `VPMOVM2Q ymm1, k1`
	///
	/// `EVEX.256.F3.0F38.W1 38 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2q_ymm_kr = 2937,
	/// `VPMOVM2Q zmm1, k1`
	///
	/// `EVEX.512.F3.0F38.W1 38 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovm2q_zmm_kr = 2938,
	/// `PMINSD xmm1, xmm2/m128`
	///
	/// `66 0F 38 39 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pminsd_xmm_xmmm128 = 2939,
	/// `VPMINSD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 39 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpminsd_xmm_xmm_xmmm128 = 2940,
	/// `VPMINSD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 39 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpminsd_ymm_ymm_ymmm256 = 2941,
	/// `VPMINSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 39 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsd_xmm_k1z_xmm_xmmm128b32 = 2942,
	/// `VPMINSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 39 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsd_ymm_k1z_ymm_ymmm256b32 = 2943,
	/// `VPMINSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 39 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsd_zmm_k1z_zmm_zmmm512b32 = 2944,
	/// `VPMINSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 39 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsq_xmm_k1z_xmm_xmmm128b64 = 2945,
	/// `VPMINSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 39 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsq_ymm_k1z_ymm_ymmm256b64 = 2946,
	/// `VPMINSQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 39 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminsq_zmm_k1z_zmm_zmmm512b64 = 2947,
	/// `VPMOVD2M k1, xmm1`
	///
	/// `EVEX.128.F3.0F38.W0 39 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovd2m_kr_xmm = 2948,
	/// `VPMOVD2M k1, ymm1`
	///
	/// `EVEX.256.F3.0F38.W0 39 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovd2m_kr_ymm = 2949,
	/// `VPMOVD2M k1, zmm1`
	///
	/// `EVEX.512.F3.0F38.W0 39 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovd2m_kr_zmm = 2950,
	/// `VPMOVQ2M k1, xmm1`
	///
	/// `EVEX.128.F3.0F38.W1 39 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovq2m_kr_xmm = 2951,
	/// `VPMOVQ2M k1, ymm1`
	///
	/// `EVEX.256.F3.0F38.W1 39 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovq2m_kr_ymm = 2952,
	/// `VPMOVQ2M k1, zmm1`
	///
	/// `EVEX.512.F3.0F38.W1 39 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmovq2m_kr_zmm = 2953,
	/// `PMINUW xmm1, xmm2/m128`
	///
	/// `66 0F 38 3A /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pminuw_xmm_xmmm128 = 2954,
	/// `VPMINUW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 3A /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpminuw_xmm_xmm_xmmm128 = 2955,
	/// `VPMINUW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 3A /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpminuw_ymm_ymm_ymmm256 = 2956,
	/// `VPMINUW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG 3A /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminuw_xmm_k1z_xmm_xmmm128 = 2957,
	/// `VPMINUW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG 3A /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminuw_ymm_k1z_ymm_ymmm256 = 2958,
	/// `VPMINUW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG 3A /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpminuw_zmm_k1z_zmm_zmmm512 = 2959,
	/// `VPBROADCASTMW2D xmm1, k1`
	///
	/// `EVEX.128.F3.0F38.W0 3A /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastmw2d_xmm_kr = 2960,
	/// `VPBROADCASTMW2D ymm1, k1`
	///
	/// `EVEX.256.F3.0F38.W0 3A /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastmw2d_ymm_kr = 2961,
	/// `VPBROADCASTMW2D zmm1, k1`
	///
	/// `EVEX.512.F3.0F38.W0 3A /r`
	///
	/// `AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastmw2d_zmm_kr = 2962,
	/// `PMINUD xmm1, xmm2/m128`
	///
	/// `66 0F 38 3B /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pminud_xmm_xmmm128 = 2963,
	/// `VPMINUD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 3B /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpminud_xmm_xmm_xmmm128 = 2964,
	/// `VPMINUD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 3B /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpminud_ymm_ymm_ymmm256 = 2965,
	/// `VPMINUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 3B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminud_xmm_k1z_xmm_xmmm128b32 = 2966,
	/// `VPMINUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 3B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminud_ymm_k1z_ymm_ymmm256b32 = 2967,
	/// `VPMINUD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 3B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminud_zmm_k1z_zmm_zmmm512b32 = 2968,
	/// `VPMINUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 3B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminuq_xmm_k1z_xmm_xmmm128b64 = 2969,
	/// `VPMINUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 3B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminuq_ymm_k1z_ymm_ymmm256b64 = 2970,
	/// `VPMINUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 3B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpminuq_zmm_k1z_zmm_zmmm512b64 = 2971,
	/// `PMAXSB xmm1, xmm2/m128`
	///
	/// `66 0F 38 3C /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmaxsb_xmm_xmmm128 = 2972,
	/// `VPMAXSB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 3C /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxsb_xmm_xmm_xmmm128 = 2973,
	/// `VPMAXSB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 3C /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxsb_ymm_ymm_ymmm256 = 2974,
	/// `VPMAXSB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG 3C /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsb_xmm_k1z_xmm_xmmm128 = 2975,
	/// `VPMAXSB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG 3C /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsb_ymm_k1z_ymm_ymmm256 = 2976,
	/// `VPMAXSB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG 3C /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsb_zmm_k1z_zmm_zmmm512 = 2977,
	/// `PMAXSD xmm1, xmm2/m128`
	///
	/// `66 0F 38 3D /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmaxsd_xmm_xmmm128 = 2978,
	/// `VPMAXSD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 3D /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxsd_xmm_xmm_xmmm128 = 2979,
	/// `VPMAXSD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 3D /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxsd_ymm_ymm_ymmm256 = 2980,
	/// `VPMAXSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 3D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsd_xmm_k1z_xmm_xmmm128b32 = 2981,
	/// `VPMAXSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 3D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsd_ymm_k1z_ymm_ymmm256b32 = 2982,
	/// `VPMAXSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 3D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsd_zmm_k1z_zmm_zmmm512b32 = 2983,
	/// `VPMAXSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 3D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsq_xmm_k1z_xmm_xmmm128b64 = 2984,
	/// `VPMAXSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 3D /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsq_ymm_k1z_ymm_ymmm256b64 = 2985,
	/// `VPMAXSQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 3D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxsq_zmm_k1z_zmm_zmmm512b64 = 2986,
	/// `PMAXUW xmm1, xmm2/m128`
	///
	/// `66 0F 38 3E /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmaxuw_xmm_xmmm128 = 2987,
	/// `VPMAXUW xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 3E /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxuw_xmm_xmm_xmmm128 = 2988,
	/// `VPMAXUW ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 3E /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxuw_ymm_ymm_ymmm256 = 2989,
	/// `VPMAXUW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG 3E /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxuw_xmm_k1z_xmm_xmmm128 = 2990,
	/// `VPMAXUW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG 3E /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxuw_ymm_k1z_ymm_ymmm256 = 2991,
	/// `VPMAXUW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG 3E /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxuw_zmm_k1z_zmm_zmmm512 = 2992,
	/// `PMAXUD xmm1, xmm2/m128`
	///
	/// `66 0F 38 3F /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmaxud_xmm_xmmm128 = 2993,
	/// `VPMAXUD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 3F /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxud_xmm_xmm_xmmm128 = 2994,
	/// `VPMAXUD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 3F /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaxud_ymm_ymm_ymmm256 = 2995,
	/// `VPMAXUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 3F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxud_xmm_k1z_xmm_xmmm128b32 = 2996,
	/// `VPMAXUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 3F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxud_ymm_k1z_ymm_ymmm256b32 = 2997,
	/// `VPMAXUD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 3F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxud_zmm_k1z_zmm_zmmm512b32 = 2998,
	/// `VPMAXUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 3F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxuq_xmm_k1z_xmm_xmmm128b64 = 2999,
	/// `VPMAXUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 3F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxuq_ymm_k1z_ymm_ymmm256b64 = 3000,
	/// `VPMAXUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 3F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmaxuq_zmm_k1z_zmm_zmmm512b64 = 3001,
	/// `PMULLD xmm1, xmm2/m128`
	///
	/// `66 0F 38 40 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pmulld_xmm_xmmm128 = 3002,
	/// `VPMULLD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG 40 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpmulld_xmm_xmm_xmmm128 = 3003,
	/// `VPMULLD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG 40 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmulld_ymm_ymm_ymmm256 = 3004,
	/// `VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 40 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulld_xmm_k1z_xmm_xmmm128b32 = 3005,
	/// `VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 40 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulld_ymm_k1z_ymm_ymmm256b32 = 3006,
	/// `VPMULLD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 40 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpmulld_zmm_k1z_zmm_zmmm512b32 = 3007,
	/// `VPMULLQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 40 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmullq_xmm_k1z_xmm_xmmm128b64 = 3008,
	/// `VPMULLQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 40 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmullq_ymm_k1z_ymm_ymmm256b64 = 3009,
	/// `VPMULLQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 40 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpmullq_zmm_k1z_zmm_zmmm512b64 = 3010,
	/// `PHMINPOSUW xmm1, xmm2/m128`
	///
	/// `66 0F 38 41 /r`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Phminposuw_xmm_xmmm128 = 3011,
	/// `VPHMINPOSUW xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.WIG 41 /r`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vphminposuw_xmm_xmmm128 = 3012,
	/// `VGETEXPPS xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 42 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpps_xmm_k1z_xmmm128b32 = 3013,
	/// `VGETEXPPS ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 42 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpps_ymm_k1z_ymmm256b32 = 3014,
	/// `VGETEXPPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W0 42 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpps_zmm_k1z_zmmm512b32_sae = 3015,
	/// `VGETEXPPD xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 42 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexppd_xmm_k1z_xmmm128b64 = 3016,
	/// `VGETEXPPD ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 42 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexppd_ymm_k1z_ymmm256b64 = 3017,
	/// `VGETEXPPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W1 42 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexppd_zmm_k1z_zmmm512b64_sae = 3018,
	/// `VGETEXPSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}`
	///
	/// `EVEX.LIG.66.0F38.W0 43 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpss_xmm_k1z_xmm_xmmm32_sae = 3019,
	/// `VGETEXPSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}`
	///
	/// `EVEX.LIG.66.0F38.W1 43 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpsd_xmm_k1z_xmm_xmmm64_sae = 3020,
	/// `VPLZCNTD xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 44 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vplzcntd_xmm_k1z_xmmm128b32 = 3021,
	/// `VPLZCNTD ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 44 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vplzcntd_ymm_k1z_ymmm256b32 = 3022,
	/// `VPLZCNTD zmm1 {k1}{z}, zmm2/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 44 /r`
	///
	/// `AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vplzcntd_zmm_k1z_zmmm512b32 = 3023,
	/// `VPLZCNTQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 44 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vplzcntq_xmm_k1z_xmmm128b64 = 3024,
	/// `VPLZCNTQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 44 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vplzcntq_ymm_k1z_ymmm256b64 = 3025,
	/// `VPLZCNTQ zmm1 {k1}{z}, zmm2/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 44 /r`
	///
	/// `AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vplzcntq_zmm_k1z_zmmm512b64 = 3026,
	/// `VPSRLVD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 45 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlvd_xmm_xmm_xmmm128 = 3027,
	/// `VPSRLVD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 45 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlvd_ymm_ymm_ymmm256 = 3028,
	/// `VPSRLVQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 45 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlvq_xmm_xmm_xmmm128 = 3029,
	/// `VPSRLVQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 45 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsrlvq_ymm_ymm_ymmm256 = 3030,
	/// `VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 45 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvd_xmm_k1z_xmm_xmmm128b32 = 3031,
	/// `VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 45 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvd_ymm_k1z_ymm_ymmm256b32 = 3032,
	/// `VPSRLVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 45 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvd_zmm_k1z_zmm_zmmm512b32 = 3033,
	/// `VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 45 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvq_xmm_k1z_xmm_xmmm128b64 = 3034,
	/// `VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 45 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvq_ymm_k1z_ymm_ymmm256b64 = 3035,
	/// `VPSRLVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 45 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsrlvq_zmm_k1z_zmm_zmmm512b64 = 3036,
	/// `VPSRAVD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 46 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsravd_xmm_xmm_xmmm128 = 3037,
	/// `VPSRAVD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 46 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsravd_ymm_ymm_ymmm256 = 3038,
	/// `VPSRAVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 46 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravd_xmm_k1z_xmm_xmmm128b32 = 3039,
	/// `VPSRAVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 46 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravd_ymm_k1z_ymm_ymmm256b32 = 3040,
	/// `VPSRAVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 46 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravd_zmm_k1z_zmm_zmmm512b32 = 3041,
	/// `VPSRAVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 46 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravq_xmm_k1z_xmm_xmmm128b64 = 3042,
	/// `VPSRAVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 46 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravq_ymm_k1z_ymm_ymmm256b64 = 3043,
	/// `VPSRAVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 46 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsravq_zmm_k1z_zmm_zmmm512b64 = 3044,
	/// `VPSLLVD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 47 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllvd_xmm_xmm_xmmm128 = 3045,
	/// `VPSLLVD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 47 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllvd_ymm_ymm_ymmm256 = 3046,
	/// `VPSLLVQ xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 47 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllvq_xmm_xmm_xmmm128 = 3047,
	/// `VPSLLVQ ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 47 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpsllvq_ymm_ymm_ymmm256 = 3048,
	/// `VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 47 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvd_xmm_k1z_xmm_xmmm128b32 = 3049,
	/// `VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 47 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvd_ymm_k1z_ymm_ymmm256b32 = 3050,
	/// `VPSLLVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 47 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvd_zmm_k1z_zmm_zmmm512b32 = 3051,
	/// `VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 47 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvq_xmm_k1z_xmm_xmmm128b64 = 3052,
	/// `VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 47 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvq_ymm_k1z_ymm_ymmm256b64 = 3053,
	/// `VPSLLVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 47 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpsllvq_zmm_k1z_zmm_zmmm512b64 = 3054,
	/// `VRCP14PS xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 4C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14ps_xmm_k1z_xmmm128b32 = 3055,
	/// `VRCP14PS ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 4C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14ps_ymm_k1z_ymmm256b32 = 3056,
	/// `VRCP14PS zmm1 {k1}{z}, zmm2/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 4C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14ps_zmm_k1z_zmmm512b32 = 3057,
	/// `VRCP14PD xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 4C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14pd_xmm_k1z_xmmm128b64 = 3058,
	/// `VRCP14PD ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 4C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14pd_ymm_k1z_ymmm256b64 = 3059,
	/// `VRCP14PD zmm1 {k1}{z}, zmm2/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 4C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14pd_zmm_k1z_zmmm512b64 = 3060,
	/// `VRCP14SS xmm1 {k1}{z}, xmm2, xmm3/m32`
	///
	/// `EVEX.LIG.66.0F38.W0 4D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14ss_xmm_k1z_xmm_xmmm32 = 3061,
	/// `VRCP14SD xmm1 {k1}{z}, xmm2, xmm3/m64`
	///
	/// `EVEX.LIG.66.0F38.W1 4D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp14sd_xmm_k1z_xmm_xmmm64 = 3062,
	/// `VRSQRT14PS xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 4E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14ps_xmm_k1z_xmmm128b32 = 3063,
	/// `VRSQRT14PS ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 4E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14ps_ymm_k1z_ymmm256b32 = 3064,
	/// `VRSQRT14PS zmm1 {k1}{z}, zmm2/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 4E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14ps_zmm_k1z_zmmm512b32 = 3065,
	/// `VRSQRT14PD xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 4E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14pd_xmm_k1z_xmmm128b64 = 3066,
	/// `VRSQRT14PD ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 4E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14pd_ymm_k1z_ymmm256b64 = 3067,
	/// `VRSQRT14PD zmm1 {k1}{z}, zmm2/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 4E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14pd_zmm_k1z_zmmm512b64 = 3068,
	/// `VRSQRT14SS xmm1 {k1}{z}, xmm2, xmm3/m32`
	///
	/// `EVEX.LIG.66.0F38.W0 4F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14ss_xmm_k1z_xmm_xmmm32 = 3069,
	/// `VRSQRT14SD xmm1 {k1}{z}, xmm2, xmm3/m64`
	///
	/// `EVEX.LIG.66.0F38.W1 4F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt14sd_xmm_k1z_xmm_xmmm64 = 3070,
	/// `VPDPBUSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 50 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpbusd_xmm_k1z_xmm_xmmm128b32 = 3071,
	/// `VPDPBUSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 50 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpbusd_ymm_k1z_ymm_ymmm256b32 = 3072,
	/// `VPDPBUSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 50 /r`
	///
	/// `AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpbusd_zmm_k1z_zmm_zmmm512b32 = 3073,
	/// `VPDPBUSDS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 51 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpbusds_xmm_k1z_xmm_xmmm128b32 = 3074,
	/// `VPDPBUSDS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 51 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpbusds_ymm_k1z_ymm_ymmm256b32 = 3075,
	/// `VPDPBUSDS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 51 /r`
	///
	/// `AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpbusds_zmm_k1z_zmm_zmmm512b32 = 3076,
	/// `VPDPWSSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 52 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpwssd_xmm_k1z_xmm_xmmm128b32 = 3077,
	/// `VPDPWSSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 52 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpwssd_ymm_k1z_ymm_ymmm256b32 = 3078,
	/// `VPDPWSSD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 52 /r`
	///
	/// `AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpwssd_zmm_k1z_zmm_zmmm512b32 = 3079,
	/// `VDPBF16PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F3.0F38.W0 52 /r`
	///
	/// `AVX512VL and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vdpbf16ps_xmm_k1z_xmm_xmmm128b32 = 3080,
	/// `VDPBF16PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F3.0F38.W0 52 /r`
	///
	/// `AVX512VL and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vdpbf16ps_ymm_k1z_ymm_ymmm256b32 = 3081,
	/// `VDPBF16PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.F3.0F38.W0 52 /r`
	///
	/// `AVX512F and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vdpbf16ps_zmm_k1z_zmm_zmmm512b32 = 3082,
	/// `VP4DPWSSD zmm1 {k1}{z}, zmm2+3, m128`
	///
	/// `EVEX.512.F2.0F38.W0 52 /r`
	///
	/// `AVX512_4VNNIW`
	///
	/// `16/32/64-bit`
	EVEX_Vp4dpwssd_zmm_k1z_zmmp3_m128 = 3083,
	/// `VPDPWSSDS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 53 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpwssds_xmm_k1z_xmm_xmmm128b32 = 3084,
	/// `VPDPWSSDS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 53 /r`
	///
	/// `AVX512VL and AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpwssds_ymm_k1z_ymm_ymmm256b32 = 3085,
	/// `VPDPWSSDS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 53 /r`
	///
	/// `AVX512_VNNI`
	///
	/// `16/32/64-bit`
	EVEX_Vpdpwssds_zmm_k1z_zmm_zmmm512b32 = 3086,
	/// `VP4DPWSSDS zmm1 {k1}{z}, zmm2+3, m128`
	///
	/// `EVEX.512.F2.0F38.W0 53 /r`
	///
	/// `AVX512_4VNNIW`
	///
	/// `16/32/64-bit`
	EVEX_Vp4dpwssds_zmm_k1z_zmmp3_m128 = 3087,
	/// `VPOPCNTB xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W0 54 /r`
	///
	/// `AVX512VL and AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntb_xmm_k1z_xmmm128 = 3088,
	/// `VPOPCNTB ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W0 54 /r`
	///
	/// `AVX512VL and AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntb_ymm_k1z_ymmm256 = 3089,
	/// `VPOPCNTB zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W0 54 /r`
	///
	/// `AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntb_zmm_k1z_zmmm512 = 3090,
	/// `VPOPCNTW xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W1 54 /r`
	///
	/// `AVX512VL and AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntw_xmm_k1z_xmmm128 = 3091,
	/// `VPOPCNTW ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W1 54 /r`
	///
	/// `AVX512VL and AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntw_ymm_k1z_ymmm256 = 3092,
	/// `VPOPCNTW zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W1 54 /r`
	///
	/// `AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntw_zmm_k1z_zmmm512 = 3093,
	/// `VPOPCNTD xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 55 /r`
	///
	/// `AVX512VL and AVX512_VPOPCNTDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntd_xmm_k1z_xmmm128b32 = 3094,
	/// `VPOPCNTD ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 55 /r`
	///
	/// `AVX512VL and AVX512_VPOPCNTDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntd_ymm_k1z_ymmm256b32 = 3095,
	/// `VPOPCNTD zmm1 {k1}{z}, zmm2/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 55 /r`
	///
	/// `AVX512_VPOPCNTDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntd_zmm_k1z_zmmm512b32 = 3096,
	/// `VPOPCNTQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 55 /r`
	///
	/// `AVX512VL and AVX512_VPOPCNTDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntq_xmm_k1z_xmmm128b64 = 3097,
	/// `VPOPCNTQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 55 /r`
	///
	/// `AVX512VL and AVX512_VPOPCNTDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntq_ymm_k1z_ymmm256b64 = 3098,
	/// `VPOPCNTQ zmm1 {k1}{z}, zmm2/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 55 /r`
	///
	/// `AVX512_VPOPCNTDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpopcntq_zmm_k1z_zmmm512b64 = 3099,
	/// `VPBROADCASTD xmm1, xmm2/m32`
	///
	/// `VEX.128.66.0F38.W0 58 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastd_xmm_xmmm32 = 3100,
	/// `VPBROADCASTD ymm1, xmm2/m32`
	///
	/// `VEX.256.66.0F38.W0 58 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastd_ymm_xmmm32 = 3101,
	/// `VPBROADCASTD xmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.128.66.0F38.W0 58 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastd_xmm_k1z_xmmm32 = 3102,
	/// `VPBROADCASTD ymm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.256.66.0F38.W0 58 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastd_ymm_k1z_xmmm32 = 3103,
	/// `VPBROADCASTD zmm1 {k1}{z}, xmm2/m32`
	///
	/// `EVEX.512.66.0F38.W0 58 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastd_zmm_k1z_xmmm32 = 3104,
	/// `VPBROADCASTQ xmm1, xmm2/m64`
	///
	/// `VEX.128.66.0F38.W0 59 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastq_xmm_xmmm64 = 3105,
	/// `VPBROADCASTQ ymm1, xmm2/m64`
	///
	/// `VEX.256.66.0F38.W0 59 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastq_ymm_xmmm64 = 3106,
	/// `VBROADCASTI32X2 xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.W0 59 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti32x2_xmm_k1z_xmmm64 = 3107,
	/// `VBROADCASTI32X2 ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.W0 59 /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti32x2_ymm_k1z_xmmm64 = 3108,
	/// `VBROADCASTI32X2 zmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.512.66.0F38.W0 59 /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti32x2_zmm_k1z_xmmm64 = 3109,
	/// `VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.128.66.0F38.W1 59 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastq_xmm_k1z_xmmm64 = 3110,
	/// `VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.256.66.0F38.W1 59 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastq_ymm_k1z_xmmm64 = 3111,
	/// `VPBROADCASTQ zmm1 {k1}{z}, xmm2/m64`
	///
	/// `EVEX.512.66.0F38.W1 59 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastq_zmm_k1z_xmmm64 = 3112,
	/// `VBROADCASTI128 ymm1, m128`
	///
	/// `VEX.256.66.0F38.W0 5A /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcasti128_ymm_m128 = 3113,
	/// `VBROADCASTI32X4 ymm1 {k1}{z}, m128`
	///
	/// `EVEX.256.66.0F38.W0 5A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti32x4_ymm_k1z_m128 = 3114,
	/// `VBROADCASTI32X4 zmm1 {k1}{z}, m128`
	///
	/// `EVEX.512.66.0F38.W0 5A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti32x4_zmm_k1z_m128 = 3115,
	/// `VBROADCASTI64X2 ymm1 {k1}{z}, m128`
	///
	/// `EVEX.256.66.0F38.W1 5A /r`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti64x2_ymm_k1z_m128 = 3116,
	/// `VBROADCASTI64X2 zmm1 {k1}{z}, m128`
	///
	/// `EVEX.512.66.0F38.W1 5A /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti64x2_zmm_k1z_m128 = 3117,
	/// `VBROADCASTI32X8 zmm1 {k1}{z}, m256`
	///
	/// `EVEX.512.66.0F38.W0 5B /r`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti32x8_zmm_k1z_m256 = 3118,
	/// `VBROADCASTI64X4 zmm1 {k1}{z}, m256`
	///
	/// `EVEX.512.66.0F38.W1 5B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vbroadcasti64x4_zmm_k1z_m256 = 3119,
	/// `VPEXPANDB xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W0 62 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandb_xmm_k1z_xmmm128 = 3120,
	/// `VPEXPANDB ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W0 62 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandb_ymm_k1z_ymmm256 = 3121,
	/// `VPEXPANDB zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W0 62 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandb_zmm_k1z_zmmm512 = 3122,
	/// `VPEXPANDW xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W1 62 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandw_xmm_k1z_xmmm128 = 3123,
	/// `VPEXPANDW ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W1 62 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandw_ymm_k1z_ymmm256 = 3124,
	/// `VPEXPANDW zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W1 62 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandw_zmm_k1z_zmmm512 = 3125,
	/// `VPCOMPRESSB xmm1/m128 {k1}{z}, xmm2`
	///
	/// `EVEX.128.66.0F38.W0 63 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressb_xmmm128_k1z_xmm = 3126,
	/// `VPCOMPRESSB ymm1/m256 {k1}{z}, ymm2`
	///
	/// `EVEX.256.66.0F38.W0 63 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressb_ymmm256_k1z_ymm = 3127,
	/// `VPCOMPRESSB zmm1/m512 {k1}{z}, zmm2`
	///
	/// `EVEX.512.66.0F38.W0 63 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressb_zmmm512_k1z_zmm = 3128,
	/// `VPCOMPRESSW xmm1/m128 {k1}{z}, xmm2`
	///
	/// `EVEX.128.66.0F38.W1 63 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressw_xmmm128_k1z_xmm = 3129,
	/// `VPCOMPRESSW ymm1/m256 {k1}{z}, ymm2`
	///
	/// `EVEX.256.66.0F38.W1 63 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressw_ymmm256_k1z_ymm = 3130,
	/// `VPCOMPRESSW zmm1/m512 {k1}{z}, zmm2`
	///
	/// `EVEX.512.66.0F38.W1 63 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressw_zmmm512_k1z_zmm = 3131,
	/// `VPBLENDMD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 64 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmd_xmm_k1z_xmm_xmmm128b32 = 3132,
	/// `VPBLENDMD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 64 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmd_ymm_k1z_ymm_ymmm256b32 = 3133,
	/// `VPBLENDMD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 64 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmd_zmm_k1z_zmm_zmmm512b32 = 3134,
	/// `VPBLENDMQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 64 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmq_xmm_k1z_xmm_xmmm128b64 = 3135,
	/// `VPBLENDMQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 64 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmq_ymm_k1z_ymm_ymmm256b64 = 3136,
	/// `VPBLENDMQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 64 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmq_zmm_k1z_zmm_zmmm512b64 = 3137,
	/// `VBLENDMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 65 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vblendmps_xmm_k1z_xmm_xmmm128b32 = 3138,
	/// `VBLENDMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 65 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vblendmps_ymm_k1z_ymm_ymmm256b32 = 3139,
	/// `VBLENDMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 65 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vblendmps_zmm_k1z_zmm_zmmm512b32 = 3140,
	/// `VBLENDMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 65 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vblendmpd_xmm_k1z_xmm_xmmm128b64 = 3141,
	/// `VBLENDMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 65 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vblendmpd_ymm_k1z_ymm_ymmm256b64 = 3142,
	/// `VBLENDMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 65 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vblendmpd_zmm_k1z_zmm_zmmm512b64 = 3143,
	/// `VPBLENDMB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W0 66 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmb_xmm_k1z_xmm_xmmm128 = 3144,
	/// `VPBLENDMB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W0 66 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmb_ymm_k1z_ymm_ymmm256 = 3145,
	/// `VPBLENDMB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W0 66 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmb_zmm_k1z_zmm_zmmm512 = 3146,
	/// `VPBLENDMW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 66 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmw_xmm_k1z_xmm_xmmm128 = 3147,
	/// `VPBLENDMW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 66 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmw_ymm_k1z_ymm_ymmm256 = 3148,
	/// `VPBLENDMW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 66 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpblendmw_zmm_k1z_zmm_zmmm512 = 3149,
	/// `VP2INTERSECTD k1+1, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F2.0F38.W0 68 /r`
	///
	/// `AVX512VL and AVX512_VP2INTERSECT`
	///
	/// `16/32/64-bit`
	EVEX_Vp2intersectd_kp1_xmm_xmmm128b32 = 3150,
	/// `VP2INTERSECTD k1+1, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F2.0F38.W0 68 /r`
	///
	/// `AVX512VL and AVX512_VP2INTERSECT`
	///
	/// `16/32/64-bit`
	EVEX_Vp2intersectd_kp1_ymm_ymmm256b32 = 3151,
	/// `VP2INTERSECTD k1+1, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.F2.0F38.W0 68 /r`
	///
	/// `AVX512F and AVX512_VP2INTERSECT`
	///
	/// `16/32/64-bit`
	EVEX_Vp2intersectd_kp1_zmm_zmmm512b32 = 3152,
	/// `VP2INTERSECTQ k1+1, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.F2.0F38.W1 68 /r`
	///
	/// `AVX512VL and AVX512_VP2INTERSECT`
	///
	/// `16/32/64-bit`
	EVEX_Vp2intersectq_kp1_xmm_xmmm128b64 = 3153,
	/// `VP2INTERSECTQ k1+1, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.F2.0F38.W1 68 /r`
	///
	/// `AVX512VL and AVX512_VP2INTERSECT`
	///
	/// `16/32/64-bit`
	EVEX_Vp2intersectq_kp1_ymm_ymmm256b64 = 3154,
	/// `VP2INTERSECTQ k1+1, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.F2.0F38.W1 68 /r`
	///
	/// `AVX512F and AVX512_VP2INTERSECT`
	///
	/// `16/32/64-bit`
	EVEX_Vp2intersectq_kp1_zmm_zmmm512b64 = 3155,
	/// `VPSHLDVW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 70 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvw_xmm_k1z_xmm_xmmm128 = 3156,
	/// `VPSHLDVW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 70 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvw_ymm_k1z_ymm_ymmm256 = 3157,
	/// `VPSHLDVW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 70 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvw_zmm_k1z_zmm_zmmm512 = 3158,
	/// `VPSHLDVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 71 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvd_xmm_k1z_xmm_xmmm128b32 = 3159,
	/// `VPSHLDVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 71 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvd_ymm_k1z_ymm_ymmm256b32 = 3160,
	/// `VPSHLDVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 71 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvd_zmm_k1z_zmm_zmmm512b32 = 3161,
	/// `VPSHLDVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 71 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvq_xmm_k1z_xmm_xmmm128b64 = 3162,
	/// `VPSHLDVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 71 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvq_ymm_k1z_ymm_ymmm256b64 = 3163,
	/// `VPSHLDVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 71 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldvq_zmm_k1z_zmm_zmmm512b64 = 3164,
	/// `VPSHRDVW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 72 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvw_xmm_k1z_xmm_xmmm128 = 3165,
	/// `VPSHRDVW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 72 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvw_ymm_k1z_ymm_ymmm256 = 3166,
	/// `VPSHRDVW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 72 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvw_zmm_k1z_zmm_zmmm512 = 3167,
	/// `VCVTNEPS2BF16 xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.F3.0F38.W0 72 /r`
	///
	/// `AVX512VL and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtneps2bf16_xmm_k1z_xmmm128b32 = 3168,
	/// `VCVTNEPS2BF16 xmm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.F3.0F38.W0 72 /r`
	///
	/// `AVX512VL and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtneps2bf16_xmm_k1z_ymmm256b32 = 3169,
	/// `VCVTNEPS2BF16 ymm1 {k1}{z}, zmm2/m512/m32bcst`
	///
	/// `EVEX.512.F3.0F38.W0 72 /r`
	///
	/// `AVX512F and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtneps2bf16_ymm_k1z_zmmm512b32 = 3170,
	/// `VCVTNE2PS2BF16 xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F2.0F38.W0 72 /r`
	///
	/// `AVX512VL and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtne2ps2bf16_xmm_k1z_xmm_xmmm128b32 = 3171,
	/// `VCVTNE2PS2BF16 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F2.0F38.W0 72 /r`
	///
	/// `AVX512VL and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtne2ps2bf16_ymm_k1z_ymm_ymmm256b32 = 3172,
	/// `VCVTNE2PS2BF16 zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.F2.0F38.W0 72 /r`
	///
	/// `AVX512F and AVX512_BF16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtne2ps2bf16_zmm_k1z_zmm_zmmm512b32 = 3173,
	/// `VPSHRDVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 73 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvd_xmm_k1z_xmm_xmmm128b32 = 3174,
	/// `VPSHRDVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 73 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvd_ymm_k1z_ymm_ymmm256b32 = 3175,
	/// `VPSHRDVD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 73 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvd_zmm_k1z_zmm_zmmm512b32 = 3176,
	/// `VPSHRDVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 73 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvq_xmm_k1z_xmm_xmmm128b64 = 3177,
	/// `VPSHRDVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 73 /r`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvq_ymm_k1z_ymm_ymmm256b64 = 3178,
	/// `VPSHRDVQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 73 /r`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdvq_zmm_k1z_zmm_zmmm512b64 = 3179,
	/// `VPERMI2B xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W0 75 /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2b_xmm_k1z_xmm_xmmm128 = 3180,
	/// `VPERMI2B ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W0 75 /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2b_ymm_k1z_ymm_ymmm256 = 3181,
	/// `VPERMI2B zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W0 75 /r`
	///
	/// `AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2b_zmm_k1z_zmm_zmmm512 = 3182,
	/// `VPERMI2W xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 75 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2w_xmm_k1z_xmm_xmmm128 = 3183,
	/// `VPERMI2W ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 75 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2w_ymm_k1z_ymm_ymmm256 = 3184,
	/// `VPERMI2W zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 75 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2w_zmm_k1z_zmm_zmmm512 = 3185,
	/// `VPERMI2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 76 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2d_xmm_k1z_xmm_xmmm128b32 = 3186,
	/// `VPERMI2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 76 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2d_ymm_k1z_ymm_ymmm256b32 = 3187,
	/// `VPERMI2D zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 76 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2d_zmm_k1z_zmm_zmmm512b32 = 3188,
	/// `VPERMI2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 76 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2q_xmm_k1z_xmm_xmmm128b64 = 3189,
	/// `VPERMI2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 76 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2q_ymm_k1z_ymm_ymmm256b64 = 3190,
	/// `VPERMI2Q zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 76 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2q_zmm_k1z_zmm_zmmm512b64 = 3191,
	/// `VPERMI2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 77 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2ps_xmm_k1z_xmm_xmmm128b32 = 3192,
	/// `VPERMI2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 77 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2ps_ymm_k1z_ymm_ymmm256b32 = 3193,
	/// `VPERMI2PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 77 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2ps_zmm_k1z_zmm_zmmm512b32 = 3194,
	/// `VPERMI2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 77 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2pd_xmm_k1z_xmm_xmmm128b64 = 3195,
	/// `VPERMI2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 77 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2pd_ymm_k1z_ymm_ymmm256b64 = 3196,
	/// `VPERMI2PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 77 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermi2pd_zmm_k1z_zmm_zmmm512b64 = 3197,
	/// `VPBROADCASTB xmm1, xmm2/m8`
	///
	/// `VEX.128.66.0F38.W0 78 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastb_xmm_xmmm8 = 3198,
	/// `VPBROADCASTB ymm1, xmm2/m8`
	///
	/// `VEX.256.66.0F38.W0 78 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastb_ymm_xmmm8 = 3199,
	/// `VPBROADCASTB xmm1 {k1}{z}, xmm2/m8`
	///
	/// `EVEX.128.66.0F38.W0 78 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastb_xmm_k1z_xmmm8 = 3200,
	/// `VPBROADCASTB ymm1 {k1}{z}, xmm2/m8`
	///
	/// `EVEX.256.66.0F38.W0 78 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastb_ymm_k1z_xmmm8 = 3201,
	/// `VPBROADCASTB zmm1 {k1}{z}, xmm2/m8`
	///
	/// `EVEX.512.66.0F38.W0 78 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastb_zmm_k1z_xmmm8 = 3202,
	/// `VPBROADCASTW xmm1, xmm2/m16`
	///
	/// `VEX.128.66.0F38.W0 79 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastw_xmm_xmmm16 = 3203,
	/// `VPBROADCASTW ymm1, xmm2/m16`
	///
	/// `VEX.256.66.0F38.W0 79 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpbroadcastw_ymm_xmmm16 = 3204,
	/// `VPBROADCASTW xmm1 {k1}{z}, xmm2/m16`
	///
	/// `EVEX.128.66.0F38.W0 79 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastw_xmm_k1z_xmmm16 = 3205,
	/// `VPBROADCASTW ymm1 {k1}{z}, xmm2/m16`
	///
	/// `EVEX.256.66.0F38.W0 79 /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastw_ymm_k1z_xmmm16 = 3206,
	/// `VPBROADCASTW zmm1 {k1}{z}, xmm2/m16`
	///
	/// `EVEX.512.66.0F38.W0 79 /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastw_zmm_k1z_xmmm16 = 3207,
	/// `VPBROADCASTB xmm1 {k1}{z}, r32`
	///
	/// `EVEX.128.66.0F38.W0 7A /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastb_xmm_k1z_r32 = 3208,
	/// `VPBROADCASTB ymm1 {k1}{z}, r32`
	///
	/// `EVEX.256.66.0F38.W0 7A /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastb_ymm_k1z_r32 = 3209,
	/// `VPBROADCASTB zmm1 {k1}{z}, r32`
	///
	/// `EVEX.512.66.0F38.W0 7A /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastb_zmm_k1z_r32 = 3210,
	/// `VPBROADCASTW xmm1 {k1}{z}, r32`
	///
	/// `EVEX.128.66.0F38.W0 7B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastw_xmm_k1z_r32 = 3211,
	/// `VPBROADCASTW ymm1 {k1}{z}, r32`
	///
	/// `EVEX.256.66.0F38.W0 7B /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastw_ymm_k1z_r32 = 3212,
	/// `VPBROADCASTW zmm1 {k1}{z}, r32`
	///
	/// `EVEX.512.66.0F38.W0 7B /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastw_zmm_k1z_r32 = 3213,
	/// `VPBROADCASTD xmm1 {k1}{z}, r32`
	///
	/// `EVEX.128.66.0F38.W0 7C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastd_xmm_k1z_r32 = 3214,
	/// `VPBROADCASTD ymm1 {k1}{z}, r32`
	///
	/// `EVEX.256.66.0F38.W0 7C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastd_ymm_k1z_r32 = 3215,
	/// `VPBROADCASTD zmm1 {k1}{z}, r32`
	///
	/// `EVEX.512.66.0F38.W0 7C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpbroadcastd_zmm_k1z_r32 = 3216,
	/// `VPBROADCASTQ xmm1 {k1}{z}, r64`
	///
	/// `EVEX.128.66.0F38.W1 7C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `64-bit`
	EVEX_Vpbroadcastq_xmm_k1z_r64 = 3217,
	/// `VPBROADCASTQ ymm1 {k1}{z}, r64`
	///
	/// `EVEX.256.66.0F38.W1 7C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `64-bit`
	EVEX_Vpbroadcastq_ymm_k1z_r64 = 3218,
	/// `VPBROADCASTQ zmm1 {k1}{z}, r64`
	///
	/// `EVEX.512.66.0F38.W1 7C /r`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vpbroadcastq_zmm_k1z_r64 = 3219,
	/// `VPERMT2B xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W0 7D /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2b_xmm_k1z_xmm_xmmm128 = 3220,
	/// `VPERMT2B ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W0 7D /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2b_ymm_k1z_ymm_ymmm256 = 3221,
	/// `VPERMT2B zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W0 7D /r`
	///
	/// `AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2b_zmm_k1z_zmm_zmmm512 = 3222,
	/// `VPERMT2W xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 7D /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2w_xmm_k1z_xmm_xmmm128 = 3223,
	/// `VPERMT2W ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 7D /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2w_ymm_k1z_ymm_ymmm256 = 3224,
	/// `VPERMT2W zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 7D /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2w_zmm_k1z_zmm_zmmm512 = 3225,
	/// `VPERMT2D xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 7E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2d_xmm_k1z_xmm_xmmm128b32 = 3226,
	/// `VPERMT2D ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 7E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2d_ymm_k1z_ymm_ymmm256b32 = 3227,
	/// `VPERMT2D zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 7E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2d_zmm_k1z_zmm_zmmm512b32 = 3228,
	/// `VPERMT2Q xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 7E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2q_xmm_k1z_xmm_xmmm128b64 = 3229,
	/// `VPERMT2Q ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 7E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2q_ymm_k1z_ymm_ymmm256b64 = 3230,
	/// `VPERMT2Q zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 7E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2q_zmm_k1z_zmm_zmmm512b64 = 3231,
	/// `VPERMT2PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2ps_xmm_k1z_xmm_xmmm128b32 = 3232,
	/// `VPERMT2PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2ps_ymm_k1z_ymm_ymmm256b32 = 3233,
	/// `VPERMT2PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 7F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2ps_zmm_k1z_zmm_zmmm512b32 = 3234,
	/// `VPERMT2PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2pd_xmm_k1z_xmm_xmmm128b64 = 3235,
	/// `VPERMT2PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 7F /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2pd_ymm_k1z_ymm_ymmm256b64 = 3236,
	/// `VPERMT2PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 7F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermt2pd_zmm_k1z_zmm_zmmm512b64 = 3237,
	/// `INVEPT r32, m128`
	///
	/// `66 0F 38 80 /r`
	///
	/// `VMX and IA32_VMX_EPT_VPID_CAP[bit 20]`
	///
	/// `16/32-bit`
	Invept_r32_m128 = 3238,
	/// `INVEPT r64, m128`
	///
	/// `66 0F 38 80 /r`
	///
	/// `VMX and IA32_VMX_EPT_VPID_CAP[bit 20]`
	///
	/// `64-bit`
	Invept_r64_m128 = 3239,
	/// `INVVPID r32, m128`
	///
	/// `66 0F 38 81 /r`
	///
	/// `VMX and IA32_VMX_EPT_VPID_CAP[bit 32]`
	///
	/// `16/32-bit`
	Invvpid_r32_m128 = 3240,
	/// `INVVPID r64, m128`
	///
	/// `66 0F 38 81 /r`
	///
	/// `VMX and IA32_VMX_EPT_VPID_CAP[bit 32]`
	///
	/// `64-bit`
	Invvpid_r64_m128 = 3241,
	/// `INVPCID r32, m128`
	///
	/// `66 0F 38 82 /r`
	///
	/// `INVPCID`
	///
	/// `16/32-bit`
	Invpcid_r32_m128 = 3242,
	/// `INVPCID r64, m128`
	///
	/// `66 0F 38 82 /r`
	///
	/// `INVPCID`
	///
	/// `64-bit`
	Invpcid_r64_m128 = 3243,
	/// `VPMULTISHIFTQB xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 83 /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpmultishiftqb_xmm_k1z_xmm_xmmm128b64 = 3244,
	/// `VPMULTISHIFTQB ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 83 /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpmultishiftqb_ymm_k1z_ymm_ymmm256b64 = 3245,
	/// `VPMULTISHIFTQB zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 83 /r`
	///
	/// `AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpmultishiftqb_zmm_k1z_zmm_zmmm512b64 = 3246,
	/// `VEXPANDPS xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W0 88 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vexpandps_xmm_k1z_xmmm128 = 3247,
	/// `VEXPANDPS ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W0 88 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vexpandps_ymm_k1z_ymmm256 = 3248,
	/// `VEXPANDPS zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W0 88 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vexpandps_zmm_k1z_zmmm512 = 3249,
	/// `VEXPANDPD xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W1 88 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vexpandpd_xmm_k1z_xmmm128 = 3250,
	/// `VEXPANDPD ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W1 88 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vexpandpd_ymm_k1z_ymmm256 = 3251,
	/// `VEXPANDPD zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W1 88 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vexpandpd_zmm_k1z_zmmm512 = 3252,
	/// `VPEXPANDD xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W0 89 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandd_xmm_k1z_xmmm128 = 3253,
	/// `VPEXPANDD ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W0 89 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandd_ymm_k1z_ymmm256 = 3254,
	/// `VPEXPANDD zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W0 89 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandd_zmm_k1z_zmmm512 = 3255,
	/// `VPEXPANDQ xmm1 {k1}{z}, xmm2/m128`
	///
	/// `EVEX.128.66.0F38.W1 89 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandq_xmm_k1z_xmmm128 = 3256,
	/// `VPEXPANDQ ymm1 {k1}{z}, ymm2/m256`
	///
	/// `EVEX.256.66.0F38.W1 89 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandq_ymm_k1z_ymmm256 = 3257,
	/// `VPEXPANDQ zmm1 {k1}{z}, zmm2/m512`
	///
	/// `EVEX.512.66.0F38.W1 89 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpexpandq_zmm_k1z_zmmm512 = 3258,
	/// `VCOMPRESSPS xmm1/m128 {k1}{z}, xmm2`
	///
	/// `EVEX.128.66.0F38.W0 8A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcompressps_xmmm128_k1z_xmm = 3259,
	/// `VCOMPRESSPS ymm1/m256 {k1}{z}, ymm2`
	///
	/// `EVEX.256.66.0F38.W0 8A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcompressps_ymmm256_k1z_ymm = 3260,
	/// `VCOMPRESSPS zmm1/m512 {k1}{z}, zmm2`
	///
	/// `EVEX.512.66.0F38.W0 8A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcompressps_zmmm512_k1z_zmm = 3261,
	/// `VCOMPRESSPD xmm1/m128 {k1}{z}, xmm2`
	///
	/// `EVEX.128.66.0F38.W1 8A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcompresspd_xmmm128_k1z_xmm = 3262,
	/// `VCOMPRESSPD ymm1/m256 {k1}{z}, ymm2`
	///
	/// `EVEX.256.66.0F38.W1 8A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcompresspd_ymmm256_k1z_ymm = 3263,
	/// `VCOMPRESSPD zmm1/m512 {k1}{z}, zmm2`
	///
	/// `EVEX.512.66.0F38.W1 8A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcompresspd_zmmm512_k1z_zmm = 3264,
	/// `VPCOMPRESSD xmm1/m128 {k1}{z}, xmm2`
	///
	/// `EVEX.128.66.0F38.W0 8B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressd_xmmm128_k1z_xmm = 3265,
	/// `VPCOMPRESSD ymm1/m256 {k1}{z}, ymm2`
	///
	/// `EVEX.256.66.0F38.W0 8B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressd_ymmm256_k1z_ymm = 3266,
	/// `VPCOMPRESSD zmm1/m512 {k1}{z}, zmm2`
	///
	/// `EVEX.512.66.0F38.W0 8B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressd_zmmm512_k1z_zmm = 3267,
	/// `VPCOMPRESSQ xmm1/m128 {k1}{z}, xmm2`
	///
	/// `EVEX.128.66.0F38.W1 8B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressq_xmmm128_k1z_xmm = 3268,
	/// `VPCOMPRESSQ ymm1/m256 {k1}{z}, ymm2`
	///
	/// `EVEX.256.66.0F38.W1 8B /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressq_ymmm256_k1z_ymm = 3269,
	/// `VPCOMPRESSQ zmm1/m512 {k1}{z}, zmm2`
	///
	/// `EVEX.512.66.0F38.W1 8B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcompressq_zmmm512_k1z_zmm = 3270,
	/// `VPMASKMOVD xmm1, xmm2, m128`
	///
	/// `VEX.128.66.0F38.W0 8C /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovd_xmm_xmm_m128 = 3271,
	/// `VPMASKMOVD ymm1, ymm2, m256`
	///
	/// `VEX.256.66.0F38.W0 8C /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovd_ymm_ymm_m256 = 3272,
	/// `VPMASKMOVQ xmm1, xmm2, m128`
	///
	/// `VEX.128.66.0F38.W1 8C /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovq_xmm_xmm_m128 = 3273,
	/// `VPMASKMOVQ ymm1, ymm2, m256`
	///
	/// `VEX.256.66.0F38.W1 8C /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovq_ymm_ymm_m256 = 3274,
	/// `VPERMB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W0 8D /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermb_xmm_k1z_xmm_xmmm128 = 3275,
	/// `VPERMB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W0 8D /r`
	///
	/// `AVX512VL and AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermb_ymm_k1z_ymm_ymmm256 = 3276,
	/// `VPERMB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W0 8D /r`
	///
	/// `AVX512_VBMI`
	///
	/// `16/32/64-bit`
	EVEX_Vpermb_zmm_k1z_zmm_zmmm512 = 3277,
	/// `VPERMW xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W1 8D /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermw_xmm_k1z_xmm_xmmm128 = 3278,
	/// `VPERMW ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W1 8D /r`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermw_ymm_k1z_ymm_ymmm256 = 3279,
	/// `VPERMW zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W1 8D /r`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpermw_zmm_k1z_zmm_zmmm512 = 3280,
	/// `VPMASKMOVD m128, xmm1, xmm2`
	///
	/// `VEX.128.66.0F38.W0 8E /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovd_m128_xmm_xmm = 3281,
	/// `VPMASKMOVD m256, ymm1, ymm2`
	///
	/// `VEX.256.66.0F38.W0 8E /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovd_m256_ymm_ymm = 3282,
	/// `VPMASKMOVQ m128, xmm1, xmm2`
	///
	/// `VEX.128.66.0F38.W1 8E /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovq_m128_xmm_xmm = 3283,
	/// `VPMASKMOVQ m256, ymm1, ymm2`
	///
	/// `VEX.256.66.0F38.W1 8E /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpmaskmovq_m256_ymm_ymm = 3284,
	/// `VPSHUFBITQMB k1 {k2}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W0 8F /r`
	///
	/// `AVX512VL and AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufbitqmb_kr_k1_xmm_xmmm128 = 3285,
	/// `VPSHUFBITQMB k1 {k2}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W0 8F /r`
	///
	/// `AVX512VL and AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufbitqmb_kr_k1_ymm_ymmm256 = 3286,
	/// `VPSHUFBITQMB k1 {k2}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W0 8F /r`
	///
	/// `AVX512_BITALG`
	///
	/// `16/32/64-bit`
	EVEX_Vpshufbitqmb_kr_k1_zmm_zmmm512 = 3287,
	/// `VPGATHERDD xmm1, vm32x, xmm2`
	///
	/// `VEX.128.66.0F38.W0 90 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherdd_xmm_vm32x_xmm = 3288,
	/// `VPGATHERDD ymm1, vm32y, ymm2`
	///
	/// `VEX.256.66.0F38.W0 90 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherdd_ymm_vm32y_ymm = 3289,
	/// `VPGATHERDQ xmm1, vm32x, xmm2`
	///
	/// `VEX.128.66.0F38.W1 90 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherdq_xmm_vm32x_xmm = 3290,
	/// `VPGATHERDQ ymm1, vm32x, ymm2`
	///
	/// `VEX.256.66.0F38.W1 90 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherdq_ymm_vm32x_ymm = 3291,
	/// `VPGATHERDD xmm1 {k1}, vm32x`
	///
	/// `EVEX.128.66.0F38.W0 90 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherdd_xmm_k1_vm32x = 3292,
	/// `VPGATHERDD ymm1 {k1}, vm32y`
	///
	/// `EVEX.256.66.0F38.W0 90 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherdd_ymm_k1_vm32y = 3293,
	/// `VPGATHERDD zmm1 {k1}, vm32z`
	///
	/// `EVEX.512.66.0F38.W0 90 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherdd_zmm_k1_vm32z = 3294,
	/// `VPGATHERDQ xmm1 {k1}, vm32x`
	///
	/// `EVEX.128.66.0F38.W1 90 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherdq_xmm_k1_vm32x = 3295,
	/// `VPGATHERDQ ymm1 {k1}, vm32x`
	///
	/// `EVEX.256.66.0F38.W1 90 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherdq_ymm_k1_vm32x = 3296,
	/// `VPGATHERDQ zmm1 {k1}, vm32y`
	///
	/// `EVEX.512.66.0F38.W1 90 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherdq_zmm_k1_vm32y = 3297,
	/// `VPGATHERQD xmm1, vm64x, xmm2`
	///
	/// `VEX.128.66.0F38.W0 91 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherqd_xmm_vm64x_xmm = 3298,
	/// `VPGATHERQD xmm1, vm64y, xmm2`
	///
	/// `VEX.256.66.0F38.W0 91 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherqd_xmm_vm64y_xmm = 3299,
	/// `VPGATHERQQ xmm1, vm64x, xmm2`
	///
	/// `VEX.128.66.0F38.W1 91 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherqq_xmm_vm64x_xmm = 3300,
	/// `VPGATHERQQ ymm1, vm64y, ymm2`
	///
	/// `VEX.256.66.0F38.W1 91 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpgatherqq_ymm_vm64y_ymm = 3301,
	/// `VPGATHERQD xmm1 {k1}, vm64x`
	///
	/// `EVEX.128.66.0F38.W0 91 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherqd_xmm_k1_vm64x = 3302,
	/// `VPGATHERQD xmm1 {k1}, vm64y`
	///
	/// `EVEX.256.66.0F38.W0 91 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherqd_xmm_k1_vm64y = 3303,
	/// `VPGATHERQD ymm1 {k1}, vm64z`
	///
	/// `EVEX.512.66.0F38.W0 91 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherqd_ymm_k1_vm64z = 3304,
	/// `VPGATHERQQ xmm1 {k1}, vm64x`
	///
	/// `EVEX.128.66.0F38.W1 91 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherqq_xmm_k1_vm64x = 3305,
	/// `VPGATHERQQ ymm1 {k1}, vm64y`
	///
	/// `EVEX.256.66.0F38.W1 91 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherqq_ymm_k1_vm64y = 3306,
	/// `VPGATHERQQ zmm1 {k1}, vm64z`
	///
	/// `EVEX.512.66.0F38.W1 91 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpgatherqq_zmm_k1_vm64z = 3307,
	/// `VGATHERDPS xmm1, vm32x, xmm2`
	///
	/// `VEX.128.66.0F38.W0 92 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherdps_xmm_vm32x_xmm = 3308,
	/// `VGATHERDPS ymm1, vm32y, ymm2`
	///
	/// `VEX.256.66.0F38.W0 92 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherdps_ymm_vm32y_ymm = 3309,
	/// `VGATHERDPD xmm1, vm32x, xmm2`
	///
	/// `VEX.128.66.0F38.W1 92 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherdpd_xmm_vm32x_xmm = 3310,
	/// `VGATHERDPD ymm1, vm32x, ymm2`
	///
	/// `VEX.256.66.0F38.W1 92 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherdpd_ymm_vm32x_ymm = 3311,
	/// `VGATHERDPS xmm1 {k1}, vm32x`
	///
	/// `EVEX.128.66.0F38.W0 92 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherdps_xmm_k1_vm32x = 3312,
	/// `VGATHERDPS ymm1 {k1}, vm32y`
	///
	/// `EVEX.256.66.0F38.W0 92 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherdps_ymm_k1_vm32y = 3313,
	/// `VGATHERDPS zmm1 {k1}, vm32z`
	///
	/// `EVEX.512.66.0F38.W0 92 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherdps_zmm_k1_vm32z = 3314,
	/// `VGATHERDPD xmm1 {k1}, vm32x`
	///
	/// `EVEX.128.66.0F38.W1 92 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherdpd_xmm_k1_vm32x = 3315,
	/// `VGATHERDPD ymm1 {k1}, vm32x`
	///
	/// `EVEX.256.66.0F38.W1 92 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherdpd_ymm_k1_vm32x = 3316,
	/// `VGATHERDPD zmm1 {k1}, vm32y`
	///
	/// `EVEX.512.66.0F38.W1 92 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherdpd_zmm_k1_vm32y = 3317,
	/// `VGATHERQPS xmm1, vm64x, xmm2`
	///
	/// `VEX.128.66.0F38.W0 93 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherqps_xmm_vm64x_xmm = 3318,
	/// `VGATHERQPS xmm1, vm64y, xmm2`
	///
	/// `VEX.256.66.0F38.W0 93 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherqps_xmm_vm64y_xmm = 3319,
	/// `VGATHERQPD xmm1, vm64x, xmm2`
	///
	/// `VEX.128.66.0F38.W1 93 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherqpd_xmm_vm64x_xmm = 3320,
	/// `VGATHERQPD ymm1, vm64y, ymm2`
	///
	/// `VEX.256.66.0F38.W1 93 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vgatherqpd_ymm_vm64y_ymm = 3321,
	/// `VGATHERQPS xmm1 {k1}, vm64x`
	///
	/// `EVEX.128.66.0F38.W0 93 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherqps_xmm_k1_vm64x = 3322,
	/// `VGATHERQPS xmm1 {k1}, vm64y`
	///
	/// `EVEX.256.66.0F38.W0 93 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherqps_xmm_k1_vm64y = 3323,
	/// `VGATHERQPS ymm1 {k1}, vm64z`
	///
	/// `EVEX.512.66.0F38.W0 93 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherqps_ymm_k1_vm64z = 3324,
	/// `VGATHERQPD xmm1 {k1}, vm64x`
	///
	/// `EVEX.128.66.0F38.W1 93 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherqpd_xmm_k1_vm64x = 3325,
	/// `VGATHERQPD ymm1 {k1}, vm64y`
	///
	/// `EVEX.256.66.0F38.W1 93 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherqpd_ymm_k1_vm64y = 3326,
	/// `VGATHERQPD zmm1 {k1}, vm64z`
	///
	/// `EVEX.512.66.0F38.W1 93 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherqpd_zmm_k1_vm64z = 3327,
	/// `VFMADDSUB132PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 96 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub132ps_xmm_xmm_xmmm128 = 3328,
	/// `VFMADDSUB132PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 96 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub132ps_ymm_ymm_ymmm256 = 3329,
	/// `VFMADDSUB132PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 96 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub132pd_xmm_xmm_xmmm128 = 3330,
	/// `VFMADDSUB132PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 96 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub132pd_ymm_ymm_ymmm256 = 3331,
	/// `VFMADDSUB132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 96 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132ps_xmm_k1z_xmm_xmmm128b32 = 3332,
	/// `VFMADDSUB132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 96 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132ps_ymm_k1z_ymm_ymmm256b32 = 3333,
	/// `VFMADDSUB132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 96 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132ps_zmm_k1z_zmm_zmmm512b32_er = 3334,
	/// `VFMADDSUB132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 96 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132pd_xmm_k1z_xmm_xmmm128b64 = 3335,
	/// `VFMADDSUB132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 96 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132pd_ymm_k1z_ymm_ymmm256b64 = 3336,
	/// `VFMADDSUB132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 96 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132pd_zmm_k1z_zmm_zmmm512b64_er = 3337,
	/// `VFMSUBADD132PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 97 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd132ps_xmm_xmm_xmmm128 = 3338,
	/// `VFMSUBADD132PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 97 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd132ps_ymm_ymm_ymmm256 = 3339,
	/// `VFMSUBADD132PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 97 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd132pd_xmm_xmm_xmmm128 = 3340,
	/// `VFMSUBADD132PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 97 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd132pd_ymm_ymm_ymmm256 = 3341,
	/// `VFMSUBADD132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 97 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132ps_xmm_k1z_xmm_xmmm128b32 = 3342,
	/// `VFMSUBADD132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 97 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132ps_ymm_k1z_ymm_ymmm256b32 = 3343,
	/// `VFMSUBADD132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 97 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132ps_zmm_k1z_zmm_zmmm512b32_er = 3344,
	/// `VFMSUBADD132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 97 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132pd_xmm_k1z_xmm_xmmm128b64 = 3345,
	/// `VFMSUBADD132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 97 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132pd_ymm_k1z_ymm_ymmm256b64 = 3346,
	/// `VFMSUBADD132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 97 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132pd_zmm_k1z_zmm_zmmm512b64_er = 3347,
	/// `VFMADD132PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 98 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd132ps_xmm_xmm_xmmm128 = 3348,
	/// `VFMADD132PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 98 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd132ps_ymm_ymm_ymmm256 = 3349,
	/// `VFMADD132PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 98 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd132pd_xmm_xmm_xmmm128 = 3350,
	/// `VFMADD132PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 98 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd132pd_ymm_ymm_ymmm256 = 3351,
	/// `VFMADD132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 98 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132ps_xmm_k1z_xmm_xmmm128b32 = 3352,
	/// `VFMADD132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 98 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132ps_ymm_k1z_ymm_ymmm256b32 = 3353,
	/// `VFMADD132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 98 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132ps_zmm_k1z_zmm_zmmm512b32_er = 3354,
	/// `VFMADD132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 98 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132pd_xmm_k1z_xmm_xmmm128b64 = 3355,
	/// `VFMADD132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 98 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132pd_ymm_k1z_ymm_ymmm256b64 = 3356,
	/// `VFMADD132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 98 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132pd_zmm_k1z_zmm_zmmm512b64_er = 3357,
	/// `VFMADD132SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 99 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd132ss_xmm_xmm_xmmm32 = 3358,
	/// `VFMADD132SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 99 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd132sd_xmm_xmm_xmmm64 = 3359,
	/// `VFMADD132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 99 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132ss_xmm_k1z_xmm_xmmm32_er = 3360,
	/// `VFMADD132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 99 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132sd_xmm_k1z_xmm_xmmm64_er = 3361,
	/// `VFMSUB132PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 9A /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub132ps_xmm_xmm_xmmm128 = 3362,
	/// `VFMSUB132PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 9A /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub132ps_ymm_ymm_ymmm256 = 3363,
	/// `VFMSUB132PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 9A /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub132pd_xmm_xmm_xmmm128 = 3364,
	/// `VFMSUB132PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 9A /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub132pd_ymm_ymm_ymmm256 = 3365,
	/// `VFMSUB132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 9A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132ps_xmm_k1z_xmm_xmmm128b32 = 3366,
	/// `VFMSUB132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 9A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132ps_ymm_k1z_ymm_ymmm256b32 = 3367,
	/// `VFMSUB132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 9A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132ps_zmm_k1z_zmm_zmmm512b32_er = 3368,
	/// `VFMSUB132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 9A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132pd_xmm_k1z_xmm_xmmm128b64 = 3369,
	/// `VFMSUB132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 9A /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132pd_ymm_k1z_ymm_ymmm256b64 = 3370,
	/// `VFMSUB132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 9A /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132pd_zmm_k1z_zmm_zmmm512b64_er = 3371,
	/// `V4FMADDPS zmm1 {k1}{z}, zmm2+3, m128`
	///
	/// `EVEX.512.F2.0F38.W0 9A /r`
	///
	/// `AVX512_4FMAPS`
	///
	/// `16/32/64-bit`
	EVEX_V4fmaddps_zmm_k1z_zmmp3_m128 = 3372,
	/// `VFMSUB132SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 9B /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub132ss_xmm_xmm_xmmm32 = 3373,
	/// `VFMSUB132SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 9B /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub132sd_xmm_xmm_xmmm64 = 3374,
	/// `VFMSUB132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 9B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132ss_xmm_k1z_xmm_xmmm32_er = 3375,
	/// `VFMSUB132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 9B /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132sd_xmm_k1z_xmm_xmmm64_er = 3376,
	/// `V4FMADDSS xmm1 {k1}{z}, xmm2+3, m128`
	///
	/// `EVEX.LIG.F2.0F38.W0 9B /r`
	///
	/// `AVX512_4FMAPS`
	///
	/// `16/32/64-bit`
	EVEX_V4fmaddss_xmm_k1z_xmmp3_m128 = 3377,
	/// `VFNMADD132PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 9C /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd132ps_xmm_xmm_xmmm128 = 3378,
	/// `VFNMADD132PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 9C /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd132ps_ymm_ymm_ymmm256 = 3379,
	/// `VFNMADD132PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 9C /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd132pd_xmm_xmm_xmmm128 = 3380,
	/// `VFNMADD132PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 9C /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd132pd_ymm_ymm_ymmm256 = 3381,
	/// `VFNMADD132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 9C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132ps_xmm_k1z_xmm_xmmm128b32 = 3382,
	/// `VFNMADD132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 9C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132ps_ymm_k1z_ymm_ymmm256b32 = 3383,
	/// `VFNMADD132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 9C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132ps_zmm_k1z_zmm_zmmm512b32_er = 3384,
	/// `VFNMADD132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 9C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132pd_xmm_k1z_xmm_xmmm128b64 = 3385,
	/// `VFNMADD132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 9C /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132pd_ymm_k1z_ymm_ymmm256b64 = 3386,
	/// `VFNMADD132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 9C /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132pd_zmm_k1z_zmm_zmmm512b64_er = 3387,
	/// `VFNMADD132SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 9D /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd132ss_xmm_xmm_xmmm32 = 3388,
	/// `VFNMADD132SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 9D /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd132sd_xmm_xmm_xmmm64 = 3389,
	/// `VFNMADD132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 9D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132ss_xmm_k1z_xmm_xmmm32_er = 3390,
	/// `VFNMADD132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 9D /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132sd_xmm_k1z_xmm_xmmm64_er = 3391,
	/// `VFNMSUB132PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 9E /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub132ps_xmm_xmm_xmmm128 = 3392,
	/// `VFNMSUB132PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 9E /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub132ps_ymm_ymm_ymmm256 = 3393,
	/// `VFNMSUB132PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 9E /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub132pd_xmm_xmm_xmmm128 = 3394,
	/// `VFNMSUB132PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 9E /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub132pd_ymm_ymm_ymmm256 = 3395,
	/// `VFNMSUB132PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 9E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132ps_xmm_k1z_xmm_xmmm128b32 = 3396,
	/// `VFNMSUB132PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 9E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132ps_ymm_k1z_ymm_ymmm256b32 = 3397,
	/// `VFNMSUB132PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 9E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132ps_zmm_k1z_zmm_zmmm512b32_er = 3398,
	/// `VFNMSUB132PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 9E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132pd_xmm_k1z_xmm_xmmm128b64 = 3399,
	/// `VFNMSUB132PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 9E /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132pd_ymm_k1z_ymm_ymmm256b64 = 3400,
	/// `VFNMSUB132PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 9E /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132pd_zmm_k1z_zmm_zmmm512b64_er = 3401,
	/// `VFNMSUB132SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 9F /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub132ss_xmm_xmm_xmmm32 = 3402,
	/// `VFNMSUB132SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 9F /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub132sd_xmm_xmm_xmmm64 = 3403,
	/// `VFNMSUB132SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 9F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132ss_xmm_k1z_xmm_xmmm32_er = 3404,
	/// `VFNMSUB132SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 9F /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132sd_xmm_k1z_xmm_xmmm64_er = 3405,
	/// `VPSCATTERDD vm32x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W0 A0 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterdd_vm32x_k1_xmm = 3406,
	/// `VPSCATTERDD vm32y {k1}, ymm1`
	///
	/// `EVEX.256.66.0F38.W0 A0 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterdd_vm32y_k1_ymm = 3407,
	/// `VPSCATTERDD vm32z {k1}, zmm1`
	///
	/// `EVEX.512.66.0F38.W0 A0 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterdd_vm32z_k1_zmm = 3408,
	/// `VPSCATTERDQ vm32x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W1 A0 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterdq_vm32x_k1_xmm = 3409,
	/// `VPSCATTERDQ vm32x {k1}, ymm1`
	///
	/// `EVEX.256.66.0F38.W1 A0 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterdq_vm32x_k1_ymm = 3410,
	/// `VPSCATTERDQ vm32y {k1}, zmm1`
	///
	/// `EVEX.512.66.0F38.W1 A0 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterdq_vm32y_k1_zmm = 3411,
	/// `VPSCATTERQD vm64x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W0 A1 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterqd_vm64x_k1_xmm = 3412,
	/// `VPSCATTERQD vm64y {k1}, xmm1`
	///
	/// `EVEX.256.66.0F38.W0 A1 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterqd_vm64y_k1_xmm = 3413,
	/// `VPSCATTERQD vm64z {k1}, ymm1`
	///
	/// `EVEX.512.66.0F38.W0 A1 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterqd_vm64z_k1_ymm = 3414,
	/// `VPSCATTERQQ vm64x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W1 A1 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterqq_vm64x_k1_xmm = 3415,
	/// `VPSCATTERQQ vm64y {k1}, ymm1`
	///
	/// `EVEX.256.66.0F38.W1 A1 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterqq_vm64y_k1_ymm = 3416,
	/// `VPSCATTERQQ vm64z {k1}, zmm1`
	///
	/// `EVEX.512.66.0F38.W1 A1 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpscatterqq_vm64z_k1_zmm = 3417,
	/// `VSCATTERDPS vm32x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W0 A2 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterdps_vm32x_k1_xmm = 3418,
	/// `VSCATTERDPS vm32y {k1}, ymm1`
	///
	/// `EVEX.256.66.0F38.W0 A2 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterdps_vm32y_k1_ymm = 3419,
	/// `VSCATTERDPS vm32z {k1}, zmm1`
	///
	/// `EVEX.512.66.0F38.W0 A2 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterdps_vm32z_k1_zmm = 3420,
	/// `VSCATTERDPD vm32x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W1 A2 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterdpd_vm32x_k1_xmm = 3421,
	/// `VSCATTERDPD vm32x {k1}, ymm1`
	///
	/// `EVEX.256.66.0F38.W1 A2 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterdpd_vm32x_k1_ymm = 3422,
	/// `VSCATTERDPD vm32y {k1}, zmm1`
	///
	/// `EVEX.512.66.0F38.W1 A2 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterdpd_vm32y_k1_zmm = 3423,
	/// `VSCATTERQPS vm64x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W0 A3 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterqps_vm64x_k1_xmm = 3424,
	/// `VSCATTERQPS vm64y {k1}, xmm1`
	///
	/// `EVEX.256.66.0F38.W0 A3 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterqps_vm64y_k1_xmm = 3425,
	/// `VSCATTERQPS vm64z {k1}, ymm1`
	///
	/// `EVEX.512.66.0F38.W0 A3 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterqps_vm64z_k1_ymm = 3426,
	/// `VSCATTERQPD vm64x {k1}, xmm1`
	///
	/// `EVEX.128.66.0F38.W1 A3 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterqpd_vm64x_k1_xmm = 3427,
	/// `VSCATTERQPD vm64y {k1}, ymm1`
	///
	/// `EVEX.256.66.0F38.W1 A3 /vsib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterqpd_vm64y_k1_ymm = 3428,
	/// `VSCATTERQPD vm64z {k1}, zmm1`
	///
	/// `EVEX.512.66.0F38.W1 A3 /vsib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterqpd_vm64z_k1_zmm = 3429,
	/// `VFMADDSUB213PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 A6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub213ps_xmm_xmm_xmmm128 = 3430,
	/// `VFMADDSUB213PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 A6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub213ps_ymm_ymm_ymmm256 = 3431,
	/// `VFMADDSUB213PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 A6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub213pd_xmm_xmm_xmmm128 = 3432,
	/// `VFMADDSUB213PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 A6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub213pd_ymm_ymm_ymmm256 = 3433,
	/// `VFMADDSUB213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 A6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213ps_xmm_k1z_xmm_xmmm128b32 = 3434,
	/// `VFMADDSUB213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 A6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213ps_ymm_k1z_ymm_ymmm256b32 = 3435,
	/// `VFMADDSUB213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 A6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213ps_zmm_k1z_zmm_zmmm512b32_er = 3436,
	/// `VFMADDSUB213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 A6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213pd_xmm_k1z_xmm_xmmm128b64 = 3437,
	/// `VFMADDSUB213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 A6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213pd_ymm_k1z_ymm_ymmm256b64 = 3438,
	/// `VFMADDSUB213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 A6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213pd_zmm_k1z_zmm_zmmm512b64_er = 3439,
	/// `VFMSUBADD213PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 A7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd213ps_xmm_xmm_xmmm128 = 3440,
	/// `VFMSUBADD213PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 A7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd213ps_ymm_ymm_ymmm256 = 3441,
	/// `VFMSUBADD213PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 A7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd213pd_xmm_xmm_xmmm128 = 3442,
	/// `VFMSUBADD213PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 A7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd213pd_ymm_ymm_ymmm256 = 3443,
	/// `VFMSUBADD213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 A7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213ps_xmm_k1z_xmm_xmmm128b32 = 3444,
	/// `VFMSUBADD213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 A7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213ps_ymm_k1z_ymm_ymmm256b32 = 3445,
	/// `VFMSUBADD213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 A7 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213ps_zmm_k1z_zmm_zmmm512b32_er = 3446,
	/// `VFMSUBADD213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 A7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213pd_xmm_k1z_xmm_xmmm128b64 = 3447,
	/// `VFMSUBADD213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 A7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213pd_ymm_k1z_ymm_ymmm256b64 = 3448,
	/// `VFMSUBADD213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 A7 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213pd_zmm_k1z_zmm_zmmm512b64_er = 3449,
	/// `VFMADD213PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 A8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd213ps_xmm_xmm_xmmm128 = 3450,
	/// `VFMADD213PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 A8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd213ps_ymm_ymm_ymmm256 = 3451,
	/// `VFMADD213PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 A8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd213pd_xmm_xmm_xmmm128 = 3452,
	/// `VFMADD213PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 A8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd213pd_ymm_ymm_ymmm256 = 3453,
	/// `VFMADD213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 A8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213ps_xmm_k1z_xmm_xmmm128b32 = 3454,
	/// `VFMADD213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 A8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213ps_ymm_k1z_ymm_ymmm256b32 = 3455,
	/// `VFMADD213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 A8 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213ps_zmm_k1z_zmm_zmmm512b32_er = 3456,
	/// `VFMADD213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 A8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213pd_xmm_k1z_xmm_xmmm128b64 = 3457,
	/// `VFMADD213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 A8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213pd_ymm_k1z_ymm_ymmm256b64 = 3458,
	/// `VFMADD213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 A8 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213pd_zmm_k1z_zmm_zmmm512b64_er = 3459,
	/// `VFMADD213SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 A9 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd213ss_xmm_xmm_xmmm32 = 3460,
	/// `VFMADD213SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 A9 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd213sd_xmm_xmm_xmmm64 = 3461,
	/// `VFMADD213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 A9 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213ss_xmm_k1z_xmm_xmmm32_er = 3462,
	/// `VFMADD213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 A9 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213sd_xmm_k1z_xmm_xmmm64_er = 3463,
	/// `VFMSUB213PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 AA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub213ps_xmm_xmm_xmmm128 = 3464,
	/// `VFMSUB213PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 AA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub213ps_ymm_ymm_ymmm256 = 3465,
	/// `VFMSUB213PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 AA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub213pd_xmm_xmm_xmmm128 = 3466,
	/// `VFMSUB213PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 AA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub213pd_ymm_ymm_ymmm256 = 3467,
	/// `VFMSUB213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 AA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213ps_xmm_k1z_xmm_xmmm128b32 = 3468,
	/// `VFMSUB213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 AA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213ps_ymm_k1z_ymm_ymmm256b32 = 3469,
	/// `VFMSUB213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 AA /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213ps_zmm_k1z_zmm_zmmm512b32_er = 3470,
	/// `VFMSUB213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 AA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213pd_xmm_k1z_xmm_xmmm128b64 = 3471,
	/// `VFMSUB213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 AA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213pd_ymm_k1z_ymm_ymmm256b64 = 3472,
	/// `VFMSUB213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 AA /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213pd_zmm_k1z_zmm_zmmm512b64_er = 3473,
	/// `V4FNMADDPS zmm1 {k1}{z}, zmm2+3, m128`
	///
	/// `EVEX.512.F2.0F38.W0 AA /r`
	///
	/// `AVX512_4FMAPS`
	///
	/// `16/32/64-bit`
	EVEX_V4fnmaddps_zmm_k1z_zmmp3_m128 = 3474,
	/// `VFMSUB213SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 AB /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub213ss_xmm_xmm_xmmm32 = 3475,
	/// `VFMSUB213SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 AB /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub213sd_xmm_xmm_xmmm64 = 3476,
	/// `VFMSUB213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 AB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213ss_xmm_k1z_xmm_xmmm32_er = 3477,
	/// `VFMSUB213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 AB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213sd_xmm_k1z_xmm_xmmm64_er = 3478,
	/// `V4FNMADDSS xmm1 {k1}{z}, xmm2+3, m128`
	///
	/// `EVEX.LIG.F2.0F38.W0 AB /r`
	///
	/// `AVX512_4FMAPS`
	///
	/// `16/32/64-bit`
	EVEX_V4fnmaddss_xmm_k1z_xmmp3_m128 = 3479,
	/// `VFNMADD213PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 AC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd213ps_xmm_xmm_xmmm128 = 3480,
	/// `VFNMADD213PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 AC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd213ps_ymm_ymm_ymmm256 = 3481,
	/// `VFNMADD213PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 AC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd213pd_xmm_xmm_xmmm128 = 3482,
	/// `VFNMADD213PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 AC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd213pd_ymm_ymm_ymmm256 = 3483,
	/// `VFNMADD213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 AC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213ps_xmm_k1z_xmm_xmmm128b32 = 3484,
	/// `VFNMADD213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 AC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213ps_ymm_k1z_ymm_ymmm256b32 = 3485,
	/// `VFNMADD213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 AC /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213ps_zmm_k1z_zmm_zmmm512b32_er = 3486,
	/// `VFNMADD213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 AC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213pd_xmm_k1z_xmm_xmmm128b64 = 3487,
	/// `VFNMADD213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 AC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213pd_ymm_k1z_ymm_ymmm256b64 = 3488,
	/// `VFNMADD213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 AC /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213pd_zmm_k1z_zmm_zmmm512b64_er = 3489,
	/// `VFNMADD213SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 AD /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd213ss_xmm_xmm_xmmm32 = 3490,
	/// `VFNMADD213SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 AD /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd213sd_xmm_xmm_xmmm64 = 3491,
	/// `VFNMADD213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 AD /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213ss_xmm_k1z_xmm_xmmm32_er = 3492,
	/// `VFNMADD213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 AD /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213sd_xmm_k1z_xmm_xmmm64_er = 3493,
	/// `VFNMSUB213PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 AE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub213ps_xmm_xmm_xmmm128 = 3494,
	/// `VFNMSUB213PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 AE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub213ps_ymm_ymm_ymmm256 = 3495,
	/// `VFNMSUB213PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 AE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub213pd_xmm_xmm_xmmm128 = 3496,
	/// `VFNMSUB213PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 AE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub213pd_ymm_ymm_ymmm256 = 3497,
	/// `VFNMSUB213PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 AE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213ps_xmm_k1z_xmm_xmmm128b32 = 3498,
	/// `VFNMSUB213PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 AE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213ps_ymm_k1z_ymm_ymmm256b32 = 3499,
	/// `VFNMSUB213PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 AE /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213ps_zmm_k1z_zmm_zmmm512b32_er = 3500,
	/// `VFNMSUB213PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 AE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213pd_xmm_k1z_xmm_xmmm128b64 = 3501,
	/// `VFNMSUB213PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 AE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213pd_ymm_k1z_ymm_ymmm256b64 = 3502,
	/// `VFNMSUB213PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 AE /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213pd_zmm_k1z_zmm_zmmm512b64_er = 3503,
	/// `VFNMSUB213SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 AF /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub213ss_xmm_xmm_xmmm32 = 3504,
	/// `VFNMSUB213SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 AF /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub213sd_xmm_xmm_xmmm64 = 3505,
	/// `VFNMSUB213SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 AF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213ss_xmm_k1z_xmm_xmmm32_er = 3506,
	/// `VFNMSUB213SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 AF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213sd_xmm_k1z_xmm_xmmm64_er = 3507,
	/// `VPMADD52LUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 B4 /r`
	///
	/// `AVX512VL and AVX512_IFMA`
	///
	/// `16/32/64-bit`
	EVEX_Vpmadd52luq_xmm_k1z_xmm_xmmm128b64 = 3508,
	/// `VPMADD52LUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 B4 /r`
	///
	/// `AVX512VL and AVX512_IFMA`
	///
	/// `16/32/64-bit`
	EVEX_Vpmadd52luq_ymm_k1z_ymm_ymmm256b64 = 3509,
	/// `VPMADD52LUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 B4 /r`
	///
	/// `AVX512_IFMA`
	///
	/// `16/32/64-bit`
	EVEX_Vpmadd52luq_zmm_k1z_zmm_zmmm512b64 = 3510,
	/// `VPMADD52HUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 B5 /r`
	///
	/// `AVX512VL and AVX512_IFMA`
	///
	/// `16/32/64-bit`
	EVEX_Vpmadd52huq_xmm_k1z_xmm_xmmm128b64 = 3511,
	/// `VPMADD52HUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 B5 /r`
	///
	/// `AVX512VL and AVX512_IFMA`
	///
	/// `16/32/64-bit`
	EVEX_Vpmadd52huq_ymm_k1z_ymm_ymmm256b64 = 3512,
	/// `VPMADD52HUQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 B5 /r`
	///
	/// `AVX512_IFMA`
	///
	/// `16/32/64-bit`
	EVEX_Vpmadd52huq_zmm_k1z_zmm_zmmm512b64 = 3513,
	/// `VFMADDSUB231PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 B6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub231ps_xmm_xmm_xmmm128 = 3514,
	/// `VFMADDSUB231PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 B6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub231ps_ymm_ymm_ymmm256 = 3515,
	/// `VFMADDSUB231PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 B6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub231pd_xmm_xmm_xmmm128 = 3516,
	/// `VFMADDSUB231PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 B6 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsub231pd_ymm_ymm_ymmm256 = 3517,
	/// `VFMADDSUB231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 B6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231ps_xmm_k1z_xmm_xmmm128b32 = 3518,
	/// `VFMADDSUB231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 B6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231ps_ymm_k1z_ymm_ymmm256b32 = 3519,
	/// `VFMADDSUB231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 B6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231ps_zmm_k1z_zmm_zmmm512b32_er = 3520,
	/// `VFMADDSUB231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 B6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231pd_xmm_k1z_xmm_xmmm128b64 = 3521,
	/// `VFMADDSUB231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 B6 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231pd_ymm_k1z_ymm_ymmm256b64 = 3522,
	/// `VFMADDSUB231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 B6 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231pd_zmm_k1z_zmm_zmmm512b64_er = 3523,
	/// `VFMSUBADD231PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 B7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd231ps_xmm_xmm_xmmm128 = 3524,
	/// `VFMSUBADD231PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 B7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd231ps_ymm_ymm_ymmm256 = 3525,
	/// `VFMSUBADD231PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 B7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd231pd_xmm_xmm_xmmm128 = 3526,
	/// `VFMSUBADD231PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 B7 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubadd231pd_ymm_ymm_ymmm256 = 3527,
	/// `VFMSUBADD231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 B7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231ps_xmm_k1z_xmm_xmmm128b32 = 3528,
	/// `VFMSUBADD231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 B7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231ps_ymm_k1z_ymm_ymmm256b32 = 3529,
	/// `VFMSUBADD231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 B7 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231ps_zmm_k1z_zmm_zmmm512b32_er = 3530,
	/// `VFMSUBADD231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 B7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231pd_xmm_k1z_xmm_xmmm128b64 = 3531,
	/// `VFMSUBADD231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 B7 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231pd_ymm_k1z_ymm_ymmm256b64 = 3532,
	/// `VFMSUBADD231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 B7 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231pd_zmm_k1z_zmm_zmmm512b64_er = 3533,
	/// `VFMADD231PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 B8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd231ps_xmm_xmm_xmmm128 = 3534,
	/// `VFMADD231PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 B8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd231ps_ymm_ymm_ymmm256 = 3535,
	/// `VFMADD231PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 B8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd231pd_xmm_xmm_xmmm128 = 3536,
	/// `VFMADD231PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 B8 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd231pd_ymm_ymm_ymmm256 = 3537,
	/// `VFMADD231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 B8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231ps_xmm_k1z_xmm_xmmm128b32 = 3538,
	/// `VFMADD231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 B8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231ps_ymm_k1z_ymm_ymmm256b32 = 3539,
	/// `VFMADD231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 B8 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231ps_zmm_k1z_zmm_zmmm512b32_er = 3540,
	/// `VFMADD231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 B8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231pd_xmm_k1z_xmm_xmmm128b64 = 3541,
	/// `VFMADD231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 B8 /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231pd_ymm_k1z_ymm_ymmm256b64 = 3542,
	/// `VFMADD231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 B8 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231pd_zmm_k1z_zmm_zmmm512b64_er = 3543,
	/// `VFMADD231SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 B9 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd231ss_xmm_xmm_xmmm32 = 3544,
	/// `VFMADD231SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 B9 /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmadd231sd_xmm_xmm_xmmm64 = 3545,
	/// `VFMADD231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 B9 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231ss_xmm_k1z_xmm_xmmm32_er = 3546,
	/// `VFMADD231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 B9 /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231sd_xmm_k1z_xmm_xmmm64_er = 3547,
	/// `VFMSUB231PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 BA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub231ps_xmm_xmm_xmmm128 = 3548,
	/// `VFMSUB231PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 BA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub231ps_ymm_ymm_ymmm256 = 3549,
	/// `VFMSUB231PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 BA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub231pd_xmm_xmm_xmmm128 = 3550,
	/// `VFMSUB231PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 BA /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub231pd_ymm_ymm_ymmm256 = 3551,
	/// `VFMSUB231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 BA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231ps_xmm_k1z_xmm_xmmm128b32 = 3552,
	/// `VFMSUB231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 BA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231ps_ymm_k1z_ymm_ymmm256b32 = 3553,
	/// `VFMSUB231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 BA /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231ps_zmm_k1z_zmm_zmmm512b32_er = 3554,
	/// `VFMSUB231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 BA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231pd_xmm_k1z_xmm_xmmm128b64 = 3555,
	/// `VFMSUB231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 BA /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231pd_ymm_k1z_ymm_ymmm256b64 = 3556,
	/// `VFMSUB231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 BA /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231pd_zmm_k1z_zmm_zmmm512b64_er = 3557,
	/// `VFMSUB231SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 BB /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub231ss_xmm_xmm_xmmm32 = 3558,
	/// `VFMSUB231SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 BB /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfmsub231sd_xmm_xmm_xmmm64 = 3559,
	/// `VFMSUB231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 BB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231ss_xmm_k1z_xmm_xmmm32_er = 3560,
	/// `VFMSUB231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 BB /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231sd_xmm_k1z_xmm_xmmm64_er = 3561,
	/// `VFNMADD231PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 BC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd231ps_xmm_xmm_xmmm128 = 3562,
	/// `VFNMADD231PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 BC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd231ps_ymm_ymm_ymmm256 = 3563,
	/// `VFNMADD231PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 BC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd231pd_xmm_xmm_xmmm128 = 3564,
	/// `VFNMADD231PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 BC /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd231pd_ymm_ymm_ymmm256 = 3565,
	/// `VFNMADD231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 BC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231ps_xmm_k1z_xmm_xmmm128b32 = 3566,
	/// `VFNMADD231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 BC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231ps_ymm_k1z_ymm_ymmm256b32 = 3567,
	/// `VFNMADD231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 BC /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231ps_zmm_k1z_zmm_zmmm512b32_er = 3568,
	/// `VFNMADD231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 BC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231pd_xmm_k1z_xmm_xmmm128b64 = 3569,
	/// `VFNMADD231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 BC /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231pd_ymm_k1z_ymm_ymmm256b64 = 3570,
	/// `VFNMADD231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 BC /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231pd_zmm_k1z_zmm_zmmm512b64_er = 3571,
	/// `VFNMADD231SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 BD /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd231ss_xmm_xmm_xmmm32 = 3572,
	/// `VFNMADD231SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 BD /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmadd231sd_xmm_xmm_xmmm64 = 3573,
	/// `VFNMADD231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 BD /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231ss_xmm_k1z_xmm_xmmm32_er = 3574,
	/// `VFNMADD231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 BD /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231sd_xmm_k1z_xmm_xmmm64_er = 3575,
	/// `VFNMSUB231PS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 BE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub231ps_xmm_xmm_xmmm128 = 3576,
	/// `VFNMSUB231PS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 BE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub231ps_ymm_ymm_ymmm256 = 3577,
	/// `VFNMSUB231PD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W1 BE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub231pd_xmm_xmm_xmmm128 = 3578,
	/// `VFNMSUB231PD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W1 BE /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub231pd_ymm_ymm_ymmm256 = 3579,
	/// `VFNMSUB231PS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 BE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231ps_xmm_k1z_xmm_xmmm128b32 = 3580,
	/// `VFNMSUB231PS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 BE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231ps_ymm_k1z_ymm_ymmm256b32 = 3581,
	/// `VFNMSUB231PS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.0F38.W0 BE /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231ps_zmm_k1z_zmm_zmmm512b32_er = 3582,
	/// `VFNMSUB231PD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 BE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231pd_xmm_k1z_xmm_xmmm128b64 = 3583,
	/// `VFNMSUB231PD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 BE /r`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231pd_ymm_k1z_ymm_ymmm256b64 = 3584,
	/// `VFNMSUB231PD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.0F38.W1 BE /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231pd_zmm_k1z_zmm_zmmm512b64_er = 3585,
	/// `VFNMSUB231SS xmm1, xmm2, xmm3/m32`
	///
	/// `VEX.LIG.66.0F38.W0 BF /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub231ss_xmm_xmm_xmmm32 = 3586,
	/// `VFNMSUB231SD xmm1, xmm2, xmm3/m64`
	///
	/// `VEX.LIG.66.0F38.W1 BF /r`
	///
	/// `FMA`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsub231sd_xmm_xmm_xmmm64 = 3587,
	/// `VFNMSUB231SS xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.66.0F38.W0 BF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231ss_xmm_k1z_xmm_xmmm32_er = 3588,
	/// `VFNMSUB231SD xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.66.0F38.W1 BF /r`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231sd_xmm_k1z_xmm_xmmm64_er = 3589,
	/// `VPCONFLICTD xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.0F38.W0 C4 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpconflictd_xmm_k1z_xmmm128b32 = 3590,
	/// `VPCONFLICTD ymm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.0F38.W0 C4 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpconflictd_ymm_k1z_ymmm256b32 = 3591,
	/// `VPCONFLICTD zmm1 {k1}{z}, zmm2/m512/m32bcst`
	///
	/// `EVEX.512.66.0F38.W0 C4 /r`
	///
	/// `AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpconflictd_zmm_k1z_zmmm512b32 = 3592,
	/// `VPCONFLICTQ xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.0F38.W1 C4 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpconflictq_xmm_k1z_xmmm128b64 = 3593,
	/// `VPCONFLICTQ ymm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.0F38.W1 C4 /r`
	///
	/// `AVX512VL and AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpconflictq_ymm_k1z_ymmm256b64 = 3594,
	/// `VPCONFLICTQ zmm1 {k1}{z}, zmm2/m512/m64bcst`
	///
	/// `EVEX.512.66.0F38.W1 C4 /r`
	///
	/// `AVX512CD`
	///
	/// `16/32/64-bit`
	EVEX_Vpconflictq_zmm_k1z_zmmm512b64 = 3595,
	/// `VGATHERPF0DPS vm32z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C6 /1 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf0dps_vm32z_k1 = 3596,
	/// `VGATHERPF0DPD vm32y {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C6 /1 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf0dpd_vm32y_k1 = 3597,
	/// `VGATHERPF1DPS vm32z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C6 /2 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf1dps_vm32z_k1 = 3598,
	/// `VGATHERPF1DPD vm32y {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C6 /2 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf1dpd_vm32y_k1 = 3599,
	/// `VSCATTERPF0DPS vm32z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C6 /5 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf0dps_vm32z_k1 = 3600,
	/// `VSCATTERPF0DPD vm32y {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C6 /5 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf0dpd_vm32y_k1 = 3601,
	/// `VSCATTERPF1DPS vm32z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C6 /6 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf1dps_vm32z_k1 = 3602,
	/// `VSCATTERPF1DPD vm32y {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C6 /6 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf1dpd_vm32y_k1 = 3603,
	/// `VGATHERPF0QPS vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C7 /1 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf0qps_vm64z_k1 = 3604,
	/// `VGATHERPF0QPD vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C7 /1 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf0qpd_vm64z_k1 = 3605,
	/// `VGATHERPF1QPS vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C7 /2 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf1qps_vm64z_k1 = 3606,
	/// `VGATHERPF1QPD vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C7 /2 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vgatherpf1qpd_vm64z_k1 = 3607,
	/// `VSCATTERPF0QPS vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C7 /5 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf0qps_vm64z_k1 = 3608,
	/// `VSCATTERPF0QPD vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C7 /5 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf0qpd_vm64z_k1 = 3609,
	/// `VSCATTERPF1QPS vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W0 C7 /6 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf1qps_vm64z_k1 = 3610,
	/// `VSCATTERPF1QPD vm64z {k1}`
	///
	/// `EVEX.512.66.0F38.W1 C7 /6 /vsib`
	///
	/// `AVX512PF`
	///
	/// `16/32/64-bit`
	EVEX_Vscatterpf1qpd_vm64z_k1 = 3611,
	/// `SHA1NEXTE xmm1, xmm2/m128`
	///
	/// `NP 0F 38 C8 /r`
	///
	/// `SHA`
	///
	/// `16/32/64-bit`
	Sha1nexte_xmm_xmmm128 = 3612,
	/// `VEXP2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W0 C8 /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vexp2ps_zmm_k1z_zmmm512b32_sae = 3613,
	/// `VEXP2PD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W1 C8 /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vexp2pd_zmm_k1z_zmmm512b64_sae = 3614,
	/// `SHA1MSG1 xmm1, xmm2/m128`
	///
	/// `NP 0F 38 C9 /r`
	///
	/// `SHA`
	///
	/// `16/32/64-bit`
	Sha1msg1_xmm_xmmm128 = 3615,
	/// `SHA1MSG2 xmm1, xmm2/m128`
	///
	/// `NP 0F 38 CA /r`
	///
	/// `SHA`
	///
	/// `16/32/64-bit`
	Sha1msg2_xmm_xmmm128 = 3616,
	/// `VRCP28PS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W0 CA /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp28ps_zmm_k1z_zmmm512b32_sae = 3617,
	/// `VRCP28PD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W1 CA /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp28pd_zmm_k1z_zmmm512b64_sae = 3618,
	/// `SHA256RNDS2 xmm1, xmm2/m128, <XMM0>`
	///
	/// `NP 0F 38 CB /r`
	///
	/// `SHA`
	///
	/// `16/32/64-bit`
	Sha256rnds2_xmm_xmmm128 = 3619,
	/// `VRCP28SS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}`
	///
	/// `EVEX.LIG.66.0F38.W0 CB /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp28ss_xmm_k1z_xmm_xmmm32_sae = 3620,
	/// `VRCP28SD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}`
	///
	/// `EVEX.LIG.66.0F38.W1 CB /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrcp28sd_xmm_k1z_xmm_xmmm64_sae = 3621,
	/// `SHA256MSG1 xmm1, xmm2/m128`
	///
	/// `NP 0F 38 CC /r`
	///
	/// `SHA`
	///
	/// `16/32/64-bit`
	Sha256msg1_xmm_xmmm128 = 3622,
	/// `VRSQRT28PS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W0 CC /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt28ps_zmm_k1z_zmmm512b32_sae = 3623,
	/// `VRSQRT28PD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}`
	///
	/// `EVEX.512.66.0F38.W1 CC /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt28pd_zmm_k1z_zmmm512b64_sae = 3624,
	/// `SHA256MSG2 xmm1, xmm2/m128`
	///
	/// `NP 0F 38 CD /r`
	///
	/// `SHA`
	///
	/// `16/32/64-bit`
	Sha256msg2_xmm_xmmm128 = 3625,
	/// `VRSQRT28SS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}`
	///
	/// `EVEX.LIG.66.0F38.W0 CD /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt28ss_xmm_k1z_xmm_xmmm32_sae = 3626,
	/// `VRSQRT28SD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}`
	///
	/// `EVEX.LIG.66.0F38.W1 CD /r`
	///
	/// `AVX512ER`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrt28sd_xmm_k1z_xmm_xmmm64_sae = 3627,
	/// `GF2P8MULB xmm1, xmm2/m128`
	///
	/// `66 0F 38 CF /r`
	///
	/// `GFNI`
	///
	/// `16/32/64-bit`
	Gf2p8mulb_xmm_xmmm128 = 3628,
	/// `VGF2P8MULB xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 CF /r`
	///
	/// `AVX and GFNI`
	///
	/// `16/32/64-bit`
	VEX_Vgf2p8mulb_xmm_xmm_xmmm128 = 3629,
	/// `VGF2P8MULB ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 CF /r`
	///
	/// `AVX and GFNI`
	///
	/// `16/32/64-bit`
	VEX_Vgf2p8mulb_ymm_ymm_ymmm256 = 3630,
	/// `VGF2P8MULB xmm1 {k1}{z}, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.W0 CF /r`
	///
	/// `AVX512VL and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8mulb_xmm_k1z_xmm_xmmm128 = 3631,
	/// `VGF2P8MULB ymm1 {k1}{z}, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.W0 CF /r`
	///
	/// `AVX512VL and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8mulb_ymm_k1z_ymm_ymmm256 = 3632,
	/// `VGF2P8MULB zmm1 {k1}{z}, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.W0 CF /r`
	///
	/// `AVX512F and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8mulb_zmm_k1z_zmm_zmmm512 = 3633,
	/// `AESIMC xmm1, xmm2/m128`
	///
	/// `66 0F 38 DB /r`
	///
	/// `AES`
	///
	/// `16/32/64-bit`
	Aesimc_xmm_xmmm128 = 3634,
	/// `VAESIMC xmm1, xmm2/m128`
	///
	/// `VEX.128.66.0F38.WIG DB /r`
	///
	/// `AES and AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaesimc_xmm_xmmm128 = 3635,
	/// `AESENC xmm1, xmm2/m128`
	///
	/// `66 0F 38 DC /r`
	///
	/// `AES`
	///
	/// `16/32/64-bit`
	Aesenc_xmm_xmmm128 = 3636,
	/// `VAESENC xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG DC /r`
	///
	/// `AES and AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaesenc_xmm_xmm_xmmm128 = 3637,
	/// `VAESENC ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG DC /r`
	///
	/// `VAES`
	///
	/// `16/32/64-bit`
	VEX_Vaesenc_ymm_ymm_ymmm256 = 3638,
	/// `VAESENC xmm1, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG DC /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesenc_xmm_xmm_xmmm128 = 3639,
	/// `VAESENC ymm1, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG DC /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesenc_ymm_ymm_ymmm256 = 3640,
	/// `VAESENC zmm1, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG DC /r`
	///
	/// `AVX512F and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesenc_zmm_zmm_zmmm512 = 3641,
	/// `AESENCLAST xmm1, xmm2/m128`
	///
	/// `66 0F 38 DD /r`
	///
	/// `AES`
	///
	/// `16/32/64-bit`
	Aesenclast_xmm_xmmm128 = 3642,
	/// `VAESENCLAST xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG DD /r`
	///
	/// `AES and AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaesenclast_xmm_xmm_xmmm128 = 3643,
	/// `VAESENCLAST ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG DD /r`
	///
	/// `VAES`
	///
	/// `16/32/64-bit`
	VEX_Vaesenclast_ymm_ymm_ymmm256 = 3644,
	/// `VAESENCLAST xmm1, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG DD /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesenclast_xmm_xmm_xmmm128 = 3645,
	/// `VAESENCLAST ymm1, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG DD /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesenclast_ymm_ymm_ymmm256 = 3646,
	/// `VAESENCLAST zmm1, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG DD /r`
	///
	/// `AVX512F and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesenclast_zmm_zmm_zmmm512 = 3647,
	/// `AESDEC xmm1, xmm2/m128`
	///
	/// `66 0F 38 DE /r`
	///
	/// `AES`
	///
	/// `16/32/64-bit`
	Aesdec_xmm_xmmm128 = 3648,
	/// `VAESDEC xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG DE /r`
	///
	/// `AES and AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaesdec_xmm_xmm_xmmm128 = 3649,
	/// `VAESDEC ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG DE /r`
	///
	/// `VAES`
	///
	/// `16/32/64-bit`
	VEX_Vaesdec_ymm_ymm_ymmm256 = 3650,
	/// `VAESDEC xmm1, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG DE /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesdec_xmm_xmm_xmmm128 = 3651,
	/// `VAESDEC ymm1, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG DE /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesdec_ymm_ymm_ymmm256 = 3652,
	/// `VAESDEC zmm1, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG DE /r`
	///
	/// `AVX512F and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesdec_zmm_zmm_zmmm512 = 3653,
	/// `AESDECLAST xmm1, xmm2/m128`
	///
	/// `66 0F 38 DF /r`
	///
	/// `AES`
	///
	/// `16/32/64-bit`
	Aesdeclast_xmm_xmmm128 = 3654,
	/// `VAESDECLAST xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.WIG DF /r`
	///
	/// `AES and AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaesdeclast_xmm_xmm_xmmm128 = 3655,
	/// `VAESDECLAST ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.WIG DF /r`
	///
	/// `VAES`
	///
	/// `16/32/64-bit`
	VEX_Vaesdeclast_ymm_ymm_ymmm256 = 3656,
	/// `VAESDECLAST xmm1, xmm2, xmm3/m128`
	///
	/// `EVEX.128.66.0F38.WIG DF /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesdeclast_xmm_xmm_xmmm128 = 3657,
	/// `VAESDECLAST ymm1, ymm2, ymm3/m256`
	///
	/// `EVEX.256.66.0F38.WIG DF /r`
	///
	/// `AVX512VL and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesdeclast_ymm_ymm_ymmm256 = 3658,
	/// `VAESDECLAST zmm1, zmm2, zmm3/m512`
	///
	/// `EVEX.512.66.0F38.WIG DF /r`
	///
	/// `AVX512F and VAES`
	///
	/// `16/32/64-bit`
	EVEX_Vaesdeclast_zmm_zmm_zmmm512 = 3659,
	/// `MOVBE r16, m16`
	///
	/// `o16 0F 38 F0 /r`
	///
	/// `MOVBE`
	///
	/// `16/32/64-bit`
	Movbe_r16_m16 = 3660,
	/// `MOVBE r32, m32`
	///
	/// `o32 0F 38 F0 /r`
	///
	/// `MOVBE`
	///
	/// `16/32/64-bit`
	Movbe_r32_m32 = 3661,
	/// `MOVBE r64, m64`
	///
	/// `o64 0F 38 F0 /r`
	///
	/// `MOVBE`
	///
	/// `64-bit`
	Movbe_r64_m64 = 3662,
	/// `CRC32 r32, r/m8`
	///
	/// `F2 0F 38 F0 /r`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Crc32_r32_rm8 = 3663,
	/// `CRC32 r64, r/m8`
	///
	/// `F2 o64 0F 38 F0 /r`
	///
	/// `SSE4.2`
	///
	/// `64-bit`
	Crc32_r64_rm8 = 3664,
	/// `MOVBE m16, r16`
	///
	/// `o16 0F 38 F1 /r`
	///
	/// `MOVBE`
	///
	/// `16/32/64-bit`
	Movbe_m16_r16 = 3665,
	/// `MOVBE m32, r32`
	///
	/// `o32 0F 38 F1 /r`
	///
	/// `MOVBE`
	///
	/// `16/32/64-bit`
	Movbe_m32_r32 = 3666,
	/// `MOVBE m64, r64`
	///
	/// `o64 0F 38 F1 /r`
	///
	/// `MOVBE`
	///
	/// `64-bit`
	Movbe_m64_r64 = 3667,
	/// `CRC32 r32, r/m16`
	///
	/// `o16 F2 0F 38 F1 /r`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Crc32_r32_rm16 = 3668,
	/// `CRC32 r32, r/m32`
	///
	/// `o32 F2 0F 38 F1 /r`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Crc32_r32_rm32 = 3669,
	/// `CRC32 r64, r/m64`
	///
	/// `F2 o64 0F 38 F1 /r`
	///
	/// `SSE4.2`
	///
	/// `64-bit`
	Crc32_r64_rm64 = 3670,
	/// `ANDN r32a, r32b, r/m32`
	///
	/// `VEX.LZ.0F38.W0 F2 /r`
	///
	/// `BMI1`
	///
	/// `16/32/64-bit`
	VEX_Andn_r32_r32_rm32 = 3671,
	/// `ANDN r64a, r64b, r/m64`
	///
	/// `VEX.LZ.0F38.W1 F2 /r`
	///
	/// `BMI1`
	///
	/// `64-bit`
	VEX_Andn_r64_r64_rm64 = 3672,
	/// `BLSR r32, r/m32`
	///
	/// `VEX.LZ.0F38.W0 F3 /1`
	///
	/// `BMI1`
	///
	/// `16/32/64-bit`
	VEX_Blsr_r32_rm32 = 3673,
	/// `BLSR r64, r/m64`
	///
	/// `VEX.LZ.0F38.W1 F3 /1`
	///
	/// `BMI1`
	///
	/// `64-bit`
	VEX_Blsr_r64_rm64 = 3674,
	/// `BLSMSK r32, r/m32`
	///
	/// `VEX.LZ.0F38.W0 F3 /2`
	///
	/// `BMI1`
	///
	/// `16/32/64-bit`
	VEX_Blsmsk_r32_rm32 = 3675,
	/// `BLSMSK r64, r/m64`
	///
	/// `VEX.LZ.0F38.W1 F3 /2`
	///
	/// `BMI1`
	///
	/// `64-bit`
	VEX_Blsmsk_r64_rm64 = 3676,
	/// `BLSI r32, r/m32`
	///
	/// `VEX.LZ.0F38.W0 F3 /3`
	///
	/// `BMI1`
	///
	/// `16/32/64-bit`
	VEX_Blsi_r32_rm32 = 3677,
	/// `BLSI r64, r/m64`
	///
	/// `VEX.LZ.0F38.W1 F3 /3`
	///
	/// `BMI1`
	///
	/// `64-bit`
	VEX_Blsi_r64_rm64 = 3678,
	/// `BZHI r32a, r/m32, r32b`
	///
	/// `VEX.LZ.0F38.W0 F5 /r`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Bzhi_r32_rm32_r32 = 3679,
	/// `BZHI r64a, r/m64, r64b`
	///
	/// `VEX.LZ.0F38.W1 F5 /r`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Bzhi_r64_rm64_r64 = 3680,
	/// `WRUSSD m32, r32`
	///
	/// `66 0F 38 F5 /r`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Wrussd_m32_r32 = 3681,
	/// `WRUSSQ m64, r64`
	///
	/// `66 o64 0F 38 F5 /r`
	///
	/// `CET_SS`
	///
	/// `64-bit`
	Wrussq_m64_r64 = 3682,
	/// `PEXT r32a, r32b, r/m32`
	///
	/// `VEX.LZ.F3.0F38.W0 F5 /r`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Pext_r32_r32_rm32 = 3683,
	/// `PEXT r64a, r64b, r/m64`
	///
	/// `VEX.LZ.F3.0F38.W1 F5 /r`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Pext_r64_r64_rm64 = 3684,
	/// `PDEP r32a, r32b, r/m32`
	///
	/// `VEX.LZ.F2.0F38.W0 F5 /r`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Pdep_r32_r32_rm32 = 3685,
	/// `PDEP r64a, r64b, r/m64`
	///
	/// `VEX.LZ.F2.0F38.W1 F5 /r`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Pdep_r64_r64_rm64 = 3686,
	/// `WRSSD m32, r32`
	///
	/// `NP 0F 38 F6 /r`
	///
	/// `CET_SS`
	///
	/// `16/32/64-bit`
	Wrssd_m32_r32 = 3687,
	/// `WRSSQ m64, r64`
	///
	/// `NP o64 0F 38 F6 /r`
	///
	/// `CET_SS`
	///
	/// `64-bit`
	Wrssq_m64_r64 = 3688,
	/// `ADCX r32, r/m32`
	///
	/// `66 0F 38 F6 /r`
	///
	/// `ADX`
	///
	/// `16/32/64-bit`
	Adcx_r32_rm32 = 3689,
	/// `ADCX r64, r/m64`
	///
	/// `66 o64 0F 38 F6 /r`
	///
	/// `ADX`
	///
	/// `64-bit`
	Adcx_r64_rm64 = 3690,
	/// `ADOX r32, r/m32`
	///
	/// `F3 0F 38 F6 /r`
	///
	/// `ADX`
	///
	/// `16/32/64-bit`
	Adox_r32_rm32 = 3691,
	/// `ADOX r64, r/m64`
	///
	/// `F3 o64 0F 38 F6 /r`
	///
	/// `ADX`
	///
	/// `64-bit`
	Adox_r64_rm64 = 3692,
	/// `MULX r32a, r32b, r/m32`
	///
	/// `VEX.LZ.F2.0F38.W0 F6 /r`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Mulx_r32_r32_rm32 = 3693,
	/// `MULX r64a, r64b, r/m64`
	///
	/// `VEX.LZ.F2.0F38.W1 F6 /r`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Mulx_r64_r64_rm64 = 3694,
	/// `BEXTR r32a, r/m32, r32b`
	///
	/// `VEX.LZ.0F38.W0 F7 /r`
	///
	/// `BMI1`
	///
	/// `16/32/64-bit`
	VEX_Bextr_r32_rm32_r32 = 3695,
	/// `BEXTR r64a, r/m64, r64b`
	///
	/// `VEX.LZ.0F38.W1 F7 /r`
	///
	/// `BMI1`
	///
	/// `64-bit`
	VEX_Bextr_r64_rm64_r64 = 3696,
	/// `SHLX r32a, r/m32, r32b`
	///
	/// `VEX.LZ.66.0F38.W0 F7 /r`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Shlx_r32_rm32_r32 = 3697,
	/// `SHLX r64a, r/m64, r64b`
	///
	/// `VEX.LZ.66.0F38.W1 F7 /r`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Shlx_r64_rm64_r64 = 3698,
	/// `SARX r32a, r/m32, r32b`
	///
	/// `VEX.LZ.F3.0F38.W0 F7 /r`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Sarx_r32_rm32_r32 = 3699,
	/// `SARX r64a, r/m64, r64b`
	///
	/// `VEX.LZ.F3.0F38.W1 F7 /r`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Sarx_r64_rm64_r64 = 3700,
	/// `SHRX r32a, r/m32, r32b`
	///
	/// `VEX.LZ.F2.0F38.W0 F7 /r`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Shrx_r32_rm32_r32 = 3701,
	/// `SHRX r64a, r/m64, r64b`
	///
	/// `VEX.LZ.F2.0F38.W1 F7 /r`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Shrx_r64_rm64_r64 = 3702,
	/// `MOVDIR64B r16, m512`
	///
	/// `a16 66 0F 38 F8 /r`
	///
	/// `MOVDIR64B`
	///
	/// `16/32-bit`
	Movdir64b_r16_m512 = 3703,
	/// `MOVDIR64B r32, m512`
	///
	/// `a32 66 0F 38 F8 /r`
	///
	/// `MOVDIR64B`
	///
	/// `16/32/64-bit`
	Movdir64b_r32_m512 = 3704,
	/// `MOVDIR64B r64, m512`
	///
	/// `a64 66 0F 38 F8 /r`
	///
	/// `MOVDIR64B`
	///
	/// `64-bit`
	Movdir64b_r64_m512 = 3705,
	/// `ENQCMDS r16, m512`
	///
	/// `a16 F3 0F 38 F8 !(11):rrr:bbb`
	///
	/// `ENQCMD`
	///
	/// `16/32-bit`
	Enqcmds_r16_m512 = 3706,
	/// `ENQCMDS r32, m512`
	///
	/// `a32 F3 0F 38 F8 !(11):rrr:bbb`
	///
	/// `ENQCMD`
	///
	/// `16/32/64-bit`
	Enqcmds_r32_m512 = 3707,
	/// `ENQCMDS r64, m512`
	///
	/// `a64 F3 0F 38 F8 !(11):rrr:bbb`
	///
	/// `ENQCMD`
	///
	/// `64-bit`
	Enqcmds_r64_m512 = 3708,
	/// `ENQCMD r16, m512`
	///
	/// `a16 F2 0F 38 F8 !(11):rrr:bbb`
	///
	/// `ENQCMD`
	///
	/// `16/32-bit`
	Enqcmd_r16_m512 = 3709,
	/// `ENQCMD r32, m512`
	///
	/// `a32 F2 0F 38 F8 !(11):rrr:bbb`
	///
	/// `ENQCMD`
	///
	/// `16/32/64-bit`
	Enqcmd_r32_m512 = 3710,
	/// `ENQCMD r64, m512`
	///
	/// `a64 F2 0F 38 F8 !(11):rrr:bbb`
	///
	/// `ENQCMD`
	///
	/// `64-bit`
	Enqcmd_r64_m512 = 3711,
	/// `MOVDIRI m32, r32`
	///
	/// `NP 0F 38 F9 /r`
	///
	/// `MOVDIRI`
	///
	/// `16/32/64-bit`
	Movdiri_m32_r32 = 3712,
	/// `MOVDIRI m64, r64`
	///
	/// `NP o64 0F 38 F9 /r`
	///
	/// `MOVDIRI`
	///
	/// `64-bit`
	Movdiri_m64_r64 = 3713,
	/// `VPERMQ ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W1 00 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpermq_ymm_ymmm256_imm8 = 3714,
	/// `VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 00 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermq_ymm_k1z_ymmm256b64_imm8 = 3715,
	/// `VPERMQ zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 00 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermq_zmm_k1z_zmmm512b64_imm8 = 3716,
	/// `VPERMPD ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W1 01 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpermpd_ymm_ymmm256_imm8 = 3717,
	/// `VPERMPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 01 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermpd_ymm_k1z_ymmm256b64_imm8 = 3718,
	/// `VPERMPD zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 01 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermpd_zmm_k1z_zmmm512b64_imm8 = 3719,
	/// `VPBLENDD xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W0 02 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpblendd_xmm_xmm_xmmm128_imm8 = 3720,
	/// `VPBLENDD ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W0 02 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpblendd_ymm_ymm_ymmm256_imm8 = 3721,
	/// `VALIGND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 03 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8 = 3722,
	/// `VALIGND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 03 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8 = 3723,
	/// `VALIGND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 03 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8 = 3724,
	/// `VALIGNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 03 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8 = 3725,
	/// `VALIGNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 03 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8 = 3726,
	/// `VALIGNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 03 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8 = 3727,
	/// `VPERMILPS xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W0 04 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilps_xmm_xmmm128_imm8 = 3728,
	/// `VPERMILPS ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W0 04 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilps_ymm_ymmm256_imm8 = 3729,
	/// `VPERMILPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 04 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilps_xmm_k1z_xmmm128b32_imm8 = 3730,
	/// `VPERMILPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 04 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilps_ymm_k1z_ymmm256b32_imm8 = 3731,
	/// `VPERMILPS zmm1 {k1}{z}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 04 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilps_zmm_k1z_zmmm512b32_imm8 = 3732,
	/// `VPERMILPD xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W0 05 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilpd_xmm_xmmm128_imm8 = 3733,
	/// `VPERMILPD ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W0 05 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpermilpd_ymm_ymmm256_imm8 = 3734,
	/// `VPERMILPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 05 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilpd_xmm_k1z_xmmm128b64_imm8 = 3735,
	/// `VPERMILPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 05 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilpd_ymm_k1z_ymmm256b64_imm8 = 3736,
	/// `VPERMILPD zmm1 {k1}{z}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 05 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpermilpd_zmm_k1z_zmmm512b64_imm8 = 3737,
	/// `VPERM2F128 ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W0 06 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vperm2f128_ymm_ymm_ymmm256_imm8 = 3738,
	/// `ROUNDPS xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 08 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Roundps_xmm_xmmm128_imm8 = 3739,
	/// `VROUNDPS xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 08 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vroundps_xmm_xmmm128_imm8 = 3740,
	/// `VROUNDPS ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 08 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vroundps_ymm_ymmm256_imm8 = 3741,
	/// `VRNDSCALEPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 08 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscaleps_xmm_k1z_xmmm128b32_imm8 = 3742,
	/// `VRNDSCALEPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 08 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscaleps_ymm_k1z_ymmm256b32_imm8 = 3743,
	/// `VRNDSCALEPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 08 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscaleps_zmm_k1z_zmmm512b32_imm8_sae = 3744,
	/// `ROUNDPD xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 09 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Roundpd_xmm_xmmm128_imm8 = 3745,
	/// `VROUNDPD xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 09 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vroundpd_xmm_xmmm128_imm8 = 3746,
	/// `VROUNDPD ymm1, ymm2/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 09 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vroundpd_ymm_ymmm256_imm8 = 3747,
	/// `VRNDSCALEPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 09 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscalepd_xmm_k1z_xmmm128b64_imm8 = 3748,
	/// `VRNDSCALEPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 09 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscalepd_ymm_k1z_ymmm256b64_imm8 = 3749,
	/// `VRNDSCALEPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 09 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscalepd_zmm_k1z_zmmm512b64_imm8_sae = 3750,
	/// `ROUNDSS xmm1, xmm2/m32, imm8`
	///
	/// `66 0F 3A 0A /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Roundss_xmm_xmmm32_imm8 = 3751,
	/// `VROUNDSS xmm1, xmm2, xmm3/m32, imm8`
	///
	/// `VEX.LIG.66.0F3A.WIG 0A /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vroundss_xmm_xmm_xmmm32_imm8 = 3752,
	/// `VRNDSCALESS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W0 0A /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscaless_xmm_k1z_xmm_xmmm32_imm8_sae = 3753,
	/// `ROUNDSD xmm1, xmm2/m64, imm8`
	///
	/// `66 0F 3A 0B /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Roundsd_xmm_xmmm64_imm8 = 3754,
	/// `VROUNDSD xmm1, xmm2, xmm3/m64, imm8`
	///
	/// `VEX.LIG.66.0F3A.WIG 0B /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vroundsd_xmm_xmm_xmmm64_imm8 = 3755,
	/// `VRNDSCALESD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W1 0B /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscalesd_xmm_k1z_xmm_xmmm64_imm8_sae = 3756,
	/// `BLENDPS xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 0C /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Blendps_xmm_xmmm128_imm8 = 3757,
	/// `VBLENDPS xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 0C /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendps_xmm_xmm_xmmm128_imm8 = 3758,
	/// `VBLENDPS ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 0C /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendps_ymm_ymm_ymmm256_imm8 = 3759,
	/// `BLENDPD xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 0D /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Blendpd_xmm_xmmm128_imm8 = 3760,
	/// `VBLENDPD xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 0D /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendpd_xmm_xmm_xmmm128_imm8 = 3761,
	/// `VBLENDPD ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 0D /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendpd_ymm_ymm_ymmm256_imm8 = 3762,
	/// `PBLENDW xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 0E /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pblendw_xmm_xmmm128_imm8 = 3763,
	/// `VPBLENDW xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 0E /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpblendw_xmm_xmm_xmmm128_imm8 = 3764,
	/// `VPBLENDW ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 0E /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpblendw_ymm_ymm_ymmm256_imm8 = 3765,
	/// `PALIGNR mm1, mm2/m64, imm8`
	///
	/// `NP 0F 3A 0F /r ib`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Palignr_mm_mmm64_imm8 = 3766,
	/// `PALIGNR xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 0F /r ib`
	///
	/// `SSSE3`
	///
	/// `16/32/64-bit`
	Palignr_xmm_xmmm128_imm8 = 3767,
	/// `VPALIGNR xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 0F /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpalignr_xmm_xmm_xmmm128_imm8 = 3768,
	/// `VPALIGNR ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 0F /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpalignr_ymm_ymm_ymmm256_imm8 = 3769,
	/// `VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.WIG 0F /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpalignr_xmm_k1z_xmm_xmmm128_imm8 = 3770,
	/// `VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.WIG 0F /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpalignr_ymm_k1z_ymm_ymmm256_imm8 = 3771,
	/// `VPALIGNR zmm1 {k1}{z}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.WIG 0F /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpalignr_zmm_k1z_zmm_zmmm512_imm8 = 3772,
	/// `PEXTRB r32/m8, xmm2, imm8`
	///
	/// `66 0F 3A 14 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pextrb_r32m8_xmm_imm8 = 3773,
	/// `PEXTRB r64/m8, xmm2, imm8`
	///
	/// `66 o64 0F 3A 14 /r ib`
	///
	/// `SSE4.1`
	///
	/// `64-bit`
	Pextrb_r64m8_xmm_imm8 = 3774,
	/// `VPEXTRB r32/m8, xmm2, imm8`
	///
	/// `VEX.128.66.0F3A.W0 14 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpextrb_r32m8_xmm_imm8 = 3775,
	/// `VPEXTRB r64/m8, xmm2, imm8`
	///
	/// `VEX.128.66.0F3A.W1 14 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpextrb_r64m8_xmm_imm8 = 3776,
	/// `VPEXTRB r32/m8, xmm2, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 14 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpextrb_r32m8_xmm_imm8 = 3777,
	/// `VPEXTRB r64/m8, xmm2, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 14 /r ib`
	///
	/// `AVX512BW`
	///
	/// `64-bit`
	EVEX_Vpextrb_r64m8_xmm_imm8 = 3778,
	/// `PEXTRW r32/m16, xmm, imm8`
	///
	/// `66 0F 3A 15 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pextrw_r32m16_xmm_imm8 = 3779,
	/// `PEXTRW r64/m16, xmm, imm8`
	///
	/// `66 o64 0F 3A 15 /r ib`
	///
	/// `SSE4.1`
	///
	/// `64-bit`
	Pextrw_r64m16_xmm_imm8 = 3780,
	/// `VPEXTRW r32/m16, xmm2, imm8`
	///
	/// `VEX.128.66.0F3A.W0 15 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpextrw_r32m16_xmm_imm8 = 3781,
	/// `VPEXTRW r64/m16, xmm2, imm8`
	///
	/// `VEX.128.66.0F3A.W1 15 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpextrw_r64m16_xmm_imm8 = 3782,
	/// `VPEXTRW r32/m16, xmm2, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 15 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpextrw_r32m16_xmm_imm8 = 3783,
	/// `VPEXTRW r64/m16, xmm2, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 15 /r ib`
	///
	/// `AVX512BW`
	///
	/// `64-bit`
	EVEX_Vpextrw_r64m16_xmm_imm8 = 3784,
	/// `PEXTRD r/m32, xmm2, imm8`
	///
	/// `66 0F 3A 16 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pextrd_rm32_xmm_imm8 = 3785,
	/// `PEXTRQ r/m64, xmm2, imm8`
	///
	/// `66 o64 0F 3A 16 /r ib`
	///
	/// `SSE4.1`
	///
	/// `64-bit`
	Pextrq_rm64_xmm_imm8 = 3786,
	/// `VPEXTRD r/m32, xmm2, imm8`
	///
	/// `VEX.128.66.0F3A.W0 16 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpextrd_rm32_xmm_imm8 = 3787,
	/// `VPEXTRQ r/m64, xmm2, imm8`
	///
	/// `VEX.128.66.0F3A.W1 16 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpextrq_rm64_xmm_imm8 = 3788,
	/// `VPEXTRD r/m32, xmm2, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 16 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpextrd_rm32_xmm_imm8 = 3789,
	/// `VPEXTRQ r/m64, xmm2, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 16 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `64-bit`
	EVEX_Vpextrq_rm64_xmm_imm8 = 3790,
	/// `EXTRACTPS r/m32, xmm1, imm8`
	///
	/// `66 0F 3A 17 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Extractps_rm32_xmm_imm8 = 3791,
	/// `EXTRACTPS r64/m32, xmm1, imm8`
	///
	/// `66 o64 0F 3A 17 /r ib`
	///
	/// `SSE4.1`
	///
	/// `64-bit`
	Extractps_r64m32_xmm_imm8 = 3792,
	/// `VEXTRACTPS r/m32, xmm1, imm8`
	///
	/// `VEX.128.66.0F3A.W0 17 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vextractps_rm32_xmm_imm8 = 3793,
	/// `VEXTRACTPS r64/m32, xmm1, imm8`
	///
	/// `VEX.128.66.0F3A.W1 17 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vextractps_r64m32_xmm_imm8 = 3794,
	/// `VEXTRACTPS r/m32, xmm1, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 17 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vextractps_rm32_xmm_imm8 = 3795,
	/// `VEXTRACTPS r64/m32, xmm1, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 17 /r ib`
	///
	/// `AVX512F`
	///
	/// `64-bit`
	EVEX_Vextractps_r64m32_xmm_imm8 = 3796,
	/// `VINSERTF128 ymm1, ymm2, xmm3/m128, imm8`
	///
	/// `VEX.256.66.0F3A.W0 18 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vinsertf128_ymm_ymm_xmmm128_imm8 = 3797,
	/// `VINSERTF32X4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 18 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vinsertf32x4_ymm_k1z_ymm_xmmm128_imm8 = 3798,
	/// `VINSERTF32X4 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 18 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vinsertf32x4_zmm_k1z_zmm_xmmm128_imm8 = 3799,
	/// `VINSERTF64X2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 18 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vinsertf64x2_ymm_k1z_ymm_xmmm128_imm8 = 3800,
	/// `VINSERTF64X2 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 18 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vinsertf64x2_zmm_k1z_zmm_xmmm128_imm8 = 3801,
	/// `VEXTRACTF128 xmm1/m128, ymm2, imm8`
	///
	/// `VEX.256.66.0F3A.W0 19 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vextractf128_xmmm128_ymm_imm8 = 3802,
	/// `VEXTRACTF32X4 xmm1/m128 {k1}{z}, ymm2, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 19 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vextractf32x4_xmmm128_k1z_ymm_imm8 = 3803,
	/// `VEXTRACTF32X4 xmm1/m128 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 19 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vextractf32x4_xmmm128_k1z_zmm_imm8 = 3804,
	/// `VEXTRACTF64X2 xmm1/m128 {k1}{z}, ymm2, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 19 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vextractf64x2_xmmm128_k1z_ymm_imm8 = 3805,
	/// `VEXTRACTF64X2 xmm1/m128 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 19 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vextractf64x2_xmmm128_k1z_zmm_imm8 = 3806,
	/// `VINSERTF32X8 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 1A /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vinsertf32x8_zmm_k1z_zmm_ymmm256_imm8 = 3807,
	/// `VINSERTF64X4 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 1A /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vinsertf64x4_zmm_k1z_zmm_ymmm256_imm8 = 3808,
	/// `VEXTRACTF32X8 ymm1/m256 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 1B /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vextractf32x8_ymmm256_k1z_zmm_imm8 = 3809,
	/// `VEXTRACTF64X4 ymm1/m256 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 1B /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vextractf64x4_ymmm256_k1z_zmm_imm8 = 3810,
	/// `VCVTPS2PH xmm1/m64, xmm2, imm8`
	///
	/// `VEX.128.66.0F3A.W0 1D /r ib`
	///
	/// `F16C`
	///
	/// `16/32/64-bit`
	VEX_Vcvtps2ph_xmmm64_xmm_imm8 = 3811,
	/// `VCVTPS2PH xmm1/m128, ymm2, imm8`
	///
	/// `VEX.256.66.0F3A.W0 1D /r ib`
	///
	/// `F16C`
	///
	/// `16/32/64-bit`
	VEX_Vcvtps2ph_xmmm128_ymm_imm8 = 3812,
	/// `VCVTPS2PH xmm1/m64 {k1}{z}, xmm2, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 1D /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2ph_xmmm64_k1z_xmm_imm8 = 3813,
	/// `VCVTPS2PH xmm1/m128 {k1}{z}, ymm2, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 1D /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2ph_xmmm128_k1z_ymm_imm8 = 3814,
	/// `VCVTPS2PH ymm1/m256 {k1}{z}, zmm2{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 1D /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2ph_ymmm256_k1z_zmm_imm8_sae = 3815,
	/// `VPCMPUD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 1E /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpud_kr_k1_xmm_xmmm128b32_imm8 = 3816,
	/// `VPCMPUD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 1E /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpud_kr_k1_ymm_ymmm256b32_imm8 = 3817,
	/// `VPCMPUD k1 {k2}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 1E /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpud_kr_k1_zmm_zmmm512b32_imm8 = 3818,
	/// `VPCMPUQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 1E /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpuq_kr_k1_xmm_xmmm128b64_imm8 = 3819,
	/// `VPCMPUQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 1E /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpuq_kr_k1_ymm_ymmm256b64_imm8 = 3820,
	/// `VPCMPUQ k1 {k2}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 1E /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpuq_kr_k1_zmm_zmmm512b64_imm8 = 3821,
	/// `VPCMPD k1 {k2}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 1F /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpd_kr_k1_xmm_xmmm128b32_imm8 = 3822,
	/// `VPCMPD k1 {k2}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 1F /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpd_kr_k1_ymm_ymmm256b32_imm8 = 3823,
	/// `VPCMPD k1 {k2}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 1F /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpd_kr_k1_zmm_zmmm512b32_imm8 = 3824,
	/// `VPCMPQ k1 {k2}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 1F /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpq_kr_k1_xmm_xmmm128b64_imm8 = 3825,
	/// `VPCMPQ k1 {k2}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 1F /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpq_kr_k1_ymm_ymmm256b64_imm8 = 3826,
	/// `VPCMPQ k1 {k2}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 1F /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpq_kr_k1_zmm_zmmm512b64_imm8 = 3827,
	/// `PINSRB xmm1, r32/m8, imm8`
	///
	/// `66 0F 3A 20 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pinsrb_xmm_r32m8_imm8 = 3828,
	/// `PINSRB xmm1, r64/m8, imm8`
	///
	/// `66 o64 0F 3A 20 /r ib`
	///
	/// `SSE4.1`
	///
	/// `64-bit`
	Pinsrb_xmm_r64m8_imm8 = 3829,
	/// `VPINSRB xmm1, xmm2, r32/m8, imm8`
	///
	/// `VEX.128.66.0F3A.W0 20 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpinsrb_xmm_xmm_r32m8_imm8 = 3830,
	/// `VPINSRB xmm1, xmm2, r64/m8, imm8`
	///
	/// `VEX.128.66.0F3A.W1 20 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpinsrb_xmm_xmm_r64m8_imm8 = 3831,
	/// `VPINSRB xmm1, xmm2, r32/m8, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 20 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpinsrb_xmm_xmm_r32m8_imm8 = 3832,
	/// `VPINSRB xmm1, xmm2, r64/m8, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 20 /r ib`
	///
	/// `AVX512BW`
	///
	/// `64-bit`
	EVEX_Vpinsrb_xmm_xmm_r64m8_imm8 = 3833,
	/// `INSERTPS xmm1, xmm2/m32, imm8`
	///
	/// `66 0F 3A 21 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Insertps_xmm_xmmm32_imm8 = 3834,
	/// `VINSERTPS xmm1, xmm2, xmm3/m32, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 21 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vinsertps_xmm_xmm_xmmm32_imm8 = 3835,
	/// `VINSERTPS xmm1, xmm2, xmm3/m32, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 21 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vinsertps_xmm_xmm_xmmm32_imm8 = 3836,
	/// `PINSRD xmm1, r/m32, imm8`
	///
	/// `66 0F 3A 22 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Pinsrd_xmm_rm32_imm8 = 3837,
	/// `PINSRQ xmm1, r/m64, imm8`
	///
	/// `66 o64 0F 3A 22 /r ib`
	///
	/// `SSE4.1`
	///
	/// `64-bit`
	Pinsrq_xmm_rm64_imm8 = 3838,
	/// `VPINSRD xmm1, xmm2, r/m32, imm8`
	///
	/// `VEX.128.66.0F3A.W0 22 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpinsrd_xmm_xmm_rm32_imm8 = 3839,
	/// `VPINSRQ xmm1, xmm2, r/m64, imm8`
	///
	/// `VEX.128.66.0F3A.W1 22 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpinsrq_xmm_xmm_rm64_imm8 = 3840,
	/// `VPINSRD xmm1, xmm2, r/m32, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 22 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpinsrd_xmm_xmm_rm32_imm8 = 3841,
	/// `VPINSRQ xmm1, xmm2, r/m64, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 22 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `64-bit`
	EVEX_Vpinsrq_xmm_xmm_rm64_imm8 = 3842,
	/// `VSHUFF32X4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 23 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshuff32x4_ymm_k1z_ymm_ymmm256b32_imm8 = 3843,
	/// `VSHUFF32X4 zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 23 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshuff32x4_zmm_k1z_zmm_zmmm512b32_imm8 = 3844,
	/// `VSHUFF64X2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 23 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshuff64x2_ymm_k1z_ymm_ymmm256b64_imm8 = 3845,
	/// `VSHUFF64X2 zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 23 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshuff64x2_zmm_k1z_zmm_zmmm512b64_imm8 = 3846,
	/// `VPTERNLOGD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 25 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpternlogd_xmm_k1z_xmm_xmmm128b32_imm8 = 3847,
	/// `VPTERNLOGD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 25 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpternlogd_ymm_k1z_ymm_ymmm256b32_imm8 = 3848,
	/// `VPTERNLOGD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 25 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpternlogd_zmm_k1z_zmm_zmmm512b32_imm8 = 3849,
	/// `VPTERNLOGQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 25 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpternlogq_xmm_k1z_xmm_xmmm128b64_imm8 = 3850,
	/// `VPTERNLOGQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 25 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpternlogq_ymm_k1z_ymm_ymmm256b64_imm8 = 3851,
	/// `VPTERNLOGQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 25 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vpternlogq_zmm_k1z_zmm_zmmm512b64_imm8 = 3852,
	/// `VGETMANTPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 26 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantps_xmm_k1z_xmmm128b32_imm8 = 3853,
	/// `VGETMANTPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 26 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantps_ymm_k1z_ymmm256b32_imm8 = 3854,
	/// `VGETMANTPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 26 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantps_zmm_k1z_zmmm512b32_imm8_sae = 3855,
	/// `VGETMANTPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 26 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantpd_xmm_k1z_xmmm128b64_imm8 = 3856,
	/// `VGETMANTPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 26 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantpd_ymm_k1z_ymmm256b64_imm8 = 3857,
	/// `VGETMANTPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 26 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantpd_zmm_k1z_zmmm512b64_imm8_sae = 3858,
	/// `VGETMANTSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W0 27 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantss_xmm_k1z_xmm_xmmm32_imm8_sae = 3859,
	/// `VGETMANTSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W1 27 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantsd_xmm_k1z_xmm_xmmm64_imm8_sae = 3860,
	/// `KSHIFTRB k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W0 30 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kshiftrb_kr_kr_imm8 = 3861,
	/// `KSHIFTRW k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W1 30 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kshiftrw_kr_kr_imm8 = 3862,
	/// `KSHIFTRD k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W0 31 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kshiftrd_kr_kr_imm8 = 3863,
	/// `KSHIFTRQ k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W1 31 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kshiftrq_kr_kr_imm8 = 3864,
	/// `KSHIFTLB k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W0 32 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	VEX_Kshiftlb_kr_kr_imm8 = 3865,
	/// `KSHIFTLW k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W1 32 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	VEX_Kshiftlw_kr_kr_imm8 = 3866,
	/// `KSHIFTLD k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W0 33 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kshiftld_kr_kr_imm8 = 3867,
	/// `KSHIFTLQ k1, k2, imm8`
	///
	/// `VEX.L0.66.0F3A.W1 33 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	VEX_Kshiftlq_kr_kr_imm8 = 3868,
	/// `VINSERTI128 ymm1, ymm2, xmm3/m128, imm8`
	///
	/// `VEX.256.66.0F3A.W0 38 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vinserti128_ymm_ymm_xmmm128_imm8 = 3869,
	/// `VINSERTI32X4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 38 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vinserti32x4_ymm_k1z_ymm_xmmm128_imm8 = 3870,
	/// `VINSERTI32X4 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 38 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vinserti32x4_zmm_k1z_zmm_xmmm128_imm8 = 3871,
	/// `VINSERTI64X2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 38 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vinserti64x2_ymm_k1z_ymm_xmmm128_imm8 = 3872,
	/// `VINSERTI64X2 zmm1 {k1}{z}, zmm2, xmm3/m128, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 38 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vinserti64x2_zmm_k1z_zmm_xmmm128_imm8 = 3873,
	/// `VEXTRACTI128 xmm1/m128, ymm2, imm8`
	///
	/// `VEX.256.66.0F3A.W0 39 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vextracti128_xmmm128_ymm_imm8 = 3874,
	/// `VEXTRACTI32X4 xmm1/m128 {k1}{z}, ymm2, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 39 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vextracti32x4_xmmm128_k1z_ymm_imm8 = 3875,
	/// `VEXTRACTI32X4 xmm1/m128 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 39 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vextracti32x4_xmmm128_k1z_zmm_imm8 = 3876,
	/// `VEXTRACTI64X2 xmm1/m128 {k1}{z}, ymm2, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 39 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vextracti64x2_xmmm128_k1z_ymm_imm8 = 3877,
	/// `VEXTRACTI64X2 xmm1/m128 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 39 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vextracti64x2_xmmm128_k1z_zmm_imm8 = 3878,
	/// `VINSERTI32X8 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 3A /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vinserti32x8_zmm_k1z_zmm_ymmm256_imm8 = 3879,
	/// `VINSERTI64X4 zmm1 {k1}{z}, zmm2, ymm3/m256, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 3A /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vinserti64x4_zmm_k1z_zmm_ymmm256_imm8 = 3880,
	/// `VEXTRACTI32X8 ymm1/m256 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 3B /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vextracti32x8_ymmm256_k1z_zmm_imm8 = 3881,
	/// `VEXTRACTI64X4 ymm1/m256 {k1}{z}, zmm2, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 3B /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vextracti64x4_ymmm256_k1z_zmm_imm8 = 3882,
	/// `VPCMPUB k1 {k2}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 3E /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpub_kr_k1_xmm_xmmm128_imm8 = 3883,
	/// `VPCMPUB k1 {k2}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 3E /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpub_kr_k1_ymm_ymmm256_imm8 = 3884,
	/// `VPCMPUB k1 {k2}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 3E /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpub_kr_k1_zmm_zmmm512_imm8 = 3885,
	/// `VPCMPUW k1 {k2}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 3E /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpuw_kr_k1_xmm_xmmm128_imm8 = 3886,
	/// `VPCMPUW k1 {k2}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 3E /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpuw_kr_k1_ymm_ymmm256_imm8 = 3887,
	/// `VPCMPUW k1 {k2}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 3E /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpuw_kr_k1_zmm_zmmm512_imm8 = 3888,
	/// `VPCMPB k1 {k2}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 3F /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpb_kr_k1_xmm_xmmm128_imm8 = 3889,
	/// `VPCMPB k1 {k2}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 3F /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpb_kr_k1_ymm_ymmm256_imm8 = 3890,
	/// `VPCMPB k1 {k2}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 3F /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpb_kr_k1_zmm_zmmm512_imm8 = 3891,
	/// `VPCMPW k1 {k2}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 3F /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpw_kr_k1_xmm_xmmm128_imm8 = 3892,
	/// `VPCMPW k1 {k2}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 3F /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpw_kr_k1_ymm_ymmm256_imm8 = 3893,
	/// `VPCMPW k1 {k2}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 3F /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vpcmpw_kr_k1_zmm_zmmm512_imm8 = 3894,
	/// `DPPS xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 40 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Dpps_xmm_xmmm128_imm8 = 3895,
	/// `VDPPS xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 40 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdpps_xmm_xmm_xmmm128_imm8 = 3896,
	/// `VDPPS ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 40 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdpps_ymm_ymm_ymmm256_imm8 = 3897,
	/// `DPPD xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 41 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Dppd_xmm_xmmm128_imm8 = 3898,
	/// `VDPPD xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 41 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vdppd_xmm_xmm_xmmm128_imm8 = 3899,
	/// `MPSADBW xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 42 /r ib`
	///
	/// `SSE4.1`
	///
	/// `16/32/64-bit`
	Mpsadbw_xmm_xmmm128_imm8 = 3900,
	/// `VMPSADBW xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 42 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vmpsadbw_xmm_xmm_xmmm128_imm8 = 3901,
	/// `VMPSADBW ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 42 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vmpsadbw_ymm_ymm_ymmm256_imm8 = 3902,
	/// `VDBPSADBW xmm1 {k1}{z}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 42 /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vdbpsadbw_xmm_k1z_xmm_xmmm128_imm8 = 3903,
	/// `VDBPSADBW ymm1 {k1}{z}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 42 /r ib`
	///
	/// `AVX512VL and AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vdbpsadbw_ymm_k1z_ymm_ymmm256_imm8 = 3904,
	/// `VDBPSADBW zmm1 {k1}{z}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 42 /r ib`
	///
	/// `AVX512BW`
	///
	/// `16/32/64-bit`
	EVEX_Vdbpsadbw_zmm_k1z_zmm_zmmm512_imm8 = 3905,
	/// `VSHUFI32X4 ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 43 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufi32x4_ymm_k1z_ymm_ymmm256b32_imm8 = 3906,
	/// `VSHUFI32X4 zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 43 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufi32x4_zmm_k1z_zmm_zmmm512b32_imm8 = 3907,
	/// `VSHUFI64X2 ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 43 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufi64x2_ymm_k1z_ymm_ymmm256b64_imm8 = 3908,
	/// `VSHUFI64X2 zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 43 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vshufi64x2_zmm_k1z_zmm_zmmm512b64_imm8 = 3909,
	/// `PCLMULQDQ xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 44 /r ib`
	///
	/// `PCLMULQDQ`
	///
	/// `16/32/64-bit`
	Pclmulqdq_xmm_xmmm128_imm8 = 3910,
	/// `VPCLMULQDQ xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 44 /r ib`
	///
	/// `PCLMULQDQ and AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8 = 3911,
	/// `VPCLMULQDQ ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.WIG 44 /r ib`
	///
	/// `VPCLMULQDQ`
	///
	/// `16/32/64-bit`
	VEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8 = 3912,
	/// `VPCLMULQDQ xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.WIG 44 /r ib`
	///
	/// `AVX512VL and VPCLMULQDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8 = 3913,
	/// `VPCLMULQDQ ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.WIG 44 /r ib`
	///
	/// `AVX512VL and VPCLMULQDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8 = 3914,
	/// `VPCLMULQDQ zmm1, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.WIG 44 /r ib`
	///
	/// `AVX512F and VPCLMULQDQ`
	///
	/// `16/32/64-bit`
	EVEX_Vpclmulqdq_zmm_zmm_zmmm512_imm8 = 3915,
	/// `VPERM2I128 ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W0 46 /r ib`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vperm2i128_ymm_ymm_ymmm256_imm8 = 3916,
	/// `VPERMIL2PS xmm1, xmm2, xmm3/m128, xmm4, imm4`
	///
	/// `VEX.128.66.0F3A.W0 48 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2ps_xmm_xmm_xmmm128_xmm_imm4 = 3917,
	/// `VPERMIL2PS ymm1, ymm2, ymm3/m256, ymm4, imm4`
	///
	/// `VEX.256.66.0F3A.W0 48 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2ps_ymm_ymm_ymmm256_ymm_imm4 = 3918,
	/// `VPERMIL2PS xmm1, xmm2, xmm3, xmm4/m128, imm4`
	///
	/// `VEX.128.66.0F3A.W1 48 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2ps_xmm_xmm_xmm_xmmm128_imm4 = 3919,
	/// `VPERMIL2PS ymm1, ymm2, ymm3, ymm4/m256, imm4`
	///
	/// `VEX.256.66.0F3A.W1 48 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2ps_ymm_ymm_ymm_ymmm256_imm4 = 3920,
	/// `VPERMIL2PD xmm1, xmm2, xmm3/m128, xmm4, imm4`
	///
	/// `VEX.128.66.0F3A.W0 49 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2pd_xmm_xmm_xmmm128_xmm_imm4 = 3921,
	/// `VPERMIL2PD ymm1, ymm2, ymm3/m256, ymm4, imm4`
	///
	/// `VEX.256.66.0F3A.W0 49 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2pd_ymm_ymm_ymmm256_ymm_imm4 = 3922,
	/// `VPERMIL2PD xmm1, xmm2, xmm3, xmm4/m128, imm4`
	///
	/// `VEX.128.66.0F3A.W1 49 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2pd_xmm_xmm_xmm_xmmm128_imm4 = 3923,
	/// `VPERMIL2PD ymm1, ymm2, ymm3, ymm4/m256, imm4`
	///
	/// `VEX.256.66.0F3A.W1 49 /r /is5`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	VEX_Vpermil2pd_ymm_ymm_ymm_ymmm256_imm4 = 3924,
	/// `VBLENDVPS xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 4A /r /is4`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendvps_xmm_xmm_xmmm128_xmm = 3925,
	/// `VBLENDVPS ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 4A /r /is4`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendvps_ymm_ymm_ymmm256_ymm = 3926,
	/// `VBLENDVPD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 4B /r /is4`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendvpd_xmm_xmm_xmmm128_xmm = 3927,
	/// `VBLENDVPD ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 4B /r /is4`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vblendvpd_ymm_ymm_ymmm256_ymm = 3928,
	/// `VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 4C /r /is4`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpblendvb_xmm_xmm_xmmm128_xmm = 3929,
	/// `VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 4C /r /is4`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vpblendvb_ymm_ymm_ymmm256_ymm = 3930,
	/// `VRANGEPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 50 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangeps_xmm_k1z_xmm_xmmm128b32_imm8 = 3931,
	/// `VRANGEPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 50 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangeps_ymm_k1z_ymm_ymmm256b32_imm8 = 3932,
	/// `VRANGEPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 50 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangeps_zmm_k1z_zmm_zmmm512b32_imm8_sae = 3933,
	/// `VRANGEPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 50 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangepd_xmm_k1z_xmm_xmmm128b64_imm8 = 3934,
	/// `VRANGEPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 50 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangepd_ymm_k1z_ymm_ymmm256b64_imm8 = 3935,
	/// `VRANGEPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 50 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangepd_zmm_k1z_zmm_zmmm512b64_imm8_sae = 3936,
	/// `VRANGESS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W0 51 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangess_xmm_k1z_xmm_xmmm32_imm8_sae = 3937,
	/// `VRANGESD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W1 51 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vrangesd_xmm_k1z_xmm_xmmm64_imm8_sae = 3938,
	/// `VFIXUPIMMPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 54 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmps_xmm_k1z_xmm_xmmm128b32_imm8 = 3939,
	/// `VFIXUPIMMPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 54 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmps_ymm_k1z_ymm_ymmm256b32_imm8 = 3940,
	/// `VFIXUPIMMPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 54 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmps_zmm_k1z_zmm_zmmm512b32_imm8_sae = 3941,
	/// `VFIXUPIMMPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 54 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmpd_xmm_k1z_xmm_xmmm128b64_imm8 = 3942,
	/// `VFIXUPIMMPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 54 /r ib`
	///
	/// `AVX512VL and AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmpd_ymm_k1z_ymm_ymmm256b64_imm8 = 3943,
	/// `VFIXUPIMMPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 54 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmpd_zmm_k1z_zmm_zmmm512b64_imm8_sae = 3944,
	/// `VFIXUPIMMSS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W0 55 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmss_xmm_k1z_xmm_xmmm32_imm8_sae = 3945,
	/// `VFIXUPIMMSD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W1 55 /r ib`
	///
	/// `AVX512F`
	///
	/// `16/32/64-bit`
	EVEX_Vfixupimmsd_xmm_k1z_xmm_xmmm64_imm8_sae = 3946,
	/// `VREDUCEPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 56 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreduceps_xmm_k1z_xmmm128b32_imm8 = 3947,
	/// `VREDUCEPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 56 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreduceps_ymm_k1z_ymmm256b32_imm8 = 3948,
	/// `VREDUCEPS zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 56 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreduceps_zmm_k1z_zmmm512b32_imm8_sae = 3949,
	/// `VREDUCEPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 56 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreducepd_xmm_k1z_xmmm128b64_imm8 = 3950,
	/// `VREDUCEPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 56 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreducepd_ymm_k1z_ymmm256b64_imm8 = 3951,
	/// `VREDUCEPD zmm1 {k1}{z}, zmm2/m512/m64bcst{sae}, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 56 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreducepd_zmm_k1z_zmmm512b64_imm8_sae = 3952,
	/// `VREDUCESS xmm1 {k1}{z}, xmm2, xmm3/m32{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W0 57 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreducess_xmm_k1z_xmm_xmmm32_imm8_sae = 3953,
	/// `VREDUCESD xmm1 {k1}{z}, xmm2, xmm3/m64{sae}, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W1 57 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vreducesd_xmm_k1z_xmm_xmmm64_imm8_sae = 3954,
	/// `VFMADDSUBPS xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 5C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubps_xmm_xmm_xmmm128_xmm = 3955,
	/// `VFMADDSUBPS ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 5C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubps_ymm_ymm_ymmm256_ymm = 3956,
	/// `VFMADDSUBPS xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 5C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubps_xmm_xmm_xmm_xmmm128 = 3957,
	/// `VFMADDSUBPS ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 5C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubps_ymm_ymm_ymm_ymmm256 = 3958,
	/// `VFMADDSUBPD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 5D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubpd_xmm_xmm_xmmm128_xmm = 3959,
	/// `VFMADDSUBPD ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 5D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubpd_ymm_ymm_ymmm256_ymm = 3960,
	/// `VFMADDSUBPD xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 5D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubpd_xmm_xmm_xmm_xmmm128 = 3961,
	/// `VFMADDSUBPD ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 5D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsubpd_ymm_ymm_ymm_ymmm256 = 3962,
	/// `VFMSUBADDPS xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 5E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddps_xmm_xmm_xmmm128_xmm = 3963,
	/// `VFMSUBADDPS ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 5E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddps_ymm_ymm_ymmm256_ymm = 3964,
	/// `VFMSUBADDPS xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 5E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddps_xmm_xmm_xmm_xmmm128 = 3965,
	/// `VFMSUBADDPS ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 5E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddps_ymm_ymm_ymm_ymmm256 = 3966,
	/// `VFMSUBADDPD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 5F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddpd_xmm_xmm_xmmm128_xmm = 3967,
	/// `VFMSUBADDPD ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 5F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddpd_ymm_ymm_ymmm256_ymm = 3968,
	/// `VFMSUBADDPD xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 5F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddpd_xmm_xmm_xmm_xmmm128 = 3969,
	/// `VFMSUBADDPD ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 5F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubaddpd_ymm_ymm_ymm_ymmm256 = 3970,
	/// `PCMPESTRM xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 60 /r ib`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Pcmpestrm_xmm_xmmm128_imm8 = 3971,
	/// `PCMPESTRM64 xmm1, xmm2/m128, imm8`
	///
	/// `66 o64 0F 3A 60 /r ib`
	///
	/// `SSE4.2`
	///
	/// `64-bit`
	Pcmpestrm64_xmm_xmmm128_imm8 = 3972,
	/// `VPCMPESTRM xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W0 60 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpestrm_xmm_xmmm128_imm8 = 3973,
	/// `VPCMPESTRM64 xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W1 60 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpcmpestrm64_xmm_xmmm128_imm8 = 3974,
	/// `PCMPESTRI xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 61 /r ib`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Pcmpestri_xmm_xmmm128_imm8 = 3975,
	/// `PCMPESTRI64 xmm1, xmm2/m128, imm8`
	///
	/// `66 o64 0F 3A 61 /r ib`
	///
	/// `SSE4.2`
	///
	/// `64-bit`
	Pcmpestri64_xmm_xmmm128_imm8 = 3976,
	/// `VPCMPESTRI xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W0 61 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpestri_xmm_xmmm128_imm8 = 3977,
	/// `VPCMPESTRI64 xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W1 61 /r ib`
	///
	/// `AVX`
	///
	/// `64-bit`
	VEX_Vpcmpestri64_xmm_xmmm128_imm8 = 3978,
	/// `PCMPISTRM xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 62 /r ib`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Pcmpistrm_xmm_xmmm128_imm8 = 3979,
	/// `VPCMPISTRM xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 62 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpistrm_xmm_xmmm128_imm8 = 3980,
	/// `PCMPISTRI xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A 63 /r ib`
	///
	/// `SSE4.2`
	///
	/// `16/32/64-bit`
	Pcmpistri_xmm_xmmm128_imm8 = 3981,
	/// `VPCMPISTRI xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG 63 /r ib`
	///
	/// `AVX`
	///
	/// `16/32/64-bit`
	VEX_Vpcmpistri_xmm_xmmm128_imm8 = 3982,
	/// `VFPCLASSPS k2 {k1}, xmm2/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 66 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclassps_kr_k1_xmmm128b32_imm8 = 3983,
	/// `VFPCLASSPS k2 {k1}, ymm2/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 66 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclassps_kr_k1_ymmm256b32_imm8 = 3984,
	/// `VFPCLASSPS k2 {k1}, zmm2/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 66 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclassps_kr_k1_zmmm512b32_imm8 = 3985,
	/// `VFPCLASSPD k2 {k1}, xmm2/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 66 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclasspd_kr_k1_xmmm128b64_imm8 = 3986,
	/// `VFPCLASSPD k2 {k1}, ymm2/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 66 /r ib`
	///
	/// `AVX512VL and AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclasspd_kr_k1_ymmm256b64_imm8 = 3987,
	/// `VFPCLASSPD k2 {k1}, zmm2/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 66 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclasspd_kr_k1_zmmm512b64_imm8 = 3988,
	/// `VFPCLASSSS k2 {k1}, xmm2/m32, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W0 67 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclassss_kr_k1_xmmm32_imm8 = 3989,
	/// `VFPCLASSSD k2 {k1}, xmm2/m64, imm8`
	///
	/// `EVEX.LIG.66.0F3A.W1 67 /r ib`
	///
	/// `AVX512DQ`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclasssd_kr_k1_xmmm64_imm8 = 3990,
	/// `VFMADDPS xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 68 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddps_xmm_xmm_xmmm128_xmm = 3991,
	/// `VFMADDPS ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 68 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddps_ymm_ymm_ymmm256_ymm = 3992,
	/// `VFMADDPS xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 68 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddps_xmm_xmm_xmm_xmmm128 = 3993,
	/// `VFMADDPS ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 68 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddps_ymm_ymm_ymm_ymmm256 = 3994,
	/// `VFMADDPD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 69 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddpd_xmm_xmm_xmmm128_xmm = 3995,
	/// `VFMADDPD ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 69 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddpd_ymm_ymm_ymmm256_ymm = 3996,
	/// `VFMADDPD xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 69 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddpd_xmm_xmm_xmm_xmmm128 = 3997,
	/// `VFMADDPD ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 69 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddpd_ymm_ymm_ymm_ymmm256 = 3998,
	/// `VFMADDSS xmm1, xmm2, xmm3/m32, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 6A /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddss_xmm_xmm_xmmm32_xmm = 3999,
	/// `VFMADDSS xmm1, xmm2, xmm3, xmm4/m32`
	///
	/// `VEX.LIG.66.0F3A.W1 6A /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddss_xmm_xmm_xmm_xmmm32 = 4000,
	/// `VFMADDSD xmm1, xmm2, xmm3/m64, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 6B /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsd_xmm_xmm_xmmm64_xmm = 4001,
	/// `VFMADDSD xmm1, xmm2, xmm3, xmm4/m64`
	///
	/// `VEX.LIG.66.0F3A.W1 6B /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmaddsd_xmm_xmm_xmm_xmmm64 = 4002,
	/// `VFMSUBPS xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 6C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubps_xmm_xmm_xmmm128_xmm = 4003,
	/// `VFMSUBPS ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 6C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubps_ymm_ymm_ymmm256_ymm = 4004,
	/// `VFMSUBPS xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 6C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubps_xmm_xmm_xmm_xmmm128 = 4005,
	/// `VFMSUBPS ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 6C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubps_ymm_ymm_ymm_ymmm256 = 4006,
	/// `VFMSUBPD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 6D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubpd_xmm_xmm_xmmm128_xmm = 4007,
	/// `VFMSUBPD ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 6D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubpd_ymm_ymm_ymmm256_ymm = 4008,
	/// `VFMSUBPD xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 6D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubpd_xmm_xmm_xmm_xmmm128 = 4009,
	/// `VFMSUBPD ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 6D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubpd_ymm_ymm_ymm_ymmm256 = 4010,
	/// `VFMSUBSS xmm1, xmm2, xmm3/m32, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 6E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubss_xmm_xmm_xmmm32_xmm = 4011,
	/// `VFMSUBSS xmm1, xmm2, xmm3, xmm4/m32`
	///
	/// `VEX.LIG.66.0F3A.W1 6E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubss_xmm_xmm_xmm_xmmm32 = 4012,
	/// `VFMSUBSD xmm1, xmm2, xmm3/m64, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 6F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubsd_xmm_xmm_xmmm64_xmm = 4013,
	/// `VFMSUBSD xmm1, xmm2, xmm3, xmm4/m64`
	///
	/// `VEX.LIG.66.0F3A.W1 6F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfmsubsd_xmm_xmm_xmm_xmmm64 = 4014,
	/// `VPSHLDW xmm1 {k1}{z}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 70 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldw_xmm_k1z_xmm_xmmm128_imm8 = 4015,
	/// `VPSHLDW ymm1 {k1}{z}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 70 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldw_ymm_k1z_ymm_ymmm256_imm8 = 4016,
	/// `VPSHLDW zmm1 {k1}{z}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 70 /r ib`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldw_zmm_k1z_zmm_zmmm512_imm8 = 4017,
	/// `VPSHLDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 71 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldd_xmm_k1z_xmm_xmmm128b32_imm8 = 4018,
	/// `VPSHLDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 71 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldd_ymm_k1z_ymm_ymmm256b32_imm8 = 4019,
	/// `VPSHLDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 71 /r ib`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldd_zmm_k1z_zmm_zmmm512b32_imm8 = 4020,
	/// `VPSHLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 71 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldq_xmm_k1z_xmm_xmmm128b64_imm8 = 4021,
	/// `VPSHLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 71 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldq_ymm_k1z_ymm_ymmm256b64_imm8 = 4022,
	/// `VPSHLDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 71 /r ib`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshldq_zmm_k1z_zmm_zmmm512b64_imm8 = 4023,
	/// `VPSHRDW xmm1 {k1}{z}, xmm2, xmm3/m128, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 72 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdw_xmm_k1z_xmm_xmmm128_imm8 = 4024,
	/// `VPSHRDW ymm1 {k1}{z}, ymm2, ymm3/m256, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 72 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdw_ymm_k1z_ymm_ymmm256_imm8 = 4025,
	/// `VPSHRDW zmm1 {k1}{z}, zmm2, zmm3/m512, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 72 /r ib`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdw_zmm_k1z_zmm_zmmm512_imm8 = 4026,
	/// `VPSHRDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W0 73 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdd_xmm_k1z_xmm_xmmm128b32_imm8 = 4027,
	/// `VPSHRDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W0 73 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdd_ymm_k1z_ymm_ymmm256b32_imm8 = 4028,
	/// `VPSHRDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W0 73 /r ib`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdd_zmm_k1z_zmm_zmmm512b32_imm8 = 4029,
	/// `VPSHRDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 73 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdq_xmm_k1z_xmm_xmmm128b64_imm8 = 4030,
	/// `VPSHRDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 73 /r ib`
	///
	/// `AVX512VL and AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdq_ymm_k1z_ymm_ymmm256b64_imm8 = 4031,
	/// `VPSHRDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 73 /r ib`
	///
	/// `AVX512_VBMI2`
	///
	/// `16/32/64-bit`
	EVEX_Vpshrdq_zmm_k1z_zmm_zmmm512b64_imm8 = 4032,
	/// `VFNMADDPS xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 78 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddps_xmm_xmm_xmmm128_xmm = 4033,
	/// `VFNMADDPS ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 78 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddps_ymm_ymm_ymmm256_ymm = 4034,
	/// `VFNMADDPS xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 78 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddps_xmm_xmm_xmm_xmmm128 = 4035,
	/// `VFNMADDPS ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 78 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddps_ymm_ymm_ymm_ymmm256 = 4036,
	/// `VFNMADDPD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 79 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddpd_xmm_xmm_xmmm128_xmm = 4037,
	/// `VFNMADDPD ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 79 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddpd_ymm_ymm_ymmm256_ymm = 4038,
	/// `VFNMADDPD xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 79 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddpd_xmm_xmm_xmm_xmmm128 = 4039,
	/// `VFNMADDPD ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 79 /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddpd_ymm_ymm_ymm_ymmm256 = 4040,
	/// `VFNMADDSS xmm1, xmm2, xmm3/m32, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 7A /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddss_xmm_xmm_xmmm32_xmm = 4041,
	/// `VFNMADDSS xmm1, xmm2, xmm3, xmm4/m32`
	///
	/// `VEX.LIG.66.0F3A.W1 7A /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddss_xmm_xmm_xmm_xmmm32 = 4042,
	/// `VFNMADDSD xmm1, xmm2, xmm3/m64, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 7B /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddsd_xmm_xmm_xmmm64_xmm = 4043,
	/// `VFNMADDSD xmm1, xmm2, xmm3, xmm4/m64`
	///
	/// `VEX.LIG.66.0F3A.W1 7B /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmaddsd_xmm_xmm_xmm_xmmm64 = 4044,
	/// `VFNMSUBPS xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 7C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubps_xmm_xmm_xmmm128_xmm = 4045,
	/// `VFNMSUBPS ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 7C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubps_ymm_ymm_ymmm256_ymm = 4046,
	/// `VFNMSUBPS xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 7C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubps_xmm_xmm_xmm_xmmm128 = 4047,
	/// `VFNMSUBPS ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 7C /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubps_ymm_ymm_ymm_ymmm256 = 4048,
	/// `VFNMSUBPD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `VEX.128.66.0F3A.W0 7D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubpd_xmm_xmm_xmmm128_xmm = 4049,
	/// `VFNMSUBPD ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `VEX.256.66.0F3A.W0 7D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubpd_ymm_ymm_ymmm256_ymm = 4050,
	/// `VFNMSUBPD xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `VEX.128.66.0F3A.W1 7D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubpd_xmm_xmm_xmm_xmmm128 = 4051,
	/// `VFNMSUBPD ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `VEX.256.66.0F3A.W1 7D /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubpd_ymm_ymm_ymm_ymmm256 = 4052,
	/// `VFNMSUBSS xmm1, xmm2, xmm3/m32, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 7E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubss_xmm_xmm_xmmm32_xmm = 4053,
	/// `VFNMSUBSS xmm1, xmm2, xmm3, xmm4/m32`
	///
	/// `VEX.LIG.66.0F3A.W1 7E /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubss_xmm_xmm_xmm_xmmm32 = 4054,
	/// `VFNMSUBSD xmm1, xmm2, xmm3/m64, xmm4`
	///
	/// `VEX.LIG.66.0F3A.W0 7F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubsd_xmm_xmm_xmmm64_xmm = 4055,
	/// `VFNMSUBSD xmm1, xmm2, xmm3, xmm4/m64`
	///
	/// `VEX.LIG.66.0F3A.W1 7F /r /is4`
	///
	/// `FMA4`
	///
	/// `16/32/64-bit`
	VEX_Vfnmsubsd_xmm_xmm_xmm_xmmm64 = 4056,
	/// `SHA1RNDS4 xmm1, xmm2/m128, imm8`
	///
	/// `NP 0F 3A CC /r ib`
	///
	/// `SHA`
	///
	/// `16/32/64-bit`
	Sha1rnds4_xmm_xmmm128_imm8 = 4057,
	/// `GF2P8AFFINEQB xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A CE /r ib`
	///
	/// `GFNI`
	///
	/// `16/32/64-bit`
	Gf2p8affineqb_xmm_xmmm128_imm8 = 4058,
	/// `VGF2P8AFFINEQB xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W1 CE /r ib`
	///
	/// `AVX and GFNI`
	///
	/// `16/32/64-bit`
	VEX_Vgf2p8affineqb_xmm_xmm_xmmm128_imm8 = 4059,
	/// `VGF2P8AFFINEQB ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W1 CE /r ib`
	///
	/// `AVX and GFNI`
	///
	/// `16/32/64-bit`
	VEX_Vgf2p8affineqb_ymm_ymm_ymmm256_imm8 = 4060,
	/// `VGF2P8AFFINEQB xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 CE /r ib`
	///
	/// `AVX512VL and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8affineqb_xmm_k1z_xmm_xmmm128b64_imm8 = 4061,
	/// `VGF2P8AFFINEQB ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 CE /r ib`
	///
	/// `AVX512VL and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8affineqb_ymm_k1z_ymm_ymmm256b64_imm8 = 4062,
	/// `VGF2P8AFFINEQB zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 CE /r ib`
	///
	/// `AVX512F and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8affineqb_zmm_k1z_zmm_zmmm512b64_imm8 = 4063,
	/// `GF2P8AFFINEINVQB xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A CF /r ib`
	///
	/// `GFNI`
	///
	/// `16/32/64-bit`
	Gf2p8affineinvqb_xmm_xmmm128_imm8 = 4064,
	/// `VGF2P8AFFINEINVQB xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `VEX.128.66.0F3A.W1 CF /r ib`
	///
	/// `AVX and GFNI`
	///
	/// `16/32/64-bit`
	VEX_Vgf2p8affineinvqb_xmm_xmm_xmmm128_imm8 = 4065,
	/// `VGF2P8AFFINEINVQB ymm1, ymm2, ymm3/m256, imm8`
	///
	/// `VEX.256.66.0F3A.W1 CF /r ib`
	///
	/// `AVX and GFNI`
	///
	/// `16/32/64-bit`
	VEX_Vgf2p8affineinvqb_ymm_ymm_ymmm256_imm8 = 4066,
	/// `VGF2P8AFFINEINVQB xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8`
	///
	/// `EVEX.128.66.0F3A.W1 CF /r ib`
	///
	/// `AVX512VL and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8affineinvqb_xmm_k1z_xmm_xmmm128b64_imm8 = 4067,
	/// `VGF2P8AFFINEINVQB ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8`
	///
	/// `EVEX.256.66.0F3A.W1 CF /r ib`
	///
	/// `AVX512VL and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8affineinvqb_ymm_k1z_ymm_ymmm256b64_imm8 = 4068,
	/// `VGF2P8AFFINEINVQB zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst, imm8`
	///
	/// `EVEX.512.66.0F3A.W1 CF /r ib`
	///
	/// `AVX512F and GFNI`
	///
	/// `16/32/64-bit`
	EVEX_Vgf2p8affineinvqb_zmm_k1z_zmm_zmmm512b64_imm8 = 4069,
	/// `AESKEYGENASSIST xmm1, xmm2/m128, imm8`
	///
	/// `66 0F 3A DF /r ib`
	///
	/// `AES`
	///
	/// `16/32/64-bit`
	Aeskeygenassist_xmm_xmmm128_imm8 = 4070,
	/// `VAESKEYGENASSIST xmm1, xmm2/m128, imm8`
	///
	/// `VEX.128.66.0F3A.WIG DF /r ib`
	///
	/// `AES and AVX`
	///
	/// `16/32/64-bit`
	VEX_Vaeskeygenassist_xmm_xmmm128_imm8 = 4071,
	/// `RORX r32, r/m32, imm8`
	///
	/// `VEX.LZ.F2.0F3A.W0 F0 /r ib`
	///
	/// `BMI2`
	///
	/// `16/32/64-bit`
	VEX_Rorx_r32_rm32_imm8 = 4072,
	/// `RORX r64, r/m64, imm8`
	///
	/// `VEX.LZ.F2.0F3A.W1 F0 /r ib`
	///
	/// `BMI2`
	///
	/// `64-bit`
	VEX_Rorx_r64_rm64_imm8 = 4073,
	/// `VPMACSSWW xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 85 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacssww_xmm_xmm_xmmm128_xmm = 4074,
	/// `VPMACSSWD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 86 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacsswd_xmm_xmm_xmmm128_xmm = 4075,
	/// `VPMACSSDQL xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 87 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacssdql_xmm_xmm_xmmm128_xmm = 4076,
	/// `VPMACSSDD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 8E /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacssdd_xmm_xmm_xmmm128_xmm = 4077,
	/// `VPMACSSDQH xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 8F /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacssdqh_xmm_xmm_xmmm128_xmm = 4078,
	/// `VPMACSWW xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 95 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacsww_xmm_xmm_xmmm128_xmm = 4079,
	/// `VPMACSWD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 96 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacswd_xmm_xmm_xmmm128_xmm = 4080,
	/// `VPMACSDQL xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 97 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacsdql_xmm_xmm_xmmm128_xmm = 4081,
	/// `VPMACSDD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 9E /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacsdd_xmm_xmm_xmmm128_xmm = 4082,
	/// `VPMACSDQH xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 9F /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmacsdqh_xmm_xmm_xmmm128_xmm = 4083,
	/// `VPCMOV xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 A2 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcmov_xmm_xmm_xmmm128_xmm = 4084,
	/// `VPCMOV ymm1, ymm2, ymm3/m256, ymm4`
	///
	/// `XOP.256.X8.W0 A2 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcmov_ymm_ymm_ymmm256_ymm = 4085,
	/// `VPCMOV xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `XOP.128.X8.W1 A2 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcmov_xmm_xmm_xmm_xmmm128 = 4086,
	/// `VPCMOV ymm1, ymm2, ymm3, ymm4/m256`
	///
	/// `XOP.256.X8.W1 A2 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcmov_ymm_ymm_ymm_ymmm256 = 4087,
	/// `VPPERM xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 A3 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpperm_xmm_xmm_xmmm128_xmm = 4088,
	/// `VPPERM xmm1, xmm2, xmm3, xmm4/m128`
	///
	/// `XOP.128.X8.W1 A3 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpperm_xmm_xmm_xmm_xmmm128 = 4089,
	/// `VPMADCSSWD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 A6 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmadcsswd_xmm_xmm_xmmm128_xmm = 4090,
	/// `VPMADCSWD xmm1, xmm2, xmm3/m128, xmm4`
	///
	/// `XOP.128.X8.W0 B6 /r /is4`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpmadcswd_xmm_xmm_xmmm128_xmm = 4091,
	/// `VPROTB xmm1, xmm2/m128, imm8`
	///
	/// `XOP.128.X8.W0 C0 /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotb_xmm_xmmm128_imm8 = 4092,
	/// `VPROTW xmm1, xmm2/m128, imm8`
	///
	/// `XOP.128.X8.W0 C1 /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotw_xmm_xmmm128_imm8 = 4093,
	/// `VPROTD xmm1, xmm2/m128, imm8`
	///
	/// `XOP.128.X8.W0 C2 /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotd_xmm_xmmm128_imm8 = 4094,
	/// `VPROTQ xmm1, xmm2/m128, imm8`
	///
	/// `XOP.128.X8.W0 C3 /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotq_xmm_xmmm128_imm8 = 4095,
	/// `VPCOMB xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 CC /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomb_xmm_xmm_xmmm128_imm8 = 4096,
	/// `VPCOMW xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 CD /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomw_xmm_xmm_xmmm128_imm8 = 4097,
	/// `VPCOMD xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 CE /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomd_xmm_xmm_xmmm128_imm8 = 4098,
	/// `VPCOMQ xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 CF /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomq_xmm_xmm_xmmm128_imm8 = 4099,
	/// `VPCOMUB xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 EC /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomub_xmm_xmm_xmmm128_imm8 = 4100,
	/// `VPCOMUW xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 ED /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomuw_xmm_xmm_xmmm128_imm8 = 4101,
	/// `VPCOMUD xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 EE /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomud_xmm_xmm_xmmm128_imm8 = 4102,
	/// `VPCOMUQ xmm1, xmm2, xmm3/m128, imm8`
	///
	/// `XOP.128.X8.W0 EF /r ib`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpcomuq_xmm_xmm_xmmm128_imm8 = 4103,
	/// `BLCFILL r32, r/m32`
	///
	/// `XOP.L0.X9.W0 01 /1`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Blcfill_r32_rm32 = 4104,
	/// `BLCFILL r64, r/m64`
	///
	/// `XOP.L0.X9.W1 01 /1`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Blcfill_r64_rm64 = 4105,
	/// `BLSFILL r32, r/m32`
	///
	/// `XOP.L0.X9.W0 01 /2`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Blsfill_r32_rm32 = 4106,
	/// `BLSFILL r64, r/m64`
	///
	/// `XOP.L0.X9.W1 01 /2`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Blsfill_r64_rm64 = 4107,
	/// `BLCS r32, r/m32`
	///
	/// `XOP.L0.X9.W0 01 /3`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Blcs_r32_rm32 = 4108,
	/// `BLCS r64, r/m64`
	///
	/// `XOP.L0.X9.W1 01 /3`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Blcs_r64_rm64 = 4109,
	/// `TZMSK r32, r/m32`
	///
	/// `XOP.L0.X9.W0 01 /4`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Tzmsk_r32_rm32 = 4110,
	/// `TZMSK r64, r/m64`
	///
	/// `XOP.L0.X9.W1 01 /4`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Tzmsk_r64_rm64 = 4111,
	/// `BLCIC r32, r/m32`
	///
	/// `XOP.L0.X9.W0 01 /5`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Blcic_r32_rm32 = 4112,
	/// `BLCIC r64, r/m64`
	///
	/// `XOP.L0.X9.W1 01 /5`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Blcic_r64_rm64 = 4113,
	/// `BLSIC r32, r/m32`
	///
	/// `XOP.L0.X9.W0 01 /6`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Blsic_r32_rm32 = 4114,
	/// `BLSIC r64, r/m64`
	///
	/// `XOP.L0.X9.W1 01 /6`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Blsic_r64_rm64 = 4115,
	/// `T1MSKC r32, r/m32`
	///
	/// `XOP.L0.X9.W0 01 /7`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_T1mskc_r32_rm32 = 4116,
	/// `T1MSKC r64, r/m64`
	///
	/// `XOP.L0.X9.W1 01 /7`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_T1mskc_r64_rm64 = 4117,
	/// `BLCMSK r32, r/m32`
	///
	/// `XOP.L0.X9.W0 02 /1`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Blcmsk_r32_rm32 = 4118,
	/// `BLCMSK r64, r/m64`
	///
	/// `XOP.L0.X9.W1 02 /1`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Blcmsk_r64_rm64 = 4119,
	/// `BLCI r32, r/m32`
	///
	/// `XOP.L0.X9.W0 02 /6`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Blci_r32_rm32 = 4120,
	/// `BLCI r64, r/m64`
	///
	/// `XOP.L0.X9.W1 02 /6`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Blci_r64_rm64 = 4121,
	/// `LLWPCB r32`
	///
	/// `XOP.L0.X9.W0 12 /0`
	///
	/// `LWP`
	///
	/// `16/32/64-bit`
	XOP_Llwpcb_r32 = 4122,
	/// `LLWPCB r64`
	///
	/// `XOP.L0.X9.W1 12 /0`
	///
	/// `LWP`
	///
	/// `64-bit`
	XOP_Llwpcb_r64 = 4123,
	/// `SLWPCB r32`
	///
	/// `XOP.L0.X9.W0 12 /1`
	///
	/// `LWP`
	///
	/// `16/32/64-bit`
	XOP_Slwpcb_r32 = 4124,
	/// `SLWPCB r64`
	///
	/// `XOP.L0.X9.W1 12 /1`
	///
	/// `LWP`
	///
	/// `64-bit`
	XOP_Slwpcb_r64 = 4125,
	/// `VFRCZPS xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 80 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vfrczps_xmm_xmmm128 = 4126,
	/// `VFRCZPS ymm1, ymm2/m256`
	///
	/// `XOP.256.X9.W0 80 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vfrczps_ymm_ymmm256 = 4127,
	/// `VFRCZPD xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 81 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vfrczpd_xmm_xmmm128 = 4128,
	/// `VFRCZPD ymm1, ymm2/m256`
	///
	/// `XOP.256.X9.W0 81 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vfrczpd_ymm_ymmm256 = 4129,
	/// `VFRCZSS xmm1, xmm2/m32`
	///
	/// `XOP.128.X9.W0 82 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vfrczss_xmm_xmmm32 = 4130,
	/// `VFRCZSD xmm1, xmm2/m64`
	///
	/// `XOP.128.X9.W0 83 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vfrczsd_xmm_xmmm64 = 4131,
	/// `VPROTB xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 90 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotb_xmm_xmmm128_xmm = 4132,
	/// `VPROTB xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 90 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotb_xmm_xmm_xmmm128 = 4133,
	/// `VPROTW xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 91 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotw_xmm_xmmm128_xmm = 4134,
	/// `VPROTW xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 91 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotw_xmm_xmm_xmmm128 = 4135,
	/// `VPROTD xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 92 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotd_xmm_xmmm128_xmm = 4136,
	/// `VPROTD xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 92 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotd_xmm_xmm_xmmm128 = 4137,
	/// `VPROTQ xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 93 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotq_xmm_xmmm128_xmm = 4138,
	/// `VPROTQ xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 93 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vprotq_xmm_xmm_xmmm128 = 4139,
	/// `VPSHLB xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 94 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshlb_xmm_xmmm128_xmm = 4140,
	/// `VPSHLB xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 94 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshlb_xmm_xmm_xmmm128 = 4141,
	/// `VPSHLW xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 95 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshlw_xmm_xmmm128_xmm = 4142,
	/// `VPSHLW xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 95 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshlw_xmm_xmm_xmmm128 = 4143,
	/// `VPSHLD xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 96 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshld_xmm_xmmm128_xmm = 4144,
	/// `VPSHLD xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 96 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshld_xmm_xmm_xmmm128 = 4145,
	/// `VPSHLQ xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 97 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshlq_xmm_xmmm128_xmm = 4146,
	/// `VPSHLQ xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 97 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshlq_xmm_xmm_xmmm128 = 4147,
	/// `VPSHAB xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 98 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshab_xmm_xmmm128_xmm = 4148,
	/// `VPSHAB xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 98 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshab_xmm_xmm_xmmm128 = 4149,
	/// `VPSHAW xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 99 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshaw_xmm_xmmm128_xmm = 4150,
	/// `VPSHAW xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 99 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshaw_xmm_xmm_xmmm128 = 4151,
	/// `VPSHAD xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 9A /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshad_xmm_xmmm128_xmm = 4152,
	/// `VPSHAD xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 9A /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshad_xmm_xmm_xmmm128 = 4153,
	/// `VPSHAQ xmm1, xmm2/m128, xmm3`
	///
	/// `XOP.128.X9.W0 9B /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshaq_xmm_xmmm128_xmm = 4154,
	/// `VPSHAQ xmm1, xmm2, xmm3/m128`
	///
	/// `XOP.128.X9.W1 9B /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vpshaq_xmm_xmm_xmmm128 = 4155,
	/// `VPHADDBW xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 C1 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddbw_xmm_xmmm128 = 4156,
	/// `VPHADDBD xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 C2 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddbd_xmm_xmmm128 = 4157,
	/// `VPHADDBQ xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 C3 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddbq_xmm_xmmm128 = 4158,
	/// `VPHADDWD xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 C6 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddwd_xmm_xmmm128 = 4159,
	/// `VPHADDWQ xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 C7 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddwq_xmm_xmmm128 = 4160,
	/// `VPHADDDQ xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 CB /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphadddq_xmm_xmmm128 = 4161,
	/// `VPHADDUBW xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 D1 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddubw_xmm_xmmm128 = 4162,
	/// `VPHADDUBD xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 D2 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddubd_xmm_xmmm128 = 4163,
	/// `VPHADDUBQ xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 D3 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddubq_xmm_xmmm128 = 4164,
	/// `VPHADDUWD xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 D6 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphadduwd_xmm_xmmm128 = 4165,
	/// `VPHADDUWQ xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 D7 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphadduwq_xmm_xmmm128 = 4166,
	/// `VPHADDUDQ xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 DB /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphaddudq_xmm_xmmm128 = 4167,
	/// `VPHSUBBW xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 E1 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphsubbw_xmm_xmmm128 = 4168,
	/// `VPHSUBWD xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 E2 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphsubwd_xmm_xmmm128 = 4169,
	/// `VPHSUBDQ xmm1, xmm2/m128`
	///
	/// `XOP.128.X9.W0 E3 /r`
	///
	/// `XOP`
	///
	/// `16/32/64-bit`
	XOP_Vphsubdq_xmm_xmmm128 = 4170,
	/// `BEXTR r32, r/m32, imm32`
	///
	/// `XOP.L0.XA.W0 10 /r id`
	///
	/// `TBM`
	///
	/// `16/32/64-bit`
	XOP_Bextr_r32_rm32_imm32 = 4171,
	/// `BEXTR r64, r/m64, imm32`
	///
	/// `XOP.L0.XA.W1 10 /r id`
	///
	/// `TBM`
	///
	/// `64-bit`
	XOP_Bextr_r64_rm64_imm32 = 4172,
	/// `LWPINS r32, r/m32, imm32`
	///
	/// `XOP.L0.XA.W0 12 /0 id`
	///
	/// `LWP`
	///
	/// `16/32/64-bit`
	XOP_Lwpins_r32_rm32_imm32 = 4173,
	/// `LWPINS r64, r/m32, imm32`
	///
	/// `XOP.L0.XA.W1 12 /0 id`
	///
	/// `LWP`
	///
	/// `64-bit`
	XOP_Lwpins_r64_rm32_imm32 = 4174,
	/// `LWPVAL r32, r/m32, imm32`
	///
	/// `XOP.L0.XA.W0 12 /1 id`
	///
	/// `LWP`
	///
	/// `16/32/64-bit`
	XOP_Lwpval_r32_rm32_imm32 = 4175,
	/// `LWPVAL r64, r/m32, imm32`
	///
	/// `XOP.L0.XA.W1 12 /1 id`
	///
	/// `LWP`
	///
	/// `64-bit`
	XOP_Lwpval_r64_rm32_imm32 = 4176,
	/// `PI2FW mm, mm/m64`
	///
	/// `0F 0F /r 0C`
	///
	/// `3DNOWEXT`
	///
	/// `16/32/64-bit`
	D3NOW_Pi2fw_mm_mmm64 = 4177,
	/// `PI2FD mm, mm/m64`
	///
	/// `0F 0F /r 0D`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pi2fd_mm_mmm64 = 4178,
	/// `PF2IW mm, mm/m64`
	///
	/// `0F 0F /r 1C`
	///
	/// `3DNOWEXT`
	///
	/// `16/32/64-bit`
	D3NOW_Pf2iw_mm_mmm64 = 4179,
	/// `PF2ID mm, mm/m64`
	///
	/// `0F 0F /r 1D`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pf2id_mm_mmm64 = 4180,
	/// `PFRCPV mm, mm/m64`
	///
	/// `0F 0F /r 86`
	///
	/// `AMD Geode GX/LX`
	///
	/// `16/32-bit`
	D3NOW_Pfrcpv_mm_mmm64 = 4181,
	/// `PFRSQRTV mm, mm/m64`
	///
	/// `0F 0F /r 87`
	///
	/// `AMD Geode GX/LX`
	///
	/// `16/32-bit`
	D3NOW_Pfrsqrtv_mm_mmm64 = 4182,
	/// `PFNACC mm, mm/m64`
	///
	/// `0F 0F /r 8A`
	///
	/// `3DNOWEXT`
	///
	/// `16/32/64-bit`
	D3NOW_Pfnacc_mm_mmm64 = 4183,
	/// `PFPNACC mm, mm/m64`
	///
	/// `0F 0F /r 8E`
	///
	/// `3DNOWEXT`
	///
	/// `16/32/64-bit`
	D3NOW_Pfpnacc_mm_mmm64 = 4184,
	/// `PFCMPGE mm, mm/m64`
	///
	/// `0F 0F /r 90`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfcmpge_mm_mmm64 = 4185,
	/// `PFMIN mm, mm/m64`
	///
	/// `0F 0F /r 94`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfmin_mm_mmm64 = 4186,
	/// `PFRCP mm, mm/m64`
	///
	/// `0F 0F /r 96`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfrcp_mm_mmm64 = 4187,
	/// `PFRSQRT mm, mm/m64`
	///
	/// `0F 0F /r 97`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfrsqrt_mm_mmm64 = 4188,
	/// `PFSUB mm, mm/m64`
	///
	/// `0F 0F /r 9A`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfsub_mm_mmm64 = 4189,
	/// `PFADD mm, mm/m64`
	///
	/// `0F 0F /r 9E`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfadd_mm_mmm64 = 4190,
	/// `PFCMPGT mm, mm/m64`
	///
	/// `0F 0F /r A0`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfcmpgt_mm_mmm64 = 4191,
	/// `PFMAX mm, mm/m64`
	///
	/// `0F 0F /r A4`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfmax_mm_mmm64 = 4192,
	/// `PFRCPIT1 mm, mm/m64`
	///
	/// `0F 0F /r A6`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfrcpit1_mm_mmm64 = 4193,
	/// `PFRSQIT1 mm, mm/m64`
	///
	/// `0F 0F /r A7`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfrsqit1_mm_mmm64 = 4194,
	/// `PFSUBR mm, mm/m64`
	///
	/// `0F 0F /r AA`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfsubr_mm_mmm64 = 4195,
	/// `PFACC mm, mm/m64`
	///
	/// `0F 0F /r AE`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfacc_mm_mmm64 = 4196,
	/// `PFCMPEQ mm, mm/m64`
	///
	/// `0F 0F /r B0`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfcmpeq_mm_mmm64 = 4197,
	/// `PFMUL mm, mm/m64`
	///
	/// `0F 0F /r B4`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfmul_mm_mmm64 = 4198,
	/// `PFRCPIT2 mm, mm/m64`
	///
	/// `0F 0F /r B6`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pfrcpit2_mm_mmm64 = 4199,
	/// `PMULHRW mm, mm/m64`
	///
	/// `0F 0F /r B7`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pmulhrw_mm_mmm64 = 4200,
	/// `PSWAPD mm, mm/m64`
	///
	/// `0F 0F /r BB`
	///
	/// `3DNOWEXT`
	///
	/// `16/32/64-bit`
	D3NOW_Pswapd_mm_mmm64 = 4201,
	/// `PAVGUSB mm, mm/m64`
	///
	/// `0F 0F /r BF`
	///
	/// `3DNOW`
	///
	/// `16/32/64-bit`
	D3NOW_Pavgusb_mm_mmm64 = 4202,
	/// `RMPADJUST`
	///
	/// `F3 0F 01 FE`
	///
	/// `SEV-SNP`
	///
	/// `64-bit`
	Rmpadjust = 4203,
	/// `RMPUPDATE`
	///
	/// `F2 0F 01 FE`
	///
	/// `SEV-SNP`
	///
	/// `64-bit`
	Rmpupdate = 4204,
	/// `PSMASH`
	///
	/// `F3 0F 01 FF`
	///
	/// `SEV-SNP`
	///
	/// `64-bit`
	Psmash = 4205,
	/// `PVALIDATE`
	///
	/// `a16 F2 0F 01 FF`
	///
	/// `SEV-SNP`
	///
	/// `16/32-bit`
	Pvalidatew = 4206,
	/// `PVALIDATE`
	///
	/// `a32 F2 0F 01 FF`
	///
	/// `SEV-SNP`
	///
	/// `16/32/64-bit`
	Pvalidated = 4207,
	/// `PVALIDATE`
	///
	/// `a64 F2 0F 01 FF`
	///
	/// `SEV-SNP`
	///
	/// `64-bit`
	Pvalidateq = 4208,
	/// `SERIALIZE`
	///
	/// `NP 0F 01 E8`
	///
	/// `SERIALIZE`
	///
	/// `16/32/64-bit`
	Serialize = 4209,
	/// `XSUSLDTRK`
	///
	/// `F2 0F 01 E8`
	///
	/// `TSXLDTRK`
	///
	/// `16/32/64-bit`
	Xsusldtrk = 4210,
	/// `XRESLDTRK`
	///
	/// `F2 0F 01 E9`
	///
	/// `TSXLDTRK`
	///
	/// `16/32/64-bit`
	Xresldtrk = 4211,
	/// `INVLPGB`
	///
	/// `a16 NP 0F 01 FE`
	///
	/// `INVLPGB`
	///
	/// `16/32-bit`
	Invlpgbw = 4212,
	/// `INVLPGB`
	///
	/// `a32 NP 0F 01 FE`
	///
	/// `INVLPGB`
	///
	/// `16/32/64-bit`
	Invlpgbd = 4213,
	/// `INVLPGB`
	///
	/// `a64 NP 0F 01 FE`
	///
	/// `INVLPGB`
	///
	/// `64-bit`
	Invlpgbq = 4214,
	/// `TLBSYNC`
	///
	/// `NP 0F 01 FF`
	///
	/// `INVLPGB`
	///
	/// `16/32/64-bit`
	Tlbsync = 4215,
	/// `PREFETCHW m8`
	///
	/// `0F 0D /3`
	///
	/// `PREFETCHW`
	///
	/// `16/32/64-bit`
	Prefetchreserved3_m8 = 4216,
	/// `PREFETCH m8`
	///
	/// `0F 0D /4`
	///
	/// `PREFETCHW`
	///
	/// `16/32/64-bit`
	Prefetchreserved4_m8 = 4217,
	/// `PREFETCH m8`
	///
	/// `0F 0D /5`
	///
	/// `PREFETCHW`
	///
	/// `16/32/64-bit`
	Prefetchreserved5_m8 = 4218,
	/// `PREFETCH m8`
	///
	/// `0F 0D /6`
	///
	/// `PREFETCHW`
	///
	/// `16/32/64-bit`
	Prefetchreserved6_m8 = 4219,
	/// `PREFETCH m8`
	///
	/// `0F 0D /7`
	///
	/// `PREFETCHW`
	///
	/// `16/32/64-bit`
	Prefetchreserved7_m8 = 4220,
	/// `UD0`
	///
	/// `0F FF`
	///
	/// `286+`
	///
	/// `16/32/64-bit`
	Ud0 = 4221,
	/// `VMGEXIT`
	///
	/// `F3 0F 01 D9`
	///
	/// `SEV-ES`
	///
	/// `16/32/64-bit`
	Vmgexit = 4222,
	/// `GETSECQ`
	///
	/// `NP o64 0F 37`
	///
	/// `SMX`
	///
	/// `64-bit`
	Getsecq = 4223,
	/// `LDTILECFG m512`
	///
	/// `VEX.128.0F38.W0 49 !(11):000:bbb`
	///
	/// `AMX-TILE`
	///
	/// `64-bit`
	VEX_Ldtilecfg_m512 = 4224,
	/// `TILERELEASE`
	///
	/// `VEX.128.0F38.W0 49 C0`
	///
	/// `AMX-TILE`
	///
	/// `64-bit`
	VEX_Tilerelease = 4225,
	/// `STTILECFG m512`
	///
	/// `VEX.128.66.0F38.W0 49 !(11):000:bbb`
	///
	/// `AMX-TILE`
	///
	/// `64-bit`
	VEX_Sttilecfg_m512 = 4226,
	/// `TILEZERO tmm1`
	///
	/// `VEX.128.F2.0F38.W0 49 11:rrr:000`
	///
	/// `AMX-TILE`
	///
	/// `64-bit`
	VEX_Tilezero_tmm = 4227,
	/// `TILELOADDT1 tmm1, sibmem`
	///
	/// `VEX.128.66.0F38.W0 4B !(11):rrr:100`
	///
	/// `AMX-TILE`
	///
	/// `64-bit`
	VEX_Tileloaddt1_tmm_sibmem = 4228,
	/// `TILESTORED sibmem, tmm1`
	///
	/// `VEX.128.F3.0F38.W0 4B !(11):rrr:100`
	///
	/// `AMX-TILE`
	///
	/// `64-bit`
	VEX_Tilestored_sibmem_tmm = 4229,
	/// `TILELOADD tmm1, sibmem`
	///
	/// `VEX.128.F2.0F38.W0 4B !(11):rrr:100`
	///
	/// `AMX-TILE`
	///
	/// `64-bit`
	VEX_Tileloadd_tmm_sibmem = 4230,
	/// `TDPBF16PS tmm1, tmm2, tmm3`
	///
	/// `VEX.128.F3.0F38.W0 5C 11:rrr:bbb`
	///
	/// `AMX-BF16`
	///
	/// `64-bit`
	VEX_Tdpbf16ps_tmm_tmm_tmm = 4231,
	/// `TDPBUUD tmm1, tmm2, tmm3`
	///
	/// `VEX.128.0F38.W0 5E 11:rrr:bbb`
	///
	/// `AMX-INT8`
	///
	/// `64-bit`
	VEX_Tdpbuud_tmm_tmm_tmm = 4232,
	/// `TDPBUSD tmm1, tmm2, tmm3`
	///
	/// `VEX.128.66.0F38.W0 5E 11:rrr:bbb`
	///
	/// `AMX-INT8`
	///
	/// `64-bit`
	VEX_Tdpbusd_tmm_tmm_tmm = 4233,
	/// `TDPBSUD tmm1, tmm2, tmm3`
	///
	/// `VEX.128.F3.0F38.W0 5E 11:rrr:bbb`
	///
	/// `AMX-INT8`
	///
	/// `64-bit`
	VEX_Tdpbsud_tmm_tmm_tmm = 4234,
	/// `TDPBSSD tmm1, tmm2, tmm3`
	///
	/// `VEX.128.F2.0F38.W0 5E 11:rrr:bbb`
	///
	/// `AMX-INT8`
	///
	/// `64-bit`
	VEX_Tdpbssd_tmm_tmm_tmm = 4235,
	/// `FNSTDW AX`
	///
	/// `DF E1`
	///
	/// `387 SL`
	///
	/// `16/32-bit`
	Fnstdw_AX = 4236,
	/// `FNSTSG AX`
	///
	/// `DF E2`
	///
	/// `387 SL`
	///
	/// `16/32-bit`
	Fnstsg_AX = 4237,
	/// `RDSHR r/m32`
	///
	/// `0F 36 /0`
	///
	/// `Cyrix 6x86MX, M II, III`
	///
	/// `16/32-bit`
	Rdshr_rm32 = 4238,
	/// `WRSHR r/m32`
	///
	/// `0F 37 /0`
	///
	/// `Cyrix 6x86MX, M II, III`
	///
	/// `16/32-bit`
	Wrshr_rm32 = 4239,
	/// `SMINT`
	///
	/// `0F 38`
	///
	/// `Cyrix 6x86MX+, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Smint = 4240,
	/// `DMINT`
	///
	/// `0F 39`
	///
	/// `AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Dmint = 4241,
	/// `RDM`
	///
	/// `0F 3A`
	///
	/// `AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Rdm = 4242,
	/// `SVDC m80, Sreg`
	///
	/// `0F 78 /r`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Svdc_m80_Sreg = 4243,
	/// `RSDC Sreg, m80`
	///
	/// `0F 79 /r`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Rsdc_Sreg_m80 = 4244,
	/// `SVLDT m80`
	///
	/// `0F 7A /0`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Svldt_m80 = 4245,
	/// `RSLDT m80`
	///
	/// `0F 7B /0`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Rsldt_m80 = 4246,
	/// `SVTS m80`
	///
	/// `0F 7C /0`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Svts_m80 = 4247,
	/// `RSTS m80`
	///
	/// `0F 7D /0`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Rsts_m80 = 4248,
	/// `SMINT`
	///
	/// `0F 7E`
	///
	/// `Cyrix 6x86 or earlier`
	///
	/// `16/32-bit`
	Smint_0F7E = 4249,
	/// `BB0_RESET`
	///
	/// `0F 3A`
	///
	/// `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// `16/32-bit`
	Bb0_reset = 4250,
	/// `BB1_RESET`
	///
	/// `0F 3B`
	///
	/// `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// `16/32-bit`
	Bb1_reset = 4251,
	/// `CPU_WRITE`
	///
	/// `0F 3C`
	///
	/// `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// `16/32-bit`
	Cpu_write = 4252,
	/// `CPU_READ`
	///
	/// `0F 3D`
	///
	/// `Cyrix MediaGX, GXm, GXLV, GX1`
	///
	/// `16/32-bit`
	Cpu_read = 4253,
	/// `ALTINST`
	///
	/// `0F 3F`
	///
	/// `Centaur AIS`
	///
	/// `16/32-bit`
	Altinst = 4254,
	/// `PAVEB mm, mm/m64`
	///
	/// `0F 50 /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Paveb_mm_mmm64 = 4255,
	/// `PADDSIW mm, mm/m64`
	///
	/// `0F 51 /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Paddsiw_mm_mmm64 = 4256,
	/// `PMAGW mm, mm/m64`
	///
	/// `0F 52 /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmagw_mm_mmm64 = 4257,
	/// `PDISTIB mm, m64`
	///
	/// `0F 54 /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pdistib_mm_m64 = 4258,
	/// `PSUBSIW mm, mm/m64`
	///
	/// `0F 55 /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Psubsiw_mm_mmm64 = 4259,
	/// `PMVZB mm, m64`
	///
	/// `0F 58 /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmvzb_mm_m64 = 4260,
	/// `PMULHRW mm, mm/m64`
	///
	/// `0F 59 /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmulhrw_mm_mmm64 = 4261,
	/// `PMVNZB mm, m64`
	///
	/// `0F 5A /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmvnzb_mm_m64 = 4262,
	/// `PMVLZB mm, m64`
	///
	/// `0F 5B /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmvlzb_mm_m64 = 4263,
	/// `PMVGEZB mm, m64`
	///
	/// `0F 5C /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmvgezb_mm_m64 = 4264,
	/// `PMULHRIW mm, mm/m64`
	///
	/// `0F 5D /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmulhriw_mm_mmm64 = 4265,
	/// `PMACHRIW mm, m64`
	///
	/// `0F 5E /r`
	///
	/// `CYRIX_EMMI`
	///
	/// `16/32-bit`
	Pmachriw_mm_m64 = 4266,
	/// `UNDOC`
	///
	/// `D9 D7`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_D9D7 = 4267,
	/// `UNDOC`
	///
	/// `D9 E2`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_D9E2 = 4268,
	/// `FTSTP`
	///
	/// `D9 E6`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Ftstp = 4269,
	/// `UNDOC`
	///
	/// `D9 E7`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_D9E7 = 4270,
	/// `FRINT2`
	///
	/// `DB FC`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Frint2 = 4271,
	/// `FRICHOP`
	///
	/// `DD FC`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Frichop = 4272,
	/// `UNDOC`
	///
	/// `DE D8`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_DED8 = 4273,
	/// `UNDOC`
	///
	/// `DE DA`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_DEDA = 4274,
	/// `UNDOC`
	///
	/// `DE DC`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_DEDC = 4275,
	/// `UNDOC`
	///
	/// `DE DD`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_DEDD = 4276,
	/// `UNDOC`
	///
	/// `DE DE`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Cyrix_DEDE = 4277,
	/// `FRINEAR`
	///
	/// `DF FC`
	///
	/// `Cyrix, AMD Geode GX/LX`
	///
	/// `16/32-bit`
	Frinear = 4278,
	/// `TDCALL`
	///
	/// `66 0F 01 CC`
	///
	/// `TDX`
	///
	/// `16/32/64-bit`
	Tdcall = 4279,
	/// `SEAMRET`
	///
	/// `66 0F 01 CD`
	///
	/// `TDX`
	///
	/// `64-bit`
	Seamret = 4280,
	/// `SEAMOPS`
	///
	/// `66 0F 01 CE`
	///
	/// `TDX`
	///
	/// `64-bit`
	Seamops = 4281,
	/// `SEAMCALL`
	///
	/// `66 0F 01 CF`
	///
	/// `TDX`
	///
	/// `64-bit`
	Seamcall = 4282,
	/// `AESENCWIDE128KL m384, <XMM0-7>`
	///
	/// `F3 0F 38 D8 !(11):000:bbb`
	///
	/// `AESKLE and WIDE_KL`
	///
	/// `16/32/64-bit`
	Aesencwide128kl_m384 = 4283,
	/// `AESDECWIDE128KL m384, <XMM0-7>`
	///
	/// `F3 0F 38 D8 !(11):001:bbb`
	///
	/// `AESKLE and WIDE_KL`
	///
	/// `16/32/64-bit`
	Aesdecwide128kl_m384 = 4284,
	/// `AESENCWIDE256KL m512, <XMM0-7>`
	///
	/// `F3 0F 38 D8 !(11):010:bbb`
	///
	/// `AESKLE and WIDE_KL`
	///
	/// `16/32/64-bit`
	Aesencwide256kl_m512 = 4285,
	/// `AESDECWIDE256KL m512, <XMM0-7>`
	///
	/// `F3 0F 38 D8 !(11):011:bbb`
	///
	/// `AESKLE and WIDE_KL`
	///
	/// `16/32/64-bit`
	Aesdecwide256kl_m512 = 4286,
	/// `LOADIWKEY xmm1, xmm2, <EAX>, <XMM0>`
	///
	/// `F3 0F 38 DC 11:rrr:bbb`
	///
	/// `KL`
	///
	/// `16/32/64-bit`
	Loadiwkey_xmm_xmm = 4287,
	/// `AESENC128KL xmm, m384`
	///
	/// `F3 0F 38 DC !(11):rrr:bbb`
	///
	/// `AESKLE`
	///
	/// `16/32/64-bit`
	Aesenc128kl_xmm_m384 = 4288,
	/// `AESDEC128KL xmm, m384`
	///
	/// `F3 0F 38 DD !(11):rrr:bbb`
	///
	/// `AESKLE`
	///
	/// `16/32/64-bit`
	Aesdec128kl_xmm_m384 = 4289,
	/// `AESENC256KL xmm, m512`
	///
	/// `F3 0F 38 DE !(11):rrr:bbb`
	///
	/// `AESKLE`
	///
	/// `16/32/64-bit`
	Aesenc256kl_xmm_m512 = 4290,
	/// `AESDEC256KL xmm, m512`
	///
	/// `F3 0F 38 DF !(11):rrr:bbb`
	///
	/// `AESKLE`
	///
	/// `16/32/64-bit`
	Aesdec256kl_xmm_m512 = 4291,
	/// `ENCODEKEY128 r32, r32, <XMM0-2>, <XMM4-6>`
	///
	/// `F3 0F 38 FA 11:rrr:bbb`
	///
	/// `AESKLE`
	///
	/// `16/32/64-bit`
	Encodekey128_r32_r32 = 4292,
	/// `ENCODEKEY256 r32, r32, <XMM0-6>`
	///
	/// `F3 0F 38 FB 11:rrr:bbb`
	///
	/// `AESKLE`
	///
	/// `16/32/64-bit`
	Encodekey256_r32_r32 = 4293,
	/// `VBROADCASTSS xmm1, xmm2`
	///
	/// `VEX.128.66.0F38.W0 18 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcastss_xmm_xmm = 4294,
	/// `VBROADCASTSS ymm1, xmm2`
	///
	/// `VEX.256.66.0F38.W0 18 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcastss_ymm_xmm = 4295,
	/// `VBROADCASTSD ymm1, xmm2`
	///
	/// `VEX.256.66.0F38.W0 19 /r`
	///
	/// `AVX2`
	///
	/// `16/32/64-bit`
	VEX_Vbroadcastsd_ymm_xmm = 4296,
	/// `VMGEXIT`
	///
	/// `F2 0F 01 D9`
	///
	/// `SEV-ES`
	///
	/// `16/32/64-bit`
	Vmgexit_F2 = 4297,
	/// `UIRET`
	///
	/// `F3 0F 01 EC`
	///
	/// `UINTR`
	///
	/// `64-bit`
	Uiret = 4298,
	/// `TESTUI`
	///
	/// `F3 0F 01 ED`
	///
	/// `UINTR`
	///
	/// `64-bit`
	Testui = 4299,
	/// `CLUI`
	///
	/// `F3 0F 01 EE`
	///
	/// `UINTR`
	///
	/// `64-bit`
	Clui = 4300,
	/// `STUI`
	///
	/// `F3 0F 01 EF`
	///
	/// `UINTR`
	///
	/// `64-bit`
	Stui = 4301,
	/// `SENDUIPI r64`
	///
	/// `F3 0F C7 /6`
	///
	/// `UINTR`
	///
	/// `64-bit`
	Senduipi_r64 = 4302,
	/// `HRESET imm8, <EAX>`
	///
	/// `F3 0F 3A F0 C0 ib`
	///
	/// `HRESET`
	///
	/// `16/32/64-bit`
	Hreset_imm8 = 4303,
	/// `VPDPBUSD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 50 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpbusd_xmm_xmm_xmmm128 = 4304,
	/// `VPDPBUSD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 50 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpbusd_ymm_ymm_ymmm256 = 4305,
	/// `VPDPBUSDS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 51 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpbusds_xmm_xmm_xmmm128 = 4306,
	/// `VPDPBUSDS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 51 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpbusds_ymm_ymm_ymmm256 = 4307,
	/// `VPDPWSSD xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 52 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpwssd_xmm_xmm_xmmm128 = 4308,
	/// `VPDPWSSD ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 52 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpwssd_ymm_ymm_ymmm256 = 4309,
	/// `VPDPWSSDS xmm1, xmm2, xmm3/m128`
	///
	/// `VEX.128.66.0F38.W0 53 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpwssds_xmm_xmm_xmmm128 = 4310,
	/// `VPDPWSSDS ymm1, ymm2, ymm3/m256`
	///
	/// `VEX.256.66.0F38.W0 53 /r`
	///
	/// `AVX-VNNI`
	///
	/// `16/32/64-bit`
	VEX_Vpdpwssds_ymm_ymm_ymmm256 = 4311,
	/// `CCS_HASH`
	///
	/// `a16 F3 0F A6 E8`
	///
	/// `PADLOCK_GMI`
	///
	/// `16/32-bit`
	Ccs_hash_16 = 4312,
	/// `CCS_HASH`
	///
	/// `a32 F3 0F A6 E8`
	///
	/// `PADLOCK_GMI`
	///
	/// `16/32/64-bit`
	Ccs_hash_32 = 4313,
	/// `CCS_HASH`
	///
	/// `a64 F3 0F A6 E8`
	///
	/// `PADLOCK_GMI`
	///
	/// `64-bit`
	Ccs_hash_64 = 4314,
	/// `CCS_ENCRYPT`
	///
	/// `a16 F3 0F A7 F0`
	///
	/// `PADLOCK_GMI`
	///
	/// `16/32-bit`
	Ccs_encrypt_16 = 4315,
	/// `CCS_ENCRYPT`
	///
	/// `a32 F3 0F A7 F0`
	///
	/// `PADLOCK_GMI`
	///
	/// `16/32/64-bit`
	Ccs_encrypt_32 = 4316,
	/// `CCS_ENCRYPT`
	///
	/// `a64 F3 0F A7 F0`
	///
	/// `PADLOCK_GMI`
	///
	/// `64-bit`
	Ccs_encrypt_64 = 4317,
	/// `LKGS r/m16`
	///
	/// `o16 F2 0F 00 /6`
	///
	/// `LKGS`
	///
	/// `64-bit`
	Lkgs_rm16 = 4318,
	/// `LKGS r32/m16`
	///
	/// `o32 F2 0F 00 /6`
	///
	/// `LKGS`
	///
	/// `64-bit`
	Lkgs_r32m16 = 4319,
	/// `LKGS r64/m16`
	///
	/// `F2 o64 0F 00 /6`
	///
	/// `LKGS`
	///
	/// `64-bit`
	Lkgs_r64m16 = 4320,
	/// `ERETU`
	///
	/// `F3 0F 01 CA`
	///
	/// `FRED`
	///
	/// `64-bit`
	Eretu = 4321,
	/// `ERETS`
	///
	/// `F2 0F 01 CA`
	///
	/// `FRED`
	///
	/// `64-bit`
	Erets = 4322,
	/// `VADDPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 58 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vaddph_xmm_k1z_xmm_xmmm128b16 = 4323,
	/// `VADDPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 58 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vaddph_ymm_k1z_ymm_ymmm256b16 = 4324,
	/// `VADDPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 58 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vaddph_zmm_k1z_zmm_zmmm512b16_er = 4325,
	/// `VADDSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 58 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vaddsh_xmm_k1z_xmm_xmmm16_er = 4326,
	/// `VCMPPH k1 {k2}, xmm2, xmm3/m128/m16bcst, imm8`
	///
	/// `EVEX.128.0F3A.W0 C2 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpph_kr_k1_xmm_xmmm128b16_imm8 = 4327,
	/// `VCMPPH k1 {k2}, ymm2, ymm3/m256/m16bcst, imm8`
	///
	/// `EVEX.256.0F3A.W0 C2 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpph_kr_k1_ymm_ymmm256b16_imm8 = 4328,
	/// `VCMPPH k1 {k2}, zmm2, zmm3/m512/m16bcst{sae}, imm8`
	///
	/// `EVEX.512.0F3A.W0 C2 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpph_kr_k1_zmm_zmmm512b16_imm8_sae = 4329,
	/// `VCMPSH k1 {k2}, xmm2, xmm3/m16{sae}, imm8`
	///
	/// `EVEX.LIG.F3.0F3A.W0 C2 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcmpsh_kr_k1_xmm_xmmm16_imm8_sae = 4330,
	/// `VCOMISH xmm1, xmm2/m16{sae}`
	///
	/// `EVEX.LIG.MAP5.W0 2F /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcomish_xmm_xmmm16_sae = 4331,
	/// `VCVTDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.MAP5.W0 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2ph_xmm_k1z_xmmm128b32 = 4332,
	/// `VCVTDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.MAP5.W0 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2ph_xmm_k1z_ymmm256b32 = 4333,
	/// `VCVTDQ2PH ymm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 5B /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtdq2ph_ymm_k1z_zmmm512b32_er = 4334,
	/// `VCVTPD2PH xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.66.MAP5.W1 5A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2ph_xmm_k1z_xmmm128b64 = 4335,
	/// `VCVTPD2PH xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.66.MAP5.W1 5A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2ph_xmm_k1z_ymmm256b64 = 4336,
	/// `VCVTPD2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.66.MAP5.W1 5A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtpd2ph_xmm_k1z_zmmm512b64_er = 4337,
	/// `VCVTPH2DQ xmm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.128.66.MAP5.W0 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2dq_xmm_k1z_xmmm64b16 = 4338,
	/// `VCVTPH2DQ ymm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.256.66.MAP5.W0 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2dq_ymm_k1z_xmmm128b16 = 4339,
	/// `VCVTPH2DQ zmm1 {k1}{z}, ymm2/m256/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP5.W0 5B /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2dq_zmm_k1z_ymmm256b16_er = 4340,
	/// `VCVTPH2PD xmm1 {k1}{z}, xmm2/m32/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 5A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2pd_xmm_k1z_xmmm32b16 = 4341,
	/// `VCVTPH2PD ymm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 5A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2pd_ymm_k1z_xmmm64b16 = 4342,
	/// `VCVTPH2PD zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}`
	///
	/// `EVEX.512.MAP5.W0 5A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2pd_zmm_k1z_xmmm128b16_sae = 4343,
	/// `VCVTPH2PSX xmm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 13 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2psx_xmm_k1z_xmmm64b16 = 4344,
	/// `VCVTPH2PSX ymm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 13 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2psx_ymm_k1z_xmmm128b16 = 4345,
	/// `VCVTPH2PSX zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}`
	///
	/// `EVEX.512.66.MAP6.W0 13 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2psx_zmm_k1z_ymmm256b16_sae = 4346,
	/// `VCVTPH2QQ xmm1 {k1}{z}, xmm2/m32/m16bcst`
	///
	/// `EVEX.128.66.MAP5.W0 7B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2qq_xmm_k1z_xmmm32b16 = 4347,
	/// `VCVTPH2QQ ymm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.256.66.MAP5.W0 7B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2qq_ymm_k1z_xmmm64b16 = 4348,
	/// `VCVTPH2QQ zmm1 {k1}{z}, xmm2/m128/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP5.W0 7B /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2qq_zmm_k1z_xmmm128b16_er = 4349,
	/// `VCVTPH2UDQ xmm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 79 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2udq_xmm_k1z_xmmm64b16 = 4350,
	/// `VCVTPH2UDQ ymm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 79 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2udq_ymm_k1z_xmmm128b16 = 4351,
	/// `VCVTPH2UDQ zmm1 {k1}{z}, ymm2/m256/m16bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 79 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2udq_zmm_k1z_ymmm256b16_er = 4352,
	/// `VCVTPH2UQQ xmm1 {k1}{z}, xmm2/m32/m16bcst`
	///
	/// `EVEX.128.66.MAP5.W0 79 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2uqq_xmm_k1z_xmmm32b16 = 4353,
	/// `VCVTPH2UQQ ymm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.256.66.MAP5.W0 79 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2uqq_ymm_k1z_xmmm64b16 = 4354,
	/// `VCVTPH2UQQ zmm1 {k1}{z}, xmm2/m128/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP5.W0 79 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2uqq_zmm_k1z_xmmm128b16_er = 4355,
	/// `VCVTPH2UW xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2uw_xmm_k1z_xmmm128b16 = 4356,
	/// `VCVTPH2UW ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2uw_ymm_k1z_ymmm256b16 = 4357,
	/// `VCVTPH2UW zmm1 {k1}{z}, zmm2/m512/m16bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 7D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2uw_zmm_k1z_zmmm512b16_er = 4358,
	/// `VCVTPH2W xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2w_xmm_k1z_xmmm128b16 = 4359,
	/// `VCVTPH2W ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2w_ymm_k1z_ymmm256b16 = 4360,
	/// `VCVTPH2W zmm1 {k1}{z}, zmm2/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP5.W0 7D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtph2w_zmm_k1z_zmmm512b16_er = 4361,
	/// `VCVTPS2PHX xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.66.MAP5.W0 1D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2phx_xmm_k1z_xmmm128b32 = 4362,
	/// `VCVTPS2PHX xmm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.66.MAP5.W0 1D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2phx_xmm_k1z_ymmm256b32 = 4363,
	/// `VCVTPS2PHX ymm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.66.MAP5.W0 1D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtps2phx_ymm_k1z_zmmm512b32_er = 4364,
	/// `VCVTQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.MAP5.W1 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2ph_xmm_k1z_xmmm128b64 = 4365,
	/// `VCVTQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.MAP5.W1 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2ph_xmm_k1z_ymmm256b64 = 4366,
	/// `VCVTQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.MAP5.W1 5B /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtqq2ph_xmm_k1z_zmmm512b64_er = 4367,
	/// `VCVTSD2SH xmm1 {k1}{z}, xmm2, xmm3/m64{er}`
	///
	/// `EVEX.LIG.F2.MAP5.W1 5A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsd2sh_xmm_k1z_xmm_xmmm64_er = 4368,
	/// `VCVTSH2SD xmm1 {k1}{z}, xmm2, xmm3/m16{sae}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 5A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsh2sd_xmm_k1z_xmm_xmmm16_sae = 4369,
	/// `VCVTSH2SI r32, xmm1/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 2D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsh2si_r32_xmmm16_er = 4370,
	/// `VCVTSH2SI r64, xmm1/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W1 2D /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vcvtsh2si_r64_xmmm16_er = 4371,
	/// `VCVTSH2SS xmm1 {k1}{z}, xmm2, xmm3/m16{sae}`
	///
	/// `EVEX.LIG.MAP6.W0 13 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsh2ss_xmm_k1z_xmm_xmmm16_sae = 4372,
	/// `VCVTSH2USI r32, xmm1/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 79 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsh2usi_r32_xmmm16_er = 4373,
	/// `VCVTSH2USI r64, xmm1/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W1 79 /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vcvtsh2usi_r64_xmmm16_er = 4374,
	/// `VCVTSI2SH xmm1, xmm2, r/m32{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 2A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtsi2sh_xmm_xmm_rm32_er = 4375,
	/// `VCVTSI2SH xmm1, xmm2, r/m64{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W1 2A /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vcvtsi2sh_xmm_xmm_rm64_er = 4376,
	/// `VCVTSS2SH xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.MAP5.W0 1D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtss2sh_xmm_k1z_xmm_xmmm32_er = 4377,
	/// `VCVTTPH2DQ xmm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.128.F3.MAP5.W0 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2dq_xmm_k1z_xmmm64b16 = 4378,
	/// `VCVTTPH2DQ ymm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.256.F3.MAP5.W0 5B /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2dq_ymm_k1z_xmmm128b16 = 4379,
	/// `VCVTTPH2DQ zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}`
	///
	/// `EVEX.512.F3.MAP5.W0 5B /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2dq_zmm_k1z_ymmm256b16_sae = 4380,
	/// `VCVTTPH2QQ xmm1 {k1}{z}, xmm2/m32/m16bcst`
	///
	/// `EVEX.128.66.MAP5.W0 7A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2qq_xmm_k1z_xmmm32b16 = 4381,
	/// `VCVTTPH2QQ ymm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.256.66.MAP5.W0 7A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2qq_ymm_k1z_xmmm64b16 = 4382,
	/// `VCVTTPH2QQ zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}`
	///
	/// `EVEX.512.66.MAP5.W0 7A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2qq_zmm_k1z_xmmm128b16_sae = 4383,
	/// `VCVTTPH2UDQ xmm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 78 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2udq_xmm_k1z_xmmm64b16 = 4384,
	/// `VCVTTPH2UDQ ymm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 78 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2udq_ymm_k1z_xmmm128b16 = 4385,
	/// `VCVTTPH2UDQ zmm1 {k1}{z}, ymm2/m256/m16bcst{sae}`
	///
	/// `EVEX.512.MAP5.W0 78 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2udq_zmm_k1z_ymmm256b16_sae = 4386,
	/// `VCVTTPH2UQQ xmm1 {k1}{z}, xmm2/m32/m16bcst`
	///
	/// `EVEX.128.66.MAP5.W0 78 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2uqq_xmm_k1z_xmmm32b16 = 4387,
	/// `VCVTTPH2UQQ ymm1 {k1}{z}, xmm2/m64/m16bcst`
	///
	/// `EVEX.256.66.MAP5.W0 78 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2uqq_ymm_k1z_xmmm64b16 = 4388,
	/// `VCVTTPH2UQQ zmm1 {k1}{z}, xmm2/m128/m16bcst{sae}`
	///
	/// `EVEX.512.66.MAP5.W0 78 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2uqq_zmm_k1z_xmmm128b16_sae = 4389,
	/// `VCVTTPH2UW xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 7C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2uw_xmm_k1z_xmmm128b16 = 4390,
	/// `VCVTTPH2UW ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 7C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2uw_ymm_k1z_ymmm256b16 = 4391,
	/// `VCVTTPH2UW zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}`
	///
	/// `EVEX.512.MAP5.W0 7C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2uw_zmm_k1z_zmmm512b16_sae = 4392,
	/// `VCVTTPH2W xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP5.W0 7C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2w_xmm_k1z_xmmm128b16 = 4393,
	/// `VCVTTPH2W ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP5.W0 7C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2w_ymm_k1z_ymmm256b16 = 4394,
	/// `VCVTTPH2W zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}`
	///
	/// `EVEX.512.66.MAP5.W0 7C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttph2w_zmm_k1z_zmmm512b16_sae = 4395,
	/// `VCVTTSH2SI r32, xmm1/m16{sae}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 2C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttsh2si_r32_xmmm16_sae = 4396,
	/// `VCVTTSH2SI r64, xmm1/m16{sae}`
	///
	/// `EVEX.LIG.F3.MAP5.W1 2C /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vcvttsh2si_r64_xmmm16_sae = 4397,
	/// `VCVTTSH2USI r32, xmm1/m16{sae}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 78 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvttsh2usi_r32_xmmm16_sae = 4398,
	/// `VCVTTSH2USI r64, xmm1/m16{sae}`
	///
	/// `EVEX.LIG.F3.MAP5.W1 78 /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vcvttsh2usi_r64_xmmm16_sae = 4399,
	/// `VCVTUDQ2PH xmm1 {k1}{z}, xmm2/m128/m32bcst`
	///
	/// `EVEX.128.F2.MAP5.W0 7A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2ph_xmm_k1z_xmmm128b32 = 4400,
	/// `VCVTUDQ2PH xmm1 {k1}{z}, ymm2/m256/m32bcst`
	///
	/// `EVEX.256.F2.MAP5.W0 7A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2ph_xmm_k1z_ymmm256b32 = 4401,
	/// `VCVTUDQ2PH ymm1 {k1}{z}, zmm2/m512/m32bcst{er}`
	///
	/// `EVEX.512.F2.MAP5.W0 7A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtudq2ph_ymm_k1z_zmmm512b32_er = 4402,
	/// `VCVTUQQ2PH xmm1 {k1}{z}, xmm2/m128/m64bcst`
	///
	/// `EVEX.128.F2.MAP5.W1 7A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2ph_xmm_k1z_xmmm128b64 = 4403,
	/// `VCVTUQQ2PH xmm1 {k1}{z}, ymm2/m256/m64bcst`
	///
	/// `EVEX.256.F2.MAP5.W1 7A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2ph_xmm_k1z_ymmm256b64 = 4404,
	/// `VCVTUQQ2PH xmm1 {k1}{z}, zmm2/m512/m64bcst{er}`
	///
	/// `EVEX.512.F2.MAP5.W1 7A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuqq2ph_xmm_k1z_zmmm512b64_er = 4405,
	/// `VCVTUSI2SH xmm1, xmm2, r/m32{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 7B /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtusi2sh_xmm_xmm_rm32_er = 4406,
	/// `VCVTUSI2SH xmm1, xmm2, r/m64{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W1 7B /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vcvtusi2sh_xmm_xmm_rm64_er = 4407,
	/// `VCVTUW2PH xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.F2.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuw2ph_xmm_k1z_xmmm128b16 = 4408,
	/// `VCVTUW2PH ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.F2.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuw2ph_ymm_k1z_ymmm256b16 = 4409,
	/// `VCVTUW2PH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}`
	///
	/// `EVEX.512.F2.MAP5.W0 7D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtuw2ph_zmm_k1z_zmmm512b16_er = 4410,
	/// `VCVTW2PH xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.F3.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtw2ph_xmm_k1z_xmmm128b16 = 4411,
	/// `VCVTW2PH ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.F3.MAP5.W0 7D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtw2ph_ymm_k1z_ymmm256b16 = 4412,
	/// `VCVTW2PH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}`
	///
	/// `EVEX.512.F3.MAP5.W0 7D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vcvtw2ph_zmm_k1z_zmmm512b16_er = 4413,
	/// `VDIVPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 5E /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vdivph_xmm_k1z_xmm_xmmm128b16 = 4414,
	/// `VDIVPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 5E /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vdivph_ymm_k1z_ymm_ymmm256b16 = 4415,
	/// `VDIVPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 5E /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vdivph_zmm_k1z_zmm_zmmm512b16_er = 4416,
	/// `VDIVSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 5E /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vdivsh_xmm_k1z_xmm_xmmm16_er = 4417,
	/// `VFCMADDCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F2.MAP6.W0 56 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmaddcph_xmm_k1z_xmm_xmmm128b32 = 4418,
	/// `VFCMADDCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F2.MAP6.W0 56 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmaddcph_ymm_k1z_ymm_ymmm256b32 = 4419,
	/// `VFCMADDCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.F2.MAP6.W0 56 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmaddcph_zmm_k1z_zmm_zmmm512b32_er = 4420,
	/// `VFMADDCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F3.MAP6.W0 56 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddcph_xmm_k1z_xmm_xmmm128b32 = 4421,
	/// `VFMADDCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F3.MAP6.W0 56 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddcph_ymm_k1z_ymm_ymmm256b32 = 4422,
	/// `VFMADDCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.F3.MAP6.W0 56 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddcph_zmm_k1z_zmm_zmmm512b32_er = 4423,
	/// `VFCMADDCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F2.MAP6.W0 57 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmaddcsh_xmm_k1z_xmm_xmmm32_er = 4424,
	/// `VFMADDCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F3.MAP6.W0 57 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddcsh_xmm_k1z_xmm_xmmm32_er = 4425,
	/// `VFCMULCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F2.MAP6.W0 D6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmulcph_xmm_k1z_xmm_xmmm128b32 = 4426,
	/// `VFCMULCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F2.MAP6.W0 D6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmulcph_ymm_k1z_ymm_ymmm256b32 = 4427,
	/// `VFCMULCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.F2.MAP6.W0 D6 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmulcph_zmm_k1z_zmm_zmmm512b32_er = 4428,
	/// `VFMULCPH xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst`
	///
	/// `EVEX.128.F3.MAP6.W0 D6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmulcph_xmm_k1z_xmm_xmmm128b32 = 4429,
	/// `VFMULCPH ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst`
	///
	/// `EVEX.256.F3.MAP6.W0 D6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmulcph_ymm_k1z_ymm_ymmm256b32 = 4430,
	/// `VFMULCPH zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}`
	///
	/// `EVEX.512.F3.MAP6.W0 D6 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmulcph_zmm_k1z_zmm_zmmm512b32_er = 4431,
	/// `VFCMULCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F2.MAP6.W0 D7 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfcmulcsh_xmm_k1z_xmm_xmmm32_er = 4432,
	/// `VFMULCSH xmm1 {k1}{z}, xmm2, xmm3/m32{er}`
	///
	/// `EVEX.LIG.F3.MAP6.W0 D7 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmulcsh_xmm_k1z_xmm_xmmm32_er = 4433,
	/// `VFMADDSUB132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 96 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132ph_xmm_k1z_xmm_xmmm128b16 = 4434,
	/// `VFMADDSUB132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 96 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132ph_ymm_k1z_ymm_ymmm256b16 = 4435,
	/// `VFMADDSUB132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 96 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub132ph_zmm_k1z_zmm_zmmm512b16_er = 4436,
	/// `VFMADDSUB213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 A6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213ph_xmm_k1z_xmm_xmmm128b16 = 4437,
	/// `VFMADDSUB213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 A6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213ph_ymm_k1z_ymm_ymmm256b16 = 4438,
	/// `VFMADDSUB213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 A6 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub213ph_zmm_k1z_zmm_zmmm512b16_er = 4439,
	/// `VFMADDSUB231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 B6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231ph_xmm_k1z_xmm_xmmm128b16 = 4440,
	/// `VFMADDSUB231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 B6 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231ph_ymm_k1z_ymm_ymmm256b16 = 4441,
	/// `VFMADDSUB231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 B6 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmaddsub231ph_zmm_k1z_zmm_zmmm512b16_er = 4442,
	/// `VFMSUBADD132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 97 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132ph_xmm_k1z_xmm_xmmm128b16 = 4443,
	/// `VFMSUBADD132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 97 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132ph_ymm_k1z_ymm_ymmm256b16 = 4444,
	/// `VFMSUBADD132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 97 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd132ph_zmm_k1z_zmm_zmmm512b16_er = 4445,
	/// `VFMSUBADD213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 A7 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213ph_xmm_k1z_xmm_xmmm128b16 = 4446,
	/// `VFMSUBADD213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 A7 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213ph_ymm_k1z_ymm_ymmm256b16 = 4447,
	/// `VFMSUBADD213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 A7 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd213ph_zmm_k1z_zmm_zmmm512b16_er = 4448,
	/// `VFMSUBADD231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 B7 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231ph_xmm_k1z_xmm_xmmm128b16 = 4449,
	/// `VFMSUBADD231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 B7 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231ph_ymm_k1z_ymm_ymmm256b16 = 4450,
	/// `VFMSUBADD231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 B7 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsubadd231ph_zmm_k1z_zmm_zmmm512b16_er = 4451,
	/// `VFMADD132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 98 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132ph_xmm_k1z_xmm_xmmm128b16 = 4452,
	/// `VFMADD132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 98 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132ph_ymm_k1z_ymm_ymmm256b16 = 4453,
	/// `VFMADD132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 98 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132ph_zmm_k1z_zmm_zmmm512b16_er = 4454,
	/// `VFMADD213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 A8 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213ph_xmm_k1z_xmm_xmmm128b16 = 4455,
	/// `VFMADD213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 A8 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213ph_ymm_k1z_ymm_ymmm256b16 = 4456,
	/// `VFMADD213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 A8 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213ph_zmm_k1z_zmm_zmmm512b16_er = 4457,
	/// `VFMADD231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 B8 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231ph_xmm_k1z_xmm_xmmm128b16 = 4458,
	/// `VFMADD231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 B8 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231ph_ymm_k1z_ymm_ymmm256b16 = 4459,
	/// `VFMADD231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 B8 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231ph_zmm_k1z_zmm_zmmm512b16_er = 4460,
	/// `VFNMADD132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 9C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132ph_xmm_k1z_xmm_xmmm128b16 = 4461,
	/// `VFNMADD132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 9C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132ph_ymm_k1z_ymm_ymmm256b16 = 4462,
	/// `VFNMADD132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 9C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132ph_zmm_k1z_zmm_zmmm512b16_er = 4463,
	/// `VFNMADD213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 AC /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213ph_xmm_k1z_xmm_xmmm128b16 = 4464,
	/// `VFNMADD213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 AC /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213ph_ymm_k1z_ymm_ymmm256b16 = 4465,
	/// `VFNMADD213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 AC /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213ph_zmm_k1z_zmm_zmmm512b16_er = 4466,
	/// `VFNMADD231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 BC /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231ph_xmm_k1z_xmm_xmmm128b16 = 4467,
	/// `VFNMADD231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 BC /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231ph_ymm_k1z_ymm_ymmm256b16 = 4468,
	/// `VFNMADD231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 BC /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231ph_zmm_k1z_zmm_zmmm512b16_er = 4469,
	/// `VFMADD132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 99 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd132sh_xmm_k1z_xmm_xmmm16_er = 4470,
	/// `VFMADD213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 A9 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd213sh_xmm_k1z_xmm_xmmm16_er = 4471,
	/// `VFMADD231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 B9 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmadd231sh_xmm_k1z_xmm_xmmm16_er = 4472,
	/// `VFNMADD132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 9D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd132sh_xmm_k1z_xmm_xmmm16_er = 4473,
	/// `VFNMADD213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 AD /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd213sh_xmm_k1z_xmm_xmmm16_er = 4474,
	/// `VFNMADD231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 BD /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmadd231sh_xmm_k1z_xmm_xmmm16_er = 4475,
	/// `VFMSUB132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 9A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132ph_xmm_k1z_xmm_xmmm128b16 = 4476,
	/// `VFMSUB132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 9A /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132ph_ymm_k1z_ymm_ymmm256b16 = 4477,
	/// `VFMSUB132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 9A /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132ph_zmm_k1z_zmm_zmmm512b16_er = 4478,
	/// `VFMSUB213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 AA /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213ph_xmm_k1z_xmm_xmmm128b16 = 4479,
	/// `VFMSUB213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 AA /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213ph_ymm_k1z_ymm_ymmm256b16 = 4480,
	/// `VFMSUB213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 AA /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213ph_zmm_k1z_zmm_zmmm512b16_er = 4481,
	/// `VFMSUB231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 BA /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231ph_xmm_k1z_xmm_xmmm128b16 = 4482,
	/// `VFMSUB231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 BA /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231ph_ymm_k1z_ymm_ymmm256b16 = 4483,
	/// `VFMSUB231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 BA /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231ph_zmm_k1z_zmm_zmmm512b16_er = 4484,
	/// `VFNMSUB132PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 9E /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132ph_xmm_k1z_xmm_xmmm128b16 = 4485,
	/// `VFNMSUB132PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 9E /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132ph_ymm_k1z_ymm_ymmm256b16 = 4486,
	/// `VFNMSUB132PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 9E /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132ph_zmm_k1z_zmm_zmmm512b16_er = 4487,
	/// `VFNMSUB213PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 AE /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213ph_xmm_k1z_xmm_xmmm128b16 = 4488,
	/// `VFNMSUB213PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 AE /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213ph_ymm_k1z_ymm_ymmm256b16 = 4489,
	/// `VFNMSUB213PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 AE /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213ph_zmm_k1z_zmm_zmmm512b16_er = 4490,
	/// `VFNMSUB231PH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 BE /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231ph_xmm_k1z_xmm_xmmm128b16 = 4491,
	/// `VFNMSUB231PH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 BE /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231ph_ymm_k1z_ymm_ymmm256b16 = 4492,
	/// `VFNMSUB231PH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 BE /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231ph_zmm_k1z_zmm_zmmm512b16_er = 4493,
	/// `VFMSUB132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 9B /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub132sh_xmm_k1z_xmm_xmmm16_er = 4494,
	/// `VFMSUB213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 AB /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub213sh_xmm_k1z_xmm_xmmm16_er = 4495,
	/// `VFMSUB231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 BB /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfmsub231sh_xmm_k1z_xmm_xmmm16_er = 4496,
	/// `VFNMSUB132SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 9F /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub132sh_xmm_k1z_xmm_xmmm16_er = 4497,
	/// `VFNMSUB213SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 AF /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub213sh_xmm_k1z_xmm_xmmm16_er = 4498,
	/// `VFNMSUB231SH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 BF /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfnmsub231sh_xmm_k1z_xmm_xmmm16_er = 4499,
	/// `VFPCLASSPH k1 {k2}, xmm2/m128/m16bcst, imm8`
	///
	/// `EVEX.128.0F3A.W0 66 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclassph_kr_k1_xmmm128b16_imm8 = 4500,
	/// `VFPCLASSPH k1 {k2}, ymm2/m256/m16bcst, imm8`
	///
	/// `EVEX.256.0F3A.W0 66 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclassph_kr_k1_ymmm256b16_imm8 = 4501,
	/// `VFPCLASSPH k1 {k2}, zmm2/m512/m16bcst, imm8`
	///
	/// `EVEX.512.0F3A.W0 66 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclassph_kr_k1_zmmm512b16_imm8 = 4502,
	/// `VFPCLASSSH k1 {k2}, xmm2/m16, imm8`
	///
	/// `EVEX.LIG.0F3A.W0 67 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vfpclasssh_kr_k1_xmmm16_imm8 = 4503,
	/// `VGETEXPPH xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 42 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpph_xmm_k1z_xmmm128b16 = 4504,
	/// `VGETEXPPH ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 42 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpph_ymm_k1z_ymmm256b16 = 4505,
	/// `VGETEXPPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}`
	///
	/// `EVEX.512.66.MAP6.W0 42 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpph_zmm_k1z_zmmm512b16_sae = 4506,
	/// `VGETEXPSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}`
	///
	/// `EVEX.LIG.66.MAP6.W0 43 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetexpsh_xmm_k1z_xmm_xmmm16_sae = 4507,
	/// `VGETMANTPH xmm1 {k1}{z}, xmm2/m128/m16bcst, imm8`
	///
	/// `EVEX.128.0F3A.W0 26 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantph_xmm_k1z_xmmm128b16_imm8 = 4508,
	/// `VGETMANTPH ymm1 {k1}{z}, ymm2/m256/m16bcst, imm8`
	///
	/// `EVEX.256.0F3A.W0 26 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantph_ymm_k1z_ymmm256b16_imm8 = 4509,
	/// `VGETMANTPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}, imm8`
	///
	/// `EVEX.512.0F3A.W0 26 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantph_zmm_k1z_zmmm512b16_imm8_sae = 4510,
	/// `VGETMANTSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}, imm8`
	///
	/// `EVEX.LIG.0F3A.W0 27 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vgetmantsh_xmm_k1z_xmm_xmmm16_imm8_sae = 4511,
	/// `VMAXPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 5F /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxph_xmm_k1z_xmm_xmmm128b16 = 4512,
	/// `VMAXPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 5F /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxph_ymm_k1z_ymm_ymmm256b16 = 4513,
	/// `VMAXPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{sae}`
	///
	/// `EVEX.512.MAP5.W0 5F /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxph_zmm_k1z_zmm_zmmm512b16_sae = 4514,
	/// `VMAXSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 5F /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmaxsh_xmm_k1z_xmm_xmmm16_sae = 4515,
	/// `VMINPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 5D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vminph_xmm_k1z_xmm_xmmm128b16 = 4516,
	/// `VMINPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 5D /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vminph_ymm_k1z_ymm_ymmm256b16 = 4517,
	/// `VMINPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{sae}`
	///
	/// `EVEX.512.MAP5.W0 5D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vminph_zmm_k1z_zmm_zmmm512b16_sae = 4518,
	/// `VMINSH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 5D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vminsh_xmm_k1z_xmm_xmmm16_sae = 4519,
	/// `VMOVSH xmm1 {k1}{z}, m16`
	///
	/// `EVEX.LIG.F3.MAP5.W0 10 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsh_xmm_k1z_m16 = 4520,
	/// `VMOVSH m16 {k1}, xmm1`
	///
	/// `EVEX.LIG.F3.MAP5.W0 11 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsh_m16_k1_xmm = 4521,
	/// `VMOVSH xmm1 {k1}{z}, xmm2, xmm3`
	///
	/// `EVEX.LIG.F3.MAP5.W0 10 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsh_xmm_k1z_xmm_xmm = 4522,
	/// `VMOVSH xmm1 {k1}{z}, xmm2, xmm3`
	///
	/// `EVEX.LIG.F3.MAP5.W0 11 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmovsh_xmm_k1z_xmm_xmm_MAP5_11 = 4523,
	/// `VMOVW xmm1, r32/m16`
	///
	/// `EVEX.128.66.MAP5.W0 6E /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmovw_xmm_r32m16 = 4524,
	/// `VMOVW xmm1, r64/m16`
	///
	/// `EVEX.128.66.MAP5.W1 6E /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vmovw_xmm_r64m16 = 4525,
	/// `VMOVW r32/m16, xmm1`
	///
	/// `EVEX.128.66.MAP5.W0 7E /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmovw_r32m16_xmm = 4526,
	/// `VMOVW r64/m16, xmm1`
	///
	/// `EVEX.128.66.MAP5.W1 7E /r`
	///
	/// `AVX512-FP16`
	///
	/// `64-bit`
	EVEX_Vmovw_r64m16_xmm = 4527,
	/// `VMULPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 59 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmulph_xmm_k1z_xmm_xmmm128b16 = 4528,
	/// `VMULPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 59 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmulph_ymm_k1z_ymm_ymmm256b16 = 4529,
	/// `VMULPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 59 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmulph_zmm_k1z_zmm_zmmm512b16_er = 4530,
	/// `VMULSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 59 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vmulsh_xmm_k1z_xmm_xmmm16_er = 4531,
	/// `VRCPPH xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 4C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrcpph_xmm_k1z_xmmm128b16 = 4532,
	/// `VRCPPH ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 4C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrcpph_ymm_k1z_ymmm256b16 = 4533,
	/// `VRCPPH zmm1 {k1}{z}, zmm2/m512/m16bcst`
	///
	/// `EVEX.512.66.MAP6.W0 4C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrcpph_zmm_k1z_zmmm512b16 = 4534,
	/// `VRCPSH xmm1 {k1}{z}, xmm2, xmm3/m16`
	///
	/// `EVEX.LIG.66.MAP6.W0 4D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrcpsh_xmm_k1z_xmm_xmmm16 = 4535,
	/// `VREDUCEPH xmm1 {k1}{z}, xmm2/m128/m16bcst, imm8`
	///
	/// `EVEX.128.0F3A.W0 56 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vreduceph_xmm_k1z_xmmm128b16_imm8 = 4536,
	/// `VREDUCEPH ymm1 {k1}{z}, ymm2/m256/m16bcst, imm8`
	///
	/// `EVEX.256.0F3A.W0 56 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vreduceph_ymm_k1z_ymmm256b16_imm8 = 4537,
	/// `VREDUCEPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}, imm8`
	///
	/// `EVEX.512.0F3A.W0 56 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vreduceph_zmm_k1z_zmmm512b16_imm8_sae = 4538,
	/// `VREDUCESH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}, imm8`
	///
	/// `EVEX.LIG.0F3A.W0 57 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vreducesh_xmm_k1z_xmm_xmmm16_imm8_sae = 4539,
	/// `VRNDSCALEPH xmm1 {k1}{z}, xmm2/m128/m16bcst, imm8`
	///
	/// `EVEX.128.0F3A.W0 08 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscaleph_xmm_k1z_xmmm128b16_imm8 = 4540,
	/// `VRNDSCALEPH ymm1 {k1}{z}, ymm2/m256/m16bcst, imm8`
	///
	/// `EVEX.256.0F3A.W0 08 /r ib`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscaleph_ymm_k1z_ymmm256b16_imm8 = 4541,
	/// `VRNDSCALEPH zmm1 {k1}{z}, zmm2/m512/m16bcst{sae}, imm8`
	///
	/// `EVEX.512.0F3A.W0 08 /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscaleph_zmm_k1z_zmmm512b16_imm8_sae = 4542,
	/// `VRNDSCALESH xmm1 {k1}{z}, xmm2, xmm3/m16{sae}, imm8`
	///
	/// `EVEX.LIG.0F3A.W0 0A /r ib`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrndscalesh_xmm_k1z_xmm_xmmm16_imm8_sae = 4543,
	/// `VRSQRTPH xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 4E /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrtph_xmm_k1z_xmmm128b16 = 4544,
	/// `VRSQRTPH ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 4E /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrtph_ymm_k1z_ymmm256b16 = 4545,
	/// `VRSQRTPH zmm1 {k1}{z}, zmm2/m512/m16bcst`
	///
	/// `EVEX.512.66.MAP6.W0 4E /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrtph_zmm_k1z_zmmm512b16 = 4546,
	/// `VRSQRTSH xmm1 {k1}{z}, xmm2, xmm3/m16`
	///
	/// `EVEX.LIG.66.MAP6.W0 4F /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vrsqrtsh_xmm_k1z_xmm_xmmm16 = 4547,
	/// `VSCALEFPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.66.MAP6.W0 2C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefph_xmm_k1z_xmm_xmmm128b16 = 4548,
	/// `VSCALEFPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.66.MAP6.W0 2C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefph_ymm_k1z_ymm_ymmm256b16 = 4549,
	/// `VSCALEFPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.66.MAP6.W0 2C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefph_zmm_k1z_zmm_zmmm512b16_er = 4550,
	/// `VSCALEFSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.66.MAP6.W0 2D /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vscalefsh_xmm_k1z_xmm_xmmm16_er = 4551,
	/// `VSQRTPH xmm1 {k1}{z}, xmm2/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 51 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtph_xmm_k1z_xmmm128b16 = 4552,
	/// `VSQRTPH ymm1 {k1}{z}, ymm2/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 51 /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtph_ymm_k1z_ymmm256b16 = 4553,
	/// `VSQRTPH zmm1 {k1}{z}, zmm2/m512/m16bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 51 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtph_zmm_k1z_zmmm512b16_er = 4554,
	/// `VSQRTSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 51 /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsqrtsh_xmm_k1z_xmm_xmmm16_er = 4555,
	/// `VSUBPH xmm1 {k1}{z}, xmm2, xmm3/m128/m16bcst`
	///
	/// `EVEX.128.MAP5.W0 5C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsubph_xmm_k1z_xmm_xmmm128b16 = 4556,
	/// `VSUBPH ymm1 {k1}{z}, ymm2, ymm3/m256/m16bcst`
	///
	/// `EVEX.256.MAP5.W0 5C /r`
	///
	/// `AVX512VL and AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsubph_ymm_k1z_ymm_ymmm256b16 = 4557,
	/// `VSUBPH zmm1 {k1}{z}, zmm2, zmm3/m512/m16bcst{er}`
	///
	/// `EVEX.512.MAP5.W0 5C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsubph_zmm_k1z_zmm_zmmm512b16_er = 4558,
	/// `VSUBSH xmm1 {k1}{z}, xmm2, xmm3/m16{er}`
	///
	/// `EVEX.LIG.F3.MAP5.W0 5C /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vsubsh_xmm_k1z_xmm_xmmm16_er = 4559,
	/// `VUCOMISH xmm1, xmm2/m16{sae}`
	///
	/// `EVEX.LIG.MAP5.W0 2E /r`
	///
	/// `AVX512-FP16`
	///
	/// `16/32/64-bit`
	EVEX_Vucomish_xmm_xmmm16_sae = 4560,
	/// `RDUDBG`
	///
	/// `0F 0E`
	///
	/// `UDBG`
	///
	/// `16/32/64-bit`
	Rdudbg = 4561,
	/// `WRUDBG`
	///
	/// `0F 0F`
	///
	/// `UDBG`
	///
	/// `16/32/64-bit`
	Wrudbg = 4562,
	/// `JKZD k1, rel8`
	///
	/// `VEX.128.W0 74 cb`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Jkzd_kr_rel8_64 = 4563,
	/// `JKNZD k1, rel8`
	///
	/// `VEX.128.W0 75 cb`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Jknzd_kr_rel8_64 = 4564,
	/// `VPREFETCHNTA m8`
	///
	/// `VEX.128.0F.WIG 18 /0`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetchnta_m8 = 4565,
	/// `VPREFETCH0 m8`
	///
	/// `VEX.128.0F.WIG 18 /1`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetch0_m8 = 4566,
	/// `VPREFETCH1 m8`
	///
	/// `VEX.128.0F.WIG 18 /2`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetch1_m8 = 4567,
	/// `VPREFETCH2 m8`
	///
	/// `VEX.128.0F.WIG 18 /3`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetch2_m8 = 4568,
	/// `VPREFETCHENTA m8`
	///
	/// `VEX.128.0F.WIG 18 /4`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetchenta_m8 = 4569,
	/// `VPREFETCHE0 m8`
	///
	/// `VEX.128.0F.WIG 18 /5`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetche0_m8 = 4570,
	/// `VPREFETCHE1 m8`
	///
	/// `VEX.128.0F.WIG 18 /6`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetche1_m8 = 4571,
	/// `VPREFETCHE2 m8`
	///
	/// `VEX.128.0F.WIG 18 /7`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Vprefetche2_m8 = 4572,
	/// `KAND k1, k2`
	///
	/// `VEX.128.0F.W0 41 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kand_kr_kr = 4573,
	/// `KANDN k1, k2`
	///
	/// `VEX.128.0F.W0 42 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kandn_kr_kr = 4574,
	/// `KANDNR k1, k2`
	///
	/// `VEX.128.0F.W0 43 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kandnr_kr_kr = 4575,
	/// `KNOT k1, k2`
	///
	/// `VEX.128.0F.W0 44 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Knot_kr_kr = 4576,
	/// `KOR k1, k2`
	///
	/// `VEX.128.0F.W0 45 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kor_kr_kr = 4577,
	/// `KXNOR k1, k2`
	///
	/// `VEX.128.0F.W0 46 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kxnor_kr_kr = 4578,
	/// `KXOR k1, k2`
	///
	/// `VEX.128.0F.W0 47 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kxor_kr_kr = 4579,
	/// `KMERGE2L1H k1, k2`
	///
	/// `VEX.128.0F.W0 48 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kmerge2l1h_kr_kr = 4580,
	/// `KMERGE2L1L k1, k2`
	///
	/// `VEX.128.0F.W0 49 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kmerge2l1l_kr_kr = 4581,
	/// `JKZD k1, rel32`
	///
	/// `VEX.128.0F.W0 84 cd`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Jkzd_kr_rel32_64 = 4582,
	/// `JKNZD k1, rel32`
	///
	/// `VEX.128.0F.W0 85 cd`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Jknzd_kr_rel32_64 = 4583,
	/// `KMOV k1, k2`
	///
	/// `VEX.128.0F.W0 90 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kmov_kr_kr = 4584,
	/// `KMOV k1, r32`
	///
	/// `VEX.128.0F.W0 92 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kmov_kr_r32 = 4585,
	/// `KMOV r32, k1`
	///
	/// `VEX.128.0F.W0 93 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kmov_r32_kr = 4586,
	/// `KCONCATH r64, k1, k2`
	///
	/// `VEX.128.0F.W0 95 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kconcath_r64_kr_kr = 4587,
	/// `KCONCATL r64, k1, k2`
	///
	/// `VEX.128.0F.W0 97 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kconcatl_r64_kr_kr = 4588,
	/// `KORTEST k1, k2`
	///
	/// `VEX.128.0F.W0 98 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kortest_kr_kr = 4589,
	/// `DELAY r32`
	///
	/// `VEX.128.F3.0F.W0 AE /6`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Delay_r32 = 4590,
	/// `DELAY r64`
	///
	/// `VEX.128.F3.0F.W1 AE /6`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Delay_r64 = 4591,
	/// `SPFLT r32`
	///
	/// `VEX.128.F2.0F.W0 AE /6`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Spflt_r32 = 4592,
	/// `SPFLT r64`
	///
	/// `VEX.128.F2.0F.W1 AE /6`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Spflt_r64 = 4593,
	/// `CLEVICT1 m8`
	///
	/// `VEX.128.F3.0F.WIG AE /7`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Clevict1_m8 = 4594,
	/// `CLEVICT0 m8`
	///
	/// `VEX.128.F2.0F.WIG AE /7`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Clevict0_m8 = 4595,
	/// `POPCNT r32, r32`
	///
	/// `VEX.128.F3.0F.W0 B8 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Popcnt_r32_r32 = 4596,
	/// `POPCNT r64, r64`
	///
	/// `VEX.128.F3.0F.W1 B8 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Popcnt_r64_r64 = 4597,
	/// `TZCNT r32, r32`
	///
	/// `VEX.128.F3.0F.W0 BC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Tzcnt_r32_r32 = 4598,
	/// `TZCNT r64, r64`
	///
	/// `VEX.128.F3.0F.W1 BC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Tzcnt_r64_r64 = 4599,
	/// `TZCNTI r32, r32`
	///
	/// `VEX.128.F2.0F.W0 BC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Tzcnti_r32_r32 = 4600,
	/// `TZCNTI r64, r64`
	///
	/// `VEX.128.F2.0F.W1 BC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Tzcnti_r64_r64 = 4601,
	/// `LZCNT r32, r32`
	///
	/// `VEX.128.F3.0F.W0 BD /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Lzcnt_r32_r32 = 4602,
	/// `LZCNT r64, r64`
	///
	/// `VEX.128.F3.0F.W1 BD /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Lzcnt_r64_r64 = 4603,
	/// `UNDOC r32, r/m32`
	///
	/// `VEX.128.F3.0F38.W0 F0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Undoc_r32_rm32_128_F3_0F38_W0_F0 = 4604,
	/// `UNDOC r64, r/m64`
	///
	/// `VEX.128.F3.0F38.W1 F0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Undoc_r64_rm64_128_F3_0F38_W1_F0 = 4605,
	/// `UNDOC r32, r/m32`
	///
	/// `VEX.128.F2.0F38.W0 F0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Undoc_r32_rm32_128_F2_0F38_W0_F0 = 4606,
	/// `UNDOC r64, r/m64`
	///
	/// `VEX.128.F2.0F38.W1 F0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Undoc_r64_rm64_128_F2_0F38_W1_F0 = 4607,
	/// `UNDOC r32, r/m32`
	///
	/// `VEX.128.F2.0F38.W0 F1 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Undoc_r32_rm32_128_F2_0F38_W0_F1 = 4608,
	/// `UNDOC r64, r/m64`
	///
	/// `VEX.128.F2.0F38.W1 F1 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Undoc_r64_rm64_128_F2_0F38_W1_F1 = 4609,
	/// `KEXTRACT k1, r64, imm8`
	///
	/// `VEX.128.66.0F3A.W0 3E /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	VEX_KNC_Kextract_kr_r64_imm8 = 4610,
	/// `VPREFETCHNTA m`
	///
	/// `MVEX.512.0F.WIG 18 /0`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetchnta_m = 4611,
	/// `VPREFETCH0 m`
	///
	/// `MVEX.512.0F.WIG 18 /1`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetch0_m = 4612,
	/// `VPREFETCH1 m`
	///
	/// `MVEX.512.0F.WIG 18 /2`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetch1_m = 4613,
	/// `VPREFETCH2 m`
	///
	/// `MVEX.512.0F.WIG 18 /3`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetch2_m = 4614,
	/// `VPREFETCHENTA m`
	///
	/// `MVEX.512.0F.WIG 18 /4`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetchenta_m = 4615,
	/// `VPREFETCHE0 m`
	///
	/// `MVEX.512.0F.WIG 18 /5`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetche0_m = 4616,
	/// `VPREFETCHE1 m`
	///
	/// `MVEX.512.0F.WIG 18 /6`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetche1_m = 4617,
	/// `VPREFETCHE2 m`
	///
	/// `MVEX.512.0F.WIG 18 /7`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vprefetche2_m = 4618,
	/// `VMOVAPS zmm1 {k1}, Sf32(zmm2/mt)`
	///
	/// `MVEX.512.0F.W0 28 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovaps_zmm_k1_zmmmt = 4619,
	/// `VMOVAPD zmm1 {k1}, Sf64(zmm2/mt)`
	///
	/// `MVEX.512.66.0F.W1 28 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovapd_zmm_k1_zmmmt = 4620,
	/// `VMOVAPS mt {k1}, Df32(zmm1)`
	///
	/// `MVEX.512.0F.W0 29 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovaps_mt_k1_zmm = 4621,
	/// `VMOVAPD mt {k1}, Df64(zmm1)`
	///
	/// `MVEX.512.66.0F.W1 29 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovapd_mt_k1_zmm = 4622,
	/// `VMOVNRAPD m {k1}, Df64(zmm1)`
	///
	/// `MVEX.512.F3.0F.W1.EH0 29 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovnrapd_m_k1_zmm = 4623,
	/// `VMOVNRNGOAPD m {k1}, Df64(zmm1)`
	///
	/// `MVEX.512.F3.0F.W1.EH1 29 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovnrngoapd_m_k1_zmm = 4624,
	/// `VMOVNRAPS m {k1}, Df32(zmm1)`
	///
	/// `MVEX.512.F2.0F.W0.EH0 29 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovnraps_m_k1_zmm = 4625,
	/// `VMOVNRNGOAPS m {k1}, Df32(zmm1)`
	///
	/// `MVEX.512.F2.0F.W0.EH1 29 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovnrngoaps_m_k1_zmm = 4626,
	/// `VADDPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.0F.W0 58 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vaddps_zmm_k1_zmm_zmmmt = 4627,
	/// `VADDPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W1 58 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vaddpd_zmm_k1_zmm_zmmmt = 4628,
	/// `VMULPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.0F.W0 59 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmulps_zmm_k1_zmm_zmmmt = 4629,
	/// `VMULPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W1 59 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmulpd_zmm_k1_zmm_zmmmt = 4630,
	/// `VCVTPS2PD zmm1 {k1}, Sf32(zmm2/mt)`
	///
	/// `MVEX.512.0F.W0 5A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtps2pd_zmm_k1_zmmmt = 4631,
	/// `VCVTPD2PS zmm1 {k1}, Sf64(zmm2/mt)`
	///
	/// `MVEX.512.66.0F.W1 5A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtpd2ps_zmm_k1_zmmmt = 4632,
	/// `VSUBPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.0F.W0 5C /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vsubps_zmm_k1_zmm_zmmmt = 4633,
	/// `VSUBPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W1 5C /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vsubpd_zmm_k1_zmm_zmmmt = 4634,
	/// `VPCMPGTD k2 {k1}, zmm1, Si32(zmm2/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 66 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpcmpgtd_kr_k1_zmm_zmmmt = 4635,
	/// `VMOVDQA32 zmm1 {k1}, Si32(zmm2/mt)`
	///
	/// `MVEX.512.66.0F.W0 6F /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovdqa32_zmm_k1_zmmmt = 4636,
	/// `VMOVDQA64 zmm1 {k1}, Si64(zmm2/mt)`
	///
	/// `MVEX.512.66.0F.W1 6F /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovdqa64_zmm_k1_zmmmt = 4637,
	/// `VPSHUFD zmm1 {k1}, zmm2/mt, imm8`
	///
	/// `MVEX.512.66.0F.W0 70 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpshufd_zmm_k1_zmmmt_imm8 = 4638,
	/// `VPSRLD zmm1 {k1}, Si32(zmm2/mt), imm8`
	///
	/// `MVEX.NDD.512.66.0F.W0 72 /2 ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsrld_zmm_k1_zmmmt_imm8 = 4639,
	/// `VPSRAD zmm1 {k1}, Si32(zmm2/mt), imm8`
	///
	/// `MVEX.NDD.512.66.0F.W0 72 /4 ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsrad_zmm_k1_zmmmt_imm8 = 4640,
	/// `VPSLLD zmm1 {k1}, Si32(zmm2/mt), imm8`
	///
	/// `MVEX.NDD.512.66.0F.W0 72 /6 ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpslld_zmm_k1_zmmmt_imm8 = 4641,
	/// `VPCMPEQD k2 {k1}, zmm1, Si32(zmm2/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 76 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpcmpeqd_kr_k1_zmm_zmmmt = 4642,
	/// `VCVTUDQ2PD zmm1 {k1}, Si32(zmm2/mt)`
	///
	/// `MVEX.512.F3.0F.W0 7A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtudq2pd_zmm_k1_zmmmt = 4643,
	/// `VMOVDQA32 mt {k1}, Di32(zmm1)`
	///
	/// `MVEX.512.66.0F.W0 7F /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovdqa32_mt_k1_zmm = 4644,
	/// `VMOVDQA64 mt {k1}, Di64(zmm1)`
	///
	/// `MVEX.512.66.0F.W1 7F /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vmovdqa64_mt_k1_zmm = 4645,
	/// `CLEVICT1 m`
	///
	/// `MVEX.512.F3.0F.WIG AE /7`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Clevict1_m = 4646,
	/// `CLEVICT0 m`
	///
	/// `MVEX.512.F2.0F.WIG AE /7`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Clevict0_m = 4647,
	/// `VCMPPS k2 {k1}, zmm1, Sf32(zmm2/mt), imm8`
	///
	/// `MVEX.NDS.512.0F.W0 C2 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcmpps_kr_k1_zmm_zmmmt_imm8 = 4648,
	/// `VCMPPD k2 {k1}, zmm1, Sf64(zmm2/mt), imm8`
	///
	/// `MVEX.NDS.512.66.0F.W1 C2 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcmppd_kr_k1_zmm_zmmmt_imm8 = 4649,
	/// `VPANDD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 DB /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpandd_zmm_k1_zmm_zmmmt = 4650,
	/// `VPANDQ zmm1 {k1}, zmm2, Si64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W1 DB /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpandq_zmm_k1_zmm_zmmmt = 4651,
	/// `VPANDND zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 DF /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpandnd_zmm_k1_zmm_zmmmt = 4652,
	/// `VPANDNQ zmm1 {k1}, zmm2, Si64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W1 DF /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpandnq_zmm_k1_zmm_zmmmt = 4653,
	/// `VCVTDQ2PD zmm1 {k1}, Si32(zmm2/mt)`
	///
	/// `MVEX.512.F3.0F.W0 E6 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtdq2pd_zmm_k1_zmmmt = 4654,
	/// `VPORD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 EB /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpord_zmm_k1_zmm_zmmmt = 4655,
	/// `VPORQ zmm1 {k1}, zmm2, Si64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W1 EB /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vporq_zmm_k1_zmm_zmmmt = 4656,
	/// `VPXORD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 EF /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpxord_zmm_k1_zmm_zmmmt = 4657,
	/// `VPXORQ zmm1 {k1}, zmm2, Si64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W1 EF /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpxorq_zmm_k1_zmm_zmmmt = 4658,
	/// `VPSUBD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 FA /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsubd_zmm_k1_zmm_zmmmt = 4659,
	/// `VPADDD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F.W0 FE /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpaddd_zmm_k1_zmm_zmmmt = 4660,
	/// `VBROADCASTSS zmm1 {k1}, Uf32(mt)`
	///
	/// `MVEX.512.66.0F38.W0 18 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vbroadcastss_zmm_k1_mt = 4661,
	/// `VBROADCASTSD zmm1 {k1}, Uf64(mt)`
	///
	/// `MVEX.512.66.0F38.W1 19 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vbroadcastsd_zmm_k1_mt = 4662,
	/// `VBROADCASTF32X4 zmm1 {k1}, Uf32(mt)`
	///
	/// `MVEX.512.66.0F38.W0 1A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vbroadcastf32x4_zmm_k1_mt = 4663,
	/// `VBROADCASTF64X4 zmm1 {k1}, Uf64(mt)`
	///
	/// `MVEX.512.66.0F38.W1 1B /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vbroadcastf64x4_zmm_k1_mt = 4664,
	/// `VPTESTMD k2 {k1}, zmm1, Si32(zmm2/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 27 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vptestmd_kr_k1_zmm_zmmmt = 4665,
	/// `VPERMD zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 36 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpermd_zmm_k1_zmm_zmmmt = 4666,
	/// `VPMINSD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 39 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpminsd_zmm_k1_zmm_zmmmt = 4667,
	/// `VPMINUD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 3B /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpminud_zmm_k1_zmm_zmmmt = 4668,
	/// `VPMAXSD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 3D /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpmaxsd_zmm_k1_zmm_zmmmt = 4669,
	/// `VPMAXUD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 3F /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpmaxud_zmm_k1_zmm_zmmmt = 4670,
	/// `VPMULLD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 40 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpmulld_zmm_k1_zmm_zmmmt = 4671,
	/// `VGETEXPPS zmm1 {k1}, Sf32(zmm2/mt)`
	///
	/// `MVEX.512.66.0F38.W0 42 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgetexpps_zmm_k1_zmmmt = 4672,
	/// `VGETEXPPD zmm1 {k1}, Sf64(zmm2/mt)`
	///
	/// `MVEX.512.66.0F38.W1 42 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgetexppd_zmm_k1_zmmmt = 4673,
	/// `VPSRLVD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 45 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsrlvd_zmm_k1_zmm_zmmmt = 4674,
	/// `VPSRAVD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 46 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsravd_zmm_k1_zmm_zmmmt = 4675,
	/// `VPSLLVD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 47 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsllvd_zmm_k1_zmm_zmmmt = 4676,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 48 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_48 = 4677,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 49 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_49 = 4678,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 4A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_4A = 4679,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 4B /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_4B = 4680,
	/// `VADDNPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 50 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vaddnps_zmm_k1_zmm_zmmmt = 4681,
	/// `VADDNPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 50 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vaddnpd_zmm_k1_zmm_zmmmt = 4682,
	/// `VGMAXABSPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 51 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgmaxabsps_zmm_k1_zmm_zmmmt = 4683,
	/// `VGMINPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 52 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgminps_zmm_k1_zmm_zmmmt = 4684,
	/// `VGMINPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 52 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgminpd_zmm_k1_zmm_zmmmt = 4685,
	/// `VGMAXPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 53 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgmaxps_zmm_k1_zmm_zmmmt = 4686,
	/// `VGMAXPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 53 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgmaxpd_zmm_k1_zmm_zmmmt = 4687,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 54 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_54 = 4688,
	/// `VFIXUPNANPS zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 55 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfixupnanps_zmm_k1_zmm_zmmmt = 4689,
	/// `VFIXUPNANPD zmm1 {k1}, zmm2, Si64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 55 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfixupnanpd_zmm_k1_zmm_zmmmt = 4690,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 56 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_56 = 4691,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 57 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_57 = 4692,
	/// `VPBROADCASTD zmm1 {k1}, Ui32(mt)`
	///
	/// `MVEX.512.66.0F38.W0 58 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpbroadcastd_zmm_k1_mt = 4693,
	/// `VPBROADCASTQ zmm1 {k1}, Ui64(mt)`
	///
	/// `MVEX.512.66.0F38.W1 59 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpbroadcastq_zmm_k1_mt = 4694,
	/// `VBROADCASTI32X4 zmm1 {k1}, Ui32(mt)`
	///
	/// `MVEX.512.66.0F38.W0 5A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vbroadcasti32x4_zmm_k1_mt = 4695,
	/// `VBROADCASTI64X4 zmm1 {k1}, Ui64(mt)`
	///
	/// `MVEX.512.66.0F38.W1 5B /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vbroadcasti64x4_zmm_k1_mt = 4696,
	/// `VPADCD zmm1 {k1}, k2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 5C /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpadcd_zmm_k1_kr_zmmmt = 4697,
	/// `VPADDSETCD zmm1 {k1}, k2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 5D /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpaddsetcd_zmm_k1_kr_zmmmt = 4698,
	/// `VPSBBD zmm1 {k1}, k2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 5E /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsbbd_zmm_k1_kr_zmmmt = 4699,
	/// `VPSUBSETBD zmm1 {k1}, k2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 5F /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsubsetbd_zmm_k1_kr_zmmmt = 4700,
	/// `VPBLENDMD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 64 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpblendmd_zmm_k1_zmm_zmmmt = 4701,
	/// `VPBLENDMQ zmm1 {k1}, zmm2, Si64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 64 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpblendmq_zmm_k1_zmm_zmmmt = 4702,
	/// `VBLENDMPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 65 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vblendmps_zmm_k1_zmm_zmmmt = 4703,
	/// `VBLENDMPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 65 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vblendmpd_zmm_k1_zmm_zmmmt = 4704,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 67 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_67 = 4705,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 68 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_68 = 4706,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 69 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_69 = 4707,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 6A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_6A = 4708,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 6B /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_6B = 4709,
	/// `VPSUBRD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 6C /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsubrd_zmm_k1_zmm_zmmmt = 4710,
	/// `VSUBRPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 6D /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vsubrps_zmm_k1_zmm_zmmmt = 4711,
	/// `VSUBRPD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 6D /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vsubrpd_zmm_k1_zmm_zmmmt = 4712,
	/// `VPSBBRD zmm1 {k1}, k2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 6E /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsbbrd_zmm_k1_kr_zmmmt = 4713,
	/// `VPSUBRSETBD zmm1 {k1}, k2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 6F /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpsubrsetbd_zmm_k1_kr_zmmmt = 4714,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 70 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_70 = 4715,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 71 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_71 = 4716,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 72 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_72 = 4717,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 73 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_73 = 4718,
	/// `VPCMPLTD k2 {k1}, zmm1, Si32(zmm2/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 74 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpcmpltd_kr_k1_zmm_zmmmt = 4719,
	/// `VSCALEPS zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 84 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vscaleps_zmm_k1_zmm_zmmmt = 4720,
	/// `VPMULHUD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 86 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpmulhud_zmm_k1_zmm_zmmmt = 4721,
	/// `VPMULHD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 87 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpmulhd_zmm_k1_zmm_zmmmt = 4722,
	/// `VPGATHERDD zmm1 {k1}, Ui32(mvt)`
	///
	/// `MVEX.512.66.0F38.W0 90 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpgatherdd_zmm_k1_mvt = 4723,
	/// `VPGATHERDQ zmm1 {k1}, Ui64(mvt)`
	///
	/// `MVEX.512.66.0F38.W1 90 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpgatherdq_zmm_k1_mvt = 4724,
	/// `VGATHERDPS zmm1 {k1}, Uf32(mvt)`
	///
	/// `MVEX.512.66.0F38.W0 92 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgatherdps_zmm_k1_mvt = 4725,
	/// `VGATHERDPD zmm1 {k1}, Uf64(mvt)`
	///
	/// `MVEX.512.66.0F38.W1 92 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgatherdpd_zmm_k1_mvt = 4726,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 94 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_94 = 4727,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W1 94 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W1_94 = 4728,
	/// `VFMADD132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 98 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmadd132ps_zmm_k1_zmm_zmmmt = 4729,
	/// `VFMADD132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 98 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmadd132pd_zmm_k1_zmm_zmmmt = 4730,
	/// `VFMSUB132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 9A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmsub132ps_zmm_k1_zmm_zmmmt = 4731,
	/// `VFMSUB132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 9A /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmsub132pd_zmm_k1_zmm_zmmmt = 4732,
	/// `VFNMADD132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 9C /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmadd132ps_zmm_k1_zmm_zmmmt = 4733,
	/// `VFNMADD132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 9C /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmadd132pd_zmm_k1_zmm_zmmmt = 4734,
	/// `VFNMSUB132PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 9E /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmsub132ps_zmm_k1_zmm_zmmmt = 4735,
	/// `VFNMSUB132PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 9E /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmsub132pd_zmm_k1_zmm_zmmmt = 4736,
	/// `VPSCATTERDD mvt {k1}, Di32(zmm1)`
	///
	/// `MVEX.512.66.0F38.W0 A0 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpscatterdd_mvt_k1_zmm = 4737,
	/// `VPSCATTERDQ mvt {k1}, Di64(zmm1)`
	///
	/// `MVEX.512.66.0F38.W1 A0 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpscatterdq_mvt_k1_zmm = 4738,
	/// `VSCATTERDPS mvt {k1}, Df32(zmm1)`
	///
	/// `MVEX.512.66.0F38.W0 A2 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vscatterdps_mvt_k1_zmm = 4739,
	/// `VSCATTERDPD mvt {k1}, Df64(zmm1)`
	///
	/// `MVEX.512.66.0F38.W1 A2 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vscatterdpd_mvt_k1_zmm = 4740,
	/// `VFMADD233PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 A4 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmadd233ps_zmm_k1_zmm_zmmmt = 4741,
	/// `VFMADD213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 A8 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmadd213ps_zmm_k1_zmm_zmmmt = 4742,
	/// `VFMADD213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 A8 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmadd213pd_zmm_k1_zmm_zmmmt = 4743,
	/// `VFMSUB213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 AA /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmsub213ps_zmm_k1_zmm_zmmmt = 4744,
	/// `VFMSUB213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 AA /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmsub213pd_zmm_k1_zmm_zmmmt = 4745,
	/// `VFNMADD213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 AC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmadd213ps_zmm_k1_zmm_zmmmt = 4746,
	/// `VFNMADD213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 AC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmadd213pd_zmm_k1_zmm_zmmmt = 4747,
	/// `VFNMSUB213PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 AE /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmsub213ps_zmm_k1_zmm_zmmmt = 4748,
	/// `VFNMSUB213PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 AE /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmsub213pd_zmm_k1_zmm_zmmmt = 4749,
	/// `UNDOC zmm1 {k1}, mvt`
	///
	/// `MVEX.512.66.0F38.W0 B0 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_mvt_512_66_0F38_W0_B0 = 4750,
	/// `UNDOC zmm1 {k1}, mvt`
	///
	/// `MVEX.512.66.0F38.W0 B2 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_mvt_512_66_0F38_W0_B2 = 4751,
	/// `VPMADD233D zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 B4 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpmadd233d_zmm_k1_zmm_zmmmt = 4752,
	/// `VPMADD231D zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 B5 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpmadd231d_zmm_k1_zmm_zmmmt = 4753,
	/// `VFMADD231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 B8 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmadd231ps_zmm_k1_zmm_zmmmt = 4754,
	/// `VFMADD231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 B8 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmadd231pd_zmm_k1_zmm_zmmmt = 4755,
	/// `VFMSUB231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 BA /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmsub231ps_zmm_k1_zmm_zmmmt = 4756,
	/// `VFMSUB231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 BA /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfmsub231pd_zmm_k1_zmm_zmmmt = 4757,
	/// `VFNMADD231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 BC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmadd231ps_zmm_k1_zmm_zmmmt = 4758,
	/// `VFNMADD231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 BC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmadd231pd_zmm_k1_zmm_zmmmt = 4759,
	/// `VFNMSUB231PS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 BE /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmsub231ps_zmm_k1_zmm_zmmmt = 4760,
	/// `VFNMSUB231PD zmm1 {k1}, zmm2, Sf64(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W1 BE /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vfnmsub231pd_zmm_k1_zmm_zmmmt = 4761,
	/// `UNDOC zmm1 {k1}, mvt`
	///
	/// `MVEX.512.66.0F38.W0 C0 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_mvt_512_66_0F38_W0_C0 = 4762,
	/// `VGATHERPF0HINTDPS Uf32(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W0 C6 /0 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgatherpf0hintdps_mvt_k1 = 4763,
	/// `VGATHERPF0HINTDPD Uf64(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W1 C6 /0 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgatherpf0hintdpd_mvt_k1 = 4764,
	/// `VGATHERPF0DPS Uf32(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W0 C6 /1 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgatherpf0dps_mvt_k1 = 4765,
	/// `VGATHERPF1DPS Uf32(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W0 C6 /2 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgatherpf1dps_mvt_k1 = 4766,
	/// `VSCATTERPF0HINTDPS Uf32(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W0 C6 /4 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vscatterpf0hintdps_mvt_k1 = 4767,
	/// `VSCATTERPF0HINTDPD Uf64(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W1 C6 /4 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vscatterpf0hintdpd_mvt_k1 = 4768,
	/// `VSCATTERPF0DPS Uf32(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W0 C6 /5 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vscatterpf0dps_mvt_k1 = 4769,
	/// `VSCATTERPF1DPS Uf32(mvt) {k1}`
	///
	/// `MVEX.512.66.0F38.W0 C6 /6 /vsib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vscatterpf1dps_mvt_k1 = 4770,
	/// `VEXP223PS zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 C8 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vexp223ps_zmm_k1_zmmmt = 4771,
	/// `VLOG2PS zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 C9 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vlog2ps_zmm_k1_zmmmt = 4772,
	/// `VRCP23PS zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 CA /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vrcp23ps_zmm_k1_zmmmt = 4773,
	/// `VRSQRT23PS zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 CB /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vrsqrt23ps_zmm_k1_zmmmt = 4774,
	/// `VADDSETSPS zmm1 {k1}, zmm2, Sf32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 CC /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vaddsetsps_zmm_k1_zmm_zmmmt = 4775,
	/// `VPADDSETSD zmm1 {k1}, zmm2, Si32(zmm3/mt)`
	///
	/// `MVEX.NDS.512.66.0F38.W0 CD /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpaddsetsd_zmm_k1_zmm_zmmmt = 4776,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 CE /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_CE = 4777,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W1 CE /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W1_CE = 4778,
	/// `UNDOC zmm1 {k1}, zmm2, zmm3/mt`
	///
	/// `MVEX.NDS.512.66.0F38.W0 CF /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_CF = 4779,
	/// `VLOADUNPACKLD zmm1 {k1}, Ui32(mt)`
	///
	/// `MVEX.512.0F38.W0 D0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpackld_zmm_k1_mt = 4780,
	/// `VLOADUNPACKLQ zmm1 {k1}, Ui64(mt)`
	///
	/// `MVEX.512.0F38.W1 D0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpacklq_zmm_k1_mt = 4781,
	/// `VPACKSTORELD mt {k1}, Di32(zmm1)`
	///
	/// `MVEX.512.66.0F38.W0 D0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstoreld_mt_k1_zmm = 4782,
	/// `VPACKSTORELQ mt {k1}, Di64(zmm1)`
	///
	/// `MVEX.512.66.0F38.W1 D0 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstorelq_mt_k1_zmm = 4783,
	/// `VLOADUNPACKLPS zmm1 {k1}, Uf32(mt)`
	///
	/// `MVEX.512.0F38.W0 D1 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpacklps_zmm_k1_mt = 4784,
	/// `VLOADUNPACKLPD zmm1 {k1}, Uf64(mt)`
	///
	/// `MVEX.512.0F38.W1 D1 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpacklpd_zmm_k1_mt = 4785,
	/// `VPACKSTORELPS mt {k1}, Df32(zmm1)`
	///
	/// `MVEX.512.66.0F38.W0 D1 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstorelps_mt_k1_zmm = 4786,
	/// `VPACKSTORELPD mt {k1}, Df64(zmm1)`
	///
	/// `MVEX.512.66.0F38.W1 D1 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstorelpd_mt_k1_zmm = 4787,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.0F38.W0 D2 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D2 = 4788,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 D2 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_D2 = 4789,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.0F38.W0 D3 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D3 = 4790,
	/// `VLOADUNPACKHD zmm1 {k1}, Ui32(mt)`
	///
	/// `MVEX.512.0F38.W0 D4 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpackhd_zmm_k1_mt = 4791,
	/// `VLOADUNPACKHQ zmm1 {k1}, Ui64(mt)`
	///
	/// `MVEX.512.0F38.W1 D4 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpackhq_zmm_k1_mt = 4792,
	/// `VPACKSTOREHD mt {k1}, Di32(zmm1)`
	///
	/// `MVEX.512.66.0F38.W0 D4 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstorehd_mt_k1_zmm = 4793,
	/// `VPACKSTOREHQ mt {k1}, Di64(zmm1)`
	///
	/// `MVEX.512.66.0F38.W1 D4 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstorehq_mt_k1_zmm = 4794,
	/// `VLOADUNPACKHPS zmm1 {k1}, Uf32(mt)`
	///
	/// `MVEX.512.0F38.W0 D5 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpackhps_zmm_k1_mt = 4795,
	/// `VLOADUNPACKHPD zmm1 {k1}, Uf64(mt)`
	///
	/// `MVEX.512.0F38.W1 D5 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vloadunpackhpd_zmm_k1_mt = 4796,
	/// `VPACKSTOREHPS mt {k1}, Df32(zmm1)`
	///
	/// `MVEX.512.66.0F38.W0 D5 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstorehps_mt_k1_zmm = 4797,
	/// `VPACKSTOREHPD mt {k1}, Df64(zmm1)`
	///
	/// `MVEX.512.66.0F38.W1 D5 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpackstorehpd_mt_k1_zmm = 4798,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.0F38.W0 D6 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D6 = 4799,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.66.0F38.W0 D6 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_D6 = 4800,
	/// `UNDOC zmm1 {k1}, zmm2/mt`
	///
	/// `MVEX.512.0F38.W0 D7 /r`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D7 = 4801,
	/// `VALIGND zmm1 {k1}, zmm2, zmm3/mt, imm8`
	///
	/// `MVEX.NDS.512.66.0F3A.W0 03 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Valignd_zmm_k1_zmm_zmmmt_imm8 = 4802,
	/// `VPERMF32X4 zmm1 {k1}, zmm2/mt, imm8`
	///
	/// `MVEX.512.66.0F3A.W0 07 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpermf32x4_zmm_k1_zmmmt_imm8 = 4803,
	/// `VPCMPUD k2 {k1}, zmm1, Si32(zmm2/mt), imm8`
	///
	/// `MVEX.NDS.512.66.0F3A.W0 1E /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpcmpud_kr_k1_zmm_zmmmt_imm8 = 4804,
	/// `VPCMPD k2 {k1}, zmm1, Si32(zmm2/mt), imm8`
	///
	/// `MVEX.NDS.512.66.0F3A.W0 1F /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vpcmpd_kr_k1_zmm_zmmmt_imm8 = 4805,
	/// `VGETMANTPS zmm1 {k1}, Sf32(zmm2/mt), imm8`
	///
	/// `MVEX.512.66.0F3A.W0 26 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgetmantps_zmm_k1_zmmmt_imm8 = 4806,
	/// `VGETMANTPD zmm1 {k1}, Sf64(zmm2/mt), imm8`
	///
	/// `MVEX.512.66.0F3A.W1 26 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vgetmantpd_zmm_k1_zmmmt_imm8 = 4807,
	/// `VRNDFXPNTPS zmm1 {k1}, Sf32(zmm2/mt), imm8`
	///
	/// `MVEX.512.66.0F3A.W0 52 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vrndfxpntps_zmm_k1_zmmmt_imm8 = 4808,
	/// `VRNDFXPNTPD zmm1 {k1}, Sf64(zmm2/mt), imm8`
	///
	/// `MVEX.512.66.0F3A.W1 52 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vrndfxpntpd_zmm_k1_zmmmt_imm8 = 4809,
	/// `VCVTFXPNTUDQ2PS zmm1 {k1}, Si32(zmm2/mt), imm8`
	///
	/// `MVEX.512.0F3A.W0 CA /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtfxpntudq2ps_zmm_k1_zmmmt_imm8 = 4810,
	/// `VCVTFXPNTPS2UDQ zmm1 {k1}, Sf32(zmm2/mt), imm8`
	///
	/// `MVEX.512.66.0F3A.W0 CA /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtfxpntps2udq_zmm_k1_zmmmt_imm8 = 4811,
	/// `VCVTFXPNTPD2UDQ zmm1 {k1}, Sf64(zmm2/mt), imm8`
	///
	/// `MVEX.512.F2.0F3A.W1 CA /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtfxpntpd2udq_zmm_k1_zmmmt_imm8 = 4812,
	/// `VCVTFXPNTDQ2PS zmm1 {k1}, Si32(zmm2/mt), imm8`
	///
	/// `MVEX.512.0F3A.W0 CB /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtfxpntdq2ps_zmm_k1_zmmmt_imm8 = 4813,
	/// `VCVTFXPNTPS2DQ zmm1 {k1}, Sf32(zmm2/mt), imm8`
	///
	/// `MVEX.512.66.0F3A.W0 CB /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtfxpntps2dq_zmm_k1_zmmmt_imm8 = 4814,
	/// `UNDOC zmm1 {k1}, zmm2/mt, imm8`
	///
	/// `MVEX.512.66.0F3A.W0 D0 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_imm8_512_66_0F3A_W0_D0 = 4815,
	/// `UNDOC zmm1 {k1}, zmm2/mt, imm8`
	///
	/// `MVEX.512.66.0F3A.W0 D1 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Undoc_zmm_k1_zmmmt_imm8_512_66_0F3A_W0_D1 = 4816,
	/// `VCVTFXPNTPD2DQ zmm1 {k1}, Sf64(zmm2/mt), imm8`
	///
	/// `MVEX.512.F2.0F3A.W1 E6 /r ib`
	///
	/// `KNC`
	///
	/// `64-bit`
	MVEX_Vcvtfxpntpd2dq_zmm_k1_zmmmt_imm8 = 4817,
	/// `UNDOC`
	///
	/// `a16 F3 0F A6 F0`
	///
	/// `PADLOCK_UNDOC`
	///
	/// `16/32-bit`
	Via_undoc_F30FA6F0_16 = 4818,
	/// `UNDOC`
	///
	/// `a32 F3 0F A6 F0`
	///
	/// `PADLOCK_UNDOC`
	///
	/// `16/32/64-bit`
	Via_undoc_F30FA6F0_32 = 4819,
	/// `UNDOC`
	///
	/// `a64 F3 0F A6 F0`
	///
	/// `PADLOCK_UNDOC`
	///
	/// `64-bit`
	Via_undoc_F30FA6F0_64 = 4820,
	/// `UNDOC`
	///
	/// `a16 F3 0F A6 F8`
	///
	/// `PADLOCK_UNDOC`
	///
	/// `16/32-bit`
	Via_undoc_F30FA6F8_16 = 4821,
	/// `UNDOC`
	///
	/// `a32 F3 0F A6 F8`
	///
	/// `PADLOCK_UNDOC`
	///
	/// `16/32/64-bit`
	Via_undoc_F30FA6F8_32 = 4822,
	/// `UNDOC`
	///
	/// `a64 F3 0F A6 F8`
	///
	/// `PADLOCK_UNDOC`
	///
	/// `64-bit`
	Via_undoc_F30FA6F8_64 = 4823,
	/// `XSHA512`
	///
	/// `a16 F3 0F A6 E0`
	///
	/// `PADLOCK_PHE`
	///
	/// `16/32-bit`
	Xsha512_16 = 4824,
	/// `XSHA512`
	///
	/// `a32 F3 0F A6 E0`
	///
	/// `PADLOCK_PHE`
	///
	/// `16/32/64-bit`
	Xsha512_32 = 4825,
	/// `XSHA512`
	///
	/// `a64 F3 0F A6 E0`
	///
	/// `PADLOCK_PHE`
	///
	/// `64-bit`
	Xsha512_64 = 4826,
	/// `XSTORE2`
	///
	/// `a16 F3 0F A7 F8`
	///
	/// `PADLOCK_RNG`
	///
	/// `16/32-bit`
	Xstore2_16 = 4827,
	/// `XSTORE2`
	///
	/// `a32 F3 0F A7 F8`
	///
	/// `PADLOCK_RNG`
	///
	/// `16/32/64-bit`
	Xstore2_32 = 4828,
	/// `XSTORE2`
	///
	/// `a64 F3 0F A7 F8`
	///
	/// `PADLOCK_RNG`
	///
	/// `64-bit`
	Xstore2_64 = 4829,
}
#[rustfmt::skip]
static GEN_DEBUG_CODE: [&str; 4830] = [
	"INVALID",
	"DeclareByte",
	"DeclareWord",
	"DeclareDword",
	"DeclareQword",
	"Add_rm8_r8",
	"Add_rm16_r16",
	"Add_rm32_r32",
	"Add_rm64_r64",
	"Add_r8_rm8",
	"Add_r16_rm16",
	"Add_r32_rm32",
	"Add_r64_rm64",
	"Add_AL_imm8",
	"Add_AX_imm16",
	"Add_EAX_imm32",
	"Add_RAX_imm32",
	"Pushw_ES",
	"Pushd_ES",
	"Popw_ES",
	"Popd_ES",
	"Or_rm8_r8",
	"Or_rm16_r16",
	"Or_rm32_r32",
	"Or_rm64_r64",
	"Or_r8_rm8",
	"Or_r16_rm16",
	"Or_r32_rm32",
	"Or_r64_rm64",
	"Or_AL_imm8",
	"Or_AX_imm16",
	"Or_EAX_imm32",
	"Or_RAX_imm32",
	"Pushw_CS",
	"Pushd_CS",
	"Popw_CS",
	"Adc_rm8_r8",
	"Adc_rm16_r16",
	"Adc_rm32_r32",
	"Adc_rm64_r64",
	"Adc_r8_rm8",
	"Adc_r16_rm16",
	"Adc_r32_rm32",
	"Adc_r64_rm64",
	"Adc_AL_imm8",
	"Adc_AX_imm16",
	"Adc_EAX_imm32",
	"Adc_RAX_imm32",
	"Pushw_SS",
	"Pushd_SS",
	"Popw_SS",
	"Popd_SS",
	"Sbb_rm8_r8",
	"Sbb_rm16_r16",
	"Sbb_rm32_r32",
	"Sbb_rm64_r64",
	"Sbb_r8_rm8",
	"Sbb_r16_rm16",
	"Sbb_r32_rm32",
	"Sbb_r64_rm64",
	"Sbb_AL_imm8",
	"Sbb_AX_imm16",
	"Sbb_EAX_imm32",
	"Sbb_RAX_imm32",
	"Pushw_DS",
	"Pushd_DS",
	"Popw_DS",
	"Popd_DS",
	"And_rm8_r8",
	"And_rm16_r16",
	"And_rm32_r32",
	"And_rm64_r64",
	"And_r8_rm8",
	"And_r16_rm16",
	"And_r32_rm32",
	"And_r64_rm64",
	"And_AL_imm8",
	"And_AX_imm16",
	"And_EAX_imm32",
	"And_RAX_imm32",
	"Daa",
	"Sub_rm8_r8",
	"Sub_rm16_r16",
	"Sub_rm32_r32",
	"Sub_rm64_r64",
	"Sub_r8_rm8",
	"Sub_r16_rm16",
	"Sub_r32_rm32",
	"Sub_r64_rm64",
	"Sub_AL_imm8",
	"Sub_AX_imm16",
	"Sub_EAX_imm32",
	"Sub_RAX_imm32",
	"Das",
	"Xor_rm8_r8",
	"Xor_rm16_r16",
	"Xor_rm32_r32",
	"Xor_rm64_r64",
	"Xor_r8_rm8",
	"Xor_r16_rm16",
	"Xor_r32_rm32",
	"Xor_r64_rm64",
	"Xor_AL_imm8",
	"Xor_AX_imm16",
	"Xor_EAX_imm32",
	"Xor_RAX_imm32",
	"Aaa",
	"Cmp_rm8_r8",
	"Cmp_rm16_r16",
	"Cmp_rm32_r32",
	"Cmp_rm64_r64",
	"Cmp_r8_rm8",
	"Cmp_r16_rm16",
	"Cmp_r32_rm32",
	"Cmp_r64_rm64",
	"Cmp_AL_imm8",
	"Cmp_AX_imm16",
	"Cmp_EAX_imm32",
	"Cmp_RAX_imm32",
	"Aas",
	"Inc_r16",
	"Inc_r32",
	"Dec_r16",
	"Dec_r32",
	"Push_r16",
	"Push_r32",
	"Push_r64",
	"Pop_r16",
	"Pop_r32",
	"Pop_r64",
	"Pushaw",
	"Pushad",
	"Popaw",
	"Popad",
	"Bound_r16_m1616",
	"Bound_r32_m3232",
	"Arpl_rm16_r16",
	"Arpl_r32m16_r32",
	"Movsxd_r16_rm16",
	"Movsxd_r32_rm32",
	"Movsxd_r64_rm32",
	"Push_imm16",
	"Pushd_imm32",
	"Pushq_imm32",
	"Imul_r16_rm16_imm16",
	"Imul_r32_rm32_imm32",
	"Imul_r64_rm64_imm32",
	"Pushw_imm8",
	"Pushd_imm8",
	"Pushq_imm8",
	"Imul_r16_rm16_imm8",
	"Imul_r32_rm32_imm8",
	"Imul_r64_rm64_imm8",
	"Insb_m8_DX",
	"Insw_m16_DX",
	"Insd_m32_DX",
	"Outsb_DX_m8",
	"Outsw_DX_m16",
	"Outsd_DX_m32",
	"Jo_rel8_16",
	"Jo_rel8_32",
	"Jo_rel8_64",
	"Jno_rel8_16",
	"Jno_rel8_32",
	"Jno_rel8_64",
	"Jb_rel8_16",
	"Jb_rel8_32",
	"Jb_rel8_64",
	"Jae_rel8_16",
	"Jae_rel8_32",
	"Jae_rel8_64",
	"Je_rel8_16",
	"Je_rel8_32",
	"Je_rel8_64",
	"Jne_rel8_16",
	"Jne_rel8_32",
	"Jne_rel8_64",
	"Jbe_rel8_16",
	"Jbe_rel8_32",
	"Jbe_rel8_64",
	"Ja_rel8_16",
	"Ja_rel8_32",
	"Ja_rel8_64",
	"Js_rel8_16",
	"Js_rel8_32",
	"Js_rel8_64",
	"Jns_rel8_16",
	"Jns_rel8_32",
	"Jns_rel8_64",
	"Jp_rel8_16",
	"Jp_rel8_32",
	"Jp_rel8_64",
	"Jnp_rel8_16",
	"Jnp_rel8_32",
	"Jnp_rel8_64",
	"Jl_rel8_16",
	"Jl_rel8_32",
	"Jl_rel8_64",
	"Jge_rel8_16",
	"Jge_rel8_32",
	"Jge_rel8_64",
	"Jle_rel8_16",
	"Jle_rel8_32",
	"Jle_rel8_64",
	"Jg_rel8_16",
	"Jg_rel8_32",
	"Jg_rel8_64",
	"Add_rm8_imm8",
	"Or_rm8_imm8",
	"Adc_rm8_imm8",
	"Sbb_rm8_imm8",
	"And_rm8_imm8",
	"Sub_rm8_imm8",
	"Xor_rm8_imm8",
	"Cmp_rm8_imm8",
	"Add_rm16_imm16",
	"Add_rm32_imm32",
	"Add_rm64_imm32",
	"Or_rm16_imm16",
	"Or_rm32_imm32",
	"Or_rm64_imm32",
	"Adc_rm16_imm16",
	"Adc_rm32_imm32",
	"Adc_rm64_imm32",
	"Sbb_rm16_imm16",
	"Sbb_rm32_imm32",
	"Sbb_rm64_imm32",
	"And_rm16_imm16",
	"And_rm32_imm32",
	"And_rm64_imm32",
	"Sub_rm16_imm16",
	"Sub_rm32_imm32",
	"Sub_rm64_imm32",
	"Xor_rm16_imm16",
	"Xor_rm32_imm32",
	"Xor_rm64_imm32",
	"Cmp_rm16_imm16",
	"Cmp_rm32_imm32",
	"Cmp_rm64_imm32",
	"Add_rm8_imm8_82",
	"Or_rm8_imm8_82",
	"Adc_rm8_imm8_82",
	"Sbb_rm8_imm8_82",
	"And_rm8_imm8_82",
	"Sub_rm8_imm8_82",
	"Xor_rm8_imm8_82",
	"Cmp_rm8_imm8_82",
	"Add_rm16_imm8",
	"Add_rm32_imm8",
	"Add_rm64_imm8",
	"Or_rm16_imm8",
	"Or_rm32_imm8",
	"Or_rm64_imm8",
	"Adc_rm16_imm8",
	"Adc_rm32_imm8",
	"Adc_rm64_imm8",
	"Sbb_rm16_imm8",
	"Sbb_rm32_imm8",
	"Sbb_rm64_imm8",
	"And_rm16_imm8",
	"And_rm32_imm8",
	"And_rm64_imm8",
	"Sub_rm16_imm8",
	"Sub_rm32_imm8",
	"Sub_rm64_imm8",
	"Xor_rm16_imm8",
	"Xor_rm32_imm8",
	"Xor_rm64_imm8",
	"Cmp_rm16_imm8",
	"Cmp_rm32_imm8",
	"Cmp_rm64_imm8",
	"Test_rm8_r8",
	"Test_rm16_r16",
	"Test_rm32_r32",
	"Test_rm64_r64",
	"Xchg_rm8_r8",
	"Xchg_rm16_r16",
	"Xchg_rm32_r32",
	"Xchg_rm64_r64",
	"Mov_rm8_r8",
	"Mov_rm16_r16",
	"Mov_rm32_r32",
	"Mov_rm64_r64",
	"Mov_r8_rm8",
	"Mov_r16_rm16",
	"Mov_r32_rm32",
	"Mov_r64_rm64",
	"Mov_rm16_Sreg",
	"Mov_r32m16_Sreg",
	"Mov_r64m16_Sreg",
	"Lea_r16_m",
	"Lea_r32_m",
	"Lea_r64_m",
	"Mov_Sreg_rm16",
	"Mov_Sreg_r32m16",
	"Mov_Sreg_r64m16",
	"Pop_rm16",
	"Pop_rm32",
	"Pop_rm64",
	"Nopw",
	"Nopd",
	"Nopq",
	"Xchg_r16_AX",
	"Xchg_r32_EAX",
	"Xchg_r64_RAX",
	"Pause",
	"Cbw",
	"Cwde",
	"Cdqe",
	"Cwd",
	"Cdq",
	"Cqo",
	"Call_ptr1616",
	"Call_ptr1632",
	"Wait",
	"Pushfw",
	"Pushfd",
	"Pushfq",
	"Popfw",
	"Popfd",
	"Popfq",
	"Sahf",
	"Lahf",
	"Mov_AL_moffs8",
	"Mov_AX_moffs16",
	"Mov_EAX_moffs32",
	"Mov_RAX_moffs64",
	"Mov_moffs8_AL",
	"Mov_moffs16_AX",
	"Mov_moffs32_EAX",
	"Mov_moffs64_RAX",
	"Movsb_m8_m8",
	"Movsw_m16_m16",
	"Movsd_m32_m32",
	"Movsq_m64_m64",
	"Cmpsb_m8_m8",
	"Cmpsw_m16_m16",
	"Cmpsd_m32_m32",
	"Cmpsq_m64_m64",
	"Test_AL_imm8",
	"Test_AX_imm16",
	"Test_EAX_imm32",
	"Test_RAX_imm32",
	"Stosb_m8_AL",
	"Stosw_m16_AX",
	"Stosd_m32_EAX",
	"Stosq_m64_RAX",
	"Lodsb_AL_m8",
	"Lodsw_AX_m16",
	"Lodsd_EAX_m32",
	"Lodsq_RAX_m64",
	"Scasb_AL_m8",
	"Scasw_AX_m16",
	"Scasd_EAX_m32",
	"Scasq_RAX_m64",
	"Mov_r8_imm8",
	"Mov_r16_imm16",
	"Mov_r32_imm32",
	"Mov_r64_imm64",
	"Rol_rm8_imm8",
	"Ror_rm8_imm8",
	"Rcl_rm8_imm8",
	"Rcr_rm8_imm8",
	"Shl_rm8_imm8",
	"Shr_rm8_imm8",
	"Sal_rm8_imm8",
	"Sar_rm8_imm8",
	"Rol_rm16_imm8",
	"Rol_rm32_imm8",
	"Rol_rm64_imm8",
	"Ror_rm16_imm8",
	"Ror_rm32_imm8",
	"Ror_rm64_imm8",
	"Rcl_rm16_imm8",
	"Rcl_rm32_imm8",
	"Rcl_rm64_imm8",
	"Rcr_rm16_imm8",
	"Rcr_rm32_imm8",
	"Rcr_rm64_imm8",
	"Shl_rm16_imm8",
	"Shl_rm32_imm8",
	"Shl_rm64_imm8",
	"Shr_rm16_imm8",
	"Shr_rm32_imm8",
	"Shr_rm64_imm8",
	"Sal_rm16_imm8",
	"Sal_rm32_imm8",
	"Sal_rm64_imm8",
	"Sar_rm16_imm8",
	"Sar_rm32_imm8",
	"Sar_rm64_imm8",
	"Retnw_imm16",
	"Retnd_imm16",
	"Retnq_imm16",
	"Retnw",
	"Retnd",
	"Retnq",
	"Les_r16_m1616",
	"Les_r32_m1632",
	"Lds_r16_m1616",
	"Lds_r32_m1632",
	"Mov_rm8_imm8",
	"Xabort_imm8",
	"Mov_rm16_imm16",
	"Mov_rm32_imm32",
	"Mov_rm64_imm32",
	"Xbegin_rel16",
	"Xbegin_rel32",
	"Enterw_imm16_imm8",
	"Enterd_imm16_imm8",
	"Enterq_imm16_imm8",
	"Leavew",
	"Leaved",
	"Leaveq",
	"Retfw_imm16",
	"Retfd_imm16",
	"Retfq_imm16",
	"Retfw",
	"Retfd",
	"Retfq",
	"Int3",
	"Int_imm8",
	"Into",
	"Iretw",
	"Iretd",
	"Iretq",
	"Rol_rm8_1",
	"Ror_rm8_1",
	"Rcl_rm8_1",
	"Rcr_rm8_1",
	"Shl_rm8_1",
	"Shr_rm8_1",
	"Sal_rm8_1",
	"Sar_rm8_1",
	"Rol_rm16_1",
	"Rol_rm32_1",
	"Rol_rm64_1",
	"Ror_rm16_1",
	"Ror_rm32_1",
	"Ror_rm64_1",
	"Rcl_rm16_1",
	"Rcl_rm32_1",
	"Rcl_rm64_1",
	"Rcr_rm16_1",
	"Rcr_rm32_1",
	"Rcr_rm64_1",
	"Shl_rm16_1",
	"Shl_rm32_1",
	"Shl_rm64_1",
	"Shr_rm16_1",
	"Shr_rm32_1",
	"Shr_rm64_1",
	"Sal_rm16_1",
	"Sal_rm32_1",
	"Sal_rm64_1",
	"Sar_rm16_1",
	"Sar_rm32_1",
	"Sar_rm64_1",
	"Rol_rm8_CL",
	"Ror_rm8_CL",
	"Rcl_rm8_CL",
	"Rcr_rm8_CL",
	"Shl_rm8_CL",
	"Shr_rm8_CL",
	"Sal_rm8_CL",
	"Sar_rm8_CL",
	"Rol_rm16_CL",
	"Rol_rm32_CL",
	"Rol_rm64_CL",
	"Ror_rm16_CL",
	"Ror_rm32_CL",
	"Ror_rm64_CL",
	"Rcl_rm16_CL",
	"Rcl_rm32_CL",
	"Rcl_rm64_CL",
	"Rcr_rm16_CL",
	"Rcr_rm32_CL",
	"Rcr_rm64_CL",
	"Shl_rm16_CL",
	"Shl_rm32_CL",
	"Shl_rm64_CL",
	"Shr_rm16_CL",
	"Shr_rm32_CL",
	"Shr_rm64_CL",
	"Sal_rm16_CL",
	"Sal_rm32_CL",
	"Sal_rm64_CL",
	"Sar_rm16_CL",
	"Sar_rm32_CL",
	"Sar_rm64_CL",
	"Aam_imm8",
	"Aad_imm8",
	"Salc",
	"Xlat_m8",
	"Fadd_m32fp",
	"Fmul_m32fp",
	"Fcom_m32fp",
	"Fcomp_m32fp",
	"Fsub_m32fp",
	"Fsubr_m32fp",
	"Fdiv_m32fp",
	"Fdivr_m32fp",
	"Fadd_st0_sti",
	"Fmul_st0_sti",
	"Fcom_st0_sti",
	"Fcomp_st0_sti",
	"Fsub_st0_sti",
	"Fsubr_st0_sti",
	"Fdiv_st0_sti",
	"Fdivr_st0_sti",
	"Fld_m32fp",
	"Fst_m32fp",
	"Fstp_m32fp",
	"Fldenv_m14byte",
	"Fldenv_m28byte",
	"Fldcw_m2byte",
	"Fnstenv_m14byte",
	"Fstenv_m14byte",
	"Fnstenv_m28byte",
	"Fstenv_m28byte",
	"Fnstcw_m2byte",
	"Fstcw_m2byte",
	"Fld_sti",
	"Fxch_st0_sti",
	"Fnop",
	"Fstpnce_sti",
	"Fchs",
	"Fabs",
	"Ftst",
	"Fxam",
	"Fld1",
	"Fldl2t",
	"Fldl2e",
	"Fldpi",
	"Fldlg2",
	"Fldln2",
	"Fldz",
	"F2xm1",
	"Fyl2x",
	"Fptan",
	"Fpatan",
	"Fxtract",
	"Fprem1",
	"Fdecstp",
	"Fincstp",
	"Fprem",
	"Fyl2xp1",
	"Fsqrt",
	"Fsincos",
	"Frndint",
	"Fscale",
	"Fsin",
	"Fcos",
	"Fiadd_m32int",
	"Fimul_m32int",
	"Ficom_m32int",
	"Ficomp_m32int",
	"Fisub_m32int",
	"Fisubr_m32int",
	"Fidiv_m32int",
	"Fidivr_m32int",
	"Fcmovb_st0_sti",
	"Fcmove_st0_sti",
	"Fcmovbe_st0_sti",
	"Fcmovu_st0_sti",
	"Fucompp",
	"Fild_m32int",
	"Fisttp_m32int",
	"Fist_m32int",
	"Fistp_m32int",
	"Fld_m80fp",
	"Fstp_m80fp",
	"Fcmovnb_st0_sti",
	"Fcmovne_st0_sti",
	"Fcmovnbe_st0_sti",
	"Fcmovnu_st0_sti",
	"Fneni",
	"Feni",
	"Fndisi",
	"Fdisi",
	"Fnclex",
	"Fclex",
	"Fninit",
	"Finit",
	"Fnsetpm",
	"Fsetpm",
	"Frstpm",
	"Fucomi_st0_sti",
	"Fcomi_st0_sti",
	"Fadd_m64fp",
	"Fmul_m64fp",
	"Fcom_m64fp",
	"Fcomp_m64fp",
	"Fsub_m64fp",
	"Fsubr_m64fp",
	"Fdiv_m64fp",
	"Fdivr_m64fp",
	"Fadd_sti_st0",
	"Fmul_sti_st0",
	"Fcom_st0_sti_DCD0",
	"Fcomp_st0_sti_DCD8",
	"Fsubr_sti_st0",
	"Fsub_sti_st0",
	"Fdivr_sti_st0",
	"Fdiv_sti_st0",
	"Fld_m64fp",
	"Fisttp_m64int",
	"Fst_m64fp",
	"Fstp_m64fp",
	"Frstor_m94byte",
	"Frstor_m108byte",
	"Fnsave_m94byte",
	"Fsave_m94byte",
	"Fnsave_m108byte",
	"Fsave_m108byte",
	"Fnstsw_m2byte",
	"Fstsw_m2byte",
	"Ffree_sti",
	"Fxch_st0_sti_DDC8",
	"Fst_sti",
	"Fstp_sti",
	"Fucom_st0_sti",
	"Fucomp_st0_sti",
	"Fiadd_m16int",
	"Fimul_m16int",
	"Ficom_m16int",
	"Ficomp_m16int",
	"Fisub_m16int",
	"Fisubr_m16int",
	"Fidiv_m16int",
	"Fidivr_m16int",
	"Faddp_sti_st0",
	"Fmulp_sti_st0",
	"Fcomp_st0_sti_DED0",
	"Fcompp",
	"Fsubrp_sti_st0",
	"Fsubp_sti_st0",
	"Fdivrp_sti_st0",
	"Fdivp_sti_st0",
	"Fild_m16int",
	"Fisttp_m16int",
	"Fist_m16int",
	"Fistp_m16int",
	"Fbld_m80bcd",
	"Fild_m64int",
	"Fbstp_m80bcd",
	"Fistp_m64int",
	"Ffreep_sti",
	"Fxch_st0_sti_DFC8",
	"Fstp_sti_DFD0",
	"Fstp_sti_DFD8",
	"Fnstsw_AX",
	"Fstsw_AX",
	"Fstdw_AX",
	"Fstsg_AX",
	"Fucomip_st0_sti",
	"Fcomip_st0_sti",
	"Loopne_rel8_16_CX",
	"Loopne_rel8_32_CX",
	"Loopne_rel8_16_ECX",
	"Loopne_rel8_32_ECX",
	"Loopne_rel8_64_ECX",
	"Loopne_rel8_16_RCX",
	"Loopne_rel8_64_RCX",
	"Loope_rel8_16_CX",
	"Loope_rel8_32_CX",
	"Loope_rel8_16_ECX",
	"Loope_rel8_32_ECX",
	"Loope_rel8_64_ECX",
	"Loope_rel8_16_RCX",
	"Loope_rel8_64_RCX",
	"Loop_rel8_16_CX",
	"Loop_rel8_32_CX",
	"Loop_rel8_16_ECX",
	"Loop_rel8_32_ECX",
	"Loop_rel8_64_ECX",
	"Loop_rel8_16_RCX",
	"Loop_rel8_64_RCX",
	"Jcxz_rel8_16",
	"Jcxz_rel8_32",
	"Jecxz_rel8_16",
	"Jecxz_rel8_32",
	"Jecxz_rel8_64",
	"Jrcxz_rel8_16",
	"Jrcxz_rel8_64",
	"In_AL_imm8",
	"In_AX_imm8",
	"In_EAX_imm8",
	"Out_imm8_AL",
	"Out_imm8_AX",
	"Out_imm8_EAX",
	"Call_rel16",
	"Call_rel32_32",
	"Call_rel32_64",
	"Jmp_rel16",
	"Jmp_rel32_32",
	"Jmp_rel32_64",
	"Jmp_ptr1616",
	"Jmp_ptr1632",
	"Jmp_rel8_16",
	"Jmp_rel8_32",
	"Jmp_rel8_64",
	"In_AL_DX",
	"In_AX_DX",
	"In_EAX_DX",
	"Out_DX_AL",
	"Out_DX_AX",
	"Out_DX_EAX",
	"Int1",
	"Hlt",
	"Cmc",
	"Test_rm8_imm8",
	"Test_rm8_imm8_F6r1",
	"Not_rm8",
	"Neg_rm8",
	"Mul_rm8",
	"Imul_rm8",
	"Div_rm8",
	"Idiv_rm8",
	"Test_rm16_imm16",
	"Test_rm32_imm32",
	"Test_rm64_imm32",
	"Test_rm16_imm16_F7r1",
	"Test_rm32_imm32_F7r1",
	"Test_rm64_imm32_F7r1",
	"Not_rm16",
	"Not_rm32",
	"Not_rm64",
	"Neg_rm16",
	"Neg_rm32",
	"Neg_rm64",
	"Mul_rm16",
	"Mul_rm32",
	"Mul_rm64",
	"Imul_rm16",
	"Imul_rm32",
	"Imul_rm64",
	"Div_rm16",
	"Div_rm32",
	"Div_rm64",
	"Idiv_rm16",
	"Idiv_rm32",
	"Idiv_rm64",
	"Clc",
	"Stc",
	"Cli",
	"Sti",
	"Cld",
	"Std",
	"Inc_rm8",
	"Dec_rm8",
	"Inc_rm16",
	"Inc_rm32",
	"Inc_rm64",
	"Dec_rm16",
	"Dec_rm32",
	"Dec_rm64",
	"Call_rm16",
	"Call_rm32",
	"Call_rm64",
	"Call_m1616",
	"Call_m1632",
	"Call_m1664",
	"Jmp_rm16",
	"Jmp_rm32",
	"Jmp_rm64",
	"Jmp_m1616",
	"Jmp_m1632",
	"Jmp_m1664",
	"Push_rm16",
	"Push_rm32",
	"Push_rm64",
	"Sldt_rm16",
	"Sldt_r32m16",
	"Sldt_r64m16",
	"Str_rm16",
	"Str_r32m16",
	"Str_r64m16",
	"Lldt_rm16",
	"Lldt_r32m16",
	"Lldt_r64m16",
	"Ltr_rm16",
	"Ltr_r32m16",
	"Ltr_r64m16",
	"Verr_rm16",
	"Verr_r32m16",
	"Verr_r64m16",
	"Verw_rm16",
	"Verw_r32m16",
	"Verw_r64m16",
	"Jmpe_rm16",
	"Jmpe_rm32",
	"Sgdt_m1632_16",
	"Sgdt_m1632",
	"Sgdt_m1664",
	"Sidt_m1632_16",
	"Sidt_m1632",
	"Sidt_m1664",
	"Lgdt_m1632_16",
	"Lgdt_m1632",
	"Lgdt_m1664",
	"Lidt_m1632_16",
	"Lidt_m1632",
	"Lidt_m1664",
	"Smsw_rm16",
	"Smsw_r32m16",
	"Smsw_r64m16",
	"Rstorssp_m64",
	"Lmsw_rm16",
	"Lmsw_r32m16",
	"Lmsw_r64m16",
	"Invlpg_m",
	"Enclv",
	"Vmcall",
	"Vmlaunch",
	"Vmresume",
	"Vmxoff",
	"Pconfig",
	"Monitorw",
	"Monitord",
	"Monitorq",
	"Mwait",
	"Clac",
	"Stac",
	"Encls",
	"Xgetbv",
	"Xsetbv",
	"Vmfunc",
	"Xend",
	"Xtest",
	"Enclu",
	"Vmrunw",
	"Vmrund",
	"Vmrunq",
	"Vmmcall",
	"Vmloadw",
	"Vmloadd",
	"Vmloadq",
	"Vmsavew",
	"Vmsaved",
	"Vmsaveq",
	"Stgi",
	"Clgi",
	"Skinit",
	"Invlpgaw",
	"Invlpgad",
	"Invlpgaq",
	"Setssbsy",
	"Saveprevssp",
	"Rdpkru",
	"Wrpkru",
	"Swapgs",
	"Rdtscp",
	"Monitorxw",
	"Monitorxd",
	"Monitorxq",
	"Mcommit",
	"Mwaitx",
	"Clzerow",
	"Clzerod",
	"Clzeroq",
	"Rdpru",
	"Lar_r16_rm16",
	"Lar_r32_r32m16",
	"Lar_r64_r64m16",
	"Lsl_r16_rm16",
	"Lsl_r32_r32m16",
	"Lsl_r64_r64m16",
	"Storeall",
	"Loadall286",
	"Syscall",
	"Clts",
	"Loadall386",
	"Sysretd",
	"Sysretq",
	"Invd",
	"Wbinvd",
	"Wbnoinvd",
	"Cl1invmb",
	"Ud2",
	"Reservednop_rm16_r16_0F0D",
	"Reservednop_rm32_r32_0F0D",
	"Reservednop_rm64_r64_0F0D",
	"Prefetch_m8",
	"Prefetchw_m8",
	"Prefetchwt1_m8",
	"Femms",
	"Umov_rm8_r8",
	"Umov_rm16_r16",
	"Umov_rm32_r32",
	"Umov_r8_rm8",
	"Umov_r16_rm16",
	"Umov_r32_rm32",
	"Movups_xmm_xmmm128",
	"VEX_Vmovups_xmm_xmmm128",
	"VEX_Vmovups_ymm_ymmm256",
	"EVEX_Vmovups_xmm_k1z_xmmm128",
	"EVEX_Vmovups_ymm_k1z_ymmm256",
	"EVEX_Vmovups_zmm_k1z_zmmm512",
	"Movupd_xmm_xmmm128",
	"VEX_Vmovupd_xmm_xmmm128",
	"VEX_Vmovupd_ymm_ymmm256",
	"EVEX_Vmovupd_xmm_k1z_xmmm128",
	"EVEX_Vmovupd_ymm_k1z_ymmm256",
	"EVEX_Vmovupd_zmm_k1z_zmmm512",
	"Movss_xmm_xmmm32",
	"VEX_Vmovss_xmm_xmm_xmm",
	"VEX_Vmovss_xmm_m32",
	"EVEX_Vmovss_xmm_k1z_xmm_xmm",
	"EVEX_Vmovss_xmm_k1z_m32",
	"Movsd_xmm_xmmm64",
	"VEX_Vmovsd_xmm_xmm_xmm",
	"VEX_Vmovsd_xmm_m64",
	"EVEX_Vmovsd_xmm_k1z_xmm_xmm",
	"EVEX_Vmovsd_xmm_k1z_m64",
	"Movups_xmmm128_xmm",
	"VEX_Vmovups_xmmm128_xmm",
	"VEX_Vmovups_ymmm256_ymm",
	"EVEX_Vmovups_xmmm128_k1z_xmm",
	"EVEX_Vmovups_ymmm256_k1z_ymm",
	"EVEX_Vmovups_zmmm512_k1z_zmm",
	"Movupd_xmmm128_xmm",
	"VEX_Vmovupd_xmmm128_xmm",
	"VEX_Vmovupd_ymmm256_ymm",
	"EVEX_Vmovupd_xmmm128_k1z_xmm",
	"EVEX_Vmovupd_ymmm256_k1z_ymm",
	"EVEX_Vmovupd_zmmm512_k1z_zmm",
	"Movss_xmmm32_xmm",
	"VEX_Vmovss_xmm_xmm_xmm_0F11",
	"VEX_Vmovss_m32_xmm",
	"EVEX_Vmovss_xmm_k1z_xmm_xmm_0F11",
	"EVEX_Vmovss_m32_k1_xmm",
	"Movsd_xmmm64_xmm",
	"VEX_Vmovsd_xmm_xmm_xmm_0F11",
	"VEX_Vmovsd_m64_xmm",
	"EVEX_Vmovsd_xmm_k1z_xmm_xmm_0F11",
	"EVEX_Vmovsd_m64_k1_xmm",
	"Movhlps_xmm_xmm",
	"Movlps_xmm_m64",
	"VEX_Vmovhlps_xmm_xmm_xmm",
	"VEX_Vmovlps_xmm_xmm_m64",
	"EVEX_Vmovhlps_xmm_xmm_xmm",
	"EVEX_Vmovlps_xmm_xmm_m64",
	"Movlpd_xmm_m64",
	"VEX_Vmovlpd_xmm_xmm_m64",
	"EVEX_Vmovlpd_xmm_xmm_m64",
	"Movsldup_xmm_xmmm128",
	"VEX_Vmovsldup_xmm_xmmm128",
	"VEX_Vmovsldup_ymm_ymmm256",
	"EVEX_Vmovsldup_xmm_k1z_xmmm128",
	"EVEX_Vmovsldup_ymm_k1z_ymmm256",
	"EVEX_Vmovsldup_zmm_k1z_zmmm512",
	"Movddup_xmm_xmmm64",
	"VEX_Vmovddup_xmm_xmmm64",
	"VEX_Vmovddup_ymm_ymmm256",
	"EVEX_Vmovddup_xmm_k1z_xmmm64",
	"EVEX_Vmovddup_ymm_k1z_ymmm256",
	"EVEX_Vmovddup_zmm_k1z_zmmm512",
	"Movlps_m64_xmm",
	"VEX_Vmovlps_m64_xmm",
	"EVEX_Vmovlps_m64_xmm",
	"Movlpd_m64_xmm",
	"VEX_Vmovlpd_m64_xmm",
	"EVEX_Vmovlpd_m64_xmm",
	"Unpcklps_xmm_xmmm128",
	"VEX_Vunpcklps_xmm_xmm_xmmm128",
	"VEX_Vunpcklps_ymm_ymm_ymmm256",
	"EVEX_Vunpcklps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vunpcklps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vunpcklps_zmm_k1z_zmm_zmmm512b32",
	"Unpcklpd_xmm_xmmm128",
	"VEX_Vunpcklpd_xmm_xmm_xmmm128",
	"VEX_Vunpcklpd_ymm_ymm_ymmm256",
	"EVEX_Vunpcklpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vunpcklpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vunpcklpd_zmm_k1z_zmm_zmmm512b64",
	"Unpckhps_xmm_xmmm128",
	"VEX_Vunpckhps_xmm_xmm_xmmm128",
	"VEX_Vunpckhps_ymm_ymm_ymmm256",
	"EVEX_Vunpckhps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vunpckhps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vunpckhps_zmm_k1z_zmm_zmmm512b32",
	"Unpckhpd_xmm_xmmm128",
	"VEX_Vunpckhpd_xmm_xmm_xmmm128",
	"VEX_Vunpckhpd_ymm_ymm_ymmm256",
	"EVEX_Vunpckhpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vunpckhpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vunpckhpd_zmm_k1z_zmm_zmmm512b64",
	"Movlhps_xmm_xmm",
	"VEX_Vmovlhps_xmm_xmm_xmm",
	"EVEX_Vmovlhps_xmm_xmm_xmm",
	"Movhps_xmm_m64",
	"VEX_Vmovhps_xmm_xmm_m64",
	"EVEX_Vmovhps_xmm_xmm_m64",
	"Movhpd_xmm_m64",
	"VEX_Vmovhpd_xmm_xmm_m64",
	"EVEX_Vmovhpd_xmm_xmm_m64",
	"Movshdup_xmm_xmmm128",
	"VEX_Vmovshdup_xmm_xmmm128",
	"VEX_Vmovshdup_ymm_ymmm256",
	"EVEX_Vmovshdup_xmm_k1z_xmmm128",
	"EVEX_Vmovshdup_ymm_k1z_ymmm256",
	"EVEX_Vmovshdup_zmm_k1z_zmmm512",
	"Movhps_m64_xmm",
	"VEX_Vmovhps_m64_xmm",
	"EVEX_Vmovhps_m64_xmm",
	"Movhpd_m64_xmm",
	"VEX_Vmovhpd_m64_xmm",
	"EVEX_Vmovhpd_m64_xmm",
	"Reservednop_rm16_r16_0F18",
	"Reservednop_rm32_r32_0F18",
	"Reservednop_rm64_r64_0F18",
	"Reservednop_rm16_r16_0F19",
	"Reservednop_rm32_r32_0F19",
	"Reservednop_rm64_r64_0F19",
	"Reservednop_rm16_r16_0F1A",
	"Reservednop_rm32_r32_0F1A",
	"Reservednop_rm64_r64_0F1A",
	"Reservednop_rm16_r16_0F1B",
	"Reservednop_rm32_r32_0F1B",
	"Reservednop_rm64_r64_0F1B",
	"Reservednop_rm16_r16_0F1C",
	"Reservednop_rm32_r32_0F1C",
	"Reservednop_rm64_r64_0F1C",
	"Reservednop_rm16_r16_0F1D",
	"Reservednop_rm32_r32_0F1D",
	"Reservednop_rm64_r64_0F1D",
	"Reservednop_rm16_r16_0F1E",
	"Reservednop_rm32_r32_0F1E",
	"Reservednop_rm64_r64_0F1E",
	"Reservednop_rm16_r16_0F1F",
	"Reservednop_rm32_r32_0F1F",
	"Reservednop_rm64_r64_0F1F",
	"Prefetchnta_m8",
	"Prefetcht0_m8",
	"Prefetcht1_m8",
	"Prefetcht2_m8",
	"Bndldx_bnd_mib",
	"Bndmov_bnd_bndm64",
	"Bndmov_bnd_bndm128",
	"Bndcl_bnd_rm32",
	"Bndcl_bnd_rm64",
	"Bndcu_bnd_rm32",
	"Bndcu_bnd_rm64",
	"Bndstx_mib_bnd",
	"Bndmov_bndm64_bnd",
	"Bndmov_bndm128_bnd",
	"Bndmk_bnd_m32",
	"Bndmk_bnd_m64",
	"Bndcn_bnd_rm32",
	"Bndcn_bnd_rm64",
	"Cldemote_m8",
	"Rdsspd_r32",
	"Rdsspq_r64",
	"Endbr64",
	"Endbr32",
	"Nop_rm16",
	"Nop_rm32",
	"Nop_rm64",
	"Mov_r32_cr",
	"Mov_r64_cr",
	"Mov_r32_dr",
	"Mov_r64_dr",
	"Mov_cr_r32",
	"Mov_cr_r64",
	"Mov_dr_r32",
	"Mov_dr_r64",
	"Mov_r32_tr",
	"Mov_tr_r32",
	"Movaps_xmm_xmmm128",
	"VEX_Vmovaps_xmm_xmmm128",
	"VEX_Vmovaps_ymm_ymmm256",
	"EVEX_Vmovaps_xmm_k1z_xmmm128",
	"EVEX_Vmovaps_ymm_k1z_ymmm256",
	"EVEX_Vmovaps_zmm_k1z_zmmm512",
	"Movapd_xmm_xmmm128",
	"VEX_Vmovapd_xmm_xmmm128",
	"VEX_Vmovapd_ymm_ymmm256",
	"EVEX_Vmovapd_xmm_k1z_xmmm128",
	"EVEX_Vmovapd_ymm_k1z_ymmm256",
	"EVEX_Vmovapd_zmm_k1z_zmmm512",
	"Movaps_xmmm128_xmm",
	"VEX_Vmovaps_xmmm128_xmm",
	"VEX_Vmovaps_ymmm256_ymm",
	"EVEX_Vmovaps_xmmm128_k1z_xmm",
	"EVEX_Vmovaps_ymmm256_k1z_ymm",
	"EVEX_Vmovaps_zmmm512_k1z_zmm",
	"Movapd_xmmm128_xmm",
	"VEX_Vmovapd_xmmm128_xmm",
	"VEX_Vmovapd_ymmm256_ymm",
	"EVEX_Vmovapd_xmmm128_k1z_xmm",
	"EVEX_Vmovapd_ymmm256_k1z_ymm",
	"EVEX_Vmovapd_zmmm512_k1z_zmm",
	"Cvtpi2ps_xmm_mmm64",
	"Cvtpi2pd_xmm_mmm64",
	"Cvtsi2ss_xmm_rm32",
	"Cvtsi2ss_xmm_rm64",
	"VEX_Vcvtsi2ss_xmm_xmm_rm32",
	"VEX_Vcvtsi2ss_xmm_xmm_rm64",
	"EVEX_Vcvtsi2ss_xmm_xmm_rm32_er",
	"EVEX_Vcvtsi2ss_xmm_xmm_rm64_er",
	"Cvtsi2sd_xmm_rm32",
	"Cvtsi2sd_xmm_rm64",
	"VEX_Vcvtsi2sd_xmm_xmm_rm32",
	"VEX_Vcvtsi2sd_xmm_xmm_rm64",
	"EVEX_Vcvtsi2sd_xmm_xmm_rm32_er",
	"EVEX_Vcvtsi2sd_xmm_xmm_rm64_er",
	"Movntps_m128_xmm",
	"VEX_Vmovntps_m128_xmm",
	"VEX_Vmovntps_m256_ymm",
	"EVEX_Vmovntps_m128_xmm",
	"EVEX_Vmovntps_m256_ymm",
	"EVEX_Vmovntps_m512_zmm",
	"Movntpd_m128_xmm",
	"VEX_Vmovntpd_m128_xmm",
	"VEX_Vmovntpd_m256_ymm",
	"EVEX_Vmovntpd_m128_xmm",
	"EVEX_Vmovntpd_m256_ymm",
	"EVEX_Vmovntpd_m512_zmm",
	"Movntss_m32_xmm",
	"Movntsd_m64_xmm",
	"Cvttps2pi_mm_xmmm64",
	"Cvttpd2pi_mm_xmmm128",
	"Cvttss2si_r32_xmmm32",
	"Cvttss2si_r64_xmmm32",
	"VEX_Vcvttss2si_r32_xmmm32",
	"VEX_Vcvttss2si_r64_xmmm32",
	"EVEX_Vcvttss2si_r32_xmmm32_sae",
	"EVEX_Vcvttss2si_r64_xmmm32_sae",
	"Cvttsd2si_r32_xmmm64",
	"Cvttsd2si_r64_xmmm64",
	"VEX_Vcvttsd2si_r32_xmmm64",
	"VEX_Vcvttsd2si_r64_xmmm64",
	"EVEX_Vcvttsd2si_r32_xmmm64_sae",
	"EVEX_Vcvttsd2si_r64_xmmm64_sae",
	"Cvtps2pi_mm_xmmm64",
	"Cvtpd2pi_mm_xmmm128",
	"Cvtss2si_r32_xmmm32",
	"Cvtss2si_r64_xmmm32",
	"VEX_Vcvtss2si_r32_xmmm32",
	"VEX_Vcvtss2si_r64_xmmm32",
	"EVEX_Vcvtss2si_r32_xmmm32_er",
	"EVEX_Vcvtss2si_r64_xmmm32_er",
	"Cvtsd2si_r32_xmmm64",
	"Cvtsd2si_r64_xmmm64",
	"VEX_Vcvtsd2si_r32_xmmm64",
	"VEX_Vcvtsd2si_r64_xmmm64",
	"EVEX_Vcvtsd2si_r32_xmmm64_er",
	"EVEX_Vcvtsd2si_r64_xmmm64_er",
	"Ucomiss_xmm_xmmm32",
	"VEX_Vucomiss_xmm_xmmm32",
	"EVEX_Vucomiss_xmm_xmmm32_sae",
	"Ucomisd_xmm_xmmm64",
	"VEX_Vucomisd_xmm_xmmm64",
	"EVEX_Vucomisd_xmm_xmmm64_sae",
	"Comiss_xmm_xmmm32",
	"Comisd_xmm_xmmm64",
	"VEX_Vcomiss_xmm_xmmm32",
	"VEX_Vcomisd_xmm_xmmm64",
	"EVEX_Vcomiss_xmm_xmmm32_sae",
	"EVEX_Vcomisd_xmm_xmmm64_sae",
	"Wrmsr",
	"Rdtsc",
	"Rdmsr",
	"Rdpmc",
	"Sysenter",
	"Sysexitd",
	"Sysexitq",
	"Getsecd",
	"Cmovo_r16_rm16",
	"Cmovo_r32_rm32",
	"Cmovo_r64_rm64",
	"Cmovno_r16_rm16",
	"Cmovno_r32_rm32",
	"Cmovno_r64_rm64",
	"Cmovb_r16_rm16",
	"Cmovb_r32_rm32",
	"Cmovb_r64_rm64",
	"Cmovae_r16_rm16",
	"Cmovae_r32_rm32",
	"Cmovae_r64_rm64",
	"Cmove_r16_rm16",
	"Cmove_r32_rm32",
	"Cmove_r64_rm64",
	"Cmovne_r16_rm16",
	"Cmovne_r32_rm32",
	"Cmovne_r64_rm64",
	"Cmovbe_r16_rm16",
	"Cmovbe_r32_rm32",
	"Cmovbe_r64_rm64",
	"Cmova_r16_rm16",
	"Cmova_r32_rm32",
	"Cmova_r64_rm64",
	"Cmovs_r16_rm16",
	"Cmovs_r32_rm32",
	"Cmovs_r64_rm64",
	"Cmovns_r16_rm16",
	"Cmovns_r32_rm32",
	"Cmovns_r64_rm64",
	"Cmovp_r16_rm16",
	"Cmovp_r32_rm32",
	"Cmovp_r64_rm64",
	"Cmovnp_r16_rm16",
	"Cmovnp_r32_rm32",
	"Cmovnp_r64_rm64",
	"Cmovl_r16_rm16",
	"Cmovl_r32_rm32",
	"Cmovl_r64_rm64",
	"Cmovge_r16_rm16",
	"Cmovge_r32_rm32",
	"Cmovge_r64_rm64",
	"Cmovle_r16_rm16",
	"Cmovle_r32_rm32",
	"Cmovle_r64_rm64",
	"Cmovg_r16_rm16",
	"Cmovg_r32_rm32",
	"Cmovg_r64_rm64",
	"VEX_Kandw_kr_kr_kr",
	"VEX_Kandq_kr_kr_kr",
	"VEX_Kandb_kr_kr_kr",
	"VEX_Kandd_kr_kr_kr",
	"VEX_Kandnw_kr_kr_kr",
	"VEX_Kandnq_kr_kr_kr",
	"VEX_Kandnb_kr_kr_kr",
	"VEX_Kandnd_kr_kr_kr",
	"VEX_Knotw_kr_kr",
	"VEX_Knotq_kr_kr",
	"VEX_Knotb_kr_kr",
	"VEX_Knotd_kr_kr",
	"VEX_Korw_kr_kr_kr",
	"VEX_Korq_kr_kr_kr",
	"VEX_Korb_kr_kr_kr",
	"VEX_Kord_kr_kr_kr",
	"VEX_Kxnorw_kr_kr_kr",
	"VEX_Kxnorq_kr_kr_kr",
	"VEX_Kxnorb_kr_kr_kr",
	"VEX_Kxnord_kr_kr_kr",
	"VEX_Kxorw_kr_kr_kr",
	"VEX_Kxorq_kr_kr_kr",
	"VEX_Kxorb_kr_kr_kr",
	"VEX_Kxord_kr_kr_kr",
	"VEX_Kaddw_kr_kr_kr",
	"VEX_Kaddq_kr_kr_kr",
	"VEX_Kaddb_kr_kr_kr",
	"VEX_Kaddd_kr_kr_kr",
	"VEX_Kunpckwd_kr_kr_kr",
	"VEX_Kunpckdq_kr_kr_kr",
	"VEX_Kunpckbw_kr_kr_kr",
	"Movmskps_r32_xmm",
	"Movmskps_r64_xmm",
	"VEX_Vmovmskps_r32_xmm",
	"VEX_Vmovmskps_r64_xmm",
	"VEX_Vmovmskps_r32_ymm",
	"VEX_Vmovmskps_r64_ymm",
	"Movmskpd_r32_xmm",
	"Movmskpd_r64_xmm",
	"VEX_Vmovmskpd_r32_xmm",
	"VEX_Vmovmskpd_r64_xmm",
	"VEX_Vmovmskpd_r32_ymm",
	"VEX_Vmovmskpd_r64_ymm",
	"Sqrtps_xmm_xmmm128",
	"VEX_Vsqrtps_xmm_xmmm128",
	"VEX_Vsqrtps_ymm_ymmm256",
	"EVEX_Vsqrtps_xmm_k1z_xmmm128b32",
	"EVEX_Vsqrtps_ymm_k1z_ymmm256b32",
	"EVEX_Vsqrtps_zmm_k1z_zmmm512b32_er",
	"Sqrtpd_xmm_xmmm128",
	"VEX_Vsqrtpd_xmm_xmmm128",
	"VEX_Vsqrtpd_ymm_ymmm256",
	"EVEX_Vsqrtpd_xmm_k1z_xmmm128b64",
	"EVEX_Vsqrtpd_ymm_k1z_ymmm256b64",
	"EVEX_Vsqrtpd_zmm_k1z_zmmm512b64_er",
	"Sqrtss_xmm_xmmm32",
	"VEX_Vsqrtss_xmm_xmm_xmmm32",
	"EVEX_Vsqrtss_xmm_k1z_xmm_xmmm32_er",
	"Sqrtsd_xmm_xmmm64",
	"VEX_Vsqrtsd_xmm_xmm_xmmm64",
	"EVEX_Vsqrtsd_xmm_k1z_xmm_xmmm64_er",
	"Rsqrtps_xmm_xmmm128",
	"VEX_Vrsqrtps_xmm_xmmm128",
	"VEX_Vrsqrtps_ymm_ymmm256",
	"Rsqrtss_xmm_xmmm32",
	"VEX_Vrsqrtss_xmm_xmm_xmmm32",
	"Rcpps_xmm_xmmm128",
	"VEX_Vrcpps_xmm_xmmm128",
	"VEX_Vrcpps_ymm_ymmm256",
	"Rcpss_xmm_xmmm32",
	"VEX_Vrcpss_xmm_xmm_xmmm32",
	"Andps_xmm_xmmm128",
	"VEX_Vandps_xmm_xmm_xmmm128",
	"VEX_Vandps_ymm_ymm_ymmm256",
	"EVEX_Vandps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vandps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vandps_zmm_k1z_zmm_zmmm512b32",
	"Andpd_xmm_xmmm128",
	"VEX_Vandpd_xmm_xmm_xmmm128",
	"VEX_Vandpd_ymm_ymm_ymmm256",
	"EVEX_Vandpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vandpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vandpd_zmm_k1z_zmm_zmmm512b64",
	"Andnps_xmm_xmmm128",
	"VEX_Vandnps_xmm_xmm_xmmm128",
	"VEX_Vandnps_ymm_ymm_ymmm256",
	"EVEX_Vandnps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vandnps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vandnps_zmm_k1z_zmm_zmmm512b32",
	"Andnpd_xmm_xmmm128",
	"VEX_Vandnpd_xmm_xmm_xmmm128",
	"VEX_Vandnpd_ymm_ymm_ymmm256",
	"EVEX_Vandnpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vandnpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vandnpd_zmm_k1z_zmm_zmmm512b64",
	"Orps_xmm_xmmm128",
	"VEX_Vorps_xmm_xmm_xmmm128",
	"VEX_Vorps_ymm_ymm_ymmm256",
	"EVEX_Vorps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vorps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vorps_zmm_k1z_zmm_zmmm512b32",
	"Orpd_xmm_xmmm128",
	"VEX_Vorpd_xmm_xmm_xmmm128",
	"VEX_Vorpd_ymm_ymm_ymmm256",
	"EVEX_Vorpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vorpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vorpd_zmm_k1z_zmm_zmmm512b64",
	"Xorps_xmm_xmmm128",
	"VEX_Vxorps_xmm_xmm_xmmm128",
	"VEX_Vxorps_ymm_ymm_ymmm256",
	"EVEX_Vxorps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vxorps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vxorps_zmm_k1z_zmm_zmmm512b32",
	"Xorpd_xmm_xmmm128",
	"VEX_Vxorpd_xmm_xmm_xmmm128",
	"VEX_Vxorpd_ymm_ymm_ymmm256",
	"EVEX_Vxorpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vxorpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vxorpd_zmm_k1z_zmm_zmmm512b64",
	"Addps_xmm_xmmm128",
	"VEX_Vaddps_xmm_xmm_xmmm128",
	"VEX_Vaddps_ymm_ymm_ymmm256",
	"EVEX_Vaddps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vaddps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vaddps_zmm_k1z_zmm_zmmm512b32_er",
	"Addpd_xmm_xmmm128",
	"VEX_Vaddpd_xmm_xmm_xmmm128",
	"VEX_Vaddpd_ymm_ymm_ymmm256",
	"EVEX_Vaddpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vaddpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vaddpd_zmm_k1z_zmm_zmmm512b64_er",
	"Addss_xmm_xmmm32",
	"VEX_Vaddss_xmm_xmm_xmmm32",
	"EVEX_Vaddss_xmm_k1z_xmm_xmmm32_er",
	"Addsd_xmm_xmmm64",
	"VEX_Vaddsd_xmm_xmm_xmmm64",
	"EVEX_Vaddsd_xmm_k1z_xmm_xmmm64_er",
	"Mulps_xmm_xmmm128",
	"VEX_Vmulps_xmm_xmm_xmmm128",
	"VEX_Vmulps_ymm_ymm_ymmm256",
	"EVEX_Vmulps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vmulps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vmulps_zmm_k1z_zmm_zmmm512b32_er",
	"Mulpd_xmm_xmmm128",
	"VEX_Vmulpd_xmm_xmm_xmmm128",
	"VEX_Vmulpd_ymm_ymm_ymmm256",
	"EVEX_Vmulpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vmulpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vmulpd_zmm_k1z_zmm_zmmm512b64_er",
	"Mulss_xmm_xmmm32",
	"VEX_Vmulss_xmm_xmm_xmmm32",
	"EVEX_Vmulss_xmm_k1z_xmm_xmmm32_er",
	"Mulsd_xmm_xmmm64",
	"VEX_Vmulsd_xmm_xmm_xmmm64",
	"EVEX_Vmulsd_xmm_k1z_xmm_xmmm64_er",
	"Cvtps2pd_xmm_xmmm64",
	"VEX_Vcvtps2pd_xmm_xmmm64",
	"VEX_Vcvtps2pd_ymm_xmmm128",
	"EVEX_Vcvtps2pd_xmm_k1z_xmmm64b32",
	"EVEX_Vcvtps2pd_ymm_k1z_xmmm128b32",
	"EVEX_Vcvtps2pd_zmm_k1z_ymmm256b32_sae",
	"Cvtpd2ps_xmm_xmmm128",
	"VEX_Vcvtpd2ps_xmm_xmmm128",
	"VEX_Vcvtpd2ps_xmm_ymmm256",
	"EVEX_Vcvtpd2ps_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtpd2ps_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtpd2ps_ymm_k1z_zmmm512b64_er",
	"Cvtss2sd_xmm_xmmm32",
	"VEX_Vcvtss2sd_xmm_xmm_xmmm32",
	"EVEX_Vcvtss2sd_xmm_k1z_xmm_xmmm32_sae",
	"Cvtsd2ss_xmm_xmmm64",
	"VEX_Vcvtsd2ss_xmm_xmm_xmmm64",
	"EVEX_Vcvtsd2ss_xmm_k1z_xmm_xmmm64_er",
	"Cvtdq2ps_xmm_xmmm128",
	"VEX_Vcvtdq2ps_xmm_xmmm128",
	"VEX_Vcvtdq2ps_ymm_ymmm256",
	"EVEX_Vcvtdq2ps_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtdq2ps_ymm_k1z_ymmm256b32",
	"EVEX_Vcvtdq2ps_zmm_k1z_zmmm512b32_er",
	"EVEX_Vcvtqq2ps_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtqq2ps_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtqq2ps_ymm_k1z_zmmm512b64_er",
	"Cvtps2dq_xmm_xmmm128",
	"VEX_Vcvtps2dq_xmm_xmmm128",
	"VEX_Vcvtps2dq_ymm_ymmm256",
	"EVEX_Vcvtps2dq_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtps2dq_ymm_k1z_ymmm256b32",
	"EVEX_Vcvtps2dq_zmm_k1z_zmmm512b32_er",
	"Cvttps2dq_xmm_xmmm128",
	"VEX_Vcvttps2dq_xmm_xmmm128",
	"VEX_Vcvttps2dq_ymm_ymmm256",
	"EVEX_Vcvttps2dq_xmm_k1z_xmmm128b32",
	"EVEX_Vcvttps2dq_ymm_k1z_ymmm256b32",
	"EVEX_Vcvttps2dq_zmm_k1z_zmmm512b32_sae",
	"Subps_xmm_xmmm128",
	"VEX_Vsubps_xmm_xmm_xmmm128",
	"VEX_Vsubps_ymm_ymm_ymmm256",
	"EVEX_Vsubps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vsubps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vsubps_zmm_k1z_zmm_zmmm512b32_er",
	"Subpd_xmm_xmmm128",
	"VEX_Vsubpd_xmm_xmm_xmmm128",
	"VEX_Vsubpd_ymm_ymm_ymmm256",
	"EVEX_Vsubpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vsubpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vsubpd_zmm_k1z_zmm_zmmm512b64_er",
	"Subss_xmm_xmmm32",
	"VEX_Vsubss_xmm_xmm_xmmm32",
	"EVEX_Vsubss_xmm_k1z_xmm_xmmm32_er",
	"Subsd_xmm_xmmm64",
	"VEX_Vsubsd_xmm_xmm_xmmm64",
	"EVEX_Vsubsd_xmm_k1z_xmm_xmmm64_er",
	"Minps_xmm_xmmm128",
	"VEX_Vminps_xmm_xmm_xmmm128",
	"VEX_Vminps_ymm_ymm_ymmm256",
	"EVEX_Vminps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vminps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vminps_zmm_k1z_zmm_zmmm512b32_sae",
	"Minpd_xmm_xmmm128",
	"VEX_Vminpd_xmm_xmm_xmmm128",
	"VEX_Vminpd_ymm_ymm_ymmm256",
	"EVEX_Vminpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vminpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vminpd_zmm_k1z_zmm_zmmm512b64_sae",
	"Minss_xmm_xmmm32",
	"VEX_Vminss_xmm_xmm_xmmm32",
	"EVEX_Vminss_xmm_k1z_xmm_xmmm32_sae",
	"Minsd_xmm_xmmm64",
	"VEX_Vminsd_xmm_xmm_xmmm64",
	"EVEX_Vminsd_xmm_k1z_xmm_xmmm64_sae",
	"Divps_xmm_xmmm128",
	"VEX_Vdivps_xmm_xmm_xmmm128",
	"VEX_Vdivps_ymm_ymm_ymmm256",
	"EVEX_Vdivps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vdivps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vdivps_zmm_k1z_zmm_zmmm512b32_er",
	"Divpd_xmm_xmmm128",
	"VEX_Vdivpd_xmm_xmm_xmmm128",
	"VEX_Vdivpd_ymm_ymm_ymmm256",
	"EVEX_Vdivpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vdivpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vdivpd_zmm_k1z_zmm_zmmm512b64_er",
	"Divss_xmm_xmmm32",
	"VEX_Vdivss_xmm_xmm_xmmm32",
	"EVEX_Vdivss_xmm_k1z_xmm_xmmm32_er",
	"Divsd_xmm_xmmm64",
	"VEX_Vdivsd_xmm_xmm_xmmm64",
	"EVEX_Vdivsd_xmm_k1z_xmm_xmmm64_er",
	"Maxps_xmm_xmmm128",
	"VEX_Vmaxps_xmm_xmm_xmmm128",
	"VEX_Vmaxps_ymm_ymm_ymmm256",
	"EVEX_Vmaxps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vmaxps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vmaxps_zmm_k1z_zmm_zmmm512b32_sae",
	"Maxpd_xmm_xmmm128",
	"VEX_Vmaxpd_xmm_xmm_xmmm128",
	"VEX_Vmaxpd_ymm_ymm_ymmm256",
	"EVEX_Vmaxpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vmaxpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vmaxpd_zmm_k1z_zmm_zmmm512b64_sae",
	"Maxss_xmm_xmmm32",
	"VEX_Vmaxss_xmm_xmm_xmmm32",
	"EVEX_Vmaxss_xmm_k1z_xmm_xmmm32_sae",
	"Maxsd_xmm_xmmm64",
	"VEX_Vmaxsd_xmm_xmm_xmmm64",
	"EVEX_Vmaxsd_xmm_k1z_xmm_xmmm64_sae",
	"Punpcklbw_mm_mmm32",
	"Punpcklbw_xmm_xmmm128",
	"VEX_Vpunpcklbw_xmm_xmm_xmmm128",
	"VEX_Vpunpcklbw_ymm_ymm_ymmm256",
	"EVEX_Vpunpcklbw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpunpcklbw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpunpcklbw_zmm_k1z_zmm_zmmm512",
	"Punpcklwd_mm_mmm32",
	"Punpcklwd_xmm_xmmm128",
	"VEX_Vpunpcklwd_xmm_xmm_xmmm128",
	"VEX_Vpunpcklwd_ymm_ymm_ymmm256",
	"EVEX_Vpunpcklwd_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpunpcklwd_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpunpcklwd_zmm_k1z_zmm_zmmm512",
	"Punpckldq_mm_mmm32",
	"Punpckldq_xmm_xmmm128",
	"VEX_Vpunpckldq_xmm_xmm_xmmm128",
	"VEX_Vpunpckldq_ymm_ymm_ymmm256",
	"EVEX_Vpunpckldq_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpunpckldq_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpunpckldq_zmm_k1z_zmm_zmmm512b32",
	"Packsswb_mm_mmm64",
	"Packsswb_xmm_xmmm128",
	"VEX_Vpacksswb_xmm_xmm_xmmm128",
	"VEX_Vpacksswb_ymm_ymm_ymmm256",
	"EVEX_Vpacksswb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpacksswb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpacksswb_zmm_k1z_zmm_zmmm512",
	"Pcmpgtb_mm_mmm64",
	"Pcmpgtb_xmm_xmmm128",
	"VEX_Vpcmpgtb_xmm_xmm_xmmm128",
	"VEX_Vpcmpgtb_ymm_ymm_ymmm256",
	"EVEX_Vpcmpgtb_kr_k1_xmm_xmmm128",
	"EVEX_Vpcmpgtb_kr_k1_ymm_ymmm256",
	"EVEX_Vpcmpgtb_kr_k1_zmm_zmmm512",
	"Pcmpgtw_mm_mmm64",
	"Pcmpgtw_xmm_xmmm128",
	"VEX_Vpcmpgtw_xmm_xmm_xmmm128",
	"VEX_Vpcmpgtw_ymm_ymm_ymmm256",
	"EVEX_Vpcmpgtw_kr_k1_xmm_xmmm128",
	"EVEX_Vpcmpgtw_kr_k1_ymm_ymmm256",
	"EVEX_Vpcmpgtw_kr_k1_zmm_zmmm512",
	"Pcmpgtd_mm_mmm64",
	"Pcmpgtd_xmm_xmmm128",
	"VEX_Vpcmpgtd_xmm_xmm_xmmm128",
	"VEX_Vpcmpgtd_ymm_ymm_ymmm256",
	"EVEX_Vpcmpgtd_kr_k1_xmm_xmmm128b32",
	"EVEX_Vpcmpgtd_kr_k1_ymm_ymmm256b32",
	"EVEX_Vpcmpgtd_kr_k1_zmm_zmmm512b32",
	"Packuswb_mm_mmm64",
	"Packuswb_xmm_xmmm128",
	"VEX_Vpackuswb_xmm_xmm_xmmm128",
	"VEX_Vpackuswb_ymm_ymm_ymmm256",
	"EVEX_Vpackuswb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpackuswb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpackuswb_zmm_k1z_zmm_zmmm512",
	"Punpckhbw_mm_mmm64",
	"Punpckhbw_xmm_xmmm128",
	"VEX_Vpunpckhbw_xmm_xmm_xmmm128",
	"VEX_Vpunpckhbw_ymm_ymm_ymmm256",
	"EVEX_Vpunpckhbw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpunpckhbw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpunpckhbw_zmm_k1z_zmm_zmmm512",
	"Punpckhwd_mm_mmm64",
	"Punpckhwd_xmm_xmmm128",
	"VEX_Vpunpckhwd_xmm_xmm_xmmm128",
	"VEX_Vpunpckhwd_ymm_ymm_ymmm256",
	"EVEX_Vpunpckhwd_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpunpckhwd_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpunpckhwd_zmm_k1z_zmm_zmmm512",
	"Punpckhdq_mm_mmm64",
	"Punpckhdq_xmm_xmmm128",
	"VEX_Vpunpckhdq_xmm_xmm_xmmm128",
	"VEX_Vpunpckhdq_ymm_ymm_ymmm256",
	"EVEX_Vpunpckhdq_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpunpckhdq_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpunpckhdq_zmm_k1z_zmm_zmmm512b32",
	"Packssdw_mm_mmm64",
	"Packssdw_xmm_xmmm128",
	"VEX_Vpackssdw_xmm_xmm_xmmm128",
	"VEX_Vpackssdw_ymm_ymm_ymmm256",
	"EVEX_Vpackssdw_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpackssdw_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpackssdw_zmm_k1z_zmm_zmmm512b32",
	"Punpcklqdq_xmm_xmmm128",
	"VEX_Vpunpcklqdq_xmm_xmm_xmmm128",
	"VEX_Vpunpcklqdq_ymm_ymm_ymmm256",
	"EVEX_Vpunpcklqdq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpunpcklqdq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpunpcklqdq_zmm_k1z_zmm_zmmm512b64",
	"Punpckhqdq_xmm_xmmm128",
	"VEX_Vpunpckhqdq_xmm_xmm_xmmm128",
	"VEX_Vpunpckhqdq_ymm_ymm_ymmm256",
	"EVEX_Vpunpckhqdq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpunpckhqdq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpunpckhqdq_zmm_k1z_zmm_zmmm512b64",
	"Movd_mm_rm32",
	"Movq_mm_rm64",
	"Movd_xmm_rm32",
	"Movq_xmm_rm64",
	"VEX_Vmovd_xmm_rm32",
	"VEX_Vmovq_xmm_rm64",
	"EVEX_Vmovd_xmm_rm32",
	"EVEX_Vmovq_xmm_rm64",
	"Movq_mm_mmm64",
	"Movdqa_xmm_xmmm128",
	"VEX_Vmovdqa_xmm_xmmm128",
	"VEX_Vmovdqa_ymm_ymmm256",
	"EVEX_Vmovdqa32_xmm_k1z_xmmm128",
	"EVEX_Vmovdqa32_ymm_k1z_ymmm256",
	"EVEX_Vmovdqa32_zmm_k1z_zmmm512",
	"EVEX_Vmovdqa64_xmm_k1z_xmmm128",
	"EVEX_Vmovdqa64_ymm_k1z_ymmm256",
	"EVEX_Vmovdqa64_zmm_k1z_zmmm512",
	"Movdqu_xmm_xmmm128",
	"VEX_Vmovdqu_xmm_xmmm128",
	"VEX_Vmovdqu_ymm_ymmm256",
	"EVEX_Vmovdqu32_xmm_k1z_xmmm128",
	"EVEX_Vmovdqu32_ymm_k1z_ymmm256",
	"EVEX_Vmovdqu32_zmm_k1z_zmmm512",
	"EVEX_Vmovdqu64_xmm_k1z_xmmm128",
	"EVEX_Vmovdqu64_ymm_k1z_ymmm256",
	"EVEX_Vmovdqu64_zmm_k1z_zmmm512",
	"EVEX_Vmovdqu8_xmm_k1z_xmmm128",
	"EVEX_Vmovdqu8_ymm_k1z_ymmm256",
	"EVEX_Vmovdqu8_zmm_k1z_zmmm512",
	"EVEX_Vmovdqu16_xmm_k1z_xmmm128",
	"EVEX_Vmovdqu16_ymm_k1z_ymmm256",
	"EVEX_Vmovdqu16_zmm_k1z_zmmm512",
	"Pshufw_mm_mmm64_imm8",
	"Pshufd_xmm_xmmm128_imm8",
	"VEX_Vpshufd_xmm_xmmm128_imm8",
	"VEX_Vpshufd_ymm_ymmm256_imm8",
	"EVEX_Vpshufd_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vpshufd_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vpshufd_zmm_k1z_zmmm512b32_imm8",
	"Pshufhw_xmm_xmmm128_imm8",
	"VEX_Vpshufhw_xmm_xmmm128_imm8",
	"VEX_Vpshufhw_ymm_ymmm256_imm8",
	"EVEX_Vpshufhw_xmm_k1z_xmmm128_imm8",
	"EVEX_Vpshufhw_ymm_k1z_ymmm256_imm8",
	"EVEX_Vpshufhw_zmm_k1z_zmmm512_imm8",
	"Pshuflw_xmm_xmmm128_imm8",
	"VEX_Vpshuflw_xmm_xmmm128_imm8",
	"VEX_Vpshuflw_ymm_ymmm256_imm8",
	"EVEX_Vpshuflw_xmm_k1z_xmmm128_imm8",
	"EVEX_Vpshuflw_ymm_k1z_ymmm256_imm8",
	"EVEX_Vpshuflw_zmm_k1z_zmmm512_imm8",
	"Psrlw_mm_imm8",
	"Psrlw_xmm_imm8",
	"VEX_Vpsrlw_xmm_xmm_imm8",
	"VEX_Vpsrlw_ymm_ymm_imm8",
	"EVEX_Vpsrlw_xmm_k1z_xmmm128_imm8",
	"EVEX_Vpsrlw_ymm_k1z_ymmm256_imm8",
	"EVEX_Vpsrlw_zmm_k1z_zmmm512_imm8",
	"Psraw_mm_imm8",
	"Psraw_xmm_imm8",
	"VEX_Vpsraw_xmm_xmm_imm8",
	"VEX_Vpsraw_ymm_ymm_imm8",
	"EVEX_Vpsraw_xmm_k1z_xmmm128_imm8",
	"EVEX_Vpsraw_ymm_k1z_ymmm256_imm8",
	"EVEX_Vpsraw_zmm_k1z_zmmm512_imm8",
	"Psllw_mm_imm8",
	"Psllw_xmm_imm8",
	"VEX_Vpsllw_xmm_xmm_imm8",
	"VEX_Vpsllw_ymm_ymm_imm8",
	"EVEX_Vpsllw_xmm_k1z_xmmm128_imm8",
	"EVEX_Vpsllw_ymm_k1z_ymmm256_imm8",
	"EVEX_Vpsllw_zmm_k1z_zmmm512_imm8",
	"EVEX_Vprord_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vprord_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vprord_zmm_k1z_zmmm512b32_imm8",
	"EVEX_Vprorq_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vprorq_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vprorq_zmm_k1z_zmmm512b64_imm8",
	"EVEX_Vprold_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vprold_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vprold_zmm_k1z_zmmm512b32_imm8",
	"EVEX_Vprolq_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vprolq_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vprolq_zmm_k1z_zmmm512b64_imm8",
	"Psrld_mm_imm8",
	"Psrld_xmm_imm8",
	"VEX_Vpsrld_xmm_xmm_imm8",
	"VEX_Vpsrld_ymm_ymm_imm8",
	"EVEX_Vpsrld_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vpsrld_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vpsrld_zmm_k1z_zmmm512b32_imm8",
	"Psrad_mm_imm8",
	"Psrad_xmm_imm8",
	"VEX_Vpsrad_xmm_xmm_imm8",
	"VEX_Vpsrad_ymm_ymm_imm8",
	"EVEX_Vpsrad_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vpsrad_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vpsrad_zmm_k1z_zmmm512b32_imm8",
	"EVEX_Vpsraq_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vpsraq_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vpsraq_zmm_k1z_zmmm512b64_imm8",
	"Pslld_mm_imm8",
	"Pslld_xmm_imm8",
	"VEX_Vpslld_xmm_xmm_imm8",
	"VEX_Vpslld_ymm_ymm_imm8",
	"EVEX_Vpslld_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vpslld_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vpslld_zmm_k1z_zmmm512b32_imm8",
	"Psrlq_mm_imm8",
	"Psrlq_xmm_imm8",
	"VEX_Vpsrlq_xmm_xmm_imm8",
	"VEX_Vpsrlq_ymm_ymm_imm8",
	"EVEX_Vpsrlq_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vpsrlq_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vpsrlq_zmm_k1z_zmmm512b64_imm8",
	"Psrldq_xmm_imm8",
	"VEX_Vpsrldq_xmm_xmm_imm8",
	"VEX_Vpsrldq_ymm_ymm_imm8",
	"EVEX_Vpsrldq_xmm_xmmm128_imm8",
	"EVEX_Vpsrldq_ymm_ymmm256_imm8",
	"EVEX_Vpsrldq_zmm_zmmm512_imm8",
	"Psllq_mm_imm8",
	"Psllq_xmm_imm8",
	"VEX_Vpsllq_xmm_xmm_imm8",
	"VEX_Vpsllq_ymm_ymm_imm8",
	"EVEX_Vpsllq_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vpsllq_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vpsllq_zmm_k1z_zmmm512b64_imm8",
	"Pslldq_xmm_imm8",
	"VEX_Vpslldq_xmm_xmm_imm8",
	"VEX_Vpslldq_ymm_ymm_imm8",
	"EVEX_Vpslldq_xmm_xmmm128_imm8",
	"EVEX_Vpslldq_ymm_ymmm256_imm8",
	"EVEX_Vpslldq_zmm_zmmm512_imm8",
	"Pcmpeqb_mm_mmm64",
	"Pcmpeqb_xmm_xmmm128",
	"VEX_Vpcmpeqb_xmm_xmm_xmmm128",
	"VEX_Vpcmpeqb_ymm_ymm_ymmm256",
	"EVEX_Vpcmpeqb_kr_k1_xmm_xmmm128",
	"EVEX_Vpcmpeqb_kr_k1_ymm_ymmm256",
	"EVEX_Vpcmpeqb_kr_k1_zmm_zmmm512",
	"Pcmpeqw_mm_mmm64",
	"Pcmpeqw_xmm_xmmm128",
	"VEX_Vpcmpeqw_xmm_xmm_xmmm128",
	"VEX_Vpcmpeqw_ymm_ymm_ymmm256",
	"EVEX_Vpcmpeqw_kr_k1_xmm_xmmm128",
	"EVEX_Vpcmpeqw_kr_k1_ymm_ymmm256",
	"EVEX_Vpcmpeqw_kr_k1_zmm_zmmm512",
	"Pcmpeqd_mm_mmm64",
	"Pcmpeqd_xmm_xmmm128",
	"VEX_Vpcmpeqd_xmm_xmm_xmmm128",
	"VEX_Vpcmpeqd_ymm_ymm_ymmm256",
	"EVEX_Vpcmpeqd_kr_k1_xmm_xmmm128b32",
	"EVEX_Vpcmpeqd_kr_k1_ymm_ymmm256b32",
	"EVEX_Vpcmpeqd_kr_k1_zmm_zmmm512b32",
	"Emms",
	"VEX_Vzeroupper",
	"VEX_Vzeroall",
	"Vmread_rm32_r32",
	"Vmread_rm64_r64",
	"EVEX_Vcvttps2udq_xmm_k1z_xmmm128b32",
	"EVEX_Vcvttps2udq_ymm_k1z_ymmm256b32",
	"EVEX_Vcvttps2udq_zmm_k1z_zmmm512b32_sae",
	"EVEX_Vcvttpd2udq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvttpd2udq_xmm_k1z_ymmm256b64",
	"EVEX_Vcvttpd2udq_ymm_k1z_zmmm512b64_sae",
	"Extrq_xmm_imm8_imm8",
	"EVEX_Vcvttps2uqq_xmm_k1z_xmmm64b32",
	"EVEX_Vcvttps2uqq_ymm_k1z_xmmm128b32",
	"EVEX_Vcvttps2uqq_zmm_k1z_ymmm256b32_sae",
	"EVEX_Vcvttpd2uqq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvttpd2uqq_ymm_k1z_ymmm256b64",
	"EVEX_Vcvttpd2uqq_zmm_k1z_zmmm512b64_sae",
	"EVEX_Vcvttss2usi_r32_xmmm32_sae",
	"EVEX_Vcvttss2usi_r64_xmmm32_sae",
	"Insertq_xmm_xmm_imm8_imm8",
	"EVEX_Vcvttsd2usi_r32_xmmm64_sae",
	"EVEX_Vcvttsd2usi_r64_xmmm64_sae",
	"Vmwrite_r32_rm32",
	"Vmwrite_r64_rm64",
	"EVEX_Vcvtps2udq_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtps2udq_ymm_k1z_ymmm256b32",
	"EVEX_Vcvtps2udq_zmm_k1z_zmmm512b32_er",
	"EVEX_Vcvtpd2udq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtpd2udq_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtpd2udq_ymm_k1z_zmmm512b64_er",
	"Extrq_xmm_xmm",
	"EVEX_Vcvtps2uqq_xmm_k1z_xmmm64b32",
	"EVEX_Vcvtps2uqq_ymm_k1z_xmmm128b32",
	"EVEX_Vcvtps2uqq_zmm_k1z_ymmm256b32_er",
	"EVEX_Vcvtpd2uqq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtpd2uqq_ymm_k1z_ymmm256b64",
	"EVEX_Vcvtpd2uqq_zmm_k1z_zmmm512b64_er",
	"EVEX_Vcvtss2usi_r32_xmmm32_er",
	"EVEX_Vcvtss2usi_r64_xmmm32_er",
	"Insertq_xmm_xmm",
	"EVEX_Vcvtsd2usi_r32_xmmm64_er",
	"EVEX_Vcvtsd2usi_r64_xmmm64_er",
	"EVEX_Vcvttps2qq_xmm_k1z_xmmm64b32",
	"EVEX_Vcvttps2qq_ymm_k1z_xmmm128b32",
	"EVEX_Vcvttps2qq_zmm_k1z_ymmm256b32_sae",
	"EVEX_Vcvttpd2qq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvttpd2qq_ymm_k1z_ymmm256b64",
	"EVEX_Vcvttpd2qq_zmm_k1z_zmmm512b64_sae",
	"EVEX_Vcvtudq2pd_xmm_k1z_xmmm64b32",
	"EVEX_Vcvtudq2pd_ymm_k1z_xmmm128b32",
	"EVEX_Vcvtudq2pd_zmm_k1z_ymmm256b32_er",
	"EVEX_Vcvtuqq2pd_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtuqq2pd_ymm_k1z_ymmm256b64",
	"EVEX_Vcvtuqq2pd_zmm_k1z_zmmm512b64_er",
	"EVEX_Vcvtudq2ps_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtudq2ps_ymm_k1z_ymmm256b32",
	"EVEX_Vcvtudq2ps_zmm_k1z_zmmm512b32_er",
	"EVEX_Vcvtuqq2ps_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtuqq2ps_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtuqq2ps_ymm_k1z_zmmm512b64_er",
	"EVEX_Vcvtps2qq_xmm_k1z_xmmm64b32",
	"EVEX_Vcvtps2qq_ymm_k1z_xmmm128b32",
	"EVEX_Vcvtps2qq_zmm_k1z_ymmm256b32_er",
	"EVEX_Vcvtpd2qq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtpd2qq_ymm_k1z_ymmm256b64",
	"EVEX_Vcvtpd2qq_zmm_k1z_zmmm512b64_er",
	"EVEX_Vcvtusi2ss_xmm_xmm_rm32_er",
	"EVEX_Vcvtusi2ss_xmm_xmm_rm64_er",
	"EVEX_Vcvtusi2sd_xmm_xmm_rm32_er",
	"EVEX_Vcvtusi2sd_xmm_xmm_rm64_er",
	"Haddpd_xmm_xmmm128",
	"VEX_Vhaddpd_xmm_xmm_xmmm128",
	"VEX_Vhaddpd_ymm_ymm_ymmm256",
	"Haddps_xmm_xmmm128",
	"VEX_Vhaddps_xmm_xmm_xmmm128",
	"VEX_Vhaddps_ymm_ymm_ymmm256",
	"Hsubpd_xmm_xmmm128",
	"VEX_Vhsubpd_xmm_xmm_xmmm128",
	"VEX_Vhsubpd_ymm_ymm_ymmm256",
	"Hsubps_xmm_xmmm128",
	"VEX_Vhsubps_xmm_xmm_xmmm128",
	"VEX_Vhsubps_ymm_ymm_ymmm256",
	"Movd_rm32_mm",
	"Movq_rm64_mm",
	"Movd_rm32_xmm",
	"Movq_rm64_xmm",
	"VEX_Vmovd_rm32_xmm",
	"VEX_Vmovq_rm64_xmm",
	"EVEX_Vmovd_rm32_xmm",
	"EVEX_Vmovq_rm64_xmm",
	"Movq_xmm_xmmm64",
	"VEX_Vmovq_xmm_xmmm64",
	"EVEX_Vmovq_xmm_xmmm64",
	"Movq_mmm64_mm",
	"Movdqa_xmmm128_xmm",
	"VEX_Vmovdqa_xmmm128_xmm",
	"VEX_Vmovdqa_ymmm256_ymm",
	"EVEX_Vmovdqa32_xmmm128_k1z_xmm",
	"EVEX_Vmovdqa32_ymmm256_k1z_ymm",
	"EVEX_Vmovdqa32_zmmm512_k1z_zmm",
	"EVEX_Vmovdqa64_xmmm128_k1z_xmm",
	"EVEX_Vmovdqa64_ymmm256_k1z_ymm",
	"EVEX_Vmovdqa64_zmmm512_k1z_zmm",
	"Movdqu_xmmm128_xmm",
	"VEX_Vmovdqu_xmmm128_xmm",
	"VEX_Vmovdqu_ymmm256_ymm",
	"EVEX_Vmovdqu32_xmmm128_k1z_xmm",
	"EVEX_Vmovdqu32_ymmm256_k1z_ymm",
	"EVEX_Vmovdqu32_zmmm512_k1z_zmm",
	"EVEX_Vmovdqu64_xmmm128_k1z_xmm",
	"EVEX_Vmovdqu64_ymmm256_k1z_ymm",
	"EVEX_Vmovdqu64_zmmm512_k1z_zmm",
	"EVEX_Vmovdqu8_xmmm128_k1z_xmm",
	"EVEX_Vmovdqu8_ymmm256_k1z_ymm",
	"EVEX_Vmovdqu8_zmmm512_k1z_zmm",
	"EVEX_Vmovdqu16_xmmm128_k1z_xmm",
	"EVEX_Vmovdqu16_ymmm256_k1z_ymm",
	"EVEX_Vmovdqu16_zmmm512_k1z_zmm",
	"Jo_rel16",
	"Jo_rel32_32",
	"Jo_rel32_64",
	"Jno_rel16",
	"Jno_rel32_32",
	"Jno_rel32_64",
	"Jb_rel16",
	"Jb_rel32_32",
	"Jb_rel32_64",
	"Jae_rel16",
	"Jae_rel32_32",
	"Jae_rel32_64",
	"Je_rel16",
	"Je_rel32_32",
	"Je_rel32_64",
	"Jne_rel16",
	"Jne_rel32_32",
	"Jne_rel32_64",
	"Jbe_rel16",
	"Jbe_rel32_32",
	"Jbe_rel32_64",
	"Ja_rel16",
	"Ja_rel32_32",
	"Ja_rel32_64",
	"Js_rel16",
	"Js_rel32_32",
	"Js_rel32_64",
	"Jns_rel16",
	"Jns_rel32_32",
	"Jns_rel32_64",
	"Jp_rel16",
	"Jp_rel32_32",
	"Jp_rel32_64",
	"Jnp_rel16",
	"Jnp_rel32_32",
	"Jnp_rel32_64",
	"Jl_rel16",
	"Jl_rel32_32",
	"Jl_rel32_64",
	"Jge_rel16",
	"Jge_rel32_32",
	"Jge_rel32_64",
	"Jle_rel16",
	"Jle_rel32_32",
	"Jle_rel32_64",
	"Jg_rel16",
	"Jg_rel32_32",
	"Jg_rel32_64",
	"Seto_rm8",
	"Setno_rm8",
	"Setb_rm8",
	"Setae_rm8",
	"Sete_rm8",
	"Setne_rm8",
	"Setbe_rm8",
	"Seta_rm8",
	"Sets_rm8",
	"Setns_rm8",
	"Setp_rm8",
	"Setnp_rm8",
	"Setl_rm8",
	"Setge_rm8",
	"Setle_rm8",
	"Setg_rm8",
	"VEX_Kmovw_kr_km16",
	"VEX_Kmovq_kr_km64",
	"VEX_Kmovb_kr_km8",
	"VEX_Kmovd_kr_km32",
	"VEX_Kmovw_m16_kr",
	"VEX_Kmovq_m64_kr",
	"VEX_Kmovb_m8_kr",
	"VEX_Kmovd_m32_kr",
	"VEX_Kmovw_kr_r32",
	"VEX_Kmovb_kr_r32",
	"VEX_Kmovd_kr_r32",
	"VEX_Kmovq_kr_r64",
	"VEX_Kmovw_r32_kr",
	"VEX_Kmovb_r32_kr",
	"VEX_Kmovd_r32_kr",
	"VEX_Kmovq_r64_kr",
	"VEX_Kortestw_kr_kr",
	"VEX_Kortestq_kr_kr",
	"VEX_Kortestb_kr_kr",
	"VEX_Kortestd_kr_kr",
	"VEX_Ktestw_kr_kr",
	"VEX_Ktestq_kr_kr",
	"VEX_Ktestb_kr_kr",
	"VEX_Ktestd_kr_kr",
	"Pushw_FS",
	"Pushd_FS",
	"Pushq_FS",
	"Popw_FS",
	"Popd_FS",
	"Popq_FS",
	"Cpuid",
	"Bt_rm16_r16",
	"Bt_rm32_r32",
	"Bt_rm64_r64",
	"Shld_rm16_r16_imm8",
	"Shld_rm32_r32_imm8",
	"Shld_rm64_r64_imm8",
	"Shld_rm16_r16_CL",
	"Shld_rm32_r32_CL",
	"Shld_rm64_r64_CL",
	"Montmul_16",
	"Montmul_32",
	"Montmul_64",
	"Xsha1_16",
	"Xsha1_32",
	"Xsha1_64",
	"Xsha256_16",
	"Xsha256_32",
	"Xsha256_64",
	"Xbts_r16_rm16",
	"Xbts_r32_rm32",
	"Xstore_16",
	"Xstore_32",
	"Xstore_64",
	"Xcryptecb_16",
	"Xcryptecb_32",
	"Xcryptecb_64",
	"Xcryptcbc_16",
	"Xcryptcbc_32",
	"Xcryptcbc_64",
	"Xcryptctr_16",
	"Xcryptctr_32",
	"Xcryptctr_64",
	"Xcryptcfb_16",
	"Xcryptcfb_32",
	"Xcryptcfb_64",
	"Xcryptofb_16",
	"Xcryptofb_32",
	"Xcryptofb_64",
	"Ibts_rm16_r16",
	"Ibts_rm32_r32",
	"Cmpxchg486_rm8_r8",
	"Cmpxchg486_rm16_r16",
	"Cmpxchg486_rm32_r32",
	"Pushw_GS",
	"Pushd_GS",
	"Pushq_GS",
	"Popw_GS",
	"Popd_GS",
	"Popq_GS",
	"Rsm",
	"Bts_rm16_r16",
	"Bts_rm32_r32",
	"Bts_rm64_r64",
	"Shrd_rm16_r16_imm8",
	"Shrd_rm32_r32_imm8",
	"Shrd_rm64_r64_imm8",
	"Shrd_rm16_r16_CL",
	"Shrd_rm32_r32_CL",
	"Shrd_rm64_r64_CL",
	"Fxsave_m512byte",
	"Fxsave64_m512byte",
	"Rdfsbase_r32",
	"Rdfsbase_r64",
	"Fxrstor_m512byte",
	"Fxrstor64_m512byte",
	"Rdgsbase_r32",
	"Rdgsbase_r64",
	"Ldmxcsr_m32",
	"Wrfsbase_r32",
	"Wrfsbase_r64",
	"VEX_Vldmxcsr_m32",
	"Stmxcsr_m32",
	"Wrgsbase_r32",
	"Wrgsbase_r64",
	"VEX_Vstmxcsr_m32",
	"Xsave_mem",
	"Xsave64_mem",
	"Ptwrite_rm32",
	"Ptwrite_rm64",
	"Xrstor_mem",
	"Xrstor64_mem",
	"Incsspd_r32",
	"Incsspq_r64",
	"Xsaveopt_mem",
	"Xsaveopt64_mem",
	"Clwb_m8",
	"Tpause_r32",
	"Tpause_r64",
	"Clrssbsy_m64",
	"Umonitor_r16",
	"Umonitor_r32",
	"Umonitor_r64",
	"Umwait_r32",
	"Umwait_r64",
	"Clflush_m8",
	"Clflushopt_m8",
	"Lfence",
	"Lfence_E9",
	"Lfence_EA",
	"Lfence_EB",
	"Lfence_EC",
	"Lfence_ED",
	"Lfence_EE",
	"Lfence_EF",
	"Mfence",
	"Mfence_F1",
	"Mfence_F2",
	"Mfence_F3",
	"Mfence_F4",
	"Mfence_F5",
	"Mfence_F6",
	"Mfence_F7",
	"Sfence",
	"Sfence_F9",
	"Sfence_FA",
	"Sfence_FB",
	"Sfence_FC",
	"Sfence_FD",
	"Sfence_FE",
	"Sfence_FF",
	"Pcommit",
	"Imul_r16_rm16",
	"Imul_r32_rm32",
	"Imul_r64_rm64",
	"Cmpxchg_rm8_r8",
	"Cmpxchg_rm16_r16",
	"Cmpxchg_rm32_r32",
	"Cmpxchg_rm64_r64",
	"Lss_r16_m1616",
	"Lss_r32_m1632",
	"Lss_r64_m1664",
	"Btr_rm16_r16",
	"Btr_rm32_r32",
	"Btr_rm64_r64",
	"Lfs_r16_m1616",
	"Lfs_r32_m1632",
	"Lfs_r64_m1664",
	"Lgs_r16_m1616",
	"Lgs_r32_m1632",
	"Lgs_r64_m1664",
	"Movzx_r16_rm8",
	"Movzx_r32_rm8",
	"Movzx_r64_rm8",
	"Movzx_r16_rm16",
	"Movzx_r32_rm16",
	"Movzx_r64_rm16",
	"Jmpe_disp16",
	"Jmpe_disp32",
	"Popcnt_r16_rm16",
	"Popcnt_r32_rm32",
	"Popcnt_r64_rm64",
	"Ud1_r16_rm16",
	"Ud1_r32_rm32",
	"Ud1_r64_rm64",
	"Bt_rm16_imm8",
	"Bt_rm32_imm8",
	"Bt_rm64_imm8",
	"Bts_rm16_imm8",
	"Bts_rm32_imm8",
	"Bts_rm64_imm8",
	"Btr_rm16_imm8",
	"Btr_rm32_imm8",
	"Btr_rm64_imm8",
	"Btc_rm16_imm8",
	"Btc_rm32_imm8",
	"Btc_rm64_imm8",
	"Btc_rm16_r16",
	"Btc_rm32_r32",
	"Btc_rm64_r64",
	"Bsf_r16_rm16",
	"Bsf_r32_rm32",
	"Bsf_r64_rm64",
	"Tzcnt_r16_rm16",
	"Tzcnt_r32_rm32",
	"Tzcnt_r64_rm64",
	"Bsr_r16_rm16",
	"Bsr_r32_rm32",
	"Bsr_r64_rm64",
	"Lzcnt_r16_rm16",
	"Lzcnt_r32_rm32",
	"Lzcnt_r64_rm64",
	"Movsx_r16_rm8",
	"Movsx_r32_rm8",
	"Movsx_r64_rm8",
	"Movsx_r16_rm16",
	"Movsx_r32_rm16",
	"Movsx_r64_rm16",
	"Xadd_rm8_r8",
	"Xadd_rm16_r16",
	"Xadd_rm32_r32",
	"Xadd_rm64_r64",
	"Cmpps_xmm_xmmm128_imm8",
	"VEX_Vcmpps_xmm_xmm_xmmm128_imm8",
	"VEX_Vcmpps_ymm_ymm_ymmm256_imm8",
	"EVEX_Vcmpps_kr_k1_xmm_xmmm128b32_imm8",
	"EVEX_Vcmpps_kr_k1_ymm_ymmm256b32_imm8",
	"EVEX_Vcmpps_kr_k1_zmm_zmmm512b32_imm8_sae",
	"Cmppd_xmm_xmmm128_imm8",
	"VEX_Vcmppd_xmm_xmm_xmmm128_imm8",
	"VEX_Vcmppd_ymm_ymm_ymmm256_imm8",
	"EVEX_Vcmppd_kr_k1_xmm_xmmm128b64_imm8",
	"EVEX_Vcmppd_kr_k1_ymm_ymmm256b64_imm8",
	"EVEX_Vcmppd_kr_k1_zmm_zmmm512b64_imm8_sae",
	"Cmpss_xmm_xmmm32_imm8",
	"VEX_Vcmpss_xmm_xmm_xmmm32_imm8",
	"EVEX_Vcmpss_kr_k1_xmm_xmmm32_imm8_sae",
	"Cmpsd_xmm_xmmm64_imm8",
	"VEX_Vcmpsd_xmm_xmm_xmmm64_imm8",
	"EVEX_Vcmpsd_kr_k1_xmm_xmmm64_imm8_sae",
	"Movnti_m32_r32",
	"Movnti_m64_r64",
	"Pinsrw_mm_r32m16_imm8",
	"Pinsrw_mm_r64m16_imm8",
	"Pinsrw_xmm_r32m16_imm8",
	"Pinsrw_xmm_r64m16_imm8",
	"VEX_Vpinsrw_xmm_xmm_r32m16_imm8",
	"VEX_Vpinsrw_xmm_xmm_r64m16_imm8",
	"EVEX_Vpinsrw_xmm_xmm_r32m16_imm8",
	"EVEX_Vpinsrw_xmm_xmm_r64m16_imm8",
	"Pextrw_r32_mm_imm8",
	"Pextrw_r64_mm_imm8",
	"Pextrw_r32_xmm_imm8",
	"Pextrw_r64_xmm_imm8",
	"VEX_Vpextrw_r32_xmm_imm8",
	"VEX_Vpextrw_r64_xmm_imm8",
	"EVEX_Vpextrw_r32_xmm_imm8",
	"EVEX_Vpextrw_r64_xmm_imm8",
	"Shufps_xmm_xmmm128_imm8",
	"VEX_Vshufps_xmm_xmm_xmmm128_imm8",
	"VEX_Vshufps_ymm_ymm_ymmm256_imm8",
	"EVEX_Vshufps_xmm_k1z_xmm_xmmm128b32_imm8",
	"EVEX_Vshufps_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vshufps_zmm_k1z_zmm_zmmm512b32_imm8",
	"Shufpd_xmm_xmmm128_imm8",
	"VEX_Vshufpd_xmm_xmm_xmmm128_imm8",
	"VEX_Vshufpd_ymm_ymm_ymmm256_imm8",
	"EVEX_Vshufpd_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vshufpd_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vshufpd_zmm_k1z_zmm_zmmm512b64_imm8",
	"Cmpxchg8b_m64",
	"Cmpxchg16b_m128",
	"Xrstors_mem",
	"Xrstors64_mem",
	"Xsavec_mem",
	"Xsavec64_mem",
	"Xsaves_mem",
	"Xsaves64_mem",
	"Vmptrld_m64",
	"Vmclear_m64",
	"Vmxon_m64",
	"Rdrand_r16",
	"Rdrand_r32",
	"Rdrand_r64",
	"Vmptrst_m64",
	"Rdseed_r16",
	"Rdseed_r32",
	"Rdseed_r64",
	"Rdpid_r32",
	"Rdpid_r64",
	"Bswap_r16",
	"Bswap_r32",
	"Bswap_r64",
	"Addsubpd_xmm_xmmm128",
	"VEX_Vaddsubpd_xmm_xmm_xmmm128",
	"VEX_Vaddsubpd_ymm_ymm_ymmm256",
	"Addsubps_xmm_xmmm128",
	"VEX_Vaddsubps_xmm_xmm_xmmm128",
	"VEX_Vaddsubps_ymm_ymm_ymmm256",
	"Psrlw_mm_mmm64",
	"Psrlw_xmm_xmmm128",
	"VEX_Vpsrlw_xmm_xmm_xmmm128",
	"VEX_Vpsrlw_ymm_ymm_xmmm128",
	"EVEX_Vpsrlw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsrlw_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsrlw_zmm_k1z_zmm_xmmm128",
	"Psrld_mm_mmm64",
	"Psrld_xmm_xmmm128",
	"VEX_Vpsrld_xmm_xmm_xmmm128",
	"VEX_Vpsrld_ymm_ymm_xmmm128",
	"EVEX_Vpsrld_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsrld_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsrld_zmm_k1z_zmm_xmmm128",
	"Psrlq_mm_mmm64",
	"Psrlq_xmm_xmmm128",
	"VEX_Vpsrlq_xmm_xmm_xmmm128",
	"VEX_Vpsrlq_ymm_ymm_xmmm128",
	"EVEX_Vpsrlq_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsrlq_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsrlq_zmm_k1z_zmm_xmmm128",
	"Paddq_mm_mmm64",
	"Paddq_xmm_xmmm128",
	"VEX_Vpaddq_xmm_xmm_xmmm128",
	"VEX_Vpaddq_ymm_ymm_ymmm256",
	"EVEX_Vpaddq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpaddq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpaddq_zmm_k1z_zmm_zmmm512b64",
	"Pmullw_mm_mmm64",
	"Pmullw_xmm_xmmm128",
	"VEX_Vpmullw_xmm_xmm_xmmm128",
	"VEX_Vpmullw_ymm_ymm_ymmm256",
	"EVEX_Vpmullw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmullw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmullw_zmm_k1z_zmm_zmmm512",
	"Movq_xmmm64_xmm",
	"VEX_Vmovq_xmmm64_xmm",
	"EVEX_Vmovq_xmmm64_xmm",
	"Movq2dq_xmm_mm",
	"Movdq2q_mm_xmm",
	"Pmovmskb_r32_mm",
	"Pmovmskb_r64_mm",
	"Pmovmskb_r32_xmm",
	"Pmovmskb_r64_xmm",
	"VEX_Vpmovmskb_r32_xmm",
	"VEX_Vpmovmskb_r64_xmm",
	"VEX_Vpmovmskb_r32_ymm",
	"VEX_Vpmovmskb_r64_ymm",
	"Psubusb_mm_mmm64",
	"Psubusb_xmm_xmmm128",
	"VEX_Vpsubusb_xmm_xmm_xmmm128",
	"VEX_Vpsubusb_ymm_ymm_ymmm256",
	"EVEX_Vpsubusb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsubusb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsubusb_zmm_k1z_zmm_zmmm512",
	"Psubusw_mm_mmm64",
	"Psubusw_xmm_xmmm128",
	"VEX_Vpsubusw_xmm_xmm_xmmm128",
	"VEX_Vpsubusw_ymm_ymm_ymmm256",
	"EVEX_Vpsubusw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsubusw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsubusw_zmm_k1z_zmm_zmmm512",
	"Pminub_mm_mmm64",
	"Pminub_xmm_xmmm128",
	"VEX_Vpminub_xmm_xmm_xmmm128",
	"VEX_Vpminub_ymm_ymm_ymmm256",
	"EVEX_Vpminub_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpminub_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpminub_zmm_k1z_zmm_zmmm512",
	"Pand_mm_mmm64",
	"Pand_xmm_xmmm128",
	"VEX_Vpand_xmm_xmm_xmmm128",
	"VEX_Vpand_ymm_ymm_ymmm256",
	"EVEX_Vpandd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpandd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpandd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpandq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpandq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpandq_zmm_k1z_zmm_zmmm512b64",
	"Paddusb_mm_mmm64",
	"Paddusb_xmm_xmmm128",
	"VEX_Vpaddusb_xmm_xmm_xmmm128",
	"VEX_Vpaddusb_ymm_ymm_ymmm256",
	"EVEX_Vpaddusb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpaddusb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpaddusb_zmm_k1z_zmm_zmmm512",
	"Paddusw_mm_mmm64",
	"Paddusw_xmm_xmmm128",
	"VEX_Vpaddusw_xmm_xmm_xmmm128",
	"VEX_Vpaddusw_ymm_ymm_ymmm256",
	"EVEX_Vpaddusw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpaddusw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpaddusw_zmm_k1z_zmm_zmmm512",
	"Pmaxub_mm_mmm64",
	"Pmaxub_xmm_xmmm128",
	"VEX_Vpmaxub_xmm_xmm_xmmm128",
	"VEX_Vpmaxub_ymm_ymm_ymmm256",
	"EVEX_Vpmaxub_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmaxub_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmaxub_zmm_k1z_zmm_zmmm512",
	"Pandn_mm_mmm64",
	"Pandn_xmm_xmmm128",
	"VEX_Vpandn_xmm_xmm_xmmm128",
	"VEX_Vpandn_ymm_ymm_ymmm256",
	"EVEX_Vpandnd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpandnd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpandnd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpandnq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpandnq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpandnq_zmm_k1z_zmm_zmmm512b64",
	"Pavgb_mm_mmm64",
	"Pavgb_xmm_xmmm128",
	"VEX_Vpavgb_xmm_xmm_xmmm128",
	"VEX_Vpavgb_ymm_ymm_ymmm256",
	"EVEX_Vpavgb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpavgb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpavgb_zmm_k1z_zmm_zmmm512",
	"Psraw_mm_mmm64",
	"Psraw_xmm_xmmm128",
	"VEX_Vpsraw_xmm_xmm_xmmm128",
	"VEX_Vpsraw_ymm_ymm_xmmm128",
	"EVEX_Vpsraw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsraw_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsraw_zmm_k1z_zmm_xmmm128",
	"Psrad_mm_mmm64",
	"Psrad_xmm_xmmm128",
	"VEX_Vpsrad_xmm_xmm_xmmm128",
	"VEX_Vpsrad_ymm_ymm_xmmm128",
	"EVEX_Vpsrad_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsrad_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsrad_zmm_k1z_zmm_xmmm128",
	"EVEX_Vpsraq_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsraq_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsraq_zmm_k1z_zmm_xmmm128",
	"Pavgw_mm_mmm64",
	"Pavgw_xmm_xmmm128",
	"VEX_Vpavgw_xmm_xmm_xmmm128",
	"VEX_Vpavgw_ymm_ymm_ymmm256",
	"EVEX_Vpavgw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpavgw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpavgw_zmm_k1z_zmm_zmmm512",
	"Pmulhuw_mm_mmm64",
	"Pmulhuw_xmm_xmmm128",
	"VEX_Vpmulhuw_xmm_xmm_xmmm128",
	"VEX_Vpmulhuw_ymm_ymm_ymmm256",
	"EVEX_Vpmulhuw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmulhuw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmulhuw_zmm_k1z_zmm_zmmm512",
	"Pmulhw_mm_mmm64",
	"Pmulhw_xmm_xmmm128",
	"VEX_Vpmulhw_xmm_xmm_xmmm128",
	"VEX_Vpmulhw_ymm_ymm_ymmm256",
	"EVEX_Vpmulhw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmulhw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmulhw_zmm_k1z_zmm_zmmm512",
	"Cvttpd2dq_xmm_xmmm128",
	"VEX_Vcvttpd2dq_xmm_xmmm128",
	"VEX_Vcvttpd2dq_xmm_ymmm256",
	"EVEX_Vcvttpd2dq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvttpd2dq_xmm_k1z_ymmm256b64",
	"EVEX_Vcvttpd2dq_ymm_k1z_zmmm512b64_sae",
	"Cvtdq2pd_xmm_xmmm64",
	"VEX_Vcvtdq2pd_xmm_xmmm64",
	"VEX_Vcvtdq2pd_ymm_xmmm128",
	"EVEX_Vcvtdq2pd_xmm_k1z_xmmm64b32",
	"EVEX_Vcvtdq2pd_ymm_k1z_xmmm128b32",
	"EVEX_Vcvtdq2pd_zmm_k1z_ymmm256b32_er",
	"EVEX_Vcvtqq2pd_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtqq2pd_ymm_k1z_ymmm256b64",
	"EVEX_Vcvtqq2pd_zmm_k1z_zmmm512b64_er",
	"Cvtpd2dq_xmm_xmmm128",
	"VEX_Vcvtpd2dq_xmm_xmmm128",
	"VEX_Vcvtpd2dq_xmm_ymmm256",
	"EVEX_Vcvtpd2dq_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtpd2dq_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtpd2dq_ymm_k1z_zmmm512b64_er",
	"Movntq_m64_mm",
	"Movntdq_m128_xmm",
	"VEX_Vmovntdq_m128_xmm",
	"VEX_Vmovntdq_m256_ymm",
	"EVEX_Vmovntdq_m128_xmm",
	"EVEX_Vmovntdq_m256_ymm",
	"EVEX_Vmovntdq_m512_zmm",
	"Psubsb_mm_mmm64",
	"Psubsb_xmm_xmmm128",
	"VEX_Vpsubsb_xmm_xmm_xmmm128",
	"VEX_Vpsubsb_ymm_ymm_ymmm256",
	"EVEX_Vpsubsb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsubsb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsubsb_zmm_k1z_zmm_zmmm512",
	"Psubsw_mm_mmm64",
	"Psubsw_xmm_xmmm128",
	"VEX_Vpsubsw_xmm_xmm_xmmm128",
	"VEX_Vpsubsw_ymm_ymm_ymmm256",
	"EVEX_Vpsubsw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsubsw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsubsw_zmm_k1z_zmm_zmmm512",
	"Pminsw_mm_mmm64",
	"Pminsw_xmm_xmmm128",
	"VEX_Vpminsw_xmm_xmm_xmmm128",
	"VEX_Vpminsw_ymm_ymm_ymmm256",
	"EVEX_Vpminsw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpminsw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpminsw_zmm_k1z_zmm_zmmm512",
	"Por_mm_mmm64",
	"Por_xmm_xmmm128",
	"VEX_Vpor_xmm_xmm_xmmm128",
	"VEX_Vpor_ymm_ymm_ymmm256",
	"EVEX_Vpord_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpord_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpord_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vporq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vporq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vporq_zmm_k1z_zmm_zmmm512b64",
	"Paddsb_mm_mmm64",
	"Paddsb_xmm_xmmm128",
	"VEX_Vpaddsb_xmm_xmm_xmmm128",
	"VEX_Vpaddsb_ymm_ymm_ymmm256",
	"EVEX_Vpaddsb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpaddsb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpaddsb_zmm_k1z_zmm_zmmm512",
	"Paddsw_mm_mmm64",
	"Paddsw_xmm_xmmm128",
	"VEX_Vpaddsw_xmm_xmm_xmmm128",
	"VEX_Vpaddsw_ymm_ymm_ymmm256",
	"EVEX_Vpaddsw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpaddsw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpaddsw_zmm_k1z_zmm_zmmm512",
	"Pmaxsw_mm_mmm64",
	"Pmaxsw_xmm_xmmm128",
	"VEX_Vpmaxsw_xmm_xmm_xmmm128",
	"VEX_Vpmaxsw_ymm_ymm_ymmm256",
	"EVEX_Vpmaxsw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmaxsw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmaxsw_zmm_k1z_zmm_zmmm512",
	"Pxor_mm_mmm64",
	"Pxor_xmm_xmmm128",
	"VEX_Vpxor_xmm_xmm_xmmm128",
	"VEX_Vpxor_ymm_ymm_ymmm256",
	"EVEX_Vpxord_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpxord_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpxord_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpxorq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpxorq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpxorq_zmm_k1z_zmm_zmmm512b64",
	"Lddqu_xmm_m128",
	"VEX_Vlddqu_xmm_m128",
	"VEX_Vlddqu_ymm_m256",
	"Psllw_mm_mmm64",
	"Psllw_xmm_xmmm128",
	"VEX_Vpsllw_xmm_xmm_xmmm128",
	"VEX_Vpsllw_ymm_ymm_xmmm128",
	"EVEX_Vpsllw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsllw_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsllw_zmm_k1z_zmm_xmmm128",
	"Pslld_mm_mmm64",
	"Pslld_xmm_xmmm128",
	"VEX_Vpslld_xmm_xmm_xmmm128",
	"VEX_Vpslld_ymm_ymm_xmmm128",
	"EVEX_Vpslld_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpslld_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpslld_zmm_k1z_zmm_xmmm128",
	"Psllq_mm_mmm64",
	"Psllq_xmm_xmmm128",
	"VEX_Vpsllq_xmm_xmm_xmmm128",
	"VEX_Vpsllq_ymm_ymm_xmmm128",
	"EVEX_Vpsllq_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsllq_ymm_k1z_ymm_xmmm128",
	"EVEX_Vpsllq_zmm_k1z_zmm_xmmm128",
	"Pmuludq_mm_mmm64",
	"Pmuludq_xmm_xmmm128",
	"VEX_Vpmuludq_xmm_xmm_xmmm128",
	"VEX_Vpmuludq_ymm_ymm_ymmm256",
	"EVEX_Vpmuludq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmuludq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmuludq_zmm_k1z_zmm_zmmm512b64",
	"Pmaddwd_mm_mmm64",
	"Pmaddwd_xmm_xmmm128",
	"VEX_Vpmaddwd_xmm_xmm_xmmm128",
	"VEX_Vpmaddwd_ymm_ymm_ymmm256",
	"EVEX_Vpmaddwd_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmaddwd_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmaddwd_zmm_k1z_zmm_zmmm512",
	"Psadbw_mm_mmm64",
	"Psadbw_xmm_xmmm128",
	"VEX_Vpsadbw_xmm_xmm_xmmm128",
	"VEX_Vpsadbw_ymm_ymm_ymmm256",
	"EVEX_Vpsadbw_xmm_xmm_xmmm128",
	"EVEX_Vpsadbw_ymm_ymm_ymmm256",
	"EVEX_Vpsadbw_zmm_zmm_zmmm512",
	"Maskmovq_rDI_mm_mm",
	"Maskmovdqu_rDI_xmm_xmm",
	"VEX_Vmaskmovdqu_rDI_xmm_xmm",
	"Psubb_mm_mmm64",
	"Psubb_xmm_xmmm128",
	"VEX_Vpsubb_xmm_xmm_xmmm128",
	"VEX_Vpsubb_ymm_ymm_ymmm256",
	"EVEX_Vpsubb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsubb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsubb_zmm_k1z_zmm_zmmm512",
	"Psubw_mm_mmm64",
	"Psubw_xmm_xmmm128",
	"VEX_Vpsubw_xmm_xmm_xmmm128",
	"VEX_Vpsubw_ymm_ymm_ymmm256",
	"EVEX_Vpsubw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsubw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsubw_zmm_k1z_zmm_zmmm512",
	"Psubd_mm_mmm64",
	"Psubd_xmm_xmmm128",
	"VEX_Vpsubd_xmm_xmm_xmmm128",
	"VEX_Vpsubd_ymm_ymm_ymmm256",
	"EVEX_Vpsubd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpsubd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpsubd_zmm_k1z_zmm_zmmm512b32",
	"Psubq_mm_mmm64",
	"Psubq_xmm_xmmm128",
	"VEX_Vpsubq_xmm_xmm_xmmm128",
	"VEX_Vpsubq_ymm_ymm_ymmm256",
	"EVEX_Vpsubq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpsubq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpsubq_zmm_k1z_zmm_zmmm512b64",
	"Paddb_mm_mmm64",
	"Paddb_xmm_xmmm128",
	"VEX_Vpaddb_xmm_xmm_xmmm128",
	"VEX_Vpaddb_ymm_ymm_ymmm256",
	"EVEX_Vpaddb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpaddb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpaddb_zmm_k1z_zmm_zmmm512",
	"Paddw_mm_mmm64",
	"Paddw_xmm_xmmm128",
	"VEX_Vpaddw_xmm_xmm_xmmm128",
	"VEX_Vpaddw_ymm_ymm_ymmm256",
	"EVEX_Vpaddw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpaddw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpaddw_zmm_k1z_zmm_zmmm512",
	"Paddd_mm_mmm64",
	"Paddd_xmm_xmmm128",
	"VEX_Vpaddd_xmm_xmm_xmmm128",
	"VEX_Vpaddd_ymm_ymm_ymmm256",
	"EVEX_Vpaddd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpaddd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpaddd_zmm_k1z_zmm_zmmm512b32",
	"Ud0_r16_rm16",
	"Ud0_r32_rm32",
	"Ud0_r64_rm64",
	"Pshufb_mm_mmm64",
	"Pshufb_xmm_xmmm128",
	"VEX_Vpshufb_xmm_xmm_xmmm128",
	"VEX_Vpshufb_ymm_ymm_ymmm256",
	"EVEX_Vpshufb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpshufb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpshufb_zmm_k1z_zmm_zmmm512",
	"Phaddw_mm_mmm64",
	"Phaddw_xmm_xmmm128",
	"VEX_Vphaddw_xmm_xmm_xmmm128",
	"VEX_Vphaddw_ymm_ymm_ymmm256",
	"Phaddd_mm_mmm64",
	"Phaddd_xmm_xmmm128",
	"VEX_Vphaddd_xmm_xmm_xmmm128",
	"VEX_Vphaddd_ymm_ymm_ymmm256",
	"Phaddsw_mm_mmm64",
	"Phaddsw_xmm_xmmm128",
	"VEX_Vphaddsw_xmm_xmm_xmmm128",
	"VEX_Vphaddsw_ymm_ymm_ymmm256",
	"Pmaddubsw_mm_mmm64",
	"Pmaddubsw_xmm_xmmm128",
	"VEX_Vpmaddubsw_xmm_xmm_xmmm128",
	"VEX_Vpmaddubsw_ymm_ymm_ymmm256",
	"EVEX_Vpmaddubsw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmaddubsw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmaddubsw_zmm_k1z_zmm_zmmm512",
	"Phsubw_mm_mmm64",
	"Phsubw_xmm_xmmm128",
	"VEX_Vphsubw_xmm_xmm_xmmm128",
	"VEX_Vphsubw_ymm_ymm_ymmm256",
	"Phsubd_mm_mmm64",
	"Phsubd_xmm_xmmm128",
	"VEX_Vphsubd_xmm_xmm_xmmm128",
	"VEX_Vphsubd_ymm_ymm_ymmm256",
	"Phsubsw_mm_mmm64",
	"Phsubsw_xmm_xmmm128",
	"VEX_Vphsubsw_xmm_xmm_xmmm128",
	"VEX_Vphsubsw_ymm_ymm_ymmm256",
	"Psignb_mm_mmm64",
	"Psignb_xmm_xmmm128",
	"VEX_Vpsignb_xmm_xmm_xmmm128",
	"VEX_Vpsignb_ymm_ymm_ymmm256",
	"Psignw_mm_mmm64",
	"Psignw_xmm_xmmm128",
	"VEX_Vpsignw_xmm_xmm_xmmm128",
	"VEX_Vpsignw_ymm_ymm_ymmm256",
	"Psignd_mm_mmm64",
	"Psignd_xmm_xmmm128",
	"VEX_Vpsignd_xmm_xmm_xmmm128",
	"VEX_Vpsignd_ymm_ymm_ymmm256",
	"Pmulhrsw_mm_mmm64",
	"Pmulhrsw_xmm_xmmm128",
	"VEX_Vpmulhrsw_xmm_xmm_xmmm128",
	"VEX_Vpmulhrsw_ymm_ymm_ymmm256",
	"EVEX_Vpmulhrsw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmulhrsw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmulhrsw_zmm_k1z_zmm_zmmm512",
	"VEX_Vpermilps_xmm_xmm_xmmm128",
	"VEX_Vpermilps_ymm_ymm_ymmm256",
	"EVEX_Vpermilps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpermilps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpermilps_zmm_k1z_zmm_zmmm512b32",
	"VEX_Vpermilpd_xmm_xmm_xmmm128",
	"VEX_Vpermilpd_ymm_ymm_ymmm256",
	"EVEX_Vpermilpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpermilpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpermilpd_zmm_k1z_zmm_zmmm512b64",
	"VEX_Vtestps_xmm_xmmm128",
	"VEX_Vtestps_ymm_ymmm256",
	"VEX_Vtestpd_xmm_xmmm128",
	"VEX_Vtestpd_ymm_ymmm256",
	"Pblendvb_xmm_xmmm128",
	"EVEX_Vpsrlvw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsrlvw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsrlvw_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpmovuswb_xmmm64_k1z_xmm",
	"EVEX_Vpmovuswb_xmmm128_k1z_ymm",
	"EVEX_Vpmovuswb_ymmm256_k1z_zmm",
	"EVEX_Vpsravw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsravw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsravw_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpmovusdb_xmmm32_k1z_xmm",
	"EVEX_Vpmovusdb_xmmm64_k1z_ymm",
	"EVEX_Vpmovusdb_xmmm128_k1z_zmm",
	"EVEX_Vpsllvw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpsllvw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpsllvw_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpmovusqb_xmmm16_k1z_xmm",
	"EVEX_Vpmovusqb_xmmm32_k1z_ymm",
	"EVEX_Vpmovusqb_xmmm64_k1z_zmm",
	"VEX_Vcvtph2ps_xmm_xmmm64",
	"VEX_Vcvtph2ps_ymm_xmmm128",
	"EVEX_Vcvtph2ps_xmm_k1z_xmmm64",
	"EVEX_Vcvtph2ps_ymm_k1z_xmmm128",
	"EVEX_Vcvtph2ps_zmm_k1z_ymmm256_sae",
	"EVEX_Vpmovusdw_xmmm64_k1z_xmm",
	"EVEX_Vpmovusdw_xmmm128_k1z_ymm",
	"EVEX_Vpmovusdw_ymmm256_k1z_zmm",
	"Blendvps_xmm_xmmm128",
	"EVEX_Vprorvd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vprorvd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vprorvd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vprorvq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vprorvq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vprorvq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpmovusqw_xmmm32_k1z_xmm",
	"EVEX_Vpmovusqw_xmmm64_k1z_ymm",
	"EVEX_Vpmovusqw_xmmm128_k1z_zmm",
	"Blendvpd_xmm_xmmm128",
	"EVEX_Vprolvd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vprolvd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vprolvd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vprolvq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vprolvq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vprolvq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpmovusqd_xmmm64_k1z_xmm",
	"EVEX_Vpmovusqd_xmmm128_k1z_ymm",
	"EVEX_Vpmovusqd_ymmm256_k1z_zmm",
	"VEX_Vpermps_ymm_ymm_ymmm256",
	"EVEX_Vpermps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpermps_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpermpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpermpd_zmm_k1z_zmm_zmmm512b64",
	"Ptest_xmm_xmmm128",
	"VEX_Vptest_xmm_xmmm128",
	"VEX_Vptest_ymm_ymmm256",
	"VEX_Vbroadcastss_xmm_m32",
	"VEX_Vbroadcastss_ymm_m32",
	"EVEX_Vbroadcastss_xmm_k1z_xmmm32",
	"EVEX_Vbroadcastss_ymm_k1z_xmmm32",
	"EVEX_Vbroadcastss_zmm_k1z_xmmm32",
	"VEX_Vbroadcastsd_ymm_m64",
	"EVEX_Vbroadcastf32x2_ymm_k1z_xmmm64",
	"EVEX_Vbroadcastf32x2_zmm_k1z_xmmm64",
	"EVEX_Vbroadcastsd_ymm_k1z_xmmm64",
	"EVEX_Vbroadcastsd_zmm_k1z_xmmm64",
	"VEX_Vbroadcastf128_ymm_m128",
	"EVEX_Vbroadcastf32x4_ymm_k1z_m128",
	"EVEX_Vbroadcastf32x4_zmm_k1z_m128",
	"EVEX_Vbroadcastf64x2_ymm_k1z_m128",
	"EVEX_Vbroadcastf64x2_zmm_k1z_m128",
	"EVEX_Vbroadcastf32x8_zmm_k1z_m256",
	"EVEX_Vbroadcastf64x4_zmm_k1z_m256",
	"Pabsb_mm_mmm64",
	"Pabsb_xmm_xmmm128",
	"VEX_Vpabsb_xmm_xmmm128",
	"VEX_Vpabsb_ymm_ymmm256",
	"EVEX_Vpabsb_xmm_k1z_xmmm128",
	"EVEX_Vpabsb_ymm_k1z_ymmm256",
	"EVEX_Vpabsb_zmm_k1z_zmmm512",
	"Pabsw_mm_mmm64",
	"Pabsw_xmm_xmmm128",
	"VEX_Vpabsw_xmm_xmmm128",
	"VEX_Vpabsw_ymm_ymmm256",
	"EVEX_Vpabsw_xmm_k1z_xmmm128",
	"EVEX_Vpabsw_ymm_k1z_ymmm256",
	"EVEX_Vpabsw_zmm_k1z_zmmm512",
	"Pabsd_mm_mmm64",
	"Pabsd_xmm_xmmm128",
	"VEX_Vpabsd_xmm_xmmm128",
	"VEX_Vpabsd_ymm_ymmm256",
	"EVEX_Vpabsd_xmm_k1z_xmmm128b32",
	"EVEX_Vpabsd_ymm_k1z_ymmm256b32",
	"EVEX_Vpabsd_zmm_k1z_zmmm512b32",
	"EVEX_Vpabsq_xmm_k1z_xmmm128b64",
	"EVEX_Vpabsq_ymm_k1z_ymmm256b64",
	"EVEX_Vpabsq_zmm_k1z_zmmm512b64",
	"Pmovsxbw_xmm_xmmm64",
	"VEX_Vpmovsxbw_xmm_xmmm64",
	"VEX_Vpmovsxbw_ymm_xmmm128",
	"EVEX_Vpmovsxbw_xmm_k1z_xmmm64",
	"EVEX_Vpmovsxbw_ymm_k1z_xmmm128",
	"EVEX_Vpmovsxbw_zmm_k1z_ymmm256",
	"EVEX_Vpmovswb_xmmm64_k1z_xmm",
	"EVEX_Vpmovswb_xmmm128_k1z_ymm",
	"EVEX_Vpmovswb_ymmm256_k1z_zmm",
	"Pmovsxbd_xmm_xmmm32",
	"VEX_Vpmovsxbd_xmm_xmmm32",
	"VEX_Vpmovsxbd_ymm_xmmm64",
	"EVEX_Vpmovsxbd_xmm_k1z_xmmm32",
	"EVEX_Vpmovsxbd_ymm_k1z_xmmm64",
	"EVEX_Vpmovsxbd_zmm_k1z_xmmm128",
	"EVEX_Vpmovsdb_xmmm32_k1z_xmm",
	"EVEX_Vpmovsdb_xmmm64_k1z_ymm",
	"EVEX_Vpmovsdb_xmmm128_k1z_zmm",
	"Pmovsxbq_xmm_xmmm16",
	"VEX_Vpmovsxbq_xmm_xmmm16",
	"VEX_Vpmovsxbq_ymm_xmmm32",
	"EVEX_Vpmovsxbq_xmm_k1z_xmmm16",
	"EVEX_Vpmovsxbq_ymm_k1z_xmmm32",
	"EVEX_Vpmovsxbq_zmm_k1z_xmmm64",
	"EVEX_Vpmovsqb_xmmm16_k1z_xmm",
	"EVEX_Vpmovsqb_xmmm32_k1z_ymm",
	"EVEX_Vpmovsqb_xmmm64_k1z_zmm",
	"Pmovsxwd_xmm_xmmm64",
	"VEX_Vpmovsxwd_xmm_xmmm64",
	"VEX_Vpmovsxwd_ymm_xmmm128",
	"EVEX_Vpmovsxwd_xmm_k1z_xmmm64",
	"EVEX_Vpmovsxwd_ymm_k1z_xmmm128",
	"EVEX_Vpmovsxwd_zmm_k1z_ymmm256",
	"EVEX_Vpmovsdw_xmmm64_k1z_xmm",
	"EVEX_Vpmovsdw_xmmm128_k1z_ymm",
	"EVEX_Vpmovsdw_ymmm256_k1z_zmm",
	"Pmovsxwq_xmm_xmmm32",
	"VEX_Vpmovsxwq_xmm_xmmm32",
	"VEX_Vpmovsxwq_ymm_xmmm64",
	"EVEX_Vpmovsxwq_xmm_k1z_xmmm32",
	"EVEX_Vpmovsxwq_ymm_k1z_xmmm64",
	"EVEX_Vpmovsxwq_zmm_k1z_xmmm128",
	"EVEX_Vpmovsqw_xmmm32_k1z_xmm",
	"EVEX_Vpmovsqw_xmmm64_k1z_ymm",
	"EVEX_Vpmovsqw_xmmm128_k1z_zmm",
	"Pmovsxdq_xmm_xmmm64",
	"VEX_Vpmovsxdq_xmm_xmmm64",
	"VEX_Vpmovsxdq_ymm_xmmm128",
	"EVEX_Vpmovsxdq_xmm_k1z_xmmm64",
	"EVEX_Vpmovsxdq_ymm_k1z_xmmm128",
	"EVEX_Vpmovsxdq_zmm_k1z_ymmm256",
	"EVEX_Vpmovsqd_xmmm64_k1z_xmm",
	"EVEX_Vpmovsqd_xmmm128_k1z_ymm",
	"EVEX_Vpmovsqd_ymmm256_k1z_zmm",
	"EVEX_Vptestmb_kr_k1_xmm_xmmm128",
	"EVEX_Vptestmb_kr_k1_ymm_ymmm256",
	"EVEX_Vptestmb_kr_k1_zmm_zmmm512",
	"EVEX_Vptestmw_kr_k1_xmm_xmmm128",
	"EVEX_Vptestmw_kr_k1_ymm_ymmm256",
	"EVEX_Vptestmw_kr_k1_zmm_zmmm512",
	"EVEX_Vptestnmb_kr_k1_xmm_xmmm128",
	"EVEX_Vptestnmb_kr_k1_ymm_ymmm256",
	"EVEX_Vptestnmb_kr_k1_zmm_zmmm512",
	"EVEX_Vptestnmw_kr_k1_xmm_xmmm128",
	"EVEX_Vptestnmw_kr_k1_ymm_ymmm256",
	"EVEX_Vptestnmw_kr_k1_zmm_zmmm512",
	"EVEX_Vptestmd_kr_k1_xmm_xmmm128b32",
	"EVEX_Vptestmd_kr_k1_ymm_ymmm256b32",
	"EVEX_Vptestmd_kr_k1_zmm_zmmm512b32",
	"EVEX_Vptestmq_kr_k1_xmm_xmmm128b64",
	"EVEX_Vptestmq_kr_k1_ymm_ymmm256b64",
	"EVEX_Vptestmq_kr_k1_zmm_zmmm512b64",
	"EVEX_Vptestnmd_kr_k1_xmm_xmmm128b32",
	"EVEX_Vptestnmd_kr_k1_ymm_ymmm256b32",
	"EVEX_Vptestnmd_kr_k1_zmm_zmmm512b32",
	"EVEX_Vptestnmq_kr_k1_xmm_xmmm128b64",
	"EVEX_Vptestnmq_kr_k1_ymm_ymmm256b64",
	"EVEX_Vptestnmq_kr_k1_zmm_zmmm512b64",
	"Pmuldq_xmm_xmmm128",
	"VEX_Vpmuldq_xmm_xmm_xmmm128",
	"VEX_Vpmuldq_ymm_ymm_ymmm256",
	"EVEX_Vpmuldq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmuldq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmuldq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpmovm2b_xmm_kr",
	"EVEX_Vpmovm2b_ymm_kr",
	"EVEX_Vpmovm2b_zmm_kr",
	"EVEX_Vpmovm2w_xmm_kr",
	"EVEX_Vpmovm2w_ymm_kr",
	"EVEX_Vpmovm2w_zmm_kr",
	"Pcmpeqq_xmm_xmmm128",
	"VEX_Vpcmpeqq_xmm_xmm_xmmm128",
	"VEX_Vpcmpeqq_ymm_ymm_ymmm256",
	"EVEX_Vpcmpeqq_kr_k1_xmm_xmmm128b64",
	"EVEX_Vpcmpeqq_kr_k1_ymm_ymmm256b64",
	"EVEX_Vpcmpeqq_kr_k1_zmm_zmmm512b64",
	"EVEX_Vpmovb2m_kr_xmm",
	"EVEX_Vpmovb2m_kr_ymm",
	"EVEX_Vpmovb2m_kr_zmm",
	"EVEX_Vpmovw2m_kr_xmm",
	"EVEX_Vpmovw2m_kr_ymm",
	"EVEX_Vpmovw2m_kr_zmm",
	"Movntdqa_xmm_m128",
	"VEX_Vmovntdqa_xmm_m128",
	"VEX_Vmovntdqa_ymm_m256",
	"EVEX_Vmovntdqa_xmm_m128",
	"EVEX_Vmovntdqa_ymm_m256",
	"EVEX_Vmovntdqa_zmm_m512",
	"EVEX_Vpbroadcastmb2q_xmm_kr",
	"EVEX_Vpbroadcastmb2q_ymm_kr",
	"EVEX_Vpbroadcastmb2q_zmm_kr",
	"Packusdw_xmm_xmmm128",
	"VEX_Vpackusdw_xmm_xmm_xmmm128",
	"VEX_Vpackusdw_ymm_ymm_ymmm256",
	"EVEX_Vpackusdw_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpackusdw_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpackusdw_zmm_k1z_zmm_zmmm512b32",
	"VEX_Vmaskmovps_xmm_xmm_m128",
	"VEX_Vmaskmovps_ymm_ymm_m256",
	"EVEX_Vscalefps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vscalefps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vscalefps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vscalefpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vscalefpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vscalefpd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vmaskmovpd_xmm_xmm_m128",
	"VEX_Vmaskmovpd_ymm_ymm_m256",
	"EVEX_Vscalefss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vscalefsd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vmaskmovps_m128_xmm_xmm",
	"VEX_Vmaskmovps_m256_ymm_ymm",
	"VEX_Vmaskmovpd_m128_xmm_xmm",
	"VEX_Vmaskmovpd_m256_ymm_ymm",
	"Pmovzxbw_xmm_xmmm64",
	"VEX_Vpmovzxbw_xmm_xmmm64",
	"VEX_Vpmovzxbw_ymm_xmmm128",
	"EVEX_Vpmovzxbw_xmm_k1z_xmmm64",
	"EVEX_Vpmovzxbw_ymm_k1z_xmmm128",
	"EVEX_Vpmovzxbw_zmm_k1z_ymmm256",
	"EVEX_Vpmovwb_xmmm64_k1z_xmm",
	"EVEX_Vpmovwb_xmmm128_k1z_ymm",
	"EVEX_Vpmovwb_ymmm256_k1z_zmm",
	"Pmovzxbd_xmm_xmmm32",
	"VEX_Vpmovzxbd_xmm_xmmm32",
	"VEX_Vpmovzxbd_ymm_xmmm64",
	"EVEX_Vpmovzxbd_xmm_k1z_xmmm32",
	"EVEX_Vpmovzxbd_ymm_k1z_xmmm64",
	"EVEX_Vpmovzxbd_zmm_k1z_xmmm128",
	"EVEX_Vpmovdb_xmmm32_k1z_xmm",
	"EVEX_Vpmovdb_xmmm64_k1z_ymm",
	"EVEX_Vpmovdb_xmmm128_k1z_zmm",
	"Pmovzxbq_xmm_xmmm16",
	"VEX_Vpmovzxbq_xmm_xmmm16",
	"VEX_Vpmovzxbq_ymm_xmmm32",
	"EVEX_Vpmovzxbq_xmm_k1z_xmmm16",
	"EVEX_Vpmovzxbq_ymm_k1z_xmmm32",
	"EVEX_Vpmovzxbq_zmm_k1z_xmmm64",
	"EVEX_Vpmovqb_xmmm16_k1z_xmm",
	"EVEX_Vpmovqb_xmmm32_k1z_ymm",
	"EVEX_Vpmovqb_xmmm64_k1z_zmm",
	"Pmovzxwd_xmm_xmmm64",
	"VEX_Vpmovzxwd_xmm_xmmm64",
	"VEX_Vpmovzxwd_ymm_xmmm128",
	"EVEX_Vpmovzxwd_xmm_k1z_xmmm64",
	"EVEX_Vpmovzxwd_ymm_k1z_xmmm128",
	"EVEX_Vpmovzxwd_zmm_k1z_ymmm256",
	"EVEX_Vpmovdw_xmmm64_k1z_xmm",
	"EVEX_Vpmovdw_xmmm128_k1z_ymm",
	"EVEX_Vpmovdw_ymmm256_k1z_zmm",
	"Pmovzxwq_xmm_xmmm32",
	"VEX_Vpmovzxwq_xmm_xmmm32",
	"VEX_Vpmovzxwq_ymm_xmmm64",
	"EVEX_Vpmovzxwq_xmm_k1z_xmmm32",
	"EVEX_Vpmovzxwq_ymm_k1z_xmmm64",
	"EVEX_Vpmovzxwq_zmm_k1z_xmmm128",
	"EVEX_Vpmovqw_xmmm32_k1z_xmm",
	"EVEX_Vpmovqw_xmmm64_k1z_ymm",
	"EVEX_Vpmovqw_xmmm128_k1z_zmm",
	"Pmovzxdq_xmm_xmmm64",
	"VEX_Vpmovzxdq_xmm_xmmm64",
	"VEX_Vpmovzxdq_ymm_xmmm128",
	"EVEX_Vpmovzxdq_xmm_k1z_xmmm64",
	"EVEX_Vpmovzxdq_ymm_k1z_xmmm128",
	"EVEX_Vpmovzxdq_zmm_k1z_ymmm256",
	"EVEX_Vpmovqd_xmmm64_k1z_xmm",
	"EVEX_Vpmovqd_xmmm128_k1z_ymm",
	"EVEX_Vpmovqd_ymmm256_k1z_zmm",
	"VEX_Vpermd_ymm_ymm_ymmm256",
	"EVEX_Vpermd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpermd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpermq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpermq_zmm_k1z_zmm_zmmm512b64",
	"Pcmpgtq_xmm_xmmm128",
	"VEX_Vpcmpgtq_xmm_xmm_xmmm128",
	"VEX_Vpcmpgtq_ymm_ymm_ymmm256",
	"EVEX_Vpcmpgtq_kr_k1_xmm_xmmm128b64",
	"EVEX_Vpcmpgtq_kr_k1_ymm_ymmm256b64",
	"EVEX_Vpcmpgtq_kr_k1_zmm_zmmm512b64",
	"Pminsb_xmm_xmmm128",
	"VEX_Vpminsb_xmm_xmm_xmmm128",
	"VEX_Vpminsb_ymm_ymm_ymmm256",
	"EVEX_Vpminsb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpminsb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpminsb_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpmovm2d_xmm_kr",
	"EVEX_Vpmovm2d_ymm_kr",
	"EVEX_Vpmovm2d_zmm_kr",
	"EVEX_Vpmovm2q_xmm_kr",
	"EVEX_Vpmovm2q_ymm_kr",
	"EVEX_Vpmovm2q_zmm_kr",
	"Pminsd_xmm_xmmm128",
	"VEX_Vpminsd_xmm_xmm_xmmm128",
	"VEX_Vpminsd_ymm_ymm_ymmm256",
	"EVEX_Vpminsd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpminsd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpminsd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpminsq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpminsq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpminsq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpmovd2m_kr_xmm",
	"EVEX_Vpmovd2m_kr_ymm",
	"EVEX_Vpmovd2m_kr_zmm",
	"EVEX_Vpmovq2m_kr_xmm",
	"EVEX_Vpmovq2m_kr_ymm",
	"EVEX_Vpmovq2m_kr_zmm",
	"Pminuw_xmm_xmmm128",
	"VEX_Vpminuw_xmm_xmm_xmmm128",
	"VEX_Vpminuw_ymm_ymm_ymmm256",
	"EVEX_Vpminuw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpminuw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpminuw_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpbroadcastmw2d_xmm_kr",
	"EVEX_Vpbroadcastmw2d_ymm_kr",
	"EVEX_Vpbroadcastmw2d_zmm_kr",
	"Pminud_xmm_xmmm128",
	"VEX_Vpminud_xmm_xmm_xmmm128",
	"VEX_Vpminud_ymm_ymm_ymmm256",
	"EVEX_Vpminud_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpminud_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpminud_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpminuq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpminuq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpminuq_zmm_k1z_zmm_zmmm512b64",
	"Pmaxsb_xmm_xmmm128",
	"VEX_Vpmaxsb_xmm_xmm_xmmm128",
	"VEX_Vpmaxsb_ymm_ymm_ymmm256",
	"EVEX_Vpmaxsb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmaxsb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmaxsb_zmm_k1z_zmm_zmmm512",
	"Pmaxsd_xmm_xmmm128",
	"VEX_Vpmaxsd_xmm_xmm_xmmm128",
	"VEX_Vpmaxsd_ymm_ymm_ymmm256",
	"EVEX_Vpmaxsd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpmaxsd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpmaxsd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpmaxsq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmaxsq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmaxsq_zmm_k1z_zmm_zmmm512b64",
	"Pmaxuw_xmm_xmmm128",
	"VEX_Vpmaxuw_xmm_xmm_xmmm128",
	"VEX_Vpmaxuw_ymm_ymm_ymmm256",
	"EVEX_Vpmaxuw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpmaxuw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpmaxuw_zmm_k1z_zmm_zmmm512",
	"Pmaxud_xmm_xmmm128",
	"VEX_Vpmaxud_xmm_xmm_xmmm128",
	"VEX_Vpmaxud_ymm_ymm_ymmm256",
	"EVEX_Vpmaxud_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpmaxud_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpmaxud_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpmaxuq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmaxuq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmaxuq_zmm_k1z_zmm_zmmm512b64",
	"Pmulld_xmm_xmmm128",
	"VEX_Vpmulld_xmm_xmm_xmmm128",
	"VEX_Vpmulld_ymm_ymm_ymmm256",
	"EVEX_Vpmulld_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpmulld_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpmulld_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpmullq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmullq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmullq_zmm_k1z_zmm_zmmm512b64",
	"Phminposuw_xmm_xmmm128",
	"VEX_Vphminposuw_xmm_xmmm128",
	"EVEX_Vgetexpps_xmm_k1z_xmmm128b32",
	"EVEX_Vgetexpps_ymm_k1z_ymmm256b32",
	"EVEX_Vgetexpps_zmm_k1z_zmmm512b32_sae",
	"EVEX_Vgetexppd_xmm_k1z_xmmm128b64",
	"EVEX_Vgetexppd_ymm_k1z_ymmm256b64",
	"EVEX_Vgetexppd_zmm_k1z_zmmm512b64_sae",
	"EVEX_Vgetexpss_xmm_k1z_xmm_xmmm32_sae",
	"EVEX_Vgetexpsd_xmm_k1z_xmm_xmmm64_sae",
	"EVEX_Vplzcntd_xmm_k1z_xmmm128b32",
	"EVEX_Vplzcntd_ymm_k1z_ymmm256b32",
	"EVEX_Vplzcntd_zmm_k1z_zmmm512b32",
	"EVEX_Vplzcntq_xmm_k1z_xmmm128b64",
	"EVEX_Vplzcntq_ymm_k1z_ymmm256b64",
	"EVEX_Vplzcntq_zmm_k1z_zmmm512b64",
	"VEX_Vpsrlvd_xmm_xmm_xmmm128",
	"VEX_Vpsrlvd_ymm_ymm_ymmm256",
	"VEX_Vpsrlvq_xmm_xmm_xmmm128",
	"VEX_Vpsrlvq_ymm_ymm_ymmm256",
	"EVEX_Vpsrlvd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpsrlvd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpsrlvd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpsrlvq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpsrlvq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpsrlvq_zmm_k1z_zmm_zmmm512b64",
	"VEX_Vpsravd_xmm_xmm_xmmm128",
	"VEX_Vpsravd_ymm_ymm_ymmm256",
	"EVEX_Vpsravd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpsravd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpsravd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpsravq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpsravq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpsravq_zmm_k1z_zmm_zmmm512b64",
	"VEX_Vpsllvd_xmm_xmm_xmmm128",
	"VEX_Vpsllvd_ymm_ymm_ymmm256",
	"VEX_Vpsllvq_xmm_xmm_xmmm128",
	"VEX_Vpsllvq_ymm_ymm_ymmm256",
	"EVEX_Vpsllvd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpsllvd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpsllvd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpsllvq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpsllvq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpsllvq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vrcp14ps_xmm_k1z_xmmm128b32",
	"EVEX_Vrcp14ps_ymm_k1z_ymmm256b32",
	"EVEX_Vrcp14ps_zmm_k1z_zmmm512b32",
	"EVEX_Vrcp14pd_xmm_k1z_xmmm128b64",
	"EVEX_Vrcp14pd_ymm_k1z_ymmm256b64",
	"EVEX_Vrcp14pd_zmm_k1z_zmmm512b64",
	"EVEX_Vrcp14ss_xmm_k1z_xmm_xmmm32",
	"EVEX_Vrcp14sd_xmm_k1z_xmm_xmmm64",
	"EVEX_Vrsqrt14ps_xmm_k1z_xmmm128b32",
	"EVEX_Vrsqrt14ps_ymm_k1z_ymmm256b32",
	"EVEX_Vrsqrt14ps_zmm_k1z_zmmm512b32",
	"EVEX_Vrsqrt14pd_xmm_k1z_xmmm128b64",
	"EVEX_Vrsqrt14pd_ymm_k1z_ymmm256b64",
	"EVEX_Vrsqrt14pd_zmm_k1z_zmmm512b64",
	"EVEX_Vrsqrt14ss_xmm_k1z_xmm_xmmm32",
	"EVEX_Vrsqrt14sd_xmm_k1z_xmm_xmmm64",
	"EVEX_Vpdpbusd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpdpbusd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpdpbusd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpdpbusds_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpdpbusds_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpdpbusds_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpdpwssd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpdpwssd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpdpwssd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vdpbf16ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vdpbf16ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vdpbf16ps_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vp4dpwssd_zmm_k1z_zmmp3_m128",
	"EVEX_Vpdpwssds_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpdpwssds_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpdpwssds_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vp4dpwssds_zmm_k1z_zmmp3_m128",
	"EVEX_Vpopcntb_xmm_k1z_xmmm128",
	"EVEX_Vpopcntb_ymm_k1z_ymmm256",
	"EVEX_Vpopcntb_zmm_k1z_zmmm512",
	"EVEX_Vpopcntw_xmm_k1z_xmmm128",
	"EVEX_Vpopcntw_ymm_k1z_ymmm256",
	"EVEX_Vpopcntw_zmm_k1z_zmmm512",
	"EVEX_Vpopcntd_xmm_k1z_xmmm128b32",
	"EVEX_Vpopcntd_ymm_k1z_ymmm256b32",
	"EVEX_Vpopcntd_zmm_k1z_zmmm512b32",
	"EVEX_Vpopcntq_xmm_k1z_xmmm128b64",
	"EVEX_Vpopcntq_ymm_k1z_ymmm256b64",
	"EVEX_Vpopcntq_zmm_k1z_zmmm512b64",
	"VEX_Vpbroadcastd_xmm_xmmm32",
	"VEX_Vpbroadcastd_ymm_xmmm32",
	"EVEX_Vpbroadcastd_xmm_k1z_xmmm32",
	"EVEX_Vpbroadcastd_ymm_k1z_xmmm32",
	"EVEX_Vpbroadcastd_zmm_k1z_xmmm32",
	"VEX_Vpbroadcastq_xmm_xmmm64",
	"VEX_Vpbroadcastq_ymm_xmmm64",
	"EVEX_Vbroadcasti32x2_xmm_k1z_xmmm64",
	"EVEX_Vbroadcasti32x2_ymm_k1z_xmmm64",
	"EVEX_Vbroadcasti32x2_zmm_k1z_xmmm64",
	"EVEX_Vpbroadcastq_xmm_k1z_xmmm64",
	"EVEX_Vpbroadcastq_ymm_k1z_xmmm64",
	"EVEX_Vpbroadcastq_zmm_k1z_xmmm64",
	"VEX_Vbroadcasti128_ymm_m128",
	"EVEX_Vbroadcasti32x4_ymm_k1z_m128",
	"EVEX_Vbroadcasti32x4_zmm_k1z_m128",
	"EVEX_Vbroadcasti64x2_ymm_k1z_m128",
	"EVEX_Vbroadcasti64x2_zmm_k1z_m128",
	"EVEX_Vbroadcasti32x8_zmm_k1z_m256",
	"EVEX_Vbroadcasti64x4_zmm_k1z_m256",
	"EVEX_Vpexpandb_xmm_k1z_xmmm128",
	"EVEX_Vpexpandb_ymm_k1z_ymmm256",
	"EVEX_Vpexpandb_zmm_k1z_zmmm512",
	"EVEX_Vpexpandw_xmm_k1z_xmmm128",
	"EVEX_Vpexpandw_ymm_k1z_ymmm256",
	"EVEX_Vpexpandw_zmm_k1z_zmmm512",
	"EVEX_Vpcompressb_xmmm128_k1z_xmm",
	"EVEX_Vpcompressb_ymmm256_k1z_ymm",
	"EVEX_Vpcompressb_zmmm512_k1z_zmm",
	"EVEX_Vpcompressw_xmmm128_k1z_xmm",
	"EVEX_Vpcompressw_ymmm256_k1z_ymm",
	"EVEX_Vpcompressw_zmmm512_k1z_zmm",
	"EVEX_Vpblendmd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpblendmd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpblendmd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpblendmq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpblendmq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpblendmq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vblendmps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vblendmps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vblendmps_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vblendmpd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vblendmpd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vblendmpd_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpblendmb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpblendmb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpblendmb_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpblendmw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpblendmw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpblendmw_zmm_k1z_zmm_zmmm512",
	"EVEX_Vp2intersectd_kp1_xmm_xmmm128b32",
	"EVEX_Vp2intersectd_kp1_ymm_ymmm256b32",
	"EVEX_Vp2intersectd_kp1_zmm_zmmm512b32",
	"EVEX_Vp2intersectq_kp1_xmm_xmmm128b64",
	"EVEX_Vp2intersectq_kp1_ymm_ymmm256b64",
	"EVEX_Vp2intersectq_kp1_zmm_zmmm512b64",
	"EVEX_Vpshldvw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpshldvw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpshldvw_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpshldvd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpshldvd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpshldvd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpshldvq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpshldvq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpshldvq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpshrdvw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpshrdvw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpshrdvw_zmm_k1z_zmm_zmmm512",
	"EVEX_Vcvtneps2bf16_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtneps2bf16_xmm_k1z_ymmm256b32",
	"EVEX_Vcvtneps2bf16_ymm_k1z_zmmm512b32",
	"EVEX_Vcvtne2ps2bf16_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vcvtne2ps2bf16_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vcvtne2ps2bf16_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpshrdvd_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpshrdvd_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpshrdvd_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpshrdvq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpshrdvq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpshrdvq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpermi2b_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpermi2b_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpermi2b_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpermi2w_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpermi2w_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpermi2w_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpermi2d_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpermi2d_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpermi2d_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpermi2q_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpermi2q_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpermi2q_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpermi2ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpermi2ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpermi2ps_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpermi2pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpermi2pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpermi2pd_zmm_k1z_zmm_zmmm512b64",
	"VEX_Vpbroadcastb_xmm_xmmm8",
	"VEX_Vpbroadcastb_ymm_xmmm8",
	"EVEX_Vpbroadcastb_xmm_k1z_xmmm8",
	"EVEX_Vpbroadcastb_ymm_k1z_xmmm8",
	"EVEX_Vpbroadcastb_zmm_k1z_xmmm8",
	"VEX_Vpbroadcastw_xmm_xmmm16",
	"VEX_Vpbroadcastw_ymm_xmmm16",
	"EVEX_Vpbroadcastw_xmm_k1z_xmmm16",
	"EVEX_Vpbroadcastw_ymm_k1z_xmmm16",
	"EVEX_Vpbroadcastw_zmm_k1z_xmmm16",
	"EVEX_Vpbroadcastb_xmm_k1z_r32",
	"EVEX_Vpbroadcastb_ymm_k1z_r32",
	"EVEX_Vpbroadcastb_zmm_k1z_r32",
	"EVEX_Vpbroadcastw_xmm_k1z_r32",
	"EVEX_Vpbroadcastw_ymm_k1z_r32",
	"EVEX_Vpbroadcastw_zmm_k1z_r32",
	"EVEX_Vpbroadcastd_xmm_k1z_r32",
	"EVEX_Vpbroadcastd_ymm_k1z_r32",
	"EVEX_Vpbroadcastd_zmm_k1z_r32",
	"EVEX_Vpbroadcastq_xmm_k1z_r64",
	"EVEX_Vpbroadcastq_ymm_k1z_r64",
	"EVEX_Vpbroadcastq_zmm_k1z_r64",
	"EVEX_Vpermt2b_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpermt2b_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpermt2b_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpermt2w_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpermt2w_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpermt2w_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpermt2d_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpermt2d_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpermt2d_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpermt2q_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpermt2q_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpermt2q_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpermt2ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vpermt2ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vpermt2ps_zmm_k1z_zmm_zmmm512b32",
	"EVEX_Vpermt2pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpermt2pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpermt2pd_zmm_k1z_zmm_zmmm512b64",
	"Invept_r32_m128",
	"Invept_r64_m128",
	"Invvpid_r32_m128",
	"Invvpid_r64_m128",
	"Invpcid_r32_m128",
	"Invpcid_r64_m128",
	"EVEX_Vpmultishiftqb_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmultishiftqb_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmultishiftqb_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vexpandps_xmm_k1z_xmmm128",
	"EVEX_Vexpandps_ymm_k1z_ymmm256",
	"EVEX_Vexpandps_zmm_k1z_zmmm512",
	"EVEX_Vexpandpd_xmm_k1z_xmmm128",
	"EVEX_Vexpandpd_ymm_k1z_ymmm256",
	"EVEX_Vexpandpd_zmm_k1z_zmmm512",
	"EVEX_Vpexpandd_xmm_k1z_xmmm128",
	"EVEX_Vpexpandd_ymm_k1z_ymmm256",
	"EVEX_Vpexpandd_zmm_k1z_zmmm512",
	"EVEX_Vpexpandq_xmm_k1z_xmmm128",
	"EVEX_Vpexpandq_ymm_k1z_ymmm256",
	"EVEX_Vpexpandq_zmm_k1z_zmmm512",
	"EVEX_Vcompressps_xmmm128_k1z_xmm",
	"EVEX_Vcompressps_ymmm256_k1z_ymm",
	"EVEX_Vcompressps_zmmm512_k1z_zmm",
	"EVEX_Vcompresspd_xmmm128_k1z_xmm",
	"EVEX_Vcompresspd_ymmm256_k1z_ymm",
	"EVEX_Vcompresspd_zmmm512_k1z_zmm",
	"EVEX_Vpcompressd_xmmm128_k1z_xmm",
	"EVEX_Vpcompressd_ymmm256_k1z_ymm",
	"EVEX_Vpcompressd_zmmm512_k1z_zmm",
	"EVEX_Vpcompressq_xmmm128_k1z_xmm",
	"EVEX_Vpcompressq_ymmm256_k1z_ymm",
	"EVEX_Vpcompressq_zmmm512_k1z_zmm",
	"VEX_Vpmaskmovd_xmm_xmm_m128",
	"VEX_Vpmaskmovd_ymm_ymm_m256",
	"VEX_Vpmaskmovq_xmm_xmm_m128",
	"VEX_Vpmaskmovq_ymm_ymm_m256",
	"EVEX_Vpermb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpermb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpermb_zmm_k1z_zmm_zmmm512",
	"EVEX_Vpermw_xmm_k1z_xmm_xmmm128",
	"EVEX_Vpermw_ymm_k1z_ymm_ymmm256",
	"EVEX_Vpermw_zmm_k1z_zmm_zmmm512",
	"VEX_Vpmaskmovd_m128_xmm_xmm",
	"VEX_Vpmaskmovd_m256_ymm_ymm",
	"VEX_Vpmaskmovq_m128_xmm_xmm",
	"VEX_Vpmaskmovq_m256_ymm_ymm",
	"EVEX_Vpshufbitqmb_kr_k1_xmm_xmmm128",
	"EVEX_Vpshufbitqmb_kr_k1_ymm_ymmm256",
	"EVEX_Vpshufbitqmb_kr_k1_zmm_zmmm512",
	"VEX_Vpgatherdd_xmm_vm32x_xmm",
	"VEX_Vpgatherdd_ymm_vm32y_ymm",
	"VEX_Vpgatherdq_xmm_vm32x_xmm",
	"VEX_Vpgatherdq_ymm_vm32x_ymm",
	"EVEX_Vpgatherdd_xmm_k1_vm32x",
	"EVEX_Vpgatherdd_ymm_k1_vm32y",
	"EVEX_Vpgatherdd_zmm_k1_vm32z",
	"EVEX_Vpgatherdq_xmm_k1_vm32x",
	"EVEX_Vpgatherdq_ymm_k1_vm32x",
	"EVEX_Vpgatherdq_zmm_k1_vm32y",
	"VEX_Vpgatherqd_xmm_vm64x_xmm",
	"VEX_Vpgatherqd_xmm_vm64y_xmm",
	"VEX_Vpgatherqq_xmm_vm64x_xmm",
	"VEX_Vpgatherqq_ymm_vm64y_ymm",
	"EVEX_Vpgatherqd_xmm_k1_vm64x",
	"EVEX_Vpgatherqd_xmm_k1_vm64y",
	"EVEX_Vpgatherqd_ymm_k1_vm64z",
	"EVEX_Vpgatherqq_xmm_k1_vm64x",
	"EVEX_Vpgatherqq_ymm_k1_vm64y",
	"EVEX_Vpgatherqq_zmm_k1_vm64z",
	"VEX_Vgatherdps_xmm_vm32x_xmm",
	"VEX_Vgatherdps_ymm_vm32y_ymm",
	"VEX_Vgatherdpd_xmm_vm32x_xmm",
	"VEX_Vgatherdpd_ymm_vm32x_ymm",
	"EVEX_Vgatherdps_xmm_k1_vm32x",
	"EVEX_Vgatherdps_ymm_k1_vm32y",
	"EVEX_Vgatherdps_zmm_k1_vm32z",
	"EVEX_Vgatherdpd_xmm_k1_vm32x",
	"EVEX_Vgatherdpd_ymm_k1_vm32x",
	"EVEX_Vgatherdpd_zmm_k1_vm32y",
	"VEX_Vgatherqps_xmm_vm64x_xmm",
	"VEX_Vgatherqps_xmm_vm64y_xmm",
	"VEX_Vgatherqpd_xmm_vm64x_xmm",
	"VEX_Vgatherqpd_ymm_vm64y_ymm",
	"EVEX_Vgatherqps_xmm_k1_vm64x",
	"EVEX_Vgatherqps_xmm_k1_vm64y",
	"EVEX_Vgatherqps_ymm_k1_vm64z",
	"EVEX_Vgatherqpd_xmm_k1_vm64x",
	"EVEX_Vgatherqpd_ymm_k1_vm64y",
	"EVEX_Vgatherqpd_zmm_k1_vm64z",
	"VEX_Vfmaddsub132ps_xmm_xmm_xmmm128",
	"VEX_Vfmaddsub132ps_ymm_ymm_ymmm256",
	"VEX_Vfmaddsub132pd_xmm_xmm_xmmm128",
	"VEX_Vfmaddsub132pd_ymm_ymm_ymmm256",
	"EVEX_Vfmaddsub132ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmaddsub132ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmaddsub132ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmaddsub132pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmaddsub132pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmaddsub132pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmsubadd132ps_xmm_xmm_xmmm128",
	"VEX_Vfmsubadd132ps_ymm_ymm_ymmm256",
	"VEX_Vfmsubadd132pd_xmm_xmm_xmmm128",
	"VEX_Vfmsubadd132pd_ymm_ymm_ymmm256",
	"EVEX_Vfmsubadd132ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmsubadd132ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmsubadd132ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmsubadd132pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmsubadd132pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmsubadd132pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmadd132ps_xmm_xmm_xmmm128",
	"VEX_Vfmadd132ps_ymm_ymm_ymmm256",
	"VEX_Vfmadd132pd_xmm_xmm_xmmm128",
	"VEX_Vfmadd132pd_ymm_ymm_ymmm256",
	"EVEX_Vfmadd132ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmadd132ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmadd132ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmadd132pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmadd132pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmadd132pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmadd132ss_xmm_xmm_xmmm32",
	"VEX_Vfmadd132sd_xmm_xmm_xmmm64",
	"EVEX_Vfmadd132ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmadd132sd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vfmsub132ps_xmm_xmm_xmmm128",
	"VEX_Vfmsub132ps_ymm_ymm_ymmm256",
	"VEX_Vfmsub132pd_xmm_xmm_xmmm128",
	"VEX_Vfmsub132pd_ymm_ymm_ymmm256",
	"EVEX_Vfmsub132ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmsub132ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmsub132ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmsub132pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmsub132pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmsub132pd_zmm_k1z_zmm_zmmm512b64_er",
	"EVEX_V4fmaddps_zmm_k1z_zmmp3_m128",
	"VEX_Vfmsub132ss_xmm_xmm_xmmm32",
	"VEX_Vfmsub132sd_xmm_xmm_xmmm64",
	"EVEX_Vfmsub132ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmsub132sd_xmm_k1z_xmm_xmmm64_er",
	"EVEX_V4fmaddss_xmm_k1z_xmmp3_m128",
	"VEX_Vfnmadd132ps_xmm_xmm_xmmm128",
	"VEX_Vfnmadd132ps_ymm_ymm_ymmm256",
	"VEX_Vfnmadd132pd_xmm_xmm_xmmm128",
	"VEX_Vfnmadd132pd_ymm_ymm_ymmm256",
	"EVEX_Vfnmadd132ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfnmadd132ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfnmadd132ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfnmadd132pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfnmadd132pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfnmadd132pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfnmadd132ss_xmm_xmm_xmmm32",
	"VEX_Vfnmadd132sd_xmm_xmm_xmmm64",
	"EVEX_Vfnmadd132ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfnmadd132sd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vfnmsub132ps_xmm_xmm_xmmm128",
	"VEX_Vfnmsub132ps_ymm_ymm_ymmm256",
	"VEX_Vfnmsub132pd_xmm_xmm_xmmm128",
	"VEX_Vfnmsub132pd_ymm_ymm_ymmm256",
	"EVEX_Vfnmsub132ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfnmsub132ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfnmsub132ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfnmsub132pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfnmsub132pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfnmsub132pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfnmsub132ss_xmm_xmm_xmmm32",
	"VEX_Vfnmsub132sd_xmm_xmm_xmmm64",
	"EVEX_Vfnmsub132ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfnmsub132sd_xmm_k1z_xmm_xmmm64_er",
	"EVEX_Vpscatterdd_vm32x_k1_xmm",
	"EVEX_Vpscatterdd_vm32y_k1_ymm",
	"EVEX_Vpscatterdd_vm32z_k1_zmm",
	"EVEX_Vpscatterdq_vm32x_k1_xmm",
	"EVEX_Vpscatterdq_vm32x_k1_ymm",
	"EVEX_Vpscatterdq_vm32y_k1_zmm",
	"EVEX_Vpscatterqd_vm64x_k1_xmm",
	"EVEX_Vpscatterqd_vm64y_k1_xmm",
	"EVEX_Vpscatterqd_vm64z_k1_ymm",
	"EVEX_Vpscatterqq_vm64x_k1_xmm",
	"EVEX_Vpscatterqq_vm64y_k1_ymm",
	"EVEX_Vpscatterqq_vm64z_k1_zmm",
	"EVEX_Vscatterdps_vm32x_k1_xmm",
	"EVEX_Vscatterdps_vm32y_k1_ymm",
	"EVEX_Vscatterdps_vm32z_k1_zmm",
	"EVEX_Vscatterdpd_vm32x_k1_xmm",
	"EVEX_Vscatterdpd_vm32x_k1_ymm",
	"EVEX_Vscatterdpd_vm32y_k1_zmm",
	"EVEX_Vscatterqps_vm64x_k1_xmm",
	"EVEX_Vscatterqps_vm64y_k1_xmm",
	"EVEX_Vscatterqps_vm64z_k1_ymm",
	"EVEX_Vscatterqpd_vm64x_k1_xmm",
	"EVEX_Vscatterqpd_vm64y_k1_ymm",
	"EVEX_Vscatterqpd_vm64z_k1_zmm",
	"VEX_Vfmaddsub213ps_xmm_xmm_xmmm128",
	"VEX_Vfmaddsub213ps_ymm_ymm_ymmm256",
	"VEX_Vfmaddsub213pd_xmm_xmm_xmmm128",
	"VEX_Vfmaddsub213pd_ymm_ymm_ymmm256",
	"EVEX_Vfmaddsub213ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmaddsub213ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmaddsub213ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmaddsub213pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmaddsub213pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmaddsub213pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmsubadd213ps_xmm_xmm_xmmm128",
	"VEX_Vfmsubadd213ps_ymm_ymm_ymmm256",
	"VEX_Vfmsubadd213pd_xmm_xmm_xmmm128",
	"VEX_Vfmsubadd213pd_ymm_ymm_ymmm256",
	"EVEX_Vfmsubadd213ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmsubadd213ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmsubadd213ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmsubadd213pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmsubadd213pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmsubadd213pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmadd213ps_xmm_xmm_xmmm128",
	"VEX_Vfmadd213ps_ymm_ymm_ymmm256",
	"VEX_Vfmadd213pd_xmm_xmm_xmmm128",
	"VEX_Vfmadd213pd_ymm_ymm_ymmm256",
	"EVEX_Vfmadd213ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmadd213ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmadd213ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmadd213pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmadd213pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmadd213pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmadd213ss_xmm_xmm_xmmm32",
	"VEX_Vfmadd213sd_xmm_xmm_xmmm64",
	"EVEX_Vfmadd213ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmadd213sd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vfmsub213ps_xmm_xmm_xmmm128",
	"VEX_Vfmsub213ps_ymm_ymm_ymmm256",
	"VEX_Vfmsub213pd_xmm_xmm_xmmm128",
	"VEX_Vfmsub213pd_ymm_ymm_ymmm256",
	"EVEX_Vfmsub213ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmsub213ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmsub213ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmsub213pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmsub213pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmsub213pd_zmm_k1z_zmm_zmmm512b64_er",
	"EVEX_V4fnmaddps_zmm_k1z_zmmp3_m128",
	"VEX_Vfmsub213ss_xmm_xmm_xmmm32",
	"VEX_Vfmsub213sd_xmm_xmm_xmmm64",
	"EVEX_Vfmsub213ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmsub213sd_xmm_k1z_xmm_xmmm64_er",
	"EVEX_V4fnmaddss_xmm_k1z_xmmp3_m128",
	"VEX_Vfnmadd213ps_xmm_xmm_xmmm128",
	"VEX_Vfnmadd213ps_ymm_ymm_ymmm256",
	"VEX_Vfnmadd213pd_xmm_xmm_xmmm128",
	"VEX_Vfnmadd213pd_ymm_ymm_ymmm256",
	"EVEX_Vfnmadd213ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfnmadd213ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfnmadd213ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfnmadd213pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfnmadd213pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfnmadd213pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfnmadd213ss_xmm_xmm_xmmm32",
	"VEX_Vfnmadd213sd_xmm_xmm_xmmm64",
	"EVEX_Vfnmadd213ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfnmadd213sd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vfnmsub213ps_xmm_xmm_xmmm128",
	"VEX_Vfnmsub213ps_ymm_ymm_ymmm256",
	"VEX_Vfnmsub213pd_xmm_xmm_xmmm128",
	"VEX_Vfnmsub213pd_ymm_ymm_ymmm256",
	"EVEX_Vfnmsub213ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfnmsub213ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfnmsub213ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfnmsub213pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfnmsub213pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfnmsub213pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfnmsub213ss_xmm_xmm_xmmm32",
	"VEX_Vfnmsub213sd_xmm_xmm_xmmm64",
	"EVEX_Vfnmsub213ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfnmsub213sd_xmm_k1z_xmm_xmmm64_er",
	"EVEX_Vpmadd52luq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmadd52luq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmadd52luq_zmm_k1z_zmm_zmmm512b64",
	"EVEX_Vpmadd52huq_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vpmadd52huq_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vpmadd52huq_zmm_k1z_zmm_zmmm512b64",
	"VEX_Vfmaddsub231ps_xmm_xmm_xmmm128",
	"VEX_Vfmaddsub231ps_ymm_ymm_ymmm256",
	"VEX_Vfmaddsub231pd_xmm_xmm_xmmm128",
	"VEX_Vfmaddsub231pd_ymm_ymm_ymmm256",
	"EVEX_Vfmaddsub231ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmaddsub231ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmaddsub231ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmaddsub231pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmaddsub231pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmaddsub231pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmsubadd231ps_xmm_xmm_xmmm128",
	"VEX_Vfmsubadd231ps_ymm_ymm_ymmm256",
	"VEX_Vfmsubadd231pd_xmm_xmm_xmmm128",
	"VEX_Vfmsubadd231pd_ymm_ymm_ymmm256",
	"EVEX_Vfmsubadd231ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmsubadd231ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmsubadd231ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmsubadd231pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmsubadd231pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmsubadd231pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmadd231ps_xmm_xmm_xmmm128",
	"VEX_Vfmadd231ps_ymm_ymm_ymmm256",
	"VEX_Vfmadd231pd_xmm_xmm_xmmm128",
	"VEX_Vfmadd231pd_ymm_ymm_ymmm256",
	"EVEX_Vfmadd231ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmadd231ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmadd231ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmadd231pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmadd231pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmadd231pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmadd231ss_xmm_xmm_xmmm32",
	"VEX_Vfmadd231sd_xmm_xmm_xmmm64",
	"EVEX_Vfmadd231ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmadd231sd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vfmsub231ps_xmm_xmm_xmmm128",
	"VEX_Vfmsub231ps_ymm_ymm_ymmm256",
	"VEX_Vfmsub231pd_xmm_xmm_xmmm128",
	"VEX_Vfmsub231pd_ymm_ymm_ymmm256",
	"EVEX_Vfmsub231ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmsub231ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmsub231ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmsub231pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfmsub231pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfmsub231pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfmsub231ss_xmm_xmm_xmmm32",
	"VEX_Vfmsub231sd_xmm_xmm_xmmm64",
	"EVEX_Vfmsub231ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmsub231sd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vfnmadd231ps_xmm_xmm_xmmm128",
	"VEX_Vfnmadd231ps_ymm_ymm_ymmm256",
	"VEX_Vfnmadd231pd_xmm_xmm_xmmm128",
	"VEX_Vfnmadd231pd_ymm_ymm_ymmm256",
	"EVEX_Vfnmadd231ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfnmadd231ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfnmadd231ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfnmadd231pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfnmadd231pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfnmadd231pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfnmadd231ss_xmm_xmm_xmmm32",
	"VEX_Vfnmadd231sd_xmm_xmm_xmmm64",
	"EVEX_Vfnmadd231ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfnmadd231sd_xmm_k1z_xmm_xmmm64_er",
	"VEX_Vfnmsub231ps_xmm_xmm_xmmm128",
	"VEX_Vfnmsub231ps_ymm_ymm_ymmm256",
	"VEX_Vfnmsub231pd_xmm_xmm_xmmm128",
	"VEX_Vfnmsub231pd_ymm_ymm_ymmm256",
	"EVEX_Vfnmsub231ps_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfnmsub231ps_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfnmsub231ps_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfnmsub231pd_xmm_k1z_xmm_xmmm128b64",
	"EVEX_Vfnmsub231pd_ymm_k1z_ymm_ymmm256b64",
	"EVEX_Vfnmsub231pd_zmm_k1z_zmm_zmmm512b64_er",
	"VEX_Vfnmsub231ss_xmm_xmm_xmmm32",
	"VEX_Vfnmsub231sd_xmm_xmm_xmmm64",
	"EVEX_Vfnmsub231ss_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfnmsub231sd_xmm_k1z_xmm_xmmm64_er",
	"EVEX_Vpconflictd_xmm_k1z_xmmm128b32",
	"EVEX_Vpconflictd_ymm_k1z_ymmm256b32",
	"EVEX_Vpconflictd_zmm_k1z_zmmm512b32",
	"EVEX_Vpconflictq_xmm_k1z_xmmm128b64",
	"EVEX_Vpconflictq_ymm_k1z_ymmm256b64",
	"EVEX_Vpconflictq_zmm_k1z_zmmm512b64",
	"EVEX_Vgatherpf0dps_vm32z_k1",
	"EVEX_Vgatherpf0dpd_vm32y_k1",
	"EVEX_Vgatherpf1dps_vm32z_k1",
	"EVEX_Vgatherpf1dpd_vm32y_k1",
	"EVEX_Vscatterpf0dps_vm32z_k1",
	"EVEX_Vscatterpf0dpd_vm32y_k1",
	"EVEX_Vscatterpf1dps_vm32z_k1",
	"EVEX_Vscatterpf1dpd_vm32y_k1",
	"EVEX_Vgatherpf0qps_vm64z_k1",
	"EVEX_Vgatherpf0qpd_vm64z_k1",
	"EVEX_Vgatherpf1qps_vm64z_k1",
	"EVEX_Vgatherpf1qpd_vm64z_k1",
	"EVEX_Vscatterpf0qps_vm64z_k1",
	"EVEX_Vscatterpf0qpd_vm64z_k1",
	"EVEX_Vscatterpf1qps_vm64z_k1",
	"EVEX_Vscatterpf1qpd_vm64z_k1",
	"Sha1nexte_xmm_xmmm128",
	"EVEX_Vexp2ps_zmm_k1z_zmmm512b32_sae",
	"EVEX_Vexp2pd_zmm_k1z_zmmm512b64_sae",
	"Sha1msg1_xmm_xmmm128",
	"Sha1msg2_xmm_xmmm128",
	"EVEX_Vrcp28ps_zmm_k1z_zmmm512b32_sae",
	"EVEX_Vrcp28pd_zmm_k1z_zmmm512b64_sae",
	"Sha256rnds2_xmm_xmmm128",
	"EVEX_Vrcp28ss_xmm_k1z_xmm_xmmm32_sae",
	"EVEX_Vrcp28sd_xmm_k1z_xmm_xmmm64_sae",
	"Sha256msg1_xmm_xmmm128",
	"EVEX_Vrsqrt28ps_zmm_k1z_zmmm512b32_sae",
	"EVEX_Vrsqrt28pd_zmm_k1z_zmmm512b64_sae",
	"Sha256msg2_xmm_xmmm128",
	"EVEX_Vrsqrt28ss_xmm_k1z_xmm_xmmm32_sae",
	"EVEX_Vrsqrt28sd_xmm_k1z_xmm_xmmm64_sae",
	"Gf2p8mulb_xmm_xmmm128",
	"VEX_Vgf2p8mulb_xmm_xmm_xmmm128",
	"VEX_Vgf2p8mulb_ymm_ymm_ymmm256",
	"EVEX_Vgf2p8mulb_xmm_k1z_xmm_xmmm128",
	"EVEX_Vgf2p8mulb_ymm_k1z_ymm_ymmm256",
	"EVEX_Vgf2p8mulb_zmm_k1z_zmm_zmmm512",
	"Aesimc_xmm_xmmm128",
	"VEX_Vaesimc_xmm_xmmm128",
	"Aesenc_xmm_xmmm128",
	"VEX_Vaesenc_xmm_xmm_xmmm128",
	"VEX_Vaesenc_ymm_ymm_ymmm256",
	"EVEX_Vaesenc_xmm_xmm_xmmm128",
	"EVEX_Vaesenc_ymm_ymm_ymmm256",
	"EVEX_Vaesenc_zmm_zmm_zmmm512",
	"Aesenclast_xmm_xmmm128",
	"VEX_Vaesenclast_xmm_xmm_xmmm128",
	"VEX_Vaesenclast_ymm_ymm_ymmm256",
	"EVEX_Vaesenclast_xmm_xmm_xmmm128",
	"EVEX_Vaesenclast_ymm_ymm_ymmm256",
	"EVEX_Vaesenclast_zmm_zmm_zmmm512",
	"Aesdec_xmm_xmmm128",
	"VEX_Vaesdec_xmm_xmm_xmmm128",
	"VEX_Vaesdec_ymm_ymm_ymmm256",
	"EVEX_Vaesdec_xmm_xmm_xmmm128",
	"EVEX_Vaesdec_ymm_ymm_ymmm256",
	"EVEX_Vaesdec_zmm_zmm_zmmm512",
	"Aesdeclast_xmm_xmmm128",
	"VEX_Vaesdeclast_xmm_xmm_xmmm128",
	"VEX_Vaesdeclast_ymm_ymm_ymmm256",
	"EVEX_Vaesdeclast_xmm_xmm_xmmm128",
	"EVEX_Vaesdeclast_ymm_ymm_ymmm256",
	"EVEX_Vaesdeclast_zmm_zmm_zmmm512",
	"Movbe_r16_m16",
	"Movbe_r32_m32",
	"Movbe_r64_m64",
	"Crc32_r32_rm8",
	"Crc32_r64_rm8",
	"Movbe_m16_r16",
	"Movbe_m32_r32",
	"Movbe_m64_r64",
	"Crc32_r32_rm16",
	"Crc32_r32_rm32",
	"Crc32_r64_rm64",
	"VEX_Andn_r32_r32_rm32",
	"VEX_Andn_r64_r64_rm64",
	"VEX_Blsr_r32_rm32",
	"VEX_Blsr_r64_rm64",
	"VEX_Blsmsk_r32_rm32",
	"VEX_Blsmsk_r64_rm64",
	"VEX_Blsi_r32_rm32",
	"VEX_Blsi_r64_rm64",
	"VEX_Bzhi_r32_rm32_r32",
	"VEX_Bzhi_r64_rm64_r64",
	"Wrussd_m32_r32",
	"Wrussq_m64_r64",
	"VEX_Pext_r32_r32_rm32",
	"VEX_Pext_r64_r64_rm64",
	"VEX_Pdep_r32_r32_rm32",
	"VEX_Pdep_r64_r64_rm64",
	"Wrssd_m32_r32",
	"Wrssq_m64_r64",
	"Adcx_r32_rm32",
	"Adcx_r64_rm64",
	"Adox_r32_rm32",
	"Adox_r64_rm64",
	"VEX_Mulx_r32_r32_rm32",
	"VEX_Mulx_r64_r64_rm64",
	"VEX_Bextr_r32_rm32_r32",
	"VEX_Bextr_r64_rm64_r64",
	"VEX_Shlx_r32_rm32_r32",
	"VEX_Shlx_r64_rm64_r64",
	"VEX_Sarx_r32_rm32_r32",
	"VEX_Sarx_r64_rm64_r64",
	"VEX_Shrx_r32_rm32_r32",
	"VEX_Shrx_r64_rm64_r64",
	"Movdir64b_r16_m512",
	"Movdir64b_r32_m512",
	"Movdir64b_r64_m512",
	"Enqcmds_r16_m512",
	"Enqcmds_r32_m512",
	"Enqcmds_r64_m512",
	"Enqcmd_r16_m512",
	"Enqcmd_r32_m512",
	"Enqcmd_r64_m512",
	"Movdiri_m32_r32",
	"Movdiri_m64_r64",
	"VEX_Vpermq_ymm_ymmm256_imm8",
	"EVEX_Vpermq_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vpermq_zmm_k1z_zmmm512b64_imm8",
	"VEX_Vpermpd_ymm_ymmm256_imm8",
	"EVEX_Vpermpd_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vpermpd_zmm_k1z_zmmm512b64_imm8",
	"VEX_Vpblendd_xmm_xmm_xmmm128_imm8",
	"VEX_Vpblendd_ymm_ymm_ymmm256_imm8",
	"EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8",
	"EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8",
	"EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8",
	"VEX_Vpermilps_xmm_xmmm128_imm8",
	"VEX_Vpermilps_ymm_ymmm256_imm8",
	"EVEX_Vpermilps_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vpermilps_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vpermilps_zmm_k1z_zmmm512b32_imm8",
	"VEX_Vpermilpd_xmm_xmmm128_imm8",
	"VEX_Vpermilpd_ymm_ymmm256_imm8",
	"EVEX_Vpermilpd_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vpermilpd_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vpermilpd_zmm_k1z_zmmm512b64_imm8",
	"VEX_Vperm2f128_ymm_ymm_ymmm256_imm8",
	"Roundps_xmm_xmmm128_imm8",
	"VEX_Vroundps_xmm_xmmm128_imm8",
	"VEX_Vroundps_ymm_ymmm256_imm8",
	"EVEX_Vrndscaleps_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vrndscaleps_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vrndscaleps_zmm_k1z_zmmm512b32_imm8_sae",
	"Roundpd_xmm_xmmm128_imm8",
	"VEX_Vroundpd_xmm_xmmm128_imm8",
	"VEX_Vroundpd_ymm_ymmm256_imm8",
	"EVEX_Vrndscalepd_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vrndscalepd_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vrndscalepd_zmm_k1z_zmmm512b64_imm8_sae",
	"Roundss_xmm_xmmm32_imm8",
	"VEX_Vroundss_xmm_xmm_xmmm32_imm8",
	"EVEX_Vrndscaless_xmm_k1z_xmm_xmmm32_imm8_sae",
	"Roundsd_xmm_xmmm64_imm8",
	"VEX_Vroundsd_xmm_xmm_xmmm64_imm8",
	"EVEX_Vrndscalesd_xmm_k1z_xmm_xmmm64_imm8_sae",
	"Blendps_xmm_xmmm128_imm8",
	"VEX_Vblendps_xmm_xmm_xmmm128_imm8",
	"VEX_Vblendps_ymm_ymm_ymmm256_imm8",
	"Blendpd_xmm_xmmm128_imm8",
	"VEX_Vblendpd_xmm_xmm_xmmm128_imm8",
	"VEX_Vblendpd_ymm_ymm_ymmm256_imm8",
	"Pblendw_xmm_xmmm128_imm8",
	"VEX_Vpblendw_xmm_xmm_xmmm128_imm8",
	"VEX_Vpblendw_ymm_ymm_ymmm256_imm8",
	"Palignr_mm_mmm64_imm8",
	"Palignr_xmm_xmmm128_imm8",
	"VEX_Vpalignr_xmm_xmm_xmmm128_imm8",
	"VEX_Vpalignr_ymm_ymm_ymmm256_imm8",
	"EVEX_Vpalignr_xmm_k1z_xmm_xmmm128_imm8",
	"EVEX_Vpalignr_ymm_k1z_ymm_ymmm256_imm8",
	"EVEX_Vpalignr_zmm_k1z_zmm_zmmm512_imm8",
	"Pextrb_r32m8_xmm_imm8",
	"Pextrb_r64m8_xmm_imm8",
	"VEX_Vpextrb_r32m8_xmm_imm8",
	"VEX_Vpextrb_r64m8_xmm_imm8",
	"EVEX_Vpextrb_r32m8_xmm_imm8",
	"EVEX_Vpextrb_r64m8_xmm_imm8",
	"Pextrw_r32m16_xmm_imm8",
	"Pextrw_r64m16_xmm_imm8",
	"VEX_Vpextrw_r32m16_xmm_imm8",
	"VEX_Vpextrw_r64m16_xmm_imm8",
	"EVEX_Vpextrw_r32m16_xmm_imm8",
	"EVEX_Vpextrw_r64m16_xmm_imm8",
	"Pextrd_rm32_xmm_imm8",
	"Pextrq_rm64_xmm_imm8",
	"VEX_Vpextrd_rm32_xmm_imm8",
	"VEX_Vpextrq_rm64_xmm_imm8",
	"EVEX_Vpextrd_rm32_xmm_imm8",
	"EVEX_Vpextrq_rm64_xmm_imm8",
	"Extractps_rm32_xmm_imm8",
	"Extractps_r64m32_xmm_imm8",
	"VEX_Vextractps_rm32_xmm_imm8",
	"VEX_Vextractps_r64m32_xmm_imm8",
	"EVEX_Vextractps_rm32_xmm_imm8",
	"EVEX_Vextractps_r64m32_xmm_imm8",
	"VEX_Vinsertf128_ymm_ymm_xmmm128_imm8",
	"EVEX_Vinsertf32x4_ymm_k1z_ymm_xmmm128_imm8",
	"EVEX_Vinsertf32x4_zmm_k1z_zmm_xmmm128_imm8",
	"EVEX_Vinsertf64x2_ymm_k1z_ymm_xmmm128_imm8",
	"EVEX_Vinsertf64x2_zmm_k1z_zmm_xmmm128_imm8",
	"VEX_Vextractf128_xmmm128_ymm_imm8",
	"EVEX_Vextractf32x4_xmmm128_k1z_ymm_imm8",
	"EVEX_Vextractf32x4_xmmm128_k1z_zmm_imm8",
	"EVEX_Vextractf64x2_xmmm128_k1z_ymm_imm8",
	"EVEX_Vextractf64x2_xmmm128_k1z_zmm_imm8",
	"EVEX_Vinsertf32x8_zmm_k1z_zmm_ymmm256_imm8",
	"EVEX_Vinsertf64x4_zmm_k1z_zmm_ymmm256_imm8",
	"EVEX_Vextractf32x8_ymmm256_k1z_zmm_imm8",
	"EVEX_Vextractf64x4_ymmm256_k1z_zmm_imm8",
	"VEX_Vcvtps2ph_xmmm64_xmm_imm8",
	"VEX_Vcvtps2ph_xmmm128_ymm_imm8",
	"EVEX_Vcvtps2ph_xmmm64_k1z_xmm_imm8",
	"EVEX_Vcvtps2ph_xmmm128_k1z_ymm_imm8",
	"EVEX_Vcvtps2ph_ymmm256_k1z_zmm_imm8_sae",
	"EVEX_Vpcmpud_kr_k1_xmm_xmmm128b32_imm8",
	"EVEX_Vpcmpud_kr_k1_ymm_ymmm256b32_imm8",
	"EVEX_Vpcmpud_kr_k1_zmm_zmmm512b32_imm8",
	"EVEX_Vpcmpuq_kr_k1_xmm_xmmm128b64_imm8",
	"EVEX_Vpcmpuq_kr_k1_ymm_ymmm256b64_imm8",
	"EVEX_Vpcmpuq_kr_k1_zmm_zmmm512b64_imm8",
	"EVEX_Vpcmpd_kr_k1_xmm_xmmm128b32_imm8",
	"EVEX_Vpcmpd_kr_k1_ymm_ymmm256b32_imm8",
	"EVEX_Vpcmpd_kr_k1_zmm_zmmm512b32_imm8",
	"EVEX_Vpcmpq_kr_k1_xmm_xmmm128b64_imm8",
	"EVEX_Vpcmpq_kr_k1_ymm_ymmm256b64_imm8",
	"EVEX_Vpcmpq_kr_k1_zmm_zmmm512b64_imm8",
	"Pinsrb_xmm_r32m8_imm8",
	"Pinsrb_xmm_r64m8_imm8",
	"VEX_Vpinsrb_xmm_xmm_r32m8_imm8",
	"VEX_Vpinsrb_xmm_xmm_r64m8_imm8",
	"EVEX_Vpinsrb_xmm_xmm_r32m8_imm8",
	"EVEX_Vpinsrb_xmm_xmm_r64m8_imm8",
	"Insertps_xmm_xmmm32_imm8",
	"VEX_Vinsertps_xmm_xmm_xmmm32_imm8",
	"EVEX_Vinsertps_xmm_xmm_xmmm32_imm8",
	"Pinsrd_xmm_rm32_imm8",
	"Pinsrq_xmm_rm64_imm8",
	"VEX_Vpinsrd_xmm_xmm_rm32_imm8",
	"VEX_Vpinsrq_xmm_xmm_rm64_imm8",
	"EVEX_Vpinsrd_xmm_xmm_rm32_imm8",
	"EVEX_Vpinsrq_xmm_xmm_rm64_imm8",
	"EVEX_Vshuff32x4_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vshuff32x4_zmm_k1z_zmm_zmmm512b32_imm8",
	"EVEX_Vshuff64x2_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vshuff64x2_zmm_k1z_zmm_zmmm512b64_imm8",
	"EVEX_Vpternlogd_xmm_k1z_xmm_xmmm128b32_imm8",
	"EVEX_Vpternlogd_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vpternlogd_zmm_k1z_zmm_zmmm512b32_imm8",
	"EVEX_Vpternlogq_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vpternlogq_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vpternlogq_zmm_k1z_zmm_zmmm512b64_imm8",
	"EVEX_Vgetmantps_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vgetmantps_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vgetmantps_zmm_k1z_zmmm512b32_imm8_sae",
	"EVEX_Vgetmantpd_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vgetmantpd_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vgetmantpd_zmm_k1z_zmmm512b64_imm8_sae",
	"EVEX_Vgetmantss_xmm_k1z_xmm_xmmm32_imm8_sae",
	"EVEX_Vgetmantsd_xmm_k1z_xmm_xmmm64_imm8_sae",
	"VEX_Kshiftrb_kr_kr_imm8",
	"VEX_Kshiftrw_kr_kr_imm8",
	"VEX_Kshiftrd_kr_kr_imm8",
	"VEX_Kshiftrq_kr_kr_imm8",
	"VEX_Kshiftlb_kr_kr_imm8",
	"VEX_Kshiftlw_kr_kr_imm8",
	"VEX_Kshiftld_kr_kr_imm8",
	"VEX_Kshiftlq_kr_kr_imm8",
	"VEX_Vinserti128_ymm_ymm_xmmm128_imm8",
	"EVEX_Vinserti32x4_ymm_k1z_ymm_xmmm128_imm8",
	"EVEX_Vinserti32x4_zmm_k1z_zmm_xmmm128_imm8",
	"EVEX_Vinserti64x2_ymm_k1z_ymm_xmmm128_imm8",
	"EVEX_Vinserti64x2_zmm_k1z_zmm_xmmm128_imm8",
	"VEX_Vextracti128_xmmm128_ymm_imm8",
	"EVEX_Vextracti32x4_xmmm128_k1z_ymm_imm8",
	"EVEX_Vextracti32x4_xmmm128_k1z_zmm_imm8",
	"EVEX_Vextracti64x2_xmmm128_k1z_ymm_imm8",
	"EVEX_Vextracti64x2_xmmm128_k1z_zmm_imm8",
	"EVEX_Vinserti32x8_zmm_k1z_zmm_ymmm256_imm8",
	"EVEX_Vinserti64x4_zmm_k1z_zmm_ymmm256_imm8",
	"EVEX_Vextracti32x8_ymmm256_k1z_zmm_imm8",
	"EVEX_Vextracti64x4_ymmm256_k1z_zmm_imm8",
	"EVEX_Vpcmpub_kr_k1_xmm_xmmm128_imm8",
	"EVEX_Vpcmpub_kr_k1_ymm_ymmm256_imm8",
	"EVEX_Vpcmpub_kr_k1_zmm_zmmm512_imm8",
	"EVEX_Vpcmpuw_kr_k1_xmm_xmmm128_imm8",
	"EVEX_Vpcmpuw_kr_k1_ymm_ymmm256_imm8",
	"EVEX_Vpcmpuw_kr_k1_zmm_zmmm512_imm8",
	"EVEX_Vpcmpb_kr_k1_xmm_xmmm128_imm8",
	"EVEX_Vpcmpb_kr_k1_ymm_ymmm256_imm8",
	"EVEX_Vpcmpb_kr_k1_zmm_zmmm512_imm8",
	"EVEX_Vpcmpw_kr_k1_xmm_xmmm128_imm8",
	"EVEX_Vpcmpw_kr_k1_ymm_ymmm256_imm8",
	"EVEX_Vpcmpw_kr_k1_zmm_zmmm512_imm8",
	"Dpps_xmm_xmmm128_imm8",
	"VEX_Vdpps_xmm_xmm_xmmm128_imm8",
	"VEX_Vdpps_ymm_ymm_ymmm256_imm8",
	"Dppd_xmm_xmmm128_imm8",
	"VEX_Vdppd_xmm_xmm_xmmm128_imm8",
	"Mpsadbw_xmm_xmmm128_imm8",
	"VEX_Vmpsadbw_xmm_xmm_xmmm128_imm8",
	"VEX_Vmpsadbw_ymm_ymm_ymmm256_imm8",
	"EVEX_Vdbpsadbw_xmm_k1z_xmm_xmmm128_imm8",
	"EVEX_Vdbpsadbw_ymm_k1z_ymm_ymmm256_imm8",
	"EVEX_Vdbpsadbw_zmm_k1z_zmm_zmmm512_imm8",
	"EVEX_Vshufi32x4_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vshufi32x4_zmm_k1z_zmm_zmmm512b32_imm8",
	"EVEX_Vshufi64x2_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vshufi64x2_zmm_k1z_zmm_zmmm512b64_imm8",
	"Pclmulqdq_xmm_xmmm128_imm8",
	"VEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8",
	"VEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8",
	"EVEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8",
	"EVEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8",
	"EVEX_Vpclmulqdq_zmm_zmm_zmmm512_imm8",
	"VEX_Vperm2i128_ymm_ymm_ymmm256_imm8",
	"VEX_Vpermil2ps_xmm_xmm_xmmm128_xmm_imm4",
	"VEX_Vpermil2ps_ymm_ymm_ymmm256_ymm_imm4",
	"VEX_Vpermil2ps_xmm_xmm_xmm_xmmm128_imm4",
	"VEX_Vpermil2ps_ymm_ymm_ymm_ymmm256_imm4",
	"VEX_Vpermil2pd_xmm_xmm_xmmm128_xmm_imm4",
	"VEX_Vpermil2pd_ymm_ymm_ymmm256_ymm_imm4",
	"VEX_Vpermil2pd_xmm_xmm_xmm_xmmm128_imm4",
	"VEX_Vpermil2pd_ymm_ymm_ymm_ymmm256_imm4",
	"VEX_Vblendvps_xmm_xmm_xmmm128_xmm",
	"VEX_Vblendvps_ymm_ymm_ymmm256_ymm",
	"VEX_Vblendvpd_xmm_xmm_xmmm128_xmm",
	"VEX_Vblendvpd_ymm_ymm_ymmm256_ymm",
	"VEX_Vpblendvb_xmm_xmm_xmmm128_xmm",
	"VEX_Vpblendvb_ymm_ymm_ymmm256_ymm",
	"EVEX_Vrangeps_xmm_k1z_xmm_xmmm128b32_imm8",
	"EVEX_Vrangeps_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vrangeps_zmm_k1z_zmm_zmmm512b32_imm8_sae",
	"EVEX_Vrangepd_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vrangepd_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vrangepd_zmm_k1z_zmm_zmmm512b64_imm8_sae",
	"EVEX_Vrangess_xmm_k1z_xmm_xmmm32_imm8_sae",
	"EVEX_Vrangesd_xmm_k1z_xmm_xmmm64_imm8_sae",
	"EVEX_Vfixupimmps_xmm_k1z_xmm_xmmm128b32_imm8",
	"EVEX_Vfixupimmps_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vfixupimmps_zmm_k1z_zmm_zmmm512b32_imm8_sae",
	"EVEX_Vfixupimmpd_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vfixupimmpd_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vfixupimmpd_zmm_k1z_zmm_zmmm512b64_imm8_sae",
	"EVEX_Vfixupimmss_xmm_k1z_xmm_xmmm32_imm8_sae",
	"EVEX_Vfixupimmsd_xmm_k1z_xmm_xmmm64_imm8_sae",
	"EVEX_Vreduceps_xmm_k1z_xmmm128b32_imm8",
	"EVEX_Vreduceps_ymm_k1z_ymmm256b32_imm8",
	"EVEX_Vreduceps_zmm_k1z_zmmm512b32_imm8_sae",
	"EVEX_Vreducepd_xmm_k1z_xmmm128b64_imm8",
	"EVEX_Vreducepd_ymm_k1z_ymmm256b64_imm8",
	"EVEX_Vreducepd_zmm_k1z_zmmm512b64_imm8_sae",
	"EVEX_Vreducess_xmm_k1z_xmm_xmmm32_imm8_sae",
	"EVEX_Vreducesd_xmm_k1z_xmm_xmmm64_imm8_sae",
	"VEX_Vfmaddsubps_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmaddsubps_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmaddsubps_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmaddsubps_ymm_ymm_ymm_ymmm256",
	"VEX_Vfmaddsubpd_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmaddsubpd_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmaddsubpd_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmaddsubpd_ymm_ymm_ymm_ymmm256",
	"VEX_Vfmsubaddps_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmsubaddps_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmsubaddps_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmsubaddps_ymm_ymm_ymm_ymmm256",
	"VEX_Vfmsubaddpd_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmsubaddpd_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmsubaddpd_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmsubaddpd_ymm_ymm_ymm_ymmm256",
	"Pcmpestrm_xmm_xmmm128_imm8",
	"Pcmpestrm64_xmm_xmmm128_imm8",
	"VEX_Vpcmpestrm_xmm_xmmm128_imm8",
	"VEX_Vpcmpestrm64_xmm_xmmm128_imm8",
	"Pcmpestri_xmm_xmmm128_imm8",
	"Pcmpestri64_xmm_xmmm128_imm8",
	"VEX_Vpcmpestri_xmm_xmmm128_imm8",
	"VEX_Vpcmpestri64_xmm_xmmm128_imm8",
	"Pcmpistrm_xmm_xmmm128_imm8",
	"VEX_Vpcmpistrm_xmm_xmmm128_imm8",
	"Pcmpistri_xmm_xmmm128_imm8",
	"VEX_Vpcmpistri_xmm_xmmm128_imm8",
	"EVEX_Vfpclassps_kr_k1_xmmm128b32_imm8",
	"EVEX_Vfpclassps_kr_k1_ymmm256b32_imm8",
	"EVEX_Vfpclassps_kr_k1_zmmm512b32_imm8",
	"EVEX_Vfpclasspd_kr_k1_xmmm128b64_imm8",
	"EVEX_Vfpclasspd_kr_k1_ymmm256b64_imm8",
	"EVEX_Vfpclasspd_kr_k1_zmmm512b64_imm8",
	"EVEX_Vfpclassss_kr_k1_xmmm32_imm8",
	"EVEX_Vfpclasssd_kr_k1_xmmm64_imm8",
	"VEX_Vfmaddps_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmaddps_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmaddps_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmaddps_ymm_ymm_ymm_ymmm256",
	"VEX_Vfmaddpd_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmaddpd_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmaddpd_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmaddpd_ymm_ymm_ymm_ymmm256",
	"VEX_Vfmaddss_xmm_xmm_xmmm32_xmm",
	"VEX_Vfmaddss_xmm_xmm_xmm_xmmm32",
	"VEX_Vfmaddsd_xmm_xmm_xmmm64_xmm",
	"VEX_Vfmaddsd_xmm_xmm_xmm_xmmm64",
	"VEX_Vfmsubps_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmsubps_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmsubps_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmsubps_ymm_ymm_ymm_ymmm256",
	"VEX_Vfmsubpd_xmm_xmm_xmmm128_xmm",
	"VEX_Vfmsubpd_ymm_ymm_ymmm256_ymm",
	"VEX_Vfmsubpd_xmm_xmm_xmm_xmmm128",
	"VEX_Vfmsubpd_ymm_ymm_ymm_ymmm256",
	"VEX_Vfmsubss_xmm_xmm_xmmm32_xmm",
	"VEX_Vfmsubss_xmm_xmm_xmm_xmmm32",
	"VEX_Vfmsubsd_xmm_xmm_xmmm64_xmm",
	"VEX_Vfmsubsd_xmm_xmm_xmm_xmmm64",
	"EVEX_Vpshldw_xmm_k1z_xmm_xmmm128_imm8",
	"EVEX_Vpshldw_ymm_k1z_ymm_ymmm256_imm8",
	"EVEX_Vpshldw_zmm_k1z_zmm_zmmm512_imm8",
	"EVEX_Vpshldd_xmm_k1z_xmm_xmmm128b32_imm8",
	"EVEX_Vpshldd_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vpshldd_zmm_k1z_zmm_zmmm512b32_imm8",
	"EVEX_Vpshldq_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vpshldq_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vpshldq_zmm_k1z_zmm_zmmm512b64_imm8",
	"EVEX_Vpshrdw_xmm_k1z_xmm_xmmm128_imm8",
	"EVEX_Vpshrdw_ymm_k1z_ymm_ymmm256_imm8",
	"EVEX_Vpshrdw_zmm_k1z_zmm_zmmm512_imm8",
	"EVEX_Vpshrdd_xmm_k1z_xmm_xmmm128b32_imm8",
	"EVEX_Vpshrdd_ymm_k1z_ymm_ymmm256b32_imm8",
	"EVEX_Vpshrdd_zmm_k1z_zmm_zmmm512b32_imm8",
	"EVEX_Vpshrdq_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vpshrdq_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vpshrdq_zmm_k1z_zmm_zmmm512b64_imm8",
	"VEX_Vfnmaddps_xmm_xmm_xmmm128_xmm",
	"VEX_Vfnmaddps_ymm_ymm_ymmm256_ymm",
	"VEX_Vfnmaddps_xmm_xmm_xmm_xmmm128",
	"VEX_Vfnmaddps_ymm_ymm_ymm_ymmm256",
	"VEX_Vfnmaddpd_xmm_xmm_xmmm128_xmm",
	"VEX_Vfnmaddpd_ymm_ymm_ymmm256_ymm",
	"VEX_Vfnmaddpd_xmm_xmm_xmm_xmmm128",
	"VEX_Vfnmaddpd_ymm_ymm_ymm_ymmm256",
	"VEX_Vfnmaddss_xmm_xmm_xmmm32_xmm",
	"VEX_Vfnmaddss_xmm_xmm_xmm_xmmm32",
	"VEX_Vfnmaddsd_xmm_xmm_xmmm64_xmm",
	"VEX_Vfnmaddsd_xmm_xmm_xmm_xmmm64",
	"VEX_Vfnmsubps_xmm_xmm_xmmm128_xmm",
	"VEX_Vfnmsubps_ymm_ymm_ymmm256_ymm",
	"VEX_Vfnmsubps_xmm_xmm_xmm_xmmm128",
	"VEX_Vfnmsubps_ymm_ymm_ymm_ymmm256",
	"VEX_Vfnmsubpd_xmm_xmm_xmmm128_xmm",
	"VEX_Vfnmsubpd_ymm_ymm_ymmm256_ymm",
	"VEX_Vfnmsubpd_xmm_xmm_xmm_xmmm128",
	"VEX_Vfnmsubpd_ymm_ymm_ymm_ymmm256",
	"VEX_Vfnmsubss_xmm_xmm_xmmm32_xmm",
	"VEX_Vfnmsubss_xmm_xmm_xmm_xmmm32",
	"VEX_Vfnmsubsd_xmm_xmm_xmmm64_xmm",
	"VEX_Vfnmsubsd_xmm_xmm_xmm_xmmm64",
	"Sha1rnds4_xmm_xmmm128_imm8",
	"Gf2p8affineqb_xmm_xmmm128_imm8",
	"VEX_Vgf2p8affineqb_xmm_xmm_xmmm128_imm8",
	"VEX_Vgf2p8affineqb_ymm_ymm_ymmm256_imm8",
	"EVEX_Vgf2p8affineqb_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vgf2p8affineqb_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vgf2p8affineqb_zmm_k1z_zmm_zmmm512b64_imm8",
	"Gf2p8affineinvqb_xmm_xmmm128_imm8",
	"VEX_Vgf2p8affineinvqb_xmm_xmm_xmmm128_imm8",
	"VEX_Vgf2p8affineinvqb_ymm_ymm_ymmm256_imm8",
	"EVEX_Vgf2p8affineinvqb_xmm_k1z_xmm_xmmm128b64_imm8",
	"EVEX_Vgf2p8affineinvqb_ymm_k1z_ymm_ymmm256b64_imm8",
	"EVEX_Vgf2p8affineinvqb_zmm_k1z_zmm_zmmm512b64_imm8",
	"Aeskeygenassist_xmm_xmmm128_imm8",
	"VEX_Vaeskeygenassist_xmm_xmmm128_imm8",
	"VEX_Rorx_r32_rm32_imm8",
	"VEX_Rorx_r64_rm64_imm8",
	"XOP_Vpmacssww_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacsswd_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacssdql_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacssdd_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacssdqh_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacsww_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacswd_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacsdql_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacsdd_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmacsdqh_xmm_xmm_xmmm128_xmm",
	"XOP_Vpcmov_xmm_xmm_xmmm128_xmm",
	"XOP_Vpcmov_ymm_ymm_ymmm256_ymm",
	"XOP_Vpcmov_xmm_xmm_xmm_xmmm128",
	"XOP_Vpcmov_ymm_ymm_ymm_ymmm256",
	"XOP_Vpperm_xmm_xmm_xmmm128_xmm",
	"XOP_Vpperm_xmm_xmm_xmm_xmmm128",
	"XOP_Vpmadcsswd_xmm_xmm_xmmm128_xmm",
	"XOP_Vpmadcswd_xmm_xmm_xmmm128_xmm",
	"XOP_Vprotb_xmm_xmmm128_imm8",
	"XOP_Vprotw_xmm_xmmm128_imm8",
	"XOP_Vprotd_xmm_xmmm128_imm8",
	"XOP_Vprotq_xmm_xmmm128_imm8",
	"XOP_Vpcomb_xmm_xmm_xmmm128_imm8",
	"XOP_Vpcomw_xmm_xmm_xmmm128_imm8",
	"XOP_Vpcomd_xmm_xmm_xmmm128_imm8",
	"XOP_Vpcomq_xmm_xmm_xmmm128_imm8",
	"XOP_Vpcomub_xmm_xmm_xmmm128_imm8",
	"XOP_Vpcomuw_xmm_xmm_xmmm128_imm8",
	"XOP_Vpcomud_xmm_xmm_xmmm128_imm8",
	"XOP_Vpcomuq_xmm_xmm_xmmm128_imm8",
	"XOP_Blcfill_r32_rm32",
	"XOP_Blcfill_r64_rm64",
	"XOP_Blsfill_r32_rm32",
	"XOP_Blsfill_r64_rm64",
	"XOP_Blcs_r32_rm32",
	"XOP_Blcs_r64_rm64",
	"XOP_Tzmsk_r32_rm32",
	"XOP_Tzmsk_r64_rm64",
	"XOP_Blcic_r32_rm32",
	"XOP_Blcic_r64_rm64",
	"XOP_Blsic_r32_rm32",
	"XOP_Blsic_r64_rm64",
	"XOP_T1mskc_r32_rm32",
	"XOP_T1mskc_r64_rm64",
	"XOP_Blcmsk_r32_rm32",
	"XOP_Blcmsk_r64_rm64",
	"XOP_Blci_r32_rm32",
	"XOP_Blci_r64_rm64",
	"XOP_Llwpcb_r32",
	"XOP_Llwpcb_r64",
	"XOP_Slwpcb_r32",
	"XOP_Slwpcb_r64",
	"XOP_Vfrczps_xmm_xmmm128",
	"XOP_Vfrczps_ymm_ymmm256",
	"XOP_Vfrczpd_xmm_xmmm128",
	"XOP_Vfrczpd_ymm_ymmm256",
	"XOP_Vfrczss_xmm_xmmm32",
	"XOP_Vfrczsd_xmm_xmmm64",
	"XOP_Vprotb_xmm_xmmm128_xmm",
	"XOP_Vprotb_xmm_xmm_xmmm128",
	"XOP_Vprotw_xmm_xmmm128_xmm",
	"XOP_Vprotw_xmm_xmm_xmmm128",
	"XOP_Vprotd_xmm_xmmm128_xmm",
	"XOP_Vprotd_xmm_xmm_xmmm128",
	"XOP_Vprotq_xmm_xmmm128_xmm",
	"XOP_Vprotq_xmm_xmm_xmmm128",
	"XOP_Vpshlb_xmm_xmmm128_xmm",
	"XOP_Vpshlb_xmm_xmm_xmmm128",
	"XOP_Vpshlw_xmm_xmmm128_xmm",
	"XOP_Vpshlw_xmm_xmm_xmmm128",
	"XOP_Vpshld_xmm_xmmm128_xmm",
	"XOP_Vpshld_xmm_xmm_xmmm128",
	"XOP_Vpshlq_xmm_xmmm128_xmm",
	"XOP_Vpshlq_xmm_xmm_xmmm128",
	"XOP_Vpshab_xmm_xmmm128_xmm",
	"XOP_Vpshab_xmm_xmm_xmmm128",
	"XOP_Vpshaw_xmm_xmmm128_xmm",
	"XOP_Vpshaw_xmm_xmm_xmmm128",
	"XOP_Vpshad_xmm_xmmm128_xmm",
	"XOP_Vpshad_xmm_xmm_xmmm128",
	"XOP_Vpshaq_xmm_xmmm128_xmm",
	"XOP_Vpshaq_xmm_xmm_xmmm128",
	"XOP_Vphaddbw_xmm_xmmm128",
	"XOP_Vphaddbd_xmm_xmmm128",
	"XOP_Vphaddbq_xmm_xmmm128",
	"XOP_Vphaddwd_xmm_xmmm128",
	"XOP_Vphaddwq_xmm_xmmm128",
	"XOP_Vphadddq_xmm_xmmm128",
	"XOP_Vphaddubw_xmm_xmmm128",
	"XOP_Vphaddubd_xmm_xmmm128",
	"XOP_Vphaddubq_xmm_xmmm128",
	"XOP_Vphadduwd_xmm_xmmm128",
	"XOP_Vphadduwq_xmm_xmmm128",
	"XOP_Vphaddudq_xmm_xmmm128",
	"XOP_Vphsubbw_xmm_xmmm128",
	"XOP_Vphsubwd_xmm_xmmm128",
	"XOP_Vphsubdq_xmm_xmmm128",
	"XOP_Bextr_r32_rm32_imm32",
	"XOP_Bextr_r64_rm64_imm32",
	"XOP_Lwpins_r32_rm32_imm32",
	"XOP_Lwpins_r64_rm32_imm32",
	"XOP_Lwpval_r32_rm32_imm32",
	"XOP_Lwpval_r64_rm32_imm32",
	"D3NOW_Pi2fw_mm_mmm64",
	"D3NOW_Pi2fd_mm_mmm64",
	"D3NOW_Pf2iw_mm_mmm64",
	"D3NOW_Pf2id_mm_mmm64",
	"D3NOW_Pfrcpv_mm_mmm64",
	"D3NOW_Pfrsqrtv_mm_mmm64",
	"D3NOW_Pfnacc_mm_mmm64",
	"D3NOW_Pfpnacc_mm_mmm64",
	"D3NOW_Pfcmpge_mm_mmm64",
	"D3NOW_Pfmin_mm_mmm64",
	"D3NOW_Pfrcp_mm_mmm64",
	"D3NOW_Pfrsqrt_mm_mmm64",
	"D3NOW_Pfsub_mm_mmm64",
	"D3NOW_Pfadd_mm_mmm64",
	"D3NOW_Pfcmpgt_mm_mmm64",
	"D3NOW_Pfmax_mm_mmm64",
	"D3NOW_Pfrcpit1_mm_mmm64",
	"D3NOW_Pfrsqit1_mm_mmm64",
	"D3NOW_Pfsubr_mm_mmm64",
	"D3NOW_Pfacc_mm_mmm64",
	"D3NOW_Pfcmpeq_mm_mmm64",
	"D3NOW_Pfmul_mm_mmm64",
	"D3NOW_Pfrcpit2_mm_mmm64",
	"D3NOW_Pmulhrw_mm_mmm64",
	"D3NOW_Pswapd_mm_mmm64",
	"D3NOW_Pavgusb_mm_mmm64",
	"Rmpadjust",
	"Rmpupdate",
	"Psmash",
	"Pvalidatew",
	"Pvalidated",
	"Pvalidateq",
	"Serialize",
	"Xsusldtrk",
	"Xresldtrk",
	"Invlpgbw",
	"Invlpgbd",
	"Invlpgbq",
	"Tlbsync",
	"Prefetchreserved3_m8",
	"Prefetchreserved4_m8",
	"Prefetchreserved5_m8",
	"Prefetchreserved6_m8",
	"Prefetchreserved7_m8",
	"Ud0",
	"Vmgexit",
	"Getsecq",
	"VEX_Ldtilecfg_m512",
	"VEX_Tilerelease",
	"VEX_Sttilecfg_m512",
	"VEX_Tilezero_tmm",
	"VEX_Tileloaddt1_tmm_sibmem",
	"VEX_Tilestored_sibmem_tmm",
	"VEX_Tileloadd_tmm_sibmem",
	"VEX_Tdpbf16ps_tmm_tmm_tmm",
	"VEX_Tdpbuud_tmm_tmm_tmm",
	"VEX_Tdpbusd_tmm_tmm_tmm",
	"VEX_Tdpbsud_tmm_tmm_tmm",
	"VEX_Tdpbssd_tmm_tmm_tmm",
	"Fnstdw_AX",
	"Fnstsg_AX",
	"Rdshr_rm32",
	"Wrshr_rm32",
	"Smint",
	"Dmint",
	"Rdm",
	"Svdc_m80_Sreg",
	"Rsdc_Sreg_m80",
	"Svldt_m80",
	"Rsldt_m80",
	"Svts_m80",
	"Rsts_m80",
	"Smint_0F7E",
	"Bb0_reset",
	"Bb1_reset",
	"Cpu_write",
	"Cpu_read",
	"Altinst",
	"Paveb_mm_mmm64",
	"Paddsiw_mm_mmm64",
	"Pmagw_mm_mmm64",
	"Pdistib_mm_m64",
	"Psubsiw_mm_mmm64",
	"Pmvzb_mm_m64",
	"Pmulhrw_mm_mmm64",
	"Pmvnzb_mm_m64",
	"Pmvlzb_mm_m64",
	"Pmvgezb_mm_m64",
	"Pmulhriw_mm_mmm64",
	"Pmachriw_mm_m64",
	"Cyrix_D9D7",
	"Cyrix_D9E2",
	"Ftstp",
	"Cyrix_D9E7",
	"Frint2",
	"Frichop",
	"Cyrix_DED8",
	"Cyrix_DEDA",
	"Cyrix_DEDC",
	"Cyrix_DEDD",
	"Cyrix_DEDE",
	"Frinear",
	"Tdcall",
	"Seamret",
	"Seamops",
	"Seamcall",
	"Aesencwide128kl_m384",
	"Aesdecwide128kl_m384",
	"Aesencwide256kl_m512",
	"Aesdecwide256kl_m512",
	"Loadiwkey_xmm_xmm",
	"Aesenc128kl_xmm_m384",
	"Aesdec128kl_xmm_m384",
	"Aesenc256kl_xmm_m512",
	"Aesdec256kl_xmm_m512",
	"Encodekey128_r32_r32",
	"Encodekey256_r32_r32",
	"VEX_Vbroadcastss_xmm_xmm",
	"VEX_Vbroadcastss_ymm_xmm",
	"VEX_Vbroadcastsd_ymm_xmm",
	"Vmgexit_F2",
	"Uiret",
	"Testui",
	"Clui",
	"Stui",
	"Senduipi_r64",
	"Hreset_imm8",
	"VEX_Vpdpbusd_xmm_xmm_xmmm128",
	"VEX_Vpdpbusd_ymm_ymm_ymmm256",
	"VEX_Vpdpbusds_xmm_xmm_xmmm128",
	"VEX_Vpdpbusds_ymm_ymm_ymmm256",
	"VEX_Vpdpwssd_xmm_xmm_xmmm128",
	"VEX_Vpdpwssd_ymm_ymm_ymmm256",
	"VEX_Vpdpwssds_xmm_xmm_xmmm128",
	"VEX_Vpdpwssds_ymm_ymm_ymmm256",
	"Ccs_hash_16",
	"Ccs_hash_32",
	"Ccs_hash_64",
	"Ccs_encrypt_16",
	"Ccs_encrypt_32",
	"Ccs_encrypt_64",
	"Lkgs_rm16",
	"Lkgs_r32m16",
	"Lkgs_r64m16",
	"Eretu",
	"Erets",
	"EVEX_Vaddph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vaddph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vaddph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vaddsh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vcmpph_kr_k1_xmm_xmmm128b16_imm8",
	"EVEX_Vcmpph_kr_k1_ymm_ymmm256b16_imm8",
	"EVEX_Vcmpph_kr_k1_zmm_zmmm512b16_imm8_sae",
	"EVEX_Vcmpsh_kr_k1_xmm_xmmm16_imm8_sae",
	"EVEX_Vcomish_xmm_xmmm16_sae",
	"EVEX_Vcvtdq2ph_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtdq2ph_xmm_k1z_ymmm256b32",
	"EVEX_Vcvtdq2ph_ymm_k1z_zmmm512b32_er",
	"EVEX_Vcvtpd2ph_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtpd2ph_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtpd2ph_xmm_k1z_zmmm512b64_er",
	"EVEX_Vcvtph2dq_xmm_k1z_xmmm64b16",
	"EVEX_Vcvtph2dq_ymm_k1z_xmmm128b16",
	"EVEX_Vcvtph2dq_zmm_k1z_ymmm256b16_er",
	"EVEX_Vcvtph2pd_xmm_k1z_xmmm32b16",
	"EVEX_Vcvtph2pd_ymm_k1z_xmmm64b16",
	"EVEX_Vcvtph2pd_zmm_k1z_xmmm128b16_sae",
	"EVEX_Vcvtph2psx_xmm_k1z_xmmm64b16",
	"EVEX_Vcvtph2psx_ymm_k1z_xmmm128b16",
	"EVEX_Vcvtph2psx_zmm_k1z_ymmm256b16_sae",
	"EVEX_Vcvtph2qq_xmm_k1z_xmmm32b16",
	"EVEX_Vcvtph2qq_ymm_k1z_xmmm64b16",
	"EVEX_Vcvtph2qq_zmm_k1z_xmmm128b16_er",
	"EVEX_Vcvtph2udq_xmm_k1z_xmmm64b16",
	"EVEX_Vcvtph2udq_ymm_k1z_xmmm128b16",
	"EVEX_Vcvtph2udq_zmm_k1z_ymmm256b16_er",
	"EVEX_Vcvtph2uqq_xmm_k1z_xmmm32b16",
	"EVEX_Vcvtph2uqq_ymm_k1z_xmmm64b16",
	"EVEX_Vcvtph2uqq_zmm_k1z_xmmm128b16_er",
	"EVEX_Vcvtph2uw_xmm_k1z_xmmm128b16",
	"EVEX_Vcvtph2uw_ymm_k1z_ymmm256b16",
	"EVEX_Vcvtph2uw_zmm_k1z_zmmm512b16_er",
	"EVEX_Vcvtph2w_xmm_k1z_xmmm128b16",
	"EVEX_Vcvtph2w_ymm_k1z_ymmm256b16",
	"EVEX_Vcvtph2w_zmm_k1z_zmmm512b16_er",
	"EVEX_Vcvtps2phx_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtps2phx_xmm_k1z_ymmm256b32",
	"EVEX_Vcvtps2phx_ymm_k1z_zmmm512b32_er",
	"EVEX_Vcvtqq2ph_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtqq2ph_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtqq2ph_xmm_k1z_zmmm512b64_er",
	"EVEX_Vcvtsd2sh_xmm_k1z_xmm_xmmm64_er",
	"EVEX_Vcvtsh2sd_xmm_k1z_xmm_xmmm16_sae",
	"EVEX_Vcvtsh2si_r32_xmmm16_er",
	"EVEX_Vcvtsh2si_r64_xmmm16_er",
	"EVEX_Vcvtsh2ss_xmm_k1z_xmm_xmmm16_sae",
	"EVEX_Vcvtsh2usi_r32_xmmm16_er",
	"EVEX_Vcvtsh2usi_r64_xmmm16_er",
	"EVEX_Vcvtsi2sh_xmm_xmm_rm32_er",
	"EVEX_Vcvtsi2sh_xmm_xmm_rm64_er",
	"EVEX_Vcvtss2sh_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vcvttph2dq_xmm_k1z_xmmm64b16",
	"EVEX_Vcvttph2dq_ymm_k1z_xmmm128b16",
	"EVEX_Vcvttph2dq_zmm_k1z_ymmm256b16_sae",
	"EVEX_Vcvttph2qq_xmm_k1z_xmmm32b16",
	"EVEX_Vcvttph2qq_ymm_k1z_xmmm64b16",
	"EVEX_Vcvttph2qq_zmm_k1z_xmmm128b16_sae",
	"EVEX_Vcvttph2udq_xmm_k1z_xmmm64b16",
	"EVEX_Vcvttph2udq_ymm_k1z_xmmm128b16",
	"EVEX_Vcvttph2udq_zmm_k1z_ymmm256b16_sae",
	"EVEX_Vcvttph2uqq_xmm_k1z_xmmm32b16",
	"EVEX_Vcvttph2uqq_ymm_k1z_xmmm64b16",
	"EVEX_Vcvttph2uqq_zmm_k1z_xmmm128b16_sae",
	"EVEX_Vcvttph2uw_xmm_k1z_xmmm128b16",
	"EVEX_Vcvttph2uw_ymm_k1z_ymmm256b16",
	"EVEX_Vcvttph2uw_zmm_k1z_zmmm512b16_sae",
	"EVEX_Vcvttph2w_xmm_k1z_xmmm128b16",
	"EVEX_Vcvttph2w_ymm_k1z_ymmm256b16",
	"EVEX_Vcvttph2w_zmm_k1z_zmmm512b16_sae",
	"EVEX_Vcvttsh2si_r32_xmmm16_sae",
	"EVEX_Vcvttsh2si_r64_xmmm16_sae",
	"EVEX_Vcvttsh2usi_r32_xmmm16_sae",
	"EVEX_Vcvttsh2usi_r64_xmmm16_sae",
	"EVEX_Vcvtudq2ph_xmm_k1z_xmmm128b32",
	"EVEX_Vcvtudq2ph_xmm_k1z_ymmm256b32",
	"EVEX_Vcvtudq2ph_ymm_k1z_zmmm512b32_er",
	"EVEX_Vcvtuqq2ph_xmm_k1z_xmmm128b64",
	"EVEX_Vcvtuqq2ph_xmm_k1z_ymmm256b64",
	"EVEX_Vcvtuqq2ph_xmm_k1z_zmmm512b64_er",
	"EVEX_Vcvtusi2sh_xmm_xmm_rm32_er",
	"EVEX_Vcvtusi2sh_xmm_xmm_rm64_er",
	"EVEX_Vcvtuw2ph_xmm_k1z_xmmm128b16",
	"EVEX_Vcvtuw2ph_ymm_k1z_ymmm256b16",
	"EVEX_Vcvtuw2ph_zmm_k1z_zmmm512b16_er",
	"EVEX_Vcvtw2ph_xmm_k1z_xmmm128b16",
	"EVEX_Vcvtw2ph_ymm_k1z_ymmm256b16",
	"EVEX_Vcvtw2ph_zmm_k1z_zmmm512b16_er",
	"EVEX_Vdivph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vdivph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vdivph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vdivsh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfcmaddcph_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfcmaddcph_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfcmaddcph_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmaddcph_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmaddcph_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmaddcph_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfcmaddcsh_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmaddcsh_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfcmulcph_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfcmulcph_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfcmulcph_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfmulcph_xmm_k1z_xmm_xmmm128b32",
	"EVEX_Vfmulcph_ymm_k1z_ymm_ymmm256b32",
	"EVEX_Vfmulcph_zmm_k1z_zmm_zmmm512b32_er",
	"EVEX_Vfcmulcsh_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmulcsh_xmm_k1z_xmm_xmmm32_er",
	"EVEX_Vfmaddsub132ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmaddsub132ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmaddsub132ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmaddsub213ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmaddsub213ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmaddsub213ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmaddsub231ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmaddsub231ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmaddsub231ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmsubadd132ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmsubadd132ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmsubadd132ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmsubadd213ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmsubadd213ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmsubadd213ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmsubadd231ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmsubadd231ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmsubadd231ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmadd132ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmadd132ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmadd132ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmadd213ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmadd213ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmadd213ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmadd231ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmadd231ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmadd231ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfnmadd132ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfnmadd132ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfnmadd132ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfnmadd213ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfnmadd213ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfnmadd213ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfnmadd231ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfnmadd231ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfnmadd231ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmadd132sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfmadd213sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfmadd231sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfnmadd132sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfnmadd213sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfnmadd231sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfmsub132ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmsub132ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmsub132ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmsub213ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmsub213ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmsub213ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmsub231ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfmsub231ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfmsub231ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfnmsub132ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfnmsub132ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfnmsub132ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfnmsub213ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfnmsub213ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfnmsub213ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfnmsub231ph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vfnmsub231ph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vfnmsub231ph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vfmsub132sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfmsub213sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfmsub231sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfnmsub132sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfnmsub213sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfnmsub231sh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vfpclassph_kr_k1_xmmm128b16_imm8",
	"EVEX_Vfpclassph_kr_k1_ymmm256b16_imm8",
	"EVEX_Vfpclassph_kr_k1_zmmm512b16_imm8",
	"EVEX_Vfpclasssh_kr_k1_xmmm16_imm8",
	"EVEX_Vgetexpph_xmm_k1z_xmmm128b16",
	"EVEX_Vgetexpph_ymm_k1z_ymmm256b16",
	"EVEX_Vgetexpph_zmm_k1z_zmmm512b16_sae",
	"EVEX_Vgetexpsh_xmm_k1z_xmm_xmmm16_sae",
	"EVEX_Vgetmantph_xmm_k1z_xmmm128b16_imm8",
	"EVEX_Vgetmantph_ymm_k1z_ymmm256b16_imm8",
	"EVEX_Vgetmantph_zmm_k1z_zmmm512b16_imm8_sae",
	"EVEX_Vgetmantsh_xmm_k1z_xmm_xmmm16_imm8_sae",
	"EVEX_Vmaxph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vmaxph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vmaxph_zmm_k1z_zmm_zmmm512b16_sae",
	"EVEX_Vmaxsh_xmm_k1z_xmm_xmmm16_sae",
	"EVEX_Vminph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vminph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vminph_zmm_k1z_zmm_zmmm512b16_sae",
	"EVEX_Vminsh_xmm_k1z_xmm_xmmm16_sae",
	"EVEX_Vmovsh_xmm_k1z_m16",
	"EVEX_Vmovsh_m16_k1_xmm",
	"EVEX_Vmovsh_xmm_k1z_xmm_xmm",
	"EVEX_Vmovsh_xmm_k1z_xmm_xmm_MAP5_11",
	"EVEX_Vmovw_xmm_r32m16",
	"EVEX_Vmovw_xmm_r64m16",
	"EVEX_Vmovw_r32m16_xmm",
	"EVEX_Vmovw_r64m16_xmm",
	"EVEX_Vmulph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vmulph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vmulph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vmulsh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vrcpph_xmm_k1z_xmmm128b16",
	"EVEX_Vrcpph_ymm_k1z_ymmm256b16",
	"EVEX_Vrcpph_zmm_k1z_zmmm512b16",
	"EVEX_Vrcpsh_xmm_k1z_xmm_xmmm16",
	"EVEX_Vreduceph_xmm_k1z_xmmm128b16_imm8",
	"EVEX_Vreduceph_ymm_k1z_ymmm256b16_imm8",
	"EVEX_Vreduceph_zmm_k1z_zmmm512b16_imm8_sae",
	"EVEX_Vreducesh_xmm_k1z_xmm_xmmm16_imm8_sae",
	"EVEX_Vrndscaleph_xmm_k1z_xmmm128b16_imm8",
	"EVEX_Vrndscaleph_ymm_k1z_ymmm256b16_imm8",
	"EVEX_Vrndscaleph_zmm_k1z_zmmm512b16_imm8_sae",
	"EVEX_Vrndscalesh_xmm_k1z_xmm_xmmm16_imm8_sae",
	"EVEX_Vrsqrtph_xmm_k1z_xmmm128b16",
	"EVEX_Vrsqrtph_ymm_k1z_ymmm256b16",
	"EVEX_Vrsqrtph_zmm_k1z_zmmm512b16",
	"EVEX_Vrsqrtsh_xmm_k1z_xmm_xmmm16",
	"EVEX_Vscalefph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vscalefph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vscalefph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vscalefsh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vsqrtph_xmm_k1z_xmmm128b16",
	"EVEX_Vsqrtph_ymm_k1z_ymmm256b16",
	"EVEX_Vsqrtph_zmm_k1z_zmmm512b16_er",
	"EVEX_Vsqrtsh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vsubph_xmm_k1z_xmm_xmmm128b16",
	"EVEX_Vsubph_ymm_k1z_ymm_ymmm256b16",
	"EVEX_Vsubph_zmm_k1z_zmm_zmmm512b16_er",
	"EVEX_Vsubsh_xmm_k1z_xmm_xmmm16_er",
	"EVEX_Vucomish_xmm_xmmm16_sae",
	"Rdudbg",
	"Wrudbg",
	"VEX_KNC_Jkzd_kr_rel8_64",
	"VEX_KNC_Jknzd_kr_rel8_64",
	"VEX_KNC_Vprefetchnta_m8",
	"VEX_KNC_Vprefetch0_m8",
	"VEX_KNC_Vprefetch1_m8",
	"VEX_KNC_Vprefetch2_m8",
	"VEX_KNC_Vprefetchenta_m8",
	"VEX_KNC_Vprefetche0_m8",
	"VEX_KNC_Vprefetche1_m8",
	"VEX_KNC_Vprefetche2_m8",
	"VEX_KNC_Kand_kr_kr",
	"VEX_KNC_Kandn_kr_kr",
	"VEX_KNC_Kandnr_kr_kr",
	"VEX_KNC_Knot_kr_kr",
	"VEX_KNC_Kor_kr_kr",
	"VEX_KNC_Kxnor_kr_kr",
	"VEX_KNC_Kxor_kr_kr",
	"VEX_KNC_Kmerge2l1h_kr_kr",
	"VEX_KNC_Kmerge2l1l_kr_kr",
	"VEX_KNC_Jkzd_kr_rel32_64",
	"VEX_KNC_Jknzd_kr_rel32_64",
	"VEX_KNC_Kmov_kr_kr",
	"VEX_KNC_Kmov_kr_r32",
	"VEX_KNC_Kmov_r32_kr",
	"VEX_KNC_Kconcath_r64_kr_kr",
	"VEX_KNC_Kconcatl_r64_kr_kr",
	"VEX_KNC_Kortest_kr_kr",
	"VEX_KNC_Delay_r32",
	"VEX_KNC_Delay_r64",
	"VEX_KNC_Spflt_r32",
	"VEX_KNC_Spflt_r64",
	"VEX_KNC_Clevict1_m8",
	"VEX_KNC_Clevict0_m8",
	"VEX_KNC_Popcnt_r32_r32",
	"VEX_KNC_Popcnt_r64_r64",
	"VEX_KNC_Tzcnt_r32_r32",
	"VEX_KNC_Tzcnt_r64_r64",
	"VEX_KNC_Tzcnti_r32_r32",
	"VEX_KNC_Tzcnti_r64_r64",
	"VEX_KNC_Lzcnt_r32_r32",
	"VEX_KNC_Lzcnt_r64_r64",
	"VEX_KNC_Undoc_r32_rm32_128_F3_0F38_W0_F0",
	"VEX_KNC_Undoc_r64_rm64_128_F3_0F38_W1_F0",
	"VEX_KNC_Undoc_r32_rm32_128_F2_0F38_W0_F0",
	"VEX_KNC_Undoc_r64_rm64_128_F2_0F38_W1_F0",
	"VEX_KNC_Undoc_r32_rm32_128_F2_0F38_W0_F1",
	"VEX_KNC_Undoc_r64_rm64_128_F2_0F38_W1_F1",
	"VEX_KNC_Kextract_kr_r64_imm8",
	"MVEX_Vprefetchnta_m",
	"MVEX_Vprefetch0_m",
	"MVEX_Vprefetch1_m",
	"MVEX_Vprefetch2_m",
	"MVEX_Vprefetchenta_m",
	"MVEX_Vprefetche0_m",
	"MVEX_Vprefetche1_m",
	"MVEX_Vprefetche2_m",
	"MVEX_Vmovaps_zmm_k1_zmmmt",
	"MVEX_Vmovapd_zmm_k1_zmmmt",
	"MVEX_Vmovaps_mt_k1_zmm",
	"MVEX_Vmovapd_mt_k1_zmm",
	"MVEX_Vmovnrapd_m_k1_zmm",
	"MVEX_Vmovnrngoapd_m_k1_zmm",
	"MVEX_Vmovnraps_m_k1_zmm",
	"MVEX_Vmovnrngoaps_m_k1_zmm",
	"MVEX_Vaddps_zmm_k1_zmm_zmmmt",
	"MVEX_Vaddpd_zmm_k1_zmm_zmmmt",
	"MVEX_Vmulps_zmm_k1_zmm_zmmmt",
	"MVEX_Vmulpd_zmm_k1_zmm_zmmmt",
	"MVEX_Vcvtps2pd_zmm_k1_zmmmt",
	"MVEX_Vcvtpd2ps_zmm_k1_zmmmt",
	"MVEX_Vsubps_zmm_k1_zmm_zmmmt",
	"MVEX_Vsubpd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpcmpgtd_kr_k1_zmm_zmmmt",
	"MVEX_Vmovdqa32_zmm_k1_zmmmt",
	"MVEX_Vmovdqa64_zmm_k1_zmmmt",
	"MVEX_Vpshufd_zmm_k1_zmmmt_imm8",
	"MVEX_Vpsrld_zmm_k1_zmmmt_imm8",
	"MVEX_Vpsrad_zmm_k1_zmmmt_imm8",
	"MVEX_Vpslld_zmm_k1_zmmmt_imm8",
	"MVEX_Vpcmpeqd_kr_k1_zmm_zmmmt",
	"MVEX_Vcvtudq2pd_zmm_k1_zmmmt",
	"MVEX_Vmovdqa32_mt_k1_zmm",
	"MVEX_Vmovdqa64_mt_k1_zmm",
	"MVEX_Clevict1_m",
	"MVEX_Clevict0_m",
	"MVEX_Vcmpps_kr_k1_zmm_zmmmt_imm8",
	"MVEX_Vcmppd_kr_k1_zmm_zmmmt_imm8",
	"MVEX_Vpandd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpandq_zmm_k1_zmm_zmmmt",
	"MVEX_Vpandnd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpandnq_zmm_k1_zmm_zmmmt",
	"MVEX_Vcvtdq2pd_zmm_k1_zmmmt",
	"MVEX_Vpord_zmm_k1_zmm_zmmmt",
	"MVEX_Vporq_zmm_k1_zmm_zmmmt",
	"MVEX_Vpxord_zmm_k1_zmm_zmmmt",
	"MVEX_Vpxorq_zmm_k1_zmm_zmmmt",
	"MVEX_Vpsubd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpaddd_zmm_k1_zmm_zmmmt",
	"MVEX_Vbroadcastss_zmm_k1_mt",
	"MVEX_Vbroadcastsd_zmm_k1_mt",
	"MVEX_Vbroadcastf32x4_zmm_k1_mt",
	"MVEX_Vbroadcastf64x4_zmm_k1_mt",
	"MVEX_Vptestmd_kr_k1_zmm_zmmmt",
	"MVEX_Vpermd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpminsd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpminud_zmm_k1_zmm_zmmmt",
	"MVEX_Vpmaxsd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpmaxud_zmm_k1_zmm_zmmmt",
	"MVEX_Vpmulld_zmm_k1_zmm_zmmmt",
	"MVEX_Vgetexpps_zmm_k1_zmmmt",
	"MVEX_Vgetexppd_zmm_k1_zmmmt",
	"MVEX_Vpsrlvd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpsravd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpsllvd_zmm_k1_zmm_zmmmt",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_48",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_49",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_4A",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_4B",
	"MVEX_Vaddnps_zmm_k1_zmm_zmmmt",
	"MVEX_Vaddnpd_zmm_k1_zmm_zmmmt",
	"MVEX_Vgmaxabsps_zmm_k1_zmm_zmmmt",
	"MVEX_Vgminps_zmm_k1_zmm_zmmmt",
	"MVEX_Vgminpd_zmm_k1_zmm_zmmmt",
	"MVEX_Vgmaxps_zmm_k1_zmm_zmmmt",
	"MVEX_Vgmaxpd_zmm_k1_zmm_zmmmt",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_54",
	"MVEX_Vfixupnanps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfixupnanpd_zmm_k1_zmm_zmmmt",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_56",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_57",
	"MVEX_Vpbroadcastd_zmm_k1_mt",
	"MVEX_Vpbroadcastq_zmm_k1_mt",
	"MVEX_Vbroadcasti32x4_zmm_k1_mt",
	"MVEX_Vbroadcasti64x4_zmm_k1_mt",
	"MVEX_Vpadcd_zmm_k1_kr_zmmmt",
	"MVEX_Vpaddsetcd_zmm_k1_kr_zmmmt",
	"MVEX_Vpsbbd_zmm_k1_kr_zmmmt",
	"MVEX_Vpsubsetbd_zmm_k1_kr_zmmmt",
	"MVEX_Vpblendmd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpblendmq_zmm_k1_zmm_zmmmt",
	"MVEX_Vblendmps_zmm_k1_zmm_zmmmt",
	"MVEX_Vblendmpd_zmm_k1_zmm_zmmmt",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_67",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_68",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_69",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_6A",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_6B",
	"MVEX_Vpsubrd_zmm_k1_zmm_zmmmt",
	"MVEX_Vsubrps_zmm_k1_zmm_zmmmt",
	"MVEX_Vsubrpd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpsbbrd_zmm_k1_kr_zmmmt",
	"MVEX_Vpsubrsetbd_zmm_k1_kr_zmmmt",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_70",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_71",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_72",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_73",
	"MVEX_Vpcmpltd_kr_k1_zmm_zmmmt",
	"MVEX_Vscaleps_zmm_k1_zmm_zmmmt",
	"MVEX_Vpmulhud_zmm_k1_zmm_zmmmt",
	"MVEX_Vpmulhd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpgatherdd_zmm_k1_mvt",
	"MVEX_Vpgatherdq_zmm_k1_mvt",
	"MVEX_Vgatherdps_zmm_k1_mvt",
	"MVEX_Vgatherdpd_zmm_k1_mvt",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_94",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W1_94",
	"MVEX_Vfmadd132ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmadd132pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmsub132ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmsub132pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmadd132ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmadd132pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmsub132ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmsub132pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vpscatterdd_mvt_k1_zmm",
	"MVEX_Vpscatterdq_mvt_k1_zmm",
	"MVEX_Vscatterdps_mvt_k1_zmm",
	"MVEX_Vscatterdpd_mvt_k1_zmm",
	"MVEX_Vfmadd233ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmadd213ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmadd213pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmsub213ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmsub213pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmadd213ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmadd213pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmsub213ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmsub213pd_zmm_k1_zmm_zmmmt",
	"MVEX_Undoc_zmm_k1_mvt_512_66_0F38_W0_B0",
	"MVEX_Undoc_zmm_k1_mvt_512_66_0F38_W0_B2",
	"MVEX_Vpmadd233d_zmm_k1_zmm_zmmmt",
	"MVEX_Vpmadd231d_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmadd231ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmadd231pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmsub231ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfmsub231pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmadd231ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmadd231pd_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmsub231ps_zmm_k1_zmm_zmmmt",
	"MVEX_Vfnmsub231pd_zmm_k1_zmm_zmmmt",
	"MVEX_Undoc_zmm_k1_mvt_512_66_0F38_W0_C0",
	"MVEX_Vgatherpf0hintdps_mvt_k1",
	"MVEX_Vgatherpf0hintdpd_mvt_k1",
	"MVEX_Vgatherpf0dps_mvt_k1",
	"MVEX_Vgatherpf1dps_mvt_k1",
	"MVEX_Vscatterpf0hintdps_mvt_k1",
	"MVEX_Vscatterpf0hintdpd_mvt_k1",
	"MVEX_Vscatterpf0dps_mvt_k1",
	"MVEX_Vscatterpf1dps_mvt_k1",
	"MVEX_Vexp223ps_zmm_k1_zmmmt",
	"MVEX_Vlog2ps_zmm_k1_zmmmt",
	"MVEX_Vrcp23ps_zmm_k1_zmmmt",
	"MVEX_Vrsqrt23ps_zmm_k1_zmmmt",
	"MVEX_Vaddsetsps_zmm_k1_zmm_zmmmt",
	"MVEX_Vpaddsetsd_zmm_k1_zmm_zmmmt",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_CE",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W1_CE",
	"MVEX_Undoc_zmm_k1_zmm_zmmmt_512_66_0F38_W0_CF",
	"MVEX_Vloadunpackld_zmm_k1_mt",
	"MVEX_Vloadunpacklq_zmm_k1_mt",
	"MVEX_Vpackstoreld_mt_k1_zmm",
	"MVEX_Vpackstorelq_mt_k1_zmm",
	"MVEX_Vloadunpacklps_zmm_k1_mt",
	"MVEX_Vloadunpacklpd_zmm_k1_mt",
	"MVEX_Vpackstorelps_mt_k1_zmm",
	"MVEX_Vpackstorelpd_mt_k1_zmm",
	"MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D2",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_D2",
	"MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D3",
	"MVEX_Vloadunpackhd_zmm_k1_mt",
	"MVEX_Vloadunpackhq_zmm_k1_mt",
	"MVEX_Vpackstorehd_mt_k1_zmm",
	"MVEX_Vpackstorehq_mt_k1_zmm",
	"MVEX_Vloadunpackhps_zmm_k1_mt",
	"MVEX_Vloadunpackhpd_zmm_k1_mt",
	"MVEX_Vpackstorehps_mt_k1_zmm",
	"MVEX_Vpackstorehpd_mt_k1_zmm",
	"MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D6",
	"MVEX_Undoc_zmm_k1_zmmmt_512_66_0F38_W0_D6",
	"MVEX_Undoc_zmm_k1_zmmmt_512_0F38_W0_D7",
	"MVEX_Valignd_zmm_k1_zmm_zmmmt_imm8",
	"MVEX_Vpermf32x4_zmm_k1_zmmmt_imm8",
	"MVEX_Vpcmpud_kr_k1_zmm_zmmmt_imm8",
	"MVEX_Vpcmpd_kr_k1_zmm_zmmmt_imm8",
	"MVEX_Vgetmantps_zmm_k1_zmmmt_imm8",
	"MVEX_Vgetmantpd_zmm_k1_zmmmt_imm8",
	"MVEX_Vrndfxpntps_zmm_k1_zmmmt_imm8",
	"MVEX_Vrndfxpntpd_zmm_k1_zmmmt_imm8",
	"MVEX_Vcvtfxpntudq2ps_zmm_k1_zmmmt_imm8",
	"MVEX_Vcvtfxpntps2udq_zmm_k1_zmmmt_imm8",
	"MVEX_Vcvtfxpntpd2udq_zmm_k1_zmmmt_imm8",
	"MVEX_Vcvtfxpntdq2ps_zmm_k1_zmmmt_imm8",
	"MVEX_Vcvtfxpntps2dq_zmm_k1_zmmmt_imm8",
	"MVEX_Undoc_zmm_k1_zmmmt_imm8_512_66_0F3A_W0_D0",
	"MVEX_Undoc_zmm_k1_zmmmt_imm8_512_66_0F3A_W0_D1",
	"MVEX_Vcvtfxpntpd2dq_zmm_k1_zmmmt_imm8",
	"Via_undoc_F30FA6F0_16",
	"Via_undoc_F30FA6F0_32",
	"Via_undoc_F30FA6F0_64",
	"Via_undoc_F30FA6F8_16",
	"Via_undoc_F30FA6F8_32",
	"Via_undoc_F30FA6F8_64",
	"Xsha512_16",
	"Xsha512_32",
	"Xsha512_64",
	"Xstore2_16",
	"Xstore2_32",
	"Xstore2_64",
];
impl fmt::Debug for Code {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CODE[*self as usize])
	}
}
impl Default for Code {
	#[must_use]
	#[inline]
	fn default() -> Self {
		Code::INVALID
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CodeUnderlyingType = u16;
#[rustfmt::skip]
impl Code {
	/// Iterates over all `Code` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = Code> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CODE_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u16, Code>(x as u16) })
	}
}
#[test]
#[rustfmt::skip]
fn test_code_values() {
	let mut iter = Code::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CODE_ENUM_COUNT, Some(IcedConstants::CODE_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CODE_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CODE_ENUM_COUNT - 1, Some(IcedConstants::CODE_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CODE_ENUM_COUNT - 1);

	let values: Vec<Code> = Code::values().collect();
	assert_eq!(values.len(), IcedConstants::CODE_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<Code> = Code::values().collect();
	let mut values2: Vec<Code> = Code::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for Code {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CODE_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u16) })
		} else {
			Err(IcedError::new("Invalid Code value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_code_try_from_usize() {
	for value in Code::values() {
		let converted = <Code as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<Code as TryFrom<usize>>::try_from(IcedConstants::CODE_ENUM_COUNT).is_err());
	assert!(<Code as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	#[cfg(not(feature = "std"))]
	use hashbrown::HashMap;
	use lazy_static::lazy_static;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	#[cfg(feature = "std")]
	use std::collections::HashMap;
	lazy_static! {
		static ref NAME_TO_ENUM: HashMap<&'static [u8], EnumType> = GEN_DEBUG_CODE.iter().map(|&s| s.as_bytes()).zip(EnumType::values()).collect();
	}
	type EnumType = Code;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("Code", *self as u32, GEN_DEBUG_CODE[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid Code variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					if let Some(&value) = NAME_TO_ENUM.get(v) {
						Ok(EnumValue(value))
					} else {
						Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["Code enum variants"][..]))
					}
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum Code")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("Code", &GEN_DEBUG_CODE[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: Code

impl Code {
	/// Gets the mnemonic
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert_eq!(Code::Add_rm32_r32.mnemonic(), Mnemonic::Add);
	/// ```
	#[must_use]
	#[inline]
	pub fn mnemonic(self) -> Mnemonic {
		mnemonics::TO_MNEMONIC[self as usize]
	}
}

#[cfg(all(feature = "encoder", feature = "op_code_info"))]
impl Code {
	/// Gets a [`OpCodeInfo`]
	///
	/// [`OpCodeInfo`]: struct.OpCodeInfo.html
	#[must_use]
	#[inline]
	pub fn op_code(self) -> &'static OpCodeInfo {
		&self::encoder::op_code_tbl::OP_CODE_INFO_TBL[self as usize]
	}
}

#[cfg(feature = "instr_info")]
impl Code {
	/// Gets the encoding, eg. Legacy, 3DNow!, VEX, EVEX, XOP
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert_eq!(Code::Add_rm32_r32.encoding(), EncodingKind::Legacy);
	/// assert_eq!(Code::VEX_Vmovups_xmm_xmmm128.encoding(), EncodingKind::VEX);
	/// assert_eq!(Code::EVEX_Vmovups_xmm_k1z_xmmm128.encoding(), EncodingKind::EVEX);
	/// assert_eq!(Code::XOP_Vpmacssww_xmm_xmm_xmmm128_xmm.encoding(), EncodingKind::XOP);
	/// assert_eq!(Code::D3NOW_Pi2fw_mm_mmm64.encoding(), EncodingKind::D3NOW);
	/// assert_eq!(Code::MVEX_Vpackstoreld_mt_k1_zmm.encoding(), EncodingKind::MVEX);
	/// ```
	#[must_use]
	#[inline]
	pub fn encoding(self) -> EncodingKind {
		// SAFETY: The table is generated and only contains valid enum variants
		unsafe {
			mem::transmute(
				((crate::info::info_table::TABLE[self as usize].1 >> InfoFlags2::ENCODING_SHIFT) & InfoFlags2::ENCODING_MASK)
					as EncodingKindUnderlyingType,
			)
		}
	}

	/// Gets the CPU or CPUID feature flags
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	///
	/// let cpuid = Code::VEX_Vmovups_xmm_xmmm128.cpuid_features();
	/// assert_eq!(cpuid.len(), 1);
	/// assert_eq!(cpuid[0], CpuidFeature::AVX);
	///
	/// let cpuid = Code::EVEX_Vmovaps_xmm_k1z_xmmm128.cpuid_features();
	/// assert_eq!(cpuid.len(), 2);
	/// assert_eq!(cpuid[0], CpuidFeature::AVX512VL);
	/// assert_eq!(cpuid[1], CpuidFeature::AVX512F);
	/// ```
	#[must_use]
	#[inline]
	pub fn cpuid_features(self) -> &'static [CpuidFeature] {
		// SAFETY: The table is generated and only contains valid enum variants
		let index: CpuidFeatureInternal = unsafe {
			mem::transmute(
				((crate::info::info_table::TABLE[self as usize].1 >> InfoFlags2::CPUID_FEATURE_INTERNAL_SHIFT)
					& InfoFlags2::CPUID_FEATURE_INTERNAL_MASK) as u8,
			)
		};
		crate::info::cpuid_table::CPUID[index as usize]
	}

	/// Gets control flow info
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert_eq!(Code::Or_r32_rm32.flow_control(), FlowControl::Next);
	/// assert_eq!(Code::Ud0_r64_rm64.flow_control(), FlowControl::Exception);
	/// assert_eq!(Code::Call_rm64.flow_control(), FlowControl::IndirectCall);
	/// ```
	#[must_use]
	#[inline]
	pub fn flow_control(self) -> FlowControl {
		// SAFETY: The table is generated and only contains valid enum variants
		unsafe {
			mem::transmute(
				((crate::info::info_table::TABLE[self as usize].1 >> InfoFlags2::FLOW_CONTROL_SHIFT) & InfoFlags2::FLOW_CONTROL_MASK)
					as FlowControlUnderlyingType,
			)
		}
	}

	/// Checks if it's a privileged instruction (all CPL=0 instructions (except `VMCALL`) and IOPL instructions `IN`, `INS`, `OUT`, `OUTS`, `CLI`, `STI`)
	#[must_use]
	#[inline]
	pub fn is_privileged(self) -> bool {
		(crate::info::info_table::TABLE[self as usize].1 & InfoFlags2::PRIVILEGED) != 0
	}

	/// Checks if this is an instruction that implicitly uses the stack pointer (`SP`/`ESP`/`RSP`), eg. `CALL`, `PUSH`, `POP`, `RET`, etc.
	/// See also [`Instruction::stack_pointer_increment()`]
	///
	/// [`Instruction::stack_pointer_increment()`]: struct.Instruction.html#method.stack_pointer_increment
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert!(!Code::Or_r32_rm32.is_stack_instruction());
	/// assert!(Code::Push_r64.is_stack_instruction());
	/// assert!(Code::Call_rm64.is_stack_instruction());
	/// ```
	#[must_use]
	#[inline]
	pub fn is_stack_instruction(self) -> bool {
		(crate::info::info_table::TABLE[self as usize].1 & InfoFlags2::STACK_INSTRUCTION) != 0
	}

	/// Checks if it's an instruction that saves or restores too many registers (eg. `FXRSTOR`, `XSAVE`, etc).
	#[must_use]
	#[inline]
	pub fn is_save_restore_instruction(self) -> bool {
		(crate::info::info_table::TABLE[self as usize].1 & InfoFlags2::SAVE_RESTORE) != 0
	}

	/// Checks if it's a `Jcc NEAR` instruction
	#[must_use]
	#[inline]
	pub fn is_jcc_near(self) -> bool {
		(self as u32).wrapping_sub(Code::Jo_rel16 as u32) <= (Code::Jg_rel32_64 as u32 - Code::Jo_rel16 as u32)
	}

	/// Checks if it's a `Jcc SHORT` instruction
	#[must_use]
	#[inline]
	pub fn is_jcc_short(self) -> bool {
		(self as u32).wrapping_sub(Code::Jo_rel8_16 as u32) <= (Code::Jg_rel8_64 as u32 - Code::Jo_rel8_16 as u32)
	}

	/// Checks if it's a `JMP SHORT` instruction
	#[must_use]
	#[inline]
	pub fn is_jmp_short(self) -> bool {
		(self as u32).wrapping_sub(Code::Jmp_rel8_16 as u32) <= (Code::Jmp_rel8_64 as u32 - Code::Jmp_rel8_16 as u32)
	}

	/// Checks if it's a `JMP NEAR` instruction
	#[must_use]
	#[inline]
	pub fn is_jmp_near(self) -> bool {
		(self as u32).wrapping_sub(Code::Jmp_rel16 as u32) <= (Code::Jmp_rel32_64 as u32 - Code::Jmp_rel16 as u32)
	}

	/// Checks if it's a `JMP SHORT` or a `JMP NEAR` instruction
	#[must_use]
	#[inline]
	pub fn is_jmp_short_or_near(self) -> bool {
		(self as u32).wrapping_sub(Code::Jmp_rel8_16 as u32) <= (Code::Jmp_rel8_64 as u32 - Code::Jmp_rel8_16 as u32)
			|| (self as u32).wrapping_sub(Code::Jmp_rel16 as u32) <= (Code::Jmp_rel32_64 as u32 - Code::Jmp_rel16 as u32)
	}

	/// Checks if it's a `JMP FAR` instruction
	#[must_use]
	#[inline]
	pub fn is_jmp_far(self) -> bool {
		(self as u32).wrapping_sub(Code::Jmp_ptr1616 as u32) <= (Code::Jmp_ptr1632 as u32 - Code::Jmp_ptr1616 as u32)
	}

	/// Checks if it's a `CALL NEAR` instruction
	#[must_use]
	#[inline]
	pub fn is_call_near(self) -> bool {
		(self as u32).wrapping_sub(Code::Call_rel16 as u32) <= (Code::Call_rel32_64 as u32 - Code::Call_rel16 as u32)
	}

	/// Checks if it's a `CALL FAR` instruction
	#[must_use]
	#[inline]
	pub fn is_call_far(self) -> bool {
		(self as u32).wrapping_sub(Code::Call_ptr1616 as u32) <= (Code::Call_ptr1632 as u32 - Code::Call_ptr1616 as u32)
	}

	/// Checks if it's a `JMP NEAR reg/[mem]` instruction
	#[must_use]
	#[inline]
	pub fn is_jmp_near_indirect(self) -> bool {
		(self as u32).wrapping_sub(Code::Jmp_rm16 as u32) <= (Code::Jmp_rm64 as u32 - Code::Jmp_rm16 as u32)
	}

	/// Checks if it's a `JMP FAR [mem]` instruction
	#[must_use]
	#[inline]
	pub fn is_jmp_far_indirect(self) -> bool {
		(self as u32).wrapping_sub(Code::Jmp_m1616 as u32) <= (Code::Jmp_m1664 as u32 - Code::Jmp_m1616 as u32)
	}

	/// Checks if it's a `CALL NEAR reg/[mem]` instruction
	#[must_use]
	#[inline]
	pub fn is_call_near_indirect(self) -> bool {
		(self as u32).wrapping_sub(Code::Call_rm16 as u32) <= (Code::Call_rm64 as u32 - Code::Call_rm16 as u32)
	}

	/// Checks if it's a `CALL FAR [mem]` instruction
	#[must_use]
	#[inline]
	pub fn is_call_far_indirect(self) -> bool {
		(self as u32).wrapping_sub(Code::Call_m1616 as u32) <= (Code::Call_m1664 as u32 - Code::Call_m1616 as u32)
	}

	/// Checks if it's a `JKccD SHORT` or `JKccD NEAR` instruction
	#[must_use]
	#[inline]
	#[cfg(feature = "mvex")]
	pub fn is_jkcc_short_or_near(self) -> bool {
		matches!(
			self,
			Code::VEX_KNC_Jkzd_kr_rel8_64 | Code::VEX_KNC_Jknzd_kr_rel8_64 | Code::VEX_KNC_Jkzd_kr_rel32_64 | Code::VEX_KNC_Jknzd_kr_rel32_64
		)
	}

	/// Checks if it's a `JKccD NEAR` instruction
	#[must_use]
	#[inline]
	#[cfg(feature = "mvex")]
	pub fn is_jkcc_near(self) -> bool {
		matches!(self, Code::VEX_KNC_Jkzd_kr_rel32_64 | Code::VEX_KNC_Jknzd_kr_rel32_64)
	}

	/// Checks if it's a `JKccD SHORT` instruction
	#[must_use]
	#[inline]
	#[cfg(feature = "mvex")]
	pub fn is_jkcc_short(self) -> bool {
		matches!(self, Code::VEX_KNC_Jkzd_kr_rel8_64 | Code::VEX_KNC_Jknzd_kr_rel8_64)
	}

	/// Gets the condition code if it's `Jcc`, `SETcc`, `CMOVcc`, `LOOPcc` else [`ConditionCode::None`] is returned
	///
	/// [`ConditionCode::None`]: enum.ConditionCode.html#variant.None
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert_eq!(Code::Jbe_rel8_64.condition_code(), ConditionCode::be);
	/// assert_eq!(Code::Cmovo_r64_rm64.condition_code(), ConditionCode::o);
	/// assert_eq!(Code::Setne_rm8.condition_code(), ConditionCode::ne);
	/// assert_eq!(Code::Pause.condition_code(), ConditionCode::None);
	/// ```
	#[must_use]
	#[allow(clippy::missing_inline_in_public_items)]
	pub fn condition_code(self) -> ConditionCode {
		let mut t;

		// SAFETY: All valid input (all Code values) have been tested successfully, the transmutes are correct

		t = (self as u32).wrapping_sub(Code::Jo_rel16 as u32);
		if t <= (Code::Jg_rel32_64 as u32 - Code::Jo_rel16 as u32) {
			return unsafe { mem::transmute(((t / 3) + ConditionCode::o as u32) as ConditionCodeUnderlyingType) };
		}

		t = (self as u32).wrapping_sub(Code::Jo_rel8_16 as u32);
		if t <= (Code::Jg_rel8_64 as u32 - Code::Jo_rel8_16 as u32) {
			return unsafe { mem::transmute(((t / 3) + ConditionCode::o as u32) as ConditionCodeUnderlyingType) };
		}

		t = (self as u32).wrapping_sub(Code::Cmovo_r16_rm16 as u32);
		if t <= (Code::Cmovg_r64_rm64 as u32 - Code::Cmovo_r16_rm16 as u32) {
			return unsafe { mem::transmute(((t / 3) + ConditionCode::o as u32) as ConditionCodeUnderlyingType) };
		}

		t = (self as u32).wrapping_sub(Code::Seto_rm8 as u32);
		if t <= (Code::Setg_rm8 as u32 - Code::Seto_rm8 as u32) {
			return unsafe { mem::transmute((t + ConditionCode::o as u32) as ConditionCodeUnderlyingType) };
		}

		t = (self as u32).wrapping_sub(Code::Loopne_rel8_16_CX as u32);
		if t <= (Code::Loopne_rel8_64_RCX as u32 - Code::Loopne_rel8_16_CX as u32) {
			return ConditionCode::ne;
		}

		t = (self as u32).wrapping_sub(Code::Loope_rel8_16_CX as u32);
		if t <= (Code::Loope_rel8_64_RCX as u32 - Code::Loope_rel8_16_CX as u32) {
			return ConditionCode::e;
		}

		#[cfg(feature = "mvex")]
		{
			match self {
				Code::VEX_KNC_Jkzd_kr_rel8_64 | Code::VEX_KNC_Jkzd_kr_rel32_64 => return ConditionCode::e,
				Code::VEX_KNC_Jknzd_kr_rel8_64 | Code::VEX_KNC_Jknzd_kr_rel32_64 => return ConditionCode::ne,
				_ => {}
			}
		}

		ConditionCode::None
	}

	/// `true` if this `Code` corresponds to a "string" operation, such as `MOVS`, `LODS`,
	/// `STOS`, etc.
	#[must_use]
	#[inline]
	#[allow(clippy::match_like_matches_macro)]
	pub fn is_string_instruction(self) -> bool {
		#[cfg_attr(feature = "cargo-fmt", rustfmt::skip)]
		match self {
			// GENERATOR-BEGIN: IsStringOpTable
			// ⚠️This was generated by GENERATOR!🦹‍♂️
			Code::Insb_m8_DX
			| Code::Insw_m16_DX
			| Code::Insd_m32_DX
			| Code::Outsb_DX_m8
			| Code::Outsw_DX_m16
			| Code::Outsd_DX_m32
			| Code::Movsb_m8_m8
			| Code::Movsw_m16_m16
			| Code::Movsd_m32_m32
			| Code::Movsq_m64_m64
			| Code::Cmpsb_m8_m8
			| Code::Cmpsw_m16_m16
			| Code::Cmpsd_m32_m32
			| Code::Cmpsq_m64_m64
			| Code::Stosb_m8_AL
			| Code::Stosw_m16_AX
			| Code::Stosd_m32_EAX
			| Code::Stosq_m64_RAX
			| Code::Lodsb_AL_m8
			| Code::Lodsw_AX_m16
			| Code::Lodsd_EAX_m32
			| Code::Lodsq_RAX_m64
			| Code::Scasb_AL_m8
			| Code::Scasw_AX_m16
			| Code::Scasd_EAX_m32
			| Code::Scasq_RAX_m64
			=> true,
			// GENERATOR-END: IsStringOpTable
			_ => false,
		}
	}

	/// Checks if it's a `JCXZ SHORT`, `JECXZ SHORT` or `JRCXZ SHORT` instruction
	#[must_use]
	#[inline]
	pub fn is_jcx_short(self) -> bool {
		(self as u32).wrapping_sub(Code::Jcxz_rel8_16 as u32) <= (Code::Jrcxz_rel8_64 as u32 - Code::Jcxz_rel8_16 as u32)
	}

	/// Checks if it's a `LOOPcc SHORT` instruction
	#[must_use]
	#[inline]
	pub fn is_loopcc(self) -> bool {
		(self as u32).wrapping_sub(Code::Loopne_rel8_16_CX as u32) <= (Code::Loope_rel8_64_RCX as u32 - Code::Loopne_rel8_16_CX as u32)
	}

	/// Checks if it's a `LOOP SHORT` instruction
	#[must_use]
	#[inline]
	pub fn is_loop(self) -> bool {
		(self as u32).wrapping_sub(Code::Loop_rel8_16_CX as u32) <= (Code::Loop_rel8_64_RCX as u32 - Code::Loop_rel8_16_CX as u32)
	}
}

#[cfg(any(feature = "instr_info", feature = "fast_fmt"))]
impl Code {
	/// Checks if it's a `Jcc SHORT` or `Jcc NEAR` instruction
	#[must_use]
	#[inline]
	pub fn is_jcc_short_or_near(self) -> bool {
		(self as u32).wrapping_sub(Code::Jo_rel8_16 as u32) <= (Code::Jg_rel8_64 as u32 - Code::Jo_rel8_16 as u32)
			|| (self as u32).wrapping_sub(Code::Jo_rel16 as u32) <= (Code::Jg_rel32_64 as u32 - Code::Jo_rel16 as u32)
	}
}

#[cfg(any(feature = "instr_info", feature = "encoder"))]
impl Code {
	/// Negates the condition code, eg. `JE` -> `JNE`. Can be used if it's `Jcc`, `SETcc`, `CMOVcc`, `LOOPcc`
	/// and returns the original value if it's none of those instructions.
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert_eq!(Code::Setbe_rm8.negate_condition_code(), Code::Seta_rm8);
	/// assert_eq!(Code::Seta_rm8.negate_condition_code(), Code::Setbe_rm8);
	/// ```
	#[must_use]
	#[allow(clippy::missing_inline_in_public_items)]
	pub fn negate_condition_code(self) -> Self {
		let mut t;

		// SAFETY: All valid input (all Code values) have been tested successfully, the transmutes are correct

		t = (self as u32).wrapping_sub(Code::Jo_rel16 as u32);
		if t <= (Code::Jg_rel32_64 as u32 - Code::Jo_rel16 as u32) {
			// They're ordered, eg. je_16, je_32, je_64, jne_16, jne_32, jne_64
			// if low 3, add 3, else if high 3, subtract 3.
			if ((t / 3) & 1) != 0 {
				return unsafe { mem::transmute(self as CodeUnderlyingType - 3) };
			}
			return unsafe { mem::transmute(self as CodeUnderlyingType + 3) };
		}

		t = (self as u32).wrapping_sub(Code::Jo_rel8_16 as u32);
		if t <= (Code::Jg_rel8_64 as u32 - Code::Jo_rel8_16 as u32) {
			if ((t / 3) & 1) != 0 {
				return unsafe { mem::transmute(self as CodeUnderlyingType - 3) };
			}
			return unsafe { mem::transmute(self as CodeUnderlyingType + 3) };
		}

		t = (self as u32).wrapping_sub(Code::Cmovo_r16_rm16 as u32);
		if t <= (Code::Cmovg_r64_rm64 as u32 - Code::Cmovo_r16_rm16 as u32) {
			if ((t / 3) & 1) != 0 {
				return unsafe { mem::transmute(self as CodeUnderlyingType - 3) };
			}
			return unsafe { mem::transmute(self as CodeUnderlyingType + 3) };
		}

		t = (self as u32).wrapping_sub(Code::Seto_rm8 as u32);
		if t <= (Code::Setg_rm8 as u32 - Code::Seto_rm8 as u32) {
			return unsafe { mem::transmute(((t ^ 1) + Code::Seto_rm8 as u32) as CodeUnderlyingType) };
		}

		const_assert_eq!(Code::Loopne_rel8_16_CX as u32 + 7, Code::Loope_rel8_16_CX as u32);
		t = (self as u32).wrapping_sub(Code::Loopne_rel8_16_CX as u32);
		if t <= (Code::Loope_rel8_64_RCX as u32 - Code::Loopne_rel8_16_CX as u32) {
			return unsafe { mem::transmute((Code::Loopne_rel8_16_CX as u32 + (t + 7) % 14) as CodeUnderlyingType) };
		}

		#[cfg(feature = "mvex")]
		{
			match self {
				Code::VEX_KNC_Jkzd_kr_rel8_64 => return Code::VEX_KNC_Jknzd_kr_rel8_64,
				Code::VEX_KNC_Jknzd_kr_rel8_64 => return Code::VEX_KNC_Jkzd_kr_rel8_64,
				Code::VEX_KNC_Jkzd_kr_rel32_64 => return Code::VEX_KNC_Jknzd_kr_rel32_64,
				Code::VEX_KNC_Jknzd_kr_rel32_64 => return Code::VEX_KNC_Jkzd_kr_rel32_64,
				_ => {}
			}
		}

		self
	}

	/// Converts `Jcc/JMP NEAR` to `Jcc/JMP SHORT`. Returns the input if it's not a `Jcc/JMP NEAR` instruction.
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert_eq!(Code::Jbe_rel32_64.as_short_branch(), Code::Jbe_rel8_64);
	/// assert_eq!(Code::Jbe_rel8_64.as_short_branch(), Code::Jbe_rel8_64);
	/// assert_eq!(Code::Pause.as_short_branch(), Code::Pause);
	/// ```
	#[must_use]
	#[allow(clippy::missing_inline_in_public_items)]
	pub fn as_short_branch(self) -> Self {
		let mut t;

		// SAFETY: All valid input (all Code values) have been tested successfully, the transmutes are correct

		t = (self as u32).wrapping_sub(Code::Jo_rel16 as u32);
		if t <= (Code::Jg_rel32_64 as u32 - Code::Jo_rel16 as u32) {
			return unsafe { mem::transmute((t + Code::Jo_rel8_16 as u32) as CodeUnderlyingType) };
		}

		t = (self as u32).wrapping_sub(Code::Jmp_rel16 as u32);
		if t <= (Code::Jmp_rel32_64 as u32 - Code::Jmp_rel16 as u32) {
			return unsafe { mem::transmute((t + Code::Jmp_rel8_16 as u32) as CodeUnderlyingType) };
		}

		#[cfg(feature = "mvex")]
		{
			match self {
				Code::VEX_KNC_Jkzd_kr_rel32_64 => return Code::VEX_KNC_Jkzd_kr_rel8_64,
				Code::VEX_KNC_Jknzd_kr_rel32_64 => return Code::VEX_KNC_Jknzd_kr_rel8_64,
				_ => {}
			}
		}

		self
	}

	/// Converts `Jcc/JMP SHORT` to `Jcc/JMP NEAR`. Returns the input if it's not a `Jcc/JMP SHORT` instruction.
	///
	/// # Examples
	///
	/// ```
	/// use iced_x86::*;
	/// assert_eq!(Code::Jbe_rel8_64.as_near_branch(), Code::Jbe_rel32_64);
	/// assert_eq!(Code::Jbe_rel32_64.as_near_branch(), Code::Jbe_rel32_64);
	/// assert_eq!(Code::Pause.as_near_branch(), Code::Pause);
	/// ```
	#[must_use]
	#[allow(clippy::missing_inline_in_public_items)]
	pub fn as_near_branch(self) -> Self {
		let mut t;

		// SAFETY: All valid input (all Code values) have been tested successfully, the transmutes are correct

		t = (self as u32).wrapping_sub(Code::Jo_rel8_16 as u32);
		if t <= (Code::Jg_rel8_64 as u32 - Code::Jo_rel8_16 as u32) {
			return unsafe { mem::transmute((t + Code::Jo_rel16 as u32) as CodeUnderlyingType) };
		}

		t = (self as u32).wrapping_sub(Code::Jmp_rel8_16 as u32);
		if t <= (Code::Jmp_rel8_64 as u32 - Code::Jmp_rel8_16 as u32) {
			return unsafe { mem::transmute((t + Code::Jmp_rel16 as u32) as CodeUnderlyingType) };
		}

		#[cfg(feature = "mvex")]
		{
			match self {
				Code::VEX_KNC_Jkzd_kr_rel8_64 => return Code::VEX_KNC_Jkzd_kr_rel32_64,
				Code::VEX_KNC_Jknzd_kr_rel8_64 => return Code::VEX_KNC_Jknzd_kr_rel32_64,
				_ => {}
			}
		}

		self
	}
}

impl Code {
	#[must_use]
	#[allow(clippy::match_like_matches_macro)]
	pub(crate) fn ignores_segment(self) -> bool {
		#[cfg_attr(feature = "cargo-fmt", rustfmt::skip)]
		match self {
			// GENERATOR-BEGIN: IgnoresSegmentTable
			// ⚠️This was generated by GENERATOR!🦹‍♂️
			Code::Lea_r16_m
			| Code::Lea_r32_m
			| Code::Lea_r64_m
			| Code::Bndcl_bnd_rm32
			| Code::Bndcl_bnd_rm64
			| Code::Bndcu_bnd_rm32
			| Code::Bndcu_bnd_rm64
			| Code::Bndmk_bnd_m32
			| Code::Bndmk_bnd_m64
			| Code::Bndcn_bnd_rm32
			| Code::Bndcn_bnd_rm64
			=> true,
			// GENERATOR-END: IgnoresSegmentTable
			_ => false,
		}
	}

	#[must_use]
	#[inline]
	#[allow(clippy::match_like_matches_macro)]
	pub(crate) fn ignores_index(self) -> bool {
		#[cfg_attr(feature = "cargo-fmt", rustfmt::skip)]
		match self {
			// GENERATOR-BEGIN: IgnoresIndexTable
			// ⚠️This was generated by GENERATOR!🦹‍♂️
			Code::Bndldx_bnd_mib
			| Code::Bndstx_mib_bnd
			=> true,
			// GENERATOR-END: IgnoresIndexTable
			_ => false,
		}
	}

	#[must_use]
	#[inline]
	pub(crate) fn is_tile_stride_index(self) -> bool {
		#[cfg_attr(feature = "cargo-fmt", rustfmt::skip)]
		match self {
			// GENERATOR-BEGIN: TileStrideIndexTable
			// ⚠️This was generated by GENERATOR!🦹‍♂️
			#[cfg(not(feature = "no_vex"))]
			Code::VEX_Tileloaddt1_tmm_sibmem
			| Code::VEX_Tilestored_sibmem_tmm
			| Code::VEX_Tileloadd_tmm_sibmem
			=> true,
			// GENERATOR-END: TileStrideIndexTable
			_ => false,
		}
	}
}
