// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::formatter::iced_constants::IcedConstants;
use crate::formatter::iced_error::IcedError;
use core::convert::TryFrom;
use core::iter::{ExactSizeIterator, FusedIterator, Iterator};
use core::{fmt, mem};

// GENERATOR-BEGIN: NumberBase
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Number base
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
pub enum NumberBase {
	/// Hex numbers (base 16)
	Hexadecimal = 0,
	/// Decimal numbers (base 10)
	Decimal = 1,
	/// Octal numbers (base 8)
	Octal = 2,
	/// Binary numbers (base 2)
	Binary = 3,
}
#[rustfmt::skip]
static GEN_DEBUG_NUMBER_BASE: [&str; 4] = [
	"Hexadecimal",
	"Decimal",
	"Octal",
	"Binary",
];
impl fmt::Debug for NumberBase {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_NUMBER_BASE[*self as usize])
	}
}
impl Default for NumberBase {
	#[must_use]
	#[inline]
	fn default() -> Self {
		NumberBase::Hexadecimal
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type NumberBaseUnderlyingType = u8;
#[rustfmt::skip]
impl NumberBase {
	/// Iterates over all `NumberBase` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = NumberBase> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::NUMBER_BASE_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, NumberBase>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_numberbase_values() {
	let mut iter = NumberBase::values();
	assert_eq!(iter.size_hint(), (IcedConstants::NUMBER_BASE_ENUM_COUNT, Some(IcedConstants::NUMBER_BASE_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::NUMBER_BASE_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::NUMBER_BASE_ENUM_COUNT - 1, Some(IcedConstants::NUMBER_BASE_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::NUMBER_BASE_ENUM_COUNT - 1);

	let values: Vec<NumberBase> = NumberBase::values().collect();
	assert_eq!(values.len(), IcedConstants::NUMBER_BASE_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<NumberBase> = NumberBase::values().collect();
	let mut values2: Vec<NumberBase> = NumberBase::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for NumberBase {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::NUMBER_BASE_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid NumberBase value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_numberbase_try_from_usize() {
	for value in NumberBase::values() {
		let converted = <NumberBase as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<NumberBase as TryFrom<usize>>::try_from(IcedConstants::NUMBER_BASE_ENUM_COUNT).is_err());
	assert!(<NumberBase as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = NumberBase;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("NumberBase", *self as u32, GEN_DEBUG_NUMBER_BASE[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid NumberBase variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_NUMBER_BASE.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["NumberBase enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum NumberBase")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("NumberBase", &GEN_DEBUG_NUMBER_BASE[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: NumberBase

// GENERATOR-BEGIN: FormatMnemonicOptions
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Format mnemonic options
#[allow(missing_copy_implementations)]
#[allow(missing_debug_implementations)]
pub struct FormatMnemonicOptions;
impl FormatMnemonicOptions {
	/// No option is set
	pub const NONE: u32 = 0x0000_0000;
	/// Don't add any prefixes
	pub const NO_PREFIXES: u32 = 0x0000_0001;
	/// Don't add the mnemonic
	pub const NO_MNEMONIC: u32 = 0x0000_0002;
}
// GENERATOR-END: FormatMnemonicOptions

// GENERATOR-BEGIN: PrefixKind
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Prefix
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[cfg_attr(not(feature = "exhaustive_enums"), non_exhaustive)]
#[allow(missing_docs)]
pub enum PrefixKind {
	ES = 0,
	CS = 1,
	SS = 2,
	DS = 3,
	FS = 4,
	GS = 5,
	Lock = 6,
	Rep = 7,
	Repe = 8,
	Repne = 9,
	OperandSize = 10,
	AddressSize = 11,
	HintNotTaken = 12,
	HintTaken = 13,
	Bnd = 14,
	Notrack = 15,
	Xacquire = 16,
	Xrelease = 17,
}
#[rustfmt::skip]
static GEN_DEBUG_PREFIX_KIND: [&str; 18] = [
	"ES",
	"CS",
	"SS",
	"DS",
	"FS",
	"GS",
	"Lock",
	"Rep",
	"Repe",
	"Repne",
	"OperandSize",
	"AddressSize",
	"HintNotTaken",
	"HintTaken",
	"Bnd",
	"Notrack",
	"Xacquire",
	"Xrelease",
];
impl fmt::Debug for PrefixKind {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_PREFIX_KIND[*self as usize])
	}
}
impl Default for PrefixKind {
	#[must_use]
	#[inline]
	fn default() -> Self {
		PrefixKind::ES
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type PrefixKindUnderlyingType = u8;
#[rustfmt::skip]
impl PrefixKind {
	/// Iterates over all `PrefixKind` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = PrefixKind> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::PREFIX_KIND_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, PrefixKind>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_prefixkind_values() {
	let mut iter = PrefixKind::values();
	assert_eq!(iter.size_hint(), (IcedConstants::PREFIX_KIND_ENUM_COUNT, Some(IcedConstants::PREFIX_KIND_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::PREFIX_KIND_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::PREFIX_KIND_ENUM_COUNT - 1, Some(IcedConstants::PREFIX_KIND_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::PREFIX_KIND_ENUM_COUNT - 1);

	let values: Vec<PrefixKind> = PrefixKind::values().collect();
	assert_eq!(values.len(), IcedConstants::PREFIX_KIND_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<PrefixKind> = PrefixKind::values().collect();
	let mut values2: Vec<PrefixKind> = PrefixKind::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for PrefixKind {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::PREFIX_KIND_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid PrefixKind value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_prefixkind_try_from_usize() {
	for value in PrefixKind::values() {
		let converted = <PrefixKind as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<PrefixKind as TryFrom<usize>>::try_from(IcedConstants::PREFIX_KIND_ENUM_COUNT).is_err());
	assert!(<PrefixKind as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = PrefixKind;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("PrefixKind", *self as u32, GEN_DEBUG_PREFIX_KIND[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid PrefixKind variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_PREFIX_KIND.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["PrefixKind enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum PrefixKind")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("PrefixKind", &GEN_DEBUG_PREFIX_KIND[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: PrefixKind

// GENERATOR-BEGIN: DecoratorKind
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Decorator
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[cfg_attr(not(feature = "exhaustive_enums"), non_exhaustive)]
pub enum DecoratorKind {
	/// Broadcast decorator, eg. `{1to4}`
	Broadcast = 0,
	/// Rounding control, eg. `{rd-sae}`
	RoundingControl = 1,
	/// Suppress all exceptions: `{sae}`
	SuppressAllExceptions = 2,
	/// Zeroing masking: `{z}`
	ZeroingMasking = 3,
	/// MVEX swizzle or memory up/down conversion: `{dacb}` or `{sint16}`
	SwizzleMemConv = 4,
	/// MVEX eviction hint: `{eh}`
	EvictionHint = 5,
}
#[rustfmt::skip]
static GEN_DEBUG_DECORATOR_KIND: [&str; 6] = [
	"Broadcast",
	"RoundingControl",
	"SuppressAllExceptions",
	"ZeroingMasking",
	"SwizzleMemConv",
	"EvictionHint",
];
impl fmt::Debug for DecoratorKind {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_DECORATOR_KIND[*self as usize])
	}
}
impl Default for DecoratorKind {
	#[must_use]
	#[inline]
	fn default() -> Self {
		DecoratorKind::Broadcast
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type DecoratorKindUnderlyingType = u8;
#[rustfmt::skip]
impl DecoratorKind {
	/// Iterates over all `DecoratorKind` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = DecoratorKind> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::DECORATOR_KIND_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, DecoratorKind>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_decoratorkind_values() {
	let mut iter = DecoratorKind::values();
	assert_eq!(iter.size_hint(), (IcedConstants::DECORATOR_KIND_ENUM_COUNT, Some(IcedConstants::DECORATOR_KIND_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::DECORATOR_KIND_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::DECORATOR_KIND_ENUM_COUNT - 1, Some(IcedConstants::DECORATOR_KIND_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::DECORATOR_KIND_ENUM_COUNT - 1);

	let values: Vec<DecoratorKind> = DecoratorKind::values().collect();
	assert_eq!(values.len(), IcedConstants::DECORATOR_KIND_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<DecoratorKind> = DecoratorKind::values().collect();
	let mut values2: Vec<DecoratorKind> = DecoratorKind::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for DecoratorKind {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::DECORATOR_KIND_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid DecoratorKind value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_decoratorkind_try_from_usize() {
	for value in DecoratorKind::values() {
		let converted = <DecoratorKind as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<DecoratorKind as TryFrom<usize>>::try_from(IcedConstants::DECORATOR_KIND_ENUM_COUNT).is_err());
	assert!(<DecoratorKind as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = DecoratorKind;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("DecoratorKind", *self as u32, GEN_DEBUG_DECORATOR_KIND[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid DecoratorKind variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_DECORATOR_KIND.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["DecoratorKind enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum DecoratorKind")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("DecoratorKind", &GEN_DEBUG_DECORATOR_KIND[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: DecoratorKind

// GENERATOR-BEGIN: NumberKind
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Number kind
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[cfg_attr(not(feature = "exhaustive_enums"), non_exhaustive)]
#[allow(missing_docs)]
pub enum NumberKind {
	Int8 = 0,
	UInt8 = 1,
	Int16 = 2,
	UInt16 = 3,
	Int32 = 4,
	UInt32 = 5,
	Int64 = 6,
	UInt64 = 7,
}
#[rustfmt::skip]
static GEN_DEBUG_NUMBER_KIND: [&str; 8] = [
	"Int8",
	"UInt8",
	"Int16",
	"UInt16",
	"Int32",
	"UInt32",
	"Int64",
	"UInt64",
];
impl fmt::Debug for NumberKind {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_NUMBER_KIND[*self as usize])
	}
}
impl Default for NumberKind {
	#[must_use]
	#[inline]
	fn default() -> Self {
		NumberKind::Int8
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type NumberKindUnderlyingType = u8;
#[rustfmt::skip]
impl NumberKind {
	/// Iterates over all `NumberKind` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = NumberKind> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::NUMBER_KIND_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, NumberKind>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_numberkind_values() {
	let mut iter = NumberKind::values();
	assert_eq!(iter.size_hint(), (IcedConstants::NUMBER_KIND_ENUM_COUNT, Some(IcedConstants::NUMBER_KIND_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::NUMBER_KIND_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::NUMBER_KIND_ENUM_COUNT - 1, Some(IcedConstants::NUMBER_KIND_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::NUMBER_KIND_ENUM_COUNT - 1);

	let values: Vec<NumberKind> = NumberKind::values().collect();
	assert_eq!(values.len(), IcedConstants::NUMBER_KIND_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<NumberKind> = NumberKind::values().collect();
	let mut values2: Vec<NumberKind> = NumberKind::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for NumberKind {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::NUMBER_KIND_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid NumberKind value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_numberkind_try_from_usize() {
	for value in NumberKind::values() {
		let converted = <NumberKind as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<NumberKind as TryFrom<usize>>::try_from(IcedConstants::NUMBER_KIND_ENUM_COUNT).is_err());
	assert!(<NumberKind as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = NumberKind;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("NumberKind", *self as u32, GEN_DEBUG_NUMBER_KIND[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid NumberKind variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_NUMBER_KIND.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["NumberKind enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum NumberKind")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("NumberKind", &GEN_DEBUG_NUMBER_KIND[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: NumberKind

// GENERATOR-BEGIN: FormatterFlowControl
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(dead_code)]
pub(crate) enum FormatterFlowControl {
	AlwaysShortBranch,
	ShortBranch,
	NearBranch,
	NearCall,
	FarBranch,
	FarCall,
	Xbegin,
}
#[rustfmt::skip]
static GEN_DEBUG_FORMATTER_FLOW_CONTROL: [&str; 7] = [
	"AlwaysShortBranch",
	"ShortBranch",
	"NearBranch",
	"NearCall",
	"FarBranch",
	"FarCall",
	"Xbegin",
];
impl fmt::Debug for FormatterFlowControl {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_FORMATTER_FLOW_CONTROL[*self as usize])
	}
}
impl Default for FormatterFlowControl {
	#[must_use]
	#[inline]
	fn default() -> Self {
		FormatterFlowControl::AlwaysShortBranch
	}
}
// GENERATOR-END: FormatterFlowControl

// GENERATOR-BEGIN: CC_b
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JB` / `JC` / `JNAE`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_b {
	/// `JB`, `CMOVB`, `SETB`
	b = 0,
	/// `JC`, `CMOVC`, `SETC`
	c = 1,
	/// `JNAE`, `CMOVNAE`, `SETNAE`
	nae = 2,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_B: [&str; 3] = [
	"b",
	"c",
	"nae",
];
impl fmt::Debug for CC_b {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_B[*self as usize])
	}
}
impl Default for CC_b {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_b::b
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_bUnderlyingType = u8;
#[rustfmt::skip]
impl CC_b {
	/// Iterates over all `CC_b` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_b> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_B_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_b>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_b_values() {
	let mut iter = CC_b::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_B_ENUM_COUNT, Some(IcedConstants::CC_B_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_B_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_B_ENUM_COUNT - 1, Some(IcedConstants::CC_B_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_B_ENUM_COUNT - 1);

	let values: Vec<CC_b> = CC_b::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_B_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_b> = CC_b::values().collect();
	let mut values2: Vec<CC_b> = CC_b::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_b {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_B_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_b value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_b_try_from_usize() {
	for value in CC_b::values() {
		let converted = <CC_b as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_b as TryFrom<usize>>::try_from(IcedConstants::CC_B_ENUM_COUNT).is_err());
	assert!(<CC_b as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_b;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_b", *self as u32, GEN_DEBUG_CC_B[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_b variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_B.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_b enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_b")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_b", &GEN_DEBUG_CC_B[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_b

// GENERATOR-BEGIN: CC_ae
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JAE` / `JNB` / `JNC`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_ae {
	/// `JAE`, `CMOVAE`, `SETAE`
	ae = 0,
	/// `JNB`, `CMOVNB`, `SETNB`
	nb = 1,
	/// `JNC`, `CMOVNC`, `SETNC`
	nc = 2,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_AE: [&str; 3] = [
	"ae",
	"nb",
	"nc",
];
impl fmt::Debug for CC_ae {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_AE[*self as usize])
	}
}
impl Default for CC_ae {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_ae::ae
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_aeUnderlyingType = u8;
#[rustfmt::skip]
impl CC_ae {
	/// Iterates over all `CC_ae` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_ae> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_AE_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_ae>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_ae_values() {
	let mut iter = CC_ae::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_AE_ENUM_COUNT, Some(IcedConstants::CC_AE_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_AE_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_AE_ENUM_COUNT - 1, Some(IcedConstants::CC_AE_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_AE_ENUM_COUNT - 1);

	let values: Vec<CC_ae> = CC_ae::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_AE_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_ae> = CC_ae::values().collect();
	let mut values2: Vec<CC_ae> = CC_ae::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_ae {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_AE_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_ae value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_ae_try_from_usize() {
	for value in CC_ae::values() {
		let converted = <CC_ae as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_ae as TryFrom<usize>>::try_from(IcedConstants::CC_AE_ENUM_COUNT).is_err());
	assert!(<CC_ae as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_ae;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_ae", *self as u32, GEN_DEBUG_CC_AE[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_ae variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_AE.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_ae enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_ae")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_ae", &GEN_DEBUG_CC_AE[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_ae

// GENERATOR-BEGIN: CC_e
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JE` / `JZ`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_e {
	/// `JE`, `CMOVE`, `SETE`, `LOOPE`, `REPE`
	e = 0,
	/// `JZ`, `CMOVZ`, `SETZ`, `LOOPZ`, `REPZ`
	z = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_E: [&str; 2] = [
	"e",
	"z",
];
impl fmt::Debug for CC_e {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_E[*self as usize])
	}
}
impl Default for CC_e {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_e::e
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_eUnderlyingType = u8;
#[rustfmt::skip]
impl CC_e {
	/// Iterates over all `CC_e` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_e> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_E_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_e>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_e_values() {
	let mut iter = CC_e::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_E_ENUM_COUNT, Some(IcedConstants::CC_E_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_E_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_E_ENUM_COUNT - 1, Some(IcedConstants::CC_E_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_E_ENUM_COUNT - 1);

	let values: Vec<CC_e> = CC_e::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_E_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_e> = CC_e::values().collect();
	let mut values2: Vec<CC_e> = CC_e::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_e {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_E_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_e value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_e_try_from_usize() {
	for value in CC_e::values() {
		let converted = <CC_e as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_e as TryFrom<usize>>::try_from(IcedConstants::CC_E_ENUM_COUNT).is_err());
	assert!(<CC_e as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_e;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_e", *self as u32, GEN_DEBUG_CC_E[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_e variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_E.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_e enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_e")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_e", &GEN_DEBUG_CC_E[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_e

// GENERATOR-BEGIN: CC_ne
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JNE` / `JNZ`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_ne {
	/// `JNE`, `CMOVNE`, `SETNE`, `LOOPNE`, `REPNE`
	ne = 0,
	/// `JNZ`, `CMOVNZ`, `SETNZ`, `LOOPNZ`, `REPNZ`
	nz = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_NE: [&str; 2] = [
	"ne",
	"nz",
];
impl fmt::Debug for CC_ne {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_NE[*self as usize])
	}
}
impl Default for CC_ne {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_ne::ne
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_neUnderlyingType = u8;
#[rustfmt::skip]
impl CC_ne {
	/// Iterates over all `CC_ne` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_ne> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_NE_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_ne>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_ne_values() {
	let mut iter = CC_ne::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_NE_ENUM_COUNT, Some(IcedConstants::CC_NE_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_NE_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_NE_ENUM_COUNT - 1, Some(IcedConstants::CC_NE_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_NE_ENUM_COUNT - 1);

	let values: Vec<CC_ne> = CC_ne::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_NE_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_ne> = CC_ne::values().collect();
	let mut values2: Vec<CC_ne> = CC_ne::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_ne {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_NE_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_ne value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_ne_try_from_usize() {
	for value in CC_ne::values() {
		let converted = <CC_ne as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_ne as TryFrom<usize>>::try_from(IcedConstants::CC_NE_ENUM_COUNT).is_err());
	assert!(<CC_ne as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_ne;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_ne", *self as u32, GEN_DEBUG_CC_NE[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_ne variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_NE.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_ne enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_ne")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_ne", &GEN_DEBUG_CC_NE[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_ne

// GENERATOR-BEGIN: CC_be
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JBE` / `JNA`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_be {
	/// `JBE`, `CMOVBE`, `SETBE`
	be = 0,
	/// `JNA`, `CMOVNA`, `SETNA`
	na = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_BE: [&str; 2] = [
	"be",
	"na",
];
impl fmt::Debug for CC_be {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_BE[*self as usize])
	}
}
impl Default for CC_be {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_be::be
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_beUnderlyingType = u8;
#[rustfmt::skip]
impl CC_be {
	/// Iterates over all `CC_be` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_be> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_BE_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_be>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_be_values() {
	let mut iter = CC_be::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_BE_ENUM_COUNT, Some(IcedConstants::CC_BE_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_BE_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_BE_ENUM_COUNT - 1, Some(IcedConstants::CC_BE_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_BE_ENUM_COUNT - 1);

	let values: Vec<CC_be> = CC_be::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_BE_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_be> = CC_be::values().collect();
	let mut values2: Vec<CC_be> = CC_be::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_be {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_BE_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_be value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_be_try_from_usize() {
	for value in CC_be::values() {
		let converted = <CC_be as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_be as TryFrom<usize>>::try_from(IcedConstants::CC_BE_ENUM_COUNT).is_err());
	assert!(<CC_be as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_be;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_be", *self as u32, GEN_DEBUG_CC_BE[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_be variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_BE.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_be enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_be")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_be", &GEN_DEBUG_CC_BE[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_be

// GENERATOR-BEGIN: CC_a
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JA` / `JNBE`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_a {
	/// `JA`, `CMOVA`, `SETA`
	a = 0,
	/// `JNBE`, `CMOVNBE`, `SETNBE`
	nbe = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_A: [&str; 2] = [
	"a",
	"nbe",
];
impl fmt::Debug for CC_a {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_A[*self as usize])
	}
}
impl Default for CC_a {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_a::a
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_aUnderlyingType = u8;
#[rustfmt::skip]
impl CC_a {
	/// Iterates over all `CC_a` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_a> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_A_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_a>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_a_values() {
	let mut iter = CC_a::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_A_ENUM_COUNT, Some(IcedConstants::CC_A_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_A_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_A_ENUM_COUNT - 1, Some(IcedConstants::CC_A_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_A_ENUM_COUNT - 1);

	let values: Vec<CC_a> = CC_a::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_A_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_a> = CC_a::values().collect();
	let mut values2: Vec<CC_a> = CC_a::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_a {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_A_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_a value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_a_try_from_usize() {
	for value in CC_a::values() {
		let converted = <CC_a as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_a as TryFrom<usize>>::try_from(IcedConstants::CC_A_ENUM_COUNT).is_err());
	assert!(<CC_a as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_a;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_a", *self as u32, GEN_DEBUG_CC_A[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_a variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_A.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_a enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_a")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_a", &GEN_DEBUG_CC_A[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_a

// GENERATOR-BEGIN: CC_p
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JP` / `JPE`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_p {
	/// `JP`, `CMOVP`, `SETP`
	p = 0,
	/// `JPE`, `CMOVPE`, `SETPE`
	pe = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_P: [&str; 2] = [
	"p",
	"pe",
];
impl fmt::Debug for CC_p {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_P[*self as usize])
	}
}
impl Default for CC_p {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_p::p
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_pUnderlyingType = u8;
#[rustfmt::skip]
impl CC_p {
	/// Iterates over all `CC_p` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_p> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_P_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_p>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_p_values() {
	let mut iter = CC_p::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_P_ENUM_COUNT, Some(IcedConstants::CC_P_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_P_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_P_ENUM_COUNT - 1, Some(IcedConstants::CC_P_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_P_ENUM_COUNT - 1);

	let values: Vec<CC_p> = CC_p::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_P_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_p> = CC_p::values().collect();
	let mut values2: Vec<CC_p> = CC_p::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_p {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_P_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_p value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_p_try_from_usize() {
	for value in CC_p::values() {
		let converted = <CC_p as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_p as TryFrom<usize>>::try_from(IcedConstants::CC_P_ENUM_COUNT).is_err());
	assert!(<CC_p as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_p;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_p", *self as u32, GEN_DEBUG_CC_P[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_p variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_P.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_p enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_p")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_p", &GEN_DEBUG_CC_P[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_p

// GENERATOR-BEGIN: CC_np
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JNP` / `JPO`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_np {
	/// `JNP`, `CMOVNP`, `SETNP`
	np = 0,
	/// `JPO`, `CMOVPO`, `SETPO`
	po = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_NP: [&str; 2] = [
	"np",
	"po",
];
impl fmt::Debug for CC_np {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_NP[*self as usize])
	}
}
impl Default for CC_np {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_np::np
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_npUnderlyingType = u8;
#[rustfmt::skip]
impl CC_np {
	/// Iterates over all `CC_np` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_np> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_NP_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_np>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_np_values() {
	let mut iter = CC_np::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_NP_ENUM_COUNT, Some(IcedConstants::CC_NP_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_NP_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_NP_ENUM_COUNT - 1, Some(IcedConstants::CC_NP_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_NP_ENUM_COUNT - 1);

	let values: Vec<CC_np> = CC_np::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_NP_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_np> = CC_np::values().collect();
	let mut values2: Vec<CC_np> = CC_np::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_np {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_NP_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_np value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_np_try_from_usize() {
	for value in CC_np::values() {
		let converted = <CC_np as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_np as TryFrom<usize>>::try_from(IcedConstants::CC_NP_ENUM_COUNT).is_err());
	assert!(<CC_np as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_np;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_np", *self as u32, GEN_DEBUG_CC_NP[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_np variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_NP.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_np enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_np")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_np", &GEN_DEBUG_CC_NP[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_np

// GENERATOR-BEGIN: CC_l
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JL` / `JNGE`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_l {
	/// `JL`, `CMOVL`, `SETL`
	l = 0,
	/// `JNGE`, `CMOVNGE`, `SETNGE`
	nge = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_L: [&str; 2] = [
	"l",
	"nge",
];
impl fmt::Debug for CC_l {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_L[*self as usize])
	}
}
impl Default for CC_l {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_l::l
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_lUnderlyingType = u8;
#[rustfmt::skip]
impl CC_l {
	/// Iterates over all `CC_l` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_l> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_L_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_l>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_l_values() {
	let mut iter = CC_l::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_L_ENUM_COUNT, Some(IcedConstants::CC_L_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_L_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_L_ENUM_COUNT - 1, Some(IcedConstants::CC_L_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_L_ENUM_COUNT - 1);

	let values: Vec<CC_l> = CC_l::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_L_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_l> = CC_l::values().collect();
	let mut values2: Vec<CC_l> = CC_l::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_l {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_L_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_l value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_l_try_from_usize() {
	for value in CC_l::values() {
		let converted = <CC_l as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_l as TryFrom<usize>>::try_from(IcedConstants::CC_L_ENUM_COUNT).is_err());
	assert!(<CC_l as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_l;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_l", *self as u32, GEN_DEBUG_CC_L[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_l variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_L.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_l enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_l")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_l", &GEN_DEBUG_CC_L[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_l

// GENERATOR-BEGIN: CC_ge
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JGE` / `JNL`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_ge {
	/// `JGE`, `CMOVGE`, `SETGE`
	ge = 0,
	/// `JNL`, `CMOVNL`, `SETNL`
	nl = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_GE: [&str; 2] = [
	"ge",
	"nl",
];
impl fmt::Debug for CC_ge {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_GE[*self as usize])
	}
}
impl Default for CC_ge {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_ge::ge
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_geUnderlyingType = u8;
#[rustfmt::skip]
impl CC_ge {
	/// Iterates over all `CC_ge` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_ge> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_GE_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_ge>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_ge_values() {
	let mut iter = CC_ge::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_GE_ENUM_COUNT, Some(IcedConstants::CC_GE_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_GE_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_GE_ENUM_COUNT - 1, Some(IcedConstants::CC_GE_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_GE_ENUM_COUNT - 1);

	let values: Vec<CC_ge> = CC_ge::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_GE_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_ge> = CC_ge::values().collect();
	let mut values2: Vec<CC_ge> = CC_ge::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_ge {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_GE_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_ge value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_ge_try_from_usize() {
	for value in CC_ge::values() {
		let converted = <CC_ge as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_ge as TryFrom<usize>>::try_from(IcedConstants::CC_GE_ENUM_COUNT).is_err());
	assert!(<CC_ge as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_ge;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_ge", *self as u32, GEN_DEBUG_CC_GE[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_ge variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_GE.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_ge enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_ge")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_ge", &GEN_DEBUG_CC_GE[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_ge

// GENERATOR-BEGIN: CC_le
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JLE` / `JNG`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_le {
	/// `JLE`, `CMOVLE`, `SETLE`
	le = 0,
	/// `JNG`, `CMOVNG`, `SETNG`
	ng = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_LE: [&str; 2] = [
	"le",
	"ng",
];
impl fmt::Debug for CC_le {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_LE[*self as usize])
	}
}
impl Default for CC_le {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_le::le
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_leUnderlyingType = u8;
#[rustfmt::skip]
impl CC_le {
	/// Iterates over all `CC_le` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_le> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_LE_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_le>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_le_values() {
	let mut iter = CC_le::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_LE_ENUM_COUNT, Some(IcedConstants::CC_LE_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_LE_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_LE_ENUM_COUNT - 1, Some(IcedConstants::CC_LE_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_LE_ENUM_COUNT - 1);

	let values: Vec<CC_le> = CC_le::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_LE_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_le> = CC_le::values().collect();
	let mut values2: Vec<CC_le> = CC_le::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_le {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_LE_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_le value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_le_try_from_usize() {
	for value in CC_le::values() {
		let converted = <CC_le as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_le as TryFrom<usize>>::try_from(IcedConstants::CC_LE_ENUM_COUNT).is_err());
	assert!(<CC_le as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_le;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_le", *self as u32, GEN_DEBUG_CC_LE[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_le variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_LE.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_le enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_le")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_le", &GEN_DEBUG_CC_LE[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_le

// GENERATOR-BEGIN: CC_g
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic condition code selector (eg. `JG` / `JNLE`)
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[allow(non_camel_case_types)]
pub enum CC_g {
	/// `JG`, `CMOVG`, `SETG`
	g = 0,
	/// `JNLE`, `CMOVNLE`, `SETNLE`
	nle = 1,
}
#[rustfmt::skip]
static GEN_DEBUG_CC_G: [&str; 2] = [
	"g",
	"nle",
];
impl fmt::Debug for CC_g {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CC_G[*self as usize])
	}
}
impl Default for CC_g {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CC_g::g
	}
}
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) type CC_gUnderlyingType = u8;
#[rustfmt::skip]
impl CC_g {
	/// Iterates over all `CC_g` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = CC_g> + DoubleEndedIterator + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::CC_G_ENUM_COUNT).map(|x| unsafe { mem::transmute::<u8, CC_g>(x as u8) })
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_g_values() {
	let mut iter = CC_g::values();
	assert_eq!(iter.size_hint(), (IcedConstants::CC_G_ENUM_COUNT, Some(IcedConstants::CC_G_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::CC_G_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::CC_G_ENUM_COUNT - 1, Some(IcedConstants::CC_G_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::CC_G_ENUM_COUNT - 1);

	let values: Vec<CC_g> = CC_g::values().collect();
	assert_eq!(values.len(), IcedConstants::CC_G_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}

	let values1: Vec<CC_g> = CC_g::values().collect();
	let mut values2: Vec<CC_g> = CC_g::values().rev().collect();
	values2.reverse();
	assert_eq!(values1, values2);
}
#[rustfmt::skip]
impl TryFrom<usize> for CC_g {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::CC_G_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u8) })
		} else {
			Err(IcedError::new("Invalid CC_g value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_cc_g_try_from_usize() {
	for value in CC_g::values() {
		let converted = <CC_g as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<CC_g as TryFrom<usize>>::try_from(IcedConstants::CC_G_ENUM_COUNT).is_err());
	assert!(<CC_g as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
#[cfg(feature = "serde")]
#[rustfmt::skip]
#[allow(clippy::zero_sized_map_values)]
const _: () = {
	use alloc::string::String;
	use core::marker::PhantomData;
	use serde::de::{self, VariantAccess};
	use serde::{Deserialize, Deserializer, Serialize, Serializer};
	type EnumType = CC_g;
	impl Serialize for EnumType {
		#[inline]
		fn serialize<S>(&self, serializer: S) -> Result<S::Ok, S::Error>
		where
			S: Serializer,
		{
			serializer.serialize_unit_variant("CC_g", *self as u32, GEN_DEBUG_CC_G[*self as usize])
		}
	}
	impl<'de> Deserialize<'de> for EnumType {
		#[inline]
		fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
		where
			D: Deserializer<'de>,
		{
			#[repr(transparent)]
			struct EnumValue(EnumType);
			struct EnumValueVisitor;
			impl<'de> de::Visitor<'de> for EnumValueVisitor {
				type Value = EnumValue;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("variant identifier")
				}
				#[inline]
				fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					if let Ok(v) = <usize as TryFrom<_>>::try_from(v) {
						if let Ok(value) = <EnumType as TryFrom<_>>::try_from(v) {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::invalid_value(de::Unexpected::Unsigned(v), &"a valid CC_g variant value"))
				}
				#[inline]
				fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v.as_bytes())
				}
				#[inline]
				fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
				where
					E: de::Error,
				{
					EnumValueVisitor::deserialize_name(v)
				}
			}
			impl EnumValueVisitor {
				#[inline]
				fn deserialize_name<E>(v: &[u8]) -> Result<EnumValue, E>
				where
					E: de::Error,
				{
					for (&name, value) in GEN_DEBUG_CC_G.iter().zip(EnumType::values()) {
						if name.as_bytes() == v {
							return Ok(EnumValue(value));
						}
					}
					Err(de::Error::unknown_variant(&String::from_utf8_lossy(v), &["CC_g enum variants"][..]))
				}
			}
			impl<'de> Deserialize<'de> for EnumValue {
				#[inline]
				fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
				where
					D: Deserializer<'de>,
				{
					deserializer.deserialize_identifier(EnumValueVisitor)
				}
			}
			struct Visitor<'de> {
				marker: PhantomData<EnumType>,
				lifetime: PhantomData<&'de ()>,
			}
			impl<'de> de::Visitor<'de> for Visitor<'de> {
				type Value = EnumType;
				#[inline]
				fn expecting(&self, formatter: &mut fmt::Formatter<'_>) -> fmt::Result {
					formatter.write_str("enum CC_g")
				}
				#[inline]
				fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
				where
					A: de::EnumAccess<'de>,
				{
					let (field, variant): (EnumValue, _) = data.variant()?;
					match variant.unit_variant() {
						Ok(_) => Ok(field.0),
						Err(err) => Err(err),
					}
				}
			}
			deserializer.deserialize_enum("CC_g", &GEN_DEBUG_CC_G[..], Visitor { marker: PhantomData::<EnumType>, lifetime: PhantomData })
		}
	}
};
// GENERATOR-END: CC_g
