// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::MemorySize;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_MEMORY_SIZE_HASH: HashMap<&'static str, MemorySize> = {
		// GENERATOR-BEGIN: MemorySizeHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(141);
		let _ = h.insert("Unknown", MemorySize::Unknown);
		let _ = h.insert("UInt8", MemorySize::UInt8);
		let _ = h.insert("UInt16", MemorySize::UInt16);
		let _ = h.insert("UInt32", MemorySize::UInt32);
		let _ = h.insert("UInt52", MemorySize::UInt52);
		let _ = h.insert("UInt64", MemorySize::UInt64);
		let _ = h.insert("UInt128", MemorySize::UInt128);
		let _ = h.insert("UInt256", MemorySize::UInt256);
		let _ = h.insert("UInt512", MemorySize::UInt512);
		let _ = h.insert("Int8", MemorySize::Int8);
		let _ = h.insert("Int16", MemorySize::Int16);
		let _ = h.insert("Int32", MemorySize::Int32);
		let _ = h.insert("Int64", MemorySize::Int64);
		let _ = h.insert("Int128", MemorySize::Int128);
		let _ = h.insert("Int256", MemorySize::Int256);
		let _ = h.insert("Int512", MemorySize::Int512);
		let _ = h.insert("SegPtr16", MemorySize::SegPtr16);
		let _ = h.insert("SegPtr32", MemorySize::SegPtr32);
		let _ = h.insert("SegPtr64", MemorySize::SegPtr64);
		let _ = h.insert("WordOffset", MemorySize::WordOffset);
		let _ = h.insert("DwordOffset", MemorySize::DwordOffset);
		let _ = h.insert("QwordOffset", MemorySize::QwordOffset);
		let _ = h.insert("Bound16_WordWord", MemorySize::Bound16_WordWord);
		let _ = h.insert("Bound32_DwordDword", MemorySize::Bound32_DwordDword);
		let _ = h.insert("Bnd32", MemorySize::Bnd32);
		let _ = h.insert("Bnd64", MemorySize::Bnd64);
		let _ = h.insert("Fword6", MemorySize::Fword6);
		let _ = h.insert("Fword10", MemorySize::Fword10);
		let _ = h.insert("Float16", MemorySize::Float16);
		let _ = h.insert("Float32", MemorySize::Float32);
		let _ = h.insert("Float64", MemorySize::Float64);
		let _ = h.insert("Float80", MemorySize::Float80);
		let _ = h.insert("Float128", MemorySize::Float128);
		let _ = h.insert("BFloat16", MemorySize::BFloat16);
		let _ = h.insert("FpuEnv14", MemorySize::FpuEnv14);
		let _ = h.insert("FpuEnv28", MemorySize::FpuEnv28);
		let _ = h.insert("FpuState94", MemorySize::FpuState94);
		let _ = h.insert("FpuState108", MemorySize::FpuState108);
		let _ = h.insert("Fxsave_512Byte", MemorySize::Fxsave_512Byte);
		let _ = h.insert("Fxsave64_512Byte", MemorySize::Fxsave64_512Byte);
		let _ = h.insert("Xsave", MemorySize::Xsave);
		let _ = h.insert("Xsave64", MemorySize::Xsave64);
		let _ = h.insert("Bcd", MemorySize::Bcd);
		let _ = h.insert("Tilecfg", MemorySize::Tilecfg);
		let _ = h.insert("Tile", MemorySize::Tile);
		let _ = h.insert("SegmentDescSelector", MemorySize::SegmentDescSelector);
		let _ = h.insert("KLHandleAes128", MemorySize::KLHandleAes128);
		let _ = h.insert("KLHandleAes256", MemorySize::KLHandleAes256);
		let _ = h.insert("Packed16_UInt8", MemorySize::Packed16_UInt8);
		let _ = h.insert("Packed16_Int8", MemorySize::Packed16_Int8);
		let _ = h.insert("Packed32_UInt8", MemorySize::Packed32_UInt8);
		let _ = h.insert("Packed32_Int8", MemorySize::Packed32_Int8);
		let _ = h.insert("Packed32_UInt16", MemorySize::Packed32_UInt16);
		let _ = h.insert("Packed32_Int16", MemorySize::Packed32_Int16);
		let _ = h.insert("Packed32_BFloat16", MemorySize::Packed32_BFloat16);
		let _ = h.insert("Packed64_UInt8", MemorySize::Packed64_UInt8);
		let _ = h.insert("Packed64_Int8", MemorySize::Packed64_Int8);
		let _ = h.insert("Packed64_UInt16", MemorySize::Packed64_UInt16);
		let _ = h.insert("Packed64_Int16", MemorySize::Packed64_Int16);
		let _ = h.insert("Packed64_UInt32", MemorySize::Packed64_UInt32);
		let _ = h.insert("Packed64_Int32", MemorySize::Packed64_Int32);
		let _ = h.insert("Packed64_Float16", MemorySize::Packed64_Float16);
		let _ = h.insert("Packed64_Float32", MemorySize::Packed64_Float32);
		let _ = h.insert("Packed128_UInt8", MemorySize::Packed128_UInt8);
		let _ = h.insert("Packed128_Int8", MemorySize::Packed128_Int8);
		let _ = h.insert("Packed128_UInt16", MemorySize::Packed128_UInt16);
		let _ = h.insert("Packed128_Int16", MemorySize::Packed128_Int16);
		let _ = h.insert("Packed128_UInt32", MemorySize::Packed128_UInt32);
		let _ = h.insert("Packed128_Int32", MemorySize::Packed128_Int32);
		let _ = h.insert("Packed128_UInt52", MemorySize::Packed128_UInt52);
		let _ = h.insert("Packed128_UInt64", MemorySize::Packed128_UInt64);
		let _ = h.insert("Packed128_Int64", MemorySize::Packed128_Int64);
		let _ = h.insert("Packed128_Float16", MemorySize::Packed128_Float16);
		let _ = h.insert("Packed128_Float32", MemorySize::Packed128_Float32);
		let _ = h.insert("Packed128_Float64", MemorySize::Packed128_Float64);
		let _ = h.insert("Packed128_2xBFloat16", MemorySize::Packed128_2xBFloat16);
		let _ = h.insert("Packed256_UInt8", MemorySize::Packed256_UInt8);
		let _ = h.insert("Packed256_Int8", MemorySize::Packed256_Int8);
		let _ = h.insert("Packed256_UInt16", MemorySize::Packed256_UInt16);
		let _ = h.insert("Packed256_Int16", MemorySize::Packed256_Int16);
		let _ = h.insert("Packed256_UInt32", MemorySize::Packed256_UInt32);
		let _ = h.insert("Packed256_Int32", MemorySize::Packed256_Int32);
		let _ = h.insert("Packed256_UInt52", MemorySize::Packed256_UInt52);
		let _ = h.insert("Packed256_UInt64", MemorySize::Packed256_UInt64);
		let _ = h.insert("Packed256_Int64", MemorySize::Packed256_Int64);
		let _ = h.insert("Packed256_UInt128", MemorySize::Packed256_UInt128);
		let _ = h.insert("Packed256_Int128", MemorySize::Packed256_Int128);
		let _ = h.insert("Packed256_Float16", MemorySize::Packed256_Float16);
		let _ = h.insert("Packed256_Float32", MemorySize::Packed256_Float32);
		let _ = h.insert("Packed256_Float64", MemorySize::Packed256_Float64);
		let _ = h.insert("Packed256_Float128", MemorySize::Packed256_Float128);
		let _ = h.insert("Packed256_2xBFloat16", MemorySize::Packed256_2xBFloat16);
		let _ = h.insert("Packed512_UInt8", MemorySize::Packed512_UInt8);
		let _ = h.insert("Packed512_Int8", MemorySize::Packed512_Int8);
		let _ = h.insert("Packed512_UInt16", MemorySize::Packed512_UInt16);
		let _ = h.insert("Packed512_Int16", MemorySize::Packed512_Int16);
		let _ = h.insert("Packed512_UInt32", MemorySize::Packed512_UInt32);
		let _ = h.insert("Packed512_Int32", MemorySize::Packed512_Int32);
		let _ = h.insert("Packed512_UInt52", MemorySize::Packed512_UInt52);
		let _ = h.insert("Packed512_UInt64", MemorySize::Packed512_UInt64);
		let _ = h.insert("Packed512_Int64", MemorySize::Packed512_Int64);
		let _ = h.insert("Packed512_UInt128", MemorySize::Packed512_UInt128);
		let _ = h.insert("Packed512_Float32", MemorySize::Packed512_Float32);
		let _ = h.insert("Packed512_Float64", MemorySize::Packed512_Float64);
		let _ = h.insert("Packed512_2xBFloat16", MemorySize::Packed512_2xBFloat16);
		let _ = h.insert("Broadcast64_UInt32", MemorySize::Broadcast64_UInt32);
		let _ = h.insert("Broadcast64_Int32", MemorySize::Broadcast64_Int32);
		let _ = h.insert("Broadcast64_Float32", MemorySize::Broadcast64_Float32);
		let _ = h.insert("Broadcast128_UInt32", MemorySize::Broadcast128_UInt32);
		let _ = h.insert("Broadcast128_Int32", MemorySize::Broadcast128_Int32);
		let _ = h.insert("Broadcast128_UInt52", MemorySize::Broadcast128_UInt52);
		let _ = h.insert("Broadcast128_UInt64", MemorySize::Broadcast128_UInt64);
		let _ = h.insert("Broadcast128_Int64", MemorySize::Broadcast128_Int64);
		let _ = h.insert("Broadcast128_Float32", MemorySize::Broadcast128_Float32);
		let _ = h.insert("Broadcast128_Float64", MemorySize::Broadcast128_Float64);
		let _ = h.insert("Broadcast256_UInt32", MemorySize::Broadcast256_UInt32);
		let _ = h.insert("Broadcast256_Int32", MemorySize::Broadcast256_Int32);
		let _ = h.insert("Broadcast256_UInt52", MemorySize::Broadcast256_UInt52);
		let _ = h.insert("Broadcast256_UInt64", MemorySize::Broadcast256_UInt64);
		let _ = h.insert("Broadcast256_Int64", MemorySize::Broadcast256_Int64);
		let _ = h.insert("Broadcast256_Float32", MemorySize::Broadcast256_Float32);
		let _ = h.insert("Broadcast256_Float64", MemorySize::Broadcast256_Float64);
		let _ = h.insert("Broadcast512_UInt32", MemorySize::Broadcast512_UInt32);
		let _ = h.insert("Broadcast512_Int32", MemorySize::Broadcast512_Int32);
		let _ = h.insert("Broadcast512_UInt52", MemorySize::Broadcast512_UInt52);
		let _ = h.insert("Broadcast512_UInt64", MemorySize::Broadcast512_UInt64);
		let _ = h.insert("Broadcast512_Int64", MemorySize::Broadcast512_Int64);
		let _ = h.insert("Broadcast512_Float32", MemorySize::Broadcast512_Float32);
		let _ = h.insert("Broadcast512_Float64", MemorySize::Broadcast512_Float64);
		let _ = h.insert("Broadcast128_2xInt16", MemorySize::Broadcast128_2xInt16);
		let _ = h.insert("Broadcast256_2xInt16", MemorySize::Broadcast256_2xInt16);
		let _ = h.insert("Broadcast512_2xInt16", MemorySize::Broadcast512_2xInt16);
		let _ = h.insert("Broadcast128_2xUInt32", MemorySize::Broadcast128_2xUInt32);
		let _ = h.insert("Broadcast256_2xUInt32", MemorySize::Broadcast256_2xUInt32);
		let _ = h.insert("Broadcast512_2xUInt32", MemorySize::Broadcast512_2xUInt32);
		let _ = h.insert("Broadcast128_2xInt32", MemorySize::Broadcast128_2xInt32);
		let _ = h.insert("Broadcast256_2xInt32", MemorySize::Broadcast256_2xInt32);
		let _ = h.insert("Broadcast512_2xInt32", MemorySize::Broadcast512_2xInt32);
		let _ = h.insert("Broadcast128_2xBFloat16", MemorySize::Broadcast128_2xBFloat16);
		let _ = h.insert("Broadcast256_2xBFloat16", MemorySize::Broadcast256_2xBFloat16);
		let _ = h.insert("Broadcast512_2xBFloat16", MemorySize::Broadcast512_2xBFloat16);
		// GENERATOR-END: MemorySizeHash
		h
	};
}
