// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::formatter::tests::enums::OptionsProps;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_OPTIONS_PROPS_HASH: HashMap<&'static str, OptionsProps> = {
		// GENERATOR-BEGIN: OptionsPropsHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(64);
		let _ = h.insert("AddLeadingZeroToHexNumbers", OptionsProps::AddLeadingZeroToHexNumbers);
		let _ = h.insert("AlwaysShowScale", OptionsProps::AlwaysShowScale);
		let _ = h.insert("AlwaysShowSegmentRegister", OptionsProps::AlwaysShowSegmentRegister);
		let _ = h.insert("BinaryDigitGroupSize", OptionsProps::BinaryDigitGroupSize);
		let _ = h.insert("BinaryPrefix", OptionsProps::BinaryPrefix);
		let _ = h.insert("BinarySuffix", OptionsProps::BinarySuffix);
		let _ = h.insert("BranchLeadingZeroes", OptionsProps::BranchLeadingZeroes);
		let _ = h.insert("DecimalDigitGroupSize", OptionsProps::DecimalDigitGroupSize);
		let _ = h.insert("DecimalPrefix", OptionsProps::DecimalPrefix);
		let _ = h.insert("DecimalSuffix", OptionsProps::DecimalSuffix);
		let _ = h.insert("DigitSeparator", OptionsProps::DigitSeparator);
		let _ = h.insert("DisplacementLeadingZeroes", OptionsProps::DisplacementLeadingZeroes);
		let _ = h.insert("FirstOperandCharIndex", OptionsProps::FirstOperandCharIndex);
		let _ = h.insert("GasNakedRegisters", OptionsProps::GasNakedRegisters);
		let _ = h.insert("GasShowMnemonicSizeSuffix", OptionsProps::GasShowMnemonicSizeSuffix);
		let _ = h.insert("GasSpaceAfterMemoryOperandComma", OptionsProps::GasSpaceAfterMemoryOperandComma);
		let _ = h.insert("HexDigitGroupSize", OptionsProps::HexDigitGroupSize);
		let _ = h.insert("HexPrefix", OptionsProps::HexPrefix);
		let _ = h.insert("HexSuffix", OptionsProps::HexSuffix);
		let _ = h.insert("IP", OptionsProps::IP);
		let _ = h.insert("LeadingZeroes", OptionsProps::LeadingZeroes);
		let _ = h.insert("MasmAddDsPrefix32", OptionsProps::MasmAddDsPrefix32);
		let _ = h.insert("MemorySizeOptions", OptionsProps::MemorySizeOptions);
		let _ = h.insert("NasmShowSignExtendedImmediateSize", OptionsProps::NasmShowSignExtendedImmediateSize);
		let _ = h.insert("NumberBase", OptionsProps::NumberBase);
		let _ = h.insert("OctalDigitGroupSize", OptionsProps::OctalDigitGroupSize);
		let _ = h.insert("OctalPrefix", OptionsProps::OctalPrefix);
		let _ = h.insert("OctalSuffix", OptionsProps::OctalSuffix);
		let _ = h.insert("PreferST0", OptionsProps::PreferST0);
		let _ = h.insert("RipRelativeAddresses", OptionsProps::RipRelativeAddresses);
		let _ = h.insert("ScaleBeforeIndex", OptionsProps::ScaleBeforeIndex);
		let _ = h.insert("ShowBranchSize", OptionsProps::ShowBranchSize);
		let _ = h.insert("ShowSymbolAddress", OptionsProps::ShowSymbolAddress);
		let _ = h.insert("ShowZeroDisplacements", OptionsProps::ShowZeroDisplacements);
		let _ = h.insert("SignedImmediateOperands", OptionsProps::SignedImmediateOperands);
		let _ = h.insert("SignedMemoryDisplacements", OptionsProps::SignedMemoryDisplacements);
		let _ = h.insert("SmallHexNumbersInDecimal", OptionsProps::SmallHexNumbersInDecimal);
		let _ = h.insert("SpaceAfterMemoryBracket", OptionsProps::SpaceAfterMemoryBracket);
		let _ = h.insert("SpaceAfterOperandSeparator", OptionsProps::SpaceAfterOperandSeparator);
		let _ = h.insert("SpaceBetweenMemoryAddOperators", OptionsProps::SpaceBetweenMemoryAddOperators);
		let _ = h.insert("SpaceBetweenMemoryMulOperators", OptionsProps::SpaceBetweenMemoryMulOperators);
		let _ = h.insert("TabSize", OptionsProps::TabSize);
		let _ = h.insert("UppercaseAll", OptionsProps::UppercaseAll);
		let _ = h.insert("UppercaseDecorators", OptionsProps::UppercaseDecorators);
		let _ = h.insert("UppercaseHex", OptionsProps::UppercaseHex);
		let _ = h.insert("UppercaseKeywords", OptionsProps::UppercaseKeywords);
		let _ = h.insert("UppercaseMnemonics", OptionsProps::UppercaseMnemonics);
		let _ = h.insert("UppercasePrefixes", OptionsProps::UppercasePrefixes);
		let _ = h.insert("UppercaseRegisters", OptionsProps::UppercaseRegisters);
		let _ = h.insert("UsePseudoOps", OptionsProps::UsePseudoOps);
		let _ = h.insert("CC_b", OptionsProps::CC_b);
		let _ = h.insert("CC_ae", OptionsProps::CC_ae);
		let _ = h.insert("CC_e", OptionsProps::CC_e);
		let _ = h.insert("CC_ne", OptionsProps::CC_ne);
		let _ = h.insert("CC_be", OptionsProps::CC_be);
		let _ = h.insert("CC_a", OptionsProps::CC_a);
		let _ = h.insert("CC_p", OptionsProps::CC_p);
		let _ = h.insert("CC_np", OptionsProps::CC_np);
		let _ = h.insert("CC_l", OptionsProps::CC_l);
		let _ = h.insert("CC_ge", OptionsProps::CC_ge);
		let _ = h.insert("CC_le", OptionsProps::CC_le);
		let _ = h.insert("CC_g", OptionsProps::CC_g);
		let _ = h.insert("DecoderOptions", OptionsProps::DecoderOptions);
		let _ = h.insert("ShowUselessPrefixes", OptionsProps::ShowUselessPrefixes);
		// GENERATOR-END: OptionsPropsHash
		h
	};
}
