// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::OpCodeOperandKind;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_OP_CODE_OPERAND_KIND_HASH: HashMap<&'static str, OpCodeOperandKind> = {
		// GENERATOR-BEGIN: OpCodeOperandKindHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(109);
		let _ = h.insert("None", OpCodeOperandKind::None);
		let _ = h.insert("farbr2_2", OpCodeOperandKind::farbr2_2);
		let _ = h.insert("farbr4_2", OpCodeOperandKind::farbr4_2);
		let _ = h.insert("mem_offs", OpCodeOperandKind::mem_offs);
		let _ = h.insert("mem", OpCodeOperandKind::mem);
		let _ = h.insert("mem_mpx", OpCodeOperandKind::mem_mpx);
		let _ = h.insert("mem_mib", OpCodeOperandKind::mem_mib);
		let _ = h.insert("mem_vsib32x", OpCodeOperandKind::mem_vsib32x);
		let _ = h.insert("mem_vsib64x", OpCodeOperandKind::mem_vsib64x);
		let _ = h.insert("mem_vsib32y", OpCodeOperandKind::mem_vsib32y);
		let _ = h.insert("mem_vsib64y", OpCodeOperandKind::mem_vsib64y);
		let _ = h.insert("mem_vsib32z", OpCodeOperandKind::mem_vsib32z);
		let _ = h.insert("mem_vsib64z", OpCodeOperandKind::mem_vsib64z);
		let _ = h.insert("r8_or_mem", OpCodeOperandKind::r8_or_mem);
		let _ = h.insert("r16_or_mem", OpCodeOperandKind::r16_or_mem);
		let _ = h.insert("r32_or_mem", OpCodeOperandKind::r32_or_mem);
		let _ = h.insert("r32_or_mem_mpx", OpCodeOperandKind::r32_or_mem_mpx);
		let _ = h.insert("r64_or_mem", OpCodeOperandKind::r64_or_mem);
		let _ = h.insert("r64_or_mem_mpx", OpCodeOperandKind::r64_or_mem_mpx);
		let _ = h.insert("mm_or_mem", OpCodeOperandKind::mm_or_mem);
		let _ = h.insert("xmm_or_mem", OpCodeOperandKind::xmm_or_mem);
		let _ = h.insert("ymm_or_mem", OpCodeOperandKind::ymm_or_mem);
		let _ = h.insert("zmm_or_mem", OpCodeOperandKind::zmm_or_mem);
		let _ = h.insert("bnd_or_mem_mpx", OpCodeOperandKind::bnd_or_mem_mpx);
		let _ = h.insert("k_or_mem", OpCodeOperandKind::k_or_mem);
		let _ = h.insert("r8_reg", OpCodeOperandKind::r8_reg);
		let _ = h.insert("r8_opcode", OpCodeOperandKind::r8_opcode);
		let _ = h.insert("r16_reg", OpCodeOperandKind::r16_reg);
		let _ = h.insert("r16_reg_mem", OpCodeOperandKind::r16_reg_mem);
		let _ = h.insert("r16_rm", OpCodeOperandKind::r16_rm);
		let _ = h.insert("r16_opcode", OpCodeOperandKind::r16_opcode);
		let _ = h.insert("r32_reg", OpCodeOperandKind::r32_reg);
		let _ = h.insert("r32_reg_mem", OpCodeOperandKind::r32_reg_mem);
		let _ = h.insert("r32_rm", OpCodeOperandKind::r32_rm);
		let _ = h.insert("r32_opcode", OpCodeOperandKind::r32_opcode);
		let _ = h.insert("r32_vvvv", OpCodeOperandKind::r32_vvvv);
		let _ = h.insert("r64_reg", OpCodeOperandKind::r64_reg);
		let _ = h.insert("r64_reg_mem", OpCodeOperandKind::r64_reg_mem);
		let _ = h.insert("r64_rm", OpCodeOperandKind::r64_rm);
		let _ = h.insert("r64_opcode", OpCodeOperandKind::r64_opcode);
		let _ = h.insert("r64_vvvv", OpCodeOperandKind::r64_vvvv);
		let _ = h.insert("seg_reg", OpCodeOperandKind::seg_reg);
		let _ = h.insert("k_reg", OpCodeOperandKind::k_reg);
		let _ = h.insert("kp1_reg", OpCodeOperandKind::kp1_reg);
		let _ = h.insert("k_rm", OpCodeOperandKind::k_rm);
		let _ = h.insert("k_vvvv", OpCodeOperandKind::k_vvvv);
		let _ = h.insert("mm_reg", OpCodeOperandKind::mm_reg);
		let _ = h.insert("mm_rm", OpCodeOperandKind::mm_rm);
		let _ = h.insert("xmm_reg", OpCodeOperandKind::xmm_reg);
		let _ = h.insert("xmm_rm", OpCodeOperandKind::xmm_rm);
		let _ = h.insert("xmm_vvvv", OpCodeOperandKind::xmm_vvvv);
		let _ = h.insert("xmmp3_vvvv", OpCodeOperandKind::xmmp3_vvvv);
		let _ = h.insert("xmm_is4", OpCodeOperandKind::xmm_is4);
		let _ = h.insert("xmm_is5", OpCodeOperandKind::xmm_is5);
		let _ = h.insert("ymm_reg", OpCodeOperandKind::ymm_reg);
		let _ = h.insert("ymm_rm", OpCodeOperandKind::ymm_rm);
		let _ = h.insert("ymm_vvvv", OpCodeOperandKind::ymm_vvvv);
		let _ = h.insert("ymm_is4", OpCodeOperandKind::ymm_is4);
		let _ = h.insert("ymm_is5", OpCodeOperandKind::ymm_is5);
		let _ = h.insert("zmm_reg", OpCodeOperandKind::zmm_reg);
		let _ = h.insert("zmm_rm", OpCodeOperandKind::zmm_rm);
		let _ = h.insert("zmm_vvvv", OpCodeOperandKind::zmm_vvvv);
		let _ = h.insert("zmmp3_vvvv", OpCodeOperandKind::zmmp3_vvvv);
		let _ = h.insert("cr_reg", OpCodeOperandKind::cr_reg);
		let _ = h.insert("dr_reg", OpCodeOperandKind::dr_reg);
		let _ = h.insert("tr_reg", OpCodeOperandKind::tr_reg);
		let _ = h.insert("bnd_reg", OpCodeOperandKind::bnd_reg);
		let _ = h.insert("es", OpCodeOperandKind::es);
		let _ = h.insert("cs", OpCodeOperandKind::cs);
		let _ = h.insert("ss", OpCodeOperandKind::ss);
		let _ = h.insert("ds", OpCodeOperandKind::ds);
		let _ = h.insert("fs", OpCodeOperandKind::fs);
		let _ = h.insert("gs", OpCodeOperandKind::gs);
		let _ = h.insert("al", OpCodeOperandKind::al);
		let _ = h.insert("cl", OpCodeOperandKind::cl);
		let _ = h.insert("ax", OpCodeOperandKind::ax);
		let _ = h.insert("dx", OpCodeOperandKind::dx);
		let _ = h.insert("eax", OpCodeOperandKind::eax);
		let _ = h.insert("rax", OpCodeOperandKind::rax);
		let _ = h.insert("st0", OpCodeOperandKind::st0);
		let _ = h.insert("sti_opcode", OpCodeOperandKind::sti_opcode);
		let _ = h.insert("imm4_m2z", OpCodeOperandKind::imm4_m2z);
		let _ = h.insert("imm8", OpCodeOperandKind::imm8);
		let _ = h.insert("imm8_const_1", OpCodeOperandKind::imm8_const_1);
		let _ = h.insert("imm8sex16", OpCodeOperandKind::imm8sex16);
		let _ = h.insert("imm8sex32", OpCodeOperandKind::imm8sex32);
		let _ = h.insert("imm8sex64", OpCodeOperandKind::imm8sex64);
		let _ = h.insert("imm16", OpCodeOperandKind::imm16);
		let _ = h.insert("imm32", OpCodeOperandKind::imm32);
		let _ = h.insert("imm32sex64", OpCodeOperandKind::imm32sex64);
		let _ = h.insert("imm64", OpCodeOperandKind::imm64);
		let _ = h.insert("seg_rSI", OpCodeOperandKind::seg_rSI);
		let _ = h.insert("es_rDI", OpCodeOperandKind::es_rDI);
		let _ = h.insert("seg_rDI", OpCodeOperandKind::seg_rDI);
		let _ = h.insert("seg_rBX_al", OpCodeOperandKind::seg_rBX_al);
		let _ = h.insert("br16_1", OpCodeOperandKind::br16_1);
		let _ = h.insert("br32_1", OpCodeOperandKind::br32_1);
		let _ = h.insert("br64_1", OpCodeOperandKind::br64_1);
		let _ = h.insert("br16_2", OpCodeOperandKind::br16_2);
		let _ = h.insert("br32_4", OpCodeOperandKind::br32_4);
		let _ = h.insert("br64_4", OpCodeOperandKind::br64_4);
		let _ = h.insert("xbegin_2", OpCodeOperandKind::xbegin_2);
		let _ = h.insert("xbegin_4", OpCodeOperandKind::xbegin_4);
		let _ = h.insert("brdisp_2", OpCodeOperandKind::brdisp_2);
		let _ = h.insert("brdisp_4", OpCodeOperandKind::brdisp_4);
		let _ = h.insert("sibmem", OpCodeOperandKind::sibmem);
		let _ = h.insert("tmm_reg", OpCodeOperandKind::tmm_reg);
		let _ = h.insert("tmm_rm", OpCodeOperandKind::tmm_rm);
		let _ = h.insert("tmm_vvvv", OpCodeOperandKind::tmm_vvvv);
		// GENERATOR-END: OpCodeOperandKindHash
		h
	};
}
