// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::Mnemonic;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_MNEMONIC_HASH: HashMap<&'static str, Mnemonic> = {
		// GENERATOR-BEGIN: MnemonicHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(1632);
		let _ = h.insert("INVALID", Mnemonic::INVALID);
		let _ = h.insert("Aaa", Mnemonic::Aaa);
		let _ = h.insert("Aad", Mnemonic::Aad);
		let _ = h.insert("Aam", Mnemonic::Aam);
		let _ = h.insert("Aas", Mnemonic::Aas);
		let _ = h.insert("Adc", Mnemonic::Adc);
		let _ = h.insert("Adcx", Mnemonic::Adcx);
		let _ = h.insert("Add", Mnemonic::Add);
		let _ = h.insert("Addpd", Mnemonic::Addpd);
		let _ = h.insert("Addps", Mnemonic::Addps);
		let _ = h.insert("Addsd", Mnemonic::Addsd);
		let _ = h.insert("Addss", Mnemonic::Addss);
		let _ = h.insert("Addsubpd", Mnemonic::Addsubpd);
		let _ = h.insert("Addsubps", Mnemonic::Addsubps);
		let _ = h.insert("Adox", Mnemonic::Adox);
		let _ = h.insert("Aesdec", Mnemonic::Aesdec);
		let _ = h.insert("Aesdeclast", Mnemonic::Aesdeclast);
		let _ = h.insert("Aesenc", Mnemonic::Aesenc);
		let _ = h.insert("Aesenclast", Mnemonic::Aesenclast);
		let _ = h.insert("Aesimc", Mnemonic::Aesimc);
		let _ = h.insert("Aeskeygenassist", Mnemonic::Aeskeygenassist);
		let _ = h.insert("And", Mnemonic::And);
		let _ = h.insert("Andn", Mnemonic::Andn);
		let _ = h.insert("Andnpd", Mnemonic::Andnpd);
		let _ = h.insert("Andnps", Mnemonic::Andnps);
		let _ = h.insert("Andpd", Mnemonic::Andpd);
		let _ = h.insert("Andps", Mnemonic::Andps);
		let _ = h.insert("Arpl", Mnemonic::Arpl);
		let _ = h.insert("Bextr", Mnemonic::Bextr);
		let _ = h.insert("Blcfill", Mnemonic::Blcfill);
		let _ = h.insert("Blci", Mnemonic::Blci);
		let _ = h.insert("Blcic", Mnemonic::Blcic);
		let _ = h.insert("Blcmsk", Mnemonic::Blcmsk);
		let _ = h.insert("Blcs", Mnemonic::Blcs);
		let _ = h.insert("Blendpd", Mnemonic::Blendpd);
		let _ = h.insert("Blendps", Mnemonic::Blendps);
		let _ = h.insert("Blendvpd", Mnemonic::Blendvpd);
		let _ = h.insert("Blendvps", Mnemonic::Blendvps);
		let _ = h.insert("Blsfill", Mnemonic::Blsfill);
		let _ = h.insert("Blsi", Mnemonic::Blsi);
		let _ = h.insert("Blsic", Mnemonic::Blsic);
		let _ = h.insert("Blsmsk", Mnemonic::Blsmsk);
		let _ = h.insert("Blsr", Mnemonic::Blsr);
		let _ = h.insert("Bndcl", Mnemonic::Bndcl);
		let _ = h.insert("Bndcn", Mnemonic::Bndcn);
		let _ = h.insert("Bndcu", Mnemonic::Bndcu);
		let _ = h.insert("Bndldx", Mnemonic::Bndldx);
		let _ = h.insert("Bndmk", Mnemonic::Bndmk);
		let _ = h.insert("Bndmov", Mnemonic::Bndmov);
		let _ = h.insert("Bndstx", Mnemonic::Bndstx);
		let _ = h.insert("Bound", Mnemonic::Bound);
		let _ = h.insert("Bsf", Mnemonic::Bsf);
		let _ = h.insert("Bsr", Mnemonic::Bsr);
		let _ = h.insert("Bswap", Mnemonic::Bswap);
		let _ = h.insert("Bt", Mnemonic::Bt);
		let _ = h.insert("Btc", Mnemonic::Btc);
		let _ = h.insert("Btr", Mnemonic::Btr);
		let _ = h.insert("Bts", Mnemonic::Bts);
		let _ = h.insert("Bzhi", Mnemonic::Bzhi);
		let _ = h.insert("Call", Mnemonic::Call);
		let _ = h.insert("Cbw", Mnemonic::Cbw);
		let _ = h.insert("Cdq", Mnemonic::Cdq);
		let _ = h.insert("Cdqe", Mnemonic::Cdqe);
		let _ = h.insert("Cl1invmb", Mnemonic::Cl1invmb);
		let _ = h.insert("Clac", Mnemonic::Clac);
		let _ = h.insert("Clc", Mnemonic::Clc);
		let _ = h.insert("Cld", Mnemonic::Cld);
		let _ = h.insert("Cldemote", Mnemonic::Cldemote);
		let _ = h.insert("Clflush", Mnemonic::Clflush);
		let _ = h.insert("Clflushopt", Mnemonic::Clflushopt);
		let _ = h.insert("Clgi", Mnemonic::Clgi);
		let _ = h.insert("Cli", Mnemonic::Cli);
		let _ = h.insert("Clrssbsy", Mnemonic::Clrssbsy);
		let _ = h.insert("Clts", Mnemonic::Clts);
		let _ = h.insert("Clwb", Mnemonic::Clwb);
		let _ = h.insert("Clzero", Mnemonic::Clzero);
		let _ = h.insert("Cmc", Mnemonic::Cmc);
		let _ = h.insert("Cmova", Mnemonic::Cmova);
		let _ = h.insert("Cmovae", Mnemonic::Cmovae);
		let _ = h.insert("Cmovb", Mnemonic::Cmovb);
		let _ = h.insert("Cmovbe", Mnemonic::Cmovbe);
		let _ = h.insert("Cmove", Mnemonic::Cmove);
		let _ = h.insert("Cmovg", Mnemonic::Cmovg);
		let _ = h.insert("Cmovge", Mnemonic::Cmovge);
		let _ = h.insert("Cmovl", Mnemonic::Cmovl);
		let _ = h.insert("Cmovle", Mnemonic::Cmovle);
		let _ = h.insert("Cmovne", Mnemonic::Cmovne);
		let _ = h.insert("Cmovno", Mnemonic::Cmovno);
		let _ = h.insert("Cmovnp", Mnemonic::Cmovnp);
		let _ = h.insert("Cmovns", Mnemonic::Cmovns);
		let _ = h.insert("Cmovo", Mnemonic::Cmovo);
		let _ = h.insert("Cmovp", Mnemonic::Cmovp);
		let _ = h.insert("Cmovs", Mnemonic::Cmovs);
		let _ = h.insert("Cmp", Mnemonic::Cmp);
		let _ = h.insert("Cmppd", Mnemonic::Cmppd);
		let _ = h.insert("Cmpps", Mnemonic::Cmpps);
		let _ = h.insert("Cmpsb", Mnemonic::Cmpsb);
		let _ = h.insert("Cmpsd", Mnemonic::Cmpsd);
		let _ = h.insert("Cmpsq", Mnemonic::Cmpsq);
		let _ = h.insert("Cmpss", Mnemonic::Cmpss);
		let _ = h.insert("Cmpsw", Mnemonic::Cmpsw);
		let _ = h.insert("Cmpxchg", Mnemonic::Cmpxchg);
		let _ = h.insert("Cmpxchg16b", Mnemonic::Cmpxchg16b);
		let _ = h.insert("Cmpxchg8b", Mnemonic::Cmpxchg8b);
		let _ = h.insert("Comisd", Mnemonic::Comisd);
		let _ = h.insert("Comiss", Mnemonic::Comiss);
		let _ = h.insert("Cpuid", Mnemonic::Cpuid);
		let _ = h.insert("Cqo", Mnemonic::Cqo);
		let _ = h.insert("Crc32", Mnemonic::Crc32);
		let _ = h.insert("Cvtdq2pd", Mnemonic::Cvtdq2pd);
		let _ = h.insert("Cvtdq2ps", Mnemonic::Cvtdq2ps);
		let _ = h.insert("Cvtpd2dq", Mnemonic::Cvtpd2dq);
		let _ = h.insert("Cvtpd2pi", Mnemonic::Cvtpd2pi);
		let _ = h.insert("Cvtpd2ps", Mnemonic::Cvtpd2ps);
		let _ = h.insert("Cvtpi2pd", Mnemonic::Cvtpi2pd);
		let _ = h.insert("Cvtpi2ps", Mnemonic::Cvtpi2ps);
		let _ = h.insert("Cvtps2dq", Mnemonic::Cvtps2dq);
		let _ = h.insert("Cvtps2pd", Mnemonic::Cvtps2pd);
		let _ = h.insert("Cvtps2pi", Mnemonic::Cvtps2pi);
		let _ = h.insert("Cvtsd2si", Mnemonic::Cvtsd2si);
		let _ = h.insert("Cvtsd2ss", Mnemonic::Cvtsd2ss);
		let _ = h.insert("Cvtsi2sd", Mnemonic::Cvtsi2sd);
		let _ = h.insert("Cvtsi2ss", Mnemonic::Cvtsi2ss);
		let _ = h.insert("Cvtss2sd", Mnemonic::Cvtss2sd);
		let _ = h.insert("Cvtss2si", Mnemonic::Cvtss2si);
		let _ = h.insert("Cvttpd2dq", Mnemonic::Cvttpd2dq);
		let _ = h.insert("Cvttpd2pi", Mnemonic::Cvttpd2pi);
		let _ = h.insert("Cvttps2dq", Mnemonic::Cvttps2dq);
		let _ = h.insert("Cvttps2pi", Mnemonic::Cvttps2pi);
		let _ = h.insert("Cvttsd2si", Mnemonic::Cvttsd2si);
		let _ = h.insert("Cvttss2si", Mnemonic::Cvttss2si);
		let _ = h.insert("Cwd", Mnemonic::Cwd);
		let _ = h.insert("Cwde", Mnemonic::Cwde);
		let _ = h.insert("Daa", Mnemonic::Daa);
		let _ = h.insert("Das", Mnemonic::Das);
		let _ = h.insert("Db", Mnemonic::Db);
		let _ = h.insert("Dd", Mnemonic::Dd);
		let _ = h.insert("Dec", Mnemonic::Dec);
		let _ = h.insert("Div", Mnemonic::Div);
		let _ = h.insert("Divpd", Mnemonic::Divpd);
		let _ = h.insert("Divps", Mnemonic::Divps);
		let _ = h.insert("Divsd", Mnemonic::Divsd);
		let _ = h.insert("Divss", Mnemonic::Divss);
		let _ = h.insert("Dppd", Mnemonic::Dppd);
		let _ = h.insert("Dpps", Mnemonic::Dpps);
		let _ = h.insert("Dq", Mnemonic::Dq);
		let _ = h.insert("Dw", Mnemonic::Dw);
		let _ = h.insert("Emms", Mnemonic::Emms);
		let _ = h.insert("Encls", Mnemonic::Encls);
		let _ = h.insert("Enclu", Mnemonic::Enclu);
		let _ = h.insert("Enclv", Mnemonic::Enclv);
		let _ = h.insert("Endbr32", Mnemonic::Endbr32);
		let _ = h.insert("Endbr64", Mnemonic::Endbr64);
		let _ = h.insert("Enqcmd", Mnemonic::Enqcmd);
		let _ = h.insert("Enqcmds", Mnemonic::Enqcmds);
		let _ = h.insert("Enter", Mnemonic::Enter);
		let _ = h.insert("Extractps", Mnemonic::Extractps);
		let _ = h.insert("Extrq", Mnemonic::Extrq);
		let _ = h.insert("F2xm1", Mnemonic::F2xm1);
		let _ = h.insert("Fabs", Mnemonic::Fabs);
		let _ = h.insert("Fadd", Mnemonic::Fadd);
		let _ = h.insert("Faddp", Mnemonic::Faddp);
		let _ = h.insert("Fbld", Mnemonic::Fbld);
		let _ = h.insert("Fbstp", Mnemonic::Fbstp);
		let _ = h.insert("Fchs", Mnemonic::Fchs);
		let _ = h.insert("Fclex", Mnemonic::Fclex);
		let _ = h.insert("Fcmovb", Mnemonic::Fcmovb);
		let _ = h.insert("Fcmovbe", Mnemonic::Fcmovbe);
		let _ = h.insert("Fcmove", Mnemonic::Fcmove);
		let _ = h.insert("Fcmovnb", Mnemonic::Fcmovnb);
		let _ = h.insert("Fcmovnbe", Mnemonic::Fcmovnbe);
		let _ = h.insert("Fcmovne", Mnemonic::Fcmovne);
		let _ = h.insert("Fcmovnu", Mnemonic::Fcmovnu);
		let _ = h.insert("Fcmovu", Mnemonic::Fcmovu);
		let _ = h.insert("Fcom", Mnemonic::Fcom);
		let _ = h.insert("Fcomi", Mnemonic::Fcomi);
		let _ = h.insert("Fcomip", Mnemonic::Fcomip);
		let _ = h.insert("Fcomp", Mnemonic::Fcomp);
		let _ = h.insert("Fcompp", Mnemonic::Fcompp);
		let _ = h.insert("Fcos", Mnemonic::Fcos);
		let _ = h.insert("Fdecstp", Mnemonic::Fdecstp);
		let _ = h.insert("Fdisi", Mnemonic::Fdisi);
		let _ = h.insert("Fdiv", Mnemonic::Fdiv);
		let _ = h.insert("Fdivp", Mnemonic::Fdivp);
		let _ = h.insert("Fdivr", Mnemonic::Fdivr);
		let _ = h.insert("Fdivrp", Mnemonic::Fdivrp);
		let _ = h.insert("Femms", Mnemonic::Femms);
		let _ = h.insert("Feni", Mnemonic::Feni);
		let _ = h.insert("Ffree", Mnemonic::Ffree);
		let _ = h.insert("Ffreep", Mnemonic::Ffreep);
		let _ = h.insert("Fiadd", Mnemonic::Fiadd);
		let _ = h.insert("Ficom", Mnemonic::Ficom);
		let _ = h.insert("Ficomp", Mnemonic::Ficomp);
		let _ = h.insert("Fidiv", Mnemonic::Fidiv);
		let _ = h.insert("Fidivr", Mnemonic::Fidivr);
		let _ = h.insert("Fild", Mnemonic::Fild);
		let _ = h.insert("Fimul", Mnemonic::Fimul);
		let _ = h.insert("Fincstp", Mnemonic::Fincstp);
		let _ = h.insert("Finit", Mnemonic::Finit);
		let _ = h.insert("Fist", Mnemonic::Fist);
		let _ = h.insert("Fistp", Mnemonic::Fistp);
		let _ = h.insert("Fisttp", Mnemonic::Fisttp);
		let _ = h.insert("Fisub", Mnemonic::Fisub);
		let _ = h.insert("Fisubr", Mnemonic::Fisubr);
		let _ = h.insert("Fld", Mnemonic::Fld);
		let _ = h.insert("Fld1", Mnemonic::Fld1);
		let _ = h.insert("Fldcw", Mnemonic::Fldcw);
		let _ = h.insert("Fldenv", Mnemonic::Fldenv);
		let _ = h.insert("Fldl2e", Mnemonic::Fldl2e);
		let _ = h.insert("Fldl2t", Mnemonic::Fldl2t);
		let _ = h.insert("Fldlg2", Mnemonic::Fldlg2);
		let _ = h.insert("Fldln2", Mnemonic::Fldln2);
		let _ = h.insert("Fldpi", Mnemonic::Fldpi);
		let _ = h.insert("Fldz", Mnemonic::Fldz);
		let _ = h.insert("Fmul", Mnemonic::Fmul);
		let _ = h.insert("Fmulp", Mnemonic::Fmulp);
		let _ = h.insert("Fnclex", Mnemonic::Fnclex);
		let _ = h.insert("Fndisi", Mnemonic::Fndisi);
		let _ = h.insert("Fneni", Mnemonic::Fneni);
		let _ = h.insert("Fninit", Mnemonic::Fninit);
		let _ = h.insert("Fnop", Mnemonic::Fnop);
		let _ = h.insert("Fnsave", Mnemonic::Fnsave);
		let _ = h.insert("Fnsetpm", Mnemonic::Fnsetpm);
		let _ = h.insert("Fnstcw", Mnemonic::Fnstcw);
		let _ = h.insert("Fnstenv", Mnemonic::Fnstenv);
		let _ = h.insert("Fnstsw", Mnemonic::Fnstsw);
		let _ = h.insert("Fpatan", Mnemonic::Fpatan);
		let _ = h.insert("Fprem", Mnemonic::Fprem);
		let _ = h.insert("Fprem1", Mnemonic::Fprem1);
		let _ = h.insert("Fptan", Mnemonic::Fptan);
		let _ = h.insert("Frndint", Mnemonic::Frndint);
		let _ = h.insert("Frstor", Mnemonic::Frstor);
		let _ = h.insert("Frstpm", Mnemonic::Frstpm);
		let _ = h.insert("Fsave", Mnemonic::Fsave);
		let _ = h.insert("Fscale", Mnemonic::Fscale);
		let _ = h.insert("Fsetpm", Mnemonic::Fsetpm);
		let _ = h.insert("Fsin", Mnemonic::Fsin);
		let _ = h.insert("Fsincos", Mnemonic::Fsincos);
		let _ = h.insert("Fsqrt", Mnemonic::Fsqrt);
		let _ = h.insert("Fst", Mnemonic::Fst);
		let _ = h.insert("Fstcw", Mnemonic::Fstcw);
		let _ = h.insert("Fstdw", Mnemonic::Fstdw);
		let _ = h.insert("Fstenv", Mnemonic::Fstenv);
		let _ = h.insert("Fstp", Mnemonic::Fstp);
		let _ = h.insert("Fstpnce", Mnemonic::Fstpnce);
		let _ = h.insert("Fstsg", Mnemonic::Fstsg);
		let _ = h.insert("Fstsw", Mnemonic::Fstsw);
		let _ = h.insert("Fsub", Mnemonic::Fsub);
		let _ = h.insert("Fsubp", Mnemonic::Fsubp);
		let _ = h.insert("Fsubr", Mnemonic::Fsubr);
		let _ = h.insert("Fsubrp", Mnemonic::Fsubrp);
		let _ = h.insert("Ftst", Mnemonic::Ftst);
		let _ = h.insert("Fucom", Mnemonic::Fucom);
		let _ = h.insert("Fucomi", Mnemonic::Fucomi);
		let _ = h.insert("Fucomip", Mnemonic::Fucomip);
		let _ = h.insert("Fucomp", Mnemonic::Fucomp);
		let _ = h.insert("Fucompp", Mnemonic::Fucompp);
		let _ = h.insert("Fxam", Mnemonic::Fxam);
		let _ = h.insert("Fxch", Mnemonic::Fxch);
		let _ = h.insert("Fxrstor", Mnemonic::Fxrstor);
		let _ = h.insert("Fxrstor64", Mnemonic::Fxrstor64);
		let _ = h.insert("Fxsave", Mnemonic::Fxsave);
		let _ = h.insert("Fxsave64", Mnemonic::Fxsave64);
		let _ = h.insert("Fxtract", Mnemonic::Fxtract);
		let _ = h.insert("Fyl2x", Mnemonic::Fyl2x);
		let _ = h.insert("Fyl2xp1", Mnemonic::Fyl2xp1);
		let _ = h.insert("Getsec", Mnemonic::Getsec);
		let _ = h.insert("Gf2p8affineinvqb", Mnemonic::Gf2p8affineinvqb);
		let _ = h.insert("Gf2p8affineqb", Mnemonic::Gf2p8affineqb);
		let _ = h.insert("Gf2p8mulb", Mnemonic::Gf2p8mulb);
		let _ = h.insert("Haddpd", Mnemonic::Haddpd);
		let _ = h.insert("Haddps", Mnemonic::Haddps);
		let _ = h.insert("Hlt", Mnemonic::Hlt);
		let _ = h.insert("Hsubpd", Mnemonic::Hsubpd);
		let _ = h.insert("Hsubps", Mnemonic::Hsubps);
		let _ = h.insert("Ibts", Mnemonic::Ibts);
		let _ = h.insert("Idiv", Mnemonic::Idiv);
		let _ = h.insert("Imul", Mnemonic::Imul);
		let _ = h.insert("In", Mnemonic::In);
		let _ = h.insert("Inc", Mnemonic::Inc);
		let _ = h.insert("Incsspd", Mnemonic::Incsspd);
		let _ = h.insert("Incsspq", Mnemonic::Incsspq);
		let _ = h.insert("Insb", Mnemonic::Insb);
		let _ = h.insert("Insd", Mnemonic::Insd);
		let _ = h.insert("Insertps", Mnemonic::Insertps);
		let _ = h.insert("Insertq", Mnemonic::Insertq);
		let _ = h.insert("Insw", Mnemonic::Insw);
		let _ = h.insert("Int", Mnemonic::Int);
		let _ = h.insert("Int1", Mnemonic::Int1);
		let _ = h.insert("Into", Mnemonic::Into);
		let _ = h.insert("Invd", Mnemonic::Invd);
		let _ = h.insert("Invept", Mnemonic::Invept);
		let _ = h.insert("Invlpg", Mnemonic::Invlpg);
		let _ = h.insert("Invlpga", Mnemonic::Invlpga);
		let _ = h.insert("Invpcid", Mnemonic::Invpcid);
		let _ = h.insert("Invvpid", Mnemonic::Invvpid);
		let _ = h.insert("Iret", Mnemonic::Iret);
		let _ = h.insert("Ja", Mnemonic::Ja);
		let _ = h.insert("Jae", Mnemonic::Jae);
		let _ = h.insert("Jb", Mnemonic::Jb);
		let _ = h.insert("Jbe", Mnemonic::Jbe);
		let _ = h.insert("Jcxz", Mnemonic::Jcxz);
		let _ = h.insert("Je", Mnemonic::Je);
		let _ = h.insert("Jecxz", Mnemonic::Jecxz);
		let _ = h.insert("Jg", Mnemonic::Jg);
		let _ = h.insert("Jge", Mnemonic::Jge);
		let _ = h.insert("Jl", Mnemonic::Jl);
		let _ = h.insert("Jle", Mnemonic::Jle);
		let _ = h.insert("Jmp", Mnemonic::Jmp);
		let _ = h.insert("Jmpe", Mnemonic::Jmpe);
		let _ = h.insert("Jne", Mnemonic::Jne);
		let _ = h.insert("Jno", Mnemonic::Jno);
		let _ = h.insert("Jnp", Mnemonic::Jnp);
		let _ = h.insert("Jns", Mnemonic::Jns);
		let _ = h.insert("Jo", Mnemonic::Jo);
		let _ = h.insert("Jp", Mnemonic::Jp);
		let _ = h.insert("Jrcxz", Mnemonic::Jrcxz);
		let _ = h.insert("Js", Mnemonic::Js);
		let _ = h.insert("Kaddb", Mnemonic::Kaddb);
		let _ = h.insert("Kaddd", Mnemonic::Kaddd);
		let _ = h.insert("Kaddq", Mnemonic::Kaddq);
		let _ = h.insert("Kaddw", Mnemonic::Kaddw);
		let _ = h.insert("Kandb", Mnemonic::Kandb);
		let _ = h.insert("Kandd", Mnemonic::Kandd);
		let _ = h.insert("Kandnb", Mnemonic::Kandnb);
		let _ = h.insert("Kandnd", Mnemonic::Kandnd);
		let _ = h.insert("Kandnq", Mnemonic::Kandnq);
		let _ = h.insert("Kandnw", Mnemonic::Kandnw);
		let _ = h.insert("Kandq", Mnemonic::Kandq);
		let _ = h.insert("Kandw", Mnemonic::Kandw);
		let _ = h.insert("Kmovb", Mnemonic::Kmovb);
		let _ = h.insert("Kmovd", Mnemonic::Kmovd);
		let _ = h.insert("Kmovq", Mnemonic::Kmovq);
		let _ = h.insert("Kmovw", Mnemonic::Kmovw);
		let _ = h.insert("Knotb", Mnemonic::Knotb);
		let _ = h.insert("Knotd", Mnemonic::Knotd);
		let _ = h.insert("Knotq", Mnemonic::Knotq);
		let _ = h.insert("Knotw", Mnemonic::Knotw);
		let _ = h.insert("Korb", Mnemonic::Korb);
		let _ = h.insert("Kord", Mnemonic::Kord);
		let _ = h.insert("Korq", Mnemonic::Korq);
		let _ = h.insert("Kortestb", Mnemonic::Kortestb);
		let _ = h.insert("Kortestd", Mnemonic::Kortestd);
		let _ = h.insert("Kortestq", Mnemonic::Kortestq);
		let _ = h.insert("Kortestw", Mnemonic::Kortestw);
		let _ = h.insert("Korw", Mnemonic::Korw);
		let _ = h.insert("Kshiftlb", Mnemonic::Kshiftlb);
		let _ = h.insert("Kshiftld", Mnemonic::Kshiftld);
		let _ = h.insert("Kshiftlq", Mnemonic::Kshiftlq);
		let _ = h.insert("Kshiftlw", Mnemonic::Kshiftlw);
		let _ = h.insert("Kshiftrb", Mnemonic::Kshiftrb);
		let _ = h.insert("Kshiftrd", Mnemonic::Kshiftrd);
		let _ = h.insert("Kshiftrq", Mnemonic::Kshiftrq);
		let _ = h.insert("Kshiftrw", Mnemonic::Kshiftrw);
		let _ = h.insert("Ktestb", Mnemonic::Ktestb);
		let _ = h.insert("Ktestd", Mnemonic::Ktestd);
		let _ = h.insert("Ktestq", Mnemonic::Ktestq);
		let _ = h.insert("Ktestw", Mnemonic::Ktestw);
		let _ = h.insert("Kunpckbw", Mnemonic::Kunpckbw);
		let _ = h.insert("Kunpckdq", Mnemonic::Kunpckdq);
		let _ = h.insert("Kunpckwd", Mnemonic::Kunpckwd);
		let _ = h.insert("Kxnorb", Mnemonic::Kxnorb);
		let _ = h.insert("Kxnord", Mnemonic::Kxnord);
		let _ = h.insert("Kxnorq", Mnemonic::Kxnorq);
		let _ = h.insert("Kxnorw", Mnemonic::Kxnorw);
		let _ = h.insert("Kxorb", Mnemonic::Kxorb);
		let _ = h.insert("Kxord", Mnemonic::Kxord);
		let _ = h.insert("Kxorq", Mnemonic::Kxorq);
		let _ = h.insert("Kxorw", Mnemonic::Kxorw);
		let _ = h.insert("Lahf", Mnemonic::Lahf);
		let _ = h.insert("Lar", Mnemonic::Lar);
		let _ = h.insert("Lddqu", Mnemonic::Lddqu);
		let _ = h.insert("Ldmxcsr", Mnemonic::Ldmxcsr);
		let _ = h.insert("Lds", Mnemonic::Lds);
		let _ = h.insert("Lea", Mnemonic::Lea);
		let _ = h.insert("Leave", Mnemonic::Leave);
		let _ = h.insert("Les", Mnemonic::Les);
		let _ = h.insert("Lfence", Mnemonic::Lfence);
		let _ = h.insert("Lfs", Mnemonic::Lfs);
		let _ = h.insert("Lgdt", Mnemonic::Lgdt);
		let _ = h.insert("Lgs", Mnemonic::Lgs);
		let _ = h.insert("Lidt", Mnemonic::Lidt);
		let _ = h.insert("Lldt", Mnemonic::Lldt);
		let _ = h.insert("Llwpcb", Mnemonic::Llwpcb);
		let _ = h.insert("Lmsw", Mnemonic::Lmsw);
		let _ = h.insert("Loadall", Mnemonic::Loadall);
		let _ = h.insert("Lodsb", Mnemonic::Lodsb);
		let _ = h.insert("Lodsd", Mnemonic::Lodsd);
		let _ = h.insert("Lodsq", Mnemonic::Lodsq);
		let _ = h.insert("Lodsw", Mnemonic::Lodsw);
		let _ = h.insert("Loop", Mnemonic::Loop);
		let _ = h.insert("Loope", Mnemonic::Loope);
		let _ = h.insert("Loopne", Mnemonic::Loopne);
		let _ = h.insert("Lsl", Mnemonic::Lsl);
		let _ = h.insert("Lss", Mnemonic::Lss);
		let _ = h.insert("Ltr", Mnemonic::Ltr);
		let _ = h.insert("Lwpins", Mnemonic::Lwpins);
		let _ = h.insert("Lwpval", Mnemonic::Lwpval);
		let _ = h.insert("Lzcnt", Mnemonic::Lzcnt);
		let _ = h.insert("Maskmovdqu", Mnemonic::Maskmovdqu);
		let _ = h.insert("Maskmovq", Mnemonic::Maskmovq);
		let _ = h.insert("Maxpd", Mnemonic::Maxpd);
		let _ = h.insert("Maxps", Mnemonic::Maxps);
		let _ = h.insert("Maxsd", Mnemonic::Maxsd);
		let _ = h.insert("Maxss", Mnemonic::Maxss);
		let _ = h.insert("Mcommit", Mnemonic::Mcommit);
		let _ = h.insert("Mfence", Mnemonic::Mfence);
		let _ = h.insert("Minpd", Mnemonic::Minpd);
		let _ = h.insert("Minps", Mnemonic::Minps);
		let _ = h.insert("Minsd", Mnemonic::Minsd);
		let _ = h.insert("Minss", Mnemonic::Minss);
		let _ = h.insert("Monitor", Mnemonic::Monitor);
		let _ = h.insert("Monitorx", Mnemonic::Monitorx);
		let _ = h.insert("Montmul", Mnemonic::Montmul);
		let _ = h.insert("Mov", Mnemonic::Mov);
		let _ = h.insert("Movapd", Mnemonic::Movapd);
		let _ = h.insert("Movaps", Mnemonic::Movaps);
		let _ = h.insert("Movbe", Mnemonic::Movbe);
		let _ = h.insert("Movd", Mnemonic::Movd);
		let _ = h.insert("Movddup", Mnemonic::Movddup);
		let _ = h.insert("Movdir64b", Mnemonic::Movdir64b);
		let _ = h.insert("Movdiri", Mnemonic::Movdiri);
		let _ = h.insert("Movdq2q", Mnemonic::Movdq2q);
		let _ = h.insert("Movdqa", Mnemonic::Movdqa);
		let _ = h.insert("Movdqu", Mnemonic::Movdqu);
		let _ = h.insert("Movhlps", Mnemonic::Movhlps);
		let _ = h.insert("Movhpd", Mnemonic::Movhpd);
		let _ = h.insert("Movhps", Mnemonic::Movhps);
		let _ = h.insert("Movlhps", Mnemonic::Movlhps);
		let _ = h.insert("Movlpd", Mnemonic::Movlpd);
		let _ = h.insert("Movlps", Mnemonic::Movlps);
		let _ = h.insert("Movmskpd", Mnemonic::Movmskpd);
		let _ = h.insert("Movmskps", Mnemonic::Movmskps);
		let _ = h.insert("Movntdq", Mnemonic::Movntdq);
		let _ = h.insert("Movntdqa", Mnemonic::Movntdqa);
		let _ = h.insert("Movnti", Mnemonic::Movnti);
		let _ = h.insert("Movntpd", Mnemonic::Movntpd);
		let _ = h.insert("Movntps", Mnemonic::Movntps);
		let _ = h.insert("Movntq", Mnemonic::Movntq);
		let _ = h.insert("Movntsd", Mnemonic::Movntsd);
		let _ = h.insert("Movntss", Mnemonic::Movntss);
		let _ = h.insert("Movq", Mnemonic::Movq);
		let _ = h.insert("Movq2dq", Mnemonic::Movq2dq);
		let _ = h.insert("Movsb", Mnemonic::Movsb);
		let _ = h.insert("Movsd", Mnemonic::Movsd);
		let _ = h.insert("Movshdup", Mnemonic::Movshdup);
		let _ = h.insert("Movsldup", Mnemonic::Movsldup);
		let _ = h.insert("Movsq", Mnemonic::Movsq);
		let _ = h.insert("Movss", Mnemonic::Movss);
		let _ = h.insert("Movsw", Mnemonic::Movsw);
		let _ = h.insert("Movsx", Mnemonic::Movsx);
		let _ = h.insert("Movsxd", Mnemonic::Movsxd);
		let _ = h.insert("Movupd", Mnemonic::Movupd);
		let _ = h.insert("Movups", Mnemonic::Movups);
		let _ = h.insert("Movzx", Mnemonic::Movzx);
		let _ = h.insert("Mpsadbw", Mnemonic::Mpsadbw);
		let _ = h.insert("Mul", Mnemonic::Mul);
		let _ = h.insert("Mulpd", Mnemonic::Mulpd);
		let _ = h.insert("Mulps", Mnemonic::Mulps);
		let _ = h.insert("Mulsd", Mnemonic::Mulsd);
		let _ = h.insert("Mulss", Mnemonic::Mulss);
		let _ = h.insert("Mulx", Mnemonic::Mulx);
		let _ = h.insert("Mwait", Mnemonic::Mwait);
		let _ = h.insert("Mwaitx", Mnemonic::Mwaitx);
		let _ = h.insert("Neg", Mnemonic::Neg);
		let _ = h.insert("Nop", Mnemonic::Nop);
		let _ = h.insert("Not", Mnemonic::Not);
		let _ = h.insert("Or", Mnemonic::Or);
		let _ = h.insert("Orpd", Mnemonic::Orpd);
		let _ = h.insert("Orps", Mnemonic::Orps);
		let _ = h.insert("Out", Mnemonic::Out);
		let _ = h.insert("Outsb", Mnemonic::Outsb);
		let _ = h.insert("Outsd", Mnemonic::Outsd);
		let _ = h.insert("Outsw", Mnemonic::Outsw);
		let _ = h.insert("Pabsb", Mnemonic::Pabsb);
		let _ = h.insert("Pabsd", Mnemonic::Pabsd);
		let _ = h.insert("Pabsw", Mnemonic::Pabsw);
		let _ = h.insert("Packssdw", Mnemonic::Packssdw);
		let _ = h.insert("Packsswb", Mnemonic::Packsswb);
		let _ = h.insert("Packusdw", Mnemonic::Packusdw);
		let _ = h.insert("Packuswb", Mnemonic::Packuswb);
		let _ = h.insert("Paddb", Mnemonic::Paddb);
		let _ = h.insert("Paddd", Mnemonic::Paddd);
		let _ = h.insert("Paddq", Mnemonic::Paddq);
		let _ = h.insert("Paddsb", Mnemonic::Paddsb);
		let _ = h.insert("Paddsw", Mnemonic::Paddsw);
		let _ = h.insert("Paddusb", Mnemonic::Paddusb);
		let _ = h.insert("Paddusw", Mnemonic::Paddusw);
		let _ = h.insert("Paddw", Mnemonic::Paddw);
		let _ = h.insert("Palignr", Mnemonic::Palignr);
		let _ = h.insert("Pand", Mnemonic::Pand);
		let _ = h.insert("Pandn", Mnemonic::Pandn);
		let _ = h.insert("Pause", Mnemonic::Pause);
		let _ = h.insert("Pavgb", Mnemonic::Pavgb);
		let _ = h.insert("Pavgusb", Mnemonic::Pavgusb);
		let _ = h.insert("Pavgw", Mnemonic::Pavgw);
		let _ = h.insert("Pblendvb", Mnemonic::Pblendvb);
		let _ = h.insert("Pblendw", Mnemonic::Pblendw);
		let _ = h.insert("Pclmulqdq", Mnemonic::Pclmulqdq);
		let _ = h.insert("Pcmpeqb", Mnemonic::Pcmpeqb);
		let _ = h.insert("Pcmpeqd", Mnemonic::Pcmpeqd);
		let _ = h.insert("Pcmpeqq", Mnemonic::Pcmpeqq);
		let _ = h.insert("Pcmpeqw", Mnemonic::Pcmpeqw);
		let _ = h.insert("Pcmpestri", Mnemonic::Pcmpestri);
		let _ = h.insert("Pcmpestri64", Mnemonic::Pcmpestri64);
		let _ = h.insert("Pcmpestrm", Mnemonic::Pcmpestrm);
		let _ = h.insert("Pcmpestrm64", Mnemonic::Pcmpestrm64);
		let _ = h.insert("Pcmpgtb", Mnemonic::Pcmpgtb);
		let _ = h.insert("Pcmpgtd", Mnemonic::Pcmpgtd);
		let _ = h.insert("Pcmpgtq", Mnemonic::Pcmpgtq);
		let _ = h.insert("Pcmpgtw", Mnemonic::Pcmpgtw);
		let _ = h.insert("Pcmpistri", Mnemonic::Pcmpistri);
		let _ = h.insert("Pcmpistrm", Mnemonic::Pcmpistrm);
		let _ = h.insert("Pcommit", Mnemonic::Pcommit);
		let _ = h.insert("Pconfig", Mnemonic::Pconfig);
		let _ = h.insert("Pdep", Mnemonic::Pdep);
		let _ = h.insert("Pext", Mnemonic::Pext);
		let _ = h.insert("Pextrb", Mnemonic::Pextrb);
		let _ = h.insert("Pextrd", Mnemonic::Pextrd);
		let _ = h.insert("Pextrq", Mnemonic::Pextrq);
		let _ = h.insert("Pextrw", Mnemonic::Pextrw);
		let _ = h.insert("Pf2id", Mnemonic::Pf2id);
		let _ = h.insert("Pf2iw", Mnemonic::Pf2iw);
		let _ = h.insert("Pfacc", Mnemonic::Pfacc);
		let _ = h.insert("Pfadd", Mnemonic::Pfadd);
		let _ = h.insert("Pfcmpeq", Mnemonic::Pfcmpeq);
		let _ = h.insert("Pfcmpge", Mnemonic::Pfcmpge);
		let _ = h.insert("Pfcmpgt", Mnemonic::Pfcmpgt);
		let _ = h.insert("Pfmax", Mnemonic::Pfmax);
		let _ = h.insert("Pfmin", Mnemonic::Pfmin);
		let _ = h.insert("Pfmul", Mnemonic::Pfmul);
		let _ = h.insert("Pfnacc", Mnemonic::Pfnacc);
		let _ = h.insert("Pfpnacc", Mnemonic::Pfpnacc);
		let _ = h.insert("Pfrcp", Mnemonic::Pfrcp);
		let _ = h.insert("Pfrcpit1", Mnemonic::Pfrcpit1);
		let _ = h.insert("Pfrcpit2", Mnemonic::Pfrcpit2);
		let _ = h.insert("Pfrcpv", Mnemonic::Pfrcpv);
		let _ = h.insert("Pfrsqit1", Mnemonic::Pfrsqit1);
		let _ = h.insert("Pfrsqrt", Mnemonic::Pfrsqrt);
		let _ = h.insert("Pfrsqrtv", Mnemonic::Pfrsqrtv);
		let _ = h.insert("Pfsub", Mnemonic::Pfsub);
		let _ = h.insert("Pfsubr", Mnemonic::Pfsubr);
		let _ = h.insert("Phaddd", Mnemonic::Phaddd);
		let _ = h.insert("Phaddsw", Mnemonic::Phaddsw);
		let _ = h.insert("Phaddw", Mnemonic::Phaddw);
		let _ = h.insert("Phminposuw", Mnemonic::Phminposuw);
		let _ = h.insert("Phsubd", Mnemonic::Phsubd);
		let _ = h.insert("Phsubsw", Mnemonic::Phsubsw);
		let _ = h.insert("Phsubw", Mnemonic::Phsubw);
		let _ = h.insert("Pi2fd", Mnemonic::Pi2fd);
		let _ = h.insert("Pi2fw", Mnemonic::Pi2fw);
		let _ = h.insert("Pinsrb", Mnemonic::Pinsrb);
		let _ = h.insert("Pinsrd", Mnemonic::Pinsrd);
		let _ = h.insert("Pinsrq", Mnemonic::Pinsrq);
		let _ = h.insert("Pinsrw", Mnemonic::Pinsrw);
		let _ = h.insert("Pmaddubsw", Mnemonic::Pmaddubsw);
		let _ = h.insert("Pmaddwd", Mnemonic::Pmaddwd);
		let _ = h.insert("Pmaxsb", Mnemonic::Pmaxsb);
		let _ = h.insert("Pmaxsd", Mnemonic::Pmaxsd);
		let _ = h.insert("Pmaxsw", Mnemonic::Pmaxsw);
		let _ = h.insert("Pmaxub", Mnemonic::Pmaxub);
		let _ = h.insert("Pmaxud", Mnemonic::Pmaxud);
		let _ = h.insert("Pmaxuw", Mnemonic::Pmaxuw);
		let _ = h.insert("Pminsb", Mnemonic::Pminsb);
		let _ = h.insert("Pminsd", Mnemonic::Pminsd);
		let _ = h.insert("Pminsw", Mnemonic::Pminsw);
		let _ = h.insert("Pminub", Mnemonic::Pminub);
		let _ = h.insert("Pminud", Mnemonic::Pminud);
		let _ = h.insert("Pminuw", Mnemonic::Pminuw);
		let _ = h.insert("Pmovmskb", Mnemonic::Pmovmskb);
		let _ = h.insert("Pmovsxbd", Mnemonic::Pmovsxbd);
		let _ = h.insert("Pmovsxbq", Mnemonic::Pmovsxbq);
		let _ = h.insert("Pmovsxbw", Mnemonic::Pmovsxbw);
		let _ = h.insert("Pmovsxdq", Mnemonic::Pmovsxdq);
		let _ = h.insert("Pmovsxwd", Mnemonic::Pmovsxwd);
		let _ = h.insert("Pmovsxwq", Mnemonic::Pmovsxwq);
		let _ = h.insert("Pmovzxbd", Mnemonic::Pmovzxbd);
		let _ = h.insert("Pmovzxbq", Mnemonic::Pmovzxbq);
		let _ = h.insert("Pmovzxbw", Mnemonic::Pmovzxbw);
		let _ = h.insert("Pmovzxdq", Mnemonic::Pmovzxdq);
		let _ = h.insert("Pmovzxwd", Mnemonic::Pmovzxwd);
		let _ = h.insert("Pmovzxwq", Mnemonic::Pmovzxwq);
		let _ = h.insert("Pmuldq", Mnemonic::Pmuldq);
		let _ = h.insert("Pmulhrsw", Mnemonic::Pmulhrsw);
		let _ = h.insert("Pmulhrw", Mnemonic::Pmulhrw);
		let _ = h.insert("Pmulhuw", Mnemonic::Pmulhuw);
		let _ = h.insert("Pmulhw", Mnemonic::Pmulhw);
		let _ = h.insert("Pmulld", Mnemonic::Pmulld);
		let _ = h.insert("Pmullw", Mnemonic::Pmullw);
		let _ = h.insert("Pmuludq", Mnemonic::Pmuludq);
		let _ = h.insert("Pop", Mnemonic::Pop);
		let _ = h.insert("Popa", Mnemonic::Popa);
		let _ = h.insert("Popcnt", Mnemonic::Popcnt);
		let _ = h.insert("Popf", Mnemonic::Popf);
		let _ = h.insert("Por", Mnemonic::Por);
		let _ = h.insert("Prefetch", Mnemonic::Prefetch);
		let _ = h.insert("Prefetchnta", Mnemonic::Prefetchnta);
		let _ = h.insert("Prefetcht0", Mnemonic::Prefetcht0);
		let _ = h.insert("Prefetcht1", Mnemonic::Prefetcht1);
		let _ = h.insert("Prefetcht2", Mnemonic::Prefetcht2);
		let _ = h.insert("Prefetchw", Mnemonic::Prefetchw);
		let _ = h.insert("Prefetchwt1", Mnemonic::Prefetchwt1);
		let _ = h.insert("Psadbw", Mnemonic::Psadbw);
		let _ = h.insert("Pshufb", Mnemonic::Pshufb);
		let _ = h.insert("Pshufd", Mnemonic::Pshufd);
		let _ = h.insert("Pshufhw", Mnemonic::Pshufhw);
		let _ = h.insert("Pshuflw", Mnemonic::Pshuflw);
		let _ = h.insert("Pshufw", Mnemonic::Pshufw);
		let _ = h.insert("Psignb", Mnemonic::Psignb);
		let _ = h.insert("Psignd", Mnemonic::Psignd);
		let _ = h.insert("Psignw", Mnemonic::Psignw);
		let _ = h.insert("Pslld", Mnemonic::Pslld);
		let _ = h.insert("Pslldq", Mnemonic::Pslldq);
		let _ = h.insert("Psllq", Mnemonic::Psllq);
		let _ = h.insert("Psllw", Mnemonic::Psllw);
		let _ = h.insert("Psrad", Mnemonic::Psrad);
		let _ = h.insert("Psraw", Mnemonic::Psraw);
		let _ = h.insert("Psrld", Mnemonic::Psrld);
		let _ = h.insert("Psrldq", Mnemonic::Psrldq);
		let _ = h.insert("Psrlq", Mnemonic::Psrlq);
		let _ = h.insert("Psrlw", Mnemonic::Psrlw);
		let _ = h.insert("Psubb", Mnemonic::Psubb);
		let _ = h.insert("Psubd", Mnemonic::Psubd);
		let _ = h.insert("Psubq", Mnemonic::Psubq);
		let _ = h.insert("Psubsb", Mnemonic::Psubsb);
		let _ = h.insert("Psubsw", Mnemonic::Psubsw);
		let _ = h.insert("Psubusb", Mnemonic::Psubusb);
		let _ = h.insert("Psubusw", Mnemonic::Psubusw);
		let _ = h.insert("Psubw", Mnemonic::Psubw);
		let _ = h.insert("Pswapd", Mnemonic::Pswapd);
		let _ = h.insert("Ptest", Mnemonic::Ptest);
		let _ = h.insert("Ptwrite", Mnemonic::Ptwrite);
		let _ = h.insert("Punpckhbw", Mnemonic::Punpckhbw);
		let _ = h.insert("Punpckhdq", Mnemonic::Punpckhdq);
		let _ = h.insert("Punpckhqdq", Mnemonic::Punpckhqdq);
		let _ = h.insert("Punpckhwd", Mnemonic::Punpckhwd);
		let _ = h.insert("Punpcklbw", Mnemonic::Punpcklbw);
		let _ = h.insert("Punpckldq", Mnemonic::Punpckldq);
		let _ = h.insert("Punpcklqdq", Mnemonic::Punpcklqdq);
		let _ = h.insert("Punpcklwd", Mnemonic::Punpcklwd);
		let _ = h.insert("Push", Mnemonic::Push);
		let _ = h.insert("Pusha", Mnemonic::Pusha);
		let _ = h.insert("Pushf", Mnemonic::Pushf);
		let _ = h.insert("Pxor", Mnemonic::Pxor);
		let _ = h.insert("Rcl", Mnemonic::Rcl);
		let _ = h.insert("Rcpps", Mnemonic::Rcpps);
		let _ = h.insert("Rcpss", Mnemonic::Rcpss);
		let _ = h.insert("Rcr", Mnemonic::Rcr);
		let _ = h.insert("Rdfsbase", Mnemonic::Rdfsbase);
		let _ = h.insert("Rdgsbase", Mnemonic::Rdgsbase);
		let _ = h.insert("Rdmsr", Mnemonic::Rdmsr);
		let _ = h.insert("Rdpid", Mnemonic::Rdpid);
		let _ = h.insert("Rdpkru", Mnemonic::Rdpkru);
		let _ = h.insert("Rdpmc", Mnemonic::Rdpmc);
		let _ = h.insert("Rdpru", Mnemonic::Rdpru);
		let _ = h.insert("Rdrand", Mnemonic::Rdrand);
		let _ = h.insert("Rdseed", Mnemonic::Rdseed);
		let _ = h.insert("Rdsspd", Mnemonic::Rdsspd);
		let _ = h.insert("Rdsspq", Mnemonic::Rdsspq);
		let _ = h.insert("Rdtsc", Mnemonic::Rdtsc);
		let _ = h.insert("Rdtscp", Mnemonic::Rdtscp);
		let _ = h.insert("Reservednop", Mnemonic::Reservednop);
		let _ = h.insert("Ret", Mnemonic::Ret);
		let _ = h.insert("Retf", Mnemonic::Retf);
		let _ = h.insert("Rol", Mnemonic::Rol);
		let _ = h.insert("Ror", Mnemonic::Ror);
		let _ = h.insert("Rorx", Mnemonic::Rorx);
		let _ = h.insert("Roundpd", Mnemonic::Roundpd);
		let _ = h.insert("Roundps", Mnemonic::Roundps);
		let _ = h.insert("Roundsd", Mnemonic::Roundsd);
		let _ = h.insert("Roundss", Mnemonic::Roundss);
		let _ = h.insert("Rsm", Mnemonic::Rsm);
		let _ = h.insert("Rsqrtps", Mnemonic::Rsqrtps);
		let _ = h.insert("Rsqrtss", Mnemonic::Rsqrtss);
		let _ = h.insert("Rstorssp", Mnemonic::Rstorssp);
		let _ = h.insert("Sahf", Mnemonic::Sahf);
		let _ = h.insert("Sal", Mnemonic::Sal);
		let _ = h.insert("Salc", Mnemonic::Salc);
		let _ = h.insert("Sar", Mnemonic::Sar);
		let _ = h.insert("Sarx", Mnemonic::Sarx);
		let _ = h.insert("Saveprevssp", Mnemonic::Saveprevssp);
		let _ = h.insert("Sbb", Mnemonic::Sbb);
		let _ = h.insert("Scasb", Mnemonic::Scasb);
		let _ = h.insert("Scasd", Mnemonic::Scasd);
		let _ = h.insert("Scasq", Mnemonic::Scasq);
		let _ = h.insert("Scasw", Mnemonic::Scasw);
		let _ = h.insert("Seta", Mnemonic::Seta);
		let _ = h.insert("Setae", Mnemonic::Setae);
		let _ = h.insert("Setb", Mnemonic::Setb);
		let _ = h.insert("Setbe", Mnemonic::Setbe);
		let _ = h.insert("Sete", Mnemonic::Sete);
		let _ = h.insert("Setg", Mnemonic::Setg);
		let _ = h.insert("Setge", Mnemonic::Setge);
		let _ = h.insert("Setl", Mnemonic::Setl);
		let _ = h.insert("Setle", Mnemonic::Setle);
		let _ = h.insert("Setne", Mnemonic::Setne);
		let _ = h.insert("Setno", Mnemonic::Setno);
		let _ = h.insert("Setnp", Mnemonic::Setnp);
		let _ = h.insert("Setns", Mnemonic::Setns);
		let _ = h.insert("Seto", Mnemonic::Seto);
		let _ = h.insert("Setp", Mnemonic::Setp);
		let _ = h.insert("Sets", Mnemonic::Sets);
		let _ = h.insert("Setssbsy", Mnemonic::Setssbsy);
		let _ = h.insert("Sfence", Mnemonic::Sfence);
		let _ = h.insert("Sgdt", Mnemonic::Sgdt);
		let _ = h.insert("Sha1msg1", Mnemonic::Sha1msg1);
		let _ = h.insert("Sha1msg2", Mnemonic::Sha1msg2);
		let _ = h.insert("Sha1nexte", Mnemonic::Sha1nexte);
		let _ = h.insert("Sha1rnds4", Mnemonic::Sha1rnds4);
		let _ = h.insert("Sha256msg1", Mnemonic::Sha256msg1);
		let _ = h.insert("Sha256msg2", Mnemonic::Sha256msg2);
		let _ = h.insert("Sha256rnds2", Mnemonic::Sha256rnds2);
		let _ = h.insert("Shl", Mnemonic::Shl);
		let _ = h.insert("Shld", Mnemonic::Shld);
		let _ = h.insert("Shlx", Mnemonic::Shlx);
		let _ = h.insert("Shr", Mnemonic::Shr);
		let _ = h.insert("Shrd", Mnemonic::Shrd);
		let _ = h.insert("Shrx", Mnemonic::Shrx);
		let _ = h.insert("Shufpd", Mnemonic::Shufpd);
		let _ = h.insert("Shufps", Mnemonic::Shufps);
		let _ = h.insert("Sidt", Mnemonic::Sidt);
		let _ = h.insert("Skinit", Mnemonic::Skinit);
		let _ = h.insert("Sldt", Mnemonic::Sldt);
		let _ = h.insert("Slwpcb", Mnemonic::Slwpcb);
		let _ = h.insert("Smsw", Mnemonic::Smsw);
		let _ = h.insert("Sqrtpd", Mnemonic::Sqrtpd);
		let _ = h.insert("Sqrtps", Mnemonic::Sqrtps);
		let _ = h.insert("Sqrtsd", Mnemonic::Sqrtsd);
		let _ = h.insert("Sqrtss", Mnemonic::Sqrtss);
		let _ = h.insert("Stac", Mnemonic::Stac);
		let _ = h.insert("Stc", Mnemonic::Stc);
		let _ = h.insert("Std", Mnemonic::Std);
		let _ = h.insert("Stgi", Mnemonic::Stgi);
		let _ = h.insert("Sti", Mnemonic::Sti);
		let _ = h.insert("Stmxcsr", Mnemonic::Stmxcsr);
		let _ = h.insert("Stosb", Mnemonic::Stosb);
		let _ = h.insert("Stosd", Mnemonic::Stosd);
		let _ = h.insert("Stosq", Mnemonic::Stosq);
		let _ = h.insert("Stosw", Mnemonic::Stosw);
		let _ = h.insert("Str", Mnemonic::Str);
		let _ = h.insert("Sub", Mnemonic::Sub);
		let _ = h.insert("Subpd", Mnemonic::Subpd);
		let _ = h.insert("Subps", Mnemonic::Subps);
		let _ = h.insert("Subsd", Mnemonic::Subsd);
		let _ = h.insert("Subss", Mnemonic::Subss);
		let _ = h.insert("Swapgs", Mnemonic::Swapgs);
		let _ = h.insert("Syscall", Mnemonic::Syscall);
		let _ = h.insert("Sysenter", Mnemonic::Sysenter);
		let _ = h.insert("Sysexit", Mnemonic::Sysexit);
		let _ = h.insert("Sysret", Mnemonic::Sysret);
		let _ = h.insert("T1mskc", Mnemonic::T1mskc);
		let _ = h.insert("Test", Mnemonic::Test);
		let _ = h.insert("Tpause", Mnemonic::Tpause);
		let _ = h.insert("Tzcnt", Mnemonic::Tzcnt);
		let _ = h.insert("Tzmsk", Mnemonic::Tzmsk);
		let _ = h.insert("Ucomisd", Mnemonic::Ucomisd);
		let _ = h.insert("Ucomiss", Mnemonic::Ucomiss);
		let _ = h.insert("Ud0", Mnemonic::Ud0);
		let _ = h.insert("Ud1", Mnemonic::Ud1);
		let _ = h.insert("Ud2", Mnemonic::Ud2);
		let _ = h.insert("Umonitor", Mnemonic::Umonitor);
		let _ = h.insert("Umov", Mnemonic::Umov);
		let _ = h.insert("Umwait", Mnemonic::Umwait);
		let _ = h.insert("Unpckhpd", Mnemonic::Unpckhpd);
		let _ = h.insert("Unpckhps", Mnemonic::Unpckhps);
		let _ = h.insert("Unpcklpd", Mnemonic::Unpcklpd);
		let _ = h.insert("Unpcklps", Mnemonic::Unpcklps);
		let _ = h.insert("V4fmaddps", Mnemonic::V4fmaddps);
		let _ = h.insert("V4fmaddss", Mnemonic::V4fmaddss);
		let _ = h.insert("V4fnmaddps", Mnemonic::V4fnmaddps);
		let _ = h.insert("V4fnmaddss", Mnemonic::V4fnmaddss);
		let _ = h.insert("Vaddpd", Mnemonic::Vaddpd);
		let _ = h.insert("Vaddps", Mnemonic::Vaddps);
		let _ = h.insert("Vaddsd", Mnemonic::Vaddsd);
		let _ = h.insert("Vaddss", Mnemonic::Vaddss);
		let _ = h.insert("Vaddsubpd", Mnemonic::Vaddsubpd);
		let _ = h.insert("Vaddsubps", Mnemonic::Vaddsubps);
		let _ = h.insert("Vaesdec", Mnemonic::Vaesdec);
		let _ = h.insert("Vaesdeclast", Mnemonic::Vaesdeclast);
		let _ = h.insert("Vaesenc", Mnemonic::Vaesenc);
		let _ = h.insert("Vaesenclast", Mnemonic::Vaesenclast);
		let _ = h.insert("Vaesimc", Mnemonic::Vaesimc);
		let _ = h.insert("Vaeskeygenassist", Mnemonic::Vaeskeygenassist);
		let _ = h.insert("Valignd", Mnemonic::Valignd);
		let _ = h.insert("Valignq", Mnemonic::Valignq);
		let _ = h.insert("Vandnpd", Mnemonic::Vandnpd);
		let _ = h.insert("Vandnps", Mnemonic::Vandnps);
		let _ = h.insert("Vandpd", Mnemonic::Vandpd);
		let _ = h.insert("Vandps", Mnemonic::Vandps);
		let _ = h.insert("Vblendmpd", Mnemonic::Vblendmpd);
		let _ = h.insert("Vblendmps", Mnemonic::Vblendmps);
		let _ = h.insert("Vblendpd", Mnemonic::Vblendpd);
		let _ = h.insert("Vblendps", Mnemonic::Vblendps);
		let _ = h.insert("Vblendvpd", Mnemonic::Vblendvpd);
		let _ = h.insert("Vblendvps", Mnemonic::Vblendvps);
		let _ = h.insert("Vbroadcastf128", Mnemonic::Vbroadcastf128);
		let _ = h.insert("Vbroadcastf32x2", Mnemonic::Vbroadcastf32x2);
		let _ = h.insert("Vbroadcastf32x4", Mnemonic::Vbroadcastf32x4);
		let _ = h.insert("Vbroadcastf32x8", Mnemonic::Vbroadcastf32x8);
		let _ = h.insert("Vbroadcastf64x2", Mnemonic::Vbroadcastf64x2);
		let _ = h.insert("Vbroadcastf64x4", Mnemonic::Vbroadcastf64x4);
		let _ = h.insert("Vbroadcasti128", Mnemonic::Vbroadcasti128);
		let _ = h.insert("Vbroadcasti32x2", Mnemonic::Vbroadcasti32x2);
		let _ = h.insert("Vbroadcasti32x4", Mnemonic::Vbroadcasti32x4);
		let _ = h.insert("Vbroadcasti32x8", Mnemonic::Vbroadcasti32x8);
		let _ = h.insert("Vbroadcasti64x2", Mnemonic::Vbroadcasti64x2);
		let _ = h.insert("Vbroadcasti64x4", Mnemonic::Vbroadcasti64x4);
		let _ = h.insert("Vbroadcastsd", Mnemonic::Vbroadcastsd);
		let _ = h.insert("Vbroadcastss", Mnemonic::Vbroadcastss);
		let _ = h.insert("Vcmppd", Mnemonic::Vcmppd);
		let _ = h.insert("Vcmpps", Mnemonic::Vcmpps);
		let _ = h.insert("Vcmpsd", Mnemonic::Vcmpsd);
		let _ = h.insert("Vcmpss", Mnemonic::Vcmpss);
		let _ = h.insert("Vcomisd", Mnemonic::Vcomisd);
		let _ = h.insert("Vcomiss", Mnemonic::Vcomiss);
		let _ = h.insert("Vcompresspd", Mnemonic::Vcompresspd);
		let _ = h.insert("Vcompressps", Mnemonic::Vcompressps);
		let _ = h.insert("Vcvtdq2pd", Mnemonic::Vcvtdq2pd);
		let _ = h.insert("Vcvtdq2ps", Mnemonic::Vcvtdq2ps);
		let _ = h.insert("Vcvtne2ps2bf16", Mnemonic::Vcvtne2ps2bf16);
		let _ = h.insert("Vcvtneps2bf16", Mnemonic::Vcvtneps2bf16);
		let _ = h.insert("Vcvtpd2dq", Mnemonic::Vcvtpd2dq);
		let _ = h.insert("Vcvtpd2ps", Mnemonic::Vcvtpd2ps);
		let _ = h.insert("Vcvtpd2qq", Mnemonic::Vcvtpd2qq);
		let _ = h.insert("Vcvtpd2udq", Mnemonic::Vcvtpd2udq);
		let _ = h.insert("Vcvtpd2uqq", Mnemonic::Vcvtpd2uqq);
		let _ = h.insert("Vcvtph2ps", Mnemonic::Vcvtph2ps);
		let _ = h.insert("Vcvtps2dq", Mnemonic::Vcvtps2dq);
		let _ = h.insert("Vcvtps2pd", Mnemonic::Vcvtps2pd);
		let _ = h.insert("Vcvtps2ph", Mnemonic::Vcvtps2ph);
		let _ = h.insert("Vcvtps2qq", Mnemonic::Vcvtps2qq);
		let _ = h.insert("Vcvtps2udq", Mnemonic::Vcvtps2udq);
		let _ = h.insert("Vcvtps2uqq", Mnemonic::Vcvtps2uqq);
		let _ = h.insert("Vcvtqq2pd", Mnemonic::Vcvtqq2pd);
		let _ = h.insert("Vcvtqq2ps", Mnemonic::Vcvtqq2ps);
		let _ = h.insert("Vcvtsd2si", Mnemonic::Vcvtsd2si);
		let _ = h.insert("Vcvtsd2ss", Mnemonic::Vcvtsd2ss);
		let _ = h.insert("Vcvtsd2usi", Mnemonic::Vcvtsd2usi);
		let _ = h.insert("Vcvtsi2sd", Mnemonic::Vcvtsi2sd);
		let _ = h.insert("Vcvtsi2ss", Mnemonic::Vcvtsi2ss);
		let _ = h.insert("Vcvtss2sd", Mnemonic::Vcvtss2sd);
		let _ = h.insert("Vcvtss2si", Mnemonic::Vcvtss2si);
		let _ = h.insert("Vcvtss2usi", Mnemonic::Vcvtss2usi);
		let _ = h.insert("Vcvttpd2dq", Mnemonic::Vcvttpd2dq);
		let _ = h.insert("Vcvttpd2qq", Mnemonic::Vcvttpd2qq);
		let _ = h.insert("Vcvttpd2udq", Mnemonic::Vcvttpd2udq);
		let _ = h.insert("Vcvttpd2uqq", Mnemonic::Vcvttpd2uqq);
		let _ = h.insert("Vcvttps2dq", Mnemonic::Vcvttps2dq);
		let _ = h.insert("Vcvttps2qq", Mnemonic::Vcvttps2qq);
		let _ = h.insert("Vcvttps2udq", Mnemonic::Vcvttps2udq);
		let _ = h.insert("Vcvttps2uqq", Mnemonic::Vcvttps2uqq);
		let _ = h.insert("Vcvttsd2si", Mnemonic::Vcvttsd2si);
		let _ = h.insert("Vcvttsd2usi", Mnemonic::Vcvttsd2usi);
		let _ = h.insert("Vcvttss2si", Mnemonic::Vcvttss2si);
		let _ = h.insert("Vcvttss2usi", Mnemonic::Vcvttss2usi);
		let _ = h.insert("Vcvtudq2pd", Mnemonic::Vcvtudq2pd);
		let _ = h.insert("Vcvtudq2ps", Mnemonic::Vcvtudq2ps);
		let _ = h.insert("Vcvtuqq2pd", Mnemonic::Vcvtuqq2pd);
		let _ = h.insert("Vcvtuqq2ps", Mnemonic::Vcvtuqq2ps);
		let _ = h.insert("Vcvtusi2sd", Mnemonic::Vcvtusi2sd);
		let _ = h.insert("Vcvtusi2ss", Mnemonic::Vcvtusi2ss);
		let _ = h.insert("Vdbpsadbw", Mnemonic::Vdbpsadbw);
		let _ = h.insert("Vdivpd", Mnemonic::Vdivpd);
		let _ = h.insert("Vdivps", Mnemonic::Vdivps);
		let _ = h.insert("Vdivsd", Mnemonic::Vdivsd);
		let _ = h.insert("Vdivss", Mnemonic::Vdivss);
		let _ = h.insert("Vdpbf16ps", Mnemonic::Vdpbf16ps);
		let _ = h.insert("Vdppd", Mnemonic::Vdppd);
		let _ = h.insert("Vdpps", Mnemonic::Vdpps);
		let _ = h.insert("Verr", Mnemonic::Verr);
		let _ = h.insert("Verw", Mnemonic::Verw);
		let _ = h.insert("Vexp2pd", Mnemonic::Vexp2pd);
		let _ = h.insert("Vexp2ps", Mnemonic::Vexp2ps);
		let _ = h.insert("Vexpandpd", Mnemonic::Vexpandpd);
		let _ = h.insert("Vexpandps", Mnemonic::Vexpandps);
		let _ = h.insert("Vextractf128", Mnemonic::Vextractf128);
		let _ = h.insert("Vextractf32x4", Mnemonic::Vextractf32x4);
		let _ = h.insert("Vextractf32x8", Mnemonic::Vextractf32x8);
		let _ = h.insert("Vextractf64x2", Mnemonic::Vextractf64x2);
		let _ = h.insert("Vextractf64x4", Mnemonic::Vextractf64x4);
		let _ = h.insert("Vextracti128", Mnemonic::Vextracti128);
		let _ = h.insert("Vextracti32x4", Mnemonic::Vextracti32x4);
		let _ = h.insert("Vextracti32x8", Mnemonic::Vextracti32x8);
		let _ = h.insert("Vextracti64x2", Mnemonic::Vextracti64x2);
		let _ = h.insert("Vextracti64x4", Mnemonic::Vextracti64x4);
		let _ = h.insert("Vextractps", Mnemonic::Vextractps);
		let _ = h.insert("Vfixupimmpd", Mnemonic::Vfixupimmpd);
		let _ = h.insert("Vfixupimmps", Mnemonic::Vfixupimmps);
		let _ = h.insert("Vfixupimmsd", Mnemonic::Vfixupimmsd);
		let _ = h.insert("Vfixupimmss", Mnemonic::Vfixupimmss);
		let _ = h.insert("Vfmadd132pd", Mnemonic::Vfmadd132pd);
		let _ = h.insert("Vfmadd132ps", Mnemonic::Vfmadd132ps);
		let _ = h.insert("Vfmadd132sd", Mnemonic::Vfmadd132sd);
		let _ = h.insert("Vfmadd132ss", Mnemonic::Vfmadd132ss);
		let _ = h.insert("Vfmadd213pd", Mnemonic::Vfmadd213pd);
		let _ = h.insert("Vfmadd213ps", Mnemonic::Vfmadd213ps);
		let _ = h.insert("Vfmadd213sd", Mnemonic::Vfmadd213sd);
		let _ = h.insert("Vfmadd213ss", Mnemonic::Vfmadd213ss);
		let _ = h.insert("Vfmadd231pd", Mnemonic::Vfmadd231pd);
		let _ = h.insert("Vfmadd231ps", Mnemonic::Vfmadd231ps);
		let _ = h.insert("Vfmadd231sd", Mnemonic::Vfmadd231sd);
		let _ = h.insert("Vfmadd231ss", Mnemonic::Vfmadd231ss);
		let _ = h.insert("Vfmaddpd", Mnemonic::Vfmaddpd);
		let _ = h.insert("Vfmaddps", Mnemonic::Vfmaddps);
		let _ = h.insert("Vfmaddsd", Mnemonic::Vfmaddsd);
		let _ = h.insert("Vfmaddss", Mnemonic::Vfmaddss);
		let _ = h.insert("Vfmaddsub132pd", Mnemonic::Vfmaddsub132pd);
		let _ = h.insert("Vfmaddsub132ps", Mnemonic::Vfmaddsub132ps);
		let _ = h.insert("Vfmaddsub213pd", Mnemonic::Vfmaddsub213pd);
		let _ = h.insert("Vfmaddsub213ps", Mnemonic::Vfmaddsub213ps);
		let _ = h.insert("Vfmaddsub231pd", Mnemonic::Vfmaddsub231pd);
		let _ = h.insert("Vfmaddsub231ps", Mnemonic::Vfmaddsub231ps);
		let _ = h.insert("Vfmaddsubpd", Mnemonic::Vfmaddsubpd);
		let _ = h.insert("Vfmaddsubps", Mnemonic::Vfmaddsubps);
		let _ = h.insert("Vfmsub132pd", Mnemonic::Vfmsub132pd);
		let _ = h.insert("Vfmsub132ps", Mnemonic::Vfmsub132ps);
		let _ = h.insert("Vfmsub132sd", Mnemonic::Vfmsub132sd);
		let _ = h.insert("Vfmsub132ss", Mnemonic::Vfmsub132ss);
		let _ = h.insert("Vfmsub213pd", Mnemonic::Vfmsub213pd);
		let _ = h.insert("Vfmsub213ps", Mnemonic::Vfmsub213ps);
		let _ = h.insert("Vfmsub213sd", Mnemonic::Vfmsub213sd);
		let _ = h.insert("Vfmsub213ss", Mnemonic::Vfmsub213ss);
		let _ = h.insert("Vfmsub231pd", Mnemonic::Vfmsub231pd);
		let _ = h.insert("Vfmsub231ps", Mnemonic::Vfmsub231ps);
		let _ = h.insert("Vfmsub231sd", Mnemonic::Vfmsub231sd);
		let _ = h.insert("Vfmsub231ss", Mnemonic::Vfmsub231ss);
		let _ = h.insert("Vfmsubadd132pd", Mnemonic::Vfmsubadd132pd);
		let _ = h.insert("Vfmsubadd132ps", Mnemonic::Vfmsubadd132ps);
		let _ = h.insert("Vfmsubadd213pd", Mnemonic::Vfmsubadd213pd);
		let _ = h.insert("Vfmsubadd213ps", Mnemonic::Vfmsubadd213ps);
		let _ = h.insert("Vfmsubadd231pd", Mnemonic::Vfmsubadd231pd);
		let _ = h.insert("Vfmsubadd231ps", Mnemonic::Vfmsubadd231ps);
		let _ = h.insert("Vfmsubaddpd", Mnemonic::Vfmsubaddpd);
		let _ = h.insert("Vfmsubaddps", Mnemonic::Vfmsubaddps);
		let _ = h.insert("Vfmsubpd", Mnemonic::Vfmsubpd);
		let _ = h.insert("Vfmsubps", Mnemonic::Vfmsubps);
		let _ = h.insert("Vfmsubsd", Mnemonic::Vfmsubsd);
		let _ = h.insert("Vfmsubss", Mnemonic::Vfmsubss);
		let _ = h.insert("Vfnmadd132pd", Mnemonic::Vfnmadd132pd);
		let _ = h.insert("Vfnmadd132ps", Mnemonic::Vfnmadd132ps);
		let _ = h.insert("Vfnmadd132sd", Mnemonic::Vfnmadd132sd);
		let _ = h.insert("Vfnmadd132ss", Mnemonic::Vfnmadd132ss);
		let _ = h.insert("Vfnmadd213pd", Mnemonic::Vfnmadd213pd);
		let _ = h.insert("Vfnmadd213ps", Mnemonic::Vfnmadd213ps);
		let _ = h.insert("Vfnmadd213sd", Mnemonic::Vfnmadd213sd);
		let _ = h.insert("Vfnmadd213ss", Mnemonic::Vfnmadd213ss);
		let _ = h.insert("Vfnmadd231pd", Mnemonic::Vfnmadd231pd);
		let _ = h.insert("Vfnmadd231ps", Mnemonic::Vfnmadd231ps);
		let _ = h.insert("Vfnmadd231sd", Mnemonic::Vfnmadd231sd);
		let _ = h.insert("Vfnmadd231ss", Mnemonic::Vfnmadd231ss);
		let _ = h.insert("Vfnmaddpd", Mnemonic::Vfnmaddpd);
		let _ = h.insert("Vfnmaddps", Mnemonic::Vfnmaddps);
		let _ = h.insert("Vfnmaddsd", Mnemonic::Vfnmaddsd);
		let _ = h.insert("Vfnmaddss", Mnemonic::Vfnmaddss);
		let _ = h.insert("Vfnmsub132pd", Mnemonic::Vfnmsub132pd);
		let _ = h.insert("Vfnmsub132ps", Mnemonic::Vfnmsub132ps);
		let _ = h.insert("Vfnmsub132sd", Mnemonic::Vfnmsub132sd);
		let _ = h.insert("Vfnmsub132ss", Mnemonic::Vfnmsub132ss);
		let _ = h.insert("Vfnmsub213pd", Mnemonic::Vfnmsub213pd);
		let _ = h.insert("Vfnmsub213ps", Mnemonic::Vfnmsub213ps);
		let _ = h.insert("Vfnmsub213sd", Mnemonic::Vfnmsub213sd);
		let _ = h.insert("Vfnmsub213ss", Mnemonic::Vfnmsub213ss);
		let _ = h.insert("Vfnmsub231pd", Mnemonic::Vfnmsub231pd);
		let _ = h.insert("Vfnmsub231ps", Mnemonic::Vfnmsub231ps);
		let _ = h.insert("Vfnmsub231sd", Mnemonic::Vfnmsub231sd);
		let _ = h.insert("Vfnmsub231ss", Mnemonic::Vfnmsub231ss);
		let _ = h.insert("Vfnmsubpd", Mnemonic::Vfnmsubpd);
		let _ = h.insert("Vfnmsubps", Mnemonic::Vfnmsubps);
		let _ = h.insert("Vfnmsubsd", Mnemonic::Vfnmsubsd);
		let _ = h.insert("Vfnmsubss", Mnemonic::Vfnmsubss);
		let _ = h.insert("Vfpclasspd", Mnemonic::Vfpclasspd);
		let _ = h.insert("Vfpclassps", Mnemonic::Vfpclassps);
		let _ = h.insert("Vfpclasssd", Mnemonic::Vfpclasssd);
		let _ = h.insert("Vfpclassss", Mnemonic::Vfpclassss);
		let _ = h.insert("Vfrczpd", Mnemonic::Vfrczpd);
		let _ = h.insert("Vfrczps", Mnemonic::Vfrczps);
		let _ = h.insert("Vfrczsd", Mnemonic::Vfrczsd);
		let _ = h.insert("Vfrczss", Mnemonic::Vfrczss);
		let _ = h.insert("Vgatherdpd", Mnemonic::Vgatherdpd);
		let _ = h.insert("Vgatherdps", Mnemonic::Vgatherdps);
		let _ = h.insert("Vgatherpf0dpd", Mnemonic::Vgatherpf0dpd);
		let _ = h.insert("Vgatherpf0dps", Mnemonic::Vgatherpf0dps);
		let _ = h.insert("Vgatherpf0qpd", Mnemonic::Vgatherpf0qpd);
		let _ = h.insert("Vgatherpf0qps", Mnemonic::Vgatherpf0qps);
		let _ = h.insert("Vgatherpf1dpd", Mnemonic::Vgatherpf1dpd);
		let _ = h.insert("Vgatherpf1dps", Mnemonic::Vgatherpf1dps);
		let _ = h.insert("Vgatherpf1qpd", Mnemonic::Vgatherpf1qpd);
		let _ = h.insert("Vgatherpf1qps", Mnemonic::Vgatherpf1qps);
		let _ = h.insert("Vgatherqpd", Mnemonic::Vgatherqpd);
		let _ = h.insert("Vgatherqps", Mnemonic::Vgatherqps);
		let _ = h.insert("Vgetexppd", Mnemonic::Vgetexppd);
		let _ = h.insert("Vgetexpps", Mnemonic::Vgetexpps);
		let _ = h.insert("Vgetexpsd", Mnemonic::Vgetexpsd);
		let _ = h.insert("Vgetexpss", Mnemonic::Vgetexpss);
		let _ = h.insert("Vgetmantpd", Mnemonic::Vgetmantpd);
		let _ = h.insert("Vgetmantps", Mnemonic::Vgetmantps);
		let _ = h.insert("Vgetmantsd", Mnemonic::Vgetmantsd);
		let _ = h.insert("Vgetmantss", Mnemonic::Vgetmantss);
		let _ = h.insert("Vgf2p8affineinvqb", Mnemonic::Vgf2p8affineinvqb);
		let _ = h.insert("Vgf2p8affineqb", Mnemonic::Vgf2p8affineqb);
		let _ = h.insert("Vgf2p8mulb", Mnemonic::Vgf2p8mulb);
		let _ = h.insert("Vhaddpd", Mnemonic::Vhaddpd);
		let _ = h.insert("Vhaddps", Mnemonic::Vhaddps);
		let _ = h.insert("Vhsubpd", Mnemonic::Vhsubpd);
		let _ = h.insert("Vhsubps", Mnemonic::Vhsubps);
		let _ = h.insert("Vinsertf128", Mnemonic::Vinsertf128);
		let _ = h.insert("Vinsertf32x4", Mnemonic::Vinsertf32x4);
		let _ = h.insert("Vinsertf32x8", Mnemonic::Vinsertf32x8);
		let _ = h.insert("Vinsertf64x2", Mnemonic::Vinsertf64x2);
		let _ = h.insert("Vinsertf64x4", Mnemonic::Vinsertf64x4);
		let _ = h.insert("Vinserti128", Mnemonic::Vinserti128);
		let _ = h.insert("Vinserti32x4", Mnemonic::Vinserti32x4);
		let _ = h.insert("Vinserti32x8", Mnemonic::Vinserti32x8);
		let _ = h.insert("Vinserti64x2", Mnemonic::Vinserti64x2);
		let _ = h.insert("Vinserti64x4", Mnemonic::Vinserti64x4);
		let _ = h.insert("Vinsertps", Mnemonic::Vinsertps);
		let _ = h.insert("Vlddqu", Mnemonic::Vlddqu);
		let _ = h.insert("Vldmxcsr", Mnemonic::Vldmxcsr);
		let _ = h.insert("Vmaskmovdqu", Mnemonic::Vmaskmovdqu);
		let _ = h.insert("Vmaskmovpd", Mnemonic::Vmaskmovpd);
		let _ = h.insert("Vmaskmovps", Mnemonic::Vmaskmovps);
		let _ = h.insert("Vmaxpd", Mnemonic::Vmaxpd);
		let _ = h.insert("Vmaxps", Mnemonic::Vmaxps);
		let _ = h.insert("Vmaxsd", Mnemonic::Vmaxsd);
		let _ = h.insert("Vmaxss", Mnemonic::Vmaxss);
		let _ = h.insert("Vmcall", Mnemonic::Vmcall);
		let _ = h.insert("Vmclear", Mnemonic::Vmclear);
		let _ = h.insert("Vmfunc", Mnemonic::Vmfunc);
		let _ = h.insert("Vminpd", Mnemonic::Vminpd);
		let _ = h.insert("Vminps", Mnemonic::Vminps);
		let _ = h.insert("Vminsd", Mnemonic::Vminsd);
		let _ = h.insert("Vminss", Mnemonic::Vminss);
		let _ = h.insert("Vmlaunch", Mnemonic::Vmlaunch);
		let _ = h.insert("Vmload", Mnemonic::Vmload);
		let _ = h.insert("Vmmcall", Mnemonic::Vmmcall);
		let _ = h.insert("Vmovapd", Mnemonic::Vmovapd);
		let _ = h.insert("Vmovaps", Mnemonic::Vmovaps);
		let _ = h.insert("Vmovd", Mnemonic::Vmovd);
		let _ = h.insert("Vmovddup", Mnemonic::Vmovddup);
		let _ = h.insert("Vmovdqa", Mnemonic::Vmovdqa);
		let _ = h.insert("Vmovdqa32", Mnemonic::Vmovdqa32);
		let _ = h.insert("Vmovdqa64", Mnemonic::Vmovdqa64);
		let _ = h.insert("Vmovdqu", Mnemonic::Vmovdqu);
		let _ = h.insert("Vmovdqu16", Mnemonic::Vmovdqu16);
		let _ = h.insert("Vmovdqu32", Mnemonic::Vmovdqu32);
		let _ = h.insert("Vmovdqu64", Mnemonic::Vmovdqu64);
		let _ = h.insert("Vmovdqu8", Mnemonic::Vmovdqu8);
		let _ = h.insert("Vmovhlps", Mnemonic::Vmovhlps);
		let _ = h.insert("Vmovhpd", Mnemonic::Vmovhpd);
		let _ = h.insert("Vmovhps", Mnemonic::Vmovhps);
		let _ = h.insert("Vmovlhps", Mnemonic::Vmovlhps);
		let _ = h.insert("Vmovlpd", Mnemonic::Vmovlpd);
		let _ = h.insert("Vmovlps", Mnemonic::Vmovlps);
		let _ = h.insert("Vmovmskpd", Mnemonic::Vmovmskpd);
		let _ = h.insert("Vmovmskps", Mnemonic::Vmovmskps);
		let _ = h.insert("Vmovntdq", Mnemonic::Vmovntdq);
		let _ = h.insert("Vmovntdqa", Mnemonic::Vmovntdqa);
		let _ = h.insert("Vmovntpd", Mnemonic::Vmovntpd);
		let _ = h.insert("Vmovntps", Mnemonic::Vmovntps);
		let _ = h.insert("Vmovq", Mnemonic::Vmovq);
		let _ = h.insert("Vmovsd", Mnemonic::Vmovsd);
		let _ = h.insert("Vmovshdup", Mnemonic::Vmovshdup);
		let _ = h.insert("Vmovsldup", Mnemonic::Vmovsldup);
		let _ = h.insert("Vmovss", Mnemonic::Vmovss);
		let _ = h.insert("Vmovupd", Mnemonic::Vmovupd);
		let _ = h.insert("Vmovups", Mnemonic::Vmovups);
		let _ = h.insert("Vmpsadbw", Mnemonic::Vmpsadbw);
		let _ = h.insert("Vmptrld", Mnemonic::Vmptrld);
		let _ = h.insert("Vmptrst", Mnemonic::Vmptrst);
		let _ = h.insert("Vmread", Mnemonic::Vmread);
		let _ = h.insert("Vmresume", Mnemonic::Vmresume);
		let _ = h.insert("Vmrun", Mnemonic::Vmrun);
		let _ = h.insert("Vmsave", Mnemonic::Vmsave);
		let _ = h.insert("Vmulpd", Mnemonic::Vmulpd);
		let _ = h.insert("Vmulps", Mnemonic::Vmulps);
		let _ = h.insert("Vmulsd", Mnemonic::Vmulsd);
		let _ = h.insert("Vmulss", Mnemonic::Vmulss);
		let _ = h.insert("Vmwrite", Mnemonic::Vmwrite);
		let _ = h.insert("Vmxoff", Mnemonic::Vmxoff);
		let _ = h.insert("Vmxon", Mnemonic::Vmxon);
		let _ = h.insert("Vorpd", Mnemonic::Vorpd);
		let _ = h.insert("Vorps", Mnemonic::Vorps);
		let _ = h.insert("Vp2intersectd", Mnemonic::Vp2intersectd);
		let _ = h.insert("Vp2intersectq", Mnemonic::Vp2intersectq);
		let _ = h.insert("Vp4dpwssd", Mnemonic::Vp4dpwssd);
		let _ = h.insert("Vp4dpwssds", Mnemonic::Vp4dpwssds);
		let _ = h.insert("Vpabsb", Mnemonic::Vpabsb);
		let _ = h.insert("Vpabsd", Mnemonic::Vpabsd);
		let _ = h.insert("Vpabsq", Mnemonic::Vpabsq);
		let _ = h.insert("Vpabsw", Mnemonic::Vpabsw);
		let _ = h.insert("Vpackssdw", Mnemonic::Vpackssdw);
		let _ = h.insert("Vpacksswb", Mnemonic::Vpacksswb);
		let _ = h.insert("Vpackusdw", Mnemonic::Vpackusdw);
		let _ = h.insert("Vpackuswb", Mnemonic::Vpackuswb);
		let _ = h.insert("Vpaddb", Mnemonic::Vpaddb);
		let _ = h.insert("Vpaddd", Mnemonic::Vpaddd);
		let _ = h.insert("Vpaddq", Mnemonic::Vpaddq);
		let _ = h.insert("Vpaddsb", Mnemonic::Vpaddsb);
		let _ = h.insert("Vpaddsw", Mnemonic::Vpaddsw);
		let _ = h.insert("Vpaddusb", Mnemonic::Vpaddusb);
		let _ = h.insert("Vpaddusw", Mnemonic::Vpaddusw);
		let _ = h.insert("Vpaddw", Mnemonic::Vpaddw);
		let _ = h.insert("Vpalignr", Mnemonic::Vpalignr);
		let _ = h.insert("Vpand", Mnemonic::Vpand);
		let _ = h.insert("Vpandd", Mnemonic::Vpandd);
		let _ = h.insert("Vpandn", Mnemonic::Vpandn);
		let _ = h.insert("Vpandnd", Mnemonic::Vpandnd);
		let _ = h.insert("Vpandnq", Mnemonic::Vpandnq);
		let _ = h.insert("Vpandq", Mnemonic::Vpandq);
		let _ = h.insert("Vpavgb", Mnemonic::Vpavgb);
		let _ = h.insert("Vpavgw", Mnemonic::Vpavgw);
		let _ = h.insert("Vpblendd", Mnemonic::Vpblendd);
		let _ = h.insert("Vpblendmb", Mnemonic::Vpblendmb);
		let _ = h.insert("Vpblendmd", Mnemonic::Vpblendmd);
		let _ = h.insert("Vpblendmq", Mnemonic::Vpblendmq);
		let _ = h.insert("Vpblendmw", Mnemonic::Vpblendmw);
		let _ = h.insert("Vpblendvb", Mnemonic::Vpblendvb);
		let _ = h.insert("Vpblendw", Mnemonic::Vpblendw);
		let _ = h.insert("Vpbroadcastb", Mnemonic::Vpbroadcastb);
		let _ = h.insert("Vpbroadcastd", Mnemonic::Vpbroadcastd);
		let _ = h.insert("Vpbroadcastmb2q", Mnemonic::Vpbroadcastmb2q);
		let _ = h.insert("Vpbroadcastmw2d", Mnemonic::Vpbroadcastmw2d);
		let _ = h.insert("Vpbroadcastq", Mnemonic::Vpbroadcastq);
		let _ = h.insert("Vpbroadcastw", Mnemonic::Vpbroadcastw);
		let _ = h.insert("Vpclmulqdq", Mnemonic::Vpclmulqdq);
		let _ = h.insert("Vpcmov", Mnemonic::Vpcmov);
		let _ = h.insert("Vpcmpb", Mnemonic::Vpcmpb);
		let _ = h.insert("Vpcmpd", Mnemonic::Vpcmpd);
		let _ = h.insert("Vpcmpeqb", Mnemonic::Vpcmpeqb);
		let _ = h.insert("Vpcmpeqd", Mnemonic::Vpcmpeqd);
		let _ = h.insert("Vpcmpeqq", Mnemonic::Vpcmpeqq);
		let _ = h.insert("Vpcmpeqw", Mnemonic::Vpcmpeqw);
		let _ = h.insert("Vpcmpestri", Mnemonic::Vpcmpestri);
		let _ = h.insert("Vpcmpestri64", Mnemonic::Vpcmpestri64);
		let _ = h.insert("Vpcmpestrm", Mnemonic::Vpcmpestrm);
		let _ = h.insert("Vpcmpestrm64", Mnemonic::Vpcmpestrm64);
		let _ = h.insert("Vpcmpgtb", Mnemonic::Vpcmpgtb);
		let _ = h.insert("Vpcmpgtd", Mnemonic::Vpcmpgtd);
		let _ = h.insert("Vpcmpgtq", Mnemonic::Vpcmpgtq);
		let _ = h.insert("Vpcmpgtw", Mnemonic::Vpcmpgtw);
		let _ = h.insert("Vpcmpistri", Mnemonic::Vpcmpistri);
		let _ = h.insert("Vpcmpistrm", Mnemonic::Vpcmpistrm);
		let _ = h.insert("Vpcmpq", Mnemonic::Vpcmpq);
		let _ = h.insert("Vpcmpub", Mnemonic::Vpcmpub);
		let _ = h.insert("Vpcmpud", Mnemonic::Vpcmpud);
		let _ = h.insert("Vpcmpuq", Mnemonic::Vpcmpuq);
		let _ = h.insert("Vpcmpuw", Mnemonic::Vpcmpuw);
		let _ = h.insert("Vpcmpw", Mnemonic::Vpcmpw);
		let _ = h.insert("Vpcomb", Mnemonic::Vpcomb);
		let _ = h.insert("Vpcomd", Mnemonic::Vpcomd);
		let _ = h.insert("Vpcompressb", Mnemonic::Vpcompressb);
		let _ = h.insert("Vpcompressd", Mnemonic::Vpcompressd);
		let _ = h.insert("Vpcompressq", Mnemonic::Vpcompressq);
		let _ = h.insert("Vpcompressw", Mnemonic::Vpcompressw);
		let _ = h.insert("Vpcomq", Mnemonic::Vpcomq);
		let _ = h.insert("Vpcomub", Mnemonic::Vpcomub);
		let _ = h.insert("Vpcomud", Mnemonic::Vpcomud);
		let _ = h.insert("Vpcomuq", Mnemonic::Vpcomuq);
		let _ = h.insert("Vpcomuw", Mnemonic::Vpcomuw);
		let _ = h.insert("Vpcomw", Mnemonic::Vpcomw);
		let _ = h.insert("Vpconflictd", Mnemonic::Vpconflictd);
		let _ = h.insert("Vpconflictq", Mnemonic::Vpconflictq);
		let _ = h.insert("Vpdpbusd", Mnemonic::Vpdpbusd);
		let _ = h.insert("Vpdpbusds", Mnemonic::Vpdpbusds);
		let _ = h.insert("Vpdpwssd", Mnemonic::Vpdpwssd);
		let _ = h.insert("Vpdpwssds", Mnemonic::Vpdpwssds);
		let _ = h.insert("Vperm2f128", Mnemonic::Vperm2f128);
		let _ = h.insert("Vperm2i128", Mnemonic::Vperm2i128);
		let _ = h.insert("Vpermb", Mnemonic::Vpermb);
		let _ = h.insert("Vpermd", Mnemonic::Vpermd);
		let _ = h.insert("Vpermi2b", Mnemonic::Vpermi2b);
		let _ = h.insert("Vpermi2d", Mnemonic::Vpermi2d);
		let _ = h.insert("Vpermi2pd", Mnemonic::Vpermi2pd);
		let _ = h.insert("Vpermi2ps", Mnemonic::Vpermi2ps);
		let _ = h.insert("Vpermi2q", Mnemonic::Vpermi2q);
		let _ = h.insert("Vpermi2w", Mnemonic::Vpermi2w);
		let _ = h.insert("Vpermil2pd", Mnemonic::Vpermil2pd);
		let _ = h.insert("Vpermil2ps", Mnemonic::Vpermil2ps);
		let _ = h.insert("Vpermilpd", Mnemonic::Vpermilpd);
		let _ = h.insert("Vpermilps", Mnemonic::Vpermilps);
		let _ = h.insert("Vpermpd", Mnemonic::Vpermpd);
		let _ = h.insert("Vpermps", Mnemonic::Vpermps);
		let _ = h.insert("Vpermq", Mnemonic::Vpermq);
		let _ = h.insert("Vpermt2b", Mnemonic::Vpermt2b);
		let _ = h.insert("Vpermt2d", Mnemonic::Vpermt2d);
		let _ = h.insert("Vpermt2pd", Mnemonic::Vpermt2pd);
		let _ = h.insert("Vpermt2ps", Mnemonic::Vpermt2ps);
		let _ = h.insert("Vpermt2q", Mnemonic::Vpermt2q);
		let _ = h.insert("Vpermt2w", Mnemonic::Vpermt2w);
		let _ = h.insert("Vpermw", Mnemonic::Vpermw);
		let _ = h.insert("Vpexpandb", Mnemonic::Vpexpandb);
		let _ = h.insert("Vpexpandd", Mnemonic::Vpexpandd);
		let _ = h.insert("Vpexpandq", Mnemonic::Vpexpandq);
		let _ = h.insert("Vpexpandw", Mnemonic::Vpexpandw);
		let _ = h.insert("Vpextrb", Mnemonic::Vpextrb);
		let _ = h.insert("Vpextrd", Mnemonic::Vpextrd);
		let _ = h.insert("Vpextrq", Mnemonic::Vpextrq);
		let _ = h.insert("Vpextrw", Mnemonic::Vpextrw);
		let _ = h.insert("Vpgatherdd", Mnemonic::Vpgatherdd);
		let _ = h.insert("Vpgatherdq", Mnemonic::Vpgatherdq);
		let _ = h.insert("Vpgatherqd", Mnemonic::Vpgatherqd);
		let _ = h.insert("Vpgatherqq", Mnemonic::Vpgatherqq);
		let _ = h.insert("Vphaddbd", Mnemonic::Vphaddbd);
		let _ = h.insert("Vphaddbq", Mnemonic::Vphaddbq);
		let _ = h.insert("Vphaddbw", Mnemonic::Vphaddbw);
		let _ = h.insert("Vphaddd", Mnemonic::Vphaddd);
		let _ = h.insert("Vphadddq", Mnemonic::Vphadddq);
		let _ = h.insert("Vphaddsw", Mnemonic::Vphaddsw);
		let _ = h.insert("Vphaddubd", Mnemonic::Vphaddubd);
		let _ = h.insert("Vphaddubq", Mnemonic::Vphaddubq);
		let _ = h.insert("Vphaddubw", Mnemonic::Vphaddubw);
		let _ = h.insert("Vphaddudq", Mnemonic::Vphaddudq);
		let _ = h.insert("Vphadduwd", Mnemonic::Vphadduwd);
		let _ = h.insert("Vphadduwq", Mnemonic::Vphadduwq);
		let _ = h.insert("Vphaddw", Mnemonic::Vphaddw);
		let _ = h.insert("Vphaddwd", Mnemonic::Vphaddwd);
		let _ = h.insert("Vphaddwq", Mnemonic::Vphaddwq);
		let _ = h.insert("Vphminposuw", Mnemonic::Vphminposuw);
		let _ = h.insert("Vphsubbw", Mnemonic::Vphsubbw);
		let _ = h.insert("Vphsubd", Mnemonic::Vphsubd);
		let _ = h.insert("Vphsubdq", Mnemonic::Vphsubdq);
		let _ = h.insert("Vphsubsw", Mnemonic::Vphsubsw);
		let _ = h.insert("Vphsubw", Mnemonic::Vphsubw);
		let _ = h.insert("Vphsubwd", Mnemonic::Vphsubwd);
		let _ = h.insert("Vpinsrb", Mnemonic::Vpinsrb);
		let _ = h.insert("Vpinsrd", Mnemonic::Vpinsrd);
		let _ = h.insert("Vpinsrq", Mnemonic::Vpinsrq);
		let _ = h.insert("Vpinsrw", Mnemonic::Vpinsrw);
		let _ = h.insert("Vplzcntd", Mnemonic::Vplzcntd);
		let _ = h.insert("Vplzcntq", Mnemonic::Vplzcntq);
		let _ = h.insert("Vpmacsdd", Mnemonic::Vpmacsdd);
		let _ = h.insert("Vpmacsdqh", Mnemonic::Vpmacsdqh);
		let _ = h.insert("Vpmacsdql", Mnemonic::Vpmacsdql);
		let _ = h.insert("Vpmacssdd", Mnemonic::Vpmacssdd);
		let _ = h.insert("Vpmacssdqh", Mnemonic::Vpmacssdqh);
		let _ = h.insert("Vpmacssdql", Mnemonic::Vpmacssdql);
		let _ = h.insert("Vpmacsswd", Mnemonic::Vpmacsswd);
		let _ = h.insert("Vpmacssww", Mnemonic::Vpmacssww);
		let _ = h.insert("Vpmacswd", Mnemonic::Vpmacswd);
		let _ = h.insert("Vpmacsww", Mnemonic::Vpmacsww);
		let _ = h.insert("Vpmadcsswd", Mnemonic::Vpmadcsswd);
		let _ = h.insert("Vpmadcswd", Mnemonic::Vpmadcswd);
		let _ = h.insert("Vpmadd52huq", Mnemonic::Vpmadd52huq);
		let _ = h.insert("Vpmadd52luq", Mnemonic::Vpmadd52luq);
		let _ = h.insert("Vpmaddubsw", Mnemonic::Vpmaddubsw);
		let _ = h.insert("Vpmaddwd", Mnemonic::Vpmaddwd);
		let _ = h.insert("Vpmaskmovd", Mnemonic::Vpmaskmovd);
		let _ = h.insert("Vpmaskmovq", Mnemonic::Vpmaskmovq);
		let _ = h.insert("Vpmaxsb", Mnemonic::Vpmaxsb);
		let _ = h.insert("Vpmaxsd", Mnemonic::Vpmaxsd);
		let _ = h.insert("Vpmaxsq", Mnemonic::Vpmaxsq);
		let _ = h.insert("Vpmaxsw", Mnemonic::Vpmaxsw);
		let _ = h.insert("Vpmaxub", Mnemonic::Vpmaxub);
		let _ = h.insert("Vpmaxud", Mnemonic::Vpmaxud);
		let _ = h.insert("Vpmaxuq", Mnemonic::Vpmaxuq);
		let _ = h.insert("Vpmaxuw", Mnemonic::Vpmaxuw);
		let _ = h.insert("Vpminsb", Mnemonic::Vpminsb);
		let _ = h.insert("Vpminsd", Mnemonic::Vpminsd);
		let _ = h.insert("Vpminsq", Mnemonic::Vpminsq);
		let _ = h.insert("Vpminsw", Mnemonic::Vpminsw);
		let _ = h.insert("Vpminub", Mnemonic::Vpminub);
		let _ = h.insert("Vpminud", Mnemonic::Vpminud);
		let _ = h.insert("Vpminuq", Mnemonic::Vpminuq);
		let _ = h.insert("Vpminuw", Mnemonic::Vpminuw);
		let _ = h.insert("Vpmovb2m", Mnemonic::Vpmovb2m);
		let _ = h.insert("Vpmovd2m", Mnemonic::Vpmovd2m);
		let _ = h.insert("Vpmovdb", Mnemonic::Vpmovdb);
		let _ = h.insert("Vpmovdw", Mnemonic::Vpmovdw);
		let _ = h.insert("Vpmovm2b", Mnemonic::Vpmovm2b);
		let _ = h.insert("Vpmovm2d", Mnemonic::Vpmovm2d);
		let _ = h.insert("Vpmovm2q", Mnemonic::Vpmovm2q);
		let _ = h.insert("Vpmovm2w", Mnemonic::Vpmovm2w);
		let _ = h.insert("Vpmovmskb", Mnemonic::Vpmovmskb);
		let _ = h.insert("Vpmovq2m", Mnemonic::Vpmovq2m);
		let _ = h.insert("Vpmovqb", Mnemonic::Vpmovqb);
		let _ = h.insert("Vpmovqd", Mnemonic::Vpmovqd);
		let _ = h.insert("Vpmovqw", Mnemonic::Vpmovqw);
		let _ = h.insert("Vpmovsdb", Mnemonic::Vpmovsdb);
		let _ = h.insert("Vpmovsdw", Mnemonic::Vpmovsdw);
		let _ = h.insert("Vpmovsqb", Mnemonic::Vpmovsqb);
		let _ = h.insert("Vpmovsqd", Mnemonic::Vpmovsqd);
		let _ = h.insert("Vpmovsqw", Mnemonic::Vpmovsqw);
		let _ = h.insert("Vpmovswb", Mnemonic::Vpmovswb);
		let _ = h.insert("Vpmovsxbd", Mnemonic::Vpmovsxbd);
		let _ = h.insert("Vpmovsxbq", Mnemonic::Vpmovsxbq);
		let _ = h.insert("Vpmovsxbw", Mnemonic::Vpmovsxbw);
		let _ = h.insert("Vpmovsxdq", Mnemonic::Vpmovsxdq);
		let _ = h.insert("Vpmovsxwd", Mnemonic::Vpmovsxwd);
		let _ = h.insert("Vpmovsxwq", Mnemonic::Vpmovsxwq);
		let _ = h.insert("Vpmovusdb", Mnemonic::Vpmovusdb);
		let _ = h.insert("Vpmovusdw", Mnemonic::Vpmovusdw);
		let _ = h.insert("Vpmovusqb", Mnemonic::Vpmovusqb);
		let _ = h.insert("Vpmovusqd", Mnemonic::Vpmovusqd);
		let _ = h.insert("Vpmovusqw", Mnemonic::Vpmovusqw);
		let _ = h.insert("Vpmovuswb", Mnemonic::Vpmovuswb);
		let _ = h.insert("Vpmovw2m", Mnemonic::Vpmovw2m);
		let _ = h.insert("Vpmovwb", Mnemonic::Vpmovwb);
		let _ = h.insert("Vpmovzxbd", Mnemonic::Vpmovzxbd);
		let _ = h.insert("Vpmovzxbq", Mnemonic::Vpmovzxbq);
		let _ = h.insert("Vpmovzxbw", Mnemonic::Vpmovzxbw);
		let _ = h.insert("Vpmovzxdq", Mnemonic::Vpmovzxdq);
		let _ = h.insert("Vpmovzxwd", Mnemonic::Vpmovzxwd);
		let _ = h.insert("Vpmovzxwq", Mnemonic::Vpmovzxwq);
		let _ = h.insert("Vpmuldq", Mnemonic::Vpmuldq);
		let _ = h.insert("Vpmulhrsw", Mnemonic::Vpmulhrsw);
		let _ = h.insert("Vpmulhuw", Mnemonic::Vpmulhuw);
		let _ = h.insert("Vpmulhw", Mnemonic::Vpmulhw);
		let _ = h.insert("Vpmulld", Mnemonic::Vpmulld);
		let _ = h.insert("Vpmullq", Mnemonic::Vpmullq);
		let _ = h.insert("Vpmullw", Mnemonic::Vpmullw);
		let _ = h.insert("Vpmultishiftqb", Mnemonic::Vpmultishiftqb);
		let _ = h.insert("Vpmuludq", Mnemonic::Vpmuludq);
		let _ = h.insert("Vpopcntb", Mnemonic::Vpopcntb);
		let _ = h.insert("Vpopcntd", Mnemonic::Vpopcntd);
		let _ = h.insert("Vpopcntq", Mnemonic::Vpopcntq);
		let _ = h.insert("Vpopcntw", Mnemonic::Vpopcntw);
		let _ = h.insert("Vpor", Mnemonic::Vpor);
		let _ = h.insert("Vpord", Mnemonic::Vpord);
		let _ = h.insert("Vporq", Mnemonic::Vporq);
		let _ = h.insert("Vpperm", Mnemonic::Vpperm);
		let _ = h.insert("Vprold", Mnemonic::Vprold);
		let _ = h.insert("Vprolq", Mnemonic::Vprolq);
		let _ = h.insert("Vprolvd", Mnemonic::Vprolvd);
		let _ = h.insert("Vprolvq", Mnemonic::Vprolvq);
		let _ = h.insert("Vprord", Mnemonic::Vprord);
		let _ = h.insert("Vprorq", Mnemonic::Vprorq);
		let _ = h.insert("Vprorvd", Mnemonic::Vprorvd);
		let _ = h.insert("Vprorvq", Mnemonic::Vprorvq);
		let _ = h.insert("Vprotb", Mnemonic::Vprotb);
		let _ = h.insert("Vprotd", Mnemonic::Vprotd);
		let _ = h.insert("Vprotq", Mnemonic::Vprotq);
		let _ = h.insert("Vprotw", Mnemonic::Vprotw);
		let _ = h.insert("Vpsadbw", Mnemonic::Vpsadbw);
		let _ = h.insert("Vpscatterdd", Mnemonic::Vpscatterdd);
		let _ = h.insert("Vpscatterdq", Mnemonic::Vpscatterdq);
		let _ = h.insert("Vpscatterqd", Mnemonic::Vpscatterqd);
		let _ = h.insert("Vpscatterqq", Mnemonic::Vpscatterqq);
		let _ = h.insert("Vpshab", Mnemonic::Vpshab);
		let _ = h.insert("Vpshad", Mnemonic::Vpshad);
		let _ = h.insert("Vpshaq", Mnemonic::Vpshaq);
		let _ = h.insert("Vpshaw", Mnemonic::Vpshaw);
		let _ = h.insert("Vpshlb", Mnemonic::Vpshlb);
		let _ = h.insert("Vpshld", Mnemonic::Vpshld);
		let _ = h.insert("Vpshldd", Mnemonic::Vpshldd);
		let _ = h.insert("Vpshldq", Mnemonic::Vpshldq);
		let _ = h.insert("Vpshldvd", Mnemonic::Vpshldvd);
		let _ = h.insert("Vpshldvq", Mnemonic::Vpshldvq);
		let _ = h.insert("Vpshldvw", Mnemonic::Vpshldvw);
		let _ = h.insert("Vpshldw", Mnemonic::Vpshldw);
		let _ = h.insert("Vpshlq", Mnemonic::Vpshlq);
		let _ = h.insert("Vpshlw", Mnemonic::Vpshlw);
		let _ = h.insert("Vpshrdd", Mnemonic::Vpshrdd);
		let _ = h.insert("Vpshrdq", Mnemonic::Vpshrdq);
		let _ = h.insert("Vpshrdvd", Mnemonic::Vpshrdvd);
		let _ = h.insert("Vpshrdvq", Mnemonic::Vpshrdvq);
		let _ = h.insert("Vpshrdvw", Mnemonic::Vpshrdvw);
		let _ = h.insert("Vpshrdw", Mnemonic::Vpshrdw);
		let _ = h.insert("Vpshufb", Mnemonic::Vpshufb);
		let _ = h.insert("Vpshufbitqmb", Mnemonic::Vpshufbitqmb);
		let _ = h.insert("Vpshufd", Mnemonic::Vpshufd);
		let _ = h.insert("Vpshufhw", Mnemonic::Vpshufhw);
		let _ = h.insert("Vpshuflw", Mnemonic::Vpshuflw);
		let _ = h.insert("Vpsignb", Mnemonic::Vpsignb);
		let _ = h.insert("Vpsignd", Mnemonic::Vpsignd);
		let _ = h.insert("Vpsignw", Mnemonic::Vpsignw);
		let _ = h.insert("Vpslld", Mnemonic::Vpslld);
		let _ = h.insert("Vpslldq", Mnemonic::Vpslldq);
		let _ = h.insert("Vpsllq", Mnemonic::Vpsllq);
		let _ = h.insert("Vpsllvd", Mnemonic::Vpsllvd);
		let _ = h.insert("Vpsllvq", Mnemonic::Vpsllvq);
		let _ = h.insert("Vpsllvw", Mnemonic::Vpsllvw);
		let _ = h.insert("Vpsllw", Mnemonic::Vpsllw);
		let _ = h.insert("Vpsrad", Mnemonic::Vpsrad);
		let _ = h.insert("Vpsraq", Mnemonic::Vpsraq);
		let _ = h.insert("Vpsravd", Mnemonic::Vpsravd);
		let _ = h.insert("Vpsravq", Mnemonic::Vpsravq);
		let _ = h.insert("Vpsravw", Mnemonic::Vpsravw);
		let _ = h.insert("Vpsraw", Mnemonic::Vpsraw);
		let _ = h.insert("Vpsrld", Mnemonic::Vpsrld);
		let _ = h.insert("Vpsrldq", Mnemonic::Vpsrldq);
		let _ = h.insert("Vpsrlq", Mnemonic::Vpsrlq);
		let _ = h.insert("Vpsrlvd", Mnemonic::Vpsrlvd);
		let _ = h.insert("Vpsrlvq", Mnemonic::Vpsrlvq);
		let _ = h.insert("Vpsrlvw", Mnemonic::Vpsrlvw);
		let _ = h.insert("Vpsrlw", Mnemonic::Vpsrlw);
		let _ = h.insert("Vpsubb", Mnemonic::Vpsubb);
		let _ = h.insert("Vpsubd", Mnemonic::Vpsubd);
		let _ = h.insert("Vpsubq", Mnemonic::Vpsubq);
		let _ = h.insert("Vpsubsb", Mnemonic::Vpsubsb);
		let _ = h.insert("Vpsubsw", Mnemonic::Vpsubsw);
		let _ = h.insert("Vpsubusb", Mnemonic::Vpsubusb);
		let _ = h.insert("Vpsubusw", Mnemonic::Vpsubusw);
		let _ = h.insert("Vpsubw", Mnemonic::Vpsubw);
		let _ = h.insert("Vpternlogd", Mnemonic::Vpternlogd);
		let _ = h.insert("Vpternlogq", Mnemonic::Vpternlogq);
		let _ = h.insert("Vptest", Mnemonic::Vptest);
		let _ = h.insert("Vptestmb", Mnemonic::Vptestmb);
		let _ = h.insert("Vptestmd", Mnemonic::Vptestmd);
		let _ = h.insert("Vptestmq", Mnemonic::Vptestmq);
		let _ = h.insert("Vptestmw", Mnemonic::Vptestmw);
		let _ = h.insert("Vptestnmb", Mnemonic::Vptestnmb);
		let _ = h.insert("Vptestnmd", Mnemonic::Vptestnmd);
		let _ = h.insert("Vptestnmq", Mnemonic::Vptestnmq);
		let _ = h.insert("Vptestnmw", Mnemonic::Vptestnmw);
		let _ = h.insert("Vpunpckhbw", Mnemonic::Vpunpckhbw);
		let _ = h.insert("Vpunpckhdq", Mnemonic::Vpunpckhdq);
		let _ = h.insert("Vpunpckhqdq", Mnemonic::Vpunpckhqdq);
		let _ = h.insert("Vpunpckhwd", Mnemonic::Vpunpckhwd);
		let _ = h.insert("Vpunpcklbw", Mnemonic::Vpunpcklbw);
		let _ = h.insert("Vpunpckldq", Mnemonic::Vpunpckldq);
		let _ = h.insert("Vpunpcklqdq", Mnemonic::Vpunpcklqdq);
		let _ = h.insert("Vpunpcklwd", Mnemonic::Vpunpcklwd);
		let _ = h.insert("Vpxor", Mnemonic::Vpxor);
		let _ = h.insert("Vpxord", Mnemonic::Vpxord);
		let _ = h.insert("Vpxorq", Mnemonic::Vpxorq);
		let _ = h.insert("Vrangepd", Mnemonic::Vrangepd);
		let _ = h.insert("Vrangeps", Mnemonic::Vrangeps);
		let _ = h.insert("Vrangesd", Mnemonic::Vrangesd);
		let _ = h.insert("Vrangess", Mnemonic::Vrangess);
		let _ = h.insert("Vrcp14pd", Mnemonic::Vrcp14pd);
		let _ = h.insert("Vrcp14ps", Mnemonic::Vrcp14ps);
		let _ = h.insert("Vrcp14sd", Mnemonic::Vrcp14sd);
		let _ = h.insert("Vrcp14ss", Mnemonic::Vrcp14ss);
		let _ = h.insert("Vrcp28pd", Mnemonic::Vrcp28pd);
		let _ = h.insert("Vrcp28ps", Mnemonic::Vrcp28ps);
		let _ = h.insert("Vrcp28sd", Mnemonic::Vrcp28sd);
		let _ = h.insert("Vrcp28ss", Mnemonic::Vrcp28ss);
		let _ = h.insert("Vrcpps", Mnemonic::Vrcpps);
		let _ = h.insert("Vrcpss", Mnemonic::Vrcpss);
		let _ = h.insert("Vreducepd", Mnemonic::Vreducepd);
		let _ = h.insert("Vreduceps", Mnemonic::Vreduceps);
		let _ = h.insert("Vreducesd", Mnemonic::Vreducesd);
		let _ = h.insert("Vreducess", Mnemonic::Vreducess);
		let _ = h.insert("Vrndscalepd", Mnemonic::Vrndscalepd);
		let _ = h.insert("Vrndscaleps", Mnemonic::Vrndscaleps);
		let _ = h.insert("Vrndscalesd", Mnemonic::Vrndscalesd);
		let _ = h.insert("Vrndscaless", Mnemonic::Vrndscaless);
		let _ = h.insert("Vroundpd", Mnemonic::Vroundpd);
		let _ = h.insert("Vroundps", Mnemonic::Vroundps);
		let _ = h.insert("Vroundsd", Mnemonic::Vroundsd);
		let _ = h.insert("Vroundss", Mnemonic::Vroundss);
		let _ = h.insert("Vrsqrt14pd", Mnemonic::Vrsqrt14pd);
		let _ = h.insert("Vrsqrt14ps", Mnemonic::Vrsqrt14ps);
		let _ = h.insert("Vrsqrt14sd", Mnemonic::Vrsqrt14sd);
		let _ = h.insert("Vrsqrt14ss", Mnemonic::Vrsqrt14ss);
		let _ = h.insert("Vrsqrt28pd", Mnemonic::Vrsqrt28pd);
		let _ = h.insert("Vrsqrt28ps", Mnemonic::Vrsqrt28ps);
		let _ = h.insert("Vrsqrt28sd", Mnemonic::Vrsqrt28sd);
		let _ = h.insert("Vrsqrt28ss", Mnemonic::Vrsqrt28ss);
		let _ = h.insert("Vrsqrtps", Mnemonic::Vrsqrtps);
		let _ = h.insert("Vrsqrtss", Mnemonic::Vrsqrtss);
		let _ = h.insert("Vscalefpd", Mnemonic::Vscalefpd);
		let _ = h.insert("Vscalefps", Mnemonic::Vscalefps);
		let _ = h.insert("Vscalefsd", Mnemonic::Vscalefsd);
		let _ = h.insert("Vscalefss", Mnemonic::Vscalefss);
		let _ = h.insert("Vscatterdpd", Mnemonic::Vscatterdpd);
		let _ = h.insert("Vscatterdps", Mnemonic::Vscatterdps);
		let _ = h.insert("Vscatterpf0dpd", Mnemonic::Vscatterpf0dpd);
		let _ = h.insert("Vscatterpf0dps", Mnemonic::Vscatterpf0dps);
		let _ = h.insert("Vscatterpf0qpd", Mnemonic::Vscatterpf0qpd);
		let _ = h.insert("Vscatterpf0qps", Mnemonic::Vscatterpf0qps);
		let _ = h.insert("Vscatterpf1dpd", Mnemonic::Vscatterpf1dpd);
		let _ = h.insert("Vscatterpf1dps", Mnemonic::Vscatterpf1dps);
		let _ = h.insert("Vscatterpf1qpd", Mnemonic::Vscatterpf1qpd);
		let _ = h.insert("Vscatterpf1qps", Mnemonic::Vscatterpf1qps);
		let _ = h.insert("Vscatterqpd", Mnemonic::Vscatterqpd);
		let _ = h.insert("Vscatterqps", Mnemonic::Vscatterqps);
		let _ = h.insert("Vshuff32x4", Mnemonic::Vshuff32x4);
		let _ = h.insert("Vshuff64x2", Mnemonic::Vshuff64x2);
		let _ = h.insert("Vshufi32x4", Mnemonic::Vshufi32x4);
		let _ = h.insert("Vshufi64x2", Mnemonic::Vshufi64x2);
		let _ = h.insert("Vshufpd", Mnemonic::Vshufpd);
		let _ = h.insert("Vshufps", Mnemonic::Vshufps);
		let _ = h.insert("Vsqrtpd", Mnemonic::Vsqrtpd);
		let _ = h.insert("Vsqrtps", Mnemonic::Vsqrtps);
		let _ = h.insert("Vsqrtsd", Mnemonic::Vsqrtsd);
		let _ = h.insert("Vsqrtss", Mnemonic::Vsqrtss);
		let _ = h.insert("Vstmxcsr", Mnemonic::Vstmxcsr);
		let _ = h.insert("Vsubpd", Mnemonic::Vsubpd);
		let _ = h.insert("Vsubps", Mnemonic::Vsubps);
		let _ = h.insert("Vsubsd", Mnemonic::Vsubsd);
		let _ = h.insert("Vsubss", Mnemonic::Vsubss);
		let _ = h.insert("Vtestpd", Mnemonic::Vtestpd);
		let _ = h.insert("Vtestps", Mnemonic::Vtestps);
		let _ = h.insert("Vucomisd", Mnemonic::Vucomisd);
		let _ = h.insert("Vucomiss", Mnemonic::Vucomiss);
		let _ = h.insert("Vunpckhpd", Mnemonic::Vunpckhpd);
		let _ = h.insert("Vunpckhps", Mnemonic::Vunpckhps);
		let _ = h.insert("Vunpcklpd", Mnemonic::Vunpcklpd);
		let _ = h.insert("Vunpcklps", Mnemonic::Vunpcklps);
		let _ = h.insert("Vxorpd", Mnemonic::Vxorpd);
		let _ = h.insert("Vxorps", Mnemonic::Vxorps);
		let _ = h.insert("Vzeroall", Mnemonic::Vzeroall);
		let _ = h.insert("Vzeroupper", Mnemonic::Vzeroupper);
		let _ = h.insert("Wait", Mnemonic::Wait);
		let _ = h.insert("Wbinvd", Mnemonic::Wbinvd);
		let _ = h.insert("Wbnoinvd", Mnemonic::Wbnoinvd);
		let _ = h.insert("Wrfsbase", Mnemonic::Wrfsbase);
		let _ = h.insert("Wrgsbase", Mnemonic::Wrgsbase);
		let _ = h.insert("Wrmsr", Mnemonic::Wrmsr);
		let _ = h.insert("Wrpkru", Mnemonic::Wrpkru);
		let _ = h.insert("Wrssd", Mnemonic::Wrssd);
		let _ = h.insert("Wrssq", Mnemonic::Wrssq);
		let _ = h.insert("Wrussd", Mnemonic::Wrussd);
		let _ = h.insert("Wrussq", Mnemonic::Wrussq);
		let _ = h.insert("Xabort", Mnemonic::Xabort);
		let _ = h.insert("Xadd", Mnemonic::Xadd);
		let _ = h.insert("Xbegin", Mnemonic::Xbegin);
		let _ = h.insert("Xbts", Mnemonic::Xbts);
		let _ = h.insert("Xchg", Mnemonic::Xchg);
		let _ = h.insert("Xcryptcbc", Mnemonic::Xcryptcbc);
		let _ = h.insert("Xcryptcfb", Mnemonic::Xcryptcfb);
		let _ = h.insert("Xcryptctr", Mnemonic::Xcryptctr);
		let _ = h.insert("Xcryptecb", Mnemonic::Xcryptecb);
		let _ = h.insert("Xcryptofb", Mnemonic::Xcryptofb);
		let _ = h.insert("Xend", Mnemonic::Xend);
		let _ = h.insert("Xgetbv", Mnemonic::Xgetbv);
		let _ = h.insert("Xlatb", Mnemonic::Xlatb);
		let _ = h.insert("Xor", Mnemonic::Xor);
		let _ = h.insert("Xorpd", Mnemonic::Xorpd);
		let _ = h.insert("Xorps", Mnemonic::Xorps);
		let _ = h.insert("Xrstor", Mnemonic::Xrstor);
		let _ = h.insert("Xrstor64", Mnemonic::Xrstor64);
		let _ = h.insert("Xrstors", Mnemonic::Xrstors);
		let _ = h.insert("Xrstors64", Mnemonic::Xrstors64);
		let _ = h.insert("Xsave", Mnemonic::Xsave);
		let _ = h.insert("Xsave64", Mnemonic::Xsave64);
		let _ = h.insert("Xsavec", Mnemonic::Xsavec);
		let _ = h.insert("Xsavec64", Mnemonic::Xsavec64);
		let _ = h.insert("Xsaveopt", Mnemonic::Xsaveopt);
		let _ = h.insert("Xsaveopt64", Mnemonic::Xsaveopt64);
		let _ = h.insert("Xsaves", Mnemonic::Xsaves);
		let _ = h.insert("Xsaves64", Mnemonic::Xsaves64);
		let _ = h.insert("Xsetbv", Mnemonic::Xsetbv);
		let _ = h.insert("Xsha1", Mnemonic::Xsha1);
		let _ = h.insert("Xsha256", Mnemonic::Xsha256);
		let _ = h.insert("Xstore", Mnemonic::Xstore);
		let _ = h.insert("Xtest", Mnemonic::Xtest);
		let _ = h.insert("Rmpadjust", Mnemonic::Rmpadjust);
		let _ = h.insert("Rmpupdate", Mnemonic::Rmpupdate);
		let _ = h.insert("Psmash", Mnemonic::Psmash);
		let _ = h.insert("Pvalidate", Mnemonic::Pvalidate);
		let _ = h.insert("Serialize", Mnemonic::Serialize);
		let _ = h.insert("Xsusldtrk", Mnemonic::Xsusldtrk);
		let _ = h.insert("Xresldtrk", Mnemonic::Xresldtrk);
		let _ = h.insert("Invlpgb", Mnemonic::Invlpgb);
		let _ = h.insert("Tlbsync", Mnemonic::Tlbsync);
		let _ = h.insert("Vmgexit", Mnemonic::Vmgexit);
		let _ = h.insert("Getsecq", Mnemonic::Getsecq);
		let _ = h.insert("Sysexitq", Mnemonic::Sysexitq);
		let _ = h.insert("Ldtilecfg", Mnemonic::Ldtilecfg);
		let _ = h.insert("Tilerelease", Mnemonic::Tilerelease);
		let _ = h.insert("Sttilecfg", Mnemonic::Sttilecfg);
		let _ = h.insert("Tilezero", Mnemonic::Tilezero);
		let _ = h.insert("Tileloaddt1", Mnemonic::Tileloaddt1);
		let _ = h.insert("Tilestored", Mnemonic::Tilestored);
		let _ = h.insert("Tileloadd", Mnemonic::Tileloadd);
		let _ = h.insert("Tdpbf16ps", Mnemonic::Tdpbf16ps);
		let _ = h.insert("Tdpbuud", Mnemonic::Tdpbuud);
		let _ = h.insert("Tdpbusd", Mnemonic::Tdpbusd);
		let _ = h.insert("Tdpbsud", Mnemonic::Tdpbsud);
		let _ = h.insert("Tdpbssd", Mnemonic::Tdpbssd);
		let _ = h.insert("Sysretq", Mnemonic::Sysretq);
		let _ = h.insert("Fnstdw", Mnemonic::Fnstdw);
		let _ = h.insert("Fnstsg", Mnemonic::Fnstsg);
		let _ = h.insert("Rdshr", Mnemonic::Rdshr);
		let _ = h.insert("Wrshr", Mnemonic::Wrshr);
		let _ = h.insert("Smint", Mnemonic::Smint);
		let _ = h.insert("Dmint", Mnemonic::Dmint);
		let _ = h.insert("Rdm", Mnemonic::Rdm);
		let _ = h.insert("Svdc", Mnemonic::Svdc);
		let _ = h.insert("Rsdc", Mnemonic::Rsdc);
		let _ = h.insert("Svldt", Mnemonic::Svldt);
		let _ = h.insert("Rsldt", Mnemonic::Rsldt);
		let _ = h.insert("Svts", Mnemonic::Svts);
		let _ = h.insert("Rsts", Mnemonic::Rsts);
		let _ = h.insert("Bb0_reset", Mnemonic::Bb0_reset);
		let _ = h.insert("Bb1_reset", Mnemonic::Bb1_reset);
		let _ = h.insert("Cpu_write", Mnemonic::Cpu_write);
		let _ = h.insert("Cpu_read", Mnemonic::Cpu_read);
		let _ = h.insert("Altinst", Mnemonic::Altinst);
		let _ = h.insert("Paveb", Mnemonic::Paveb);
		let _ = h.insert("Paddsiw", Mnemonic::Paddsiw);
		let _ = h.insert("Pmagw", Mnemonic::Pmagw);
		let _ = h.insert("Pdistib", Mnemonic::Pdistib);
		let _ = h.insert("Psubsiw", Mnemonic::Psubsiw);
		let _ = h.insert("Pmvzb", Mnemonic::Pmvzb);
		let _ = h.insert("Pmvnzb", Mnemonic::Pmvnzb);
		let _ = h.insert("Pmvlzb", Mnemonic::Pmvlzb);
		let _ = h.insert("Pmvgezb", Mnemonic::Pmvgezb);
		let _ = h.insert("Pmulhriw", Mnemonic::Pmulhriw);
		let _ = h.insert("Pmachriw", Mnemonic::Pmachriw);
		let _ = h.insert("Ftstp", Mnemonic::Ftstp);
		let _ = h.insert("Frint2", Mnemonic::Frint2);
		let _ = h.insert("Frichop", Mnemonic::Frichop);
		let _ = h.insert("Frinear", Mnemonic::Frinear);
		let _ = h.insert("Undoc", Mnemonic::Undoc);
		let _ = h.insert("Tdcall", Mnemonic::Tdcall);
		let _ = h.insert("Seamret", Mnemonic::Seamret);
		let _ = h.insert("Seamops", Mnemonic::Seamops);
		let _ = h.insert("Seamcall", Mnemonic::Seamcall);
		let _ = h.insert("Aesencwide128kl", Mnemonic::Aesencwide128kl);
		let _ = h.insert("Aesdecwide128kl", Mnemonic::Aesdecwide128kl);
		let _ = h.insert("Aesencwide256kl", Mnemonic::Aesencwide256kl);
		let _ = h.insert("Aesdecwide256kl", Mnemonic::Aesdecwide256kl);
		let _ = h.insert("Loadiwkey", Mnemonic::Loadiwkey);
		let _ = h.insert("Aesenc128kl", Mnemonic::Aesenc128kl);
		let _ = h.insert("Aesdec128kl", Mnemonic::Aesdec128kl);
		let _ = h.insert("Aesenc256kl", Mnemonic::Aesenc256kl);
		let _ = h.insert("Aesdec256kl", Mnemonic::Aesdec256kl);
		let _ = h.insert("Encodekey128", Mnemonic::Encodekey128);
		let _ = h.insert("Encodekey256", Mnemonic::Encodekey256);
		let _ = h.insert("Pushad", Mnemonic::Pushad);
		let _ = h.insert("Popad", Mnemonic::Popad);
		let _ = h.insert("Pushfd", Mnemonic::Pushfd);
		let _ = h.insert("Pushfq", Mnemonic::Pushfq);
		let _ = h.insert("Popfd", Mnemonic::Popfd);
		let _ = h.insert("Popfq", Mnemonic::Popfq);
		let _ = h.insert("Iretd", Mnemonic::Iretd);
		let _ = h.insert("Iretq", Mnemonic::Iretq);
		let _ = h.insert("Int3", Mnemonic::Int3);
		let _ = h.insert("Uiret", Mnemonic::Uiret);
		let _ = h.insert("Testui", Mnemonic::Testui);
		let _ = h.insert("Clui", Mnemonic::Clui);
		let _ = h.insert("Stui", Mnemonic::Stui);
		let _ = h.insert("Senduipi", Mnemonic::Senduipi);
		let _ = h.insert("Hreset", Mnemonic::Hreset);
		let _ = h.insert("Ccs_hash", Mnemonic::Ccs_hash);
		let _ = h.insert("Ccs_encrypt", Mnemonic::Ccs_encrypt);
		let _ = h.insert("Lkgs", Mnemonic::Lkgs);
		let _ = h.insert("Eretu", Mnemonic::Eretu);
		let _ = h.insert("Erets", Mnemonic::Erets);
		// GENERATOR-END: MnemonicHash
		h
	};
}
