// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::FlowControl;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_FLOW_CONTROL_HASH: HashMap<&'static str, FlowControl> = {
		// GENERATOR-BEGIN: FlowControlHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(10);
		let _ = h.insert("Next", FlowControl::Next);
		let _ = h.insert("UnconditionalBranch", FlowControl::UnconditionalBranch);
		let _ = h.insert("IndirectBranch", FlowControl::IndirectBranch);
		let _ = h.insert("ConditionalBranch", FlowControl::ConditionalBranch);
		let _ = h.insert("Return", FlowControl::Return);
		let _ = h.insert("Call", FlowControl::Call);
		let _ = h.insert("IndirectCall", FlowControl::IndirectCall);
		let _ = h.insert("Interrupt", FlowControl::Interrupt);
		let _ = h.insert("XbeginXabortXend", FlowControl::XbeginXabortXend);
		let _ = h.insert("Exception", FlowControl::Exception);
		// GENERATOR-END: FlowControlHash
		h
	};
}
