// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::CpuidFeature;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_CPUID_FEATURE_HASH: HashMap<&'static str, CpuidFeature> = {
		// GENERATOR-BEGIN: CpuidFeatureHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(158);
		let _ = h.insert("INTEL8086", CpuidFeature::INTEL8086);
		let _ = h.insert("INTEL8086_ONLY", CpuidFeature::INTEL8086_ONLY);
		let _ = h.insert("INTEL186", CpuidFeature::INTEL186);
		let _ = h.insert("INTEL286", CpuidFeature::INTEL286);
		let _ = h.insert("INTEL286_ONLY", CpuidFeature::INTEL286_ONLY);
		let _ = h.insert("INTEL386", CpuidFeature::INTEL386);
		let _ = h.insert("INTEL386_ONLY", CpuidFeature::INTEL386_ONLY);
		let _ = h.insert("INTEL386_A0_ONLY", CpuidFeature::INTEL386_A0_ONLY);
		let _ = h.insert("INTEL486", CpuidFeature::INTEL486);
		let _ = h.insert("INTEL486_A_ONLY", CpuidFeature::INTEL486_A_ONLY);
		let _ = h.insert("UMOV", CpuidFeature::UMOV);
		let _ = h.insert("IA64", CpuidFeature::IA64);
		let _ = h.insert("X64", CpuidFeature::X64);
		let _ = h.insert("ADX", CpuidFeature::ADX);
		let _ = h.insert("AES", CpuidFeature::AES);
		let _ = h.insert("AVX", CpuidFeature::AVX);
		let _ = h.insert("AVX2", CpuidFeature::AVX2);
		let _ = h.insert("AVX512_4FMAPS", CpuidFeature::AVX512_4FMAPS);
		let _ = h.insert("AVX512_4VNNIW", CpuidFeature::AVX512_4VNNIW);
		let _ = h.insert("AVX512_BF16", CpuidFeature::AVX512_BF16);
		let _ = h.insert("AVX512_BITALG", CpuidFeature::AVX512_BITALG);
		let _ = h.insert("AVX512_IFMA", CpuidFeature::AVX512_IFMA);
		let _ = h.insert("AVX512_VBMI", CpuidFeature::AVX512_VBMI);
		let _ = h.insert("AVX512_VBMI2", CpuidFeature::AVX512_VBMI2);
		let _ = h.insert("AVX512_VNNI", CpuidFeature::AVX512_VNNI);
		let _ = h.insert("AVX512_VP2INTERSECT", CpuidFeature::AVX512_VP2INTERSECT);
		let _ = h.insert("AVX512_VPOPCNTDQ", CpuidFeature::AVX512_VPOPCNTDQ);
		let _ = h.insert("AVX512BW", CpuidFeature::AVX512BW);
		let _ = h.insert("AVX512CD", CpuidFeature::AVX512CD);
		let _ = h.insert("AVX512DQ", CpuidFeature::AVX512DQ);
		let _ = h.insert("AVX512ER", CpuidFeature::AVX512ER);
		let _ = h.insert("AVX512F", CpuidFeature::AVX512F);
		let _ = h.insert("AVX512PF", CpuidFeature::AVX512PF);
		let _ = h.insert("AVX512VL", CpuidFeature::AVX512VL);
		let _ = h.insert("BMI1", CpuidFeature::BMI1);
		let _ = h.insert("BMI2", CpuidFeature::BMI2);
		let _ = h.insert("CET_IBT", CpuidFeature::CET_IBT);
		let _ = h.insert("CET_SS", CpuidFeature::CET_SS);
		let _ = h.insert("CL1INVMB", CpuidFeature::CL1INVMB);
		let _ = h.insert("CLDEMOTE", CpuidFeature::CLDEMOTE);
		let _ = h.insert("CLFLUSHOPT", CpuidFeature::CLFLUSHOPT);
		let _ = h.insert("CLFSH", CpuidFeature::CLFSH);
		let _ = h.insert("CLWB", CpuidFeature::CLWB);
		let _ = h.insert("CLZERO", CpuidFeature::CLZERO);
		let _ = h.insert("CMOV", CpuidFeature::CMOV);
		let _ = h.insert("CMPXCHG16B", CpuidFeature::CMPXCHG16B);
		let _ = h.insert("CPUID", CpuidFeature::CPUID);
		let _ = h.insert("CX8", CpuidFeature::CX8);
		let _ = h.insert("D3NOW", CpuidFeature::D3NOW);
		let _ = h.insert("D3NOWEXT", CpuidFeature::D3NOWEXT);
		let _ = h.insert("OSS", CpuidFeature::OSS);
		let _ = h.insert("ENQCMD", CpuidFeature::ENQCMD);
		let _ = h.insert("F16C", CpuidFeature::F16C);
		let _ = h.insert("FMA", CpuidFeature::FMA);
		let _ = h.insert("FMA4", CpuidFeature::FMA4);
		let _ = h.insert("FPU", CpuidFeature::FPU);
		let _ = h.insert("FPU287", CpuidFeature::FPU287);
		let _ = h.insert("FPU287XL_ONLY", CpuidFeature::FPU287XL_ONLY);
		let _ = h.insert("FPU387", CpuidFeature::FPU387);
		let _ = h.insert("FPU387SL_ONLY", CpuidFeature::FPU387SL_ONLY);
		let _ = h.insert("FSGSBASE", CpuidFeature::FSGSBASE);
		let _ = h.insert("FXSR", CpuidFeature::FXSR);
		let _ = h.insert("CYRIX_D3NOW", CpuidFeature::CYRIX_D3NOW);
		let _ = h.insert("GFNI", CpuidFeature::GFNI);
		let _ = h.insert("HLE", CpuidFeature::HLE);
		let _ = h.insert("HLE_or_RTM", CpuidFeature::HLE_or_RTM);
		let _ = h.insert("INVEPT", CpuidFeature::INVEPT);
		let _ = h.insert("INVPCID", CpuidFeature::INVPCID);
		let _ = h.insert("INVVPID", CpuidFeature::INVVPID);
		let _ = h.insert("LWP", CpuidFeature::LWP);
		let _ = h.insert("LZCNT", CpuidFeature::LZCNT);
		let _ = h.insert("MCOMMIT", CpuidFeature::MCOMMIT);
		let _ = h.insert("MMX", CpuidFeature::MMX);
		let _ = h.insert("MONITOR", CpuidFeature::MONITOR);
		let _ = h.insert("MONITORX", CpuidFeature::MONITORX);
		let _ = h.insert("MOVBE", CpuidFeature::MOVBE);
		let _ = h.insert("MOVDIR64B", CpuidFeature::MOVDIR64B);
		let _ = h.insert("MOVDIRI", CpuidFeature::MOVDIRI);
		let _ = h.insert("MPX", CpuidFeature::MPX);
		let _ = h.insert("MSR", CpuidFeature::MSR);
		let _ = h.insert("MULTIBYTENOP", CpuidFeature::MULTIBYTENOP);
		let _ = h.insert("PADLOCK_ACE", CpuidFeature::PADLOCK_ACE);
		let _ = h.insert("PADLOCK_PHE", CpuidFeature::PADLOCK_PHE);
		let _ = h.insert("PADLOCK_PMM", CpuidFeature::PADLOCK_PMM);
		let _ = h.insert("PADLOCK_RNG", CpuidFeature::PADLOCK_RNG);
		let _ = h.insert("PAUSE", CpuidFeature::PAUSE);
		let _ = h.insert("PCLMULQDQ", CpuidFeature::PCLMULQDQ);
		let _ = h.insert("PCOMMIT", CpuidFeature::PCOMMIT);
		let _ = h.insert("PCONFIG", CpuidFeature::PCONFIG);
		let _ = h.insert("PKU", CpuidFeature::PKU);
		let _ = h.insert("POPCNT", CpuidFeature::POPCNT);
		let _ = h.insert("PREFETCHW", CpuidFeature::PREFETCHW);
		let _ = h.insert("PREFETCHWT1", CpuidFeature::PREFETCHWT1);
		let _ = h.insert("PTWRITE", CpuidFeature::PTWRITE);
		let _ = h.insert("RDPID", CpuidFeature::RDPID);
		let _ = h.insert("RDPMC", CpuidFeature::RDPMC);
		let _ = h.insert("RDPRU", CpuidFeature::RDPRU);
		let _ = h.insert("RDRAND", CpuidFeature::RDRAND);
		let _ = h.insert("RDSEED", CpuidFeature::RDSEED);
		let _ = h.insert("RDTSCP", CpuidFeature::RDTSCP);
		let _ = h.insert("RTM", CpuidFeature::RTM);
		let _ = h.insert("SEP", CpuidFeature::SEP);
		let _ = h.insert("SGX1", CpuidFeature::SGX1);
		let _ = h.insert("SHA", CpuidFeature::SHA);
		let _ = h.insert("SKINIT", CpuidFeature::SKINIT);
		let _ = h.insert("SKINIT_or_SVM", CpuidFeature::SKINIT_or_SVM);
		let _ = h.insert("SMAP", CpuidFeature::SMAP);
		let _ = h.insert("SMX", CpuidFeature::SMX);
		let _ = h.insert("SSE", CpuidFeature::SSE);
		let _ = h.insert("SSE2", CpuidFeature::SSE2);
		let _ = h.insert("SSE3", CpuidFeature::SSE3);
		let _ = h.insert("SSE4_1", CpuidFeature::SSE4_1);
		let _ = h.insert("SSE4_2", CpuidFeature::SSE4_2);
		let _ = h.insert("SSE4A", CpuidFeature::SSE4A);
		let _ = h.insert("SSSE3", CpuidFeature::SSSE3);
		let _ = h.insert("SVM", CpuidFeature::SVM);
		let _ = h.insert("SEV_ES", CpuidFeature::SEV_ES);
		let _ = h.insert("SYSCALL", CpuidFeature::SYSCALL);
		let _ = h.insert("TBM", CpuidFeature::TBM);
		let _ = h.insert("TSC", CpuidFeature::TSC);
		let _ = h.insert("VAES", CpuidFeature::VAES);
		let _ = h.insert("VMX", CpuidFeature::VMX);
		let _ = h.insert("VPCLMULQDQ", CpuidFeature::VPCLMULQDQ);
		let _ = h.insert("WAITPKG", CpuidFeature::WAITPKG);
		let _ = h.insert("WBNOINVD", CpuidFeature::WBNOINVD);
		let _ = h.insert("XOP", CpuidFeature::XOP);
		let _ = h.insert("XSAVE", CpuidFeature::XSAVE);
		let _ = h.insert("XSAVEC", CpuidFeature::XSAVEC);
		let _ = h.insert("XSAVEOPT", CpuidFeature::XSAVEOPT);
		let _ = h.insert("XSAVES", CpuidFeature::XSAVES);
		let _ = h.insert("SEV_SNP", CpuidFeature::SEV_SNP);
		let _ = h.insert("SERIALIZE", CpuidFeature::SERIALIZE);
		let _ = h.insert("TSXLDTRK", CpuidFeature::TSXLDTRK);
		let _ = h.insert("INVLPGB", CpuidFeature::INVLPGB);
		let _ = h.insert("AMX_BF16", CpuidFeature::AMX_BF16);
		let _ = h.insert("AMX_TILE", CpuidFeature::AMX_TILE);
		let _ = h.insert("AMX_INT8", CpuidFeature::AMX_INT8);
		let _ = h.insert("CYRIX_FPU", CpuidFeature::CYRIX_FPU);
		let _ = h.insert("CYRIX_SMM", CpuidFeature::CYRIX_SMM);
		let _ = h.insert("CYRIX_SMINT", CpuidFeature::CYRIX_SMINT);
		let _ = h.insert("CYRIX_SMINT_0F7E", CpuidFeature::CYRIX_SMINT_0F7E);
		let _ = h.insert("CYRIX_SHR", CpuidFeature::CYRIX_SHR);
		let _ = h.insert("CYRIX_DDI", CpuidFeature::CYRIX_DDI);
		let _ = h.insert("CYRIX_EMMI", CpuidFeature::CYRIX_EMMI);
		let _ = h.insert("CYRIX_DMI", CpuidFeature::CYRIX_DMI);
		let _ = h.insert("CENTAUR_AIS", CpuidFeature::CENTAUR_AIS);
		let _ = h.insert("MOV_TR", CpuidFeature::MOV_TR);
		let _ = h.insert("SMM", CpuidFeature::SMM);
		let _ = h.insert("TDX", CpuidFeature::TDX);
		let _ = h.insert("KL", CpuidFeature::KL);
		let _ = h.insert("AESKLE", CpuidFeature::AESKLE);
		let _ = h.insert("WIDE_KL", CpuidFeature::WIDE_KL);
		let _ = h.insert("UINTR", CpuidFeature::UINTR);
		let _ = h.insert("HRESET", CpuidFeature::HRESET);
		let _ = h.insert("AVX_VNNI", CpuidFeature::AVX_VNNI);
		let _ = h.insert("PADLOCK_GMI", CpuidFeature::PADLOCK_GMI);
		let _ = h.insert("FRED", CpuidFeature::FRED);
		let _ = h.insert("LKGS", CpuidFeature::LKGS);
		// GENERATOR-END: CpuidFeatureHash
		h
	};
}
