// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::ConditionCode;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_CONDITION_CODE_HASH: HashMap<&'static str, ConditionCode> = {
		// GENERATOR-BEGIN: ConditionCodeHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(17);
		let _ = h.insert("None", ConditionCode::None);
		let _ = h.insert("o", ConditionCode::o);
		let _ = h.insert("no", ConditionCode::no);
		let _ = h.insert("b", ConditionCode::b);
		let _ = h.insert("ae", ConditionCode::ae);
		let _ = h.insert("e", ConditionCode::e);
		let _ = h.insert("ne", ConditionCode::ne);
		let _ = h.insert("be", ConditionCode::be);
		let _ = h.insert("a", ConditionCode::a);
		let _ = h.insert("s", ConditionCode::s);
		let _ = h.insert("ns", ConditionCode::ns);
		let _ = h.insert("p", ConditionCode::p);
		let _ = h.insert("np", ConditionCode::np);
		let _ = h.insert("l", ConditionCode::l);
		let _ = h.insert("ge", ConditionCode::ge);
		let _ = h.insert("le", ConditionCode::le);
		let _ = h.insert("g", ConditionCode::g);
		// GENERATOR-END: ConditionCodeHash
		h
	};
}
