// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::TupleType;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_TUPLE_TYPE_HASH: HashMap<&'static str, TupleType> = {
		// GENERATOR-BEGIN: TupleTypeHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(14);
		let _ = h.insert("N1", TupleType::N1);
		let _ = h.insert("N2", TupleType::N2);
		let _ = h.insert("N4", TupleType::N4);
		let _ = h.insert("N8", TupleType::N8);
		let _ = h.insert("N16", TupleType::N16);
		let _ = h.insert("N32", TupleType::N32);
		let _ = h.insert("N64", TupleType::N64);
		let _ = h.insert("N8b4", TupleType::N8b4);
		let _ = h.insert("N16b4", TupleType::N16b4);
		let _ = h.insert("N32b4", TupleType::N32b4);
		let _ = h.insert("N64b4", TupleType::N64b4);
		let _ = h.insert("N16b8", TupleType::N16b8);
		let _ = h.insert("N32b8", TupleType::N32b8);
		let _ = h.insert("N64b8", TupleType::N64b8);
		// GENERATOR-END: TupleTypeHash
		h
	};
}
