// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::DecoderOptions;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_DECODER_OPTIONS_HASH: HashMap<&'static str, u32> = {
		// GENERATOR-BEGIN: DecoderOptionsHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(25);
		let _ = h.insert("None", DecoderOptions::NONE);
		let _ = h.insert("NoInvalidCheck", DecoderOptions::NO_INVALID_CHECK);
		let _ = h.insert("AMD", DecoderOptions::AMD);
		let _ = h.insert("ForceReservedNop", DecoderOptions::FORCE_RESERVED_NOP);
		let _ = h.insert("Umov", DecoderOptions::UMOV);
		let _ = h.insert("Xbts", DecoderOptions::XBTS);
		let _ = h.insert("Cmpxchg486A", DecoderOptions::CMPXCHG486A);
		let _ = h.insert("OldFpu", DecoderOptions::OLD_FPU);
		let _ = h.insert("Pcommit", DecoderOptions::PCOMMIT);
		let _ = h.insert("Loadall286", DecoderOptions::LOADALL286);
		let _ = h.insert("Loadall386", DecoderOptions::LOADALL386);
		let _ = h.insert("Cl1invmb", DecoderOptions::CL1INVMB);
		let _ = h.insert("MovTr", DecoderOptions::MOV_TR);
		let _ = h.insert("Jmpe", DecoderOptions::JMPE);
		let _ = h.insert("NoPause", DecoderOptions::NO_PAUSE);
		let _ = h.insert("NoWbnoinvd", DecoderOptions::NO_WBNOINVD);
		let _ = h.insert("NoMPFX_0FBC", DecoderOptions::NO_MPFX_0FBC);
		let _ = h.insert("NoMPFX_0FBD", DecoderOptions::NO_MPFX_0FBD);
		let _ = h.insert("NoLahfSahf64", DecoderOptions::NO_LAHF_SAHF_64);
		let _ = h.insert("MPX", DecoderOptions::MPX);
		let _ = h.insert("Cyrix", DecoderOptions::CYRIX);
		let _ = h.insert("Cyrix_SMINT_0F7E", DecoderOptions::CYRIX_SMINT_0F7E);
		let _ = h.insert("Cyrix_DMI", DecoderOptions::CYRIX_DMI);
		let _ = h.insert("ALTINST", DecoderOptions::ALTINST);
		// GENERATOR-END: DecoderOptionsHash
		h
	};
}
