// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::Code;
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
	pub(super) static ref TO_CODE_HASH: HashMap<&'static str, Code> = {
		// GENERATOR-BEGIN: CodeHash
		// ⚠️This was generated by GENERATOR!🦹‍♂️
		let mut h = HashMap::with_capacity(4323);
		let _ = h.insert("INVALID", Code::INVALID);
		let _ = h.insert("DeclareByte", Code::DeclareByte);
		let _ = h.insert("DeclareWord", Code::DeclareWord);
		let _ = h.insert("DeclareDword", Code::DeclareDword);
		let _ = h.insert("DeclareQword", Code::DeclareQword);
		let _ = h.insert("Add_rm8_r8", Code::Add_rm8_r8);
		let _ = h.insert("Add_rm16_r16", Code::Add_rm16_r16);
		let _ = h.insert("Add_rm32_r32", Code::Add_rm32_r32);
		let _ = h.insert("Add_rm64_r64", Code::Add_rm64_r64);
		let _ = h.insert("Add_r8_rm8", Code::Add_r8_rm8);
		let _ = h.insert("Add_r16_rm16", Code::Add_r16_rm16);
		let _ = h.insert("Add_r32_rm32", Code::Add_r32_rm32);
		let _ = h.insert("Add_r64_rm64", Code::Add_r64_rm64);
		let _ = h.insert("Add_AL_imm8", Code::Add_AL_imm8);
		let _ = h.insert("Add_AX_imm16", Code::Add_AX_imm16);
		let _ = h.insert("Add_EAX_imm32", Code::Add_EAX_imm32);
		let _ = h.insert("Add_RAX_imm32", Code::Add_RAX_imm32);
		let _ = h.insert("Pushw_ES", Code::Pushw_ES);
		let _ = h.insert("Pushd_ES", Code::Pushd_ES);
		let _ = h.insert("Popw_ES", Code::Popw_ES);
		let _ = h.insert("Popd_ES", Code::Popd_ES);
		let _ = h.insert("Or_rm8_r8", Code::Or_rm8_r8);
		let _ = h.insert("Or_rm16_r16", Code::Or_rm16_r16);
		let _ = h.insert("Or_rm32_r32", Code::Or_rm32_r32);
		let _ = h.insert("Or_rm64_r64", Code::Or_rm64_r64);
		let _ = h.insert("Or_r8_rm8", Code::Or_r8_rm8);
		let _ = h.insert("Or_r16_rm16", Code::Or_r16_rm16);
		let _ = h.insert("Or_r32_rm32", Code::Or_r32_rm32);
		let _ = h.insert("Or_r64_rm64", Code::Or_r64_rm64);
		let _ = h.insert("Or_AL_imm8", Code::Or_AL_imm8);
		let _ = h.insert("Or_AX_imm16", Code::Or_AX_imm16);
		let _ = h.insert("Or_EAX_imm32", Code::Or_EAX_imm32);
		let _ = h.insert("Or_RAX_imm32", Code::Or_RAX_imm32);
		let _ = h.insert("Pushw_CS", Code::Pushw_CS);
		let _ = h.insert("Pushd_CS", Code::Pushd_CS);
		let _ = h.insert("Popw_CS", Code::Popw_CS);
		let _ = h.insert("Adc_rm8_r8", Code::Adc_rm8_r8);
		let _ = h.insert("Adc_rm16_r16", Code::Adc_rm16_r16);
		let _ = h.insert("Adc_rm32_r32", Code::Adc_rm32_r32);
		let _ = h.insert("Adc_rm64_r64", Code::Adc_rm64_r64);
		let _ = h.insert("Adc_r8_rm8", Code::Adc_r8_rm8);
		let _ = h.insert("Adc_r16_rm16", Code::Adc_r16_rm16);
		let _ = h.insert("Adc_r32_rm32", Code::Adc_r32_rm32);
		let _ = h.insert("Adc_r64_rm64", Code::Adc_r64_rm64);
		let _ = h.insert("Adc_AL_imm8", Code::Adc_AL_imm8);
		let _ = h.insert("Adc_AX_imm16", Code::Adc_AX_imm16);
		let _ = h.insert("Adc_EAX_imm32", Code::Adc_EAX_imm32);
		let _ = h.insert("Adc_RAX_imm32", Code::Adc_RAX_imm32);
		let _ = h.insert("Pushw_SS", Code::Pushw_SS);
		let _ = h.insert("Pushd_SS", Code::Pushd_SS);
		let _ = h.insert("Popw_SS", Code::Popw_SS);
		let _ = h.insert("Popd_SS", Code::Popd_SS);
		let _ = h.insert("Sbb_rm8_r8", Code::Sbb_rm8_r8);
		let _ = h.insert("Sbb_rm16_r16", Code::Sbb_rm16_r16);
		let _ = h.insert("Sbb_rm32_r32", Code::Sbb_rm32_r32);
		let _ = h.insert("Sbb_rm64_r64", Code::Sbb_rm64_r64);
		let _ = h.insert("Sbb_r8_rm8", Code::Sbb_r8_rm8);
		let _ = h.insert("Sbb_r16_rm16", Code::Sbb_r16_rm16);
		let _ = h.insert("Sbb_r32_rm32", Code::Sbb_r32_rm32);
		let _ = h.insert("Sbb_r64_rm64", Code::Sbb_r64_rm64);
		let _ = h.insert("Sbb_AL_imm8", Code::Sbb_AL_imm8);
		let _ = h.insert("Sbb_AX_imm16", Code::Sbb_AX_imm16);
		let _ = h.insert("Sbb_EAX_imm32", Code::Sbb_EAX_imm32);
		let _ = h.insert("Sbb_RAX_imm32", Code::Sbb_RAX_imm32);
		let _ = h.insert("Pushw_DS", Code::Pushw_DS);
		let _ = h.insert("Pushd_DS", Code::Pushd_DS);
		let _ = h.insert("Popw_DS", Code::Popw_DS);
		let _ = h.insert("Popd_DS", Code::Popd_DS);
		let _ = h.insert("And_rm8_r8", Code::And_rm8_r8);
		let _ = h.insert("And_rm16_r16", Code::And_rm16_r16);
		let _ = h.insert("And_rm32_r32", Code::And_rm32_r32);
		let _ = h.insert("And_rm64_r64", Code::And_rm64_r64);
		let _ = h.insert("And_r8_rm8", Code::And_r8_rm8);
		let _ = h.insert("And_r16_rm16", Code::And_r16_rm16);
		let _ = h.insert("And_r32_rm32", Code::And_r32_rm32);
		let _ = h.insert("And_r64_rm64", Code::And_r64_rm64);
		let _ = h.insert("And_AL_imm8", Code::And_AL_imm8);
		let _ = h.insert("And_AX_imm16", Code::And_AX_imm16);
		let _ = h.insert("And_EAX_imm32", Code::And_EAX_imm32);
		let _ = h.insert("And_RAX_imm32", Code::And_RAX_imm32);
		let _ = h.insert("Daa", Code::Daa);
		let _ = h.insert("Sub_rm8_r8", Code::Sub_rm8_r8);
		let _ = h.insert("Sub_rm16_r16", Code::Sub_rm16_r16);
		let _ = h.insert("Sub_rm32_r32", Code::Sub_rm32_r32);
		let _ = h.insert("Sub_rm64_r64", Code::Sub_rm64_r64);
		let _ = h.insert("Sub_r8_rm8", Code::Sub_r8_rm8);
		let _ = h.insert("Sub_r16_rm16", Code::Sub_r16_rm16);
		let _ = h.insert("Sub_r32_rm32", Code::Sub_r32_rm32);
		let _ = h.insert("Sub_r64_rm64", Code::Sub_r64_rm64);
		let _ = h.insert("Sub_AL_imm8", Code::Sub_AL_imm8);
		let _ = h.insert("Sub_AX_imm16", Code::Sub_AX_imm16);
		let _ = h.insert("Sub_EAX_imm32", Code::Sub_EAX_imm32);
		let _ = h.insert("Sub_RAX_imm32", Code::Sub_RAX_imm32);
		let _ = h.insert("Das", Code::Das);
		let _ = h.insert("Xor_rm8_r8", Code::Xor_rm8_r8);
		let _ = h.insert("Xor_rm16_r16", Code::Xor_rm16_r16);
		let _ = h.insert("Xor_rm32_r32", Code::Xor_rm32_r32);
		let _ = h.insert("Xor_rm64_r64", Code::Xor_rm64_r64);
		let _ = h.insert("Xor_r8_rm8", Code::Xor_r8_rm8);
		let _ = h.insert("Xor_r16_rm16", Code::Xor_r16_rm16);
		let _ = h.insert("Xor_r32_rm32", Code::Xor_r32_rm32);
		let _ = h.insert("Xor_r64_rm64", Code::Xor_r64_rm64);
		let _ = h.insert("Xor_AL_imm8", Code::Xor_AL_imm8);
		let _ = h.insert("Xor_AX_imm16", Code::Xor_AX_imm16);
		let _ = h.insert("Xor_EAX_imm32", Code::Xor_EAX_imm32);
		let _ = h.insert("Xor_RAX_imm32", Code::Xor_RAX_imm32);
		let _ = h.insert("Aaa", Code::Aaa);
		let _ = h.insert("Cmp_rm8_r8", Code::Cmp_rm8_r8);
		let _ = h.insert("Cmp_rm16_r16", Code::Cmp_rm16_r16);
		let _ = h.insert("Cmp_rm32_r32", Code::Cmp_rm32_r32);
		let _ = h.insert("Cmp_rm64_r64", Code::Cmp_rm64_r64);
		let _ = h.insert("Cmp_r8_rm8", Code::Cmp_r8_rm8);
		let _ = h.insert("Cmp_r16_rm16", Code::Cmp_r16_rm16);
		let _ = h.insert("Cmp_r32_rm32", Code::Cmp_r32_rm32);
		let _ = h.insert("Cmp_r64_rm64", Code::Cmp_r64_rm64);
		let _ = h.insert("Cmp_AL_imm8", Code::Cmp_AL_imm8);
		let _ = h.insert("Cmp_AX_imm16", Code::Cmp_AX_imm16);
		let _ = h.insert("Cmp_EAX_imm32", Code::Cmp_EAX_imm32);
		let _ = h.insert("Cmp_RAX_imm32", Code::Cmp_RAX_imm32);
		let _ = h.insert("Aas", Code::Aas);
		let _ = h.insert("Inc_r16", Code::Inc_r16);
		let _ = h.insert("Inc_r32", Code::Inc_r32);
		let _ = h.insert("Dec_r16", Code::Dec_r16);
		let _ = h.insert("Dec_r32", Code::Dec_r32);
		let _ = h.insert("Push_r16", Code::Push_r16);
		let _ = h.insert("Push_r32", Code::Push_r32);
		let _ = h.insert("Push_r64", Code::Push_r64);
		let _ = h.insert("Pop_r16", Code::Pop_r16);
		let _ = h.insert("Pop_r32", Code::Pop_r32);
		let _ = h.insert("Pop_r64", Code::Pop_r64);
		let _ = h.insert("Pushaw", Code::Pushaw);
		let _ = h.insert("Pushad", Code::Pushad);
		let _ = h.insert("Popaw", Code::Popaw);
		let _ = h.insert("Popad", Code::Popad);
		let _ = h.insert("Bound_r16_m1616", Code::Bound_r16_m1616);
		let _ = h.insert("Bound_r32_m3232", Code::Bound_r32_m3232);
		let _ = h.insert("Arpl_rm16_r16", Code::Arpl_rm16_r16);
		let _ = h.insert("Arpl_r32m16_r32", Code::Arpl_r32m16_r32);
		let _ = h.insert("Movsxd_r16_rm16", Code::Movsxd_r16_rm16);
		let _ = h.insert("Movsxd_r32_rm32", Code::Movsxd_r32_rm32);
		let _ = h.insert("Movsxd_r64_rm32", Code::Movsxd_r64_rm32);
		let _ = h.insert("Push_imm16", Code::Push_imm16);
		let _ = h.insert("Pushd_imm32", Code::Pushd_imm32);
		let _ = h.insert("Pushq_imm32", Code::Pushq_imm32);
		let _ = h.insert("Imul_r16_rm16_imm16", Code::Imul_r16_rm16_imm16);
		let _ = h.insert("Imul_r32_rm32_imm32", Code::Imul_r32_rm32_imm32);
		let _ = h.insert("Imul_r64_rm64_imm32", Code::Imul_r64_rm64_imm32);
		let _ = h.insert("Pushw_imm8", Code::Pushw_imm8);
		let _ = h.insert("Pushd_imm8", Code::Pushd_imm8);
		let _ = h.insert("Pushq_imm8", Code::Pushq_imm8);
		let _ = h.insert("Imul_r16_rm16_imm8", Code::Imul_r16_rm16_imm8);
		let _ = h.insert("Imul_r32_rm32_imm8", Code::Imul_r32_rm32_imm8);
		let _ = h.insert("Imul_r64_rm64_imm8", Code::Imul_r64_rm64_imm8);
		let _ = h.insert("Insb_m8_DX", Code::Insb_m8_DX);
		let _ = h.insert("Insw_m16_DX", Code::Insw_m16_DX);
		let _ = h.insert("Insd_m32_DX", Code::Insd_m32_DX);
		let _ = h.insert("Outsb_DX_m8", Code::Outsb_DX_m8);
		let _ = h.insert("Outsw_DX_m16", Code::Outsw_DX_m16);
		let _ = h.insert("Outsd_DX_m32", Code::Outsd_DX_m32);
		let _ = h.insert("Jo_rel8_16", Code::Jo_rel8_16);
		let _ = h.insert("Jo_rel8_32", Code::Jo_rel8_32);
		let _ = h.insert("Jo_rel8_64", Code::Jo_rel8_64);
		let _ = h.insert("Jno_rel8_16", Code::Jno_rel8_16);
		let _ = h.insert("Jno_rel8_32", Code::Jno_rel8_32);
		let _ = h.insert("Jno_rel8_64", Code::Jno_rel8_64);
		let _ = h.insert("Jb_rel8_16", Code::Jb_rel8_16);
		let _ = h.insert("Jb_rel8_32", Code::Jb_rel8_32);
		let _ = h.insert("Jb_rel8_64", Code::Jb_rel8_64);
		let _ = h.insert("Jae_rel8_16", Code::Jae_rel8_16);
		let _ = h.insert("Jae_rel8_32", Code::Jae_rel8_32);
		let _ = h.insert("Jae_rel8_64", Code::Jae_rel8_64);
		let _ = h.insert("Je_rel8_16", Code::Je_rel8_16);
		let _ = h.insert("Je_rel8_32", Code::Je_rel8_32);
		let _ = h.insert("Je_rel8_64", Code::Je_rel8_64);
		let _ = h.insert("Jne_rel8_16", Code::Jne_rel8_16);
		let _ = h.insert("Jne_rel8_32", Code::Jne_rel8_32);
		let _ = h.insert("Jne_rel8_64", Code::Jne_rel8_64);
		let _ = h.insert("Jbe_rel8_16", Code::Jbe_rel8_16);
		let _ = h.insert("Jbe_rel8_32", Code::Jbe_rel8_32);
		let _ = h.insert("Jbe_rel8_64", Code::Jbe_rel8_64);
		let _ = h.insert("Ja_rel8_16", Code::Ja_rel8_16);
		let _ = h.insert("Ja_rel8_32", Code::Ja_rel8_32);
		let _ = h.insert("Ja_rel8_64", Code::Ja_rel8_64);
		let _ = h.insert("Js_rel8_16", Code::Js_rel8_16);
		let _ = h.insert("Js_rel8_32", Code::Js_rel8_32);
		let _ = h.insert("Js_rel8_64", Code::Js_rel8_64);
		let _ = h.insert("Jns_rel8_16", Code::Jns_rel8_16);
		let _ = h.insert("Jns_rel8_32", Code::Jns_rel8_32);
		let _ = h.insert("Jns_rel8_64", Code::Jns_rel8_64);
		let _ = h.insert("Jp_rel8_16", Code::Jp_rel8_16);
		let _ = h.insert("Jp_rel8_32", Code::Jp_rel8_32);
		let _ = h.insert("Jp_rel8_64", Code::Jp_rel8_64);
		let _ = h.insert("Jnp_rel8_16", Code::Jnp_rel8_16);
		let _ = h.insert("Jnp_rel8_32", Code::Jnp_rel8_32);
		let _ = h.insert("Jnp_rel8_64", Code::Jnp_rel8_64);
		let _ = h.insert("Jl_rel8_16", Code::Jl_rel8_16);
		let _ = h.insert("Jl_rel8_32", Code::Jl_rel8_32);
		let _ = h.insert("Jl_rel8_64", Code::Jl_rel8_64);
		let _ = h.insert("Jge_rel8_16", Code::Jge_rel8_16);
		let _ = h.insert("Jge_rel8_32", Code::Jge_rel8_32);
		let _ = h.insert("Jge_rel8_64", Code::Jge_rel8_64);
		let _ = h.insert("Jle_rel8_16", Code::Jle_rel8_16);
		let _ = h.insert("Jle_rel8_32", Code::Jle_rel8_32);
		let _ = h.insert("Jle_rel8_64", Code::Jle_rel8_64);
		let _ = h.insert("Jg_rel8_16", Code::Jg_rel8_16);
		let _ = h.insert("Jg_rel8_32", Code::Jg_rel8_32);
		let _ = h.insert("Jg_rel8_64", Code::Jg_rel8_64);
		let _ = h.insert("Add_rm8_imm8", Code::Add_rm8_imm8);
		let _ = h.insert("Or_rm8_imm8", Code::Or_rm8_imm8);
		let _ = h.insert("Adc_rm8_imm8", Code::Adc_rm8_imm8);
		let _ = h.insert("Sbb_rm8_imm8", Code::Sbb_rm8_imm8);
		let _ = h.insert("And_rm8_imm8", Code::And_rm8_imm8);
		let _ = h.insert("Sub_rm8_imm8", Code::Sub_rm8_imm8);
		let _ = h.insert("Xor_rm8_imm8", Code::Xor_rm8_imm8);
		let _ = h.insert("Cmp_rm8_imm8", Code::Cmp_rm8_imm8);
		let _ = h.insert("Add_rm16_imm16", Code::Add_rm16_imm16);
		let _ = h.insert("Add_rm32_imm32", Code::Add_rm32_imm32);
		let _ = h.insert("Add_rm64_imm32", Code::Add_rm64_imm32);
		let _ = h.insert("Or_rm16_imm16", Code::Or_rm16_imm16);
		let _ = h.insert("Or_rm32_imm32", Code::Or_rm32_imm32);
		let _ = h.insert("Or_rm64_imm32", Code::Or_rm64_imm32);
		let _ = h.insert("Adc_rm16_imm16", Code::Adc_rm16_imm16);
		let _ = h.insert("Adc_rm32_imm32", Code::Adc_rm32_imm32);
		let _ = h.insert("Adc_rm64_imm32", Code::Adc_rm64_imm32);
		let _ = h.insert("Sbb_rm16_imm16", Code::Sbb_rm16_imm16);
		let _ = h.insert("Sbb_rm32_imm32", Code::Sbb_rm32_imm32);
		let _ = h.insert("Sbb_rm64_imm32", Code::Sbb_rm64_imm32);
		let _ = h.insert("And_rm16_imm16", Code::And_rm16_imm16);
		let _ = h.insert("And_rm32_imm32", Code::And_rm32_imm32);
		let _ = h.insert("And_rm64_imm32", Code::And_rm64_imm32);
		let _ = h.insert("Sub_rm16_imm16", Code::Sub_rm16_imm16);
		let _ = h.insert("Sub_rm32_imm32", Code::Sub_rm32_imm32);
		let _ = h.insert("Sub_rm64_imm32", Code::Sub_rm64_imm32);
		let _ = h.insert("Xor_rm16_imm16", Code::Xor_rm16_imm16);
		let _ = h.insert("Xor_rm32_imm32", Code::Xor_rm32_imm32);
		let _ = h.insert("Xor_rm64_imm32", Code::Xor_rm64_imm32);
		let _ = h.insert("Cmp_rm16_imm16", Code::Cmp_rm16_imm16);
		let _ = h.insert("Cmp_rm32_imm32", Code::Cmp_rm32_imm32);
		let _ = h.insert("Cmp_rm64_imm32", Code::Cmp_rm64_imm32);
		let _ = h.insert("Add_rm8_imm8_82", Code::Add_rm8_imm8_82);
		let _ = h.insert("Or_rm8_imm8_82", Code::Or_rm8_imm8_82);
		let _ = h.insert("Adc_rm8_imm8_82", Code::Adc_rm8_imm8_82);
		let _ = h.insert("Sbb_rm8_imm8_82", Code::Sbb_rm8_imm8_82);
		let _ = h.insert("And_rm8_imm8_82", Code::And_rm8_imm8_82);
		let _ = h.insert("Sub_rm8_imm8_82", Code::Sub_rm8_imm8_82);
		let _ = h.insert("Xor_rm8_imm8_82", Code::Xor_rm8_imm8_82);
		let _ = h.insert("Cmp_rm8_imm8_82", Code::Cmp_rm8_imm8_82);
		let _ = h.insert("Add_rm16_imm8", Code::Add_rm16_imm8);
		let _ = h.insert("Add_rm32_imm8", Code::Add_rm32_imm8);
		let _ = h.insert("Add_rm64_imm8", Code::Add_rm64_imm8);
		let _ = h.insert("Or_rm16_imm8", Code::Or_rm16_imm8);
		let _ = h.insert("Or_rm32_imm8", Code::Or_rm32_imm8);
		let _ = h.insert("Or_rm64_imm8", Code::Or_rm64_imm8);
		let _ = h.insert("Adc_rm16_imm8", Code::Adc_rm16_imm8);
		let _ = h.insert("Adc_rm32_imm8", Code::Adc_rm32_imm8);
		let _ = h.insert("Adc_rm64_imm8", Code::Adc_rm64_imm8);
		let _ = h.insert("Sbb_rm16_imm8", Code::Sbb_rm16_imm8);
		let _ = h.insert("Sbb_rm32_imm8", Code::Sbb_rm32_imm8);
		let _ = h.insert("Sbb_rm64_imm8", Code::Sbb_rm64_imm8);
		let _ = h.insert("And_rm16_imm8", Code::And_rm16_imm8);
		let _ = h.insert("And_rm32_imm8", Code::And_rm32_imm8);
		let _ = h.insert("And_rm64_imm8", Code::And_rm64_imm8);
		let _ = h.insert("Sub_rm16_imm8", Code::Sub_rm16_imm8);
		let _ = h.insert("Sub_rm32_imm8", Code::Sub_rm32_imm8);
		let _ = h.insert("Sub_rm64_imm8", Code::Sub_rm64_imm8);
		let _ = h.insert("Xor_rm16_imm8", Code::Xor_rm16_imm8);
		let _ = h.insert("Xor_rm32_imm8", Code::Xor_rm32_imm8);
		let _ = h.insert("Xor_rm64_imm8", Code::Xor_rm64_imm8);
		let _ = h.insert("Cmp_rm16_imm8", Code::Cmp_rm16_imm8);
		let _ = h.insert("Cmp_rm32_imm8", Code::Cmp_rm32_imm8);
		let _ = h.insert("Cmp_rm64_imm8", Code::Cmp_rm64_imm8);
		let _ = h.insert("Test_rm8_r8", Code::Test_rm8_r8);
		let _ = h.insert("Test_rm16_r16", Code::Test_rm16_r16);
		let _ = h.insert("Test_rm32_r32", Code::Test_rm32_r32);
		let _ = h.insert("Test_rm64_r64", Code::Test_rm64_r64);
		let _ = h.insert("Xchg_rm8_r8", Code::Xchg_rm8_r8);
		let _ = h.insert("Xchg_rm16_r16", Code::Xchg_rm16_r16);
		let _ = h.insert("Xchg_rm32_r32", Code::Xchg_rm32_r32);
		let _ = h.insert("Xchg_rm64_r64", Code::Xchg_rm64_r64);
		let _ = h.insert("Mov_rm8_r8", Code::Mov_rm8_r8);
		let _ = h.insert("Mov_rm16_r16", Code::Mov_rm16_r16);
		let _ = h.insert("Mov_rm32_r32", Code::Mov_rm32_r32);
		let _ = h.insert("Mov_rm64_r64", Code::Mov_rm64_r64);
		let _ = h.insert("Mov_r8_rm8", Code::Mov_r8_rm8);
		let _ = h.insert("Mov_r16_rm16", Code::Mov_r16_rm16);
		let _ = h.insert("Mov_r32_rm32", Code::Mov_r32_rm32);
		let _ = h.insert("Mov_r64_rm64", Code::Mov_r64_rm64);
		let _ = h.insert("Mov_rm16_Sreg", Code::Mov_rm16_Sreg);
		let _ = h.insert("Mov_r32m16_Sreg", Code::Mov_r32m16_Sreg);
		let _ = h.insert("Mov_r64m16_Sreg", Code::Mov_r64m16_Sreg);
		let _ = h.insert("Lea_r16_m", Code::Lea_r16_m);
		let _ = h.insert("Lea_r32_m", Code::Lea_r32_m);
		let _ = h.insert("Lea_r64_m", Code::Lea_r64_m);
		let _ = h.insert("Mov_Sreg_rm16", Code::Mov_Sreg_rm16);
		let _ = h.insert("Mov_Sreg_r32m16", Code::Mov_Sreg_r32m16);
		let _ = h.insert("Mov_Sreg_r64m16", Code::Mov_Sreg_r64m16);
		let _ = h.insert("Pop_rm16", Code::Pop_rm16);
		let _ = h.insert("Pop_rm32", Code::Pop_rm32);
		let _ = h.insert("Pop_rm64", Code::Pop_rm64);
		let _ = h.insert("Nopw", Code::Nopw);
		let _ = h.insert("Nopd", Code::Nopd);
		let _ = h.insert("Nopq", Code::Nopq);
		let _ = h.insert("Xchg_r16_AX", Code::Xchg_r16_AX);
		let _ = h.insert("Xchg_r32_EAX", Code::Xchg_r32_EAX);
		let _ = h.insert("Xchg_r64_RAX", Code::Xchg_r64_RAX);
		let _ = h.insert("Pause", Code::Pause);
		let _ = h.insert("Cbw", Code::Cbw);
		let _ = h.insert("Cwde", Code::Cwde);
		let _ = h.insert("Cdqe", Code::Cdqe);
		let _ = h.insert("Cwd", Code::Cwd);
		let _ = h.insert("Cdq", Code::Cdq);
		let _ = h.insert("Cqo", Code::Cqo);
		let _ = h.insert("Call_ptr1616", Code::Call_ptr1616);
		let _ = h.insert("Call_ptr1632", Code::Call_ptr1632);
		let _ = h.insert("Wait", Code::Wait);
		let _ = h.insert("Pushfw", Code::Pushfw);
		let _ = h.insert("Pushfd", Code::Pushfd);
		let _ = h.insert("Pushfq", Code::Pushfq);
		let _ = h.insert("Popfw", Code::Popfw);
		let _ = h.insert("Popfd", Code::Popfd);
		let _ = h.insert("Popfq", Code::Popfq);
		let _ = h.insert("Sahf", Code::Sahf);
		let _ = h.insert("Lahf", Code::Lahf);
		let _ = h.insert("Mov_AL_moffs8", Code::Mov_AL_moffs8);
		let _ = h.insert("Mov_AX_moffs16", Code::Mov_AX_moffs16);
		let _ = h.insert("Mov_EAX_moffs32", Code::Mov_EAX_moffs32);
		let _ = h.insert("Mov_RAX_moffs64", Code::Mov_RAX_moffs64);
		let _ = h.insert("Mov_moffs8_AL", Code::Mov_moffs8_AL);
		let _ = h.insert("Mov_moffs16_AX", Code::Mov_moffs16_AX);
		let _ = h.insert("Mov_moffs32_EAX", Code::Mov_moffs32_EAX);
		let _ = h.insert("Mov_moffs64_RAX", Code::Mov_moffs64_RAX);
		let _ = h.insert("Movsb_m8_m8", Code::Movsb_m8_m8);
		let _ = h.insert("Movsw_m16_m16", Code::Movsw_m16_m16);
		let _ = h.insert("Movsd_m32_m32", Code::Movsd_m32_m32);
		let _ = h.insert("Movsq_m64_m64", Code::Movsq_m64_m64);
		let _ = h.insert("Cmpsb_m8_m8", Code::Cmpsb_m8_m8);
		let _ = h.insert("Cmpsw_m16_m16", Code::Cmpsw_m16_m16);
		let _ = h.insert("Cmpsd_m32_m32", Code::Cmpsd_m32_m32);
		let _ = h.insert("Cmpsq_m64_m64", Code::Cmpsq_m64_m64);
		let _ = h.insert("Test_AL_imm8", Code::Test_AL_imm8);
		let _ = h.insert("Test_AX_imm16", Code::Test_AX_imm16);
		let _ = h.insert("Test_EAX_imm32", Code::Test_EAX_imm32);
		let _ = h.insert("Test_RAX_imm32", Code::Test_RAX_imm32);
		let _ = h.insert("Stosb_m8_AL", Code::Stosb_m8_AL);
		let _ = h.insert("Stosw_m16_AX", Code::Stosw_m16_AX);
		let _ = h.insert("Stosd_m32_EAX", Code::Stosd_m32_EAX);
		let _ = h.insert("Stosq_m64_RAX", Code::Stosq_m64_RAX);
		let _ = h.insert("Lodsb_AL_m8", Code::Lodsb_AL_m8);
		let _ = h.insert("Lodsw_AX_m16", Code::Lodsw_AX_m16);
		let _ = h.insert("Lodsd_EAX_m32", Code::Lodsd_EAX_m32);
		let _ = h.insert("Lodsq_RAX_m64", Code::Lodsq_RAX_m64);
		let _ = h.insert("Scasb_AL_m8", Code::Scasb_AL_m8);
		let _ = h.insert("Scasw_AX_m16", Code::Scasw_AX_m16);
		let _ = h.insert("Scasd_EAX_m32", Code::Scasd_EAX_m32);
		let _ = h.insert("Scasq_RAX_m64", Code::Scasq_RAX_m64);
		let _ = h.insert("Mov_r8_imm8", Code::Mov_r8_imm8);
		let _ = h.insert("Mov_r16_imm16", Code::Mov_r16_imm16);
		let _ = h.insert("Mov_r32_imm32", Code::Mov_r32_imm32);
		let _ = h.insert("Mov_r64_imm64", Code::Mov_r64_imm64);
		let _ = h.insert("Rol_rm8_imm8", Code::Rol_rm8_imm8);
		let _ = h.insert("Ror_rm8_imm8", Code::Ror_rm8_imm8);
		let _ = h.insert("Rcl_rm8_imm8", Code::Rcl_rm8_imm8);
		let _ = h.insert("Rcr_rm8_imm8", Code::Rcr_rm8_imm8);
		let _ = h.insert("Shl_rm8_imm8", Code::Shl_rm8_imm8);
		let _ = h.insert("Shr_rm8_imm8", Code::Shr_rm8_imm8);
		let _ = h.insert("Sal_rm8_imm8", Code::Sal_rm8_imm8);
		let _ = h.insert("Sar_rm8_imm8", Code::Sar_rm8_imm8);
		let _ = h.insert("Rol_rm16_imm8", Code::Rol_rm16_imm8);
		let _ = h.insert("Rol_rm32_imm8", Code::Rol_rm32_imm8);
		let _ = h.insert("Rol_rm64_imm8", Code::Rol_rm64_imm8);
		let _ = h.insert("Ror_rm16_imm8", Code::Ror_rm16_imm8);
		let _ = h.insert("Ror_rm32_imm8", Code::Ror_rm32_imm8);
		let _ = h.insert("Ror_rm64_imm8", Code::Ror_rm64_imm8);
		let _ = h.insert("Rcl_rm16_imm8", Code::Rcl_rm16_imm8);
		let _ = h.insert("Rcl_rm32_imm8", Code::Rcl_rm32_imm8);
		let _ = h.insert("Rcl_rm64_imm8", Code::Rcl_rm64_imm8);
		let _ = h.insert("Rcr_rm16_imm8", Code::Rcr_rm16_imm8);
		let _ = h.insert("Rcr_rm32_imm8", Code::Rcr_rm32_imm8);
		let _ = h.insert("Rcr_rm64_imm8", Code::Rcr_rm64_imm8);
		let _ = h.insert("Shl_rm16_imm8", Code::Shl_rm16_imm8);
		let _ = h.insert("Shl_rm32_imm8", Code::Shl_rm32_imm8);
		let _ = h.insert("Shl_rm64_imm8", Code::Shl_rm64_imm8);
		let _ = h.insert("Shr_rm16_imm8", Code::Shr_rm16_imm8);
		let _ = h.insert("Shr_rm32_imm8", Code::Shr_rm32_imm8);
		let _ = h.insert("Shr_rm64_imm8", Code::Shr_rm64_imm8);
		let _ = h.insert("Sal_rm16_imm8", Code::Sal_rm16_imm8);
		let _ = h.insert("Sal_rm32_imm8", Code::Sal_rm32_imm8);
		let _ = h.insert("Sal_rm64_imm8", Code::Sal_rm64_imm8);
		let _ = h.insert("Sar_rm16_imm8", Code::Sar_rm16_imm8);
		let _ = h.insert("Sar_rm32_imm8", Code::Sar_rm32_imm8);
		let _ = h.insert("Sar_rm64_imm8", Code::Sar_rm64_imm8);
		let _ = h.insert("Retnw_imm16", Code::Retnw_imm16);
		let _ = h.insert("Retnd_imm16", Code::Retnd_imm16);
		let _ = h.insert("Retnq_imm16", Code::Retnq_imm16);
		let _ = h.insert("Retnw", Code::Retnw);
		let _ = h.insert("Retnd", Code::Retnd);
		let _ = h.insert("Retnq", Code::Retnq);
		let _ = h.insert("Les_r16_m1616", Code::Les_r16_m1616);
		let _ = h.insert("Les_r32_m1632", Code::Les_r32_m1632);
		let _ = h.insert("Lds_r16_m1616", Code::Lds_r16_m1616);
		let _ = h.insert("Lds_r32_m1632", Code::Lds_r32_m1632);
		let _ = h.insert("Mov_rm8_imm8", Code::Mov_rm8_imm8);
		let _ = h.insert("Xabort_imm8", Code::Xabort_imm8);
		let _ = h.insert("Mov_rm16_imm16", Code::Mov_rm16_imm16);
		let _ = h.insert("Mov_rm32_imm32", Code::Mov_rm32_imm32);
		let _ = h.insert("Mov_rm64_imm32", Code::Mov_rm64_imm32);
		let _ = h.insert("Xbegin_rel16", Code::Xbegin_rel16);
		let _ = h.insert("Xbegin_rel32", Code::Xbegin_rel32);
		let _ = h.insert("Enterw_imm16_imm8", Code::Enterw_imm16_imm8);
		let _ = h.insert("Enterd_imm16_imm8", Code::Enterd_imm16_imm8);
		let _ = h.insert("Enterq_imm16_imm8", Code::Enterq_imm16_imm8);
		let _ = h.insert("Leavew", Code::Leavew);
		let _ = h.insert("Leaved", Code::Leaved);
		let _ = h.insert("Leaveq", Code::Leaveq);
		let _ = h.insert("Retfw_imm16", Code::Retfw_imm16);
		let _ = h.insert("Retfd_imm16", Code::Retfd_imm16);
		let _ = h.insert("Retfq_imm16", Code::Retfq_imm16);
		let _ = h.insert("Retfw", Code::Retfw);
		let _ = h.insert("Retfd", Code::Retfd);
		let _ = h.insert("Retfq", Code::Retfq);
		let _ = h.insert("Int3", Code::Int3);
		let _ = h.insert("Int_imm8", Code::Int_imm8);
		let _ = h.insert("Into", Code::Into);
		let _ = h.insert("Iretw", Code::Iretw);
		let _ = h.insert("Iretd", Code::Iretd);
		let _ = h.insert("Iretq", Code::Iretq);
		let _ = h.insert("Rol_rm8_1", Code::Rol_rm8_1);
		let _ = h.insert("Ror_rm8_1", Code::Ror_rm8_1);
		let _ = h.insert("Rcl_rm8_1", Code::Rcl_rm8_1);
		let _ = h.insert("Rcr_rm8_1", Code::Rcr_rm8_1);
		let _ = h.insert("Shl_rm8_1", Code::Shl_rm8_1);
		let _ = h.insert("Shr_rm8_1", Code::Shr_rm8_1);
		let _ = h.insert("Sal_rm8_1", Code::Sal_rm8_1);
		let _ = h.insert("Sar_rm8_1", Code::Sar_rm8_1);
		let _ = h.insert("Rol_rm16_1", Code::Rol_rm16_1);
		let _ = h.insert("Rol_rm32_1", Code::Rol_rm32_1);
		let _ = h.insert("Rol_rm64_1", Code::Rol_rm64_1);
		let _ = h.insert("Ror_rm16_1", Code::Ror_rm16_1);
		let _ = h.insert("Ror_rm32_1", Code::Ror_rm32_1);
		let _ = h.insert("Ror_rm64_1", Code::Ror_rm64_1);
		let _ = h.insert("Rcl_rm16_1", Code::Rcl_rm16_1);
		let _ = h.insert("Rcl_rm32_1", Code::Rcl_rm32_1);
		let _ = h.insert("Rcl_rm64_1", Code::Rcl_rm64_1);
		let _ = h.insert("Rcr_rm16_1", Code::Rcr_rm16_1);
		let _ = h.insert("Rcr_rm32_1", Code::Rcr_rm32_1);
		let _ = h.insert("Rcr_rm64_1", Code::Rcr_rm64_1);
		let _ = h.insert("Shl_rm16_1", Code::Shl_rm16_1);
		let _ = h.insert("Shl_rm32_1", Code::Shl_rm32_1);
		let _ = h.insert("Shl_rm64_1", Code::Shl_rm64_1);
		let _ = h.insert("Shr_rm16_1", Code::Shr_rm16_1);
		let _ = h.insert("Shr_rm32_1", Code::Shr_rm32_1);
		let _ = h.insert("Shr_rm64_1", Code::Shr_rm64_1);
		let _ = h.insert("Sal_rm16_1", Code::Sal_rm16_1);
		let _ = h.insert("Sal_rm32_1", Code::Sal_rm32_1);
		let _ = h.insert("Sal_rm64_1", Code::Sal_rm64_1);
		let _ = h.insert("Sar_rm16_1", Code::Sar_rm16_1);
		let _ = h.insert("Sar_rm32_1", Code::Sar_rm32_1);
		let _ = h.insert("Sar_rm64_1", Code::Sar_rm64_1);
		let _ = h.insert("Rol_rm8_CL", Code::Rol_rm8_CL);
		let _ = h.insert("Ror_rm8_CL", Code::Ror_rm8_CL);
		let _ = h.insert("Rcl_rm8_CL", Code::Rcl_rm8_CL);
		let _ = h.insert("Rcr_rm8_CL", Code::Rcr_rm8_CL);
		let _ = h.insert("Shl_rm8_CL", Code::Shl_rm8_CL);
		let _ = h.insert("Shr_rm8_CL", Code::Shr_rm8_CL);
		let _ = h.insert("Sal_rm8_CL", Code::Sal_rm8_CL);
		let _ = h.insert("Sar_rm8_CL", Code::Sar_rm8_CL);
		let _ = h.insert("Rol_rm16_CL", Code::Rol_rm16_CL);
		let _ = h.insert("Rol_rm32_CL", Code::Rol_rm32_CL);
		let _ = h.insert("Rol_rm64_CL", Code::Rol_rm64_CL);
		let _ = h.insert("Ror_rm16_CL", Code::Ror_rm16_CL);
		let _ = h.insert("Ror_rm32_CL", Code::Ror_rm32_CL);
		let _ = h.insert("Ror_rm64_CL", Code::Ror_rm64_CL);
		let _ = h.insert("Rcl_rm16_CL", Code::Rcl_rm16_CL);
		let _ = h.insert("Rcl_rm32_CL", Code::Rcl_rm32_CL);
		let _ = h.insert("Rcl_rm64_CL", Code::Rcl_rm64_CL);
		let _ = h.insert("Rcr_rm16_CL", Code::Rcr_rm16_CL);
		let _ = h.insert("Rcr_rm32_CL", Code::Rcr_rm32_CL);
		let _ = h.insert("Rcr_rm64_CL", Code::Rcr_rm64_CL);
		let _ = h.insert("Shl_rm16_CL", Code::Shl_rm16_CL);
		let _ = h.insert("Shl_rm32_CL", Code::Shl_rm32_CL);
		let _ = h.insert("Shl_rm64_CL", Code::Shl_rm64_CL);
		let _ = h.insert("Shr_rm16_CL", Code::Shr_rm16_CL);
		let _ = h.insert("Shr_rm32_CL", Code::Shr_rm32_CL);
		let _ = h.insert("Shr_rm64_CL", Code::Shr_rm64_CL);
		let _ = h.insert("Sal_rm16_CL", Code::Sal_rm16_CL);
		let _ = h.insert("Sal_rm32_CL", Code::Sal_rm32_CL);
		let _ = h.insert("Sal_rm64_CL", Code::Sal_rm64_CL);
		let _ = h.insert("Sar_rm16_CL", Code::Sar_rm16_CL);
		let _ = h.insert("Sar_rm32_CL", Code::Sar_rm32_CL);
		let _ = h.insert("Sar_rm64_CL", Code::Sar_rm64_CL);
		let _ = h.insert("Aam_imm8", Code::Aam_imm8);
		let _ = h.insert("Aad_imm8", Code::Aad_imm8);
		let _ = h.insert("Salc", Code::Salc);
		let _ = h.insert("Xlat_m8", Code::Xlat_m8);
		let _ = h.insert("Fadd_m32fp", Code::Fadd_m32fp);
		let _ = h.insert("Fmul_m32fp", Code::Fmul_m32fp);
		let _ = h.insert("Fcom_m32fp", Code::Fcom_m32fp);
		let _ = h.insert("Fcomp_m32fp", Code::Fcomp_m32fp);
		let _ = h.insert("Fsub_m32fp", Code::Fsub_m32fp);
		let _ = h.insert("Fsubr_m32fp", Code::Fsubr_m32fp);
		let _ = h.insert("Fdiv_m32fp", Code::Fdiv_m32fp);
		let _ = h.insert("Fdivr_m32fp", Code::Fdivr_m32fp);
		let _ = h.insert("Fadd_st0_sti", Code::Fadd_st0_sti);
		let _ = h.insert("Fmul_st0_sti", Code::Fmul_st0_sti);
		let _ = h.insert("Fcom_st0_sti", Code::Fcom_st0_sti);
		let _ = h.insert("Fcomp_st0_sti", Code::Fcomp_st0_sti);
		let _ = h.insert("Fsub_st0_sti", Code::Fsub_st0_sti);
		let _ = h.insert("Fsubr_st0_sti", Code::Fsubr_st0_sti);
		let _ = h.insert("Fdiv_st0_sti", Code::Fdiv_st0_sti);
		let _ = h.insert("Fdivr_st0_sti", Code::Fdivr_st0_sti);
		let _ = h.insert("Fld_m32fp", Code::Fld_m32fp);
		let _ = h.insert("Fst_m32fp", Code::Fst_m32fp);
		let _ = h.insert("Fstp_m32fp", Code::Fstp_m32fp);
		let _ = h.insert("Fldenv_m14byte", Code::Fldenv_m14byte);
		let _ = h.insert("Fldenv_m28byte", Code::Fldenv_m28byte);
		let _ = h.insert("Fldcw_m2byte", Code::Fldcw_m2byte);
		let _ = h.insert("Fnstenv_m14byte", Code::Fnstenv_m14byte);
		let _ = h.insert("Fstenv_m14byte", Code::Fstenv_m14byte);
		let _ = h.insert("Fnstenv_m28byte", Code::Fnstenv_m28byte);
		let _ = h.insert("Fstenv_m28byte", Code::Fstenv_m28byte);
		let _ = h.insert("Fnstcw_m2byte", Code::Fnstcw_m2byte);
		let _ = h.insert("Fstcw_m2byte", Code::Fstcw_m2byte);
		let _ = h.insert("Fld_sti", Code::Fld_sti);
		let _ = h.insert("Fxch_st0_sti", Code::Fxch_st0_sti);
		let _ = h.insert("Fnop", Code::Fnop);
		let _ = h.insert("Fstpnce_sti", Code::Fstpnce_sti);
		let _ = h.insert("Fchs", Code::Fchs);
		let _ = h.insert("Fabs", Code::Fabs);
		let _ = h.insert("Ftst", Code::Ftst);
		let _ = h.insert("Fxam", Code::Fxam);
		let _ = h.insert("Fld1", Code::Fld1);
		let _ = h.insert("Fldl2t", Code::Fldl2t);
		let _ = h.insert("Fldl2e", Code::Fldl2e);
		let _ = h.insert("Fldpi", Code::Fldpi);
		let _ = h.insert("Fldlg2", Code::Fldlg2);
		let _ = h.insert("Fldln2", Code::Fldln2);
		let _ = h.insert("Fldz", Code::Fldz);
		let _ = h.insert("F2xm1", Code::F2xm1);
		let _ = h.insert("Fyl2x", Code::Fyl2x);
		let _ = h.insert("Fptan", Code::Fptan);
		let _ = h.insert("Fpatan", Code::Fpatan);
		let _ = h.insert("Fxtract", Code::Fxtract);
		let _ = h.insert("Fprem1", Code::Fprem1);
		let _ = h.insert("Fdecstp", Code::Fdecstp);
		let _ = h.insert("Fincstp", Code::Fincstp);
		let _ = h.insert("Fprem", Code::Fprem);
		let _ = h.insert("Fyl2xp1", Code::Fyl2xp1);
		let _ = h.insert("Fsqrt", Code::Fsqrt);
		let _ = h.insert("Fsincos", Code::Fsincos);
		let _ = h.insert("Frndint", Code::Frndint);
		let _ = h.insert("Fscale", Code::Fscale);
		let _ = h.insert("Fsin", Code::Fsin);
		let _ = h.insert("Fcos", Code::Fcos);
		let _ = h.insert("Fiadd_m32int", Code::Fiadd_m32int);
		let _ = h.insert("Fimul_m32int", Code::Fimul_m32int);
		let _ = h.insert("Ficom_m32int", Code::Ficom_m32int);
		let _ = h.insert("Ficomp_m32int", Code::Ficomp_m32int);
		let _ = h.insert("Fisub_m32int", Code::Fisub_m32int);
		let _ = h.insert("Fisubr_m32int", Code::Fisubr_m32int);
		let _ = h.insert("Fidiv_m32int", Code::Fidiv_m32int);
		let _ = h.insert("Fidivr_m32int", Code::Fidivr_m32int);
		let _ = h.insert("Fcmovb_st0_sti", Code::Fcmovb_st0_sti);
		let _ = h.insert("Fcmove_st0_sti", Code::Fcmove_st0_sti);
		let _ = h.insert("Fcmovbe_st0_sti", Code::Fcmovbe_st0_sti);
		let _ = h.insert("Fcmovu_st0_sti", Code::Fcmovu_st0_sti);
		let _ = h.insert("Fucompp", Code::Fucompp);
		let _ = h.insert("Fild_m32int", Code::Fild_m32int);
		let _ = h.insert("Fisttp_m32int", Code::Fisttp_m32int);
		let _ = h.insert("Fist_m32int", Code::Fist_m32int);
		let _ = h.insert("Fistp_m32int", Code::Fistp_m32int);
		let _ = h.insert("Fld_m80fp", Code::Fld_m80fp);
		let _ = h.insert("Fstp_m80fp", Code::Fstp_m80fp);
		let _ = h.insert("Fcmovnb_st0_sti", Code::Fcmovnb_st0_sti);
		let _ = h.insert("Fcmovne_st0_sti", Code::Fcmovne_st0_sti);
		let _ = h.insert("Fcmovnbe_st0_sti", Code::Fcmovnbe_st0_sti);
		let _ = h.insert("Fcmovnu_st0_sti", Code::Fcmovnu_st0_sti);
		let _ = h.insert("Fneni", Code::Fneni);
		let _ = h.insert("Feni", Code::Feni);
		let _ = h.insert("Fndisi", Code::Fndisi);
		let _ = h.insert("Fdisi", Code::Fdisi);
		let _ = h.insert("Fnclex", Code::Fnclex);
		let _ = h.insert("Fclex", Code::Fclex);
		let _ = h.insert("Fninit", Code::Fninit);
		let _ = h.insert("Finit", Code::Finit);
		let _ = h.insert("Fnsetpm", Code::Fnsetpm);
		let _ = h.insert("Fsetpm", Code::Fsetpm);
		let _ = h.insert("Frstpm", Code::Frstpm);
		let _ = h.insert("Fucomi_st0_sti", Code::Fucomi_st0_sti);
		let _ = h.insert("Fcomi_st0_sti", Code::Fcomi_st0_sti);
		let _ = h.insert("Fadd_m64fp", Code::Fadd_m64fp);
		let _ = h.insert("Fmul_m64fp", Code::Fmul_m64fp);
		let _ = h.insert("Fcom_m64fp", Code::Fcom_m64fp);
		let _ = h.insert("Fcomp_m64fp", Code::Fcomp_m64fp);
		let _ = h.insert("Fsub_m64fp", Code::Fsub_m64fp);
		let _ = h.insert("Fsubr_m64fp", Code::Fsubr_m64fp);
		let _ = h.insert("Fdiv_m64fp", Code::Fdiv_m64fp);
		let _ = h.insert("Fdivr_m64fp", Code::Fdivr_m64fp);
		let _ = h.insert("Fadd_sti_st0", Code::Fadd_sti_st0);
		let _ = h.insert("Fmul_sti_st0", Code::Fmul_sti_st0);
		let _ = h.insert("Fcom_st0_sti_DCD0", Code::Fcom_st0_sti_DCD0);
		let _ = h.insert("Fcomp_st0_sti_DCD8", Code::Fcomp_st0_sti_DCD8);
		let _ = h.insert("Fsubr_sti_st0", Code::Fsubr_sti_st0);
		let _ = h.insert("Fsub_sti_st0", Code::Fsub_sti_st0);
		let _ = h.insert("Fdivr_sti_st0", Code::Fdivr_sti_st0);
		let _ = h.insert("Fdiv_sti_st0", Code::Fdiv_sti_st0);
		let _ = h.insert("Fld_m64fp", Code::Fld_m64fp);
		let _ = h.insert("Fisttp_m64int", Code::Fisttp_m64int);
		let _ = h.insert("Fst_m64fp", Code::Fst_m64fp);
		let _ = h.insert("Fstp_m64fp", Code::Fstp_m64fp);
		let _ = h.insert("Frstor_m94byte", Code::Frstor_m94byte);
		let _ = h.insert("Frstor_m108byte", Code::Frstor_m108byte);
		let _ = h.insert("Fnsave_m94byte", Code::Fnsave_m94byte);
		let _ = h.insert("Fsave_m94byte", Code::Fsave_m94byte);
		let _ = h.insert("Fnsave_m108byte", Code::Fnsave_m108byte);
		let _ = h.insert("Fsave_m108byte", Code::Fsave_m108byte);
		let _ = h.insert("Fnstsw_m2byte", Code::Fnstsw_m2byte);
		let _ = h.insert("Fstsw_m2byte", Code::Fstsw_m2byte);
		let _ = h.insert("Ffree_sti", Code::Ffree_sti);
		let _ = h.insert("Fxch_st0_sti_DDC8", Code::Fxch_st0_sti_DDC8);
		let _ = h.insert("Fst_sti", Code::Fst_sti);
		let _ = h.insert("Fstp_sti", Code::Fstp_sti);
		let _ = h.insert("Fucom_st0_sti", Code::Fucom_st0_sti);
		let _ = h.insert("Fucomp_st0_sti", Code::Fucomp_st0_sti);
		let _ = h.insert("Fiadd_m16int", Code::Fiadd_m16int);
		let _ = h.insert("Fimul_m16int", Code::Fimul_m16int);
		let _ = h.insert("Ficom_m16int", Code::Ficom_m16int);
		let _ = h.insert("Ficomp_m16int", Code::Ficomp_m16int);
		let _ = h.insert("Fisub_m16int", Code::Fisub_m16int);
		let _ = h.insert("Fisubr_m16int", Code::Fisubr_m16int);
		let _ = h.insert("Fidiv_m16int", Code::Fidiv_m16int);
		let _ = h.insert("Fidivr_m16int", Code::Fidivr_m16int);
		let _ = h.insert("Faddp_sti_st0", Code::Faddp_sti_st0);
		let _ = h.insert("Fmulp_sti_st0", Code::Fmulp_sti_st0);
		let _ = h.insert("Fcomp_st0_sti_DED0", Code::Fcomp_st0_sti_DED0);
		let _ = h.insert("Fcompp", Code::Fcompp);
		let _ = h.insert("Fsubrp_sti_st0", Code::Fsubrp_sti_st0);
		let _ = h.insert("Fsubp_sti_st0", Code::Fsubp_sti_st0);
		let _ = h.insert("Fdivrp_sti_st0", Code::Fdivrp_sti_st0);
		let _ = h.insert("Fdivp_sti_st0", Code::Fdivp_sti_st0);
		let _ = h.insert("Fild_m16int", Code::Fild_m16int);
		let _ = h.insert("Fisttp_m16int", Code::Fisttp_m16int);
		let _ = h.insert("Fist_m16int", Code::Fist_m16int);
		let _ = h.insert("Fistp_m16int", Code::Fistp_m16int);
		let _ = h.insert("Fbld_m80bcd", Code::Fbld_m80bcd);
		let _ = h.insert("Fild_m64int", Code::Fild_m64int);
		let _ = h.insert("Fbstp_m80bcd", Code::Fbstp_m80bcd);
		let _ = h.insert("Fistp_m64int", Code::Fistp_m64int);
		let _ = h.insert("Ffreep_sti", Code::Ffreep_sti);
		let _ = h.insert("Fxch_st0_sti_DFC8", Code::Fxch_st0_sti_DFC8);
		let _ = h.insert("Fstp_sti_DFD0", Code::Fstp_sti_DFD0);
		let _ = h.insert("Fstp_sti_DFD8", Code::Fstp_sti_DFD8);
		let _ = h.insert("Fnstsw_AX", Code::Fnstsw_AX);
		let _ = h.insert("Fstsw_AX", Code::Fstsw_AX);
		let _ = h.insert("Fstdw_AX", Code::Fstdw_AX);
		let _ = h.insert("Fstsg_AX", Code::Fstsg_AX);
		let _ = h.insert("Fucomip_st0_sti", Code::Fucomip_st0_sti);
		let _ = h.insert("Fcomip_st0_sti", Code::Fcomip_st0_sti);
		let _ = h.insert("Loopne_rel8_16_CX", Code::Loopne_rel8_16_CX);
		let _ = h.insert("Loopne_rel8_32_CX", Code::Loopne_rel8_32_CX);
		let _ = h.insert("Loopne_rel8_16_ECX", Code::Loopne_rel8_16_ECX);
		let _ = h.insert("Loopne_rel8_32_ECX", Code::Loopne_rel8_32_ECX);
		let _ = h.insert("Loopne_rel8_64_ECX", Code::Loopne_rel8_64_ECX);
		let _ = h.insert("Loopne_rel8_16_RCX", Code::Loopne_rel8_16_RCX);
		let _ = h.insert("Loopne_rel8_64_RCX", Code::Loopne_rel8_64_RCX);
		let _ = h.insert("Loope_rel8_16_CX", Code::Loope_rel8_16_CX);
		let _ = h.insert("Loope_rel8_32_CX", Code::Loope_rel8_32_CX);
		let _ = h.insert("Loope_rel8_16_ECX", Code::Loope_rel8_16_ECX);
		let _ = h.insert("Loope_rel8_32_ECX", Code::Loope_rel8_32_ECX);
		let _ = h.insert("Loope_rel8_64_ECX", Code::Loope_rel8_64_ECX);
		let _ = h.insert("Loope_rel8_16_RCX", Code::Loope_rel8_16_RCX);
		let _ = h.insert("Loope_rel8_64_RCX", Code::Loope_rel8_64_RCX);
		let _ = h.insert("Loop_rel8_16_CX", Code::Loop_rel8_16_CX);
		let _ = h.insert("Loop_rel8_32_CX", Code::Loop_rel8_32_CX);
		let _ = h.insert("Loop_rel8_16_ECX", Code::Loop_rel8_16_ECX);
		let _ = h.insert("Loop_rel8_32_ECX", Code::Loop_rel8_32_ECX);
		let _ = h.insert("Loop_rel8_64_ECX", Code::Loop_rel8_64_ECX);
		let _ = h.insert("Loop_rel8_16_RCX", Code::Loop_rel8_16_RCX);
		let _ = h.insert("Loop_rel8_64_RCX", Code::Loop_rel8_64_RCX);
		let _ = h.insert("Jcxz_rel8_16", Code::Jcxz_rel8_16);
		let _ = h.insert("Jcxz_rel8_32", Code::Jcxz_rel8_32);
		let _ = h.insert("Jecxz_rel8_16", Code::Jecxz_rel8_16);
		let _ = h.insert("Jecxz_rel8_32", Code::Jecxz_rel8_32);
		let _ = h.insert("Jecxz_rel8_64", Code::Jecxz_rel8_64);
		let _ = h.insert("Jrcxz_rel8_16", Code::Jrcxz_rel8_16);
		let _ = h.insert("Jrcxz_rel8_64", Code::Jrcxz_rel8_64);
		let _ = h.insert("In_AL_imm8", Code::In_AL_imm8);
		let _ = h.insert("In_AX_imm8", Code::In_AX_imm8);
		let _ = h.insert("In_EAX_imm8", Code::In_EAX_imm8);
		let _ = h.insert("Out_imm8_AL", Code::Out_imm8_AL);
		let _ = h.insert("Out_imm8_AX", Code::Out_imm8_AX);
		let _ = h.insert("Out_imm8_EAX", Code::Out_imm8_EAX);
		let _ = h.insert("Call_rel16", Code::Call_rel16);
		let _ = h.insert("Call_rel32_32", Code::Call_rel32_32);
		let _ = h.insert("Call_rel32_64", Code::Call_rel32_64);
		let _ = h.insert("Jmp_rel16", Code::Jmp_rel16);
		let _ = h.insert("Jmp_rel32_32", Code::Jmp_rel32_32);
		let _ = h.insert("Jmp_rel32_64", Code::Jmp_rel32_64);
		let _ = h.insert("Jmp_ptr1616", Code::Jmp_ptr1616);
		let _ = h.insert("Jmp_ptr1632", Code::Jmp_ptr1632);
		let _ = h.insert("Jmp_rel8_16", Code::Jmp_rel8_16);
		let _ = h.insert("Jmp_rel8_32", Code::Jmp_rel8_32);
		let _ = h.insert("Jmp_rel8_64", Code::Jmp_rel8_64);
		let _ = h.insert("In_AL_DX", Code::In_AL_DX);
		let _ = h.insert("In_AX_DX", Code::In_AX_DX);
		let _ = h.insert("In_EAX_DX", Code::In_EAX_DX);
		let _ = h.insert("Out_DX_AL", Code::Out_DX_AL);
		let _ = h.insert("Out_DX_AX", Code::Out_DX_AX);
		let _ = h.insert("Out_DX_EAX", Code::Out_DX_EAX);
		let _ = h.insert("Int1", Code::Int1);
		let _ = h.insert("Hlt", Code::Hlt);
		let _ = h.insert("Cmc", Code::Cmc);
		let _ = h.insert("Test_rm8_imm8", Code::Test_rm8_imm8);
		let _ = h.insert("Test_rm8_imm8_F6r1", Code::Test_rm8_imm8_F6r1);
		let _ = h.insert("Not_rm8", Code::Not_rm8);
		let _ = h.insert("Neg_rm8", Code::Neg_rm8);
		let _ = h.insert("Mul_rm8", Code::Mul_rm8);
		let _ = h.insert("Imul_rm8", Code::Imul_rm8);
		let _ = h.insert("Div_rm8", Code::Div_rm8);
		let _ = h.insert("Idiv_rm8", Code::Idiv_rm8);
		let _ = h.insert("Test_rm16_imm16", Code::Test_rm16_imm16);
		let _ = h.insert("Test_rm32_imm32", Code::Test_rm32_imm32);
		let _ = h.insert("Test_rm64_imm32", Code::Test_rm64_imm32);
		let _ = h.insert("Test_rm16_imm16_F7r1", Code::Test_rm16_imm16_F7r1);
		let _ = h.insert("Test_rm32_imm32_F7r1", Code::Test_rm32_imm32_F7r1);
		let _ = h.insert("Test_rm64_imm32_F7r1", Code::Test_rm64_imm32_F7r1);
		let _ = h.insert("Not_rm16", Code::Not_rm16);
		let _ = h.insert("Not_rm32", Code::Not_rm32);
		let _ = h.insert("Not_rm64", Code::Not_rm64);
		let _ = h.insert("Neg_rm16", Code::Neg_rm16);
		let _ = h.insert("Neg_rm32", Code::Neg_rm32);
		let _ = h.insert("Neg_rm64", Code::Neg_rm64);
		let _ = h.insert("Mul_rm16", Code::Mul_rm16);
		let _ = h.insert("Mul_rm32", Code::Mul_rm32);
		let _ = h.insert("Mul_rm64", Code::Mul_rm64);
		let _ = h.insert("Imul_rm16", Code::Imul_rm16);
		let _ = h.insert("Imul_rm32", Code::Imul_rm32);
		let _ = h.insert("Imul_rm64", Code::Imul_rm64);
		let _ = h.insert("Div_rm16", Code::Div_rm16);
		let _ = h.insert("Div_rm32", Code::Div_rm32);
		let _ = h.insert("Div_rm64", Code::Div_rm64);
		let _ = h.insert("Idiv_rm16", Code::Idiv_rm16);
		let _ = h.insert("Idiv_rm32", Code::Idiv_rm32);
		let _ = h.insert("Idiv_rm64", Code::Idiv_rm64);
		let _ = h.insert("Clc", Code::Clc);
		let _ = h.insert("Stc", Code::Stc);
		let _ = h.insert("Cli", Code::Cli);
		let _ = h.insert("Sti", Code::Sti);
		let _ = h.insert("Cld", Code::Cld);
		let _ = h.insert("Std", Code::Std);
		let _ = h.insert("Inc_rm8", Code::Inc_rm8);
		let _ = h.insert("Dec_rm8", Code::Dec_rm8);
		let _ = h.insert("Inc_rm16", Code::Inc_rm16);
		let _ = h.insert("Inc_rm32", Code::Inc_rm32);
		let _ = h.insert("Inc_rm64", Code::Inc_rm64);
		let _ = h.insert("Dec_rm16", Code::Dec_rm16);
		let _ = h.insert("Dec_rm32", Code::Dec_rm32);
		let _ = h.insert("Dec_rm64", Code::Dec_rm64);
		let _ = h.insert("Call_rm16", Code::Call_rm16);
		let _ = h.insert("Call_rm32", Code::Call_rm32);
		let _ = h.insert("Call_rm64", Code::Call_rm64);
		let _ = h.insert("Call_m1616", Code::Call_m1616);
		let _ = h.insert("Call_m1632", Code::Call_m1632);
		let _ = h.insert("Call_m1664", Code::Call_m1664);
		let _ = h.insert("Jmp_rm16", Code::Jmp_rm16);
		let _ = h.insert("Jmp_rm32", Code::Jmp_rm32);
		let _ = h.insert("Jmp_rm64", Code::Jmp_rm64);
		let _ = h.insert("Jmp_m1616", Code::Jmp_m1616);
		let _ = h.insert("Jmp_m1632", Code::Jmp_m1632);
		let _ = h.insert("Jmp_m1664", Code::Jmp_m1664);
		let _ = h.insert("Push_rm16", Code::Push_rm16);
		let _ = h.insert("Push_rm32", Code::Push_rm32);
		let _ = h.insert("Push_rm64", Code::Push_rm64);
		let _ = h.insert("Sldt_rm16", Code::Sldt_rm16);
		let _ = h.insert("Sldt_r32m16", Code::Sldt_r32m16);
		let _ = h.insert("Sldt_r64m16", Code::Sldt_r64m16);
		let _ = h.insert("Str_rm16", Code::Str_rm16);
		let _ = h.insert("Str_r32m16", Code::Str_r32m16);
		let _ = h.insert("Str_r64m16", Code::Str_r64m16);
		let _ = h.insert("Lldt_rm16", Code::Lldt_rm16);
		let _ = h.insert("Lldt_r32m16", Code::Lldt_r32m16);
		let _ = h.insert("Lldt_r64m16", Code::Lldt_r64m16);
		let _ = h.insert("Ltr_rm16", Code::Ltr_rm16);
		let _ = h.insert("Ltr_r32m16", Code::Ltr_r32m16);
		let _ = h.insert("Ltr_r64m16", Code::Ltr_r64m16);
		let _ = h.insert("Verr_rm16", Code::Verr_rm16);
		let _ = h.insert("Verr_r32m16", Code::Verr_r32m16);
		let _ = h.insert("Verr_r64m16", Code::Verr_r64m16);
		let _ = h.insert("Verw_rm16", Code::Verw_rm16);
		let _ = h.insert("Verw_r32m16", Code::Verw_r32m16);
		let _ = h.insert("Verw_r64m16", Code::Verw_r64m16);
		let _ = h.insert("Jmpe_rm16", Code::Jmpe_rm16);
		let _ = h.insert("Jmpe_rm32", Code::Jmpe_rm32);
		let _ = h.insert("Sgdt_m1632_16", Code::Sgdt_m1632_16);
		let _ = h.insert("Sgdt_m1632", Code::Sgdt_m1632);
		let _ = h.insert("Sgdt_m1664", Code::Sgdt_m1664);
		let _ = h.insert("Sidt_m1632_16", Code::Sidt_m1632_16);
		let _ = h.insert("Sidt_m1632", Code::Sidt_m1632);
		let _ = h.insert("Sidt_m1664", Code::Sidt_m1664);
		let _ = h.insert("Lgdt_m1632_16", Code::Lgdt_m1632_16);
		let _ = h.insert("Lgdt_m1632", Code::Lgdt_m1632);
		let _ = h.insert("Lgdt_m1664", Code::Lgdt_m1664);
		let _ = h.insert("Lidt_m1632_16", Code::Lidt_m1632_16);
		let _ = h.insert("Lidt_m1632", Code::Lidt_m1632);
		let _ = h.insert("Lidt_m1664", Code::Lidt_m1664);
		let _ = h.insert("Smsw_rm16", Code::Smsw_rm16);
		let _ = h.insert("Smsw_r32m16", Code::Smsw_r32m16);
		let _ = h.insert("Smsw_r64m16", Code::Smsw_r64m16);
		let _ = h.insert("Rstorssp_m64", Code::Rstorssp_m64);
		let _ = h.insert("Lmsw_rm16", Code::Lmsw_rm16);
		let _ = h.insert("Lmsw_r32m16", Code::Lmsw_r32m16);
		let _ = h.insert("Lmsw_r64m16", Code::Lmsw_r64m16);
		let _ = h.insert("Invlpg_m", Code::Invlpg_m);
		let _ = h.insert("Enclv", Code::Enclv);
		let _ = h.insert("Vmcall", Code::Vmcall);
		let _ = h.insert("Vmlaunch", Code::Vmlaunch);
		let _ = h.insert("Vmresume", Code::Vmresume);
		let _ = h.insert("Vmxoff", Code::Vmxoff);
		let _ = h.insert("Pconfig", Code::Pconfig);
		let _ = h.insert("Monitorw", Code::Monitorw);
		let _ = h.insert("Monitord", Code::Monitord);
		let _ = h.insert("Monitorq", Code::Monitorq);
		let _ = h.insert("Mwait", Code::Mwait);
		let _ = h.insert("Clac", Code::Clac);
		let _ = h.insert("Stac", Code::Stac);
		let _ = h.insert("Encls", Code::Encls);
		let _ = h.insert("Xgetbv", Code::Xgetbv);
		let _ = h.insert("Xsetbv", Code::Xsetbv);
		let _ = h.insert("Vmfunc", Code::Vmfunc);
		let _ = h.insert("Xend", Code::Xend);
		let _ = h.insert("Xtest", Code::Xtest);
		let _ = h.insert("Enclu", Code::Enclu);
		let _ = h.insert("Vmrunw", Code::Vmrunw);
		let _ = h.insert("Vmrund", Code::Vmrund);
		let _ = h.insert("Vmrunq", Code::Vmrunq);
		let _ = h.insert("Vmmcall", Code::Vmmcall);
		let _ = h.insert("Vmloadw", Code::Vmloadw);
		let _ = h.insert("Vmloadd", Code::Vmloadd);
		let _ = h.insert("Vmloadq", Code::Vmloadq);
		let _ = h.insert("Vmsavew", Code::Vmsavew);
		let _ = h.insert("Vmsaved", Code::Vmsaved);
		let _ = h.insert("Vmsaveq", Code::Vmsaveq);
		let _ = h.insert("Stgi", Code::Stgi);
		let _ = h.insert("Clgi", Code::Clgi);
		let _ = h.insert("Skinit", Code::Skinit);
		let _ = h.insert("Invlpgaw", Code::Invlpgaw);
		let _ = h.insert("Invlpgad", Code::Invlpgad);
		let _ = h.insert("Invlpgaq", Code::Invlpgaq);
		let _ = h.insert("Setssbsy", Code::Setssbsy);
		let _ = h.insert("Saveprevssp", Code::Saveprevssp);
		let _ = h.insert("Rdpkru", Code::Rdpkru);
		let _ = h.insert("Wrpkru", Code::Wrpkru);
		let _ = h.insert("Swapgs", Code::Swapgs);
		let _ = h.insert("Rdtscp", Code::Rdtscp);
		let _ = h.insert("Monitorxw", Code::Monitorxw);
		let _ = h.insert("Monitorxd", Code::Monitorxd);
		let _ = h.insert("Monitorxq", Code::Monitorxq);
		let _ = h.insert("Mcommit", Code::Mcommit);
		let _ = h.insert("Mwaitx", Code::Mwaitx);
		let _ = h.insert("Clzerow", Code::Clzerow);
		let _ = h.insert("Clzerod", Code::Clzerod);
		let _ = h.insert("Clzeroq", Code::Clzeroq);
		let _ = h.insert("Rdpru", Code::Rdpru);
		let _ = h.insert("Lar_r16_rm16", Code::Lar_r16_rm16);
		let _ = h.insert("Lar_r32_r32m16", Code::Lar_r32_r32m16);
		let _ = h.insert("Lar_r64_r64m16", Code::Lar_r64_r64m16);
		let _ = h.insert("Lsl_r16_rm16", Code::Lsl_r16_rm16);
		let _ = h.insert("Lsl_r32_r32m16", Code::Lsl_r32_r32m16);
		let _ = h.insert("Lsl_r64_r64m16", Code::Lsl_r64_r64m16);
		let _ = h.insert("Loadallreset286", Code::Loadallreset286);
		let _ = h.insert("Loadall286", Code::Loadall286);
		let _ = h.insert("Syscall", Code::Syscall);
		let _ = h.insert("Clts", Code::Clts);
		let _ = h.insert("Loadall386", Code::Loadall386);
		let _ = h.insert("Sysretd", Code::Sysretd);
		let _ = h.insert("Sysretq", Code::Sysretq);
		let _ = h.insert("Invd", Code::Invd);
		let _ = h.insert("Wbinvd", Code::Wbinvd);
		let _ = h.insert("Wbnoinvd", Code::Wbnoinvd);
		let _ = h.insert("Cl1invmb", Code::Cl1invmb);
		let _ = h.insert("Ud2", Code::Ud2);
		let _ = h.insert("Reservednop_rm16_r16_0F0D", Code::Reservednop_rm16_r16_0F0D);
		let _ = h.insert("Reservednop_rm32_r32_0F0D", Code::Reservednop_rm32_r32_0F0D);
		let _ = h.insert("Reservednop_rm64_r64_0F0D", Code::Reservednop_rm64_r64_0F0D);
		let _ = h.insert("Prefetch_m8", Code::Prefetch_m8);
		let _ = h.insert("Prefetchw_m8", Code::Prefetchw_m8);
		let _ = h.insert("Prefetchwt1_m8", Code::Prefetchwt1_m8);
		let _ = h.insert("Femms", Code::Femms);
		let _ = h.insert("Umov_rm8_r8", Code::Umov_rm8_r8);
		let _ = h.insert("Umov_rm16_r16", Code::Umov_rm16_r16);
		let _ = h.insert("Umov_rm32_r32", Code::Umov_rm32_r32);
		let _ = h.insert("Umov_r8_rm8", Code::Umov_r8_rm8);
		let _ = h.insert("Umov_r16_rm16", Code::Umov_r16_rm16);
		let _ = h.insert("Umov_r32_rm32", Code::Umov_r32_rm32);
		let _ = h.insert("Movups_xmm_xmmm128", Code::Movups_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovups_xmm_xmmm128", Code::VEX_Vmovups_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovups_ymm_ymmm256", Code::VEX_Vmovups_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovups_xmm_k1z_xmmm128", Code::EVEX_Vmovups_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovups_ymm_k1z_ymmm256", Code::EVEX_Vmovups_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovups_zmm_k1z_zmmm512", Code::EVEX_Vmovups_zmm_k1z_zmmm512);
		let _ = h.insert("Movupd_xmm_xmmm128", Code::Movupd_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovupd_xmm_xmmm128", Code::VEX_Vmovupd_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovupd_ymm_ymmm256", Code::VEX_Vmovupd_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovupd_xmm_k1z_xmmm128", Code::EVEX_Vmovupd_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovupd_ymm_k1z_ymmm256", Code::EVEX_Vmovupd_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovupd_zmm_k1z_zmmm512", Code::EVEX_Vmovupd_zmm_k1z_zmmm512);
		let _ = h.insert("Movss_xmm_xmmm32", Code::Movss_xmm_xmmm32);
		let _ = h.insert("VEX_Vmovss_xmm_xmm_xmm", Code::VEX_Vmovss_xmm_xmm_xmm);
		let _ = h.insert("VEX_Vmovss_xmm_m32", Code::VEX_Vmovss_xmm_m32);
		let _ = h.insert("EVEX_Vmovss_xmm_k1z_xmm_xmm", Code::EVEX_Vmovss_xmm_k1z_xmm_xmm);
		let _ = h.insert("EVEX_Vmovss_xmm_k1z_m32", Code::EVEX_Vmovss_xmm_k1z_m32);
		let _ = h.insert("Movsd_xmm_xmmm64", Code::Movsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vmovsd_xmm_xmm_xmm", Code::VEX_Vmovsd_xmm_xmm_xmm);
		let _ = h.insert("VEX_Vmovsd_xmm_m64", Code::VEX_Vmovsd_xmm_m64);
		let _ = h.insert("EVEX_Vmovsd_xmm_k1z_xmm_xmm", Code::EVEX_Vmovsd_xmm_k1z_xmm_xmm);
		let _ = h.insert("EVEX_Vmovsd_xmm_k1z_m64", Code::EVEX_Vmovsd_xmm_k1z_m64);
		let _ = h.insert("Movups_xmmm128_xmm", Code::Movups_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovups_xmmm128_xmm", Code::VEX_Vmovups_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovups_ymmm256_ymm", Code::VEX_Vmovups_ymmm256_ymm);
		let _ = h.insert("EVEX_Vmovups_xmmm128_k1z_xmm", Code::EVEX_Vmovups_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovups_ymmm256_k1z_ymm", Code::EVEX_Vmovups_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovups_zmmm512_k1z_zmm", Code::EVEX_Vmovups_zmmm512_k1z_zmm);
		let _ = h.insert("Movupd_xmmm128_xmm", Code::Movupd_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovupd_xmmm128_xmm", Code::VEX_Vmovupd_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovupd_ymmm256_ymm", Code::VEX_Vmovupd_ymmm256_ymm);
		let _ = h.insert("EVEX_Vmovupd_xmmm128_k1z_xmm", Code::EVEX_Vmovupd_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovupd_ymmm256_k1z_ymm", Code::EVEX_Vmovupd_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovupd_zmmm512_k1z_zmm", Code::EVEX_Vmovupd_zmmm512_k1z_zmm);
		let _ = h.insert("Movss_xmmm32_xmm", Code::Movss_xmmm32_xmm);
		let _ = h.insert("VEX_Vmovss_xmm_xmm_xmm_0F11", Code::VEX_Vmovss_xmm_xmm_xmm_0F11);
		let _ = h.insert("VEX_Vmovss_m32_xmm", Code::VEX_Vmovss_m32_xmm);
		let _ = h.insert("EVEX_Vmovss_xmm_k1z_xmm_xmm_0F11", Code::EVEX_Vmovss_xmm_k1z_xmm_xmm_0F11);
		let _ = h.insert("EVEX_Vmovss_m32_k1_xmm", Code::EVEX_Vmovss_m32_k1_xmm);
		let _ = h.insert("Movsd_xmmm64_xmm", Code::Movsd_xmmm64_xmm);
		let _ = h.insert("VEX_Vmovsd_xmm_xmm_xmm_0F11", Code::VEX_Vmovsd_xmm_xmm_xmm_0F11);
		let _ = h.insert("VEX_Vmovsd_m64_xmm", Code::VEX_Vmovsd_m64_xmm);
		let _ = h.insert("EVEX_Vmovsd_xmm_k1z_xmm_xmm_0F11", Code::EVEX_Vmovsd_xmm_k1z_xmm_xmm_0F11);
		let _ = h.insert("EVEX_Vmovsd_m64_k1_xmm", Code::EVEX_Vmovsd_m64_k1_xmm);
		let _ = h.insert("Movhlps_xmm_xmm", Code::Movhlps_xmm_xmm);
		let _ = h.insert("Movlps_xmm_m64", Code::Movlps_xmm_m64);
		let _ = h.insert("VEX_Vmovhlps_xmm_xmm_xmm", Code::VEX_Vmovhlps_xmm_xmm_xmm);
		let _ = h.insert("VEX_Vmovlps_xmm_xmm_m64", Code::VEX_Vmovlps_xmm_xmm_m64);
		let _ = h.insert("EVEX_Vmovhlps_xmm_xmm_xmm", Code::EVEX_Vmovhlps_xmm_xmm_xmm);
		let _ = h.insert("EVEX_Vmovlps_xmm_xmm_m64", Code::EVEX_Vmovlps_xmm_xmm_m64);
		let _ = h.insert("Movlpd_xmm_m64", Code::Movlpd_xmm_m64);
		let _ = h.insert("VEX_Vmovlpd_xmm_xmm_m64", Code::VEX_Vmovlpd_xmm_xmm_m64);
		let _ = h.insert("EVEX_Vmovlpd_xmm_xmm_m64", Code::EVEX_Vmovlpd_xmm_xmm_m64);
		let _ = h.insert("Movsldup_xmm_xmmm128", Code::Movsldup_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovsldup_xmm_xmmm128", Code::VEX_Vmovsldup_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovsldup_ymm_ymmm256", Code::VEX_Vmovsldup_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovsldup_xmm_k1z_xmmm128", Code::EVEX_Vmovsldup_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovsldup_ymm_k1z_ymmm256", Code::EVEX_Vmovsldup_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovsldup_zmm_k1z_zmmm512", Code::EVEX_Vmovsldup_zmm_k1z_zmmm512);
		let _ = h.insert("Movddup_xmm_xmmm64", Code::Movddup_xmm_xmmm64);
		let _ = h.insert("VEX_Vmovddup_xmm_xmmm64", Code::VEX_Vmovddup_xmm_xmmm64);
		let _ = h.insert("VEX_Vmovddup_ymm_ymmm256", Code::VEX_Vmovddup_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovddup_xmm_k1z_xmmm64", Code::EVEX_Vmovddup_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vmovddup_ymm_k1z_ymmm256", Code::EVEX_Vmovddup_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovddup_zmm_k1z_zmmm512", Code::EVEX_Vmovddup_zmm_k1z_zmmm512);
		let _ = h.insert("Movlps_m64_xmm", Code::Movlps_m64_xmm);
		let _ = h.insert("VEX_Vmovlps_m64_xmm", Code::VEX_Vmovlps_m64_xmm);
		let _ = h.insert("EVEX_Vmovlps_m64_xmm", Code::EVEX_Vmovlps_m64_xmm);
		let _ = h.insert("Movlpd_m64_xmm", Code::Movlpd_m64_xmm);
		let _ = h.insert("VEX_Vmovlpd_m64_xmm", Code::VEX_Vmovlpd_m64_xmm);
		let _ = h.insert("EVEX_Vmovlpd_m64_xmm", Code::EVEX_Vmovlpd_m64_xmm);
		let _ = h.insert("Unpcklps_xmm_xmmm128", Code::Unpcklps_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpcklps_xmm_xmm_xmmm128", Code::VEX_Vunpcklps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpcklps_ymm_ymm_ymmm256", Code::VEX_Vunpcklps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vunpcklps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vunpcklps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vunpcklps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vunpcklps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vunpcklps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vunpcklps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Unpcklpd_xmm_xmmm128", Code::Unpcklpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpcklpd_xmm_xmm_xmmm128", Code::VEX_Vunpcklpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpcklpd_ymm_ymm_ymmm256", Code::VEX_Vunpcklpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vunpcklpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vunpcklpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vunpcklpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vunpcklpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vunpcklpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vunpcklpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Unpckhps_xmm_xmmm128", Code::Unpckhps_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpckhps_xmm_xmm_xmmm128", Code::VEX_Vunpckhps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpckhps_ymm_ymm_ymmm256", Code::VEX_Vunpckhps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vunpckhps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vunpckhps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vunpckhps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vunpckhps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vunpckhps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vunpckhps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Unpckhpd_xmm_xmmm128", Code::Unpckhpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpckhpd_xmm_xmm_xmmm128", Code::VEX_Vunpckhpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vunpckhpd_ymm_ymm_ymmm256", Code::VEX_Vunpckhpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vunpckhpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vunpckhpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vunpckhpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vunpckhpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vunpckhpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vunpckhpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Movlhps_xmm_xmm", Code::Movlhps_xmm_xmm);
		let _ = h.insert("VEX_Vmovlhps_xmm_xmm_xmm", Code::VEX_Vmovlhps_xmm_xmm_xmm);
		let _ = h.insert("EVEX_Vmovlhps_xmm_xmm_xmm", Code::EVEX_Vmovlhps_xmm_xmm_xmm);
		let _ = h.insert("Movhps_xmm_m64", Code::Movhps_xmm_m64);
		let _ = h.insert("VEX_Vmovhps_xmm_xmm_m64", Code::VEX_Vmovhps_xmm_xmm_m64);
		let _ = h.insert("EVEX_Vmovhps_xmm_xmm_m64", Code::EVEX_Vmovhps_xmm_xmm_m64);
		let _ = h.insert("Movhpd_xmm_m64", Code::Movhpd_xmm_m64);
		let _ = h.insert("VEX_Vmovhpd_xmm_xmm_m64", Code::VEX_Vmovhpd_xmm_xmm_m64);
		let _ = h.insert("EVEX_Vmovhpd_xmm_xmm_m64", Code::EVEX_Vmovhpd_xmm_xmm_m64);
		let _ = h.insert("Movshdup_xmm_xmmm128", Code::Movshdup_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovshdup_xmm_xmmm128", Code::VEX_Vmovshdup_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovshdup_ymm_ymmm256", Code::VEX_Vmovshdup_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovshdup_xmm_k1z_xmmm128", Code::EVEX_Vmovshdup_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovshdup_ymm_k1z_ymmm256", Code::EVEX_Vmovshdup_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovshdup_zmm_k1z_zmmm512", Code::EVEX_Vmovshdup_zmm_k1z_zmmm512);
		let _ = h.insert("Movhps_m64_xmm", Code::Movhps_m64_xmm);
		let _ = h.insert("VEX_Vmovhps_m64_xmm", Code::VEX_Vmovhps_m64_xmm);
		let _ = h.insert("EVEX_Vmovhps_m64_xmm", Code::EVEX_Vmovhps_m64_xmm);
		let _ = h.insert("Movhpd_m64_xmm", Code::Movhpd_m64_xmm);
		let _ = h.insert("VEX_Vmovhpd_m64_xmm", Code::VEX_Vmovhpd_m64_xmm);
		let _ = h.insert("EVEX_Vmovhpd_m64_xmm", Code::EVEX_Vmovhpd_m64_xmm);
		let _ = h.insert("Reservednop_rm16_r16_0F18", Code::Reservednop_rm16_r16_0F18);
		let _ = h.insert("Reservednop_rm32_r32_0F18", Code::Reservednop_rm32_r32_0F18);
		let _ = h.insert("Reservednop_rm64_r64_0F18", Code::Reservednop_rm64_r64_0F18);
		let _ = h.insert("Reservednop_rm16_r16_0F19", Code::Reservednop_rm16_r16_0F19);
		let _ = h.insert("Reservednop_rm32_r32_0F19", Code::Reservednop_rm32_r32_0F19);
		let _ = h.insert("Reservednop_rm64_r64_0F19", Code::Reservednop_rm64_r64_0F19);
		let _ = h.insert("Reservednop_rm16_r16_0F1A", Code::Reservednop_rm16_r16_0F1A);
		let _ = h.insert("Reservednop_rm32_r32_0F1A", Code::Reservednop_rm32_r32_0F1A);
		let _ = h.insert("Reservednop_rm64_r64_0F1A", Code::Reservednop_rm64_r64_0F1A);
		let _ = h.insert("Reservednop_rm16_r16_0F1B", Code::Reservednop_rm16_r16_0F1B);
		let _ = h.insert("Reservednop_rm32_r32_0F1B", Code::Reservednop_rm32_r32_0F1B);
		let _ = h.insert("Reservednop_rm64_r64_0F1B", Code::Reservednop_rm64_r64_0F1B);
		let _ = h.insert("Reservednop_rm16_r16_0F1C", Code::Reservednop_rm16_r16_0F1C);
		let _ = h.insert("Reservednop_rm32_r32_0F1C", Code::Reservednop_rm32_r32_0F1C);
		let _ = h.insert("Reservednop_rm64_r64_0F1C", Code::Reservednop_rm64_r64_0F1C);
		let _ = h.insert("Reservednop_rm16_r16_0F1D", Code::Reservednop_rm16_r16_0F1D);
		let _ = h.insert("Reservednop_rm32_r32_0F1D", Code::Reservednop_rm32_r32_0F1D);
		let _ = h.insert("Reservednop_rm64_r64_0F1D", Code::Reservednop_rm64_r64_0F1D);
		let _ = h.insert("Reservednop_rm16_r16_0F1E", Code::Reservednop_rm16_r16_0F1E);
		let _ = h.insert("Reservednop_rm32_r32_0F1E", Code::Reservednop_rm32_r32_0F1E);
		let _ = h.insert("Reservednop_rm64_r64_0F1E", Code::Reservednop_rm64_r64_0F1E);
		let _ = h.insert("Reservednop_rm16_r16_0F1F", Code::Reservednop_rm16_r16_0F1F);
		let _ = h.insert("Reservednop_rm32_r32_0F1F", Code::Reservednop_rm32_r32_0F1F);
		let _ = h.insert("Reservednop_rm64_r64_0F1F", Code::Reservednop_rm64_r64_0F1F);
		let _ = h.insert("Prefetchnta_m8", Code::Prefetchnta_m8);
		let _ = h.insert("Prefetcht0_m8", Code::Prefetcht0_m8);
		let _ = h.insert("Prefetcht1_m8", Code::Prefetcht1_m8);
		let _ = h.insert("Prefetcht2_m8", Code::Prefetcht2_m8);
		let _ = h.insert("Bndldx_bnd_mib", Code::Bndldx_bnd_mib);
		let _ = h.insert("Bndmov_bnd_bndm64", Code::Bndmov_bnd_bndm64);
		let _ = h.insert("Bndmov_bnd_bndm128", Code::Bndmov_bnd_bndm128);
		let _ = h.insert("Bndcl_bnd_rm32", Code::Bndcl_bnd_rm32);
		let _ = h.insert("Bndcl_bnd_rm64", Code::Bndcl_bnd_rm64);
		let _ = h.insert("Bndcu_bnd_rm32", Code::Bndcu_bnd_rm32);
		let _ = h.insert("Bndcu_bnd_rm64", Code::Bndcu_bnd_rm64);
		let _ = h.insert("Bndstx_mib_bnd", Code::Bndstx_mib_bnd);
		let _ = h.insert("Bndmov_bndm64_bnd", Code::Bndmov_bndm64_bnd);
		let _ = h.insert("Bndmov_bndm128_bnd", Code::Bndmov_bndm128_bnd);
		let _ = h.insert("Bndmk_bnd_m32", Code::Bndmk_bnd_m32);
		let _ = h.insert("Bndmk_bnd_m64", Code::Bndmk_bnd_m64);
		let _ = h.insert("Bndcn_bnd_rm32", Code::Bndcn_bnd_rm32);
		let _ = h.insert("Bndcn_bnd_rm64", Code::Bndcn_bnd_rm64);
		let _ = h.insert("Cldemote_m8", Code::Cldemote_m8);
		let _ = h.insert("Rdsspd_r32", Code::Rdsspd_r32);
		let _ = h.insert("Rdsspq_r64", Code::Rdsspq_r64);
		let _ = h.insert("Endbr64", Code::Endbr64);
		let _ = h.insert("Endbr32", Code::Endbr32);
		let _ = h.insert("Nop_rm16", Code::Nop_rm16);
		let _ = h.insert("Nop_rm32", Code::Nop_rm32);
		let _ = h.insert("Nop_rm64", Code::Nop_rm64);
		let _ = h.insert("Mov_r32_cr", Code::Mov_r32_cr);
		let _ = h.insert("Mov_r64_cr", Code::Mov_r64_cr);
		let _ = h.insert("Mov_r32_dr", Code::Mov_r32_dr);
		let _ = h.insert("Mov_r64_dr", Code::Mov_r64_dr);
		let _ = h.insert("Mov_cr_r32", Code::Mov_cr_r32);
		let _ = h.insert("Mov_cr_r64", Code::Mov_cr_r64);
		let _ = h.insert("Mov_dr_r32", Code::Mov_dr_r32);
		let _ = h.insert("Mov_dr_r64", Code::Mov_dr_r64);
		let _ = h.insert("Mov_r32_tr", Code::Mov_r32_tr);
		let _ = h.insert("Mov_tr_r32", Code::Mov_tr_r32);
		let _ = h.insert("Movaps_xmm_xmmm128", Code::Movaps_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovaps_xmm_xmmm128", Code::VEX_Vmovaps_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovaps_ymm_ymmm256", Code::VEX_Vmovaps_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovaps_xmm_k1z_xmmm128", Code::EVEX_Vmovaps_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovaps_ymm_k1z_ymmm256", Code::EVEX_Vmovaps_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovaps_zmm_k1z_zmmm512", Code::EVEX_Vmovaps_zmm_k1z_zmmm512);
		let _ = h.insert("Movapd_xmm_xmmm128", Code::Movapd_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovapd_xmm_xmmm128", Code::VEX_Vmovapd_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovapd_ymm_ymmm256", Code::VEX_Vmovapd_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovapd_xmm_k1z_xmmm128", Code::EVEX_Vmovapd_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovapd_ymm_k1z_ymmm256", Code::EVEX_Vmovapd_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovapd_zmm_k1z_zmmm512", Code::EVEX_Vmovapd_zmm_k1z_zmmm512);
		let _ = h.insert("Movaps_xmmm128_xmm", Code::Movaps_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovaps_xmmm128_xmm", Code::VEX_Vmovaps_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovaps_ymmm256_ymm", Code::VEX_Vmovaps_ymmm256_ymm);
		let _ = h.insert("EVEX_Vmovaps_xmmm128_k1z_xmm", Code::EVEX_Vmovaps_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovaps_ymmm256_k1z_ymm", Code::EVEX_Vmovaps_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovaps_zmmm512_k1z_zmm", Code::EVEX_Vmovaps_zmmm512_k1z_zmm);
		let _ = h.insert("Movapd_xmmm128_xmm", Code::Movapd_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovapd_xmmm128_xmm", Code::VEX_Vmovapd_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovapd_ymmm256_ymm", Code::VEX_Vmovapd_ymmm256_ymm);
		let _ = h.insert("EVEX_Vmovapd_xmmm128_k1z_xmm", Code::EVEX_Vmovapd_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovapd_ymmm256_k1z_ymm", Code::EVEX_Vmovapd_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovapd_zmmm512_k1z_zmm", Code::EVEX_Vmovapd_zmmm512_k1z_zmm);
		let _ = h.insert("Cvtpi2ps_xmm_mmm64", Code::Cvtpi2ps_xmm_mmm64);
		let _ = h.insert("Cvtpi2pd_xmm_mmm64", Code::Cvtpi2pd_xmm_mmm64);
		let _ = h.insert("Cvtsi2ss_xmm_rm32", Code::Cvtsi2ss_xmm_rm32);
		let _ = h.insert("Cvtsi2ss_xmm_rm64", Code::Cvtsi2ss_xmm_rm64);
		let _ = h.insert("VEX_Vcvtsi2ss_xmm_xmm_rm32", Code::VEX_Vcvtsi2ss_xmm_xmm_rm32);
		let _ = h.insert("VEX_Vcvtsi2ss_xmm_xmm_rm64", Code::VEX_Vcvtsi2ss_xmm_xmm_rm64);
		let _ = h.insert("EVEX_Vcvtsi2ss_xmm_xmm_rm32_er", Code::EVEX_Vcvtsi2ss_xmm_xmm_rm32_er);
		let _ = h.insert("EVEX_Vcvtsi2ss_xmm_xmm_rm64_er", Code::EVEX_Vcvtsi2ss_xmm_xmm_rm64_er);
		let _ = h.insert("Cvtsi2sd_xmm_rm32", Code::Cvtsi2sd_xmm_rm32);
		let _ = h.insert("Cvtsi2sd_xmm_rm64", Code::Cvtsi2sd_xmm_rm64);
		let _ = h.insert("VEX_Vcvtsi2sd_xmm_xmm_rm32", Code::VEX_Vcvtsi2sd_xmm_xmm_rm32);
		let _ = h.insert("VEX_Vcvtsi2sd_xmm_xmm_rm64", Code::VEX_Vcvtsi2sd_xmm_xmm_rm64);
		let _ = h.insert("EVEX_Vcvtsi2sd_xmm_xmm_rm32_er", Code::EVEX_Vcvtsi2sd_xmm_xmm_rm32_er);
		let _ = h.insert("EVEX_Vcvtsi2sd_xmm_xmm_rm64_er", Code::EVEX_Vcvtsi2sd_xmm_xmm_rm64_er);
		let _ = h.insert("Movntps_m128_xmm", Code::Movntps_m128_xmm);
		let _ = h.insert("VEX_Vmovntps_m128_xmm", Code::VEX_Vmovntps_m128_xmm);
		let _ = h.insert("VEX_Vmovntps_m256_ymm", Code::VEX_Vmovntps_m256_ymm);
		let _ = h.insert("EVEX_Vmovntps_m128_xmm", Code::EVEX_Vmovntps_m128_xmm);
		let _ = h.insert("EVEX_Vmovntps_m256_ymm", Code::EVEX_Vmovntps_m256_ymm);
		let _ = h.insert("EVEX_Vmovntps_m512_zmm", Code::EVEX_Vmovntps_m512_zmm);
		let _ = h.insert("Movntpd_m128_xmm", Code::Movntpd_m128_xmm);
		let _ = h.insert("VEX_Vmovntpd_m128_xmm", Code::VEX_Vmovntpd_m128_xmm);
		let _ = h.insert("VEX_Vmovntpd_m256_ymm", Code::VEX_Vmovntpd_m256_ymm);
		let _ = h.insert("EVEX_Vmovntpd_m128_xmm", Code::EVEX_Vmovntpd_m128_xmm);
		let _ = h.insert("EVEX_Vmovntpd_m256_ymm", Code::EVEX_Vmovntpd_m256_ymm);
		let _ = h.insert("EVEX_Vmovntpd_m512_zmm", Code::EVEX_Vmovntpd_m512_zmm);
		let _ = h.insert("Movntss_m32_xmm", Code::Movntss_m32_xmm);
		let _ = h.insert("Movntsd_m64_xmm", Code::Movntsd_m64_xmm);
		let _ = h.insert("Cvttps2pi_mm_xmmm64", Code::Cvttps2pi_mm_xmmm64);
		let _ = h.insert("Cvttpd2pi_mm_xmmm128", Code::Cvttpd2pi_mm_xmmm128);
		let _ = h.insert("Cvttss2si_r32_xmmm32", Code::Cvttss2si_r32_xmmm32);
		let _ = h.insert("Cvttss2si_r64_xmmm32", Code::Cvttss2si_r64_xmmm32);
		let _ = h.insert("VEX_Vcvttss2si_r32_xmmm32", Code::VEX_Vcvttss2si_r32_xmmm32);
		let _ = h.insert("VEX_Vcvttss2si_r64_xmmm32", Code::VEX_Vcvttss2si_r64_xmmm32);
		let _ = h.insert("EVEX_Vcvttss2si_r32_xmmm32_sae", Code::EVEX_Vcvttss2si_r32_xmmm32_sae);
		let _ = h.insert("EVEX_Vcvttss2si_r64_xmmm32_sae", Code::EVEX_Vcvttss2si_r64_xmmm32_sae);
		let _ = h.insert("Cvttsd2si_r32_xmmm64", Code::Cvttsd2si_r32_xmmm64);
		let _ = h.insert("Cvttsd2si_r64_xmmm64", Code::Cvttsd2si_r64_xmmm64);
		let _ = h.insert("VEX_Vcvttsd2si_r32_xmmm64", Code::VEX_Vcvttsd2si_r32_xmmm64);
		let _ = h.insert("VEX_Vcvttsd2si_r64_xmmm64", Code::VEX_Vcvttsd2si_r64_xmmm64);
		let _ = h.insert("EVEX_Vcvttsd2si_r32_xmmm64_sae", Code::EVEX_Vcvttsd2si_r32_xmmm64_sae);
		let _ = h.insert("EVEX_Vcvttsd2si_r64_xmmm64_sae", Code::EVEX_Vcvttsd2si_r64_xmmm64_sae);
		let _ = h.insert("Cvtps2pi_mm_xmmm64", Code::Cvtps2pi_mm_xmmm64);
		let _ = h.insert("Cvtpd2pi_mm_xmmm128", Code::Cvtpd2pi_mm_xmmm128);
		let _ = h.insert("Cvtss2si_r32_xmmm32", Code::Cvtss2si_r32_xmmm32);
		let _ = h.insert("Cvtss2si_r64_xmmm32", Code::Cvtss2si_r64_xmmm32);
		let _ = h.insert("VEX_Vcvtss2si_r32_xmmm32", Code::VEX_Vcvtss2si_r32_xmmm32);
		let _ = h.insert("VEX_Vcvtss2si_r64_xmmm32", Code::VEX_Vcvtss2si_r64_xmmm32);
		let _ = h.insert("EVEX_Vcvtss2si_r32_xmmm32_er", Code::EVEX_Vcvtss2si_r32_xmmm32_er);
		let _ = h.insert("EVEX_Vcvtss2si_r64_xmmm32_er", Code::EVEX_Vcvtss2si_r64_xmmm32_er);
		let _ = h.insert("Cvtsd2si_r32_xmmm64", Code::Cvtsd2si_r32_xmmm64);
		let _ = h.insert("Cvtsd2si_r64_xmmm64", Code::Cvtsd2si_r64_xmmm64);
		let _ = h.insert("VEX_Vcvtsd2si_r32_xmmm64", Code::VEX_Vcvtsd2si_r32_xmmm64);
		let _ = h.insert("VEX_Vcvtsd2si_r64_xmmm64", Code::VEX_Vcvtsd2si_r64_xmmm64);
		let _ = h.insert("EVEX_Vcvtsd2si_r32_xmmm64_er", Code::EVEX_Vcvtsd2si_r32_xmmm64_er);
		let _ = h.insert("EVEX_Vcvtsd2si_r64_xmmm64_er", Code::EVEX_Vcvtsd2si_r64_xmmm64_er);
		let _ = h.insert("Ucomiss_xmm_xmmm32", Code::Ucomiss_xmm_xmmm32);
		let _ = h.insert("VEX_Vucomiss_xmm_xmmm32", Code::VEX_Vucomiss_xmm_xmmm32);
		let _ = h.insert("EVEX_Vucomiss_xmm_xmmm32_sae", Code::EVEX_Vucomiss_xmm_xmmm32_sae);
		let _ = h.insert("Ucomisd_xmm_xmmm64", Code::Ucomisd_xmm_xmmm64);
		let _ = h.insert("VEX_Vucomisd_xmm_xmmm64", Code::VEX_Vucomisd_xmm_xmmm64);
		let _ = h.insert("EVEX_Vucomisd_xmm_xmmm64_sae", Code::EVEX_Vucomisd_xmm_xmmm64_sae);
		let _ = h.insert("Comiss_xmm_xmmm32", Code::Comiss_xmm_xmmm32);
		let _ = h.insert("Comisd_xmm_xmmm64", Code::Comisd_xmm_xmmm64);
		let _ = h.insert("VEX_Vcomiss_xmm_xmmm32", Code::VEX_Vcomiss_xmm_xmmm32);
		let _ = h.insert("VEX_Vcomisd_xmm_xmmm64", Code::VEX_Vcomisd_xmm_xmmm64);
		let _ = h.insert("EVEX_Vcomiss_xmm_xmmm32_sae", Code::EVEX_Vcomiss_xmm_xmmm32_sae);
		let _ = h.insert("EVEX_Vcomisd_xmm_xmmm64_sae", Code::EVEX_Vcomisd_xmm_xmmm64_sae);
		let _ = h.insert("Wrmsr", Code::Wrmsr);
		let _ = h.insert("Rdtsc", Code::Rdtsc);
		let _ = h.insert("Rdmsr", Code::Rdmsr);
		let _ = h.insert("Rdpmc", Code::Rdpmc);
		let _ = h.insert("Sysenter", Code::Sysenter);
		let _ = h.insert("Sysexitd", Code::Sysexitd);
		let _ = h.insert("Sysexitq", Code::Sysexitq);
		let _ = h.insert("Getsecd", Code::Getsecd);
		let _ = h.insert("Cmovo_r16_rm16", Code::Cmovo_r16_rm16);
		let _ = h.insert("Cmovo_r32_rm32", Code::Cmovo_r32_rm32);
		let _ = h.insert("Cmovo_r64_rm64", Code::Cmovo_r64_rm64);
		let _ = h.insert("Cmovno_r16_rm16", Code::Cmovno_r16_rm16);
		let _ = h.insert("Cmovno_r32_rm32", Code::Cmovno_r32_rm32);
		let _ = h.insert("Cmovno_r64_rm64", Code::Cmovno_r64_rm64);
		let _ = h.insert("Cmovb_r16_rm16", Code::Cmovb_r16_rm16);
		let _ = h.insert("Cmovb_r32_rm32", Code::Cmovb_r32_rm32);
		let _ = h.insert("Cmovb_r64_rm64", Code::Cmovb_r64_rm64);
		let _ = h.insert("Cmovae_r16_rm16", Code::Cmovae_r16_rm16);
		let _ = h.insert("Cmovae_r32_rm32", Code::Cmovae_r32_rm32);
		let _ = h.insert("Cmovae_r64_rm64", Code::Cmovae_r64_rm64);
		let _ = h.insert("Cmove_r16_rm16", Code::Cmove_r16_rm16);
		let _ = h.insert("Cmove_r32_rm32", Code::Cmove_r32_rm32);
		let _ = h.insert("Cmove_r64_rm64", Code::Cmove_r64_rm64);
		let _ = h.insert("Cmovne_r16_rm16", Code::Cmovne_r16_rm16);
		let _ = h.insert("Cmovne_r32_rm32", Code::Cmovne_r32_rm32);
		let _ = h.insert("Cmovne_r64_rm64", Code::Cmovne_r64_rm64);
		let _ = h.insert("Cmovbe_r16_rm16", Code::Cmovbe_r16_rm16);
		let _ = h.insert("Cmovbe_r32_rm32", Code::Cmovbe_r32_rm32);
		let _ = h.insert("Cmovbe_r64_rm64", Code::Cmovbe_r64_rm64);
		let _ = h.insert("Cmova_r16_rm16", Code::Cmova_r16_rm16);
		let _ = h.insert("Cmova_r32_rm32", Code::Cmova_r32_rm32);
		let _ = h.insert("Cmova_r64_rm64", Code::Cmova_r64_rm64);
		let _ = h.insert("Cmovs_r16_rm16", Code::Cmovs_r16_rm16);
		let _ = h.insert("Cmovs_r32_rm32", Code::Cmovs_r32_rm32);
		let _ = h.insert("Cmovs_r64_rm64", Code::Cmovs_r64_rm64);
		let _ = h.insert("Cmovns_r16_rm16", Code::Cmovns_r16_rm16);
		let _ = h.insert("Cmovns_r32_rm32", Code::Cmovns_r32_rm32);
		let _ = h.insert("Cmovns_r64_rm64", Code::Cmovns_r64_rm64);
		let _ = h.insert("Cmovp_r16_rm16", Code::Cmovp_r16_rm16);
		let _ = h.insert("Cmovp_r32_rm32", Code::Cmovp_r32_rm32);
		let _ = h.insert("Cmovp_r64_rm64", Code::Cmovp_r64_rm64);
		let _ = h.insert("Cmovnp_r16_rm16", Code::Cmovnp_r16_rm16);
		let _ = h.insert("Cmovnp_r32_rm32", Code::Cmovnp_r32_rm32);
		let _ = h.insert("Cmovnp_r64_rm64", Code::Cmovnp_r64_rm64);
		let _ = h.insert("Cmovl_r16_rm16", Code::Cmovl_r16_rm16);
		let _ = h.insert("Cmovl_r32_rm32", Code::Cmovl_r32_rm32);
		let _ = h.insert("Cmovl_r64_rm64", Code::Cmovl_r64_rm64);
		let _ = h.insert("Cmovge_r16_rm16", Code::Cmovge_r16_rm16);
		let _ = h.insert("Cmovge_r32_rm32", Code::Cmovge_r32_rm32);
		let _ = h.insert("Cmovge_r64_rm64", Code::Cmovge_r64_rm64);
		let _ = h.insert("Cmovle_r16_rm16", Code::Cmovle_r16_rm16);
		let _ = h.insert("Cmovle_r32_rm32", Code::Cmovle_r32_rm32);
		let _ = h.insert("Cmovle_r64_rm64", Code::Cmovle_r64_rm64);
		let _ = h.insert("Cmovg_r16_rm16", Code::Cmovg_r16_rm16);
		let _ = h.insert("Cmovg_r32_rm32", Code::Cmovg_r32_rm32);
		let _ = h.insert("Cmovg_r64_rm64", Code::Cmovg_r64_rm64);
		let _ = h.insert("VEX_Kandw_kr_kr_kr", Code::VEX_Kandw_kr_kr_kr);
		let _ = h.insert("VEX_Kandq_kr_kr_kr", Code::VEX_Kandq_kr_kr_kr);
		let _ = h.insert("VEX_Kandb_kr_kr_kr", Code::VEX_Kandb_kr_kr_kr);
		let _ = h.insert("VEX_Kandd_kr_kr_kr", Code::VEX_Kandd_kr_kr_kr);
		let _ = h.insert("VEX_Kandnw_kr_kr_kr", Code::VEX_Kandnw_kr_kr_kr);
		let _ = h.insert("VEX_Kandnq_kr_kr_kr", Code::VEX_Kandnq_kr_kr_kr);
		let _ = h.insert("VEX_Kandnb_kr_kr_kr", Code::VEX_Kandnb_kr_kr_kr);
		let _ = h.insert("VEX_Kandnd_kr_kr_kr", Code::VEX_Kandnd_kr_kr_kr);
		let _ = h.insert("VEX_Knotw_kr_kr", Code::VEX_Knotw_kr_kr);
		let _ = h.insert("VEX_Knotq_kr_kr", Code::VEX_Knotq_kr_kr);
		let _ = h.insert("VEX_Knotb_kr_kr", Code::VEX_Knotb_kr_kr);
		let _ = h.insert("VEX_Knotd_kr_kr", Code::VEX_Knotd_kr_kr);
		let _ = h.insert("VEX_Korw_kr_kr_kr", Code::VEX_Korw_kr_kr_kr);
		let _ = h.insert("VEX_Korq_kr_kr_kr", Code::VEX_Korq_kr_kr_kr);
		let _ = h.insert("VEX_Korb_kr_kr_kr", Code::VEX_Korb_kr_kr_kr);
		let _ = h.insert("VEX_Kord_kr_kr_kr", Code::VEX_Kord_kr_kr_kr);
		let _ = h.insert("VEX_Kxnorw_kr_kr_kr", Code::VEX_Kxnorw_kr_kr_kr);
		let _ = h.insert("VEX_Kxnorq_kr_kr_kr", Code::VEX_Kxnorq_kr_kr_kr);
		let _ = h.insert("VEX_Kxnorb_kr_kr_kr", Code::VEX_Kxnorb_kr_kr_kr);
		let _ = h.insert("VEX_Kxnord_kr_kr_kr", Code::VEX_Kxnord_kr_kr_kr);
		let _ = h.insert("VEX_Kxorw_kr_kr_kr", Code::VEX_Kxorw_kr_kr_kr);
		let _ = h.insert("VEX_Kxorq_kr_kr_kr", Code::VEX_Kxorq_kr_kr_kr);
		let _ = h.insert("VEX_Kxorb_kr_kr_kr", Code::VEX_Kxorb_kr_kr_kr);
		let _ = h.insert("VEX_Kxord_kr_kr_kr", Code::VEX_Kxord_kr_kr_kr);
		let _ = h.insert("VEX_Kaddw_kr_kr_kr", Code::VEX_Kaddw_kr_kr_kr);
		let _ = h.insert("VEX_Kaddq_kr_kr_kr", Code::VEX_Kaddq_kr_kr_kr);
		let _ = h.insert("VEX_Kaddb_kr_kr_kr", Code::VEX_Kaddb_kr_kr_kr);
		let _ = h.insert("VEX_Kaddd_kr_kr_kr", Code::VEX_Kaddd_kr_kr_kr);
		let _ = h.insert("VEX_Kunpckwd_kr_kr_kr", Code::VEX_Kunpckwd_kr_kr_kr);
		let _ = h.insert("VEX_Kunpckdq_kr_kr_kr", Code::VEX_Kunpckdq_kr_kr_kr);
		let _ = h.insert("VEX_Kunpckbw_kr_kr_kr", Code::VEX_Kunpckbw_kr_kr_kr);
		let _ = h.insert("Movmskps_r32_xmm", Code::Movmskps_r32_xmm);
		let _ = h.insert("Movmskps_r64_xmm", Code::Movmskps_r64_xmm);
		let _ = h.insert("VEX_Vmovmskps_r32_xmm", Code::VEX_Vmovmskps_r32_xmm);
		let _ = h.insert("VEX_Vmovmskps_r64_xmm", Code::VEX_Vmovmskps_r64_xmm);
		let _ = h.insert("VEX_Vmovmskps_r32_ymm", Code::VEX_Vmovmskps_r32_ymm);
		let _ = h.insert("VEX_Vmovmskps_r64_ymm", Code::VEX_Vmovmskps_r64_ymm);
		let _ = h.insert("Movmskpd_r32_xmm", Code::Movmskpd_r32_xmm);
		let _ = h.insert("Movmskpd_r64_xmm", Code::Movmskpd_r64_xmm);
		let _ = h.insert("VEX_Vmovmskpd_r32_xmm", Code::VEX_Vmovmskpd_r32_xmm);
		let _ = h.insert("VEX_Vmovmskpd_r64_xmm", Code::VEX_Vmovmskpd_r64_xmm);
		let _ = h.insert("VEX_Vmovmskpd_r32_ymm", Code::VEX_Vmovmskpd_r32_ymm);
		let _ = h.insert("VEX_Vmovmskpd_r64_ymm", Code::VEX_Vmovmskpd_r64_ymm);
		let _ = h.insert("Sqrtps_xmm_xmmm128", Code::Sqrtps_xmm_xmmm128);
		let _ = h.insert("VEX_Vsqrtps_xmm_xmmm128", Code::VEX_Vsqrtps_xmm_xmmm128);
		let _ = h.insert("VEX_Vsqrtps_ymm_ymmm256", Code::VEX_Vsqrtps_ymm_ymmm256);
		let _ = h.insert("EVEX_Vsqrtps_xmm_k1z_xmmm128b32", Code::EVEX_Vsqrtps_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vsqrtps_ymm_k1z_ymmm256b32", Code::EVEX_Vsqrtps_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vsqrtps_zmm_k1z_zmmm512b32_er", Code::EVEX_Vsqrtps_zmm_k1z_zmmm512b32_er);
		let _ = h.insert("Sqrtpd_xmm_xmmm128", Code::Sqrtpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vsqrtpd_xmm_xmmm128", Code::VEX_Vsqrtpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vsqrtpd_ymm_ymmm256", Code::VEX_Vsqrtpd_ymm_ymmm256);
		let _ = h.insert("EVEX_Vsqrtpd_xmm_k1z_xmmm128b64", Code::EVEX_Vsqrtpd_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vsqrtpd_ymm_k1z_ymmm256b64", Code::EVEX_Vsqrtpd_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vsqrtpd_zmm_k1z_zmmm512b64_er", Code::EVEX_Vsqrtpd_zmm_k1z_zmmm512b64_er);
		let _ = h.insert("Sqrtss_xmm_xmmm32", Code::Sqrtss_xmm_xmmm32);
		let _ = h.insert("VEX_Vsqrtss_xmm_xmm_xmmm32", Code::VEX_Vsqrtss_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vsqrtss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vsqrtss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("Sqrtsd_xmm_xmmm64", Code::Sqrtsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vsqrtsd_xmm_xmm_xmmm64", Code::VEX_Vsqrtsd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vsqrtsd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vsqrtsd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("Rsqrtps_xmm_xmmm128", Code::Rsqrtps_xmm_xmmm128);
		let _ = h.insert("VEX_Vrsqrtps_xmm_xmmm128", Code::VEX_Vrsqrtps_xmm_xmmm128);
		let _ = h.insert("VEX_Vrsqrtps_ymm_ymmm256", Code::VEX_Vrsqrtps_ymm_ymmm256);
		let _ = h.insert("Rsqrtss_xmm_xmmm32", Code::Rsqrtss_xmm_xmmm32);
		let _ = h.insert("VEX_Vrsqrtss_xmm_xmm_xmmm32", Code::VEX_Vrsqrtss_xmm_xmm_xmmm32);
		let _ = h.insert("Rcpps_xmm_xmmm128", Code::Rcpps_xmm_xmmm128);
		let _ = h.insert("VEX_Vrcpps_xmm_xmmm128", Code::VEX_Vrcpps_xmm_xmmm128);
		let _ = h.insert("VEX_Vrcpps_ymm_ymmm256", Code::VEX_Vrcpps_ymm_ymmm256);
		let _ = h.insert("Rcpss_xmm_xmmm32", Code::Rcpss_xmm_xmmm32);
		let _ = h.insert("VEX_Vrcpss_xmm_xmm_xmmm32", Code::VEX_Vrcpss_xmm_xmm_xmmm32);
		let _ = h.insert("Andps_xmm_xmmm128", Code::Andps_xmm_xmmm128);
		let _ = h.insert("VEX_Vandps_xmm_xmm_xmmm128", Code::VEX_Vandps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vandps_ymm_ymm_ymmm256", Code::VEX_Vandps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vandps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vandps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vandps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vandps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vandps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vandps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Andpd_xmm_xmmm128", Code::Andpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vandpd_xmm_xmm_xmmm128", Code::VEX_Vandpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vandpd_ymm_ymm_ymmm256", Code::VEX_Vandpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vandpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vandpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vandpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vandpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vandpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vandpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Andnps_xmm_xmmm128", Code::Andnps_xmm_xmmm128);
		let _ = h.insert("VEX_Vandnps_xmm_xmm_xmmm128", Code::VEX_Vandnps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vandnps_ymm_ymm_ymmm256", Code::VEX_Vandnps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vandnps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vandnps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vandnps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vandnps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vandnps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vandnps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Andnpd_xmm_xmmm128", Code::Andnpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vandnpd_xmm_xmm_xmmm128", Code::VEX_Vandnpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vandnpd_ymm_ymm_ymmm256", Code::VEX_Vandnpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vandnpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vandnpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vandnpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vandnpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vandnpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vandnpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Orps_xmm_xmmm128", Code::Orps_xmm_xmmm128);
		let _ = h.insert("VEX_Vorps_xmm_xmm_xmmm128", Code::VEX_Vorps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vorps_ymm_ymm_ymmm256", Code::VEX_Vorps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vorps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vorps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vorps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vorps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vorps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vorps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Orpd_xmm_xmmm128", Code::Orpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vorpd_xmm_xmm_xmmm128", Code::VEX_Vorpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vorpd_ymm_ymm_ymmm256", Code::VEX_Vorpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vorpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vorpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vorpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vorpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vorpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vorpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Xorps_xmm_xmmm128", Code::Xorps_xmm_xmmm128);
		let _ = h.insert("VEX_Vxorps_xmm_xmm_xmmm128", Code::VEX_Vxorps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vxorps_ymm_ymm_ymmm256", Code::VEX_Vxorps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vxorps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vxorps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vxorps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vxorps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vxorps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vxorps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Xorpd_xmm_xmmm128", Code::Xorpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vxorpd_xmm_xmm_xmmm128", Code::VEX_Vxorpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vxorpd_ymm_ymm_ymmm256", Code::VEX_Vxorpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vxorpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vxorpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vxorpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vxorpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vxorpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vxorpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Addps_xmm_xmmm128", Code::Addps_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddps_xmm_xmm_xmmm128", Code::VEX_Vaddps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddps_ymm_ymm_ymmm256", Code::VEX_Vaddps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaddps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vaddps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vaddps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vaddps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vaddps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vaddps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("Addpd_xmm_xmmm128", Code::Addpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddpd_xmm_xmm_xmmm128", Code::VEX_Vaddpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddpd_ymm_ymm_ymmm256", Code::VEX_Vaddpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaddpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vaddpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vaddpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vaddpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vaddpd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vaddpd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("Addss_xmm_xmmm32", Code::Addss_xmm_xmmm32);
		let _ = h.insert("VEX_Vaddss_xmm_xmm_xmmm32", Code::VEX_Vaddss_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vaddss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vaddss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("Addsd_xmm_xmmm64", Code::Addsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vaddsd_xmm_xmm_xmmm64", Code::VEX_Vaddsd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vaddsd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vaddsd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("Mulps_xmm_xmmm128", Code::Mulps_xmm_xmmm128);
		let _ = h.insert("VEX_Vmulps_xmm_xmm_xmmm128", Code::VEX_Vmulps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vmulps_ymm_ymm_ymmm256", Code::VEX_Vmulps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmulps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vmulps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vmulps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vmulps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vmulps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vmulps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("Mulpd_xmm_xmmm128", Code::Mulpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vmulpd_xmm_xmm_xmmm128", Code::VEX_Vmulpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vmulpd_ymm_ymm_ymmm256", Code::VEX_Vmulpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmulpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vmulpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vmulpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vmulpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vmulpd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vmulpd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("Mulss_xmm_xmmm32", Code::Mulss_xmm_xmmm32);
		let _ = h.insert("VEX_Vmulss_xmm_xmm_xmmm32", Code::VEX_Vmulss_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vmulss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vmulss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("Mulsd_xmm_xmmm64", Code::Mulsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vmulsd_xmm_xmm_xmmm64", Code::VEX_Vmulsd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vmulsd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vmulsd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("Cvtps2pd_xmm_xmmm64", Code::Cvtps2pd_xmm_xmmm64);
		let _ = h.insert("VEX_Vcvtps2pd_xmm_xmmm64", Code::VEX_Vcvtps2pd_xmm_xmmm64);
		let _ = h.insert("VEX_Vcvtps2pd_ymm_xmmm128", Code::VEX_Vcvtps2pd_ymm_xmmm128);
		let _ = h.insert("EVEX_Vcvtps2pd_xmm_k1z_xmmm64b32", Code::EVEX_Vcvtps2pd_xmm_k1z_xmmm64b32);
		let _ = h.insert("EVEX_Vcvtps2pd_ymm_k1z_xmmm128b32", Code::EVEX_Vcvtps2pd_ymm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtps2pd_zmm_k1z_ymmm256b32_sae", Code::EVEX_Vcvtps2pd_zmm_k1z_ymmm256b32_sae);
		let _ = h.insert("Cvtpd2ps_xmm_xmmm128", Code::Cvtpd2ps_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtpd2ps_xmm_xmmm128", Code::VEX_Vcvtpd2ps_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtpd2ps_xmm_ymmm256", Code::VEX_Vcvtpd2ps_xmm_ymmm256);
		let _ = h.insert("EVEX_Vcvtpd2ps_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtpd2ps_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtpd2ps_xmm_k1z_ymmm256b64", Code::EVEX_Vcvtpd2ps_xmm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtpd2ps_ymm_k1z_zmmm512b64_er", Code::EVEX_Vcvtpd2ps_ymm_k1z_zmmm512b64_er);
		let _ = h.insert("Cvtss2sd_xmm_xmmm32", Code::Cvtss2sd_xmm_xmmm32);
		let _ = h.insert("VEX_Vcvtss2sd_xmm_xmm_xmmm32", Code::VEX_Vcvtss2sd_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vcvtss2sd_xmm_k1z_xmm_xmmm32_sae", Code::EVEX_Vcvtss2sd_xmm_k1z_xmm_xmmm32_sae);
		let _ = h.insert("Cvtsd2ss_xmm_xmmm64", Code::Cvtsd2ss_xmm_xmmm64);
		let _ = h.insert("VEX_Vcvtsd2ss_xmm_xmm_xmmm64", Code::VEX_Vcvtsd2ss_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vcvtsd2ss_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vcvtsd2ss_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("Cvtdq2ps_xmm_xmmm128", Code::Cvtdq2ps_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtdq2ps_xmm_xmmm128", Code::VEX_Vcvtdq2ps_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtdq2ps_ymm_ymmm256", Code::VEX_Vcvtdq2ps_ymm_ymmm256);
		let _ = h.insert("EVEX_Vcvtdq2ps_xmm_k1z_xmmm128b32", Code::EVEX_Vcvtdq2ps_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtdq2ps_ymm_k1z_ymmm256b32", Code::EVEX_Vcvtdq2ps_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vcvtdq2ps_zmm_k1z_zmmm512b32_er", Code::EVEX_Vcvtdq2ps_zmm_k1z_zmmm512b32_er);
		let _ = h.insert("EVEX_Vcvtqq2ps_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtqq2ps_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtqq2ps_xmm_k1z_ymmm256b64", Code::EVEX_Vcvtqq2ps_xmm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtqq2ps_ymm_k1z_zmmm512b64_er", Code::EVEX_Vcvtqq2ps_ymm_k1z_zmmm512b64_er);
		let _ = h.insert("Cvtps2dq_xmm_xmmm128", Code::Cvtps2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtps2dq_xmm_xmmm128", Code::VEX_Vcvtps2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtps2dq_ymm_ymmm256", Code::VEX_Vcvtps2dq_ymm_ymmm256);
		let _ = h.insert("EVEX_Vcvtps2dq_xmm_k1z_xmmm128b32", Code::EVEX_Vcvtps2dq_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtps2dq_ymm_k1z_ymmm256b32", Code::EVEX_Vcvtps2dq_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vcvtps2dq_zmm_k1z_zmmm512b32_er", Code::EVEX_Vcvtps2dq_zmm_k1z_zmmm512b32_er);
		let _ = h.insert("Cvttps2dq_xmm_xmmm128", Code::Cvttps2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvttps2dq_xmm_xmmm128", Code::VEX_Vcvttps2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvttps2dq_ymm_ymmm256", Code::VEX_Vcvttps2dq_ymm_ymmm256);
		let _ = h.insert("EVEX_Vcvttps2dq_xmm_k1z_xmmm128b32", Code::EVEX_Vcvttps2dq_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvttps2dq_ymm_k1z_ymmm256b32", Code::EVEX_Vcvttps2dq_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vcvttps2dq_zmm_k1z_zmmm512b32_sae", Code::EVEX_Vcvttps2dq_zmm_k1z_zmmm512b32_sae);
		let _ = h.insert("Subps_xmm_xmmm128", Code::Subps_xmm_xmmm128);
		let _ = h.insert("VEX_Vsubps_xmm_xmm_xmmm128", Code::VEX_Vsubps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vsubps_ymm_ymm_ymmm256", Code::VEX_Vsubps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vsubps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vsubps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vsubps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vsubps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vsubps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vsubps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("Subpd_xmm_xmmm128", Code::Subpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vsubpd_xmm_xmm_xmmm128", Code::VEX_Vsubpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vsubpd_ymm_ymm_ymmm256", Code::VEX_Vsubpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vsubpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vsubpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vsubpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vsubpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vsubpd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vsubpd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("Subss_xmm_xmmm32", Code::Subss_xmm_xmmm32);
		let _ = h.insert("VEX_Vsubss_xmm_xmm_xmmm32", Code::VEX_Vsubss_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vsubss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vsubss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("Subsd_xmm_xmmm64", Code::Subsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vsubsd_xmm_xmm_xmmm64", Code::VEX_Vsubsd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vsubsd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vsubsd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("Minps_xmm_xmmm128", Code::Minps_xmm_xmmm128);
		let _ = h.insert("VEX_Vminps_xmm_xmm_xmmm128", Code::VEX_Vminps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vminps_ymm_ymm_ymmm256", Code::VEX_Vminps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vminps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vminps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vminps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vminps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vminps_zmm_k1z_zmm_zmmm512b32_sae", Code::EVEX_Vminps_zmm_k1z_zmm_zmmm512b32_sae);
		let _ = h.insert("Minpd_xmm_xmmm128", Code::Minpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vminpd_xmm_xmm_xmmm128", Code::VEX_Vminpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vminpd_ymm_ymm_ymmm256", Code::VEX_Vminpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vminpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vminpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vminpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vminpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vminpd_zmm_k1z_zmm_zmmm512b64_sae", Code::EVEX_Vminpd_zmm_k1z_zmm_zmmm512b64_sae);
		let _ = h.insert("Minss_xmm_xmmm32", Code::Minss_xmm_xmmm32);
		let _ = h.insert("VEX_Vminss_xmm_xmm_xmmm32", Code::VEX_Vminss_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vminss_xmm_k1z_xmm_xmmm32_sae", Code::EVEX_Vminss_xmm_k1z_xmm_xmmm32_sae);
		let _ = h.insert("Minsd_xmm_xmmm64", Code::Minsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vminsd_xmm_xmm_xmmm64", Code::VEX_Vminsd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vminsd_xmm_k1z_xmm_xmmm64_sae", Code::EVEX_Vminsd_xmm_k1z_xmm_xmmm64_sae);
		let _ = h.insert("Divps_xmm_xmmm128", Code::Divps_xmm_xmmm128);
		let _ = h.insert("VEX_Vdivps_xmm_xmm_xmmm128", Code::VEX_Vdivps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vdivps_ymm_ymm_ymmm256", Code::VEX_Vdivps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vdivps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vdivps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vdivps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vdivps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vdivps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vdivps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("Divpd_xmm_xmmm128", Code::Divpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vdivpd_xmm_xmm_xmmm128", Code::VEX_Vdivpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vdivpd_ymm_ymm_ymmm256", Code::VEX_Vdivpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vdivpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vdivpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vdivpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vdivpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vdivpd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vdivpd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("Divss_xmm_xmmm32", Code::Divss_xmm_xmmm32);
		let _ = h.insert("VEX_Vdivss_xmm_xmm_xmmm32", Code::VEX_Vdivss_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vdivss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vdivss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("Divsd_xmm_xmmm64", Code::Divsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vdivsd_xmm_xmm_xmmm64", Code::VEX_Vdivsd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vdivsd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vdivsd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("Maxps_xmm_xmmm128", Code::Maxps_xmm_xmmm128);
		let _ = h.insert("VEX_Vmaxps_xmm_xmm_xmmm128", Code::VEX_Vmaxps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vmaxps_ymm_ymm_ymmm256", Code::VEX_Vmaxps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmaxps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vmaxps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vmaxps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vmaxps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vmaxps_zmm_k1z_zmm_zmmm512b32_sae", Code::EVEX_Vmaxps_zmm_k1z_zmm_zmmm512b32_sae);
		let _ = h.insert("Maxpd_xmm_xmmm128", Code::Maxpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vmaxpd_xmm_xmm_xmmm128", Code::VEX_Vmaxpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vmaxpd_ymm_ymm_ymmm256", Code::VEX_Vmaxpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmaxpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vmaxpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vmaxpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vmaxpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vmaxpd_zmm_k1z_zmm_zmmm512b64_sae", Code::EVEX_Vmaxpd_zmm_k1z_zmm_zmmm512b64_sae);
		let _ = h.insert("Maxss_xmm_xmmm32", Code::Maxss_xmm_xmmm32);
		let _ = h.insert("VEX_Vmaxss_xmm_xmm_xmmm32", Code::VEX_Vmaxss_xmm_xmm_xmmm32);
		let _ = h.insert("EVEX_Vmaxss_xmm_k1z_xmm_xmmm32_sae", Code::EVEX_Vmaxss_xmm_k1z_xmm_xmmm32_sae);
		let _ = h.insert("Maxsd_xmm_xmmm64", Code::Maxsd_xmm_xmmm64);
		let _ = h.insert("VEX_Vmaxsd_xmm_xmm_xmmm64", Code::VEX_Vmaxsd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vmaxsd_xmm_k1z_xmm_xmmm64_sae", Code::EVEX_Vmaxsd_xmm_k1z_xmm_xmmm64_sae);
		let _ = h.insert("Punpcklbw_mm_mmm32", Code::Punpcklbw_mm_mmm32);
		let _ = h.insert("Punpcklbw_xmm_xmmm128", Code::Punpcklbw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpcklbw_xmm_xmm_xmmm128", Code::VEX_Vpunpcklbw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpcklbw_ymm_ymm_ymmm256", Code::VEX_Vpunpcklbw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpcklbw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpunpcklbw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpunpcklbw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpunpcklbw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpcklbw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpunpcklbw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Punpcklwd_mm_mmm32", Code::Punpcklwd_mm_mmm32);
		let _ = h.insert("Punpcklwd_xmm_xmmm128", Code::Punpcklwd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpcklwd_xmm_xmm_xmmm128", Code::VEX_Vpunpcklwd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpcklwd_ymm_ymm_ymmm256", Code::VEX_Vpunpcklwd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpcklwd_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpunpcklwd_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpunpcklwd_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpunpcklwd_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpcklwd_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpunpcklwd_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Punpckldq_mm_mmm32", Code::Punpckldq_mm_mmm32);
		let _ = h.insert("Punpckldq_xmm_xmmm128", Code::Punpckldq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckldq_xmm_xmm_xmmm128", Code::VEX_Vpunpckldq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckldq_ymm_ymm_ymmm256", Code::VEX_Vpunpckldq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpckldq_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpunpckldq_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpunpckldq_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpunpckldq_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpunpckldq_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpunpckldq_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Packsswb_mm_mmm64", Code::Packsswb_mm_mmm64);
		let _ = h.insert("Packsswb_xmm_xmmm128", Code::Packsswb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpacksswb_xmm_xmm_xmmm128", Code::VEX_Vpacksswb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpacksswb_ymm_ymm_ymmm256", Code::VEX_Vpacksswb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpacksswb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpacksswb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpacksswb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpacksswb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpacksswb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpacksswb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pcmpgtb_mm_mmm64", Code::Pcmpgtb_mm_mmm64);
		let _ = h.insert("Pcmpgtb_xmm_xmmm128", Code::Pcmpgtb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtb_xmm_xmm_xmmm128", Code::VEX_Vpcmpgtb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtb_ymm_ymm_ymmm256", Code::VEX_Vpcmpgtb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpgtb_kr_k1_xmm_xmmm128", Code::EVEX_Vpcmpgtb_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpcmpgtb_kr_k1_ymm_ymmm256", Code::EVEX_Vpcmpgtb_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpgtb_kr_k1_zmm_zmmm512", Code::EVEX_Vpcmpgtb_kr_k1_zmm_zmmm512);
		let _ = h.insert("Pcmpgtw_mm_mmm64", Code::Pcmpgtw_mm_mmm64);
		let _ = h.insert("Pcmpgtw_xmm_xmmm128", Code::Pcmpgtw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtw_xmm_xmm_xmmm128", Code::VEX_Vpcmpgtw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtw_ymm_ymm_ymmm256", Code::VEX_Vpcmpgtw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpgtw_kr_k1_xmm_xmmm128", Code::EVEX_Vpcmpgtw_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpcmpgtw_kr_k1_ymm_ymmm256", Code::EVEX_Vpcmpgtw_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpgtw_kr_k1_zmm_zmmm512", Code::EVEX_Vpcmpgtw_kr_k1_zmm_zmmm512);
		let _ = h.insert("Pcmpgtd_mm_mmm64", Code::Pcmpgtd_mm_mmm64);
		let _ = h.insert("Pcmpgtd_xmm_xmmm128", Code::Pcmpgtd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtd_xmm_xmm_xmmm128", Code::VEX_Vpcmpgtd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtd_ymm_ymm_ymmm256", Code::VEX_Vpcmpgtd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpgtd_kr_k1_xmm_xmmm128b32", Code::EVEX_Vpcmpgtd_kr_k1_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpcmpgtd_kr_k1_ymm_ymmm256b32", Code::EVEX_Vpcmpgtd_kr_k1_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpcmpgtd_kr_k1_zmm_zmmm512b32", Code::EVEX_Vpcmpgtd_kr_k1_zmm_zmmm512b32);
		let _ = h.insert("Packuswb_mm_mmm64", Code::Packuswb_mm_mmm64);
		let _ = h.insert("Packuswb_xmm_xmmm128", Code::Packuswb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpackuswb_xmm_xmm_xmmm128", Code::VEX_Vpackuswb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpackuswb_ymm_ymm_ymmm256", Code::VEX_Vpackuswb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpackuswb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpackuswb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpackuswb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpackuswb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpackuswb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpackuswb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Punpckhbw_mm_mmm64", Code::Punpckhbw_mm_mmm64);
		let _ = h.insert("Punpckhbw_xmm_xmmm128", Code::Punpckhbw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhbw_xmm_xmm_xmmm128", Code::VEX_Vpunpckhbw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhbw_ymm_ymm_ymmm256", Code::VEX_Vpunpckhbw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpckhbw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpunpckhbw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpunpckhbw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpunpckhbw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpckhbw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpunpckhbw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Punpckhwd_mm_mmm64", Code::Punpckhwd_mm_mmm64);
		let _ = h.insert("Punpckhwd_xmm_xmmm128", Code::Punpckhwd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhwd_xmm_xmm_xmmm128", Code::VEX_Vpunpckhwd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhwd_ymm_ymm_ymmm256", Code::VEX_Vpunpckhwd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpckhwd_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpunpckhwd_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpunpckhwd_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpunpckhwd_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpckhwd_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpunpckhwd_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Punpckhdq_mm_mmm64", Code::Punpckhdq_mm_mmm64);
		let _ = h.insert("Punpckhdq_xmm_xmmm128", Code::Punpckhdq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhdq_xmm_xmm_xmmm128", Code::VEX_Vpunpckhdq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhdq_ymm_ymm_ymmm256", Code::VEX_Vpunpckhdq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpckhdq_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpunpckhdq_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpunpckhdq_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpunpckhdq_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpunpckhdq_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpunpckhdq_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Packssdw_mm_mmm64", Code::Packssdw_mm_mmm64);
		let _ = h.insert("Packssdw_xmm_xmmm128", Code::Packssdw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpackssdw_xmm_xmm_xmmm128", Code::VEX_Vpackssdw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpackssdw_ymm_ymm_ymmm256", Code::VEX_Vpackssdw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpackssdw_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpackssdw_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpackssdw_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpackssdw_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpackssdw_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpackssdw_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Punpcklqdq_xmm_xmmm128", Code::Punpcklqdq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpcklqdq_xmm_xmm_xmmm128", Code::VEX_Vpunpcklqdq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpcklqdq_ymm_ymm_ymmm256", Code::VEX_Vpunpcklqdq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpcklqdq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpunpcklqdq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpunpcklqdq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpunpcklqdq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpunpcklqdq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpunpcklqdq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Punpckhqdq_xmm_xmmm128", Code::Punpckhqdq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhqdq_xmm_xmm_xmmm128", Code::VEX_Vpunpckhqdq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpunpckhqdq_ymm_ymm_ymmm256", Code::VEX_Vpunpckhqdq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpunpckhqdq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpunpckhqdq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpunpckhqdq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpunpckhqdq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpunpckhqdq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpunpckhqdq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Movd_mm_rm32", Code::Movd_mm_rm32);
		let _ = h.insert("Movq_mm_rm64", Code::Movq_mm_rm64);
		let _ = h.insert("Movd_xmm_rm32", Code::Movd_xmm_rm32);
		let _ = h.insert("Movq_xmm_rm64", Code::Movq_xmm_rm64);
		let _ = h.insert("VEX_Vmovd_xmm_rm32", Code::VEX_Vmovd_xmm_rm32);
		let _ = h.insert("VEX_Vmovq_xmm_rm64", Code::VEX_Vmovq_xmm_rm64);
		let _ = h.insert("EVEX_Vmovd_xmm_rm32", Code::EVEX_Vmovd_xmm_rm32);
		let _ = h.insert("EVEX_Vmovq_xmm_rm64", Code::EVEX_Vmovq_xmm_rm64);
		let _ = h.insert("Movq_mm_mmm64", Code::Movq_mm_mmm64);
		let _ = h.insert("Movdqa_xmm_xmmm128", Code::Movdqa_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovdqa_xmm_xmmm128", Code::VEX_Vmovdqa_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovdqa_ymm_ymmm256", Code::VEX_Vmovdqa_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovdqa32_xmm_k1z_xmmm128", Code::EVEX_Vmovdqa32_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovdqa32_ymm_k1z_ymmm256", Code::EVEX_Vmovdqa32_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovdqa32_zmm_k1z_zmmm512", Code::EVEX_Vmovdqa32_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vmovdqa64_xmm_k1z_xmmm128", Code::EVEX_Vmovdqa64_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovdqa64_ymm_k1z_ymmm256", Code::EVEX_Vmovdqa64_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovdqa64_zmm_k1z_zmmm512", Code::EVEX_Vmovdqa64_zmm_k1z_zmmm512);
		let _ = h.insert("Movdqu_xmm_xmmm128", Code::Movdqu_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovdqu_xmm_xmmm128", Code::VEX_Vmovdqu_xmm_xmmm128);
		let _ = h.insert("VEX_Vmovdqu_ymm_ymmm256", Code::VEX_Vmovdqu_ymm_ymmm256);
		let _ = h.insert("EVEX_Vmovdqu32_xmm_k1z_xmmm128", Code::EVEX_Vmovdqu32_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovdqu32_ymm_k1z_ymmm256", Code::EVEX_Vmovdqu32_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovdqu32_zmm_k1z_zmmm512", Code::EVEX_Vmovdqu32_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vmovdqu64_xmm_k1z_xmmm128", Code::EVEX_Vmovdqu64_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovdqu64_ymm_k1z_ymmm256", Code::EVEX_Vmovdqu64_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovdqu64_zmm_k1z_zmmm512", Code::EVEX_Vmovdqu64_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vmovdqu8_xmm_k1z_xmmm128", Code::EVEX_Vmovdqu8_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovdqu8_ymm_k1z_ymmm256", Code::EVEX_Vmovdqu8_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovdqu8_zmm_k1z_zmmm512", Code::EVEX_Vmovdqu8_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vmovdqu16_xmm_k1z_xmmm128", Code::EVEX_Vmovdqu16_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vmovdqu16_ymm_k1z_ymmm256", Code::EVEX_Vmovdqu16_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vmovdqu16_zmm_k1z_zmmm512", Code::EVEX_Vmovdqu16_zmm_k1z_zmmm512);
		let _ = h.insert("Pshufw_mm_mmm64_imm8", Code::Pshufw_mm_mmm64_imm8);
		let _ = h.insert("Pshufd_xmm_xmmm128_imm8", Code::Pshufd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpshufd_xmm_xmmm128_imm8", Code::VEX_Vpshufd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpshufd_ymm_ymmm256_imm8", Code::VEX_Vpshufd_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpshufd_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vpshufd_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpshufd_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vpshufd_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpshufd_zmm_k1z_zmmm512b32_imm8", Code::EVEX_Vpshufd_zmm_k1z_zmmm512b32_imm8);
		let _ = h.insert("Pshufhw_xmm_xmmm128_imm8", Code::Pshufhw_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpshufhw_xmm_xmmm128_imm8", Code::VEX_Vpshufhw_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpshufhw_ymm_ymmm256_imm8", Code::VEX_Vpshufhw_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpshufhw_xmm_k1z_xmmm128_imm8", Code::EVEX_Vpshufhw_xmm_k1z_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpshufhw_ymm_k1z_ymmm256_imm8", Code::EVEX_Vpshufhw_ymm_k1z_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpshufhw_zmm_k1z_zmmm512_imm8", Code::EVEX_Vpshufhw_zmm_k1z_zmmm512_imm8);
		let _ = h.insert("Pshuflw_xmm_xmmm128_imm8", Code::Pshuflw_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpshuflw_xmm_xmmm128_imm8", Code::VEX_Vpshuflw_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpshuflw_ymm_ymmm256_imm8", Code::VEX_Vpshuflw_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpshuflw_xmm_k1z_xmmm128_imm8", Code::EVEX_Vpshuflw_xmm_k1z_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpshuflw_ymm_k1z_ymmm256_imm8", Code::EVEX_Vpshuflw_ymm_k1z_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpshuflw_zmm_k1z_zmmm512_imm8", Code::EVEX_Vpshuflw_zmm_k1z_zmmm512_imm8);
		let _ = h.insert("Psrlw_mm_imm8", Code::Psrlw_mm_imm8);
		let _ = h.insert("Psrlw_xmm_imm8", Code::Psrlw_xmm_imm8);
		let _ = h.insert("VEX_Vpsrlw_xmm_xmm_imm8", Code::VEX_Vpsrlw_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsrlw_ymm_ymm_imm8", Code::VEX_Vpsrlw_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsrlw_xmm_k1z_xmmm128_imm8", Code::EVEX_Vpsrlw_xmm_k1z_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpsrlw_ymm_k1z_ymmm256_imm8", Code::EVEX_Vpsrlw_ymm_k1z_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpsrlw_zmm_k1z_zmmm512_imm8", Code::EVEX_Vpsrlw_zmm_k1z_zmmm512_imm8);
		let _ = h.insert("Psraw_mm_imm8", Code::Psraw_mm_imm8);
		let _ = h.insert("Psraw_xmm_imm8", Code::Psraw_xmm_imm8);
		let _ = h.insert("VEX_Vpsraw_xmm_xmm_imm8", Code::VEX_Vpsraw_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsraw_ymm_ymm_imm8", Code::VEX_Vpsraw_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsraw_xmm_k1z_xmmm128_imm8", Code::EVEX_Vpsraw_xmm_k1z_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpsraw_ymm_k1z_ymmm256_imm8", Code::EVEX_Vpsraw_ymm_k1z_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpsraw_zmm_k1z_zmmm512_imm8", Code::EVEX_Vpsraw_zmm_k1z_zmmm512_imm8);
		let _ = h.insert("Psllw_mm_imm8", Code::Psllw_mm_imm8);
		let _ = h.insert("Psllw_xmm_imm8", Code::Psllw_xmm_imm8);
		let _ = h.insert("VEX_Vpsllw_xmm_xmm_imm8", Code::VEX_Vpsllw_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsllw_ymm_ymm_imm8", Code::VEX_Vpsllw_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsllw_xmm_k1z_xmmm128_imm8", Code::EVEX_Vpsllw_xmm_k1z_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpsllw_ymm_k1z_ymmm256_imm8", Code::EVEX_Vpsllw_ymm_k1z_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpsllw_zmm_k1z_zmmm512_imm8", Code::EVEX_Vpsllw_zmm_k1z_zmmm512_imm8);
		let _ = h.insert("EVEX_Vprord_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vprord_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vprord_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vprord_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vprord_zmm_k1z_zmmm512b32_imm8", Code::EVEX_Vprord_zmm_k1z_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vprorq_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vprorq_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vprorq_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vprorq_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vprorq_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vprorq_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("EVEX_Vprold_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vprold_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vprold_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vprold_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vprold_zmm_k1z_zmmm512b32_imm8", Code::EVEX_Vprold_zmm_k1z_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vprolq_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vprolq_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vprolq_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vprolq_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vprolq_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vprolq_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("Psrld_mm_imm8", Code::Psrld_mm_imm8);
		let _ = h.insert("Psrld_xmm_imm8", Code::Psrld_xmm_imm8);
		let _ = h.insert("VEX_Vpsrld_xmm_xmm_imm8", Code::VEX_Vpsrld_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsrld_ymm_ymm_imm8", Code::VEX_Vpsrld_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsrld_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vpsrld_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpsrld_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vpsrld_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpsrld_zmm_k1z_zmmm512b32_imm8", Code::EVEX_Vpsrld_zmm_k1z_zmmm512b32_imm8);
		let _ = h.insert("Psrad_mm_imm8", Code::Psrad_mm_imm8);
		let _ = h.insert("Psrad_xmm_imm8", Code::Psrad_xmm_imm8);
		let _ = h.insert("VEX_Vpsrad_xmm_xmm_imm8", Code::VEX_Vpsrad_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsrad_ymm_ymm_imm8", Code::VEX_Vpsrad_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsrad_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vpsrad_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpsrad_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vpsrad_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpsrad_zmm_k1z_zmmm512b32_imm8", Code::EVEX_Vpsrad_zmm_k1z_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vpsraq_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vpsraq_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpsraq_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vpsraq_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpsraq_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vpsraq_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("Pslld_mm_imm8", Code::Pslld_mm_imm8);
		let _ = h.insert("Pslld_xmm_imm8", Code::Pslld_xmm_imm8);
		let _ = h.insert("VEX_Vpslld_xmm_xmm_imm8", Code::VEX_Vpslld_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpslld_ymm_ymm_imm8", Code::VEX_Vpslld_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpslld_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vpslld_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpslld_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vpslld_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpslld_zmm_k1z_zmmm512b32_imm8", Code::EVEX_Vpslld_zmm_k1z_zmmm512b32_imm8);
		let _ = h.insert("Psrlq_mm_imm8", Code::Psrlq_mm_imm8);
		let _ = h.insert("Psrlq_xmm_imm8", Code::Psrlq_xmm_imm8);
		let _ = h.insert("VEX_Vpsrlq_xmm_xmm_imm8", Code::VEX_Vpsrlq_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsrlq_ymm_ymm_imm8", Code::VEX_Vpsrlq_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsrlq_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vpsrlq_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpsrlq_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vpsrlq_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpsrlq_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vpsrlq_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("Psrldq_xmm_imm8", Code::Psrldq_xmm_imm8);
		let _ = h.insert("VEX_Vpsrldq_xmm_xmm_imm8", Code::VEX_Vpsrldq_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsrldq_ymm_ymm_imm8", Code::VEX_Vpsrldq_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsrldq_xmm_xmmm128_imm8", Code::EVEX_Vpsrldq_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpsrldq_ymm_ymmm256_imm8", Code::EVEX_Vpsrldq_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpsrldq_zmm_zmmm512_imm8", Code::EVEX_Vpsrldq_zmm_zmmm512_imm8);
		let _ = h.insert("Psllq_mm_imm8", Code::Psllq_mm_imm8);
		let _ = h.insert("Psllq_xmm_imm8", Code::Psllq_xmm_imm8);
		let _ = h.insert("VEX_Vpsllq_xmm_xmm_imm8", Code::VEX_Vpsllq_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpsllq_ymm_ymm_imm8", Code::VEX_Vpsllq_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpsllq_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vpsllq_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpsllq_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vpsllq_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpsllq_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vpsllq_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("Pslldq_xmm_imm8", Code::Pslldq_xmm_imm8);
		let _ = h.insert("VEX_Vpslldq_xmm_xmm_imm8", Code::VEX_Vpslldq_xmm_xmm_imm8);
		let _ = h.insert("VEX_Vpslldq_ymm_ymm_imm8", Code::VEX_Vpslldq_ymm_ymm_imm8);
		let _ = h.insert("EVEX_Vpslldq_xmm_xmmm128_imm8", Code::EVEX_Vpslldq_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpslldq_ymm_ymmm256_imm8", Code::EVEX_Vpslldq_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpslldq_zmm_zmmm512_imm8", Code::EVEX_Vpslldq_zmm_zmmm512_imm8);
		let _ = h.insert("Pcmpeqb_mm_mmm64", Code::Pcmpeqb_mm_mmm64);
		let _ = h.insert("Pcmpeqb_xmm_xmmm128", Code::Pcmpeqb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqb_xmm_xmm_xmmm128", Code::VEX_Vpcmpeqb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqb_ymm_ymm_ymmm256", Code::VEX_Vpcmpeqb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpeqb_kr_k1_xmm_xmmm128", Code::EVEX_Vpcmpeqb_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpcmpeqb_kr_k1_ymm_ymmm256", Code::EVEX_Vpcmpeqb_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpeqb_kr_k1_zmm_zmmm512", Code::EVEX_Vpcmpeqb_kr_k1_zmm_zmmm512);
		let _ = h.insert("Pcmpeqw_mm_mmm64", Code::Pcmpeqw_mm_mmm64);
		let _ = h.insert("Pcmpeqw_xmm_xmmm128", Code::Pcmpeqw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqw_xmm_xmm_xmmm128", Code::VEX_Vpcmpeqw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqw_ymm_ymm_ymmm256", Code::VEX_Vpcmpeqw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpeqw_kr_k1_xmm_xmmm128", Code::EVEX_Vpcmpeqw_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpcmpeqw_kr_k1_ymm_ymmm256", Code::EVEX_Vpcmpeqw_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpeqw_kr_k1_zmm_zmmm512", Code::EVEX_Vpcmpeqw_kr_k1_zmm_zmmm512);
		let _ = h.insert("Pcmpeqd_mm_mmm64", Code::Pcmpeqd_mm_mmm64);
		let _ = h.insert("Pcmpeqd_xmm_xmmm128", Code::Pcmpeqd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqd_xmm_xmm_xmmm128", Code::VEX_Vpcmpeqd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqd_ymm_ymm_ymmm256", Code::VEX_Vpcmpeqd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpeqd_kr_k1_xmm_xmmm128b32", Code::EVEX_Vpcmpeqd_kr_k1_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpcmpeqd_kr_k1_ymm_ymmm256b32", Code::EVEX_Vpcmpeqd_kr_k1_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpcmpeqd_kr_k1_zmm_zmmm512b32", Code::EVEX_Vpcmpeqd_kr_k1_zmm_zmmm512b32);
		let _ = h.insert("Emms", Code::Emms);
		let _ = h.insert("VEX_Vzeroupper", Code::VEX_Vzeroupper);
		let _ = h.insert("VEX_Vzeroall", Code::VEX_Vzeroall);
		let _ = h.insert("Vmread_rm32_r32", Code::Vmread_rm32_r32);
		let _ = h.insert("Vmread_rm64_r64", Code::Vmread_rm64_r64);
		let _ = h.insert("EVEX_Vcvttps2udq_xmm_k1z_xmmm128b32", Code::EVEX_Vcvttps2udq_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvttps2udq_ymm_k1z_ymmm256b32", Code::EVEX_Vcvttps2udq_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vcvttps2udq_zmm_k1z_zmmm512b32_sae", Code::EVEX_Vcvttps2udq_zmm_k1z_zmmm512b32_sae);
		let _ = h.insert("EVEX_Vcvttpd2udq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvttpd2udq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvttpd2udq_xmm_k1z_ymmm256b64", Code::EVEX_Vcvttpd2udq_xmm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvttpd2udq_ymm_k1z_zmmm512b64_sae", Code::EVEX_Vcvttpd2udq_ymm_k1z_zmmm512b64_sae);
		let _ = h.insert("Extrq_xmm_imm8_imm8", Code::Extrq_xmm_imm8_imm8);
		let _ = h.insert("EVEX_Vcvttps2uqq_xmm_k1z_xmmm64b32", Code::EVEX_Vcvttps2uqq_xmm_k1z_xmmm64b32);
		let _ = h.insert("EVEX_Vcvttps2uqq_ymm_k1z_xmmm128b32", Code::EVEX_Vcvttps2uqq_ymm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvttps2uqq_zmm_k1z_ymmm256b32_sae", Code::EVEX_Vcvttps2uqq_zmm_k1z_ymmm256b32_sae);
		let _ = h.insert("EVEX_Vcvttpd2uqq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvttpd2uqq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvttpd2uqq_ymm_k1z_ymmm256b64", Code::EVEX_Vcvttpd2uqq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvttpd2uqq_zmm_k1z_zmmm512b64_sae", Code::EVEX_Vcvttpd2uqq_zmm_k1z_zmmm512b64_sae);
		let _ = h.insert("EVEX_Vcvttss2usi_r32_xmmm32_sae", Code::EVEX_Vcvttss2usi_r32_xmmm32_sae);
		let _ = h.insert("EVEX_Vcvttss2usi_r64_xmmm32_sae", Code::EVEX_Vcvttss2usi_r64_xmmm32_sae);
		let _ = h.insert("Insertq_xmm_xmm_imm8_imm8", Code::Insertq_xmm_xmm_imm8_imm8);
		let _ = h.insert("EVEX_Vcvttsd2usi_r32_xmmm64_sae", Code::EVEX_Vcvttsd2usi_r32_xmmm64_sae);
		let _ = h.insert("EVEX_Vcvttsd2usi_r64_xmmm64_sae", Code::EVEX_Vcvttsd2usi_r64_xmmm64_sae);
		let _ = h.insert("Vmwrite_r32_rm32", Code::Vmwrite_r32_rm32);
		let _ = h.insert("Vmwrite_r64_rm64", Code::Vmwrite_r64_rm64);
		let _ = h.insert("EVEX_Vcvtps2udq_xmm_k1z_xmmm128b32", Code::EVEX_Vcvtps2udq_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtps2udq_ymm_k1z_ymmm256b32", Code::EVEX_Vcvtps2udq_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vcvtps2udq_zmm_k1z_zmmm512b32_er", Code::EVEX_Vcvtps2udq_zmm_k1z_zmmm512b32_er);
		let _ = h.insert("EVEX_Vcvtpd2udq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtpd2udq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtpd2udq_xmm_k1z_ymmm256b64", Code::EVEX_Vcvtpd2udq_xmm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtpd2udq_ymm_k1z_zmmm512b64_er", Code::EVEX_Vcvtpd2udq_ymm_k1z_zmmm512b64_er);
		let _ = h.insert("Extrq_xmm_xmm", Code::Extrq_xmm_xmm);
		let _ = h.insert("EVEX_Vcvtps2uqq_xmm_k1z_xmmm64b32", Code::EVEX_Vcvtps2uqq_xmm_k1z_xmmm64b32);
		let _ = h.insert("EVEX_Vcvtps2uqq_ymm_k1z_xmmm128b32", Code::EVEX_Vcvtps2uqq_ymm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtps2uqq_zmm_k1z_ymmm256b32_er", Code::EVEX_Vcvtps2uqq_zmm_k1z_ymmm256b32_er);
		let _ = h.insert("EVEX_Vcvtpd2uqq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtpd2uqq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtpd2uqq_ymm_k1z_ymmm256b64", Code::EVEX_Vcvtpd2uqq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtpd2uqq_zmm_k1z_zmmm512b64_er", Code::EVEX_Vcvtpd2uqq_zmm_k1z_zmmm512b64_er);
		let _ = h.insert("EVEX_Vcvtss2usi_r32_xmmm32_er", Code::EVEX_Vcvtss2usi_r32_xmmm32_er);
		let _ = h.insert("EVEX_Vcvtss2usi_r64_xmmm32_er", Code::EVEX_Vcvtss2usi_r64_xmmm32_er);
		let _ = h.insert("Insertq_xmm_xmm", Code::Insertq_xmm_xmm);
		let _ = h.insert("EVEX_Vcvtsd2usi_r32_xmmm64_er", Code::EVEX_Vcvtsd2usi_r32_xmmm64_er);
		let _ = h.insert("EVEX_Vcvtsd2usi_r64_xmmm64_er", Code::EVEX_Vcvtsd2usi_r64_xmmm64_er);
		let _ = h.insert("EVEX_Vcvttps2qq_xmm_k1z_xmmm64b32", Code::EVEX_Vcvttps2qq_xmm_k1z_xmmm64b32);
		let _ = h.insert("EVEX_Vcvttps2qq_ymm_k1z_xmmm128b32", Code::EVEX_Vcvttps2qq_ymm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvttps2qq_zmm_k1z_ymmm256b32_sae", Code::EVEX_Vcvttps2qq_zmm_k1z_ymmm256b32_sae);
		let _ = h.insert("EVEX_Vcvttpd2qq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvttpd2qq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvttpd2qq_ymm_k1z_ymmm256b64", Code::EVEX_Vcvttpd2qq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvttpd2qq_zmm_k1z_zmmm512b64_sae", Code::EVEX_Vcvttpd2qq_zmm_k1z_zmmm512b64_sae);
		let _ = h.insert("EVEX_Vcvtudq2pd_xmm_k1z_xmmm64b32", Code::EVEX_Vcvtudq2pd_xmm_k1z_xmmm64b32);
		let _ = h.insert("EVEX_Vcvtudq2pd_ymm_k1z_xmmm128b32", Code::EVEX_Vcvtudq2pd_ymm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtudq2pd_zmm_k1z_ymmm256b32_er", Code::EVEX_Vcvtudq2pd_zmm_k1z_ymmm256b32_er);
		let _ = h.insert("EVEX_Vcvtuqq2pd_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtuqq2pd_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtuqq2pd_ymm_k1z_ymmm256b64", Code::EVEX_Vcvtuqq2pd_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtuqq2pd_zmm_k1z_zmmm512b64_er", Code::EVEX_Vcvtuqq2pd_zmm_k1z_zmmm512b64_er);
		let _ = h.insert("EVEX_Vcvtudq2ps_xmm_k1z_xmmm128b32", Code::EVEX_Vcvtudq2ps_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtudq2ps_ymm_k1z_ymmm256b32", Code::EVEX_Vcvtudq2ps_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vcvtudq2ps_zmm_k1z_zmmm512b32_er", Code::EVEX_Vcvtudq2ps_zmm_k1z_zmmm512b32_er);
		let _ = h.insert("EVEX_Vcvtuqq2ps_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtuqq2ps_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtuqq2ps_xmm_k1z_ymmm256b64", Code::EVEX_Vcvtuqq2ps_xmm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtuqq2ps_ymm_k1z_zmmm512b64_er", Code::EVEX_Vcvtuqq2ps_ymm_k1z_zmmm512b64_er);
		let _ = h.insert("EVEX_Vcvtps2qq_xmm_k1z_xmmm64b32", Code::EVEX_Vcvtps2qq_xmm_k1z_xmmm64b32);
		let _ = h.insert("EVEX_Vcvtps2qq_ymm_k1z_xmmm128b32", Code::EVEX_Vcvtps2qq_ymm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtps2qq_zmm_k1z_ymmm256b32_er", Code::EVEX_Vcvtps2qq_zmm_k1z_ymmm256b32_er);
		let _ = h.insert("EVEX_Vcvtpd2qq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtpd2qq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtpd2qq_ymm_k1z_ymmm256b64", Code::EVEX_Vcvtpd2qq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtpd2qq_zmm_k1z_zmmm512b64_er", Code::EVEX_Vcvtpd2qq_zmm_k1z_zmmm512b64_er);
		let _ = h.insert("EVEX_Vcvtusi2ss_xmm_xmm_rm32_er", Code::EVEX_Vcvtusi2ss_xmm_xmm_rm32_er);
		let _ = h.insert("EVEX_Vcvtusi2ss_xmm_xmm_rm64_er", Code::EVEX_Vcvtusi2ss_xmm_xmm_rm64_er);
		let _ = h.insert("EVEX_Vcvtusi2sd_xmm_xmm_rm32_er", Code::EVEX_Vcvtusi2sd_xmm_xmm_rm32_er);
		let _ = h.insert("EVEX_Vcvtusi2sd_xmm_xmm_rm64_er", Code::EVEX_Vcvtusi2sd_xmm_xmm_rm64_er);
		let _ = h.insert("Haddpd_xmm_xmmm128", Code::Haddpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vhaddpd_xmm_xmm_xmmm128", Code::VEX_Vhaddpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vhaddpd_ymm_ymm_ymmm256", Code::VEX_Vhaddpd_ymm_ymm_ymmm256);
		let _ = h.insert("Haddps_xmm_xmmm128", Code::Haddps_xmm_xmmm128);
		let _ = h.insert("VEX_Vhaddps_xmm_xmm_xmmm128", Code::VEX_Vhaddps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vhaddps_ymm_ymm_ymmm256", Code::VEX_Vhaddps_ymm_ymm_ymmm256);
		let _ = h.insert("Hsubpd_xmm_xmmm128", Code::Hsubpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vhsubpd_xmm_xmm_xmmm128", Code::VEX_Vhsubpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vhsubpd_ymm_ymm_ymmm256", Code::VEX_Vhsubpd_ymm_ymm_ymmm256);
		let _ = h.insert("Hsubps_xmm_xmmm128", Code::Hsubps_xmm_xmmm128);
		let _ = h.insert("VEX_Vhsubps_xmm_xmm_xmmm128", Code::VEX_Vhsubps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vhsubps_ymm_ymm_ymmm256", Code::VEX_Vhsubps_ymm_ymm_ymmm256);
		let _ = h.insert("Movd_rm32_mm", Code::Movd_rm32_mm);
		let _ = h.insert("Movq_rm64_mm", Code::Movq_rm64_mm);
		let _ = h.insert("Movd_rm32_xmm", Code::Movd_rm32_xmm);
		let _ = h.insert("Movq_rm64_xmm", Code::Movq_rm64_xmm);
		let _ = h.insert("VEX_Vmovd_rm32_xmm", Code::VEX_Vmovd_rm32_xmm);
		let _ = h.insert("VEX_Vmovq_rm64_xmm", Code::VEX_Vmovq_rm64_xmm);
		let _ = h.insert("EVEX_Vmovd_rm32_xmm", Code::EVEX_Vmovd_rm32_xmm);
		let _ = h.insert("EVEX_Vmovq_rm64_xmm", Code::EVEX_Vmovq_rm64_xmm);
		let _ = h.insert("Movq_xmm_xmmm64", Code::Movq_xmm_xmmm64);
		let _ = h.insert("VEX_Vmovq_xmm_xmmm64", Code::VEX_Vmovq_xmm_xmmm64);
		let _ = h.insert("EVEX_Vmovq_xmm_xmmm64", Code::EVEX_Vmovq_xmm_xmmm64);
		let _ = h.insert("Movq_mmm64_mm", Code::Movq_mmm64_mm);
		let _ = h.insert("Movdqa_xmmm128_xmm", Code::Movdqa_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovdqa_xmmm128_xmm", Code::VEX_Vmovdqa_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovdqa_ymmm256_ymm", Code::VEX_Vmovdqa_ymmm256_ymm);
		let _ = h.insert("EVEX_Vmovdqa32_xmmm128_k1z_xmm", Code::EVEX_Vmovdqa32_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovdqa32_ymmm256_k1z_ymm", Code::EVEX_Vmovdqa32_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovdqa32_zmmm512_k1z_zmm", Code::EVEX_Vmovdqa32_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vmovdqa64_xmmm128_k1z_xmm", Code::EVEX_Vmovdqa64_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovdqa64_ymmm256_k1z_ymm", Code::EVEX_Vmovdqa64_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovdqa64_zmmm512_k1z_zmm", Code::EVEX_Vmovdqa64_zmmm512_k1z_zmm);
		let _ = h.insert("Movdqu_xmmm128_xmm", Code::Movdqu_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovdqu_xmmm128_xmm", Code::VEX_Vmovdqu_xmmm128_xmm);
		let _ = h.insert("VEX_Vmovdqu_ymmm256_ymm", Code::VEX_Vmovdqu_ymmm256_ymm);
		let _ = h.insert("EVEX_Vmovdqu32_xmmm128_k1z_xmm", Code::EVEX_Vmovdqu32_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovdqu32_ymmm256_k1z_ymm", Code::EVEX_Vmovdqu32_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovdqu32_zmmm512_k1z_zmm", Code::EVEX_Vmovdqu32_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vmovdqu64_xmmm128_k1z_xmm", Code::EVEX_Vmovdqu64_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovdqu64_ymmm256_k1z_ymm", Code::EVEX_Vmovdqu64_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovdqu64_zmmm512_k1z_zmm", Code::EVEX_Vmovdqu64_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vmovdqu8_xmmm128_k1z_xmm", Code::EVEX_Vmovdqu8_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovdqu8_ymmm256_k1z_ymm", Code::EVEX_Vmovdqu8_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovdqu8_zmmm512_k1z_zmm", Code::EVEX_Vmovdqu8_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vmovdqu16_xmmm128_k1z_xmm", Code::EVEX_Vmovdqu16_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vmovdqu16_ymmm256_k1z_ymm", Code::EVEX_Vmovdqu16_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vmovdqu16_zmmm512_k1z_zmm", Code::EVEX_Vmovdqu16_zmmm512_k1z_zmm);
		let _ = h.insert("Jo_rel16", Code::Jo_rel16);
		let _ = h.insert("Jo_rel32_32", Code::Jo_rel32_32);
		let _ = h.insert("Jo_rel32_64", Code::Jo_rel32_64);
		let _ = h.insert("Jno_rel16", Code::Jno_rel16);
		let _ = h.insert("Jno_rel32_32", Code::Jno_rel32_32);
		let _ = h.insert("Jno_rel32_64", Code::Jno_rel32_64);
		let _ = h.insert("Jb_rel16", Code::Jb_rel16);
		let _ = h.insert("Jb_rel32_32", Code::Jb_rel32_32);
		let _ = h.insert("Jb_rel32_64", Code::Jb_rel32_64);
		let _ = h.insert("Jae_rel16", Code::Jae_rel16);
		let _ = h.insert("Jae_rel32_32", Code::Jae_rel32_32);
		let _ = h.insert("Jae_rel32_64", Code::Jae_rel32_64);
		let _ = h.insert("Je_rel16", Code::Je_rel16);
		let _ = h.insert("Je_rel32_32", Code::Je_rel32_32);
		let _ = h.insert("Je_rel32_64", Code::Je_rel32_64);
		let _ = h.insert("Jne_rel16", Code::Jne_rel16);
		let _ = h.insert("Jne_rel32_32", Code::Jne_rel32_32);
		let _ = h.insert("Jne_rel32_64", Code::Jne_rel32_64);
		let _ = h.insert("Jbe_rel16", Code::Jbe_rel16);
		let _ = h.insert("Jbe_rel32_32", Code::Jbe_rel32_32);
		let _ = h.insert("Jbe_rel32_64", Code::Jbe_rel32_64);
		let _ = h.insert("Ja_rel16", Code::Ja_rel16);
		let _ = h.insert("Ja_rel32_32", Code::Ja_rel32_32);
		let _ = h.insert("Ja_rel32_64", Code::Ja_rel32_64);
		let _ = h.insert("Js_rel16", Code::Js_rel16);
		let _ = h.insert("Js_rel32_32", Code::Js_rel32_32);
		let _ = h.insert("Js_rel32_64", Code::Js_rel32_64);
		let _ = h.insert("Jns_rel16", Code::Jns_rel16);
		let _ = h.insert("Jns_rel32_32", Code::Jns_rel32_32);
		let _ = h.insert("Jns_rel32_64", Code::Jns_rel32_64);
		let _ = h.insert("Jp_rel16", Code::Jp_rel16);
		let _ = h.insert("Jp_rel32_32", Code::Jp_rel32_32);
		let _ = h.insert("Jp_rel32_64", Code::Jp_rel32_64);
		let _ = h.insert("Jnp_rel16", Code::Jnp_rel16);
		let _ = h.insert("Jnp_rel32_32", Code::Jnp_rel32_32);
		let _ = h.insert("Jnp_rel32_64", Code::Jnp_rel32_64);
		let _ = h.insert("Jl_rel16", Code::Jl_rel16);
		let _ = h.insert("Jl_rel32_32", Code::Jl_rel32_32);
		let _ = h.insert("Jl_rel32_64", Code::Jl_rel32_64);
		let _ = h.insert("Jge_rel16", Code::Jge_rel16);
		let _ = h.insert("Jge_rel32_32", Code::Jge_rel32_32);
		let _ = h.insert("Jge_rel32_64", Code::Jge_rel32_64);
		let _ = h.insert("Jle_rel16", Code::Jle_rel16);
		let _ = h.insert("Jle_rel32_32", Code::Jle_rel32_32);
		let _ = h.insert("Jle_rel32_64", Code::Jle_rel32_64);
		let _ = h.insert("Jg_rel16", Code::Jg_rel16);
		let _ = h.insert("Jg_rel32_32", Code::Jg_rel32_32);
		let _ = h.insert("Jg_rel32_64", Code::Jg_rel32_64);
		let _ = h.insert("Seto_rm8", Code::Seto_rm8);
		let _ = h.insert("Setno_rm8", Code::Setno_rm8);
		let _ = h.insert("Setb_rm8", Code::Setb_rm8);
		let _ = h.insert("Setae_rm8", Code::Setae_rm8);
		let _ = h.insert("Sete_rm8", Code::Sete_rm8);
		let _ = h.insert("Setne_rm8", Code::Setne_rm8);
		let _ = h.insert("Setbe_rm8", Code::Setbe_rm8);
		let _ = h.insert("Seta_rm8", Code::Seta_rm8);
		let _ = h.insert("Sets_rm8", Code::Sets_rm8);
		let _ = h.insert("Setns_rm8", Code::Setns_rm8);
		let _ = h.insert("Setp_rm8", Code::Setp_rm8);
		let _ = h.insert("Setnp_rm8", Code::Setnp_rm8);
		let _ = h.insert("Setl_rm8", Code::Setl_rm8);
		let _ = h.insert("Setge_rm8", Code::Setge_rm8);
		let _ = h.insert("Setle_rm8", Code::Setle_rm8);
		let _ = h.insert("Setg_rm8", Code::Setg_rm8);
		let _ = h.insert("VEX_Kmovw_kr_km16", Code::VEX_Kmovw_kr_km16);
		let _ = h.insert("VEX_Kmovq_kr_km64", Code::VEX_Kmovq_kr_km64);
		let _ = h.insert("VEX_Kmovb_kr_km8", Code::VEX_Kmovb_kr_km8);
		let _ = h.insert("VEX_Kmovd_kr_km32", Code::VEX_Kmovd_kr_km32);
		let _ = h.insert("VEX_Kmovw_m16_kr", Code::VEX_Kmovw_m16_kr);
		let _ = h.insert("VEX_Kmovq_m64_kr", Code::VEX_Kmovq_m64_kr);
		let _ = h.insert("VEX_Kmovb_m8_kr", Code::VEX_Kmovb_m8_kr);
		let _ = h.insert("VEX_Kmovd_m32_kr", Code::VEX_Kmovd_m32_kr);
		let _ = h.insert("VEX_Kmovw_kr_r32", Code::VEX_Kmovw_kr_r32);
		let _ = h.insert("VEX_Kmovb_kr_r32", Code::VEX_Kmovb_kr_r32);
		let _ = h.insert("VEX_Kmovd_kr_r32", Code::VEX_Kmovd_kr_r32);
		let _ = h.insert("VEX_Kmovq_kr_r64", Code::VEX_Kmovq_kr_r64);
		let _ = h.insert("VEX_Kmovw_r32_kr", Code::VEX_Kmovw_r32_kr);
		let _ = h.insert("VEX_Kmovb_r32_kr", Code::VEX_Kmovb_r32_kr);
		let _ = h.insert("VEX_Kmovd_r32_kr", Code::VEX_Kmovd_r32_kr);
		let _ = h.insert("VEX_Kmovq_r64_kr", Code::VEX_Kmovq_r64_kr);
		let _ = h.insert("VEX_Kortestw_kr_kr", Code::VEX_Kortestw_kr_kr);
		let _ = h.insert("VEX_Kortestq_kr_kr", Code::VEX_Kortestq_kr_kr);
		let _ = h.insert("VEX_Kortestb_kr_kr", Code::VEX_Kortestb_kr_kr);
		let _ = h.insert("VEX_Kortestd_kr_kr", Code::VEX_Kortestd_kr_kr);
		let _ = h.insert("VEX_Ktestw_kr_kr", Code::VEX_Ktestw_kr_kr);
		let _ = h.insert("VEX_Ktestq_kr_kr", Code::VEX_Ktestq_kr_kr);
		let _ = h.insert("VEX_Ktestb_kr_kr", Code::VEX_Ktestb_kr_kr);
		let _ = h.insert("VEX_Ktestd_kr_kr", Code::VEX_Ktestd_kr_kr);
		let _ = h.insert("Pushw_FS", Code::Pushw_FS);
		let _ = h.insert("Pushd_FS", Code::Pushd_FS);
		let _ = h.insert("Pushq_FS", Code::Pushq_FS);
		let _ = h.insert("Popw_FS", Code::Popw_FS);
		let _ = h.insert("Popd_FS", Code::Popd_FS);
		let _ = h.insert("Popq_FS", Code::Popq_FS);
		let _ = h.insert("Cpuid", Code::Cpuid);
		let _ = h.insert("Bt_rm16_r16", Code::Bt_rm16_r16);
		let _ = h.insert("Bt_rm32_r32", Code::Bt_rm32_r32);
		let _ = h.insert("Bt_rm64_r64", Code::Bt_rm64_r64);
		let _ = h.insert("Shld_rm16_r16_imm8", Code::Shld_rm16_r16_imm8);
		let _ = h.insert("Shld_rm32_r32_imm8", Code::Shld_rm32_r32_imm8);
		let _ = h.insert("Shld_rm64_r64_imm8", Code::Shld_rm64_r64_imm8);
		let _ = h.insert("Shld_rm16_r16_CL", Code::Shld_rm16_r16_CL);
		let _ = h.insert("Shld_rm32_r32_CL", Code::Shld_rm32_r32_CL);
		let _ = h.insert("Shld_rm64_r64_CL", Code::Shld_rm64_r64_CL);
		let _ = h.insert("Montmul_16", Code::Montmul_16);
		let _ = h.insert("Montmul_32", Code::Montmul_32);
		let _ = h.insert("Montmul_64", Code::Montmul_64);
		let _ = h.insert("Xsha1_16", Code::Xsha1_16);
		let _ = h.insert("Xsha1_32", Code::Xsha1_32);
		let _ = h.insert("Xsha1_64", Code::Xsha1_64);
		let _ = h.insert("Xsha256_16", Code::Xsha256_16);
		let _ = h.insert("Xsha256_32", Code::Xsha256_32);
		let _ = h.insert("Xsha256_64", Code::Xsha256_64);
		let _ = h.insert("Xbts_r16_rm16", Code::Xbts_r16_rm16);
		let _ = h.insert("Xbts_r32_rm32", Code::Xbts_r32_rm32);
		let _ = h.insert("Xstore_16", Code::Xstore_16);
		let _ = h.insert("Xstore_32", Code::Xstore_32);
		let _ = h.insert("Xstore_64", Code::Xstore_64);
		let _ = h.insert("Xcryptecb_16", Code::Xcryptecb_16);
		let _ = h.insert("Xcryptecb_32", Code::Xcryptecb_32);
		let _ = h.insert("Xcryptecb_64", Code::Xcryptecb_64);
		let _ = h.insert("Xcryptcbc_16", Code::Xcryptcbc_16);
		let _ = h.insert("Xcryptcbc_32", Code::Xcryptcbc_32);
		let _ = h.insert("Xcryptcbc_64", Code::Xcryptcbc_64);
		let _ = h.insert("Xcryptctr_16", Code::Xcryptctr_16);
		let _ = h.insert("Xcryptctr_32", Code::Xcryptctr_32);
		let _ = h.insert("Xcryptctr_64", Code::Xcryptctr_64);
		let _ = h.insert("Xcryptcfb_16", Code::Xcryptcfb_16);
		let _ = h.insert("Xcryptcfb_32", Code::Xcryptcfb_32);
		let _ = h.insert("Xcryptcfb_64", Code::Xcryptcfb_64);
		let _ = h.insert("Xcryptofb_16", Code::Xcryptofb_16);
		let _ = h.insert("Xcryptofb_32", Code::Xcryptofb_32);
		let _ = h.insert("Xcryptofb_64", Code::Xcryptofb_64);
		let _ = h.insert("Ibts_rm16_r16", Code::Ibts_rm16_r16);
		let _ = h.insert("Ibts_rm32_r32", Code::Ibts_rm32_r32);
		let _ = h.insert("Cmpxchg486_rm8_r8", Code::Cmpxchg486_rm8_r8);
		let _ = h.insert("Cmpxchg486_rm16_r16", Code::Cmpxchg486_rm16_r16);
		let _ = h.insert("Cmpxchg486_rm32_r32", Code::Cmpxchg486_rm32_r32);
		let _ = h.insert("Pushw_GS", Code::Pushw_GS);
		let _ = h.insert("Pushd_GS", Code::Pushd_GS);
		let _ = h.insert("Pushq_GS", Code::Pushq_GS);
		let _ = h.insert("Popw_GS", Code::Popw_GS);
		let _ = h.insert("Popd_GS", Code::Popd_GS);
		let _ = h.insert("Popq_GS", Code::Popq_GS);
		let _ = h.insert("Rsm", Code::Rsm);
		let _ = h.insert("Bts_rm16_r16", Code::Bts_rm16_r16);
		let _ = h.insert("Bts_rm32_r32", Code::Bts_rm32_r32);
		let _ = h.insert("Bts_rm64_r64", Code::Bts_rm64_r64);
		let _ = h.insert("Shrd_rm16_r16_imm8", Code::Shrd_rm16_r16_imm8);
		let _ = h.insert("Shrd_rm32_r32_imm8", Code::Shrd_rm32_r32_imm8);
		let _ = h.insert("Shrd_rm64_r64_imm8", Code::Shrd_rm64_r64_imm8);
		let _ = h.insert("Shrd_rm16_r16_CL", Code::Shrd_rm16_r16_CL);
		let _ = h.insert("Shrd_rm32_r32_CL", Code::Shrd_rm32_r32_CL);
		let _ = h.insert("Shrd_rm64_r64_CL", Code::Shrd_rm64_r64_CL);
		let _ = h.insert("Fxsave_m512byte", Code::Fxsave_m512byte);
		let _ = h.insert("Fxsave64_m512byte", Code::Fxsave64_m512byte);
		let _ = h.insert("Rdfsbase_r32", Code::Rdfsbase_r32);
		let _ = h.insert("Rdfsbase_r64", Code::Rdfsbase_r64);
		let _ = h.insert("Fxrstor_m512byte", Code::Fxrstor_m512byte);
		let _ = h.insert("Fxrstor64_m512byte", Code::Fxrstor64_m512byte);
		let _ = h.insert("Rdgsbase_r32", Code::Rdgsbase_r32);
		let _ = h.insert("Rdgsbase_r64", Code::Rdgsbase_r64);
		let _ = h.insert("Ldmxcsr_m32", Code::Ldmxcsr_m32);
		let _ = h.insert("Wrfsbase_r32", Code::Wrfsbase_r32);
		let _ = h.insert("Wrfsbase_r64", Code::Wrfsbase_r64);
		let _ = h.insert("VEX_Vldmxcsr_m32", Code::VEX_Vldmxcsr_m32);
		let _ = h.insert("Stmxcsr_m32", Code::Stmxcsr_m32);
		let _ = h.insert("Wrgsbase_r32", Code::Wrgsbase_r32);
		let _ = h.insert("Wrgsbase_r64", Code::Wrgsbase_r64);
		let _ = h.insert("VEX_Vstmxcsr_m32", Code::VEX_Vstmxcsr_m32);
		let _ = h.insert("Xsave_mem", Code::Xsave_mem);
		let _ = h.insert("Xsave64_mem", Code::Xsave64_mem);
		let _ = h.insert("Ptwrite_rm32", Code::Ptwrite_rm32);
		let _ = h.insert("Ptwrite_rm64", Code::Ptwrite_rm64);
		let _ = h.insert("Xrstor_mem", Code::Xrstor_mem);
		let _ = h.insert("Xrstor64_mem", Code::Xrstor64_mem);
		let _ = h.insert("Incsspd_r32", Code::Incsspd_r32);
		let _ = h.insert("Incsspq_r64", Code::Incsspq_r64);
		let _ = h.insert("Xsaveopt_mem", Code::Xsaveopt_mem);
		let _ = h.insert("Xsaveopt64_mem", Code::Xsaveopt64_mem);
		let _ = h.insert("Clwb_m8", Code::Clwb_m8);
		let _ = h.insert("Tpause_r32", Code::Tpause_r32);
		let _ = h.insert("Tpause_r64", Code::Tpause_r64);
		let _ = h.insert("Clrssbsy_m64", Code::Clrssbsy_m64);
		let _ = h.insert("Umonitor_r16", Code::Umonitor_r16);
		let _ = h.insert("Umonitor_r32", Code::Umonitor_r32);
		let _ = h.insert("Umonitor_r64", Code::Umonitor_r64);
		let _ = h.insert("Umwait_r32", Code::Umwait_r32);
		let _ = h.insert("Umwait_r64", Code::Umwait_r64);
		let _ = h.insert("Clflush_m8", Code::Clflush_m8);
		let _ = h.insert("Clflushopt_m8", Code::Clflushopt_m8);
		let _ = h.insert("Lfence", Code::Lfence);
		let _ = h.insert("Lfence_E9", Code::Lfence_E9);
		let _ = h.insert("Lfence_EA", Code::Lfence_EA);
		let _ = h.insert("Lfence_EB", Code::Lfence_EB);
		let _ = h.insert("Lfence_EC", Code::Lfence_EC);
		let _ = h.insert("Lfence_ED", Code::Lfence_ED);
		let _ = h.insert("Lfence_EE", Code::Lfence_EE);
		let _ = h.insert("Lfence_EF", Code::Lfence_EF);
		let _ = h.insert("Mfence", Code::Mfence);
		let _ = h.insert("Mfence_F1", Code::Mfence_F1);
		let _ = h.insert("Mfence_F2", Code::Mfence_F2);
		let _ = h.insert("Mfence_F3", Code::Mfence_F3);
		let _ = h.insert("Mfence_F4", Code::Mfence_F4);
		let _ = h.insert("Mfence_F5", Code::Mfence_F5);
		let _ = h.insert("Mfence_F6", Code::Mfence_F6);
		let _ = h.insert("Mfence_F7", Code::Mfence_F7);
		let _ = h.insert("Sfence", Code::Sfence);
		let _ = h.insert("Sfence_F9", Code::Sfence_F9);
		let _ = h.insert("Sfence_FA", Code::Sfence_FA);
		let _ = h.insert("Sfence_FB", Code::Sfence_FB);
		let _ = h.insert("Sfence_FC", Code::Sfence_FC);
		let _ = h.insert("Sfence_FD", Code::Sfence_FD);
		let _ = h.insert("Sfence_FE", Code::Sfence_FE);
		let _ = h.insert("Sfence_FF", Code::Sfence_FF);
		let _ = h.insert("Pcommit", Code::Pcommit);
		let _ = h.insert("Imul_r16_rm16", Code::Imul_r16_rm16);
		let _ = h.insert("Imul_r32_rm32", Code::Imul_r32_rm32);
		let _ = h.insert("Imul_r64_rm64", Code::Imul_r64_rm64);
		let _ = h.insert("Cmpxchg_rm8_r8", Code::Cmpxchg_rm8_r8);
		let _ = h.insert("Cmpxchg_rm16_r16", Code::Cmpxchg_rm16_r16);
		let _ = h.insert("Cmpxchg_rm32_r32", Code::Cmpxchg_rm32_r32);
		let _ = h.insert("Cmpxchg_rm64_r64", Code::Cmpxchg_rm64_r64);
		let _ = h.insert("Lss_r16_m1616", Code::Lss_r16_m1616);
		let _ = h.insert("Lss_r32_m1632", Code::Lss_r32_m1632);
		let _ = h.insert("Lss_r64_m1664", Code::Lss_r64_m1664);
		let _ = h.insert("Btr_rm16_r16", Code::Btr_rm16_r16);
		let _ = h.insert("Btr_rm32_r32", Code::Btr_rm32_r32);
		let _ = h.insert("Btr_rm64_r64", Code::Btr_rm64_r64);
		let _ = h.insert("Lfs_r16_m1616", Code::Lfs_r16_m1616);
		let _ = h.insert("Lfs_r32_m1632", Code::Lfs_r32_m1632);
		let _ = h.insert("Lfs_r64_m1664", Code::Lfs_r64_m1664);
		let _ = h.insert("Lgs_r16_m1616", Code::Lgs_r16_m1616);
		let _ = h.insert("Lgs_r32_m1632", Code::Lgs_r32_m1632);
		let _ = h.insert("Lgs_r64_m1664", Code::Lgs_r64_m1664);
		let _ = h.insert("Movzx_r16_rm8", Code::Movzx_r16_rm8);
		let _ = h.insert("Movzx_r32_rm8", Code::Movzx_r32_rm8);
		let _ = h.insert("Movzx_r64_rm8", Code::Movzx_r64_rm8);
		let _ = h.insert("Movzx_r16_rm16", Code::Movzx_r16_rm16);
		let _ = h.insert("Movzx_r32_rm16", Code::Movzx_r32_rm16);
		let _ = h.insert("Movzx_r64_rm16", Code::Movzx_r64_rm16);
		let _ = h.insert("Jmpe_disp16", Code::Jmpe_disp16);
		let _ = h.insert("Jmpe_disp32", Code::Jmpe_disp32);
		let _ = h.insert("Popcnt_r16_rm16", Code::Popcnt_r16_rm16);
		let _ = h.insert("Popcnt_r32_rm32", Code::Popcnt_r32_rm32);
		let _ = h.insert("Popcnt_r64_rm64", Code::Popcnt_r64_rm64);
		let _ = h.insert("Ud1_r16_rm16", Code::Ud1_r16_rm16);
		let _ = h.insert("Ud1_r32_rm32", Code::Ud1_r32_rm32);
		let _ = h.insert("Ud1_r64_rm64", Code::Ud1_r64_rm64);
		let _ = h.insert("Bt_rm16_imm8", Code::Bt_rm16_imm8);
		let _ = h.insert("Bt_rm32_imm8", Code::Bt_rm32_imm8);
		let _ = h.insert("Bt_rm64_imm8", Code::Bt_rm64_imm8);
		let _ = h.insert("Bts_rm16_imm8", Code::Bts_rm16_imm8);
		let _ = h.insert("Bts_rm32_imm8", Code::Bts_rm32_imm8);
		let _ = h.insert("Bts_rm64_imm8", Code::Bts_rm64_imm8);
		let _ = h.insert("Btr_rm16_imm8", Code::Btr_rm16_imm8);
		let _ = h.insert("Btr_rm32_imm8", Code::Btr_rm32_imm8);
		let _ = h.insert("Btr_rm64_imm8", Code::Btr_rm64_imm8);
		let _ = h.insert("Btc_rm16_imm8", Code::Btc_rm16_imm8);
		let _ = h.insert("Btc_rm32_imm8", Code::Btc_rm32_imm8);
		let _ = h.insert("Btc_rm64_imm8", Code::Btc_rm64_imm8);
		let _ = h.insert("Btc_rm16_r16", Code::Btc_rm16_r16);
		let _ = h.insert("Btc_rm32_r32", Code::Btc_rm32_r32);
		let _ = h.insert("Btc_rm64_r64", Code::Btc_rm64_r64);
		let _ = h.insert("Bsf_r16_rm16", Code::Bsf_r16_rm16);
		let _ = h.insert("Bsf_r32_rm32", Code::Bsf_r32_rm32);
		let _ = h.insert("Bsf_r64_rm64", Code::Bsf_r64_rm64);
		let _ = h.insert("Tzcnt_r16_rm16", Code::Tzcnt_r16_rm16);
		let _ = h.insert("Tzcnt_r32_rm32", Code::Tzcnt_r32_rm32);
		let _ = h.insert("Tzcnt_r64_rm64", Code::Tzcnt_r64_rm64);
		let _ = h.insert("Bsr_r16_rm16", Code::Bsr_r16_rm16);
		let _ = h.insert("Bsr_r32_rm32", Code::Bsr_r32_rm32);
		let _ = h.insert("Bsr_r64_rm64", Code::Bsr_r64_rm64);
		let _ = h.insert("Lzcnt_r16_rm16", Code::Lzcnt_r16_rm16);
		let _ = h.insert("Lzcnt_r32_rm32", Code::Lzcnt_r32_rm32);
		let _ = h.insert("Lzcnt_r64_rm64", Code::Lzcnt_r64_rm64);
		let _ = h.insert("Movsx_r16_rm8", Code::Movsx_r16_rm8);
		let _ = h.insert("Movsx_r32_rm8", Code::Movsx_r32_rm8);
		let _ = h.insert("Movsx_r64_rm8", Code::Movsx_r64_rm8);
		let _ = h.insert("Movsx_r16_rm16", Code::Movsx_r16_rm16);
		let _ = h.insert("Movsx_r32_rm16", Code::Movsx_r32_rm16);
		let _ = h.insert("Movsx_r64_rm16", Code::Movsx_r64_rm16);
		let _ = h.insert("Xadd_rm8_r8", Code::Xadd_rm8_r8);
		let _ = h.insert("Xadd_rm16_r16", Code::Xadd_rm16_r16);
		let _ = h.insert("Xadd_rm32_r32", Code::Xadd_rm32_r32);
		let _ = h.insert("Xadd_rm64_r64", Code::Xadd_rm64_r64);
		let _ = h.insert("Cmpps_xmm_xmmm128_imm8", Code::Cmpps_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vcmpps_xmm_xmm_xmmm128_imm8", Code::VEX_Vcmpps_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vcmpps_ymm_ymm_ymmm256_imm8", Code::VEX_Vcmpps_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vcmpps_kr_k1_xmm_xmmm128b32_imm8", Code::EVEX_Vcmpps_kr_k1_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vcmpps_kr_k1_ymm_ymmm256b32_imm8", Code::EVEX_Vcmpps_kr_k1_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vcmpps_kr_k1_zmm_zmmm512b32_imm8_sae", Code::EVEX_Vcmpps_kr_k1_zmm_zmmm512b32_imm8_sae);
		let _ = h.insert("Cmppd_xmm_xmmm128_imm8", Code::Cmppd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vcmppd_xmm_xmm_xmmm128_imm8", Code::VEX_Vcmppd_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vcmppd_ymm_ymm_ymmm256_imm8", Code::VEX_Vcmppd_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vcmppd_kr_k1_xmm_xmmm128b64_imm8", Code::EVEX_Vcmppd_kr_k1_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vcmppd_kr_k1_ymm_ymmm256b64_imm8", Code::EVEX_Vcmppd_kr_k1_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vcmppd_kr_k1_zmm_zmmm512b64_imm8_sae", Code::EVEX_Vcmppd_kr_k1_zmm_zmmm512b64_imm8_sae);
		let _ = h.insert("Cmpss_xmm_xmmm32_imm8", Code::Cmpss_xmm_xmmm32_imm8);
		let _ = h.insert("VEX_Vcmpss_xmm_xmm_xmmm32_imm8", Code::VEX_Vcmpss_xmm_xmm_xmmm32_imm8);
		let _ = h.insert("EVEX_Vcmpss_kr_k1_xmm_xmmm32_imm8_sae", Code::EVEX_Vcmpss_kr_k1_xmm_xmmm32_imm8_sae);
		let _ = h.insert("Cmpsd_xmm_xmmm64_imm8", Code::Cmpsd_xmm_xmmm64_imm8);
		let _ = h.insert("VEX_Vcmpsd_xmm_xmm_xmmm64_imm8", Code::VEX_Vcmpsd_xmm_xmm_xmmm64_imm8);
		let _ = h.insert("EVEX_Vcmpsd_kr_k1_xmm_xmmm64_imm8_sae", Code::EVEX_Vcmpsd_kr_k1_xmm_xmmm64_imm8_sae);
		let _ = h.insert("Movnti_m32_r32", Code::Movnti_m32_r32);
		let _ = h.insert("Movnti_m64_r64", Code::Movnti_m64_r64);
		let _ = h.insert("Pinsrw_mm_r32m16_imm8", Code::Pinsrw_mm_r32m16_imm8);
		let _ = h.insert("Pinsrw_mm_r64m16_imm8", Code::Pinsrw_mm_r64m16_imm8);
		let _ = h.insert("Pinsrw_xmm_r32m16_imm8", Code::Pinsrw_xmm_r32m16_imm8);
		let _ = h.insert("Pinsrw_xmm_r64m16_imm8", Code::Pinsrw_xmm_r64m16_imm8);
		let _ = h.insert("VEX_Vpinsrw_xmm_xmm_r32m16_imm8", Code::VEX_Vpinsrw_xmm_xmm_r32m16_imm8);
		let _ = h.insert("VEX_Vpinsrw_xmm_xmm_r64m16_imm8", Code::VEX_Vpinsrw_xmm_xmm_r64m16_imm8);
		let _ = h.insert("EVEX_Vpinsrw_xmm_xmm_r32m16_imm8", Code::EVEX_Vpinsrw_xmm_xmm_r32m16_imm8);
		let _ = h.insert("EVEX_Vpinsrw_xmm_xmm_r64m16_imm8", Code::EVEX_Vpinsrw_xmm_xmm_r64m16_imm8);
		let _ = h.insert("Pextrw_r32_mm_imm8", Code::Pextrw_r32_mm_imm8);
		let _ = h.insert("Pextrw_r64_mm_imm8", Code::Pextrw_r64_mm_imm8);
		let _ = h.insert("Pextrw_r32_xmm_imm8", Code::Pextrw_r32_xmm_imm8);
		let _ = h.insert("Pextrw_r64_xmm_imm8", Code::Pextrw_r64_xmm_imm8);
		let _ = h.insert("VEX_Vpextrw_r32_xmm_imm8", Code::VEX_Vpextrw_r32_xmm_imm8);
		let _ = h.insert("VEX_Vpextrw_r64_xmm_imm8", Code::VEX_Vpextrw_r64_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrw_r32_xmm_imm8", Code::EVEX_Vpextrw_r32_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrw_r64_xmm_imm8", Code::EVEX_Vpextrw_r64_xmm_imm8);
		let _ = h.insert("Shufps_xmm_xmmm128_imm8", Code::Shufps_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vshufps_xmm_xmm_xmmm128_imm8", Code::VEX_Vshufps_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vshufps_ymm_ymm_ymmm256_imm8", Code::VEX_Vshufps_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vshufps_xmm_k1z_xmm_xmmm128b32_imm8", Code::EVEX_Vshufps_xmm_k1z_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vshufps_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vshufps_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vshufps_zmm_k1z_zmm_zmmm512b32_imm8", Code::EVEX_Vshufps_zmm_k1z_zmm_zmmm512b32_imm8);
		let _ = h.insert("Shufpd_xmm_xmmm128_imm8", Code::Shufpd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vshufpd_xmm_xmm_xmmm128_imm8", Code::VEX_Vshufpd_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vshufpd_ymm_ymm_ymmm256_imm8", Code::VEX_Vshufpd_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vshufpd_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vshufpd_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vshufpd_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vshufpd_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vshufpd_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vshufpd_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("Cmpxchg8b_m64", Code::Cmpxchg8b_m64);
		let _ = h.insert("Cmpxchg16b_m128", Code::Cmpxchg16b_m128);
		let _ = h.insert("Xrstors_mem", Code::Xrstors_mem);
		let _ = h.insert("Xrstors64_mem", Code::Xrstors64_mem);
		let _ = h.insert("Xsavec_mem", Code::Xsavec_mem);
		let _ = h.insert("Xsavec64_mem", Code::Xsavec64_mem);
		let _ = h.insert("Xsaves_mem", Code::Xsaves_mem);
		let _ = h.insert("Xsaves64_mem", Code::Xsaves64_mem);
		let _ = h.insert("Vmptrld_m64", Code::Vmptrld_m64);
		let _ = h.insert("Vmclear_m64", Code::Vmclear_m64);
		let _ = h.insert("Vmxon_m64", Code::Vmxon_m64);
		let _ = h.insert("Rdrand_r16", Code::Rdrand_r16);
		let _ = h.insert("Rdrand_r32", Code::Rdrand_r32);
		let _ = h.insert("Rdrand_r64", Code::Rdrand_r64);
		let _ = h.insert("Vmptrst_m64", Code::Vmptrst_m64);
		let _ = h.insert("Rdseed_r16", Code::Rdseed_r16);
		let _ = h.insert("Rdseed_r32", Code::Rdseed_r32);
		let _ = h.insert("Rdseed_r64", Code::Rdseed_r64);
		let _ = h.insert("Rdpid_r32", Code::Rdpid_r32);
		let _ = h.insert("Rdpid_r64", Code::Rdpid_r64);
		let _ = h.insert("Bswap_r16", Code::Bswap_r16);
		let _ = h.insert("Bswap_r32", Code::Bswap_r32);
		let _ = h.insert("Bswap_r64", Code::Bswap_r64);
		let _ = h.insert("Addsubpd_xmm_xmmm128", Code::Addsubpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddsubpd_xmm_xmm_xmmm128", Code::VEX_Vaddsubpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddsubpd_ymm_ymm_ymmm256", Code::VEX_Vaddsubpd_ymm_ymm_ymmm256);
		let _ = h.insert("Addsubps_xmm_xmmm128", Code::Addsubps_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddsubps_xmm_xmm_xmmm128", Code::VEX_Vaddsubps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaddsubps_ymm_ymm_ymmm256", Code::VEX_Vaddsubps_ymm_ymm_ymmm256);
		let _ = h.insert("Psrlw_mm_mmm64", Code::Psrlw_mm_mmm64);
		let _ = h.insert("Psrlw_xmm_xmmm128", Code::Psrlw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrlw_xmm_xmm_xmmm128", Code::VEX_Vpsrlw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrlw_ymm_ymm_xmmm128", Code::VEX_Vpsrlw_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsrlw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlw_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsrlw_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlw_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsrlw_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Psrld_mm_mmm64", Code::Psrld_mm_mmm64);
		let _ = h.insert("Psrld_xmm_xmmm128", Code::Psrld_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrld_xmm_xmm_xmmm128", Code::VEX_Vpsrld_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrld_ymm_ymm_xmmm128", Code::VEX_Vpsrld_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrld_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsrld_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsrld_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsrld_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrld_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsrld_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Psrlq_mm_mmm64", Code::Psrlq_mm_mmm64);
		let _ = h.insert("Psrlq_xmm_xmmm128", Code::Psrlq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrlq_xmm_xmm_xmmm128", Code::VEX_Vpsrlq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrlq_ymm_ymm_xmmm128", Code::VEX_Vpsrlq_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlq_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsrlq_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlq_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsrlq_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlq_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsrlq_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Paddq_mm_mmm64", Code::Paddq_mm_mmm64);
		let _ = h.insert("Paddq_xmm_xmmm128", Code::Paddq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddq_xmm_xmm_xmmm128", Code::VEX_Vpaddq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddq_ymm_ymm_ymmm256", Code::VEX_Vpaddq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpaddq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpaddq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpaddq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpaddq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpaddq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Pmullw_mm_mmm64", Code::Pmullw_mm_mmm64);
		let _ = h.insert("Pmullw_xmm_xmmm128", Code::Pmullw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmullw_xmm_xmm_xmmm128", Code::VEX_Vpmullw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmullw_ymm_ymm_ymmm256", Code::VEX_Vpmullw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmullw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmullw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmullw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmullw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmullw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmullw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Movq_xmmm64_xmm", Code::Movq_xmmm64_xmm);
		let _ = h.insert("VEX_Vmovq_xmmm64_xmm", Code::VEX_Vmovq_xmmm64_xmm);
		let _ = h.insert("EVEX_Vmovq_xmmm64_xmm", Code::EVEX_Vmovq_xmmm64_xmm);
		let _ = h.insert("Movq2dq_xmm_mm", Code::Movq2dq_xmm_mm);
		let _ = h.insert("Movdq2q_mm_xmm", Code::Movdq2q_mm_xmm);
		let _ = h.insert("Pmovmskb_r32_mm", Code::Pmovmskb_r32_mm);
		let _ = h.insert("Pmovmskb_r64_mm", Code::Pmovmskb_r64_mm);
		let _ = h.insert("Pmovmskb_r32_xmm", Code::Pmovmskb_r32_xmm);
		let _ = h.insert("Pmovmskb_r64_xmm", Code::Pmovmskb_r64_xmm);
		let _ = h.insert("VEX_Vpmovmskb_r32_xmm", Code::VEX_Vpmovmskb_r32_xmm);
		let _ = h.insert("VEX_Vpmovmskb_r64_xmm", Code::VEX_Vpmovmskb_r64_xmm);
		let _ = h.insert("VEX_Vpmovmskb_r32_ymm", Code::VEX_Vpmovmskb_r32_ymm);
		let _ = h.insert("VEX_Vpmovmskb_r64_ymm", Code::VEX_Vpmovmskb_r64_ymm);
		let _ = h.insert("Psubusb_mm_mmm64", Code::Psubusb_mm_mmm64);
		let _ = h.insert("Psubusb_xmm_xmmm128", Code::Psubusb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubusb_xmm_xmm_xmmm128", Code::VEX_Vpsubusb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubusb_ymm_ymm_ymmm256", Code::VEX_Vpsubusb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubusb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsubusb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsubusb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsubusb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubusb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsubusb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Psubusw_mm_mmm64", Code::Psubusw_mm_mmm64);
		let _ = h.insert("Psubusw_xmm_xmmm128", Code::Psubusw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubusw_xmm_xmm_xmmm128", Code::VEX_Vpsubusw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubusw_ymm_ymm_ymmm256", Code::VEX_Vpsubusw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubusw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsubusw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsubusw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsubusw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubusw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsubusw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pminub_mm_mmm64", Code::Pminub_mm_mmm64);
		let _ = h.insert("Pminub_xmm_xmmm128", Code::Pminub_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminub_xmm_xmm_xmmm128", Code::VEX_Vpminub_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminub_ymm_ymm_ymmm256", Code::VEX_Vpminub_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminub_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpminub_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpminub_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpminub_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminub_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpminub_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pand_mm_mmm64", Code::Pand_mm_mmm64);
		let _ = h.insert("Pand_xmm_xmmm128", Code::Pand_xmm_xmmm128);
		let _ = h.insert("VEX_Vpand_xmm_xmm_xmmm128", Code::VEX_Vpand_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpand_ymm_ymm_ymmm256", Code::VEX_Vpand_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpandd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpandd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpandd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpandd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpandd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpandd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpandq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpandq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpandq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpandq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpandq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpandq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Paddusb_mm_mmm64", Code::Paddusb_mm_mmm64);
		let _ = h.insert("Paddusb_xmm_xmmm128", Code::Paddusb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddusb_xmm_xmm_xmmm128", Code::VEX_Vpaddusb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddusb_ymm_ymm_ymmm256", Code::VEX_Vpaddusb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddusb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpaddusb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpaddusb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpaddusb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddusb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpaddusb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Paddusw_mm_mmm64", Code::Paddusw_mm_mmm64);
		let _ = h.insert("Paddusw_xmm_xmmm128", Code::Paddusw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddusw_xmm_xmm_xmmm128", Code::VEX_Vpaddusw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddusw_ymm_ymm_ymmm256", Code::VEX_Vpaddusw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddusw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpaddusw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpaddusw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpaddusw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddusw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpaddusw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pmaxub_mm_mmm64", Code::Pmaxub_mm_mmm64);
		let _ = h.insert("Pmaxub_xmm_xmmm128", Code::Pmaxub_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxub_xmm_xmm_xmmm128", Code::VEX_Vpmaxub_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxub_ymm_ymm_ymmm256", Code::VEX_Vpmaxub_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxub_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmaxub_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmaxub_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmaxub_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxub_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmaxub_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pandn_mm_mmm64", Code::Pandn_mm_mmm64);
		let _ = h.insert("Pandn_xmm_xmmm128", Code::Pandn_xmm_xmmm128);
		let _ = h.insert("VEX_Vpandn_xmm_xmm_xmmm128", Code::VEX_Vpandn_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpandn_ymm_ymm_ymmm256", Code::VEX_Vpandn_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpandnd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpandnd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpandnd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpandnd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpandnd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpandnd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpandnq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpandnq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpandnq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpandnq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpandnq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpandnq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Pavgb_mm_mmm64", Code::Pavgb_mm_mmm64);
		let _ = h.insert("Pavgb_xmm_xmmm128", Code::Pavgb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpavgb_xmm_xmm_xmmm128", Code::VEX_Vpavgb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpavgb_ymm_ymm_ymmm256", Code::VEX_Vpavgb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpavgb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpavgb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpavgb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpavgb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpavgb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpavgb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Psraw_mm_mmm64", Code::Psraw_mm_mmm64);
		let _ = h.insert("Psraw_xmm_xmmm128", Code::Psraw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsraw_xmm_xmm_xmmm128", Code::VEX_Vpsraw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsraw_ymm_ymm_xmmm128", Code::VEX_Vpsraw_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsraw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsraw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsraw_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsraw_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsraw_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsraw_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Psrad_mm_mmm64", Code::Psrad_mm_mmm64);
		let _ = h.insert("Psrad_xmm_xmmm128", Code::Psrad_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrad_xmm_xmm_xmmm128", Code::VEX_Vpsrad_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrad_ymm_ymm_xmmm128", Code::VEX_Vpsrad_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrad_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsrad_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsrad_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsrad_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsrad_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsrad_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("EVEX_Vpsraq_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsraq_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsraq_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsraq_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsraq_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsraq_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Pavgw_mm_mmm64", Code::Pavgw_mm_mmm64);
		let _ = h.insert("Pavgw_xmm_xmmm128", Code::Pavgw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpavgw_xmm_xmm_xmmm128", Code::VEX_Vpavgw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpavgw_ymm_ymm_ymmm256", Code::VEX_Vpavgw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpavgw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpavgw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpavgw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpavgw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpavgw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpavgw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pmulhuw_mm_mmm64", Code::Pmulhuw_mm_mmm64);
		let _ = h.insert("Pmulhuw_xmm_xmmm128", Code::Pmulhuw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulhuw_xmm_xmm_xmmm128", Code::VEX_Vpmulhuw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulhuw_ymm_ymm_ymmm256", Code::VEX_Vpmulhuw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmulhuw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmulhuw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmulhuw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmulhuw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmulhuw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmulhuw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pmulhw_mm_mmm64", Code::Pmulhw_mm_mmm64);
		let _ = h.insert("Pmulhw_xmm_xmmm128", Code::Pmulhw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulhw_xmm_xmm_xmmm128", Code::VEX_Vpmulhw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulhw_ymm_ymm_ymmm256", Code::VEX_Vpmulhw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmulhw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmulhw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmulhw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmulhw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmulhw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmulhw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Cvttpd2dq_xmm_xmmm128", Code::Cvttpd2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvttpd2dq_xmm_xmmm128", Code::VEX_Vcvttpd2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvttpd2dq_xmm_ymmm256", Code::VEX_Vcvttpd2dq_xmm_ymmm256);
		let _ = h.insert("EVEX_Vcvttpd2dq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvttpd2dq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvttpd2dq_xmm_k1z_ymmm256b64", Code::EVEX_Vcvttpd2dq_xmm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvttpd2dq_ymm_k1z_zmmm512b64_sae", Code::EVEX_Vcvttpd2dq_ymm_k1z_zmmm512b64_sae);
		let _ = h.insert("Cvtdq2pd_xmm_xmmm64", Code::Cvtdq2pd_xmm_xmmm64);
		let _ = h.insert("VEX_Vcvtdq2pd_xmm_xmmm64", Code::VEX_Vcvtdq2pd_xmm_xmmm64);
		let _ = h.insert("VEX_Vcvtdq2pd_ymm_xmmm128", Code::VEX_Vcvtdq2pd_ymm_xmmm128);
		let _ = h.insert("EVEX_Vcvtdq2pd_xmm_k1z_xmmm64b32", Code::EVEX_Vcvtdq2pd_xmm_k1z_xmmm64b32);
		let _ = h.insert("EVEX_Vcvtdq2pd_ymm_k1z_xmmm128b32", Code::EVEX_Vcvtdq2pd_ymm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtdq2pd_zmm_k1z_ymmm256b32_er", Code::EVEX_Vcvtdq2pd_zmm_k1z_ymmm256b32_er);
		let _ = h.insert("EVEX_Vcvtqq2pd_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtqq2pd_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtqq2pd_ymm_k1z_ymmm256b64", Code::EVEX_Vcvtqq2pd_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtqq2pd_zmm_k1z_zmmm512b64_er", Code::EVEX_Vcvtqq2pd_zmm_k1z_zmmm512b64_er);
		let _ = h.insert("Cvtpd2dq_xmm_xmmm128", Code::Cvtpd2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtpd2dq_xmm_xmmm128", Code::VEX_Vcvtpd2dq_xmm_xmmm128);
		let _ = h.insert("VEX_Vcvtpd2dq_xmm_ymmm256", Code::VEX_Vcvtpd2dq_xmm_ymmm256);
		let _ = h.insert("EVEX_Vcvtpd2dq_xmm_k1z_xmmm128b64", Code::EVEX_Vcvtpd2dq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vcvtpd2dq_xmm_k1z_ymmm256b64", Code::EVEX_Vcvtpd2dq_xmm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vcvtpd2dq_ymm_k1z_zmmm512b64_er", Code::EVEX_Vcvtpd2dq_ymm_k1z_zmmm512b64_er);
		let _ = h.insert("Movntq_m64_mm", Code::Movntq_m64_mm);
		let _ = h.insert("Movntdq_m128_xmm", Code::Movntdq_m128_xmm);
		let _ = h.insert("VEX_Vmovntdq_m128_xmm", Code::VEX_Vmovntdq_m128_xmm);
		let _ = h.insert("VEX_Vmovntdq_m256_ymm", Code::VEX_Vmovntdq_m256_ymm);
		let _ = h.insert("EVEX_Vmovntdq_m128_xmm", Code::EVEX_Vmovntdq_m128_xmm);
		let _ = h.insert("EVEX_Vmovntdq_m256_ymm", Code::EVEX_Vmovntdq_m256_ymm);
		let _ = h.insert("EVEX_Vmovntdq_m512_zmm", Code::EVEX_Vmovntdq_m512_zmm);
		let _ = h.insert("Psubsb_mm_mmm64", Code::Psubsb_mm_mmm64);
		let _ = h.insert("Psubsb_xmm_xmmm128", Code::Psubsb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubsb_xmm_xmm_xmmm128", Code::VEX_Vpsubsb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubsb_ymm_ymm_ymmm256", Code::VEX_Vpsubsb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubsb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsubsb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsubsb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsubsb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubsb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsubsb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Psubsw_mm_mmm64", Code::Psubsw_mm_mmm64);
		let _ = h.insert("Psubsw_xmm_xmmm128", Code::Psubsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubsw_xmm_xmm_xmmm128", Code::VEX_Vpsubsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubsw_ymm_ymm_ymmm256", Code::VEX_Vpsubsw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubsw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsubsw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsubsw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsubsw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubsw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsubsw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pminsw_mm_mmm64", Code::Pminsw_mm_mmm64);
		let _ = h.insert("Pminsw_xmm_xmmm128", Code::Pminsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminsw_xmm_xmm_xmmm128", Code::VEX_Vpminsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminsw_ymm_ymm_ymmm256", Code::VEX_Vpminsw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminsw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpminsw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpminsw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpminsw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminsw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpminsw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Por_mm_mmm64", Code::Por_mm_mmm64);
		let _ = h.insert("Por_xmm_xmmm128", Code::Por_xmm_xmmm128);
		let _ = h.insert("VEX_Vpor_xmm_xmm_xmmm128", Code::VEX_Vpor_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpor_ymm_ymm_ymmm256", Code::VEX_Vpor_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpord_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpord_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpord_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpord_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpord_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpord_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vporq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vporq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vporq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vporq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vporq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vporq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Paddsb_mm_mmm64", Code::Paddsb_mm_mmm64);
		let _ = h.insert("Paddsb_xmm_xmmm128", Code::Paddsb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddsb_xmm_xmm_xmmm128", Code::VEX_Vpaddsb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddsb_ymm_ymm_ymmm256", Code::VEX_Vpaddsb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddsb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpaddsb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpaddsb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpaddsb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddsb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpaddsb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Paddsw_mm_mmm64", Code::Paddsw_mm_mmm64);
		let _ = h.insert("Paddsw_xmm_xmmm128", Code::Paddsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddsw_xmm_xmm_xmmm128", Code::VEX_Vpaddsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddsw_ymm_ymm_ymmm256", Code::VEX_Vpaddsw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddsw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpaddsw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpaddsw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpaddsw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddsw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpaddsw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pmaxsw_mm_mmm64", Code::Pmaxsw_mm_mmm64);
		let _ = h.insert("Pmaxsw_xmm_xmmm128", Code::Pmaxsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxsw_xmm_xmm_xmmm128", Code::VEX_Vpmaxsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxsw_ymm_ymm_ymmm256", Code::VEX_Vpmaxsw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxsw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmaxsw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmaxsw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmaxsw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxsw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmaxsw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pxor_mm_mmm64", Code::Pxor_mm_mmm64);
		let _ = h.insert("Pxor_xmm_xmmm128", Code::Pxor_xmm_xmmm128);
		let _ = h.insert("VEX_Vpxor_xmm_xmm_xmmm128", Code::VEX_Vpxor_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpxor_ymm_ymm_ymmm256", Code::VEX_Vpxor_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpxord_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpxord_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpxord_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpxord_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpxord_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpxord_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpxorq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpxorq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpxorq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpxorq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpxorq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpxorq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Lddqu_xmm_m128", Code::Lddqu_xmm_m128);
		let _ = h.insert("VEX_Vlddqu_xmm_m128", Code::VEX_Vlddqu_xmm_m128);
		let _ = h.insert("VEX_Vlddqu_ymm_m256", Code::VEX_Vlddqu_ymm_m256);
		let _ = h.insert("Psllw_mm_mmm64", Code::Psllw_mm_mmm64);
		let _ = h.insert("Psllw_xmm_xmmm128", Code::Psllw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsllw_xmm_xmm_xmmm128", Code::VEX_Vpsllw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsllw_ymm_ymm_xmmm128", Code::VEX_Vpsllw_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsllw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsllw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsllw_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsllw_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsllw_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsllw_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Pslld_mm_mmm64", Code::Pslld_mm_mmm64);
		let _ = h.insert("Pslld_xmm_xmmm128", Code::Pslld_xmm_xmmm128);
		let _ = h.insert("VEX_Vpslld_xmm_xmm_xmmm128", Code::VEX_Vpslld_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpslld_ymm_ymm_xmmm128", Code::VEX_Vpslld_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpslld_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpslld_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpslld_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpslld_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpslld_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpslld_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Psllq_mm_mmm64", Code::Psllq_mm_mmm64);
		let _ = h.insert("Psllq_xmm_xmmm128", Code::Psllq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsllq_xmm_xmm_xmmm128", Code::VEX_Vpsllq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsllq_ymm_ymm_xmmm128", Code::VEX_Vpsllq_ymm_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsllq_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsllq_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsllq_ymm_k1z_ymm_xmmm128", Code::EVEX_Vpsllq_ymm_k1z_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpsllq_zmm_k1z_zmm_xmmm128", Code::EVEX_Vpsllq_zmm_k1z_zmm_xmmm128);
		let _ = h.insert("Pmuludq_mm_mmm64", Code::Pmuludq_mm_mmm64);
		let _ = h.insert("Pmuludq_xmm_xmmm128", Code::Pmuludq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmuludq_xmm_xmm_xmmm128", Code::VEX_Vpmuludq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmuludq_ymm_ymm_ymmm256", Code::VEX_Vpmuludq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmuludq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmuludq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmuludq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmuludq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmuludq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmuludq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Pmaddwd_mm_mmm64", Code::Pmaddwd_mm_mmm64);
		let _ = h.insert("Pmaddwd_xmm_xmmm128", Code::Pmaddwd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaddwd_xmm_xmm_xmmm128", Code::VEX_Vpmaddwd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaddwd_ymm_ymm_ymmm256", Code::VEX_Vpmaddwd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaddwd_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmaddwd_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmaddwd_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmaddwd_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaddwd_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmaddwd_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Psadbw_mm_mmm64", Code::Psadbw_mm_mmm64);
		let _ = h.insert("Psadbw_xmm_xmmm128", Code::Psadbw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsadbw_xmm_xmm_xmmm128", Code::VEX_Vpsadbw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsadbw_ymm_ymm_ymmm256", Code::VEX_Vpsadbw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsadbw_xmm_xmm_xmmm128", Code::EVEX_Vpsadbw_xmm_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsadbw_ymm_ymm_ymmm256", Code::EVEX_Vpsadbw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsadbw_zmm_zmm_zmmm512", Code::EVEX_Vpsadbw_zmm_zmm_zmmm512);
		let _ = h.insert("Maskmovq_rDI_mm_mm", Code::Maskmovq_rDI_mm_mm);
		let _ = h.insert("Maskmovdqu_rDI_xmm_xmm", Code::Maskmovdqu_rDI_xmm_xmm);
		let _ = h.insert("VEX_Vmaskmovdqu_rDI_xmm_xmm", Code::VEX_Vmaskmovdqu_rDI_xmm_xmm);
		let _ = h.insert("Psubb_mm_mmm64", Code::Psubb_mm_mmm64);
		let _ = h.insert("Psubb_xmm_xmmm128", Code::Psubb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubb_xmm_xmm_xmmm128", Code::VEX_Vpsubb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubb_ymm_ymm_ymmm256", Code::VEX_Vpsubb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsubb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsubb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsubb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsubb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Psubw_mm_mmm64", Code::Psubw_mm_mmm64);
		let _ = h.insert("Psubw_xmm_xmmm128", Code::Psubw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubw_xmm_xmm_xmmm128", Code::VEX_Vpsubw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubw_ymm_ymm_ymmm256", Code::VEX_Vpsubw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsubw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsubw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsubw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsubw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Psubd_mm_mmm64", Code::Psubd_mm_mmm64);
		let _ = h.insert("Psubd_xmm_xmmm128", Code::Psubd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubd_xmm_xmm_xmmm128", Code::VEX_Vpsubd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubd_ymm_ymm_ymmm256", Code::VEX_Vpsubd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpsubd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpsubd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpsubd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpsubd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpsubd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Psubq_mm_mmm64", Code::Psubq_mm_mmm64);
		let _ = h.insert("Psubq_xmm_xmmm128", Code::Psubq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubq_xmm_xmm_xmmm128", Code::VEX_Vpsubq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsubq_ymm_ymm_ymmm256", Code::VEX_Vpsubq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsubq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpsubq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpsubq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpsubq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpsubq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpsubq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Paddb_mm_mmm64", Code::Paddb_mm_mmm64);
		let _ = h.insert("Paddb_xmm_xmmm128", Code::Paddb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddb_xmm_xmm_xmmm128", Code::VEX_Vpaddb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddb_ymm_ymm_ymmm256", Code::VEX_Vpaddb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpaddb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpaddb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpaddb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpaddb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Paddw_mm_mmm64", Code::Paddw_mm_mmm64);
		let _ = h.insert("Paddw_xmm_xmmm128", Code::Paddw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddw_xmm_xmm_xmmm128", Code::VEX_Vpaddw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddw_ymm_ymm_ymmm256", Code::VEX_Vpaddw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpaddw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpaddw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpaddw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpaddw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Paddd_mm_mmm64", Code::Paddd_mm_mmm64);
		let _ = h.insert("Paddd_xmm_xmmm128", Code::Paddd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddd_xmm_xmm_xmmm128", Code::VEX_Vpaddd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpaddd_ymm_ymm_ymmm256", Code::VEX_Vpaddd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpaddd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpaddd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpaddd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpaddd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpaddd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpaddd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("Ud0_r16_rm16", Code::Ud0_r16_rm16);
		let _ = h.insert("Ud0_r32_rm32", Code::Ud0_r32_rm32);
		let _ = h.insert("Ud0_r64_rm64", Code::Ud0_r64_rm64);
		let _ = h.insert("Pshufb_mm_mmm64", Code::Pshufb_mm_mmm64);
		let _ = h.insert("Pshufb_xmm_xmmm128", Code::Pshufb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpshufb_xmm_xmm_xmmm128", Code::VEX_Vpshufb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpshufb_ymm_ymm_ymmm256", Code::VEX_Vpshufb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpshufb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpshufb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpshufb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpshufb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpshufb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpshufb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Phaddw_mm_mmm64", Code::Phaddw_mm_mmm64);
		let _ = h.insert("Phaddw_xmm_xmmm128", Code::Phaddw_xmm_xmmm128);
		let _ = h.insert("VEX_Vphaddw_xmm_xmm_xmmm128", Code::VEX_Vphaddw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vphaddw_ymm_ymm_ymmm256", Code::VEX_Vphaddw_ymm_ymm_ymmm256);
		let _ = h.insert("Phaddd_mm_mmm64", Code::Phaddd_mm_mmm64);
		let _ = h.insert("Phaddd_xmm_xmmm128", Code::Phaddd_xmm_xmmm128);
		let _ = h.insert("VEX_Vphaddd_xmm_xmm_xmmm128", Code::VEX_Vphaddd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vphaddd_ymm_ymm_ymmm256", Code::VEX_Vphaddd_ymm_ymm_ymmm256);
		let _ = h.insert("Phaddsw_mm_mmm64", Code::Phaddsw_mm_mmm64);
		let _ = h.insert("Phaddsw_xmm_xmmm128", Code::Phaddsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vphaddsw_xmm_xmm_xmmm128", Code::VEX_Vphaddsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vphaddsw_ymm_ymm_ymmm256", Code::VEX_Vphaddsw_ymm_ymm_ymmm256);
		let _ = h.insert("Pmaddubsw_mm_mmm64", Code::Pmaddubsw_mm_mmm64);
		let _ = h.insert("Pmaddubsw_xmm_xmmm128", Code::Pmaddubsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaddubsw_xmm_xmm_xmmm128", Code::VEX_Vpmaddubsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaddubsw_ymm_ymm_ymmm256", Code::VEX_Vpmaddubsw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaddubsw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmaddubsw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmaddubsw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmaddubsw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaddubsw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmaddubsw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Phsubw_mm_mmm64", Code::Phsubw_mm_mmm64);
		let _ = h.insert("Phsubw_xmm_xmmm128", Code::Phsubw_xmm_xmmm128);
		let _ = h.insert("VEX_Vphsubw_xmm_xmm_xmmm128", Code::VEX_Vphsubw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vphsubw_ymm_ymm_ymmm256", Code::VEX_Vphsubw_ymm_ymm_ymmm256);
		let _ = h.insert("Phsubd_mm_mmm64", Code::Phsubd_mm_mmm64);
		let _ = h.insert("Phsubd_xmm_xmmm128", Code::Phsubd_xmm_xmmm128);
		let _ = h.insert("VEX_Vphsubd_xmm_xmm_xmmm128", Code::VEX_Vphsubd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vphsubd_ymm_ymm_ymmm256", Code::VEX_Vphsubd_ymm_ymm_ymmm256);
		let _ = h.insert("Phsubsw_mm_mmm64", Code::Phsubsw_mm_mmm64);
		let _ = h.insert("Phsubsw_xmm_xmmm128", Code::Phsubsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vphsubsw_xmm_xmm_xmmm128", Code::VEX_Vphsubsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vphsubsw_ymm_ymm_ymmm256", Code::VEX_Vphsubsw_ymm_ymm_ymmm256);
		let _ = h.insert("Psignb_mm_mmm64", Code::Psignb_mm_mmm64);
		let _ = h.insert("Psignb_xmm_xmmm128", Code::Psignb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsignb_xmm_xmm_xmmm128", Code::VEX_Vpsignb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsignb_ymm_ymm_ymmm256", Code::VEX_Vpsignb_ymm_ymm_ymmm256);
		let _ = h.insert("Psignw_mm_mmm64", Code::Psignw_mm_mmm64);
		let _ = h.insert("Psignw_xmm_xmmm128", Code::Psignw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsignw_xmm_xmm_xmmm128", Code::VEX_Vpsignw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsignw_ymm_ymm_ymmm256", Code::VEX_Vpsignw_ymm_ymm_ymmm256);
		let _ = h.insert("Psignd_mm_mmm64", Code::Psignd_mm_mmm64);
		let _ = h.insert("Psignd_xmm_xmmm128", Code::Psignd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsignd_xmm_xmm_xmmm128", Code::VEX_Vpsignd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsignd_ymm_ymm_ymmm256", Code::VEX_Vpsignd_ymm_ymm_ymmm256);
		let _ = h.insert("Pmulhrsw_mm_mmm64", Code::Pmulhrsw_mm_mmm64);
		let _ = h.insert("Pmulhrsw_xmm_xmmm128", Code::Pmulhrsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulhrsw_xmm_xmm_xmmm128", Code::VEX_Vpmulhrsw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulhrsw_ymm_ymm_ymmm256", Code::VEX_Vpmulhrsw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmulhrsw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmulhrsw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmulhrsw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmulhrsw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmulhrsw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmulhrsw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("VEX_Vpermilps_xmm_xmm_xmmm128", Code::VEX_Vpermilps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpermilps_ymm_ymm_ymmm256", Code::VEX_Vpermilps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermilps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpermilps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpermilps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpermilps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpermilps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpermilps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("VEX_Vpermilpd_xmm_xmm_xmmm128", Code::VEX_Vpermilpd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpermilpd_ymm_ymm_ymmm256", Code::VEX_Vpermilpd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermilpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpermilpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpermilpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpermilpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpermilpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpermilpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("VEX_Vtestps_xmm_xmmm128", Code::VEX_Vtestps_xmm_xmmm128);
		let _ = h.insert("VEX_Vtestps_ymm_ymmm256", Code::VEX_Vtestps_ymm_ymmm256);
		let _ = h.insert("VEX_Vtestpd_xmm_xmmm128", Code::VEX_Vtestpd_xmm_xmmm128);
		let _ = h.insert("VEX_Vtestpd_ymm_ymmm256", Code::VEX_Vtestpd_ymm_ymmm256);
		let _ = h.insert("Pblendvb_xmm_xmmm128", Code::Pblendvb_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlvw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsrlvw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsrlvw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsrlvw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsrlvw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsrlvw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpmovuswb_xmmm64_k1z_xmm", Code::EVEX_Vpmovuswb_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovuswb_xmmm128_k1z_ymm", Code::EVEX_Vpmovuswb_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovuswb_ymmm256_k1z_zmm", Code::EVEX_Vpmovuswb_ymmm256_k1z_zmm);
		let _ = h.insert("EVEX_Vpsravw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsravw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsravw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsravw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsravw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsravw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpmovusdb_xmmm32_k1z_xmm", Code::EVEX_Vpmovusdb_xmmm32_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovusdb_xmmm64_k1z_ymm", Code::EVEX_Vpmovusdb_xmmm64_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovusdb_xmmm128_k1z_zmm", Code::EVEX_Vpmovusdb_xmmm128_k1z_zmm);
		let _ = h.insert("EVEX_Vpsllvw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpsllvw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpsllvw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpsllvw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsllvw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpsllvw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpmovusqb_xmmm16_k1z_xmm", Code::EVEX_Vpmovusqb_xmmm16_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovusqb_xmmm32_k1z_ymm", Code::EVEX_Vpmovusqb_xmmm32_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovusqb_xmmm64_k1z_zmm", Code::EVEX_Vpmovusqb_xmmm64_k1z_zmm);
		let _ = h.insert("VEX_Vcvtph2ps_xmm_xmmm64", Code::VEX_Vcvtph2ps_xmm_xmmm64);
		let _ = h.insert("VEX_Vcvtph2ps_ymm_xmmm128", Code::VEX_Vcvtph2ps_ymm_xmmm128);
		let _ = h.insert("EVEX_Vcvtph2ps_xmm_k1z_xmmm64", Code::EVEX_Vcvtph2ps_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vcvtph2ps_ymm_k1z_xmmm128", Code::EVEX_Vcvtph2ps_ymm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vcvtph2ps_zmm_k1z_ymmm256_sae", Code::EVEX_Vcvtph2ps_zmm_k1z_ymmm256_sae);
		let _ = h.insert("EVEX_Vpmovusdw_xmmm64_k1z_xmm", Code::EVEX_Vpmovusdw_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovusdw_xmmm128_k1z_ymm", Code::EVEX_Vpmovusdw_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovusdw_ymmm256_k1z_zmm", Code::EVEX_Vpmovusdw_ymmm256_k1z_zmm);
		let _ = h.insert("Blendvps_xmm_xmmm128", Code::Blendvps_xmm_xmmm128);
		let _ = h.insert("EVEX_Vprorvd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vprorvd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vprorvd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vprorvd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vprorvd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vprorvd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vprorvq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vprorvq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vprorvq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vprorvq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vprorvq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vprorvq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpmovusqw_xmmm32_k1z_xmm", Code::EVEX_Vpmovusqw_xmmm32_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovusqw_xmmm64_k1z_ymm", Code::EVEX_Vpmovusqw_xmmm64_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovusqw_xmmm128_k1z_zmm", Code::EVEX_Vpmovusqw_xmmm128_k1z_zmm);
		let _ = h.insert("Blendvpd_xmm_xmmm128", Code::Blendvpd_xmm_xmmm128);
		let _ = h.insert("EVEX_Vprolvd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vprolvd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vprolvd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vprolvd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vprolvd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vprolvd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vprolvq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vprolvq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vprolvq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vprolvq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vprolvq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vprolvq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpmovusqd_xmmm64_k1z_xmm", Code::EVEX_Vpmovusqd_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovusqd_xmmm128_k1z_ymm", Code::EVEX_Vpmovusqd_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovusqd_ymmm256_k1z_zmm", Code::EVEX_Vpmovusqd_ymmm256_k1z_zmm);
		let _ = h.insert("VEX_Vpermps_ymm_ymm_ymmm256", Code::VEX_Vpermps_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpermps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpermps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpermps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpermpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpermpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpermpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpermpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Ptest_xmm_xmmm128", Code::Ptest_xmm_xmmm128);
		let _ = h.insert("VEX_Vptest_xmm_xmmm128", Code::VEX_Vptest_xmm_xmmm128);
		let _ = h.insert("VEX_Vptest_ymm_ymmm256", Code::VEX_Vptest_ymm_ymmm256);
		let _ = h.insert("VEX_Vbroadcastss_xmm_m32", Code::VEX_Vbroadcastss_xmm_m32);
		let _ = h.insert("VEX_Vbroadcastss_ymm_m32", Code::VEX_Vbroadcastss_ymm_m32);
		let _ = h.insert("EVEX_Vbroadcastss_xmm_k1z_xmmm32", Code::EVEX_Vbroadcastss_xmm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vbroadcastss_ymm_k1z_xmmm32", Code::EVEX_Vbroadcastss_ymm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vbroadcastss_zmm_k1z_xmmm32", Code::EVEX_Vbroadcastss_zmm_k1z_xmmm32);
		let _ = h.insert("VEX_Vbroadcastsd_ymm_m64", Code::VEX_Vbroadcastsd_ymm_m64);
		let _ = h.insert("EVEX_Vbroadcastf32x2_ymm_k1z_xmmm64", Code::EVEX_Vbroadcastf32x2_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vbroadcastf32x2_zmm_k1z_xmmm64", Code::EVEX_Vbroadcastf32x2_zmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vbroadcastsd_ymm_k1z_xmmm64", Code::EVEX_Vbroadcastsd_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vbroadcastsd_zmm_k1z_xmmm64", Code::EVEX_Vbroadcastsd_zmm_k1z_xmmm64);
		let _ = h.insert("VEX_Vbroadcastf128_ymm_m128", Code::VEX_Vbroadcastf128_ymm_m128);
		let _ = h.insert("EVEX_Vbroadcastf32x4_ymm_k1z_m128", Code::EVEX_Vbroadcastf32x4_ymm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcastf32x4_zmm_k1z_m128", Code::EVEX_Vbroadcastf32x4_zmm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcastf64x2_ymm_k1z_m128", Code::EVEX_Vbroadcastf64x2_ymm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcastf64x2_zmm_k1z_m128", Code::EVEX_Vbroadcastf64x2_zmm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcastf32x8_zmm_k1z_m256", Code::EVEX_Vbroadcastf32x8_zmm_k1z_m256);
		let _ = h.insert("EVEX_Vbroadcastf64x4_zmm_k1z_m256", Code::EVEX_Vbroadcastf64x4_zmm_k1z_m256);
		let _ = h.insert("Pabsb_mm_mmm64", Code::Pabsb_mm_mmm64);
		let _ = h.insert("Pabsb_xmm_xmmm128", Code::Pabsb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpabsb_xmm_xmmm128", Code::VEX_Vpabsb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpabsb_ymm_ymmm256", Code::VEX_Vpabsb_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpabsb_xmm_k1z_xmmm128", Code::EVEX_Vpabsb_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpabsb_ymm_k1z_ymmm256", Code::EVEX_Vpabsb_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpabsb_zmm_k1z_zmmm512", Code::EVEX_Vpabsb_zmm_k1z_zmmm512);
		let _ = h.insert("Pabsw_mm_mmm64", Code::Pabsw_mm_mmm64);
		let _ = h.insert("Pabsw_xmm_xmmm128", Code::Pabsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpabsw_xmm_xmmm128", Code::VEX_Vpabsw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpabsw_ymm_ymmm256", Code::VEX_Vpabsw_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpabsw_xmm_k1z_xmmm128", Code::EVEX_Vpabsw_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpabsw_ymm_k1z_ymmm256", Code::EVEX_Vpabsw_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpabsw_zmm_k1z_zmmm512", Code::EVEX_Vpabsw_zmm_k1z_zmmm512);
		let _ = h.insert("Pabsd_mm_mmm64", Code::Pabsd_mm_mmm64);
		let _ = h.insert("Pabsd_xmm_xmmm128", Code::Pabsd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpabsd_xmm_xmmm128", Code::VEX_Vpabsd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpabsd_ymm_ymmm256", Code::VEX_Vpabsd_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpabsd_xmm_k1z_xmmm128b32", Code::EVEX_Vpabsd_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vpabsd_ymm_k1z_ymmm256b32", Code::EVEX_Vpabsd_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vpabsd_zmm_k1z_zmmm512b32", Code::EVEX_Vpabsd_zmm_k1z_zmmm512b32);
		let _ = h.insert("EVEX_Vpabsq_xmm_k1z_xmmm128b64", Code::EVEX_Vpabsq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vpabsq_ymm_k1z_ymmm256b64", Code::EVEX_Vpabsq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vpabsq_zmm_k1z_zmmm512b64", Code::EVEX_Vpabsq_zmm_k1z_zmmm512b64);
		let _ = h.insert("Pmovsxbw_xmm_xmmm64", Code::Pmovsxbw_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovsxbw_xmm_xmmm64", Code::VEX_Vpmovsxbw_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovsxbw_ymm_xmmm128", Code::VEX_Vpmovsxbw_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpmovsxbw_xmm_k1z_xmmm64", Code::EVEX_Vpmovsxbw_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovsxbw_ymm_k1z_xmmm128", Code::EVEX_Vpmovsxbw_ymm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovsxbw_zmm_k1z_ymmm256", Code::EVEX_Vpmovsxbw_zmm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpmovswb_xmmm64_k1z_xmm", Code::EVEX_Vpmovswb_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovswb_xmmm128_k1z_ymm", Code::EVEX_Vpmovswb_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovswb_ymmm256_k1z_zmm", Code::EVEX_Vpmovswb_ymmm256_k1z_zmm);
		let _ = h.insert("Pmovsxbd_xmm_xmmm32", Code::Pmovsxbd_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovsxbd_xmm_xmmm32", Code::VEX_Vpmovsxbd_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovsxbd_ymm_xmmm64", Code::VEX_Vpmovsxbd_ymm_xmmm64);
		let _ = h.insert("EVEX_Vpmovsxbd_xmm_k1z_xmmm32", Code::EVEX_Vpmovsxbd_xmm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpmovsxbd_ymm_k1z_xmmm64", Code::EVEX_Vpmovsxbd_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovsxbd_zmm_k1z_xmmm128", Code::EVEX_Vpmovsxbd_zmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovsdb_xmmm32_k1z_xmm", Code::EVEX_Vpmovsdb_xmmm32_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovsdb_xmmm64_k1z_ymm", Code::EVEX_Vpmovsdb_xmmm64_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovsdb_xmmm128_k1z_zmm", Code::EVEX_Vpmovsdb_xmmm128_k1z_zmm);
		let _ = h.insert("Pmovsxbq_xmm_xmmm16", Code::Pmovsxbq_xmm_xmmm16);
		let _ = h.insert("VEX_Vpmovsxbq_xmm_xmmm16", Code::VEX_Vpmovsxbq_xmm_xmmm16);
		let _ = h.insert("VEX_Vpmovsxbq_ymm_xmmm32", Code::VEX_Vpmovsxbq_ymm_xmmm32);
		let _ = h.insert("EVEX_Vpmovsxbq_xmm_k1z_xmmm16", Code::EVEX_Vpmovsxbq_xmm_k1z_xmmm16);
		let _ = h.insert("EVEX_Vpmovsxbq_ymm_k1z_xmmm32", Code::EVEX_Vpmovsxbq_ymm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpmovsxbq_zmm_k1z_xmmm64", Code::EVEX_Vpmovsxbq_zmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovsqb_xmmm16_k1z_xmm", Code::EVEX_Vpmovsqb_xmmm16_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovsqb_xmmm32_k1z_ymm", Code::EVEX_Vpmovsqb_xmmm32_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovsqb_xmmm64_k1z_zmm", Code::EVEX_Vpmovsqb_xmmm64_k1z_zmm);
		let _ = h.insert("Pmovsxwd_xmm_xmmm64", Code::Pmovsxwd_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovsxwd_xmm_xmmm64", Code::VEX_Vpmovsxwd_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovsxwd_ymm_xmmm128", Code::VEX_Vpmovsxwd_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpmovsxwd_xmm_k1z_xmmm64", Code::EVEX_Vpmovsxwd_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovsxwd_ymm_k1z_xmmm128", Code::EVEX_Vpmovsxwd_ymm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovsxwd_zmm_k1z_ymmm256", Code::EVEX_Vpmovsxwd_zmm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpmovsdw_xmmm64_k1z_xmm", Code::EVEX_Vpmovsdw_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovsdw_xmmm128_k1z_ymm", Code::EVEX_Vpmovsdw_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovsdw_ymmm256_k1z_zmm", Code::EVEX_Vpmovsdw_ymmm256_k1z_zmm);
		let _ = h.insert("Pmovsxwq_xmm_xmmm32", Code::Pmovsxwq_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovsxwq_xmm_xmmm32", Code::VEX_Vpmovsxwq_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovsxwq_ymm_xmmm64", Code::VEX_Vpmovsxwq_ymm_xmmm64);
		let _ = h.insert("EVEX_Vpmovsxwq_xmm_k1z_xmmm32", Code::EVEX_Vpmovsxwq_xmm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpmovsxwq_ymm_k1z_xmmm64", Code::EVEX_Vpmovsxwq_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovsxwq_zmm_k1z_xmmm128", Code::EVEX_Vpmovsxwq_zmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovsqw_xmmm32_k1z_xmm", Code::EVEX_Vpmovsqw_xmmm32_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovsqw_xmmm64_k1z_ymm", Code::EVEX_Vpmovsqw_xmmm64_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovsqw_xmmm128_k1z_zmm", Code::EVEX_Vpmovsqw_xmmm128_k1z_zmm);
		let _ = h.insert("Pmovsxdq_xmm_xmmm64", Code::Pmovsxdq_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovsxdq_xmm_xmmm64", Code::VEX_Vpmovsxdq_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovsxdq_ymm_xmmm128", Code::VEX_Vpmovsxdq_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpmovsxdq_xmm_k1z_xmmm64", Code::EVEX_Vpmovsxdq_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovsxdq_ymm_k1z_xmmm128", Code::EVEX_Vpmovsxdq_ymm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovsxdq_zmm_k1z_ymmm256", Code::EVEX_Vpmovsxdq_zmm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpmovsqd_xmmm64_k1z_xmm", Code::EVEX_Vpmovsqd_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovsqd_xmmm128_k1z_ymm", Code::EVEX_Vpmovsqd_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovsqd_ymmm256_k1z_zmm", Code::EVEX_Vpmovsqd_ymmm256_k1z_zmm);
		let _ = h.insert("EVEX_Vptestmb_kr_k1_xmm_xmmm128", Code::EVEX_Vptestmb_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vptestmb_kr_k1_ymm_ymmm256", Code::EVEX_Vptestmb_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vptestmb_kr_k1_zmm_zmmm512", Code::EVEX_Vptestmb_kr_k1_zmm_zmmm512);
		let _ = h.insert("EVEX_Vptestmw_kr_k1_xmm_xmmm128", Code::EVEX_Vptestmw_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vptestmw_kr_k1_ymm_ymmm256", Code::EVEX_Vptestmw_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vptestmw_kr_k1_zmm_zmmm512", Code::EVEX_Vptestmw_kr_k1_zmm_zmmm512);
		let _ = h.insert("EVEX_Vptestnmb_kr_k1_xmm_xmmm128", Code::EVEX_Vptestnmb_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vptestnmb_kr_k1_ymm_ymmm256", Code::EVEX_Vptestnmb_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vptestnmb_kr_k1_zmm_zmmm512", Code::EVEX_Vptestnmb_kr_k1_zmm_zmmm512);
		let _ = h.insert("EVEX_Vptestnmw_kr_k1_xmm_xmmm128", Code::EVEX_Vptestnmw_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vptestnmw_kr_k1_ymm_ymmm256", Code::EVEX_Vptestnmw_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vptestnmw_kr_k1_zmm_zmmm512", Code::EVEX_Vptestnmw_kr_k1_zmm_zmmm512);
		let _ = h.insert("EVEX_Vptestmd_kr_k1_xmm_xmmm128b32", Code::EVEX_Vptestmd_kr_k1_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vptestmd_kr_k1_ymm_ymmm256b32", Code::EVEX_Vptestmd_kr_k1_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vptestmd_kr_k1_zmm_zmmm512b32", Code::EVEX_Vptestmd_kr_k1_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vptestmq_kr_k1_xmm_xmmm128b64", Code::EVEX_Vptestmq_kr_k1_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vptestmq_kr_k1_ymm_ymmm256b64", Code::EVEX_Vptestmq_kr_k1_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vptestmq_kr_k1_zmm_zmmm512b64", Code::EVEX_Vptestmq_kr_k1_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vptestnmd_kr_k1_xmm_xmmm128b32", Code::EVEX_Vptestnmd_kr_k1_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vptestnmd_kr_k1_ymm_ymmm256b32", Code::EVEX_Vptestnmd_kr_k1_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vptestnmd_kr_k1_zmm_zmmm512b32", Code::EVEX_Vptestnmd_kr_k1_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vptestnmq_kr_k1_xmm_xmmm128b64", Code::EVEX_Vptestnmq_kr_k1_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vptestnmq_kr_k1_ymm_ymmm256b64", Code::EVEX_Vptestnmq_kr_k1_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vptestnmq_kr_k1_zmm_zmmm512b64", Code::EVEX_Vptestnmq_kr_k1_zmm_zmmm512b64);
		let _ = h.insert("Pmuldq_xmm_xmmm128", Code::Pmuldq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmuldq_xmm_xmm_xmmm128", Code::VEX_Vpmuldq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmuldq_ymm_ymm_ymmm256", Code::VEX_Vpmuldq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmuldq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmuldq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmuldq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmuldq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmuldq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmuldq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpmovm2b_xmm_kr", Code::EVEX_Vpmovm2b_xmm_kr);
		let _ = h.insert("EVEX_Vpmovm2b_ymm_kr", Code::EVEX_Vpmovm2b_ymm_kr);
		let _ = h.insert("EVEX_Vpmovm2b_zmm_kr", Code::EVEX_Vpmovm2b_zmm_kr);
		let _ = h.insert("EVEX_Vpmovm2w_xmm_kr", Code::EVEX_Vpmovm2w_xmm_kr);
		let _ = h.insert("EVEX_Vpmovm2w_ymm_kr", Code::EVEX_Vpmovm2w_ymm_kr);
		let _ = h.insert("EVEX_Vpmovm2w_zmm_kr", Code::EVEX_Vpmovm2w_zmm_kr);
		let _ = h.insert("Pcmpeqq_xmm_xmmm128", Code::Pcmpeqq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqq_xmm_xmm_xmmm128", Code::VEX_Vpcmpeqq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpeqq_ymm_ymm_ymmm256", Code::VEX_Vpcmpeqq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpeqq_kr_k1_xmm_xmmm128b64", Code::EVEX_Vpcmpeqq_kr_k1_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpcmpeqq_kr_k1_ymm_ymmm256b64", Code::EVEX_Vpcmpeqq_kr_k1_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpcmpeqq_kr_k1_zmm_zmmm512b64", Code::EVEX_Vpcmpeqq_kr_k1_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpmovb2m_kr_xmm", Code::EVEX_Vpmovb2m_kr_xmm);
		let _ = h.insert("EVEX_Vpmovb2m_kr_ymm", Code::EVEX_Vpmovb2m_kr_ymm);
		let _ = h.insert("EVEX_Vpmovb2m_kr_zmm", Code::EVEX_Vpmovb2m_kr_zmm);
		let _ = h.insert("EVEX_Vpmovw2m_kr_xmm", Code::EVEX_Vpmovw2m_kr_xmm);
		let _ = h.insert("EVEX_Vpmovw2m_kr_ymm", Code::EVEX_Vpmovw2m_kr_ymm);
		let _ = h.insert("EVEX_Vpmovw2m_kr_zmm", Code::EVEX_Vpmovw2m_kr_zmm);
		let _ = h.insert("Movntdqa_xmm_m128", Code::Movntdqa_xmm_m128);
		let _ = h.insert("VEX_Vmovntdqa_xmm_m128", Code::VEX_Vmovntdqa_xmm_m128);
		let _ = h.insert("VEX_Vmovntdqa_ymm_m256", Code::VEX_Vmovntdqa_ymm_m256);
		let _ = h.insert("EVEX_Vmovntdqa_xmm_m128", Code::EVEX_Vmovntdqa_xmm_m128);
		let _ = h.insert("EVEX_Vmovntdqa_ymm_m256", Code::EVEX_Vmovntdqa_ymm_m256);
		let _ = h.insert("EVEX_Vmovntdqa_zmm_m512", Code::EVEX_Vmovntdqa_zmm_m512);
		let _ = h.insert("EVEX_Vpbroadcastmb2q_xmm_kr", Code::EVEX_Vpbroadcastmb2q_xmm_kr);
		let _ = h.insert("EVEX_Vpbroadcastmb2q_ymm_kr", Code::EVEX_Vpbroadcastmb2q_ymm_kr);
		let _ = h.insert("EVEX_Vpbroadcastmb2q_zmm_kr", Code::EVEX_Vpbroadcastmb2q_zmm_kr);
		let _ = h.insert("Packusdw_xmm_xmmm128", Code::Packusdw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpackusdw_xmm_xmm_xmmm128", Code::VEX_Vpackusdw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpackusdw_ymm_ymm_ymmm256", Code::VEX_Vpackusdw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpackusdw_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpackusdw_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpackusdw_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpackusdw_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpackusdw_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpackusdw_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("VEX_Vmaskmovps_xmm_xmm_m128", Code::VEX_Vmaskmovps_xmm_xmm_m128);
		let _ = h.insert("VEX_Vmaskmovps_ymm_ymm_m256", Code::VEX_Vmaskmovps_ymm_ymm_m256);
		let _ = h.insert("EVEX_Vscalefps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vscalefps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vscalefps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vscalefps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vscalefps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vscalefps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vscalefpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vscalefpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vscalefpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vscalefpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vscalefpd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vscalefpd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vmaskmovpd_xmm_xmm_m128", Code::VEX_Vmaskmovpd_xmm_xmm_m128);
		let _ = h.insert("VEX_Vmaskmovpd_ymm_ymm_m256", Code::VEX_Vmaskmovpd_ymm_ymm_m256);
		let _ = h.insert("EVEX_Vscalefss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vscalefss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vscalefsd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vscalefsd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vmaskmovps_m128_xmm_xmm", Code::VEX_Vmaskmovps_m128_xmm_xmm);
		let _ = h.insert("VEX_Vmaskmovps_m256_ymm_ymm", Code::VEX_Vmaskmovps_m256_ymm_ymm);
		let _ = h.insert("VEX_Vmaskmovpd_m128_xmm_xmm", Code::VEX_Vmaskmovpd_m128_xmm_xmm);
		let _ = h.insert("VEX_Vmaskmovpd_m256_ymm_ymm", Code::VEX_Vmaskmovpd_m256_ymm_ymm);
		let _ = h.insert("Pmovzxbw_xmm_xmmm64", Code::Pmovzxbw_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovzxbw_xmm_xmmm64", Code::VEX_Vpmovzxbw_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovzxbw_ymm_xmmm128", Code::VEX_Vpmovzxbw_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpmovzxbw_xmm_k1z_xmmm64", Code::EVEX_Vpmovzxbw_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovzxbw_ymm_k1z_xmmm128", Code::EVEX_Vpmovzxbw_ymm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovzxbw_zmm_k1z_ymmm256", Code::EVEX_Vpmovzxbw_zmm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpmovwb_xmmm64_k1z_xmm", Code::EVEX_Vpmovwb_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovwb_xmmm128_k1z_ymm", Code::EVEX_Vpmovwb_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovwb_ymmm256_k1z_zmm", Code::EVEX_Vpmovwb_ymmm256_k1z_zmm);
		let _ = h.insert("Pmovzxbd_xmm_xmmm32", Code::Pmovzxbd_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovzxbd_xmm_xmmm32", Code::VEX_Vpmovzxbd_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovzxbd_ymm_xmmm64", Code::VEX_Vpmovzxbd_ymm_xmmm64);
		let _ = h.insert("EVEX_Vpmovzxbd_xmm_k1z_xmmm32", Code::EVEX_Vpmovzxbd_xmm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpmovzxbd_ymm_k1z_xmmm64", Code::EVEX_Vpmovzxbd_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovzxbd_zmm_k1z_xmmm128", Code::EVEX_Vpmovzxbd_zmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovdb_xmmm32_k1z_xmm", Code::EVEX_Vpmovdb_xmmm32_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovdb_xmmm64_k1z_ymm", Code::EVEX_Vpmovdb_xmmm64_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovdb_xmmm128_k1z_zmm", Code::EVEX_Vpmovdb_xmmm128_k1z_zmm);
		let _ = h.insert("Pmovzxbq_xmm_xmmm16", Code::Pmovzxbq_xmm_xmmm16);
		let _ = h.insert("VEX_Vpmovzxbq_xmm_xmmm16", Code::VEX_Vpmovzxbq_xmm_xmmm16);
		let _ = h.insert("VEX_Vpmovzxbq_ymm_xmmm32", Code::VEX_Vpmovzxbq_ymm_xmmm32);
		let _ = h.insert("EVEX_Vpmovzxbq_xmm_k1z_xmmm16", Code::EVEX_Vpmovzxbq_xmm_k1z_xmmm16);
		let _ = h.insert("EVEX_Vpmovzxbq_ymm_k1z_xmmm32", Code::EVEX_Vpmovzxbq_ymm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpmovzxbq_zmm_k1z_xmmm64", Code::EVEX_Vpmovzxbq_zmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovqb_xmmm16_k1z_xmm", Code::EVEX_Vpmovqb_xmmm16_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovqb_xmmm32_k1z_ymm", Code::EVEX_Vpmovqb_xmmm32_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovqb_xmmm64_k1z_zmm", Code::EVEX_Vpmovqb_xmmm64_k1z_zmm);
		let _ = h.insert("Pmovzxwd_xmm_xmmm64", Code::Pmovzxwd_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovzxwd_xmm_xmmm64", Code::VEX_Vpmovzxwd_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovzxwd_ymm_xmmm128", Code::VEX_Vpmovzxwd_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpmovzxwd_xmm_k1z_xmmm64", Code::EVEX_Vpmovzxwd_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovzxwd_ymm_k1z_xmmm128", Code::EVEX_Vpmovzxwd_ymm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovzxwd_zmm_k1z_ymmm256", Code::EVEX_Vpmovzxwd_zmm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpmovdw_xmmm64_k1z_xmm", Code::EVEX_Vpmovdw_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovdw_xmmm128_k1z_ymm", Code::EVEX_Vpmovdw_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovdw_ymmm256_k1z_zmm", Code::EVEX_Vpmovdw_ymmm256_k1z_zmm);
		let _ = h.insert("Pmovzxwq_xmm_xmmm32", Code::Pmovzxwq_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovzxwq_xmm_xmmm32", Code::VEX_Vpmovzxwq_xmm_xmmm32);
		let _ = h.insert("VEX_Vpmovzxwq_ymm_xmmm64", Code::VEX_Vpmovzxwq_ymm_xmmm64);
		let _ = h.insert("EVEX_Vpmovzxwq_xmm_k1z_xmmm32", Code::EVEX_Vpmovzxwq_xmm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpmovzxwq_ymm_k1z_xmmm64", Code::EVEX_Vpmovzxwq_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovzxwq_zmm_k1z_xmmm128", Code::EVEX_Vpmovzxwq_zmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovqw_xmmm32_k1z_xmm", Code::EVEX_Vpmovqw_xmmm32_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovqw_xmmm64_k1z_ymm", Code::EVEX_Vpmovqw_xmmm64_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovqw_xmmm128_k1z_zmm", Code::EVEX_Vpmovqw_xmmm128_k1z_zmm);
		let _ = h.insert("Pmovzxdq_xmm_xmmm64", Code::Pmovzxdq_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovzxdq_xmm_xmmm64", Code::VEX_Vpmovzxdq_xmm_xmmm64);
		let _ = h.insert("VEX_Vpmovzxdq_ymm_xmmm128", Code::VEX_Vpmovzxdq_ymm_xmmm128);
		let _ = h.insert("EVEX_Vpmovzxdq_xmm_k1z_xmmm64", Code::EVEX_Vpmovzxdq_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpmovzxdq_ymm_k1z_xmmm128", Code::EVEX_Vpmovzxdq_ymm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpmovzxdq_zmm_k1z_ymmm256", Code::EVEX_Vpmovzxdq_zmm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpmovqd_xmmm64_k1z_xmm", Code::EVEX_Vpmovqd_xmmm64_k1z_xmm);
		let _ = h.insert("EVEX_Vpmovqd_xmmm128_k1z_ymm", Code::EVEX_Vpmovqd_xmmm128_k1z_ymm);
		let _ = h.insert("EVEX_Vpmovqd_ymmm256_k1z_zmm", Code::EVEX_Vpmovqd_ymmm256_k1z_zmm);
		let _ = h.insert("VEX_Vpermd_ymm_ymm_ymmm256", Code::VEX_Vpermd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpermd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpermd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpermd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpermq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpermq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpermq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpermq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Pcmpgtq_xmm_xmmm128", Code::Pcmpgtq_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtq_xmm_xmm_xmmm128", Code::VEX_Vpcmpgtq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpcmpgtq_ymm_ymm_ymmm256", Code::VEX_Vpcmpgtq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpcmpgtq_kr_k1_xmm_xmmm128b64", Code::EVEX_Vpcmpgtq_kr_k1_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpcmpgtq_kr_k1_ymm_ymmm256b64", Code::EVEX_Vpcmpgtq_kr_k1_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpcmpgtq_kr_k1_zmm_zmmm512b64", Code::EVEX_Vpcmpgtq_kr_k1_zmm_zmmm512b64);
		let _ = h.insert("Pminsb_xmm_xmmm128", Code::Pminsb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminsb_xmm_xmm_xmmm128", Code::VEX_Vpminsb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminsb_ymm_ymm_ymmm256", Code::VEX_Vpminsb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminsb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpminsb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpminsb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpminsb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminsb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpminsb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpmovm2d_xmm_kr", Code::EVEX_Vpmovm2d_xmm_kr);
		let _ = h.insert("EVEX_Vpmovm2d_ymm_kr", Code::EVEX_Vpmovm2d_ymm_kr);
		let _ = h.insert("EVEX_Vpmovm2d_zmm_kr", Code::EVEX_Vpmovm2d_zmm_kr);
		let _ = h.insert("EVEX_Vpmovm2q_xmm_kr", Code::EVEX_Vpmovm2q_xmm_kr);
		let _ = h.insert("EVEX_Vpmovm2q_ymm_kr", Code::EVEX_Vpmovm2q_ymm_kr);
		let _ = h.insert("EVEX_Vpmovm2q_zmm_kr", Code::EVEX_Vpmovm2q_zmm_kr);
		let _ = h.insert("Pminsd_xmm_xmmm128", Code::Pminsd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminsd_xmm_xmm_xmmm128", Code::VEX_Vpminsd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminsd_ymm_ymm_ymmm256", Code::VEX_Vpminsd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminsd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpminsd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpminsd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpminsd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpminsd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpminsd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpminsq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpminsq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpminsq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpminsq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpminsq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpminsq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpmovd2m_kr_xmm", Code::EVEX_Vpmovd2m_kr_xmm);
		let _ = h.insert("EVEX_Vpmovd2m_kr_ymm", Code::EVEX_Vpmovd2m_kr_ymm);
		let _ = h.insert("EVEX_Vpmovd2m_kr_zmm", Code::EVEX_Vpmovd2m_kr_zmm);
		let _ = h.insert("EVEX_Vpmovq2m_kr_xmm", Code::EVEX_Vpmovq2m_kr_xmm);
		let _ = h.insert("EVEX_Vpmovq2m_kr_ymm", Code::EVEX_Vpmovq2m_kr_ymm);
		let _ = h.insert("EVEX_Vpmovq2m_kr_zmm", Code::EVEX_Vpmovq2m_kr_zmm);
		let _ = h.insert("Pminuw_xmm_xmmm128", Code::Pminuw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminuw_xmm_xmm_xmmm128", Code::VEX_Vpminuw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminuw_ymm_ymm_ymmm256", Code::VEX_Vpminuw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminuw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpminuw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpminuw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpminuw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminuw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpminuw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpbroadcastmw2d_xmm_kr", Code::EVEX_Vpbroadcastmw2d_xmm_kr);
		let _ = h.insert("EVEX_Vpbroadcastmw2d_ymm_kr", Code::EVEX_Vpbroadcastmw2d_ymm_kr);
		let _ = h.insert("EVEX_Vpbroadcastmw2d_zmm_kr", Code::EVEX_Vpbroadcastmw2d_zmm_kr);
		let _ = h.insert("Pminud_xmm_xmmm128", Code::Pminud_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminud_xmm_xmm_xmmm128", Code::VEX_Vpminud_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpminud_ymm_ymm_ymmm256", Code::VEX_Vpminud_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpminud_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpminud_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpminud_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpminud_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpminud_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpminud_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpminuq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpminuq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpminuq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpminuq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpminuq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpminuq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Pmaxsb_xmm_xmmm128", Code::Pmaxsb_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxsb_xmm_xmm_xmmm128", Code::VEX_Vpmaxsb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxsb_ymm_ymm_ymmm256", Code::VEX_Vpmaxsb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxsb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmaxsb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmaxsb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmaxsb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxsb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmaxsb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pmaxsd_xmm_xmmm128", Code::Pmaxsd_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxsd_xmm_xmm_xmmm128", Code::VEX_Vpmaxsd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxsd_ymm_ymm_ymmm256", Code::VEX_Vpmaxsd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxsd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpmaxsd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpmaxsd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpmaxsd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpmaxsd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpmaxsd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpmaxsq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmaxsq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmaxsq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmaxsq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmaxsq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmaxsq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Pmaxuw_xmm_xmmm128", Code::Pmaxuw_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxuw_xmm_xmm_xmmm128", Code::VEX_Vpmaxuw_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxuw_ymm_ymm_ymmm256", Code::VEX_Vpmaxuw_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxuw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpmaxuw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpmaxuw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpmaxuw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxuw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpmaxuw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Pmaxud_xmm_xmmm128", Code::Pmaxud_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxud_xmm_xmm_xmmm128", Code::VEX_Vpmaxud_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmaxud_ymm_ymm_ymmm256", Code::VEX_Vpmaxud_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmaxud_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpmaxud_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpmaxud_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpmaxud_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpmaxud_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpmaxud_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpmaxuq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmaxuq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmaxuq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmaxuq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmaxuq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmaxuq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Pmulld_xmm_xmmm128", Code::Pmulld_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulld_xmm_xmm_xmmm128", Code::VEX_Vpmulld_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpmulld_ymm_ymm_ymmm256", Code::VEX_Vpmulld_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpmulld_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpmulld_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpmulld_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpmulld_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpmulld_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpmulld_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpmullq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmullq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmullq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmullq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmullq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmullq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Phminposuw_xmm_xmmm128", Code::Phminposuw_xmm_xmmm128);
		let _ = h.insert("VEX_Vphminposuw_xmm_xmmm128", Code::VEX_Vphminposuw_xmm_xmmm128);
		let _ = h.insert("EVEX_Vgetexpps_xmm_k1z_xmmm128b32", Code::EVEX_Vgetexpps_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vgetexpps_ymm_k1z_ymmm256b32", Code::EVEX_Vgetexpps_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vgetexpps_zmm_k1z_zmmm512b32_sae", Code::EVEX_Vgetexpps_zmm_k1z_zmmm512b32_sae);
		let _ = h.insert("EVEX_Vgetexppd_xmm_k1z_xmmm128b64", Code::EVEX_Vgetexppd_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vgetexppd_ymm_k1z_ymmm256b64", Code::EVEX_Vgetexppd_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vgetexppd_zmm_k1z_zmmm512b64_sae", Code::EVEX_Vgetexppd_zmm_k1z_zmmm512b64_sae);
		let _ = h.insert("EVEX_Vgetexpss_xmm_k1z_xmm_xmmm32_sae", Code::EVEX_Vgetexpss_xmm_k1z_xmm_xmmm32_sae);
		let _ = h.insert("EVEX_Vgetexpsd_xmm_k1z_xmm_xmmm64_sae", Code::EVEX_Vgetexpsd_xmm_k1z_xmm_xmmm64_sae);
		let _ = h.insert("EVEX_Vplzcntd_xmm_k1z_xmmm128b32", Code::EVEX_Vplzcntd_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vplzcntd_ymm_k1z_ymmm256b32", Code::EVEX_Vplzcntd_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vplzcntd_zmm_k1z_zmmm512b32", Code::EVEX_Vplzcntd_zmm_k1z_zmmm512b32);
		let _ = h.insert("EVEX_Vplzcntq_xmm_k1z_xmmm128b64", Code::EVEX_Vplzcntq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vplzcntq_ymm_k1z_ymmm256b64", Code::EVEX_Vplzcntq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vplzcntq_zmm_k1z_zmmm512b64", Code::EVEX_Vplzcntq_zmm_k1z_zmmm512b64);
		let _ = h.insert("VEX_Vpsrlvd_xmm_xmm_xmmm128", Code::VEX_Vpsrlvd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrlvd_ymm_ymm_ymmm256", Code::VEX_Vpsrlvd_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vpsrlvq_xmm_xmm_xmmm128", Code::VEX_Vpsrlvq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsrlvq_ymm_ymm_ymmm256", Code::VEX_Vpsrlvq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsrlvd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpsrlvd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpsrlvd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpsrlvd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpsrlvd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpsrlvd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpsrlvq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpsrlvq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpsrlvq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpsrlvq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpsrlvq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpsrlvq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("VEX_Vpsravd_xmm_xmm_xmmm128", Code::VEX_Vpsravd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsravd_ymm_ymm_ymmm256", Code::VEX_Vpsravd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsravd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpsravd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpsravd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpsravd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpsravd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpsravd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpsravq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpsravq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpsravq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpsravq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpsravq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpsravq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("VEX_Vpsllvd_xmm_xmm_xmmm128", Code::VEX_Vpsllvd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsllvd_ymm_ymm_ymmm256", Code::VEX_Vpsllvd_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vpsllvq_xmm_xmm_xmmm128", Code::VEX_Vpsllvq_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpsllvq_ymm_ymm_ymmm256", Code::VEX_Vpsllvq_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpsllvd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpsllvd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpsllvd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpsllvd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpsllvd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpsllvd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpsllvq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpsllvq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpsllvq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpsllvq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpsllvq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpsllvq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vrcp14ps_xmm_k1z_xmmm128b32", Code::EVEX_Vrcp14ps_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vrcp14ps_ymm_k1z_ymmm256b32", Code::EVEX_Vrcp14ps_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vrcp14ps_zmm_k1z_zmmm512b32", Code::EVEX_Vrcp14ps_zmm_k1z_zmmm512b32);
		let _ = h.insert("EVEX_Vrcp14pd_xmm_k1z_xmmm128b64", Code::EVEX_Vrcp14pd_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vrcp14pd_ymm_k1z_ymmm256b64", Code::EVEX_Vrcp14pd_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vrcp14pd_zmm_k1z_zmmm512b64", Code::EVEX_Vrcp14pd_zmm_k1z_zmmm512b64);
		let _ = h.insert("EVEX_Vrcp14ss_xmm_k1z_xmm_xmmm32", Code::EVEX_Vrcp14ss_xmm_k1z_xmm_xmmm32);
		let _ = h.insert("EVEX_Vrcp14sd_xmm_k1z_xmm_xmmm64", Code::EVEX_Vrcp14sd_xmm_k1z_xmm_xmmm64);
		let _ = h.insert("EVEX_Vrsqrt14ps_xmm_k1z_xmmm128b32", Code::EVEX_Vrsqrt14ps_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vrsqrt14ps_ymm_k1z_ymmm256b32", Code::EVEX_Vrsqrt14ps_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vrsqrt14ps_zmm_k1z_zmmm512b32", Code::EVEX_Vrsqrt14ps_zmm_k1z_zmmm512b32);
		let _ = h.insert("EVEX_Vrsqrt14pd_xmm_k1z_xmmm128b64", Code::EVEX_Vrsqrt14pd_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vrsqrt14pd_ymm_k1z_ymmm256b64", Code::EVEX_Vrsqrt14pd_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vrsqrt14pd_zmm_k1z_zmmm512b64", Code::EVEX_Vrsqrt14pd_zmm_k1z_zmmm512b64);
		let _ = h.insert("EVEX_Vrsqrt14ss_xmm_k1z_xmm_xmmm32", Code::EVEX_Vrsqrt14ss_xmm_k1z_xmm_xmmm32);
		let _ = h.insert("EVEX_Vrsqrt14sd_xmm_k1z_xmm_xmmm64", Code::EVEX_Vrsqrt14sd_xmm_k1z_xmm_xmmm64);
		let _ = h.insert("EVEX_Vpdpbusd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpdpbusd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpdpbusd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpdpbusd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpdpbusd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpdpbusd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpdpbusds_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpdpbusds_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpdpbusds_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpdpbusds_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpdpbusds_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpdpbusds_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpdpwssd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpdpwssd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpdpwssd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpdpwssd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpdpwssd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpdpwssd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vdpbf16ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vdpbf16ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vdpbf16ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vdpbf16ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vdpbf16ps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vdpbf16ps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vp4dpwssd_zmm_k1z_zmmp3_m128", Code::EVEX_Vp4dpwssd_zmm_k1z_zmmp3_m128);
		let _ = h.insert("EVEX_Vpdpwssds_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpdpwssds_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpdpwssds_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpdpwssds_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpdpwssds_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpdpwssds_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vp4dpwssds_zmm_k1z_zmmp3_m128", Code::EVEX_Vp4dpwssds_zmm_k1z_zmmp3_m128);
		let _ = h.insert("EVEX_Vpopcntb_xmm_k1z_xmmm128", Code::EVEX_Vpopcntb_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpopcntb_ymm_k1z_ymmm256", Code::EVEX_Vpopcntb_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpopcntb_zmm_k1z_zmmm512", Code::EVEX_Vpopcntb_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vpopcntw_xmm_k1z_xmmm128", Code::EVEX_Vpopcntw_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpopcntw_ymm_k1z_ymmm256", Code::EVEX_Vpopcntw_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpopcntw_zmm_k1z_zmmm512", Code::EVEX_Vpopcntw_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vpopcntd_xmm_k1z_xmmm128b32", Code::EVEX_Vpopcntd_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vpopcntd_ymm_k1z_ymmm256b32", Code::EVEX_Vpopcntd_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vpopcntd_zmm_k1z_zmmm512b32", Code::EVEX_Vpopcntd_zmm_k1z_zmmm512b32);
		let _ = h.insert("EVEX_Vpopcntq_xmm_k1z_xmmm128b64", Code::EVEX_Vpopcntq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vpopcntq_ymm_k1z_ymmm256b64", Code::EVEX_Vpopcntq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vpopcntq_zmm_k1z_zmmm512b64", Code::EVEX_Vpopcntq_zmm_k1z_zmmm512b64);
		let _ = h.insert("VEX_Vpbroadcastd_xmm_xmmm32", Code::VEX_Vpbroadcastd_xmm_xmmm32);
		let _ = h.insert("VEX_Vpbroadcastd_ymm_xmmm32", Code::VEX_Vpbroadcastd_ymm_xmmm32);
		let _ = h.insert("EVEX_Vpbroadcastd_xmm_k1z_xmmm32", Code::EVEX_Vpbroadcastd_xmm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpbroadcastd_ymm_k1z_xmmm32", Code::EVEX_Vpbroadcastd_ymm_k1z_xmmm32);
		let _ = h.insert("EVEX_Vpbroadcastd_zmm_k1z_xmmm32", Code::EVEX_Vpbroadcastd_zmm_k1z_xmmm32);
		let _ = h.insert("VEX_Vpbroadcastq_xmm_xmmm64", Code::VEX_Vpbroadcastq_xmm_xmmm64);
		let _ = h.insert("VEX_Vpbroadcastq_ymm_xmmm64", Code::VEX_Vpbroadcastq_ymm_xmmm64);
		let _ = h.insert("EVEX_Vbroadcasti32x2_xmm_k1z_xmmm64", Code::EVEX_Vbroadcasti32x2_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vbroadcasti32x2_ymm_k1z_xmmm64", Code::EVEX_Vbroadcasti32x2_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vbroadcasti32x2_zmm_k1z_xmmm64", Code::EVEX_Vbroadcasti32x2_zmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpbroadcastq_xmm_k1z_xmmm64", Code::EVEX_Vpbroadcastq_xmm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpbroadcastq_ymm_k1z_xmmm64", Code::EVEX_Vpbroadcastq_ymm_k1z_xmmm64);
		let _ = h.insert("EVEX_Vpbroadcastq_zmm_k1z_xmmm64", Code::EVEX_Vpbroadcastq_zmm_k1z_xmmm64);
		let _ = h.insert("VEX_Vbroadcasti128_ymm_m128", Code::VEX_Vbroadcasti128_ymm_m128);
		let _ = h.insert("EVEX_Vbroadcasti32x4_ymm_k1z_m128", Code::EVEX_Vbroadcasti32x4_ymm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcasti32x4_zmm_k1z_m128", Code::EVEX_Vbroadcasti32x4_zmm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcasti64x2_ymm_k1z_m128", Code::EVEX_Vbroadcasti64x2_ymm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcasti64x2_zmm_k1z_m128", Code::EVEX_Vbroadcasti64x2_zmm_k1z_m128);
		let _ = h.insert("EVEX_Vbroadcasti32x8_zmm_k1z_m256", Code::EVEX_Vbroadcasti32x8_zmm_k1z_m256);
		let _ = h.insert("EVEX_Vbroadcasti64x4_zmm_k1z_m256", Code::EVEX_Vbroadcasti64x4_zmm_k1z_m256);
		let _ = h.insert("EVEX_Vpexpandb_xmm_k1z_xmmm128", Code::EVEX_Vpexpandb_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpexpandb_ymm_k1z_ymmm256", Code::EVEX_Vpexpandb_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpexpandb_zmm_k1z_zmmm512", Code::EVEX_Vpexpandb_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vpexpandw_xmm_k1z_xmmm128", Code::EVEX_Vpexpandw_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpexpandw_ymm_k1z_ymmm256", Code::EVEX_Vpexpandw_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpexpandw_zmm_k1z_zmmm512", Code::EVEX_Vpexpandw_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vpcompressb_xmmm128_k1z_xmm", Code::EVEX_Vpcompressb_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vpcompressb_ymmm256_k1z_ymm", Code::EVEX_Vpcompressb_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vpcompressb_zmmm512_k1z_zmm", Code::EVEX_Vpcompressb_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vpcompressw_xmmm128_k1z_xmm", Code::EVEX_Vpcompressw_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vpcompressw_ymmm256_k1z_ymm", Code::EVEX_Vpcompressw_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vpcompressw_zmmm512_k1z_zmm", Code::EVEX_Vpcompressw_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vpblendmd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpblendmd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpblendmd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpblendmd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpblendmd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpblendmd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpblendmq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpblendmq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpblendmq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpblendmq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpblendmq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpblendmq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vblendmps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vblendmps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vblendmps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vblendmps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vblendmps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vblendmps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vblendmpd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vblendmpd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vblendmpd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vblendmpd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vblendmpd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vblendmpd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpblendmb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpblendmb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpblendmb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpblendmb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpblendmb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpblendmb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpblendmw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpblendmw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpblendmw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpblendmw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpblendmw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpblendmw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vp2intersectd_kp1_xmm_xmmm128b32", Code::EVEX_Vp2intersectd_kp1_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vp2intersectd_kp1_ymm_ymmm256b32", Code::EVEX_Vp2intersectd_kp1_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vp2intersectd_kp1_zmm_zmmm512b32", Code::EVEX_Vp2intersectd_kp1_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vp2intersectq_kp1_xmm_xmmm128b64", Code::EVEX_Vp2intersectq_kp1_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vp2intersectq_kp1_ymm_ymmm256b64", Code::EVEX_Vp2intersectq_kp1_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vp2intersectq_kp1_zmm_zmmm512b64", Code::EVEX_Vp2intersectq_kp1_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpshldvw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpshldvw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpshldvw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpshldvw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpshldvw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpshldvw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpshldvd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpshldvd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpshldvd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpshldvd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpshldvd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpshldvd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpshldvq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpshldvq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpshldvq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpshldvq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpshldvq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpshldvq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpshrdvw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpshrdvw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpshrdvw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpshrdvw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpshrdvw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpshrdvw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vcvtneps2bf16_xmm_k1z_xmmm128b32", Code::EVEX_Vcvtneps2bf16_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtneps2bf16_xmm_k1z_ymmm256b32", Code::EVEX_Vcvtneps2bf16_xmm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vcvtneps2bf16_ymm_k1z_zmmm512b32", Code::EVEX_Vcvtneps2bf16_ymm_k1z_zmmm512b32);
		let _ = h.insert("EVEX_Vcvtne2ps2bf16_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vcvtne2ps2bf16_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vcvtne2ps2bf16_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vcvtne2ps2bf16_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vcvtne2ps2bf16_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vcvtne2ps2bf16_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpshrdvd_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpshrdvd_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpshrdvd_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpshrdvd_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpshrdvd_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpshrdvd_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpshrdvq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpshrdvq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpshrdvq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpshrdvq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpshrdvq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpshrdvq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpermi2b_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpermi2b_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpermi2b_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpermi2b_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermi2b_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpermi2b_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpermi2w_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpermi2w_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpermi2w_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpermi2w_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermi2w_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpermi2w_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpermi2d_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpermi2d_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpermi2d_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpermi2d_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpermi2d_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpermi2d_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpermi2q_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpermi2q_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpermi2q_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpermi2q_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpermi2q_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpermi2q_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpermi2ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpermi2ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpermi2ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpermi2ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpermi2ps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpermi2ps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpermi2pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpermi2pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpermi2pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpermi2pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpermi2pd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpermi2pd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("VEX_Vpbroadcastb_xmm_xmmm8", Code::VEX_Vpbroadcastb_xmm_xmmm8);
		let _ = h.insert("VEX_Vpbroadcastb_ymm_xmmm8", Code::VEX_Vpbroadcastb_ymm_xmmm8);
		let _ = h.insert("EVEX_Vpbroadcastb_xmm_k1z_xmmm8", Code::EVEX_Vpbroadcastb_xmm_k1z_xmmm8);
		let _ = h.insert("EVEX_Vpbroadcastb_ymm_k1z_xmmm8", Code::EVEX_Vpbroadcastb_ymm_k1z_xmmm8);
		let _ = h.insert("EVEX_Vpbroadcastb_zmm_k1z_xmmm8", Code::EVEX_Vpbroadcastb_zmm_k1z_xmmm8);
		let _ = h.insert("VEX_Vpbroadcastw_xmm_xmmm16", Code::VEX_Vpbroadcastw_xmm_xmmm16);
		let _ = h.insert("VEX_Vpbroadcastw_ymm_xmmm16", Code::VEX_Vpbroadcastw_ymm_xmmm16);
		let _ = h.insert("EVEX_Vpbroadcastw_xmm_k1z_xmmm16", Code::EVEX_Vpbroadcastw_xmm_k1z_xmmm16);
		let _ = h.insert("EVEX_Vpbroadcastw_ymm_k1z_xmmm16", Code::EVEX_Vpbroadcastw_ymm_k1z_xmmm16);
		let _ = h.insert("EVEX_Vpbroadcastw_zmm_k1z_xmmm16", Code::EVEX_Vpbroadcastw_zmm_k1z_xmmm16);
		let _ = h.insert("EVEX_Vpbroadcastb_xmm_k1z_r32", Code::EVEX_Vpbroadcastb_xmm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastb_ymm_k1z_r32", Code::EVEX_Vpbroadcastb_ymm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastb_zmm_k1z_r32", Code::EVEX_Vpbroadcastb_zmm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastw_xmm_k1z_r32", Code::EVEX_Vpbroadcastw_xmm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastw_ymm_k1z_r32", Code::EVEX_Vpbroadcastw_ymm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastw_zmm_k1z_r32", Code::EVEX_Vpbroadcastw_zmm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastd_xmm_k1z_r32", Code::EVEX_Vpbroadcastd_xmm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastd_ymm_k1z_r32", Code::EVEX_Vpbroadcastd_ymm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastd_zmm_k1z_r32", Code::EVEX_Vpbroadcastd_zmm_k1z_r32);
		let _ = h.insert("EVEX_Vpbroadcastq_xmm_k1z_r64", Code::EVEX_Vpbroadcastq_xmm_k1z_r64);
		let _ = h.insert("EVEX_Vpbroadcastq_ymm_k1z_r64", Code::EVEX_Vpbroadcastq_ymm_k1z_r64);
		let _ = h.insert("EVEX_Vpbroadcastq_zmm_k1z_r64", Code::EVEX_Vpbroadcastq_zmm_k1z_r64);
		let _ = h.insert("EVEX_Vpermt2b_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpermt2b_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpermt2b_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpermt2b_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermt2b_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpermt2b_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpermt2w_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpermt2w_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpermt2w_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpermt2w_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermt2w_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpermt2w_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpermt2d_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpermt2d_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpermt2d_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpermt2d_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpermt2d_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpermt2d_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpermt2q_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpermt2q_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpermt2q_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpermt2q_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpermt2q_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpermt2q_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpermt2ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vpermt2ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vpermt2ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vpermt2ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vpermt2ps_zmm_k1z_zmm_zmmm512b32", Code::EVEX_Vpermt2ps_zmm_k1z_zmm_zmmm512b32);
		let _ = h.insert("EVEX_Vpermt2pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpermt2pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpermt2pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpermt2pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpermt2pd_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpermt2pd_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("Invept_r32_m128", Code::Invept_r32_m128);
		let _ = h.insert("Invept_r64_m128", Code::Invept_r64_m128);
		let _ = h.insert("Invvpid_r32_m128", Code::Invvpid_r32_m128);
		let _ = h.insert("Invvpid_r64_m128", Code::Invvpid_r64_m128);
		let _ = h.insert("Invpcid_r32_m128", Code::Invpcid_r32_m128);
		let _ = h.insert("Invpcid_r64_m128", Code::Invpcid_r64_m128);
		let _ = h.insert("EVEX_Vpmultishiftqb_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmultishiftqb_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmultishiftqb_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmultishiftqb_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmultishiftqb_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmultishiftqb_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vexpandps_xmm_k1z_xmmm128", Code::EVEX_Vexpandps_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vexpandps_ymm_k1z_ymmm256", Code::EVEX_Vexpandps_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vexpandps_zmm_k1z_zmmm512", Code::EVEX_Vexpandps_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vexpandpd_xmm_k1z_xmmm128", Code::EVEX_Vexpandpd_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vexpandpd_ymm_k1z_ymmm256", Code::EVEX_Vexpandpd_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vexpandpd_zmm_k1z_zmmm512", Code::EVEX_Vexpandpd_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vpexpandd_xmm_k1z_xmmm128", Code::EVEX_Vpexpandd_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpexpandd_ymm_k1z_ymmm256", Code::EVEX_Vpexpandd_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpexpandd_zmm_k1z_zmmm512", Code::EVEX_Vpexpandd_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vpexpandq_xmm_k1z_xmmm128", Code::EVEX_Vpexpandq_xmm_k1z_xmmm128);
		let _ = h.insert("EVEX_Vpexpandq_ymm_k1z_ymmm256", Code::EVEX_Vpexpandq_ymm_k1z_ymmm256);
		let _ = h.insert("EVEX_Vpexpandq_zmm_k1z_zmmm512", Code::EVEX_Vpexpandq_zmm_k1z_zmmm512);
		let _ = h.insert("EVEX_Vcompressps_xmmm128_k1z_xmm", Code::EVEX_Vcompressps_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vcompressps_ymmm256_k1z_ymm", Code::EVEX_Vcompressps_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vcompressps_zmmm512_k1z_zmm", Code::EVEX_Vcompressps_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vcompresspd_xmmm128_k1z_xmm", Code::EVEX_Vcompresspd_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vcompresspd_ymmm256_k1z_ymm", Code::EVEX_Vcompresspd_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vcompresspd_zmmm512_k1z_zmm", Code::EVEX_Vcompresspd_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vpcompressd_xmmm128_k1z_xmm", Code::EVEX_Vpcompressd_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vpcompressd_ymmm256_k1z_ymm", Code::EVEX_Vpcompressd_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vpcompressd_zmmm512_k1z_zmm", Code::EVEX_Vpcompressd_zmmm512_k1z_zmm);
		let _ = h.insert("EVEX_Vpcompressq_xmmm128_k1z_xmm", Code::EVEX_Vpcompressq_xmmm128_k1z_xmm);
		let _ = h.insert("EVEX_Vpcompressq_ymmm256_k1z_ymm", Code::EVEX_Vpcompressq_ymmm256_k1z_ymm);
		let _ = h.insert("EVEX_Vpcompressq_zmmm512_k1z_zmm", Code::EVEX_Vpcompressq_zmmm512_k1z_zmm);
		let _ = h.insert("VEX_Vpmaskmovd_xmm_xmm_m128", Code::VEX_Vpmaskmovd_xmm_xmm_m128);
		let _ = h.insert("VEX_Vpmaskmovd_ymm_ymm_m256", Code::VEX_Vpmaskmovd_ymm_ymm_m256);
		let _ = h.insert("VEX_Vpmaskmovq_xmm_xmm_m128", Code::VEX_Vpmaskmovq_xmm_xmm_m128);
		let _ = h.insert("VEX_Vpmaskmovq_ymm_ymm_m256", Code::VEX_Vpmaskmovq_ymm_ymm_m256);
		let _ = h.insert("EVEX_Vpermb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpermb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpermb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpermb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpermb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("EVEX_Vpermw_xmm_k1z_xmm_xmmm128", Code::EVEX_Vpermw_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpermw_ymm_k1z_ymm_ymmm256", Code::EVEX_Vpermw_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpermw_zmm_k1z_zmm_zmmm512", Code::EVEX_Vpermw_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("VEX_Vpmaskmovd_m128_xmm_xmm", Code::VEX_Vpmaskmovd_m128_xmm_xmm);
		let _ = h.insert("VEX_Vpmaskmovd_m256_ymm_ymm", Code::VEX_Vpmaskmovd_m256_ymm_ymm);
		let _ = h.insert("VEX_Vpmaskmovq_m128_xmm_xmm", Code::VEX_Vpmaskmovq_m128_xmm_xmm);
		let _ = h.insert("VEX_Vpmaskmovq_m256_ymm_ymm", Code::VEX_Vpmaskmovq_m256_ymm_ymm);
		let _ = h.insert("EVEX_Vpshufbitqmb_kr_k1_xmm_xmmm128", Code::EVEX_Vpshufbitqmb_kr_k1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vpshufbitqmb_kr_k1_ymm_ymmm256", Code::EVEX_Vpshufbitqmb_kr_k1_ymm_ymmm256);
		let _ = h.insert("EVEX_Vpshufbitqmb_kr_k1_zmm_zmmm512", Code::EVEX_Vpshufbitqmb_kr_k1_zmm_zmmm512);
		let _ = h.insert("VEX_Vpgatherdd_xmm_vm32x_xmm", Code::VEX_Vpgatherdd_xmm_vm32x_xmm);
		let _ = h.insert("VEX_Vpgatherdd_ymm_vm32y_ymm", Code::VEX_Vpgatherdd_ymm_vm32y_ymm);
		let _ = h.insert("VEX_Vpgatherdq_xmm_vm32x_xmm", Code::VEX_Vpgatherdq_xmm_vm32x_xmm);
		let _ = h.insert("VEX_Vpgatherdq_ymm_vm32x_ymm", Code::VEX_Vpgatherdq_ymm_vm32x_ymm);
		let _ = h.insert("EVEX_Vpgatherdd_xmm_k1_vm32x", Code::EVEX_Vpgatherdd_xmm_k1_vm32x);
		let _ = h.insert("EVEX_Vpgatherdd_ymm_k1_vm32y", Code::EVEX_Vpgatherdd_ymm_k1_vm32y);
		let _ = h.insert("EVEX_Vpgatherdd_zmm_k1_vm32z", Code::EVEX_Vpgatherdd_zmm_k1_vm32z);
		let _ = h.insert("EVEX_Vpgatherdq_xmm_k1_vm32x", Code::EVEX_Vpgatherdq_xmm_k1_vm32x);
		let _ = h.insert("EVEX_Vpgatherdq_ymm_k1_vm32x", Code::EVEX_Vpgatherdq_ymm_k1_vm32x);
		let _ = h.insert("EVEX_Vpgatherdq_zmm_k1_vm32y", Code::EVEX_Vpgatherdq_zmm_k1_vm32y);
		let _ = h.insert("VEX_Vpgatherqd_xmm_vm64x_xmm", Code::VEX_Vpgatherqd_xmm_vm64x_xmm);
		let _ = h.insert("VEX_Vpgatherqd_xmm_vm64y_xmm", Code::VEX_Vpgatherqd_xmm_vm64y_xmm);
		let _ = h.insert("VEX_Vpgatherqq_xmm_vm64x_xmm", Code::VEX_Vpgatherqq_xmm_vm64x_xmm);
		let _ = h.insert("VEX_Vpgatherqq_ymm_vm64y_ymm", Code::VEX_Vpgatherqq_ymm_vm64y_ymm);
		let _ = h.insert("EVEX_Vpgatherqd_xmm_k1_vm64x", Code::EVEX_Vpgatherqd_xmm_k1_vm64x);
		let _ = h.insert("EVEX_Vpgatherqd_xmm_k1_vm64y", Code::EVEX_Vpgatherqd_xmm_k1_vm64y);
		let _ = h.insert("EVEX_Vpgatherqd_ymm_k1_vm64z", Code::EVEX_Vpgatherqd_ymm_k1_vm64z);
		let _ = h.insert("EVEX_Vpgatherqq_xmm_k1_vm64x", Code::EVEX_Vpgatherqq_xmm_k1_vm64x);
		let _ = h.insert("EVEX_Vpgatherqq_ymm_k1_vm64y", Code::EVEX_Vpgatherqq_ymm_k1_vm64y);
		let _ = h.insert("EVEX_Vpgatherqq_zmm_k1_vm64z", Code::EVEX_Vpgatherqq_zmm_k1_vm64z);
		let _ = h.insert("VEX_Vgatherdps_xmm_vm32x_xmm", Code::VEX_Vgatherdps_xmm_vm32x_xmm);
		let _ = h.insert("VEX_Vgatherdps_ymm_vm32y_ymm", Code::VEX_Vgatherdps_ymm_vm32y_ymm);
		let _ = h.insert("VEX_Vgatherdpd_xmm_vm32x_xmm", Code::VEX_Vgatherdpd_xmm_vm32x_xmm);
		let _ = h.insert("VEX_Vgatherdpd_ymm_vm32x_ymm", Code::VEX_Vgatherdpd_ymm_vm32x_ymm);
		let _ = h.insert("EVEX_Vgatherdps_xmm_k1_vm32x", Code::EVEX_Vgatherdps_xmm_k1_vm32x);
		let _ = h.insert("EVEX_Vgatherdps_ymm_k1_vm32y", Code::EVEX_Vgatherdps_ymm_k1_vm32y);
		let _ = h.insert("EVEX_Vgatherdps_zmm_k1_vm32z", Code::EVEX_Vgatherdps_zmm_k1_vm32z);
		let _ = h.insert("EVEX_Vgatherdpd_xmm_k1_vm32x", Code::EVEX_Vgatherdpd_xmm_k1_vm32x);
		let _ = h.insert("EVEX_Vgatherdpd_ymm_k1_vm32x", Code::EVEX_Vgatherdpd_ymm_k1_vm32x);
		let _ = h.insert("EVEX_Vgatherdpd_zmm_k1_vm32y", Code::EVEX_Vgatherdpd_zmm_k1_vm32y);
		let _ = h.insert("VEX_Vgatherqps_xmm_vm64x_xmm", Code::VEX_Vgatherqps_xmm_vm64x_xmm);
		let _ = h.insert("VEX_Vgatherqps_xmm_vm64y_xmm", Code::VEX_Vgatherqps_xmm_vm64y_xmm);
		let _ = h.insert("VEX_Vgatherqpd_xmm_vm64x_xmm", Code::VEX_Vgatherqpd_xmm_vm64x_xmm);
		let _ = h.insert("VEX_Vgatherqpd_ymm_vm64y_ymm", Code::VEX_Vgatherqpd_ymm_vm64y_ymm);
		let _ = h.insert("EVEX_Vgatherqps_xmm_k1_vm64x", Code::EVEX_Vgatherqps_xmm_k1_vm64x);
		let _ = h.insert("EVEX_Vgatherqps_xmm_k1_vm64y", Code::EVEX_Vgatherqps_xmm_k1_vm64y);
		let _ = h.insert("EVEX_Vgatherqps_ymm_k1_vm64z", Code::EVEX_Vgatherqps_ymm_k1_vm64z);
		let _ = h.insert("EVEX_Vgatherqpd_xmm_k1_vm64x", Code::EVEX_Vgatherqpd_xmm_k1_vm64x);
		let _ = h.insert("EVEX_Vgatherqpd_ymm_k1_vm64y", Code::EVEX_Vgatherqpd_ymm_k1_vm64y);
		let _ = h.insert("EVEX_Vgatherqpd_zmm_k1_vm64z", Code::EVEX_Vgatherqpd_zmm_k1_vm64z);
		let _ = h.insert("VEX_Vfmaddsub132ps_xmm_xmm_xmmm128", Code::VEX_Vfmaddsub132ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsub132ps_ymm_ymm_ymmm256", Code::VEX_Vfmaddsub132ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmaddsub132pd_xmm_xmm_xmmm128", Code::VEX_Vfmaddsub132pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsub132pd_ymm_ymm_ymmm256", Code::VEX_Vfmaddsub132pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmaddsub132ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmaddsub132ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmaddsub132ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmaddsub132ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmaddsub132ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmaddsub132ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmaddsub132pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmaddsub132pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmaddsub132pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmaddsub132pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmaddsub132pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmaddsub132pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmsubadd132ps_xmm_xmm_xmmm128", Code::VEX_Vfmsubadd132ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubadd132ps_ymm_ymm_ymmm256", Code::VEX_Vfmsubadd132ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsubadd132pd_xmm_xmm_xmmm128", Code::VEX_Vfmsubadd132pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubadd132pd_ymm_ymm_ymmm256", Code::VEX_Vfmsubadd132pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmsubadd132ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmsubadd132ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmsubadd132ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmsubadd132ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmsubadd132ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmsubadd132ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmsubadd132pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmsubadd132pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmsubadd132pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmsubadd132pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmsubadd132pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmsubadd132pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmadd132ps_xmm_xmm_xmmm128", Code::VEX_Vfmadd132ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmadd132ps_ymm_ymm_ymmm256", Code::VEX_Vfmadd132ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmadd132pd_xmm_xmm_xmmm128", Code::VEX_Vfmadd132pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmadd132pd_ymm_ymm_ymmm256", Code::VEX_Vfmadd132pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmadd132ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmadd132ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmadd132ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmadd132ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmadd132ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmadd132ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmadd132pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmadd132pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmadd132pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmadd132pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmadd132pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmadd132pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmadd132ss_xmm_xmm_xmmm32", Code::VEX_Vfmadd132ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmadd132sd_xmm_xmm_xmmm64", Code::VEX_Vfmadd132sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfmadd132ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfmadd132ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfmadd132sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfmadd132sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vfmsub132ps_xmm_xmm_xmmm128", Code::VEX_Vfmsub132ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsub132ps_ymm_ymm_ymmm256", Code::VEX_Vfmsub132ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsub132pd_xmm_xmm_xmmm128", Code::VEX_Vfmsub132pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsub132pd_ymm_ymm_ymmm256", Code::VEX_Vfmsub132pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmsub132ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmsub132ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmsub132ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmsub132ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmsub132ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmsub132ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmsub132pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmsub132pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmsub132pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmsub132pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmsub132pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmsub132pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("EVEX_V4fmaddps_zmm_k1z_zmmp3_m128", Code::EVEX_V4fmaddps_zmm_k1z_zmmp3_m128);
		let _ = h.insert("VEX_Vfmsub132ss_xmm_xmm_xmmm32", Code::VEX_Vfmsub132ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmsub132sd_xmm_xmm_xmmm64", Code::VEX_Vfmsub132sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfmsub132ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfmsub132ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfmsub132sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfmsub132sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("EVEX_V4fmaddss_xmm_k1z_xmmp3_m128", Code::EVEX_V4fmaddss_xmm_k1z_xmmp3_m128);
		let _ = h.insert("VEX_Vfnmadd132ps_xmm_xmm_xmmm128", Code::VEX_Vfnmadd132ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmadd132ps_ymm_ymm_ymmm256", Code::VEX_Vfnmadd132ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmadd132pd_xmm_xmm_xmmm128", Code::VEX_Vfnmadd132pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmadd132pd_ymm_ymm_ymmm256", Code::VEX_Vfnmadd132pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfnmadd132ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfnmadd132ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfnmadd132ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfnmadd132ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfnmadd132ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfnmadd132ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfnmadd132pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfnmadd132pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfnmadd132pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfnmadd132pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfnmadd132pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfnmadd132pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfnmadd132ss_xmm_xmm_xmmm32", Code::VEX_Vfnmadd132ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmadd132sd_xmm_xmm_xmmm64", Code::VEX_Vfnmadd132sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfnmadd132ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfnmadd132ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfnmadd132sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfnmadd132sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vfnmsub132ps_xmm_xmm_xmmm128", Code::VEX_Vfnmsub132ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsub132ps_ymm_ymm_ymmm256", Code::VEX_Vfnmsub132ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmsub132pd_xmm_xmm_xmmm128", Code::VEX_Vfnmsub132pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsub132pd_ymm_ymm_ymmm256", Code::VEX_Vfnmsub132pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfnmsub132ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfnmsub132ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfnmsub132ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfnmsub132ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfnmsub132ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfnmsub132ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfnmsub132pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfnmsub132pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfnmsub132pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfnmsub132pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfnmsub132pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfnmsub132pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfnmsub132ss_xmm_xmm_xmmm32", Code::VEX_Vfnmsub132ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmsub132sd_xmm_xmm_xmmm64", Code::VEX_Vfnmsub132sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfnmsub132ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfnmsub132ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfnmsub132sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfnmsub132sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("EVEX_Vpscatterdd_vm32x_k1_xmm", Code::EVEX_Vpscatterdd_vm32x_k1_xmm);
		let _ = h.insert("EVEX_Vpscatterdd_vm32y_k1_ymm", Code::EVEX_Vpscatterdd_vm32y_k1_ymm);
		let _ = h.insert("EVEX_Vpscatterdd_vm32z_k1_zmm", Code::EVEX_Vpscatterdd_vm32z_k1_zmm);
		let _ = h.insert("EVEX_Vpscatterdq_vm32x_k1_xmm", Code::EVEX_Vpscatterdq_vm32x_k1_xmm);
		let _ = h.insert("EVEX_Vpscatterdq_vm32x_k1_ymm", Code::EVEX_Vpscatterdq_vm32x_k1_ymm);
		let _ = h.insert("EVEX_Vpscatterdq_vm32y_k1_zmm", Code::EVEX_Vpscatterdq_vm32y_k1_zmm);
		let _ = h.insert("EVEX_Vpscatterqd_vm64x_k1_xmm", Code::EVEX_Vpscatterqd_vm64x_k1_xmm);
		let _ = h.insert("EVEX_Vpscatterqd_vm64y_k1_xmm", Code::EVEX_Vpscatterqd_vm64y_k1_xmm);
		let _ = h.insert("EVEX_Vpscatterqd_vm64z_k1_ymm", Code::EVEX_Vpscatterqd_vm64z_k1_ymm);
		let _ = h.insert("EVEX_Vpscatterqq_vm64x_k1_xmm", Code::EVEX_Vpscatterqq_vm64x_k1_xmm);
		let _ = h.insert("EVEX_Vpscatterqq_vm64y_k1_ymm", Code::EVEX_Vpscatterqq_vm64y_k1_ymm);
		let _ = h.insert("EVEX_Vpscatterqq_vm64z_k1_zmm", Code::EVEX_Vpscatterqq_vm64z_k1_zmm);
		let _ = h.insert("EVEX_Vscatterdps_vm32x_k1_xmm", Code::EVEX_Vscatterdps_vm32x_k1_xmm);
		let _ = h.insert("EVEX_Vscatterdps_vm32y_k1_ymm", Code::EVEX_Vscatterdps_vm32y_k1_ymm);
		let _ = h.insert("EVEX_Vscatterdps_vm32z_k1_zmm", Code::EVEX_Vscatterdps_vm32z_k1_zmm);
		let _ = h.insert("EVEX_Vscatterdpd_vm32x_k1_xmm", Code::EVEX_Vscatterdpd_vm32x_k1_xmm);
		let _ = h.insert("EVEX_Vscatterdpd_vm32x_k1_ymm", Code::EVEX_Vscatterdpd_vm32x_k1_ymm);
		let _ = h.insert("EVEX_Vscatterdpd_vm32y_k1_zmm", Code::EVEX_Vscatterdpd_vm32y_k1_zmm);
		let _ = h.insert("EVEX_Vscatterqps_vm64x_k1_xmm", Code::EVEX_Vscatterqps_vm64x_k1_xmm);
		let _ = h.insert("EVEX_Vscatterqps_vm64y_k1_xmm", Code::EVEX_Vscatterqps_vm64y_k1_xmm);
		let _ = h.insert("EVEX_Vscatterqps_vm64z_k1_ymm", Code::EVEX_Vscatterqps_vm64z_k1_ymm);
		let _ = h.insert("EVEX_Vscatterqpd_vm64x_k1_xmm", Code::EVEX_Vscatterqpd_vm64x_k1_xmm);
		let _ = h.insert("EVEX_Vscatterqpd_vm64y_k1_ymm", Code::EVEX_Vscatterqpd_vm64y_k1_ymm);
		let _ = h.insert("EVEX_Vscatterqpd_vm64z_k1_zmm", Code::EVEX_Vscatterqpd_vm64z_k1_zmm);
		let _ = h.insert("VEX_Vfmaddsub213ps_xmm_xmm_xmmm128", Code::VEX_Vfmaddsub213ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsub213ps_ymm_ymm_ymmm256", Code::VEX_Vfmaddsub213ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmaddsub213pd_xmm_xmm_xmmm128", Code::VEX_Vfmaddsub213pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsub213pd_ymm_ymm_ymmm256", Code::VEX_Vfmaddsub213pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmaddsub213ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmaddsub213ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmaddsub213ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmaddsub213ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmaddsub213ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmaddsub213ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmaddsub213pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmaddsub213pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmaddsub213pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmaddsub213pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmaddsub213pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmaddsub213pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmsubadd213ps_xmm_xmm_xmmm128", Code::VEX_Vfmsubadd213ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubadd213ps_ymm_ymm_ymmm256", Code::VEX_Vfmsubadd213ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsubadd213pd_xmm_xmm_xmmm128", Code::VEX_Vfmsubadd213pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubadd213pd_ymm_ymm_ymmm256", Code::VEX_Vfmsubadd213pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmsubadd213ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmsubadd213ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmsubadd213ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmsubadd213ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmsubadd213ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmsubadd213ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmsubadd213pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmsubadd213pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmsubadd213pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmsubadd213pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmsubadd213pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmsubadd213pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmadd213ps_xmm_xmm_xmmm128", Code::VEX_Vfmadd213ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmadd213ps_ymm_ymm_ymmm256", Code::VEX_Vfmadd213ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmadd213pd_xmm_xmm_xmmm128", Code::VEX_Vfmadd213pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmadd213pd_ymm_ymm_ymmm256", Code::VEX_Vfmadd213pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmadd213ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmadd213ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmadd213ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmadd213ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmadd213ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmadd213ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmadd213pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmadd213pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmadd213pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmadd213pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmadd213pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmadd213pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmadd213ss_xmm_xmm_xmmm32", Code::VEX_Vfmadd213ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmadd213sd_xmm_xmm_xmmm64", Code::VEX_Vfmadd213sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfmadd213ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfmadd213ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfmadd213sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfmadd213sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vfmsub213ps_xmm_xmm_xmmm128", Code::VEX_Vfmsub213ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsub213ps_ymm_ymm_ymmm256", Code::VEX_Vfmsub213ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsub213pd_xmm_xmm_xmmm128", Code::VEX_Vfmsub213pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsub213pd_ymm_ymm_ymmm256", Code::VEX_Vfmsub213pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmsub213ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmsub213ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmsub213ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmsub213ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmsub213ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmsub213ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmsub213pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmsub213pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmsub213pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmsub213pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmsub213pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmsub213pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("EVEX_V4fnmaddps_zmm_k1z_zmmp3_m128", Code::EVEX_V4fnmaddps_zmm_k1z_zmmp3_m128);
		let _ = h.insert("VEX_Vfmsub213ss_xmm_xmm_xmmm32", Code::VEX_Vfmsub213ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmsub213sd_xmm_xmm_xmmm64", Code::VEX_Vfmsub213sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfmsub213ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfmsub213ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfmsub213sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfmsub213sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("EVEX_V4fnmaddss_xmm_k1z_xmmp3_m128", Code::EVEX_V4fnmaddss_xmm_k1z_xmmp3_m128);
		let _ = h.insert("VEX_Vfnmadd213ps_xmm_xmm_xmmm128", Code::VEX_Vfnmadd213ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmadd213ps_ymm_ymm_ymmm256", Code::VEX_Vfnmadd213ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmadd213pd_xmm_xmm_xmmm128", Code::VEX_Vfnmadd213pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmadd213pd_ymm_ymm_ymmm256", Code::VEX_Vfnmadd213pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfnmadd213ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfnmadd213ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfnmadd213ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfnmadd213ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfnmadd213ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfnmadd213ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfnmadd213pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfnmadd213pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfnmadd213pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfnmadd213pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfnmadd213pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfnmadd213pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfnmadd213ss_xmm_xmm_xmmm32", Code::VEX_Vfnmadd213ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmadd213sd_xmm_xmm_xmmm64", Code::VEX_Vfnmadd213sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfnmadd213ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfnmadd213ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfnmadd213sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfnmadd213sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vfnmsub213ps_xmm_xmm_xmmm128", Code::VEX_Vfnmsub213ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsub213ps_ymm_ymm_ymmm256", Code::VEX_Vfnmsub213ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmsub213pd_xmm_xmm_xmmm128", Code::VEX_Vfnmsub213pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsub213pd_ymm_ymm_ymmm256", Code::VEX_Vfnmsub213pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfnmsub213ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfnmsub213ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfnmsub213ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfnmsub213ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfnmsub213ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfnmsub213ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfnmsub213pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfnmsub213pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfnmsub213pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfnmsub213pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfnmsub213pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfnmsub213pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfnmsub213ss_xmm_xmm_xmmm32", Code::VEX_Vfnmsub213ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmsub213sd_xmm_xmm_xmmm64", Code::VEX_Vfnmsub213sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfnmsub213ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfnmsub213ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfnmsub213sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfnmsub213sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("EVEX_Vpmadd52luq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmadd52luq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmadd52luq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmadd52luq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmadd52luq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmadd52luq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("EVEX_Vpmadd52huq_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vpmadd52huq_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vpmadd52huq_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vpmadd52huq_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vpmadd52huq_zmm_k1z_zmm_zmmm512b64", Code::EVEX_Vpmadd52huq_zmm_k1z_zmm_zmmm512b64);
		let _ = h.insert("VEX_Vfmaddsub231ps_xmm_xmm_xmmm128", Code::VEX_Vfmaddsub231ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsub231ps_ymm_ymm_ymmm256", Code::VEX_Vfmaddsub231ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmaddsub231pd_xmm_xmm_xmmm128", Code::VEX_Vfmaddsub231pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsub231pd_ymm_ymm_ymmm256", Code::VEX_Vfmaddsub231pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmaddsub231ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmaddsub231ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmaddsub231ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmaddsub231ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmaddsub231ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmaddsub231ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmaddsub231pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmaddsub231pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmaddsub231pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmaddsub231pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmaddsub231pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmaddsub231pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmsubadd231ps_xmm_xmm_xmmm128", Code::VEX_Vfmsubadd231ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubadd231ps_ymm_ymm_ymmm256", Code::VEX_Vfmsubadd231ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsubadd231pd_xmm_xmm_xmmm128", Code::VEX_Vfmsubadd231pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubadd231pd_ymm_ymm_ymmm256", Code::VEX_Vfmsubadd231pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmsubadd231ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmsubadd231ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmsubadd231ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmsubadd231ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmsubadd231ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmsubadd231ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmsubadd231pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmsubadd231pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmsubadd231pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmsubadd231pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmsubadd231pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmsubadd231pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmadd231ps_xmm_xmm_xmmm128", Code::VEX_Vfmadd231ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmadd231ps_ymm_ymm_ymmm256", Code::VEX_Vfmadd231ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmadd231pd_xmm_xmm_xmmm128", Code::VEX_Vfmadd231pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmadd231pd_ymm_ymm_ymmm256", Code::VEX_Vfmadd231pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmadd231ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmadd231ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmadd231ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmadd231ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmadd231ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmadd231ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmadd231pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmadd231pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmadd231pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmadd231pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmadd231pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmadd231pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmadd231ss_xmm_xmm_xmmm32", Code::VEX_Vfmadd231ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmadd231sd_xmm_xmm_xmmm64", Code::VEX_Vfmadd231sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfmadd231ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfmadd231ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfmadd231sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfmadd231sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vfmsub231ps_xmm_xmm_xmmm128", Code::VEX_Vfmsub231ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsub231ps_ymm_ymm_ymmm256", Code::VEX_Vfmsub231ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsub231pd_xmm_xmm_xmmm128", Code::VEX_Vfmsub231pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsub231pd_ymm_ymm_ymmm256", Code::VEX_Vfmsub231pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfmsub231ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfmsub231ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfmsub231ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfmsub231ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfmsub231ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfmsub231ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfmsub231pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfmsub231pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfmsub231pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfmsub231pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfmsub231pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfmsub231pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfmsub231ss_xmm_xmm_xmmm32", Code::VEX_Vfmsub231ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmsub231sd_xmm_xmm_xmmm64", Code::VEX_Vfmsub231sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfmsub231ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfmsub231ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfmsub231sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfmsub231sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vfnmadd231ps_xmm_xmm_xmmm128", Code::VEX_Vfnmadd231ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmadd231ps_ymm_ymm_ymmm256", Code::VEX_Vfnmadd231ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmadd231pd_xmm_xmm_xmmm128", Code::VEX_Vfnmadd231pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmadd231pd_ymm_ymm_ymmm256", Code::VEX_Vfnmadd231pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfnmadd231ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfnmadd231ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfnmadd231ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfnmadd231ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfnmadd231ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfnmadd231ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfnmadd231pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfnmadd231pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfnmadd231pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfnmadd231pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfnmadd231pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfnmadd231pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfnmadd231ss_xmm_xmm_xmmm32", Code::VEX_Vfnmadd231ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmadd231sd_xmm_xmm_xmmm64", Code::VEX_Vfnmadd231sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfnmadd231ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfnmadd231ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfnmadd231sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfnmadd231sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("VEX_Vfnmsub231ps_xmm_xmm_xmmm128", Code::VEX_Vfnmsub231ps_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsub231ps_ymm_ymm_ymmm256", Code::VEX_Vfnmsub231ps_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmsub231pd_xmm_xmm_xmmm128", Code::VEX_Vfnmsub231pd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsub231pd_ymm_ymm_ymmm256", Code::VEX_Vfnmsub231pd_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vfnmsub231ps_xmm_k1z_xmm_xmmm128b32", Code::EVEX_Vfnmsub231ps_xmm_k1z_xmm_xmmm128b32);
		let _ = h.insert("EVEX_Vfnmsub231ps_ymm_k1z_ymm_ymmm256b32", Code::EVEX_Vfnmsub231ps_ymm_k1z_ymm_ymmm256b32);
		let _ = h.insert("EVEX_Vfnmsub231ps_zmm_k1z_zmm_zmmm512b32_er", Code::EVEX_Vfnmsub231ps_zmm_k1z_zmm_zmmm512b32_er);
		let _ = h.insert("EVEX_Vfnmsub231pd_xmm_k1z_xmm_xmmm128b64", Code::EVEX_Vfnmsub231pd_xmm_k1z_xmm_xmmm128b64);
		let _ = h.insert("EVEX_Vfnmsub231pd_ymm_k1z_ymm_ymmm256b64", Code::EVEX_Vfnmsub231pd_ymm_k1z_ymm_ymmm256b64);
		let _ = h.insert("EVEX_Vfnmsub231pd_zmm_k1z_zmm_zmmm512b64_er", Code::EVEX_Vfnmsub231pd_zmm_k1z_zmm_zmmm512b64_er);
		let _ = h.insert("VEX_Vfnmsub231ss_xmm_xmm_xmmm32", Code::VEX_Vfnmsub231ss_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmsub231sd_xmm_xmm_xmmm64", Code::VEX_Vfnmsub231sd_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vfnmsub231ss_xmm_k1z_xmm_xmmm32_er", Code::EVEX_Vfnmsub231ss_xmm_k1z_xmm_xmmm32_er);
		let _ = h.insert("EVEX_Vfnmsub231sd_xmm_k1z_xmm_xmmm64_er", Code::EVEX_Vfnmsub231sd_xmm_k1z_xmm_xmmm64_er);
		let _ = h.insert("EVEX_Vpconflictd_xmm_k1z_xmmm128b32", Code::EVEX_Vpconflictd_xmm_k1z_xmmm128b32);
		let _ = h.insert("EVEX_Vpconflictd_ymm_k1z_ymmm256b32", Code::EVEX_Vpconflictd_ymm_k1z_ymmm256b32);
		let _ = h.insert("EVEX_Vpconflictd_zmm_k1z_zmmm512b32", Code::EVEX_Vpconflictd_zmm_k1z_zmmm512b32);
		let _ = h.insert("EVEX_Vpconflictq_xmm_k1z_xmmm128b64", Code::EVEX_Vpconflictq_xmm_k1z_xmmm128b64);
		let _ = h.insert("EVEX_Vpconflictq_ymm_k1z_ymmm256b64", Code::EVEX_Vpconflictq_ymm_k1z_ymmm256b64);
		let _ = h.insert("EVEX_Vpconflictq_zmm_k1z_zmmm512b64", Code::EVEX_Vpconflictq_zmm_k1z_zmmm512b64);
		let _ = h.insert("EVEX_Vgatherpf0dps_vm32z_k1", Code::EVEX_Vgatherpf0dps_vm32z_k1);
		let _ = h.insert("EVEX_Vgatherpf0dpd_vm32y_k1", Code::EVEX_Vgatherpf0dpd_vm32y_k1);
		let _ = h.insert("EVEX_Vgatherpf1dps_vm32z_k1", Code::EVEX_Vgatherpf1dps_vm32z_k1);
		let _ = h.insert("EVEX_Vgatherpf1dpd_vm32y_k1", Code::EVEX_Vgatherpf1dpd_vm32y_k1);
		let _ = h.insert("EVEX_Vscatterpf0dps_vm32z_k1", Code::EVEX_Vscatterpf0dps_vm32z_k1);
		let _ = h.insert("EVEX_Vscatterpf0dpd_vm32y_k1", Code::EVEX_Vscatterpf0dpd_vm32y_k1);
		let _ = h.insert("EVEX_Vscatterpf1dps_vm32z_k1", Code::EVEX_Vscatterpf1dps_vm32z_k1);
		let _ = h.insert("EVEX_Vscatterpf1dpd_vm32y_k1", Code::EVEX_Vscatterpf1dpd_vm32y_k1);
		let _ = h.insert("EVEX_Vgatherpf0qps_vm64z_k1", Code::EVEX_Vgatherpf0qps_vm64z_k1);
		let _ = h.insert("EVEX_Vgatherpf0qpd_vm64z_k1", Code::EVEX_Vgatherpf0qpd_vm64z_k1);
		let _ = h.insert("EVEX_Vgatherpf1qps_vm64z_k1", Code::EVEX_Vgatherpf1qps_vm64z_k1);
		let _ = h.insert("EVEX_Vgatherpf1qpd_vm64z_k1", Code::EVEX_Vgatherpf1qpd_vm64z_k1);
		let _ = h.insert("EVEX_Vscatterpf0qps_vm64z_k1", Code::EVEX_Vscatterpf0qps_vm64z_k1);
		let _ = h.insert("EVEX_Vscatterpf0qpd_vm64z_k1", Code::EVEX_Vscatterpf0qpd_vm64z_k1);
		let _ = h.insert("EVEX_Vscatterpf1qps_vm64z_k1", Code::EVEX_Vscatterpf1qps_vm64z_k1);
		let _ = h.insert("EVEX_Vscatterpf1qpd_vm64z_k1", Code::EVEX_Vscatterpf1qpd_vm64z_k1);
		let _ = h.insert("Sha1nexte_xmm_xmmm128", Code::Sha1nexte_xmm_xmmm128);
		let _ = h.insert("EVEX_Vexp2ps_zmm_k1z_zmmm512b32_sae", Code::EVEX_Vexp2ps_zmm_k1z_zmmm512b32_sae);
		let _ = h.insert("EVEX_Vexp2pd_zmm_k1z_zmmm512b64_sae", Code::EVEX_Vexp2pd_zmm_k1z_zmmm512b64_sae);
		let _ = h.insert("Sha1msg1_xmm_xmmm128", Code::Sha1msg1_xmm_xmmm128);
		let _ = h.insert("Sha1msg2_xmm_xmmm128", Code::Sha1msg2_xmm_xmmm128);
		let _ = h.insert("EVEX_Vrcp28ps_zmm_k1z_zmmm512b32_sae", Code::EVEX_Vrcp28ps_zmm_k1z_zmmm512b32_sae);
		let _ = h.insert("EVEX_Vrcp28pd_zmm_k1z_zmmm512b64_sae", Code::EVEX_Vrcp28pd_zmm_k1z_zmmm512b64_sae);
		let _ = h.insert("Sha256rnds2_xmm_xmmm128", Code::Sha256rnds2_xmm_xmmm128);
		let _ = h.insert("EVEX_Vrcp28ss_xmm_k1z_xmm_xmmm32_sae", Code::EVEX_Vrcp28ss_xmm_k1z_xmm_xmmm32_sae);
		let _ = h.insert("EVEX_Vrcp28sd_xmm_k1z_xmm_xmmm64_sae", Code::EVEX_Vrcp28sd_xmm_k1z_xmm_xmmm64_sae);
		let _ = h.insert("Sha256msg1_xmm_xmmm128", Code::Sha256msg1_xmm_xmmm128);
		let _ = h.insert("EVEX_Vrsqrt28ps_zmm_k1z_zmmm512b32_sae", Code::EVEX_Vrsqrt28ps_zmm_k1z_zmmm512b32_sae);
		let _ = h.insert("EVEX_Vrsqrt28pd_zmm_k1z_zmmm512b64_sae", Code::EVEX_Vrsqrt28pd_zmm_k1z_zmmm512b64_sae);
		let _ = h.insert("Sha256msg2_xmm_xmmm128", Code::Sha256msg2_xmm_xmmm128);
		let _ = h.insert("EVEX_Vrsqrt28ss_xmm_k1z_xmm_xmmm32_sae", Code::EVEX_Vrsqrt28ss_xmm_k1z_xmm_xmmm32_sae);
		let _ = h.insert("EVEX_Vrsqrt28sd_xmm_k1z_xmm_xmmm64_sae", Code::EVEX_Vrsqrt28sd_xmm_k1z_xmm_xmmm64_sae);
		let _ = h.insert("Gf2p8mulb_xmm_xmmm128", Code::Gf2p8mulb_xmm_xmmm128);
		let _ = h.insert("VEX_Vgf2p8mulb_xmm_xmm_xmmm128", Code::VEX_Vgf2p8mulb_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vgf2p8mulb_ymm_ymm_ymmm256", Code::VEX_Vgf2p8mulb_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vgf2p8mulb_xmm_k1z_xmm_xmmm128", Code::EVEX_Vgf2p8mulb_xmm_k1z_xmm_xmmm128);
		let _ = h.insert("EVEX_Vgf2p8mulb_ymm_k1z_ymm_ymmm256", Code::EVEX_Vgf2p8mulb_ymm_k1z_ymm_ymmm256);
		let _ = h.insert("EVEX_Vgf2p8mulb_zmm_k1z_zmm_zmmm512", Code::EVEX_Vgf2p8mulb_zmm_k1z_zmm_zmmm512);
		let _ = h.insert("Aesimc_xmm_xmmm128", Code::Aesimc_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesimc_xmm_xmmm128", Code::VEX_Vaesimc_xmm_xmmm128);
		let _ = h.insert("Aesenc_xmm_xmmm128", Code::Aesenc_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesenc_xmm_xmm_xmmm128", Code::VEX_Vaesenc_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesenc_ymm_ymm_ymmm256", Code::VEX_Vaesenc_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesenc_xmm_xmm_xmmm128", Code::EVEX_Vaesenc_xmm_xmm_xmmm128);
		let _ = h.insert("EVEX_Vaesenc_ymm_ymm_ymmm256", Code::EVEX_Vaesenc_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesenc_zmm_zmm_zmmm512", Code::EVEX_Vaesenc_zmm_zmm_zmmm512);
		let _ = h.insert("Aesenclast_xmm_xmmm128", Code::Aesenclast_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesenclast_xmm_xmm_xmmm128", Code::VEX_Vaesenclast_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesenclast_ymm_ymm_ymmm256", Code::VEX_Vaesenclast_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesenclast_xmm_xmm_xmmm128", Code::EVEX_Vaesenclast_xmm_xmm_xmmm128);
		let _ = h.insert("EVEX_Vaesenclast_ymm_ymm_ymmm256", Code::EVEX_Vaesenclast_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesenclast_zmm_zmm_zmmm512", Code::EVEX_Vaesenclast_zmm_zmm_zmmm512);
		let _ = h.insert("Aesdec_xmm_xmmm128", Code::Aesdec_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesdec_xmm_xmm_xmmm128", Code::VEX_Vaesdec_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesdec_ymm_ymm_ymmm256", Code::VEX_Vaesdec_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesdec_xmm_xmm_xmmm128", Code::EVEX_Vaesdec_xmm_xmm_xmmm128);
		let _ = h.insert("EVEX_Vaesdec_ymm_ymm_ymmm256", Code::EVEX_Vaesdec_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesdec_zmm_zmm_zmmm512", Code::EVEX_Vaesdec_zmm_zmm_zmmm512);
		let _ = h.insert("Aesdeclast_xmm_xmmm128", Code::Aesdeclast_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesdeclast_xmm_xmm_xmmm128", Code::VEX_Vaesdeclast_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vaesdeclast_ymm_ymm_ymmm256", Code::VEX_Vaesdeclast_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesdeclast_xmm_xmm_xmmm128", Code::EVEX_Vaesdeclast_xmm_xmm_xmmm128);
		let _ = h.insert("EVEX_Vaesdeclast_ymm_ymm_ymmm256", Code::EVEX_Vaesdeclast_ymm_ymm_ymmm256);
		let _ = h.insert("EVEX_Vaesdeclast_zmm_zmm_zmmm512", Code::EVEX_Vaesdeclast_zmm_zmm_zmmm512);
		let _ = h.insert("Movbe_r16_m16", Code::Movbe_r16_m16);
		let _ = h.insert("Movbe_r32_m32", Code::Movbe_r32_m32);
		let _ = h.insert("Movbe_r64_m64", Code::Movbe_r64_m64);
		let _ = h.insert("Crc32_r32_rm8", Code::Crc32_r32_rm8);
		let _ = h.insert("Crc32_r64_rm8", Code::Crc32_r64_rm8);
		let _ = h.insert("Movbe_m16_r16", Code::Movbe_m16_r16);
		let _ = h.insert("Movbe_m32_r32", Code::Movbe_m32_r32);
		let _ = h.insert("Movbe_m64_r64", Code::Movbe_m64_r64);
		let _ = h.insert("Crc32_r32_rm16", Code::Crc32_r32_rm16);
		let _ = h.insert("Crc32_r32_rm32", Code::Crc32_r32_rm32);
		let _ = h.insert("Crc32_r64_rm64", Code::Crc32_r64_rm64);
		let _ = h.insert("VEX_Andn_r32_r32_rm32", Code::VEX_Andn_r32_r32_rm32);
		let _ = h.insert("VEX_Andn_r64_r64_rm64", Code::VEX_Andn_r64_r64_rm64);
		let _ = h.insert("VEX_Blsr_r32_rm32", Code::VEX_Blsr_r32_rm32);
		let _ = h.insert("VEX_Blsr_r64_rm64", Code::VEX_Blsr_r64_rm64);
		let _ = h.insert("VEX_Blsmsk_r32_rm32", Code::VEX_Blsmsk_r32_rm32);
		let _ = h.insert("VEX_Blsmsk_r64_rm64", Code::VEX_Blsmsk_r64_rm64);
		let _ = h.insert("VEX_Blsi_r32_rm32", Code::VEX_Blsi_r32_rm32);
		let _ = h.insert("VEX_Blsi_r64_rm64", Code::VEX_Blsi_r64_rm64);
		let _ = h.insert("VEX_Bzhi_r32_rm32_r32", Code::VEX_Bzhi_r32_rm32_r32);
		let _ = h.insert("VEX_Bzhi_r64_rm64_r64", Code::VEX_Bzhi_r64_rm64_r64);
		let _ = h.insert("Wrussd_m32_r32", Code::Wrussd_m32_r32);
		let _ = h.insert("Wrussq_m64_r64", Code::Wrussq_m64_r64);
		let _ = h.insert("VEX_Pext_r32_r32_rm32", Code::VEX_Pext_r32_r32_rm32);
		let _ = h.insert("VEX_Pext_r64_r64_rm64", Code::VEX_Pext_r64_r64_rm64);
		let _ = h.insert("VEX_Pdep_r32_r32_rm32", Code::VEX_Pdep_r32_r32_rm32);
		let _ = h.insert("VEX_Pdep_r64_r64_rm64", Code::VEX_Pdep_r64_r64_rm64);
		let _ = h.insert("Wrssd_m32_r32", Code::Wrssd_m32_r32);
		let _ = h.insert("Wrssq_m64_r64", Code::Wrssq_m64_r64);
		let _ = h.insert("Adcx_r32_rm32", Code::Adcx_r32_rm32);
		let _ = h.insert("Adcx_r64_rm64", Code::Adcx_r64_rm64);
		let _ = h.insert("Adox_r32_rm32", Code::Adox_r32_rm32);
		let _ = h.insert("Adox_r64_rm64", Code::Adox_r64_rm64);
		let _ = h.insert("VEX_Mulx_r32_r32_rm32", Code::VEX_Mulx_r32_r32_rm32);
		let _ = h.insert("VEX_Mulx_r64_r64_rm64", Code::VEX_Mulx_r64_r64_rm64);
		let _ = h.insert("VEX_Bextr_r32_rm32_r32", Code::VEX_Bextr_r32_rm32_r32);
		let _ = h.insert("VEX_Bextr_r64_rm64_r64", Code::VEX_Bextr_r64_rm64_r64);
		let _ = h.insert("VEX_Shlx_r32_rm32_r32", Code::VEX_Shlx_r32_rm32_r32);
		let _ = h.insert("VEX_Shlx_r64_rm64_r64", Code::VEX_Shlx_r64_rm64_r64);
		let _ = h.insert("VEX_Sarx_r32_rm32_r32", Code::VEX_Sarx_r32_rm32_r32);
		let _ = h.insert("VEX_Sarx_r64_rm64_r64", Code::VEX_Sarx_r64_rm64_r64);
		let _ = h.insert("VEX_Shrx_r32_rm32_r32", Code::VEX_Shrx_r32_rm32_r32);
		let _ = h.insert("VEX_Shrx_r64_rm64_r64", Code::VEX_Shrx_r64_rm64_r64);
		let _ = h.insert("Movdir64b_r16_m512", Code::Movdir64b_r16_m512);
		let _ = h.insert("Movdir64b_r32_m512", Code::Movdir64b_r32_m512);
		let _ = h.insert("Movdir64b_r64_m512", Code::Movdir64b_r64_m512);
		let _ = h.insert("Enqcmds_r16_m512", Code::Enqcmds_r16_m512);
		let _ = h.insert("Enqcmds_r32_m512", Code::Enqcmds_r32_m512);
		let _ = h.insert("Enqcmds_r64_m512", Code::Enqcmds_r64_m512);
		let _ = h.insert("Enqcmd_r16_m512", Code::Enqcmd_r16_m512);
		let _ = h.insert("Enqcmd_r32_m512", Code::Enqcmd_r32_m512);
		let _ = h.insert("Enqcmd_r64_m512", Code::Enqcmd_r64_m512);
		let _ = h.insert("Movdiri_m32_r32", Code::Movdiri_m32_r32);
		let _ = h.insert("Movdiri_m64_r64", Code::Movdiri_m64_r64);
		let _ = h.insert("VEX_Vpermq_ymm_ymmm256_imm8", Code::VEX_Vpermq_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpermq_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vpermq_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpermq_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vpermq_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("VEX_Vpermpd_ymm_ymmm256_imm8", Code::VEX_Vpermpd_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpermpd_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vpermpd_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpermpd_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vpermpd_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("VEX_Vpblendd_xmm_xmm_xmmm128_imm8", Code::VEX_Vpblendd_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpblendd_ymm_ymm_ymmm256_imm8", Code::VEX_Vpblendd_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8", Code::EVEX_Valignd_xmm_k1z_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Valignd_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8", Code::EVEX_Valignd_zmm_k1z_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Valignq_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Valignq_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Valignq_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("VEX_Vpermilps_xmm_xmmm128_imm8", Code::VEX_Vpermilps_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpermilps_ymm_ymmm256_imm8", Code::VEX_Vpermilps_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpermilps_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vpermilps_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpermilps_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vpermilps_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpermilps_zmm_k1z_zmmm512b32_imm8", Code::EVEX_Vpermilps_zmm_k1z_zmmm512b32_imm8);
		let _ = h.insert("VEX_Vpermilpd_xmm_xmmm128_imm8", Code::VEX_Vpermilpd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpermilpd_ymm_ymmm256_imm8", Code::VEX_Vpermilpd_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpermilpd_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vpermilpd_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpermilpd_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vpermilpd_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpermilpd_zmm_k1z_zmmm512b64_imm8", Code::EVEX_Vpermilpd_zmm_k1z_zmmm512b64_imm8);
		let _ = h.insert("VEX_Vperm2f128_ymm_ymm_ymmm256_imm8", Code::VEX_Vperm2f128_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("Roundps_xmm_xmmm128_imm8", Code::Roundps_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vroundps_xmm_xmmm128_imm8", Code::VEX_Vroundps_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vroundps_ymm_ymmm256_imm8", Code::VEX_Vroundps_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vrndscaleps_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vrndscaleps_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vrndscaleps_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vrndscaleps_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vrndscaleps_zmm_k1z_zmmm512b32_imm8_sae", Code::EVEX_Vrndscaleps_zmm_k1z_zmmm512b32_imm8_sae);
		let _ = h.insert("Roundpd_xmm_xmmm128_imm8", Code::Roundpd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vroundpd_xmm_xmmm128_imm8", Code::VEX_Vroundpd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vroundpd_ymm_ymmm256_imm8", Code::VEX_Vroundpd_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vrndscalepd_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vrndscalepd_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vrndscalepd_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vrndscalepd_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vrndscalepd_zmm_k1z_zmmm512b64_imm8_sae", Code::EVEX_Vrndscalepd_zmm_k1z_zmmm512b64_imm8_sae);
		let _ = h.insert("Roundss_xmm_xmmm32_imm8", Code::Roundss_xmm_xmmm32_imm8);
		let _ = h.insert("VEX_Vroundss_xmm_xmm_xmmm32_imm8", Code::VEX_Vroundss_xmm_xmm_xmmm32_imm8);
		let _ = h.insert("EVEX_Vrndscaless_xmm_k1z_xmm_xmmm32_imm8_sae", Code::EVEX_Vrndscaless_xmm_k1z_xmm_xmmm32_imm8_sae);
		let _ = h.insert("Roundsd_xmm_xmmm64_imm8", Code::Roundsd_xmm_xmmm64_imm8);
		let _ = h.insert("VEX_Vroundsd_xmm_xmm_xmmm64_imm8", Code::VEX_Vroundsd_xmm_xmm_xmmm64_imm8);
		let _ = h.insert("EVEX_Vrndscalesd_xmm_k1z_xmm_xmmm64_imm8_sae", Code::EVEX_Vrndscalesd_xmm_k1z_xmm_xmmm64_imm8_sae);
		let _ = h.insert("Blendps_xmm_xmmm128_imm8", Code::Blendps_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vblendps_xmm_xmm_xmmm128_imm8", Code::VEX_Vblendps_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vblendps_ymm_ymm_ymmm256_imm8", Code::VEX_Vblendps_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("Blendpd_xmm_xmmm128_imm8", Code::Blendpd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vblendpd_xmm_xmm_xmmm128_imm8", Code::VEX_Vblendpd_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vblendpd_ymm_ymm_ymmm256_imm8", Code::VEX_Vblendpd_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("Pblendw_xmm_xmmm128_imm8", Code::Pblendw_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpblendw_xmm_xmm_xmmm128_imm8", Code::VEX_Vpblendw_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpblendw_ymm_ymm_ymmm256_imm8", Code::VEX_Vpblendw_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("Palignr_mm_mmm64_imm8", Code::Palignr_mm_mmm64_imm8);
		let _ = h.insert("Palignr_xmm_xmmm128_imm8", Code::Palignr_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpalignr_xmm_xmm_xmmm128_imm8", Code::VEX_Vpalignr_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpalignr_ymm_ymm_ymmm256_imm8", Code::VEX_Vpalignr_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpalignr_xmm_k1z_xmm_xmmm128_imm8", Code::EVEX_Vpalignr_xmm_k1z_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpalignr_ymm_k1z_ymm_ymmm256_imm8", Code::EVEX_Vpalignr_ymm_k1z_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpalignr_zmm_k1z_zmm_zmmm512_imm8", Code::EVEX_Vpalignr_zmm_k1z_zmm_zmmm512_imm8);
		let _ = h.insert("Pextrb_r32m8_xmm_imm8", Code::Pextrb_r32m8_xmm_imm8);
		let _ = h.insert("Pextrb_r64m8_xmm_imm8", Code::Pextrb_r64m8_xmm_imm8);
		let _ = h.insert("VEX_Vpextrb_r32m8_xmm_imm8", Code::VEX_Vpextrb_r32m8_xmm_imm8);
		let _ = h.insert("VEX_Vpextrb_r64m8_xmm_imm8", Code::VEX_Vpextrb_r64m8_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrb_r32m8_xmm_imm8", Code::EVEX_Vpextrb_r32m8_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrb_r64m8_xmm_imm8", Code::EVEX_Vpextrb_r64m8_xmm_imm8);
		let _ = h.insert("Pextrw_r32m16_xmm_imm8", Code::Pextrw_r32m16_xmm_imm8);
		let _ = h.insert("Pextrw_r64m16_xmm_imm8", Code::Pextrw_r64m16_xmm_imm8);
		let _ = h.insert("VEX_Vpextrw_r32m16_xmm_imm8", Code::VEX_Vpextrw_r32m16_xmm_imm8);
		let _ = h.insert("VEX_Vpextrw_r64m16_xmm_imm8", Code::VEX_Vpextrw_r64m16_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrw_r32m16_xmm_imm8", Code::EVEX_Vpextrw_r32m16_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrw_r64m16_xmm_imm8", Code::EVEX_Vpextrw_r64m16_xmm_imm8);
		let _ = h.insert("Pextrd_rm32_xmm_imm8", Code::Pextrd_rm32_xmm_imm8);
		let _ = h.insert("Pextrq_rm64_xmm_imm8", Code::Pextrq_rm64_xmm_imm8);
		let _ = h.insert("VEX_Vpextrd_rm32_xmm_imm8", Code::VEX_Vpextrd_rm32_xmm_imm8);
		let _ = h.insert("VEX_Vpextrq_rm64_xmm_imm8", Code::VEX_Vpextrq_rm64_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrd_rm32_xmm_imm8", Code::EVEX_Vpextrd_rm32_xmm_imm8);
		let _ = h.insert("EVEX_Vpextrq_rm64_xmm_imm8", Code::EVEX_Vpextrq_rm64_xmm_imm8);
		let _ = h.insert("Extractps_rm32_xmm_imm8", Code::Extractps_rm32_xmm_imm8);
		let _ = h.insert("Extractps_r64m32_xmm_imm8", Code::Extractps_r64m32_xmm_imm8);
		let _ = h.insert("VEX_Vextractps_rm32_xmm_imm8", Code::VEX_Vextractps_rm32_xmm_imm8);
		let _ = h.insert("VEX_Vextractps_r64m32_xmm_imm8", Code::VEX_Vextractps_r64m32_xmm_imm8);
		let _ = h.insert("EVEX_Vextractps_rm32_xmm_imm8", Code::EVEX_Vextractps_rm32_xmm_imm8);
		let _ = h.insert("EVEX_Vextractps_r64m32_xmm_imm8", Code::EVEX_Vextractps_r64m32_xmm_imm8);
		let _ = h.insert("VEX_Vinsertf128_ymm_ymm_xmmm128_imm8", Code::VEX_Vinsertf128_ymm_ymm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinsertf32x4_ymm_k1z_ymm_xmmm128_imm8", Code::EVEX_Vinsertf32x4_ymm_k1z_ymm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinsertf32x4_zmm_k1z_zmm_xmmm128_imm8", Code::EVEX_Vinsertf32x4_zmm_k1z_zmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinsertf64x2_ymm_k1z_ymm_xmmm128_imm8", Code::EVEX_Vinsertf64x2_ymm_k1z_ymm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinsertf64x2_zmm_k1z_zmm_xmmm128_imm8", Code::EVEX_Vinsertf64x2_zmm_k1z_zmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vextractf128_xmmm128_ymm_imm8", Code::VEX_Vextractf128_xmmm128_ymm_imm8);
		let _ = h.insert("EVEX_Vextractf32x4_xmmm128_k1z_ymm_imm8", Code::EVEX_Vextractf32x4_xmmm128_k1z_ymm_imm8);
		let _ = h.insert("EVEX_Vextractf32x4_xmmm128_k1z_zmm_imm8", Code::EVEX_Vextractf32x4_xmmm128_k1z_zmm_imm8);
		let _ = h.insert("EVEX_Vextractf64x2_xmmm128_k1z_ymm_imm8", Code::EVEX_Vextractf64x2_xmmm128_k1z_ymm_imm8);
		let _ = h.insert("EVEX_Vextractf64x2_xmmm128_k1z_zmm_imm8", Code::EVEX_Vextractf64x2_xmmm128_k1z_zmm_imm8);
		let _ = h.insert("EVEX_Vinsertf32x8_zmm_k1z_zmm_ymmm256_imm8", Code::EVEX_Vinsertf32x8_zmm_k1z_zmm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vinsertf64x4_zmm_k1z_zmm_ymmm256_imm8", Code::EVEX_Vinsertf64x4_zmm_k1z_zmm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vextractf32x8_ymmm256_k1z_zmm_imm8", Code::EVEX_Vextractf32x8_ymmm256_k1z_zmm_imm8);
		let _ = h.insert("EVEX_Vextractf64x4_ymmm256_k1z_zmm_imm8", Code::EVEX_Vextractf64x4_ymmm256_k1z_zmm_imm8);
		let _ = h.insert("VEX_Vcvtps2ph_xmmm64_xmm_imm8", Code::VEX_Vcvtps2ph_xmmm64_xmm_imm8);
		let _ = h.insert("VEX_Vcvtps2ph_xmmm128_ymm_imm8", Code::VEX_Vcvtps2ph_xmmm128_ymm_imm8);
		let _ = h.insert("EVEX_Vcvtps2ph_xmmm64_k1z_xmm_imm8", Code::EVEX_Vcvtps2ph_xmmm64_k1z_xmm_imm8);
		let _ = h.insert("EVEX_Vcvtps2ph_xmmm128_k1z_ymm_imm8", Code::EVEX_Vcvtps2ph_xmmm128_k1z_ymm_imm8);
		let _ = h.insert("EVEX_Vcvtps2ph_ymmm256_k1z_zmm_imm8_sae", Code::EVEX_Vcvtps2ph_ymmm256_k1z_zmm_imm8_sae);
		let _ = h.insert("EVEX_Vpcmpud_kr_k1_xmm_xmmm128b32_imm8", Code::EVEX_Vpcmpud_kr_k1_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpcmpud_kr_k1_ymm_ymmm256b32_imm8", Code::EVEX_Vpcmpud_kr_k1_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpcmpud_kr_k1_zmm_zmmm512b32_imm8", Code::EVEX_Vpcmpud_kr_k1_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vpcmpuq_kr_k1_xmm_xmmm128b64_imm8", Code::EVEX_Vpcmpuq_kr_k1_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpcmpuq_kr_k1_ymm_ymmm256b64_imm8", Code::EVEX_Vpcmpuq_kr_k1_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpcmpuq_kr_k1_zmm_zmmm512b64_imm8", Code::EVEX_Vpcmpuq_kr_k1_zmm_zmmm512b64_imm8);
		let _ = h.insert("EVEX_Vpcmpd_kr_k1_xmm_xmmm128b32_imm8", Code::EVEX_Vpcmpd_kr_k1_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpcmpd_kr_k1_ymm_ymmm256b32_imm8", Code::EVEX_Vpcmpd_kr_k1_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpcmpd_kr_k1_zmm_zmmm512b32_imm8", Code::EVEX_Vpcmpd_kr_k1_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vpcmpq_kr_k1_xmm_xmmm128b64_imm8", Code::EVEX_Vpcmpq_kr_k1_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpcmpq_kr_k1_ymm_ymmm256b64_imm8", Code::EVEX_Vpcmpq_kr_k1_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpcmpq_kr_k1_zmm_zmmm512b64_imm8", Code::EVEX_Vpcmpq_kr_k1_zmm_zmmm512b64_imm8);
		let _ = h.insert("Pinsrb_xmm_r32m8_imm8", Code::Pinsrb_xmm_r32m8_imm8);
		let _ = h.insert("Pinsrb_xmm_r64m8_imm8", Code::Pinsrb_xmm_r64m8_imm8);
		let _ = h.insert("VEX_Vpinsrb_xmm_xmm_r32m8_imm8", Code::VEX_Vpinsrb_xmm_xmm_r32m8_imm8);
		let _ = h.insert("VEX_Vpinsrb_xmm_xmm_r64m8_imm8", Code::VEX_Vpinsrb_xmm_xmm_r64m8_imm8);
		let _ = h.insert("EVEX_Vpinsrb_xmm_xmm_r32m8_imm8", Code::EVEX_Vpinsrb_xmm_xmm_r32m8_imm8);
		let _ = h.insert("EVEX_Vpinsrb_xmm_xmm_r64m8_imm8", Code::EVEX_Vpinsrb_xmm_xmm_r64m8_imm8);
		let _ = h.insert("Insertps_xmm_xmmm32_imm8", Code::Insertps_xmm_xmmm32_imm8);
		let _ = h.insert("VEX_Vinsertps_xmm_xmm_xmmm32_imm8", Code::VEX_Vinsertps_xmm_xmm_xmmm32_imm8);
		let _ = h.insert("EVEX_Vinsertps_xmm_xmm_xmmm32_imm8", Code::EVEX_Vinsertps_xmm_xmm_xmmm32_imm8);
		let _ = h.insert("Pinsrd_xmm_rm32_imm8", Code::Pinsrd_xmm_rm32_imm8);
		let _ = h.insert("Pinsrq_xmm_rm64_imm8", Code::Pinsrq_xmm_rm64_imm8);
		let _ = h.insert("VEX_Vpinsrd_xmm_xmm_rm32_imm8", Code::VEX_Vpinsrd_xmm_xmm_rm32_imm8);
		let _ = h.insert("VEX_Vpinsrq_xmm_xmm_rm64_imm8", Code::VEX_Vpinsrq_xmm_xmm_rm64_imm8);
		let _ = h.insert("EVEX_Vpinsrd_xmm_xmm_rm32_imm8", Code::EVEX_Vpinsrd_xmm_xmm_rm32_imm8);
		let _ = h.insert("EVEX_Vpinsrq_xmm_xmm_rm64_imm8", Code::EVEX_Vpinsrq_xmm_xmm_rm64_imm8);
		let _ = h.insert("EVEX_Vshuff32x4_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vshuff32x4_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vshuff32x4_zmm_k1z_zmm_zmmm512b32_imm8", Code::EVEX_Vshuff32x4_zmm_k1z_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vshuff64x2_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vshuff64x2_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vshuff64x2_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vshuff64x2_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("EVEX_Vpternlogd_xmm_k1z_xmm_xmmm128b32_imm8", Code::EVEX_Vpternlogd_xmm_k1z_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpternlogd_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vpternlogd_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpternlogd_zmm_k1z_zmm_zmmm512b32_imm8", Code::EVEX_Vpternlogd_zmm_k1z_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vpternlogq_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vpternlogq_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpternlogq_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vpternlogq_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpternlogq_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vpternlogq_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("EVEX_Vgetmantps_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vgetmantps_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vgetmantps_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vgetmantps_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vgetmantps_zmm_k1z_zmmm512b32_imm8_sae", Code::EVEX_Vgetmantps_zmm_k1z_zmmm512b32_imm8_sae);
		let _ = h.insert("EVEX_Vgetmantpd_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vgetmantpd_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vgetmantpd_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vgetmantpd_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vgetmantpd_zmm_k1z_zmmm512b64_imm8_sae", Code::EVEX_Vgetmantpd_zmm_k1z_zmmm512b64_imm8_sae);
		let _ = h.insert("EVEX_Vgetmantss_xmm_k1z_xmm_xmmm32_imm8_sae", Code::EVEX_Vgetmantss_xmm_k1z_xmm_xmmm32_imm8_sae);
		let _ = h.insert("EVEX_Vgetmantsd_xmm_k1z_xmm_xmmm64_imm8_sae", Code::EVEX_Vgetmantsd_xmm_k1z_xmm_xmmm64_imm8_sae);
		let _ = h.insert("VEX_Kshiftrb_kr_kr_imm8", Code::VEX_Kshiftrb_kr_kr_imm8);
		let _ = h.insert("VEX_Kshiftrw_kr_kr_imm8", Code::VEX_Kshiftrw_kr_kr_imm8);
		let _ = h.insert("VEX_Kshiftrd_kr_kr_imm8", Code::VEX_Kshiftrd_kr_kr_imm8);
		let _ = h.insert("VEX_Kshiftrq_kr_kr_imm8", Code::VEX_Kshiftrq_kr_kr_imm8);
		let _ = h.insert("VEX_Kshiftlb_kr_kr_imm8", Code::VEX_Kshiftlb_kr_kr_imm8);
		let _ = h.insert("VEX_Kshiftlw_kr_kr_imm8", Code::VEX_Kshiftlw_kr_kr_imm8);
		let _ = h.insert("VEX_Kshiftld_kr_kr_imm8", Code::VEX_Kshiftld_kr_kr_imm8);
		let _ = h.insert("VEX_Kshiftlq_kr_kr_imm8", Code::VEX_Kshiftlq_kr_kr_imm8);
		let _ = h.insert("VEX_Vinserti128_ymm_ymm_xmmm128_imm8", Code::VEX_Vinserti128_ymm_ymm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinserti32x4_ymm_k1z_ymm_xmmm128_imm8", Code::EVEX_Vinserti32x4_ymm_k1z_ymm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinserti32x4_zmm_k1z_zmm_xmmm128_imm8", Code::EVEX_Vinserti32x4_zmm_k1z_zmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinserti64x2_ymm_k1z_ymm_xmmm128_imm8", Code::EVEX_Vinserti64x2_ymm_k1z_ymm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vinserti64x2_zmm_k1z_zmm_xmmm128_imm8", Code::EVEX_Vinserti64x2_zmm_k1z_zmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vextracti128_xmmm128_ymm_imm8", Code::VEX_Vextracti128_xmmm128_ymm_imm8);
		let _ = h.insert("EVEX_Vextracti32x4_xmmm128_k1z_ymm_imm8", Code::EVEX_Vextracti32x4_xmmm128_k1z_ymm_imm8);
		let _ = h.insert("EVEX_Vextracti32x4_xmmm128_k1z_zmm_imm8", Code::EVEX_Vextracti32x4_xmmm128_k1z_zmm_imm8);
		let _ = h.insert("EVEX_Vextracti64x2_xmmm128_k1z_ymm_imm8", Code::EVEX_Vextracti64x2_xmmm128_k1z_ymm_imm8);
		let _ = h.insert("EVEX_Vextracti64x2_xmmm128_k1z_zmm_imm8", Code::EVEX_Vextracti64x2_xmmm128_k1z_zmm_imm8);
		let _ = h.insert("EVEX_Vinserti32x8_zmm_k1z_zmm_ymmm256_imm8", Code::EVEX_Vinserti32x8_zmm_k1z_zmm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vinserti64x4_zmm_k1z_zmm_ymmm256_imm8", Code::EVEX_Vinserti64x4_zmm_k1z_zmm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vextracti32x8_ymmm256_k1z_zmm_imm8", Code::EVEX_Vextracti32x8_ymmm256_k1z_zmm_imm8);
		let _ = h.insert("EVEX_Vextracti64x4_ymmm256_k1z_zmm_imm8", Code::EVEX_Vextracti64x4_ymmm256_k1z_zmm_imm8);
		let _ = h.insert("EVEX_Vpcmpub_kr_k1_xmm_xmmm128_imm8", Code::EVEX_Vpcmpub_kr_k1_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpcmpub_kr_k1_ymm_ymmm256_imm8", Code::EVEX_Vpcmpub_kr_k1_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpcmpub_kr_k1_zmm_zmmm512_imm8", Code::EVEX_Vpcmpub_kr_k1_zmm_zmmm512_imm8);
		let _ = h.insert("EVEX_Vpcmpuw_kr_k1_xmm_xmmm128_imm8", Code::EVEX_Vpcmpuw_kr_k1_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpcmpuw_kr_k1_ymm_ymmm256_imm8", Code::EVEX_Vpcmpuw_kr_k1_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpcmpuw_kr_k1_zmm_zmmm512_imm8", Code::EVEX_Vpcmpuw_kr_k1_zmm_zmmm512_imm8);
		let _ = h.insert("EVEX_Vpcmpb_kr_k1_xmm_xmmm128_imm8", Code::EVEX_Vpcmpb_kr_k1_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpcmpb_kr_k1_ymm_ymmm256_imm8", Code::EVEX_Vpcmpb_kr_k1_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpcmpb_kr_k1_zmm_zmmm512_imm8", Code::EVEX_Vpcmpb_kr_k1_zmm_zmmm512_imm8);
		let _ = h.insert("EVEX_Vpcmpw_kr_k1_xmm_xmmm128_imm8", Code::EVEX_Vpcmpw_kr_k1_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpcmpw_kr_k1_ymm_ymmm256_imm8", Code::EVEX_Vpcmpw_kr_k1_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpcmpw_kr_k1_zmm_zmmm512_imm8", Code::EVEX_Vpcmpw_kr_k1_zmm_zmmm512_imm8);
		let _ = h.insert("Dpps_xmm_xmmm128_imm8", Code::Dpps_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vdpps_xmm_xmm_xmmm128_imm8", Code::VEX_Vdpps_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vdpps_ymm_ymm_ymmm256_imm8", Code::VEX_Vdpps_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("Dppd_xmm_xmmm128_imm8", Code::Dppd_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vdppd_xmm_xmm_xmmm128_imm8", Code::VEX_Vdppd_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("Mpsadbw_xmm_xmmm128_imm8", Code::Mpsadbw_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vmpsadbw_xmm_xmm_xmmm128_imm8", Code::VEX_Vmpsadbw_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vmpsadbw_ymm_ymm_ymmm256_imm8", Code::VEX_Vmpsadbw_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vdbpsadbw_xmm_k1z_xmm_xmmm128_imm8", Code::EVEX_Vdbpsadbw_xmm_k1z_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vdbpsadbw_ymm_k1z_ymm_ymmm256_imm8", Code::EVEX_Vdbpsadbw_ymm_k1z_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vdbpsadbw_zmm_k1z_zmm_zmmm512_imm8", Code::EVEX_Vdbpsadbw_zmm_k1z_zmm_zmmm512_imm8);
		let _ = h.insert("EVEX_Vshufi32x4_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vshufi32x4_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vshufi32x4_zmm_k1z_zmm_zmmm512b32_imm8", Code::EVEX_Vshufi32x4_zmm_k1z_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vshufi64x2_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vshufi64x2_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vshufi64x2_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vshufi64x2_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("Pclmulqdq_xmm_xmmm128_imm8", Code::Pclmulqdq_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8", Code::VEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8", Code::VEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8", Code::EVEX_Vpclmulqdq_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8", Code::EVEX_Vpclmulqdq_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpclmulqdq_zmm_zmm_zmmm512_imm8", Code::EVEX_Vpclmulqdq_zmm_zmm_zmmm512_imm8);
		let _ = h.insert("VEX_Vperm2i128_ymm_ymm_ymmm256_imm8", Code::VEX_Vperm2i128_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("VEX_Vpermil2ps_xmm_xmm_xmmm128_xmm_imm4", Code::VEX_Vpermil2ps_xmm_xmm_xmmm128_xmm_imm4);
		let _ = h.insert("VEX_Vpermil2ps_ymm_ymm_ymmm256_ymm_imm4", Code::VEX_Vpermil2ps_ymm_ymm_ymmm256_ymm_imm4);
		let _ = h.insert("VEX_Vpermil2ps_xmm_xmm_xmm_xmmm128_imm4", Code::VEX_Vpermil2ps_xmm_xmm_xmm_xmmm128_imm4);
		let _ = h.insert("VEX_Vpermil2ps_ymm_ymm_ymm_ymmm256_imm4", Code::VEX_Vpermil2ps_ymm_ymm_ymm_ymmm256_imm4);
		let _ = h.insert("VEX_Vpermil2pd_xmm_xmm_xmmm128_xmm_imm4", Code::VEX_Vpermil2pd_xmm_xmm_xmmm128_xmm_imm4);
		let _ = h.insert("VEX_Vpermil2pd_ymm_ymm_ymmm256_ymm_imm4", Code::VEX_Vpermil2pd_ymm_ymm_ymmm256_ymm_imm4);
		let _ = h.insert("VEX_Vpermil2pd_xmm_xmm_xmm_xmmm128_imm4", Code::VEX_Vpermil2pd_xmm_xmm_xmm_xmmm128_imm4);
		let _ = h.insert("VEX_Vpermil2pd_ymm_ymm_ymm_ymmm256_imm4", Code::VEX_Vpermil2pd_ymm_ymm_ymm_ymmm256_imm4);
		let _ = h.insert("VEX_Vblendvps_xmm_xmm_xmmm128_xmm", Code::VEX_Vblendvps_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vblendvps_ymm_ymm_ymmm256_ymm", Code::VEX_Vblendvps_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vblendvpd_xmm_xmm_xmmm128_xmm", Code::VEX_Vblendvpd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vblendvpd_ymm_ymm_ymmm256_ymm", Code::VEX_Vblendvpd_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vpblendvb_xmm_xmm_xmmm128_xmm", Code::VEX_Vpblendvb_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vpblendvb_ymm_ymm_ymmm256_ymm", Code::VEX_Vpblendvb_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("EVEX_Vrangeps_xmm_k1z_xmm_xmmm128b32_imm8", Code::EVEX_Vrangeps_xmm_k1z_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vrangeps_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vrangeps_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vrangeps_zmm_k1z_zmm_zmmm512b32_imm8_sae", Code::EVEX_Vrangeps_zmm_k1z_zmm_zmmm512b32_imm8_sae);
		let _ = h.insert("EVEX_Vrangepd_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vrangepd_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vrangepd_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vrangepd_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vrangepd_zmm_k1z_zmm_zmmm512b64_imm8_sae", Code::EVEX_Vrangepd_zmm_k1z_zmm_zmmm512b64_imm8_sae);
		let _ = h.insert("EVEX_Vrangess_xmm_k1z_xmm_xmmm32_imm8_sae", Code::EVEX_Vrangess_xmm_k1z_xmm_xmmm32_imm8_sae);
		let _ = h.insert("EVEX_Vrangesd_xmm_k1z_xmm_xmmm64_imm8_sae", Code::EVEX_Vrangesd_xmm_k1z_xmm_xmmm64_imm8_sae);
		let _ = h.insert("EVEX_Vfixupimmps_xmm_k1z_xmm_xmmm128b32_imm8", Code::EVEX_Vfixupimmps_xmm_k1z_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vfixupimmps_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vfixupimmps_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vfixupimmps_zmm_k1z_zmm_zmmm512b32_imm8_sae", Code::EVEX_Vfixupimmps_zmm_k1z_zmm_zmmm512b32_imm8_sae);
		let _ = h.insert("EVEX_Vfixupimmpd_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vfixupimmpd_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vfixupimmpd_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vfixupimmpd_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vfixupimmpd_zmm_k1z_zmm_zmmm512b64_imm8_sae", Code::EVEX_Vfixupimmpd_zmm_k1z_zmm_zmmm512b64_imm8_sae);
		let _ = h.insert("EVEX_Vfixupimmss_xmm_k1z_xmm_xmmm32_imm8_sae", Code::EVEX_Vfixupimmss_xmm_k1z_xmm_xmmm32_imm8_sae);
		let _ = h.insert("EVEX_Vfixupimmsd_xmm_k1z_xmm_xmmm64_imm8_sae", Code::EVEX_Vfixupimmsd_xmm_k1z_xmm_xmmm64_imm8_sae);
		let _ = h.insert("EVEX_Vreduceps_xmm_k1z_xmmm128b32_imm8", Code::EVEX_Vreduceps_xmm_k1z_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vreduceps_ymm_k1z_ymmm256b32_imm8", Code::EVEX_Vreduceps_ymm_k1z_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vreduceps_zmm_k1z_zmmm512b32_imm8_sae", Code::EVEX_Vreduceps_zmm_k1z_zmmm512b32_imm8_sae);
		let _ = h.insert("EVEX_Vreducepd_xmm_k1z_xmmm128b64_imm8", Code::EVEX_Vreducepd_xmm_k1z_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vreducepd_ymm_k1z_ymmm256b64_imm8", Code::EVEX_Vreducepd_ymm_k1z_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vreducepd_zmm_k1z_zmmm512b64_imm8_sae", Code::EVEX_Vreducepd_zmm_k1z_zmmm512b64_imm8_sae);
		let _ = h.insert("EVEX_Vreducess_xmm_k1z_xmm_xmmm32_imm8_sae", Code::EVEX_Vreducess_xmm_k1z_xmm_xmmm32_imm8_sae);
		let _ = h.insert("EVEX_Vreducesd_xmm_k1z_xmm_xmmm64_imm8_sae", Code::EVEX_Vreducesd_xmm_k1z_xmm_xmmm64_imm8_sae);
		let _ = h.insert("VEX_Vfmaddsubps_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmaddsubps_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmaddsubps_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmaddsubps_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmaddsubps_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmaddsubps_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsubps_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmaddsubps_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmaddsubpd_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmaddsubpd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmaddsubpd_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmaddsubpd_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmaddsubpd_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmaddsubpd_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddsubpd_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmaddsubpd_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsubaddps_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmsubaddps_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmsubaddps_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmsubaddps_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmsubaddps_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmsubaddps_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubaddps_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmsubaddps_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsubaddpd_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmsubaddpd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmsubaddpd_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmsubaddpd_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmsubaddpd_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmsubaddpd_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubaddpd_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmsubaddpd_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("Pcmpestrm_xmm_xmmm128_imm8", Code::Pcmpestrm_xmm_xmmm128_imm8);
		let _ = h.insert("Pcmpestrm64_xmm_xmmm128_imm8", Code::Pcmpestrm64_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpcmpestrm_xmm_xmmm128_imm8", Code::VEX_Vpcmpestrm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpcmpestrm64_xmm_xmmm128_imm8", Code::VEX_Vpcmpestrm64_xmm_xmmm128_imm8);
		let _ = h.insert("Pcmpestri_xmm_xmmm128_imm8", Code::Pcmpestri_xmm_xmmm128_imm8);
		let _ = h.insert("Pcmpestri64_xmm_xmmm128_imm8", Code::Pcmpestri64_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpcmpestri_xmm_xmmm128_imm8", Code::VEX_Vpcmpestri_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpcmpestri64_xmm_xmmm128_imm8", Code::VEX_Vpcmpestri64_xmm_xmmm128_imm8);
		let _ = h.insert("Pcmpistrm_xmm_xmmm128_imm8", Code::Pcmpistrm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpcmpistrm_xmm_xmmm128_imm8", Code::VEX_Vpcmpistrm_xmm_xmmm128_imm8);
		let _ = h.insert("Pcmpistri_xmm_xmmm128_imm8", Code::Pcmpistri_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vpcmpistri_xmm_xmmm128_imm8", Code::VEX_Vpcmpistri_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vfpclassps_kr_k1_xmmm128b32_imm8", Code::EVEX_Vfpclassps_kr_k1_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vfpclassps_kr_k1_ymmm256b32_imm8", Code::EVEX_Vfpclassps_kr_k1_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vfpclassps_kr_k1_zmmm512b32_imm8", Code::EVEX_Vfpclassps_kr_k1_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vfpclasspd_kr_k1_xmmm128b64_imm8", Code::EVEX_Vfpclasspd_kr_k1_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vfpclasspd_kr_k1_ymmm256b64_imm8", Code::EVEX_Vfpclasspd_kr_k1_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vfpclasspd_kr_k1_zmmm512b64_imm8", Code::EVEX_Vfpclasspd_kr_k1_zmmm512b64_imm8);
		let _ = h.insert("EVEX_Vfpclassss_kr_k1_xmmm32_imm8", Code::EVEX_Vfpclassss_kr_k1_xmmm32_imm8);
		let _ = h.insert("EVEX_Vfpclasssd_kr_k1_xmmm64_imm8", Code::EVEX_Vfpclasssd_kr_k1_xmmm64_imm8);
		let _ = h.insert("VEX_Vfmaddps_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmaddps_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmaddps_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmaddps_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmaddps_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmaddps_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddps_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmaddps_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmaddpd_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmaddpd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmaddpd_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmaddpd_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmaddpd_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmaddpd_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmaddpd_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmaddpd_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmaddss_xmm_xmm_xmmm32_xmm", Code::VEX_Vfmaddss_xmm_xmm_xmmm32_xmm);
		let _ = h.insert("VEX_Vfmaddss_xmm_xmm_xmm_xmmm32", Code::VEX_Vfmaddss_xmm_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmaddsd_xmm_xmm_xmmm64_xmm", Code::VEX_Vfmaddsd_xmm_xmm_xmmm64_xmm);
		let _ = h.insert("VEX_Vfmaddsd_xmm_xmm_xmm_xmmm64", Code::VEX_Vfmaddsd_xmm_xmm_xmm_xmmm64);
		let _ = h.insert("VEX_Vfmsubps_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmsubps_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmsubps_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmsubps_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmsubps_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmsubps_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubps_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmsubps_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsubpd_xmm_xmm_xmmm128_xmm", Code::VEX_Vfmsubpd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfmsubpd_ymm_ymm_ymmm256_ymm", Code::VEX_Vfmsubpd_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfmsubpd_xmm_xmm_xmm_xmmm128", Code::VEX_Vfmsubpd_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfmsubpd_ymm_ymm_ymm_ymmm256", Code::VEX_Vfmsubpd_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfmsubss_xmm_xmm_xmmm32_xmm", Code::VEX_Vfmsubss_xmm_xmm_xmmm32_xmm);
		let _ = h.insert("VEX_Vfmsubss_xmm_xmm_xmm_xmmm32", Code::VEX_Vfmsubss_xmm_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfmsubsd_xmm_xmm_xmmm64_xmm", Code::VEX_Vfmsubsd_xmm_xmm_xmmm64_xmm);
		let _ = h.insert("VEX_Vfmsubsd_xmm_xmm_xmm_xmmm64", Code::VEX_Vfmsubsd_xmm_xmm_xmm_xmmm64);
		let _ = h.insert("EVEX_Vpshldw_xmm_k1z_xmm_xmmm128_imm8", Code::EVEX_Vpshldw_xmm_k1z_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpshldw_ymm_k1z_ymm_ymmm256_imm8", Code::EVEX_Vpshldw_ymm_k1z_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpshldw_zmm_k1z_zmm_zmmm512_imm8", Code::EVEX_Vpshldw_zmm_k1z_zmm_zmmm512_imm8);
		let _ = h.insert("EVEX_Vpshldd_xmm_k1z_xmm_xmmm128b32_imm8", Code::EVEX_Vpshldd_xmm_k1z_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpshldd_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vpshldd_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpshldd_zmm_k1z_zmm_zmmm512b32_imm8", Code::EVEX_Vpshldd_zmm_k1z_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vpshldq_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vpshldq_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpshldq_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vpshldq_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpshldq_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vpshldq_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("EVEX_Vpshrdw_xmm_k1z_xmm_xmmm128_imm8", Code::EVEX_Vpshrdw_xmm_k1z_xmm_xmmm128_imm8);
		let _ = h.insert("EVEX_Vpshrdw_ymm_k1z_ymm_ymmm256_imm8", Code::EVEX_Vpshrdw_ymm_k1z_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vpshrdw_zmm_k1z_zmm_zmmm512_imm8", Code::EVEX_Vpshrdw_zmm_k1z_zmm_zmmm512_imm8);
		let _ = h.insert("EVEX_Vpshrdd_xmm_k1z_xmm_xmmm128b32_imm8", Code::EVEX_Vpshrdd_xmm_k1z_xmm_xmmm128b32_imm8);
		let _ = h.insert("EVEX_Vpshrdd_ymm_k1z_ymm_ymmm256b32_imm8", Code::EVEX_Vpshrdd_ymm_k1z_ymm_ymmm256b32_imm8);
		let _ = h.insert("EVEX_Vpshrdd_zmm_k1z_zmm_zmmm512b32_imm8", Code::EVEX_Vpshrdd_zmm_k1z_zmm_zmmm512b32_imm8);
		let _ = h.insert("EVEX_Vpshrdq_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vpshrdq_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vpshrdq_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vpshrdq_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vpshrdq_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vpshrdq_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("VEX_Vfnmaddps_xmm_xmm_xmmm128_xmm", Code::VEX_Vfnmaddps_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfnmaddps_ymm_ymm_ymmm256_ymm", Code::VEX_Vfnmaddps_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfnmaddps_xmm_xmm_xmm_xmmm128", Code::VEX_Vfnmaddps_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmaddps_ymm_ymm_ymm_ymmm256", Code::VEX_Vfnmaddps_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmaddpd_xmm_xmm_xmmm128_xmm", Code::VEX_Vfnmaddpd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfnmaddpd_ymm_ymm_ymmm256_ymm", Code::VEX_Vfnmaddpd_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfnmaddpd_xmm_xmm_xmm_xmmm128", Code::VEX_Vfnmaddpd_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmaddpd_ymm_ymm_ymm_ymmm256", Code::VEX_Vfnmaddpd_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmaddss_xmm_xmm_xmmm32_xmm", Code::VEX_Vfnmaddss_xmm_xmm_xmmm32_xmm);
		let _ = h.insert("VEX_Vfnmaddss_xmm_xmm_xmm_xmmm32", Code::VEX_Vfnmaddss_xmm_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmaddsd_xmm_xmm_xmmm64_xmm", Code::VEX_Vfnmaddsd_xmm_xmm_xmmm64_xmm);
		let _ = h.insert("VEX_Vfnmaddsd_xmm_xmm_xmm_xmmm64", Code::VEX_Vfnmaddsd_xmm_xmm_xmm_xmmm64);
		let _ = h.insert("VEX_Vfnmsubps_xmm_xmm_xmmm128_xmm", Code::VEX_Vfnmsubps_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfnmsubps_ymm_ymm_ymmm256_ymm", Code::VEX_Vfnmsubps_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfnmsubps_xmm_xmm_xmm_xmmm128", Code::VEX_Vfnmsubps_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsubps_ymm_ymm_ymm_ymmm256", Code::VEX_Vfnmsubps_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmsubpd_xmm_xmm_xmmm128_xmm", Code::VEX_Vfnmsubpd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("VEX_Vfnmsubpd_ymm_ymm_ymmm256_ymm", Code::VEX_Vfnmsubpd_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("VEX_Vfnmsubpd_xmm_xmm_xmm_xmmm128", Code::VEX_Vfnmsubpd_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vfnmsubpd_ymm_ymm_ymm_ymmm256", Code::VEX_Vfnmsubpd_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vfnmsubss_xmm_xmm_xmmm32_xmm", Code::VEX_Vfnmsubss_xmm_xmm_xmmm32_xmm);
		let _ = h.insert("VEX_Vfnmsubss_xmm_xmm_xmm_xmmm32", Code::VEX_Vfnmsubss_xmm_xmm_xmm_xmmm32);
		let _ = h.insert("VEX_Vfnmsubsd_xmm_xmm_xmmm64_xmm", Code::VEX_Vfnmsubsd_xmm_xmm_xmmm64_xmm);
		let _ = h.insert("VEX_Vfnmsubsd_xmm_xmm_xmm_xmmm64", Code::VEX_Vfnmsubsd_xmm_xmm_xmm_xmmm64);
		let _ = h.insert("Sha1rnds4_xmm_xmmm128_imm8", Code::Sha1rnds4_xmm_xmmm128_imm8);
		let _ = h.insert("Gf2p8affineqb_xmm_xmmm128_imm8", Code::Gf2p8affineqb_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vgf2p8affineqb_xmm_xmm_xmmm128_imm8", Code::VEX_Vgf2p8affineqb_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vgf2p8affineqb_ymm_ymm_ymmm256_imm8", Code::VEX_Vgf2p8affineqb_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vgf2p8affineqb_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vgf2p8affineqb_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vgf2p8affineqb_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vgf2p8affineqb_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vgf2p8affineqb_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vgf2p8affineqb_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("Gf2p8affineinvqb_xmm_xmmm128_imm8", Code::Gf2p8affineinvqb_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vgf2p8affineinvqb_xmm_xmm_xmmm128_imm8", Code::VEX_Vgf2p8affineinvqb_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vgf2p8affineinvqb_ymm_ymm_ymmm256_imm8", Code::VEX_Vgf2p8affineinvqb_ymm_ymm_ymmm256_imm8);
		let _ = h.insert("EVEX_Vgf2p8affineinvqb_xmm_k1z_xmm_xmmm128b64_imm8", Code::EVEX_Vgf2p8affineinvqb_xmm_k1z_xmm_xmmm128b64_imm8);
		let _ = h.insert("EVEX_Vgf2p8affineinvqb_ymm_k1z_ymm_ymmm256b64_imm8", Code::EVEX_Vgf2p8affineinvqb_ymm_k1z_ymm_ymmm256b64_imm8);
		let _ = h.insert("EVEX_Vgf2p8affineinvqb_zmm_k1z_zmm_zmmm512b64_imm8", Code::EVEX_Vgf2p8affineinvqb_zmm_k1z_zmm_zmmm512b64_imm8);
		let _ = h.insert("Aeskeygenassist_xmm_xmmm128_imm8", Code::Aeskeygenassist_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Vaeskeygenassist_xmm_xmmm128_imm8", Code::VEX_Vaeskeygenassist_xmm_xmmm128_imm8);
		let _ = h.insert("VEX_Rorx_r32_rm32_imm8", Code::VEX_Rorx_r32_rm32_imm8);
		let _ = h.insert("VEX_Rorx_r64_rm64_imm8", Code::VEX_Rorx_r64_rm64_imm8);
		let _ = h.insert("XOP_Vpmacssww_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacssww_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacsswd_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacsswd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacssdql_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacssdql_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacssdd_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacssdd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacssdqh_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacssdqh_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacsww_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacsww_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacswd_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacswd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacsdql_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacsdql_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacsdd_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacsdd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmacsdqh_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmacsdqh_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpcmov_xmm_xmm_xmmm128_xmm", Code::XOP_Vpcmov_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpcmov_ymm_ymm_ymmm256_ymm", Code::XOP_Vpcmov_ymm_ymm_ymmm256_ymm);
		let _ = h.insert("XOP_Vpcmov_xmm_xmm_xmm_xmmm128", Code::XOP_Vpcmov_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpcmov_ymm_ymm_ymm_ymmm256", Code::XOP_Vpcmov_ymm_ymm_ymm_ymmm256);
		let _ = h.insert("XOP_Vpperm_xmm_xmm_xmmm128_xmm", Code::XOP_Vpperm_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpperm_xmm_xmm_xmm_xmmm128", Code::XOP_Vpperm_xmm_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpmadcsswd_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmadcsswd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpmadcswd_xmm_xmm_xmmm128_xmm", Code::XOP_Vpmadcswd_xmm_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vprotb_xmm_xmmm128_imm8", Code::XOP_Vprotb_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vprotw_xmm_xmmm128_imm8", Code::XOP_Vprotw_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vprotd_xmm_xmmm128_imm8", Code::XOP_Vprotd_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vprotq_xmm_xmmm128_imm8", Code::XOP_Vprotq_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomb_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomb_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomw_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomw_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomd_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomd_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomq_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomq_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomub_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomub_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomuw_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomuw_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomud_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomud_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Vpcomuq_xmm_xmm_xmmm128_imm8", Code::XOP_Vpcomuq_xmm_xmm_xmmm128_imm8);
		let _ = h.insert("XOP_Blcfill_r32_rm32", Code::XOP_Blcfill_r32_rm32);
		let _ = h.insert("XOP_Blcfill_r64_rm64", Code::XOP_Blcfill_r64_rm64);
		let _ = h.insert("XOP_Blsfill_r32_rm32", Code::XOP_Blsfill_r32_rm32);
		let _ = h.insert("XOP_Blsfill_r64_rm64", Code::XOP_Blsfill_r64_rm64);
		let _ = h.insert("XOP_Blcs_r32_rm32", Code::XOP_Blcs_r32_rm32);
		let _ = h.insert("XOP_Blcs_r64_rm64", Code::XOP_Blcs_r64_rm64);
		let _ = h.insert("XOP_Tzmsk_r32_rm32", Code::XOP_Tzmsk_r32_rm32);
		let _ = h.insert("XOP_Tzmsk_r64_rm64", Code::XOP_Tzmsk_r64_rm64);
		let _ = h.insert("XOP_Blcic_r32_rm32", Code::XOP_Blcic_r32_rm32);
		let _ = h.insert("XOP_Blcic_r64_rm64", Code::XOP_Blcic_r64_rm64);
		let _ = h.insert("XOP_Blsic_r32_rm32", Code::XOP_Blsic_r32_rm32);
		let _ = h.insert("XOP_Blsic_r64_rm64", Code::XOP_Blsic_r64_rm64);
		let _ = h.insert("XOP_T1mskc_r32_rm32", Code::XOP_T1mskc_r32_rm32);
		let _ = h.insert("XOP_T1mskc_r64_rm64", Code::XOP_T1mskc_r64_rm64);
		let _ = h.insert("XOP_Blcmsk_r32_rm32", Code::XOP_Blcmsk_r32_rm32);
		let _ = h.insert("XOP_Blcmsk_r64_rm64", Code::XOP_Blcmsk_r64_rm64);
		let _ = h.insert("XOP_Blci_r32_rm32", Code::XOP_Blci_r32_rm32);
		let _ = h.insert("XOP_Blci_r64_rm64", Code::XOP_Blci_r64_rm64);
		let _ = h.insert("XOP_Llwpcb_r32", Code::XOP_Llwpcb_r32);
		let _ = h.insert("XOP_Llwpcb_r64", Code::XOP_Llwpcb_r64);
		let _ = h.insert("XOP_Slwpcb_r32", Code::XOP_Slwpcb_r32);
		let _ = h.insert("XOP_Slwpcb_r64", Code::XOP_Slwpcb_r64);
		let _ = h.insert("XOP_Vfrczps_xmm_xmmm128", Code::XOP_Vfrczps_xmm_xmmm128);
		let _ = h.insert("XOP_Vfrczps_ymm_ymmm256", Code::XOP_Vfrczps_ymm_ymmm256);
		let _ = h.insert("XOP_Vfrczpd_xmm_xmmm128", Code::XOP_Vfrczpd_xmm_xmmm128);
		let _ = h.insert("XOP_Vfrczpd_ymm_ymmm256", Code::XOP_Vfrczpd_ymm_ymmm256);
		let _ = h.insert("XOP_Vfrczss_xmm_xmmm32", Code::XOP_Vfrczss_xmm_xmmm32);
		let _ = h.insert("XOP_Vfrczsd_xmm_xmmm64", Code::XOP_Vfrczsd_xmm_xmmm64);
		let _ = h.insert("XOP_Vprotb_xmm_xmmm128_xmm", Code::XOP_Vprotb_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vprotb_xmm_xmm_xmmm128", Code::XOP_Vprotb_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vprotw_xmm_xmmm128_xmm", Code::XOP_Vprotw_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vprotw_xmm_xmm_xmmm128", Code::XOP_Vprotw_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vprotd_xmm_xmmm128_xmm", Code::XOP_Vprotd_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vprotd_xmm_xmm_xmmm128", Code::XOP_Vprotd_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vprotq_xmm_xmmm128_xmm", Code::XOP_Vprotq_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vprotq_xmm_xmm_xmmm128", Code::XOP_Vprotq_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshlb_xmm_xmmm128_xmm", Code::XOP_Vpshlb_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshlb_xmm_xmm_xmmm128", Code::XOP_Vpshlb_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshlw_xmm_xmmm128_xmm", Code::XOP_Vpshlw_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshlw_xmm_xmm_xmmm128", Code::XOP_Vpshlw_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshld_xmm_xmmm128_xmm", Code::XOP_Vpshld_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshld_xmm_xmm_xmmm128", Code::XOP_Vpshld_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshlq_xmm_xmmm128_xmm", Code::XOP_Vpshlq_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshlq_xmm_xmm_xmmm128", Code::XOP_Vpshlq_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshab_xmm_xmmm128_xmm", Code::XOP_Vpshab_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshab_xmm_xmm_xmmm128", Code::XOP_Vpshab_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshaw_xmm_xmmm128_xmm", Code::XOP_Vpshaw_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshaw_xmm_xmm_xmmm128", Code::XOP_Vpshaw_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshad_xmm_xmmm128_xmm", Code::XOP_Vpshad_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshad_xmm_xmm_xmmm128", Code::XOP_Vpshad_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vpshaq_xmm_xmmm128_xmm", Code::XOP_Vpshaq_xmm_xmmm128_xmm);
		let _ = h.insert("XOP_Vpshaq_xmm_xmm_xmmm128", Code::XOP_Vpshaq_xmm_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddbw_xmm_xmmm128", Code::XOP_Vphaddbw_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddbd_xmm_xmmm128", Code::XOP_Vphaddbd_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddbq_xmm_xmmm128", Code::XOP_Vphaddbq_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddwd_xmm_xmmm128", Code::XOP_Vphaddwd_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddwq_xmm_xmmm128", Code::XOP_Vphaddwq_xmm_xmmm128);
		let _ = h.insert("XOP_Vphadddq_xmm_xmmm128", Code::XOP_Vphadddq_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddubw_xmm_xmmm128", Code::XOP_Vphaddubw_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddubd_xmm_xmmm128", Code::XOP_Vphaddubd_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddubq_xmm_xmmm128", Code::XOP_Vphaddubq_xmm_xmmm128);
		let _ = h.insert("XOP_Vphadduwd_xmm_xmmm128", Code::XOP_Vphadduwd_xmm_xmmm128);
		let _ = h.insert("XOP_Vphadduwq_xmm_xmmm128", Code::XOP_Vphadduwq_xmm_xmmm128);
		let _ = h.insert("XOP_Vphaddudq_xmm_xmmm128", Code::XOP_Vphaddudq_xmm_xmmm128);
		let _ = h.insert("XOP_Vphsubbw_xmm_xmmm128", Code::XOP_Vphsubbw_xmm_xmmm128);
		let _ = h.insert("XOP_Vphsubwd_xmm_xmmm128", Code::XOP_Vphsubwd_xmm_xmmm128);
		let _ = h.insert("XOP_Vphsubdq_xmm_xmmm128", Code::XOP_Vphsubdq_xmm_xmmm128);
		let _ = h.insert("XOP_Bextr_r32_rm32_imm32", Code::XOP_Bextr_r32_rm32_imm32);
		let _ = h.insert("XOP_Bextr_r64_rm64_imm32", Code::XOP_Bextr_r64_rm64_imm32);
		let _ = h.insert("XOP_Lwpins_r32_rm32_imm32", Code::XOP_Lwpins_r32_rm32_imm32);
		let _ = h.insert("XOP_Lwpins_r64_rm32_imm32", Code::XOP_Lwpins_r64_rm32_imm32);
		let _ = h.insert("XOP_Lwpval_r32_rm32_imm32", Code::XOP_Lwpval_r32_rm32_imm32);
		let _ = h.insert("XOP_Lwpval_r64_rm32_imm32", Code::XOP_Lwpval_r64_rm32_imm32);
		let _ = h.insert("D3NOW_Pi2fw_mm_mmm64", Code::D3NOW_Pi2fw_mm_mmm64);
		let _ = h.insert("D3NOW_Pi2fd_mm_mmm64", Code::D3NOW_Pi2fd_mm_mmm64);
		let _ = h.insert("D3NOW_Pf2iw_mm_mmm64", Code::D3NOW_Pf2iw_mm_mmm64);
		let _ = h.insert("D3NOW_Pf2id_mm_mmm64", Code::D3NOW_Pf2id_mm_mmm64);
		let _ = h.insert("D3NOW_Pfrcpv_mm_mmm64", Code::D3NOW_Pfrcpv_mm_mmm64);
		let _ = h.insert("D3NOW_Pfrsqrtv_mm_mmm64", Code::D3NOW_Pfrsqrtv_mm_mmm64);
		let _ = h.insert("D3NOW_Pfnacc_mm_mmm64", Code::D3NOW_Pfnacc_mm_mmm64);
		let _ = h.insert("D3NOW_Pfpnacc_mm_mmm64", Code::D3NOW_Pfpnacc_mm_mmm64);
		let _ = h.insert("D3NOW_Pfcmpge_mm_mmm64", Code::D3NOW_Pfcmpge_mm_mmm64);
		let _ = h.insert("D3NOW_Pfmin_mm_mmm64", Code::D3NOW_Pfmin_mm_mmm64);
		let _ = h.insert("D3NOW_Pfrcp_mm_mmm64", Code::D3NOW_Pfrcp_mm_mmm64);
		let _ = h.insert("D3NOW_Pfrsqrt_mm_mmm64", Code::D3NOW_Pfrsqrt_mm_mmm64);
		let _ = h.insert("D3NOW_Pfsub_mm_mmm64", Code::D3NOW_Pfsub_mm_mmm64);
		let _ = h.insert("D3NOW_Pfadd_mm_mmm64", Code::D3NOW_Pfadd_mm_mmm64);
		let _ = h.insert("D3NOW_Pfcmpgt_mm_mmm64", Code::D3NOW_Pfcmpgt_mm_mmm64);
		let _ = h.insert("D3NOW_Pfmax_mm_mmm64", Code::D3NOW_Pfmax_mm_mmm64);
		let _ = h.insert("D3NOW_Pfrcpit1_mm_mmm64", Code::D3NOW_Pfrcpit1_mm_mmm64);
		let _ = h.insert("D3NOW_Pfrsqit1_mm_mmm64", Code::D3NOW_Pfrsqit1_mm_mmm64);
		let _ = h.insert("D3NOW_Pfsubr_mm_mmm64", Code::D3NOW_Pfsubr_mm_mmm64);
		let _ = h.insert("D3NOW_Pfacc_mm_mmm64", Code::D3NOW_Pfacc_mm_mmm64);
		let _ = h.insert("D3NOW_Pfcmpeq_mm_mmm64", Code::D3NOW_Pfcmpeq_mm_mmm64);
		let _ = h.insert("D3NOW_Pfmul_mm_mmm64", Code::D3NOW_Pfmul_mm_mmm64);
		let _ = h.insert("D3NOW_Pfrcpit2_mm_mmm64", Code::D3NOW_Pfrcpit2_mm_mmm64);
		let _ = h.insert("D3NOW_Pmulhrw_mm_mmm64", Code::D3NOW_Pmulhrw_mm_mmm64);
		let _ = h.insert("D3NOW_Pswapd_mm_mmm64", Code::D3NOW_Pswapd_mm_mmm64);
		let _ = h.insert("D3NOW_Pavgusb_mm_mmm64", Code::D3NOW_Pavgusb_mm_mmm64);
		let _ = h.insert("Rmpadjust", Code::Rmpadjust);
		let _ = h.insert("Rmpupdate", Code::Rmpupdate);
		let _ = h.insert("Psmash", Code::Psmash);
		let _ = h.insert("Pvalidatew", Code::Pvalidatew);
		let _ = h.insert("Pvalidated", Code::Pvalidated);
		let _ = h.insert("Pvalidateq", Code::Pvalidateq);
		let _ = h.insert("Serialize", Code::Serialize);
		let _ = h.insert("Xsusldtrk", Code::Xsusldtrk);
		let _ = h.insert("Xresldtrk", Code::Xresldtrk);
		let _ = h.insert("Invlpgbw", Code::Invlpgbw);
		let _ = h.insert("Invlpgbd", Code::Invlpgbd);
		let _ = h.insert("Invlpgbq", Code::Invlpgbq);
		let _ = h.insert("Tlbsync", Code::Tlbsync);
		let _ = h.insert("Prefetchreserved3_m8", Code::Prefetchreserved3_m8);
		let _ = h.insert("Prefetchreserved4_m8", Code::Prefetchreserved4_m8);
		let _ = h.insert("Prefetchreserved5_m8", Code::Prefetchreserved5_m8);
		let _ = h.insert("Prefetchreserved6_m8", Code::Prefetchreserved6_m8);
		let _ = h.insert("Prefetchreserved7_m8", Code::Prefetchreserved7_m8);
		let _ = h.insert("Ud0", Code::Ud0);
		let _ = h.insert("Vmgexit", Code::Vmgexit);
		let _ = h.insert("Getsecq", Code::Getsecq);
		let _ = h.insert("VEX_Ldtilecfg_m512", Code::VEX_Ldtilecfg_m512);
		let _ = h.insert("VEX_Tilerelease", Code::VEX_Tilerelease);
		let _ = h.insert("VEX_Sttilecfg_m512", Code::VEX_Sttilecfg_m512);
		let _ = h.insert("VEX_Tilezero_tmm", Code::VEX_Tilezero_tmm);
		let _ = h.insert("VEX_Tileloaddt1_tmm_sibmem", Code::VEX_Tileloaddt1_tmm_sibmem);
		let _ = h.insert("VEX_Tilestored_sibmem_tmm", Code::VEX_Tilestored_sibmem_tmm);
		let _ = h.insert("VEX_Tileloadd_tmm_sibmem", Code::VEX_Tileloadd_tmm_sibmem);
		let _ = h.insert("VEX_Tdpbf16ps_tmm_tmm_tmm", Code::VEX_Tdpbf16ps_tmm_tmm_tmm);
		let _ = h.insert("VEX_Tdpbuud_tmm_tmm_tmm", Code::VEX_Tdpbuud_tmm_tmm_tmm);
		let _ = h.insert("VEX_Tdpbusd_tmm_tmm_tmm", Code::VEX_Tdpbusd_tmm_tmm_tmm);
		let _ = h.insert("VEX_Tdpbsud_tmm_tmm_tmm", Code::VEX_Tdpbsud_tmm_tmm_tmm);
		let _ = h.insert("VEX_Tdpbssd_tmm_tmm_tmm", Code::VEX_Tdpbssd_tmm_tmm_tmm);
		let _ = h.insert("Fnstdw_AX", Code::Fnstdw_AX);
		let _ = h.insert("Fnstsg_AX", Code::Fnstsg_AX);
		let _ = h.insert("Rdshr_rm32", Code::Rdshr_rm32);
		let _ = h.insert("Wrshr_rm32", Code::Wrshr_rm32);
		let _ = h.insert("Smint", Code::Smint);
		let _ = h.insert("Dmint", Code::Dmint);
		let _ = h.insert("Rdm", Code::Rdm);
		let _ = h.insert("Svdc_m80_Sreg", Code::Svdc_m80_Sreg);
		let _ = h.insert("Rsdc_Sreg_m80", Code::Rsdc_Sreg_m80);
		let _ = h.insert("Svldt_m80", Code::Svldt_m80);
		let _ = h.insert("Rsldt_m80", Code::Rsldt_m80);
		let _ = h.insert("Svts_m80", Code::Svts_m80);
		let _ = h.insert("Rsts_m80", Code::Rsts_m80);
		let _ = h.insert("Smint_0F7E", Code::Smint_0F7E);
		let _ = h.insert("Bb0_reset", Code::Bb0_reset);
		let _ = h.insert("Bb1_reset", Code::Bb1_reset);
		let _ = h.insert("Cpu_write", Code::Cpu_write);
		let _ = h.insert("Cpu_read", Code::Cpu_read);
		let _ = h.insert("Altinst", Code::Altinst);
		let _ = h.insert("Paveb_mm_mmm64", Code::Paveb_mm_mmm64);
		let _ = h.insert("Paddsiw_mm_mmm64", Code::Paddsiw_mm_mmm64);
		let _ = h.insert("Pmagw_mm_mmm64", Code::Pmagw_mm_mmm64);
		let _ = h.insert("Pdistib_mm_m64", Code::Pdistib_mm_m64);
		let _ = h.insert("Psubsiw_mm_mmm64", Code::Psubsiw_mm_mmm64);
		let _ = h.insert("Pmvzb_mm_m64", Code::Pmvzb_mm_m64);
		let _ = h.insert("Pmulhrw_mm_mmm64", Code::Pmulhrw_mm_mmm64);
		let _ = h.insert("Pmvnzb_mm_m64", Code::Pmvnzb_mm_m64);
		let _ = h.insert("Pmvlzb_mm_m64", Code::Pmvlzb_mm_m64);
		let _ = h.insert("Pmvgezb_mm_m64", Code::Pmvgezb_mm_m64);
		let _ = h.insert("Pmulhriw_mm_mmm64", Code::Pmulhriw_mm_mmm64);
		let _ = h.insert("Pmachriw_mm_m64", Code::Pmachriw_mm_m64);
		let _ = h.insert("Cyrix_D9D7", Code::Cyrix_D9D7);
		let _ = h.insert("Cyrix_D9E2", Code::Cyrix_D9E2);
		let _ = h.insert("Ftstp", Code::Ftstp);
		let _ = h.insert("Cyrix_D9E7", Code::Cyrix_D9E7);
		let _ = h.insert("Frint2", Code::Frint2);
		let _ = h.insert("Frichop", Code::Frichop);
		let _ = h.insert("Cyrix_DED8", Code::Cyrix_DED8);
		let _ = h.insert("Cyrix_DEDA", Code::Cyrix_DEDA);
		let _ = h.insert("Cyrix_DEDC", Code::Cyrix_DEDC);
		let _ = h.insert("Cyrix_DEDD", Code::Cyrix_DEDD);
		let _ = h.insert("Cyrix_DEDE", Code::Cyrix_DEDE);
		let _ = h.insert("Frinear", Code::Frinear);
		let _ = h.insert("Tdcall", Code::Tdcall);
		let _ = h.insert("Seamret", Code::Seamret);
		let _ = h.insert("Seamops", Code::Seamops);
		let _ = h.insert("Seamcall", Code::Seamcall);
		let _ = h.insert("Aesencwide128kl_m384", Code::Aesencwide128kl_m384);
		let _ = h.insert("Aesdecwide128kl_m384", Code::Aesdecwide128kl_m384);
		let _ = h.insert("Aesencwide256kl_m512", Code::Aesencwide256kl_m512);
		let _ = h.insert("Aesdecwide256kl_m512", Code::Aesdecwide256kl_m512);
		let _ = h.insert("Loadiwkey_xmm_xmm", Code::Loadiwkey_xmm_xmm);
		let _ = h.insert("Aesenc128kl_xmm_m384", Code::Aesenc128kl_xmm_m384);
		let _ = h.insert("Aesdec128kl_xmm_m384", Code::Aesdec128kl_xmm_m384);
		let _ = h.insert("Aesenc256kl_xmm_m512", Code::Aesenc256kl_xmm_m512);
		let _ = h.insert("Aesdec256kl_xmm_m512", Code::Aesdec256kl_xmm_m512);
		let _ = h.insert("Encodekey128_r32_r32", Code::Encodekey128_r32_r32);
		let _ = h.insert("Encodekey256_r32_r32", Code::Encodekey256_r32_r32);
		let _ = h.insert("VEX_Vbroadcastss_xmm_xmm", Code::VEX_Vbroadcastss_xmm_xmm);
		let _ = h.insert("VEX_Vbroadcastss_ymm_xmm", Code::VEX_Vbroadcastss_ymm_xmm);
		let _ = h.insert("VEX_Vbroadcastsd_ymm_xmm", Code::VEX_Vbroadcastsd_ymm_xmm);
		let _ = h.insert("Vmgexit_F2", Code::Vmgexit_F2);
		let _ = h.insert("Uiret", Code::Uiret);
		let _ = h.insert("Testui", Code::Testui);
		let _ = h.insert("Clui", Code::Clui);
		let _ = h.insert("Stui", Code::Stui);
		let _ = h.insert("Senduipi_r64", Code::Senduipi_r64);
		let _ = h.insert("Hreset_imm8", Code::Hreset_imm8);
		let _ = h.insert("VEX_Vpdpbusd_xmm_xmm_xmmm128", Code::VEX_Vpdpbusd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpdpbusd_ymm_ymm_ymmm256", Code::VEX_Vpdpbusd_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vpdpbusds_xmm_xmm_xmmm128", Code::VEX_Vpdpbusds_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpdpbusds_ymm_ymm_ymmm256", Code::VEX_Vpdpbusds_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vpdpwssd_xmm_xmm_xmmm128", Code::VEX_Vpdpwssd_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpdpwssd_ymm_ymm_ymmm256", Code::VEX_Vpdpwssd_ymm_ymm_ymmm256);
		let _ = h.insert("VEX_Vpdpwssds_xmm_xmm_xmmm128", Code::VEX_Vpdpwssds_xmm_xmm_xmmm128);
		let _ = h.insert("VEX_Vpdpwssds_ymm_ymm_ymmm256", Code::VEX_Vpdpwssds_ymm_ymm_ymmm256);
		let _ = h.insert("Ccs_hash_16", Code::Ccs_hash_16);
		let _ = h.insert("Ccs_hash_32", Code::Ccs_hash_32);
		let _ = h.insert("Ccs_hash_64", Code::Ccs_hash_64);
		let _ = h.insert("Ccs_encrypt_16", Code::Ccs_encrypt_16);
		let _ = h.insert("Ccs_encrypt_32", Code::Ccs_encrypt_32);
		let _ = h.insert("Ccs_encrypt_64", Code::Ccs_encrypt_64);
		let _ = h.insert("Lkgs_rm16", Code::Lkgs_rm16);
		let _ = h.insert("Lkgs_r32m16", Code::Lkgs_r32m16);
		let _ = h.insert("Lkgs_r64m16", Code::Lkgs_r64m16);
		let _ = h.insert("Eretu", Code::Eretu);
		let _ = h.insert("Erets", Code::Erets);
		// GENERATOR-END: CodeHash
		h
	};
}
