// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use crate::iced_constants::IcedConstants;
use crate::iced_error::IcedError;
use core::convert::TryFrom;
use core::iter::{ExactSizeIterator, FusedIterator, Iterator};
use core::{fmt, mem};

// GENERATOR-BEGIN: Mnemonic
// ⚠️This was generated by GENERATOR!🦹‍♂️
/// Mnemonic
#[derive(Copy, Clone, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[cfg_attr(not(feature = "exhaustive_enums"), non_exhaustive)]
#[allow(non_camel_case_types)]
#[allow(missing_docs)]
pub enum Mnemonic {
	INVALID = 0,
	Aaa = 1,
	Aad = 2,
	Aam = 3,
	Aas = 4,
	Adc = 5,
	Adcx = 6,
	Add = 7,
	Addpd = 8,
	Addps = 9,
	Addsd = 10,
	Addss = 11,
	Addsubpd = 12,
	Addsubps = 13,
	Adox = 14,
	Aesdec = 15,
	Aesdeclast = 16,
	Aesenc = 17,
	Aesenclast = 18,
	Aesimc = 19,
	Aeskeygenassist = 20,
	And = 21,
	Andn = 22,
	Andnpd = 23,
	Andnps = 24,
	Andpd = 25,
	Andps = 26,
	Arpl = 27,
	Bextr = 28,
	Blcfill = 29,
	Blci = 30,
	Blcic = 31,
	Blcmsk = 32,
	Blcs = 33,
	Blendpd = 34,
	Blendps = 35,
	Blendvpd = 36,
	Blendvps = 37,
	Blsfill = 38,
	Blsi = 39,
	Blsic = 40,
	Blsmsk = 41,
	Blsr = 42,
	Bndcl = 43,
	Bndcn = 44,
	Bndcu = 45,
	Bndldx = 46,
	Bndmk = 47,
	Bndmov = 48,
	Bndstx = 49,
	Bound = 50,
	Bsf = 51,
	Bsr = 52,
	Bswap = 53,
	Bt = 54,
	Btc = 55,
	Btr = 56,
	Bts = 57,
	Bzhi = 58,
	Call = 59,
	Cbw = 60,
	Cdq = 61,
	Cdqe = 62,
	Cl1invmb = 63,
	Clac = 64,
	Clc = 65,
	Cld = 66,
	Cldemote = 67,
	Clflush = 68,
	Clflushopt = 69,
	Clgi = 70,
	Cli = 71,
	Clrssbsy = 72,
	Clts = 73,
	Clwb = 74,
	Clzero = 75,
	Cmc = 76,
	Cmova = 77,
	Cmovae = 78,
	Cmovb = 79,
	Cmovbe = 80,
	Cmove = 81,
	Cmovg = 82,
	Cmovge = 83,
	Cmovl = 84,
	Cmovle = 85,
	Cmovne = 86,
	Cmovno = 87,
	Cmovnp = 88,
	Cmovns = 89,
	Cmovo = 90,
	Cmovp = 91,
	Cmovs = 92,
	Cmp = 93,
	Cmppd = 94,
	Cmpps = 95,
	Cmpsb = 96,
	Cmpsd = 97,
	Cmpsq = 98,
	Cmpss = 99,
	Cmpsw = 100,
	Cmpxchg = 101,
	Cmpxchg16b = 102,
	Cmpxchg8b = 103,
	Comisd = 104,
	Comiss = 105,
	Cpuid = 106,
	Cqo = 107,
	Crc32 = 108,
	Cvtdq2pd = 109,
	Cvtdq2ps = 110,
	Cvtpd2dq = 111,
	Cvtpd2pi = 112,
	Cvtpd2ps = 113,
	Cvtpi2pd = 114,
	Cvtpi2ps = 115,
	Cvtps2dq = 116,
	Cvtps2pd = 117,
	Cvtps2pi = 118,
	Cvtsd2si = 119,
	Cvtsd2ss = 120,
	Cvtsi2sd = 121,
	Cvtsi2ss = 122,
	Cvtss2sd = 123,
	Cvtss2si = 124,
	Cvttpd2dq = 125,
	Cvttpd2pi = 126,
	Cvttps2dq = 127,
	Cvttps2pi = 128,
	Cvttsd2si = 129,
	Cvttss2si = 130,
	Cwd = 131,
	Cwde = 132,
	Daa = 133,
	Das = 134,
	Db = 135,
	Dd = 136,
	Dec = 137,
	Div = 138,
	Divpd = 139,
	Divps = 140,
	Divsd = 141,
	Divss = 142,
	Dppd = 143,
	Dpps = 144,
	Dq = 145,
	Dw = 146,
	Emms = 147,
	Encls = 148,
	Enclu = 149,
	Enclv = 150,
	Endbr32 = 151,
	Endbr64 = 152,
	Enqcmd = 153,
	Enqcmds = 154,
	Enter = 155,
	Extractps = 156,
	Extrq = 157,
	F2xm1 = 158,
	Fabs = 159,
	Fadd = 160,
	Faddp = 161,
	Fbld = 162,
	Fbstp = 163,
	Fchs = 164,
	Fclex = 165,
	Fcmovb = 166,
	Fcmovbe = 167,
	Fcmove = 168,
	Fcmovnb = 169,
	Fcmovnbe = 170,
	Fcmovne = 171,
	Fcmovnu = 172,
	Fcmovu = 173,
	Fcom = 174,
	Fcomi = 175,
	Fcomip = 176,
	Fcomp = 177,
	Fcompp = 178,
	Fcos = 179,
	Fdecstp = 180,
	Fdisi = 181,
	Fdiv = 182,
	Fdivp = 183,
	Fdivr = 184,
	Fdivrp = 185,
	Femms = 186,
	Feni = 187,
	Ffree = 188,
	Ffreep = 189,
	Fiadd = 190,
	Ficom = 191,
	Ficomp = 192,
	Fidiv = 193,
	Fidivr = 194,
	Fild = 195,
	Fimul = 196,
	Fincstp = 197,
	Finit = 198,
	Fist = 199,
	Fistp = 200,
	Fisttp = 201,
	Fisub = 202,
	Fisubr = 203,
	Fld = 204,
	Fld1 = 205,
	Fldcw = 206,
	Fldenv = 207,
	Fldl2e = 208,
	Fldl2t = 209,
	Fldlg2 = 210,
	Fldln2 = 211,
	Fldpi = 212,
	Fldz = 213,
	Fmul = 214,
	Fmulp = 215,
	Fnclex = 216,
	Fndisi = 217,
	Fneni = 218,
	Fninit = 219,
	Fnop = 220,
	Fnsave = 221,
	Fnsetpm = 222,
	Fnstcw = 223,
	Fnstenv = 224,
	Fnstsw = 225,
	Fpatan = 226,
	Fprem = 227,
	Fprem1 = 228,
	Fptan = 229,
	Frndint = 230,
	Frstor = 231,
	Frstpm = 232,
	Fsave = 233,
	Fscale = 234,
	Fsetpm = 235,
	Fsin = 236,
	Fsincos = 237,
	Fsqrt = 238,
	Fst = 239,
	Fstcw = 240,
	Fstdw = 241,
	Fstenv = 242,
	Fstp = 243,
	Fstpnce = 244,
	Fstsg = 245,
	Fstsw = 246,
	Fsub = 247,
	Fsubp = 248,
	Fsubr = 249,
	Fsubrp = 250,
	Ftst = 251,
	Fucom = 252,
	Fucomi = 253,
	Fucomip = 254,
	Fucomp = 255,
	Fucompp = 256,
	Fxam = 257,
	Fxch = 258,
	Fxrstor = 259,
	Fxrstor64 = 260,
	Fxsave = 261,
	Fxsave64 = 262,
	Fxtract = 263,
	Fyl2x = 264,
	Fyl2xp1 = 265,
	Getsec = 266,
	Gf2p8affineinvqb = 267,
	Gf2p8affineqb = 268,
	Gf2p8mulb = 269,
	Haddpd = 270,
	Haddps = 271,
	Hlt = 272,
	Hsubpd = 273,
	Hsubps = 274,
	Ibts = 275,
	Idiv = 276,
	Imul = 277,
	In = 278,
	Inc = 279,
	Incsspd = 280,
	Incsspq = 281,
	Insb = 282,
	Insd = 283,
	Insertps = 284,
	Insertq = 285,
	Insw = 286,
	Int = 287,
	Int1 = 288,
	Into = 289,
	Invd = 290,
	Invept = 291,
	Invlpg = 292,
	Invlpga = 293,
	Invpcid = 294,
	Invvpid = 295,
	Iret = 296,
	Ja = 297,
	Jae = 298,
	Jb = 299,
	Jbe = 300,
	Jcxz = 301,
	Je = 302,
	Jecxz = 303,
	Jg = 304,
	Jge = 305,
	Jl = 306,
	Jle = 307,
	Jmp = 308,
	Jmpe = 309,
	Jne = 310,
	Jno = 311,
	Jnp = 312,
	Jns = 313,
	Jo = 314,
	Jp = 315,
	Jrcxz = 316,
	Js = 317,
	Kaddb = 318,
	Kaddd = 319,
	Kaddq = 320,
	Kaddw = 321,
	Kandb = 322,
	Kandd = 323,
	Kandnb = 324,
	Kandnd = 325,
	Kandnq = 326,
	Kandnw = 327,
	Kandq = 328,
	Kandw = 329,
	Kmovb = 330,
	Kmovd = 331,
	Kmovq = 332,
	Kmovw = 333,
	Knotb = 334,
	Knotd = 335,
	Knotq = 336,
	Knotw = 337,
	Korb = 338,
	Kord = 339,
	Korq = 340,
	Kortestb = 341,
	Kortestd = 342,
	Kortestq = 343,
	Kortestw = 344,
	Korw = 345,
	Kshiftlb = 346,
	Kshiftld = 347,
	Kshiftlq = 348,
	Kshiftlw = 349,
	Kshiftrb = 350,
	Kshiftrd = 351,
	Kshiftrq = 352,
	Kshiftrw = 353,
	Ktestb = 354,
	Ktestd = 355,
	Ktestq = 356,
	Ktestw = 357,
	Kunpckbw = 358,
	Kunpckdq = 359,
	Kunpckwd = 360,
	Kxnorb = 361,
	Kxnord = 362,
	Kxnorq = 363,
	Kxnorw = 364,
	Kxorb = 365,
	Kxord = 366,
	Kxorq = 367,
	Kxorw = 368,
	Lahf = 369,
	Lar = 370,
	Lddqu = 371,
	Ldmxcsr = 372,
	Lds = 373,
	Lea = 374,
	Leave = 375,
	Les = 376,
	Lfence = 377,
	Lfs = 378,
	Lgdt = 379,
	Lgs = 380,
	Lidt = 381,
	Lldt = 382,
	Llwpcb = 383,
	Lmsw = 384,
	Loadall = 385,
	Lodsb = 386,
	Lodsd = 387,
	Lodsq = 388,
	Lodsw = 389,
	Loop = 390,
	Loope = 391,
	Loopne = 392,
	Lsl = 393,
	Lss = 394,
	Ltr = 395,
	Lwpins = 396,
	Lwpval = 397,
	Lzcnt = 398,
	Maskmovdqu = 399,
	Maskmovq = 400,
	Maxpd = 401,
	Maxps = 402,
	Maxsd = 403,
	Maxss = 404,
	Mcommit = 405,
	Mfence = 406,
	Minpd = 407,
	Minps = 408,
	Minsd = 409,
	Minss = 410,
	Monitor = 411,
	Monitorx = 412,
	Montmul = 413,
	Mov = 414,
	Movapd = 415,
	Movaps = 416,
	Movbe = 417,
	Movd = 418,
	Movddup = 419,
	Movdir64b = 420,
	Movdiri = 421,
	Movdq2q = 422,
	Movdqa = 423,
	Movdqu = 424,
	Movhlps = 425,
	Movhpd = 426,
	Movhps = 427,
	Movlhps = 428,
	Movlpd = 429,
	Movlps = 430,
	Movmskpd = 431,
	Movmskps = 432,
	Movntdq = 433,
	Movntdqa = 434,
	Movnti = 435,
	Movntpd = 436,
	Movntps = 437,
	Movntq = 438,
	Movntsd = 439,
	Movntss = 440,
	Movq = 441,
	Movq2dq = 442,
	Movsb = 443,
	Movsd = 444,
	Movshdup = 445,
	Movsldup = 446,
	Movsq = 447,
	Movss = 448,
	Movsw = 449,
	Movsx = 450,
	Movsxd = 451,
	Movupd = 452,
	Movups = 453,
	Movzx = 454,
	Mpsadbw = 455,
	Mul = 456,
	Mulpd = 457,
	Mulps = 458,
	Mulsd = 459,
	Mulss = 460,
	Mulx = 461,
	Mwait = 462,
	Mwaitx = 463,
	Neg = 464,
	Nop = 465,
	Not = 466,
	Or = 467,
	Orpd = 468,
	Orps = 469,
	Out = 470,
	Outsb = 471,
	Outsd = 472,
	Outsw = 473,
	Pabsb = 474,
	Pabsd = 475,
	Pabsw = 476,
	Packssdw = 477,
	Packsswb = 478,
	Packusdw = 479,
	Packuswb = 480,
	Paddb = 481,
	Paddd = 482,
	Paddq = 483,
	Paddsb = 484,
	Paddsw = 485,
	Paddusb = 486,
	Paddusw = 487,
	Paddw = 488,
	Palignr = 489,
	Pand = 490,
	Pandn = 491,
	Pause = 492,
	Pavgb = 493,
	Pavgusb = 494,
	Pavgw = 495,
	Pblendvb = 496,
	Pblendw = 497,
	Pclmulqdq = 498,
	Pcmpeqb = 499,
	Pcmpeqd = 500,
	Pcmpeqq = 501,
	Pcmpeqw = 502,
	Pcmpestri = 503,
	Pcmpestri64 = 504,
	Pcmpestrm = 505,
	Pcmpestrm64 = 506,
	Pcmpgtb = 507,
	Pcmpgtd = 508,
	Pcmpgtq = 509,
	Pcmpgtw = 510,
	Pcmpistri = 511,
	Pcmpistrm = 512,
	Pcommit = 513,
	Pconfig = 514,
	Pdep = 515,
	Pext = 516,
	Pextrb = 517,
	Pextrd = 518,
	Pextrq = 519,
	Pextrw = 520,
	Pf2id = 521,
	Pf2iw = 522,
	Pfacc = 523,
	Pfadd = 524,
	Pfcmpeq = 525,
	Pfcmpge = 526,
	Pfcmpgt = 527,
	Pfmax = 528,
	Pfmin = 529,
	Pfmul = 530,
	Pfnacc = 531,
	Pfpnacc = 532,
	Pfrcp = 533,
	Pfrcpit1 = 534,
	Pfrcpit2 = 535,
	Pfrcpv = 536,
	Pfrsqit1 = 537,
	Pfrsqrt = 538,
	Pfrsqrtv = 539,
	Pfsub = 540,
	Pfsubr = 541,
	Phaddd = 542,
	Phaddsw = 543,
	Phaddw = 544,
	Phminposuw = 545,
	Phsubd = 546,
	Phsubsw = 547,
	Phsubw = 548,
	Pi2fd = 549,
	Pi2fw = 550,
	Pinsrb = 551,
	Pinsrd = 552,
	Pinsrq = 553,
	Pinsrw = 554,
	Pmaddubsw = 555,
	Pmaddwd = 556,
	Pmaxsb = 557,
	Pmaxsd = 558,
	Pmaxsw = 559,
	Pmaxub = 560,
	Pmaxud = 561,
	Pmaxuw = 562,
	Pminsb = 563,
	Pminsd = 564,
	Pminsw = 565,
	Pminub = 566,
	Pminud = 567,
	Pminuw = 568,
	Pmovmskb = 569,
	Pmovsxbd = 570,
	Pmovsxbq = 571,
	Pmovsxbw = 572,
	Pmovsxdq = 573,
	Pmovsxwd = 574,
	Pmovsxwq = 575,
	Pmovzxbd = 576,
	Pmovzxbq = 577,
	Pmovzxbw = 578,
	Pmovzxdq = 579,
	Pmovzxwd = 580,
	Pmovzxwq = 581,
	Pmuldq = 582,
	Pmulhrsw = 583,
	Pmulhrw = 584,
	Pmulhuw = 585,
	Pmulhw = 586,
	Pmulld = 587,
	Pmullw = 588,
	Pmuludq = 589,
	Pop = 590,
	Popa = 591,
	Popcnt = 592,
	Popf = 593,
	Por = 594,
	Prefetch = 595,
	Prefetchnta = 596,
	Prefetcht0 = 597,
	Prefetcht1 = 598,
	Prefetcht2 = 599,
	Prefetchw = 600,
	Prefetchwt1 = 601,
	Psadbw = 602,
	Pshufb = 603,
	Pshufd = 604,
	Pshufhw = 605,
	Pshuflw = 606,
	Pshufw = 607,
	Psignb = 608,
	Psignd = 609,
	Psignw = 610,
	Pslld = 611,
	Pslldq = 612,
	Psllq = 613,
	Psllw = 614,
	Psrad = 615,
	Psraw = 616,
	Psrld = 617,
	Psrldq = 618,
	Psrlq = 619,
	Psrlw = 620,
	Psubb = 621,
	Psubd = 622,
	Psubq = 623,
	Psubsb = 624,
	Psubsw = 625,
	Psubusb = 626,
	Psubusw = 627,
	Psubw = 628,
	Pswapd = 629,
	Ptest = 630,
	Ptwrite = 631,
	Punpckhbw = 632,
	Punpckhdq = 633,
	Punpckhqdq = 634,
	Punpckhwd = 635,
	Punpcklbw = 636,
	Punpckldq = 637,
	Punpcklqdq = 638,
	Punpcklwd = 639,
	Push = 640,
	Pusha = 641,
	Pushf = 642,
	Pxor = 643,
	Rcl = 644,
	Rcpps = 645,
	Rcpss = 646,
	Rcr = 647,
	Rdfsbase = 648,
	Rdgsbase = 649,
	Rdmsr = 650,
	Rdpid = 651,
	Rdpkru = 652,
	Rdpmc = 653,
	Rdpru = 654,
	Rdrand = 655,
	Rdseed = 656,
	Rdsspd = 657,
	Rdsspq = 658,
	Rdtsc = 659,
	Rdtscp = 660,
	Reservednop = 661,
	Ret = 662,
	Retf = 663,
	Rol = 664,
	Ror = 665,
	Rorx = 666,
	Roundpd = 667,
	Roundps = 668,
	Roundsd = 669,
	Roundss = 670,
	Rsm = 671,
	Rsqrtps = 672,
	Rsqrtss = 673,
	Rstorssp = 674,
	Sahf = 675,
	Sal = 676,
	Salc = 677,
	Sar = 678,
	Sarx = 679,
	Saveprevssp = 680,
	Sbb = 681,
	Scasb = 682,
	Scasd = 683,
	Scasq = 684,
	Scasw = 685,
	Seta = 686,
	Setae = 687,
	Setb = 688,
	Setbe = 689,
	Sete = 690,
	Setg = 691,
	Setge = 692,
	Setl = 693,
	Setle = 694,
	Setne = 695,
	Setno = 696,
	Setnp = 697,
	Setns = 698,
	Seto = 699,
	Setp = 700,
	Sets = 701,
	Setssbsy = 702,
	Sfence = 703,
	Sgdt = 704,
	Sha1msg1 = 705,
	Sha1msg2 = 706,
	Sha1nexte = 707,
	Sha1rnds4 = 708,
	Sha256msg1 = 709,
	Sha256msg2 = 710,
	Sha256rnds2 = 711,
	Shl = 712,
	Shld = 713,
	Shlx = 714,
	Shr = 715,
	Shrd = 716,
	Shrx = 717,
	Shufpd = 718,
	Shufps = 719,
	Sidt = 720,
	Skinit = 721,
	Sldt = 722,
	Slwpcb = 723,
	Smsw = 724,
	Sqrtpd = 725,
	Sqrtps = 726,
	Sqrtsd = 727,
	Sqrtss = 728,
	Stac = 729,
	Stc = 730,
	Std = 731,
	Stgi = 732,
	Sti = 733,
	Stmxcsr = 734,
	Stosb = 735,
	Stosd = 736,
	Stosq = 737,
	Stosw = 738,
	Str = 739,
	Sub = 740,
	Subpd = 741,
	Subps = 742,
	Subsd = 743,
	Subss = 744,
	Swapgs = 745,
	Syscall = 746,
	Sysenter = 747,
	Sysexit = 748,
	Sysret = 749,
	T1mskc = 750,
	Test = 751,
	Tpause = 752,
	Tzcnt = 753,
	Tzmsk = 754,
	Ucomisd = 755,
	Ucomiss = 756,
	Ud0 = 757,
	Ud1 = 758,
	Ud2 = 759,
	Umonitor = 760,
	Umov = 761,
	Umwait = 762,
	Unpckhpd = 763,
	Unpckhps = 764,
	Unpcklpd = 765,
	Unpcklps = 766,
	V4fmaddps = 767,
	V4fmaddss = 768,
	V4fnmaddps = 769,
	V4fnmaddss = 770,
	Vaddpd = 771,
	Vaddps = 772,
	Vaddsd = 773,
	Vaddss = 774,
	Vaddsubpd = 775,
	Vaddsubps = 776,
	Vaesdec = 777,
	Vaesdeclast = 778,
	Vaesenc = 779,
	Vaesenclast = 780,
	Vaesimc = 781,
	Vaeskeygenassist = 782,
	Valignd = 783,
	Valignq = 784,
	Vandnpd = 785,
	Vandnps = 786,
	Vandpd = 787,
	Vandps = 788,
	Vblendmpd = 789,
	Vblendmps = 790,
	Vblendpd = 791,
	Vblendps = 792,
	Vblendvpd = 793,
	Vblendvps = 794,
	Vbroadcastf128 = 795,
	Vbroadcastf32x2 = 796,
	Vbroadcastf32x4 = 797,
	Vbroadcastf32x8 = 798,
	Vbroadcastf64x2 = 799,
	Vbroadcastf64x4 = 800,
	Vbroadcasti128 = 801,
	Vbroadcasti32x2 = 802,
	Vbroadcasti32x4 = 803,
	Vbroadcasti32x8 = 804,
	Vbroadcasti64x2 = 805,
	Vbroadcasti64x4 = 806,
	Vbroadcastsd = 807,
	Vbroadcastss = 808,
	Vcmppd = 809,
	Vcmpps = 810,
	Vcmpsd = 811,
	Vcmpss = 812,
	Vcomisd = 813,
	Vcomiss = 814,
	Vcompresspd = 815,
	Vcompressps = 816,
	Vcvtdq2pd = 817,
	Vcvtdq2ps = 818,
	Vcvtne2ps2bf16 = 819,
	Vcvtneps2bf16 = 820,
	Vcvtpd2dq = 821,
	Vcvtpd2ps = 822,
	Vcvtpd2qq = 823,
	Vcvtpd2udq = 824,
	Vcvtpd2uqq = 825,
	Vcvtph2ps = 826,
	Vcvtps2dq = 827,
	Vcvtps2pd = 828,
	Vcvtps2ph = 829,
	Vcvtps2qq = 830,
	Vcvtps2udq = 831,
	Vcvtps2uqq = 832,
	Vcvtqq2pd = 833,
	Vcvtqq2ps = 834,
	Vcvtsd2si = 835,
	Vcvtsd2ss = 836,
	Vcvtsd2usi = 837,
	Vcvtsi2sd = 838,
	Vcvtsi2ss = 839,
	Vcvtss2sd = 840,
	Vcvtss2si = 841,
	Vcvtss2usi = 842,
	Vcvttpd2dq = 843,
	Vcvttpd2qq = 844,
	Vcvttpd2udq = 845,
	Vcvttpd2uqq = 846,
	Vcvttps2dq = 847,
	Vcvttps2qq = 848,
	Vcvttps2udq = 849,
	Vcvttps2uqq = 850,
	Vcvttsd2si = 851,
	Vcvttsd2usi = 852,
	Vcvttss2si = 853,
	Vcvttss2usi = 854,
	Vcvtudq2pd = 855,
	Vcvtudq2ps = 856,
	Vcvtuqq2pd = 857,
	Vcvtuqq2ps = 858,
	Vcvtusi2sd = 859,
	Vcvtusi2ss = 860,
	Vdbpsadbw = 861,
	Vdivpd = 862,
	Vdivps = 863,
	Vdivsd = 864,
	Vdivss = 865,
	Vdpbf16ps = 866,
	Vdppd = 867,
	Vdpps = 868,
	Verr = 869,
	Verw = 870,
	Vexp2pd = 871,
	Vexp2ps = 872,
	Vexpandpd = 873,
	Vexpandps = 874,
	Vextractf128 = 875,
	Vextractf32x4 = 876,
	Vextractf32x8 = 877,
	Vextractf64x2 = 878,
	Vextractf64x4 = 879,
	Vextracti128 = 880,
	Vextracti32x4 = 881,
	Vextracti32x8 = 882,
	Vextracti64x2 = 883,
	Vextracti64x4 = 884,
	Vextractps = 885,
	Vfixupimmpd = 886,
	Vfixupimmps = 887,
	Vfixupimmsd = 888,
	Vfixupimmss = 889,
	Vfmadd132pd = 890,
	Vfmadd132ps = 891,
	Vfmadd132sd = 892,
	Vfmadd132ss = 893,
	Vfmadd213pd = 894,
	Vfmadd213ps = 895,
	Vfmadd213sd = 896,
	Vfmadd213ss = 897,
	Vfmadd231pd = 898,
	Vfmadd231ps = 899,
	Vfmadd231sd = 900,
	Vfmadd231ss = 901,
	Vfmaddpd = 902,
	Vfmaddps = 903,
	Vfmaddsd = 904,
	Vfmaddss = 905,
	Vfmaddsub132pd = 906,
	Vfmaddsub132ps = 907,
	Vfmaddsub213pd = 908,
	Vfmaddsub213ps = 909,
	Vfmaddsub231pd = 910,
	Vfmaddsub231ps = 911,
	Vfmaddsubpd = 912,
	Vfmaddsubps = 913,
	Vfmsub132pd = 914,
	Vfmsub132ps = 915,
	Vfmsub132sd = 916,
	Vfmsub132ss = 917,
	Vfmsub213pd = 918,
	Vfmsub213ps = 919,
	Vfmsub213sd = 920,
	Vfmsub213ss = 921,
	Vfmsub231pd = 922,
	Vfmsub231ps = 923,
	Vfmsub231sd = 924,
	Vfmsub231ss = 925,
	Vfmsubadd132pd = 926,
	Vfmsubadd132ps = 927,
	Vfmsubadd213pd = 928,
	Vfmsubadd213ps = 929,
	Vfmsubadd231pd = 930,
	Vfmsubadd231ps = 931,
	Vfmsubaddpd = 932,
	Vfmsubaddps = 933,
	Vfmsubpd = 934,
	Vfmsubps = 935,
	Vfmsubsd = 936,
	Vfmsubss = 937,
	Vfnmadd132pd = 938,
	Vfnmadd132ps = 939,
	Vfnmadd132sd = 940,
	Vfnmadd132ss = 941,
	Vfnmadd213pd = 942,
	Vfnmadd213ps = 943,
	Vfnmadd213sd = 944,
	Vfnmadd213ss = 945,
	Vfnmadd231pd = 946,
	Vfnmadd231ps = 947,
	Vfnmadd231sd = 948,
	Vfnmadd231ss = 949,
	Vfnmaddpd = 950,
	Vfnmaddps = 951,
	Vfnmaddsd = 952,
	Vfnmaddss = 953,
	Vfnmsub132pd = 954,
	Vfnmsub132ps = 955,
	Vfnmsub132sd = 956,
	Vfnmsub132ss = 957,
	Vfnmsub213pd = 958,
	Vfnmsub213ps = 959,
	Vfnmsub213sd = 960,
	Vfnmsub213ss = 961,
	Vfnmsub231pd = 962,
	Vfnmsub231ps = 963,
	Vfnmsub231sd = 964,
	Vfnmsub231ss = 965,
	Vfnmsubpd = 966,
	Vfnmsubps = 967,
	Vfnmsubsd = 968,
	Vfnmsubss = 969,
	Vfpclasspd = 970,
	Vfpclassps = 971,
	Vfpclasssd = 972,
	Vfpclassss = 973,
	Vfrczpd = 974,
	Vfrczps = 975,
	Vfrczsd = 976,
	Vfrczss = 977,
	Vgatherdpd = 978,
	Vgatherdps = 979,
	Vgatherpf0dpd = 980,
	Vgatherpf0dps = 981,
	Vgatherpf0qpd = 982,
	Vgatherpf0qps = 983,
	Vgatherpf1dpd = 984,
	Vgatherpf1dps = 985,
	Vgatherpf1qpd = 986,
	Vgatherpf1qps = 987,
	Vgatherqpd = 988,
	Vgatherqps = 989,
	Vgetexppd = 990,
	Vgetexpps = 991,
	Vgetexpsd = 992,
	Vgetexpss = 993,
	Vgetmantpd = 994,
	Vgetmantps = 995,
	Vgetmantsd = 996,
	Vgetmantss = 997,
	Vgf2p8affineinvqb = 998,
	Vgf2p8affineqb = 999,
	Vgf2p8mulb = 1000,
	Vhaddpd = 1001,
	Vhaddps = 1002,
	Vhsubpd = 1003,
	Vhsubps = 1004,
	Vinsertf128 = 1005,
	Vinsertf32x4 = 1006,
	Vinsertf32x8 = 1007,
	Vinsertf64x2 = 1008,
	Vinsertf64x4 = 1009,
	Vinserti128 = 1010,
	Vinserti32x4 = 1011,
	Vinserti32x8 = 1012,
	Vinserti64x2 = 1013,
	Vinserti64x4 = 1014,
	Vinsertps = 1015,
	Vlddqu = 1016,
	Vldmxcsr = 1017,
	Vmaskmovdqu = 1018,
	Vmaskmovpd = 1019,
	Vmaskmovps = 1020,
	Vmaxpd = 1021,
	Vmaxps = 1022,
	Vmaxsd = 1023,
	Vmaxss = 1024,
	Vmcall = 1025,
	Vmclear = 1026,
	Vmfunc = 1027,
	Vminpd = 1028,
	Vminps = 1029,
	Vminsd = 1030,
	Vminss = 1031,
	Vmlaunch = 1032,
	Vmload = 1033,
	Vmmcall = 1034,
	Vmovapd = 1035,
	Vmovaps = 1036,
	Vmovd = 1037,
	Vmovddup = 1038,
	Vmovdqa = 1039,
	Vmovdqa32 = 1040,
	Vmovdqa64 = 1041,
	Vmovdqu = 1042,
	Vmovdqu16 = 1043,
	Vmovdqu32 = 1044,
	Vmovdqu64 = 1045,
	Vmovdqu8 = 1046,
	Vmovhlps = 1047,
	Vmovhpd = 1048,
	Vmovhps = 1049,
	Vmovlhps = 1050,
	Vmovlpd = 1051,
	Vmovlps = 1052,
	Vmovmskpd = 1053,
	Vmovmskps = 1054,
	Vmovntdq = 1055,
	Vmovntdqa = 1056,
	Vmovntpd = 1057,
	Vmovntps = 1058,
	Vmovq = 1059,
	Vmovsd = 1060,
	Vmovshdup = 1061,
	Vmovsldup = 1062,
	Vmovss = 1063,
	Vmovupd = 1064,
	Vmovups = 1065,
	Vmpsadbw = 1066,
	Vmptrld = 1067,
	Vmptrst = 1068,
	Vmread = 1069,
	Vmresume = 1070,
	Vmrun = 1071,
	Vmsave = 1072,
	Vmulpd = 1073,
	Vmulps = 1074,
	Vmulsd = 1075,
	Vmulss = 1076,
	Vmwrite = 1077,
	Vmxoff = 1078,
	Vmxon = 1079,
	Vorpd = 1080,
	Vorps = 1081,
	Vp2intersectd = 1082,
	Vp2intersectq = 1083,
	Vp4dpwssd = 1084,
	Vp4dpwssds = 1085,
	Vpabsb = 1086,
	Vpabsd = 1087,
	Vpabsq = 1088,
	Vpabsw = 1089,
	Vpackssdw = 1090,
	Vpacksswb = 1091,
	Vpackusdw = 1092,
	Vpackuswb = 1093,
	Vpaddb = 1094,
	Vpaddd = 1095,
	Vpaddq = 1096,
	Vpaddsb = 1097,
	Vpaddsw = 1098,
	Vpaddusb = 1099,
	Vpaddusw = 1100,
	Vpaddw = 1101,
	Vpalignr = 1102,
	Vpand = 1103,
	Vpandd = 1104,
	Vpandn = 1105,
	Vpandnd = 1106,
	Vpandnq = 1107,
	Vpandq = 1108,
	Vpavgb = 1109,
	Vpavgw = 1110,
	Vpblendd = 1111,
	Vpblendmb = 1112,
	Vpblendmd = 1113,
	Vpblendmq = 1114,
	Vpblendmw = 1115,
	Vpblendvb = 1116,
	Vpblendw = 1117,
	Vpbroadcastb = 1118,
	Vpbroadcastd = 1119,
	Vpbroadcastmb2q = 1120,
	Vpbroadcastmw2d = 1121,
	Vpbroadcastq = 1122,
	Vpbroadcastw = 1123,
	Vpclmulqdq = 1124,
	Vpcmov = 1125,
	Vpcmpb = 1126,
	Vpcmpd = 1127,
	Vpcmpeqb = 1128,
	Vpcmpeqd = 1129,
	Vpcmpeqq = 1130,
	Vpcmpeqw = 1131,
	Vpcmpestri = 1132,
	Vpcmpestri64 = 1133,
	Vpcmpestrm = 1134,
	Vpcmpestrm64 = 1135,
	Vpcmpgtb = 1136,
	Vpcmpgtd = 1137,
	Vpcmpgtq = 1138,
	Vpcmpgtw = 1139,
	Vpcmpistri = 1140,
	Vpcmpistrm = 1141,
	Vpcmpq = 1142,
	Vpcmpub = 1143,
	Vpcmpud = 1144,
	Vpcmpuq = 1145,
	Vpcmpuw = 1146,
	Vpcmpw = 1147,
	Vpcomb = 1148,
	Vpcomd = 1149,
	Vpcompressb = 1150,
	Vpcompressd = 1151,
	Vpcompressq = 1152,
	Vpcompressw = 1153,
	Vpcomq = 1154,
	Vpcomub = 1155,
	Vpcomud = 1156,
	Vpcomuq = 1157,
	Vpcomuw = 1158,
	Vpcomw = 1159,
	Vpconflictd = 1160,
	Vpconflictq = 1161,
	Vpdpbusd = 1162,
	Vpdpbusds = 1163,
	Vpdpwssd = 1164,
	Vpdpwssds = 1165,
	Vperm2f128 = 1166,
	Vperm2i128 = 1167,
	Vpermb = 1168,
	Vpermd = 1169,
	Vpermi2b = 1170,
	Vpermi2d = 1171,
	Vpermi2pd = 1172,
	Vpermi2ps = 1173,
	Vpermi2q = 1174,
	Vpermi2w = 1175,
	Vpermil2pd = 1176,
	Vpermil2ps = 1177,
	Vpermilpd = 1178,
	Vpermilps = 1179,
	Vpermpd = 1180,
	Vpermps = 1181,
	Vpermq = 1182,
	Vpermt2b = 1183,
	Vpermt2d = 1184,
	Vpermt2pd = 1185,
	Vpermt2ps = 1186,
	Vpermt2q = 1187,
	Vpermt2w = 1188,
	Vpermw = 1189,
	Vpexpandb = 1190,
	Vpexpandd = 1191,
	Vpexpandq = 1192,
	Vpexpandw = 1193,
	Vpextrb = 1194,
	Vpextrd = 1195,
	Vpextrq = 1196,
	Vpextrw = 1197,
	Vpgatherdd = 1198,
	Vpgatherdq = 1199,
	Vpgatherqd = 1200,
	Vpgatherqq = 1201,
	Vphaddbd = 1202,
	Vphaddbq = 1203,
	Vphaddbw = 1204,
	Vphaddd = 1205,
	Vphadddq = 1206,
	Vphaddsw = 1207,
	Vphaddubd = 1208,
	Vphaddubq = 1209,
	Vphaddubw = 1210,
	Vphaddudq = 1211,
	Vphadduwd = 1212,
	Vphadduwq = 1213,
	Vphaddw = 1214,
	Vphaddwd = 1215,
	Vphaddwq = 1216,
	Vphminposuw = 1217,
	Vphsubbw = 1218,
	Vphsubd = 1219,
	Vphsubdq = 1220,
	Vphsubsw = 1221,
	Vphsubw = 1222,
	Vphsubwd = 1223,
	Vpinsrb = 1224,
	Vpinsrd = 1225,
	Vpinsrq = 1226,
	Vpinsrw = 1227,
	Vplzcntd = 1228,
	Vplzcntq = 1229,
	Vpmacsdd = 1230,
	Vpmacsdqh = 1231,
	Vpmacsdql = 1232,
	Vpmacssdd = 1233,
	Vpmacssdqh = 1234,
	Vpmacssdql = 1235,
	Vpmacsswd = 1236,
	Vpmacssww = 1237,
	Vpmacswd = 1238,
	Vpmacsww = 1239,
	Vpmadcsswd = 1240,
	Vpmadcswd = 1241,
	Vpmadd52huq = 1242,
	Vpmadd52luq = 1243,
	Vpmaddubsw = 1244,
	Vpmaddwd = 1245,
	Vpmaskmovd = 1246,
	Vpmaskmovq = 1247,
	Vpmaxsb = 1248,
	Vpmaxsd = 1249,
	Vpmaxsq = 1250,
	Vpmaxsw = 1251,
	Vpmaxub = 1252,
	Vpmaxud = 1253,
	Vpmaxuq = 1254,
	Vpmaxuw = 1255,
	Vpminsb = 1256,
	Vpminsd = 1257,
	Vpminsq = 1258,
	Vpminsw = 1259,
	Vpminub = 1260,
	Vpminud = 1261,
	Vpminuq = 1262,
	Vpminuw = 1263,
	Vpmovb2m = 1264,
	Vpmovd2m = 1265,
	Vpmovdb = 1266,
	Vpmovdw = 1267,
	Vpmovm2b = 1268,
	Vpmovm2d = 1269,
	Vpmovm2q = 1270,
	Vpmovm2w = 1271,
	Vpmovmskb = 1272,
	Vpmovq2m = 1273,
	Vpmovqb = 1274,
	Vpmovqd = 1275,
	Vpmovqw = 1276,
	Vpmovsdb = 1277,
	Vpmovsdw = 1278,
	Vpmovsqb = 1279,
	Vpmovsqd = 1280,
	Vpmovsqw = 1281,
	Vpmovswb = 1282,
	Vpmovsxbd = 1283,
	Vpmovsxbq = 1284,
	Vpmovsxbw = 1285,
	Vpmovsxdq = 1286,
	Vpmovsxwd = 1287,
	Vpmovsxwq = 1288,
	Vpmovusdb = 1289,
	Vpmovusdw = 1290,
	Vpmovusqb = 1291,
	Vpmovusqd = 1292,
	Vpmovusqw = 1293,
	Vpmovuswb = 1294,
	Vpmovw2m = 1295,
	Vpmovwb = 1296,
	Vpmovzxbd = 1297,
	Vpmovzxbq = 1298,
	Vpmovzxbw = 1299,
	Vpmovzxdq = 1300,
	Vpmovzxwd = 1301,
	Vpmovzxwq = 1302,
	Vpmuldq = 1303,
	Vpmulhrsw = 1304,
	Vpmulhuw = 1305,
	Vpmulhw = 1306,
	Vpmulld = 1307,
	Vpmullq = 1308,
	Vpmullw = 1309,
	Vpmultishiftqb = 1310,
	Vpmuludq = 1311,
	Vpopcntb = 1312,
	Vpopcntd = 1313,
	Vpopcntq = 1314,
	Vpopcntw = 1315,
	Vpor = 1316,
	Vpord = 1317,
	Vporq = 1318,
	Vpperm = 1319,
	Vprold = 1320,
	Vprolq = 1321,
	Vprolvd = 1322,
	Vprolvq = 1323,
	Vprord = 1324,
	Vprorq = 1325,
	Vprorvd = 1326,
	Vprorvq = 1327,
	Vprotb = 1328,
	Vprotd = 1329,
	Vprotq = 1330,
	Vprotw = 1331,
	Vpsadbw = 1332,
	Vpscatterdd = 1333,
	Vpscatterdq = 1334,
	Vpscatterqd = 1335,
	Vpscatterqq = 1336,
	Vpshab = 1337,
	Vpshad = 1338,
	Vpshaq = 1339,
	Vpshaw = 1340,
	Vpshlb = 1341,
	Vpshld = 1342,
	Vpshldd = 1343,
	Vpshldq = 1344,
	Vpshldvd = 1345,
	Vpshldvq = 1346,
	Vpshldvw = 1347,
	Vpshldw = 1348,
	Vpshlq = 1349,
	Vpshlw = 1350,
	Vpshrdd = 1351,
	Vpshrdq = 1352,
	Vpshrdvd = 1353,
	Vpshrdvq = 1354,
	Vpshrdvw = 1355,
	Vpshrdw = 1356,
	Vpshufb = 1357,
	Vpshufbitqmb = 1358,
	Vpshufd = 1359,
	Vpshufhw = 1360,
	Vpshuflw = 1361,
	Vpsignb = 1362,
	Vpsignd = 1363,
	Vpsignw = 1364,
	Vpslld = 1365,
	Vpslldq = 1366,
	Vpsllq = 1367,
	Vpsllvd = 1368,
	Vpsllvq = 1369,
	Vpsllvw = 1370,
	Vpsllw = 1371,
	Vpsrad = 1372,
	Vpsraq = 1373,
	Vpsravd = 1374,
	Vpsravq = 1375,
	Vpsravw = 1376,
	Vpsraw = 1377,
	Vpsrld = 1378,
	Vpsrldq = 1379,
	Vpsrlq = 1380,
	Vpsrlvd = 1381,
	Vpsrlvq = 1382,
	Vpsrlvw = 1383,
	Vpsrlw = 1384,
	Vpsubb = 1385,
	Vpsubd = 1386,
	Vpsubq = 1387,
	Vpsubsb = 1388,
	Vpsubsw = 1389,
	Vpsubusb = 1390,
	Vpsubusw = 1391,
	Vpsubw = 1392,
	Vpternlogd = 1393,
	Vpternlogq = 1394,
	Vptest = 1395,
	Vptestmb = 1396,
	Vptestmd = 1397,
	Vptestmq = 1398,
	Vptestmw = 1399,
	Vptestnmb = 1400,
	Vptestnmd = 1401,
	Vptestnmq = 1402,
	Vptestnmw = 1403,
	Vpunpckhbw = 1404,
	Vpunpckhdq = 1405,
	Vpunpckhqdq = 1406,
	Vpunpckhwd = 1407,
	Vpunpcklbw = 1408,
	Vpunpckldq = 1409,
	Vpunpcklqdq = 1410,
	Vpunpcklwd = 1411,
	Vpxor = 1412,
	Vpxord = 1413,
	Vpxorq = 1414,
	Vrangepd = 1415,
	Vrangeps = 1416,
	Vrangesd = 1417,
	Vrangess = 1418,
	Vrcp14pd = 1419,
	Vrcp14ps = 1420,
	Vrcp14sd = 1421,
	Vrcp14ss = 1422,
	Vrcp28pd = 1423,
	Vrcp28ps = 1424,
	Vrcp28sd = 1425,
	Vrcp28ss = 1426,
	Vrcpps = 1427,
	Vrcpss = 1428,
	Vreducepd = 1429,
	Vreduceps = 1430,
	Vreducesd = 1431,
	Vreducess = 1432,
	Vrndscalepd = 1433,
	Vrndscaleps = 1434,
	Vrndscalesd = 1435,
	Vrndscaless = 1436,
	Vroundpd = 1437,
	Vroundps = 1438,
	Vroundsd = 1439,
	Vroundss = 1440,
	Vrsqrt14pd = 1441,
	Vrsqrt14ps = 1442,
	Vrsqrt14sd = 1443,
	Vrsqrt14ss = 1444,
	Vrsqrt28pd = 1445,
	Vrsqrt28ps = 1446,
	Vrsqrt28sd = 1447,
	Vrsqrt28ss = 1448,
	Vrsqrtps = 1449,
	Vrsqrtss = 1450,
	Vscalefpd = 1451,
	Vscalefps = 1452,
	Vscalefsd = 1453,
	Vscalefss = 1454,
	Vscatterdpd = 1455,
	Vscatterdps = 1456,
	Vscatterpf0dpd = 1457,
	Vscatterpf0dps = 1458,
	Vscatterpf0qpd = 1459,
	Vscatterpf0qps = 1460,
	Vscatterpf1dpd = 1461,
	Vscatterpf1dps = 1462,
	Vscatterpf1qpd = 1463,
	Vscatterpf1qps = 1464,
	Vscatterqpd = 1465,
	Vscatterqps = 1466,
	Vshuff32x4 = 1467,
	Vshuff64x2 = 1468,
	Vshufi32x4 = 1469,
	Vshufi64x2 = 1470,
	Vshufpd = 1471,
	Vshufps = 1472,
	Vsqrtpd = 1473,
	Vsqrtps = 1474,
	Vsqrtsd = 1475,
	Vsqrtss = 1476,
	Vstmxcsr = 1477,
	Vsubpd = 1478,
	Vsubps = 1479,
	Vsubsd = 1480,
	Vsubss = 1481,
	Vtestpd = 1482,
	Vtestps = 1483,
	Vucomisd = 1484,
	Vucomiss = 1485,
	Vunpckhpd = 1486,
	Vunpckhps = 1487,
	Vunpcklpd = 1488,
	Vunpcklps = 1489,
	Vxorpd = 1490,
	Vxorps = 1491,
	Vzeroall = 1492,
	Vzeroupper = 1493,
	Wait = 1494,
	Wbinvd = 1495,
	Wbnoinvd = 1496,
	Wrfsbase = 1497,
	Wrgsbase = 1498,
	Wrmsr = 1499,
	Wrpkru = 1500,
	Wrssd = 1501,
	Wrssq = 1502,
	Wrussd = 1503,
	Wrussq = 1504,
	Xabort = 1505,
	Xadd = 1506,
	Xbegin = 1507,
	Xbts = 1508,
	Xchg = 1509,
	Xcryptcbc = 1510,
	Xcryptcfb = 1511,
	Xcryptctr = 1512,
	Xcryptecb = 1513,
	Xcryptofb = 1514,
	Xend = 1515,
	Xgetbv = 1516,
	Xlatb = 1517,
	Xor = 1518,
	Xorpd = 1519,
	Xorps = 1520,
	Xrstor = 1521,
	Xrstor64 = 1522,
	Xrstors = 1523,
	Xrstors64 = 1524,
	Xsave = 1525,
	Xsave64 = 1526,
	Xsavec = 1527,
	Xsavec64 = 1528,
	Xsaveopt = 1529,
	Xsaveopt64 = 1530,
	Xsaves = 1531,
	Xsaves64 = 1532,
	Xsetbv = 1533,
	Xsha1 = 1534,
	Xsha256 = 1535,
	Xstore = 1536,
	Xtest = 1537,
	Rmpadjust = 1538,
	Rmpupdate = 1539,
	Psmash = 1540,
	Pvalidate = 1541,
	Serialize = 1542,
	Xsusldtrk = 1543,
	Xresldtrk = 1544,
	Invlpgb = 1545,
	Tlbsync = 1546,
	Vmgexit = 1547,
	Getsecq = 1548,
	Sysexitq = 1549,
	Ldtilecfg = 1550,
	Tilerelease = 1551,
	Sttilecfg = 1552,
	Tilezero = 1553,
	Tileloaddt1 = 1554,
	Tilestored = 1555,
	Tileloadd = 1556,
	Tdpbf16ps = 1557,
	Tdpbuud = 1558,
	Tdpbusd = 1559,
	Tdpbsud = 1560,
	Tdpbssd = 1561,
	Sysretq = 1562,
	Fnstdw = 1563,
	Fnstsg = 1564,
	Rdshr = 1565,
	Wrshr = 1566,
	Smint = 1567,
	Dmint = 1568,
	Rdm = 1569,
	Svdc = 1570,
	Rsdc = 1571,
	Svldt = 1572,
	Rsldt = 1573,
	Svts = 1574,
	Rsts = 1575,
	Bb0_reset = 1576,
	Bb1_reset = 1577,
	Cpu_write = 1578,
	Cpu_read = 1579,
	Altinst = 1580,
	Paveb = 1581,
	Paddsiw = 1582,
	Pmagw = 1583,
	Pdistib = 1584,
	Psubsiw = 1585,
	Pmvzb = 1586,
	Pmvnzb = 1587,
	Pmvlzb = 1588,
	Pmvgezb = 1589,
	Pmulhriw = 1590,
	Pmachriw = 1591,
	Ftstp = 1592,
	Frint2 = 1593,
	Frichop = 1594,
	Frinear = 1595,
	Undoc = 1596,
	Tdcall = 1597,
	Seamret = 1598,
	Seamops = 1599,
	Seamcall = 1600,
	Aesencwide128kl = 1601,
	Aesdecwide128kl = 1602,
	Aesencwide256kl = 1603,
	Aesdecwide256kl = 1604,
	Loadiwkey = 1605,
	Aesenc128kl = 1606,
	Aesdec128kl = 1607,
	Aesenc256kl = 1608,
	Aesdec256kl = 1609,
	Encodekey128 = 1610,
	Encodekey256 = 1611,
	Pushad = 1612,
	Popad = 1613,
	Pushfd = 1614,
	Pushfq = 1615,
	Popfd = 1616,
	Popfq = 1617,
	Iretd = 1618,
	Iretq = 1619,
	Int3 = 1620,
	Uiret = 1621,
	Testui = 1622,
	Clui = 1623,
	Stui = 1624,
	Senduipi = 1625,
	Hreset = 1626,
	Ccs_hash = 1627,
	Ccs_encrypt = 1628,
	Lkgs = 1629,
	Eretu = 1630,
	Erets = 1631,
}
#[rustfmt::skip]
static GEN_DEBUG_MNEMONIC: [&str; 1632] = [
	"INVALID",
	"Aaa",
	"Aad",
	"Aam",
	"Aas",
	"Adc",
	"Adcx",
	"Add",
	"Addpd",
	"Addps",
	"Addsd",
	"Addss",
	"Addsubpd",
	"Addsubps",
	"Adox",
	"Aesdec",
	"Aesdeclast",
	"Aesenc",
	"Aesenclast",
	"Aesimc",
	"Aeskeygenassist",
	"And",
	"Andn",
	"Andnpd",
	"Andnps",
	"Andpd",
	"Andps",
	"Arpl",
	"Bextr",
	"Blcfill",
	"Blci",
	"Blcic",
	"Blcmsk",
	"Blcs",
	"Blendpd",
	"Blendps",
	"Blendvpd",
	"Blendvps",
	"Blsfill",
	"Blsi",
	"Blsic",
	"Blsmsk",
	"Blsr",
	"Bndcl",
	"Bndcn",
	"Bndcu",
	"Bndldx",
	"Bndmk",
	"Bndmov",
	"Bndstx",
	"Bound",
	"Bsf",
	"Bsr",
	"Bswap",
	"Bt",
	"Btc",
	"Btr",
	"Bts",
	"Bzhi",
	"Call",
	"Cbw",
	"Cdq",
	"Cdqe",
	"Cl1invmb",
	"Clac",
	"Clc",
	"Cld",
	"Cldemote",
	"Clflush",
	"Clflushopt",
	"Clgi",
	"Cli",
	"Clrssbsy",
	"Clts",
	"Clwb",
	"Clzero",
	"Cmc",
	"Cmova",
	"Cmovae",
	"Cmovb",
	"Cmovbe",
	"Cmove",
	"Cmovg",
	"Cmovge",
	"Cmovl",
	"Cmovle",
	"Cmovne",
	"Cmovno",
	"Cmovnp",
	"Cmovns",
	"Cmovo",
	"Cmovp",
	"Cmovs",
	"Cmp",
	"Cmppd",
	"Cmpps",
	"Cmpsb",
	"Cmpsd",
	"Cmpsq",
	"Cmpss",
	"Cmpsw",
	"Cmpxchg",
	"Cmpxchg16b",
	"Cmpxchg8b",
	"Comisd",
	"Comiss",
	"Cpuid",
	"Cqo",
	"Crc32",
	"Cvtdq2pd",
	"Cvtdq2ps",
	"Cvtpd2dq",
	"Cvtpd2pi",
	"Cvtpd2ps",
	"Cvtpi2pd",
	"Cvtpi2ps",
	"Cvtps2dq",
	"Cvtps2pd",
	"Cvtps2pi",
	"Cvtsd2si",
	"Cvtsd2ss",
	"Cvtsi2sd",
	"Cvtsi2ss",
	"Cvtss2sd",
	"Cvtss2si",
	"Cvttpd2dq",
	"Cvttpd2pi",
	"Cvttps2dq",
	"Cvttps2pi",
	"Cvttsd2si",
	"Cvttss2si",
	"Cwd",
	"Cwde",
	"Daa",
	"Das",
	"Db",
	"Dd",
	"Dec",
	"Div",
	"Divpd",
	"Divps",
	"Divsd",
	"Divss",
	"Dppd",
	"Dpps",
	"Dq",
	"Dw",
	"Emms",
	"Encls",
	"Enclu",
	"Enclv",
	"Endbr32",
	"Endbr64",
	"Enqcmd",
	"Enqcmds",
	"Enter",
	"Extractps",
	"Extrq",
	"F2xm1",
	"Fabs",
	"Fadd",
	"Faddp",
	"Fbld",
	"Fbstp",
	"Fchs",
	"Fclex",
	"Fcmovb",
	"Fcmovbe",
	"Fcmove",
	"Fcmovnb",
	"Fcmovnbe",
	"Fcmovne",
	"Fcmovnu",
	"Fcmovu",
	"Fcom",
	"Fcomi",
	"Fcomip",
	"Fcomp",
	"Fcompp",
	"Fcos",
	"Fdecstp",
	"Fdisi",
	"Fdiv",
	"Fdivp",
	"Fdivr",
	"Fdivrp",
	"Femms",
	"Feni",
	"Ffree",
	"Ffreep",
	"Fiadd",
	"Ficom",
	"Ficomp",
	"Fidiv",
	"Fidivr",
	"Fild",
	"Fimul",
	"Fincstp",
	"Finit",
	"Fist",
	"Fistp",
	"Fisttp",
	"Fisub",
	"Fisubr",
	"Fld",
	"Fld1",
	"Fldcw",
	"Fldenv",
	"Fldl2e",
	"Fldl2t",
	"Fldlg2",
	"Fldln2",
	"Fldpi",
	"Fldz",
	"Fmul",
	"Fmulp",
	"Fnclex",
	"Fndisi",
	"Fneni",
	"Fninit",
	"Fnop",
	"Fnsave",
	"Fnsetpm",
	"Fnstcw",
	"Fnstenv",
	"Fnstsw",
	"Fpatan",
	"Fprem",
	"Fprem1",
	"Fptan",
	"Frndint",
	"Frstor",
	"Frstpm",
	"Fsave",
	"Fscale",
	"Fsetpm",
	"Fsin",
	"Fsincos",
	"Fsqrt",
	"Fst",
	"Fstcw",
	"Fstdw",
	"Fstenv",
	"Fstp",
	"Fstpnce",
	"Fstsg",
	"Fstsw",
	"Fsub",
	"Fsubp",
	"Fsubr",
	"Fsubrp",
	"Ftst",
	"Fucom",
	"Fucomi",
	"Fucomip",
	"Fucomp",
	"Fucompp",
	"Fxam",
	"Fxch",
	"Fxrstor",
	"Fxrstor64",
	"Fxsave",
	"Fxsave64",
	"Fxtract",
	"Fyl2x",
	"Fyl2xp1",
	"Getsec",
	"Gf2p8affineinvqb",
	"Gf2p8affineqb",
	"Gf2p8mulb",
	"Haddpd",
	"Haddps",
	"Hlt",
	"Hsubpd",
	"Hsubps",
	"Ibts",
	"Idiv",
	"Imul",
	"In",
	"Inc",
	"Incsspd",
	"Incsspq",
	"Insb",
	"Insd",
	"Insertps",
	"Insertq",
	"Insw",
	"Int",
	"Int1",
	"Into",
	"Invd",
	"Invept",
	"Invlpg",
	"Invlpga",
	"Invpcid",
	"Invvpid",
	"Iret",
	"Ja",
	"Jae",
	"Jb",
	"Jbe",
	"Jcxz",
	"Je",
	"Jecxz",
	"Jg",
	"Jge",
	"Jl",
	"Jle",
	"Jmp",
	"Jmpe",
	"Jne",
	"Jno",
	"Jnp",
	"Jns",
	"Jo",
	"Jp",
	"Jrcxz",
	"Js",
	"Kaddb",
	"Kaddd",
	"Kaddq",
	"Kaddw",
	"Kandb",
	"Kandd",
	"Kandnb",
	"Kandnd",
	"Kandnq",
	"Kandnw",
	"Kandq",
	"Kandw",
	"Kmovb",
	"Kmovd",
	"Kmovq",
	"Kmovw",
	"Knotb",
	"Knotd",
	"Knotq",
	"Knotw",
	"Korb",
	"Kord",
	"Korq",
	"Kortestb",
	"Kortestd",
	"Kortestq",
	"Kortestw",
	"Korw",
	"Kshiftlb",
	"Kshiftld",
	"Kshiftlq",
	"Kshiftlw",
	"Kshiftrb",
	"Kshiftrd",
	"Kshiftrq",
	"Kshiftrw",
	"Ktestb",
	"Ktestd",
	"Ktestq",
	"Ktestw",
	"Kunpckbw",
	"Kunpckdq",
	"Kunpckwd",
	"Kxnorb",
	"Kxnord",
	"Kxnorq",
	"Kxnorw",
	"Kxorb",
	"Kxord",
	"Kxorq",
	"Kxorw",
	"Lahf",
	"Lar",
	"Lddqu",
	"Ldmxcsr",
	"Lds",
	"Lea",
	"Leave",
	"Les",
	"Lfence",
	"Lfs",
	"Lgdt",
	"Lgs",
	"Lidt",
	"Lldt",
	"Llwpcb",
	"Lmsw",
	"Loadall",
	"Lodsb",
	"Lodsd",
	"Lodsq",
	"Lodsw",
	"Loop",
	"Loope",
	"Loopne",
	"Lsl",
	"Lss",
	"Ltr",
	"Lwpins",
	"Lwpval",
	"Lzcnt",
	"Maskmovdqu",
	"Maskmovq",
	"Maxpd",
	"Maxps",
	"Maxsd",
	"Maxss",
	"Mcommit",
	"Mfence",
	"Minpd",
	"Minps",
	"Minsd",
	"Minss",
	"Monitor",
	"Monitorx",
	"Montmul",
	"Mov",
	"Movapd",
	"Movaps",
	"Movbe",
	"Movd",
	"Movddup",
	"Movdir64b",
	"Movdiri",
	"Movdq2q",
	"Movdqa",
	"Movdqu",
	"Movhlps",
	"Movhpd",
	"Movhps",
	"Movlhps",
	"Movlpd",
	"Movlps",
	"Movmskpd",
	"Movmskps",
	"Movntdq",
	"Movntdqa",
	"Movnti",
	"Movntpd",
	"Movntps",
	"Movntq",
	"Movntsd",
	"Movntss",
	"Movq",
	"Movq2dq",
	"Movsb",
	"Movsd",
	"Movshdup",
	"Movsldup",
	"Movsq",
	"Movss",
	"Movsw",
	"Movsx",
	"Movsxd",
	"Movupd",
	"Movups",
	"Movzx",
	"Mpsadbw",
	"Mul",
	"Mulpd",
	"Mulps",
	"Mulsd",
	"Mulss",
	"Mulx",
	"Mwait",
	"Mwaitx",
	"Neg",
	"Nop",
	"Not",
	"Or",
	"Orpd",
	"Orps",
	"Out",
	"Outsb",
	"Outsd",
	"Outsw",
	"Pabsb",
	"Pabsd",
	"Pabsw",
	"Packssdw",
	"Packsswb",
	"Packusdw",
	"Packuswb",
	"Paddb",
	"Paddd",
	"Paddq",
	"Paddsb",
	"Paddsw",
	"Paddusb",
	"Paddusw",
	"Paddw",
	"Palignr",
	"Pand",
	"Pandn",
	"Pause",
	"Pavgb",
	"Pavgusb",
	"Pavgw",
	"Pblendvb",
	"Pblendw",
	"Pclmulqdq",
	"Pcmpeqb",
	"Pcmpeqd",
	"Pcmpeqq",
	"Pcmpeqw",
	"Pcmpestri",
	"Pcmpestri64",
	"Pcmpestrm",
	"Pcmpestrm64",
	"Pcmpgtb",
	"Pcmpgtd",
	"Pcmpgtq",
	"Pcmpgtw",
	"Pcmpistri",
	"Pcmpistrm",
	"Pcommit",
	"Pconfig",
	"Pdep",
	"Pext",
	"Pextrb",
	"Pextrd",
	"Pextrq",
	"Pextrw",
	"Pf2id",
	"Pf2iw",
	"Pfacc",
	"Pfadd",
	"Pfcmpeq",
	"Pfcmpge",
	"Pfcmpgt",
	"Pfmax",
	"Pfmin",
	"Pfmul",
	"Pfnacc",
	"Pfpnacc",
	"Pfrcp",
	"Pfrcpit1",
	"Pfrcpit2",
	"Pfrcpv",
	"Pfrsqit1",
	"Pfrsqrt",
	"Pfrsqrtv",
	"Pfsub",
	"Pfsubr",
	"Phaddd",
	"Phaddsw",
	"Phaddw",
	"Phminposuw",
	"Phsubd",
	"Phsubsw",
	"Phsubw",
	"Pi2fd",
	"Pi2fw",
	"Pinsrb",
	"Pinsrd",
	"Pinsrq",
	"Pinsrw",
	"Pmaddubsw",
	"Pmaddwd",
	"Pmaxsb",
	"Pmaxsd",
	"Pmaxsw",
	"Pmaxub",
	"Pmaxud",
	"Pmaxuw",
	"Pminsb",
	"Pminsd",
	"Pminsw",
	"Pminub",
	"Pminud",
	"Pminuw",
	"Pmovmskb",
	"Pmovsxbd",
	"Pmovsxbq",
	"Pmovsxbw",
	"Pmovsxdq",
	"Pmovsxwd",
	"Pmovsxwq",
	"Pmovzxbd",
	"Pmovzxbq",
	"Pmovzxbw",
	"Pmovzxdq",
	"Pmovzxwd",
	"Pmovzxwq",
	"Pmuldq",
	"Pmulhrsw",
	"Pmulhrw",
	"Pmulhuw",
	"Pmulhw",
	"Pmulld",
	"Pmullw",
	"Pmuludq",
	"Pop",
	"Popa",
	"Popcnt",
	"Popf",
	"Por",
	"Prefetch",
	"Prefetchnta",
	"Prefetcht0",
	"Prefetcht1",
	"Prefetcht2",
	"Prefetchw",
	"Prefetchwt1",
	"Psadbw",
	"Pshufb",
	"Pshufd",
	"Pshufhw",
	"Pshuflw",
	"Pshufw",
	"Psignb",
	"Psignd",
	"Psignw",
	"Pslld",
	"Pslldq",
	"Psllq",
	"Psllw",
	"Psrad",
	"Psraw",
	"Psrld",
	"Psrldq",
	"Psrlq",
	"Psrlw",
	"Psubb",
	"Psubd",
	"Psubq",
	"Psubsb",
	"Psubsw",
	"Psubusb",
	"Psubusw",
	"Psubw",
	"Pswapd",
	"Ptest",
	"Ptwrite",
	"Punpckhbw",
	"Punpckhdq",
	"Punpckhqdq",
	"Punpckhwd",
	"Punpcklbw",
	"Punpckldq",
	"Punpcklqdq",
	"Punpcklwd",
	"Push",
	"Pusha",
	"Pushf",
	"Pxor",
	"Rcl",
	"Rcpps",
	"Rcpss",
	"Rcr",
	"Rdfsbase",
	"Rdgsbase",
	"Rdmsr",
	"Rdpid",
	"Rdpkru",
	"Rdpmc",
	"Rdpru",
	"Rdrand",
	"Rdseed",
	"Rdsspd",
	"Rdsspq",
	"Rdtsc",
	"Rdtscp",
	"Reservednop",
	"Ret",
	"Retf",
	"Rol",
	"Ror",
	"Rorx",
	"Roundpd",
	"Roundps",
	"Roundsd",
	"Roundss",
	"Rsm",
	"Rsqrtps",
	"Rsqrtss",
	"Rstorssp",
	"Sahf",
	"Sal",
	"Salc",
	"Sar",
	"Sarx",
	"Saveprevssp",
	"Sbb",
	"Scasb",
	"Scasd",
	"Scasq",
	"Scasw",
	"Seta",
	"Setae",
	"Setb",
	"Setbe",
	"Sete",
	"Setg",
	"Setge",
	"Setl",
	"Setle",
	"Setne",
	"Setno",
	"Setnp",
	"Setns",
	"Seto",
	"Setp",
	"Sets",
	"Setssbsy",
	"Sfence",
	"Sgdt",
	"Sha1msg1",
	"Sha1msg2",
	"Sha1nexte",
	"Sha1rnds4",
	"Sha256msg1",
	"Sha256msg2",
	"Sha256rnds2",
	"Shl",
	"Shld",
	"Shlx",
	"Shr",
	"Shrd",
	"Shrx",
	"Shufpd",
	"Shufps",
	"Sidt",
	"Skinit",
	"Sldt",
	"Slwpcb",
	"Smsw",
	"Sqrtpd",
	"Sqrtps",
	"Sqrtsd",
	"Sqrtss",
	"Stac",
	"Stc",
	"Std",
	"Stgi",
	"Sti",
	"Stmxcsr",
	"Stosb",
	"Stosd",
	"Stosq",
	"Stosw",
	"Str",
	"Sub",
	"Subpd",
	"Subps",
	"Subsd",
	"Subss",
	"Swapgs",
	"Syscall",
	"Sysenter",
	"Sysexit",
	"Sysret",
	"T1mskc",
	"Test",
	"Tpause",
	"Tzcnt",
	"Tzmsk",
	"Ucomisd",
	"Ucomiss",
	"Ud0",
	"Ud1",
	"Ud2",
	"Umonitor",
	"Umov",
	"Umwait",
	"Unpckhpd",
	"Unpckhps",
	"Unpcklpd",
	"Unpcklps",
	"V4fmaddps",
	"V4fmaddss",
	"V4fnmaddps",
	"V4fnmaddss",
	"Vaddpd",
	"Vaddps",
	"Vaddsd",
	"Vaddss",
	"Vaddsubpd",
	"Vaddsubps",
	"Vaesdec",
	"Vaesdeclast",
	"Vaesenc",
	"Vaesenclast",
	"Vaesimc",
	"Vaeskeygenassist",
	"Valignd",
	"Valignq",
	"Vandnpd",
	"Vandnps",
	"Vandpd",
	"Vandps",
	"Vblendmpd",
	"Vblendmps",
	"Vblendpd",
	"Vblendps",
	"Vblendvpd",
	"Vblendvps",
	"Vbroadcastf128",
	"Vbroadcastf32x2",
	"Vbroadcastf32x4",
	"Vbroadcastf32x8",
	"Vbroadcastf64x2",
	"Vbroadcastf64x4",
	"Vbroadcasti128",
	"Vbroadcasti32x2",
	"Vbroadcasti32x4",
	"Vbroadcasti32x8",
	"Vbroadcasti64x2",
	"Vbroadcasti64x4",
	"Vbroadcastsd",
	"Vbroadcastss",
	"Vcmppd",
	"Vcmpps",
	"Vcmpsd",
	"Vcmpss",
	"Vcomisd",
	"Vcomiss",
	"Vcompresspd",
	"Vcompressps",
	"Vcvtdq2pd",
	"Vcvtdq2ps",
	"Vcvtne2ps2bf16",
	"Vcvtneps2bf16",
	"Vcvtpd2dq",
	"Vcvtpd2ps",
	"Vcvtpd2qq",
	"Vcvtpd2udq",
	"Vcvtpd2uqq",
	"Vcvtph2ps",
	"Vcvtps2dq",
	"Vcvtps2pd",
	"Vcvtps2ph",
	"Vcvtps2qq",
	"Vcvtps2udq",
	"Vcvtps2uqq",
	"Vcvtqq2pd",
	"Vcvtqq2ps",
	"Vcvtsd2si",
	"Vcvtsd2ss",
	"Vcvtsd2usi",
	"Vcvtsi2sd",
	"Vcvtsi2ss",
	"Vcvtss2sd",
	"Vcvtss2si",
	"Vcvtss2usi",
	"Vcvttpd2dq",
	"Vcvttpd2qq",
	"Vcvttpd2udq",
	"Vcvttpd2uqq",
	"Vcvttps2dq",
	"Vcvttps2qq",
	"Vcvttps2udq",
	"Vcvttps2uqq",
	"Vcvttsd2si",
	"Vcvttsd2usi",
	"Vcvttss2si",
	"Vcvttss2usi",
	"Vcvtudq2pd",
	"Vcvtudq2ps",
	"Vcvtuqq2pd",
	"Vcvtuqq2ps",
	"Vcvtusi2sd",
	"Vcvtusi2ss",
	"Vdbpsadbw",
	"Vdivpd",
	"Vdivps",
	"Vdivsd",
	"Vdivss",
	"Vdpbf16ps",
	"Vdppd",
	"Vdpps",
	"Verr",
	"Verw",
	"Vexp2pd",
	"Vexp2ps",
	"Vexpandpd",
	"Vexpandps",
	"Vextractf128",
	"Vextractf32x4",
	"Vextractf32x8",
	"Vextractf64x2",
	"Vextractf64x4",
	"Vextracti128",
	"Vextracti32x4",
	"Vextracti32x8",
	"Vextracti64x2",
	"Vextracti64x4",
	"Vextractps",
	"Vfixupimmpd",
	"Vfixupimmps",
	"Vfixupimmsd",
	"Vfixupimmss",
	"Vfmadd132pd",
	"Vfmadd132ps",
	"Vfmadd132sd",
	"Vfmadd132ss",
	"Vfmadd213pd",
	"Vfmadd213ps",
	"Vfmadd213sd",
	"Vfmadd213ss",
	"Vfmadd231pd",
	"Vfmadd231ps",
	"Vfmadd231sd",
	"Vfmadd231ss",
	"Vfmaddpd",
	"Vfmaddps",
	"Vfmaddsd",
	"Vfmaddss",
	"Vfmaddsub132pd",
	"Vfmaddsub132ps",
	"Vfmaddsub213pd",
	"Vfmaddsub213ps",
	"Vfmaddsub231pd",
	"Vfmaddsub231ps",
	"Vfmaddsubpd",
	"Vfmaddsubps",
	"Vfmsub132pd",
	"Vfmsub132ps",
	"Vfmsub132sd",
	"Vfmsub132ss",
	"Vfmsub213pd",
	"Vfmsub213ps",
	"Vfmsub213sd",
	"Vfmsub213ss",
	"Vfmsub231pd",
	"Vfmsub231ps",
	"Vfmsub231sd",
	"Vfmsub231ss",
	"Vfmsubadd132pd",
	"Vfmsubadd132ps",
	"Vfmsubadd213pd",
	"Vfmsubadd213ps",
	"Vfmsubadd231pd",
	"Vfmsubadd231ps",
	"Vfmsubaddpd",
	"Vfmsubaddps",
	"Vfmsubpd",
	"Vfmsubps",
	"Vfmsubsd",
	"Vfmsubss",
	"Vfnmadd132pd",
	"Vfnmadd132ps",
	"Vfnmadd132sd",
	"Vfnmadd132ss",
	"Vfnmadd213pd",
	"Vfnmadd213ps",
	"Vfnmadd213sd",
	"Vfnmadd213ss",
	"Vfnmadd231pd",
	"Vfnmadd231ps",
	"Vfnmadd231sd",
	"Vfnmadd231ss",
	"Vfnmaddpd",
	"Vfnmaddps",
	"Vfnmaddsd",
	"Vfnmaddss",
	"Vfnmsub132pd",
	"Vfnmsub132ps",
	"Vfnmsub132sd",
	"Vfnmsub132ss",
	"Vfnmsub213pd",
	"Vfnmsub213ps",
	"Vfnmsub213sd",
	"Vfnmsub213ss",
	"Vfnmsub231pd",
	"Vfnmsub231ps",
	"Vfnmsub231sd",
	"Vfnmsub231ss",
	"Vfnmsubpd",
	"Vfnmsubps",
	"Vfnmsubsd",
	"Vfnmsubss",
	"Vfpclasspd",
	"Vfpclassps",
	"Vfpclasssd",
	"Vfpclassss",
	"Vfrczpd",
	"Vfrczps",
	"Vfrczsd",
	"Vfrczss",
	"Vgatherdpd",
	"Vgatherdps",
	"Vgatherpf0dpd",
	"Vgatherpf0dps",
	"Vgatherpf0qpd",
	"Vgatherpf0qps",
	"Vgatherpf1dpd",
	"Vgatherpf1dps",
	"Vgatherpf1qpd",
	"Vgatherpf1qps",
	"Vgatherqpd",
	"Vgatherqps",
	"Vgetexppd",
	"Vgetexpps",
	"Vgetexpsd",
	"Vgetexpss",
	"Vgetmantpd",
	"Vgetmantps",
	"Vgetmantsd",
	"Vgetmantss",
	"Vgf2p8affineinvqb",
	"Vgf2p8affineqb",
	"Vgf2p8mulb",
	"Vhaddpd",
	"Vhaddps",
	"Vhsubpd",
	"Vhsubps",
	"Vinsertf128",
	"Vinsertf32x4",
	"Vinsertf32x8",
	"Vinsertf64x2",
	"Vinsertf64x4",
	"Vinserti128",
	"Vinserti32x4",
	"Vinserti32x8",
	"Vinserti64x2",
	"Vinserti64x4",
	"Vinsertps",
	"Vlddqu",
	"Vldmxcsr",
	"Vmaskmovdqu",
	"Vmaskmovpd",
	"Vmaskmovps",
	"Vmaxpd",
	"Vmaxps",
	"Vmaxsd",
	"Vmaxss",
	"Vmcall",
	"Vmclear",
	"Vmfunc",
	"Vminpd",
	"Vminps",
	"Vminsd",
	"Vminss",
	"Vmlaunch",
	"Vmload",
	"Vmmcall",
	"Vmovapd",
	"Vmovaps",
	"Vmovd",
	"Vmovddup",
	"Vmovdqa",
	"Vmovdqa32",
	"Vmovdqa64",
	"Vmovdqu",
	"Vmovdqu16",
	"Vmovdqu32",
	"Vmovdqu64",
	"Vmovdqu8",
	"Vmovhlps",
	"Vmovhpd",
	"Vmovhps",
	"Vmovlhps",
	"Vmovlpd",
	"Vmovlps",
	"Vmovmskpd",
	"Vmovmskps",
	"Vmovntdq",
	"Vmovntdqa",
	"Vmovntpd",
	"Vmovntps",
	"Vmovq",
	"Vmovsd",
	"Vmovshdup",
	"Vmovsldup",
	"Vmovss",
	"Vmovupd",
	"Vmovups",
	"Vmpsadbw",
	"Vmptrld",
	"Vmptrst",
	"Vmread",
	"Vmresume",
	"Vmrun",
	"Vmsave",
	"Vmulpd",
	"Vmulps",
	"Vmulsd",
	"Vmulss",
	"Vmwrite",
	"Vmxoff",
	"Vmxon",
	"Vorpd",
	"Vorps",
	"Vp2intersectd",
	"Vp2intersectq",
	"Vp4dpwssd",
	"Vp4dpwssds",
	"Vpabsb",
	"Vpabsd",
	"Vpabsq",
	"Vpabsw",
	"Vpackssdw",
	"Vpacksswb",
	"Vpackusdw",
	"Vpackuswb",
	"Vpaddb",
	"Vpaddd",
	"Vpaddq",
	"Vpaddsb",
	"Vpaddsw",
	"Vpaddusb",
	"Vpaddusw",
	"Vpaddw",
	"Vpalignr",
	"Vpand",
	"Vpandd",
	"Vpandn",
	"Vpandnd",
	"Vpandnq",
	"Vpandq",
	"Vpavgb",
	"Vpavgw",
	"Vpblendd",
	"Vpblendmb",
	"Vpblendmd",
	"Vpblendmq",
	"Vpblendmw",
	"Vpblendvb",
	"Vpblendw",
	"Vpbroadcastb",
	"Vpbroadcastd",
	"Vpbroadcastmb2q",
	"Vpbroadcastmw2d",
	"Vpbroadcastq",
	"Vpbroadcastw",
	"Vpclmulqdq",
	"Vpcmov",
	"Vpcmpb",
	"Vpcmpd",
	"Vpcmpeqb",
	"Vpcmpeqd",
	"Vpcmpeqq",
	"Vpcmpeqw",
	"Vpcmpestri",
	"Vpcmpestri64",
	"Vpcmpestrm",
	"Vpcmpestrm64",
	"Vpcmpgtb",
	"Vpcmpgtd",
	"Vpcmpgtq",
	"Vpcmpgtw",
	"Vpcmpistri",
	"Vpcmpistrm",
	"Vpcmpq",
	"Vpcmpub",
	"Vpcmpud",
	"Vpcmpuq",
	"Vpcmpuw",
	"Vpcmpw",
	"Vpcomb",
	"Vpcomd",
	"Vpcompressb",
	"Vpcompressd",
	"Vpcompressq",
	"Vpcompressw",
	"Vpcomq",
	"Vpcomub",
	"Vpcomud",
	"Vpcomuq",
	"Vpcomuw",
	"Vpcomw",
	"Vpconflictd",
	"Vpconflictq",
	"Vpdpbusd",
	"Vpdpbusds",
	"Vpdpwssd",
	"Vpdpwssds",
	"Vperm2f128",
	"Vperm2i128",
	"Vpermb",
	"Vpermd",
	"Vpermi2b",
	"Vpermi2d",
	"Vpermi2pd",
	"Vpermi2ps",
	"Vpermi2q",
	"Vpermi2w",
	"Vpermil2pd",
	"Vpermil2ps",
	"Vpermilpd",
	"Vpermilps",
	"Vpermpd",
	"Vpermps",
	"Vpermq",
	"Vpermt2b",
	"Vpermt2d",
	"Vpermt2pd",
	"Vpermt2ps",
	"Vpermt2q",
	"Vpermt2w",
	"Vpermw",
	"Vpexpandb",
	"Vpexpandd",
	"Vpexpandq",
	"Vpexpandw",
	"Vpextrb",
	"Vpextrd",
	"Vpextrq",
	"Vpextrw",
	"Vpgatherdd",
	"Vpgatherdq",
	"Vpgatherqd",
	"Vpgatherqq",
	"Vphaddbd",
	"Vphaddbq",
	"Vphaddbw",
	"Vphaddd",
	"Vphadddq",
	"Vphaddsw",
	"Vphaddubd",
	"Vphaddubq",
	"Vphaddubw",
	"Vphaddudq",
	"Vphadduwd",
	"Vphadduwq",
	"Vphaddw",
	"Vphaddwd",
	"Vphaddwq",
	"Vphminposuw",
	"Vphsubbw",
	"Vphsubd",
	"Vphsubdq",
	"Vphsubsw",
	"Vphsubw",
	"Vphsubwd",
	"Vpinsrb",
	"Vpinsrd",
	"Vpinsrq",
	"Vpinsrw",
	"Vplzcntd",
	"Vplzcntq",
	"Vpmacsdd",
	"Vpmacsdqh",
	"Vpmacsdql",
	"Vpmacssdd",
	"Vpmacssdqh",
	"Vpmacssdql",
	"Vpmacsswd",
	"Vpmacssww",
	"Vpmacswd",
	"Vpmacsww",
	"Vpmadcsswd",
	"Vpmadcswd",
	"Vpmadd52huq",
	"Vpmadd52luq",
	"Vpmaddubsw",
	"Vpmaddwd",
	"Vpmaskmovd",
	"Vpmaskmovq",
	"Vpmaxsb",
	"Vpmaxsd",
	"Vpmaxsq",
	"Vpmaxsw",
	"Vpmaxub",
	"Vpmaxud",
	"Vpmaxuq",
	"Vpmaxuw",
	"Vpminsb",
	"Vpminsd",
	"Vpminsq",
	"Vpminsw",
	"Vpminub",
	"Vpminud",
	"Vpminuq",
	"Vpminuw",
	"Vpmovb2m",
	"Vpmovd2m",
	"Vpmovdb",
	"Vpmovdw",
	"Vpmovm2b",
	"Vpmovm2d",
	"Vpmovm2q",
	"Vpmovm2w",
	"Vpmovmskb",
	"Vpmovq2m",
	"Vpmovqb",
	"Vpmovqd",
	"Vpmovqw",
	"Vpmovsdb",
	"Vpmovsdw",
	"Vpmovsqb",
	"Vpmovsqd",
	"Vpmovsqw",
	"Vpmovswb",
	"Vpmovsxbd",
	"Vpmovsxbq",
	"Vpmovsxbw",
	"Vpmovsxdq",
	"Vpmovsxwd",
	"Vpmovsxwq",
	"Vpmovusdb",
	"Vpmovusdw",
	"Vpmovusqb",
	"Vpmovusqd",
	"Vpmovusqw",
	"Vpmovuswb",
	"Vpmovw2m",
	"Vpmovwb",
	"Vpmovzxbd",
	"Vpmovzxbq",
	"Vpmovzxbw",
	"Vpmovzxdq",
	"Vpmovzxwd",
	"Vpmovzxwq",
	"Vpmuldq",
	"Vpmulhrsw",
	"Vpmulhuw",
	"Vpmulhw",
	"Vpmulld",
	"Vpmullq",
	"Vpmullw",
	"Vpmultishiftqb",
	"Vpmuludq",
	"Vpopcntb",
	"Vpopcntd",
	"Vpopcntq",
	"Vpopcntw",
	"Vpor",
	"Vpord",
	"Vporq",
	"Vpperm",
	"Vprold",
	"Vprolq",
	"Vprolvd",
	"Vprolvq",
	"Vprord",
	"Vprorq",
	"Vprorvd",
	"Vprorvq",
	"Vprotb",
	"Vprotd",
	"Vprotq",
	"Vprotw",
	"Vpsadbw",
	"Vpscatterdd",
	"Vpscatterdq",
	"Vpscatterqd",
	"Vpscatterqq",
	"Vpshab",
	"Vpshad",
	"Vpshaq",
	"Vpshaw",
	"Vpshlb",
	"Vpshld",
	"Vpshldd",
	"Vpshldq",
	"Vpshldvd",
	"Vpshldvq",
	"Vpshldvw",
	"Vpshldw",
	"Vpshlq",
	"Vpshlw",
	"Vpshrdd",
	"Vpshrdq",
	"Vpshrdvd",
	"Vpshrdvq",
	"Vpshrdvw",
	"Vpshrdw",
	"Vpshufb",
	"Vpshufbitqmb",
	"Vpshufd",
	"Vpshufhw",
	"Vpshuflw",
	"Vpsignb",
	"Vpsignd",
	"Vpsignw",
	"Vpslld",
	"Vpslldq",
	"Vpsllq",
	"Vpsllvd",
	"Vpsllvq",
	"Vpsllvw",
	"Vpsllw",
	"Vpsrad",
	"Vpsraq",
	"Vpsravd",
	"Vpsravq",
	"Vpsravw",
	"Vpsraw",
	"Vpsrld",
	"Vpsrldq",
	"Vpsrlq",
	"Vpsrlvd",
	"Vpsrlvq",
	"Vpsrlvw",
	"Vpsrlw",
	"Vpsubb",
	"Vpsubd",
	"Vpsubq",
	"Vpsubsb",
	"Vpsubsw",
	"Vpsubusb",
	"Vpsubusw",
	"Vpsubw",
	"Vpternlogd",
	"Vpternlogq",
	"Vptest",
	"Vptestmb",
	"Vptestmd",
	"Vptestmq",
	"Vptestmw",
	"Vptestnmb",
	"Vptestnmd",
	"Vptestnmq",
	"Vptestnmw",
	"Vpunpckhbw",
	"Vpunpckhdq",
	"Vpunpckhqdq",
	"Vpunpckhwd",
	"Vpunpcklbw",
	"Vpunpckldq",
	"Vpunpcklqdq",
	"Vpunpcklwd",
	"Vpxor",
	"Vpxord",
	"Vpxorq",
	"Vrangepd",
	"Vrangeps",
	"Vrangesd",
	"Vrangess",
	"Vrcp14pd",
	"Vrcp14ps",
	"Vrcp14sd",
	"Vrcp14ss",
	"Vrcp28pd",
	"Vrcp28ps",
	"Vrcp28sd",
	"Vrcp28ss",
	"Vrcpps",
	"Vrcpss",
	"Vreducepd",
	"Vreduceps",
	"Vreducesd",
	"Vreducess",
	"Vrndscalepd",
	"Vrndscaleps",
	"Vrndscalesd",
	"Vrndscaless",
	"Vroundpd",
	"Vroundps",
	"Vroundsd",
	"Vroundss",
	"Vrsqrt14pd",
	"Vrsqrt14ps",
	"Vrsqrt14sd",
	"Vrsqrt14ss",
	"Vrsqrt28pd",
	"Vrsqrt28ps",
	"Vrsqrt28sd",
	"Vrsqrt28ss",
	"Vrsqrtps",
	"Vrsqrtss",
	"Vscalefpd",
	"Vscalefps",
	"Vscalefsd",
	"Vscalefss",
	"Vscatterdpd",
	"Vscatterdps",
	"Vscatterpf0dpd",
	"Vscatterpf0dps",
	"Vscatterpf0qpd",
	"Vscatterpf0qps",
	"Vscatterpf1dpd",
	"Vscatterpf1dps",
	"Vscatterpf1qpd",
	"Vscatterpf1qps",
	"Vscatterqpd",
	"Vscatterqps",
	"Vshuff32x4",
	"Vshuff64x2",
	"Vshufi32x4",
	"Vshufi64x2",
	"Vshufpd",
	"Vshufps",
	"Vsqrtpd",
	"Vsqrtps",
	"Vsqrtsd",
	"Vsqrtss",
	"Vstmxcsr",
	"Vsubpd",
	"Vsubps",
	"Vsubsd",
	"Vsubss",
	"Vtestpd",
	"Vtestps",
	"Vucomisd",
	"Vucomiss",
	"Vunpckhpd",
	"Vunpckhps",
	"Vunpcklpd",
	"Vunpcklps",
	"Vxorpd",
	"Vxorps",
	"Vzeroall",
	"Vzeroupper",
	"Wait",
	"Wbinvd",
	"Wbnoinvd",
	"Wrfsbase",
	"Wrgsbase",
	"Wrmsr",
	"Wrpkru",
	"Wrssd",
	"Wrssq",
	"Wrussd",
	"Wrussq",
	"Xabort",
	"Xadd",
	"Xbegin",
	"Xbts",
	"Xchg",
	"Xcryptcbc",
	"Xcryptcfb",
	"Xcryptctr",
	"Xcryptecb",
	"Xcryptofb",
	"Xend",
	"Xgetbv",
	"Xlatb",
	"Xor",
	"Xorpd",
	"Xorps",
	"Xrstor",
	"Xrstor64",
	"Xrstors",
	"Xrstors64",
	"Xsave",
	"Xsave64",
	"Xsavec",
	"Xsavec64",
	"Xsaveopt",
	"Xsaveopt64",
	"Xsaves",
	"Xsaves64",
	"Xsetbv",
	"Xsha1",
	"Xsha256",
	"Xstore",
	"Xtest",
	"Rmpadjust",
	"Rmpupdate",
	"Psmash",
	"Pvalidate",
	"Serialize",
	"Xsusldtrk",
	"Xresldtrk",
	"Invlpgb",
	"Tlbsync",
	"Vmgexit",
	"Getsecq",
	"Sysexitq",
	"Ldtilecfg",
	"Tilerelease",
	"Sttilecfg",
	"Tilezero",
	"Tileloaddt1",
	"Tilestored",
	"Tileloadd",
	"Tdpbf16ps",
	"Tdpbuud",
	"Tdpbusd",
	"Tdpbsud",
	"Tdpbssd",
	"Sysretq",
	"Fnstdw",
	"Fnstsg",
	"Rdshr",
	"Wrshr",
	"Smint",
	"Dmint",
	"Rdm",
	"Svdc",
	"Rsdc",
	"Svldt",
	"Rsldt",
	"Svts",
	"Rsts",
	"Bb0_reset",
	"Bb1_reset",
	"Cpu_write",
	"Cpu_read",
	"Altinst",
	"Paveb",
	"Paddsiw",
	"Pmagw",
	"Pdistib",
	"Psubsiw",
	"Pmvzb",
	"Pmvnzb",
	"Pmvlzb",
	"Pmvgezb",
	"Pmulhriw",
	"Pmachriw",
	"Ftstp",
	"Frint2",
	"Frichop",
	"Frinear",
	"Undoc",
	"Tdcall",
	"Seamret",
	"Seamops",
	"Seamcall",
	"Aesencwide128kl",
	"Aesdecwide128kl",
	"Aesencwide256kl",
	"Aesdecwide256kl",
	"Loadiwkey",
	"Aesenc128kl",
	"Aesdec128kl",
	"Aesenc256kl",
	"Aesdec256kl",
	"Encodekey128",
	"Encodekey256",
	"Pushad",
	"Popad",
	"Pushfd",
	"Pushfq",
	"Popfd",
	"Popfq",
	"Iretd",
	"Iretq",
	"Int3",
	"Uiret",
	"Testui",
	"Clui",
	"Stui",
	"Senduipi",
	"Hreset",
	"Ccs_hash",
	"Ccs_encrypt",
	"Lkgs",
	"Eretu",
	"Erets",
];
impl fmt::Debug for Mnemonic {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_MNEMONIC[*self as usize])
	}
}
impl Default for Mnemonic {
	#[must_use]
	#[inline]
	fn default() -> Self {
		Mnemonic::INVALID
	}
}
#[rustfmt::skip]
impl Mnemonic {
	/// Iterates over all `Mnemonic` enum values
	#[inline]
	pub fn values() -> impl Iterator<Item = Mnemonic> + ExactSizeIterator + FusedIterator {
		// SAFETY: all values 0-max are valid enum values
		(0..IcedConstants::MNEMONIC_ENUM_COUNT).map(|x| unsafe { core::mem::transmute::<u16, Mnemonic>(x as u16) })
	}
}
#[test]
#[rustfmt::skip]
fn test_mnemonic_values() {
	let mut iter = Mnemonic::values();
	assert_eq!(iter.size_hint(), (IcedConstants::MNEMONIC_ENUM_COUNT, Some(IcedConstants::MNEMONIC_ENUM_COUNT)));
	assert_eq!(iter.len(), IcedConstants::MNEMONIC_ENUM_COUNT);
	assert!(iter.next().is_some());
	assert_eq!(iter.size_hint(), (IcedConstants::MNEMONIC_ENUM_COUNT - 1, Some(IcedConstants::MNEMONIC_ENUM_COUNT - 1)));
	assert_eq!(iter.len(), IcedConstants::MNEMONIC_ENUM_COUNT - 1);

	let values: Vec<Mnemonic> = Mnemonic::values().collect();
	assert_eq!(values.len(), IcedConstants::MNEMONIC_ENUM_COUNT);
	for (i, value) in values.into_iter().enumerate() {
		assert_eq!(i, value as usize);
	}
}
#[rustfmt::skip]
impl TryFrom<usize> for Mnemonic {
	type Error = IcedError;
	#[inline]
	fn try_from(value: usize) -> Result<Self, Self::Error> {
		if value < IcedConstants::MNEMONIC_ENUM_COUNT {
			// SAFETY: all values 0-max are valid enum values
			Ok(unsafe { mem::transmute(value as u16) })
		} else {
			Err(IcedError::new("Invalid Mnemonic value"))
		}
	}
}
#[test]
#[rustfmt::skip]
fn test_mnemonic_try_from_usize() {
	for value in Mnemonic::values() {
		let converted = <Mnemonic as TryFrom<usize>>::try_from(value as usize).unwrap();
		assert_eq!(converted, value);
	}
	assert!(<Mnemonic as TryFrom<usize>>::try_from(IcedConstants::MNEMONIC_ENUM_COUNT).is_err());
	assert!(<Mnemonic as TryFrom<usize>>::try_from(core::usize::MAX).is_err());
}
// GENERATOR-END: Mnemonic
