use ibig::{ibig, ubig};

#[test]
#[allow(clippy::identity_op, clippy::op_ref)]
fn test_ubig_shl() {
    assert_eq!(ubig!(0) << 17, ubig!(0));
    assert_eq!(&ubig!(0) << 17, ubig!(0));

    assert_eq!(ubig!(0xef) << 0, ubig!(0xef));
    assert_eq!(ubig!(0xef) << 4, ubig!(0xef0));
    assert_eq!(
        ubig!(0xef) << 128,
        ubig!(_0xef00000000000000000000000000000000)
    );
    assert_eq!(
        ubig!(0xef) << 124,
        ubig!(_0xef0000000000000000000000000000000)
    );
    assert_eq!(ubig!(0xef) << 10240, ubig!(_0xef0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000));
    assert_eq!(ubig!(0xef) << 10244, ubig!(_0xef00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000));

    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef) << 0,
        ubig!(_0x0123456789abcdef0123456789abcdef)
    );
    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef) << 4,
        ubig!(_0x0123456789abcdef0123456789abcdef0)
    );
    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef) << 128,
        ubig!(_0x0123456789abcdef0123456789abcdef00000000000000000000000000000000)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef) << 128,
        ubig!(_0x0123456789abcdef0123456789abcdef00000000000000000000000000000000)
    );
    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef) << 124,
        ubig!(_0x0123456789abcdef0123456789abcdef0000000000000000000000000000000)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef) << 124,
        ubig!(_0x0123456789abcdef0123456789abcdef0000000000000000000000000000000)
    );
    assert_eq!(ubig!(_0x0123456789abcdef0123456789abcdef) << 10240,
               ubig!(_0x0123456789abcdef0123456789abcdef0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000));
    assert_eq!(ubig!(_0x0123456789abcdef0123456789abcdef) << 10244,
               ubig!(_0x0123456789abcdef0123456789abcdef00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000));

    assert_eq!(&ubig!(0xef) << 4, ubig!(0xef0));
    assert_eq!(ubig!(0xef) << &4, ubig!(0xef0));
    assert_eq!(&ubig!(0xef) << &4, ubig!(0xef0));
}

#[test]
#[should_panic]
fn test_ubig_shl_too_large() {
    let _ = ubig!(1) << usize::MAX;
}

#[test]
#[allow(clippy::op_ref)]
fn test_ibig_shl() {
    assert_eq!(ibig!(0) << 4, ibig!(0));
    assert_eq!(ibig!(0) << usize::MAX, ibig!(0));

    assert_eq!(ibig!(0xef) << 4, ibig!(0xef0));
    assert_eq!(&ibig!(0xef) << 4, ibig!(0xef0));
    assert_eq!(ibig!(0xef) << &4, ibig!(0xef0));
    assert_eq!(&ibig!(0xef) << &4, ibig!(0xef0));
}

#[test]
fn test_shl_assign() {
    let mut a = ubig!(0xef);
    a <<= 4;
    assert_eq!(a, ubig!(0xef0));
    a <<= &4;
    assert_eq!(a, ubig!(0xef00));
}

#[test]
#[allow(clippy::identity_op, clippy::op_ref)]
fn test_ubig_shr() {
    assert_eq!(ubig!(0xef) >> 4, ubig!(0xe));
    assert_eq!(ubig!(0xef) >> &4, ubig!(0xe));
    assert_eq!(&ubig!(0xef) >> 4, ubig!(0xe));
    assert_eq!(&ubig!(0xef) >> &4, ubig!(0xe));

    assert_eq!(ubig!(0xef) >> 100, ubig!(0));
    assert_eq!(&ubig!(0xef) >> 100, ubig!(0));
    assert_eq!(ubig!(0xef) >> usize::MAX, ubig!(0));
    assert_eq!(&ubig!(0xef) >> usize::MAX, ubig!(0));

    assert_eq!((ubig!(0xef) << 63) >> 63, ubig!(0xef));
    assert_eq!((ubig!(0xef) << 64) >> 64, ubig!(0xef));
    assert_eq!((ubig!(0xef) << 1023) >> 1023, ubig!(0xef));
    assert_eq!((ubig!(0xef) << 1024) >> 1024, ubig!(0xef));
    assert_eq!(((ubig!(0xef) << 1024) >> 512) >> 512, ubig!(0xef));
    assert_eq!(((ubig!(0xef) << 1024) >> 510) >> 514, ubig!(0xef));
    assert_eq!(&(&(ubig!(0xef) << 1024) >> 512) >> 512, ubig!(0xef));
    assert_eq!(&(&(ubig!(0xef) << 1024) >> 510) >> 514, ubig!(0xef));

    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 0,
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef)
    );

    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 0,
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef)
    );

    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 1000000,
        ubig!(0)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 1000000,
        ubig!(0)
    );
    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 1000001,
        ubig!(0)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 1000001,
        ubig!(0)
    );

    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 4,
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcde)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 4,
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcde)
    );

    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 64,
        ubig!(_0x0123456789abcdef0123456789abcdef)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 64,
        ubig!(_0x0123456789abcdef0123456789abcdef)
    );
    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 124,
        ubig!(_0x123456789abcdef0)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 124,
        ubig!(_0x123456789abcdef0)
    );
    assert_eq!(
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 128,
        ubig!(_0x123456789abcdef)
    );
    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 128,
        ubig!(_0x123456789abcdef)
    );

    assert_eq!(ubig!(0xef) >> &4, ubig!(0xe));
    assert_eq!(&ubig!(0xef) >> 4, ubig!(0xe));
    assert_eq!(&ubig!(0xef) >> &4, ubig!(0xe));

    assert_eq!(
        &ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcdef) >> 4,
        ubig!(_0x0123456789abcdef0123456789abcdef0123456789abcde)
    );
}

#[test]
fn test_ubig_shr_assign() {
    let mut a = ubig!(0xeff);
    a >>= 4;
    assert_eq!(a, ubig!(0xef));
    a >>= &4;
    assert_eq!(a, ubig!(0xe));
}

#[test]
fn test_ibig_shr() {
    let test_cases = [
        (ibig!(0xe0), 4, ibig!(0xe)),
        (ibig!(0xef), 4, ibig!(0xe)),
        (ibig!(0xef), 100, ibig!(0)),
        (ibig!(-0xe0), 4, ibig!(-0xe)),
        (ibig!(-0xef), 4, ibig!(-0xf)),
        (ibig!(-0xef), 100, ibig!(-1)),
        (ibig!(0xff) << 1000, 1000, ibig!(0xff)),
        ((ibig!(0xff) << 1000) + ibig!(1), 1000, ibig!(0xff)),
        (ibig!(-0xff) << 1000, 1000, ibig!(-0xff)),
        ((ibig!(-0xff) << 1000) - ibig!(1), 1000, ibig!(-0x100)),
        (
            (ibig!(-0xff) << 1000) - (ibig!(1) << 999),
            1000,
            ibig!(-0x100),
        ),
        (ibig!(-0xff) << 1000, 2000, ibig!(-1)),
    ];
    for (a, b, c) in &test_cases {
        assert_eq!(a >> b, *c);
        assert_eq!(a >> *b, *c);
        assert_eq!(a.clone() >> b, *c);
        assert_eq!(a.clone() >> *b, *c);

        let mut x = a.clone();
        x >>= b;
        assert_eq!(x, *c);

        let mut x = a.clone();
        x >>= *b;
        assert_eq!(x, *c);
    }
}
