/* 
 * Client Portal Web API
 *
 * Client Poral Web API
 *
 * OpenAPI spec version: 1.0.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

/// Transactions : account transactions

#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct Transactions {
  /// same as request
  #[serde(rename = "currency")]
  currency: Option<String>,
  /// Period start date. Epoch time, GMT
  #[serde(rename = "from")]
  from: Option<f32>,
  /// will always be getTransactions
  #[serde(rename = "id")]
  id: Option<String>,
  /// Indicates whether current day and realtime data is included in the result
  #[serde(rename = "includesRealTime")]
  includes_real_time: Option<bool>,
  /// Period end date. Epoch time, GMT
  #[serde(rename = "to")]
  to: Option<f32>,
  /// Sorted by date descending
  #[serde(rename = "transactions")]
  transactions: Option<Vec<::models::TransactionsTransactions>>
}

impl Transactions {
  /// account transactions
  pub fn new() -> Transactions {
    Transactions {
      currency: None,
      from: None,
      id: None,
      includes_real_time: None,
      to: None,
      transactions: None
    }
  }

  pub fn set_currency(&mut self, currency: String) {
    self.currency = Some(currency);
  }

  pub fn with_currency(mut self, currency: String) -> Transactions {
    self.currency = Some(currency);
    self
  }

  pub fn currency(&self) -> Option<&String> {
    self.currency.as_ref()
  }

  pub fn reset_currency(&mut self) {
    self.currency = None;
  }

  pub fn set_from(&mut self, from: f32) {
    self.from = Some(from);
  }

  pub fn with_from(mut self, from: f32) -> Transactions {
    self.from = Some(from);
    self
  }

  pub fn from(&self) -> Option<&f32> {
    self.from.as_ref()
  }

  pub fn reset_from(&mut self) {
    self.from = None;
  }

  pub fn set_id(&mut self, id: String) {
    self.id = Some(id);
  }

  pub fn with_id(mut self, id: String) -> Transactions {
    self.id = Some(id);
    self
  }

  pub fn id(&self) -> Option<&String> {
    self.id.as_ref()
  }

  pub fn reset_id(&mut self) {
    self.id = None;
  }

  pub fn set_includes_real_time(&mut self, includes_real_time: bool) {
    self.includes_real_time = Some(includes_real_time);
  }

  pub fn with_includes_real_time(mut self, includes_real_time: bool) -> Transactions {
    self.includes_real_time = Some(includes_real_time);
    self
  }

  pub fn includes_real_time(&self) -> Option<&bool> {
    self.includes_real_time.as_ref()
  }

  pub fn reset_includes_real_time(&mut self) {
    self.includes_real_time = None;
  }

  pub fn set_to(&mut self, to: f32) {
    self.to = Some(to);
  }

  pub fn with_to(mut self, to: f32) -> Transactions {
    self.to = Some(to);
    self
  }

  pub fn to(&self) -> Option<&f32> {
    self.to.as_ref()
  }

  pub fn reset_to(&mut self) {
    self.to = None;
  }

  pub fn set_transactions(&mut self, transactions: Vec<::models::TransactionsTransactions>) {
    self.transactions = Some(transactions);
  }

  pub fn with_transactions(mut self, transactions: Vec<::models::TransactionsTransactions>) -> Transactions {
    self.transactions = Some(transactions);
    self
  }

  pub fn transactions(&self) -> Option<&Vec<::models::TransactionsTransactions>> {
    self.transactions.as_ref()
  }

  pub fn reset_transactions(&mut self) {
    self.transactions = None;
  }

}



