/* 
 * Client Portal Web API
 *
 * Client Poral Web API
 *
 * OpenAPI spec version: 1.0.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct Trade {
  /// accountCode
  #[serde(rename = "account")]
  account: Option<String>,
  /// Account Number
  #[serde(rename = "acountCode")]
  acount_code: Option<String>,
  /// Firm which will settle the trade. For IBExecution customers only.
  #[serde(rename = "clearing_id")]
  clearing_id: Option<String>,
  /// Specifies the true beneficiary of the order. For IBExecution customers only.
  #[serde(rename = "clearing_name")]
  clearing_name: Option<String>,
  /// Commission of the order
  #[serde(rename = "commission")]
  commission: Option<f32>,
  /// Contracts company name
  #[serde(rename = "company_name")]
  company_name: Option<String>,
  /// IBKR's contract identifier
  #[serde(rename = "conid")]
  conid: Option<String>,
  /// conid and exchange. Format supports conid or conid@exchange
  #[serde(rename = "conidex")]
  conidex: Option<String>,
  /// Format contract name
  #[serde(rename = "contract_description_1")]
  contract_description_1: Option<String>,
  /// Exchange or venue of order
  #[serde(rename = "exchange")]
  exchange: Option<String>,
  /// execution identifier for the order
  #[serde(rename = "execution_id")]
  execution_id: Option<String>,
  /// If order adds liquidity to the market.
  #[serde(rename = "liquidation_trade")]
  liquidation_trade: Option<f32>,
  /// Net cost of the order, including contract multiplier and quantity.
  #[serde(rename = "net_amount")]
  net_amount: Option<f32>,
  /// Formatted description of the order \"%side% %size% @ %price% on %exchange%\".
  #[serde(rename = "order_description")]
  order_description: Option<String>,
  /// User defined string used to identify the order. Value is set using \"cOID\" field while placing an order.
  #[serde(rename = "order_ref")]
  order_ref: Option<String>,
  /// Total quantity owned for this contract
  #[serde(rename = "position")]
  position: Option<String>,
  /// Average Price
  #[serde(rename = "price")]
  price: Option<String>,
  /// Asset class
  #[serde(rename = "sec_type")]
  sec_type: Option<String>,
  /// The side of the market of the order.   * B - Buy contract near posted ask price   * S - Sell contract near posted bid price   * X - Option expired 
  #[serde(rename = "side")]
  side: Option<String>,
  /// Quantity of the order
  #[serde(rename = "size")]
  size: Option<String>,
  /// User that submitted order
  #[serde(rename = "submitter")]
  submitter: Option<String>,
  /// Underlying Symbol
  #[serde(rename = "symbol")]
  symbol: Option<String>,
  /// Time of Status update in format \"YYYYMMDD-hh:mm:ss\".
  #[serde(rename = "trade_time")]
  trade_time: Option<String>,
  /// Time of status update in format unix time.
  #[serde(rename = "trade_time_r")]
  trade_time_r: Option<f32>
}

impl Trade {
  pub fn new() -> Trade {
    Trade {
      account: None,
      acount_code: None,
      clearing_id: None,
      clearing_name: None,
      commission: None,
      company_name: None,
      conid: None,
      conidex: None,
      contract_description_1: None,
      exchange: None,
      execution_id: None,
      liquidation_trade: None,
      net_amount: None,
      order_description: None,
      order_ref: None,
      position: None,
      price: None,
      sec_type: None,
      side: None,
      size: None,
      submitter: None,
      symbol: None,
      trade_time: None,
      trade_time_r: None
    }
  }

  pub fn set_account(&mut self, account: String) {
    self.account = Some(account);
  }

  pub fn with_account(mut self, account: String) -> Trade {
    self.account = Some(account);
    self
  }

  pub fn account(&self) -> Option<&String> {
    self.account.as_ref()
  }

  pub fn reset_account(&mut self) {
    self.account = None;
  }

  pub fn set_acount_code(&mut self, acount_code: String) {
    self.acount_code = Some(acount_code);
  }

  pub fn with_acount_code(mut self, acount_code: String) -> Trade {
    self.acount_code = Some(acount_code);
    self
  }

  pub fn acount_code(&self) -> Option<&String> {
    self.acount_code.as_ref()
  }

  pub fn reset_acount_code(&mut self) {
    self.acount_code = None;
  }

  pub fn set_clearing_id(&mut self, clearing_id: String) {
    self.clearing_id = Some(clearing_id);
  }

  pub fn with_clearing_id(mut self, clearing_id: String) -> Trade {
    self.clearing_id = Some(clearing_id);
    self
  }

  pub fn clearing_id(&self) -> Option<&String> {
    self.clearing_id.as_ref()
  }

  pub fn reset_clearing_id(&mut self) {
    self.clearing_id = None;
  }

  pub fn set_clearing_name(&mut self, clearing_name: String) {
    self.clearing_name = Some(clearing_name);
  }

  pub fn with_clearing_name(mut self, clearing_name: String) -> Trade {
    self.clearing_name = Some(clearing_name);
    self
  }

  pub fn clearing_name(&self) -> Option<&String> {
    self.clearing_name.as_ref()
  }

  pub fn reset_clearing_name(&mut self) {
    self.clearing_name = None;
  }

  pub fn set_commission(&mut self, commission: f32) {
    self.commission = Some(commission);
  }

  pub fn with_commission(mut self, commission: f32) -> Trade {
    self.commission = Some(commission);
    self
  }

  pub fn commission(&self) -> Option<&f32> {
    self.commission.as_ref()
  }

  pub fn reset_commission(&mut self) {
    self.commission = None;
  }

  pub fn set_company_name(&mut self, company_name: String) {
    self.company_name = Some(company_name);
  }

  pub fn with_company_name(mut self, company_name: String) -> Trade {
    self.company_name = Some(company_name);
    self
  }

  pub fn company_name(&self) -> Option<&String> {
    self.company_name.as_ref()
  }

  pub fn reset_company_name(&mut self) {
    self.company_name = None;
  }

  pub fn set_conid(&mut self, conid: String) {
    self.conid = Some(conid);
  }

  pub fn with_conid(mut self, conid: String) -> Trade {
    self.conid = Some(conid);
    self
  }

  pub fn conid(&self) -> Option<&String> {
    self.conid.as_ref()
  }

  pub fn reset_conid(&mut self) {
    self.conid = None;
  }

  pub fn set_conidex(&mut self, conidex: String) {
    self.conidex = Some(conidex);
  }

  pub fn with_conidex(mut self, conidex: String) -> Trade {
    self.conidex = Some(conidex);
    self
  }

  pub fn conidex(&self) -> Option<&String> {
    self.conidex.as_ref()
  }

  pub fn reset_conidex(&mut self) {
    self.conidex = None;
  }

  pub fn set_contract_description_1(&mut self, contract_description_1: String) {
    self.contract_description_1 = Some(contract_description_1);
  }

  pub fn with_contract_description_1(mut self, contract_description_1: String) -> Trade {
    self.contract_description_1 = Some(contract_description_1);
    self
  }

  pub fn contract_description_1(&self) -> Option<&String> {
    self.contract_description_1.as_ref()
  }

  pub fn reset_contract_description_1(&mut self) {
    self.contract_description_1 = None;
  }

  pub fn set_exchange(&mut self, exchange: String) {
    self.exchange = Some(exchange);
  }

  pub fn with_exchange(mut self, exchange: String) -> Trade {
    self.exchange = Some(exchange);
    self
  }

  pub fn exchange(&self) -> Option<&String> {
    self.exchange.as_ref()
  }

  pub fn reset_exchange(&mut self) {
    self.exchange = None;
  }

  pub fn set_execution_id(&mut self, execution_id: String) {
    self.execution_id = Some(execution_id);
  }

  pub fn with_execution_id(mut self, execution_id: String) -> Trade {
    self.execution_id = Some(execution_id);
    self
  }

  pub fn execution_id(&self) -> Option<&String> {
    self.execution_id.as_ref()
  }

  pub fn reset_execution_id(&mut self) {
    self.execution_id = None;
  }

  pub fn set_liquidation_trade(&mut self, liquidation_trade: f32) {
    self.liquidation_trade = Some(liquidation_trade);
  }

  pub fn with_liquidation_trade(mut self, liquidation_trade: f32) -> Trade {
    self.liquidation_trade = Some(liquidation_trade);
    self
  }

  pub fn liquidation_trade(&self) -> Option<&f32> {
    self.liquidation_trade.as_ref()
  }

  pub fn reset_liquidation_trade(&mut self) {
    self.liquidation_trade = None;
  }

  pub fn set_net_amount(&mut self, net_amount: f32) {
    self.net_amount = Some(net_amount);
  }

  pub fn with_net_amount(mut self, net_amount: f32) -> Trade {
    self.net_amount = Some(net_amount);
    self
  }

  pub fn net_amount(&self) -> Option<&f32> {
    self.net_amount.as_ref()
  }

  pub fn reset_net_amount(&mut self) {
    self.net_amount = None;
  }

  pub fn set_order_description(&mut self, order_description: String) {
    self.order_description = Some(order_description);
  }

  pub fn with_order_description(mut self, order_description: String) -> Trade {
    self.order_description = Some(order_description);
    self
  }

  pub fn order_description(&self) -> Option<&String> {
    self.order_description.as_ref()
  }

  pub fn reset_order_description(&mut self) {
    self.order_description = None;
  }

  pub fn set_order_ref(&mut self, order_ref: String) {
    self.order_ref = Some(order_ref);
  }

  pub fn with_order_ref(mut self, order_ref: String) -> Trade {
    self.order_ref = Some(order_ref);
    self
  }

  pub fn order_ref(&self) -> Option<&String> {
    self.order_ref.as_ref()
  }

  pub fn reset_order_ref(&mut self) {
    self.order_ref = None;
  }

  pub fn set_position(&mut self, position: String) {
    self.position = Some(position);
  }

  pub fn with_position(mut self, position: String) -> Trade {
    self.position = Some(position);
    self
  }

  pub fn position(&self) -> Option<&String> {
    self.position.as_ref()
  }

  pub fn reset_position(&mut self) {
    self.position = None;
  }

  pub fn set_price(&mut self, price: String) {
    self.price = Some(price);
  }

  pub fn with_price(mut self, price: String) -> Trade {
    self.price = Some(price);
    self
  }

  pub fn price(&self) -> Option<&String> {
    self.price.as_ref()
  }

  pub fn reset_price(&mut self) {
    self.price = None;
  }

  pub fn set_sec_type(&mut self, sec_type: String) {
    self.sec_type = Some(sec_type);
  }

  pub fn with_sec_type(mut self, sec_type: String) -> Trade {
    self.sec_type = Some(sec_type);
    self
  }

  pub fn sec_type(&self) -> Option<&String> {
    self.sec_type.as_ref()
  }

  pub fn reset_sec_type(&mut self) {
    self.sec_type = None;
  }

  pub fn set_side(&mut self, side: String) {
    self.side = Some(side);
  }

  pub fn with_side(mut self, side: String) -> Trade {
    self.side = Some(side);
    self
  }

  pub fn side(&self) -> Option<&String> {
    self.side.as_ref()
  }

  pub fn reset_side(&mut self) {
    self.side = None;
  }

  pub fn set_size(&mut self, size: String) {
    self.size = Some(size);
  }

  pub fn with_size(mut self, size: String) -> Trade {
    self.size = Some(size);
    self
  }

  pub fn size(&self) -> Option<&String> {
    self.size.as_ref()
  }

  pub fn reset_size(&mut self) {
    self.size = None;
  }

  pub fn set_submitter(&mut self, submitter: String) {
    self.submitter = Some(submitter);
  }

  pub fn with_submitter(mut self, submitter: String) -> Trade {
    self.submitter = Some(submitter);
    self
  }

  pub fn submitter(&self) -> Option<&String> {
    self.submitter.as_ref()
  }

  pub fn reset_submitter(&mut self) {
    self.submitter = None;
  }

  pub fn set_symbol(&mut self, symbol: String) {
    self.symbol = Some(symbol);
  }

  pub fn with_symbol(mut self, symbol: String) -> Trade {
    self.symbol = Some(symbol);
    self
  }

  pub fn symbol(&self) -> Option<&String> {
    self.symbol.as_ref()
  }

  pub fn reset_symbol(&mut self) {
    self.symbol = None;
  }

  pub fn set_trade_time(&mut self, trade_time: String) {
    self.trade_time = Some(trade_time);
  }

  pub fn with_trade_time(mut self, trade_time: String) -> Trade {
    self.trade_time = Some(trade_time);
    self
  }

  pub fn trade_time(&self) -> Option<&String> {
    self.trade_time.as_ref()
  }

  pub fn reset_trade_time(&mut self) {
    self.trade_time = None;
  }

  pub fn set_trade_time_r(&mut self, trade_time_r: f32) {
    self.trade_time_r = Some(trade_time_r);
  }

  pub fn with_trade_time_r(mut self, trade_time_r: f32) -> Trade {
    self.trade_time_r = Some(trade_time_r);
    self
  }

  pub fn trade_time_r(&self) -> Option<&f32> {
    self.trade_time_r.as_ref()
  }

  pub fn reset_trade_time_r(&mut self) {
    self.trade_time_r = None;
  }

}



