/* 
 * Client Portal Web API
 *
 * Client Poral Web API
 *
 * OpenAPI spec version: 1.0.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

/// SecdefInner : security definition information.

#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct SecdefInner {
  /// List of exchanges and venues contract trades.
  #[serde(rename = "allExchanges")]
  all_exchanges: Option<String>,
  /// Group of financial instruments which have similar financial characteristics and behave similar in the marketplace.
  #[serde(rename = "assetClass")]
  asset_class: Option<String>,
  /// HTML encoded company description in Chinese.
  #[serde(rename = "chineseName")]
  chinese_name: Option<String>,
  /// IBKR contract identifier.
  #[serde(rename = "conid")]
  conid: Option<i32>,
  /// Defines if a derivative contract has a different currency.
  #[serde(rename = "crossCurrency")]
  cross_currency: Option<bool>,
  /// Currency contract trades in.
  #[serde(rename = "currency")]
  currency: Option<String>,
  /// Specific data contract expires.
  #[serde(rename = "expiry")]
  expiry: Option<String>,
  /// Formatted company name with underlying symbol, expiration, strike, right.
  #[serde(rename = "fullName")]
  full_name: Option<String>,
  /// Potential characteristic of each product.
  #[serde(rename = "group")]
  group: Option<String>,
  /// If contract has an option.
  #[serde(rename = "hasOptions")]
  has_options: Option<bool>,
  #[serde(rename = "incrementRules")]
  increment_rules: Option<::models::SecdefInnerIncrementRules>,
  /// If contract is a US contract. Currently supported for stocks, options and warrants.
  #[serde(rename = "isUS")]
  is_us: Option<bool>,
  /// Final day derivative contract can be traded before delivery of the underlying asset or cash settlement.
  #[serde(rename = "lastTradingDay")]
  last_trading_day: Option<String>,
  /// Main trading venue.
  #[serde(rename = "listingExchange")]
  listing_exchange: Option<String>,
  /// Multiplier for total premium paid or received for derivative contract.
  #[serde(rename = "multiplier")]
  multiplier: Option<i32>,
  /// Company Name.
  #[serde(rename = "name")]
  name: Option<String>,
  /// Defines the right to buy or sell of the underlying security.
  #[serde(rename = "putOrCall")]
  put_or_call: Option<String>,
  /// The category of the economy.
  #[serde(rename = "sector")]
  sector: Option<String>,
  /// Stock Group contract belongs too.
  #[serde(rename = "sectorGroup")]
  sector_group: Option<String>,
  /// Set price at which a derivative contract can be bought or sold.
  #[serde(rename = "strike")]
  strike: Option<f32>,
  /// Contract symbol.
  #[serde(rename = "ticker")]
  ticker: Option<String>,
  #[serde(rename = "time")]
  time: Option<i32>,
  /// Stock type.
  #[serde(rename = "type")]
  _type: Option<String>,
  /// Company name for underlying contract.
  #[serde(rename = "undComp")]
  und_comp: Option<String>,
  /// Underlying contract identifier.
  #[serde(rename = "undConid")]
  und_conid: Option<i32>,
  /// IBKR Symbol for underlying contract.
  #[serde(rename = "undSym")]
  und_sym: Option<String>
}

impl SecdefInner {
  /// security definition information.
  pub fn new() -> SecdefInner {
    SecdefInner {
      all_exchanges: None,
      asset_class: None,
      chinese_name: None,
      conid: None,
      cross_currency: None,
      currency: None,
      expiry: None,
      full_name: None,
      group: None,
      has_options: None,
      increment_rules: None,
      is_us: None,
      last_trading_day: None,
      listing_exchange: None,
      multiplier: None,
      name: None,
      put_or_call: None,
      sector: None,
      sector_group: None,
      strike: None,
      ticker: None,
      time: None,
      _type: None,
      und_comp: None,
      und_conid: None,
      und_sym: None
    }
  }

  pub fn set_all_exchanges(&mut self, all_exchanges: String) {
    self.all_exchanges = Some(all_exchanges);
  }

  pub fn with_all_exchanges(mut self, all_exchanges: String) -> SecdefInner {
    self.all_exchanges = Some(all_exchanges);
    self
  }

  pub fn all_exchanges(&self) -> Option<&String> {
    self.all_exchanges.as_ref()
  }

  pub fn reset_all_exchanges(&mut self) {
    self.all_exchanges = None;
  }

  pub fn set_asset_class(&mut self, asset_class: String) {
    self.asset_class = Some(asset_class);
  }

  pub fn with_asset_class(mut self, asset_class: String) -> SecdefInner {
    self.asset_class = Some(asset_class);
    self
  }

  pub fn asset_class(&self) -> Option<&String> {
    self.asset_class.as_ref()
  }

  pub fn reset_asset_class(&mut self) {
    self.asset_class = None;
  }

  pub fn set_chinese_name(&mut self, chinese_name: String) {
    self.chinese_name = Some(chinese_name);
  }

  pub fn with_chinese_name(mut self, chinese_name: String) -> SecdefInner {
    self.chinese_name = Some(chinese_name);
    self
  }

  pub fn chinese_name(&self) -> Option<&String> {
    self.chinese_name.as_ref()
  }

  pub fn reset_chinese_name(&mut self) {
    self.chinese_name = None;
  }

  pub fn set_conid(&mut self, conid: i32) {
    self.conid = Some(conid);
  }

  pub fn with_conid(mut self, conid: i32) -> SecdefInner {
    self.conid = Some(conid);
    self
  }

  pub fn conid(&self) -> Option<&i32> {
    self.conid.as_ref()
  }

  pub fn reset_conid(&mut self) {
    self.conid = None;
  }

  pub fn set_cross_currency(&mut self, cross_currency: bool) {
    self.cross_currency = Some(cross_currency);
  }

  pub fn with_cross_currency(mut self, cross_currency: bool) -> SecdefInner {
    self.cross_currency = Some(cross_currency);
    self
  }

  pub fn cross_currency(&self) -> Option<&bool> {
    self.cross_currency.as_ref()
  }

  pub fn reset_cross_currency(&mut self) {
    self.cross_currency = None;
  }

  pub fn set_currency(&mut self, currency: String) {
    self.currency = Some(currency);
  }

  pub fn with_currency(mut self, currency: String) -> SecdefInner {
    self.currency = Some(currency);
    self
  }

  pub fn currency(&self) -> Option<&String> {
    self.currency.as_ref()
  }

  pub fn reset_currency(&mut self) {
    self.currency = None;
  }

  pub fn set_expiry(&mut self, expiry: String) {
    self.expiry = Some(expiry);
  }

  pub fn with_expiry(mut self, expiry: String) -> SecdefInner {
    self.expiry = Some(expiry);
    self
  }

  pub fn expiry(&self) -> Option<&String> {
    self.expiry.as_ref()
  }

  pub fn reset_expiry(&mut self) {
    self.expiry = None;
  }

  pub fn set_full_name(&mut self, full_name: String) {
    self.full_name = Some(full_name);
  }

  pub fn with_full_name(mut self, full_name: String) -> SecdefInner {
    self.full_name = Some(full_name);
    self
  }

  pub fn full_name(&self) -> Option<&String> {
    self.full_name.as_ref()
  }

  pub fn reset_full_name(&mut self) {
    self.full_name = None;
  }

  pub fn set_group(&mut self, group: String) {
    self.group = Some(group);
  }

  pub fn with_group(mut self, group: String) -> SecdefInner {
    self.group = Some(group);
    self
  }

  pub fn group(&self) -> Option<&String> {
    self.group.as_ref()
  }

  pub fn reset_group(&mut self) {
    self.group = None;
  }

  pub fn set_has_options(&mut self, has_options: bool) {
    self.has_options = Some(has_options);
  }

  pub fn with_has_options(mut self, has_options: bool) -> SecdefInner {
    self.has_options = Some(has_options);
    self
  }

  pub fn has_options(&self) -> Option<&bool> {
    self.has_options.as_ref()
  }

  pub fn reset_has_options(&mut self) {
    self.has_options = None;
  }

  pub fn set_increment_rules(&mut self, increment_rules: ::models::SecdefInnerIncrementRules) {
    self.increment_rules = Some(increment_rules);
  }

  pub fn with_increment_rules(mut self, increment_rules: ::models::SecdefInnerIncrementRules) -> SecdefInner {
    self.increment_rules = Some(increment_rules);
    self
  }

  pub fn increment_rules(&self) -> Option<&::models::SecdefInnerIncrementRules> {
    self.increment_rules.as_ref()
  }

  pub fn reset_increment_rules(&mut self) {
    self.increment_rules = None;
  }

  pub fn set_is_us(&mut self, is_us: bool) {
    self.is_us = Some(is_us);
  }

  pub fn with_is_us(mut self, is_us: bool) -> SecdefInner {
    self.is_us = Some(is_us);
    self
  }

  pub fn is_us(&self) -> Option<&bool> {
    self.is_us.as_ref()
  }

  pub fn reset_is_us(&mut self) {
    self.is_us = None;
  }

  pub fn set_last_trading_day(&mut self, last_trading_day: String) {
    self.last_trading_day = Some(last_trading_day);
  }

  pub fn with_last_trading_day(mut self, last_trading_day: String) -> SecdefInner {
    self.last_trading_day = Some(last_trading_day);
    self
  }

  pub fn last_trading_day(&self) -> Option<&String> {
    self.last_trading_day.as_ref()
  }

  pub fn reset_last_trading_day(&mut self) {
    self.last_trading_day = None;
  }

  pub fn set_listing_exchange(&mut self, listing_exchange: String) {
    self.listing_exchange = Some(listing_exchange);
  }

  pub fn with_listing_exchange(mut self, listing_exchange: String) -> SecdefInner {
    self.listing_exchange = Some(listing_exchange);
    self
  }

  pub fn listing_exchange(&self) -> Option<&String> {
    self.listing_exchange.as_ref()
  }

  pub fn reset_listing_exchange(&mut self) {
    self.listing_exchange = None;
  }

  pub fn set_multiplier(&mut self, multiplier: i32) {
    self.multiplier = Some(multiplier);
  }

  pub fn with_multiplier(mut self, multiplier: i32) -> SecdefInner {
    self.multiplier = Some(multiplier);
    self
  }

  pub fn multiplier(&self) -> Option<&i32> {
    self.multiplier.as_ref()
  }

  pub fn reset_multiplier(&mut self) {
    self.multiplier = None;
  }

  pub fn set_name(&mut self, name: String) {
    self.name = Some(name);
  }

  pub fn with_name(mut self, name: String) -> SecdefInner {
    self.name = Some(name);
    self
  }

  pub fn name(&self) -> Option<&String> {
    self.name.as_ref()
  }

  pub fn reset_name(&mut self) {
    self.name = None;
  }

  pub fn set_put_or_call(&mut self, put_or_call: String) {
    self.put_or_call = Some(put_or_call);
  }

  pub fn with_put_or_call(mut self, put_or_call: String) -> SecdefInner {
    self.put_or_call = Some(put_or_call);
    self
  }

  pub fn put_or_call(&self) -> Option<&String> {
    self.put_or_call.as_ref()
  }

  pub fn reset_put_or_call(&mut self) {
    self.put_or_call = None;
  }

  pub fn set_sector(&mut self, sector: String) {
    self.sector = Some(sector);
  }

  pub fn with_sector(mut self, sector: String) -> SecdefInner {
    self.sector = Some(sector);
    self
  }

  pub fn sector(&self) -> Option<&String> {
    self.sector.as_ref()
  }

  pub fn reset_sector(&mut self) {
    self.sector = None;
  }

  pub fn set_sector_group(&mut self, sector_group: String) {
    self.sector_group = Some(sector_group);
  }

  pub fn with_sector_group(mut self, sector_group: String) -> SecdefInner {
    self.sector_group = Some(sector_group);
    self
  }

  pub fn sector_group(&self) -> Option<&String> {
    self.sector_group.as_ref()
  }

  pub fn reset_sector_group(&mut self) {
    self.sector_group = None;
  }

  pub fn set_strike(&mut self, strike: f32) {
    self.strike = Some(strike);
  }

  pub fn with_strike(mut self, strike: f32) -> SecdefInner {
    self.strike = Some(strike);
    self
  }

  pub fn strike(&self) -> Option<&f32> {
    self.strike.as_ref()
  }

  pub fn reset_strike(&mut self) {
    self.strike = None;
  }

  pub fn set_ticker(&mut self, ticker: String) {
    self.ticker = Some(ticker);
  }

  pub fn with_ticker(mut self, ticker: String) -> SecdefInner {
    self.ticker = Some(ticker);
    self
  }

  pub fn ticker(&self) -> Option<&String> {
    self.ticker.as_ref()
  }

  pub fn reset_ticker(&mut self) {
    self.ticker = None;
  }

  pub fn set_time(&mut self, time: i32) {
    self.time = Some(time);
  }

  pub fn with_time(mut self, time: i32) -> SecdefInner {
    self.time = Some(time);
    self
  }

  pub fn time(&self) -> Option<&i32> {
    self.time.as_ref()
  }

  pub fn reset_time(&mut self) {
    self.time = None;
  }

  pub fn set__type(&mut self, _type: String) {
    self._type = Some(_type);
  }

  pub fn with__type(mut self, _type: String) -> SecdefInner {
    self._type = Some(_type);
    self
  }

  pub fn _type(&self) -> Option<&String> {
    self._type.as_ref()
  }

  pub fn reset__type(&mut self) {
    self._type = None;
  }

  pub fn set_und_comp(&mut self, und_comp: String) {
    self.und_comp = Some(und_comp);
  }

  pub fn with_und_comp(mut self, und_comp: String) -> SecdefInner {
    self.und_comp = Some(und_comp);
    self
  }

  pub fn und_comp(&self) -> Option<&String> {
    self.und_comp.as_ref()
  }

  pub fn reset_und_comp(&mut self) {
    self.und_comp = None;
  }

  pub fn set_und_conid(&mut self, und_conid: i32) {
    self.und_conid = Some(und_conid);
  }

  pub fn with_und_conid(mut self, und_conid: i32) -> SecdefInner {
    self.und_conid = Some(und_conid);
    self
  }

  pub fn und_conid(&self) -> Option<&i32> {
    self.und_conid.as_ref()
  }

  pub fn reset_und_conid(&mut self) {
    self.und_conid = None;
  }

  pub fn set_und_sym(&mut self, und_sym: String) {
    self.und_sym = Some(und_sym);
  }

  pub fn with_und_sym(mut self, und_sym: String) -> SecdefInner {
    self.und_sym = Some(und_sym);
    self
  }

  pub fn und_sym(&self) -> Option<&String> {
    self.und_sym.as_ref()
  }

  pub fn reset_und_sym(&mut self) {
    self.und_sym = None;
  }

}



