/* 
 * Client Portal Web API
 *
 * Client Poral Web API
 *
 * OpenAPI spec version: 1.0.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct AccountParent {
  /// Account Number for Money Manager Client
  #[serde(rename = "accountId")]
  account_id: Option<String>,
  /// Is MM a Child Account
  #[serde(rename = "isMChild")]
  is_m_child: Option<bool>,
  /// Is MM a Parent Account
  #[serde(rename = "isMParent")]
  is_m_parent: Option<bool>,
  /// Is a Multiplex Account. These are account models with individual account being parent and managed account being child.
  #[serde(rename = "isMultiplex")]
  is_multiplex: Option<bool>,
  #[serde(rename = "mmc")]
  mmc: Option<Vec<String>>
}

impl AccountParent {
  pub fn new() -> AccountParent {
    AccountParent {
      account_id: None,
      is_m_child: None,
      is_m_parent: None,
      is_multiplex: None,
      mmc: None
    }
  }

  pub fn set_account_id(&mut self, account_id: String) {
    self.account_id = Some(account_id);
  }

  pub fn with_account_id(mut self, account_id: String) -> AccountParent {
    self.account_id = Some(account_id);
    self
  }

  pub fn account_id(&self) -> Option<&String> {
    self.account_id.as_ref()
  }

  pub fn reset_account_id(&mut self) {
    self.account_id = None;
  }

  pub fn set_is_m_child(&mut self, is_m_child: bool) {
    self.is_m_child = Some(is_m_child);
  }

  pub fn with_is_m_child(mut self, is_m_child: bool) -> AccountParent {
    self.is_m_child = Some(is_m_child);
    self
  }

  pub fn is_m_child(&self) -> Option<&bool> {
    self.is_m_child.as_ref()
  }

  pub fn reset_is_m_child(&mut self) {
    self.is_m_child = None;
  }

  pub fn set_is_m_parent(&mut self, is_m_parent: bool) {
    self.is_m_parent = Some(is_m_parent);
  }

  pub fn with_is_m_parent(mut self, is_m_parent: bool) -> AccountParent {
    self.is_m_parent = Some(is_m_parent);
    self
  }

  pub fn is_m_parent(&self) -> Option<&bool> {
    self.is_m_parent.as_ref()
  }

  pub fn reset_is_m_parent(&mut self) {
    self.is_m_parent = None;
  }

  pub fn set_is_multiplex(&mut self, is_multiplex: bool) {
    self.is_multiplex = Some(is_multiplex);
  }

  pub fn with_is_multiplex(mut self, is_multiplex: bool) -> AccountParent {
    self.is_multiplex = Some(is_multiplex);
    self
  }

  pub fn is_multiplex(&self) -> Option<&bool> {
    self.is_multiplex.as_ref()
  }

  pub fn reset_is_multiplex(&mut self) {
    self.is_multiplex = None;
  }

  pub fn set_mmc(&mut self, mmc: Vec<String>) {
    self.mmc = Some(mmc);
  }

  pub fn with_mmc(mut self, mmc: Vec<String>) -> AccountParent {
    self.mmc = Some(mmc);
    self
  }

  pub fn mmc(&self) -> Option<&Vec<String>> {
    self.mmc.as_ref()
  }

  pub fn reset_mmc(&mut self) {
    self.mmc = None;
  }

}



