# Rust API client for swagger

Client Poral Web API

## Overview
This API client was generated by the [swagger-codegen](https://github.com/swagger-api/swagger-codegen) project.  By using the [swagger-spec](https://github.com/swagger-api/swagger-spec) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.RustClientCodegen

## Installation
Put the package under your project folder and add the following in import:
```
    "./swagger"
```

## Documentation for API Endpoints

All URIs are relative to *https://localhost:5000/v1/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**iserver_account_pnl_partitioned_get**](docs/AccountApi.md#iserver_account_pnl_partitioned_get) | **Get** /iserver/account/pnl/partitioned | PnL for the selected account
*AccountApi* | [**iserver_account_post**](docs/AccountApi.md#iserver_account_post) | **Post** /iserver/account | Switch Account
*AccountApi* | [**iserver_accounts_get**](docs/AccountApi.md#iserver_accounts_get) | **Get** /iserver/accounts | Brokerage Accounts
*AccountApi* | [**portfolio_account_id_ledger_get**](docs/AccountApi.md#portfolio_account_id_ledger_get) | **Get** /portfolio/{accountId}/ledger | Account Ledger
*AccountApi* | [**portfolio_account_id_meta_get**](docs/AccountApi.md#portfolio_account_id_meta_get) | **Get** /portfolio/{accountId}/meta | Account Information
*AccountApi* | [**portfolio_account_id_summary_get**](docs/AccountApi.md#portfolio_account_id_summary_get) | **Get** /portfolio/{accountId}/summary | Account Summary
*AccountApi* | [**portfolio_accounts_get**](docs/AccountApi.md#portfolio_accounts_get) | **Get** /portfolio/accounts | Portfolio Accounts
*AccountApi* | [**portfolio_subaccounts_get**](docs/AccountApi.md#portfolio_subaccounts_get) | **Get** /portfolio/subaccounts | List of Sub-Accounts
*AlertApi* | [**iserver_account_account_id_alert_post**](docs/AlertApi.md#iserver_account_account_id_alert_post) | **Post** /iserver/account/{accountId}/alert | Create or modify alert
*AlertApi* | [**iserver_account_alertid_get**](docs/AlertApi.md#iserver_account_alertid_get) | **Get** /iserver/account/alert/:id | Get details of an alert
*AlertApi* | [**iserver_account_mta_get**](docs/AlertApi.md#iserver_account_mta_get) | **Get** /iserver/account/mta | Get MTA alert
*AlertApi* | [**iserver_accountaccount_id_alert_activate_post**](docs/AlertApi.md#iserver_accountaccount_id_alert_activate_post) | **Post** /iserver/account/:accountId/alert/activate | Activate or deactivate an alert
*AlertApi* | [**iserver_accountaccount_id_alertalert_id_delete**](docs/AlertApi.md#iserver_accountaccount_id_alertalert_id_delete) | **Delete** /iserver/account/:accountId/alert/:alertId | Delete an alert
*AlertApi* | [**iserver_accountaccount_id_alerts_get**](docs/AlertApi.md#iserver_accountaccount_id_alerts_get) | **Get** /iserver/account/:accountId/alerts | Get a list of available alerts
*CCPBetaApi* | [**ccp_account_get**](docs/CCPBetaApi.md#ccp_account_get) | **Get** /ccp/account | Brokerage Accounts
*CCPBetaApi* | [**ccp_auth_init_post**](docs/CCPBetaApi.md#ccp_auth_init_post) | **Post** /ccp/auth/init | Start CCP Session
*CCPBetaApi* | [**ccp_auth_response_post**](docs/CCPBetaApi.md#ccp_auth_response_post) | **Post** /ccp/auth/response | Complete CCP Session
*CCPBetaApi* | [**ccp_order_delete**](docs/CCPBetaApi.md#ccp_order_delete) | **Delete** /ccp/order | Delete Order
*CCPBetaApi* | [**ccp_order_post**](docs/CCPBetaApi.md#ccp_order_post) | **Post** /ccp/order | Submit Order
*CCPBetaApi* | [**ccp_order_put**](docs/CCPBetaApi.md#ccp_order_put) | **Put** /ccp/order | Update Order
*CCPBetaApi* | [**ccp_orders_get**](docs/CCPBetaApi.md#ccp_orders_get) | **Get** /ccp/orders | Order Status
*CCPBetaApi* | [**ccp_positions_get**](docs/CCPBetaApi.md#ccp_positions_get) | **Get** /ccp/positions | Positions
*CCPBetaApi* | [**ccp_status_get**](docs/CCPBetaApi.md#ccp_status_get) | **Get** /ccp/status | CCP Status
*CCPBetaApi* | [**ccp_trades_get**](docs/CCPBetaApi.md#ccp_trades_get) | **Get** /ccp/trades | Trades
*ContractApi* | [**iserver_contract_conid_algos_get**](docs/ContractApi.md#iserver_contract_conid_algos_get) | **Get** /iserver/contract/{conid}/algos | IB Algo Params
*ContractApi* | [**iserver_contract_conid_info_and_rules_get**](docs/ContractApi.md#iserver_contract_conid_info_and_rules_get) | **Get** /iserver/contract/{conid}/info-and-rules | Info and Rules
*ContractApi* | [**iserver_contract_conid_info_get**](docs/ContractApi.md#iserver_contract_conid_info_get) | **Get** /iserver/contract/{conid}/info | Contract Details
*ContractApi* | [**iserver_secdef_info_get**](docs/ContractApi.md#iserver_secdef_info_get) | **Get** /iserver/secdef/info | Secdef Info
*ContractApi* | [**iserver_secdef_search_post**](docs/ContractApi.md#iserver_secdef_search_post) | **Post** /iserver/secdef/search | Search by Symbol or Name
*ContractApi* | [**iserver_secdef_strikes_get**](docs/ContractApi.md#iserver_secdef_strikes_get) | **Get** /iserver/secdef/strikes | Search Strikes
*ContractApi* | [**trsrv_futures_get**](docs/ContractApi.md#trsrv_futures_get) | **Get** /trsrv/futures | Security Futures by Symbol
*ContractApi* | [**trsrv_secdef_post**](docs/ContractApi.md#trsrv_secdef_post) | **Post** /trsrv/secdef | Secdef by Conid
*ContractApi* | [**trsrv_secdef_schedule_get**](docs/ContractApi.md#trsrv_secdef_schedule_get) | **Get** /trsrv/secdef/schedule | Get trading schedule for symbol
*ContractApi* | [**trsrv_stocks_get**](docs/ContractApi.md#trsrv_stocks_get) | **Get** /trsrv/stocks | Security Stocks by Symbol
*FYIApi* | [**fyi_deliveryoptions_device_id_delete**](docs/FYIApi.md#fyi_deliveryoptions_device_id_delete) | **Delete** /fyi/deliveryoptions/{deviceId} | Delete a device
*FYIApi* | [**fyi_deliveryoptions_device_post**](docs/FYIApi.md#fyi_deliveryoptions_device_post) | **Post** /fyi/deliveryoptions/device | Enable/Disable device option
*FYIApi* | [**fyi_deliveryoptions_email_put**](docs/FYIApi.md#fyi_deliveryoptions_email_put) | **Put** /fyi/deliveryoptions/email | Enable/Disable email option
*FYIApi* | [**fyi_deliveryoptions_get**](docs/FYIApi.md#fyi_deliveryoptions_get) | **Get** /fyi/deliveryoptions | Get delivery options
*FYIApi* | [**fyi_disclaimer_typecode_get**](docs/FYIApi.md#fyi_disclaimer_typecode_get) | **Get** /fyi/disclaimer/{typecode} | Get disclaimer for a certain kind of fyi
*FYIApi* | [**fyi_disclaimer_typecode_put**](docs/FYIApi.md#fyi_disclaimer_typecode_put) | **Put** /fyi/disclaimer/{typecode} | Mark disclaimer read
*FYIApi* | [**fyi_notifications_get**](docs/FYIApi.md#fyi_notifications_get) | **Get** /fyi/notifications | Get a list of notifications
*FYIApi* | [**fyi_notifications_more_get**](docs/FYIApi.md#fyi_notifications_more_get) | **Get** /fyi/notifications/more | Get more notifications based on a certain one
*FYIApi* | [**fyi_notifications_notification_id_put**](docs/FYIApi.md#fyi_notifications_notification_id_put) | **Put** /fyi/notifications/{notificationId} | Get a list of notifications
*FYIApi* | [**fyi_settings_get**](docs/FYIApi.md#fyi_settings_get) | **Get** /fyi/settings | Get a list of subscriptions
*FYIApi* | [**fyi_settings_typecode_post**](docs/FYIApi.md#fyi_settings_typecode_post) | **Post** /fyi/settings/{typecode} | Enable/Disable certain subscription
*FYIApi* | [**fyi_unreadnumber_get**](docs/FYIApi.md#fyi_unreadnumber_get) | **Get** /fyi/unreadnumber | Get unread number of fyis. The HTTP method POST is also supported.
*IBCustApi* | [**ibcust_entity_info_get**](docs/IBCustApi.md#ibcust_entity_info_get) | **Get** /ibcust/entity/info | IBCust Entity Info
*MarketDataApi* | [**iserver_marketdata_conid_unsubscribe_get**](docs/MarketDataApi.md#iserver_marketdata_conid_unsubscribe_get) | **Get** /iserver/marketdata/{conid}/unsubscribe | Market Data Cancel (Single)
*MarketDataApi* | [**iserver_marketdata_history_get**](docs/MarketDataApi.md#iserver_marketdata_history_get) | **Get** /iserver/marketdata/history | Market Data History
*MarketDataApi* | [**iserver_marketdata_snapshot_get**](docs/MarketDataApi.md#iserver_marketdata_snapshot_get) | **Get** /iserver/marketdata/snapshot | Market Data
*MarketDataApi* | [**iserver_marketdata_unsubscribeall_get**](docs/MarketDataApi.md#iserver_marketdata_unsubscribeall_get) | **Get** /iserver/marketdata/unsubscribeall | Market Data Cancel (All)
*OrderApi* | [**iserver_account_account_id_order_order_id_delete**](docs/OrderApi.md#iserver_account_account_id_order_order_id_delete) | **Delete** /iserver/account/{accountId}/order/{orderId} | Cancel Order
*OrderApi* | [**iserver_account_account_id_order_order_id_post**](docs/OrderApi.md#iserver_account_account_id_order_order_id_post) | **Post** /iserver/account/{accountId}/order/{orderId} | Modify Order
*OrderApi* | [**iserver_account_account_id_order_post**](docs/OrderApi.md#iserver_account_account_id_order_post) | **Post** /iserver/account/{accountId}/order | Place Order (Deprecated)
*OrderApi* | [**iserver_account_account_id_order_whatif_post**](docs/OrderApi.md#iserver_account_account_id_order_whatif_post) | **Post** /iserver/account/{accountId}/order/whatif | Preview Order (Deprecated)
*OrderApi* | [**iserver_account_account_id_orders_post**](docs/OrderApi.md#iserver_account_account_id_orders_post) | **Post** /iserver/account/{accountId}/orders | Place Orders
*OrderApi* | [**iserver_account_account_id_orders_whatif_post**](docs/OrderApi.md#iserver_account_account_id_orders_whatif_post) | **Post** /iserver/account/{accountId}/orders/whatif | Preview Orders
*OrderApi* | [**iserver_account_order_status_order_id_get**](docs/OrderApi.md#iserver_account_order_status_order_id_get) | **Get** /iserver/account/order/status/{orderId} | Order Status
*OrderApi* | [**iserver_account_orders_fa_group_post**](docs/OrderApi.md#iserver_account_orders_fa_group_post) | **Post** /iserver/account/orders/{faGroup} | Place Orders for FA
*OrderApi* | [**iserver_account_orders_get**](docs/OrderApi.md#iserver_account_orders_get) | **Get** /iserver/account/orders | Live Orders
*OrderApi* | [**iserver_reply_replyid_post**](docs/OrderApi.md#iserver_reply_replyid_post) | **Post** /iserver/reply/{replyid} | Place Order Reply
*PnLApi* | [**iserver_account_pnl_partitioned_get**](docs/PnLApi.md#iserver_account_pnl_partitioned_get) | **Get** /iserver/account/pnl/partitioned | PnL for the selected account
*PortfolioApi* | [**portfolio_account_id_allocation_get**](docs/PortfolioApi.md#portfolio_account_id_allocation_get) | **Get** /portfolio/{accountId}/allocation | Account Allocation
*PortfolioApi* | [**portfolio_account_id_ledger_get**](docs/PortfolioApi.md#portfolio_account_id_ledger_get) | **Get** /portfolio/{accountId}/ledger | Account Ledger
*PortfolioApi* | [**portfolio_account_id_meta_get**](docs/PortfolioApi.md#portfolio_account_id_meta_get) | **Get** /portfolio/{accountId}/meta | Account Information
*PortfolioApi* | [**portfolio_account_id_position_conid_get**](docs/PortfolioApi.md#portfolio_account_id_position_conid_get) | **Get** /portfolio/{accountId}/position/{conid} | Position by Conid
*PortfolioApi* | [**portfolio_account_id_positions_invalidate_post**](docs/PortfolioApi.md#portfolio_account_id_positions_invalidate_post) | **Post** /portfolio/{accountId}/positions/invalidate | Invalidates the backend cache of the Portfolio
*PortfolioApi* | [**portfolio_account_id_positions_page_id_get**](docs/PortfolioApi.md#portfolio_account_id_positions_page_id_get) | **Get** /portfolio/{accountId}/positions/{pageId} | Portfolio Positions
*PortfolioApi* | [**portfolio_account_id_summary_get**](docs/PortfolioApi.md#portfolio_account_id_summary_get) | **Get** /portfolio/{accountId}/summary | Account Summary
*PortfolioApi* | [**portfolio_accounts_get**](docs/PortfolioApi.md#portfolio_accounts_get) | **Get** /portfolio/accounts | Portfolio Accounts
*PortfolioApi* | [**portfolio_allocation_post**](docs/PortfolioApi.md#portfolio_allocation_post) | **Post** /portfolio/allocation | Account Alloction (All Accounts)
*PortfolioApi* | [**portfolio_positions_conid_get**](docs/PortfolioApi.md#portfolio_positions_conid_get) | **Get** /portfolio/positions/{conid} | Positions by Conid
*PortfolioApi* | [**portfolio_subaccounts_get**](docs/PortfolioApi.md#portfolio_subaccounts_get) | **Get** /portfolio/subaccounts | List of Sub-Accounts
*PortfolioAnalystApi* | [**pa_performance_post**](docs/PortfolioAnalystApi.md#pa_performance_post) | **Post** /pa/performance | Account Performance
*PortfolioAnalystApi* | [**pa_summary_post**](docs/PortfolioAnalystApi.md#pa_summary_post) | **Post** /pa/summary | Account Balance&#39;s Summary
*PortfolioAnalystApi* | [**pa_transactions_post**](docs/PortfolioAnalystApi.md#pa_transactions_post) | **Post** /pa/transactions | Position&#39;s Transaction History
*ScannerApi* | [**iserver_scanner_params_get**](docs/ScannerApi.md#iserver_scanner_params_get) | **Get** /iserver/scanner/params | Scanner Parameters
*ScannerApi* | [**iserver_scanner_run_post**](docs/ScannerApi.md#iserver_scanner_run_post) | **Post** /iserver/scanner/run | run scanner to get a list of contracts
*SessionApi* | [**iserver_auth_status_post**](docs/SessionApi.md#iserver_auth_status_post) | **Post** /iserver/auth/status | Authentication Status
*SessionApi* | [**iserver_reauthenticate_post**](docs/SessionApi.md#iserver_reauthenticate_post) | **Post** /iserver/reauthenticate | Tries to re-authenticate to Brokerage
*SessionApi* | [**logout_post**](docs/SessionApi.md#logout_post) | **Post** /logout | Ends the current session
*SessionApi* | [**sso_validate_get**](docs/SessionApi.md#sso_validate_get) | **Get** /sso/validate | Validate SSO
*SessionApi* | [**tickle_post**](docs/SessionApi.md#tickle_post) | **Post** /tickle | Ping the server to keep the session open
*StreamingApi* | [**ws_post**](docs/StreamingApi.md#ws_post) | **Post** /ws | Websocket Endpoint
*TradesApi* | [**iserver_account_trades_get**](docs/TradesApi.md#iserver_account_trades_get) | **Get** /iserver/account/trades | List of Trades for the selected account


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountParent](docs/AccountParent.md)
 - [Accounts](docs/Accounts.md)
 - [AlertRequest](docs/AlertRequest.md)
 - [AlertResponse](docs/AlertResponse.md)
 - [AlertrequestConditions](docs/AlertrequestConditions.md)
 - [AlertresponseConditions](docs/AlertresponseConditions.md)
 - [Allocation](docs/Allocation.md)
 - [AllocationInner](docs/AllocationInner.md)
 - [AllocationInnerAssetClass](docs/AllocationInnerAssetClass.md)
 - [AllocationInnerAssetClassLong](docs/AllocationInnerAssetClassLong.md)
 - [AllocationInnerAssetClassShort](docs/AllocationInnerAssetClassShort.md)
 - [AllocationInnerGroup](docs/AllocationInnerGroup.md)
 - [AllocationInnerGroupLong](docs/AllocationInnerGroupLong.md)
 - [AllocationInnerGroupShort](docs/AllocationInnerGroupShort.md)
 - [AllocationInnerSector](docs/AllocationInnerSector.md)
 - [AllocationInnerSectorLong](docs/AllocationInnerSectorLong.md)
 - [AllocationInnerSectorShort](docs/AllocationInnerSectorShort.md)
 - [Auth](docs/Auth.md)
 - [AuthStatus](docs/AuthStatus.md)
 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [Body10](docs/Body10.md)
 - [Body11](docs/Body11.md)
 - [Body2](docs/Body2.md)
 - [Body3](docs/Body3.md)
 - [Body4](docs/Body4.md)
 - [Body5](docs/Body5.md)
 - [Body6](docs/Body6.md)
 - [Body7](docs/Body7.md)
 - [Body8](docs/Body8.md)
 - [Body9](docs/Body9.md)
 - [CalendarRequest](docs/CalendarRequest.md)
 - [CalendarRequestDate](docs/CalendarRequestDate.md)
 - [CalendarRequestFilters](docs/CalendarRequestFilters.md)
 - [Contract](docs/Contract.md)
 - [ContractRules](docs/ContractRules.md)
 - [Events](docs/Events.md)
 - [EventsInner](docs/EventsInner.md)
 - [Futures](docs/Futures.md)
 - [FuturesInner](docs/FuturesInner.md)
 - [HistoryData](docs/HistoryData.md)
 - [HistoryResult](docs/HistoryResult.md)
 - [HistorydataData](docs/HistorydataData.md)
 - [HistoryresultBars](docs/HistoryresultBars.md)
 - [IbcustentityinfoAddress](docs/IbcustentityinfoAddress.md)
 - [IbcustentityinfoEntities](docs/IbcustentityinfoEntities.md)
 - [IbcustentityinfoName](docs/IbcustentityinfoName.md)
 - [Inds](docs/Inds.md)
 - [IndsInner](docs/IndsInner.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse20012](docs/InlineResponse20012.md)
 - [InlineResponse20013](docs/InlineResponse20013.md)
 - [InlineResponse20014](docs/InlineResponse20014.md)
 - [InlineResponse20014Orders](docs/InlineResponse20014Orders.md)
 - [InlineResponse20015](docs/InlineResponse20015.md)
 - [InlineResponse20016](docs/InlineResponse20016.md)
 - [InlineResponse20017](docs/InlineResponse20017.md)
 - [InlineResponse20018](docs/InlineResponse20018.md)
 - [InlineResponse20018Amount](docs/InlineResponse20018Amount.md)
 - [InlineResponse20018Equity](docs/InlineResponse20018Equity.md)
 - [InlineResponse20019](docs/InlineResponse20019.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse20020](docs/InlineResponse20020.md)
 - [InlineResponse20021](docs/InlineResponse20021.md)
 - [InlineResponse20022](docs/InlineResponse20022.md)
 - [InlineResponse20023](docs/InlineResponse20023.md)
 - [InlineResponse20023CqtTypes](docs/InlineResponse20023CqtTypes.md)
 - [InlineResponse20023FraqTypes](docs/InlineResponse20023FraqTypes.md)
 - [InlineResponse20023IbalgoTypes](docs/InlineResponse20023IbalgoTypes.md)
 - [InlineResponse20023OrderDefaults](docs/InlineResponse20023OrderDefaults.md)
 - [InlineResponse20023OrderTypes](docs/InlineResponse20023OrderTypes.md)
 - [InlineResponse20023OrderTypesOutside](docs/InlineResponse20023OrderTypesOutside.md)
 - [InlineResponse20023Rules](docs/InlineResponse20023Rules.md)
 - [InlineResponse20023String](docs/InlineResponse20023String.md)
 - [InlineResponse20023TifTypes](docs/InlineResponse20023TifTypes.md)
 - [InlineResponse20024](docs/InlineResponse20024.md)
 - [InlineResponse20025](docs/InlineResponse20025.md)
 - [InlineResponse20026](docs/InlineResponse20026.md)
 - [InlineResponse20027](docs/InlineResponse20027.md)
 - [InlineResponse20027FilterList](docs/InlineResponse20027FilterList.md)
 - [InlineResponse20027InstrumentList](docs/InlineResponse20027InstrumentList.md)
 - [InlineResponse20027LocationTree](docs/InlineResponse20027LocationTree.md)
 - [InlineResponse20027Locations](docs/InlineResponse20027Locations.md)
 - [InlineResponse20027ScanTypeList](docs/InlineResponse20027ScanTypeList.md)
 - [InlineResponse20028](docs/InlineResponse20028.md)
 - [InlineResponse20029](docs/InlineResponse20029.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse20030](docs/InlineResponse20030.md)
 - [InlineResponse20031](docs/InlineResponse20031.md)
 - [InlineResponse20032](docs/InlineResponse20032.md)
 - [InlineResponse20033](docs/InlineResponse20033.md)
 - [InlineResponse20034](docs/InlineResponse20034.md)
 - [InlineResponse20035](docs/InlineResponse20035.md)
 - [InlineResponse20036](docs/InlineResponse20036.md)
 - [InlineResponse20037](docs/InlineResponse20037.md)
 - [InlineResponse20037Schedules](docs/InlineResponse20037Schedules.md)
 - [InlineResponse20037Sessions](docs/InlineResponse20037Sessions.md)
 - [InlineResponse20037TradingTimes](docs/InlineResponse20037TradingTimes.md)
 - [InlineResponse20038](docs/InlineResponse20038.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2005E](docs/InlineResponse2005E.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InlineResponse200AcctList](docs/InlineResponse200AcctList.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse4001](docs/InlineResponse4001.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [IservercontractconidalgosParameters](docs/IservercontractconidalgosParameters.md)
 - [IserversecdefsearchSections](docs/IserversecdefsearchSections.md)
 - [Ledger](docs/Ledger.md)
 - [MarketData](docs/MarketData.md)
 - [ModifyOrder](docs/ModifyOrder.md)
 - [Notifications](docs/Notifications.md)
 - [NotificationsInner](docs/NotificationsInner.md)
 - [Order](docs/Order.md)
 - [OrderData](docs/OrderData.md)
 - [OrderRequest](docs/OrderRequest.md)
 - [OrderStatus](docs/OrderStatus.md)
 - [OrderdataWarnings](docs/OrderdataWarnings.md)
 - [Performance](docs/Performance.md)
 - [PerformanceCps](docs/PerformanceCps.md)
 - [PerformanceCpsData](docs/PerformanceCpsData.md)
 - [PerformanceNav](docs/PerformanceNav.md)
 - [PerformanceTpps](docs/PerformanceTpps.md)
 - [Position](docs/Position.md)
 - [PositionData](docs/PositionData.md)
 - [PositionInner](docs/PositionInner.md)
 - [ScannerParams](docs/ScannerParams.md)
 - [ScannerResult](docs/ScannerResult.md)
 - [ScannerparamsInstrumentList](docs/ScannerparamsInstrumentList.md)
 - [ScannerparamsInstrumentListInstrument](docs/ScannerparamsInstrumentListInstrument.md)
 - [ScannerparamsLocationTree](docs/ScannerparamsLocationTree.md)
 - [ScannerparamsLocationTreeLocation](docs/ScannerparamsLocationTreeLocation.md)
 - [ScannerparamsScanTypeList](docs/ScannerparamsScanTypeList.md)
 - [ScannerparamsScanTypeListScanType](docs/ScannerparamsScanTypeListScanType.md)
 - [ScannerresultContracts](docs/ScannerresultContracts.md)
 - [ScannerresultContractsContract](docs/ScannerresultContractsContract.md)
 - [Secdef](docs/Secdef.md)
 - [SecdefInfo](docs/SecdefInfo.md)
 - [SecdefInner](docs/SecdefInner.md)
 - [SecdefInnerIncrementRules](docs/SecdefInnerIncrementRules.md)
 - [SetAccount](docs/SetAccount.md)
 - [StatsData](docs/StatsData.md)
 - [Stocks](docs/Stocks.md)
 - [StocksInner](docs/StocksInner.md)
 - [StocksInnerContracts](docs/StocksInnerContracts.md)
 - [Summary](docs/Summary.md)
 - [SummaryAccountSummaries](docs/SummaryAccountSummaries.md)
 - [SummaryBalanceByDate](docs/SummaryBalanceByDate.md)
 - [SummaryBalanceByDateSeries](docs/SummaryBalanceByDateSeries.md)
 - [SummaryExcludedAccounts](docs/SummaryExcludedAccounts.md)
 - [SummaryTotal](docs/SummaryTotal.md)
 - [Symbol](docs/Symbol.md)
 - [SystemError](docs/SystemError.md)
 - [Trade](docs/Trade.md)
 - [Transactions](docs/Transactions.md)
 - [TransactionsTransactions](docs/TransactionsTransactions.md)
 - [Wagers](docs/Wagers.md)
 - [WagersInner](docs/WagersInner.md)


## Documentation For Authorization
 Endpoints do not require authorization.


## Author



