use std::thread;
use std::time::Duration;

mod iaqms_cli;
mod iaqms_hash;
mod iaqms_redis;
mod iaqms_settings;

use iaqms_cli::*;
use iaqms_redis::IaqmsRedis;
use iaqms_settings::*;

fn main() -> redis::RedisResult<()> {
    let opts = parse_args();
    let redis = IaqmsRedis::new(&opts.redis, opts.debug);

    let opt = IaqmsSyncOpts {
        fs_sync_secs: opts.sync_fs_secs as i64,
        fs_setting_path: opts.path,
        redis_key_name_base: opts.key_name_base,
    };

    let settings = IaqmsSettings::new(redis, opt);
    let mem_sync_secs = opts.sync_mem_secs;

    loop {
        settings.sync();
        thread::sleep(Duration::from_secs_f64(mem_sync_secs));
    }
}
