use std::env;

pub const SHA1_ENV_VAR: &str = "IAQMS_INMEM_NO_SHA1";
pub const IAQMS_DEBUG: &str = "IAQMS_DEBUG";

pub struct Opts {
    pub use_sha1: bool,
    pub path: String,
    pub sync_mem_secs: f64,
    pub sync_fs_secs: f64,
    pub key_name_base: String,
    pub redis: String,
    pub debug: bool,
}

pub fn parse_args() -> Opts {
    let debug = env::var_os(IAQMS_DEBUG).take();
    let no_sha1 = env::var_os(SHA1_ENV_VAR).take();

    return Opts {
        path: String::from("settings.json"),
        sync_mem_secs: 240.0,
        sync_fs_secs: 480.0,
        key_name_base: String::from("settings"),
        redis: String::from("redis://localhost:6379"),
        debug: debug.is_some(),
        use_sha1: no_sha1.is_none(),
    };
}
