use clap::Clap;
use std::thread;
use std::time::Duration;

mod iaqms_cli;
mod iaqms_md5;
mod iaqms_redis;
mod iaqms_settings;

use iaqms_cli::Opts;
use iaqms_redis::IaqmsRedis;
use iaqms_settings::*;

fn main() -> redis::RedisResult<()> {
    let opts: Opts = Opts::parse();

    let redis = IaqmsRedis::new(&opts.redis, opts.debug);

    let opt = IaqmsSyncOpts {
        fs_sync_secs: opts.sync_fs_secs as i64,
        fs_setting_path: opts.path,
        redis_key_name_base: opts.key_name_base,
    };

    let settings = IaqmsSettings::new(redis, opt);
    let mem_sync_secs = opts.sync_mem_secs;

    loop {
        settings.sync();
        thread::sleep(Duration::from_secs_f64(mem_sync_secs));
    }
}
