extern crate redis;
use redis::Commands;
use redis::*;

pub const REDIS_ERR_CONNECT: &str = "couldn't connect to redis";

pub struct IaqmsRedis {
    _client: redis::Client,
    _debug: bool,
}

impl IaqmsRedis {
    pub fn new(connection_string: &str, debug: bool) -> IaqmsRedis {
        return IaqmsRedis {
            _client: redis::Client::open(connection_string).expect(REDIS_ERR_CONNECT),
            _debug: debug,
        };
    }
    pub fn get_connection(&self) -> Connection {
        return self._client.get_connection().expect(REDIS_ERR_CONNECT);
    }

    pub fn get<T: redis::FromRedisValue>(&self, key: &str) -> Option<T> {
        return self.get_connection().get(&key).unwrap_or(None);
    }

    pub fn set(&self, key: &str, value: &serde_json::Value) -> RedisResult<()> {
        let conn = &mut self.get_connection();
        conn.set(key, value.as_str())?;

        if self._debug {
            println!("set {} to {}", key, value)
        }

        return Ok(());
    }
}
