use md5::*;

pub struct IaqmsChecksum {
    _raw: Option<md5::Digest>,
}

impl IaqmsChecksum {
    fn _new(raw: Digest) -> IaqmsChecksum {
        return IaqmsChecksum {
            _raw: Option::from(raw),
        };
    }

    pub fn from_json(json: &serde_json::Value) -> IaqmsChecksum {
        let stringified = &serde_json::to_string(json).unwrap();
        return IaqmsChecksum::_new(md5::compute(stringified));
    }

    pub fn to_hex(&self) -> String {
        return format!("{:x}", self._raw.unwrap());
    }

    pub fn compare(&self, x: String) -> bool {
        return x == self.to_hex();
    }
}
