use clap::{AppSettings, Clap};

#[derive(Clap)]
#[clap(version = "1.0.0-rc1.0", author = "Michael Palmer")]
#[clap(setting = AppSettings::ColoredHelp)]
pub struct Opts {
    #[clap(
        short = 'c',
        long = "checksum",
        about = "uses md5 checksum calculations if set"
    )]
    pub md5: bool,

    #[clap(
        short = 'p',
        long = "path",
        about = "path to valid settings.json",
        default_value = "settings.json"
    )]
    pub path: String,

    #[clap(long = "sync_mem_secs", default_value = "30")]
    pub sync_mem_secs: f64,

    #[clap(long = "sync_fs_secs", default_value = "480")]
    pub sync_fs_secs: f64,

    #[clap(
        long = "key_name_base",
        about = "sets the base name used for all keys (redis)",
        default_value = "settings"
    )]
    pub key_name_base: String,

    #[clap(long = "redis", default_value = "redis://localhost:6379")]
    pub redis: String,

    #[clap(
        short = 'd',
        long = "debug",
        about = "when on, additional messages are displayed"
    )]
    pub debug: bool,
}
