# iapiab

iapiab verifies the purchase receipt via AppStore, GooglePlayStore.  
iapiab is inspired by [golang implementation for iap and iab](https://github.com/awa/go-iap)

[![CI](https://github.com/yoshidan/rust-iap/workflows/CI/badge.svg?branch=main)](https://github.com/yoshidan/rust-iap/workflows/CI)

## Installation

```
[dependencies]
iapiab = 0.1.0
```
or you can get latest branch.
```
[dependencies]
iapiab = { git = "https://github.com/yoshidan/rust-iap/", branch = "main"}
```

## Quickstart 

### In App Purchase (via App Store)
```
use iapiab::appstore::model::IAPRequest;
use iapiab::appstore::validator::{IAPClient, IAPVerifier};

#[tokio::main]
async fn main() {
    let v = IAPRequest {
        receipt_data: "your receipt data encoded by base64".to_string(),
        password: None,
        exclude_old_transactions: false,
    };
    let client = IAPClient::new(reqwest::Client::new());
    let res = client.verify(&v).await.unwrap();
    println!("{}", res.status);
}
```

### In App Billing (via GooglePlay)
```
use iapiab::playstore::validator::{IABClient, IABProduct};

#[tokio::main]
async fn main() {
    let client = IABClient::new(
        b"your google service account json key",
        hyper::Client::builder().build(hyper_rustls::HttpsConnector::with_native_roots()),
    )
    .await;
    let res = client
        .verify("package name", "product id", "purchase token")
        .await;
    println!("{}", res.unwrap().acknowledgement_state.unwrap());
}
```

### In App Billing Signature Verification (via GooglePlay)

```
use iapiab::playstore::validator::{verify_signature, SignatureError};

#[tokio::main]
async fn main() {
    // ex) UnityIAP payload is {"json":{"orderId":"GPA.-..",...,"acknowledged":".."},"signature":"XXXXX", ...}
    let receipt = b"receipt json value"; //{"orderId":"GPA.-..",...,"acknowledged":".."}
    let pub_key = b"your pub key in play store";
    let signature = b"signature value";
    let result = verify_signature(pub_key, receipt, signature);
}
```

## Support

### In App Purchase
This validator supports the receipt type for iOS7 or above.

### In App Billing
This validator uses [Version 3 API](http://developer.android.com/google/play/billing/api.html).

## License
iapiab is licensed under the MIT.