/* automatically generated by rust-bindgen 0.59.2 */

pub const CH_SUCCESS: u32 = 0;
pub const CH_INVALID: i32 = -1;
pub const CH_NOMEM: i32 = -2;
pub const CH_SCAN_TERMINATED: i32 = -3;
pub const CH_COMPILER_ERROR: i32 = -4;
pub const CH_DB_VERSION_ERROR: i32 = -5;
pub const CH_DB_PLATFORM_ERROR: i32 = -6;
pub const CH_DB_MODE_ERROR: i32 = -7;
pub const CH_BAD_ALIGN: i32 = -8;
pub const CH_BAD_ALLOC: i32 = -9;
pub const CH_SCRATCH_IN_USE: i32 = -10;
pub const CH_UNKNOWN_HS_ERROR: i32 = -13;
pub const CH_FAIL_INTERNAL: i32 = -32;
pub const CH_FLAG_CASELESS: u32 = 1;
pub const CH_FLAG_DOTALL: u32 = 2;
pub const CH_FLAG_MULTILINE: u32 = 4;
pub const CH_FLAG_SINGLEMATCH: u32 = 8;
pub const CH_FLAG_UTF8: u32 = 32;
pub const CH_FLAG_UCP: u32 = 64;
pub const CH_MODE_NOGROUPS: u32 = 0;
pub const CH_MODE_GROUPS: u32 = 1048576;
pub const CH_CALLBACK_CONTINUE: u32 = 0;
pub const CH_CALLBACK_TERMINATE: u32 = 1;
pub const CH_CALLBACK_SKIP_PATTERN: u32 = 2;
pub const CH_ERROR_MATCHLIMIT: u32 = 1;
pub const CH_ERROR_RECURSIONLIMIT: u32 = 2;
pub const CH_CAPTURE_FLAG_INACTIVE: u32 = 0;
pub const CH_CAPTURE_FLAG_ACTIVE: u32 = 1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ch_database {
    _unused: [u8; 0],
}
#[doc = " A Chimera pattern database."]
#[doc = ""]
#[doc = " Generated by one of the Chimera compiler functions:"]
#[doc = "  - @ref ch_compile()"]
#[doc = "  - @ref ch_compile_multi()"]
#[doc = "  - @ref ch_compile_ext_multi()"]
pub type ch_database_t = ch_database;
#[doc = " A type for errors returned by Chimera functions."]
pub type ch_error_t = ::libc::c_int;
extern "C" {
    #[doc = " Free a compiled pattern database."]
    #[doc = ""]
    #[doc = " The free callback set by @ref ch_set_allocator()) will be used by this"]
    #[doc = " function."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      A compiled pattern database. NULL may also be safely provided, in which"]
    #[doc = "      case the function does nothing."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_free_database(db: *mut ch_database_t) -> ch_error_t;
}
extern "C" {
    #[doc = " Utility function for identifying this release version."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      A string containing the version number of this release build and the"]
    #[doc = "      date of the build. It is allocated statically, so it does not need to"]
    #[doc = "      be freed by the caller."]
    pub fn ch_version() -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Returns the size of the given database."]
    #[doc = ""]
    #[doc = " @param database"]
    #[doc = "      Pointer to compiled expression database."]
    #[doc = ""]
    #[doc = " @param database_size"]
    #[doc = "      On success, the size of the compiled database in bytes is placed in this"]
    #[doc = "      parameter."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_database_size(database: *const ch_database_t, database_size: *mut usize) -> ch_error_t;
}
extern "C" {
    #[doc = " Utility function providing information about a database."]
    #[doc = ""]
    #[doc = " @param database"]
    #[doc = "      Pointer to a compiled database."]
    #[doc = ""]
    #[doc = " @param info"]
    #[doc = "      On success, a string containing the version and platform information for"]
    #[doc = "      the supplied database is placed in the parameter. The string is"]
    #[doc = "      allocated using the allocator supplied in @ref hs_set_allocator()"]
    #[doc = "      (or malloc() if no allocator was set) and should be freed by the caller."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_database_info(database: *const ch_database_t, info: *mut *mut ::libc::c_char) -> ch_error_t;
}
#[doc = " The type of the callback function that will be used by Chimera to allocate"]
#[doc = " more memory at runtime as required."]
#[doc = ""]
#[doc = " If Chimera is to be used in a multi-threaded, or similarly concurrent"]
#[doc = " environment, the allocation function will need to be re-entrant, or"]
#[doc = " similarly safe for concurrent use."]
#[doc = ""]
#[doc = " @param size"]
#[doc = "      The number of bytes to allocate."]
#[doc = " @return"]
#[doc = "      A pointer to the region of memory allocated, or NULL on error."]
pub type ch_alloc_t = ::core::option::Option<unsafe extern "C" fn(size: usize) -> *mut ::libc::c_void>;
#[doc = " The type of the callback function that will be used by Chimera to free"]
#[doc = " memory regions previously allocated using the @ref ch_alloc_t function."]
#[doc = ""]
#[doc = " @param ptr"]
#[doc = "      The region of memory to be freed."]
pub type ch_free_t = ::core::option::Option<unsafe extern "C" fn(ptr: *mut ::libc::c_void)>;
extern "C" {
    #[doc = " Set the allocate and free functions used by Chimera for allocating"]
    #[doc = " memory at runtime for stream state, scratch space, database bytecode,"]
    #[doc = " and various other data structure returned by the Chimera API."]
    #[doc = ""]
    #[doc = " The function is equivalent to calling @ref ch_set_scratch_allocator(),"]
    #[doc = " @ref ch_set_database_allocator() and"]
    #[doc = " @ref ch_set_misc_allocator() with the provided parameters."]
    #[doc = ""]
    #[doc = " This call will override any previous allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: there is no way to change the allocator used for temporary objects"]
    #[doc = " created during the various compile calls (@ref ch_compile() and @ref"]
    #[doc = " ch_compile_multi())."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_set_allocator(alloc_func: ch_alloc_t, free_func: ch_free_t) -> ch_error_t;
}
extern "C" {
    #[doc = " Set the allocate and free functions used by Chimera for allocating memory"]
    #[doc = " for database bytecode produced by the compile calls (@ref ch_compile() and @ref"]
    #[doc = " ch_compile_multi())."]
    #[doc = ""]
    #[doc = " If no database allocation functions are set, or if NULL is used in place of"]
    #[doc = " both parameters, then memory allocation will default to standard methods"]
    #[doc = " (such as the system malloc() and free() calls)."]
    #[doc = ""]
    #[doc = " This call will override any previous database allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: the database allocator may also be set by calling @ref"]
    #[doc = " ch_set_allocator()."]
    #[doc = ""]
    #[doc = " Note: there is no way to change how temporary objects created during the"]
    #[doc = " various compile calls (@ref ch_compile() and @ref ch_compile_multi()) are"]
    #[doc = " allocated."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn ch_set_database_allocator(alloc_func: ch_alloc_t, free_func: ch_free_t) -> ch_error_t;
}
extern "C" {
    #[doc = " Set the allocate and free functions used by Chimera for allocating memory"]
    #[doc = " for items returned by the Chimera API such as @ref ch_compile_error_t."]
    #[doc = ""]
    #[doc = " If no misc allocation functions are set, or if NULL is used in place of both"]
    #[doc = " parameters, then memory allocation will default to standard methods (such as"]
    #[doc = " the system malloc() and free() calls)."]
    #[doc = ""]
    #[doc = " This call will override any previous misc allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: the misc allocator may also be set by calling @ref ch_set_allocator()."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_set_misc_allocator(alloc_func: ch_alloc_t, free_func: ch_free_t) -> ch_error_t;
}
extern "C" {
    #[doc = " Set the allocate and free functions used by Chimera for allocating memory"]
    #[doc = " for scratch space by @ref ch_alloc_scratch() and @ref ch_clone_scratch()."]
    #[doc = ""]
    #[doc = " If no scratch allocation functions are set, or if NULL is used in place of"]
    #[doc = " both parameters, then memory allocation will default to standard methods"]
    #[doc = " (such as the system malloc() and free() calls)."]
    #[doc = ""]
    #[doc = " This call will override any previous scratch allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: the scratch allocator may also be set by calling @ref"]
    #[doc = " ch_set_allocator()."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_set_scratch_allocator(alloc_func: ch_alloc_t, free_func: ch_free_t) -> ch_error_t;
}
#[doc = " A type containing information on the target platform which may optionally be"]
#[doc = " provided to the compile calls (@ref hs_compile(), @ref hs_compile_multi(),"]
#[doc = " @ref hs_compile_ext_multi())."]
#[doc = ""]
#[doc = " A hs_platform_info structure may be populated for the current platform by"]
#[doc = " using the @ref hs_populate_platform() call."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct hs_platform_info {
    #[doc = " Information about the target platform which may be used to guide the"]
    #[doc = " optimisation process of the compile."]
    #[doc = ""]
    #[doc = " Use of this field does not limit the processors that the resulting"]
    #[doc = " database can run on, but may impact the performance of the resulting"]
    #[doc = " database."]
    pub tune: ::libc::c_uint,
    #[doc = " Relevant CPU features available on the target platform"]
    #[doc = ""]
    #[doc = " This value may be produced by combining HS_CPU_FEATURE_* flags (such as"]
    #[doc = " @ref HS_CPU_FEATURES_AVX2). Multiple CPU features may be or'ed together"]
    #[doc = " to produce the value."]
    pub cpu_features: ::libc::c_ulonglong,
    #[doc = " Reserved for future use."]
    pub reserved1: ::libc::c_ulonglong,
    #[doc = " Reserved for future use."]
    pub reserved2: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_hs_platform_info() {
    assert_eq!(
        ::core::mem::size_of::<hs_platform_info>(),
        32usize,
        concat!("Size of: ", stringify!(hs_platform_info))
    );
    assert_eq!(
        ::core::mem::align_of::<hs_platform_info>(),
        8usize,
        concat!("Alignment of ", stringify!(hs_platform_info))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).tune as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(tune)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).cpu_features as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(cpu_features)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).reserved1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).reserved2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(reserved2)
        )
    );
}
#[doc = " A type containing information on the target platform which may optionally be"]
#[doc = " provided to the compile calls (@ref hs_compile(), @ref hs_compile_multi(),"]
#[doc = " @ref hs_compile_ext_multi())."]
#[doc = ""]
#[doc = " A hs_platform_info structure may be populated for the current platform by"]
#[doc = " using the @ref hs_populate_platform() call."]
pub type hs_platform_info_t = hs_platform_info;
#[doc = " A type containing error details that is returned by the compile calls (@ref"]
#[doc = " ch_compile() and @ref ch_compile_multi() on failure. The caller may inspect"]
#[doc = " the values returned in this type to determine the cause of failure."]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ch_compile_error {
    #[doc = " A human-readable error message describing the error."]
    pub message: *mut ::libc::c_char,
    #[doc = " The zero-based number of the expression that caused the error (if this"]
    #[doc = " can be determined). If the error is not specific to an expression, then"]
    #[doc = " this value will be less than zero."]
    pub expression: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_ch_compile_error() {
    assert_eq!(
        ::core::mem::size_of::<ch_compile_error>(),
        16usize,
        concat!("Size of: ", stringify!(ch_compile_error))
    );
    assert_eq!(
        ::core::mem::align_of::<ch_compile_error>(),
        8usize,
        concat!("Alignment of ", stringify!(ch_compile_error))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<ch_compile_error>())).message as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ch_compile_error),
            "::",
            stringify!(message)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<ch_compile_error>())).expression as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ch_compile_error),
            "::",
            stringify!(expression)
        )
    );
}
impl Default for ch_compile_error {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " A type containing error details that is returned by the compile calls (@ref"]
#[doc = " ch_compile() and @ref ch_compile_multi() on failure. The caller may inspect"]
#[doc = " the values returned in this type to determine the cause of failure."]
pub type ch_compile_error_t = ch_compile_error;
extern "C" {
    #[doc = " The basic regular expression compiler."]
    #[doc = ""]
    #[doc = " This is the function call with which an expression is compiled into a"]
    #[doc = " Chimera database which can be passed to the runtime function ("]
    #[doc = " @ref ch_scan())"]
    #[doc = ""]
    #[doc = " @param expression"]
    #[doc = "      The NULL-terminated expression to parse. Note that this string must"]
    #[doc = "      represent ONLY the pattern to be matched, with no delimiters or flags;"]
    #[doc = "      any global flags should be specified with the @a flags argument. For"]
    #[doc = "      example, the expression `/abc?def/i` should be compiled by providing"]
    #[doc = "      `abc?def` as the @a expression, and @ref CH_FLAG_CASELESS as the @a"]
    #[doc = "      flags."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags which modify the behaviour of the expression. Multiple flags may"]
    #[doc = "      be used by ORing them together. Valid values are:"]
    #[doc = "       - CH_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - CH_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - CH_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - CH_FLAG_SINGLEMATCH - Only one match will be generated for the"]
    #[doc = "                               expression per stream."]
    #[doc = "       - CH_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - CH_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flag that affect the database as a whole for capturing"]
    #[doc = "      groups. One of  CH_MODE_NOGROUPS or  CH_MODE_GROUPS must be supplied."]
    #[doc = "      See @ref CH_MODE_FLAG for more details."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref ch_free_database() function."]
    #[doc = ""]
    #[doc = " @param compile_error"]
    #[doc = "      If the compile fails, a pointer to a @ref ch_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      ch_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      CH_COMPILER_ERROR on failure, with details provided in the error"]
    #[doc = "      parameter."]
    pub fn ch_compile(
        expression: *const ::libc::c_char,
        flags: ::libc::c_uint,
        mode: ::libc::c_uint,
        platform: *const hs_platform_info_t,
        db: *mut *mut ch_database_t,
        compile_error: *mut *mut ch_compile_error_t,
    ) -> ch_error_t;
}
extern "C" {
    #[doc = " The multiple regular expression compiler."]
    #[doc = ""]
    #[doc = " This is the function call with which a set of expressions is compiled into a"]
    #[doc = " database which can be passed to the runtime function (@ref ch_scan())."]
    #[doc = " Each expression can be labelled with a unique integer which is passed into"]
    #[doc = " the match callback to identify the pattern that has matched."]
    #[doc = ""]
    #[doc = " @param expressions"]
    #[doc = "      Array of NULL-terminated expressions to compile. Note that (as for @ref"]
    #[doc = "      ch_compile()) these strings must contain only the pattern to be"]
    #[doc = "      matched, with no delimiters or flags. For example, the expression"]
    #[doc = "      `/abc?def/i` should be compiled by providing `abc?def` as the first"]
    #[doc = "      string in the @a expressions array, and @ref CH_FLAG_CASELESS as the"]
    #[doc = "      first value in the @a flags array."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Array of flags which modify the behaviour of each expression. Multiple"]
    #[doc = "      flags may be used by ORing them together.  Specifying the NULL pointer"]
    #[doc = "      in place of an array will set the flags value for all patterns to zero."]
    #[doc = "      Valid values are:"]
    #[doc = "       - CH_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - CH_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - CH_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - CH_FLAG_SINGLEMATCH - Only one match will be generated by patterns"]
    #[doc = "                               with this match id per stream."]
    #[doc = "       - CH_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - CH_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = ""]
    #[doc = " @param ids"]
    #[doc = "      An array of integers specifying the ID number to be associated with the"]
    #[doc = "      corresponding pattern in the expressions array. Specifying the NULL"]
    #[doc = "      pointer in place of an array will set the ID value for all patterns to"]
    #[doc = "      zero."]
    #[doc = ""]
    #[doc = " @param elements"]
    #[doc = "      The number of elements in the input arrays."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flag that affect the database as a whole for capturing"]
    #[doc = "      groups. One of  CH_MODE_NOGROUPS or  CH_MODE_GROUPS must be supplied."]
    #[doc = "      See @ref CH_MODE_FLAG for more details."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref ch_free_database() function."]
    #[doc = ""]
    #[doc = " @param compile_error"]
    #[doc = "      If the compile fails, a pointer to a @ref ch_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      ch_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      CH_COMPILER_ERROR on failure, with details provided in the @a error"]
    #[doc = "      parameter."]
    #[doc = ""]
    pub fn ch_compile_multi(
        expressions: *const *const ::libc::c_char,
        flags: *const ::libc::c_uint,
        ids: *const ::libc::c_uint,
        elements: ::libc::c_uint,
        mode: ::libc::c_uint,
        platform: *const hs_platform_info_t,
        db: *mut *mut ch_database_t,
        compile_error: *mut *mut ch_compile_error_t,
    ) -> ch_error_t;
}
extern "C" {
    #[doc = " The multiple regular expression compiler with extended match limits support."]
    #[doc = ""]
    #[doc = " This is the function call with which a set of expressions is compiled into a"]
    #[doc = " database in the same way as @ref ch_compile_multi(), but allows additional"]
    #[doc = " parameters to be specified via match_limit and match_limit_recursion to"]
    #[doc = " define match limits for PCRE runtime."]
    #[doc = ""]
    #[doc = " @param expressions"]
    #[doc = "      Array of NULL-terminated expressions to compile. Note that (as for @ref"]
    #[doc = "      ch_compile()) these strings must contain only the pattern to be"]
    #[doc = "      matched, with no delimiters or flags. For example, the expression"]
    #[doc = "      `/abc?def/i` should be compiled by providing `abc?def` as the first"]
    #[doc = "      string in the @a expressions array, and @ref CH_FLAG_CASELESS as the"]
    #[doc = "      first value in the @a flags array."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Array of flags which modify the behaviour of each expression. Multiple"]
    #[doc = "      flags may be used by ORing them together.  Specifying the NULL pointer"]
    #[doc = "      in place of an array will set the flags value for all patterns to zero."]
    #[doc = "      Valid values are:"]
    #[doc = "       - CH_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - CH_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - CH_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - CH_FLAG_SINGLEMATCH - Only one match will be generated by patterns"]
    #[doc = "                               with this match id per stream."]
    #[doc = "       - CH_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - CH_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = ""]
    #[doc = " @param ids"]
    #[doc = "      An array of integers specifying the ID number to be associated with the"]
    #[doc = "      corresponding pattern in the expressions array. Specifying the NULL"]
    #[doc = "      pointer in place of an array will set the ID value for all patterns to"]
    #[doc = "      zero."]
    #[doc = ""]
    #[doc = " @param elements"]
    #[doc = "      The number of elements in the input arrays."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flag that affect the database as a whole for capturing"]
    #[doc = "      groups. One of  CH_MODE_NOGROUPS or  CH_MODE_GROUPS must be supplied."]
    #[doc = "      See @ref CH_MODE_FLAG for more details."]
    #[doc = ""]
    #[doc = " @param match_limit"]
    #[doc = "      A limit from pcre_extra on the amount of match function called in PCRE"]
    #[doc = "      to limit backtracking that can take place."]
    #[doc = ""]
    #[doc = " @param match_limit_recursion"]
    #[doc = "      A limit from pcre_extra on the recursion depth of match function"]
    #[doc = "      in PCRE."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref ch_free_database() function."]
    #[doc = ""]
    #[doc = " @param compile_error"]
    #[doc = "      If the compile fails, a pointer to a @ref ch_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      ch_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      CH_COMPILER_ERROR on failure, with details provided in the @a error"]
    #[doc = "      parameter."]
    #[doc = ""]
    pub fn ch_compile_ext_multi(
        expressions: *const *const ::libc::c_char,
        flags: *const ::libc::c_uint,
        ids: *const ::libc::c_uint,
        elements: ::libc::c_uint,
        mode: ::libc::c_uint,
        match_limit: ::libc::c_ulong,
        match_limit_recursion: ::libc::c_ulong,
        platform: *const hs_platform_info_t,
        db: *mut *mut ch_database_t,
        compile_error: *mut *mut ch_compile_error_t,
    ) -> ch_error_t;
}
extern "C" {
    #[doc = " Free an error structure generated by @ref ch_compile(), @ref"]
    #[doc = " ch_compile_multi()."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      The @ref ch_compile_error_t to be freed. NULL may also be safely"]
    #[doc = "      provided."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_free_compile_error(error: *mut ch_compile_error_t) -> ch_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ch_scratch {
    _unused: [u8; 0],
}
#[doc = " A Chimera scratch space."]
pub type ch_scratch_t = ch_scratch;
#[doc = " Callback return value used to tell the Chimera matcher what to do after"]
#[doc = " processing this match."]
pub type ch_callback_t = ::libc::c_int;
#[doc = " Type used to differentiate the errors raised with the @ref"]
#[doc = " ch_error_event_handler callback."]
pub type ch_error_event_t = ::libc::c_int;
#[doc = " Structure representing a captured subexpression within a match. An array of"]
#[doc = " these structures corresponding to capture groups in order is passed to the"]
#[doc = " callback on match, with active structures identified by the"]
#[doc = " CH_CAPTURE_FLAG_ACTIVE flag."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ch_capture {
    #[doc = " The flags indicating if this structure is active."]
    pub flags: ::libc::c_uint,
    #[doc = " offset at which this capture group begins."]
    pub from: ::libc::c_ulonglong,
    #[doc = " offset at which this capture group ends."]
    pub to: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_ch_capture() {
    assert_eq!(
        ::core::mem::size_of::<ch_capture>(),
        24usize,
        concat!("Size of: ", stringify!(ch_capture))
    );
    assert_eq!(
        ::core::mem::align_of::<ch_capture>(),
        8usize,
        concat!("Alignment of ", stringify!(ch_capture))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<ch_capture>())).flags as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(ch_capture), "::", stringify!(flags))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<ch_capture>())).from as *const _ as usize },
        8usize,
        concat!("Offset of field: ", stringify!(ch_capture), "::", stringify!(from))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<ch_capture>())).to as *const _ as usize },
        16usize,
        concat!("Offset of field: ", stringify!(ch_capture), "::", stringify!(to))
    );
}
#[doc = " Structure representing a captured subexpression within a match. An array of"]
#[doc = " these structures corresponding to capture groups in order is passed to the"]
#[doc = " callback on match, with active structures identified by the"]
#[doc = " CH_CAPTURE_FLAG_ACTIVE flag."]
pub type ch_capture_t = ch_capture;
#[doc = " Definition of the match event callback function type."]
#[doc = ""]
#[doc = " A callback function matching the defined type must be provided by the"]
#[doc = " application calling the @ref ch_scan()"]
#[doc = ""]
#[doc = " This callback function will be invoked whenever a match is located in the"]
#[doc = " target data during the execution of a scan. The details of the match are"]
#[doc = " passed in as parameters to the callback function, and the callback function"]
#[doc = " should return a value indicating whether or not matching should continue on"]
#[doc = " the target data. If no callbacks are desired from a scan call, NULL may be"]
#[doc = " provided in order to suppress match production."]
#[doc = ""]
#[doc = " @param id"]
#[doc = "      The ID number of the expression that matched. If the expression was a"]
#[doc = "      single expression compiled with @ref ch_compile(), this value will be"]
#[doc = "      zero."]
#[doc = ""]
#[doc = " @param from"]
#[doc = "      The offset of the first byte that matches the expression."]
#[doc = ""]
#[doc = " @param to"]
#[doc = "      The offset after the last byte that matches the expression."]
#[doc = ""]
#[doc = " @param flags"]
#[doc = "      This is provided for future use and is unused at present."]
#[doc = ""]
#[doc = " @param size"]
#[doc = "      The number of valid entries pointed to by the captured parameter."]
#[doc = ""]
#[doc = " @param captured"]
#[doc = "      A pointer to an array of @ref ch_capture_t structures that"]
#[doc = "      contain the start and end offsets of entire pattern match and"]
#[doc = "      each captured subexpression."]
#[doc = ""]
#[doc = " @param ctx"]
#[doc = "      The pointer supplied by the user to the @ref ch_scan() function."]
#[doc = ""]
#[doc = " @return"]
#[doc = "      The callback can return @ref CH_CALLBACK_TERMINATE to stop matching."]
#[doc = "      Otherwise, a return value of @ref CH_CALLBACK_CONTINUE will continue,"]
#[doc = "      with the current pattern if configured to produce multiple matches per"]
#[doc = "      pattern, while a return value of @ref CH_CALLBACK_SKIP_PATTERN will"]
#[doc = "      cease matching this pattern but continue matching the next pattern."]
pub type ch_match_event_handler = ::core::option::Option<
    unsafe extern "C" fn(
        id: ::libc::c_uint,
        from: ::libc::c_ulonglong,
        to: ::libc::c_ulonglong,
        flags: ::libc::c_uint,
        size: ::libc::c_uint,
        captured: *const ch_capture_t,
        ctx: *mut ::libc::c_void,
    ) -> ch_callback_t,
>;
#[doc = " Definition of the Chimera error event callback function type."]
#[doc = ""]
#[doc = " A callback function matching the defined type may be provided by the"]
#[doc = " application calling the @ref ch_scan function. This callback function"]
#[doc = " will be invoked when an error event occurs during matching; this indicates"]
#[doc = " that some matches for a given expression may not be reported."]
#[doc = ""]
#[doc = " @param error_type"]
#[doc = "      The type of error event that occurred. Currently these errors"]
#[doc = "      correspond to resource limits on PCRE backtracking"]
#[doc = "      @ref CH_ERROR_MATCHLIMIT and @ref CH_ERROR_RECURSIONLIMIT."]
#[doc = ""]
#[doc = " @param id"]
#[doc = "      The ID number of the expression that matched."]
#[doc = ""]
#[doc = " @param info"]
#[doc = "      Event-specific data, for future use. Currently unused."]
#[doc = ""]
#[doc = " @param ctx"]
#[doc = "      The context pointer supplied by the user to the @ref ch_scan"]
#[doc = "      function."]
#[doc = ""]
#[doc = " @return"]
#[doc = "      The callback can return @ref CH_CALLBACK_SKIP_PATTERN to cease matching"]
#[doc = "      this pattern but continue matching the next pattern. Otherwise, we stop"]
#[doc = "      matching for all patterns with @ref CH_CALLBACK_TERMINATE."]
pub type ch_error_event_handler = ::core::option::Option<
    unsafe extern "C" fn(
        error_type: ch_error_event_t,
        id: ::libc::c_uint,
        info: *mut ::libc::c_void,
        ctx: *mut ::libc::c_void,
    ) -> ch_callback_t,
>;
extern "C" {
    #[doc = " The block regular expression scanner."]
    #[doc = ""]
    #[doc = " This is the function call in which the actual pattern matching takes place"]
    #[doc = " for block-mode pattern databases."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      A compiled pattern database."]
    #[doc = ""]
    #[doc = " @param data"]
    #[doc = "      Pointer to the data to be scanned."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      The number of bytes to scan."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags modifying the behaviour of this function. This parameter is"]
    #[doc = "      provided for future use and is unused at present."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref ch_alloc_scratch() for this"]
    #[doc = "      database."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param onError"]
    #[doc = "      Pointer to a error event callback function. If a NULL pointer is given,"]
    #[doc = "      @ref CH_ERROR_MATCHLIMIT and @ref CH_ERROR_RECURSIONLIMIT errors will"]
    #[doc = "      be ignored and match will continue."]
    #[doc = ""]
    #[doc = " @param context"]
    #[doc = "      The user defined pointer which will be passed to the callback function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      Returns @ref CH_SUCCESS on success; @ref CH_SCAN_TERMINATED if the"]
    #[doc = "      match callback indicated that scanning should stop; other values on"]
    #[doc = "      error."]
    pub fn ch_scan(
        db: *const ch_database_t,
        data: *const ::libc::c_char,
        length: ::libc::c_uint,
        flags: ::libc::c_uint,
        scratch: *mut ch_scratch_t,
        onEvent: ch_match_event_handler,
        onError: ch_error_event_handler,
        context: *mut ::libc::c_void,
    ) -> ch_error_t;
}
extern "C" {
    #[doc = " Allocate a \"scratch\" space for use by Chimera."]
    #[doc = ""]
    #[doc = " This is required for runtime use, and one scratch space per thread, or"]
    #[doc = " concurrent caller, is required. Any allocator callback set by @ref"]
    #[doc = " ch_set_scratch_allocator() or @ref ch_set_allocator() will be used by this"]
    #[doc = " function."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      The database, as produced by @ref ch_compile()."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      On first allocation, a pointer to NULL should be provided so a new"]
    #[doc = "      scratch can be allocated. If a scratch block has been previously"]
    #[doc = "      allocated, then a pointer to it should be passed back in to see if it"]
    #[doc = "      is valid for this database block. If a new scratch block is required,"]
    #[doc = "      the original will be freed and the new one returned, otherwise the"]
    #[doc = "      previous scratch block will be returned. On success, the scratch block"]
    #[doc = "      will be suitable for use with the provided database in addition to any"]
    #[doc = "      databases that original scratch space was suitable for."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on successful allocation; @ref CH_NOMEM if the"]
    #[doc = "      allocation fails.  Other errors may be returned if invalid parameters"]
    #[doc = "      are specified."]
    pub fn ch_alloc_scratch(db: *const ch_database_t, scratch: *mut *mut ch_scratch_t) -> ch_error_t;
}
extern "C" {
    #[doc = " Allocate a scratch space that is a clone of an existing scratch space."]
    #[doc = ""]
    #[doc = " This is useful when multiple concurrent threads will be using the same set"]
    #[doc = " of compiled databases, and another scratch space is required. Any allocator"]
    #[doc = " callback set by @ref ch_set_scratch_allocator() or @ref ch_set_allocator()"]
    #[doc = " will be used by this function."]
    #[doc = ""]
    #[doc = " @param src"]
    #[doc = "      The existing @ref ch_scratch_t to be cloned."]
    #[doc = ""]
    #[doc = " @param dest"]
    #[doc = "      A pointer to the new scratch space will be returned here."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success; @ref CH_NOMEM if the allocation fails."]
    #[doc = "      Other errors may be returned if invalid parameters are specified."]
    pub fn ch_clone_scratch(src: *const ch_scratch_t, dest: *mut *mut ch_scratch_t) -> ch_error_t;
}
extern "C" {
    #[doc = " Provides the size of the given scratch space."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref ch_alloc_scratch() or @ref"]
    #[doc = "      ch_clone_scratch()."]
    #[doc = ""]
    #[doc = " @param scratch_size"]
    #[doc = "      On success, the size of the scratch space in bytes is placed in this"]
    #[doc = "      parameter."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_scratch_size(scratch: *const ch_scratch_t, scratch_size: *mut usize) -> ch_error_t;
}
extern "C" {
    #[doc = " Free a scratch block previously allocated by @ref ch_alloc_scratch() or @ref"]
    #[doc = " ch_clone_scratch()."]
    #[doc = ""]
    #[doc = " The free callback set by @ref ch_set_scratch_allocator() or @ref"]
    #[doc = " ch_set_allocator() will be used by this function."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      The scratch block to be freed. NULL may also be safely provided."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref CH_SUCCESS on success, other values on failure."]
    pub fn ch_free_scratch(scratch: *mut ch_scratch_t) -> ch_error_t;
}
