/* automatically generated by rust-bindgen 0.58.1 */

pub const HS_MAJOR: u32 = 5;
pub const HS_MINOR: u32 = 4;
pub const HS_PATCH: u32 = 0;
pub const HS_SUCCESS: u32 = 0;
pub const HS_INVALID: i32 = -1;
pub const HS_NOMEM: i32 = -2;
pub const HS_SCAN_TERMINATED: i32 = -3;
pub const HS_COMPILER_ERROR: i32 = -4;
pub const HS_DB_VERSION_ERROR: i32 = -5;
pub const HS_DB_PLATFORM_ERROR: i32 = -6;
pub const HS_DB_MODE_ERROR: i32 = -7;
pub const HS_BAD_ALIGN: i32 = -8;
pub const HS_BAD_ALLOC: i32 = -9;
pub const HS_SCRATCH_IN_USE: i32 = -10;
pub const HS_ARCH_ERROR: i32 = -11;
pub const HS_INSUFFICIENT_SPACE: i32 = -12;
pub const HS_UNKNOWN_ERROR: i32 = -13;
pub const HS_EXT_FLAG_MIN_OFFSET: u32 = 1;
pub const HS_EXT_FLAG_MAX_OFFSET: u32 = 2;
pub const HS_EXT_FLAG_MIN_LENGTH: u32 = 4;
pub const HS_EXT_FLAG_EDIT_DISTANCE: u32 = 8;
pub const HS_EXT_FLAG_HAMMING_DISTANCE: u32 = 16;
pub const HS_FLAG_CASELESS: u32 = 1;
pub const HS_FLAG_DOTALL: u32 = 2;
pub const HS_FLAG_MULTILINE: u32 = 4;
pub const HS_FLAG_SINGLEMATCH: u32 = 8;
pub const HS_FLAG_ALLOWEMPTY: u32 = 16;
pub const HS_FLAG_UTF8: u32 = 32;
pub const HS_FLAG_UCP: u32 = 64;
pub const HS_FLAG_PREFILTER: u32 = 128;
pub const HS_FLAG_SOM_LEFTMOST: u32 = 256;
pub const HS_FLAG_COMBINATION: u32 = 512;
pub const HS_FLAG_QUIET: u32 = 1024;
pub const HS_CPU_FEATURES_AVX2: u32 = 4;
pub const HS_CPU_FEATURES_AVX512: u32 = 8;
pub const HS_CPU_FEATURES_AVX512VBMI: u32 = 16;
pub const HS_TUNE_FAMILY_GENERIC: u32 = 0;
pub const HS_TUNE_FAMILY_SNB: u32 = 1;
pub const HS_TUNE_FAMILY_IVB: u32 = 2;
pub const HS_TUNE_FAMILY_HSW: u32 = 3;
pub const HS_TUNE_FAMILY_SLM: u32 = 4;
pub const HS_TUNE_FAMILY_BDW: u32 = 5;
pub const HS_TUNE_FAMILY_SKL: u32 = 6;
pub const HS_TUNE_FAMILY_SKX: u32 = 7;
pub const HS_TUNE_FAMILY_GLM: u32 = 8;
pub const HS_TUNE_FAMILY_ICL: u32 = 9;
pub const HS_TUNE_FAMILY_ICX: u32 = 10;
pub const HS_MODE_BLOCK: u32 = 1;
pub const HS_MODE_NOSTREAM: u32 = 1;
pub const HS_MODE_STREAM: u32 = 2;
pub const HS_MODE_VECTORED: u32 = 4;
pub const HS_MODE_SOM_HORIZON_LARGE: u32 = 16777216;
pub const HS_MODE_SOM_HORIZON_MEDIUM: u32 = 33554432;
pub const HS_MODE_SOM_HORIZON_SMALL: u32 = 67108864;
pub const HS_OFFSET_PAST_HORIZON: i32 = -1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hs_database {
    _unused: [u8; 0],
}
#[doc = " A Hyperscan pattern database."]
#[doc = ""]
#[doc = " Generated by one of the Hyperscan compiler functions:"]
#[doc = "  - @ref hs_compile()"]
#[doc = "  - @ref hs_compile_multi()"]
#[doc = "  - @ref hs_compile_ext_multi()"]
pub type hs_database_t = hs_database;
#[doc = " A type for errors returned by Hyperscan functions."]
pub type hs_error_t = ::libc::c_int;
extern "C" {
    #[doc = " Free a compiled pattern database."]
    #[doc = ""]
    #[doc = " The free callback set by @ref hs_set_database_allocator() (or @ref"]
    #[doc = " hs_set_allocator()) will be used by this function."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      A compiled pattern database. NULL may also be safely provided, in which"]
    #[doc = "      case the function does nothing."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_free_database(db: *mut hs_database_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Serialize a pattern database to a stream of bytes."]
    #[doc = ""]
    #[doc = " The allocator callback set by @ref hs_set_misc_allocator() (or @ref"]
    #[doc = " hs_set_allocator()) will be used by this function."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      A compiled pattern database."]
    #[doc = ""]
    #[doc = " @param bytes"]
    #[doc = "      On success, a pointer to an array of bytes will be returned here."]
    #[doc = "      These bytes can be subsequently relocated or written to disk. The"]
    #[doc = "      caller is responsible for freeing this block."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      On success, the number of bytes in the generated byte array will be"]
    #[doc = "      returned here."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, @ref HS_NOMEM if the byte array cannot be"]
    #[doc = "      allocated, other values may be returned if errors are detected."]
    pub fn hs_serialize_database(
        db: *const hs_database_t,
        bytes: *mut *mut ::libc::c_char,
        length: *mut usize,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Reconstruct a pattern database from a stream of bytes previously generated"]
    #[doc = " by @ref hs_serialize_database()."]
    #[doc = ""]
    #[doc = " This function will allocate sufficient space for the database using the"]
    #[doc = " allocator set with @ref hs_set_database_allocator() (or @ref"]
    #[doc = " hs_set_allocator()); to use a pre-allocated region of memory, use the @ref"]
    #[doc = " hs_deserialize_database_at() function."]
    #[doc = ""]
    #[doc = " @param bytes"]
    #[doc = "      A byte array generated by @ref hs_serialize_database() representing a"]
    #[doc = "      compiled pattern database."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      The length of the byte array generated by @ref hs_serialize_database()."]
    #[doc = "      This should be the same value as that returned by @ref"]
    #[doc = "      hs_serialize_database()."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to a newly allocated @ref hs_database_t will be"]
    #[doc = "      returned here. This database can then be used for scanning, and"]
    #[doc = "      eventually freed by the caller using @ref hs_free_database()."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_deserialize_database(
        bytes: *const ::libc::c_char,
        length: usize,
        db: *mut *mut hs_database_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Reconstruct a pattern database from a stream of bytes previously generated"]
    #[doc = " by @ref hs_serialize_database() at a given memory location."]
    #[doc = ""]
    #[doc = " This function (unlike @ref hs_deserialize_database()) will write the"]
    #[doc = " reconstructed database to the memory location given in the @p db parameter."]
    #[doc = " The amount of space required at this location can be determined with the"]
    #[doc = " @ref hs_serialized_database_size() function."]
    #[doc = ""]
    #[doc = " @param bytes"]
    #[doc = "      A byte array generated by @ref hs_serialize_database() representing a"]
    #[doc = "      compiled pattern database."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      The length of the byte array generated by @ref hs_serialize_database()."]
    #[doc = "      This should be the same value as that returned by @ref"]
    #[doc = "      hs_serialize_database()."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      Pointer to an 8-byte aligned block of memory of sufficient size to hold"]
    #[doc = "      the deserialized database. On success, the reconstructed database will"]
    #[doc = "      be written to this location. This database can then be used for pattern"]
    #[doc = "      matching. The user is responsible for freeing this memory; the @ref"]
    #[doc = "      hs_free_database() call should not be used."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_deserialize_database_at(
        bytes: *const ::libc::c_char,
        length: usize,
        db: *mut hs_database_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Provides the size of the stream state allocated by a single stream opened"]
    #[doc = " against the given database."]
    #[doc = ""]
    #[doc = " @param database"]
    #[doc = "      Pointer to a compiled (streaming mode) pattern database."]
    #[doc = ""]
    #[doc = " @param stream_size"]
    #[doc = "      On success, the size in bytes of an individual stream opened against the"]
    #[doc = "      given database is placed in this parameter."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_stream_size(database: *const hs_database_t, stream_size: *mut usize) -> hs_error_t;
}
extern "C" {
    #[doc = " Provides the size of the given database in bytes."]
    #[doc = ""]
    #[doc = " @param database"]
    #[doc = "      Pointer to compiled pattern database."]
    #[doc = ""]
    #[doc = " @param database_size"]
    #[doc = "      On success, the size of the compiled database in bytes is placed in this"]
    #[doc = "      parameter."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_database_size(database: *const hs_database_t, database_size: *mut usize) -> hs_error_t;
}
extern "C" {
    #[doc = " Utility function for reporting the size that would be required by a"]
    #[doc = " database if it were deserialized."]
    #[doc = ""]
    #[doc = " This can be used to allocate a shared memory region or other \"special\""]
    #[doc = " allocation prior to deserializing with the @ref hs_deserialize_database_at()"]
    #[doc = " function."]
    #[doc = ""]
    #[doc = " @param bytes"]
    #[doc = "      Pointer to a byte array generated by @ref hs_serialize_database()"]
    #[doc = "      representing a compiled pattern database."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      The length of the byte array generated by @ref hs_serialize_database()."]
    #[doc = "      This should be the same value as that returned by @ref"]
    #[doc = "      hs_serialize_database()."]
    #[doc = ""]
    #[doc = " @param deserialized_size"]
    #[doc = "      On success, the size of the compiled database that would be generated"]
    #[doc = "      by @ref hs_deserialize_database_at() is returned here."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_serialized_database_size(
        bytes: *const ::libc::c_char,
        length: usize,
        deserialized_size: *mut usize,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Utility function providing information about a database."]
    #[doc = ""]
    #[doc = " @param database"]
    #[doc = "      Pointer to a compiled database."]
    #[doc = ""]
    #[doc = " @param info"]
    #[doc = "      On success, a string containing the version and platform information for"]
    #[doc = "      the supplied database is placed in the parameter. The string is"]
    #[doc = "      allocated using the allocator supplied in @ref hs_set_misc_allocator()"]
    #[doc = "      (or malloc() if no allocator was set) and should be freed by the caller."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_database_info(database: *const hs_database_t, info: *mut *mut ::libc::c_char) -> hs_error_t;
}
extern "C" {
    #[doc = " Utility function providing information about a serialized database."]
    #[doc = ""]
    #[doc = " @param bytes"]
    #[doc = "      Pointer to a serialized database."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      Length in bytes of the serialized database."]
    #[doc = ""]
    #[doc = " @param info"]
    #[doc = "      On success, a string containing the version and platform information"]
    #[doc = "      for the supplied serialized database is placed in the parameter. The"]
    #[doc = "      string is allocated using the allocator supplied in @ref"]
    #[doc = "      hs_set_misc_allocator() (or malloc() if no allocator was set) and"]
    #[doc = "      should be freed by the caller."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_serialized_database_info(
        bytes: *const ::libc::c_char,
        length: usize,
        info: *mut *mut ::libc::c_char,
    ) -> hs_error_t;
}
#[doc = " The type of the callback function that will be used by Hyperscan to allocate"]
#[doc = " more memory at runtime as required, for example in @ref hs_open_stream() to"]
#[doc = " allocate stream state."]
#[doc = ""]
#[doc = " If Hyperscan is to be used in a multi-threaded, or similarly concurrent"]
#[doc = " environment, the allocation function will need to be re-entrant, or"]
#[doc = " similarly safe for concurrent use."]
#[doc = ""]
#[doc = " @param size"]
#[doc = "      The number of bytes to allocate."]
#[doc = " @return"]
#[doc = "      A pointer to the region of memory allocated, or NULL on error."]
pub type hs_alloc_t = ::core::option::Option<unsafe extern "C" fn(size: usize) -> *mut ::libc::c_void>;
#[doc = " The type of the callback function that will be used by Hyperscan to free"]
#[doc = " memory regions previously allocated using the @ref hs_alloc_t function."]
#[doc = ""]
#[doc = " @param ptr"]
#[doc = "      The region of memory to be freed."]
pub type hs_free_t = ::core::option::Option<unsafe extern "C" fn(ptr: *mut ::libc::c_void)>;
extern "C" {
    #[doc = " Set the allocate and free functions used by Hyperscan for allocating"]
    #[doc = " memory at runtime for stream state, scratch space, database bytecode,"]
    #[doc = " and various other data structure returned by the Hyperscan API."]
    #[doc = ""]
    #[doc = " The function is equivalent to calling @ref hs_set_stream_allocator(),"]
    #[doc = " @ref hs_set_scratch_allocator(), @ref hs_set_database_allocator() and"]
    #[doc = " @ref hs_set_misc_allocator() with the provided parameters."]
    #[doc = ""]
    #[doc = " This call will override any previous allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: there is no way to change the allocator used for temporary objects"]
    #[doc = " created during the various compile calls (@ref hs_compile(), @ref"]
    #[doc = " hs_compile_multi(), @ref hs_compile_ext_multi())."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_set_allocator(alloc_func: hs_alloc_t, free_func: hs_free_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Set the allocate and free functions used by Hyperscan for allocating memory"]
    #[doc = " for database bytecode produced by the compile calls (@ref hs_compile(), @ref"]
    #[doc = " hs_compile_multi(), @ref hs_compile_ext_multi()) and by database"]
    #[doc = " deserialization (@ref hs_deserialize_database())."]
    #[doc = ""]
    #[doc = " If no database allocation functions are set, or if NULL is used in place of"]
    #[doc = " both parameters, then memory allocation will default to standard methods"]
    #[doc = " (such as the system malloc() and free() calls)."]
    #[doc = ""]
    #[doc = " This call will override any previous database allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: the database allocator may also be set by calling @ref"]
    #[doc = " hs_set_allocator()."]
    #[doc = ""]
    #[doc = " Note: there is no way to change how temporary objects created during the"]
    #[doc = " various compile calls (@ref hs_compile(), @ref hs_compile_multi(), @ref"]
    #[doc = " hs_compile_ext_multi()) are allocated."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_set_database_allocator(alloc_func: hs_alloc_t, free_func: hs_free_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Set the allocate and free functions used by Hyperscan for allocating memory"]
    #[doc = " for items returned by the Hyperscan API such as @ref hs_compile_error_t, @ref"]
    #[doc = " hs_expr_info_t and serialized databases."]
    #[doc = ""]
    #[doc = " If no misc allocation functions are set, or if NULL is used in place of both"]
    #[doc = " parameters, then memory allocation will default to standard methods (such as"]
    #[doc = " the system malloc() and free() calls)."]
    #[doc = ""]
    #[doc = " This call will override any previous misc allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: the misc allocator may also be set by calling @ref hs_set_allocator()."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_set_misc_allocator(alloc_func: hs_alloc_t, free_func: hs_free_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Set the allocate and free functions used by Hyperscan for allocating memory"]
    #[doc = " for scratch space by @ref hs_alloc_scratch() and @ref hs_clone_scratch()."]
    #[doc = ""]
    #[doc = " If no scratch allocation functions are set, or if NULL is used in place of"]
    #[doc = " both parameters, then memory allocation will default to standard methods"]
    #[doc = " (such as the system malloc() and free() calls)."]
    #[doc = ""]
    #[doc = " This call will override any previous scratch allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: the scratch allocator may also be set by calling @ref"]
    #[doc = " hs_set_allocator()."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_set_scratch_allocator(alloc_func: hs_alloc_t, free_func: hs_free_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Set the allocate and free functions used by Hyperscan for allocating memory"]
    #[doc = " for stream state by @ref hs_open_stream()."]
    #[doc = ""]
    #[doc = " If no stream allocation functions are set, or if NULL is used in place of"]
    #[doc = " both parameters, then memory allocation will default to standard methods"]
    #[doc = " (such as the system malloc() and free() calls)."]
    #[doc = ""]
    #[doc = " This call will override any previous stream allocators that have been set."]
    #[doc = ""]
    #[doc = " Note: the stream allocator may also be set by calling @ref"]
    #[doc = " hs_set_allocator()."]
    #[doc = ""]
    #[doc = " @param alloc_func"]
    #[doc = "      A callback function pointer that allocates memory. This function must"]
    #[doc = "      return memory suitably aligned for the largest representable data type"]
    #[doc = "      on this platform."]
    #[doc = ""]
    #[doc = " @param free_func"]
    #[doc = "      A callback function pointer that frees allocated memory."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_set_stream_allocator(alloc_func: hs_alloc_t, free_func: hs_free_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Utility function for identifying this release version."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      A string containing the version number of this release build and the"]
    #[doc = "      date of the build. It is allocated statically, so it does not need to"]
    #[doc = "      be freed by the caller."]
    pub fn hs_version() -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Utility function to test the current system architecture."]
    #[doc = ""]
    #[doc = " Hyperscan requires the Supplemental Streaming SIMD Extensions 3 instruction"]
    #[doc = " set. This function can be called on any x86 platform to determine if the"]
    #[doc = " system provides the required instruction set."]
    #[doc = ""]
    #[doc = " This function does not test for more advanced features if Hyperscan has"]
    #[doc = " been built for a more specific architecture, for example the AVX2"]
    #[doc = " instruction set."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, @ref HS_ARCH_ERROR if system does not"]
    #[doc = "      support Hyperscan."]
    pub fn hs_valid_platform() -> hs_error_t;
}
#[doc = " A type containing error details that is returned by the compile calls (@ref"]
#[doc = " hs_compile(), @ref hs_compile_multi() and @ref hs_compile_ext_multi()) on"]
#[doc = " failure. The caller may inspect the values returned in this type to"]
#[doc = " determine the cause of failure."]
#[doc = ""]
#[doc = " Common errors generated during the compile process include:"]
#[doc = ""]
#[doc = "    - *Invalid parameter*"]
#[doc = ""]
#[doc = "      An invalid argument was specified in the compile call."]
#[doc = ""]
#[doc = "    - *Unrecognised flag*"]
#[doc = ""]
#[doc = "      An unrecognised value was passed in the flags argument."]
#[doc = ""]
#[doc = "    - *Pattern matches empty buffer*"]
#[doc = ""]
#[doc = "      By default, Hyperscan only supports patterns that will *always*"]
#[doc = "      consume at least one byte of input. Patterns that do not have this"]
#[doc = "      property (such as `/(abc)?/`) will produce this error unless"]
#[doc = "      the @ref HS_FLAG_ALLOWEMPTY flag is supplied. Note that such"]
#[doc = "      patterns will produce a match for *every* byte when scanned."]
#[doc = ""]
#[doc = "    - *Embedded anchors not supported*"]
#[doc = ""]
#[doc = "      Hyperscan only supports the use of anchor meta-characters (such as"]
#[doc = "      `^` and `$`) in patterns where they could *only* match"]
#[doc = "      at the start or end of a buffer. A pattern containing an embedded"]
#[doc = "      anchor, such as `/abc^def/`, can never match, as there is no"]
#[doc = "      way for `abc` to precede the start of the data stream."]
#[doc = ""]
#[doc = "    - *Bounded repeat is too large*"]
#[doc = ""]
#[doc = "      The pattern contains a repeated construct with very large finite"]
#[doc = "      bounds."]
#[doc = ""]
#[doc = "    - *Unsupported component type*"]
#[doc = ""]
#[doc = "      An unsupported PCRE construct was used in the pattern."]
#[doc = ""]
#[doc = "    - *Unable to generate bytecode*"]
#[doc = ""]
#[doc = "      This error indicates that Hyperscan was unable to compile a pattern"]
#[doc = "      that is syntactically valid. The most common cause is a pattern that is"]
#[doc = "      very long and complex or contains a large repeated subpattern."]
#[doc = ""]
#[doc = "    - *Unable to allocate memory*"]
#[doc = ""]
#[doc = "      The library was unable to allocate temporary storage used during"]
#[doc = "      compilation time."]
#[doc = ""]
#[doc = "    - *Allocator returned misaligned memory*"]
#[doc = ""]
#[doc = "      The memory allocator (either malloc() or the allocator set with @ref"]
#[doc = "      hs_set_allocator()) did not correctly return memory suitably aligned"]
#[doc = "      for the largest representable data type on this platform."]
#[doc = ""]
#[doc = "    - *Internal error*"]
#[doc = ""]
#[doc = "      An unexpected error occurred: if this error is reported, please contact"]
#[doc = "      the Hyperscan team with a description of the situation."]
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct hs_compile_error {
    #[doc = " A human-readable error message describing the error."]
    pub message: *mut ::libc::c_char,
    #[doc = " The zero-based number of the expression that caused the error (if this"]
    #[doc = " can be determined). If the error is not specific to an expression, then"]
    #[doc = " this value will be less than zero."]
    pub expression: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_hs_compile_error() {
    assert_eq!(
        ::core::mem::size_of::<hs_compile_error>(),
        16usize,
        concat!("Size of: ", stringify!(hs_compile_error))
    );
    assert_eq!(
        ::core::mem::align_of::<hs_compile_error>(),
        8usize,
        concat!("Alignment of ", stringify!(hs_compile_error))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_compile_error>())).message as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_compile_error),
            "::",
            stringify!(message)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_compile_error>())).expression as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_compile_error),
            "::",
            stringify!(expression)
        )
    );
}
impl Default for hs_compile_error {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = " A type containing error details that is returned by the compile calls (@ref"]
#[doc = " hs_compile(), @ref hs_compile_multi() and @ref hs_compile_ext_multi()) on"]
#[doc = " failure. The caller may inspect the values returned in this type to"]
#[doc = " determine the cause of failure."]
#[doc = ""]
#[doc = " Common errors generated during the compile process include:"]
#[doc = ""]
#[doc = "    - *Invalid parameter*"]
#[doc = ""]
#[doc = "      An invalid argument was specified in the compile call."]
#[doc = ""]
#[doc = "    - *Unrecognised flag*"]
#[doc = ""]
#[doc = "      An unrecognised value was passed in the flags argument."]
#[doc = ""]
#[doc = "    - *Pattern matches empty buffer*"]
#[doc = ""]
#[doc = "      By default, Hyperscan only supports patterns that will *always*"]
#[doc = "      consume at least one byte of input. Patterns that do not have this"]
#[doc = "      property (such as `/(abc)?/`) will produce this error unless"]
#[doc = "      the @ref HS_FLAG_ALLOWEMPTY flag is supplied. Note that such"]
#[doc = "      patterns will produce a match for *every* byte when scanned."]
#[doc = ""]
#[doc = "    - *Embedded anchors not supported*"]
#[doc = ""]
#[doc = "      Hyperscan only supports the use of anchor meta-characters (such as"]
#[doc = "      `^` and `$`) in patterns where they could *only* match"]
#[doc = "      at the start or end of a buffer. A pattern containing an embedded"]
#[doc = "      anchor, such as `/abc^def/`, can never match, as there is no"]
#[doc = "      way for `abc` to precede the start of the data stream."]
#[doc = ""]
#[doc = "    - *Bounded repeat is too large*"]
#[doc = ""]
#[doc = "      The pattern contains a repeated construct with very large finite"]
#[doc = "      bounds."]
#[doc = ""]
#[doc = "    - *Unsupported component type*"]
#[doc = ""]
#[doc = "      An unsupported PCRE construct was used in the pattern."]
#[doc = ""]
#[doc = "    - *Unable to generate bytecode*"]
#[doc = ""]
#[doc = "      This error indicates that Hyperscan was unable to compile a pattern"]
#[doc = "      that is syntactically valid. The most common cause is a pattern that is"]
#[doc = "      very long and complex or contains a large repeated subpattern."]
#[doc = ""]
#[doc = "    - *Unable to allocate memory*"]
#[doc = ""]
#[doc = "      The library was unable to allocate temporary storage used during"]
#[doc = "      compilation time."]
#[doc = ""]
#[doc = "    - *Allocator returned misaligned memory*"]
#[doc = ""]
#[doc = "      The memory allocator (either malloc() or the allocator set with @ref"]
#[doc = "      hs_set_allocator()) did not correctly return memory suitably aligned"]
#[doc = "      for the largest representable data type on this platform."]
#[doc = ""]
#[doc = "    - *Internal error*"]
#[doc = ""]
#[doc = "      An unexpected error occurred: if this error is reported, please contact"]
#[doc = "      the Hyperscan team with a description of the situation."]
pub type hs_compile_error_t = hs_compile_error;
#[doc = " A type containing information on the target platform which may optionally be"]
#[doc = " provided to the compile calls (@ref hs_compile(), @ref hs_compile_multi(),"]
#[doc = " @ref hs_compile_ext_multi())."]
#[doc = ""]
#[doc = " A hs_platform_info structure may be populated for the current platform by"]
#[doc = " using the @ref hs_populate_platform() call."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct hs_platform_info {
    #[doc = " Information about the target platform which may be used to guide the"]
    #[doc = " optimisation process of the compile."]
    #[doc = ""]
    #[doc = " Use of this field does not limit the processors that the resulting"]
    #[doc = " database can run on, but may impact the performance of the resulting"]
    #[doc = " database."]
    pub tune: ::libc::c_uint,
    #[doc = " Relevant CPU features available on the target platform"]
    #[doc = ""]
    #[doc = " This value may be produced by combining HS_CPU_FEATURE_* flags (such as"]
    #[doc = " @ref HS_CPU_FEATURES_AVX2). Multiple CPU features may be or'ed together"]
    #[doc = " to produce the value."]
    pub cpu_features: ::libc::c_ulonglong,
    #[doc = " Reserved for future use."]
    pub reserved1: ::libc::c_ulonglong,
    #[doc = " Reserved for future use."]
    pub reserved2: ::libc::c_ulonglong,
}
#[test]
fn bindgen_test_layout_hs_platform_info() {
    assert_eq!(
        ::core::mem::size_of::<hs_platform_info>(),
        32usize,
        concat!("Size of: ", stringify!(hs_platform_info))
    );
    assert_eq!(
        ::core::mem::align_of::<hs_platform_info>(),
        8usize,
        concat!("Alignment of ", stringify!(hs_platform_info))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).tune as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(tune)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).cpu_features as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(cpu_features)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).reserved1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_platform_info>())).reserved2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_platform_info),
            "::",
            stringify!(reserved2)
        )
    );
}
#[doc = " A type containing information on the target platform which may optionally be"]
#[doc = " provided to the compile calls (@ref hs_compile(), @ref hs_compile_multi(),"]
#[doc = " @ref hs_compile_ext_multi())."]
#[doc = ""]
#[doc = " A hs_platform_info structure may be populated for the current platform by"]
#[doc = " using the @ref hs_populate_platform() call."]
pub type hs_platform_info_t = hs_platform_info;
#[doc = " A type containing information related to an expression that is returned by"]
#[doc = " @ref hs_expression_info() or @ref hs_expression_ext_info."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct hs_expr_info {
    #[doc = " The minimum length in bytes of a match for the pattern."]
    #[doc = ""]
    #[doc = " Note: in some cases when using advanced features to suppress matches"]
    #[doc = " (such as extended parameters or the @ref HS_FLAG_SINGLEMATCH flag) this"]
    #[doc = " may represent a conservative lower bound for the true minimum length of"]
    #[doc = " a match."]
    pub min_width: ::libc::c_uint,
    #[doc = " The maximum length in bytes of a match for the pattern. If the pattern"]
    #[doc = " has an unbounded maximum length, this will be set to the maximum value"]
    #[doc = " of an unsigned int (UINT_MAX)."]
    #[doc = ""]
    #[doc = " Note: in some cases when using advanced features to suppress matches"]
    #[doc = " (such as extended parameters or the @ref HS_FLAG_SINGLEMATCH flag) this"]
    #[doc = " may represent a conservative upper bound for the true maximum length of"]
    #[doc = " a match."]
    pub max_width: ::libc::c_uint,
    #[doc = " Whether this expression can produce matches that are not returned in"]
    #[doc = " order, such as those produced by assertions. Zero if false, non-zero if"]
    #[doc = " true."]
    pub unordered_matches: ::libc::c_char,
    #[doc = " Whether this expression can produce matches at end of data (EOD). In"]
    #[doc = " streaming mode, EOD matches are raised during @ref hs_close_stream(),"]
    #[doc = " since it is only when @ref hs_close_stream() is called that the EOD"]
    #[doc = " location is known. Zero if false, non-zero if true."]
    #[doc = ""]
    #[doc = " Note: trailing `\\b` word boundary assertions may also result in EOD"]
    #[doc = " matches as end-of-data can act as a word boundary."]
    pub matches_at_eod: ::libc::c_char,
    #[doc = " Whether this expression can *only* produce matches at end of data (EOD)."]
    #[doc = " In streaming mode, all matches for this expression are raised during"]
    #[doc = " @ref hs_close_stream(). Zero if false, non-zero if true."]
    pub matches_only_at_eod: ::libc::c_char,
}
#[test]
fn bindgen_test_layout_hs_expr_info() {
    assert_eq!(
        ::core::mem::size_of::<hs_expr_info>(),
        12usize,
        concat!("Size of: ", stringify!(hs_expr_info))
    );
    assert_eq!(
        ::core::mem::align_of::<hs_expr_info>(),
        4usize,
        concat!("Alignment of ", stringify!(hs_expr_info))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_info>())).min_width as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_info),
            "::",
            stringify!(min_width)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_info>())).max_width as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_info),
            "::",
            stringify!(max_width)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_info>())).unordered_matches as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_info),
            "::",
            stringify!(unordered_matches)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_info>())).matches_at_eod as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_info),
            "::",
            stringify!(matches_at_eod)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_info>())).matches_only_at_eod as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_info),
            "::",
            stringify!(matches_only_at_eod)
        )
    );
}
#[doc = " A type containing information related to an expression that is returned by"]
#[doc = " @ref hs_expression_info() or @ref hs_expression_ext_info."]
pub type hs_expr_info_t = hs_expr_info;
#[doc = " A structure containing additional parameters related to an expression,"]
#[doc = " passed in at build time to @ref hs_compile_ext_multi() or @ref"]
#[doc = " hs_expression_ext_info."]
#[doc = ""]
#[doc = " These parameters allow the set of matches produced by a pattern to be"]
#[doc = " constrained at compile time, rather than relying on the application to"]
#[doc = " process unwanted matches at runtime."]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct hs_expr_ext {
    #[doc = " Flags governing which parts of this structure are to be used by the"]
    #[doc = " compiler. See @ref HS_EXT_FLAG."]
    pub flags: ::libc::c_ulonglong,
    #[doc = " The minimum end offset in the data stream at which this expression"]
    #[doc = " should match successfully. To use this parameter, set the"]
    #[doc = " @ref HS_EXT_FLAG_MIN_OFFSET flag in the hs_expr_ext::flags field."]
    pub min_offset: ::libc::c_ulonglong,
    #[doc = " The maximum end offset in the data stream at which this expression"]
    #[doc = " should match successfully. To use this parameter, set the"]
    #[doc = " @ref HS_EXT_FLAG_MAX_OFFSET flag in the hs_expr_ext::flags field."]
    pub max_offset: ::libc::c_ulonglong,
    #[doc = " The minimum match length (from start to end) required to successfully"]
    #[doc = " match this expression. To use this parameter, set the"]
    #[doc = " @ref HS_EXT_FLAG_MIN_LENGTH flag in the hs_expr_ext::flags field."]
    pub min_length: ::libc::c_ulonglong,
    #[doc = " Allow patterns to approximately match within this edit distance. To use"]
    #[doc = " this parameter, set the @ref HS_EXT_FLAG_EDIT_DISTANCE flag in the"]
    #[doc = " hs_expr_ext::flags field."]
    pub edit_distance: ::libc::c_uint,
    #[doc = " Allow patterns to approximately match within this Hamming distance. To"]
    #[doc = " use this parameter, set the @ref HS_EXT_FLAG_HAMMING_DISTANCE flag in the"]
    #[doc = " hs_expr_ext::flags field."]
    pub hamming_distance: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_hs_expr_ext() {
    assert_eq!(
        ::core::mem::size_of::<hs_expr_ext>(),
        40usize,
        concat!("Size of: ", stringify!(hs_expr_ext))
    );
    assert_eq!(
        ::core::mem::align_of::<hs_expr_ext>(),
        8usize,
        concat!("Alignment of ", stringify!(hs_expr_ext))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_ext>())).flags as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(hs_expr_ext), "::", stringify!(flags))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_ext>())).min_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_ext),
            "::",
            stringify!(min_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_ext>())).max_offset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_ext),
            "::",
            stringify!(max_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_ext>())).min_length as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_ext),
            "::",
            stringify!(min_length)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_ext>())).edit_distance as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_ext),
            "::",
            stringify!(edit_distance)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<hs_expr_ext>())).hamming_distance as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(hs_expr_ext),
            "::",
            stringify!(hamming_distance)
        )
    );
}
#[doc = " A structure containing additional parameters related to an expression,"]
#[doc = " passed in at build time to @ref hs_compile_ext_multi() or @ref"]
#[doc = " hs_expression_ext_info."]
#[doc = ""]
#[doc = " These parameters allow the set of matches produced by a pattern to be"]
#[doc = " constrained at compile time, rather than relying on the application to"]
#[doc = " process unwanted matches at runtime."]
pub type hs_expr_ext_t = hs_expr_ext;
extern "C" {
    #[doc = " The basic regular expression compiler."]
    #[doc = ""]
    #[doc = " This is the function call with which an expression is compiled into a"]
    #[doc = " Hyperscan database which can be passed to the runtime functions (such as"]
    #[doc = " @ref hs_scan(), @ref hs_open_stream(), etc.)"]
    #[doc = ""]
    #[doc = " @param expression"]
    #[doc = "      The NULL-terminated expression to parse. Note that this string must"]
    #[doc = "      represent ONLY the pattern to be matched, with no delimiters or flags;"]
    #[doc = "      any global flags should be specified with the @p flags argument. For"]
    #[doc = "      example, the expression `/abc?def/i` should be compiled by providing"]
    #[doc = "      `abc?def` as the @p expression, and @ref HS_FLAG_CASELESS as the @a"]
    #[doc = "      flags."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags which modify the behaviour of the expression. Multiple flags may"]
    #[doc = "      be used by ORing them together. Valid values are:"]
    #[doc = "       - HS_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - HS_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - HS_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - HS_FLAG_SINGLEMATCH - Only one match will be generated for the"]
    #[doc = "                               expression per stream."]
    #[doc = "       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an"]
    #[doc = "                              empty string, such as `.*`."]
    #[doc = "       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - HS_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = "       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode."]
    #[doc = "       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset"]
    #[doc = "                                when a match is found."]
    #[doc = "       - HS_FLAG_COMBINATION - Parse the expression in logical combination"]
    #[doc = "                               syntax."]
    #[doc = "       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for"]
    #[doc = "                         the sub-expressions in logical combinations."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flags that affect the database as a whole. One of @ref"]
    #[doc = "      HS_MODE_STREAM or @ref HS_MODE_BLOCK or @ref HS_MODE_VECTORED must be"]
    #[doc = "      supplied, to select between the generation of a streaming, block or"]
    #[doc = "      vectored database. In addition, other flags (beginning with HS_MODE_)"]
    #[doc = "      may be supplied to enable specific features. See @ref HS_MODE_FLAG for"]
    #[doc = "      more details."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref hs_free_database() function."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      If the compile fails, a pointer to a @ref hs_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      hs_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      HS_COMPILER_ERROR on failure, with details provided in the error"]
    #[doc = "      parameter."]
    pub fn hs_compile(
        expression: *const ::libc::c_char,
        flags: ::libc::c_uint,
        mode: ::libc::c_uint,
        platform: *const hs_platform_info_t,
        db: *mut *mut hs_database_t,
        error: *mut *mut hs_compile_error_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " The multiple regular expression compiler."]
    #[doc = ""]
    #[doc = " This is the function call with which a set of expressions is compiled into a"]
    #[doc = " database which can be passed to the runtime functions (such as @ref"]
    #[doc = " hs_scan(), @ref hs_open_stream(), etc.) Each expression can be labelled with"]
    #[doc = " a unique integer which is passed into the match callback to identify the"]
    #[doc = " pattern that has matched."]
    #[doc = ""]
    #[doc = " @param expressions"]
    #[doc = "      Array of NULL-terminated expressions to compile. Note that (as for @ref"]
    #[doc = "      hs_compile()) these strings must contain only the pattern to be"]
    #[doc = "      matched, with no delimiters or flags. For example, the expression"]
    #[doc = "      `/abc?def/i` should be compiled by providing `abc?def` as the first"]
    #[doc = "      string in the @p expressions array, and @ref HS_FLAG_CASELESS as the"]
    #[doc = "      first value in the @p flags array."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Array of flags which modify the behaviour of each expression. Multiple"]
    #[doc = "      flags may be used by ORing them together.  Specifying the NULL pointer"]
    #[doc = "      in place of an array will set the flags value for all patterns to zero."]
    #[doc = "      Valid values are:"]
    #[doc = "       - HS_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - HS_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - HS_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - HS_FLAG_SINGLEMATCH - Only one match will be generated by patterns"]
    #[doc = "                               with this match id per stream."]
    #[doc = "       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an"]
    #[doc = "                              empty string, such as `.*`."]
    #[doc = "       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - HS_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = "       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode."]
    #[doc = "       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset"]
    #[doc = "                                when a match is found."]
    #[doc = "       - HS_FLAG_COMBINATION - Parse the expression in logical combination"]
    #[doc = "                               syntax."]
    #[doc = "       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for"]
    #[doc = "                         the sub-expressions in logical combinations."]
    #[doc = ""]
    #[doc = " @param ids"]
    #[doc = "      An array of integers specifying the ID number to be associated with the"]
    #[doc = "      corresponding pattern in the expressions array. Specifying the NULL"]
    #[doc = "      pointer in place of an array will set the ID value for all patterns to"]
    #[doc = "      zero."]
    #[doc = ""]
    #[doc = " @param elements"]
    #[doc = "      The number of elements in the input arrays."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flags that affect the database as a whole. One of @ref"]
    #[doc = "      HS_MODE_STREAM or @ref HS_MODE_BLOCK or @ref HS_MODE_VECTORED must be"]
    #[doc = "      supplied, to select between the generation of a streaming, block or"]
    #[doc = "      vectored database. In addition, other flags (beginning with HS_MODE_)"]
    #[doc = "      may be supplied to enable specific features. See @ref HS_MODE_FLAG for"]
    #[doc = "      more details."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref hs_free_database() function."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      If the compile fails, a pointer to a @ref hs_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      hs_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      HS_COMPILER_ERROR on failure, with details provided in the @p error"]
    #[doc = "      parameter."]
    #[doc = ""]
    pub fn hs_compile_multi(
        expressions: *const *const ::libc::c_char,
        flags: *const ::libc::c_uint,
        ids: *const ::libc::c_uint,
        elements: ::libc::c_uint,
        mode: ::libc::c_uint,
        platform: *const hs_platform_info_t,
        db: *mut *mut hs_database_t,
        error: *mut *mut hs_compile_error_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " The multiple regular expression compiler with extended parameter support."]
    #[doc = ""]
    #[doc = " This function call compiles a group of expressions into a database in the"]
    #[doc = " same way as @ref hs_compile_multi(), but allows additional parameters to be"]
    #[doc = " specified via an @ref hs_expr_ext_t structure per expression."]
    #[doc = ""]
    #[doc = " @param expressions"]
    #[doc = "      Array of NULL-terminated expressions to compile. Note that (as for @ref"]
    #[doc = "      hs_compile()) these strings must contain only the pattern to be"]
    #[doc = "      matched, with no delimiters or flags. For example, the expression"]
    #[doc = "      `/abc?def/i` should be compiled by providing `abc?def` as the first"]
    #[doc = "      string in the @p expressions array, and @ref HS_FLAG_CASELESS as the"]
    #[doc = "      first value in the @p flags array."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Array of flags which modify the behaviour of each expression. Multiple"]
    #[doc = "      flags may be used by ORing them together. Specifying the NULL pointer"]
    #[doc = "      in place of an array will set the flags value for all patterns to zero."]
    #[doc = "      Valid values are:"]
    #[doc = "       - HS_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - HS_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - HS_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - HS_FLAG_SINGLEMATCH - Only one match will be generated by patterns"]
    #[doc = "                               with this match id per stream."]
    #[doc = "       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an"]
    #[doc = "                              empty string, such as `.*`."]
    #[doc = "       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - HS_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = "       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode."]
    #[doc = "       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset"]
    #[doc = "                                when a match is found."]
    #[doc = "       - HS_FLAG_COMBINATION - Parse the expression in logical combination"]
    #[doc = "                               syntax."]
    #[doc = "       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for"]
    #[doc = "                         the sub-expressions in logical combinations."]
    #[doc = ""]
    #[doc = " @param ids"]
    #[doc = "      An array of integers specifying the ID number to be associated with the"]
    #[doc = "      corresponding pattern in the expressions array. Specifying the NULL"]
    #[doc = "      pointer in place of an array will set the ID value for all patterns to"]
    #[doc = "      zero."]
    #[doc = ""]
    #[doc = " @param ext"]
    #[doc = "      An array of pointers to filled @ref hs_expr_ext_t structures that"]
    #[doc = "      define extended behaviour for each pattern. NULL may be specified if no"]
    #[doc = "      extended behaviour is needed for an individual pattern, or in place of"]
    #[doc = "      the whole array if it is not needed for any expressions. Memory used by"]
    #[doc = "      these structures must be both allocated and freed by the caller."]
    #[doc = ""]
    #[doc = " @param elements"]
    #[doc = "      The number of elements in the input arrays."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flags that affect the database as a whole. One of @ref"]
    #[doc = "      HS_MODE_STREAM, @ref HS_MODE_BLOCK or @ref HS_MODE_VECTORED must be"]
    #[doc = "      supplied, to select between the generation of a streaming, block or"]
    #[doc = "      vectored database. In addition, other flags (beginning with HS_MODE_)"]
    #[doc = "      may be supplied to enable specific features. See @ref HS_MODE_FLAG for"]
    #[doc = "      more details."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref hs_free_database() function."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      If the compile fails, a pointer to a @ref hs_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      hs_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      HS_COMPILER_ERROR on failure, with details provided in the @p error"]
    #[doc = "      parameter."]
    #[doc = ""]
    pub fn hs_compile_ext_multi(
        expressions: *const *const ::libc::c_char,
        flags: *const ::libc::c_uint,
        ids: *const ::libc::c_uint,
        ext: *const *const hs_expr_ext_t,
        elements: ::libc::c_uint,
        mode: ::libc::c_uint,
        platform: *const hs_platform_info_t,
        db: *mut *mut hs_database_t,
        error: *mut *mut hs_compile_error_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " The basic pure literal expression compiler."]
    #[doc = ""]
    #[doc = " This is the function call with which a pure literal expression (not a"]
    #[doc = " common regular expression) is compiled into a Hyperscan database which"]
    #[doc = " can be passed to the runtime functions (such as @ref hs_scan(),"]
    #[doc = " @ref hs_open_stream(), etc.)"]
    #[doc = ""]
    #[doc = " @param expression"]
    #[doc = "      The NULL-terminated expression to parse. Note that this string must"]
    #[doc = "      represent ONLY the pattern to be matched, with no delimiters or flags;"]
    #[doc = "      any global flags should be specified with the @p flags argument. For"]
    #[doc = "      example, the expression `/abc?def/i` should be compiled by providing"]
    #[doc = "      `abc?def` as the @p expression, and @ref HS_FLAG_CASELESS as the @a"]
    #[doc = "      flags. Meanwhile, the string content shall be fully parsed in a literal"]
    #[doc = "      sense without any regular grammars. For example, the @p expression"]
    #[doc = "      `abc?` simply means a char sequence of `a`, `b`, `c`, and `?`. The `?`"]
    #[doc = "      here doesn't mean 0 or 1 quantifier under regular semantics."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags which modify the behaviour of the expression. Multiple flags may"]
    #[doc = "      be used by ORing them together. Compared to @ref hs_compile(), fewer"]
    #[doc = "      valid values are provided:"]
    #[doc = "       - HS_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - HS_FLAG_SINGLEMATCH - Only one match will be generated for the"]
    #[doc = "                               expression per stream."]
    #[doc = "       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset"]
    #[doc = "                                when a match is found."]
    #[doc = ""]
    #[doc = " @param len"]
    #[doc = "      The length of the text content of the pure literal expression. As the"]
    #[doc = "      text content indicated by @p expression is treated as single character"]
    #[doc = "      one by one, the special terminating character `\\0` should be allowed"]
    #[doc = "      to appear in expression, and not treated as a terminator for a string."]
    #[doc = "      Thus, the end of a pure literal expression cannot be indicated by"]
    #[doc = "      identifying `\\0`, but by counting to the expression length."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flags that affect the database as a whole. One of @ref"]
    #[doc = "      HS_MODE_STREAM or @ref HS_MODE_BLOCK or @ref HS_MODE_VECTORED must be"]
    #[doc = "      supplied, to select between the generation of a streaming, block or"]
    #[doc = "      vectored database. In addition, other flags (beginning with HS_MODE_)"]
    #[doc = "      may be supplied to enable specific features. See @ref HS_MODE_FLAG for"]
    #[doc = "      more details."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref hs_free_database() function."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      If the compile fails, a pointer to a @ref hs_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      hs_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      HS_COMPILER_ERROR on failure, with details provided in the error"]
    #[doc = "      parameter."]
    pub fn hs_compile_lit(
        expression: *const ::libc::c_char,
        flags: ::libc::c_uint,
        len: usize,
        mode: ::libc::c_uint,
        platform: *const hs_platform_info_t,
        db: *mut *mut hs_database_t,
        error: *mut *mut hs_compile_error_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " The multiple pure literal expression compiler."]
    #[doc = ""]
    #[doc = " This is the function call with which a set of pure literal expressions is"]
    #[doc = " compiled into a database which can be passed to the runtime functions (such"]
    #[doc = " as @ref hs_scan(), @ref hs_open_stream(), etc.) Each expression can be"]
    #[doc = " labelled with a unique integer which is passed into the match callback to"]
    #[doc = " identify the pattern that has matched."]
    #[doc = ""]
    #[doc = " @param expressions"]
    #[doc = "      The NULL-terminated expression to parse. Note that this string must"]
    #[doc = "      represent ONLY the pattern to be matched, with no delimiters or flags;"]
    #[doc = "      any global flags should be specified with the @p flags argument. For"]
    #[doc = "      example, the expression `/abc?def/i` should be compiled by providing"]
    #[doc = "      `abc?def` as the @p expression, and @ref HS_FLAG_CASELESS as the @a"]
    #[doc = "      flags. Meanwhile, the string content shall be fully parsed in a literal"]
    #[doc = "      sense without any regular grammars. For example, the @p expression"]
    #[doc = "      `abc?` simply means a char sequence of `a`, `b`, `c`, and `?`. The `?`"]
    #[doc = "      here doesn't mean 0 or 1 quantifier under regular semantics."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Array of flags which modify the behaviour of each expression. Multiple"]
    #[doc = "      flags may be used by ORing them together. Specifying the NULL pointer"]
    #[doc = "      in place of an array will set the flags value for all patterns to zero."]
    #[doc = "      Compared to @ref hs_compile_multi(), fewer valid values are provided:"]
    #[doc = "       - HS_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - HS_FLAG_SINGLEMATCH - Only one match will be generated for the"]
    #[doc = "                               expression per stream."]
    #[doc = "       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset"]
    #[doc = "                                when a match is found."]
    #[doc = ""]
    #[doc = " @param ids"]
    #[doc = "      An array of integers specifying the ID number to be associated with the"]
    #[doc = "      corresponding pattern in the expressions array. Specifying the NULL"]
    #[doc = "      pointer in place of an array will set the ID value for all patterns to"]
    #[doc = "      zero."]
    #[doc = ""]
    #[doc = " @param lens"]
    #[doc = "      Array of lengths of the text content of each pure literal expression."]
    #[doc = "      As the text content indicated by @p expression is treated as single"]
    #[doc = "      character one by one, the special terminating character `\\0` should be"]
    #[doc = "      allowed to appear in expression, and not treated as a terminator for a"]
    #[doc = "      string. Thus, the end of a pure literal expression cannot be indicated"]
    #[doc = "      by identifying `\\0`, but by counting to the expression length."]
    #[doc = ""]
    #[doc = " @param elements"]
    #[doc = "      The number of elements in the input arrays."]
    #[doc = ""]
    #[doc = " @param mode"]
    #[doc = "      Compiler mode flags that affect the database as a whole. One of @ref"]
    #[doc = "      HS_MODE_STREAM or @ref HS_MODE_BLOCK or @ref HS_MODE_VECTORED must be"]
    #[doc = "      supplied, to select between the generation of a streaming, block or"]
    #[doc = "      vectored database. In addition, other flags (beginning with HS_MODE_)"]
    #[doc = "      may be supplied to enable specific features. See @ref HS_MODE_FLAG for"]
    #[doc = "      more details."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      If not NULL, the platform structure is used to determine the target"]
    #[doc = "      platform for the database. If NULL, a database suitable for running"]
    #[doc = "      on the current host platform is produced."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      On success, a pointer to the generated database will be returned in"]
    #[doc = "      this parameter, or NULL on failure. The caller is responsible for"]
    #[doc = "      deallocating the buffer using the @ref hs_free_database() function."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      If the compile fails, a pointer to a @ref hs_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      hs_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      HS_COMPILER_ERROR on failure, with details provided in the error"]
    #[doc = "      parameter."]
    pub fn hs_compile_lit_multi(
        expressions: *const *const ::libc::c_char,
        flags: *const ::libc::c_uint,
        ids: *const ::libc::c_uint,
        lens: *const usize,
        elements: ::libc::c_uint,
        mode: ::libc::c_uint,
        platform: *const hs_platform_info_t,
        db: *mut *mut hs_database_t,
        error: *mut *mut hs_compile_error_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Free an error structure generated by @ref hs_compile(), @ref"]
    #[doc = " hs_compile_multi() or @ref hs_compile_ext_multi()."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      The @ref hs_compile_error_t to be freed. NULL may also be safely"]
    #[doc = "      provided."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_free_compile_error(error: *mut hs_compile_error_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Utility function providing information about a regular expression. The"]
    #[doc = " information provided in @ref hs_expr_info_t includes the minimum and maximum"]
    #[doc = " width of a pattern match."]
    #[doc = ""]
    #[doc = " Note: successful analysis of an expression with this function does not imply"]
    #[doc = " that compilation of the same expression (via @ref hs_compile(), @ref"]
    #[doc = " hs_compile_multi() or @ref hs_compile_ext_multi()) would succeed. This"]
    #[doc = " function may return @ref HS_SUCCESS for regular expressions that Hyperscan"]
    #[doc = " cannot compile."]
    #[doc = ""]
    #[doc = " Note: some per-pattern flags (such as @ref HS_FLAG_ALLOWEMPTY, @ref"]
    #[doc = " HS_FLAG_SOM_LEFTMOST) are accepted by this call, but as they do not affect"]
    #[doc = " the properties returned in the @ref hs_expr_info_t structure, they will not"]
    #[doc = " affect the outcome of this function."]
    #[doc = ""]
    #[doc = " @param expression"]
    #[doc = "      The NULL-terminated expression to parse. Note that this string must"]
    #[doc = "      represent ONLY the pattern to be matched, with no delimiters or flags;"]
    #[doc = "      any global flags should be specified with the @p flags argument.  For"]
    #[doc = "      example, the expression `/abc?def/i` should be compiled by providing"]
    #[doc = "      `abc?def` as the @p expression, and @ref HS_FLAG_CASELESS as the @a"]
    #[doc = "      flags."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags which modify the behaviour of the expression. Multiple flags may"]
    #[doc = "      be used by ORing them together. Valid values are:"]
    #[doc = "       - HS_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - HS_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - HS_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - HS_FLAG_SINGLEMATCH - Only one match will be generated by the"]
    #[doc = "                               expression per stream."]
    #[doc = "       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an"]
    #[doc = "                              empty string, such as `.*`."]
    #[doc = "       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - HS_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = "       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode."]
    #[doc = "       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset"]
    #[doc = "                                when a match is found."]
    #[doc = "       - HS_FLAG_COMBINATION - Parse the expression in logical combination"]
    #[doc = "                               syntax."]
    #[doc = "       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for"]
    #[doc = "                         the sub-expressions in logical combinations."]
    #[doc = ""]
    #[doc = " @param info"]
    #[doc = "      On success, a pointer to the pattern information will be returned in"]
    #[doc = "      this parameter, or NULL on failure. This structure is allocated using"]
    #[doc = "      the allocator supplied in @ref hs_set_allocator() (or malloc() if no"]
    #[doc = "      allocator was set) and should be freed by the caller."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      If the call fails, a pointer to a @ref hs_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      hs_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      HS_COMPILER_ERROR on failure, with details provided in the error"]
    #[doc = "      parameter."]
    pub fn hs_expression_info(
        expression: *const ::libc::c_char,
        flags: ::libc::c_uint,
        info: *mut *mut hs_expr_info_t,
        error: *mut *mut hs_compile_error_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Utility function providing information about a regular expression, with"]
    #[doc = " extended parameter support. The information provided in @ref hs_expr_info_t"]
    #[doc = " includes the minimum and maximum width of a pattern match."]
    #[doc = ""]
    #[doc = " Note: successful analysis of an expression with this function does not imply"]
    #[doc = " that compilation of the same expression (via @ref hs_compile(), @ref"]
    #[doc = " hs_compile_multi() or @ref hs_compile_ext_multi()) would succeed. This"]
    #[doc = " function may return @ref HS_SUCCESS for regular expressions that Hyperscan"]
    #[doc = " cannot compile."]
    #[doc = ""]
    #[doc = " Note: some per-pattern flags (such as @ref HS_FLAG_ALLOWEMPTY, @ref"]
    #[doc = " HS_FLAG_SOM_LEFTMOST) are accepted by this call, but as they do not affect"]
    #[doc = " the properties returned in the @ref hs_expr_info_t structure, they will not"]
    #[doc = " affect the outcome of this function."]
    #[doc = ""]
    #[doc = " @param expression"]
    #[doc = "      The NULL-terminated expression to parse. Note that this string must"]
    #[doc = "      represent ONLY the pattern to be matched, with no delimiters or flags;"]
    #[doc = "      any global flags should be specified with the @p flags argument.  For"]
    #[doc = "      example, the expression `/abc?def/i` should be compiled by providing"]
    #[doc = "      `abc?def` as the @p expression, and @ref HS_FLAG_CASELESS as the @a"]
    #[doc = "      flags."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags which modify the behaviour of the expression. Multiple flags may"]
    #[doc = "      be used by ORing them together. Valid values are:"]
    #[doc = "       - HS_FLAG_CASELESS - Matching will be performed case-insensitively."]
    #[doc = "       - HS_FLAG_DOTALL - Matching a `.` will not exclude newlines."]
    #[doc = "       - HS_FLAG_MULTILINE - `^` and `$` anchors match any newlines in data."]
    #[doc = "       - HS_FLAG_SINGLEMATCH - Only one match will be generated by the"]
    #[doc = "                               expression per stream."]
    #[doc = "       - HS_FLAG_ALLOWEMPTY - Allow expressions which can match against an"]
    #[doc = "                              empty string, such as `.*`."]
    #[doc = "       - HS_FLAG_UTF8 - Treat this pattern as a sequence of UTF-8 characters."]
    #[doc = "       - HS_FLAG_UCP - Use Unicode properties for character classes."]
    #[doc = "       - HS_FLAG_PREFILTER - Compile pattern in prefiltering mode."]
    #[doc = "       - HS_FLAG_SOM_LEFTMOST - Report the leftmost start of match offset"]
    #[doc = "                                when a match is found."]
    #[doc = "       - HS_FLAG_COMBINATION - Parse the expression in logical combination"]
    #[doc = "                               syntax."]
    #[doc = "       - HS_FLAG_QUIET - Ignore match reporting for this expression. Used for"]
    #[doc = "                         the sub-expressions in logical combinations."]
    #[doc = ""]
    #[doc = " @param ext"]
    #[doc = "      A pointer to a filled @ref hs_expr_ext_t structure that defines"]
    #[doc = "      extended behaviour for this pattern. NULL may be specified if no"]
    #[doc = "      extended parameters are needed."]
    #[doc = ""]
    #[doc = " @param info"]
    #[doc = "      On success, a pointer to the pattern information will be returned in"]
    #[doc = "      this parameter, or NULL on failure. This structure is allocated using"]
    #[doc = "      the allocator supplied in @ref hs_set_allocator() (or malloc() if no"]
    #[doc = "      allocator was set) and should be freed by the caller."]
    #[doc = ""]
    #[doc = " @param error"]
    #[doc = "      If the call fails, a pointer to a @ref hs_compile_error_t will be"]
    #[doc = "      returned, providing details of the error condition. The caller is"]
    #[doc = "      responsible for deallocating the buffer using the @ref"]
    #[doc = "      hs_free_compile_error() function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS is returned on successful compilation; @ref"]
    #[doc = "      HS_COMPILER_ERROR on failure, with details provided in the error"]
    #[doc = "      parameter."]
    pub fn hs_expression_ext_info(
        expression: *const ::libc::c_char,
        flags: ::libc::c_uint,
        ext: *const hs_expr_ext_t,
        info: *mut *mut hs_expr_info_t,
        error: *mut *mut hs_compile_error_t,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Populates the platform information based on the current host."]
    #[doc = ""]
    #[doc = " @param platform"]
    #[doc = "      On success, the pointed to structure is populated based on the current"]
    #[doc = "      host."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_populate_platform(platform: *mut hs_platform_info_t) -> hs_error_t;
}
#[doc = " Definition of the stream identifier type."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hs_stream {
    _unused: [u8; 0],
}
#[doc = " The stream identifier returned by @ref hs_open_stream()."]
pub type hs_stream_t = hs_stream;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hs_scratch {
    _unused: [u8; 0],
}
#[doc = " A Hyperscan scratch space."]
pub type hs_scratch_t = hs_scratch;
#[doc = " Definition of the match event callback function type."]
#[doc = ""]
#[doc = " A callback function matching the defined type must be provided by the"]
#[doc = " application calling the @ref hs_scan(), @ref hs_scan_vector() or @ref"]
#[doc = " hs_scan_stream() functions (or other streaming calls which can produce"]
#[doc = " matches)."]
#[doc = ""]
#[doc = " This callback function will be invoked whenever a match is located in the"]
#[doc = " target data during the execution of a scan. The details of the match are"]
#[doc = " passed in as parameters to the callback function, and the callback function"]
#[doc = " should return a value indicating whether or not matching should continue on"]
#[doc = " the target data. If no callbacks are desired from a scan call, NULL may be"]
#[doc = " provided in order to suppress match production."]
#[doc = ""]
#[doc = " This callback function should not attempt to call Hyperscan API functions on"]
#[doc = " the same stream nor should it attempt to reuse the scratch space allocated"]
#[doc = " for the API calls that caused it to be triggered. Making another call to the"]
#[doc = " Hyperscan library with completely independent parameters should work (for"]
#[doc = " example, scanning a different database in a new stream and with new scratch"]
#[doc = " space), but reusing data structures like stream state and/or scratch space"]
#[doc = " will produce undefined behavior."]
#[doc = ""]
#[doc = " @param id"]
#[doc = "      The ID number of the expression that matched. If the expression was a"]
#[doc = "      single expression compiled with @ref hs_compile(), this value will be"]
#[doc = "      zero."]
#[doc = ""]
#[doc = " @param from"]
#[doc = "      - If a start of match flag is enabled for the current pattern, this"]
#[doc = "        argument will be set to the start of match for the pattern assuming"]
#[doc = "        that that start of match value lies within the current 'start of match"]
#[doc = "        horizon' chosen by one of the SOM_HORIZON mode flags."]
#[doc = ""]
#[doc = "      - If the start of match value lies outside this horizon (possible only"]
#[doc = "        when the SOM_HORIZON value is not @ref HS_MODE_SOM_HORIZON_LARGE),"]
#[doc = "        the @p from value will be set to @ref HS_OFFSET_PAST_HORIZON."]
#[doc = ""]
#[doc = "      - This argument will be set to zero if the Start of Match flag is not"]
#[doc = "        enabled for the given pattern."]
#[doc = ""]
#[doc = " @param to"]
#[doc = "      The offset after the last byte that matches the expression."]
#[doc = ""]
#[doc = " @param flags"]
#[doc = "      This is provided for future use and is unused at present."]
#[doc = ""]
#[doc = " @param context"]
#[doc = "      The pointer supplied by the user to the @ref hs_scan(), @ref"]
#[doc = "      hs_scan_vector() or @ref hs_scan_stream() function."]
#[doc = ""]
#[doc = " @return"]
#[doc = "      Non-zero if the matching should cease, else zero. If scanning is"]
#[doc = "      performed in streaming mode and a non-zero value is returned, any"]
#[doc = "      subsequent calls to @ref hs_scan_stream() for that stream will"]
#[doc = "      immediately return with @ref HS_SCAN_TERMINATED."]
pub type match_event_handler = ::core::option::Option<
    unsafe extern "C" fn(
        id: ::libc::c_uint,
        from: ::libc::c_ulonglong,
        to: ::libc::c_ulonglong,
        flags: ::libc::c_uint,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Open and initialise a stream."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      A compiled pattern database."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags modifying the behaviour of the stream. This parameter is provided"]
    #[doc = "      for future use and is unused at present."]
    #[doc = ""]
    #[doc = " @param stream"]
    #[doc = "      On success, a pointer to the generated @ref hs_stream_t will be"]
    #[doc = "      returned; NULL on failure."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_open_stream(db: *const hs_database_t, flags: ::libc::c_uint, stream: *mut *mut hs_stream_t)
        -> hs_error_t;
}
extern "C" {
    #[doc = " Write data to be scanned to the opened stream."]
    #[doc = ""]
    #[doc = " This is the function call in which the actual pattern matching takes place"]
    #[doc = " as data is written to the stream. Matches will be returned via the @ref"]
    #[doc = " match_event_handler callback supplied."]
    #[doc = ""]
    #[doc = " @param id"]
    #[doc = "      The stream ID (returned by @ref hs_open_stream()) to which the data"]
    #[doc = "      will be written."]
    #[doc = ""]
    #[doc = " @param data"]
    #[doc = "      Pointer to the data to be scanned."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      The number of bytes to scan."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags modifying the behaviour of the stream. This parameter is provided"]
    #[doc = "      for future use and is unused at present."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch()."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param ctxt"]
    #[doc = "      The user defined pointer which will be passed to the callback function"]
    #[doc = "      when a match occurs."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      Returns @ref HS_SUCCESS on success; @ref HS_SCAN_TERMINATED if the"]
    #[doc = "      match callback indicated that scanning should stop; other values on"]
    #[doc = "      error."]
    pub fn hs_scan_stream(
        id: *mut hs_stream_t,
        data: *const ::libc::c_char,
        length: ::libc::c_uint,
        flags: ::libc::c_uint,
        scratch: *mut hs_scratch_t,
        onEvent: match_event_handler,
        ctxt: *mut ::libc::c_void,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Close a stream."]
    #[doc = ""]
    #[doc = " This function completes matching on the given stream and frees the memory"]
    #[doc = " associated with the stream state. After this call, the stream pointed to by"]
    #[doc = " @p id is invalid and can no longer be used. To reuse the stream state after"]
    #[doc = " completion, rather than closing it, the @ref hs_reset_stream function can be"]
    #[doc = " used."]
    #[doc = ""]
    #[doc = " This function must be called for any stream created with @ref"]
    #[doc = " hs_open_stream(), even if scanning has been terminated by a non-zero return"]
    #[doc = " from the match callback function."]
    #[doc = ""]
    #[doc = " Note: This operation may result in matches being returned (via calls to the"]
    #[doc = " match event callback) for expressions anchored to the end of the data stream"]
    #[doc = " (for example, via the use of the `$` meta-character). If these matches are"]
    #[doc = " not desired, NULL may be provided as the @ref match_event_handler callback."]
    #[doc = ""]
    #[doc = " If NULL is provided as the @ref match_event_handler callback, it is"]
    #[doc = " permissible to provide a NULL scratch."]
    #[doc = ""]
    #[doc = " @param id"]
    #[doc = "      The stream ID returned by @ref hs_open_stream()."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch(). This is"]
    #[doc = "      allowed to be NULL only if the @p onEvent callback is also NULL."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param ctxt"]
    #[doc = "      The user defined pointer which will be passed to the callback function"]
    #[doc = "      when a match occurs."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      Returns @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_close_stream(
        id: *mut hs_stream_t,
        scratch: *mut hs_scratch_t,
        onEvent: match_event_handler,
        ctxt: *mut ::libc::c_void,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Reset a stream to an initial state."]
    #[doc = ""]
    #[doc = " Conceptually, this is equivalent to performing @ref hs_close_stream() on the"]
    #[doc = " given stream, followed by a @ref hs_open_stream(). This new stream replaces"]
    #[doc = " the original stream in memory, avoiding the overhead of freeing the old"]
    #[doc = " stream and allocating the new one."]
    #[doc = ""]
    #[doc = " Note: This operation may result in matches being returned (via calls to the"]
    #[doc = " match event callback) for expressions anchored to the end of the original"]
    #[doc = " data stream (for example, via the use of the `$` meta-character). If these"]
    #[doc = " matches are not desired, NULL may be provided as the @ref match_event_handler"]
    #[doc = " callback."]
    #[doc = ""]
    #[doc = " Note: the stream will also be tied to the same database."]
    #[doc = ""]
    #[doc = " @param id"]
    #[doc = "      The stream (as created by @ref hs_open_stream()) to be replaced."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags modifying the behaviour of the stream. This parameter is provided"]
    #[doc = "      for future use and is unused at present."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch(). This is"]
    #[doc = "      allowed to be NULL only if the @p onEvent callback is also NULL."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param context"]
    #[doc = "      The user defined pointer which will be passed to the callback function"]
    #[doc = "      when a match occurs."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_reset_stream(
        id: *mut hs_stream_t,
        flags: ::libc::c_uint,
        scratch: *mut hs_scratch_t,
        onEvent: match_event_handler,
        context: *mut ::libc::c_void,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Duplicate the given stream. The new stream will have the same state as the"]
    #[doc = " original including the current stream offset."]
    #[doc = ""]
    #[doc = " @param to_id"]
    #[doc = "      On success, a pointer to the new, copied @ref hs_stream_t will be"]
    #[doc = "      returned; NULL on failure."]
    #[doc = ""]
    #[doc = " @param from_id"]
    #[doc = "      The stream (as created by @ref hs_open_stream()) to be copied."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_copy_stream(to_id: *mut *mut hs_stream_t, from_id: *const hs_stream_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Duplicate the given 'from' stream state onto the 'to' stream. The 'to' stream"]
    #[doc = " will first be reset (reporting any EOD matches if a non-NULL @p onEvent"]
    #[doc = " callback handler is provided)."]
    #[doc = ""]
    #[doc = " Note: the 'to' stream and the 'from' stream must be open against the same"]
    #[doc = " database."]
    #[doc = ""]
    #[doc = " @param to_id"]
    #[doc = "      On success, a pointer to the new, copied @ref hs_stream_t will be"]
    #[doc = "      returned; NULL on failure."]
    #[doc = ""]
    #[doc = " @param from_id"]
    #[doc = "      The stream (as created by @ref hs_open_stream()) to be copied."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch(). This is"]
    #[doc = "      allowed to be NULL only if the @p onEvent callback is also NULL."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param context"]
    #[doc = "      The user defined pointer which will be passed to the callback function"]
    #[doc = "      when a match occurs."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_reset_and_copy_stream(
        to_id: *mut hs_stream_t,
        from_id: *const hs_stream_t,
        scratch: *mut hs_scratch_t,
        onEvent: match_event_handler,
        context: *mut ::libc::c_void,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Creates a compressed representation of the provided stream in the buffer"]
    #[doc = " provided. This compressed representation can be converted back into a stream"]
    #[doc = " state by using @ref hs_expand_stream() or @ref hs_reset_and_expand_stream()."]
    #[doc = " The size of the compressed representation will be placed into @p used_space."]
    #[doc = ""]
    #[doc = " If there is not sufficient space in the buffer to hold the compressed"]
    #[doc = " representation, @ref HS_INSUFFICIENT_SPACE will be returned and @p used_space"]
    #[doc = " will be populated with the amount of space required."]
    #[doc = ""]
    #[doc = " Note: this function does not close the provided stream, you may continue to"]
    #[doc = " use the stream or to free it with @ref hs_close_stream()."]
    #[doc = ""]
    #[doc = " @param stream"]
    #[doc = "      The stream (as created by @ref hs_open_stream()) to be compressed."]
    #[doc = ""]
    #[doc = " @param buf"]
    #[doc = "      Buffer to write the compressed representation into. Note: if the call is"]
    #[doc = "      just being used to determine the amount of space required, it is allowed"]
    #[doc = "      to pass NULL here and @p buf_space as 0."]
    #[doc = ""]
    #[doc = " @param buf_space"]
    #[doc = "      The number of bytes in @p buf. If buf_space is too small, the call will"]
    #[doc = "      fail with @ref HS_INSUFFICIENT_SPACE."]
    #[doc = ""]
    #[doc = " @param used_space"]
    #[doc = "      Pointer to where the amount of used space will be written to. The used"]
    #[doc = "      buffer space is always less than or equal to @p buf_space. If the call"]
    #[doc = "      fails with @ref HS_INSUFFICIENT_SPACE, this pointer will be used to"]
    #[doc = "      write out the amount of buffer space required."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, @ref HS_INSUFFICIENT_SPACE if the provided"]
    #[doc = "      buffer is too small."]
    pub fn hs_compress_stream(
        stream: *const hs_stream_t,
        buf: *mut ::libc::c_char,
        buf_space: usize,
        used_space: *mut usize,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Decompresses a compressed representation created by @ref hs_compress_stream()"]
    #[doc = " into a new stream."]
    #[doc = ""]
    #[doc = " Note: @p buf must correspond to a complete compressed representation created"]
    #[doc = " by @ref hs_compress_stream() of a stream that was opened against @p db. It is"]
    #[doc = " not always possible to detect misuse of this API and behaviour is undefined"]
    #[doc = " if these properties are not satisfied."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      The compiled pattern database that the compressed stream was opened"]
    #[doc = "      against."]
    #[doc = ""]
    #[doc = " @param stream"]
    #[doc = "      On success, a pointer to the expanded @ref hs_stream_t will be"]
    #[doc = "      returned; NULL on failure."]
    #[doc = ""]
    #[doc = " @param buf"]
    #[doc = "      A compressed representation of a stream. These compressed forms are"]
    #[doc = "      created by @ref hs_compress_stream()."]
    #[doc = ""]
    #[doc = " @param buf_size"]
    #[doc = "      The size in bytes of the compressed representation."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_expand_stream(
        db: *const hs_database_t,
        stream: *mut *mut hs_stream_t,
        buf: *const ::libc::c_char,
        buf_size: usize,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Decompresses a compressed representation created by @ref hs_compress_stream()"]
    #[doc = " on top of the 'to' stream. The 'to' stream will first be reset (reporting"]
    #[doc = " any EOD matches if a non-NULL @p onEvent callback handler is provided)."]
    #[doc = ""]
    #[doc = " Note: the 'to' stream must be opened against the same database as the"]
    #[doc = " compressed stream."]
    #[doc = ""]
    #[doc = " Note: @p buf must correspond to a complete compressed representation created"]
    #[doc = " by @ref hs_compress_stream() of a stream that was opened against @p db. It is"]
    #[doc = " not always possible to detect misuse of this API and behaviour is undefined"]
    #[doc = " if these properties are not satisfied."]
    #[doc = ""]
    #[doc = " @param to_stream"]
    #[doc = "      A pointer to a valid stream state. A pointer to the expanded @ref"]
    #[doc = "      hs_stream_t will be returned; NULL on failure."]
    #[doc = ""]
    #[doc = " @param buf"]
    #[doc = "      A compressed representation of a stream. These compressed forms are"]
    #[doc = "      created by @ref hs_compress_stream()."]
    #[doc = ""]
    #[doc = " @param buf_size"]
    #[doc = "      The size in bytes of the compressed representation."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch(). This is"]
    #[doc = "      allowed to be NULL only if the @p onEvent callback is also NULL."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param context"]
    #[doc = "      The user defined pointer which will be passed to the callback function"]
    #[doc = "      when a match occurs."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_reset_and_expand_stream(
        to_stream: *mut hs_stream_t,
        buf: *const ::libc::c_char,
        buf_size: usize,
        scratch: *mut hs_scratch_t,
        onEvent: match_event_handler,
        context: *mut ::libc::c_void,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " The block (non-streaming) regular expression scanner."]
    #[doc = ""]
    #[doc = " This is the function call in which the actual pattern matching takes place"]
    #[doc = " for block-mode pattern databases."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      A compiled pattern database."]
    #[doc = ""]
    #[doc = " @param data"]
    #[doc = "      Pointer to the data to be scanned."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      The number of bytes to scan."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags modifying the behaviour of this function. This parameter is"]
    #[doc = "      provided for future use and is unused at present."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch() for this"]
    #[doc = "      database."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param context"]
    #[doc = "      The user defined pointer which will be passed to the callback function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      Returns @ref HS_SUCCESS on success; @ref HS_SCAN_TERMINATED if the"]
    #[doc = "      match callback indicated that scanning should stop; other values on"]
    #[doc = "      error."]
    pub fn hs_scan(
        db: *const hs_database_t,
        data: *const ::libc::c_char,
        length: ::libc::c_uint,
        flags: ::libc::c_uint,
        scratch: *mut hs_scratch_t,
        onEvent: match_event_handler,
        context: *mut ::libc::c_void,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " The vectored regular expression scanner."]
    #[doc = ""]
    #[doc = " This is the function call in which the actual pattern matching takes place"]
    #[doc = " for vectoring-mode pattern databases."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      A compiled pattern database."]
    #[doc = ""]
    #[doc = " @param data"]
    #[doc = "      An array of pointers to the data blocks to be scanned."]
    #[doc = ""]
    #[doc = " @param length"]
    #[doc = "      An array of lengths (in bytes) of each data block to scan."]
    #[doc = ""]
    #[doc = " @param count"]
    #[doc = "      Number of data blocks to scan. This should correspond to the size of"]
    #[doc = "      of the @p data and @p length arrays."]
    #[doc = ""]
    #[doc = " @param flags"]
    #[doc = "      Flags modifying the behaviour of this function. This parameter is"]
    #[doc = "      provided for future use and is unused at present."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch() for"]
    #[doc = "      this database."]
    #[doc = ""]
    #[doc = " @param onEvent"]
    #[doc = "      Pointer to a match event callback function. If a NULL pointer is given,"]
    #[doc = "      no matches will be returned."]
    #[doc = ""]
    #[doc = " @param context"]
    #[doc = "      The user defined pointer which will be passed to the callback function."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      Returns @ref HS_SUCCESS on success; @ref HS_SCAN_TERMINATED if the match"]
    #[doc = "      callback indicated that scanning should stop; other values on error."]
    pub fn hs_scan_vector(
        db: *const hs_database_t,
        data: *const *const ::libc::c_char,
        length: *const ::libc::c_uint,
        count: ::libc::c_uint,
        flags: ::libc::c_uint,
        scratch: *mut hs_scratch_t,
        onEvent: match_event_handler,
        context: *mut ::libc::c_void,
    ) -> hs_error_t;
}
extern "C" {
    #[doc = " Allocate a \"scratch\" space for use by Hyperscan."]
    #[doc = ""]
    #[doc = " This is required for runtime use, and one scratch space per thread, or"]
    #[doc = " concurrent caller, is required. Any allocator callback set by @ref"]
    #[doc = " hs_set_scratch_allocator() or @ref hs_set_allocator() will be used by this"]
    #[doc = " function."]
    #[doc = ""]
    #[doc = " @param db"]
    #[doc = "      The database, as produced by @ref hs_compile()."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      On first allocation, a pointer to NULL should be provided so a new"]
    #[doc = "      scratch can be allocated. If a scratch block has been previously"]
    #[doc = "      allocated, then a pointer to it should be passed back in to see if it"]
    #[doc = "      is valid for this database block. If a new scratch block is required,"]
    #[doc = "      the original will be freed and the new one returned, otherwise the"]
    #[doc = "      previous scratch block will be returned. On success, the scratch block"]
    #[doc = "      will be suitable for use with the provided database in addition to any"]
    #[doc = "      databases that original scratch space was suitable for."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on successful allocation; @ref HS_NOMEM if the"]
    #[doc = "      allocation fails.  Other errors may be returned if invalid parameters"]
    #[doc = "      are specified."]
    pub fn hs_alloc_scratch(db: *const hs_database_t, scratch: *mut *mut hs_scratch_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Allocate a scratch space that is a clone of an existing scratch space."]
    #[doc = ""]
    #[doc = " This is useful when multiple concurrent threads will be using the same set"]
    #[doc = " of compiled databases, and another scratch space is required. Any allocator"]
    #[doc = " callback set by @ref hs_set_scratch_allocator() or @ref hs_set_allocator()"]
    #[doc = " will be used by this function."]
    #[doc = ""]
    #[doc = " @param src"]
    #[doc = "      The existing @ref hs_scratch_t to be cloned."]
    #[doc = ""]
    #[doc = " @param dest"]
    #[doc = "      A pointer to the new scratch space will be returned here."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success; @ref HS_NOMEM if the allocation fails."]
    #[doc = "      Other errors may be returned if invalid parameters are specified."]
    pub fn hs_clone_scratch(src: *const hs_scratch_t, dest: *mut *mut hs_scratch_t) -> hs_error_t;
}
extern "C" {
    #[doc = " Provides the size of the given scratch space."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      A per-thread scratch space allocated by @ref hs_alloc_scratch() or @ref"]
    #[doc = "      hs_clone_scratch()."]
    #[doc = ""]
    #[doc = " @param scratch_size"]
    #[doc = "      On success, the size of the scratch space in bytes is placed in this"]
    #[doc = "      parameter."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_scratch_size(scratch: *const hs_scratch_t, scratch_size: *mut usize) -> hs_error_t;
}
extern "C" {
    #[doc = " Free a scratch block previously allocated by @ref hs_alloc_scratch() or @ref"]
    #[doc = " hs_clone_scratch()."]
    #[doc = ""]
    #[doc = " The free callback set by @ref hs_set_scratch_allocator() or @ref"]
    #[doc = " hs_set_allocator() will be used by this function."]
    #[doc = ""]
    #[doc = " @param scratch"]
    #[doc = "      The scratch block to be freed. NULL may also be safely provided."]
    #[doc = ""]
    #[doc = " @return"]
    #[doc = "      @ref HS_SUCCESS on success, other values on failure."]
    pub fn hs_free_scratch(scratch: *mut hs_scratch_t) -> hs_error_t;
}
