use std::{collections::HashMap, fmt::Debug};

/// Bi-directional hashmap used to store the mapping between the internal
/// unstable indexes - generated by IndexMap and IndexSet - and the exposed
/// stable indexes.
pub(crate) struct BiHashMap<Index>
where
    Index: Copy + Debug + Eq,
{
    pub(crate) left: HashMap<usize, Index>,
    pub(crate) right: HashMap<Index, usize>,
}

impl<Index> BiHashMap<Index>
where
    Index: Copy + Debug + Eq,
{
    /// Creates a new BiHashMap with no allocation.
    pub(crate) fn new() -> BiHashMap<Index> {
        Self {
            left: HashMap::<usize, Index>::with_capacity(0),
            right: HashMap::<Index, usize>::with_capacity(0),
        }
    }
}

impl<Index> Default for BiHashMap<Index>
where
    Index: Copy + Debug + Eq,
{
    fn default() -> Self {
        BiHashMap::new()
    }
}
