// Copyright (c) 2021 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

use hvif::Hvif;
use std::fs::File;
use std::io::{BufReader, Read};
use std::path::PathBuf;

fn do_render(hvif: Hvif, width: i32, height: i32) -> Result<cairo::ImageSurface, cairo::Error> {
    let mut surface = cairo::ImageSurface::create(cairo::Format::ARgb32, width, height)?;
    hvif::render(hvif, &mut surface)?;
    Ok(surface)
}

fn main() {
    let args: Vec<_> = std::env::args().collect();
    if args.len() != 4 {
        eprintln!("Usage: {} <file.avif> <size> <output.png>", args[0]);
        return;
    }
    let filename = PathBuf::from(args[1].clone());
    let size = args[2].parse().unwrap();
    let output = PathBuf::from(args[3].clone());
    let data = {
        let file = File::open(filename).unwrap();
        let mut file = BufReader::new(file);
        let mut data = Vec::new();
        file.read_to_end(&mut data).unwrap();
        data
    };
    let hvif = Hvif::parse(&data).unwrap();
    assert!(hvif.0.is_empty());
    let surface = do_render(hvif.1, size, size).unwrap();
    let mut file = File::create(output).unwrap();
    surface.write_to_png(&mut file).unwrap();
}
